/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "functionlistviewitem.h"
#include "functionitempopup.h"
#include "../../utils/stringutils.h"
#include "../../utils/debugger.h"
#include "../common/constants.h"
#include <iostream.h>

	FunctionListViewItem::FunctionListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBFunction(), DBMasterManagerRef()
	{
	} // end constructor

	FunctionListViewItem::FunctionListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBFunction(), DBMasterManagerRef()
	{
	} // end constructor

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void FunctionListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		string strMethodName = "FunctionListViewItem::showRightPressedMenu";
		Debugger::entered(strMethodName);
		
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new FunctionItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);
		
		Debugger::exited(strMethodName);
	} // end showRightPressedMenu		
		
	/**
 	 * Used to update the description.
   */			    	
	void FunctionListViewItem::updateDescription()
	{
 		// format string to appear on description
 		string strOutputDesc = "<h1>Function</h1><hr><p><strong>Name</strong><br>"
 														+ StringUtils::htmlstr(getFunctionName()) +
 														"</p><p><strong>Comment</strong><br>";
 		if (getFunctionComment().size() == 0)
 		{
 			strOutputDesc += StringUtils::htmlstr(Constants::NO_COMMENT);
 		} // end if no comment															
 		else
 		{
 			strOutputDesc	+= StringUtils::htmlstr(getFunctionComment());
 		} // end else comment exists
		
 		strOutputDesc +=			"</p><p><strong>Return Type</strong><br>";
 		// lets get the return type
 		if (getReturnType().size() == 0)
 		{
 			strOutputDesc += StringUtils::htmlstr(Constants::NONE);
 		} // end if no return type
 		else
 		{
 			strOutputDesc += StringUtils::htmlstr(getReturnType()); 		
 		} // end else return type exists

 		strOutputDesc +=			"</p><p><strong>Argument List</strong><br>";
 		// lets get the return type
 		if (getNumberOfArgumentTypes() == 0)
 		{
 			strOutputDesc += StringUtils::htmlstr(Constants::NONE);
 		} // end if no argument types
 		else
 		{
 			for (int nArgTypeIdx = 0; nArgTypeIdx < getNumberOfArgumentTypes(); nArgTypeIdx++)
 			{
 				if (nArgTypeIdx == 0)
 				{
 					strOutputDesc += StringUtils::htmlstr(getArgumentType(nArgTypeIdx));
 				} // end if first
 				else
 				{
 					strOutputDesc += ", " + StringUtils::htmlstr(getArgumentType(nArgTypeIdx)); 				
 				} // end else not first 				 		
 			} // end for more arg types
 		} // end else argument types exists
 		
 		strOutputDesc +=				"</p><p><strong>Language</strong><br>"
 														+ StringUtils::htmlstr(getLanguage()); 			
 		strOutputDesc +=				"</p><p><strong>Owner</strong><br>"
 														+ StringUtils::htmlstr(getFunctionOwner()) + "</p>";
 		m_qstrDescription = strOutputDesc.c_str();
	
	} // end updateDescription
			
	