/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "sequenceitempopup.h"
#include "sequencelistviewitem.h"
#include "../common/commentform.h"
#include "../../utils/debugger.h"

	/**
	 * Constructor
	 */
	SequenceItemPopup::SequenceItemPopup(QWidget *pqoParent, SequenceListViewItem *poSequenceListViewItem)
		: QPopupMenu(pqoParent)
	{
		m_poSequenceListViewItem = poSequenceListViewItem;	// keep a reference to the sequence item
		
		insertItem("View/Edit Comment", this, SLOT(editComment()));				

	} // end constructor

	/**
	 * Used to get a reference to the sequence item that this popup was generated from.
	 */
	SequenceListViewItem * SequenceItemPopup::getSequenceListViewItem() const
	{
		return m_poSequenceListViewItem;
	} // end getSequenceListViewItem
	
	/**
	 * This slot is called by the popup menu itself when edit comment is selected.
	 */
	void SequenceItemPopup::editComment()
	{
		// bring up edit comment form
		CommentForm *poCommentForm = new CommentForm(this, *((m_poSequenceListViewItem->getDBMasterManager())->getDBConnection()),
																				CommentForm::SequenceComment);
		poCommentForm->setObjectName(m_poSequenceListViewItem->getSequenceName());		
		poCommentForm->setComment(m_poSequenceListViewItem->getSequenceComment().c_str());
		poCommentForm->show();				
	} // end editComment

