/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef COMBOBOXTABLEITEM_H
#define COMBOBOXTABLEITEM_H

#include <qtable.h>
#include <qstringlist.h>

/**
 * This table item is used for combo boxes.
 */
class ComboBoxTableItem: public QTableItem
{
	
protected:
	QStringList m_qoStringList;	
	bool m_bManualEdit;
	
public:
	/**
	 * Constructor
	 */
	ComboBoxTableItem(QTable * pqtblParent, EditType nEditType, const QString & rqstrText);

	/**
	 * Sets the selection list for the combo box.
	 */
	void setStringList(QStringList rqoStringList);

	/**
	 * Sets the if manual editing is allowed.
	 */
	void setManualEdit(bool bManualEdit);
		
	/**
	 * Overrided implementation from QTableItem
	 */
	QWidget * createEditor() const;
	
	/**
	 * Overrided implementation from QTableItem
	 */
	void setContentFromEditor(QWidget * pqoWidget);
};


#endif

