/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DROPTABLEFORM_H
#define DROPTABLEFORM_H

#include "uic_droptableform.h"
#include "../../dataaccess/dbconnection.h"
#include "../../dataaccess/tables/dbtablemanager.h"

/**
 * This prompts the user to confirm the dropping of the table.
 */
class DropTableForm: public UicDropTableForm
{
	Q_OBJECT
			
protected:	
	DBConnection m_oDBConn;
	DBTableManager m_oDBTableMgr;
	string m_strTableName;
				
public:
	
	/**
 	 * Constructor
   */		
  DropTableForm(QWidget* pqoParent, const DBConnection & roDBConn, const string & rstrTableName);

  /**
   * Destructor
   */
  ~DropTableForm();

public slots:
	/**
	 * This method is used to drop a table.
	 */
	void dropTableSchema();
	
	/**
	 * This method is used to close the table.
	 */
	void closeForm();
	
	 	
};


#endif


