/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef VIEWLISTVIEWITEM_H
#define VIEWLISTVIEWITEM_H

#include "../baselistviewitem.h"
#include "../../dataaccess/views/dbview.h"
#include "../../dataaccess/dbmastermanagerref.h"

/**
 * This list view item is used to represent a database view.
 */
class ViewListViewItem: public BaseListViewItem, public DBView, public DBMasterManagerRef
{
				
public:
	
	/**
 	 * Constructor
   */		
	ViewListViewItem(QListViewItem *pqoListViewItem);
	ViewListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem);	

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	virtual void showRightPressedMenu(const QPoint & rqoLocation, int nColumn);
	
	/**
 	 * Used to update the description.
   */			    	
	virtual void updateDescription();
		
		
protected:

};


#endif

