/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbfunction.h"
	
	/**
 	 * Constructor
   */		
	DBFunction::DBFunction()
	{
		clear();
	} // end constructor
	
	/**
 	 * Destructor
   */		
	DBFunction::~DBFunction()
	{
	} // end destructor
	
	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void DBFunction::clear()
	{
		m_strFunctionName = "";
		m_strFunctionComment = "";
		m_strFunctionOwner = "";
		m_strLanguage = "";	
		m_strReturnType = "";
		m_vstrArgumentTypes.clear();		
	} // end clear
	
	/**
 	 * Used to set the Function name.
   */			    	
	void DBFunction::setFunctionName(const string &rstrFunctionName)
	{
		m_strFunctionName = rstrFunctionName;
	} // end setFunctionName

	/**
 	 * Used to retrieve the Function name.
   */			    			
	const string & DBFunction::getFunctionName() const
	{
		return m_strFunctionName;
	} // end getFunctionName

	/**
 	 * Used to set the Function comment.
   */			    						
	void DBFunction::setFunctionComment(const string &rstrFunctionComment)
	{
		m_strFunctionComment = rstrFunctionComment;
	} // end setFunctionComment

	/**
 	 * Used to retrieve the Function comment.
   */			    			
	const string & DBFunction::getFunctionComment() const
	{
		return m_strFunctionComment;
	} // end getFunctionComment			

	/**
 	 * Used to set the Function owner.
   */			    						
	void DBFunction::setFunctionOwner(const string &rstrFunctionOwner)
	{
		m_strFunctionOwner = rstrFunctionOwner;
	} // end setFunctionOwner

	/**
 	 * Used to retrieve the Function owner.
   */			    			
	const string & DBFunction::getFunctionOwner() const
	{
		return m_strFunctionOwner;
	} // end getFunctionOwner			

	/**
 	 * Used to set the return type.
   */			    						
	void DBFunction::setReturnType(const string &rstrReturnType)
	{
		m_strReturnType = rstrReturnType;
	} // end setReturnType

	/**
 	 * Used to retrieve the return type.
   */			    			
	const string & DBFunction::getReturnType() const
	{
		return m_strReturnType;
	} // end getReturnType			

	/**
 	 * Used to set the language.
   */			    						
	void DBFunction::setLanguage(const string &rstrLanguage)
	{
		m_strLanguage = rstrLanguage;
	} // end setLanguage

	/**
 	 * Used to retrieve the language.
   */			    			
	const string & DBFunction::getLanguage() const
	{
		return m_strLanguage;
	} // end getLanguage			

	/**
 	 * Used to add an argument type to the list.
   */			    			
	void DBFunction::addArgumentType(const string & rstrArgumentType)
	{
		m_vstrArgumentTypes.push_back(rstrArgumentType);
	} // addArgumentType
	
	/**
 	 * Used to retrieve an argument type.
   */			    			
	const string & DBFunction::getArgumentType(int nColumnIndex) const throw (IndexOutOfRangeException)
	{
		if (nColumnIndex < 0 || nColumnIndex >= getNumberOfArgumentTypes())
		{
			throw IndexOutOfRangeException("Index out of range.", "DBFunction", "getArgumentType");							
		} // end if index is invalid
		return m_vstrArgumentTypes[nColumnIndex];
	} // end getArgumentType
	
	/**
	 * Used to get the number arguments for this function.
	 */
	int DBFunction::getNumberOfArgumentTypes() const
	{
		return m_vstrArgumentTypes.size();
	} // end getNumberOfArgumentTypes

	/**
 	 * Used to get all the argument types in a vector.
   */			    			
	const vector<string> & DBFunction::getArgumentTypes() const
	{
		return m_vstrArgumentTypes;
	} // end getArgumentTypes
		