/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbtype.h"
#include "../../utils/debugger.h"
	
	/**
 	 * Constructor
   */		
	DBType::DBType()
	{
		clear();
	} // end constructor

	/**
 	 * Copy Constructor
 	 * Implemented for STL.
   */		
	DBType::DBType(const DBType & roDBType)
	{
		//string strMethodName = "DBtype::Copy constructor";
		//Debugger::entered(strMethodName);
		(*this) = roDBType;
		//Debugger::exited(strMethodName);		
	} // end copy constructor

	/**
 	 * Assignment operator
 	 * Implemented for STL.
   */		
	DBType & DBType::operator=(const DBType & roDBType)
	{
		//string strMethodName = "DBtype::operator=";
		//Debugger::entered(strMethodName);	
		m_lTypeOid = roDBType.m_lTypeOid;		
		m_strTypeName = roDBType.m_strTypeName;
		//Debugger::exited(strMethodName);
		return (*this);
	} // end operator=
		
	/**
 	 * Destructor
   */		
	DBType::~DBType()
	{
	} // end destructor
	
	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void DBType::clear()
	{
		m_lTypeOid = 0;
		m_strTypeName = "";
	} // end clear
	
	/**
 	 * Used to set the type name.
   */			    	
	void DBType::setTypeName(const string &rstrTypeName)
	{
		m_strTypeName = rstrTypeName;
	} // end setTypeName

	/**
 	 * Used to retrieve the type name.
   */			    			
	const string & DBType::getTypeName() const
	{
		return m_strTypeName;
	} // end getTypeName

	/**
 	 * Used to set the type oid.
   */			    	
	void DBType::setTypeOid(long lTypeOid)
	{
		m_lTypeOid = lTypeOid;
	} // end setTypeName

	/**
 	 * Used to retrieve the type oid.
   */			    			
	long DBType::getTypeOid() const
	{
		return m_lTypeOid;
	} // end getTypeOid
