/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "infodialogs.h"
#include <qmessagebox.h>

  /**
   * This method is used to display an error message when a SQL exception occurs.
   */
  void InfoDialogs::infoSQLException(QWidget * pqoParent, const SQLException & roSQLException)
  {
  	string strErrorMsg = "The sql query \"" + roSQLException.getSQL() + "\"\n"
  											 "returned the exception: " + roSQLException.getExceptionDescription();
		QMessageBox::information(pqoParent, "SQL Error", strErrorMsg.c_str());  											
  } // end infoSQLExceptions

  /**
   * This method is used to display an error message when a database connection exception occurs.
   */
  void InfoDialogs::infoDBConnectionException(QWidget * pqoParent, const DBConnectionException & roDBConnectionException)
  {
  	string strErrorMsg = "Failed to make a database connection: " + roDBConnectionException.getExceptionDescription();
		QMessageBox::information(pqoParent, "Database Connection Error", strErrorMsg.c_str());  											  	
  } // end infoDBConnectionException
