/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef TABLEGROUPITEMPOPUP_H
#define TABLEGROUPITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "tablegrouplistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a table group item in the list viewer.
 */
class TableGroupItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	TableGroupListViewItem * m_poTableGroupItem;	
	
public:
	/**
	 * Constructor
	 */
	TableGroupItemPopup(QWidget *pqoParent, TableGroupListViewItem *poTableGroupItem);

	/**
	 * Used to access the table group list view item.
	 */
	TableGroupListViewItem * getTableGroupListViewItem() const;
	
protected slots:	
	/**
 	 * This slot is called by the popup menu itself when a new table is to be created.
   */	
	void createDBTable();

	/**
 	 * This slot is called by the popup menu itself when it needs to refresh the table list.
   */	
	void refreshListOfTables();
		
};


#endif

