/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef TABLELISTVIEWITEM_H
#define TABLELISTVIEWITEM_H

#include "../baselistviewitem.h"
#include "../../dataaccess/tables/dbtable.h"
#include "../../dataaccess/dbmastermanagerref.h"

/**
 * This list view item is used to represent a database table.
 */
class TableListViewItem: public BaseListViewItem, public DBTable, public DBMasterManagerRef
{
				
public:
	
	/**
 	 * Constructor
   */		
	TableListViewItem(QListViewItem *pqoListViewItem);
	TableListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem);	

	/**
 	 * Used to update the description.
   */			    	
	virtual void updateDescription();
		
	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	virtual void showRightPressedMenu(const QPoint & rqoLocation, int nColumn);

	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	virtual void initChildren();
		
protected:

};


#endif

