/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef TRIGGERGROUPITEMPOPUP_H
#define TRIGGERGROUPITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "triggergrouplistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a Trigger group item in the list viewer.
 */
class TriggerGroupItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	TriggerGroupListViewItem * m_poTriggerGroupItem;	
	
public:
	/**
	 * Constructor
	 */
	TriggerGroupItemPopup(QWidget *pqoParent, TriggerGroupListViewItem *poTriggerGroupItem);

	/**
	 * Used to access the Trigger group list view item.
	 */
	TriggerGroupListViewItem * getTriggerGroupListViewItem() const;
	
protected slots:	
	/**
 	 * This slot is called by the popup menu itself when it needs to refresh the Trigger list.
   */	
	void refreshListOfTriggers();
		
};


#endif

