//
//  PgASyncThread.m
//  PostgresSQL
//
//  Created by Pascal on Fri Dec 20 2002.
//  Copyright (c) 2002 P3 Consulting. All rights reserved.
//

#import <sys/types.h>
#import <sys/time.h>
#import <unistd.h>
#import "PgASyncThread.h"
#import "PostgreSQL.h"
#import "PostgreSQLPrivate.h"

static	NSMutableDictionary	*connsServiced = nil	;

@implementation PgASyncThread


+ (void)initServicesArray	{
		if (connsServiced == nil)
			connsServiced = [[NSMutableDictionary dictionaryWithCapacity:10] retain]	;
}

+ (NSConnection *)startASyncThreadForConnection:(PostgreSQL *)inConn
{
	NSConnection *serverConnection	;
		
		[self initServicesArray]	;
		serverConnection = [connsServiced objectForKey:[inConn uniqueID]] 	;

		if (serverConnection == nil)	{
			NSPort *port1 = [NSPort port];
			NSPort *port2 = [NSPort port];
				
				NSArray *portArray = [NSArray arrayWithObjects:port2, port1, inConn, nil];
				serverConnection = [[NSConnection alloc] initWithReceivePort:port1 sendPort:port2];
				[serverConnection setRootObject:inConn];
				[NSThread detachNewThreadSelector:@selector(_connectWithPorts:) toTarget:self withObject:portArray];
				
				[connsServiced setObject:serverConnection forKey:[inConn uniqueID]]	;
		}
		return serverConnection;
}

+ (void)_connectWithPorts:(NSArray *)portArray
{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	id 	rootProxy	;
	PgASyncThread *serverObject	;
	NSConnection	*serverConnection	;
	PostgreSQL *pgConn = [portArray objectAtIndex:2]	;
		
		serverConnection = [NSConnection connectionWithReceivePort:[portArray objectAtIndex:0] sendPort:[portArray objectAtIndex:1]];


    	rootProxy = (id)[serverConnection rootProxy];
    	
		serverObject = [[self alloc] initForConnection:pgConn];	

		[rootProxy _setAsyncThread:serverObject];
		[serverObject release];
		/* In case you're curious to see what's in here...
		{
			NSMutableDictionary *threadDictionary = [[NSThread currentThread] threadDictionary];
			NSLog(@"Thread dictionary:\n%@\n", [threadDictionary description]);
		}
		*/
		[[NSRunLoop currentRunLoop] run];
		[pool release];
}

- (id)initForConnection:(PostgreSQL *)theConnection
{
    self = [super init];
    if (!self) 
		return nil;

    connection = theConnection	;

    return self;
}

-(void)executeAsyncCommand:(NSString *)cmdBuffer
{
	int	ok	;
	PGconn	*pgconn	;
			
		pgconn = [connection getPGconn]	;
		ok = PQsendQuery(pgconn,[cmdBuffer cString])	;
		if (ok == 1)
			ok = (0 == PQflush(pgconn))	;

		if (ok)	{
			fd_set	fdset	;
			struct timeval timeout	;
			struct timeval	*pTimeout = &timeout	;
			
				timeout.tv_sec = [connection getTimeOut]	;
				timeout.tv_usec = 0	;
				
				if (timeout.tv_sec == -1)
					pTimeout = NULL	;
					
				FD_ZERO(&fdset)	;
				FD_SET(PQsocket(pgconn),&fdset)	;
				
				if (select(PQsocket(pgconn)+1,&fdset,NULL,NULL,pTimeout) > 0)	{
					if (PQconsumeInput(pgconn))	{
						
						while (PQisBusy(pgconn))	{
							sleep(1)	;
						}
						
						[connection _resultAvailable]	;
					}
				}
				else
					[connection _timeOut]	;
		}
}

@end
