//
//  TestDelegate.m
//  PostgresSQL
//
//  Created by Pascal on Mon Dec 16 2002.
//  Copyright (c) 2002 P3 Consulting. All rights reserved.
//

#import "TestDelegate.h"
#import "PostgreSQL.h"

extern	NSString *PostgreSQLNotification	;

@implementation TestDelegate

-(id)init
{
		self = [super init]	;
		notified = NO	;
							
		return self		;
}

-(void)pgSQLNotify:(NSNotification *)notification
{
		[[notification userInfo] writeToFile:[[NSString stringWithCString:"~/notification.plist"] stringByExpandingTildeInPath] atomically:NO]	;
		NSLog(@"Notification %@ by %@",[[notification userInfo] objectForKey:@"condition"],[[notification userInfo] objectForKey:@"pid"])	;
		notified = YES	;
}

-(BOOL)notificationReceived
{
		return notified	;
}

-(void)dealloc
{
		[[NSNotificationCenter defaultCenter]  removeObserver:self]	;
		[super dealloc]	;
}

-(void)postgreSQLAsyncResultAvailable:(PostgreSQL *)inConn
{
		NSLog(@"Delegate postgreSQLAsyncResultAvailable")	;
}

-(void)postgreSQLAsyncResulTimedOut:(PostgreSQL *)inConn
{
		NSLog(@"Delegate postgreSQLAsyncResulTimedOut")	;
}

-(void)postgreSQL:(PostgreSQL *)inConn notification:(NSDictionary *)inDict
{
		NSLog(@"Delegate postgreSQL %@",inDict)	;
}

@end
