#include <uuid.h>
#include <string.h>

#define UUCHECK(a,b) if (a != b) return((a < b) ? -1 : 1);

int uuid_compare(const uuid_p p1, const uuid_p p2)
{
	if ((p1 == 0) && (p2 == 0))
	{
		return (0);
	}
	if ((p1 == 0) && (p2 != 0))
	{
		return (-1);
	}
	if ((p1 != 0) && (p2 == 0))
	{
		return (1);
	}

	UUCHECK(p1->time_low, p2->time_low);
	UUCHECK(p1->time_mid, p2->time_mid);
	UUCHECK(p1->time_hi_and_version, p2->time_hi_and_version);
	UUCHECK(p1->clock_seq, p2->clock_seq);

	return memcmp(p1->node, p2->node, 6);
}

