/* Written by Morgoth DBMA, morgothdbma@o2.pl
 This is part of PgXexplorer software, Open Source
 on BSD licence, Libraries(interaces) used:
 GNU GCC, AS (all stuff needed to compile C source into executable binary)
 LibPQ-FE from PostgreSQL, GTK (GIMP Toolkit)
 written in VIM editor, ctags used, CVS used
 Currently only one author: MOrgoth DBMA
 ! THIS FILE IS BASED ON GTK EXAMPLE FROM INTERNET !
 ! MANY GTK UI FUNCTIONS ARE BASED ON SOMEBODY'S EXAMLE CODE !
 ! BUT I DON'T KNOW THEIR PERSONALITY SO SORRY !
 ! I CANNOT ADD THEM TO AUTORS, BUT THANKS FOR SUPPORT ME !
 FILE: main.c */
#include "gtkincl.h"
#include "consoleout.h"
#include "gtkdialogs.h"
#include "pgxexplorer.h"

void disconnect()
{
 disconnect_db(&connection);
}

static void __dummy( GtkWidget *w,gpointer   data )
{
  error("Not yet implemented.\n");
}

static void close_results( GtkWidget *w,gpointer   data)
{
 gtk_main_quit();
 gtk_widget_destroy((GtkWidget*)(data));
}

static void qexec_quit( GtkWidget *w,gpointer   data)
{
 gtk_main_quit();
 gtk_widget_destroy(query_exec);
 query_exec = NULL;
}

static int menu_quit( GtkWidget *w,gpointer   data)
{
  if (gtk_dialog_yes_no("Are you sure?")) 
   {
    disconnect();
    gtk_main_quit();
    if (query_exec) 
       {
	qexec_quit(query_exec, NULL);
	exit(0);
       }
    return FALSE;
   }
 return TRUE;
}


static void about_box( GtkWidget *w,gpointer   data)
{
 gtk_dialog_printf("PgXexplorer: version 0.1 alpha", "Written by\nMorgoth DBMA\nPgXexplorer\nCurrently connected to: %s", currentbase);
}

static void save_database(GtkWidget* w, gpointer data)
{
 int a;
 char* filename;
 a = gtk_dialog_with_2_buttons("Do You want to save Current database or Other database?", "Current", "Other");
 if (a)
   {
    filename = gtk_dialog_gettext_printf("Enter filename, %s will be saved to:\n(extension .SQL will be added automatically)", currentbase);
    if (!strcmp(filename,""))
      {
	gtk_dialog_printf("Cannot save %s to empty name.\n", currentbase);
        return;
      }
    system_printf("pg_dump %s > %s.SQL", currentbase, filename);
   }
}

char* get_env(char*);

char *dbenv()
{
 sprintf(tmpstr,"PGDATA=\"%s\"\nPGPORT=\"%s\"\nPGHOST=\"%s\"", get_env("PGDATA"), get_env("PGPORT"), get_env("PGHOST")); 
 return tmpstr;
}

void fatal_nodb(char* dbname, char* errstr, int killed)
{
 gtk_dialog_printf_big_with_title("PgXexplorer Fatal Error", 
 	"Cannot connect to DB: %s\nDBMS returned: \n%s\nSystem will now exit.\nENV=%s", 
  	dbname,errstr,dbenv());
 if(killed) exit(1);
}

void reload_bases(char* db, int ask)
{
 int a;
 char errstr[MAX_QUERY_LENGTH];
 char winname[STDSTRING];
 char dbname[STDSTRING];
 strcpy(dbname,db);
 if (ask) a = gtk_dialog_yes_no_printf("Switch to database \"%s\" now?", db);
 else a=1;
 /**/
 if (!a) return;
 disconnect();
 free(currentbase);
 while (!strcmp(dbname,"")) 
   {
    gtk_dialog_printf("Cannot switch to an empty DB");
    strcpy(dbname, gtk_dialog_gettext("Null DB name cannot be accepted\nEnter database name: "));
   }
 sprintf(winname, "PgXexplorer: (no database opened currently)");
 gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
 connection = gtk_connect_db(dbname, errstr);
 if (!connection)
   {
    fatal_nodb(dbname,errstr,1);
    return ;
   }
 else 
   {
    currentbase = (char*)malloc(strlen(dbname)+2);
    strcpy(currentbase, dbname);
    sprintf(winname, "PgXexplorer: %s", currentbase);
    gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
   }
}

static void create_database(GtkWidget* w, gpointer data)
{
 char* dbname;
 char errstr[MAX_QUERY_LENGTH];
 char winname[STDSTRING];
 int a;
 PGresult *result;
 dbname = gtk_dialog_gettext("Enter database name: ");
 if (!strcmp(dbname,""))
    {
     gtk_dialog_printf("Will not create empty name DB\nTry once again.");
     return;
    }
 result = NULL;
 execute_printf_query(connection, &result, errstr, "CREATE DATABASE %s", dbname);
 if (!result)
   {
    gtk_dialog_printf_big("Error executing query:\nReturn from DBMS: %s\n", errstr);
    return;
   }
 a = gtk_dialog_yes_no_printf("Switch from database\n%s to %s now?", currentbase, dbname);
 if (a)
  {
   disconnect();
   free(currentbase);
   sprintf(winname, "PgXexplorer: (no database opened currently)");
   gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
   connection = gtk_connect_db(dbname, errstr);
   if (!connection)
     {
      fatal_nodb(dbname,errstr,1);
      exit(1);
      return ;
     }
   else 
     {
      currentbase = (char*)malloc(strlen(dbname)+2);
      strcpy(currentbase, dbname);
      sprintf(winname, "PgXexplorer: %s", currentbase);
      gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
     }
  }
}

static void exec_test_prog(GtkWidget* w, gpointer data)
{
 system("./pgxtest");
}

void gtk_table_out(char* title, char*** str_data, int a, int b)
{
 GtkWidget* window, *table, *button, *scrolled_window;
 GtkWidget*** entry;
 int i,j;
 if (!str_data) { gtk_dialog_printf("Error, table of results to display is equal NULL"); return; }
 entry = (GtkWidget***)malloc(a*sizeof(GtkWidget**));
 for (i=0;i<a;i++) entry[i] = (GtkWidget**)malloc(b*sizeof(GtkWidget*));
 window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_window_set_modal(GTK_WINDOW(window), TRUE);
 gtk_widget_set_usize (GTK_WIDGET(window), 500, 500);
 table = gtk_table_new (b+1, a+1, FALSE); 
 for (i=0;i<a;i++)
 for (j=0;j<b;j++)
   {
    entry[i][j] = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(entry[i][j]), str_data[i][j]);
    gtk_entry_set_editable(GTK_ENTRY(entry[i][j]), FALSE);
    gtk_table_attach (GTK_TABLE (table), entry[i][j], j, j+1, i+1, i+2,GTK_FILL,GTK_FILL, 0, 0);
    gtk_widget_show(entry[i][j]);
   }
 button = gtk_button_new_with_label("Close this window");
 gtk_table_attach (GTK_TABLE (table), button, 0, (b>2)?3:(b+1), 0, 1,GTK_FILL,GTK_FILL, 0, 0);
 gtk_widget_show(button);
 gtk_widget_show (table);
 scrolled_window = gtk_scrolled_window_new(NULL,NULL);
 gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
 gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window), table);
 gtk_container_set_border_width(GTK_CONTAINER(window), 2);
 gtk_container_set_border_width(GTK_CONTAINER(scrolled_window), 2);
 gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
 gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(close_results), (gpointer)(window));
 gtk_widget_show(scrolled_window);
 gtk_container_add (GTK_CONTAINER(window), scrolled_window);
 gtk_window_set_title(GTK_WINDOW(window), title);
 gtk_widget_show(window);
 gtk_main();
 for (i=0;i<a;i++) free(entry[i]);
 free(entry);
}

static void execute_proc(GtkWidget* w, gpointer txt)
{
 char* t;
 int l,i,a,b;
 PGresult *result;
 char errstr[MAX_QUERY_LENGTH];
 char*** out;
 l = gtk_text_get_length(GTK_TEXT(txt));
 if (l<3)
    {
     gtk_dialog_printf("Will not execute empty query\nTry once again.");
     return;
    }
 t = malloc(l+2);
 for (i=0;i<l;i++) t[i] = GTK_TEXT_INDEX(GTK_TEXT(txt), i);
 t[i] = 0;
 result = NULL;
 execute_printf_query(connection, &result, errstr, t);
 free(t);
 if (!result)
   {
    gtk_dialog_printf_big("Error executing query:\nReturn from DBMS: %s\n", errstr);
    return;
   }
 out = pgres2pc3(result, &a, &b);
 clear_result(&result);
 if (a>0 && b>0) gtk_table_out("Results of Query:", out, a, b);
 else gtk_dialog_printf("Query was OK, but didn't returned any result\nThis probably was INSERT OR CREATE...");
 free_p3c(&out, a, b);
}

void update_entry(GtkWidget* w, gpointer d)
{
 strcpy((char*)d,gtk_entry_get_text(GTK_ENTRY(w)));
}

void apply_proc(GtkWidget* w, gpointer d)
{
 char** ptr;
 ptr = (char**)d;
 if (setenv("PGPORT",ptr[0],1)==-1) gtk_dialog_printf("Cannot set environment variable: PGPORT");
 if (setenv("PGDATA",ptr[1],1)==-1) gtk_dialog_printf("Cannot set environment variable: PGDATA");
 if (setenv("PGHOST",ptr[2],1)==-1) gtk_dialog_printf("Cannot set environment variable: PGHOST");
 reload_bases(ptr[3], 1);
}

int connect_proc(GtkWidget* w, gpointer d)
{
 char** ptr;
 ptr = (char**)d;
 if (setenv("PGPORT",ptr[0],1)==-1) gtk_dialog_printf("Cannot set environment variable: PGPORT");
 if (setenv("PGDATA",ptr[1],1)==-1) gtk_dialog_printf("Cannot set environment variable: PGDATA");
 if (setenv("PGHOST",ptr[2],1)==-1) gtk_dialog_printf("Cannot set environment variable: PGHOST");
 reload_bases(ptr[3], 0);
 gtk_main_quit();
 return TRUE;
}


int delete_proc(GtkWidget* w, gpointer d)
{
 gtk_main_quit();
 /*gtk_widget_destroy((GtkWidget*)d);*/
 return TRUE;
}

char* get_env(char* str)
{
 char* ret;
 ret = getenv(str);
 if (ret) return ret;
 else return "";
}


static void env_dialog(GtkWidget* www, gpointer d)
{
 GtkWidget* dialog, *label[4], *button[3], *entry[4], *table;
 char **t_entry;
 int i;
 t_entry = (char**)malloc(4<<2);
 for (i=0;i<4;i++) t_entry[i] = (char*)malloc(STDSTRING+1);
 for (i=0;i<4;i++)strcpy(t_entry[i], "");
 dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 if (!d) gtk_window_set_title(GTK_WINDOW(dialog), "Environment settings");
 else gtk_window_set_title(GTK_WINDOW(dialog), "Write at least database name, empty fields means default");
 gtk_widget_set_usize(dialog, 500, 160);
 gtk_window_set_modal(GTK_WINDOW(dialog), 1);
 label[0] = gtk_label_new("Port:");
 label[1] = gtk_label_new("DataDir:");
 label[2] = gtk_label_new("Host:");
 label[3] = gtk_label_new("DataBase:");
 for (i=0;i<4;i++) 
  {
   entry[i] = gtk_entry_new();
   gtk_entry_set_max_length(GTK_ENTRY(entry[i]), STDSTRING-1);
   gtk_entry_set_editable(GTK_ENTRY(entry[0]), TRUE);
   gtk_signal_connect(GTK_OBJECT(entry[i]), "activate", GTK_SIGNAL_FUNC(update_entry), (gpointer)t_entry[i]);
   gtk_signal_connect(GTK_OBJECT(entry[i]), "changed",  GTK_SIGNAL_FUNC(update_entry), (gpointer)t_entry[i]);
  }
 table = gtk_table_new (5, 3, TRUE); 
 gtk_entry_set_text(GTK_ENTRY(entry[0]), get_env("PGPORT"));
 gtk_entry_set_text(GTK_ENTRY(entry[1]), get_env("PGDATA"));
 gtk_entry_set_text(GTK_ENTRY(entry[2]), get_env("PGHOST"));
 gtk_entry_set_text(GTK_ENTRY(entry[3]), currentbase?currentbase:"");
 for (i=0;i<4;i++)
   { 
    gtk_table_attach (GTK_TABLE (table),label[i], 0, 1, i, i+1,GTK_FILL,GTK_FILL, 0, 0);
    gtk_table_attach (GTK_TABLE (table),entry[i], 1, 3, i, i+1,GTK_FILL|GTK_EXPAND,GTK_FILL, 0, 0);
    gtk_widget_show(entry[i]);
    gtk_widget_show(label[i]);
   }
 if (!d)
  {
   button[0] = gtk_button_new_with_label("Apply");
   button[1] = gtk_button_new_with_label("Close");
   gtk_signal_connect(GTK_OBJECT(button[0]), "clicked", GTK_SIGNAL_FUNC(apply_proc), (gpointer)(t_entry));
   gtk_signal_connect(GTK_OBJECT(button[1]), "clicked", GTK_SIGNAL_FUNC(delete_proc), (gpointer)dialog);
  }
 button[2] = gtk_button_new_with_label("Connect");
 gtk_signal_connect(GTK_OBJECT(button[2]), "clicked", GTK_SIGNAL_FUNC(connect_proc),(gpointer)(t_entry));
 if (!d)
   {
    gtk_table_attach (GTK_TABLE (table), button[0], 1, 2, 4, 5,GTK_FILL,GTK_FILL|GTK_EXPAND, 0, 0);
    gtk_table_attach (GTK_TABLE (table), button[1], 2, 3, 4, 5,GTK_FILL,GTK_FILL|GTK_EXPAND, 0, 0);
    gtk_table_attach (GTK_TABLE (table), button[2], 0, 1, 4, 5,GTK_FILL,GTK_FILL|GTK_EXPAND, 0, 0);
    gtk_widget_show(button[0]);
    gtk_widget_show(button[1]);
   }
 else gtk_table_attach (GTK_TABLE (table), button[2], 0, 3, 4, 5,GTK_FILL,GTK_FILL|GTK_EXPAND, 0, 0);
 gtk_widget_show(button[2]);
 gtk_widget_grab_focus(entry[0]);
 gtk_container_add(GTK_CONTAINER(GTK_WINDOW(dialog)), table);
 gtk_widget_show(table);
 gtk_signal_connect(GTK_OBJECT(dialog), "delete_event", GTK_SIGNAL_FUNC(delete_proc), (gpointer)dialog);
 gtk_widget_show(dialog);
 gtk_main();
 for (i=0;i<4;i++) free(t_entry[i]);
 free(t_entry);
 gtk_widget_destroy(dialog);
}

static void check_exec_proc(GtkWidget* txt, gpointer dlg)
{
 int l;
 l = gtk_text_get_length(GTK_TEXT(txt));
 if (GTK_TEXT_INDEX(GTK_TEXT(txt), l-1)==';') execute_proc(dlg,(GtkWidget*)txt);
}

static void query_executor(GtkWidget* w, gpointer data)
{
 GtkWidget* window, *table, *text, *hscrollbar, *vscrollbar, *button;
 if (query_exec)
   {
    gtk_dialog_printf("Another instance of QueryExecutor is running.");
    return;
   }
 window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET(window), 400, 300);
 gtk_container_set_border_width(GTK_CONTAINER(window), 10);
 table = gtk_table_new (2, 2, FALSE);  
 text = gtk_text_new (NULL, NULL);
 gtk_table_attach (GTK_TABLE (table), text, 0, 1, 0, 1,
		      GTK_FILL | GTK_EXPAND,
		      GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 0);
 gtk_text_set_editable(GTK_TEXT(text), TRUE);
 gtk_text_set_word_wrap(GTK_TEXT(text), TRUE);
 gtk_text_set_line_wrap(GTK_TEXT(text), TRUE);
 gtk_widget_show (text);   
 hscrollbar = gtk_hscrollbar_new (GTK_TEXT (text)->hadj);
 gtk_table_attach (GTK_TABLE (table), hscrollbar, 0, 1, 1, 2,
		      GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 0);
 gtk_widget_show (hscrollbar);  
 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
		      GTK_FILL, GTK_EXPAND | GTK_FILL | GTK_SHRINK, 0, 0);
 gtk_widget_show (vscrollbar);
 button = gtk_button_new_with_label("Go!");
 gtk_table_attach (GTK_TABLE (table), button, 1, 2, 1, 2,
		      GTK_FILL, GTK_FILL, 0, 0);
 gtk_widget_show(button);
 gtk_container_add (GTK_CONTAINER(window), table);
 gtk_widget_show (table);
 gtk_widget_grab_focus(text);
 gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(qexec_quit), NULL);
 gtk_signal_connect(GTK_OBJECT(text),   "changed", GTK_SIGNAL_FUNC(check_exec_proc), (gpointer)(window));
 gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(qexec_quit), NULL);
 gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(execute_proc), (gpointer)(text));
 gtk_window_set_title(GTK_WINDOW(window), "SQL Query Editor, type `;' to execute query");
 gtk_widget_show(window);
 query_exec = window;
 gtk_main();
}

/* This is the GtkItemFactoryEntry structure used to generate new menus.
   Item 1: The menu path. The letter after the underscore indicates an
           accelerator key once the menu is open.
   Item 2: The accelerator key for the entry
   Item 3: The callback function.
   Item 4: The callback action.  This changes the parameters with
           which the function is called.  The default is 0.
   Item 5: The item type, used to define what kind of an item it is.
           Here are the possible values:
           NULL               -> "<Item>"
           ""                 -> "<Item>"
           "<Title>"          -> create a title item
           "<Item>"           -> create a simple item
           "<CheckItem>"      -> create a check item
           "<ToggleItem>"     -> create a toggle item
           "<RadioItem>"      -> create a radio item
           <path>             -> path of a radio item to link against
           "<Separator>"      -> create a separator
           "<Branch>"         -> create an item to hold sub items (optional)
           "<LastBranch>"     -> create a right justified branch
*/
static GtkItemFactoryEntry menu_items[] = {
  { "/_File",         		NULL,         NULL, 0, "<Branch>" },
  { "/File/_New DB",     	"<control>N", create_database, 0, NULL },
  { "/File/_Open DB",    	"<control>O", __dummy, 0, NULL },
  { "/File/_Load DB from File", "<control>L", __dummy, 0, NULL },
  { "/File/_Save DB to File",	"<control>S", save_database, 0, NULL },
  { "/File/_Execute SQL Query",	"<control>E", query_executor, 0, NULL },
  { "/File/sep1",     NULL,         NULL, 0, "<Separator>" },
  { "/File/Quit",     "<control>Q", (void (*)(GtkWidget*,gpointer))menu_quit, 0, NULL },
  { "/_Options",      NULL,         NULL, 0, "<Branch>" },
  { "/Options/Test",  "<control>T",         exec_test_prog, 0, NULL },
  { "/Options/Environment",     NULL,       env_dialog, 0, NULL },
  { "/_Help",         NULL,         NULL, 0, "<LastBranch>" },
  { "/_Help/About",   NULL,         about_box, 0, NULL },
};

void get_main_menu( GtkWidget  *window,GtkWidget **menubar )
{
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
  accel_group = gtk_accel_group_new ();
  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",accel_group);
  gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, NULL);
  gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);
  if (menubar) *menubar = gtk_item_factory_get_widget (item_factory, "<main>");
  error("menu is not yet implemented.\n");
}

int parse_cmdline(int lb, char** par, GtkWidget* w)
{
 char* dbname;
 char errstr[MAX_ENTRY_LENGTH];
 int gotdb,ch;
 gotdb=0;
 dbname = NULL;
 printf("Dodac opcje zapisac aktualnej kwerendy i wykonania kwerendy z pliku: opefiledialog\n");
 printf("Zmienic w savedb to file na uzycie savefiledialog, i tak samo uzyc w zapisie kwerendy\n");
 printf("powyzsze f-cje dodac do gtkdialogs.[ch]\n");
 while ((ch = getopt(lb,par,"d:he")) != -1)
   {
    switch (ch)
      {
       case 'd': gotdb=1; dbname = malloc(strlen(optarg)+1); strcpy(dbname, optarg); break;
       case 'e': gotdb=1; env_dialog(w,(gpointer)1); return 0;
       case 'h': gtk_dialog_printf("Options are:\n-d [database_name]\n-e (use advanced environment)"); return 1;
       default: gtk_dialog_printf("Unrecognized command line option\noptions are:\n-d data_base_name\n-h help"); return 1;
      }
   }
 if (!gotdb) dbname = gtk_dialog_gettext("Connect to database: ");
 if (!strcmp(dbname,""))
    {
     gtk_dialog_printf("Empty Database name, cannot be opened.\nSystem will now exit.");
     return 1;
    }
 connection = gtk_connect_db(dbname, errstr);
 if (!connection)
   {
    fatal_nodb(dbname,errstr,1);
    if (gotdb) free(dbname);
    return 1;
   }
 else 
   {
    currentbase = (char*)malloc(strlen(dbname)+2);
    strcpy(currentbase, dbname);
    if (gotdb) free(dbname);
    return 0;
   }
}


int main(int lb, char **par)
{
  GtkWidget *window;
  GtkWidget *main_vbox;
  GtkWidget *menubar;
  char winname[MAX_ENTRY_LENGTH];
  int err;
  gtk_init (&lb, &par);
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  /*gtk_signal_connect (GTK_OBJECT (window), "destroy", GTK_SIGNAL_FUNC (gtk_main_quit), "WM destroy");*/
  gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(menu_quit), NULL);
  gtk_widget_set_usize (GTK_WIDGET(window), 800, 600);
  main_vbox = gtk_vbox_new (FALSE, 1);
  gtk_container_border_width (GTK_CONTAINER (main_vbox), 1);
  gtk_container_add (GTK_CONTAINER (window), main_vbox);
  gtk_widget_show (main_vbox);
  get_main_menu (window, &menubar);
  gtk_box_pack_start (GTK_BOX (main_vbox), menubar, FALSE, TRUE, 0);
  gtk_widget_show (menubar);
  gtk_widget_show (window);
  main_wnd = window;
  err = parse_cmdline(lb,par,window);
  if (err) return 1;
  else 
    {
     sprintf(winname, "PgXexplorer: %s", currentbase);
     gtk_window_set_title (GTK_WINDOW(window), winname);
    }
  gtk_main ();
  return(0);
}

