<?php

/**************************************************
Program name:	buildsql_tbl_setprivilege.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Builds SQL string for setting privilege and 
		execute SQL (i.e. set privilege)
		Returns Zero Rows
		
Create Date:	6/29/01 

Modified Dates: 	

Notes:		

**************************************************/

unset($sql_query);

// Check if a todo action was declared (from tbl_privilege2page.php)
if (isset($todo)) {
	// Build GRANT statement
	if ($todo == "grant") {
		$sql_query = "GRANT ". implode(", ", $privileges) ." ON ".dq($table)." TO ". dquotes(rawurldecode($username));

	// Build REVOKE statement
	} elseif ($todo == "revoke") {
		$sql_query = "REVOKE ". implode(", ", $privileges) ." ON ".dq($table)." FROM ". dquotes(rawurldecode($username));

	// Build GRANT statement for user or group
	} else {
		$sql_query = "GRANT ". implode(", ", $privileges) ." ON ".dq($table)." TO ". rawurldecode($grant_name);
	}
}

// strip quotes off public
$sql_query = eregi_replace("\"public\"", "PUBLIC", $sql_query);

// strip quoutus off group (TO "group" will give an error)
$sql_query = eregi_replace("\"group ", "GROUP \"", $sql_query);

// replace double-quotes with single quotes
$sql_query = eregi_replace("\"\"", "\"", $sql_query);

// strip slashes
$sql_query = stripslashes($sql_query);


?>
