<?php
/* $Id: db_dump.php,v 1.2 2000/11/26 10:58:38 chriskl Exp $ */

$crlf="\n";
if (empty($asfile)) {
	include("header.inc.php");
	print "<div align=left><pre>\n";
} else {
	include("lib.inc.php");
	header("Content-disposition: filename=$db.sql");
	header("Content-type: application/octetstream");
	header("Pragma: no-cache");
	header("Expires: 0");

	// doing some DOS-CRLF magic...
	$client=getenv("HTTP_USER_AGENT");
	if (ereg('[^(]*\((.*)\)[^)]*',$client,$regs)) {
		$os = $regs[1];
		// this looks better under WinX
		if (eregi("Win",$os)) $crlf="\r\n";
	}
}

function my_handler($sql_insert) {
	global $crlf, $asfile;
	if (empty($asfile)) {
		echo htmlspecialchars("$sql_insert;$crlf");
	} else {
		echo "$sql_insert;$crlf";
	}
}

print "$crlf/* -------------------------------------------------------- $crlf"; 
print "  $cfgProgName $cfgVersion DB Dump$crlf";
print "  http://www.phpwizard.net/phpPgAdmin/$crlf";
print "  $strHost: " . $cfgServer['host'];

if (!empty($cfgServer['port'])) {
	print ":" . $cfgServer['port'];
}
print "$crlf  $strDatabase: $db$crlf";
print "  " . date("Y-d-m H:m:i") . $crlf;
print "-------------------------------------------------------- */ $crlf";

$get_seq_sql = "
	SELECT relname 
	FROM pg_class 
	WHERE 
		NOT relname ~ 'pg_.*' 
		AND relkind ='S' 
	ORDER BY relname
	";

$seq = @pg_exec($link, pre_query($get_seq_sql));
if (!$num_seq = @pg_numrows($seq)) {
	print "/* $strNo $strSequences $strFound */";
} else {
	print "$crlf/* -------------------------------------------------------- $crlf";
	print "  $strSequences $crlf";
	print "-------------------------------------------------------- */ $crlf";

	while ($i_seq < $num_seq) {
		$sequence = @pg_result($seq, $i_seq, "relname");
		
		$sql_get_props = "SELECT * FROM $cfgQuotes$sequence$cfgQuotes";
		$seq_props = @pg_exec($link, pre_query($sql_get_props));
		if (@pg_numrows($seq_props)) {
			$row = @pg_fetch_array($seq_props, 0);
			if ($what != "data") {
				$row[last_value] = 1;
			}
			print "CREATE SEQUENCE $cfgQuotes$sequence$cfgQuotes start $row[last_value] increment $row[increment_by] maxvalue $row[max_value] minvalue $row[min_value] cache $row[cache_value]; $crlf";
		}
		if (($row[last_value] > 1) && ($what == "data")) {
			print "SELECT NEXTVAL('$sequence'); $crlf";
			unset($row[last_value]);
		}
		$i_seq++;
	}
}

$tables = @pg_exec($link, "SELECT tablename FROM pg_tables WHERE tablename !~ 'pg_.*' ORDER BY tablename");

$num_tables = @pg_numrows($tables);
if (!$num_tables) {
	echo $strNoTablesFound;
} else {
	
	for ($i = 0; $i < $num_tables; $i++) {
		$table = pg_result($tables, $i, "tablename");
	
		print "$crlf/* -------------------------------------------------------- $crlf";
		print "  $strTableStructure $cfgQuotes$table$cfgQuotes $crlf";
		print "-------------------------------------------------------- */";

		echo $crlf, get_table_def($link, $table, $crlf), $crlf;
		
		if ($what == "data") {
		
			print "$crlf/* -------------------------------------------------------- $crlf";
			print "  $strDumpingData $cfgQuotes$table$cfgQuotes $crlf";
			print "-------------------------------------------------------- */ $crlf";
		
			get_table_content($link, $table, "my_handler");
		}
	}
}

// tablename !~ 'pg_.*'
$sql_get_views = "SELECT * FROM pg_views WHERE viewname !~ 'pg_.*'";

$views = @pg_exec($link, pre_query($sql_get_views));
if (!$num_views = @pg_numrows($views)) {
	print "$crlf/* $strNo $strViews $strFound */$crlf";
} else {
	print "$crlf/* -------------------------------------------------------- $crlf";
	print "  $strViews $crlf";
	print "-------------------------------------------------------- */ $crlf";

	for ($i_views = 0; $i_views < $num_views; $i_views++) {
		$view = pg_fetch_array($views, $i_views);
		print "CREATE VIEW $cfgQuotes$view[viewname]$cfgQuotes AS $view[definition] $crlf";
	}
}

// Output triggers

// Some definitions
$TRIGGER_TYPE_ROW			=	(1 << 0);
$TRIGGER_TYPE_BEFORE		=	(1 << 1);
$TRIGGER_TYPE_INSERT		=	(1 << 2);
$TRIGGER_TYPE_DELETE		=	(1 << 3);
$TRIGGER_TYPE_UPDATE		=	(1 << 4);

$sql_get_triggers = "
	SELECT 
		pt.*, pp.proname, pc.relname
	FROM 
		pg_trigger pt, pg_proc pp, pg_class pc
	WHERE 
		pp.oid=pt.tgfoid
		and pt.tgrelid=pc.oid
		and relname !~ '^pg_'
";

$triggers = @pg_exec($link, pre_query($sql_get_triggers));
if (!$num_triggers = @pg_numrows($triggers)) {
	print "$crlf/* $strNo $strTriggers $strFound */$crlf";
} else {
	print "$crlf/* -------------------------------------------------------- $crlf";
	print "  $strTriggers $crlf";
	print "-------------------------------------------------------- */ $crlf";

	for ($i_triggers = 0; $i_triggers < $num_triggers; $i_triggers++) {
		$trigger = pg_fetch_array($triggers, $i_triggers);
		// Constraint or not
		if ($trigger[tgisconstraint] == 't')
			print "CREATE CONSTRAINT TRIGGER";
		else
			print "CREATE TRIGGER";
		// Name
		print " $cfgQuotes$trigger[tgname]$cfgQuotes";

		// before/after
		if ($trigger[tgtype] & $TRIGGER_TYPE_BEFORE)
			print " BEFORE";
		else
			print " AFTER";

		// Insert
		$findx = 0;
		if ($trigger[tgtype] & $TRIGGER_TYPE_INSERT) {
			print " INSERT";
			$findx++;
		}

		// Delete
		if ($trigger[tgtype] & $TRIGGER_TYPE_DELETE) {
			if ($findx > 0)
				print " OR DELETE";
			else
				print " DELETE";
			$findx++;
		}
		
		// Update
		if ($trigger[tgtype] & $TRIGGER_TYPE_UPDATE) {
			if ($findx > 0)
				print " OR UPDATE";
			else
				print " UPDATE";
		}

		// On
		print " ON $cfgQuotes$trigger[relname]$cfgQuotes";

		// Contraints, deferrable
		if ($trigger[tgisconstraint] == 't') {
			if ($trigger[tgdeferrable] == 'f') print " NOT";
			print " DEFERRABLE INITIALLY ";

			if ($trigger[tginitdeferred] == 't')
				print "DEFERRED";
			else
				print "IMMEDIATE";
		}
		echo " FOR EACH ROW";
		echo " EXECUTE PROCEDURE $cfgQuotes$trigger[proname]$cfgQuotes ('";

		// Strip of trailing delimiter
		$tgargs = trim(substr($trigger[tgargs], 0, strlen($trigger[tgargs]) - 4));
		$params = explode('\000', $tgargs);

		for ($i = 0; $i < sizeof($params); $i++) {
			$params[$i] = str_replace("'", "\\'", $params[$i]);
		}
		$params = implode("', '", $params);
		echo htmlspecialchars($params), "');$crlf";
	}
}

// Output functions

// Max built-in oid
//$sql_get_max = "SELECT datlastsysoid from pg_database where datname = '$db'";
//$maxes = @pg_exec($link, pre_query($sql_get_max));
//$row = @pg_fetch_array($maxes, 0);
//$max = $row[datlastsysoid];
$max = 16384;

// Skips system functions
$sql_get_funcs = "
	SELECT
		proname
	FROM 
		pg_proc pc, pg_user pu
	WHERE
		proowner = usesysid
		AND pg_proc.oid > '$max'::oid
";

print $crlf;

$funcs = @pg_exec($link, pre_query($sql_get_funcs));
if (!$num_funcs = @pg_numrows($funcs)) {
	print "/* $strNo $strFuncs $strFound */$crlf";
} else {
	print "$crlf/* -------------------------------------------------------- $crlf";
	print "  $strFuncs $crlf";
	print "-------------------------------------------------------- */ $crlf";

	for ($i_funcs = 0; $i_funcs < $num_funcs; $i_funcs++) {
		$function = pg_result($funcs, $i_funcs, "proname");

		$sql_func_props = "
			SELECT 
				proname, 
				lanname as language,
				pt.typname as return_type,
				pa.typname as argtype,
				prosrc as source
			FROM 
				pg_proc pc, pg_language pl, pg_type pt, pg_type pa
			WHERE 
				proname = '$function'
				AND pc.prolang = pl.oid
				AND pc.prorettype = pt.oid
		";

		$sql_func_args = "
			SELECT 
				proname, 
				pa.typname as argtype
			FROM 
				pg_proc pc, pg_type pa
			WHERE 
				proname = '$function'
				AND
				(
					pa.oid = pc.proargtypes[0]
					OR pa.oid = pc.proargtypes[1]
					OR pa.oid = pc.proargtypes[2]
					OR pa.oid = pc.proargtypes[3]
					OR pa.oid = pc.proargtypes[4]
					OR pa.oid = pc.proargtypes[5]
					OR pa.oid = pc.proargtypes[6]
					OR pa.oid = pc.proargtypes[7]
				)
		";

		$props = @pg_exec($link, pre_query($sql_func_props)) or pg_die(pg_errormessage(), $sql_func_props);
		$row = @pg_fetch_array($props, 0);
		$args = @pg_exec($link, pre_query($sql_func_args)) or pg_die();
		for ($i_arg = 0; $i_arg < @pg_numrows($args); $i_arg++) {
			$strArgList .= " " . pg_result($args, $i_arg, "argtype") . ",";
		}
		$strArgList = ereg_replace(",$|, $", "", $strArgList);
		
		print "CREATE FUNCTION $function($strArgList) ";
		print "   RETURNS $row[return_type]";
		print "   AS '$row[source]'";
		print "   LANGUAGE '$row[language]'; $crlf $crlf";
	}
}


if(empty($asfile)) {
	print "</pre></div>\n";
	include ("footer.inc.php");
}
?>
