/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.SingleRowResultSet;

public class SingleRowWriter
extends SingleRowResultSet {
    private final TupleDesc m_tupleDesc;
    private final Object[] m_values;

    public SingleRowWriter(TupleDesc tupleDesc) throws SQLException {
        this.m_tupleDesc = tupleDesc;
        this.m_values = new Object[tupleDesc.size()];
    }

    protected Object getObjectValue(int n) throws SQLException {
        return this.m_values[n - 1];
    }

    public boolean rowUpdated() throws SQLException {
        int n = this.m_values.length;
        while (--n >= 0) {
            if (this.m_values[n] == null) continue;
            return true;
        }
        return false;
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.m_values[n - 1] = object;
    }

    public void cancelRowUpdates() throws SQLException {
        Arrays.fill(this.m_values, null);
    }

    public void copyRowFrom(ResultSet resultSet) throws SQLException {
        int n = this.m_values.length;
        for (int i = 0; i < n; ++i) {
            this.m_values[i] = resultSet.getObject(i + 1);
        }
    }

    public Tuple getTupleAndClear() throws SQLException {
        Tuple tuple = this.getTupleDesc().formTuple(this.m_values);
        Arrays.fill(this.m_values, null);
        return tuple;
    }

    protected final TupleDesc getTupleDesc() {
        return this.m_tupleDesc;
    }
}

