/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.Backend;

public class PgSavepoint
implements Savepoint {
    private static final WeakHashMap s_knownSavepoints = new WeakHashMap();
    private long m_pointer;

    PgSavepoint(long l) {
        this.m_pointer = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PgSavepoint set(String string) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            PgSavepoint pgSavepoint = new PgSavepoint(PgSavepoint._set(string));
            s_knownSavepoints.put(pgSavepoint, Boolean.TRUE);
            return pgSavepoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PgSavepoint forId(int n) {
        if (n != 0) {
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                Iterator iterator = s_knownSavepoints.keySet().iterator();
                while (iterator.hasNext()) {
                    PgSavepoint pgSavepoint = (PgSavepoint)iterator.next();
                    if (n != PgSavepoint._getId(pgSavepoint.m_pointer)) continue;
                    return pgSavepoint;
                }
            }
        }
        return null;
    }

    public int hashCode() {
        return this.getSavepointId();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            PgSavepoint._release(this.m_pointer);
            s_knownSavepoints.remove(this);
            this.m_pointer = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            PgSavepoint._rollback(this.m_pointer);
            s_knownSavepoints.remove(this);
            this.m_pointer = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSavepointName() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return PgSavepoint._getName(this.m_pointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSavepointId() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return PgSavepoint._getId(this.m_pointer);
        }
    }

    public void onInvocationExit(Connection connection) throws SQLException {
        if (this.m_pointer == 0L) {
            return;
        }
        Logger logger = Logger.getAnonymousLogger();
        if (Backend.isReleaseLingeringSavepoints()) {
            logger.warning("Releasing savepoint '" + PgSavepoint._getId(this.m_pointer) + "' since its lifespan exceeds that of the function where it was set");
            connection.releaseSavepoint(this);
        } else {
            logger.warning("Rolling back to savepoint '" + PgSavepoint._getId(this.m_pointer) + "' since its lifespan exceeds that of the function where it was set");
            connection.rollback(this);
        }
    }

    private static native long _set(String var0) throws SQLException;

    private static native void _release(long var0) throws SQLException;

    private static native void _rollback(long var0) throws SQLException;

    private static native String _getName(long var0);

    private static native int _getId(long var0);
}

