/*
 * plpq.h
 *
 */

#ifndef PLPQ_H
#define PLPQ_H

#include "postgres.h"
#include "libpq-fe.h"
#include "fmgr.h"
#include "utils/memutils.h"
#include "catalog/pg_type.h"
#include "nodes/pg_list.h"
#include "utils/builtins.h"
#include "commands/trigger.h"	/* -"- and triggers */
#include "pqexpbuffer.h"
#include "executor/spi.h"

/*
 * This struct information about public connections
 */
typedef struct
{
	/*
	 * resource index number for this context
	 */
	int			conn_id_index;

	/*
	 * the actual connection pointer
	 */
	PGconn   *conn;
}	public_pq_connections;


typedef struct
{
	/*
	 * resource index number for this context
	 */
	int			res_id_index;

	/*
	 * the actual query results
	 */
	PGresult   *res;
}	public_pq_results;

extern Datum plpq_Connectdb(PG_FUNCTION_ARGS);
extern Datum plpq_SetdbLogin(PG_FUNCTION_ARGS);
extern Datum plpq_Status(PG_FUNCTION_ARGS);
extern Datum plpq_StatusStr(PG_FUNCTION_ARGS);
extern Datum plpq_Finish(PG_FUNCTION_ARGS);
extern Datum plpq_Reset(PG_FUNCTION_ARGS);
extern Datum plpq_Db(PG_FUNCTION_ARGS);
extern Datum plpq_User(PG_FUNCTION_ARGS);
extern Datum plpq_Password(PG_FUNCTION_ARGS);
extern Datum plpq_Host(PG_FUNCTION_ARGS);
extern Datum plpq_Port(PG_FUNCTION_ARGS);
extern Datum plpq_Tty(PG_FUNCTION_ARGS);
extern Datum plpq_ErrorMessage(PG_FUNCTION_ARGS);
extern Datum plpq_BackendPID(PG_FUNCTION_ARGS);
extern Datum plpq_Exec(PG_FUNCTION_ARGS);
extern Datum plpq_ResultStatus(PG_FUNCTION_ARGS);
extern Datum plpq_ResStatus(PG_FUNCTION_ARGS);
extern Datum plpq_ResultErrorMessage(PG_FUNCTION_ARGS);
extern Datum plpq_Clear(PG_FUNCTION_ARGS);
extern Datum plpq_EscapeString(PG_FUNCTION_ARGS);
extern Datum plpq_Ntuples(PG_FUNCTION_ARGS);
extern Datum plpq_Nfields(PG_FUNCTION_ARGS);
extern Datum plpq_Fname(PG_FUNCTION_ARGS);
extern Datum plpq_Fnumber(PG_FUNCTION_ARGS);
extern Datum plpq_Ftype(PG_FUNCTION_ARGS);
extern Datum plpq_Fmod(PG_FUNCTION_ARGS);
extern Datum plpq_Fsize(PG_FUNCTION_ARGS);
extern Datum plpq_BinaryTuples(PG_FUNCTION_ARGS);
extern Datum plpq_GetValue(PG_FUNCTION_ARGS);
extern Datum plpq_Getisnull(PG_FUNCTION_ARGS);
extern Datum plpq_Getlength(PG_FUNCTION_ARGS);
extern Datum plpq_CmdStatus(PG_FUNCTION_ARGS);
extern Datum plpq_CmdTuples(PG_FUNCTION_ARGS);
extern Datum plpq_OidValue(PG_FUNCTION_ARGS);
extern Datum plpq_OidStatus(PG_FUNCTION_ARGS);
extern Datum plpq_Setnonblocking(PG_FUNCTION_ARGS);
extern Datum plpq_Isnonblocking(PG_FUNCTION_ARGS);
extern Datum plpq_SendQuery(PG_FUNCTION_ARGS);
extern Datum plpq_GetResult(PG_FUNCTION_ARGS);
extern Datum plpq_ConsumeInput(PG_FUNCTION_ARGS);
extern Datum plpq_IsBusy(PG_FUNCTION_ARGS);
extern Datum plpq_Flush(PG_FUNCTION_ARGS);
extern Datum plpq_Socket(PG_FUNCTION_ARGS);
extern Datum plpq_RequestCancel(PG_FUNCTION_ARGS);
extern Datum Rlog(PG_FUNCTION_ARGS);

#endif   /* PLPQ_H */
