/* Module:          SQLGetConnectOption.c
 *
 * Description:     Has been replaced by SQLGetConnectAttr. 
 *
 * Classes:         
 *
 * API functions:   SQLGetConnectOption
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLGetConnectOption(
        SQLHDBC    hDrvDbc,
        SQLUSMALLINT   fOption,
        SQLPOINTER     pvParam)
{
	static char *func="SQLGetConnectOption";
	ConnectionClass *conn = (ConnectionClass *) hDrvDbc;

	mylog("%s: entering...\n", func);

	if (! conn) 
	{
		CC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	switch (fOption) 
	{
		case SQL_ACCESS_MODE:/* NOT SUPPORTED */
			*((UDWORD *) pvParam) = SQL_MODE_READ_WRITE;
			break;

		case SQL_AUTOCOMMIT:
			*((UDWORD *)pvParam) = (UDWORD)( CC_is_in_autocommit(conn) ?
						SQL_AUTOCOMMIT_ON : SQL_AUTOCOMMIT_OFF);
			break;

		case SQL_CURRENT_QUALIFIER:	/* don't use qualifiers */
			if(pvParam)
			{
				strcpy(pvParam, "");
			}
			break;

		case SQL_LOGIN_TIMEOUT: /* NOT SUPPORTED */
			*((UDWORD *) pvParam) = 0;
			break;

		case SQL_PACKET_SIZE: /* NOT SUPPORTED */
			*((UDWORD *) pvParam) = globals.socket_buffersize;
			break;

		case SQL_QUIET_MODE:/* NOT SUPPORTED */
			*((UDWORD *) pvParam) = (UDWORD) NULL;
			break;

		case SQL_TXN_ISOLATION:/* NOT SUPPORTED */
			*((UDWORD *) pvParam) = SQL_TXN_SERIALIZABLE;
			break;

		/*	These options should be handled by driver manager */
		case SQL_ODBC_CURSORS:
		case SQL_OPT_TRACE:
		case SQL_OPT_TRACEFILE:
		case SQL_TRANSLATE_DLL:
		case SQL_TRANSLATE_OPTION:
			CC_log_error(func, "This connect option (Get) is only used by the Driver Manager", conn);
		break;

	default:
		{
			char option[64];
			conn->errormsg = "Unknown connect option (Get)";
			conn->errornumber = CONN_UNSUPPORTED_OPTION;
			sprintf(option, "fOption=%d", fOption);
			CC_log_error(func, option, conn);
			return SQL_ERROR;
			break;
		}
		

	}    

	return SQL_SUCCESS;
}

