//------------------------------------------------------------------------------
//  Name                :   WinMaster
//      You can obtain the latest version at                                             
//      http://gborg.postgresql.org/project/winmaster/projdisplay.php
//      Here's a web interface to CVS tree
//      http://gborg.postgresql.org/project/winmaster/viewcvs/
//
//  Description         :   Windows console for PostgreSQL server
//
//  Date                :   17/01/03 11:36
//
//  Copyright           :   Igor Georgiev       gory@alphasoft-bg.com
//                          Alpha Soft Ltd      www.alphasoft-bg.com
//
//  Portions Copyright  :   Mark L. Woodward    markw@mohawksoft.com
//                          Mohawk Software     www.mohawksoft.com
//
//  Authors             :   If this code works  it was written by
//                          Igor Georgiev & Mark L. Woodward
//                          If not, we don't know who wrote it and 
//                          dont't even heard anything about it.
//------------------------------------------------------------------------------
// This program is free software. You can redistribute it and/or
// modify it under the terms of the Mozilla Public License 1.1 (MPL 1.1)
// (at your option) any later version.
// You can obtain the latest version at                                             
// http://www.opensource.org/licenses/
//------------------------------------------------------------------------------
// This program is distributed in the hope that it will be useful,                
// but WITHOUT ANY WARRANTY; without even the implied warranty of                 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                  
// Mozilla Public License for more details.    
// http://www.opensource.org/licenses/mozilla1.1.php                               
//------------------------------------------------------------------------------
#ifndef _MAIN_H_INCLUDED
#define _MAIN_H_INCLUDED
//------------------------------------------------------------------------------
#include <windows.h>
#include <stdio.h>
//------------------------------------------------------------------------------
#define	__SMART_SHUTDOWN		"-s TERM"
#define	__FAST_SHUTDOWN			"-s INT"
#define	__IMMEDIATE_SHUTDOWN	"-s QUIT"
#define	__RELOAD				"-s HUP"
#define MAX_BUF_LEN	512
//------------------------------------------------------------------------------
#include "rc.h"
#include "miscfunc.h"
#include "winexept.h"
#include "msgstrings.h"
#include "controls.h"
#include "controller.h"
#include "redirect.h"
#include "profile.h"
#include "optionsdlg.h"
//------------------------------------------------------------------------------
#ifdef	__MAIN_CPP
	HINSTANCE TheInstance = 0;
	Controller* control = 0;
	ConsoleRedirector ConsolePostmaster;
	// profile settings
	ProfileReader Prf;
	// private static 
	char* const Controller::_shutdownmodes[] = {__SMART_SHUTDOWN, __FAST_SHUTDOWN, __IMMEDIATE_SHUTDOWN};
#else
	extern HINSTANCE TheInstance;
	extern Controller* control;
	extern ConsoleRedirector ConsolePostmaster;
	// profile settings
	extern ProfileReader Prf;
#endif //
//------------------------------------------------------------------------------
#endif // ifndef _MAIN_H_INCLUDED
//------------------------------------------------------------------------------
