/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS ReportAppearance v 0.1
* Esta clase se encarga de mostrar la ventana donde el usuario      
* define la apariencia personalizada de su reporte.                
*                                                                 
* Los objetos de este tipo se crean desde la clase ReportDesigner      
*                                                               
* Fecha: 2001/07/31                                            
* Autores: Beatriz Florin  - bettyflor@kazak.ws             
*          Gustavo Gonzalez - xtingray@kazak.ws
*
*/

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ReportAppearance extends JDialog implements ActionListener{ 
 JFrame frame;
 String enkabezado = "";
 String Cola = "";
 JPanel pColor;
 JPanel bColorP;
 JPanel FCColor;
 JPanel BCColor;
 JCheckBox border;
 JTextField cp;
 JTextField sp;
 JComboBox Fstyle;
 JComboBox Fsize;
 JComboBox Fstyle2;
 JComboBox Fsize2;
 boolean wellDone = false;
 String HTFSettings = "";
 String CTFSettings = "";
 String HTBC = "#FFFFFF";
 String HTFC = "#000000";
 String CTBC = "#FFFFFF";
 String CTFC = "#000000";
 HtmlProperties htmlInfo;
 String RGB[] = new String[256];
 Language idiom;

 public ReportAppearance(JDialog extern, JFrame aframe, Language lang) 
  {
  super(extern,true);
  String[] hex = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
  int k=0;                        

  for (int i = 0; i < 16; i++) 
   {
    for (int j = 0; j < 16; j++) 
     {
      RGB[k] = hex[i] + hex[j];
         k++;
     }
   }

  idiom = lang;
  frame = aframe;
  setTitle(idiom.getWord("REPAPP"));
  Border etched1 = BorderFactory.createEtchedBorder();
  TitledBorder title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("GENSETT"));
  getContentPane().setLayout(new BorderLayout());
  JButton butH = new JButton(idiom.getWord("HEADER"));
  butH.setActionCommand("ButtonHeader");
  butH.addActionListener(this);
  JButton butF = new JButton(idiom.getWord("FOOTER")); 
  butF.setActionCommand("ButtonFooter");
  butF.addActionListener(this);
  JPanel botons = new JPanel();
  botons.setLayout(new FlowLayout(FlowLayout.CENTER));
  botons.add(butH);
  botons.add(butF);
  botons.setBorder(title1);

  JPanel table = new JPanel();
  table.setLayout(new BoxLayout(table,BoxLayout.Y_AXIS));
  title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("DATSETT"));
  table.setBorder(title1);
  JPanel struct = new JPanel();
  struct.setLayout(new FlowLayout(FlowLayout.CENTER));
  border = new JCheckBox(idiom.getWord("UBR"));
  JLabel cellpading = new JLabel(idiom.getWord("CELLPAD")+":");
  cp = new JTextField(2);
  JLabel cellspacing = new JLabel(" "+idiom.getWord("CELLSPA")+":");
  sp = new JTextField(2); 
  struct.setLayout(new FlowLayout(FlowLayout.CENTER));
  struct.add(border);
  struct.add(cellpading);
  struct.add(cp);
  struct.add(cellspacing);
  struct.add(sp);

  JPanel tableHeader = new JPanel();
  tableHeader.setLayout(new BorderLayout());

  title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("TABLEH"));
  tableHeader.setBorder(title1);

  JPanel FontPanel = new JPanel();
  FontPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
 
  String[] values = {"Arial","Arial Black","Arial Narrow","Book Antiqua","Bookman Old Style","Calixto MT","Century Gothic","Comic Sans MS","Copperplate Gothic Bold","Copperplate Gothic Light","Courier New","Garamond","Helvetica","Impact","Lucida Console","Lucida Handwriting","Lucida Sans","Lucida Sans Unicode","Map Symbols","Marlett","Matisse ITC","Monotype Sorts","MS Outlook","MT Extra","News Gothic MT","OCR A Extended","Symbol","Tahoma","Tempus Sans ITC","Times New Roman","Verdana","Webdings","Westminster","Wingdings"};
  JLabel style = new JLabel(idiom.getWord("STYLE")+":");
  Fstyle = new JComboBox(values);
  JLabel size = new JLabel(" "+idiom.getWord("LONGTYPE")+":");
  String[] values1 = {"1","2","3","4","5","6"};
  Fsize = new JComboBox(values1);
  JButton Fcolor = new JButton(idiom.getWord("FCOLOR"));
  Fcolor.setActionCommand("FCOLOR");
  Fcolor.addActionListener(this);

  pColor = new JPanel();
  pColor.setPreferredSize(new Dimension(15,15));
  pColor.setBackground(Color.black);
  title1 = BorderFactory.createTitledBorder(etched1);
  pColor.setBorder(title1);
  title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("FSETT"));
  FontPanel.setBorder(title1);
 
  FontPanel.add(style);
  FontPanel.add(Fstyle);
  FontPanel.add(size);
  FontPanel.add(Fsize);
  FontPanel.add(Fcolor);
  FontPanel.add(pColor);

  JPanel bc = new JPanel();
  bc.setLayout(new FlowLayout(FlowLayout.CENTER));
  JButton bcolor = new JButton(idiom.getWord("BACKCOLOR")); 
  bcolor.setActionCommand("BCOLOR");
  bcolor.addActionListener(this);
  bColorP = new JPanel();
  bColorP.setPreferredSize(new Dimension(15,15));
  bColorP.setBackground(Color.white);
  title1 = BorderFactory.createTitledBorder(etched1);
  bColorP.setBorder(title1);

  bc.add(bcolor,BorderLayout.CENTER);
  bc.add(bColorP,BorderLayout.EAST);

  tableHeader.add(FontPanel,BorderLayout.CENTER);
  tableHeader.add(bc,BorderLayout.SOUTH);

  JPanel cells = new JPanel();
  cells.setLayout(new BorderLayout());
  title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("CELLS"));
  cells.setBorder(title1);

  FontPanel = new JPanel();
  FontPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
 
  style = new JLabel(idiom.getWord("STYLE")+":");
  Fstyle2 = new JComboBox(values);
  size = new JLabel(" "+idiom.getWord("LONGTYPE")+":");
  Fsize2 = new JComboBox(values1);
  Fcolor = new JButton(idiom.getWord("FCOLOR"));
  Fcolor.setActionCommand("CFCOLOR");
  Fcolor.addActionListener(this);

  FCColor = new JPanel();
  FCColor.setPreferredSize(new Dimension(15,15));
  FCColor.setBackground(Color.black);
  title1 = BorderFactory.createTitledBorder(etched1);
  FCColor.setBorder(title1);

  title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("FSETT"));
  FontPanel.setBorder(title1);
 
  FontPanel.add(style);
  FontPanel.add(Fstyle2);
  FontPanel.add(size);
  FontPanel.add(Fsize2);
  FontPanel.add(Fcolor);
  FontPanel.add(FCColor);

  cells.add(FontPanel,BorderLayout.NORTH);
  JPanel bx = new JPanel();
  bx.setLayout(new FlowLayout(FlowLayout.CENTER));
  JButton colB = new JButton(idiom.getWord("BACKCOLOR"));
  colB.setActionCommand("BCCOLOR");
  colB.addActionListener(this);

  BCColor = new JPanel();
  BCColor.setPreferredSize(new Dimension(15,15));
  BCColor.setBackground(Color.white);
  title1 = BorderFactory.createTitledBorder(etched1);
  BCColor.setBorder(title1);

  bx.add(colB);
  bx.add(BCColor);

  cells.add(FontPanel,BorderLayout.NORTH);
  cells.add(bx,BorderLayout.CENTER);

  table.add(botons);
  table.add(struct);
  table.add(tableHeader);
  table.add(cells);

  JButton ok = new JButton(idiom.getWord("OK"));
  ok.setActionCommand("ButtonOk");
  ok.addActionListener(this);
  JButton cancel = new JButton(idiom.getWord("CANCEL"));
  cancel.setActionCommand("ButtonCancel");
  cancel.addActionListener(this);
  JPanel botonD = new JPanel();
  botonD.setLayout(new FlowLayout(FlowLayout.CENTER));
  botonD.add(ok);
  botonD.add(cancel);

  getContentPane().add(botons,BorderLayout.NORTH);
  getContentPane().add(table,BorderLayout.CENTER);
  getContentPane().add(botonD,BorderLayout.SOUTH);
  pack();
  setLocationRelativeTo(frame);
  setVisible(true);
 }

 public void actionPerformed(java.awt.event.ActionEvent e) 
  {

  if(e.getActionCommand().equals("BCCOLOR"))
   {
   Color newColor = JColorChooser.showDialog(ReportAppearance.this,idiom.getWord("CCBC"),Color.white);
   if (newColor != null) 
     {
       BCColor.setBackground(newColor);
       CTBC = SetColor(newColor.getRed(),newColor.getGreen(),newColor.getBlue());
     }
   }

  if(e.getActionCommand().equals("CFCOLOR"))
   {
   Color newColor = JColorChooser.showDialog(ReportAppearance.this,idiom.getWord("CCTC"),Color.white);
   if (newColor != null) 
     {
       FCColor.setBackground(newColor);
       CTFC = SetColor(newColor.getRed(),newColor.getGreen(),newColor.getBlue());
     }
   } 

  if(e.getActionCommand().equals("BCOLOR"))
   {
   Color newColor = JColorChooser.showDialog(ReportAppearance.this,
					  idiom.getWord("CBC"),
                                          Color.white);
   if (newColor != null) 
     {
       bColorP.setBackground(newColor);
       HTBC = SetColor(newColor.getRed(),newColor.getGreen(),newColor.getBlue());
     }
   } 

  if(e.getActionCommand().equals("FCOLOR"))
   {
   Color newColor = JColorChooser.showDialog(ReportAppearance.this,
					  idiom.getWord("CTC"),
                                          Color.white);
   if (newColor != null) 
     {
       pColor.setBackground(newColor);
       HTFC = SetColor(newColor.getRed(),newColor.getGreen(),newColor.getBlue());
     }
   }

  if(e.getActionCommand().equals("ButtonHeader"))
   {
   ReportHeader ht = new ReportHeader(ReportAppearance.this,frame,idiom);
   if(ht.isWell)
     enkabezado = ht.cab;
   }

  if(e.getActionCommand().equals("ButtonFooter"))
   {
   ReportFooter ft = new ReportFooter(idiom,ReportAppearance.this,frame);
   if(ft.wellDone)
     Cola = ft.Cola; 
   }

  if(e.getActionCommand().equals("ButtonOk"))
   {   
   String HeaderT = "<table border=";

   if(border.isSelected())
     HeaderT += "1 ";
   else
     HeaderT += "0 "; 

   String CellPadding = cp.getText();
   if(CellPadding.length()>0)     
    {
     if(isNum(CellPadding))
        HeaderT += "cellpadding=" + CellPadding;
     else
      {
       JOptionPane.showMessageDialog(ReportAppearance.this,
                                  idiom.getWord("CPDNG"),
                                  idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
       return;
      }
    }
     
   String SpacePadding = sp.getText();
   if(SpacePadding.length()>0)     
    {
     if(isNum(SpacePadding))
       HeaderT += "cellspacing=" + SpacePadding;
     else
      {
       JOptionPane.showMessageDialog(ReportAppearance.this,
                                  idiom.getWord("CSCNG"),
                                  idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);

       return;
      }
    }

   HeaderT += ">";

   String fontSt = (String) Fstyle.getSelectedItem();
   String fontFs = (String) Fsize.getSelectedItem();

   HTFSettings = "<font face=\"" + fontSt + "\" size=" + fontFs + " color=\"" + HTFC + "\">";

   String fontSt2 = (String) Fstyle2.getSelectedItem();
   String fontFs2 = (String) Fsize2.getSelectedItem();

   CTFSettings = "<font face=\"" + fontSt2 + "\" size=" + fontFs2 + " color=\"" + CTFC + "\">";

   htmlInfo = new HtmlProperties(HTFSettings,CTFSettings,HeaderT,HTBC,CTBC,enkabezado,Cola);

   wellDone = true;
   setVisible(false);
   }  

  if(e.getActionCommand().equals("ButtonCancel"))
   {
   setVisible(false);
   }
 }

 public String SetColor(int red,int green,int blue) 
  {
   return "#" + RGB[red] + RGB[green] + RGB[blue];
  }

 public boolean isNum(String s)
  {
    for(int i = 0; i < s.length(); i++)
     {
      char c = s.charAt(i);
      if(!Character.isDigit(c))
          return false;
     }

    return true;
  }

} //Fin de la Clase
