/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2002
*
* CLASS DisplayControl v 0.1                                                   
* Descripcion:
* Esta clase se encarga de mostrar la lista de atributos de una 
* tabla, para que el usuario escoja cuales de ellos desea visualizar.
*
* Esta clase es instanciada desde la clase Records.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;
import java.util.StringTokenizer;

public class DisplayControl extends JDialog implements ActionListener {

 Table myTable;
 Hashtable checkFields = new Hashtable();
 JButton clear;
 int numFields;
 Language idiom;
 boolean selected = true;
 Vector fields; 
 String filter = ""; 
 JCheckBox keepCBox;
 boolean keepIt = false;
 boolean wellDone = false;

 public DisplayControl(Table table,JFrame parent,Language leng, String nameFields, boolean keepOn) 
  {
   super(parent, true);
   idiom = leng;
   setTitle(idiom.getWord("DSPLY"));
   myTable = table;

   Hashtable previewFields = new Hashtable(); 

   if (!nameFields.equals("\"oid\",*")) {

        StringTokenizer st = new StringTokenizer(nameFields,",");

        while (st.hasMoreTokens()) {

               String field = st.nextToken();

               if (!field.equals("oid")) 
                   previewFields.put(field,field);
         }
    }

   JPanel global = new JPanel();
   global.setLayout(new BoxLayout(global,BoxLayout.Y_AXIS));

   JPanel base = new JPanel();
   base.setLayout(new GridLayout(0,1));

   numFields = myTable.getTableHeader().getNumFields();
   Hashtable hashFields = myTable.getTableHeader().getHashtable();

   fields = myTable.getTableHeader().getNameFields();

   for (int i=0; i<numFields ;i++) {

        String nfield = (String) fields.elementAt(i);

        JCheckBox check = new JCheckBox(nfield);
        checkFields.put("" + i,check);
        base.add(check);

        if (previewFields.containsKey("\"" + nfield + "\"")) 
            check.setSelected(true);

    } // fin for

   JPanel center = new JPanel();
   center.setLayout(new BorderLayout());
   center.add(base,BorderLayout.WEST);

   JPanel up = new JPanel();
   up.setLayout(new FlowLayout(FlowLayout.CENTER));
   up.add(center);

   Border etched1 = BorderFactory.createEtchedBorder();
   TitledBorder title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("VFIELDS"));
   up.setBorder(title1);

   JButton ok = new JButton(idiom.getWord("OK"));
   ok.setActionCommand("OK");
   ok.addActionListener(this);

   clear = new JButton(idiom.getWord("SELALL"));
   clear.setActionCommand("SELECTION");
   clear.addActionListener(this);

   JButton cancel = new JButton(idiom.getWord("CANCEL"));
   cancel.setActionCommand("CANCEL");
   cancel.addActionListener(this);

   JPanel botons = new JPanel();
   botons.setLayout(new FlowLayout(FlowLayout.CENTER));
   botons.add(ok);
   botons.add(clear);
   botons.add(cancel);

   if(numFields > 15)
    {
     JScrollPane scroll = new JScrollPane(up);
     scroll.setPreferredSize(new Dimension(400,400));
     global.add(scroll);
    }
   else
     global.add(up);

   JPanel keep = new JPanel();
   keepCBox = new JCheckBox(idiom.getWord("KSDS"));

   if (keepOn)
       keepCBox.setSelected(true);

   keep.add(keepCBox);
   global.add(keep);

   global.add(botons);

   getContentPane().add(global);
   pack();
   setLocationRelativeTo(parent);
   setVisible(true);
 }

 public void actionPerformed(java.awt.event.ActionEvent e) {

  if (e.getActionCommand().equals("OK")) {

     for (int k=0;k<numFields;k++) { 

       JCheckBox chTmp = (JCheckBox) checkFields.get("" + k);
       if (chTmp.isSelected()) {
           String nf = (String) fields.elementAt(k);
           nf = "\"" + nf + "\""; 
           filter += nf + ",";
        }
        
     } // fin for

     if (filter.length() > 0)
         filter = filter.substring(0,filter.length()-1);

     if (keepCBox.isSelected()) {
         keepIt = true;
       
         if (filter.length() == 0) {

             JOptionPane.showMessageDialog(DisplayControl.this,
             idiom.getWord("ALOF"),
             idiom.getWord("ERROR!"), JOptionPane.ERROR_MESSAGE);

             return; 
          }
     }

     wellDone = true; 
     setVisible(false);
     return; 
   }

  if (e.getActionCommand().equals("SELECTION")) {

      for (int k=0;k<numFields;k++) {
           JCheckBox chTmp = (JCheckBox) checkFields.get("" + k);
           chTmp.setSelected(selected);
       } // fin for

     if(selected){
        selected = false;
        clear.setText(idiom.getWord("UNSELALL"));
      }
     else {
        selected = true;
        clear.setText(idiom.getWord("SELALL"));
      }

     return;
   }

  if (e.getActionCommand().equals("CANCEL")) {
      setVisible(false);
      return;
   }

 } // fin del Metodo

 public String getFilter() {
   return filter;
  }

 public boolean isKeepIt() {
   return keepIt;
  }

 public boolean isWellDone() {
   return wellDone;
  }

} //Fin de Clase
