/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS Records v 0.1                                                   
* Descripcion:
* Esta clase se encarga de manejar el panel de Registros
* en la interfaz principal. A traves de este panel, se
* pueden realizar operaciones como ingresar, modificar y
* eliminar registros de una tabla.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*          Angela Sandobal  - angesand@libertad.univalle.edu.co     
*/

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.event.*;
import java.util.Vector;
import javax.swing.table.*;
import java.net.URL;
import java.io.*;
import java.util.StringTokenizer;
import javax.swing.border.*;
import java.util.Hashtable;

public class Records extends JPanel implements ActionListener,SwingConstants,KeyListener,FocusListener {

 JToolBar StructureBar;
 JScrollPane tablaScroll;
 JPanel General;
 Language idiom;
 JTextField title;
 JScrollPane windowX;
 JPanel firstPanel;
 JPanel base;
 JButton insertRecord,delRecord,updateRecord,exportFile,reportBut;
 JCheckBox rectangle,rectangle2;
 JComboBox combo1,combo2;
 JTextField combo3,numRegTextField,limitText; 
 JLabel men1,men2;
 JButton button,advanced;
 JTable table;
 JPanel up;
 boolean firstBool = true;
 JFrame frame;
 String currentTable = "";
 String operator = "";
 String field = "";
 Table tableStruct;
 PGConnection connReg;
 final JPopupMenu popup = new JPopupMenu();
 String sentence;
 int numReg = 0;
 String firstField;
 String recordFilter = "\"oid\"," + "*";
 Hashtable hashRecordFilter = new Hashtable();
 Hashtable hashDB = new Hashtable();
 MyTableModel myModel;

 Vector columns = new Vector();
 Vector dataRecords = new Vector(); 
 Vector columnNamesVector = new Vector();

 Object[] columnNames;
 Object[][] data;

 JTextArea LogWin;

 /******************** METODO CONSTRUCTOR ********************/
 public Records (Language glossary,JFrame xframe,JTextArea log) {

  frame = xframe;
  idiom = glossary;
  LogWin = log;
  setLayout(new BorderLayout());
  StructureBar = new JToolBar(SwingConstants.VERTICAL);
  StructureBar.setFloatable(false);
  CreateToolBar();

  title = new JTextField("");
  title.setHorizontalAlignment(JTextField.CENTER);
  title.setEditable(false);

  JPanel top = new JPanel();
  top.setLayout(new BorderLayout());
  top.add(title);

  Border etched1 = BorderFactory.createEtchedBorder();
  TitledBorder title1 = BorderFactory.createTitledBorder(etched1);

  top.setBorder(title1);

  add(top,BorderLayout.NORTH); 

  setLabel("","",0,"");
  showQueryResult(new Vector(),new Vector());
  add(StructureBar,BorderLayout.WEST);
  pieDatos();
  add(firstPanel,BorderLayout.SOUTH);
  setSize(500,500);
}

/******************** METODO Filter() : Panel Filtro de Inf. ********************/

public void Filter() {
  base = new JPanel();
  base.setLayout(new BoxLayout(base, BoxLayout.Y_AXIS));
  JPanel row1 = new JPanel();
  row1.setLayout(new FlowLayout(FlowLayout.LEFT));
  JPanel row2 = new JPanel();
  row2.setLayout(new FlowLayout(FlowLayout.LEFT));
  CheckBoxListener myListener = new CheckBoxListener();
  String[] datmp = {""};
  String[] ig = {"=","!=","<",">","<=",">=","like","not like","~","~*","!~","!~*"};
  rectangle = new JCheckBox(idiom.getWord("FILTER")+":");
  rectangle.setMnemonic('F'); 
  rectangle.addItemListener(myListener);

  rectangle2 = new JCheckBox(idiom.getWord("LIMIT")+":");
  rectangle2.setMnemonic('L'); 
  rectangle2.addItemListener(myListener);

  combo1 = new JComboBox(datmp);
  combo2 = new JComboBox(ig);
  combo3 = new JTextField(10);

  combo1.setActionCommand("COMBO1");
  combo1.addActionListener(this);
  combo2.setActionCommand("COMBO2");
  combo2.addActionListener(this);

  JPanel space = new JPanel();

  advanced = new JButton(idiom.getWord("OPC"));
  advanced.setActionCommand("Options");
  advanced.addActionListener(this);

  JMenuItem Item = new JMenuItem(idiom.getWord("DSPLY"));
  Item.setActionCommand("DISPLAY");
  Item.addActionListener(this);
  popup.add(Item);

  Item = new JMenuItem(idiom.getWord("ADF")); 
  Item.setActionCommand("ADVANCED");
  Item.addActionListener(this);
  popup.add(Item);

  Item = new JMenuItem(idiom.getWord("CUF")); 
  Item.setActionCommand("CUSTOMIZE");
  Item.addActionListener(this);
  popup.add(Item);

  MouseListener mouseListener = new MouseAdapter() {
	public void mousePressed(MouseEvent e) {
         if (!popup.isVisible() && advanced.isEnabled())
               popup.show(advanced,90,0);
 					       }
  };
  advanced.addMouseListener(mouseListener);

  button = new JButton(idiom.getWord("UPDT"));
  button.setActionCommand("BOTON");
  button.addActionListener(this);

  JPanel row0 = new JPanel();
  row0.setLayout(new FlowLayout(FlowLayout.CENTER));
  row0.add(button);
  row0.add(advanced);

  row1.add(rectangle); 
  row1.add(combo1);
  row1.add(combo2);
  row1.add(combo3);
  row1.add(space);

  numRegTextField = new JTextField(7);
  men1 = new JLabel(idiom.getWord("STARTR")+":"); 
  limitText = new JTextField(7);
  men2 = new JLabel(idiom.getWord("LRW"));

  row2.add(rectangle2);
  row2.add(men1);
  row2.add(numRegTextField);
  row2.add(men2);
  row2.add(limitText);

  setRow1(false);
  setRow2(false);

  JPanel right = new JPanel();
  right.setLayout(new BorderLayout());
  right.add(row2,BorderLayout.WEST);

  JPanel groupPanel = new JPanel();
  groupPanel.setLayout(new BoxLayout(groupPanel, BoxLayout.Y_AXIS));
  groupPanel.add(row1);
  groupPanel.add(right);

  Border etched1 = BorderFactory.createEtchedBorder();
  TitledBorder title1 = BorderFactory.createTitledBorder(etched1);

  groupPanel.setBorder(title1);

  base.add(row0);
  base.add(groupPanel); 
}

/******************** METODO pieDatos() : Texto de Operacion ********************/
public void pieDatos() {
   firstPanel = new JPanel();
   firstPanel.setLayout(new BorderLayout());
   Filter();
   firstPanel.add(base,BorderLayout.CENTER);
}

/******************** METODO CreateToolBar() : Crea Barra de Iconos ********************/
public void CreateToolBar() {
 
  URL imgURL = getClass().getResource("icons/16_InsertRecord.png"); 
  insertRecord = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  insertRecord.setActionCommand("INSERT-RECORD");
  insertRecord.addActionListener(this);
  insertRecord.setToolTipText(idiom.getWord("INSREC"));
  StructureBar.add(insertRecord);

  imgURL = getClass().getResource("icons/16_DelRecord.png");
  delRecord = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  delRecord.setActionCommand("DELETE-RECORD");
  delRecord.addActionListener(this);
  delRecord.setToolTipText(idiom.getWord("DELREC"));
  delRecord.setEnabled(false);
  StructureBar.add(delRecord);

  imgURL = getClass().getResource("icons/16_UpdateRecord.png");
  updateRecord = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  updateRecord.setActionCommand("UPDATE-RECORD");
  updateRecord.addActionListener(this);
  updateRecord.setToolTipText(idiom.getWord("UPDREC"));
  updateRecord.setEnabled(false);
  StructureBar.add(updateRecord);

  imgURL = getClass().getResource("icons/16_ExportFile.png");
  exportFile = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  exportFile.setActionCommand("EXPORT-TO-FILE");
  exportFile.addActionListener(this);
  exportFile.setToolTipText(idiom.getWord("EXPORTAB") + "/" + idiom.getWord("ITT"));
  exportFile.setEnabled(false);
  StructureBar.add(exportFile);

  imgURL = getClass().getResource("icons/16_NewTable.png");
  reportBut = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  reportBut.setActionCommand("EXPORT-REPORT");
  reportBut.addActionListener(this);
  reportBut.setToolTipText(idiom.getWord("EXPORREP"));
  reportBut.setEnabled(false);
  StructureBar.add(reportBut);
    
}

/******************** METODO actionPerformed() : Manejador de Eventos ********************/
public void actionPerformed(java.awt.event.ActionEvent e) {


if (e.getActionCommand().equals("UPDATE-POP")) {

    updatingRecords();
    return;
 }

if (e.getActionCommand().equals("DELETE-POP")) {

    dropRecords();
    return;
 }

if (e.getActionCommand().equals("INSERT-RECORD")) {

    insertRecords();
    return;
 }
    
 if (e.getActionCommand().equals("DELETE-RECORD") ) {

    table.clearSelection();
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

    DropTableRecord Eraser = new DropTableRecord(tableStruct,frame,idiom);
    Eraser.setLocationRelativeTo(frame);
    Eraser.setVisible(true);

    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

    if(Eraser.isWellDone())
     {
      addTextLogMonitor(idiom.getWord("EXEC")+ Eraser.getSQL() + "\"");
      String result = connReg.SQL_Instruction(Eraser.getSQL());
      if(result.equals("OK")) {
        Vector res = connReg.TableQuery("SELECT " + recordFilter + " FROM \"" + tableStruct.getName() + "\" ORDER BY oid");
        Vector col = connReg.getTableHeader();
        numReg = res.size();
        if(!connReg.queryFail()) 
          {
           String owner = connReg.getOwner(tableStruct.getName());
           setLabel(connReg.getDBname(),tableStruct.getName(),numReg,owner);
           showQueryResult(res,col);
           if(numReg==0)
            {
             rectangle.setEnabled(false);
             rectangle2.setEnabled(false);
             advanced.setEnabled(false);
            }
           updateUI(); 
          }    
     }
      else
        {          
     	 result = result.substring(0,result.length()-1);
         ErrorDialog showError = new ErrorDialog(new JDialog(),connReg.getErrorMessage(),idiom);
         showError.pack();
         showError.setLocationRelativeTo(frame);

         showError.show();
        }
        addTextLogMonitor(idiom.getWord("RES") + result);
    }

   return;
 }

 if (e.getActionCommand().equals("UPDATE-RECORD") ) {

    table.clearSelection();
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    UpdateTable upper = new UpdateTable(tableStruct,frame,idiom);
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

    if (upper.getResult()) {

      addTextLogMonitor(idiom.getWord("EXEC")+ upper.getUpdate() + "\"");
      String result = connReg.SQL_Instruction(upper.getUpdate());

      if (result.equals("OK")) {

          Vector res = connReg.TableQuery("SELECT " + recordFilter + " FROM \"" + tableStruct.getName() + "\" ORDER BY oid");
          Vector col = connReg.getTableHeader();
          if (!connReg.queryFail()) {
              showQueryResult(res,col);
              updateUI(); 
           }    
       }
      else {
            result = result.substring(0,result.length()-1);
            ErrorDialog showError = new ErrorDialog(new JDialog(),connReg.getErrorMessage(),idiom);
            showError.pack();
            showError.setLocationRelativeTo(frame);

            showError.show();
       }
      addTextLogMonitor(idiom.getWord("RES") + result);
    }

   return;
 }

 if(e.getActionCommand().equals("EXPORT-TO-FILE") )
  {
   ExportToFile dialog = new ExportToFile(frame,currentTable,connReg,idiom,numReg);
   dialog.pack();
   dialog.setLocationRelativeTo(frame);
   dialog.setVisible(true);
   int option = 0;

   if(dialog.isWellDone())
    {
     option = dialog.getOption();
     String s = "file:" + System.getProperty("user.dir");
     File file;
     boolean Rewrite = true;
     String FileName = "";
     int returnVal;
     JFileChooser fc;

     switch(option)
      {
       case 1: 
              fc = new JFileChooser(s);

              returnVal = fc.showDialog(frame,idiom.getWord("EXPORTAB"));

              if (returnVal == JFileChooser.APPROVE_OPTION) 
                {
                  file = fc.getSelectedFile();
                  FileName = file.getAbsolutePath(); // Camino Absoluto

                  if(file.exists())
                     {
                       BoolOption win = new BoolOption(frame,idiom.getWord("YES"),idiom.getWord("NO"),idiom.getWord("ADV"),
                       idiom.getWord("FILE") + " \"" + FileName + "\" " + idiom.getWord("SEQEXIS2") + " " +
idiom.getWord("OVWR"));
                       /* win.pack();
                       win.setLocationRelativeTo(frame);
                       win.show(); */
                       Rewrite = win.getSelecction();
                     }
                  if(Rewrite)
                     {
                       try
                          {
                           ExportSeparatorField little = new ExportSeparatorField(frame,idiom);
                           little.setSize(260,150);
                           little.pack();
                           little.setLocationRelativeTo(frame);
                           little.show();

                           if(little.isDone())
                            {
                              String limiter = little.getLimiter();
                              PrintStream saveFile = new PrintStream(new FileOutputStream(FileName));
                              String sentence = "SELECT * FROM \"" + currentTable + "\" ORDER BY oid";
                              Vector resultGlobal = connReg.TableQuery(sentence);
                              Vector columnNamesG = connReg.getTableHeader();
                              String val = "OK";

                              if(connReg.queryFail())
                                {
                                 val = connReg.problem;
                                 val = val.substring(0,val.length()-1);
                                }

                              addTextLogMonitor(idiom.getWord("EXEC") + sentence + "\"");
                              addTextLogMonitor(idiom.getWord("RES") + val);
                              printFile(saveFile,resultGlobal,columnNamesG,limiter);
                            }

                          }
                       catch(Exception ex) { }
                     } // fin if
                 } // fin if 
             return;

       case 2:
              fc = new JFileChooser(s);

              returnVal = fc.showDialog(frame,idiom.getWord("LFILE"));

              if (returnVal == JFileChooser.APPROVE_OPTION)
                {
                  file = fc.getSelectedFile();
                  FileName = file.getAbsolutePath(); // Camino Absoluto

                  ImportSeparatorField little = new ImportSeparatorField(frame,idiom);
                  little.pack();
                  little.setLocationRelativeTo(frame);
                  little.show();

                  if(little.isDone())
                   {
                    String limiter = little.getLimiter();
                    try
                     {
                      BufferedReader in = new BufferedReader(new FileReader(file));
                      String firstReg = in.readLine(); 
                      Vector data = new Vector();
                      int index = firstReg.indexOf(limiter);
                      if(index != -1)
                        {
                          StringTokenizer filter = new StringTokenizer(firstReg,limiter);
                          int i = 0;
                          Vector tuple = new Vector();

                          while (filter.hasMoreTokens()) 
                           {
                             i++;
                             String tmp = filter.nextToken();
                             tuple.addElement(tmp);
                           } 

                          int k = tableStruct.getTableHeader().getNumFields();

                          if(i == k)
                           {
                            data.addElement(tuple); 
                            while(true)
                             {
                              String line = in.readLine();
                              if (line == null) 
                                  break;

                              StringTokenizer filterFile = new StringTokenizer(line,limiter);
                              int counter = 0;
                              tuple = new Vector();

                              while (filterFile.hasMoreTokens())
                               {
                                counter += 1;
                                String tmp = filterFile.nextToken();
                                tuple.addElement(tmp);
                               }

                              data.addElement(tuple);
                             }

                            BuildSQLRecords(currentTable,tableStruct.getTableHeader(),data);
                           }
                          else
                           {
                            JOptionPane.showMessageDialog(new JDialog(),
                            idiom.getWord("NCNNA"),
                            idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
                            return;
                           }
                        } 
                      else
                        {
                         JOptionPane.showMessageDialog(new JDialog(),
                         idiom.getWord("SEPNF"),
                         idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
                         return;
                        }
                     } 
                    catch(Exception ex)
                     { 
                      System.out.println("Error" + ex);
                     }
                   }
                }
       return;
       default:
      }
    }

   return;
  }

 if(e.getActionCommand().equals("EXPORT-REPORT") )
  {
   ReportDesigner format = new ReportDesigner(frame,columns,dataRecords,idiom,LogWin,currentTable,connReg);
   return;
  }

 if(e.getActionCommand().equals("COMBO1"))
  {
    JComboBox cb = (JComboBox)e.getSource();
    int pos = cb.getSelectedIndex();

    if(pos < 0)
       pos = 0;
 
    field = (String) columnNamesVector.elementAt(pos);

    if(field == null)
     {
      field = firstField; 
      pos = columnNamesVector.indexOf(firstField);
      cb.setSelectedIndex(pos);
     }

   return;
  } 

 if(e.getActionCommand().equals("COMBO2"))	
  {
    JComboBox cb = (JComboBox)e.getSource();
    operator = (String) cb.getSelectedItem();

   return;
  }

 if(e.getActionCommand().equals("DISPLAY"))
  {
    boolean keepOn = false;
    Hashtable hashTmp = new Hashtable();

    if (hashDB.containsKey(connReg.getDBname())) {

        hashTmp = (Hashtable) hashDB.get(connReg.getDBname());

        if (hashTmp.containsKey(currentTable)) { 
            keepOn = true;
            recordFilter = "\"oid\"," + (String) hashTmp.get(currentTable); 
         }
        else 
            recordFilter = "\"oid\"," + "*";
     }
    else 
      recordFilter = "\"oid\"," + "*";

    if (rectangle2.isSelected())
        rectangle2.setSelected(false);

    if (rectangle.isSelected())
        rectangle.setSelected(false);

    DisplayControl regListPanel = new DisplayControl(tableStruct,frame,idiom,recordFilter,keepOn);

    if (regListPanel.isWellDone()) {

        recordFilter = regListPanel.getFilter();

        hashTmp.remove(currentTable);
        hashDB.remove(connReg.getDBname());

        if (recordFilter.length() == 0) {
            recordFilter = "\"oid\"," + "*";
            hashDB.put(connReg.getDBname(),hashTmp);
         }
        else {
               recordFilter = "\"oid\"," + recordFilter;

               if (regListPanel.isKeepIt()) { 

                   hashTmp.put(currentTable,recordFilter);
                   hashDB.put(connReg.getDBname(),hashTmp);
                }
               else
                   hashDB.put(connReg.getDBname(),hashTmp);

               refreshTable();
         }
        
    }

    return;
  }

 if(e.getActionCommand().equals("ADVANCED"))
  {
    if (rectangle2.isSelected())
        rectangle2.setSelected(false);

    if (rectangle.isSelected())
        rectangle.setSelected(false);

    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    AdvancedFilter button = new AdvancedFilter(tableStruct,frame,idiom);
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
    if(button.getResult())
     {
      Vector res = connReg.TableQuery(button.getSelect());
      Vector col = connReg.getTableHeader();
      addTextLogMonitor(idiom.getWord("EXEC") + button.getSelect() + ";\"");
      String str = "OK";
      if(!connReg.queryFail()) 
         {
          showQueryResult(res,col);
          updateUI(); 
         }
      else 
          {
          str = connReg.getProblemString().substring(0,connReg.getProblemString().length()-1);
          ErrorDialog showError = new ErrorDialog(new JDialog(),connReg.getErrorMessage(),idiom);
          showError.pack();
          showError.setLocationRelativeTo(frame);

          showError.show();
          }     
      addTextLogMonitor(idiom.getWord("RES") + str);
     }

   return;
 } 

 if(e.getActionCommand().equals("CUSTOMIZE"))
  {
    if (rectangle2.isSelected())
        rectangle2.setSelected(false);

    if (rectangle.isSelected())
        rectangle.setSelected(false);

    CustomizeFilter custim = new CustomizeFilter(tableStruct,frame,idiom);
    if(custim.wellDone)
     {
      Vector res = connReg.TableQuery(custim.select);
      Vector col = connReg.getTableHeader();
      String str = "OK";
      addTextLogMonitor(idiom.getWord("EXEC") + custim.select + "\"");
      if(!connReg.queryFail()) 
         {
          showQueryResult(res,col);
          updateUI(); 
         }    
      else
        {
          str = connReg.problem.substring(0,connReg.problem.length()-1);
          ErrorDialog showError = new ErrorDialog(new JDialog(),connReg.getErrorMessage(), idiom);
          showError.pack();
          showError.setLocationRelativeTo(Records.this);
          showError.show();
        }

      addTextLogMonitor(idiom.getWord("RES") + str);
     }

   return;
  }

 if(e.getActionCommand().equals("BOTON"))
  {
    sentence = "SELECT " + recordFilter + " FROM \"" + currentTable + "\" ORDER BY oid";

    if(rectangle.isSelected()) 
     {
        String var = combo3.getText();

        if(var.length()==0) 
          {
              JOptionPane.showMessageDialog(frame,                               
              idiom.getWord("ERRFIL"),                       
              idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
              return;
          }
        else 
          {
            if (!field.equals("oid")) {
                String type = tableStruct.getTableHeader().getType(field);
                int code = getTypeCode(type);

                switch (code) {
                        case 1:
                                if (!var.startsWith("'"))
                                    var = "'" + var;

                                if (!var.endsWith("'"))
                                    var = var + "'";

                                combo3.setText(var);
                                break;
                        case 2:
                                if (!isNum(var)) {
                                    JOptionPane.showMessageDialog(frame,
                                    idiom.getWord("FINTIV"),
                                    idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
                                    return;
                                 }
                                break;
                        case 3:
                                var = var.toLowerCase();
                                if (!var.equals("true") && !var.equals("false")) {
                                    JOptionPane.showMessageDialog(frame,
                                    idiom.getWord("IBT"),
                                    idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
                                    return;
                                 }
                 } // fin switch
             } // fin if

            sentence += " WHERE \"" + field + "\" " + operator + " " + var;
          } // fin else
     }

    if(rectangle2.isSelected()) 
     {
        int fail = 0;
        boolean firstvalid = false;
        boolean secondvalid = false;
        String num = numRegTextField.getText();
        String limit = limitText.getText();
        if(num.length()>0)
         {
          if(isNum(num))
               firstvalid = true;
          else
            {
             JOptionPane.showMessageDialog(frame,                               
             idiom.getWord("ERRLIM") + " 1 " + idiom.getWord("ERRLIM2"),                       
             idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
             return;
            }
         }
        else
          fail += 1;

        if(limit.length()>0) 
         {
          if(isNum(limit))
               secondvalid = true;
          else
            {
             JOptionPane.showMessageDialog(frame,                               
             idiom.getWord("ERRLIM") + " 2 " + idiom.getWord("ERRLIM2"),                       
             idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
             return;
            }
         }
        else
          fail += 1;

        if (fail==2) {

            JOptionPane.showMessageDialog(frame,                               
            idiom.getWord("LIMUS"),                       
            idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
            return;
      	 }
        else {

              if (fail==1) {

                  JOptionPane.showMessageDialog(frame,                               
                  idiom.getWord("LIM1US"),                       
                  idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
                  return;
               }
              else
                 if (firstvalid && secondvalid) {

                     int a = Integer.parseInt(num);
                     int b = Integer.parseInt(limit);

                     if (a <= b) {
                         int numrows = (b - a) + 1;
                         sentence += " LIMIT " + numrows + " OFFSET " + num;
                      }
                     else {
                           JOptionPane.showMessageDialog(frame,                               
                           idiom.getWord("MORELIM"),                       
                           idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
                           return;
                      } // fin else
                 } // fin if
           } // fin else
    
     }
    sentence += ";";
    Vector res = connReg.TableQuery(sentence);
    addTextLogMonitor(idiom.getWord("EXEC") + sentence + "\"");
    Vector col = connReg.getTableHeader();
    if(!connReg.queryFail()) 
        {
         showQueryResult(res,col);
         updateUI(); 
         addTextLogMonitor(idiom.getWord("RES") + "OK");
        }
    else
        {
         String resStr = connReg.problem;
         addTextLogMonitor(idiom.getWord("ERRONRUN") + resStr.substring(0,resStr.length()-1));
        }
 }
}

 /**
  * METODO activeInterface()  
  * Activa o desactiva los Botones
  */ 
 public void activeInterface(boolean value) {
   insertRecord.setEnabled(value);
   updateRecord.setEnabled(value);
   rectangle.setEnabled(value);
   rectangle2.setEnabled(value);
   button.setEnabled(value);
   exportFile.setEnabled(value);

   if(!value)
    {
     title.setText(idiom.getWord("DSCNNTD"));
     showQueryResult(new Vector(),new Vector());
     hashDB.clear();
     //hashRecordFilter.clear();
     advanced.setEnabled(false);
    }
 }                                                                              

 public void setLabel(String dbName,String table,int NumR,String owner)
  {
   currentTable = table;
   String mesg = "";
   if(dbName.length()>0)
    {
      String regTitle = idiom.getWord("RECS");

      if(NumR == 1)
         regTitle = regTitle.substring(0,regTitle.length()-1);

      mesg =  NumR + " " + regTitle + " " + idiom.getWord("INTA") + " '" + table + "' [DB:" + dbName + " / " + idiom.getWord("OWNER") + ": " + owner + "]"; 
    }
   else
    mesg = idiom.getWord("NOSELECT");

    title.setText(mesg);
  }

 public void activeBox(boolean state)
  {
   rectangle.setEnabled(state);
   rectangle2.setEnabled(state);
   advanced.setEnabled(state);
   //button.setEnabled(state);
  }

 public void setRecordFilter(String TableN,String DBName) 
  {

    if (hashDB.containsKey(DBName)) {

        hashRecordFilter = (Hashtable) hashDB.get(DBName);
        recordFilter = (String) hashRecordFilter.get(TableN);

        if (recordFilter == null)
            recordFilter = "\"oid\"," + "*";
     }
    else
        recordFilter = "\"oid\"," + "*";
  }

 public boolean updateTable(PGConnection conn, String TableN, Table structT)
  {
    if (hashDB.containsKey(conn.getDBname())) {

        hashRecordFilter = (Hashtable) hashDB.get(conn.getDBname());
        recordFilter = (String) hashRecordFilter.get(TableN);
        if (recordFilter == null)
            recordFilter = "\"oid\",*";
     }
    else
      recordFilter = "\"oid\",*";

    String sentence = "SELECT " + recordFilter + " FROM \"" + TableN + "\" ORDER BY oid;";

    int tuples = Count(TableN,conn);

    if(tuples == -1)
      return false;

    if(tuples > 50)
      sentence = "SELECT " + recordFilter + " FROM \"" + TableN + "\" ORDER BY oid LIMIT 50;";

    connReg = conn;
    tableStruct = structT;
    currentTable = TableN;
    rectangle.setSelected(false);
    rectangle2.setSelected(false);
    combo3.setText("");
    numRegTextField.setText("");
    limitText.setText("");
    Vector result = connReg.TableQuery(sentence);
    columnNamesVector = connReg.getTableHeader();
    numReg = tuples;
    if(!connReg.queryFail()) 
      {
        String owner = connReg.getOwner(TableN);
        setLabel(connReg.getDBname(),TableN,tuples,owner);

        if(result.size()==0) 
            activeBox(false);
        else 
          {
            activeBox(true);
            button.setEnabled(true);
          }

        combo1.removeAllItems();
        firstField = "";
        for(int t=0;t<columnNamesVector.size();t++)
         {
          String element = (String) columnNamesVector.elementAt(t);

          if(element.length() > 25)
             element = element.substring(0,25) + "...";

          combo1.insertItemAt(element, t); 

          if(t == 0 && element != null)
            firstField = element; 

          if(firstField == null)
            firstField = element;
         }
        updateUI();
 
        showQueryResult(result,columnNamesVector);
        insertRecord.setEnabled(true);
        exportFile.setEnabled(true);

	if(tuples>50)
	  {
	  addTextLogMonitor(idiom.getWord("EX0"));
          addTextLogMonitor(idiom.getWord("EX1"));
	  addTextLogMonitor(idiom.getWord("EX2"));
	  }
       }
      else
        {
         rectangle.setEnabled(false);
         rectangle2.setEnabled(false);
         insertRecord.setEnabled(false);
         combo1.removeAllItems();
         combo1.insertItemAt("",0);
         showQueryResult(new Vector(),new Vector());
         title.setText(idiom.getWord("NRE"));
         ErrorDialog showError = new ErrorDialog(new JDialog(), conn.getErrorMessage(),idiom);
         showError.pack();
         showError.setLocationRelativeTo(frame);
         showError.show();
        }
   updateUI();

   return true;
   }

public void showQueryResult(Vector rowData,Vector columnNames) {

   columns = columnNames;
   dataRecords = rowData;

   String[] colNames = new String[columnNames.size()];
   Object[][] rowD = new Object[rowData.size()][columnNames.size()];

   if(columnNames.size()>0)
   {
     for(int p=0;p<columnNames.size();p++)
      {
       Object o = columnNames.elementAt(p);
       colNames[p] = o.toString();
      }

     for(int p=0;p<rowData.size();p++)
     {
       Vector tempo = (Vector) rowData.elementAt(p);
       for(int j=0;j<columnNames.size();j++)
        {
         Object o = tempo.elementAt(j);
         rowD[p][j] = o;
        }
      }
    }

  if (rowData.size() > 0) {

      int tableWidth = table.getWidth();
 
      myModel = new MyTableModel(rowD,colNames);
      table = new JTable(myModel);
      table.setPreferredScrollableViewportSize(new Dimension(tableWidth, 70));

      table.addFocusListener(this);
      addFocusListener(this);

      Integer v = (Integer) rowD[0][0]; 

      String val = v.toString();
      int longStr = val.length();

      longStr = longStr*10;

      DefaultTableCellRenderer renderer = new ColoredTableCellRenderer();
      renderer.setHorizontalAlignment(JLabel.CENTER);

      //Personalizar ancho de columnas
      TableColumn column = table.getColumnModel().getColumn(0);
      column.setPreferredWidth(longStr);
      column.setMaxWidth(longStr);
      column.setCellRenderer(renderer);

      int width = (tableWidth - longStr) / columnNames.size() - 1; 

      for (int p=1;p<columnNames.size();p++) {
           column = table.getColumnModel().getColumn(p);
           column.setPreferredWidth(width);

           String type = tableStruct.getTableHeader().getType((String) columnNames.elementAt(p));
           int code = getTypeCode(type);
           DefaultTableCellRenderer r = new DefaultTableCellRenderer();

           switch(code) {
              case 2:  
                       r.setHorizontalAlignment(JLabel.RIGHT);
                       break;
              case 3:  r.setHorizontalAlignment(JLabel.CENTER); 
                       break;
              default: r.setHorizontalAlignment(JLabel.LEFT);
            }

           column.setCellRenderer(r);
      }

     final JPopupMenu popup = new JPopupMenu();

     JMenuItem Item = new JMenuItem("Update");
     Item.setFont(new Font("Helvetica", Font.PLAIN, 10));
     Item.setActionCommand("UPDATE-POP");
     Item.addActionListener(this);
     popup.add(Item);

     Item = new JMenuItem("Delete");
     Item.setFont(new Font("Helvetica", Font.PLAIN, 10));
     Item.setActionCommand("DELETE-POP");
     Item.addActionListener(this);
     popup.add(Item);

     table.addMouseListener(new MouseAdapter() {

           public void mouseClicked(MouseEvent e) {

                  int[] row = table.getSelectedRows();

                  if (row.length > 0) {

                      if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e) 
                          && row[0] != -1) {

                          if (!popup.isVisible())
                              popup.show(table,e.getX(),e.getY());
                       }
                   }

                  if (e.getClickCount() == 2) { 
                      updatingRecords();
                   }
            }
     });

      delRecord.setEnabled(true);
      updateRecord.setEnabled(true);
      exportFile.setEnabled(true); 
      reportBut.setEnabled(true);
   }
   else {

          delRecord.setEnabled(false);
          updateRecord.setEnabled(false);
	  reportBut.setEnabled(false);
          table = new JTable(rowData,columnNames);
        }

   if (!firstBool)
       remove(windowX);
   else
       firstBool = false;

   windowX = new JScrollPane(table);
   add(windowX,BorderLayout.CENTER);
}

 class MyTableModel extends AbstractTableModel {

  public MyTableModel(Object[][] xdata,String[] colN) {
       data = xdata;
       columnNames = colN;
      }
 
  public String getColumnName(int col) {
        return columnNames[col].toString();
      }

  public int getRowCount() {
        return data.length; 
      }

  public int getColumnCount() {
        return columnNames.length; 
      }

  public Object getValueAt(int row, int col) {
        return data[row][col];
      }

  public boolean isCellEditable(int row, int col) {
        return false;
      }

  public void setValueAt(Object value, int row, int col) {
        data[row][col] = value;
        fireTableCellUpdated(row, col); 
      }

  }

  public void setRow1(boolean state) {
     combo1.setEnabled(state);  
     combo2.setEnabled(state);
     combo3.setEnabled(state);
   }

  public void setRow2(boolean state) {
     numRegTextField.setEnabled(state);
     men1.setEnabled(state);
     limitText.setEnabled(state);
     men2.setEnabled(state);
   }

  class CheckBoxListener implements ItemListener {

     public void itemStateChanged(ItemEvent e) {
        Object source = e.getItemSelectable();

        if (source == rectangle) {
            if (rectangle.isSelected()) {
                setRow1(true);
                combo1.setSelectedItem(firstField);
            }
          else
                setRow1(false);

          combo2.setSelectedIndex(0);
        } 

        if (source == rectangle2) {

            if (rectangle2.isSelected()) {
                setRow2(true);
             }
            else {
                  setRow2(false);
                  numRegTextField.setText("");
                  limitText.setText("");
             }

        }
    }
 }

 public boolean isNum(String word)
 { 
   for(int i=0;i<word.length();i++)
    {
      char c = word.charAt(i);
      if(!Character.isDigit(c))
        return false;
    }
   return true;
 }

 public int Count(String TableN,PGConnection konn)
  {
   int val = -1;
   String counting = "SELECT count(*) FROM \"" + TableN + "\";";
   String answer = "OK";
   addTextLogMonitor(idiom.getWord("EXEC")+ counting + "\"");
   Vector result = new Vector();
   result = konn.TableQuery(counting);
   if(konn.queryFail())
    {
      answer = konn.getProblemString().substring(0,konn.getProblemString().length()-1);
      ErrorDialog showError = new ErrorDialog(new JDialog(),konn.getErrorMessage(),idiom);
      showError.pack();
      showError.setLocationRelativeTo(frame);
      showError.show();
    }
   else
    {
     Vector value = (Vector) result.elementAt(0);
     try {
           Long entero = (Long) value.elementAt(0);   
           val = entero.intValue();
      }
     catch(Exception ex){
            Integer entero = (Integer) value.elementAt(0);
            val = entero.intValue();
      }
    }

   addTextLogMonitor(idiom.getWord("RES") + answer);

   return val;
  }


 public int getTypeCode(String typeStr)
  {
   if(typeStr.startsWith("varchar") || typeStr.startsWith("char") || typeStr.startsWith("text") || typeStr.startsWith("name") || typeStr.startsWith("date") || typeStr.startsWith("time"))
     return 1;

   if(typeStr.startsWith("int") || typeStr.equals("serial") || typeStr.equals("smallint") || typeStr.equals("real") || typeStr.equals("double"))
     return 2;

   if(typeStr.startsWith("bool"))
     return 3;
   else
     return 4;
 }

 /**
  * Metodo addTextLogMonitor
  * Imprime mensajes en el Monitor de Eventos
  */
  public void addTextLogMonitor(String msg)
   {
    LogWin.append(msg + "\n");
    int longiT = LogWin.getDocument().getLength();
    if(longiT > 0)
        LogWin.setCaretPosition(longiT - 1);
   }

 /**
  * Metodo getNumRegs
  * Retorna el numero de registros de la tabla
  */
  public int getNumRegs()
   {
     return numReg;
   }

public void printFile(PrintStream xfile,Vector registers,Vector FieldNames,String Separator)
 {
   String limit = "";
   boolean isCSV = false;
   try {
        int TableWidth = FieldNames.size();
        if(Separator.equals("csv"))
         {
           limit = ",";
           isCSV = true;
         }
        else
          limit = Separator;

        for(int p=0;p<registers.size();p++)
          {
           Vector rData = (Vector) registers.elementAt(p);
           for(int i=0;i<TableWidth;i++)
            {
             Object o = rData.elementAt(i);
             String field = o.toString();

             if(isCSV)
              xfile.print("\"" + field + "\"");
             else
              xfile.print(field);

             if(i<TableWidth-1)
              xfile.print(limit);
            }
           xfile.print("\n");
          }

         try
          {
           xfile.close();
          }
         catch(Exception ex)
          {
           System.out.println("Error: " + ex.toString());
          }
       }
     catch(Exception e)
        {
         System.out.println("Error: " + e.toString());
        }
 }

void BuildSQLRecords(String table,TableHeader headT,Vector data)
 {
   Vector col  = headT.getNameFields(); 
   String sql  = "";
   int numCol = col.size();

   try 
     {
      for(int p=0;p<data.size();p++)
       {
        sql = "INSERT INTO \"" + table + "\" VALUES(";
        Vector tempo = (Vector) data.elementAt(p);

        if(tempo.size() != numCol)
         {
           if(p > 0)
            {
             refreshTable();
            }

           int k = p + 1;

           JOptionPane.showMessageDialog(Records.this,
           "The file is corrupt on line " + k,
           idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
           return;
         }          

        for(int j=0;j<numCol;j++)
         {
          String colName = (String) col.elementAt(j);
          String type = headT.getType(colName);
          Object o = tempo.elementAt(j);

          if(type.startsWith("varchar") || type.startsWith("char") || type.startsWith("text") || type.startsWith("name") || type.startsWith("date") || type.startsWith("time"))
             sql += "'" + o.toString() + "'";
          else
             sql += o.toString();

          if(j < (numCol - 1))
            sql += ",";
         }

        sql += ");";
     
        addTextLogMonitor(idiom.getWord("EXEC")+ sql + "\"");
        String result = connReg.SQL_Instruction(sql);

        if (result.equals("OK")) {
            addTextLogMonitor(idiom.getWord("RES") + result);
         }
        else {
              result = result.substring(0,result.length()-1);
              addTextLogMonitor(idiom.getWord("RES") + result);

              ErrorDialog showError = new ErrorDialog(new JDialog(),connReg.getErrorMessage(),idiom);
              showError.pack();
              showError.setLocationRelativeTo(frame);
              showError.show();
              return;
         }

       }
       refreshTable();

      }
    catch (Exception ex) {
           System.out.println("Error: " + ex);
           ex.printStackTrace(); 
     }

 }

public void refreshTable() {

   Vector res = connReg.TableQuery("SELECT " + recordFilter + " FROM \"" + tableStruct.getName() + "\" ORDER BY oid");
   Vector colNames = connReg.getTableHeader();
   String owner = connReg.getOwner(tableStruct.getName());
   numReg = res.size();
   setLabel(connReg.getDBname(),tableStruct.getName(),numReg,owner);
   showQueryResult(res,colNames);
   updateUI();
 }

 /** METODO keyTyped */

public void keyTyped(KeyEvent e) {
 }

public void keyPressed(KeyEvent e) {
    int keyCode = e.getKeyCode();
    String keySelected = KeyEvent.getKeyText(keyCode); 

    if (keySelected.equals("Delete")) {

        dropRecords();
        return;
     }

    if (keySelected.equals("Insert")) {

        updatingRecords();
        return;
     }
 }

 /*
  * METODO keyReleased
  * Handle the key released event from the text field.
  */

public void keyReleased(KeyEvent e) {
 }

 /**
  * METODO focusGained
  * Es un foco para los eventos del teclado
  */

public void focusGained(FocusEvent e) {
    Component jTable = e.getComponent();
    jTable.addKeyListener(this);
 }

 /**
 * METODO focusLost
 */

public void focusLost(FocusEvent e) {
    Component jTable = e.getComponent();
    jTable.removeKeyListener(this);
 }

 /**
 * METODO insertRecords 
 */

public void insertRecords() {

   setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
   InsertData insert = new InsertData(tableStruct,frame,idiom);
   setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

   if (insert.wasOk()) {

       addTextLogMonitor(idiom.getWord("EXEC")+ insert.getSQLString() + "\"");
       String result = connReg.SQL_Instruction(insert.getSQLString());

       if (result.equals("OK")) {

           Vector res = connReg.TableQuery("SELECT " + recordFilter + " FROM \"" + tableStruct.getName() + "\" ORDER BY oid");
           Vector col = connReg.getTableHeader();
           int oldNum = numReg;
           numReg = res.size();

           if (!connReg.queryFail()) {

               String owner = connReg.getOwner(tableStruct.getName());
               setLabel(connReg.getDBname(),tableStruct.getName(),numReg,owner);
               showQueryResult(res,col);

               if (oldNum==0) {
                   rectangle.setEnabled(true);
                   rectangle2.setEnabled(true);
                   advanced.setEnabled(true);
                }
               updateUI();
             }
         }
       else {
             result = result.substring(0,result.length()-1);

             ErrorDialog showError = new ErrorDialog(new JDialog(),connReg.getErrorMessage(),idiom);
             showError.pack();
             showError.setLocationRelativeTo(frame);
             showError.show();
        }

       addTextLogMonitor(idiom.getWord("RES") + result);
    }
}

 /**
 * METODO dropRecords 
 */

public void dropRecords() {

    BoolOption dropRecs = new BoolOption(frame,idiom.getWord("YES"),idiom.getWord ("NO"),
                                       idiom.getWord("CONFRM"),idiom.getWord("DRCONF"));

    boolean sure = dropRecs.getSelecction();

    if (sure) {

        String[] oid = getRecordOid();

        for (int i=0;i<oid.length;i++) {

            String sqlStr = "DELETE FROM \"" + tableStruct.getName() + "\" WHERE oid=" + oid[i];
            addTextLogMonitor(idiom.getWord("EXEC")+ sqlStr + ";\"");
            String result = connReg.SQL_Instruction(sqlStr);
            addTextLogMonitor(idiom.getWord("RES") + result);
         }

        refreshTable();
     }
 }

 /**
 * METODO getRecordOid 
 */

public String[] getRecordOid() {

    int[] rows = table.getSelectedRows();
    String[] oid = new String[rows.length];

    for (int i=0;i<rows.length;i++) {
         Object proof = myModel.getValueAt(rows[i],0);
         oid[i] = proof.toString();
     }

    return oid;
 }

 /**
 * METODO updatingRecords 
 */

public void updatingRecords() {

    String[] oid = getRecordOid();

    UpdateRecord upper = new UpdateRecord(tableStruct,frame,idiom);

    if (upper.getResult()) {

        String SQL = upper.getUpdate() + " WHERE ";
        for (int i=0;i<oid.length;i++) {
             SQL += "oid=" + oid[i];
             if (i<oid.length-1)
                 SQL += " OR ";
         }

        addTextLogMonitor(idiom.getWord("EXEC")+ SQL + ";\"");
        String result = connReg.SQL_Instruction(SQL);
        addTextLogMonitor(idiom.getWord("RES") + result);
        refreshTable();
     }
 }

} // Fin de la Clase

class ColoredTableCellRenderer extends DefaultTableCellRenderer {

public void setValue(Object value) {
            setForeground(Color.red);
            setText(value.toString());
 }
}
