/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS UpdateDBTree v 0.1                                                   
* Descripcion:
* Esta clase se encarga de realizar un escaneo de conexiones
* a todas las bases de datos en un SMBD Postgres.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import java.lang.*;
import java.util.Vector;
import javax.swing.JTextArea;

public class UpdateDBTree {

 Vector validDB = new Vector();
 Vector vecConn = new Vector();
 Vector listDB;
 PGConnection conn;
 Language idiom;
 ConRegister user;
 boolean killing=false;
 JTextArea LogWin;

 public UpdateDBTree(JTextArea log,Language lang,PGConnection pgconn,Vector DBs) 
 {
   LogWin = log;
   idiom = lang;
   conn = pgconn;
   user = conn.getConRegister();
   listDB = DBs;
   makeSearch();
 }

 public void makeSearch() 
 {
  Vector tables;
  int numDB = listDB.size();
  if(numDB>0)
  {
   for (int i=0;i<numDB;i++)
   {
    Object o = listDB.elementAt(i);
    String dbname = o.toString();
    addTextLogMonitor(idiom.getWord("LOOKDB") + ": \"" + dbname + "\"... ");
    ConRegister tmp = new ConRegister(user.Hostname,dbname,user.Username,user.Password,user.Port); 
    PGConnection proofConn = new PGConnection(tmp, idiom); 
    if (!proofConn.Fail())
     {
      addTextLogMonitor(idiom.getWord("OKACCESS"));

     if(!dbname.equals("template1") || !dbname.equals("postgres")) 
      {
       vecConn.addElement(proofConn);
       validDB.addElement(listDB.elementAt(i));                     
      }
     }
    else
       addTextLogMonitor(idiom.getWord("NOACCESS"));       
    }//fin del for
  }

 }

 public Vector getDatabases() 
 {
	  return validDB;
 }

 public Vector getConn() 
 {
   return vecConn;
 }

 /**
  * Metodo addTextLogMonitor
  * Imprime mensajes en el Monitor de Eventos
  */
 public void addTextLogMonitor(String msg)
  {
   LogWin.append(msg + "\n");	
   int longiT = LogWin.getDocument().getLength();
   if(longiT > 0)
     LogWin.setCaretPosition(longiT - 1);
  }

} //Fin de la Clase 
