--
-- USDA Food Database R18
--
BEGIN;

SET client_encoding = 'LATIN1';

--
-- Name: data_src; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE data_src (
    datasrc_id character(6) NOT NULL,
    authors text,
    title text NOT NULL,
    "year" integer,
    journal text,
    vol_city text,
    issue_state text,
    start_page text,
    end_page text
);


--
-- Name: datsrcln; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE datsrcln (
    ndb_no character(5) NOT NULL,
    nutr_no character(3) NOT NULL,
    datasrc_id character(6) NOT NULL
);


--
-- Name: deriv_cd; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE deriv_cd (
    deriv_cd text NOT NULL,
    derivcd_desc text NOT NULL
);


--
-- Name: fd_group; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE fd_group (
    fdgrp_cd character(4) NOT NULL,
    fddrp_desc text NOT NULL
);


--
-- Name: food_des; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE food_des (
    ndb_no character(5) NOT NULL,
    fdgrp_cd character(4) NOT NULL,
    long_desc text NOT NULL,
    shrt_desc text NOT NULL,
    comname text,
    manufacname text,
    survey character(1),
    ref_desc text,
    refuse integer,
    sciname text,
    n_factor double precision,
    pro_factor double precision,
    fat_factor double precision,
    cho_factor double precision
);


--
-- Name: footnote; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE footnote (
    ndb_no character(5) NOT NULL,
    footnt_no character(4) NOT NULL,
    footnt_typ character(1) NOT NULL,
    nutr_no character(3),
    footnt_txt text NOT NULL
);


--
-- Name: nut_data; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nut_data (
    ndb_no character(5) NOT NULL,
    nutr_no character(3) NOT NULL,
    nutr_val double precision NOT NULL,
    num_data_pts double precision NOT NULL,
    std_error double precision,
    src_cd integer NOT NULL,
    deriv_cd text,
    ref_ndb_no character(5),
    add_nutr_mark character(1),
    num_studies integer,
    min double precision,
    max double precision,
    df integer,
    low_eb double precision,
    up_eb double precision,
    stat_cmt text,
    cc character(1)
);


--
-- Name: nutr_def; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nutr_def (
    nutr_no character(3) NOT NULL,
    units text NOT NULL,
    tagname text,
    nutrdesc text,
    num_dec smallint,
    sr_order integer
);


--
-- Name: src_cd; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE src_cd (
    src_cd integer NOT NULL,
    srccd_desc text NOT NULL
);


--
-- Name: weight; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE weight (
    ndb_no character(5) NOT NULL,
    seq character(2) NOT NULL,
    amount double precision NOT NULL,
    msre_desc text NOT NULL,
    gm_wgt double precision NOT NULL,
    num_data_pts integer,
    std_dev double precision
);


--
-- Data for Name: data_src; Type: TABLE DATA; Schema: public; Owner: -
--

COPY data_src (datasrc_id, authors, title, "year", journal, vol_city, issue_state, start_page, end_page) FROM stdin;
D1066 	G.V. Mann	The Health and Nutritional status of Alaskan Eskimos.	1962	American Journal of Clinical Nutrition	11		31	76
D1073 	J.P. McBride, R.A. Maclead	Sodium and potassium in fish from the Canadian Pacific coast.	1956	Journal of the American Dietetic Association	32		636	638
D1107 	M.E. Stansby	Chemical Characteristics of fish caught in the northwest Pacific Oceans.	1976	Marine Fish Rev.	38	9	1	11
D1191 	I.J. Tinsley, R.R. Lowry	Bromine content of lipids of marine organisms	1980	American Oil Chemists' Society, Journal		1	31	33
D1243 	M. Iwasaki, R. Harada	Composition of the Ros Marine Species.	1985	(Pre-publication copy)				
D1417 	O. Longe	Effect of boiling on the carbohydrate constituents of some non-leafy vegetables	1981	Food Chemistry	7	1	1	6
D2793 	D.T. Gordon, G.L. Roberts, D.M. Hernty	Thiamin, Riboflavin, and Niacin content and stability in Pacific coast seafoods.	1979	Journal of Agricultural and Food Chemistry	27	3	483	490
D3284 	R. Becker	Identification of some sugars and mannitol in celery	1968	Journal of Food Science	33		128	130
D3296 	C.E. Damon, B.C. Pettitt	Sugars and Sugar Products: High Performance Liquid Chomatographic Determination of Fructose, Glucose and Sucrose in Molasses	1980	J. AOAC	63	3	476	480
D3302 	M.C. Gancedo, B.S. Luh	HPLC Analysis of Organic Acids and Sugars in Tomato Juice	1986	Journal of Food Science	51	3	571	573
D3305 	K.C. Gross, P.B. Acosta	Fruits and vegetables are a source of galactose: Implications in planning the diets of patients with galactosaemia	1991	J. Inher. Metab. Dis.	14		253	258
D3306 	K. Haila	Sugar and organic acid content of vegetables consumed in Finland during 1988-1989	1992	Journal of Food Composition and Analysis	5		100	107
D3309 	M. Horbowicz	Adaptation of the method of sugars determination by gas chromatography (GC) and characteristics of  their occurrence	1980	Acta Alimentaria Polonica	6	4	227	236
D3311 	A. Hughes, R.C. Lindsay	Liquid chromatographic analysis of sugars and mannitol in cabbage and fermenting sauerkraut	1985	Journal of Food Science	50	6	1662	1667
D3315 	W.J. Hurst, R.A. Martin, B.L. Zoumas	Application of HPLC to Characterization of Individual Carbohydrates in Foods	1979	Journal of Food Science	44		892	893
D3316 	J.L. Iverson, M.P. Bueno	Evaluation of high pressure liquid chromatography and gas liquid chromatography for quantitative determination of sugars in foods	1981	Journal of the Association of Official Analytical Chemists	64	1	139	143
D3318 	D.A. Kline	Quantitative determination of sugars in fruits by GLC separation of TMS derivatives	1970	Journal of AOAC International	53	6	1198	1202
D3321 	C. Y. Lee	Free sugars in fruits and vegetables	1970	Food Science and Technology		1		
D3326 	C. Martin-Villa	High performance liquid chromatographic determination of carbohydrates in raw and cooked vegetables	1982	Journal of Food Science	47		2086	
D3335 	D.H. Picha	HPLC Determination Of Sugars In Raw And Baked Sweet Potatoes	1985	Journal Of Food Science	50		1189	1190
D3336 	M.L. Richmond	Analysis of simple sugars and sorbitol in fruit by high-performance liquid chromatography	1981	J. Agric. Food Chem.	29		4	7
D3338 	P. Sporns	Alberta honey composition	1992	Food Research International	25		93	100
D3339 	K.W. Swallow, N.H. Low	Analysis And Quantitation Of The Carbohydrates In Honey Using High-Performance Liquid Chromatography.	1990	Journal of Agricultural and Food Chemistry	38	9	1828	1832
D3342 	J.W. White, R MeLoy, J Probst, W Huser	Sugars Containing Galactose Occur In Honey	1986	Journal Of Agricultural Research (J Apic Res. V.25 (3)	25	3	182	185
D3344 	R.B. H. Wills	Nutrient composition of stone fruit (Prunus spp.) cultivars: apricot, cherry, nectarine, peach and plum	1983	J Sci Food Agric	34		1383	1389
D3357 	V.C. Morris, O.A. Levander	Selenium content of food	1970	Journal of Nutrition	100	12	1383	1388
D3358 	A.L. Moxon, D.L. Palmquist	Selenium content of foods grown or sold in Ohio	1980	Ohio Report	65	1		
D3359 	O.E. Olson, I.S. Palmer	Selenium in foods purchased or produced in South Dakota	1984	Journal of Food Science	49			
D3364 	J.T. Snook, D. Kinsey, D.L. Palmquist, J.P. DeLaney, V.M. Vivian, A.L. Moxon	Selenium content of foods purchased or produced in Ohio	1987	Journal of the American Dietetic Association	87	6	744	749
D3410 	A.W. Lantz	Use of chilled sea water in place of ice in transporting fish	1953	Fisheries Research Board of Canada, Progress Reports of the Pacific Coast Stations	95		39	44
D342  	J. A. Bowers, J. Craig	Components of B6 in Turkey Breast Muscle	1978	Journal of Food Science	43	5	1619	
D3764 	J Marlett	Content and composition of dietary fiber in 117 frequently consumed foods	1992	Journal of the American Dietetic Association	92	2		
D3765 	N Vollendorf, J Marlett	Comparison of Two Methods of Fiber Analysis of 58 Foods	1993	Journal of Food Composition and Analysis	6		203	214
D3766 	V Chaudhary, F Weber	Barley bran flour evaluated as dietary fiber ingredient in wheat bread	1990	Cereal Foods World	35	6	560	562
D3771 	L Prosky	Total Dietary Fiber in Cereals -- Problems and Determination	1986	AACC Symposium				
D3773 	R. Mongeau, R. Brassard	A Comparison of Three Methods for Analyzing Dietary Fiber in 38 Foods	1989	Journal of Food Composition and Analysis	2		189	199
D3776 	C. Lintas, M. Capelloni	Content and composition of dietary fibre in raw and cooked vegetables	1988	Food Sciences and Nutrition	42F		117	124
D3777 	J Marlett, N Vollendorf	Dietary fiber content and composition of vegetables determined by two methods of analysis	1993	Journal of Agriculture and Food Chemistry	41		1608	1612
D3779 	N Vollendorf, J Marlett	Dietary Fiber Content and Composition in Home-Prepared and Commercially Baked Products: Analysis and Prediction	1994	Cereal Chemistry	71	1	99	105
D3780 	J Marlett, N Vollendorf	Dietary fiber content and composition of different forms of fruits	1994	Food Chemistry	51			
D3842 	T Philip, T S Chen	Quantitative analyses of major carotenoid fatty acid esters in fruits by liquid chromatography: Persimmon and Papaya.	1988	J. Food Science	53	6	1720	1722
D3843 	F W Quackenbush	Reverse phase HPLC separation of cis- and trans-carotenoids and its application to beta-carotenes in food materials	1987	J Liq Chrom	10		643	653
D3844 	D B Rodriguez, L C Raymundo, K L Simpson, C O Chichester	Carotenoid pigment changes in ripening Momordica charantia fruits	1976	Ann Bot (London)	40		615	624
D3845 	R L Rouseff, G D Sadler, T J Putman, J E Davis	Determination of beta-carotene and other hydrocarbon carotenoids in red grapefruit cultivars.	1992	J. Agric. Food Chem.	40		47	51
D3846 	J P Sweeney, A C Marsh	Effect of processing on provitamin A in vegetables	1971	J Am Diet Assoc	59		238	243
D3847 	J P Sweeney, A C Marsh	Effects of selected herbicides on provitamin A content of vegetables	1971	J Agric Food Chem	19		854	856
D3848 	I R Stewart	High performance liquid chromatographic determination of provitamin A in orange juice	1977	J AOAC	60		132	136
D3849 	I R Stewart	Provitamin A and carotenoid content of citrus juices	1977	J Agric Food Chem	25		1132	1137
D3850 	P W Simon, X Y Wolff	Carotenes in typical and dark orange carrots	1987	J Agric Food Chem	35		1017	1022
D3851 	L H Tonucci, J M Holden, G R Beecher, F Khachik, C S Davis, G Mulokozi	Carotenoid content of thermally processed tomato-based food products.	1995	J. Agric. Food Chem.	43		579	586
D3852 	J Q Wu, D E Carrol	Chemical and physical sensory stabilities of prebaked frozen sweet potatoes.	1991	J. Food Sci.	56	1	710	713
D3853 	Y Wu, A K Perry, B P Klein	Vitamin C and beta-carotene in fresh and frozen green beans and broccoli in a simulated system.	1992	J. Food Quality	15	2	87	96
D3863 	K. Bhaskarachary, D.S. Sankar Rao, Y.G. Deosthale, Vinodini Reddy	Carotene content of some common and less familiar foods of plant origin.	1995	Food Chemistry	54		189	193
D3869 	B.H. Chen	Studies on the stability of carotenoids in garland chrysanthemums (Ipomoea spp.) as affected by microwave and conventional heating	1995	J. Food Protection	55		296	300
D3870 	B.H. Chen, J.R. Chuang, J.H. Lin, P. Chiu	Quantification of provitamin A compounds in Chinese vegetables by high-performance liquid chromatography	1993	J. Food Protection	56		51	54
D3885 	R J Bushway, A M Wilson	Determination of alpha- and beta-carotene in fruit and vegetables by high performance liquid chromatography	1982	Can Inst Food Sci Technol	15		165	169
D3886 	A A Bushway, D V Setteze, D F McGann, R H True, T M Work, R J Bushway	Effect of processing method and storage time on the nutrient composition of fiddlehead greens	1985	J Food Sci	50		1491	1492
D3887 	J L Bureau, R J Bushway	HPLC determination of carotenoids in fruits and vegetables in the United States	1986	J Food Sci	52		128	130
D3888 	R J Bushway	Determination of alpha- and beta-carotene in some raw fruits and vegetables by high-performance liquid chromatography	1986	J Agr Food Chem	34		409	412
D3889 	R J Bushway, A Yang, A M Yamani	Comparison of alpha- and beta-carotene content of supermarket versus roadside stand produce	1987	J Food Qual	9		437	443
D389  	K. Hoppner, B. Lampi, D.E. Perrin	The free & Total folate activity in foods available on the Canadian market.	1972	Canadian Institute of Food Technology Journal	5	2	60	
D3890 	E D Brown, M S Micozzi, N E Craft, J G Bieri, G Beecher, B K Edwards, A Rose, P R Taylor, J C Smith, Jr.	Plasma carotenoids in normal men after a single ingestion of vegetables or purified beta-carotene	1989	Am J Clin Nutr	49		1258	1265
D3891 	L A Chandler, S J Schwartz	Isomerization and losses of trans-beta-carotene in sweet potatoes as affected by processing treatments	1988	J Agric Food Chem	36		129	133
D3894 	G K Gregory, T-S Chen, T R Philip	Quantitative analysis of carotenoids and carotenoid esters in fruits by HPLC: red bell peppers	1987	J Food Sci	52		1071	1073
D3899 	A Homnava, W Rogers, R R Eitenmiller	Provitamin A activity of specialty fruit marketed in the United States.	1990	J. Food Composition and Analysis	3		119	133
D390  	A.V. Lentoc, L.B. Dimannahan, O.N. Gonzalez	Vitamin B6 Content of Some Phillipine Foods. Raw Foods	1971	Philippine Journal of Nutrition	24		209	
D3900 	L R Howard, T Dewi	Minimal processing and edible coating effects on composition and sensory quality of mini-peeled carrots.	1996	J. Food Science	61	3	643	651
D3901 	F Khachik, G R Beecher, N F Whittaker	Separation, identification and quantification of the major carotenoid and chlorophyll constituents in extracts of several green vegetables by liquid chromatography	1986	J Agr Food Chem	34		603	616
D3902 	F Khachik, G R Beecher	Application of C-45-beta-carotene as an internal standard for the quantification of carotenoids in yellow/orange vegetables by liquid chromatography	1987	J Agr Food Chem	35		732	738
D3903 	F Khachik, G R Beecher	Separation and identification of carotenoids and carotenol fatty acid esters in some squash products by liquid chromatography 1. Quantification of carotenoids and related esters by HPLC	1988	J Agr Food Chem	36		929	937
D3904 	F Khachik, G R Beecher, W R Lusby	Separation, identification and quantification of the major carotenoids in extracts of apricots, peaches, cantaloupe, and pink grapefruit by liquid chromatography	1989	J Agric Food Chem	37		1465	1473
D3905 	F Khachik, M B Goli, G R Beecher, J Holden, W R Lusby, M D Tenoro, M R Barrera	Effect of food preparation on qualitative and quantitative distribution of major carotenoid constituents of tomatoes and several green vegetables.	1992	J. Agric Food Chem	40		390	398
D3907 	C Y Lee, P E McCoon, J H LeBowitz	Vitamin A value of sweet corn	1981	J Agric Food Chem	29		1294	1295
D3909 	C Y Lee	Changes in carotenoid content of carrots during growth and post-harvest storage	1986	Food Chem	20		285	293
D3911 	A T Ogunlesi, C Y Lee	Effect of thermal processing on the stereoisomerization of major carotenoids and vitamin A value of carrots	1979	Food Chem	4		311	318
D3912 	T Philip, T S Chen	Development of a method for the quantitative estimation of provitamin A carotenoids in some fruits.	1988	J. Food Science	53		1703	1707
D3919 	I.M. Heinonen, V. Ollilainen, E. Linkola, P. Varo, P. Koivistoinen	Carotenoids in Finnish Foods:  Vegetables, Fruits, and Berries	1989	Journal  of Agriculture and Food Chemistry	37		655	659
D3920 	M. Heinonen, V. Olliloinen, E. Perttivaro, P. Koivistoinen	Carotenoids and retinoids in Finnish Foods: Dietary Fats	1988	J. Food Composition and Analysis	1		334	340
D3921 	I.M. Heinonen, V. Ollilainen, E. Linkola, P. Varo, P. Koivistoinen	Carotenoids and Retinoids in Finnish Foods:  Cereal and Bakery Products	1989	Cereal Chemistry	66	4	270	273
D3924 	D.J. Hart, K.J. Scott	Development and evaluation of an HPLC method for the analysis of carotenoids in foods, and the measurement of the carotenoid content of vegetables and fruits commonly consumed in the UK	1995	Food Chemistry	54		101	111
D3933 	C. Y. Lee, R.W. Robinson	Influence of the crimson gene (ogc) on vitamin A content of tomato	1980	Horticultural Science	15		260	261
D3949 	H. Muller	Determination of the carotenoid content in selected vegetables and fruit by HPLC and photoiode array detection	1997	Z. Lebensm Unters Forsch A	204		88	94
D3956 	D.M. R. Ramos, D B Rodriguez	Determination of the vitamin A value of common Brazilian leafy vegetables.	1987	J. Micronutrient Analysis	3		147	155
D3964 	A.J. Speek, S. Speek-Saichua, W.H. P. Schreurs	Total carotenoid and B-carotene contents of Thai vegetables and the effect of processing.	1988	Food Chemistry	27		245	257
D3969 	E-Siong Tee, Chin-Lam Lim	Carotenoid composition and content of Malaysian vegetables and fruits by the AOAC and HPLC methods.	1991	Food Chemistry	41		309	339
D4002 	S.L. Booth, J.A. Sadowski, J.A. T. Pennington	Phylloquinone (Vitamin K) Content of Foods in the U.S. Food and Drug Administration's Total Diet Study	1995	Journal of Agricultural and Food Chemistry	43	6	1574	1579
D4041 	S.L. Booth, KW Davidson, J.A. Sadowski	Evaluation of an HPLC Method for the Determination of Phylloquinone (Vitamin K) in Various Food Matrices	1994	Journal of Agricultural and Food Chemistry	42	2	295	300
D4042 	Z.H. Gao, R.G. Ackman	Determination of Vitamin K in Canola Oils by High Performance Liquid Chromatography with Menoquinone-4 as an Internal Standard	1995	Food Research International	28	1	61	69
D4043 	E. Jakob, I. Elmadfa	Application of a Simplified HPLC Assay for the Determination of Phylloquinone (Vitamin K) in Animal and Plant Food Items	1996	Food Chemistry	56	1	87	91
D4048 	G. Ferland, D. MacDonald, J.A. Sadowski	Development of a diet low in vitamin K (phylloquinone)	1992	J. American Dietetic Assoc	92	5	593	597
D4050 	M.J. Shearer, C. Bolton-Smith	The UK Food Data-Base for Vitamin K and Why We Need It	1999	Food Chemistry	68		213	218
D4051 	G. Ferland, J.A. Sadowski	Vitamin K (Phylloquinie) Content of Edible Oils:  Effects of Heating and Light Exposure	1992	Journal of Agricultural and Food Chemistry	40	10	1869	1873
D4052 	T.J. Koivu, V. I. Piironen, S.K. Henttonen, P.H. Mattila	Determination of Phylloquinone in Vegetables, Fruits, and Berries by High-Performance Liquid Chromatography with Electrochemical Detection	1997	American Chemical Society				
D4053 	A.C. Shovic	Nutrient composition of abiyuch and rowal fruits	1999	Tropical Science	39		159	161
D4066 	V. I. Piironen, T.J. Koivu	Quality of Vitamin K Analysis and Food Composition Data in Finland	1998	Food Chemistry	68		223	226
D4068 	T.J. Koivu, V. I. Piironen, P.H. Mattila	Phylloquinone (Vitamin K) in Cereal Products	1997	Cereal Chemistry	75	1	1	6
D4069 	S.L. Booth, H.T. Madabushi, KW Davidson, J.A. Sadowski	Tea and Coffee Brews are not Dietary Sources of Vitamin K-1 (Phylloquinone)	1995	Journal of the American Dietetic Assoc.	95	1	82	83
D4070 	N.J. Miller-Ihli	Atomic absorption and atomic emission spectrometry for the determination of the trace element content of selected fruits consumed in the United States	1996	Journal of Food Composition and Analysis	9	4	301	311
D4071 	V. I. Piironen, T.J. Koivu, O. Tammisalo, P.H. Mattila	Determination of phylloquinone in oils, margarines and butter by HPLC with electrochemical detection	1997	Food Chemistry	59	3	473	480
D4072 	C. Bolton-Smith, R.J.G. Price, Steven T. Fenton, Dominic J. Harrington, M.J. Shearer	Compilation of a provisional UK database for the phylloquinone (vitamin K) content of foods	2000	British Journal of Nutrition	83		389	399
D4073 	E. Jakob, I. Elmadfa	Rapid and simple HPLC analysis of vitamin K in food, tissues and blood	2000	Food Chemistry	68		219	221
D4074 	T.J. Koivu, V. I. Piironen, A.-M. Lampi, P.H. Mattila	Dihydrovitamin K in oils and margarines	1999	Food Chemistry	64		411	414
D4077 	S.L. Booth, KW Davidson, A.H. Lichtenstein, J.A. Sadowski	Plasma concentration of dihydro-vitamin K following dietary intake of hydrogenated vitamin K-rich vegetable oil	1996	Lipids	31	7	709	713
D4078 	S.L. Booth, J.A. T. Pennington, J.A. Sadowski	Dihydro-vitamin K: primary food sources and estimated dietary intakes in the American diet	1996	Lipids	31	7	714	719
D4142 	W. R. Mindak, S. P. Dolan	Determination of arsenic and selenium in food using a microwave digestion-dry ash preparation and flow injection hydride generation atomic absorption spectrometry	1999	Journal of Food Composition and Analysis	12		111	122
D4281 	L.D. Thompson, L.C. Hoover, H.C. Brittin, W.R. Lan, M.F. Miller, C.K. Wu	Carcass characteristics, composition, palatability, microbiological quality and consumer acceptance of emu meat	1996	Department of Animal Science and Food Technology, Texas Tech University Research Report				
D4282 	L.D. Thompson	Nutritional composition of six muscles from yearling emus	1997	Department of Animal Science and Food Technology Research Report, Texas Tech University				
D429  	P.E. Johnson, C. Straus, G.W. Evans	Metallocalorie Ratios for Copper, Iron and Zinc in Fruits and Vegetables	1977	Nutrition Reports International	15	4	469	
D4301 	K.D. Pollok, D.S. Hale, R.K. Miller, J.T. Keeton, R. Angel, A. Blue-McLendon	Ostrich Meat industry development: Phase II	1997	American Ostrich Association, Fort Worth, Texas				
D4381 	S.W. Leonard, K. Hardin, J.E. Leklem	Vitamin B-6 Content of Spices	2001	Journal of Food Composition and Analysis	14		163	167
D4541 		Bottled Water Sampling Study Final Report	\N					
D4561 	H. Fukuba, T. Murota	Determination of tocopherols in foodstuffs, especially nuts and spices, by high-performance liquid chromotography	1985	Journal of Micronutrient Analysis	1		93	105
D4581 	R.H. Matthews, P.R. Pehrsson, M. Farhat-Sabet	Sugar Content of Selected Foods:  Individual and Total Sugars	1987	Home Economics Research Report Number 48				
D4602 	P.J. McLaughlin, J. Weihrauch	Vitamin E content of foods	1979	Journal of the American Dietetic Association	75	6	647	665
D463  	H.T. Chan	Tropical Foods - the Chemistry & Biochemistry of Papaya	1979	Academic Press	1			
D4682 	K.U. Pradeep	Common Indian spices:  Nutrient composition, consumption and contribution to dietary value	1993	Plant Food for Human Nutrition	44		137	148
D4701 	M. Murkovic	Development of an Austrian carotenoid database	2000	Journal of Food Composition and Analysis	13		435	440
D4721 	M.I. Minguez-Mosquera, D. Hornero-Mendez	Comparative study of the effect of paprika processing on the carotenoids in peppers (Capsicum annuum) of the Bola and Agridulce varieties	1994	Journal of Agricultural and Food Chemistry	42		1555	1560
D4722 	H.G. Daood	Antioxidant vitamin content of spice red pepper (paprika) as affected by technological and varietal factors	1996	Food Chemistry	55	4	365	372
D4743 	J.K. Daun, R. Przybylski	Environmental effects on the composition of four Canadian flax cultivars	2000	Proceedings of the 58th Meeting of the Flax Institute of the United States			80	91
D4761 	K.C. Duester	Avocado fruit is a rich source of beta-sitosterol	2001	Journal of the American Dietetic Association	101	4	404	404
D4781 	R.J. Pawlosky, V.P. Flanagan, R.F. Doherty	A Mass Spectrometric Validated High-Performance Liquid Chromatography Procedure for the Determination of Folates in Foods	2003	Journal of Agricultural and Food Chemistry				
D4801 	P. Perkins-Veazie	Lycopene content differs among red-fleshed watermelon cultivars	2001	Journal of the Science of Food and Agriculture	81		983	987
D4821 	B. Heuer	Effect of late salinization of chia (Salvia hispanica), stock (Matthiola tricuspidata) and evening primrose (Oenothera biennis) on their oil content and quality	2002	Industrial Crops and Products	15		163	167
D4822 	C.W. Weber	The nutritional and chemical evaluation of chia seeds	1991	Ecology of Food and Nutrition	26		119	125
D4841 	J.A. Dudek	Investigation of total dietary fiber methodology in the characterization of the carbohydrate fraction of canned pears	1985	Journal of Food Science	50		851	852
D4861 	I.P. Ting	Chia: a potential oil crop for arid zones	1990	New Industrial Crops and Products			197	200
D4862 	R. Ayerza, Wayne Coates	An omega-3 fatty acid enriched chia diet: Influence on egg fatty acid composition, cholesterol and oil content	1999	Canadian Journal of Animal Science	79		53	58
D4863 	V.C. Wilberg, D.B. Rodriguez-Amaya	HPLC quantitation of major carotenoids of fresh and processed guava, mango and papaya	1995	Lebensmittel-Wissenschaft und-Technologie	28	5	474	480
D4864 	M. Padula, D.B. Rodriguez-Amaya	Characteristics of the carotenoids and assessment of the vitamin A value of Brazilian guavas	1986	Food Chemistry	20		11	19
D4901 	J.I. Rader, C. M. Weaver, G. Angyal	Total folate in enriched cereal grain products in the United States following fortification	2000	Food Chemistry	70		275	289
D4941 	S.D. Senter, G.W.Jr. Chapman, W.R. Jr Forbus, J.A. Payne	Sugar and nonvolatile acid composition of persimmons during maturation	1991	Journal of Food Science	56	4	989	991
D4961 	Elizabeth Nobmann	Nutrient Value of Alaska Native Foods	1993					
D5083 	Carmen Cabrera, Fuensanta Lloris, Rafael Gimenez, Manuel Olalla, M. Carmen Lopez	Mineral content in legumes and nuts: contribution to the Spanish dietary intake.	2003	The Science of the Total Environment	308		1	14
D5202 	V Chaudhary, F Weber	Dietary fiber ingredients obtained by processing brewer's dried grain	1990	Journal of Food Science	55	2	551	553
D5261 	Prakash Bhosale, Igor V. Ermakkov, Maia R. Ermakova, Werner Gellermann, Paul S. Bernstein	Resonance Raman notification of nutritionally important carotenoids in fruit, vegetables, and their juices in comparison to high-pressure liquid chromatography analysis.	2004	Journal of Agricultural and Food Chemistry	52	11	3281	3285
D548  	M. A. Amer, G. J. Brisson	Selenium in Human Food Stuffs Collected at Ste-Foy (Quebec) Food M.L.T.	1973	Canadian Institute of Food Technology Journal	6	3	184	
D566  	J. Leichtev, R. J. Bandoni	Nutrient Content of Mushrooms Grown in British Columbia	1980	Canadian Institute of Food Technology Journal	13	3	122	
D5841 	E.A. Tosi, E. R, H. Lucero, R. Masciarelli	Dietary fiber obtained from amaranth (Amaranthus cruentus) grain by differential milling	2001	Food Chemistry	73		441	443
D5861 	B. Pedersen, K.E.B. Knudsen, B.O. Eggum	The nutritive value of amaranth grain (Amaranthus caudatus): Energy and fibre of raw and processed grain	1990	Plant Food for Human Nutrition	40		61	71
D5881 	N.L. Escudero, M.L. De Arellano, J.M. Luco, M.S. Gimenez, S.I. Mucciarelli	Comparison of chemical composition and nutritional value of Amaranthus cruentus flour and its protein concentrate	2004	Plant Food for Human Nutrition	59		15	21
D614  	L. Hook, I.K. Brandt	Copper content of some low-copper foods	1966	Journal of the American Dietetic Association	49	3	202	203
D642  	 Consumer Reports	Orange Drink Mixes	1977	Consumer Reports		Jan	68	70
D657  	W. J. Hurst, R. A. Martin, B. L. Zoumas	Application of HPLC to Characterization of Individual CHO in Foods	1979	Journal of Food Science	44	3	892	
D672  	L. A. Koehler	Food and Drug Bulletin (beverages gen)	1963	Food and Drug Bulletin No. 134, North Dakota State Lab. 1963	134		134	
D673  	L. A. Koehlar	Food and Drug Bulletin - N. Dakota State Gen. Beverages	1965	Bulletin No. 141, June 1965	141		141	
D739  	J.H. Hankin, S. Margen, N. Goldsmith	Contribution of Hard Water to Calcium and Magnesium Intakes of Adults	1970	Journal of the American Dietetic Association	56	3	212	224
D964  	E.H. Jr. Gruger, R.W. Nelson, M.E. Stansby	Fatty acid composition of oils from 21 species of marine fish, freshwater fish and shellfish.	1964	American Oil Chemists' Society, Journal	41	10	662	667
S10   	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1995					
S1001 	Southeastern Regional Lab (ARS South Atlantic Area), Georgia, USDA	Protein hydrolysis studies on tree nuts	1981		Athens	GA		
S101  	California Pistachio Commission	Nutrition Labeling Database for California Pistachios	1994					
S1023 	Produce Marketing Association (PMA)	Nutrient Content of Banana	1990					
S1024 	Produce Marketing Association (PMA)	Nutrient Content of Cantaloupe	1985					
S1026 	Produce Marketing Association (PMA)	Nutrient Content of Honeydew	1985					
S1027 	Produce Marketing Association (PMA)	Nutrient Content of Watermelon	1989					
S1031 	Produce Marketing Association (PMA)	Nutrient Content of Avocado	1989					
S1032 	Produce Marketing Association (PMA)	Nutrient Content of Date	1986					
S1033 	Produce Marketing Association (PMA)	Nutrient Content of Kiwi	1983					
S1041 	Nutrient Data Laboratory, ARS, USDA	Nutrient composition of Oscar Mayer Luncheon Meats	2002		Beltsville	MD		
S1062 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 6a	2002		Beltsville	MD		
S1063 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 6b	2002		Beltsville	MD		
S1064 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 6c	2002		Beltsville	MD		
S1065 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 6d	2002		Beltsville	MD		
S1066 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 6e	2002		Beltsville	MD		
S1067 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 6f	2002		Beltsville	MD		
S1068 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 6g	2002		Beltsville	MD		
S1069 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 6h	2002		Beltsville	MD		
S1082 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 6i	2002		Beltsville	MD		
S11   	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1996					
S1121 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5n	2001		Beltsville	MD		
S1122 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5o	2001		Beltsville	MD		
S1141 	Produce Marketing Association (PMA)	Nutrient Content of Blueberry	1990					
S1161 	Produce Marketing Association (PMA)	Nutrient Content of Tangerines	1992					
S1162 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 6k	2002		Beltsville	MD		
S1163 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 6l	2002		Beltsville	MD		
S1164 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 6m	2002		Beltsville	MD		
S1166 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 6j	2002		Beltsville	MD		
S1167 	Produce Marketing Association (PMA)	Nutrient Content of Pineapple	1981					
S1183 	Produce Marketing Association (PMA)	Nutrient Content of Apple	1990					
S12   	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1997					
S1202 	Nutrient Data Laboratory, ARS, USDA	Nutrient content of ethnic and geographic specific foods, Southern Testing and Research Laboratories	1995		Beltsville	MD		
S1203 	National Institutes of Health (NIH)	Carotenoid analyses of U.S. foods, Food Composition Laboratory	1997					
S1206 	Nutrient Data Laboratory, ARS, USDA	Continued monitoring of the nutrient content of selected key foods, University of Georgia	1993		Beltsville	MD		
S1209 	Kellogg, Co.	Kellogg Company Data	2002					
S121  	Nutrient Data Laboratory, ARS, USDA	NDL Report Vitamin E 1991	1991		Beltsville	MD		
S1221 	Flax Council of Canada	Nutrient Analysis of Flaxseed by Medallion Lab	1997		Winnipeg			
S1222 	Nutrient Data Laboratory, ARS, USDA	Analysis of fat-free and reduced fat food items, University of Georgia	1992		Beltsville	MD		
S13   	Food Safety and Inspection Service (FSIS), USDA	FSIS Labeling Study	1996					
S1322 	Nutrient Data Laboratory, ARS, USDA	Development/Verification of Nutrient Retention Values in Foods Prepared by Different Cooking Methods	1993		Beltsville	MD		
S1341 	California Prune Board	Carotenoid Analysis of Prunes	2000					
S1343 	Nutrient Data Laboratory, ARS, USDA	Analysis of carotenoids in selected foods.	2002		Beltsville	MD		
S1362 	MGP Ingredients	Nutrient Analyses of Vital Wheat Gluten	2002		Atchison	KS		
S1381 	National Cancer Institute (NCI), DHHS	NCI Contract No. 1-CN-SS442 - Carotenoids	1988					
S14   	National Cattlemen's Beef Association (NCBA)	Nutrient Content of Ground Beef	2000		Chicago	IL		
S1401 	Nutrient Data Laboratory, ARS, USDA	Total dietary fiber in 104 foods	1992		Beltsville	MD		
S141  	Almond Board of California	Nutrient Content of Almonds	1999		Modesto	CA		
S1504 	National Sunflower Association	Phytochemicals in sunflower kernel (Helianthus annus L.) and selected tree nuts	2001		Bismark	ND		
S1562 	Association of Spanish Exporters of Table Olives	Analysis of Spanish Olives	1993					
S1581 	Nutrient Data Laboratory, ARS, USDA	Variety Meats All Food Groups	2003		Beltsville	MD		
S1621 	California Avocado Commission	California Avocado Commission data for avocados 1993-2001	1993					
S1662 	Nutrient Data Laboratory, ARS, USDA	Food Analysis Laboratory and Control Center Folate Stability Study	2002		Beltsville	MD		
S1701 	Ocean Spray Cranberries, Inc.	Nutrient Analysis of Sweetened Dried Cranberries	2002					
S1742 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program - Industrial Flour	2000		Beltsville	MD		
S1782 	University  of Arizona	An omega-3 fatty acid enriched chia diet: Influence on egg fatty acid comp., cholest. & oil content	1999					
S1783 	Ministry of Public Health	Analysis of Salvia hispanica chia seed	2003					
S18   	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 1a	1998		Beltsville	MD		
S182  	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1982					
S1821 	Utah State University	Composition of Foods	1980					
S183  	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1983					
S19   	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 2a	1999		Beltsville	MD		
S2    	National Cattlemen's Beef Association (NCBA)	Nutrient Content of Retail Beef Cuts with 1/8 inch Trim Beef	2000		Chicago	IL		
S20   	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 2b	1999		Beltsville	MD		
S201  	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1984					
S202  	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1985					
S203  	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1986					
S204  	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1987					
S205  	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1988					
S206  	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1998					
S208  	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1999					
S21   	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 2c	1999		Beltsville	MD		
S2103 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 7b	2002		Beltsville	MD		
S2104 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 7c	2002		Beltsville	MD		
S2105 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 7d	2002		Beltsville	MD		
S2108 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 7g	2003		Beltsville	MD		
S2109 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 7h	2003		Beltsville	MD		
S2110 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 7i	2003		Beltsville	MD		
S2111 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 7j	2003		Beltsville	MD		
S2112 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 7k	2003		Beltsville	MD		
S2121 	Nutrient Data Laboratory, ARS, USDA	 FCL-NDL Interlaboratory agreement- Data on Dietary fiber and sugar in foods	1995		Beltsville	MD		
S2122 	Nutrient Data Laboratory, ARS, USDA	Analyses of Selenium in Foods, Hazleton Laboratories	1989		Beltsville	MD		
S2123 	Nutrient Data Laboratory, ARS, USDA	Analyses of Selenium in Foods, Enviromental Trace Substances Research Center	1989		Beltsville	MD		
S2142 	National Sunflower Association	National Sunflower Association Analysis of Vitamin E in Dry Roasted and Oil Roasted Sunflower Seeds	2003		Bismark	ND		
S2161 	Kellogg, Co.	Kellogg Company Data	2003					
S22   	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 3a	2000		Beltsville	MD		
S2202 	Nutrient Data Laboratory, ARS, USDA	Nutrient Content of Legumes and Some Cereal and Baked Products	1984		Beltsville	MD		
S2203 	Nutrient Data Laboratory, ARS, USDA	USDA Commodity pickup 2001	2001		Beltsville	MD		
S221  	National Cattlemen's Beef Association (NCBA)	Beef study, Texas A&M University	1992		Chicago	IL		
S222  	Fred Usinger Inc.	Nutrient Composition of Fred Usinger, Inc. Luncheon Meats	1999		Milwaukee	WI		
S2221 	Nutrient Data Laboratory, ARS, USDA	Industrial Oils, Shortenings and Margarines	2001		Beltsville	MD		
S224  	Tyson Foods, Inc.	Nutrient Composition of Tyson Foods, Inc./Weaver Luncheon Meats	1999		Springdale	AR		
S225  	Bar-S Foods	Nutrient composition of Bar-S Foods Company Luncheon Meats	1999		Clinton	OK		
S226  	Underwood	Nutrient Composition of The Pillsbury Company/Underwood Luncheon Meats	1999		St. Paul	MN		
S227  	Bil Mar Foods	Nutrient Composition of Bil-Mar Foods Luncheon Meats	1999		Zeeland	MI		
S228  	Bridgford	Nutrient Composition of Bridgford Foods of Illinois, Inc. Luncheon Meats	1999		Chicago	IL		
S23   	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 3b	2000		Beltsville	MD		
S230  	Carl Buddig	Nutrient Composition of Carl Buddig and Company Luncheon Meats	1999		South Holland	IL		
S231  	Carando Gourmet	Nutrient Composition of Carando Gourmet Foods Corporation Luncheon Meats	1999		Springfield	MA		
S233  	Citterio USA Corp.	Nutrient Composition of Citterio USA Corporation Luncheon Meats	1999		Freeland	PA		
S235  	Country Smoked Meats	Nutrient Composition of Country Smoked Meats, Inc. Luncheon Meats	1999		Wooster	OH		
S237  	Farmland	Nutrient Composition of Farmland Foods Luncheon Meats	1999		Topeka	KS		
S238  	Gallo Salame	Nutrient Composition of Gallo Salame/Galileo Foods Luncheon Meats	1999		San Lorenzo	CA		
S2381 	Nutrient Data Laboratory, ARS, USDA	American Indian/Alaskan Native Database - Navajo Foods 1999-2000	2000		Beltsville	MD		
S239  	Hillshire Farm & Kahn's	Nutrient Composition of Hillshire Farms and Kahn's Luncheon Meats	1999		Cincinnati	OH		
S2401 	GFA Brands	GFA Brands Company Data	2004					
S241  	Jimmy Dean Foods	Nutrient Composition of Jimmy Dean Foods Luncheon Meats	1999		Cordova	TN		
S242  	Johnsonville Foods Co.	Nutrient Composition of Johnsonville Foods Company Luncheon Meats	1999		Sheboygan Falls	WI		
S2421 	General Mills Inc.	General Mills Company Data	2004					
S2422 	Kraft Foods, Inc.	Kraft Foods	2004					
S243  	Jones	Nutrient Composition of Jones Dairy Farm Luncheon Meats	1999		Fort Atkinson	WI		
S244  	Juniata Packing	Nutrient Composition of Juniata Packing Luncheon Meats	1999					
S245  	Penn Valley Farms	Nutrient Composition of Penn Valley Farms, Ltd. Luncheon Meats	1999		Chicago	IL		
S247  	Schaller & Weber Inc.	Nutrient Composition of Schaller and Weber, Inc. Luncheon Meats	1999		Long Island City	NY		
S248  	Sutton Place Gourmet	Nutrient Composition of Sutton Place Gourmet Luncheon Meats	1999					
S249  	Ohio Agriculture & Devel Center, Wooster, Ohio, KC Institute OH0002	Nutrient Composition of Odom's Tennessee Pride Sausage, Inc. Luncheon Meats	1999		Madison	TN		
S25   	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 4a	2001		Beltsville	MD		
S2502 	Malt-O-Meal Company	Malt-O-Meal Company Data	2004					
S251  	Bob Evans Farms	Nutrient Composition of Bob Evans Farms Luncheon Meats	1999		Columbus	OH		
S252  	Jerome Foods	Nutrient Composition of Jerome Foods/The Turkey Store Company Luncheon Meats	1999		Barron	WI		
S2581 	Nutrient Data Laboratory, ARS, USDA	Fiber Content of Selected Foods	1987		Beltsville	MD		
S259  	Hormel Foods Corp.	Nutrient Composition of Hormel Foods Corporation Luncheon Meats	1999					
S26   	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 4b	2001		Beltsville	MD		
S2621 	California Salmon Council	Nutrient Analysis of King Salmon Samples Caught off of the California Coast	2000		Folsom	CA		
S2644 	National Cancer Institute (NCI), DHHS	Carotenoid content of fruits and vegetables	1988					
S2662 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 8f	2004		Beltsville	MD		
S2664 	Kellogg, Co.	Kellogg Company Data	2004					
S2682 	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	2000					
S2683 	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	2001					
S2684 	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	2002					
S27   	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 4c	2001		Beltsville	MD		
S2702 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 8i	2004		Beltsville	MD		
S2703 	National Cattlemen's Beef Association (NCBA)	Beef Value Cuts 2004	2004		Chicago	IL		
S2722 	Nutrient Data Laboratory, ARS, USDA	Analysis of iron, thiamin, and niacin in unenriched white rice	2004		Beltsville	MD		
S2782 	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 8b	2004		Beltsville	MD		
S2801 	McDonalds	McDonald's Supplied Food Analyses	2004					
S281  	Food Safety and Inspection Service (FSIS), USDA	Nutrient Composition of FSIS 96 NDL SLM Luncheon Meats	1999					
S282  	Owens Country Sausage	Nutrient Composition of Owens Country Sausage Luncheon Meats	1999					
S2841 	Alcohol and Tobacco Tax and Trade Bureau	Wine and malt beverage data from TTB	2004		Beltsville	MD		
S2901 	American Italian Pasta Company	Trans fat in egg noodles	2004			MO		
S2921 	Uncle Ben's, KC Institute GM1065	Niacin in parboiled rice	2005					
S2922 	The Vinegar Institute	Nutrient content of vinegars	2002		Atlanta	GA		
S2941 	Mushroom Council	National Food and Nutrient Analysis program Wave 9b	2004		Dublin	CA		
S2961 	Sunkist Growers, Inc. , KC Institute GM1108	Nutrient content of citrus fruits	2004					
S2985 	Castle and Cooke (Dole), KC Institute GM1120	Select nutrients in pineapple fruit and juice	1979					
S3    	University of Wisconsin - Madison, Muscle Biology Laboratory	Nutrient Content of Alternate Red Meat Products	2000		Madison	WI		
S3081 	National Grain Sorghum Producers	Dietary fiber content of ground whole sorghum grain	2005					
S343  	International Nut Council	Nutrient Content of Cashews	1999					
S363  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5c	2001		Beltsville	MD		
S381  	Nutrient Data Laboratory, ARS, USDA	Nutrient Analysis of Specialty Fruit Marketed in the United States	1987		Beltsville	MD		
S39   	Nutrient Data Laboratory, ARS, USDA	National Food and Analysis Program Wave 0	1998		Beltsville	MD		
S404  	Nutrient Data Laboratory, ARS, USDA	Determination of the Nutrient Content of Selected Candies, Nuts, Condiments, Beverages & Vegetables	1985		Beltsville	MD		
S405  	Nutrient Data Laboratory, ARS, USDA	Monitoring Nutrient Content of Selected Key Foods	1992		Beltsville	MD		
S406  	Nutrient Data Laboratory, ARS, USDA	Nutritional Evaluation of the Solid and Liquid Portion of Selected Canned Fruits and Vegetables	1986		Beltsville	MD		
S421  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 4d	2001		Beltsville	MD		
S441  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5k	2001		Beltsville	MD		
S461  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 4e	2001		Beltsville	MD		
S481  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5g	2001		Beltsville	MD		
S482  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5i	2001		Beltsville	MD		
S5    	Food and Drug Administration (FDA), DHHS	FDA Study on Labeling	1996					
S502  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5j	2001		Beltsville	MD		
S503  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5d	2001		Beltsville	MD		
S53   	Produce Marketing Association (PMA)	Nutrient Content of Sweet Cherries	1990					
S541  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5a	2001		Beltsville	MD		
S561  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5b	2000		Beltsville	MD		
S562  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 4f	2000		Beltsville	MD		
S563  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5e	2001		Beltsville	MD		
S564  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5f	2001		Beltsville	MD		
S565  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5h	2001		Beltsville	MD		
S566  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5L	2001		Beltsville	MD		
S581  	Produce Marketing Association (PMA)	Nutrient Content of Strawberries	1989					
S582  	Nutrient Data Laboratory, ARS, USDA	National Food and Nutrient Analysis Program Wave 5m	2001		Beltsville	MD		
S6    	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1991					
S603  	General Mills Inc.	General Mills Company Data	2001					
S604  	Nutrient Data Laboratory, ARS, USDA	Investigation of the carbohydrate fraction of foods . . . raw, processed and prepared	1985		Beltsville	MD		
S606  	Nutrient Data Laboratory, ARS, USDA	Variability of  the sugar content of foods	1989		Beltsville	MD		
S608  	Produce Marketing Association (PMA)	Nutrient Content of Tomato	1983					
S611  	Produce Marketing Association (PMA)	Nutrient Content of Pepper	1987					
S615  	Produce Marketing Association (PMA)	Nutrient Content of Eggplant	1991					
S616  	Produce Marketing Association (PMA)	Nutrient content of Broccoflower	1992					
S617  	Produce Marketing Association (PMA)	Nutrient Content of Radish	1982					
S618  	Produce Marketing Association (PMA)	Nutrient Content of Carrot	1982					
S619  	Produce Marketing Association (PMA)	Nutrient Content of Broccoli	1982					
S620  	Produce Marketing Association (PMA)	Nutrient Content of Lettuce	1991					
S622  	Produce Marketing Association (PMA)	Nutrient Content of Squash	1991					
S624  	Produce Marketing Association (PMA)	Nutrient Content of Lettuce	1982					
S625  	National Food Processors Association	NFPA Canned Vegetables	1993					
S626  	National Food Processors Association	NFPA Canned Vegetables	1995					
S627  	National Food Processors Association	NFPA Canned Vegetables	1994					
S641  	National Food Processors Association	NFPA Canned Vegetables	1992					
S642  	National Cancer Institute (NCI), DHHS	Total dietary fiber content of selected foods	1992					
S661  	Dahlgren & Company, Inc.	Sunflower analysis for Dahlgren & Company	1996		Crookston	MN		
S682  	Kellogg, Co.	Kellogg Company Data	2001					
S7    	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1992					
S702  	The Quaker Oats, Co.	Quaker Oats Company Data	2001					
S73   	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1989					
S74   	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1990					
S743  	Nutrient Data Laboratory, ARS, USDA	University of Idaho Contract No. 53-3198-8-29	1989		Beltsville	MD		
S77   	International Nut Council	Nutrient Content of Macadamia Nuts	1999					
S78   	Produce Marketing Association (PMA)	Nutrient Content of Mushrooms	1982					
S79   	California Walnut Commission	Nutrient Content of Walnuts	1999		Modesto	CA		
S8    	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1993					
S80   	Mushroom Council	Nutrient Content of Mushrooms	1999					
S81   	Nutrient Data Laboratory, ARS, USDA	Nutrient Analysis of Selected Foods, University of Georgia	1987		Beltsville	MD		
S82   	Nutrient Data Laboratory, ARS, USDA	Determination of the Tocopherol Content of Selected Foods	1990		Beltsville	MD		
S822  	Kraft Foods, Inc.	Kraft Study, Hazelton Lab	1992					
S83   	Hazelnut Marketing Board	Nutrient Content of Hazelnuts	1999		Aurora	OR		
S837  	Nutrient Data Laboratory, ARS, USDA	Dietary Fiber and Sugars in Commonly Consumed Foods	1994		Beltsville	MD		
S84   	Nutrient Data Laboratory, ARS, USDA	Determination of the Tocopherol Content of Selected Foods	1992		Beltsville	MD		
S85   	Pecan Shellers Association	Nutrient Content of Pecans	1999					
S86   	California Pistachio Commission	Nutrient Content of Pistachio Nuts	1999					
S87   	Nutrient Data Laboratory, ARS, USDA	NDL Report Vitamin E 1997	1997		Beltsville	MD		
S881  	The Quaker Oats, Co.	Quaker Oats Co. 02	2002					
S9    	Food and Drug Administration (FDA), DHHS	FDA Total Diet Study	1994					
S941  	Hammons Products Company	Nutrient Analysis of Black Walnuts	2002		Stockton	MO		
S961  	National Sunflower Association	Nutrient Analysis of Oil Roasted Sunflower Seeds	2000		Bismark	ND		
S963  	Produce Marketing Association (PMA)	Nutrient Content of Raspberries	1990					
S986  	University of Maine	Determination of alpha- and beta-carotene in fruit and vegetables by HPLC	1982					
\.


--
-- Data for Name: datsrcln; Type: TABLE DATA; Schema: public; Owner: -
--

COPY datsrcln (ndb_no, nutr_no, datasrc_id) FROM stdin;
01026	203	S25   
01029	203	S27   
01032	203	S19   
01040	203	S27   
01046	203	S19   
01077	203	S27   
01079	203	S1063 
01079	203	S20   
01082	203	S1063 
01085	203	S1063 
01103	203	S1163 
01123	203	S1063 
01123	203	S561  
01124	203	S1065 
01125	203	S1065 
01202	203	S1163 
02048	203	S2109 
02053	203	S2109 
04017	203	S19   
04020	203	S19   
04021	203	S19   
04023	203	S19   
04053	203	S19   
04114	203	S19   
04120	203	S19   
04141	203	S19   
04142	203	S19   
04143	203	S19   
04144	203	S19   
04367	203	S19   
04610	203	S18   
04628	203	S18   
04629	203	S18   
04630	203	S19   
04631	203	S20   
04635	203	S19   
04636	203	S19   
04638	203	S26   
04639	203	S26   
04640	203	S26   
04641	203	S25   
04656	203	S2221 
04657	203	S2221 
04658	203	S2221 
04659	203	S2221 
04660	203	S2221 
04661	203	S2221 
04662	203	S2221 
04663	203	S2221 
04673	203	S2401 
04674	203	S2401 
04675	203	S2401 
04676	203	S2401 
04677	203	S2401 
05023	203	S1581 
05024	203	S1581 
05027	203	S1082 
05028	203	S1082 
05173	203	S1581 
05174	203	S1581 
05175	203	S1581 
05176	203	S1581 
05177	203	S1581 
05178	203	S1581 
05312	203	S26   
05313	203	S26   
05320	203	S26   
05623	203	D4282 
05624	203	S3    
05625	203	D4282 
05626	203	D4281 
05626	203	D4282 
05627	203	D4282 
05628	203	D4281 
05628	203	D4282 
05629	203	D4281 
05630	203	D4282 
05631	203	D4282 
05632	203	S3    
05643	203	D4301 
05644	203	D4301 
05645	203	D4301 
05646	203	D4301 
05647	203	D4301 
05648	203	D4301 
05649	203	D4301 
05650	203	D4301 
05651	203	D4301 
05652	203	D4301 
05653	203	D4301 
05654	203	D4301 
05655	203	D4301 
05656	203	D4301 
05657	203	D4301 
05658	203	D4301 
05661	203	S1082 
06016	203	S18   
06019	203	S18   
06043	203	S18   
06094	203	S18   
06128	203	S18   
06159	203	S18   
06164	203	S23   
06931	203	S22   
06982	203	S18   
06983	203	S18   
06984	203	S2104 
06985	203	S2104 
07002	203	S222  
07005	203	S248  
07006	203	S247  
07007	203	S1164 
07008	203	S238  
07011	203	S227  
07011	203	S281  
07013	203	S242  
07013	203	S281  
07014	203	S281  
07015	203	S248  
07016	203	S248  
07018	203	S226  
07021	203	S237  
07023	203	S242  
07027	203	S281  
07028	203	S225  
07028	203	S230  
07028	203	S281  
07029	203	S281  
07032	203	S281  
07034	203	S249  
07038	203	S281  
07039	203	S244  
07043	203	S230  
07052	203	S227  
07056	203	S248  
07057	203	S281  
07058	203	S237  
07063	203	S1164 
07063	203	S582  
07064	203	S1164 
07068	203	S1041 
07072	203	S281  
07075	203	S1164 
07076	203	S239  
07078	203	S228  
07078	203	S281  
07079	203	S13   
07079	203	S227  
07079	203	S281  
07080	203	S227  
07083	203	S281  
07089	203	S241  
07089	203	S251  
07201	203	S281  
07202	203	S281  
07205	203	S281  
07207	203	S281  
07209	203	S281  
07211	203	S281  
07212	203	S281  
07213	203	S281  
07230	203	S281  
07233	203	S281  
07240	203	S281  
07242	203	S281  
07254	203	S281  
07255	203	S281  
07256	203	S281  
07268	203	S281  
07276	203	S281  
07278	203	S259  
07279	203	S259  
07905	203	S281  
07906	203	S281  
07908	203	S281  
07909	203	S259  
07910	203	S245  
07911	203	S226  
07912	203	S226  
07913	203	S238  
07914	203	S252  
07915	203	S281  
07916	203	S242  
07917	203	S242  
07918	203	S242  
07919	203	S252  
07920	203	S242  
07921	203	S228  
07922	203	S242  
07923	203	S245  
07924	203	S242  
07925	203	S281  
07926	203	S228  
07927	203	S227  
07928	203	S225  
07929	203	S227  
07930	203	S222  
07931	203	S222  
07932	203	S224  
07933	203	S224  
07934	203	S281  
07935	203	S224  
07936	203	S247  
07937	203	S239  
07938	203	S233  
07939	203	S235  
07940	203	S237  
07941	203	S281  
07942	203	S281  
07943	203	S281  
07944	203	S227  
07949	203	S23   
07950	203	S23   
07951	203	S243  
07952	203	S1164 
07953	203	S1164 
07953	203	S582  
07954	203	S582  
07955	203	S1164 
07956	203	S1164 
07957	203	S1164 
07958	203	S1164 
07959	203	S1164 
07960	203	S1164 
08001	203	S1065 
08003	203	S2664 
08005	203	S2664 
08010	203	S702  
08011	203	S702  
08012	203	S1065 
08013	203	S1065 
08014	203	S1065 
08017	203	S603  
08018	203	S702  
08019	203	S603  
08020	203	S1065 
08023	203	S2664 
08025	203	S2662 
08026	203	S603  
08028	203	S2664 
08030	203	S1065 
08031	203	S2664 
08032	203	S2664 
08035	203	S603  
08045	203	S603  
08047	203	S702  
08048	203	S603  
08049	203	S702  
08050	203	S603  
08054	203	S702  
08057	203	S603  
08058	203	S2664 
08059	203	S702  
08060	203	S2664 
08061	203	S1065 
08064	203	S603  
08065	203	S1065 
08065	203	S2662 
08066	203	S702  
08067	203	S2664 
08068	203	S2664 
08069	203	S2664 
08071	203	S2664 
08074	203	S2662 
08077	203	S1065 
08078	203	S603  
08082	203	S603  
08083	203	S2502 
08085	203	S702  
08086	203	S603  
08087	203	S603  
08089	203	S603  
08092	203	S702  
08094	203	S702  
08116	203	S2502 
08124	203	S702  
08128	203	S702  
08130	203	S702  
08138	203	S2502 
08139	203	S603  
08146	203	S702  
08147	203	S1065 
08147	203	S2422 
08177	203	S2502 
08189	203	S2664 
08190	203	S603  
08194	203	S603  
08200	203	S702  
08202	203	S603  
08206	203	S2502 
08210	203	S702  
08211	203	S702  
08212	203	S702  
08214	203	S702  
08215	203	S702  
08216	203	S702  
08217	203	S2664 
08218	203	S1065 
08219	203	S702  
08220	203	S702  
08221	203	S702  
08225	203	S702  
08229	203	S702  
08231	203	S702  
08232	203	S702  
08243	203	S603  
08244	203	S603  
08245	203	S603  
08247	203	S603  
08253	203	S2664 
08258	203	S2664 
08259	203	S2662 
08262	203	S603  
08263	203	S603  
08266	203	S603  
08267	203	S603  
08268	203	S603  
08269	203	S603  
08270	203	S603  
08271	203	S603  
08272	203	S603  
08273	203	S603  
08274	203	S603  
08277	203	S603  
08278	203	S603  
08283	203	S2664 
08284	203	S2664 
08286	203	S2664 
08287	203	S2664 
08288	203	S2664 
08289	203	S2664 
08293	203	S702  
08294	203	S702  
08299	203	S702  
08309	203	S2664 
08315	203	S702  
08316	203	S702  
08317	203	S702  
08318	203	S2664 
08319	203	S2664 
08345	203	S603  
08346	203	S2502 
08347	203	S2502 
08348	203	S2502 
08349	203	S2502 
08350	203	S2502 
08351	203	S702  
08352	203	S702  
08353	203	S702  
08354	203	S702  
08355	203	S702  
08357	203	S702  
08358	203	S702  
08359	203	S702  
08360	203	S702  
08361	203	S702  
08362	203	S702  
08363	203	S702  
08364	203	S702  
08366	203	S702  
08367	203	S603  
08368	203	S603  
08370	203	S603  
08371	203	S603  
08372	203	S603  
08374	203	S2664 
08376	203	S2664 
08378	203	S2161 
08379	203	S2664 
08380	203	S2664 
08383	203	S2664 
08384	203	S2664 
08385	203	S2664 
08386	203	S2664 
08387	203	S2664 
08388	203	S2664 
08389	203	S2664 
08390	203	S2664 
08391	203	S682  
08392	203	S2664 
08393	203	S2664 
08394	203	S702  
08395	203	S702  
08396	203	S702  
08397	203	S603  
08398	203	S603  
08399	203	S603  
08400	203	S881  
08401	203	S881  
08402	203	S702  
08403	203	S1209 
08408	203	S2502 
08409	203	S2502 
08410	203	S702  
08411	203	S702  
08412	203	S702  
08413	203	S702  
08414	203	S702  
08415	203	S702  
08416	203	S702  
08417	203	S702  
08418	203	S702  
08419	203	S702  
08420	203	S702  
08421	203	S702  
08422	203	S702  
08435	203	S1065 
08436	203	S702  
08444	203	S702  
08446	203	S702  
08448	203	S702  
08449	203	S702  
08450	203	S702  
08454	203	S2664 
08455	203	S2664 
08456	203	S2664 
08457	203	S2664 
08458	203	S2664 
08459	203	S2664 
08460	203	S2664 
08461	203	S2664 
08462	203	S2664 
08463	203	S2664 
08464	203	S2664 
08465	203	S2664 
08466	203	S2664 
08467	203	S2161 
08468	203	S2664 
08469	203	S2664 
08470	203	S2664 
08471	203	S2664 
08472	203	S2664 
08473	203	S2664 
08474	203	S2664 
08476	203	S2502 
08478	203	S2502 
08481	203	S2502 
08482	203	S2502 
08483	203	S2502 
08484	203	S2502 
08487	203	S2502 
08488	203	S2502 
08489	203	S2502 
08490	203	S2502 
08491	203	S2502 
08492	203	S2502 
08493	203	S2502 
08494	203	S2502 
08495	203	S2502 
08497	203	S2502 
08498	203	S2502 
08500	203	S2502 
08501	203	S2502 
08504	203	S2662 
08505	203	S2662 
08506	203	S2662 
08507	203	S2662 
08508	203	S2662 
08509	203	S2662 
09003	203	S1183 
09003	203	S502  
09003	203	S561  
09004	203	S502  
09032	203	S21   
09037	203	S1031 
09037	203	S1621 
09037	203	S381  
09037	203	S481  
09037	203	S502  
09038	203	S1031 
09038	203	S1621 
09038	203	S481  
09038	203	S502  
09039	203	S381  
09040	203	S1023 
09040	203	S481  
09040	203	S562  
09042	203	S461  
09042	203	S566  
09050	203	S1141 
09050	203	S421  
09050	203	S441  
09060	203	S381  
09062	203	S381  
09062	203	S404  
09070	203	S53   
09070	203	S582  
09078	203	S561  
09079	203	S1701 
09087	203	S1032 
09087	203	S564  
09087	203	S582  
09094	203	S363  
09094	203	S582  
09112	203	S482  
09112	203	S563  
09132	203	S1062 
09139	203	S381  
09148	203	S1033 
09148	203	S363  
09148	203	S582  
09149	203	S381  
09160	203	S1065 
09181	203	S1024 
09181	203	S1121 
09181	203	S461  
09183	203	S381  
09184	203	S1026 
09184	203	S562  
09184	203	S565  
09191	203	S421  
09191	203	S582  
09195	203	S1202 
09195	203	S1562 
09202	203	S482  
09202	203	S564  
09218	203	S1065 
09218	203	S1161 
09236	203	S461  
09236	203	S582  
09252	203	S482  
09252	203	S541  
09266	203	S1167 
09266	203	S441  
09266	203	S561  
09273	203	S2104 
09273	203	S2985 
09279	203	S421  
09279	203	S582  
09291	203	S564  
09291	203	S566  
09298	203	S5    
09298	203	S564  
09298	203	S566  
09302	203	S381  
09302	203	S461  
09302	203	S566  
09302	203	S963  
09316	203	S1162 
09316	203	S421  
09316	203	S566  
09316	203	S581  
09316	203	S604  
09326	203	S1027 
09326	203	S441  
09326	203	S461  
09328	203	S1206 
09409	203	S2104 
09409	203	S2985 
09421	203	S564  
09421	203	S582  
09422	203	S1202 
09427	203	D4053 
09428	203	D4053 
09429	203	S1167 
09429	203	S441  
09430	203	S441  
09430	203	S561  
09431	203	S2203 
09432	203	S2203 
09433	203	S2105 
09433	203	S2961 
10007	203	S1082 
10066	203	S1082 
10067	203	S1082 
10068	203	S1082 
10098	203	S1581 
10099	203	S1581 
10102	203	S1581 
10119	203	S1581 
10123	203	S1082 
10124	203	S1082 
10173	203	S1581 
10858	203	S1082 
10860	203	S1082 
10861	203	S1082 
10862	203	S1082 
10863	203	S1581 
10864	203	S1082 
11011	203	S1069 
11012	203	S1069 
11090	203	S1121 
11090	203	S564  
11090	203	S619  
11091	203	S1121 
11091	203	S564  
11096	203	S1121 
11096	203	S482  
11097	203	S482  
11112	203	S1065 
11113	203	S1065 
11124	203	S1062 
11124	203	S618  
11125	203	S1062 
11130	203	S25   
11131	203	S25   
11143	203	S1121 
11143	203	S564  
11157	203	S1202 
11205	203	S1062 
11206	203	S1062 
11243	203	S2941 
11250	203	S562  
11250	203	S565  
11251	203	S481  
11251	203	S503  
11251	203	S620  
11252	203	S481  
11252	203	S562  
11252	203	S624  
11253	203	S565  
11257	203	S565  
11260	203	D566  
11260	203	S1821 
11260	203	S2941 
11260	203	S78   
11260	203	S80   
11263	203	S2941 
11267	203	S2941 
11282	203	S1062 
11286	203	S1062 
11294	203	S563  
11294	203	S582  
11333	203	S1062 
11333	203	S611  
11339	203	S1062 
11352	203	S563  
11352	203	S566  
11353	203	S563  
11353	203	S566  
11354	203	S563  
11354	203	S566  
11355	203	S563  
11355	203	S566  
11356	203	S563  
11356	203	S566  
11357	203	S563  
11357	203	S566  
11358	203	S563  
11358	203	S566  
11359	203	S2105 
11360	203	S2105 
11394	203	S2105 
11395	203	S2105 
11398	203	S2105 
11399	203	S2105 
11402	203	S2105 
11403	203	S2105 
11411	203	S2105 
11412	203	S2105 
11429	203	S1121 
11429	203	S363  
11429	203	S617  
11463	203	S25   
11464	203	S25   
11507	203	S1062 
11508	203	S1062 
11510	203	S1062 
11529	203	S441  
11529	203	S503  
11529	203	S608  
11530	203	S441  
11546	203	S21   
11546	203	S5    
11546	203	S625  
11546	203	S626  
11546	203	S627  
11546	203	S641  
11547	203	S21   
11547	203	S625  
11547	203	S626  
11547	203	S627  
11549	203	S21   
11644	203	S1821 
11674	203	S563  
11674	203	S566  
11705	203	S1069 
11752	203	S1065 
11757	203	S1062 
11760	203	S25   
11821	203	S1062 
11828	203	S563  
11828	203	S566  
11841	203	S2105 
11842	203	S2105 
11856	203	S25   
11875	203	S1062 
11876	203	S1062 
11884	203	S441  
11887	203	S21   
11887	203	S5    
11887	203	S625  
11887	203	S626  
11887	203	S627  
11887	203	S641  
11888	203	S21   
11888	203	S625  
11888	203	S626  
11888	203	S627  
11921	203	S1062 
11935	203	S22   
11935	203	S5    
11949	203	S22   
11949	203	S5    
11950	203	S2941 
11960	203	S481  
11960	203	S562  
11987	203	S1202 
11987	203	S2941 
11990	203	S1202 
11991	203	S1202 
11992	203	S2941 
12006	203	D4822 
12006	203	D4861 
12006	203	D4862 
12006	203	S1783 
12038	203	S661  
12038	203	S961  
12061	203	S141  
12062	203	S141  
12063	203	S141  
12065	203	S141  
12078	203	S1063 
12078	203	S503  
12086	203	S343  
12086	203	S363  
12086	203	S502  
12087	203	S343  
12120	203	S83   
12121	203	S83   
12122	203	S83   
12131	203	S77   
12132	203	S77   
12142	203	S85   
12143	203	S85   
12144	203	S85   
12147	203	S502  
12147	203	S564  
12151	203	S101  
12151	203	S86   
12152	203	S101  
12152	203	S86   
12154	203	S1001 
12154	203	S941  
12155	203	S79   
12201	203	S1164 
12220	203	D4743 
12220	203	S1221 
12220	203	S2109 
12538	203	S661  
12538	203	S961  
12563	203	S141  
12565	203	S141  
12586	203	S343  
12586	203	S363  
12586	203	S502  
12632	203	S77   
12643	203	S85   
12644	203	S85   
12652	203	S101  
12652	203	S86   
13019	203	S2    
13020	203	S2    
13039	203	S221  
13055	203	S2    
13065	203	S2    
13067	203	S2    
13068	203	S2    
13070	203	S2    
13096	203	S2    
13098	203	S2    
13165	203	S2    
13318	203	S1581 
13320	203	S1581 
13321	203	S1581 
13322	203	S1581 
13323	203	S1581 
13324	203	S1581 
13325	203	S1082 
13326	203	S1082 
13327	203	S1082 
13340	203	S1581 
13341	203	S1581 
13343	203	S2    
13355	203	S230  
13355	203	S231  
13369	203	S2    
13370	203	S2    
13373	203	S2    
13375	203	S2    
13377	203	S2    
13378	203	S2    
13391	203	S2    
13394	203	S2    
13398	203	S2    
13399	203	S2    
13401	203	S2    
13402	203	S2    
13404	203	S2    
13405	203	S2    
13407	203	S2    
13408	203	S2    
13410	203	S2    
13411	203	S2    
13413	203	S2    
13414	203	S2    
13415	203	S2    
13416	203	S2    
13417	203	S2    
13418	203	S2    
13419	203	S2    
13420	203	S2    
13421	203	S2    
13422	203	S2    
13423	203	S2    
13424	203	S2    
13425	203	S2    
13426	203	S2    
13439	203	S2    
13440	203	S2    
13441	203	S2    
13442	203	S2    
13443	203	S2    
13444	203	S2    
13445	203	S2    
13446	203	S2    
13447	203	S2    
13448	203	S2    
13449	203	S2    
13450	203	S2    
13451	203	S2    
13452	203	S2    
13453	203	S2    
13454	203	S2    
13455	203	S2    
13456	203	S2    
13467	203	S221  
13468	203	S221  
13469	203	S221  
13470	203	S221  
13481	203	S221  
13482	203	S221  
13483	203	S221  
13484	203	S221  
13485	203	S2    
13486	203	S2    
13487	203	S2    
13488	203	S2    
13490	203	S2    
13491	203	S2    
13492	203	S2    
13493	203	S2    
13494	203	S14   
13495	203	S14   
13496	203	S14   
13497	203	S14   
13498	203	S14   
13565	203	S2703 
13566	203	S2703 
13567	203	S2703 
13568	203	S2703 
13569	203	S2703 
13805	203	S2    
13806	203	S2    
13809	203	S2    
13810	203	S2    
13811	203	S2    
13812	203	S2    
13813	203	S2    
13814	203	S2    
13850	203	S2    
13851	203	S2    
13853	203	S2    
13854	203	S2    
13856	203	S2    
13857	203	S2    
13868	203	S2    
13869	203	S2    
13870	203	S2    
13871	203	S2    
13872	203	S2    
13873	203	S2    
13874	203	S2    
13875	203	S2    
13876	203	S2    
13877	203	S2    
13878	203	S2    
13879	203	S2    
13880	203	S2    
13881	203	S2    
13882	203	S2    
13891	203	S2    
13893	203	S2    
13894	203	S2    
13896	203	S2    
13898	203	S2    
13900	203	S2    
13909	203	S2    
13910	203	S2    
13911	203	S2    
13912	203	S2    
13913	203	S2    
13914	203	S2    
13917	203	S2    
13918	203	S2    
13920	203	S2    
13921	203	S2    
13923	203	S2    
13924	203	S2    
13929	203	S2    
13930	203	S2    
13931	203	S2    
13932	203	S2    
13934	203	S2    
13935	203	S2    
13936	203	S221  
13937	203	S221  
13938	203	S221  
13939	203	S221  
13940	203	S221  
13941	203	S221  
13942	203	S221  
13943	203	S221  
13944	203	S221  
13945	203	S221  
13946	203	S221  
13947	203	S221  
13948	203	S2    
13949	203	S2    
13950	203	S2    
13951	203	S2    
13952	203	S2    
13953	203	S2    
13954	203	S2    
13955	203	S2    
13956	203	S2    
13957	203	S2    
13958	203	S2    
13959	203	S2    
13960	203	S221  
13961	203	S221  
13962	203	S221  
13963	203	S221  
13964	203	S221  
13965	203	S221  
13966	203	S221  
13967	203	S221  
13968	203	S2    
13969	203	S2    
13970	203	S2    
13971	203	S2    
13976	203	S221  
13977	203	S221  
13978	203	S221  
13979	203	S221  
13985	203	S2    
13987	203	S221  
13988	203	S2703 
13989	203	S2703 
13990	203	S2703 
13991	203	S2703 
13992	203	S2703 
13994	203	S2703 
13995	203	S2703 
13996	203	S2703 
13997	203	S2703 
13998	203	S2703 
14003	203	S2841 
14006	203	S2841 
14084	203	S2103 
14096	203	S2103 
14106	203	S2103 
14137	203	S1068 
14144	203	S1068 
14145	203	S1064 
14145	203	S1066 
14145	203	S1068 
14145	203	S1122 
14146	203	S1068 
14147	203	S1068 
14148	203	S1068 
14149	203	S1068 
14154	203	S2702 
14156	203	S2702 
14209	203	S1064 
14209	203	S1066 
14209	203	S1122 
14209	203	S23   
14238	203	S2104 
14242	203	S2104 
14323	203	S1067 
14347	203	S1064 
14347	203	S1122 
14366	203	S2104 
14370	203	S2104 
14400	203	S1064 
14400	203	S1066 
14400	203	S1068 
14400	203	S1122 
14416	203	S1064 
14416	203	S1066 
14416	203	S1068 
14416	203	S1122 
14434	203	S1068 
14440	203	S2109 
14462	203	S2109 
14475	203	S1068 
14476	203	S1068 
14601	203	S1066 
14602	203	S2103 
15027	203	S1163 
15073	203	S1163 
15078	203	D1066 
15078	203	D1107 
15078	203	D2793 
15078	203	S2621 
15087	203	S2109 
15152	203	S2104 
15232	203	S1163 
15260	203	S2109 
15261	203	S1163 
15262	203	S1163 
16006	203	S1164 
16010	203	S1164 
16011	203	S1164 
16029	203	S1164 
16038	203	S1164 
16038	203	S2202 
16042	203	S1065 
16042	203	S2202 
16043	203	S1065 
16043	203	S2202 
16089	203	S563  
16097	203	S22   
16098	203	S22   
16112	203	S39   
16114	203	S39   
16120	203	S39   
16123	203	S39   
16126	203	S39   
16139	203	S39   
16147	203	S2104 
16159	203	D342  
16159	203	S39   
16167	203	S2203 
16174	203	S18   
16338	203	S1164 
16338	203	S2202 
16343	203	S1065 
16343	203	S2202 
16397	203	S22   
16398	203	S22   
17202	203	S1082 
17203	203	S1082 
17204	203	S1082 
17218	203	S1581 
17219	203	S1581 
17332	203	S3    
17335	203	S3    
17340	203	S3    
17341	203	S3    
17342	203	S3    
17345	203	S3    
17346	203	S3    
17347	203	S3    
17348	203	S3    
18001	203	S1162 
18002	203	S1162 
18069	203	S20   
18079	203	S25   
18159	203	S21   
18166	203	S25   
18168	203	S25   
18215	203	S25   
18228	203	S23   
18231	203	S25   
18258	203	S1162 
18259	203	S1162 
18262	203	S1162 
18263	203	S1162 
18288	203	S27   
18350	203	S21   
18364	203	S22   
18365	203	S27   
18376	203	S25   
18403	203	S27   
18927	203	S25   
18930	203	S2203 
18931	203	S2203 
18932	203	S27   
18933	203	S27   
18934	203	S27   
18935	203	S27   
18936	203	S27   
19003	203	S26   
19014	203	S5    
19034	203	S26   
19035	203	S26   
19047	203	S1162 
19056	203	S26   
19057	203	S2109 
19058	203	S2109 
19064	203	S1164 
19076	203	S1164 
19109	203	S1164 
19120	203	S1069 
19155	203	S1164 
19230	203	S1063 
19283	203	S1067 
19300	203	S5    
19337	203	S2109 
19350	203	S1164 
19411	203	S26   
19856	203	S1067 
19868	203	S2109 
19873	203	S1067 
20046	203	S20   
20047	203	S20   
20048	203	S20   
20049	203	S20   
20099	203	S1163 
20099	203	S20   
20099	203	S5    
20100	203	S1163 
20100	203	S20   
20100	203	S2901 
20109	203	S2105 
20110	203	S2105 
20120	203	S1163 
20120	203	S20   
20120	203	S5    
20121	203	S1163 
20121	203	S20   
20121	203	S2901 
20132	203	S1202 
20310	203	S2105 
20321	203	S1163 
20321	203	S20   
20321	203	S2901 
20400	203	S1163 
20400	203	S20   
20400	203	S2901 
20409	203	S2105 
20410	203	S2105 
20420	203	S1163 
20420	203	S20   
20420	203	S5    
20421	203	S1163 
20421	203	S20   
20421	203	S2901 
20446	203	S20   
20447	203	S20   
20499	203	S1163 
20499	203	S20   
20499	203	S5    
20510	203	S2105 
20521	203	S1163 
20521	203	S20   
20521	203	S2901 
20623	203	S1742 
20624	203	S1742 
20628	203	S1742 
20629	203	S1742 
20630	203	S1742 
20634	203	S1742 
20635	203	S1742 
20636	203	S1742 
20640	203	S1742 
20641	203	S1742 
20645	203	S1742 
20646	203	S1742 
21138	203	S1064 
21138	203	S1066 
21138	203	S1122 
21141	203	S1064 
21224	203	S19   
21225	203	S19   
21226	203	S22   
21227	203	S22   
21229	203	S1122 
21238	203	S2801 
21239	203	S1066 
21240	203	S1066 
21241	203	S1066 
21242	203	S1066 
21243	203	S1066 
21244	203	S1066 
21245	203	S1066 
21246	203	S1066 
21247	203	S1066 
21248	203	S1066 
21249	203	S1064 
21250	203	S1064 
21251	203	S1064 
21252	203	S1064 
21253	203	S1064 
21254	203	S1064 
21255	203	S1064 
21256	203	S1064 
21257	203	S1064 
21259	203	S1064 
21260	203	S1082 
21261	203	S1082 
21262	203	S1082 
21263	203	S1082 
21264	203	S1082 
21265	203	S1082 
21266	203	S1082 
21267	203	S1082 
21268	203	S1082 
21269	203	S1082 
21270	203	S1082 
21271	203	S2108 
21272	203	S2108 
21273	203	S2108 
21274	203	S2108 
21275	203	S2108 
21276	203	S2108 
21277	203	S2110 
21278	203	S2110 
21279	203	S2110 
21280	203	S2110 
21281	203	S2110 
21282	203	S2110 
21283	203	S2111 
21284	203	S2111 
21285	203	S2111 
21286	203	S2111 
21287	203	S2112 
21288	203	S2112 
21289	203	S2112 
21290	203	S2112 
21291	203	S2112 
21292	203	S2112 
21293	203	S2782 
21294	203	S2782 
21295	203	S2782 
21296	203	S2782 
21297	203	S2782 
21298	203	S2782 
21299	203	S2110 
21299	203	S2111 
21299	203	S2112 
21299	203	S2782 
21300	203	S2110 
21300	203	S2112 
21300	203	S2782 
21301	203	S2110 
21301	203	S2111 
21301	203	S2112 
21301	203	S2782 
21302	203	S2110 
21302	203	S2111 
21302	203	S2112 
21302	203	S2782 
21303	203	S2110 
21303	203	S2112 
21303	203	S2782 
21304	203	S2110 
21304	203	S2111 
21304	203	S2112 
21304	203	S2782 
21308	203	S2801 
21309	203	S2801 
21310	203	S2801 
21311	203	S2801 
21312	203	S2801 
21313	203	S2801 
21314	203	S2801 
21315	203	S2801 
21316	203	S2801 
21317	203	S2801 
21318	203	S2801 
21319	203	S2801 
21320	203	S2801 
21321	203	S2801 
21322	203	S2801 
21323	203	S2801 
21324	203	S2801 
21325	203	S2801 
21326	203	S2801 
21337	203	S2801 
21342	203	S2801 
21343	203	S2801 
21346	203	S2801 
21347	203	S2801 
21348	203	S2801 
21349	203	S2801 
22247	203	S20   
22903	203	S21   
22904	203	S18   
22909	203	S22   
22911	203	S18   
22912	203	S19   
22914	203	S19   
22915	203	S19   
22916	203	S19   
23009	203	S2703 
23010	203	S2703 
23011	203	S2703 
23012	203	S2703 
23013	203	S2703 
23014	203	S2703 
23015	203	S2703 
23016	203	S2703 
23017	203	S2703 
23018	203	S2703 
23019	203	S2703 
23020	203	S2703 
23021	203	S2703 
23022	203	S2703 
23023	203	S2703 
23024	203	S2703 
23025	203	S2703 
23027	203	S2703 
23028	203	S2703 
23029	203	S2703 
23030	203	S2703 
23031	203	S2703 
23032	203	S2703 
23033	203	S2703 
23034	203	S2703 
23035	203	S2703 
23036	203	S2703 
23037	203	S2703 
23038	203	S2703 
23039	203	S2703 
23040	203	S2703 
23041	203	S2703 
23042	203	S2703 
23043	203	S2703 
23044	203	S2703 
23045	203	S2703 
23046	203	S2703 
23047	203	S2703 
23048	203	S2703 
23049	203	S2703 
23050	203	S2703 
23051	203	S2703 
23052	203	S2703 
23053	203	S2703 
23054	203	S2703 
23055	203	S2703 
23056	203	S2703 
23057	203	S2703 
23058	203	S2703 
23059	203	S2703 
23060	203	S2703 
23061	203	S2703 
23062	203	S2703 
23063	203	S2703 
23064	203	S2703 
23065	203	S2703 
23557	203	S14   
23558	203	S14   
23559	203	S14   
23560	203	S14   
23561	203	S14   
23562	203	S14   
23563	203	S14   
23564	203	S14   
23565	203	S14   
23566	203	S14   
23567	203	S14   
23568	203	S14   
23569	203	S14   
23570	203	S14   
23571	203	S14   
23572	203	S14   
23573	203	S14   
23574	203	S14   
23575	203	S14   
23576	203	S14   
23577	203	S14   
23578	203	S14   
23579	203	S14   
23580	203	S14   
23581	203	S14   
23582	203	S2    
23583	203	S2    
23584	203	S2    
23585	203	S2    
23586	203	S2    
23587	203	S2    
23588	203	S2    
23589	203	S2    
23590	203	S2    
23591	203	S2    
23592	203	S2    
23593	203	S2    
23594	203	S2    
23595	203	S2    
23596	203	S2    
23597	203	S2    
23598	203	S2    
23599	203	S2    
23600	203	S2    
23601	203	S2    
23602	203	S2    
23603	203	S2    
23604	203	S2    
23605	203	S2    
23606	203	S2    
23607	203	S2    
23608	203	S2    
23609	203	S2    
23610	203	S2    
23611	203	S2    
23612	203	S2    
23613	203	S2    
23614	203	S2    
23615	203	S2    
23616	203	S2    
23617	203	S2    
23618	203	S2    
23619	203	S2    
23620	203	S2    
23621	203	S2    
23622	203	S2    
23623	203	S2    
23624	203	S2    
23625	203	S2    
23626	203	S2    
23627	203	S2    
23628	203	S2    
23629	203	S2    
23630	203	S2    
23631	203	S2    
23632	203	S2    
23633	203	S2    
23634	203	S2    
23635	203	S2    
23636	203	S2    
23637	203	S2    
23638	203	S2    
23640	203	S1581 
23646	203	S2    
23647	203	S2    
23648	203	S2    
23649	203	S2    
23650	203	S2    
23651	203	S2    
23652	203	S2    
23653	203	S2    
23654	203	S2    
23655	203	S2    
23656	203	S2    
23657	203	S2    
23658	203	S2    
23659	203	S2    
23660	203	S2    
35001	203	D4961 
35002	203	D4961 
35003	203	D4961 
35004	203	D4961 
35008	203	D4961 
35009	203	D4961 
35010	203	D4961 
35011	203	D4961 
35012	203	D4961 
35013	203	D4961 
35014	203	D4961 
35015	203	D4961 
35016	203	D4961 
35017	203	D4961 
35021	203	D4961 
35022	203	D4961 
35023	203	D4961 
35024	203	D4961 
35025	203	D4961 
35026	203	D4961 
35027	203	D4961 
35028	203	D4961 
35029	203	D4961 
35030	203	D4961 
35034	203	D4961 
35038	203	D4961 
35039	203	D4961 
35040	203	D4961 
35041	203	D4961 
35042	203	D4961 
35043	203	D4961 
35046	203	D4961 
35047	203	D4961 
35048	203	D4961 
35050	203	D4961 
35051	203	D4961 
35054	203	D4961 
35055	203	D4961 
35056	203	D4961 
35057	203	D4961 
35058	203	D4961 
35059	203	D4961 
35060	203	D4961 
35063	203	D4961 
35064	203	D4961 
35065	203	D4961 
35066	203	D4961 
35067	203	D4961 
35068	203	D4961 
35070	203	D4961 
35071	203	D4961 
35072	203	D4961 
35073	203	D4961 
35074	203	D4961 
35075	203	D4961 
35078	203	D4961 
35079	203	D4961 
35080	203	D4961 
35081	203	D4961 
35082	203	D4961 
35083	203	D4961 
35084	203	D4961 
35085	203	D4961 
35086	203	D4961 
35087	203	D4961 
35088	203	D4961 
35089	203	D4961 
35090	203	D4961 
35091	203	D4961 
35092	203	D4961 
35093	203	D4961 
35130	203	S2381 
35131	203	S2381 
35132	203	S2381 
35133	203	S2381 
35134	203	S2381 
35135	203	S2381 
35136	203	S2381 
35137	203	S2381 
35138	203	S2381 
35139	203	S2381 
35140	203	S2381 
35141	203	S2381 
35142	203	S2381 
35143	203	S2381 
35144	203	S2381 
35145	203	S2381 
35146	203	S2381 
35147	203	S2381 
35148	203	S2381 
42161	203	S281  
42190	203	S243  
42190	203	S281  
42190	203	S282  
43158	203	S2109 
43215	203	S26   
43364	203	S26   
43372	203	S5    
43378	203	S1082 
43514	203	S1067 
48052	203	S1362 
01026	204	S25   
01029	204	S27   
01032	204	S19   
01040	204	S27   
01046	204	S19   
01079	204	S1063 
01079	204	S20   
01082	204	S1063 
01085	204	S1063 
01103	204	S1163 
01123	204	S1063 
01123	204	S561  
01124	204	S1065 
01125	204	S1065 
01202	204	S1163 
02048	204	S2109 
02053	204	S2109 
04017	204	S19   
04020	204	S19   
04021	204	S19   
04023	204	S19   
04025	204	S22   
04031	204	S87   
04053	204	S19   
04053	204	S87   
04114	204	S19   
04120	204	S19   
04141	204	S19   
04142	204	S19   
04143	204	S19   
04144	204	S19   
04367	204	S19   
04547	204	S87   
04548	204	S87   
04551	204	S87   
04552	204	S87   
04554	204	S87   
04560	204	S87   
04586	204	S87   
04587	204	S87   
04610	204	S18   
04612	204	S19   
04613	204	S19   
04628	204	S18   
04629	204	S18   
04630	204	S19   
04631	204	S20   
04635	204	S19   
04636	204	S19   
04638	204	S26   
04639	204	S26   
04640	204	S26   
04641	204	S25   
04642	204	S2221 
04643	204	S2221 
04644	204	S2221 
04645	204	S2221 
04646	204	S2221 
04648	204	S2221 
04649	204	S2221 
04650	204	S2221 
04651	204	S2221 
04652	204	S2221 
04653	204	S2221 
04654	204	S2221 
04655	204	S2221 
04656	204	S2221 
04657	204	S2221 
04658	204	S2221 
04659	204	S2221 
04660	204	S2221 
04662	204	S2221 
04663	204	S2221 
04664	204	S2221 
04665	204	S2221 
04666	204	S2221 
04667	204	S2221 
04668	204	S2221 
04669	204	S2221 
04670	204	S2221 
04671	204	S2221 
04672	204	S2221 
04673	204	S2401 
04674	204	S2401 
04675	204	S2401 
04676	204	S2401 
04677	204	S2401 
05023	204	S1581 
05024	204	S1581 
05027	204	S1082 
05028	204	S1082 
05173	204	S1581 
05174	204	S1581 
05175	204	S1581 
05176	204	S1581 
05177	204	S1581 
05178	204	S1581 
05312	204	S26   
05313	204	S26   
05320	204	S26   
05623	204	D4282 
05624	204	S3    
05625	204	D4282 
05626	204	D4281 
05626	204	D4282 
05627	204	D4282 
05628	204	D4281 
05628	204	D4282 
05629	204	D4281 
05630	204	D4282 
05631	204	D4282 
05632	204	S3    
05643	204	D4301 
05644	204	D4301 
05645	204	D4301 
05646	204	D4301 
05647	204	D4301 
05648	204	D4301 
05649	204	D4301 
05650	204	D4301 
05651	204	D4301 
05652	204	D4301 
05653	204	D4301 
05654	204	D4301 
05655	204	D4301 
05656	204	D4301 
05657	204	D4301 
05658	204	D4301 
05661	204	S1082 
06016	204	S18   
06019	204	S18   
06043	204	S18   
06094	204	S18   
06128	204	S18   
06159	204	S18   
06164	204	S23   
06931	204	S22   
06982	204	S18   
06983	204	S18   
06984	204	S2104 
06985	204	S2104 
07002	204	S222  
07005	204	S248  
07006	204	S247  
07007	204	S1164 
07008	204	S238  
07011	204	S227  
07011	204	S281  
07013	204	S242  
07013	204	S281  
07014	204	S281  
07015	204	S248  
07016	204	S248  
07018	204	S226  
07021	204	S237  
07022	204	S21   
07023	204	S242  
07027	204	S281  
07028	204	S225  
07028	204	S230  
07028	204	S281  
07029	204	S281  
07032	204	S281  
07034	204	S249  
07038	204	S281  
07039	204	S244  
07043	204	S230  
07052	204	S227  
07056	204	S248  
07057	204	S281  
07058	204	S237  
07063	204	S1164 
07063	204	S582  
07064	204	S1164 
07068	204	S1041 
07072	204	S281  
07075	204	S1164 
07076	204	S239  
07078	204	S228  
07078	204	S281  
07079	204	S13   
07079	204	S227  
07079	204	S281  
07080	204	S227  
07083	204	S281  
07089	204	S241  
07089	204	S251  
07201	204	S281  
07202	204	S281  
07205	204	S281  
07207	204	S281  
07209	204	S281  
07211	204	S281  
07212	204	S281  
07213	204	S281  
07230	204	S281  
07233	204	S281  
07240	204	S281  
07241	204	S21   
07242	204	S281  
07254	204	S281  
07255	204	S281  
07256	204	S281  
07268	204	S281  
07276	204	S281  
07278	204	S259  
07279	204	S259  
07905	204	S281  
07906	204	S281  
07908	204	S281  
07909	204	S259  
07910	204	S245  
07911	204	S226  
07912	204	S226  
07913	204	S238  
07914	204	S252  
07915	204	S281  
07916	204	S242  
07917	204	S242  
07918	204	S242  
07919	204	S252  
07920	204	S242  
07921	204	S228  
07922	204	S242  
07923	204	S245  
07924	204	S242  
07925	204	S281  
07926	204	S228  
07927	204	S227  
07928	204	S225  
07929	204	S227  
07930	204	S222  
07931	204	S222  
07932	204	S224  
07933	204	S224  
07934	204	S281  
07935	204	S224  
07936	204	S247  
07937	204	S239  
07938	204	S233  
07939	204	S235  
07940	204	S237  
07941	204	S281  
07942	204	S281  
07943	204	S281  
07944	204	S227  
07945	204	S21   
07949	204	S23   
07950	204	S23   
07951	204	S243  
07952	204	S1164 
07953	204	S1164 
07953	204	S582  
07954	204	S582  
07955	204	S1164 
07956	204	S1164 
07957	204	S1164 
07958	204	S1164 
07959	204	S1164 
07960	204	S1164 
08001	204	S1065 
08003	204	S2664 
08005	204	S2664 
08010	204	S702  
08011	204	S702  
08012	204	S1065 
08013	204	S1065 
08014	204	S1065 
08018	204	S702  
08020	204	S1065 
08023	204	S2664 
08025	204	S2662 
08026	204	S603  
08028	204	S2664 
08030	204	S1065 
08031	204	S2664 
08032	204	S2664 
08045	204	S603  
08047	204	S702  
08048	204	S603  
08049	204	S702  
08050	204	S603  
08054	204	S702  
08057	204	S603  
08058	204	S2664 
08059	204	S702  
08060	204	S2664 
08061	204	S1065 
08064	204	S603  
08065	204	S1065 
08065	204	S2662 
08066	204	S702  
08067	204	S2664 
08068	204	S2664 
08069	204	S2664 
08071	204	S2664 
08074	204	S2662 
08077	204	S1065 
08078	204	S603  
08082	204	S603  
08085	204	S702  
08087	204	S603  
08089	204	S603  
08092	204	S702  
08094	204	S702  
08124	204	S702  
08128	204	S702  
08130	204	S702  
08146	204	S702  
08147	204	S1065 
08147	204	S2422 
08189	204	S2664 
08190	204	S603  
08194	204	S603  
08200	204	S702  
08202	204	S603  
08210	204	S702  
08211	204	S702  
08212	204	S702  
08214	204	S702  
08215	204	S702  
08216	204	S702  
08217	204	S2664 
08218	204	S1065 
08219	204	S702  
08220	204	S702  
08221	204	S702  
08225	204	S702  
08229	204	S702  
08231	204	S702  
08232	204	S702  
08243	204	S603  
08245	204	S603  
08247	204	S603  
08253	204	S2664 
08258	204	S2664 
08259	204	S2662 
08263	204	S603  
08277	204	S603  
08278	204	S603  
08283	204	S2664 
08284	204	S2664 
08286	204	S2664 
08287	204	S2664 
08288	204	S2664 
08289	204	S2664 
08293	204	S702  
08294	204	S702  
08299	204	S702  
08309	204	S2664 
08315	204	S702  
08316	204	S702  
08317	204	S702  
08318	204	S2664 
08319	204	S2664 
08345	204	S603  
08351	204	S702  
08352	204	S702  
08353	204	S702  
08354	204	S702  
08355	204	S702  
08357	204	S702  
08358	204	S702  
08359	204	S702  
08360	204	S702  
08361	204	S702  
08362	204	S702  
08363	204	S702  
08364	204	S702  
08366	204	S702  
08367	204	S603  
08368	204	S603  
08370	204	S603  
08371	204	S603  
08372	204	S603  
08374	204	S2664 
08376	204	S2664 
08378	204	S2161 
08379	204	S2664 
08380	204	S2664 
08383	204	S2664 
08384	204	S2664 
08385	204	S2664 
08386	204	S2664 
08387	204	S2664 
08388	204	S2664 
08389	204	S2664 
08390	204	S2664 
08391	204	S682  
08392	204	S2664 
08393	204	S2664 
08394	204	S702  
08395	204	S702  
08396	204	S702  
08398	204	S603  
08399	204	S603  
08400	204	S881  
08401	204	S881  
08402	204	S702  
08403	204	S1209 
08410	204	S702  
08411	204	S702  
08412	204	S702  
08413	204	S702  
08414	204	S702  
08415	204	S702  
08416	204	S702  
08417	204	S702  
08418	204	S702  
08419	204	S702  
08420	204	S702  
08421	204	S702  
08422	204	S702  
08435	204	S1065 
08436	204	S702  
08444	204	S702  
08446	204	S702  
08448	204	S702  
08449	204	S702  
08450	204	S702  
08454	204	S2664 
08455	204	S2664 
08456	204	S2664 
08457	204	S2664 
08458	204	S2664 
08459	204	S2664 
08460	204	S2664 
08461	204	S2664 
08462	204	S2664 
08463	204	S2664 
08464	204	S2664 
08465	204	S2664 
08466	204	S2664 
08467	204	S2161 
08468	204	S2664 
08469	204	S2664 
08470	204	S2664 
08471	204	S2664 
08472	204	S2664 
08473	204	S2664 
08474	204	S2664 
08504	204	S2662 
08505	204	S2662 
08506	204	S2662 
08507	204	S2662 
08508	204	S2662 
08509	204	S2662 
09003	204	S1183 
09003	204	S502  
09003	204	S561  
09003	204	S87   
09004	204	S502  
09004	204	S84   
09032	204	S21   
09037	204	S1031 
09037	204	S121  
09037	204	S1621 
09037	204	S381  
09037	204	S481  
09037	204	S502  
09038	204	S1031 
09038	204	S121  
09038	204	S1621 
09038	204	S481  
09038	204	S502  
09039	204	S381  
09040	204	S1023 
09040	204	S121  
09040	204	S481  
09040	204	S562  
09040	204	S87   
09042	204	S461  
09042	204	S566  
09050	204	S1141 
09050	204	S421  
09050	204	S441  
09060	204	S381  
09062	204	S381  
09062	204	S404  
09070	204	S53   
09070	204	S582  
09078	204	S561  
09079	204	S1701 
09087	204	S1032 
09087	204	S564  
09087	204	S582  
09094	204	S363  
09094	204	S582  
09112	204	S482  
09112	204	S563  
09132	204	S1062 
09139	204	S381  
09148	204	S1033 
09148	204	S363  
09148	204	S582  
09149	204	S381  
09160	204	S1065 
09181	204	S1024 
09181	204	S1121 
09181	204	S121  
09181	204	S461  
09181	204	S87   
09184	204	S562  
09184	204	S565  
09191	204	S421  
09191	204	S582  
09191	204	S84   
09195	204	S1202 
09195	204	S1562 
09195	204	S84   
09202	204	S482  
09202	204	S564  
09218	204	S1065 
09218	204	S1161 
09236	204	S121  
09236	204	S461  
09236	204	S582  
09252	204	S482  
09252	204	S541  
09266	204	S1167 
09266	204	S441  
09266	204	S561  
09273	204	S2104 
09273	204	S2985 
09279	204	S121  
09279	204	S421  
09279	204	S582  
09291	204	S121  
09291	204	S564  
09291	204	S566  
09298	204	S121  
09298	204	S5    
09298	204	S564  
09298	204	S566  
09302	204	S381  
09302	204	S461  
09302	204	S566  
09302	204	S963  
09316	204	S1162 
09316	204	S421  
09316	204	S566  
09316	204	S581  
09316	204	S604  
09326	204	S1027 
09326	204	S441  
09326	204	S461  
09328	204	S1206 
09409	204	S2104 
09409	204	S2985 
09421	204	S564  
09421	204	S582  
09422	204	S1202 
09427	204	D4053 
09428	204	D4053 
09429	204	S1167 
09429	204	S441  
09430	204	S441  
09430	204	S561  
09431	204	S2203 
09432	204	S2203 
09433	204	S2105 
09433	204	S2961 
10007	204	S1082 
10066	204	S1082 
10066	204	S1166 
10067	204	S1082 
10067	204	S1166 
10068	204	S1082 
10068	204	S1166 
10098	204	S1581 
10099	204	S1581 
10102	204	S1581 
10119	204	S1581 
10123	204	S1082 
10124	204	S1082 
10173	204	S1581 
10858	204	S1082 
10858	204	S1166 
10860	204	S1082 
10861	204	S1082 
10862	204	S1082 
10863	204	S1581 
10864	204	S1082 
11011	204	S1069 
11011	204	S81   
11012	204	S1069 
11090	204	S1121 
11090	204	S121  
11090	204	S564  
11090	204	S619  
11090	204	S87   
11091	204	S1121 
11091	204	S564  
11096	204	S1121 
11096	204	S482  
11097	204	S482  
11112	204	S1065 
11113	204	S1065 
11124	204	S1062 
11124	204	S618  
11124	204	S84   
11124	204	S87   
11125	204	S1062 
11130	204	S25   
11131	204	S25   
11143	204	S1121 
11143	204	S564  
11143	204	S84   
11143	204	S87   
11157	204	S1202 
11179	204	S405  
11179	204	S84   
11205	204	S1062 
11205	204	S121  
11206	204	S1062 
11206	204	S121  
11206	204	S81   
11243	204	S2941 
11250	204	S562  
11250	204	S565  
11251	204	S481  
11251	204	S503  
11251	204	S620  
11252	204	S121  
11252	204	S481  
11252	204	S562  
11252	204	S624  
11252	204	S87   
11253	204	S541  
11253	204	S565  
11257	204	S541  
11257	204	S565  
11260	204	D566  
11260	204	S121  
11260	204	S1821 
11260	204	S2941 
11260	204	S78   
11260	204	S80   
11263	204	S2941 
11267	204	S2941 
11282	204	S1062 
11282	204	S121  
11286	204	S1062 
11294	204	S563  
11294	204	S582  
11333	204	S1062 
11333	204	S611  
11333	204	S84   
11339	204	S1062 
11352	204	S563  
11352	204	S566  
11353	204	S563  
11353	204	S566  
11354	204	S563  
11354	204	S566  
11355	204	S563  
11355	204	S566  
11356	204	S563  
11356	204	S566  
11357	204	S563  
11357	204	S566  
11358	204	S563  
11358	204	S566  
11359	204	S2105 
11360	204	S2105 
11394	204	S2105 
11395	204	S2105 
11398	204	S2105 
11399	204	S2105 
11402	204	S2105 
11403	204	S2105 
11411	204	S2105 
11412	204	S2105 
11429	204	S1121 
11429	204	S363  
11429	204	S617  
11463	204	S25   
11464	204	S25   
11507	204	S1062 
11508	204	S1062 
11508	204	S121  
11510	204	S1062 
11529	204	S441  
11529	204	S503  
11529	204	S608  
11529	204	S84   
11529	204	S87   
11530	204	S441  
11531	204	S625  
11531	204	S626  
11531	204	S627  
11531	204	S641  
11531	204	S87   
11546	204	S21   
11546	204	S5    
11546	204	S625  
11546	204	S626  
11546	204	S627  
11546	204	S641  
11547	204	S21   
11547	204	S625  
11547	204	S626  
11547	204	S627  
11549	204	S21   
11549	204	S87   
11674	204	S563  
11674	204	S566  
11705	204	S1069 
11752	204	S1065 
11757	204	S1062 
11760	204	S25   
11774	204	S405  
11774	204	S84   
11821	204	S1062 
11828	204	S563  
11828	204	S566  
11841	204	S2105 
11842	204	S2105 
11856	204	S25   
11875	204	S1062 
11875	204	S121  
11876	204	S1062 
11884	204	S441  
11887	204	S21   
11887	204	S5    
11887	204	S625  
11887	204	S626  
11887	204	S627  
11887	204	S641  
11888	204	S21   
11888	204	S625  
11888	204	S626  
11888	204	S627  
11921	204	S1062 
11935	204	S22   
11935	204	S5    
11949	204	S22   
11949	204	S5    
11950	204	S2941 
11960	204	S481  
11960	204	S562  
11987	204	S1202 
11987	204	S2941 
11990	204	S1202 
11991	204	S1202 
11992	204	S2941 
12006	204	D4821 
12006	204	D4822 
12006	204	D4861 
12006	204	D4862 
12006	204	S1783 
12038	204	S661  
12038	204	S961  
12061	204	S141  
12062	204	S141  
12063	204	S141  
12065	204	S141  
12078	204	S1063 
12078	204	S503  
12086	204	S363  
12086	204	S5    
12086	204	S502  
12120	204	S83   
12121	204	S83   
12122	204	S83   
12131	204	S77   
12132	204	S77   
12142	204	S85   
12143	204	S85   
12144	204	S85   
12147	204	S502  
12147	204	S564  
12151	204	S101  
12151	204	S86   
12152	204	S101  
12152	204	S86   
12154	204	S941  
12155	204	S79   
12201	204	S1164 
12220	204	D4743 
12220	204	S2109 
12538	204	S661  
12538	204	S961  
12563	204	S141  
12565	204	S141  
12586	204	S363  
12586	204	S5    
12586	204	S502  
12632	204	S77   
12643	204	S85   
12644	204	S85   
12652	204	S101  
12652	204	S86   
13019	204	S2    
13020	204	S2    
13039	204	S221  
13055	204	S2    
13065	204	S2    
13067	204	S2    
13068	204	S2    
13070	204	S2    
13096	204	S2    
13098	204	S2    
13165	204	S2    
13318	204	S1581 
13320	204	S1581 
13321	204	S1581 
13322	204	S1581 
13323	204	S1581 
13324	204	S1581 
13325	204	S1082 
13326	204	S1082 
13327	204	S1082 
13340	204	S1581 
13341	204	S1581 
13343	204	S2    
13355	204	S230  
13355	204	S231  
13369	204	S2    
13370	204	S2    
13373	204	S2    
13375	204	S2    
13377	204	S2    
13378	204	S2    
13391	204	S2    
13394	204	S2    
13398	204	S2    
13399	204	S2    
13401	204	S2    
13402	204	S2    
13404	204	S2    
13405	204	S2    
13407	204	S2    
13408	204	S2    
13410	204	S2    
13411	204	S2    
13413	204	S2    
13414	204	S2    
13415	204	S2    
13416	204	S2    
13417	204	S2    
13418	204	S2    
13419	204	S2    
13420	204	S2    
13421	204	S2    
13422	204	S2    
13423	204	S2    
13424	204	S2    
13425	204	S2    
13426	204	S2    
13439	204	S2    
13440	204	S2    
13441	204	S2    
13442	204	S2    
13443	204	S2    
13444	204	S2    
13445	204	S2    
13446	204	S2    
13447	204	S2    
13448	204	S2    
13449	204	S2    
13450	204	S2    
13451	204	S2    
13452	204	S2    
13453	204	S2    
13454	204	S2    
13455	204	S2    
13456	204	S2    
13467	204	S221  
13468	204	S221  
13469	204	S221  
13470	204	S221  
13481	204	S221  
13482	204	S221  
13483	204	S221  
13484	204	S221  
13485	204	S2    
13486	204	S2    
13487	204	S2    
13488	204	S2    
13490	204	S2    
13491	204	S2    
13492	204	S2    
13493	204	S2    
13494	204	S14   
13495	204	S14   
13496	204	S14   
13497	204	S14   
13498	204	S14   
13565	204	S2703 
13566	204	S2703 
13567	204	S2703 
13568	204	S2703 
13569	204	S2703 
13805	204	S2    
13806	204	S2    
13809	204	S2    
13810	204	S2    
13811	204	S2    
13812	204	S2    
13813	204	S2    
13814	204	S2    
13850	204	S2    
13851	204	S2    
13853	204	S2    
13854	204	S2    
13856	204	S2    
13857	204	S2    
13868	204	S2    
13869	204	S2    
13870	204	S2    
13871	204	S2    
13872	204	S2    
13873	204	S2    
13874	204	S2    
13875	204	S2    
13876	204	S2    
13877	204	S2    
13878	204	S2    
13879	204	S2    
13880	204	S2    
13881	204	S2    
13882	204	S2    
13891	204	S2    
13893	204	S2    
13894	204	S2    
13896	204	S2    
13898	204	S2    
13900	204	S2    
13909	204	S2    
13910	204	S2    
13911	204	S2    
13912	204	S2    
13913	204	S2    
13914	204	S2    
13917	204	S2    
13918	204	S2    
13920	204	S2    
13921	204	S2    
13923	204	S2    
13924	204	S2    
13929	204	S2    
13930	204	S2    
13931	204	S2    
13932	204	S2    
13934	204	S2    
13935	204	S2    
13936	204	S221  
13937	204	S221  
13938	204	S221  
13939	204	S221  
13940	204	S221  
13941	204	S221  
13942	204	S221  
13943	204	S221  
13944	204	S221  
13945	204	S221  
13946	204	S221  
13947	204	S221  
13948	204	S2    
13949	204	S2    
13950	204	S2    
13951	204	S2    
13952	204	S2    
13953	204	S2    
13954	204	S2    
13955	204	S2    
13956	204	S2    
13957	204	S2    
13958	204	S2    
13959	204	S2    
13960	204	S221  
13961	204	S221  
13962	204	S221  
13963	204	S221  
13964	204	S221  
13965	204	S221  
13966	204	S221  
13967	204	S221  
13968	204	S2    
13969	204	S2    
13970	204	S2    
13971	204	S2    
13976	204	S221  
13977	204	S221  
13978	204	S221  
13979	204	S221  
13985	204	S2    
13987	204	S221  
13988	204	S2703 
13989	204	S2703 
13990	204	S2703 
13991	204	S2703 
13992	204	S2703 
13994	204	S2703 
13995	204	S2703 
13996	204	S2703 
13997	204	S2703 
13998	204	S2703 
14003	204	S2103 
14006	204	S2103 
14084	204	S2103 
14096	204	S2103 
14106	204	S2103 
14137	204	S1068 
14144	204	S1068 
14145	204	S1064 
14145	204	S1066 
14145	204	S1068 
14145	204	S1122 
14146	204	S1068 
14147	204	S1068 
14148	204	S1068 
14149	204	S1068 
14154	204	S2702 
14156	204	S2702 
14209	204	S1064 
14209	204	S1066 
14209	204	S1122 
14209	204	S23   
14238	204	S2104 
14242	204	S2104 
14323	204	S1067 
14347	204	S1064 
14347	204	S1122 
14366	204	S2104 
14370	204	S2104 
14382	204	S1164 
14400	204	S1064 
14400	204	S1066 
14400	204	S1068 
14400	204	S1122 
14416	204	S1064 
14416	204	S1066 
14416	204	S1068 
14416	204	S1122 
14434	204	S1068 
14440	204	S2109 
14450	204	S1164 
14460	204	S1164 
14462	204	S2109 
14475	204	S1068 
14476	204	S1068 
14601	204	S1066 
14602	204	S2103 
15027	204	S1163 
15078	204	D1066 
15078	204	D1107 
15078	204	D1191 
15078	204	D2793 
15078	204	D964  
15078	204	S2621 
15152	204	S2104 
15260	204	S2109 
15261	204	S1163 
15262	204	S1163 
16006	204	S1164 
16010	204	S1164 
16011	204	S1164 
16011	204	S87   
16029	204	S1164 
16037	204	S1164 
16037	204	S2202 
16038	204	S1164 
16038	204	S2202 
16042	204	S1065 
16042	204	S2202 
16043	204	S1065 
16043	204	S2202 
16089	204	S563  
16097	204	S22   
16098	204	S22   
16098	204	S84   
16098	204	S87   
16112	204	S39   
16114	204	S39   
16120	204	S39   
16123	204	S39   
16126	204	S39   
16139	204	S39   
16147	204	S2104 
16159	204	D342  
16159	204	S39   
16167	204	S2203 
16174	204	S18   
16338	204	S1164 
16338	204	S2202 
16343	204	S1065 
16343	204	S2202 
16397	204	S22   
16398	204	S22   
16398	204	S84   
16398	204	S87   
17202	204	S1082 
17203	204	S1082 
17204	204	S1082 
17218	204	S1581 
17219	204	S1581 
17332	204	S3    
17335	204	S3    
17340	204	S3    
17341	204	S3    
17342	204	S3    
17345	204	S3    
17346	204	S3    
17347	204	S3    
17348	204	S3    
18001	204	S1162 
18002	204	S1162 
18069	204	S20   
18079	204	S25   
18159	204	S21   
18166	204	S25   
18168	204	S25   
18215	204	S25   
18228	204	S23   
18231	204	S25   
18258	204	S1162 
18259	204	S1162 
18262	204	S1162 
18263	204	S1162 
18288	204	S27   
18350	204	S21   
18363	204	S22   
18364	204	S22   
18365	204	S27   
18376	204	S25   
18403	204	S27   
18927	204	S25   
18930	204	S2203 
18931	204	S2203 
18932	204	S27   
18933	204	S27   
18934	204	S27   
18935	204	S27   
18936	204	S27   
19003	204	S26   
19034	204	S26   
19035	204	S26   
19047	204	S1162 
19056	204	S26   
19057	204	S2109 
19058	204	S2109 
19064	204	S1164 
19076	204	S1164 
19078	204	S1069 
19109	204	S1164 
19120	204	S1069 
19155	204	S1164 
19230	204	S1063 
19283	204	S1067 
19300	204	S5    
19337	204	S2109 
19350	204	S1164 
19411	204	S26   
19856	204	S1067 
19868	204	S2109 
20046	204	S20   
20047	204	S20   
20048	204	S20   
20049	204	S20   
20099	204	S1163 
20099	204	S20   
20099	204	S5    
20099	204	S82   
20100	204	S1163 
20100	204	S20   
20100	204	S2901 
20109	204	S2105 
20110	204	S2105 
20120	204	S1163 
20120	204	S20   
20120	204	S5    
20120	204	S82   
20121	204	S1163 
20121	204	S20   
20121	204	S2901 
20132	204	S1202 
20310	204	S2105 
20321	204	S1163 
20321	204	S20   
20321	204	S2901 
20400	204	S1163 
20400	204	S20   
20400	204	S2901 
20409	204	S2105 
20410	204	S2105 
20420	204	S1163 
20420	204	S20   
20420	204	S5    
20420	204	S82   
20421	204	S1163 
20421	204	S20   
20421	204	S2901 
20446	204	S20   
20447	204	S20   
20499	204	S1163 
20499	204	S20   
20499	204	S5    
20499	204	S82   
20510	204	S2105 
20521	204	S1163 
20521	204	S20   
20521	204	S2901 
20623	204	S1742 
20624	204	S1742 
20628	204	S1742 
20629	204	S1742 
20630	204	S1742 
20634	204	S1742 
20635	204	S1742 
20636	204	S1742 
20640	204	S1742 
20641	204	S1742 
20645	204	S1742 
20646	204	S1742 
21138	204	S1064 
21138	204	S1066 
21138	204	S1122 
21141	204	S1064 
21224	204	S19   
21225	204	S19   
21226	204	S22   
21227	204	S22   
21229	204	S1122 
21238	204	S2801 
21239	204	S1066 
21240	204	S1066 
21241	204	S1066 
21242	204	S1066 
21243	204	S1066 
21244	204	S1066 
21245	204	S1066 
21246	204	S1066 
21247	204	S1066 
21248	204	S1066 
21249	204	S1064 
21250	204	S1064 
21251	204	S1064 
21252	204	S1064 
21253	204	S1064 
21254	204	S1064 
21255	204	S1064 
21256	204	S1064 
21257	204	S1064 
21259	204	S1064 
21260	204	S1082 
21261	204	S1082 
21262	204	S1082 
21263	204	S1082 
21264	204	S1082 
21265	204	S1082 
21266	204	S1082 
21267	204	S1082 
21268	204	S1082 
21269	204	S1082 
21270	204	S1082 
21271	204	S2108 
21272	204	S2108 
21273	204	S2108 
21274	204	S2108 
21275	204	S2108 
21276	204	S2108 
21277	204	S2110 
21278	204	S2110 
21279	204	S2110 
21280	204	S2110 
21281	204	S2110 
21282	204	S2110 
21283	204	S2111 
21284	204	S2111 
21285	204	S2111 
21286	204	S2111 
21287	204	S2112 
21288	204	S2112 
21289	204	S2112 
21290	204	S2112 
21291	204	S2112 
21292	204	S2112 
21293	204	S2782 
21294	204	S2782 
21295	204	S2782 
21296	204	S2782 
21297	204	S2782 
21298	204	S2782 
21299	204	S2110 
21299	204	S2111 
21299	204	S2112 
21299	204	S2782 
21300	204	S2110 
21300	204	S2112 
21300	204	S2782 
21301	204	S2110 
21301	204	S2111 
21301	204	S2112 
21301	204	S2782 
21302	204	S2110 
21302	204	S2111 
21302	204	S2112 
21302	204	S2782 
21303	204	S2110 
21303	204	S2112 
21303	204	S2782 
21304	204	S2110 
21304	204	S2111 
21304	204	S2112 
21304	204	S2782 
21308	204	S2801 
21309	204	S2801 
21310	204	S2801 
21311	204	S2801 
21312	204	S2801 
21313	204	S2801 
21314	204	S2801 
21315	204	S2801 
21316	204	S2801 
21317	204	S2801 
21318	204	S2801 
21319	204	S2801 
21320	204	S2801 
21321	204	S2801 
21322	204	S2801 
21323	204	S2801 
21324	204	S2801 
21325	204	S2801 
21326	204	S2801 
21337	204	S2801 
21342	204	S2801 
21343	204	S2801 
21346	204	S2801 
21347	204	S2801 
21348	204	S2801 
21349	204	S2801 
22247	204	S20   
22903	204	S21   
22904	204	S18   
22909	204	S22   
22911	204	S18   
22912	204	S19   
22914	204	S19   
22915	204	S19   
22916	204	S19   
23009	204	S2703 
23010	204	S2703 
23011	204	S2703 
23012	204	S2703 
23013	204	S2703 
23014	204	S2703 
23015	204	S2703 
23016	204	S2703 
23017	204	S2703 
23018	204	S2703 
23019	204	S2703 
23020	204	S2703 
23021	204	S2703 
23022	204	S2703 
23023	204	S2703 
23024	204	S2703 
23025	204	S2703 
23027	204	S2703 
23028	204	S2703 
23029	204	S2703 
23030	204	S2703 
23031	204	S2703 
23032	204	S2703 
23033	204	S2703 
23034	204	S2703 
23035	204	S2703 
23036	204	S2703 
23037	204	S2703 
23038	204	S2703 
23039	204	S2703 
23040	204	S2703 
23041	204	S2703 
23042	204	S2703 
23043	204	S2703 
23044	204	S2703 
23045	204	S2703 
23046	204	S2703 
23047	204	S2703 
23048	204	S2703 
23049	204	S2703 
23050	204	S2703 
23051	204	S2703 
23052	204	S2703 
23053	204	S2703 
23054	204	S2703 
23055	204	S2703 
23056	204	S2703 
23057	204	S2703 
23058	204	S2703 
23059	204	S2703 
23060	204	S2703 
23061	204	S2703 
23062	204	S2703 
23063	204	S2703 
23064	204	S2703 
23065	204	S2703 
23557	204	S14   
23558	204	S14   
23559	204	S14   
23560	204	S14   
23561	204	S14   
23562	204	S14   
23563	204	S14   
23564	204	S14   
23565	204	S14   
23566	204	S14   
23567	204	S14   
23568	204	S14   
23569	204	S14   
23570	204	S14   
23571	204	S14   
23572	204	S14   
23573	204	S14   
23574	204	S14   
23575	204	S14   
23576	204	S14   
23577	204	S14   
23578	204	S14   
23579	204	S14   
23580	204	S14   
23581	204	S14   
23582	204	S2    
23583	204	S2    
23584	204	S2    
23585	204	S2    
23586	204	S2    
23587	204	S2    
23588	204	S2    
23589	204	S2    
23590	204	S2    
23591	204	S2    
23592	204	S2    
23593	204	S2    
23594	204	S2    
23595	204	S2    
23596	204	S2    
23597	204	S2    
23598	204	S2    
23599	204	S2    
23600	204	S2    
23601	204	S2    
23602	204	S2    
23603	204	S2    
23604	204	S2    
23605	204	S2    
23606	204	S2    
23607	204	S2    
23608	204	S2    
23609	204	S2    
23610	204	S2    
23611	204	S2    
23612	204	S2    
23613	204	S2    
23614	204	S2    
23615	204	S2    
23616	204	S2    
23617	204	S2    
23618	204	S2    
23619	204	S2    
23620	204	S2    
23621	204	S2    
23622	204	S2    
23623	204	S2    
23624	204	S2    
23625	204	S2    
23626	204	S2    
23627	204	S2    
23628	204	S2    
23629	204	S2    
23630	204	S2    
23631	204	S2    
23632	204	S2    
23633	204	S2    
23634	204	S2    
23635	204	S2    
23636	204	S2    
23637	204	S2    
23638	204	S2    
23640	204	S1581 
23646	204	S2    
23647	204	S2    
23648	204	S2    
23649	204	S2    
23650	204	S2    
23651	204	S2    
23652	204	S2    
23653	204	S2    
23654	204	S2    
23655	204	S2    
23656	204	S2    
23657	204	S2    
23658	204	S2    
23659	204	S2    
23660	204	S2    
35001	204	D4961 
35002	204	D4961 
35003	204	D4961 
35004	204	D4961 
35008	204	D4961 
35009	204	D4961 
35010	204	D4961 
35011	204	D4961 
35012	204	D4961 
35013	204	D4961 
35014	204	D4961 
35015	204	D4961 
35016	204	D4961 
35017	204	D4961 
35021	204	D4961 
35022	204	D4961 
35023	204	D4961 
35024	204	D4961 
35025	204	D4961 
35026	204	D4961 
35027	204	D4961 
35028	204	D4961 
35029	204	D4961 
35030	204	D4961 
35034	204	D4961 
35038	204	D4961 
35039	204	D4961 
35040	204	D4961 
35041	204	D4961 
35042	204	D4961 
35043	204	D4961 
35046	204	D4961 
35047	204	D4961 
35048	204	D4961 
35050	204	D4961 
35051	204	D4961 
35054	204	D4961 
35055	204	D4961 
35056	204	D4961 
35057	204	D4961 
35058	204	D4961 
35059	204	D4961 
35060	204	D4961 
35063	204	D4961 
35064	204	D4961 
35065	204	D4961 
35066	204	D4961 
35067	204	D4961 
35068	204	D4961 
35070	204	D4961 
35071	204	D4961 
35072	204	D4961 
35073	204	D4961 
35074	204	D4961 
35075	204	D4961 
35078	204	D4961 
35079	204	D4961 
35080	204	D4961 
35081	204	D4961 
35082	204	D4961 
35083	204	D4961 
35084	204	D4961 
35085	204	D4961 
35086	204	D4961 
35087	204	D4961 
35088	204	D4961 
35089	204	D4961 
35090	204	D4961 
35091	204	D4961 
35092	204	D4961 
35093	204	D4961 
35130	204	S2381 
35131	204	S2381 
35132	204	S2381 
35133	204	S2381 
35134	204	S2381 
35135	204	S2381 
35136	204	S2381 
35137	204	S2381 
35138	204	S2381 
35139	204	S2381 
35140	204	S2381 
35141	204	S2381 
35142	204	S2381 
35143	204	S2381 
35144	204	S2381 
35145	204	S2381 
35146	204	S2381 
35147	204	S2381 
35148	204	S2381 
42161	204	S281  
42190	204	S243  
42190	204	S281  
42190	204	S282  
43158	204	S2109 
43215	204	S26   
43372	204	S5    
43378	204	S1082 
48052	204	S1362 
04673	205	S2401 
04674	205	S2401 
04675	205	S2401 
04676	205	S2401 
04677	205	S2401 
07002	205	S222  
07006	205	S247  
07013	205	S242  
07013	205	S281  
07014	205	S281  
07015	205	S248  
07056	205	S248  
07068	205	S1041 
07201	205	S281  
07205	205	S281  
07207	205	S281  
07209	205	S281  
07213	205	S281  
07233	205	S281  
07240	205	S281  
07242	205	S281  
07254	205	S281  
07255	205	S281  
07256	205	S281  
07268	205	S281  
07909	205	S259  
07910	205	S245  
07911	205	S226  
07912	205	S226  
07913	205	S238  
07914	205	S252  
07915	205	S281  
07916	205	S242  
07918	205	S242  
07919	205	S252  
07920	205	S242  
07921	205	S228  
07922	205	S242  
07923	205	S245  
07924	205	S242  
07925	205	S281  
07926	205	S228  
07927	205	S227  
07928	205	S225  
07929	205	S227  
07930	205	S222  
07931	205	S222  
07932	205	S224  
07933	205	S224  
07934	205	S281  
07935	205	S224  
07936	205	S247  
07938	205	S233  
07939	205	S235  
07940	205	S237  
07941	205	S281  
07942	205	S281  
07943	205	S281  
07944	205	S227  
08003	205	S2664 
08005	205	S2664 
08010	205	S702  
08011	205	S702  
08012	205	S702  
08013	205	S603  
08017	205	S603  
08018	205	S702  
08019	205	S603  
08023	205	S2664 
08026	205	S603  
08028	205	S2664 
08031	205	S2664 
08032	205	S2664 
08035	205	S603  
08045	205	S603  
08047	205	S702  
08048	205	S603  
08049	205	S702  
08050	205	S603  
08054	205	S702  
08057	205	S603  
08058	205	S2664 
08059	205	S702  
08060	205	S2664 
08064	205	S603  
08066	205	S702  
08067	205	S2664 
08068	205	S2664 
08069	205	S2664 
08071	205	S2664 
08077	205	S603  
08078	205	S603  
08082	205	S603  
08083	205	S2502 
08085	205	S702  
08086	205	S603  
08087	205	S603  
08089	205	S603  
08092	205	S702  
08094	205	S702  
08116	205	S2502 
08124	205	S702  
08128	205	S702  
08130	205	S702  
08138	205	S2502 
08139	205	S603  
08146	205	S702  
08147	205	S2422 
08177	205	S2502 
08189	205	S2664 
08190	205	S603  
08194	205	S603  
08200	205	S702  
08202	205	S603  
08206	205	S2502 
08210	205	S702  
08211	205	S702  
08212	205	S702  
08214	205	S702  
08215	205	S702  
08216	205	S702  
08217	205	S2664 
08219	205	S702  
08220	205	S702  
08221	205	S702  
08225	205	S702  
08229	205	S702  
08231	205	S702  
08232	205	S702  
08243	205	S603  
08244	205	S603  
08245	205	S603  
08247	205	S603  
08253	205	S2664 
08258	205	S2664 
08259	205	S2664 
08262	205	S603  
08263	205	S603  
08266	205	S603  
08267	205	S603  
08268	205	S603  
08269	205	S603  
08270	205	S603  
08271	205	S603  
08272	205	S603  
08273	205	S603  
08274	205	S603  
08277	205	S603  
08278	205	S603  
08283	205	S2664 
08284	205	S2664 
08286	205	S2664 
08287	205	S2664 
08288	205	S2664 
08289	205	S2664 
08293	205	S702  
08294	205	S702  
08299	205	S702  
08309	205	S2664 
08315	205	S702  
08316	205	S702  
08317	205	S702  
08318	205	S2664 
08319	205	S2664 
08345	205	S603  
08346	205	S2502 
08347	205	S2502 
08348	205	S2502 
08349	205	S2502 
08350	205	S2502 
08351	205	S702  
08352	205	S702  
08353	205	S702  
08354	205	S702  
08355	205	S702  
08357	205	S702  
08358	205	S702  
08359	205	S702  
08360	205	S702  
08361	205	S702  
08362	205	S702  
08363	205	S702  
08364	205	S702  
08366	205	S702  
08367	205	S603  
08368	205	S603  
08370	205	S603  
08371	205	S603  
08372	205	S603  
08374	205	S2664 
08376	205	S2664 
08378	205	S2161 
08379	205	S2664 
08380	205	S2664 
08383	205	S2664 
08384	205	S2664 
08385	205	S2664 
08386	205	S2664 
08387	205	S2664 
08388	205	S2664 
08389	205	S2664 
08390	205	S2664 
08391	205	S682  
08392	205	S2664 
08393	205	S2664 
08394	205	S702  
08395	205	S702  
08396	205	S702  
08397	205	S603  
08398	205	S603  
08399	205	S603  
08400	205	S881  
08401	205	S881  
08402	205	S702  
08403	205	S1209 
08408	205	S2502 
08409	205	S2502 
08410	205	S702  
08411	205	S702  
08412	205	S702  
08413	205	S702  
08414	205	S702  
08415	205	S702  
08416	205	S702  
08417	205	S702  
08418	205	S702  
08419	205	S702  
08420	205	S702  
08421	205	S702  
08422	205	S702  
08436	205	S702  
08444	205	S702  
08446	205	S702  
08448	205	S702  
08449	205	S702  
08450	205	S702  
08454	205	S2664 
08455	205	S2664 
08456	205	S2664 
08457	205	S2664 
08458	205	S2664 
08459	205	S2664 
08460	205	S2664 
08461	205	S2664 
08462	205	S2664 
08463	205	S2664 
08464	205	S2664 
08465	205	S2664 
08466	205	S2664 
08467	205	S2161 
08468	205	S2664 
08469	205	S2664 
08470	205	S2664 
08471	205	S2664 
08472	205	S2664 
08473	205	S2664 
08474	205	S2664 
08476	205	S2502 
08478	205	S2502 
08481	205	S2502 
08482	205	S2502 
08483	205	S2502 
08484	205	S2502 
08487	205	S2502 
08488	205	S2502 
08489	205	S2502 
08490	205	S2502 
08491	205	S2502 
08492	205	S2502 
08493	205	S2502 
08494	205	S2502 
08495	205	S2502 
08497	205	S2502 
08498	205	S2502 
08500	205	S2502 
08501	205	S2502 
11935	205	S5    
11949	205	S5    
13039	205	S221  
13355	205	S231  
13936	205	S221  
13937	205	S221  
13938	205	S221  
13939	205	S221  
13940	205	S221  
13941	205	S221  
13942	205	S221  
13943	205	S221  
13944	205	S221  
13945	205	S221  
13946	205	S221  
13947	205	S221  
13960	205	S221  
13961	205	S221  
13962	205	S221  
13963	205	S221  
13964	205	S221  
13965	205	S221  
13966	205	S221  
13967	205	S221  
13976	205	S221  
13977	205	S221  
13978	205	S221  
13979	205	S221  
13987	205	S221  
14003	205	S2841 
14006	205	S2841 
14084	205	S2841 
14096	205	S2841 
14097	205	S2841 
14098	205	S2841 
14099	205	S2841 
14100	205	S2841 
14101	205	S2841 
14102	205	S2841 
14103	205	S2841 
14105	205	S2841 
14106	205	S2841 
14107	205	S2841 
14108	205	S2841 
14109	205	S2841 
14113	205	S2841 
14116	205	S2841 
14117	205	S2841 
14120	205	S2841 
14124	205	S2841 
14126	205	S2841 
14132	205	S2841 
14134	205	S2841 
14135	205	S2841 
14138	205	S2841 
14140	205	S2841 
14152	205	S2841 
14158	205	S2841 
14159	205	S2841 
14602	205	S2841 
16114	205	S39   
16120	205	S39   
16126	205	S39   
16139	205	S39   
23648	205	S2    
35001	205	D4961 
35002	205	D4961 
35003	205	D4961 
35004	205	D4961 
35008	205	D4961 
35009	205	D4961 
35010	205	D4961 
35011	205	D4961 
35012	205	D4961 
35013	205	D4961 
35014	205	D4961 
35015	205	D4961 
35016	205	D4961 
35017	205	D4961 
35021	205	D4961 
35022	205	D4961 
35023	205	D4961 
35024	205	D4961 
35025	205	D4961 
35026	205	D4961 
35027	205	D4961 
35028	205	D4961 
35029	205	D4961 
35030	205	D4961 
35034	205	D4961 
35038	205	D4961 
35039	205	D4961 
35040	205	D4961 
35041	205	D4961 
35042	205	D4961 
35043	205	D4961 
35046	205	D4961 
35047	205	D4961 
35048	205	D4961 
35050	205	D4961 
35051	205	D4961 
35054	205	D4961 
35055	205	D4961 
35056	205	D4961 
35057	205	D4961 
35058	205	D4961 
35059	205	D4961 
35060	205	D4961 
35063	205	D4961 
35064	205	D4961 
35065	205	D4961 
35066	205	D4961 
35067	205	D4961 
35068	205	D4961 
35070	205	D4961 
35071	205	D4961 
35072	205	D4961 
35073	205	D4961 
35074	205	D4961 
35075	205	D4961 
35078	205	D4961 
35079	205	D4961 
35080	205	D4961 
35081	205	D4961 
35082	205	D4961 
35083	205	D4961 
35084	205	D4961 
35085	205	D4961 
35086	205	D4961 
35087	205	D4961 
35088	205	D4961 
35089	205	D4961 
35090	205	D4961 
35091	205	D4961 
35092	205	D4961 
35093	205	D4961 
01026	207	S25   
01029	207	S27   
01032	207	S19   
01040	207	S27   
01046	207	S19   
01077	207	S27   
01079	207	S1063 
01079	207	S20   
01082	207	S1063 
01085	207	S1063 
01103	207	S1163 
01123	207	S1063 
01123	207	S561  
01124	207	S1065 
01125	207	S1065 
01202	207	S1163 
02048	207	S2109 
02053	207	S2109 
04017	207	S19   
04020	207	S19   
04021	207	S19   
04023	207	S19   
04053	207	S19   
04114	207	S19   
04120	207	S19   
04141	207	S19   
04142	207	S19   
04143	207	S19   
04144	207	S19   
04367	207	S19   
04610	207	S18   
04628	207	S18   
04629	207	S18   
04630	207	S19   
04631	207	S20   
04635	207	S19   
04636	207	S19   
04638	207	S26   
04639	207	S26   
04640	207	S26   
04641	207	S25   
04656	207	S2221 
04657	207	S2221 
04658	207	S2221 
04659	207	S2221 
04660	207	S2221 
04661	207	S2221 
04662	207	S2221 
04663	207	S2221 
04673	207	S2401 
04674	207	S2401 
04675	207	S2401 
04676	207	S2401 
04677	207	S2401 
05023	207	S1581 
05024	207	S1581 
05027	207	S1082 
05028	207	S1082 
05173	207	S1581 
05174	207	S1581 
05175	207	S1581 
05176	207	S1581 
05177	207	S1581 
05178	207	S1581 
05312	207	S26   
05313	207	S26   
05320	207	S26   
05623	207	D4282 
05624	207	S3    
05625	207	D4282 
05626	207	D4281 
05626	207	D4282 
05627	207	D4282 
05628	207	D4281 
05628	207	D4282 
05629	207	D4281 
05630	207	D4282 
05631	207	D4282 
05632	207	S3    
05646	207	D4301 
05649	207	D4301 
05661	207	S1082 
06016	207	S18   
06019	207	S18   
06043	207	S18   
06094	207	S18   
06128	207	S18   
06159	207	S18   
06164	207	S23   
06931	207	S22   
06982	207	S18   
06983	207	S18   
06984	207	S2104 
06985	207	S2104 
07002	207	S222  
07005	207	S248  
07006	207	S247  
07007	207	S1164 
07008	207	S238  
07011	207	S281  
07013	207	S281  
07014	207	S281  
07015	207	S248  
07016	207	S248  
07018	207	S226  
07021	207	S237  
07022	207	S21   
07027	207	S281  
07028	207	S225  
07028	207	S230  
07028	207	S281  
07029	207	S281  
07032	207	S281  
07034	207	S249  
07038	207	S281  
07039	207	S244  
07043	207	S230  
07052	207	S227  
07056	207	S248  
07057	207	S281  
07058	207	S237  
07063	207	S1164 
07063	207	S582  
07064	207	S1164 
07068	207	S1041 
07072	207	S281  
07075	207	S1164 
07078	207	S228  
07078	207	S281  
07079	207	S13   
07079	207	S281  
07083	207	S281  
07089	207	S241  
07201	207	S281  
07202	207	S281  
07205	207	S281  
07207	207	S281  
07209	207	S281  
07211	207	S281  
07212	207	S281  
07213	207	S281  
07230	207	S281  
07233	207	S281  
07240	207	S281  
07241	207	S21   
07242	207	S281  
07254	207	S281  
07255	207	S281  
07256	207	S281  
07268	207	S281  
07276	207	S281  
07278	207	S259  
07279	207	S259  
07905	207	S281  
07906	207	S281  
07908	207	S281  
07909	207	S259  
07910	207	S245  
07911	207	S226  
07912	207	S226  
07913	207	S238  
07914	207	S252  
07915	207	S281  
07916	207	S242  
07917	207	S242  
07918	207	S242  
07919	207	S252  
07920	207	S242  
07921	207	S228  
07922	207	S242  
07923	207	S245  
07924	207	S242  
07925	207	S281  
07926	207	S228  
07927	207	S227  
07928	207	S225  
07929	207	S227  
07930	207	S222  
07931	207	S222  
07932	207	S224  
07933	207	S224  
07934	207	S281  
07935	207	S224  
07936	207	S247  
07938	207	S233  
07939	207	S235  
07940	207	S237  
07941	207	S281  
07942	207	S281  
07943	207	S281  
07944	207	S227  
07945	207	S21   
07949	207	S23   
07950	207	S23   
07951	207	S243  
07952	207	S1164 
07953	207	S1164 
07953	207	S582  
07954	207	S582  
07955	207	S1164 
07956	207	S1164 
07957	207	S1164 
07958	207	S1164 
07959	207	S1164 
07960	207	S1164 
08001	207	S1065 
08003	207	S2664 
08005	207	S2664 
08010	207	S702  
08011	207	S702  
08012	207	S1065 
08013	207	S1065 
08014	207	S1065 
08017	207	S603  
08018	207	S702  
08019	207	S603  
08020	207	S1065 
08023	207	S2664 
08025	207	S2662 
08026	207	S603  
08028	207	S2664 
08030	207	S1065 
08031	207	S2664 
08032	207	S2664 
08035	207	S603  
08045	207	S603  
08047	207	S702  
08048	207	S603  
08049	207	S702  
08050	207	S603  
08054	207	S702  
08057	207	S603  
08058	207	S2664 
08059	207	S702  
08060	207	S2664 
08061	207	S1065 
08064	207	S603  
08065	207	S1065 
08065	207	S2662 
08066	207	S702  
08067	207	S2664 
08068	207	S2664 
08069	207	S2664 
08071	207	S2664 
08074	207	S2662 
08077	207	S1065 
08078	207	S603  
08082	207	S603  
08083	207	S2502 
08086	207	S603  
08087	207	S603  
08089	207	S603  
08092	207	S702  
08094	207	S702  
08116	207	S2502 
08124	207	S702  
08128	207	S702  
08130	207	S702  
08138	207	S2502 
08139	207	S603  
08146	207	S702  
08147	207	S1065 
08147	207	S2422 
08177	207	S2502 
08189	207	S2664 
08190	207	S603  
08194	207	S603  
08200	207	S702  
08202	207	S603  
08206	207	S2502 
08210	207	S702  
08211	207	S702  
08212	207	S702  
08214	207	S702  
08215	207	S702  
08216	207	S702  
08217	207	S2664 
08218	207	S1065 
08219	207	S702  
08220	207	S702  
08221	207	S702  
08225	207	S702  
08229	207	S702  
08231	207	S702  
08232	207	S702  
08243	207	S603  
08244	207	S603  
08245	207	S603  
08247	207	S603  
08253	207	S2664 
08258	207	S2664 
08259	207	S2662 
08262	207	S603  
08263	207	S603  
08266	207	S603  
08267	207	S603  
08268	207	S603  
08269	207	S603  
08270	207	S603  
08271	207	S603  
08272	207	S603  
08273	207	S603  
08274	207	S603  
08277	207	S603  
08278	207	S603  
08283	207	S2664 
08284	207	S2664 
08286	207	S2664 
08287	207	S2664 
08288	207	S2664 
08289	207	S2664 
08293	207	S702  
08294	207	S702  
08299	207	S702  
08309	207	S2664 
08315	207	S702  
08316	207	S702  
08317	207	S702  
08318	207	S2664 
08319	207	S2664 
08345	207	S603  
08346	207	S2502 
08347	207	S2502 
08348	207	S2502 
08349	207	S2502 
08350	207	S2502 
08351	207	S702  
08352	207	S702  
08353	207	S702  
08354	207	S702  
08355	207	S702  
08357	207	S702  
08358	207	S702  
08359	207	S702  
08360	207	S702  
08361	207	S702  
08362	207	S702  
08363	207	S702  
08364	207	S702  
08366	207	S702  
08367	207	S603  
08368	207	S603  
08370	207	S603  
08371	207	S603  
08372	207	S603  
08374	207	S2664 
08376	207	S2664 
08378	207	S2161 
08379	207	S2664 
08380	207	S2664 
08383	207	S2664 
08384	207	S2664 
08385	207	S2664 
08386	207	S2664 
08387	207	S2664 
08388	207	S2664 
08390	207	S2664 
08391	207	S682  
08392	207	S2664 
08393	207	S2664 
08394	207	S702  
08395	207	S702  
08396	207	S702  
08397	207	S603  
08398	207	S603  
08399	207	S603  
08400	207	S881  
08401	207	S881  
08402	207	S702  
08403	207	S1209 
08408	207	S2502 
08409	207	S2502 
08410	207	S702  
08411	207	S702  
08412	207	S702  
08413	207	S702  
08414	207	S702  
08415	207	S702  
08416	207	S702  
08417	207	S702  
08418	207	S702  
08419	207	S702  
08420	207	S702  
08421	207	S702  
08422	207	S702  
08435	207	S1065 
08436	207	S702  
08444	207	S702  
08446	207	S702  
08448	207	S702  
08449	207	S702  
08450	207	S702  
08454	207	S2664 
08455	207	S2664 
08456	207	S2664 
08457	207	S2664 
08458	207	S2664 
08459	207	S2664 
08460	207	S2664 
08461	207	S2664 
08462	207	S2664 
08463	207	S2664 
08464	207	S2664 
08465	207	S2664 
08466	207	S2664 
08467	207	S2161 
08468	207	S2664 
08469	207	S2664 
08470	207	S2664 
08471	207	S2664 
08472	207	S2664 
08473	207	S2664 
08474	207	S2664 
08476	207	S2502 
08478	207	S2502 
08481	207	S2502 
08482	207	S2502 
08483	207	S2502 
08484	207	S2502 
08487	207	S2502 
08488	207	S2502 
08489	207	S2502 
08490	207	S2502 
08491	207	S2502 
08492	207	S2502 
08493	207	S2502 
08494	207	S2502 
08495	207	S2502 
08497	207	S2502 
08498	207	S2502 
08500	207	S2502 
08501	207	S2502 
08504	207	S2662 
08505	207	S2662 
08506	207	S2662 
08507	207	S2662 
08508	207	S2662 
08509	207	S2662 
09003	207	S1183 
09003	207	S502  
09003	207	S561  
09004	207	S502  
09032	207	S21   
09037	207	S1031 
09037	207	S1621 
09037	207	S381  
09037	207	S481  
09037	207	S502  
09038	207	S1031 
09038	207	S1621 
09038	207	S481  
09038	207	S502  
09039	207	S381  
09040	207	S1023 
09040	207	S481  
09040	207	S562  
09042	207	S461  
09042	207	S566  
09050	207	S1141 
09050	207	S421  
09050	207	S441  
09060	207	S381  
09062	207	S381  
09062	207	S404  
09070	207	S53   
09070	207	S582  
09078	207	S561  
09079	207	S1701 
09087	207	S1032 
09087	207	S564  
09087	207	S582  
09094	207	S363  
09094	207	S582  
09112	207	S482  
09112	207	S563  
09132	207	S1062 
09139	207	S381  
09148	207	S1033 
09148	207	S363  
09148	207	S582  
09149	207	S381  
09160	207	S1065 
09181	207	S1024 
09181	207	S1121 
09181	207	S461  
09183	207	S381  
09184	207	S1026 
09184	207	S562  
09184	207	S565  
09191	207	S421  
09191	207	S582  
09195	207	S1202 
09202	207	S482  
09202	207	S564  
09218	207	S1065 
09218	207	S1161 
09236	207	S461  
09236	207	S582  
09252	207	S482  
09252	207	S541  
09266	207	S1167 
09266	207	S441  
09266	207	S561  
09273	207	S2104 
09279	207	S421  
09279	207	S582  
09291	207	S564  
09291	207	S566  
09298	207	S564  
09298	207	S566  
09302	207	S381  
09302	207	S461  
09302	207	S566  
09302	207	S963  
09316	207	S1162 
09316	207	S421  
09316	207	S566  
09316	207	S581  
09316	207	S604  
09326	207	S1027 
09326	207	S441  
09326	207	S461  
09328	207	S1206 
09409	207	S2104 
09421	207	S564  
09421	207	S582  
09422	207	S1202 
09427	207	D4053 
09428	207	D4053 
09429	207	S1167 
09429	207	S441  
09430	207	S441  
09430	207	S561  
09431	207	S2203 
09432	207	S2203 
09433	207	S2105 
09433	207	S2961 
10007	207	S1082 
10066	207	S1082 
10067	207	S1082 
10068	207	S1082 
10098	207	S1581 
10099	207	S1581 
10102	207	S1581 
10119	207	S1581 
10123	207	S1082 
10124	207	S1082 
10173	207	S1581 
10858	207	S1082 
10860	207	S1082 
10861	207	S1082 
10862	207	S1082 
10863	207	S1581 
10864	207	S1082 
11011	207	S1069 
11012	207	S1069 
11090	207	S1121 
11090	207	S564  
11090	207	S619  
11091	207	S1121 
11091	207	S564  
11096	207	S1121 
11096	207	S482  
11097	207	S482  
11112	207	S1065 
11113	207	S1065 
11124	207	S1062 
11124	207	S618  
11125	207	S1062 
11130	207	S25   
11131	207	S25   
11143	207	S1121 
11143	207	S564  
11157	207	S1202 
11205	207	S1062 
11206	207	S1062 
11243	207	S2941 
11250	207	S562  
11250	207	S565  
11251	207	S481  
11251	207	S503  
11251	207	S620  
11252	207	S481  
11252	207	S562  
11252	207	S624  
11253	207	S541  
11253	207	S565  
11257	207	S541  
11257	207	S565  
11260	207	D566  
11260	207	S1821 
11260	207	S2941 
11260	207	S78   
11260	207	S80   
11263	207	S2941 
11267	207	S2941 
11282	207	S1062 
11286	207	S1062 
11294	207	S563  
11294	207	S582  
11333	207	S1062 
11339	207	S1062 
11352	207	S563  
11352	207	S566  
11353	207	S563  
11353	207	S566  
11354	207	S563  
11354	207	S566  
11355	207	S563  
11355	207	S566  
11356	207	S563  
11356	207	S566  
11357	207	S563  
11357	207	S566  
11358	207	S563  
11358	207	S566  
11359	207	S2105 
11360	207	S2105 
11394	207	S2105 
11395	207	S2105 
11398	207	S2105 
11399	207	S2105 
11402	207	S2105 
11403	207	S2105 
11411	207	S2105 
11412	207	S2105 
11429	207	S1121 
11429	207	S363  
11429	207	S617  
11463	207	S25   
11464	207	S25   
11507	207	S1062 
11508	207	S1062 
11510	207	S1062 
11529	207	S441  
11529	207	S503  
11529	207	S608  
11530	207	S441  
11531	207	S27   
11531	207	S625  
11531	207	S626  
11531	207	S627  
11531	207	S641  
11546	207	S21   
11546	207	S5    
11546	207	S625  
11546	207	S626  
11546	207	S627  
11546	207	S641  
11547	207	S21   
11547	207	S625  
11547	207	S626  
11547	207	S627  
11549	207	S21   
11674	207	S563  
11674	207	S566  
11705	207	S1069 
11752	207	S1065 
11757	207	S1062 
11760	207	S25   
11821	207	S1062 
11828	207	S563  
11828	207	S566  
11841	207	S2105 
11842	207	S2105 
11856	207	S25   
11875	207	S1062 
11876	207	S1062 
11884	207	S441  
11887	207	S21   
11887	207	S5    
11887	207	S625  
11887	207	S626  
11887	207	S627  
11887	207	S641  
11888	207	S21   
11888	207	S625  
11888	207	S626  
11888	207	S627  
11921	207	S1062 
11935	207	S22   
11935	207	S5    
11949	207	S22   
11949	207	S5    
11950	207	S2941 
11960	207	S481  
11960	207	S562  
11987	207	S1202 
11987	207	S2941 
11990	207	S1202 
11991	207	S1202 
11992	207	S2941 
12006	207	D4822 
12006	207	S1783 
12038	207	S661  
12038	207	S961  
12061	207	S141  
12062	207	S141  
12063	207	S141  
12065	207	S141  
12078	207	S1063 
12078	207	S503  
12086	207	S343  
12087	207	S343  
12120	207	S83   
12121	207	S83   
12122	207	S83   
12131	207	S77   
12132	207	S77   
12142	207	S85   
12143	207	S85   
12144	207	S85   
12147	207	S502  
12147	207	S564  
12151	207	S101  
12151	207	S86   
12152	207	S101  
12152	207	S86   
12154	207	S941  
12155	207	S79   
12201	207	S1164 
12220	207	S1221 
12220	207	S2109 
12538	207	S661  
12538	207	S961  
12563	207	S141  
12565	207	S141  
12586	207	S343  
12586	207	S363  
12586	207	S5    
12586	207	S502  
12632	207	S77   
12643	207	S85   
12644	207	S85   
12652	207	S86   
13019	207	S2    
13020	207	S2    
13039	207	S221  
13055	207	S2    
13065	207	S2    
13067	207	S2    
13068	207	S2    
13070	207	S2    
13096	207	S2    
13098	207	S2    
13165	207	S2    
13318	207	S1581 
13320	207	S1581 
13321	207	S1581 
13322	207	S1581 
13323	207	S1581 
13324	207	S1581 
13325	207	S1082 
13326	207	S1082 
13327	207	S1082 
13340	207	S1581 
13341	207	S1581 
13343	207	S2    
13355	207	S230  
13369	207	S2    
13370	207	S2    
13373	207	S2    
13375	207	S2    
13377	207	S2    
13378	207	S2    
13391	207	S2    
13394	207	S2    
13398	207	S2    
13399	207	S2    
13401	207	S2    
13402	207	S2    
13404	207	S2    
13405	207	S2    
13407	207	S2    
13408	207	S2    
13410	207	S2    
13411	207	S2    
13413	207	S2    
13414	207	S2    
13415	207	S2    
13416	207	S2    
13417	207	S2    
13418	207	S2    
13419	207	S2    
13420	207	S2    
13421	207	S2    
13422	207	S2    
13423	207	S2    
13424	207	S2    
13425	207	S2    
13426	207	S2    
13439	207	S2    
13440	207	S2    
13441	207	S2    
13442	207	S2    
13443	207	S2    
13444	207	S2    
13445	207	S2    
13446	207	S2    
13447	207	S2    
13448	207	S2    
13449	207	S2    
13450	207	S2    
13451	207	S2    
13452	207	S2    
13453	207	S2    
13454	207	S2    
13455	207	S2    
13456	207	S2    
13467	207	S221  
13468	207	S221  
13469	207	S221  
13470	207	S221  
13481	207	S221  
13482	207	S221  
13483	207	S221  
13484	207	S221  
13485	207	S2    
13486	207	S2    
13487	207	S2    
13488	207	S2    
13490	207	S2    
13491	207	S2    
13492	207	S2    
13493	207	S2    
13494	207	S14   
13495	207	S14   
13496	207	S14   
13497	207	S14   
13498	207	S14   
13565	207	S2703 
13566	207	S2703 
13567	207	S2703 
13568	207	S2703 
13569	207	S2703 
13805	207	S2    
13806	207	S2    
13809	207	S2    
13810	207	S2    
13811	207	S2    
13812	207	S2    
13813	207	S2    
13814	207	S2    
13850	207	S2    
13851	207	S2    
13853	207	S2    
13854	207	S2    
13856	207	S2    
13857	207	S2    
13868	207	S2    
13869	207	S2    
13870	207	S2    
13871	207	S2    
13872	207	S2    
13873	207	S2    
13874	207	S2    
13875	207	S2    
13876	207	S2    
13877	207	S2    
13878	207	S2    
13879	207	S2    
13880	207	S2    
13881	207	S2    
13882	207	S2    
13891	207	S2    
13893	207	S2    
13894	207	S2    
13896	207	S2    
13898	207	S2    
13900	207	S2    
13909	207	S2    
13910	207	S2    
13911	207	S2    
13912	207	S2    
13913	207	S2    
13914	207	S2    
13917	207	S2    
13918	207	S2    
13920	207	S2    
13921	207	S2    
13923	207	S2    
13924	207	S2    
13929	207	S2    
13930	207	S2    
13931	207	S2    
13932	207	S2    
13934	207	S2    
13935	207	S2    
13936	207	S221  
13937	207	S221  
13938	207	S221  
13939	207	S221  
13940	207	S221  
13941	207	S221  
13942	207	S221  
13943	207	S221  
13944	207	S221  
13946	207	S221  
13947	207	S221  
13948	207	S2    
13949	207	S2    
13950	207	S2    
13951	207	S2    
13952	207	S2    
13953	207	S2    
13954	207	S2    
13955	207	S2    
13956	207	S2    
13957	207	S2    
13958	207	S2    
13959	207	S2    
13960	207	S221  
13961	207	S221  
13962	207	S221  
13963	207	S221  
13964	207	S221  
13965	207	S221  
13966	207	S221  
13967	207	S221  
13968	207	S2    
13969	207	S2    
13970	207	S2    
13971	207	S2    
13976	207	S221  
13977	207	S221  
13978	207	S221  
13979	207	S221  
13985	207	S2    
13987	207	S221  
13988	207	S2703 
13989	207	S2703 
13990	207	S2703 
13991	207	S2703 
13992	207	S2703 
13994	207	S2703 
13995	207	S2703 
13996	207	S2703 
13997	207	S2703 
13998	207	S2703 
14003	207	S2841 
14006	207	S2841 
14084	207	S2841 
14096	207	S2841 
14097	207	S2841 
14098	207	S2841 
14099	207	S2841 
14100	207	S2841 
14101	207	S2841 
14102	207	S2841 
14103	207	S2841 
14105	207	S2841 
14106	207	S2841 
14107	207	S2841 
14108	207	S2841 
14109	207	S2841 
14113	207	S2841 
14116	207	S2841 
14117	207	S2841 
14120	207	S2841 
14124	207	S2841 
14126	207	S2841 
14132	207	S2841 
14134	207	S2841 
14135	207	S2841 
14137	207	S1068 
14138	207	S2841 
14140	207	S2841 
14144	207	S1068 
14145	207	S1064 
14145	207	S1066 
14145	207	S1068 
14145	207	S1122 
14146	207	S1068 
14147	207	S1068 
14148	207	S1068 
14149	207	S1068 
14152	207	S2841 
14154	207	S2702 
14156	207	S2702 
14158	207	S2841 
14159	207	S2841 
14209	207	S1064 
14209	207	S1066 
14209	207	S1122 
14209	207	S23   
14238	207	S2104 
14242	207	S2104 
14243	207	D673  
14277	207	D672  
14277	207	D673  
14282	207	D672  
14323	207	S1067 
14347	207	S1064 
14347	207	S1122 
14366	207	S2104 
14370	207	S2104 
14382	207	S1164 
14400	207	S1064 
14400	207	S1066 
14400	207	S1068 
14400	207	S1122 
14416	207	S1064 
14416	207	S1066 
14416	207	S1068 
14416	207	S1122 
14432	207	S1068 
14433	207	S1068 
14434	207	S1068 
14437	207	S27   
14438	207	S27   
14439	207	S27   
14440	207	S2109 
14450	207	S1164 
14460	207	S1164 
14461	207	S1164 
14462	207	S2109 
14475	207	S1068 
14476	207	S1068 
14555	207	S1068 
14555	207	S27   
14559	207	S1068 
14559	207	S27   
14601	207	S1066 
14602	207	S2841 
15027	207	S1163 
15073	207	S1163 
15078	207	D1066 
15078	207	D1107 
15078	207	D2793 
15078	207	S2621 
15087	207	S2109 
15152	207	S2104 
15232	207	S1163 
15260	207	S2109 
15261	207	S1163 
15262	207	S1163 
16006	207	S1164 
16010	207	S1164 
16011	207	S1164 
16029	207	S1164 
16037	207	S1164 
16037	207	S2202 
16038	207	S1164 
16038	207	S2202 
16042	207	S1065 
16042	207	S2202 
16043	207	S1065 
16043	207	S2202 
16089	207	S563  
16097	207	S22   
16098	207	S22   
16112	207	S39   
16114	207	S39   
16120	207	S39   
16123	207	S39   
16126	207	S39   
16139	207	S39   
16147	207	S2104 
16159	207	D342  
16159	207	S39   
16167	207	S2203 
16174	207	S18   
16338	207	S1164 
16338	207	S2202 
16343	207	S1065 
16343	207	S2202 
16397	207	S22   
16398	207	S22   
17202	207	S1082 
17203	207	S1082 
17204	207	S1082 
17218	207	S1581 
17219	207	S1581 
17332	207	S3    
17335	207	S3    
17340	207	S3    
17341	207	S3    
17342	207	S3    
17345	207	S3    
17346	207	S3    
17347	207	S3    
17348	207	S3    
18001	207	S1162 
18002	207	S1162 
18069	207	S20   
18079	207	S25   
18159	207	S21   
18166	207	S25   
18168	207	S25   
18215	207	S25   
18228	207	S23   
18231	207	S25   
18258	207	S1162 
18259	207	S1162 
18262	207	S1162 
18263	207	S1162 
18288	207	S27   
18350	207	S21   
18363	207	S22   
18364	207	S22   
18365	207	S27   
18376	207	S25   
18403	207	S27   
18927	207	S25   
18930	207	S2203 
18931	207	S2203 
18932	207	S27   
18933	207	S27   
18934	207	S27   
18935	207	S27   
18936	207	S27   
19003	207	S26   
19034	207	S26   
19035	207	S26   
19047	207	S1162 
19056	207	S26   
19057	207	S2109 
19058	207	S2109 
19064	207	S1164 
19076	207	S1164 
19078	207	S1069 
19109	207	S1164 
19120	207	S1069 
19155	207	S1164 
19230	207	S1063 
19283	207	S1067 
19300	207	S5    
19337	207	S2109 
19350	207	S1164 
19411	207	S26   
19856	207	S1067 
19868	207	S2109 
19873	207	S1067 
20046	207	S20   
20047	207	S20   
20048	207	S20   
20049	207	S20   
20099	207	S1163 
20099	207	S20   
20100	207	S20   
20100	207	S2901 
20109	207	S2105 
20110	207	S2105 
20120	207	S1163 
20120	207	S20   
20121	207	S20   
20121	207	S2901 
20132	207	S1202 
20310	207	S2105 
20321	207	S1163 
20400	207	S20   
20400	207	S2901 
20409	207	S2105 
20410	207	S2105 
20420	207	S1163 
20420	207	S20   
20421	207	S20   
20421	207	S2901 
20446	207	S20   
20447	207	S20   
20499	207	S1163 
20499	207	S20   
20510	207	S2105 
20521	207	S1163 
20623	207	S1742 
20624	207	S1742 
20628	207	S1742 
20629	207	S1742 
20630	207	S1742 
20634	207	S1742 
20635	207	S1742 
20636	207	S1742 
20640	207	S1742 
20641	207	S1742 
20645	207	S1742 
20646	207	S1742 
21138	207	S1064 
21138	207	S1066 
21138	207	S1122 
21141	207	S1064 
21224	207	S19   
21225	207	S19   
21226	207	S22   
21227	207	S22   
21229	207	S1122 
21238	207	S2801 
21239	207	S1066 
21240	207	S1066 
21241	207	S1066 
21242	207	S1066 
21243	207	S1066 
21244	207	S1066 
21245	207	S1066 
21246	207	S1066 
21247	207	S1066 
21248	207	S1066 
21249	207	S1064 
21250	207	S1064 
21251	207	S1064 
21252	207	S1064 
21253	207	S1064 
21254	207	S1064 
21255	207	S1064 
21256	207	S1064 
21257	207	S1064 
21259	207	S1064 
21260	207	S1082 
21261	207	S1082 
21262	207	S1082 
21263	207	S1082 
21264	207	S1082 
21265	207	S1082 
21266	207	S1082 
21267	207	S1082 
21268	207	S1082 
21269	207	S1082 
21270	207	S1082 
21271	207	S2108 
21272	207	S2108 
21273	207	S2108 
21274	207	S2108 
21275	207	S2108 
21276	207	S2108 
21277	207	S2110 
21278	207	S2110 
21279	207	S2110 
21280	207	S2110 
21281	207	S2110 
21282	207	S2110 
21283	207	S2111 
21284	207	S2111 
21285	207	S2111 
21286	207	S2111 
21287	207	S2112 
21288	207	S2112 
21289	207	S2112 
21290	207	S2112 
21291	207	S2112 
21292	207	S2112 
21293	207	S2782 
21294	207	S2782 
21295	207	S2782 
21296	207	S2782 
21297	207	S2782 
21298	207	S2782 
21299	207	S2110 
21299	207	S2111 
21299	207	S2112 
21299	207	S2782 
21300	207	S2110 
21300	207	S2112 
21300	207	S2782 
21301	207	S2110 
21301	207	S2111 
21301	207	S2112 
21301	207	S2782 
21302	207	S2110 
21302	207	S2111 
21302	207	S2112 
21302	207	S2782 
21303	207	S2110 
21303	207	S2112 
21303	207	S2782 
21304	207	S2110 
21304	207	S2111 
21304	207	S2112 
21304	207	S2782 
21308	207	S2801 
21309	207	S2801 
21310	207	S2801 
21311	207	S2801 
21312	207	S2801 
21313	207	S2801 
21314	207	S2801 
21315	207	S2801 
21316	207	S2801 
21317	207	S2801 
21318	207	S2801 
21319	207	S2801 
21320	207	S2801 
21321	207	S2801 
21322	207	S2801 
21323	207	S2801 
21324	207	S2801 
21325	207	S2801 
21326	207	S2801 
21337	207	S2801 
21342	207	S2801 
21343	207	S2801 
21346	207	S2801 
21348	207	S2801 
22247	207	S20   
22903	207	S21   
22904	207	S18   
22909	207	S22   
22911	207	S18   
22912	207	S19   
22914	207	S19   
22915	207	S19   
22916	207	S19   
23009	207	S2703 
23010	207	S2703 
23011	207	S2703 
23012	207	S2703 
23013	207	S2703 
23014	207	S2703 
23015	207	S2703 
23016	207	S2703 
23017	207	S2703 
23018	207	S2703 
23019	207	S2703 
23020	207	S2703 
23021	207	S2703 
23022	207	S2703 
23023	207	S2703 
23024	207	S2703 
23025	207	S2703 
23027	207	S2703 
23028	207	S2703 
23029	207	S2703 
23030	207	S2703 
23031	207	S2703 
23032	207	S2703 
23033	207	S2703 
23034	207	S2703 
23035	207	S2703 
23036	207	S2703 
23037	207	S2703 
23038	207	S2703 
23039	207	S2703 
23040	207	S2703 
23041	207	S2703 
23042	207	S2703 
23043	207	S2703 
23044	207	S2703 
23045	207	S2703 
23046	207	S2703 
23047	207	S2703 
23048	207	S2703 
23049	207	S2703 
23050	207	S2703 
23051	207	S2703 
23052	207	S2703 
23053	207	S2703 
23054	207	S2703 
23055	207	S2703 
23056	207	S2703 
23057	207	S2703 
23058	207	S2703 
23059	207	S2703 
23060	207	S2703 
23061	207	S2703 
23062	207	S2703 
23063	207	S2703 
23064	207	S2703 
23065	207	S2703 
23557	207	S14   
23558	207	S14   
23559	207	S14   
23560	207	S14   
23561	207	S14   
23562	207	S14   
23563	207	S14   
23564	207	S14   
23565	207	S14   
23566	207	S14   
23567	207	S14   
23568	207	S14   
23569	207	S14   
23570	207	S14   
23571	207	S14   
23572	207	S14   
23573	207	S14   
23574	207	S14   
23575	207	S14   
23576	207	S14   
23577	207	S14   
23578	207	S14   
23579	207	S14   
23580	207	S14   
23581	207	S14   
23582	207	S2    
23583	207	S2    
23584	207	S2    
23585	207	S2    
23586	207	S2    
23587	207	S2    
23588	207	S2    
23589	207	S2    
23590	207	S2    
23591	207	S2    
23592	207	S2    
23593	207	S2    
23594	207	S2    
23595	207	S2    
23596	207	S2    
23597	207	S2    
23598	207	S2    
23599	207	S2    
23600	207	S2    
23601	207	S2    
23602	207	S2    
23603	207	S2    
23604	207	S2    
23605	207	S2    
23606	207	S2    
23607	207	S2    
23608	207	S2    
23609	207	S2    
23610	207	S2    
23611	207	S2    
23612	207	S2    
23613	207	S2    
23614	207	S2    
23615	207	S2    
23616	207	S2    
23617	207	S2    
23618	207	S2    
23619	207	S2    
23620	207	S2    
23621	207	S2    
23622	207	S2    
23623	207	S2    
23624	207	S2    
23625	207	S2    
23626	207	S2    
23627	207	S2    
23628	207	S2    
23629	207	S2    
23630	207	S2    
23631	207	S2    
23632	207	S2    
23633	207	S2    
23634	207	S2    
23635	207	S2    
23636	207	S2    
23637	207	S2    
23638	207	S2    
23640	207	S1581 
23646	207	S2    
23647	207	S2    
23648	207	S2    
23649	207	S2    
23650	207	S2    
23651	207	S2    
23652	207	S2    
23653	207	S2    
23654	207	S2    
23655	207	S2    
23656	207	S2    
23657	207	S2    
23658	207	S2    
23659	207	S2    
23660	207	S2    
35001	207	D4961 
35002	207	D4961 
35003	207	D4961 
35004	207	D4961 
35008	207	D4961 
35009	207	D4961 
35010	207	D4961 
35011	207	D4961 
35012	207	D4961 
35013	207	D4961 
35014	207	D4961 
35015	207	D4961 
35016	207	D4961 
35017	207	D4961 
35021	207	D4961 
35022	207	D4961 
35023	207	D4961 
35024	207	D4961 
35025	207	D4961 
35026	207	D4961 
35027	207	D4961 
35028	207	D4961 
35029	207	D4961 
35030	207	D4961 
35034	207	D4961 
35038	207	D4961 
35039	207	D4961 
35040	207	D4961 
35041	207	D4961 
35042	207	D4961 
35043	207	D4961 
35046	207	D4961 
35047	207	D4961 
35048	207	D4961 
35050	207	D4961 
35051	207	D4961 
35054	207	D4961 
35055	207	D4961 
35056	207	D4961 
35057	207	D4961 
35058	207	D4961 
35059	207	D4961 
35060	207	D4961 
35063	207	D4961 
35064	207	D4961 
35065	207	D4961 
35066	207	D4961 
35067	207	D4961 
35068	207	D4961 
35070	207	D4961 
35071	207	D4961 
35072	207	D4961 
35073	207	D4961 
35074	207	D4961 
35075	207	D4961 
35078	207	D4961 
35079	207	D4961 
35080	207	D4961 
35081	207	D4961 
35082	207	D4961 
35083	207	D4961 
35084	207	D4961 
35085	207	D4961 
35086	207	D4961 
35087	207	D4961 
35088	207	D4961 
35089	207	D4961 
35090	207	D4961 
35091	207	D4961 
35092	207	D4961 
35093	207	D4961 
35130	207	S2381 
35131	207	S2381 
35132	207	S2381 
35133	207	S2381 
35134	207	S2381 
35135	207	S2381 
35136	207	S2381 
35137	207	S2381 
35138	207	S2381 
35139	207	S2381 
35140	207	S2381 
35141	207	S2381 
35142	207	S2381 
35143	207	S2381 
35144	207	S2381 
35145	207	S2381 
35146	207	S2381 
35147	207	S2381 
35148	207	S2381 
42161	207	S281  
42190	207	S243  
42190	207	S281  
42190	207	S282  
43158	207	S2109 
43215	207	S26   
43364	207	S26   
43372	207	S5    
43378	207	S1082 
43514	207	S1067 
48052	207	S1362 
04673	208	S2401 
04674	208	S2401 
04675	208	S2401 
04676	208	S2401 
04677	208	S2401 
07002	208	S222  
07005	208	S248  
07006	208	S247  
07007	208	S1164 
07014	208	S281  
07039	208	S244  
07056	208	S248  
07064	208	S1164 
07068	208	S1041 
07201	208	S281  
07205	208	S281  
07207	208	S281  
07209	208	S281  
07213	208	S281  
07233	208	S281  
07240	208	S281  
07242	208	S281  
07254	208	S281  
07255	208	S281  
07256	208	S281  
07268	208	S281  
07279	208	S259  
07909	208	S259  
07910	208	S245  
07911	208	S226  
07912	208	S226  
07913	208	S238  
07914	208	S252  
07915	208	S281  
07916	208	S242  
07919	208	S252  
07921	208	S228  
07923	208	S245  
07925	208	S281  
07927	208	S227  
07928	208	S225  
07929	208	S227  
07930	208	S222  
07931	208	S222  
07932	208	S224  
07933	208	S224  
07934	208	S281  
07935	208	S224  
07936	208	S247  
07938	208	S233  
07939	208	S235  
07940	208	S237  
07941	208	S281  
07942	208	S281  
07943	208	S281  
07944	208	S227  
07952	208	S1164 
07958	208	S1164 
07959	208	S1164 
07960	208	S1164 
08001	208	S2664 
08003	208	S2664 
08005	208	S2664 
08010	208	S702  
08011	208	S702  
08013	208	S603  
08014	208	S2664 
08017	208	S603  
08018	208	S702  
08019	208	S603  
08020	208	S2664 
08023	208	S2664 
08026	208	S603  
08028	208	S2664 
08030	208	S2664 
08031	208	S2664 
08032	208	S2664 
08035	208	S603  
08045	208	S603  
08047	208	S702  
08048	208	S603  
08049	208	S702  
08050	208	S603  
08054	208	S702  
08057	208	S603  
08058	208	S2664 
08059	208	S702  
08060	208	S2664 
08064	208	S603  
08065	208	S2664 
08066	208	S702  
08067	208	S2664 
08068	208	S2664 
08069	208	S2664 
08071	208	S2664 
08077	208	S603  
08078	208	S603  
08082	208	S603  
08083	208	S2502 
08085	208	S702  
08086	208	S603  
08087	208	S603  
08089	208	S603  
08092	208	S702  
08094	208	S702  
08116	208	S2502 
08124	208	S702  
08128	208	S702  
08130	208	S702  
08138	208	S2502 
08139	208	S603  
08146	208	S702  
08147	208	S2422 
08177	208	S2502 
08189	208	S2664 
08190	208	S603  
08194	208	S603  
08200	208	S702  
08202	208	S603  
08206	208	S2502 
08210	208	S702  
08211	208	S702  
08212	208	S702  
08214	208	S702  
08215	208	S702  
08216	208	S702  
08217	208	S2664 
08219	208	S702  
08220	208	S702  
08221	208	S702  
08225	208	S702  
08229	208	S702  
08231	208	S702  
08232	208	S702  
08243	208	S603  
08244	208	S603  
08245	208	S603  
08247	208	S603  
08253	208	S2664 
08258	208	S2664 
08259	208	S2664 
08262	208	S603  
08263	208	S603  
08266	208	S603  
08267	208	S603  
08268	208	S603  
08269	208	S603  
08270	208	S603  
08271	208	S603  
08272	208	S603  
08273	208	S603  
08274	208	S603  
08278	208	S603  
08283	208	S2664 
08284	208	S2664 
08286	208	S2664 
08287	208	S2664 
08288	208	S2664 
08289	208	S2664 
08293	208	S702  
08294	208	S702  
08299	208	S702  
08309	208	S2664 
08315	208	S702  
08316	208	S702  
08317	208	S702  
08318	208	S2664 
08319	208	S2664 
08345	208	S603  
08346	208	S2502 
08347	208	S2502 
08348	208	S2502 
08349	208	S2502 
08350	208	S2502 
08351	208	S702  
08352	208	S702  
08353	208	S702  
08354	208	S702  
08355	208	S702  
08357	208	S702  
08358	208	S702  
08359	208	S702  
08360	208	S702  
08361	208	S702  
08362	208	S702  
08363	208	S702  
08364	208	S702  
08366	208	S702  
08367	208	S603  
08368	208	S603  
08370	208	S603  
08371	208	S603  
08372	208	S603  
08374	208	S2664 
08376	208	S2664 
08378	208	S2161 
08379	208	S2664 
08380	208	S2664 
08383	208	S2664 
08384	208	S2664 
08385	208	S2664 
08386	208	S2664 
08387	208	S2664 
08388	208	S2664 
08390	208	S2664 
08391	208	S682  
08392	208	S2664 
08393	208	S2664 
08394	208	S702  
08395	208	S702  
08396	208	S702  
08397	208	S603  
08398	208	S603  
08399	208	S603  
08400	208	S881  
08401	208	S881  
08402	208	S702  
08403	208	S1209 
08408	208	S2502 
08409	208	S2502 
08410	208	S702  
08411	208	S702  
08412	208	S702  
08413	208	S702  
08414	208	S702  
08415	208	S702  
08416	208	S702  
08417	208	S702  
08418	208	S702  
08419	208	S702  
08420	208	S702  
08421	208	S702  
08422	208	S702  
08436	208	S702  
08444	208	S702  
08446	208	S702  
08448	208	S702  
08449	208	S702  
08450	208	S702  
08454	208	S2664 
08455	208	S2664 
08456	208	S2664 
08457	208	S2664 
08458	208	S2664 
08459	208	S2664 
08460	208	S2664 
08461	208	S2664 
08462	208	S2664 
08463	208	S2664 
08464	208	S2664 
08465	208	S2664 
08466	208	S2664 
08467	208	S2161 
08468	208	S2664 
08469	208	S2664 
08470	208	S2664 
08471	208	S2664 
08472	208	S2664 
08473	208	S2664 
08474	208	S2664 
08476	208	S2502 
08478	208	S2502 
08481	208	S2502 
08482	208	S2502 
08483	208	S2502 
08484	208	S2502 
08487	208	S2502 
08488	208	S2502 
08489	208	S2502 
08490	208	S2502 
08491	208	S2502 
08492	208	S2502 
08493	208	S2502 
08494	208	S2502 
08495	208	S2502 
08497	208	S2502 
08498	208	S2502 
08500	208	S2502 
08501	208	S2502 
11935	208	S5    
11949	208	S5    
13321	208	S1581 
16114	208	S39   
48052	208	S1362 
01103	209	S1163 
01202	209	S1163 
04017	209	S19   
04021	209	S19   
04023	209	S19   
04114	209	S19   
04120	209	S19   
04141	209	S19   
04142	209	S19   
04143	209	S19   
04144	209	S19   
04367	209	S19   
04635	209	S19   
04636	209	S19   
04638	209	S26   
04639	209	S26   
04640	209	S26   
04641	209	S25   
05312	209	S26   
05313	209	S26   
05320	209	S26   
06019	209	S18   
06128	209	S18   
06159	209	S18   
06164	209	S23   
06982	209	S18   
06983	209	S18   
06984	209	S2104 
06985	209	S2104 
07022	209	S21   
07241	209	S21   
07945	209	S21   
08001	209	S1065 
08012	209	S1065 
08014	209	S1065 
08020	209	S1065 
08030	209	S1065 
08061	209	S1065 
08077	209	S1065 
08147	209	S1065 
08218	209	S1065 
08435	209	S1065 
08504	209	S2662 
08506	209	S2662 
09003	209	S561  
09032	209	S21   
09037	209	S481  
09037	209	S502  
09038	209	S481  
09038	209	S502  
09040	209	S481  
09040	209	S562  
09042	209	S461  
09050	209	S421  
09070	209	S582  
09078	209	S561  
09094	209	S363  
09112	209	S563  
09132	209	S1062 
09148	209	S363  
09160	209	S1065 
09181	209	S461  
09184	209	S562  
09191	209	S421  
09202	209	S564  
09218	209	S1065 
09236	209	S461  
09266	209	S561  
09279	209	S421  
09291	209	S564  
09291	209	S566  
09298	209	S564  
09298	209	S566  
09302	209	S461  
09316	209	S421  
09316	209	S566  
09326	209	S461  
09430	209	S561  
09433	209	S2105 
11012	209	S1069 
11090	209	S564  
11091	209	S564  
11112	209	S1065 
11113	209	S1065 
11124	209	S1062 
11125	209	S1062 
11130	209	S25   
11131	209	S25   
11143	209	S564  
11205	209	S1062 
11206	209	S1062 
11243	209	S2941 
11251	209	S503  
11253	209	S541  
11257	209	S541  
11260	209	S2941 
11263	209	S2941 
11267	209	S2941 
11282	209	S1062 
11286	209	S1062 
11294	209	S563  
11333	209	S1062 
11339	209	S1062 
11352	209	S563  
11352	209	S566  
11353	209	S563  
11353	209	S566  
11355	209	S563  
11355	209	S566  
11356	209	S563  
11356	209	S566  
11357	209	S563  
11357	209	S566  
11358	209	S563  
11358	209	S566  
11359	209	S2105 
11360	209	S2105 
11394	209	S2105 
11395	209	S2105 
11398	209	S2105 
11399	209	S2105 
11402	209	S2105 
11403	209	S2105 
11411	209	S2105 
11412	209	S2105 
11429	209	S363  
11463	209	S25   
11464	209	S25   
11507	209	S1062 
11508	209	S1062 
11510	209	S1062 
11529	209	S503  
11546	209	S21   
11674	209	S563  
11674	209	S566  
11705	209	S1069 
11742	209	S564  
11752	209	S1065 
11757	209	S1062 
11760	209	S25   
11821	209	S1062 
11828	209	S563  
11828	209	S566  
11841	209	S2105 
11842	209	S2105 
11856	209	S25   
11875	209	S1062 
11876	209	S1062 
11887	209	S21   
11921	209	S1062 
11960	209	S562  
11987	209	S2941 
11992	209	S2941 
12061	209	S141  
12062	209	S141  
12063	209	S141  
12065	209	S141  
12078	209	S1063 
12078	209	S503  
12086	209	S343  
12086	209	S363  
12086	209	S502  
12087	209	S343  
12120	209	S83   
12121	209	S83   
12122	209	S83   
12131	209	S77   
12132	209	S77   
12142	209	S85   
12143	209	S85   
12144	209	S85   
12147	209	S564  
12151	209	S86   
12152	209	S86   
12154	209	S941  
12155	209	S79   
12220	209	S2109 
12563	209	S141  
12565	209	S141  
12586	209	S343  
12586	209	S363  
12586	209	S502  
12632	209	S77   
12643	209	S85   
12644	209	S85   
12652	209	S86   
14003	209	S2103 
14006	209	S2103 
14366	209	S2104 
14370	209	S2104 
15027	209	S1163 
15087	209	S2109 
15260	209	S2109 
16006	209	S1164 
16010	209	S1164 
16011	209	S1164 
16029	209	S1164 
16037	209	S1164 
16038	209	S1164 
16042	209	S1065 
16043	209	S1065 
16097	209	S22   
16098	209	S22   
16147	209	S2104 
16167	209	S2203 
16338	209	S1164 
16343	209	S1065 
16397	209	S22   
16398	209	S22   
18001	209	S1162 
18002	209	S1162 
18069	209	S20   
18079	209	S25   
18159	209	S21   
18166	209	S25   
18168	209	S25   
18215	209	S25   
18228	209	S23   
18231	209	S25   
18258	209	S1162 
18259	209	S1162 
18262	209	S1162 
18263	209	S1162 
18288	209	S27   
18350	209	S21   
18365	209	S27   
18376	209	S25   
18403	209	S27   
18927	209	S25   
18930	209	S2203 
18931	209	S2203 
18932	209	S27   
18933	209	S27   
18934	209	S27   
18935	209	S27   
18936	209	S27   
19003	209	S26   
19034	209	S26   
19035	209	S26   
19047	209	S1162 
19056	209	S26   
19057	209	S2109 
19058	209	S2109 
19064	209	S1164 
19109	209	S1164 
19155	209	S1164 
19337	209	S2109 
19868	209	S2109 
20046	209	S20   
20047	209	S20   
20048	209	S20   
20049	209	S20   
20099	209	S1163 
20099	209	S20   
20100	209	S1163 
20100	209	S20   
20120	209	S1163 
20120	209	S20   
20121	209	S1163 
20121	209	S20   
20321	209	S1163 
20321	209	S20   
20400	209	S1163 
20400	209	S20   
20420	209	S1163 
20420	209	S20   
20421	209	S1163 
20421	209	S20   
20446	209	S20   
20447	209	S20   
20499	209	S1163 
20499	209	S20   
20521	209	S1163 
20521	209	S20   
20623	209	S1742 
20624	209	S1742 
20628	209	S1742 
20629	209	S1742 
20630	209	S1742 
20634	209	S1742 
20635	209	S1742 
20636	209	S1742 
20640	209	S1742 
20641	209	S1742 
20645	209	S1742 
20646	209	S1742 
21141	209	S1064 
21224	209	S19   
21225	209	S19   
21226	209	S22   
21227	209	S22   
21239	209	S1066 
21240	209	S1066 
21241	209	S1066 
21242	209	S1066 
21243	209	S1066 
21244	209	S1066 
21245	209	S1066 
21246	209	S1066 
21247	209	S1066 
21248	209	S1066 
21249	209	S1064 
21250	209	S1064 
21251	209	S1064 
21252	209	S1064 
21254	209	S1064 
21255	209	S1064 
21256	209	S1064 
21259	209	S1064 
21260	209	S1082 
21261	209	S1082 
21262	209	S1082 
21263	209	S1082 
21264	209	S1082 
21265	209	S1082 
21266	209	S1082 
21267	209	S1082 
21268	209	S1082 
21269	209	S1082 
21270	209	S1082 
21271	209	S2108 
21272	209	S2108 
21273	209	S2108 
21274	209	S2108 
21275	209	S2108 
21276	209	S2108 
21277	209	S2110 
21278	209	S2110 
21279	209	S2110 
21280	209	S2110 
21281	209	S2110 
21282	209	S2110 
21283	209	S2111 
21284	209	S2111 
21285	209	S2111 
21286	209	S2111 
21287	209	S2112 
21288	209	S2112 
21289	209	S2112 
21290	209	S2112 
21291	209	S2112 
21292	209	S2112 
21293	209	S2782 
21294	209	S2782 
21295	209	S2782 
21296	209	S2782 
21297	209	S2782 
21298	209	S2782 
21299	209	S2110 
21299	209	S2111 
21299	209	S2112 
21299	209	S2782 
21300	209	S2110 
21300	209	S2112 
21300	209	S2782 
21301	209	S2110 
21301	209	S2111 
21301	209	S2112 
21301	209	S2782 
21302	209	S2110 
21302	209	S2111 
21302	209	S2112 
21302	209	S2782 
21303	209	S2110 
21303	209	S2112 
21303	209	S2782 
21304	209	S2110 
21304	209	S2111 
21304	209	S2112 
21304	209	S2782 
22247	209	S20   
22903	209	S21   
22904	209	S18   
22909	209	S22   
22911	209	S18   
22912	209	S19   
22914	209	S19   
22915	209	S19   
22916	209	S19   
35130	209	S2381 
35131	209	S2381 
35132	209	S2381 
35133	209	S2381 
35134	209	S2381 
35135	209	S2381 
35136	209	S2381 
35137	209	S2381 
35138	209	S2381 
35139	209	S2381 
35140	209	S2381 
35142	209	S2381 
35143	209	S2381 
35144	209	S2381 
35145	209	S2381 
35146	209	S2381 
35147	209	S2381 
35148	209	S2381 
43158	209	S2109 
43215	209	S26   
43364	209	S26   
01026	210	S25   
01026	210	S606  
01032	210	S19   
01077	210	S27   
01079	210	S1063 
01079	210	S20   
01082	210	S1063 
01085	210	S1063 
01103	210	S1163 
01123	210	S1063 
01123	210	S561  
01124	210	S1065 
01125	210	S1065 
01202	210	S1163 
02003	210	S1069 
02009	210	S1069 
02010	210	S1069 
02011	210	S1069 
02015	210	S1069 
02021	210	S1069 
02024	210	S1069 
02027	210	S1069 
02028	210	S1069 
02029	210	S1069 
02043	210	S1069 
02048	210	S2922 
04017	210	S19   
04021	210	S19   
04023	210	S19   
04114	210	S19   
04120	210	S19   
04141	210	S19   
04143	210	S19   
04144	210	S19   
04367	210	S19   
04635	210	S19   
04636	210	S19   
04638	210	S26   
04639	210	S26   
04640	210	S26   
04641	210	S25   
05312	210	S26   
05313	210	S26   
05320	210	S26   
06016	210	S18   
06019	210	S18   
06094	210	S18   
06128	210	S18   
06159	210	S18   
06931	210	S22   
06982	210	S18   
06983	210	S18   
06984	210	S2104 
06985	210	S2104 
07022	210	S21   
07945	210	S21   
07951	210	S243  
08001	210	S1065 
08012	210	S1065 
08014	210	S1065 
08020	210	S1065 
08025	210	S2662 
08030	210	S1065 
08061	210	S1065 
08065	210	S2662 
08074	210	S2662 
08077	210	S1065 
08147	210	S1065 
08218	210	S1065 
08259	210	S2662 
08435	210	S1065 
08504	210	S2662 
08505	210	S2662 
08506	210	S2662 
08507	210	S2662 
08508	210	S2662 
08509	210	S2662 
09003	210	S502  
09003	210	S561  
09004	210	S502  
09021	210	D3321 
09021	210	D3344 
09021	210	S604  
09032	210	S21   
09037	210	S481  
09037	210	S502  
09037	210	S837  
09038	210	S481  
09038	210	S502  
09038	210	S837  
09039	210	S837  
09040	210	S481  
09040	210	S562  
09042	210	S461  
09042	210	S566  
09050	210	S421  
09050	210	S441  
09062	210	S404  
09070	210	D3321 
09070	210	D3336 
09070	210	D3344 
09070	210	S582  
09078	210	S561  
09084	210	D3321 
09087	210	S564  
09087	210	S582  
09094	210	S363  
09094	210	S582  
09112	210	S482  
09112	210	S563  
09132	210	S1062 
09148	210	S363  
09148	210	S582  
09160	210	S1065 
09181	210	S1121 
09181	210	S461  
09181	210	S604  
09181	210	S606  
09184	210	S562  
09184	210	S565  
09191	210	D3344 
09191	210	S421  
09191	210	S582  
09202	210	S482  
09202	210	S564  
09202	210	S837  
09215	210	S404  
09215	210	S837  
09218	210	S1065 
09218	210	S606  
09236	210	S461  
09236	210	S582  
09252	210	S482  
09252	210	S541  
09263	210	D4941 
09263	210	S606  
09266	210	S441  
09266	210	S561  
09268	210	D3315 
09270	210	D3315 
09273	210	S2104 
09279	210	S421  
09279	210	S582  
09291	210	D3315 
09291	210	S564  
09291	210	S566  
09291	210	S606  
09291	210	S837  
09298	210	D3315 
09298	210	S564  
09298	210	S566  
09298	210	S837  
09302	210	S461  
09302	210	S566  
09316	210	S421  
09316	210	S566  
09316	210	S606  
09318	210	S604  
09326	210	S441  
09326	210	S461  
09326	210	S837  
09409	210	S2104 
09421	210	S564  
09421	210	S582  
09427	210	D4053 
09428	210	D4053 
09429	210	S441  
09430	210	S441  
09430	210	S561  
09431	210	S2203 
09432	210	S2203 
09433	210	S2105 
11011	210	D3321 
11011	210	S1069 
11012	210	S1069 
11090	210	D3321 
11090	210	S1121 
11090	210	S564  
11090	210	S604  
11090	210	S606  
11090	210	S837  
11091	210	S1121 
11091	210	S564  
11091	210	S837  
11096	210	S1121 
11096	210	S482  
11097	210	S482  
11112	210	D3321 
11112	210	D3326 
11112	210	S1065 
11113	210	S1065 
11124	210	S1062 
11124	210	S604  
11124	210	S606  
11124	210	S837  
11125	210	S1062 
11130	210	S25   
11131	210	S25   
11143	210	D3284 
11143	210	D3321 
11143	210	S1121 
11143	210	S564  
11143	210	S604  
11205	210	S1062 
11206	210	S1062 
11243	210	S2941 
11250	210	S562  
11251	210	S503  
11252	210	S562  
11252	210	S604  
11252	210	S837  
11253	210	S541  
11257	210	S541  
11260	210	S2941 
11263	210	S2941 
11267	210	S2941 
11282	210	D3306 
11282	210	D3309 
11282	210	D3321 
11282	210	S1062 
11282	210	S837  
11286	210	S1062 
11294	210	S563  
11294	210	S582  
11333	210	S1062 
11333	210	S604  
11333	210	S837  
11339	210	S1062 
11352	210	S563  
11352	210	S566  
11353	210	S563  
11353	210	S566  
11354	210	S563  
11354	210	S566  
11355	210	S563  
11355	210	S566  
11356	210	S563  
11356	210	S566  
11357	210	S563  
11357	210	S566  
11358	210	S563  
11358	210	S566  
11359	210	S2105 
11360	210	S2105 
11394	210	S2105 
11395	210	S2105 
11398	210	S2105 
11399	210	S2105 
11402	210	S2105 
11403	210	S2105 
11411	210	S2105 
11412	210	S2105 
11429	210	D3309 
11429	210	D3321 
11429	210	S1121 
11429	210	S363  
11463	210	S25   
11464	210	S25   
11507	210	S1062 
11507	210	S606  
11508	210	D3335 
11508	210	S1062 
11508	210	S606  
11510	210	S1062 
11529	210	D3306 
11529	210	S441  
11529	210	S503  
11529	210	S604  
11529	210	S837  
11530	210	S441  
11546	210	S21   
11549	210	S21   
11674	210	S563  
11674	210	S566  
11705	210	S1069 
11742	210	S1121 
11742	210	S564  
11742	210	S837  
11752	210	S1065 
11757	210	S1062 
11760	210	S25   
11821	210	S1062 
11828	210	S563  
11828	210	S566  
11841	210	S2105 
11842	210	S2105 
11856	210	S25   
11875	210	D3335 
11875	210	S1062 
11875	210	S606  
11876	210	S1062 
11884	210	S441  
11887	210	S21   
11921	210	S1062 
11935	210	S22   
11949	210	S22   
11950	210	S2941 
11960	210	S562  
11987	210	S2941 
11992	210	S2941 
12038	210	S606  
12038	210	S661  
12038	210	S961  
12061	210	S141  
12062	210	S141  
12063	210	S141  
12065	210	S141  
12078	210	S1063 
12078	210	S503  
12086	210	S343  
12086	210	S363  
12086	210	S502  
12087	210	S343  
12120	210	S83   
12121	210	S83   
12122	210	S83   
12131	210	S77   
12132	210	S77   
12142	210	S85   
12143	210	S85   
12144	210	S85   
12147	210	S564  
12151	210	S101  
12151	210	S86   
12152	210	S101  
12152	210	S86   
12154	210	S941  
12155	210	S79   
12201	210	S1164 
12201	210	S606  
12220	210	S1221 
12220	210	S2109 
12537	210	S604  
12538	210	S606  
12538	210	S661  
12538	210	S961  
12563	210	S141  
12565	210	S141  
12586	210	S343  
12586	210	S363  
12586	210	S502  
12632	210	S77   
12643	210	S85   
12644	210	S85   
12652	210	S101  
12652	210	S86   
14003	210	S2103 
14006	210	S2103 
14144	210	S1068 
14145	210	S1064 
14145	210	S1066 
14145	210	S1068 
14145	210	S1122 
14147	210	S1068 
14148	210	S1068 
14209	210	S23   
14242	210	S2104 
14416	210	S1064 
14416	210	S1066 
14416	210	S1122 
14450	210	S1164 
14460	210	S1164 
14461	210	S1164 
14476	210	S1068 
15027	210	S1163 
15087	210	S2109 
15260	210	S2109 
16006	210	S1164 
16010	210	S1164 
16010	210	S604  
16010	210	S606  
16011	210	S1164 
16011	210	S604  
16011	210	S606  
16029	210	S1164 
16037	210	S1164 
16038	210	S1164 
16042	210	S1065 
16043	210	S1065 
16089	210	S563  
16097	210	S22   
16098	210	S22   
16098	210	S404  
16098	210	S837  
16147	210	S2104 
16167	210	S2203 
16338	210	S1164 
16343	210	S1065 
16397	210	S22   
16398	210	S22   
16398	210	S404  
16398	210	S837  
18001	210	S1162 
18002	210	S1162 
18069	210	S20   
18079	210	S25   
18159	210	S21   
18166	210	S25   
18168	210	S25   
18215	210	S25   
18231	210	S25   
18258	210	S1162 
18259	210	S1162 
18288	210	S27   
18350	210	S21   
18363	210	S22   
18364	210	S22   
18365	210	S27   
18376	210	S25   
18403	210	S27   
18927	210	S25   
18930	210	S2203 
18931	210	S2203 
18932	210	S27   
18933	210	S27   
18934	210	S27   
18935	210	S27   
18936	210	S27   
19003	210	S26   
19034	210	S26   
19035	210	S26   
19047	210	S1162 
19056	210	S26   
19057	210	S2109 
19058	210	S2109 
19064	210	S1164 
19076	210	S1164 
19109	210	S1164 
19155	210	S1164 
19283	210	S1067 
19296	210	D3338 
19296	210	D3339 
19304	210	D3296 
19350	210	S1164 
19353	210	D3316 
19856	210	S1067 
19873	210	S1067 
20010	210	S604  
20037	210	S604  
20037	210	S837  
20044	210	S1164 
20044	210	S20   
20046	210	S20   
20046	210	S604  
20046	210	S606  
20047	210	S20   
20047	210	S606  
20048	210	S20   
20049	210	S20   
20089	210	S604  
20108	210	S604  
20109	210	S2105 
20109	210	S606  
20110	210	S2105 
20110	210	S606  
20310	210	S2105 
20310	210	S606  
20409	210	S2105 
20409	210	S606  
20410	210	S2105 
20410	210	S606  
20446	210	S20   
20446	210	S604  
20446	210	S606  
20447	210	S20   
20447	210	S606  
20510	210	S2105 
20510	210	S606  
20623	210	S1742 
20624	210	S1742 
20628	210	S1742 
20629	210	S1742 
20630	210	S1742 
20634	210	S1742 
20635	210	S1742 
20636	210	S1742 
20640	210	S1742 
20641	210	S1742 
20645	210	S1742 
20646	210	S1742 
21138	210	S1064 
21138	210	S1066 
21138	210	S1122 
21141	210	S1064 
21224	210	S19   
21229	210	S1122 
21238	210	S2801 
21239	210	S1066 
21240	210	S1066 
21241	210	S1066 
21242	210	S1066 
21243	210	S1066 
21244	210	S1066 
21245	210	S1066 
21246	210	S1066 
21247	210	S1066 
21248	210	S1066 
21249	210	S1064 
21250	210	S1064 
21251	210	S1064 
21252	210	S1064 
21253	210	S1064 
21254	210	S1064 
21255	210	S1064 
21256	210	S1064 
21257	210	S1064 
21259	210	S1064 
21260	210	S1082 
21261	210	S1082 
21262	210	S1082 
21263	210	S1082 
21264	210	S1082 
21265	210	S1082 
21266	210	S1082 
21267	210	S1082 
21268	210	S1082 
21269	210	S1082 
21270	210	S1082 
21271	210	S2108 
21272	210	S2108 
21273	210	S2108 
21274	210	S2108 
21275	210	S2108 
21276	210	S2108 
21277	210	S2110 
21278	210	S2110 
21279	210	S2110 
21280	210	S2110 
21281	210	S2110 
21282	210	S2110 
21283	210	S2111 
21284	210	S2111 
21285	210	S2111 
21286	210	S2111 
21287	210	S2112 
21288	210	S2112 
21289	210	S2112 
21290	210	S2112 
21291	210	S2112 
21292	210	S2112 
21293	210	S2782 
21294	210	S2782 
21295	210	S2782 
21296	210	S2782 
21297	210	S2782 
21298	210	S2782 
21299	210	S2110 
21299	210	S2111 
21299	210	S2112 
21299	210	S2782 
21300	210	S2110 
21300	210	S2112 
21300	210	S2782 
21301	210	S2110 
21301	210	S2111 
21301	210	S2112 
21301	210	S2782 
21302	210	S2110 
21302	210	S2111 
21302	210	S2112 
21302	210	S2782 
21303	210	S2110 
21303	210	S2112 
21303	210	S2782 
21304	210	S2110 
21304	210	S2111 
21304	210	S2112 
21304	210	S2782 
21308	210	S2801 
21309	210	S2801 
21310	210	S2801 
21311	210	S2801 
21312	210	S2801 
21313	210	S2801 
21314	210	S2801 
21315	210	S2801 
21316	210	S2801 
21317	210	S2801 
21318	210	S2801 
21319	210	S2801 
21320	210	S2801 
21321	210	S2801 
21322	210	S2801 
21323	210	S2801 
21324	210	S2801 
21325	210	S2801 
21326	210	S2801 
21337	210	S2801 
21342	210	S2801 
21343	210	S2801 
22247	210	S20   
22903	210	S21   
22904	210	S18   
22909	210	S22   
22911	210	S18   
22915	210	S19   
22916	210	S19   
35130	210	S2381 
35131	210	S2381 
35132	210	S2381 
35133	210	S2381 
35134	210	S2381 
35135	210	S2381 
35136	210	S2381 
35137	210	S2381 
35139	210	S2381 
35140	210	S2381 
35142	210	S2381 
35143	210	S2381 
35144	210	S2381 
35145	210	S2381 
35146	210	S2381 
35147	210	S2381 
35148	210	S2381 
43215	210	S26   
43364	210	S26   
43514	210	S1067 
01026	211	S25   
01026	211	S606  
01032	211	S19   
01046	211	S19   
01077	211	S27   
01079	211	S1063 
01079	211	S20   
01082	211	S1063 
01085	211	S1063 
01103	211	S1163 
01123	211	S1063 
01123	211	S561  
01124	211	S1065 
01125	211	S1065 
01202	211	S1163 
02003	211	S1069 
02009	211	S1069 
02010	211	S1069 
02011	211	S1069 
02015	211	S1069 
02021	211	S1069 
02024	211	S1069 
02027	211	S1069 
02028	211	S1069 
02029	211	S1069 
02043	211	S1069 
02048	211	S2922 
04017	211	S19   
04021	211	S19   
04023	211	S19   
04114	211	S19   
04120	211	S19   
04141	211	S19   
04142	211	S19   
04143	211	S19   
04144	211	S19   
04367	211	S19   
04635	211	S19   
04636	211	S19   
04638	211	S26   
04639	211	S26   
04640	211	S26   
04641	211	S25   
05312	211	S26   
05313	211	S26   
05320	211	S26   
06016	211	S18   
06019	211	S18   
06094	211	S18   
06128	211	S18   
06159	211	S18   
06931	211	S22   
06982	211	S18   
06983	211	S18   
06984	211	S2104 
06985	211	S2104 
07022	211	S21   
07945	211	S21   
07951	211	S243  
08001	211	S1065 
08012	211	S1065 
08014	211	S1065 
08020	211	S1065 
08025	211	S2662 
08030	211	S1065 
08061	211	S1065 
08065	211	S2662 
08074	211	S2662 
08077	211	S1065 
08147	211	S1065 
08218	211	S1065 
08259	211	S2662 
08435	211	S1065 
08504	211	S2662 
08505	211	S2662 
08506	211	S2662 
08507	211	S2662 
08508	211	S2662 
08509	211	S2662 
09003	211	S502  
09003	211	S561  
09004	211	S502  
09021	211	D3321 
09021	211	D3344 
09021	211	S604  
09032	211	S21   
09037	211	S481  
09037	211	S502  
09037	211	S837  
09038	211	S481  
09038	211	S502  
09038	211	S837  
09039	211	S837  
09040	211	S481  
09040	211	S562  
09042	211	S461  
09042	211	S566  
09050	211	S421  
09050	211	S441  
09070	211	D3321 
09070	211	D3336 
09070	211	D3344 
09070	211	S582  
09078	211	S561  
09084	211	D3321 
09087	211	S564  
09087	211	S582  
09094	211	S363  
09094	211	S582  
09112	211	S482  
09112	211	S563  
09132	211	S1062 
09148	211	S363  
09148	211	S582  
09160	211	S1065 
09181	211	S1121 
09181	211	S461  
09181	211	S604  
09181	211	S606  
09184	211	S562  
09184	211	S565  
09191	211	D3344 
09191	211	S421  
09191	211	S582  
09202	211	S482  
09202	211	S564  
09202	211	S837  
09215	211	S404  
09215	211	S837  
09218	211	S1065 
09218	211	S606  
09236	211	S461  
09236	211	S582  
09252	211	S482  
09252	211	S541  
09263	211	D4941 
09263	211	S606  
09266	211	S441  
09266	211	S561  
09268	211	D3315 
09270	211	D3315 
09273	211	S2104 
09279	211	S421  
09279	211	S582  
09291	211	D3315 
09291	211	D3318 
09291	211	S564  
09291	211	S566  
09291	211	S606  
09291	211	S837  
09298	211	D3315 
09298	211	S564  
09298	211	S566  
09298	211	S837  
09302	211	S461  
09302	211	S566  
09316	211	S421  
09316	211	S566  
09316	211	S604  
09316	211	S606  
09318	211	S604  
09318	211	S606  
09326	211	S441  
09326	211	S461  
09326	211	S837  
09409	211	S2104 
09421	211	S564  
09421	211	S582  
09427	211	D4053 
09428	211	D4053 
09429	211	S441  
09430	211	S441  
09430	211	S561  
09431	211	S2203 
09432	211	S2203 
09433	211	S2105 
11011	211	D3321 
11011	211	D3326 
11011	211	S1069 
11012	211	S1069 
11090	211	D3321 
11090	211	S1121 
11090	211	S564  
11090	211	S604  
11090	211	S606  
11090	211	S837  
11091	211	S1121 
11091	211	S564  
11091	211	S837  
11096	211	S1121 
11096	211	S482  
11097	211	S482  
11112	211	D3321 
11112	211	D3326 
11112	211	S1065 
11113	211	S1065 
11124	211	S1062 
11124	211	S604  
11124	211	S606  
11124	211	S837  
11125	211	S1062 
11130	211	S25   
11131	211	S25   
11143	211	D3284 
11143	211	D3321 
11143	211	S1121 
11143	211	S564  
11143	211	S604  
11205	211	S1062 
11205	211	S604  
11206	211	S1062 
11243	211	S2941 
11250	211	S562  
11251	211	S503  
11252	211	S562  
11252	211	S604  
11252	211	S837  
11253	211	S541  
11257	211	S541  
11260	211	S2941 
11260	211	S604  
11260	211	S606  
11260	211	S80   
11263	211	S2941 
11267	211	S2941 
11282	211	D3306 
11282	211	D3309 
11282	211	D3321 
11282	211	S1062 
11282	211	S837  
11286	211	S1062 
11294	211	S563  
11294	211	S582  
11333	211	D3326 
11333	211	S1062 
11333	211	S604  
11333	211	S837  
11339	211	S1062 
11352	211	S563  
11352	211	S566  
11353	211	S563  
11353	211	S566  
11354	211	S563  
11354	211	S566  
11355	211	S563  
11355	211	S566  
11356	211	S563  
11356	211	S566  
11357	211	S563  
11357	211	S566  
11358	211	S563  
11358	211	S566  
11359	211	S2105 
11360	211	S2105 
11394	211	S2105 
11395	211	S2105 
11398	211	S2105 
11399	211	S2105 
11402	211	S2105 
11403	211	S2105 
11411	211	S2105 
11412	211	S2105 
11429	211	D3309 
11429	211	D3321 
11429	211	S1121 
11429	211	S363  
11429	211	S604  
11463	211	S25   
11464	211	S25   
11507	211	S1062 
11507	211	S606  
11508	211	D3335 
11508	211	S1062 
11508	211	S606  
11510	211	S1062 
11529	211	D3306 
11529	211	D3309 
11529	211	D3326 
11529	211	S441  
11529	211	S503  
11529	211	S604  
11529	211	S837  
11530	211	S441  
11546	211	S21   
11547	211	S21   
11549	211	S21   
11674	211	S563  
11674	211	S566  
11705	211	S1069 
11742	211	S1121 
11742	211	S564  
11742	211	S837  
11752	211	S1065 
11757	211	S1062 
11760	211	S25   
11821	211	S1062 
11828	211	S563  
11828	211	S566  
11841	211	S2105 
11842	211	S2105 
11856	211	S25   
11875	211	D3335 
11875	211	S1062 
11875	211	S606  
11876	211	S1062 
11884	211	S441  
11887	211	S21   
11888	211	S21   
11921	211	S1062 
11935	211	S22   
11949	211	S22   
11950	211	S2941 
11960	211	S562  
11987	211	S2941 
11992	211	S2941 
12038	211	S606  
12038	211	S661  
12038	211	S961  
12061	211	S141  
12062	211	S141  
12063	211	S141  
12065	211	S141  
12078	211	S1063 
12078	211	S503  
12086	211	S343  
12086	211	S363  
12086	211	S502  
12087	211	S343  
12120	211	S83   
12121	211	S83   
12122	211	S83   
12131	211	S77   
12132	211	S77   
12142	211	S85   
12143	211	S85   
12144	211	S85   
12147	211	S564  
12151	211	S101  
12151	211	S86   
12152	211	S101  
12152	211	S86   
12154	211	S941  
12155	211	S79   
12201	211	S1164 
12201	211	S606  
12220	211	S1221 
12220	211	S2109 
12537	211	S604  
12538	211	S606  
12538	211	S661  
12538	211	S961  
12563	211	S141  
12565	211	S141  
12586	211	S343  
12586	211	S363  
12586	211	S502  
12632	211	S77   
12643	211	S85   
12644	211	S85   
12652	211	S101  
12652	211	S86   
14003	211	S2103 
14006	211	S2103 
14144	211	S1068 
14145	211	S1064 
14145	211	S1066 
14145	211	S1068 
14145	211	S1122 
14147	211	S1068 
14148	211	S1068 
14209	211	S23   
14242	211	S2104 
14450	211	S1164 
14460	211	S1164 
14461	211	S1164 
15027	211	S1163 
15260	211	S2109 
16006	211	S1164 
16010	211	S1164 
16010	211	S604  
16010	211	S606  
16011	211	S1164 
16011	211	S604  
16011	211	S606  
16029	211	S1164 
16037	211	S1164 
16038	211	S1164 
16042	211	S1065 
16043	211	S1065 
16089	211	S563  
16097	211	S22   
16098	211	S22   
16098	211	S404  
16098	211	S837  
16147	211	S2104 
16167	211	S2203 
16338	211	S1164 
16343	211	S1065 
16397	211	S22   
16398	211	S22   
16398	211	S404  
16398	211	S837  
18001	211	S1162 
18002	211	S1162 
18069	211	S20   
18079	211	S25   
18159	211	S21   
18166	211	S25   
18168	211	S25   
18215	211	S25   
18231	211	S25   
18258	211	S1162 
18259	211	S1162 
18288	211	S27   
18350	211	S21   
18363	211	S22   
18364	211	S22   
18365	211	S27   
18376	211	S25   
18403	211	S27   
18927	211	S25   
18930	211	S2203 
18931	211	S2203 
18932	211	S27   
18933	211	S27   
18934	211	S27   
18935	211	S27   
18936	211	S27   
19003	211	S26   
19034	211	S26   
19035	211	S26   
19047	211	S1162 
19056	211	S26   
19057	211	S2109 
19058	211	S2109 
19064	211	S1164 
19109	211	S1164 
19155	211	S1164 
19283	211	S1067 
19296	211	D3316 
19296	211	D3338 
19296	211	D3339 
19304	211	D3296 
19353	211	D3316 
19856	211	S1067 
19873	211	S1067 
20010	211	S604  
20037	211	S837  
20044	211	S1164 
20044	211	S20   
20046	211	S20   
20046	211	S606  
20047	211	S20   
20047	211	S606  
20048	211	S20   
20049	211	S20   
20089	211	S604  
20109	211	S2105 
20109	211	S606  
20110	211	S2105 
20110	211	S606  
20310	211	S2105 
20310	211	S606  
20409	211	S2105 
20409	211	S606  
20410	211	S2105 
20410	211	S606  
20446	211	S20   
20446	211	S606  
20447	211	S20   
20447	211	S606  
20510	211	S2105 
20510	211	S606  
20623	211	S1742 
20624	211	S1742 
20628	211	S1742 
20629	211	S1742 
20630	211	S1742 
20634	211	S1742 
20635	211	S1742 
20636	211	S1742 
20640	211	S1742 
20641	211	S1742 
20645	211	S1742 
20646	211	S1742 
21138	211	S1064 
21138	211	S1066 
21138	211	S1122 
21141	211	S1064 
21224	211	S19   
21225	211	S19   
21226	211	S22   
21227	211	S22   
21229	211	S1122 
21238	211	S2801 
21239	211	S1066 
21240	211	S1066 
21241	211	S1066 
21242	211	S1066 
21243	211	S1066 
21244	211	S1066 
21245	211	S1066 
21246	211	S1066 
21247	211	S1066 
21248	211	S1066 
21249	211	S1064 
21250	211	S1064 
21251	211	S1064 
21252	211	S1064 
21253	211	S1064 
21254	211	S1064 
21255	211	S1064 
21256	211	S1064 
21257	211	S1064 
21259	211	S1064 
21260	211	S1082 
21261	211	S1082 
21262	211	S1082 
21263	211	S1082 
21264	211	S1082 
21265	211	S1082 
21266	211	S1082 
21267	211	S1082 
21268	211	S1082 
21269	211	S1082 
21270	211	S1082 
21271	211	S2108 
21272	211	S2108 
21273	211	S2108 
21274	211	S2108 
21275	211	S2108 
21276	211	S2108 
21277	211	S2110 
21278	211	S2110 
21279	211	S2110 
21280	211	S2110 
21281	211	S2110 
21282	211	S2110 
21283	211	S2111 
21284	211	S2111 
21285	211	S2111 
21286	211	S2111 
21287	211	S2112 
21288	211	S2112 
21289	211	S2112 
21290	211	S2112 
21291	211	S2112 
21292	211	S2112 
21293	211	S2782 
21294	211	S2782 
21295	211	S2782 
21296	211	S2782 
21297	211	S2782 
21298	211	S2782 
21299	211	S2110 
21299	211	S2111 
21299	211	S2112 
21299	211	S2782 
21300	211	S2110 
21300	211	S2112 
21300	211	S2782 
21301	211	S2110 
21301	211	S2111 
21301	211	S2112 
21301	211	S2782 
21302	211	S2110 
21302	211	S2111 
21302	211	S2112 
21302	211	S2782 
21303	211	S2110 
21303	211	S2112 
21303	211	S2782 
21304	211	S2110 
21304	211	S2111 
21304	211	S2112 
21304	211	S2782 
21308	211	S2801 
21309	211	S2801 
21310	211	S2801 
21311	211	S2801 
21312	211	S2801 
21313	211	S2801 
21314	211	S2801 
21315	211	S2801 
21316	211	S2801 
21317	211	S2801 
21318	211	S2801 
21319	211	S2801 
21320	211	S2801 
21321	211	S2801 
21322	211	S2801 
21323	211	S2801 
21324	211	S2801 
21325	211	S2801 
21326	211	S2801 
21337	211	S2801 
21342	211	S2801 
21343	211	S2801 
22247	211	S20   
22903	211	S21   
22904	211	S18   
22909	211	S22   
22912	211	S19   
22914	211	S19   
22915	211	S19   
22916	211	S19   
35130	211	S2381 
35131	211	S2381 
35132	211	S2381 
35133	211	S2381 
35134	211	S2381 
35135	211	S2381 
35136	211	S2381 
35137	211	S2381 
35139	211	S2381 
35140	211	S2381 
35142	211	S2381 
35143	211	S2381 
35144	211	S2381 
35145	211	S2381 
35146	211	S2381 
35147	211	S2381 
35148	211	S2381 
43215	211	S26   
43364	211	S26   
43514	211	S1067 
01026	212	S25   
01032	212	S19   
01077	212	S27   
01079	212	S1063 
01079	212	S20   
01082	212	S1063 
01085	212	S1063 
01103	212	S1163 
01123	212	S1063 
01123	212	S561  
01124	212	S1065 
01125	212	S1065 
01202	212	S1163 
02003	212	S1069 
02009	212	S1069 
02010	212	S1069 
02011	212	S1069 
02015	212	S1069 
02021	212	S1069 
02024	212	S1069 
02027	212	S1069 
02028	212	S1069 
02029	212	S1069 
02043	212	S1069 
02048	212	S2922 
04017	212	S19   
04021	212	S19   
04023	212	S19   
04114	212	S19   
04120	212	S19   
04141	212	S19   
04142	212	S19   
04143	212	S19   
04144	212	S19   
04367	212	S19   
04635	212	S19   
04636	212	S19   
04638	212	S26   
04639	212	S26   
04640	212	S26   
04641	212	S25   
05312	212	S26   
05313	212	S26   
05320	212	S26   
06016	212	S18   
06019	212	S18   
06128	212	S18   
06159	212	S18   
06931	212	S22   
06982	212	S18   
06983	212	S18   
06984	212	S2104 
06985	212	S2104 
07022	212	S21   
07945	212	S21   
07951	212	S243  
08001	212	S1065 
08012	212	S1065 
08014	212	S1065 
08020	212	S1065 
08025	212	S2662 
08030	212	S1065 
08061	212	S1065 
08065	212	S2662 
08074	212	S2662 
08077	212	S1065 
08147	212	S1065 
08218	212	S1065 
08259	212	S2662 
08435	212	S1065 
08504	212	S2662 
08505	212	S2662 
08506	212	S2662 
08507	212	S2662 
08508	212	S2662 
08509	212	S2662 
09003	212	S502  
09003	212	S561  
09004	212	S502  
09021	212	D3321 
09021	212	D3344 
09021	212	S604  
09032	212	S21   
09037	212	S481  
09037	212	S502  
09037	212	S837  
09038	212	S481  
09038	212	S502  
09038	212	S837  
09039	212	S837  
09040	212	S481  
09040	212	S562  
09042	212	S461  
09042	212	S566  
09050	212	S421  
09050	212	S441  
09070	212	D3321 
09070	212	D3336 
09070	212	D3344 
09070	212	S582  
09078	212	S561  
09084	212	D3321 
09087	212	S564  
09087	212	S582  
09094	212	S363  
09094	212	S582  
09112	212	S482  
09112	212	S563  
09132	212	S1062 
09148	212	S363  
09148	212	S582  
09160	212	S1065 
09181	212	S1121 
09181	212	S461  
09181	212	S604  
09181	212	S606  
09184	212	S562  
09184	212	S565  
09191	212	D3344 
09191	212	S421  
09191	212	S582  
09202	212	S482  
09202	212	S564  
09202	212	S837  
09215	212	S404  
09215	212	S837  
09218	212	S1065 
09218	212	S606  
09236	212	S461  
09236	212	S582  
09252	212	S482  
09252	212	S541  
09263	212	D4941 
09263	212	S606  
09266	212	S441  
09266	212	S561  
09268	212	D3315 
09270	212	D3315 
09273	212	S2104 
09279	212	S421  
09279	212	S582  
09291	212	D3315 
09291	212	D3318 
09291	212	S564  
09291	212	S566  
09291	212	S606  
09291	212	S837  
09298	212	D3315 
09298	212	S564  
09298	212	S566  
09298	212	S837  
09302	212	S461  
09302	212	S566  
09316	212	S421  
09316	212	S566  
09316	212	S604  
09316	212	S606  
09318	212	S604  
09318	212	S606  
09326	212	S441  
09326	212	S461  
09326	212	S837  
09409	212	S2104 
09421	212	S564  
09421	212	S582  
09427	212	D4053 
09428	212	D4053 
09429	212	S441  
09430	212	S441  
09430	212	S561  
09431	212	S2203 
09432	212	S2203 
09433	212	S2105 
11011	212	D3321 
11011	212	D3326 
11011	212	S1069 
11012	212	S1069 
11090	212	D3321 
11090	212	S1121 
11090	212	S564  
11090	212	S604  
11090	212	S606  
11090	212	S837  
11091	212	S1121 
11091	212	S564  
11091	212	S837  
11096	212	S1121 
11096	212	S482  
11097	212	S482  
11112	212	D3321 
11112	212	D3326 
11112	212	S1065 
11113	212	S1065 
11124	212	S1062 
11124	212	S604  
11124	212	S606  
11124	212	S837  
11125	212	S1062 
11130	212	S25   
11131	212	S25   
11143	212	D3284 
11143	212	D3321 
11143	212	S1121 
11143	212	S564  
11143	212	S604  
11205	212	S1062 
11205	212	S604  
11206	212	S1062 
11243	212	S2941 
11250	212	S562  
11251	212	S503  
11252	212	S562  
11252	212	S604  
11252	212	S837  
11253	212	S541  
11257	212	S541  
11260	212	S2941 
11260	212	S604  
11260	212	S606  
11260	212	S80   
11263	212	S2941 
11267	212	S2941 
11282	212	D3306 
11282	212	D3309 
11282	212	D3321 
11282	212	S1062 
11282	212	S837  
11286	212	S1062 
11294	212	S563  
11294	212	S582  
11333	212	D3326 
11333	212	S1062 
11333	212	S604  
11333	212	S837  
11339	212	S1062 
11352	212	S563  
11352	212	S566  
11353	212	S563  
11353	212	S566  
11354	212	S563  
11354	212	S566  
11355	212	S563  
11355	212	S566  
11356	212	S563  
11356	212	S566  
11357	212	S563  
11357	212	S566  
11358	212	S563  
11358	212	S566  
11359	212	S2105 
11360	212	S2105 
11394	212	S2105 
11395	212	S2105 
11398	212	S2105 
11399	212	S2105 
11402	212	S2105 
11403	212	S2105 
11411	212	S2105 
11412	212	S2105 
11429	212	D3309 
11429	212	D3321 
11429	212	S1121 
11429	212	S363  
11429	212	S604  
11463	212	S25   
11464	212	S25   
11507	212	S1062 
11507	212	S606  
11508	212	D3335 
11508	212	S1062 
11508	212	S606  
11510	212	S1062 
11529	212	D3306 
11529	212	D3309 
11529	212	D3326 
11529	212	S441  
11529	212	S503  
11529	212	S604  
11529	212	S837  
11530	212	S441  
11546	212	S21   
11547	212	S21   
11549	212	S21   
11674	212	S563  
11674	212	S566  
11705	212	S1069 
11742	212	S1121 
11742	212	S564  
11742	212	S837  
11752	212	S1065 
11757	212	S1062 
11760	212	S25   
11821	212	S1062 
11828	212	S563  
11828	212	S566  
11841	212	S2105 
11842	212	S2105 
11856	212	S25   
11875	212	D3335 
11875	212	S1062 
11875	212	S606  
11876	212	S1062 
11884	212	S441  
11887	212	S21   
11888	212	S21   
11921	212	S1062 
11935	212	S22   
11949	212	S22   
11950	212	S2941 
11960	212	S562  
11987	212	S2941 
11992	212	S2941 
12038	212	S661  
12038	212	S961  
12061	212	S141  
12062	212	S141  
12063	212	S141  
12065	212	S141  
12078	212	S1063 
12078	212	S503  
12086	212	S343  
12086	212	S363  
12086	212	S502  
12087	212	S343  
12120	212	S83   
12121	212	S83   
12122	212	S83   
12131	212	S77   
12132	212	S77   
12142	212	S85   
12143	212	S85   
12144	212	S85   
12147	212	S564  
12151	212	S101  
12151	212	S86   
12152	212	S101  
12152	212	S86   
12154	212	S941  
12155	212	S79   
12201	212	S1164 
12220	212	S1221 
12220	212	S2109 
12538	212	S661  
12538	212	S961  
12563	212	S141  
12565	212	S141  
12586	212	S343  
12586	212	S363  
12586	212	S502  
12632	212	S77   
12643	212	S85   
12644	212	S85   
12652	212	S101  
12652	212	S86   
14003	212	S2103 
14006	212	S2103 
14144	212	S1068 
14145	212	S1064 
14145	212	S1066 
14145	212	S1068 
14145	212	S1122 
14147	212	S1068 
14148	212	S1068 
14209	212	S23   
14242	212	S2104 
14450	212	S1164 
14460	212	S1164 
14461	212	S1164 
15027	212	S1163 
15087	212	S2109 
15260	212	S2109 
16006	212	S1164 
16010	212	S1164 
16010	212	S604  
16010	212	S606  
16011	212	S1164 
16011	212	S604  
16011	212	S606  
16029	212	S1164 
16037	212	S1164 
16038	212	S1164 
16042	212	S1065 
16043	212	S1065 
16089	212	S563  
16097	212	S22   
16098	212	S22   
16098	212	S837  
16147	212	S2104 
16167	212	S2203 
16338	212	S1164 
16343	212	S1065 
16397	212	S22   
16398	212	S22   
16398	212	S837  
18001	212	S1162 
18002	212	S1162 
18069	212	S20   
18079	212	S25   
18159	212	S21   
18166	212	S25   
18168	212	S25   
18215	212	S25   
18231	212	S25   
18258	212	S1162 
18259	212	S1162 
18288	212	S27   
18350	212	S21   
18363	212	S22   
18364	212	S22   
18365	212	S27   
18376	212	S25   
18403	212	S27   
18927	212	S25   
18930	212	S2203 
18931	212	S2203 
18932	212	S27   
18933	212	S27   
18934	212	S27   
18935	212	S27   
18936	212	S27   
19003	212	S26   
19034	212	S26   
19035	212	S26   
19047	212	S1162 
19056	212	S26   
19057	212	S2109 
19058	212	S2109 
19064	212	S1164 
19109	212	S1164 
19155	212	S1164 
19283	212	S1067 
19296	212	D3316 
19296	212	D3338 
19296	212	D3339 
19304	212	D3296 
19353	212	D3316 
19856	212	S1067 
19873	212	S1067 
20010	212	S604  
20037	212	S837  
20044	212	S1164 
20044	212	S20   
20046	212	S20   
20046	212	S606  
20047	212	S20   
20048	212	S20   
20049	212	S20   
20089	212	S604  
20109	212	S2105 
20110	212	S2105 
20310	212	S2105 
20409	212	S2105 
20410	212	S2105 
20446	212	S20   
20446	212	S606  
20447	212	S20   
20510	212	S2105 
20623	212	S1742 
20624	212	S1742 
20628	212	S1742 
20629	212	S1742 
20630	212	S1742 
20634	212	S1742 
20635	212	S1742 
20636	212	S1742 
20640	212	S1742 
20641	212	S1742 
20645	212	S1742 
20646	212	S1742 
21138	212	S1064 
21138	212	S1066 
21138	212	S1122 
21141	212	S1064 
21224	212	S19   
21225	212	S19   
21226	212	S22   
21227	212	S22   
21229	212	S1122 
21238	212	S2801 
21239	212	S1066 
21240	212	S1066 
21241	212	S1066 
21242	212	S1066 
21243	212	S1066 
21244	212	S1066 
21245	212	S1066 
21246	212	S1066 
21247	212	S1066 
21248	212	S1066 
21249	212	S1064 
21250	212	S1064 
21251	212	S1064 
21252	212	S1064 
21253	212	S1064 
21254	212	S1064 
21255	212	S1064 
21256	212	S1064 
21257	212	S1064 
21259	212	S1064 
21260	212	S1082 
21261	212	S1082 
21262	212	S1082 
21263	212	S1082 
21264	212	S1082 
21265	212	S1082 
21266	212	S1082 
21267	212	S1082 
21268	212	S1082 
21269	212	S1082 
21270	212	S1082 
21271	212	S2108 
21272	212	S2108 
21273	212	S2108 
21274	212	S2108 
21275	212	S2108 
21276	212	S2108 
21277	212	S2110 
21278	212	S2110 
21279	212	S2110 
21280	212	S2110 
21281	212	S2110 
21282	212	S2110 
21283	212	S2111 
21284	212	S2111 
21285	212	S2111 
21286	212	S2111 
21287	212	S2112 
21288	212	S2112 
21289	212	S2112 
21290	212	S2112 
21291	212	S2112 
21292	212	S2112 
21293	212	S2782 
21294	212	S2782 
21295	212	S2782 
21296	212	S2782 
21297	212	S2782 
21298	212	S2782 
21299	212	S2110 
21299	212	S2111 
21299	212	S2112 
21299	212	S2782 
21300	212	S2110 
21300	212	S2112 
21300	212	S2782 
21301	212	S2110 
21301	212	S2111 
21301	212	S2112 
21301	212	S2782 
21302	212	S2110 
21302	212	S2111 
21302	212	S2112 
21302	212	S2782 
21303	212	S2110 
21303	212	S2112 
21303	212	S2782 
21304	212	S2110 
21304	212	S2111 
21304	212	S2112 
21304	212	S2782 
21308	212	S2801 
21309	212	S2801 
21310	212	S2801 
21311	212	S2801 
21312	212	S2801 
21313	212	S2801 
21314	212	S2801 
21315	212	S2801 
21316	212	S2801 
21317	212	S2801 
21318	212	S2801 
21319	212	S2801 
21320	212	S2801 
21321	212	S2801 
21322	212	S2801 
21323	212	S2801 
21324	212	S2801 
21325	212	S2801 
21326	212	S2801 
21337	212	S2801 
21342	212	S2801 
21343	212	S2801 
22247	212	S20   
22903	212	S21   
22904	212	S18   
22909	212	S22   
22911	212	S18   
22912	212	S19   
22914	212	S19   
22915	212	S19   
22916	212	S19   
35130	212	S2381 
35131	212	S2381 
35132	212	S2381 
35133	212	S2381 
35134	212	S2381 
35135	212	S2381 
35136	212	S2381 
35137	212	S2381 
35139	212	S2381 
35140	212	S2381 
35142	212	S2381 
35143	212	S2381 
35144	212	S2381 
35145	212	S2381 
35146	212	S2381 
35147	212	S2381 
35148	212	S2381 
43215	212	S26   
43364	212	S26   
43514	212	S1067 
01026	213	S25   
01026	213	S606  
01032	213	S19   
01046	213	S19   
01046	213	S606  
01077	213	S27   
01079	213	S1063 
01079	213	S20   
01082	213	S1063 
01085	213	S1063 
01103	213	S1163 
01123	213	S1063 
01123	213	S561  
01124	213	S1065 
01125	213	S1065 
01202	213	S1163 
02003	213	S1069 
02009	213	S1069 
02010	213	S1069 
02011	213	S1069 
02015	213	S1069 
02021	213	S1069 
02024	213	S1069 
02027	213	S1069 
02028	213	S1069 
02029	213	S1069 
02043	213	S1069 
02048	213	S2922 
04017	213	S19   
04021	213	S19   
04023	213	S19   
04114	213	S19   
04120	213	S19   
04141	213	S19   
04143	213	S19   
04144	213	S19   
04635	213	S19   
04636	213	S19   
04638	213	S26   
04639	213	S26   
04640	213	S26   
04641	213	S25   
05312	213	S26   
05313	213	S26   
05320	213	S26   
06016	213	S18   
06019	213	S18   
06128	213	S18   
06159	213	S18   
06931	213	S22   
06982	213	S18   
06983	213	S18   
06984	213	S2104 
06985	213	S2104 
07022	213	S21   
07945	213	S21   
07951	213	S243  
08001	213	S1065 
08012	213	S1065 
08014	213	S1065 
08020	213	S1065 
08025	213	S2662 
08030	213	S1065 
08061	213	S1065 
08065	213	S2662 
08074	213	S2662 
08077	213	S1065 
08147	213	S1065 
08218	213	S1065 
08259	213	S2662 
08435	213	S1065 
08504	213	S2662 
08505	213	S2662 
08506	213	S2662 
08507	213	S2662 
08508	213	S2662 
08509	213	S2662 
09003	213	S502  
09003	213	S561  
09004	213	S502  
09032	213	S21   
09037	213	S481  
09037	213	S502  
09037	213	S837  
09038	213	S481  
09038	213	S502  
09038	213	S837  
09039	213	S837  
09040	213	S481  
09040	213	S562  
09042	213	S461  
09042	213	S566  
09050	213	S421  
09050	213	S441  
09070	213	S582  
09078	213	S561  
09087	213	S564  
09087	213	S582  
09094	213	S363  
09094	213	S582  
09112	213	S482  
09112	213	S563  
09132	213	S1062 
09148	213	S363  
09148	213	S582  
09160	213	S1065 
09181	213	S1121 
09181	213	S461  
09184	213	S562  
09184	213	S565  
09191	213	S421  
09191	213	S582  
09202	213	S482  
09202	213	S564  
09202	213	S837  
09215	213	S837  
09218	213	S1065 
09236	213	S461  
09236	213	S582  
09252	213	S482  
09252	213	S541  
09266	213	S441  
09266	213	S561  
09273	213	S2104 
09279	213	S421  
09279	213	S582  
09291	213	S564  
09291	213	S566  
09291	213	S837  
09298	213	S564  
09298	213	S566  
09302	213	S461  
09302	213	S566  
09316	213	S421  
09316	213	S566  
09326	213	S441  
09326	213	S461  
09326	213	S837  
09409	213	S2104 
09421	213	S564  
09421	213	S582  
09427	213	D4053 
09428	213	D4053 
09429	213	S441  
09430	213	S441  
09430	213	S561  
09431	213	S2203 
09432	213	S2203 
09433	213	S2105 
11011	213	S1069 
11012	213	S1069 
11090	213	S1121 
11090	213	S564  
11090	213	S837  
11091	213	S1121 
11091	213	S564  
11091	213	S837  
11096	213	S1121 
11096	213	S482  
11097	213	S482  
11112	213	S1065 
11113	213	S1065 
11124	213	S1062 
11124	213	S837  
11125	213	S1062 
11130	213	S25   
11131	213	S25   
11143	213	S1121 
11143	213	S564  
11205	213	S1062 
11206	213	S1062 
11243	213	S2941 
11250	213	S562  
11251	213	S503  
11252	213	S562  
11252	213	S837  
11253	213	S541  
11257	213	S541  
11260	213	S2941 
11263	213	S2941 
11267	213	S2941 
11282	213	S1062 
11282	213	S837  
11286	213	S1062 
11294	213	S563  
11294	213	S582  
11333	213	S1062 
11333	213	S837  
11339	213	S1062 
11352	213	S563  
11352	213	S566  
11353	213	S563  
11353	213	S566  
11354	213	S563  
11354	213	S566  
11355	213	S563  
11355	213	S566  
11356	213	S563  
11356	213	S566  
11357	213	S563  
11357	213	S566  
11358	213	S563  
11358	213	S566  
11359	213	S2105 
11360	213	S2105 
11394	213	S2105 
11395	213	S2105 
11398	213	S2105 
11399	213	S2105 
11402	213	S2105 
11403	213	S2105 
11411	213	S2105 
11412	213	S2105 
11429	213	S1121 
11429	213	S363  
11463	213	S25   
11464	213	S25   
11507	213	S1062 
11508	213	S1062 
11510	213	S1062 
11529	213	S441  
11529	213	S503  
11529	213	S837  
11530	213	S441  
11674	213	S563  
11674	213	S566  
11705	213	S1069 
11742	213	S1121 
11742	213	S564  
11742	213	S837  
11752	213	S1065 
11757	213	S1062 
11760	213	S25   
11821	213	S1062 
11828	213	S563  
11828	213	S566  
11841	213	S2105 
11842	213	S2105 
11856	213	S25   
11875	213	S1062 
11876	213	S1062 
11884	213	S441  
11921	213	S1062 
11935	213	S22   
11949	213	S22   
11950	213	S2941 
11960	213	S562  
11987	213	S2941 
11992	213	S2941 
12038	213	S661  
12038	213	S961  
12061	213	S141  
12062	213	S141  
12063	213	S141  
12065	213	S141  
12078	213	S1063 
12078	213	S503  
12086	213	S343  
12086	213	S363  
12086	213	S502  
12087	213	S343  
12120	213	S83   
12121	213	S83   
12122	213	S83   
12131	213	S77   
12132	213	S77   
12142	213	S85   
12143	213	S85   
12144	213	S85   
12147	213	S564  
12151	213	S101  
12151	213	S86   
12152	213	S101  
12152	213	S86   
12154	213	S941  
12155	213	S79   
12201	213	S1164 
12220	213	S1221 
12220	213	S2109 
12538	213	S661  
12538	213	S961  
12563	213	S141  
12565	213	S141  
12586	213	S343  
12586	213	S363  
12586	213	S502  
12632	213	S77   
12643	213	S85   
12644	213	S85   
12652	213	S101  
12652	213	S86   
14003	213	S2103 
14006	213	S2103 
14209	213	S23   
14242	213	S2104 
14450	213	S1164 
14460	213	S1164 
14461	213	S1164 
15027	213	S1163 
15087	213	S2109 
15260	213	S2109 
16006	213	S1164 
16010	213	S1164 
16011	213	S1164 
16029	213	S1164 
16037	213	S1164 
16038	213	S1164 
16042	213	S1065 
16043	213	S1065 
16089	213	S563  
16097	213	S22   
16098	213	S22   
16098	213	S837  
16147	213	S2104 
16167	213	S2203 
16338	213	S1164 
16343	213	S1065 
16397	213	S22   
16398	213	S22   
16398	213	S837  
18001	213	S1162 
18002	213	S1162 
18069	213	S20   
18079	213	S25   
18159	213	S21   
18166	213	S25   
18168	213	S25   
18215	213	S25   
18231	213	S25   
18258	213	S1162 
18259	213	S1162 
18288	213	S27   
18350	213	S21   
18363	213	S22   
18364	213	S22   
18365	213	S27   
18376	213	S25   
18403	213	S27   
18927	213	S25   
18930	213	S2203 
18931	213	S2203 
18932	213	S27   
18933	213	S27   
18934	213	S27   
18935	213	S27   
18936	213	S27   
19003	213	S26   
19034	213	S26   
19035	213	S26   
19047	213	S1162 
19056	213	S26   
19057	213	S2109 
19058	213	S2109 
19064	213	S1164 
19109	213	S1164 
19155	213	S1164 
19283	213	S1067 
19856	213	S1067 
19873	213	S1067 
20037	213	S837  
20044	213	S1164 
20044	213	S20   
20046	213	S20   
20047	213	S20   
20048	213	S20   
20049	213	S20   
20109	213	S2105 
20110	213	S2105 
20310	213	S2105 
20409	213	S2105 
20410	213	S2105 
20446	213	S20   
20447	213	S20   
20510	213	S2105 
20623	213	S1742 
20624	213	S1742 
20628	213	S1742 
20629	213	S1742 
20630	213	S1742 
20634	213	S1742 
20635	213	S1742 
20636	213	S1742 
20640	213	S1742 
20641	213	S1742 
20645	213	S1742 
20646	213	S1742 
21141	213	S1064 
21224	213	S19   
21229	213	S1122 
21238	213	S2801 
21239	213	S1066 
21240	213	S1066 
21241	213	S1066 
21242	213	S1066 
21243	213	S1066 
21244	213	S1066 
21245	213	S1066 
21246	213	S1066 
21247	213	S1066 
21248	213	S1066 
21249	213	S1064 
21250	213	S1064 
21251	213	S1064 
21252	213	S1064 
21253	213	S1064 
21254	213	S1064 
21255	213	S1064 
21256	213	S1064 
21257	213	S1064 
21259	213	S1064 
21260	213	S1082 
21261	213	S1082 
21262	213	S1082 
21263	213	S1082 
21264	213	S1082 
21265	213	S1082 
21266	213	S1082 
21267	213	S1082 
21268	213	S1082 
21269	213	S1082 
21270	213	S1082 
21271	213	S2108 
21272	213	S2108 
21273	213	S2108 
21274	213	S2108 
21275	213	S2108 
21276	213	S2108 
21277	213	S2110 
21278	213	S2110 
21279	213	S2110 
21280	213	S2110 
21281	213	S2110 
21282	213	S2110 
21283	213	S2111 
21284	213	S2111 
21285	213	S2111 
21286	213	S2111 
21287	213	S2112 
21288	213	S2112 
21289	213	S2112 
21290	213	S2112 
21291	213	S2112 
21292	213	S2112 
21293	213	S2782 
21294	213	S2782 
21295	213	S2782 
21296	213	S2782 
21297	213	S2782 
21298	213	S2782 
21299	213	S2110 
21299	213	S2111 
21299	213	S2112 
21299	213	S2782 
21300	213	S2110 
21300	213	S2112 
21300	213	S2782 
21301	213	S2110 
21301	213	S2111 
21301	213	S2112 
21301	213	S2782 
21302	213	S2110 
21302	213	S2111 
21302	213	S2112 
21302	213	S2782 
21303	213	S2110 
21303	213	S2112 
21303	213	S2782 
21304	213	S2110 
21304	213	S2111 
21304	213	S2112 
21304	213	S2782 
21308	213	S2801 
21309	213	S2801 
21310	213	S2801 
21311	213	S2801 
21312	213	S2801 
21313	213	S2801 
21314	213	S2801 
21315	213	S2801 
21316	213	S2801 
21317	213	S2801 
21318	213	S2801 
21319	213	S2801 
21320	213	S2801 
21321	213	S2801 
21322	213	S2801 
21323	213	S2801 
21324	213	S2801 
21325	213	S2801 
21326	213	S2801 
21337	213	S2801 
21342	213	S2801 
21343	213	S2801 
22247	213	S20   
22903	213	S21   
22909	213	S22   
22914	213	S19   
35130	213	S2381 
35131	213	S2381 
35132	213	S2381 
35133	213	S2381 
35134	213	S2381 
35135	213	S2381 
35136	213	S2381 
35137	213	S2381 
35138	213	S2381 
35139	213	S2381 
35140	213	S2381 
35142	213	S2381 
35143	213	S2381 
35144	213	S2381 
35145	213	S2381 
35146	213	S2381 
35147	213	S2381 
35148	213	S2381 
43215	213	S26   
43364	213	S26   
43514	213	S1067 
01026	214	S25   
01026	214	S606  
01032	214	S19   
01077	214	S27   
01079	214	S1063 
01079	214	S20   
01082	214	S1063 
01085	214	S1063 
01103	214	S1163 
01123	214	S1063 
01123	214	S561  
01124	214	S1065 
01125	214	S1065 
01202	214	S1163 
02003	214	S1069 
02009	214	S1069 
02010	214	S1069 
02011	214	S1069 
02015	214	S1069 
02021	214	S1069 
02024	214	S1069 
02027	214	S1069 
02028	214	S1069 
02029	214	S1069 
02043	214	S1069 
02048	214	S2922 
04017	214	S19   
04021	214	S19   
04023	214	S19   
04114	214	S19   
04120	214	S19   
04141	214	S19   
04142	214	S19   
04143	214	S19   
04144	214	S19   
04367	214	S19   
04635	214	S19   
04636	214	S19   
04638	214	S26   
04639	214	S26   
04640	214	S26   
04641	214	S25   
05312	214	S26   
05313	214	S26   
05320	214	S26   
06016	214	S18   
06019	214	S18   
06128	214	S18   
06159	214	S18   
06931	214	S22   
06982	214	S18   
06983	214	S18   
06984	214	S2104 
06985	214	S2104 
07022	214	S21   
07945	214	S21   
07951	214	S243  
08001	214	S1065 
08012	214	S1065 
08014	214	S1065 
08020	214	S1065 
08025	214	S2662 
08030	214	S1065 
08061	214	S1065 
08065	214	S2662 
08074	214	S2662 
08077	214	S1065 
08147	214	S1065 
08218	214	S1065 
08259	214	S2662 
08435	214	S1065 
08504	214	S2662 
08505	214	S2662 
08506	214	S2662 
08507	214	S2662 
08508	214	S2662 
08509	214	S2662 
09003	214	S502  
09003	214	S561  
09004	214	S502  
09021	214	D3321 
09032	214	S21   
09037	214	S481  
09037	214	S502  
09037	214	S837  
09038	214	S481  
09038	214	S502  
09038	214	S837  
09039	214	S837  
09040	214	S481  
09040	214	S562  
09042	214	S461  
09042	214	S566  
09050	214	S421  
09050	214	S441  
09070	214	D3321 
09070	214	S582  
09078	214	S561  
09087	214	S564  
09087	214	S582  
09094	214	S363  
09094	214	S582  
09112	214	S482  
09112	214	S563  
09132	214	S1062 
09148	214	S363  
09148	214	S582  
09160	214	S1065 
09181	214	S1121 
09181	214	S461  
09181	214	S604  
09184	214	S562  
09184	214	S565  
09191	214	S421  
09191	214	S582  
09202	214	S482  
09202	214	S564  
09202	214	S837  
09215	214	S837  
09218	214	S1065 
09236	214	S461  
09236	214	S582  
09252	214	S482  
09252	214	S541  
09266	214	S441  
09266	214	S561  
09273	214	S2104 
09279	214	S421  
09279	214	S582  
09291	214	S564  
09291	214	S566  
09291	214	S837  
09298	214	S564  
09298	214	S566  
09302	214	S461  
09302	214	S566  
09316	214	S421  
09316	214	S566  
09326	214	S441  
09326	214	S461  
09326	214	S837  
09409	214	S2104 
09421	214	S564  
09421	214	S582  
09427	214	D4053 
09428	214	D4053 
09429	214	S441  
09430	214	S441  
09430	214	S561  
09431	214	S2203 
09432	214	S2203 
09433	214	S2105 
11011	214	S1069 
11012	214	S1069 
11090	214	S1121 
11090	214	S564  
11090	214	S837  
11091	214	S1121 
11091	214	S564  
11091	214	S837  
11096	214	S1121 
11096	214	S482  
11097	214	S482  
11112	214	S1065 
11113	214	S1065 
11124	214	S1062 
11124	214	S837  
11125	214	S1062 
11130	214	S25   
11131	214	S25   
11143	214	S1121 
11143	214	S564  
11205	214	S1062 
11205	214	S604  
11206	214	S1062 
11243	214	S2941 
11250	214	S562  
11251	214	S503  
11252	214	S562  
11252	214	S837  
11253	214	S541  
11257	214	S541  
11260	214	S2941 
11263	214	S2941 
11267	214	S2941 
11282	214	S1062 
11282	214	S837  
11286	214	S1062 
11294	214	S563  
11294	214	S582  
11333	214	S1062 
11333	214	S837  
11339	214	S1062 
11352	214	S563  
11352	214	S566  
11353	214	S563  
11353	214	S566  
11354	214	S563  
11354	214	S566  
11355	214	S563  
11355	214	S566  
11356	214	S563  
11356	214	S566  
11357	214	S563  
11357	214	S566  
11358	214	S563  
11358	214	S566  
11359	214	S2105 
11360	214	S2105 
11394	214	S2105 
11395	214	S2105 
11398	214	S2105 
11399	214	S2105 
11402	214	S2105 
11403	214	S2105 
11411	214	S2105 
11412	214	S2105 
11429	214	S1121 
11429	214	S363  
11463	214	S25   
11464	214	S25   
11507	214	S1062 
11508	214	D3335 
11508	214	S1062 
11508	214	S606  
11510	214	S1062 
11529	214	S441  
11529	214	S503  
11529	214	S837  
11530	214	S441  
11546	214	S21   
11674	214	S563  
11674	214	S566  
11705	214	S1069 
11742	214	S1121 
11742	214	S564  
11742	214	S837  
11752	214	S1065 
11757	214	S1062 
11760	214	S25   
11821	214	S1062 
11828	214	S563  
11828	214	S566  
11841	214	S2105 
11842	214	S2105 
11856	214	S25   
11875	214	D3335 
11875	214	S1062 
11875	214	S606  
11876	214	S1062 
11884	214	S441  
11887	214	S21   
11921	214	S1062 
11935	214	S22   
11949	214	S22   
11950	214	S2941 
11960	214	S562  
11987	214	S2941 
11992	214	S2941 
12038	214	S661  
12038	214	S961  
12061	214	S141  
12062	214	S141  
12063	214	S141  
12065	214	S141  
12078	214	S1063 
12078	214	S503  
12086	214	S343  
12086	214	S363  
12086	214	S502  
12087	214	S343  
12120	214	S83   
12121	214	S83   
12122	214	S83   
12131	214	S77   
12132	214	S77   
12142	214	S85   
12143	214	S85   
12144	214	S85   
12147	214	S564  
12151	214	S101  
12151	214	S86   
12152	214	S101  
12152	214	S86   
12154	214	S941  
12155	214	S79   
12201	214	S1164 
12220	214	S1221 
12220	214	S2109 
12538	214	S661  
12538	214	S961  
12563	214	S141  
12565	214	S141  
12586	214	S343  
12586	214	S363  
12586	214	S502  
12632	214	S77   
12643	214	S85   
12644	214	S85   
12652	214	S101  
12652	214	S86   
14003	214	S2103 
14006	214	S2103 
14209	214	S23   
14242	214	S2104 
14450	214	S1164 
14460	214	S1164 
14461	214	S1164 
15027	214	S1163 
15087	214	S2109 
15260	214	S2109 
16006	214	S1164 
16010	214	S1164 
16010	214	S606  
16011	214	S1164 
16011	214	S604  
16029	214	S1164 
16037	214	S1164 
16038	214	S1164 
16042	214	S1065 
16043	214	S1065 
16089	214	S563  
16097	214	S22   
16098	214	S22   
16098	214	S837  
16147	214	S2104 
16167	214	S2203 
16338	214	S1164 
16343	214	S1065 
16397	214	S22   
16398	214	S22   
16398	214	S837  
18001	214	S1162 
18002	214	S1162 
18069	214	S20   
18079	214	S25   
18159	214	S21   
18166	214	S25   
18168	214	S25   
18215	214	S25   
18231	214	S25   
18258	214	S1162 
18259	214	S1162 
18288	214	S27   
18350	214	S21   
18363	214	S22   
18364	214	S22   
18365	214	S27   
18376	214	S25   
18403	214	S27   
18927	214	S25   
18930	214	S2203 
18931	214	S2203 
18932	214	S27   
18933	214	S27   
18934	214	S27   
18935	214	S27   
18936	214	S27   
19003	214	S26   
19034	214	S26   
19035	214	S26   
19047	214	S1162 
19056	214	S26   
19058	214	S2109 
19064	214	S1164 
19109	214	S1164 
19155	214	S1164 
19283	214	S1067 
19296	214	D3338 
19296	214	D3339 
19856	214	S1067 
19873	214	S1067 
20037	214	S837  
20044	214	S1164 
20044	214	S20   
20046	214	S20   
20047	214	S20   
20048	214	S20   
20049	214	S20   
20108	214	S604  
20109	214	S2105 
20109	214	S606  
20110	214	S2105 
20110	214	S606  
20310	214	S2105 
20310	214	S606  
20409	214	S2105 
20409	214	S606  
20410	214	S2105 
20410	214	S606  
20446	214	S20   
20447	214	S20   
20510	214	S2105 
20510	214	S606  
20623	214	S1742 
20624	214	S1742 
20628	214	S1742 
20629	214	S1742 
20630	214	S1742 
20634	214	S1742 
20635	214	S1742 
20636	214	S1742 
20640	214	S1742 
20641	214	S1742 
20645	214	S1742 
20646	214	S1742 
21141	214	S1064 
21224	214	S19   
21225	214	S19   
21226	214	S22   
21227	214	S22   
21229	214	S1122 
21238	214	S2801 
21239	214	S1066 
21240	214	S1066 
21241	214	S1066 
21242	214	S1066 
21243	214	S1066 
21244	214	S1066 
21245	214	S1066 
21246	214	S1066 
21247	214	S1066 
21248	214	S1066 
21249	214	S1064 
21250	214	S1064 
21251	214	S1064 
21252	214	S1064 
21253	214	S1064 
21254	214	S1064 
21255	214	S1064 
21256	214	S1064 
21257	214	S1064 
21259	214	S1064 
21260	214	S1082 
21261	214	S1082 
21262	214	S1082 
21263	214	S1082 
21264	214	S1082 
21265	214	S1082 
21266	214	S1082 
21267	214	S1082 
21268	214	S1082 
21269	214	S1082 
21270	214	S1082 
21271	214	S2108 
21272	214	S2108 
21273	214	S2108 
21274	214	S2108 
21275	214	S2108 
21276	214	S2108 
21277	214	S2110 
21278	214	S2110 
21279	214	S2110 
21280	214	S2110 
21281	214	S2110 
21282	214	S2110 
21283	214	S2111 
21284	214	S2111 
21285	214	S2111 
21286	214	S2111 
21287	214	S2112 
21288	214	S2112 
21289	214	S2112 
21290	214	S2112 
21291	214	S2112 
21292	214	S2112 
21293	214	S2782 
21294	214	S2782 
21295	214	S2782 
21296	214	S2782 
21297	214	S2782 
21298	214	S2782 
21299	214	S2110 
21299	214	S2111 
21299	214	S2112 
21299	214	S2782 
21300	214	S2110 
21300	214	S2112 
21300	214	S2782 
21301	214	S2110 
21301	214	S2111 
21301	214	S2112 
21301	214	S2782 
21302	214	S2110 
21302	214	S2111 
21302	214	S2112 
21302	214	S2782 
21303	214	S2110 
21303	214	S2112 
21303	214	S2782 
21304	214	S2110 
21304	214	S2111 
21304	214	S2112 
21304	214	S2782 
21308	214	S2801 
21309	214	S2801 
21310	214	S2801 
21311	214	S2801 
21312	214	S2801 
21313	214	S2801 
21314	214	S2801 
21315	214	S2801 
21316	214	S2801 
21317	214	S2801 
21318	214	S2801 
21319	214	S2801 
21320	214	S2801 
21321	214	S2801 
21322	214	S2801 
21323	214	S2801 
21324	214	S2801 
21325	214	S2801 
21326	214	S2801 
21337	214	S2801 
21342	214	S2801 
21343	214	S2801 
22247	214	S20   
22903	214	S21   
22909	214	S22   
22912	214	S19   
22914	214	S19   
35130	214	S2381 
35131	214	S2381 
35132	214	S2381 
35133	214	S2381 
35134	214	S2381 
35135	214	S2381 
35136	214	S2381 
35137	214	S2381 
35138	214	S2381 
35139	214	S2381 
35140	214	S2381 
35142	214	S2381 
35143	214	S2381 
35144	214	S2381 
35145	214	S2381 
35146	214	S2381 
35147	214	S2381 
35148	214	S2381 
43215	214	S26   
43364	214	S26   
43514	214	S1067 
14003	221	S2841 
14006	221	S2841 
14084	221	S2841 
14096	221	S2841 
14097	221	S2841 
14098	221	S2841 
14099	221	S2841 
14100	221	S2841 
14101	221	S2841 
14102	221	S2841 
14103	221	S2841 
14105	221	S2841 
14106	221	S2841 
14107	221	S2841 
14108	221	S2841 
14109	221	S2841 
14113	221	S2841 
14116	221	S2841 
14117	221	S2841 
14120	221	S2841 
14124	221	S2841 
14126	221	S2841 
14132	221	S2841 
14134	221	S2841 
14135	221	S2841 
14138	221	S2841 
14140	221	S2841 
14152	221	S2841 
14158	221	S2841 
14159	221	S2841 
14602	221	S2841 
01026	255	S25   
01029	255	S27   
01032	255	S19   
01040	255	S27   
01046	255	S19   
01077	255	S27   
01079	255	S1063 
01079	255	S20   
01082	255	S1063 
01085	255	S1063 
01103	255	S1163 
01123	255	S1063 
01123	255	S561  
01124	255	S1065 
01125	255	S1065 
01202	255	S1163 
02048	255	S2109 
02053	255	S2109 
04017	255	S19   
04020	255	S19   
04021	255	S19   
04023	255	S19   
04031	255	S81   
04053	255	S19   
04114	255	S19   
04120	255	S19   
04141	255	S19   
04142	255	S19   
04143	255	S19   
04144	255	S19   
04367	255	S19   
04547	255	S81   
04548	255	S81   
04551	255	S81   
04552	255	S81   
04554	255	S81   
04560	255	S81   
04586	255	S81   
04587	255	S81   
04610	255	S18   
04612	255	S19   
04613	255	S19   
04628	255	S18   
04629	255	S18   
04630	255	S19   
04631	255	S20   
04635	255	S19   
04636	255	S19   
04638	255	S26   
04639	255	S26   
04640	255	S26   
04641	255	S25   
04656	255	S2221 
04657	255	S2221 
04658	255	S2221 
04659	255	S2221 
04660	255	S2221 
04661	255	S2221 
04662	255	S2221 
04663	255	S2221 
04673	255	S2401 
04674	255	S2401 
04675	255	S2401 
04676	255	S2401 
04677	255	S2401 
05023	255	S1581 
05024	255	S1581 
05027	255	S1082 
05028	255	S1082 
05173	255	S1581 
05174	255	S1581 
05175	255	S1581 
05176	255	S1581 
05177	255	S1581 
05178	255	S1581 
05312	255	S26   
05313	255	S26   
05320	255	S26   
05623	255	D4282 
05624	255	S3    
05625	255	D4282 
05626	255	D4281 
05626	255	D4282 
05627	255	D4282 
05628	255	D4281 
05628	255	D4282 
05629	255	D4281 
05630	255	D4282 
05631	255	D4282 
05632	255	S3    
05643	255	D4301 
05644	255	D4301 
05645	255	D4301 
05646	255	D4301 
05647	255	D4301 
05648	255	D4301 
05649	255	D4301 
05650	255	D4301 
05651	255	D4301 
05652	255	D4301 
05653	255	D4301 
05654	255	D4301 
05655	255	D4301 
05656	255	D4301 
05657	255	D4301 
05658	255	D4301 
05661	255	S1082 
06016	255	S18   
06019	255	S18   
06043	255	S18   
06094	255	S18   
06128	255	S18   
06159	255	S18   
06164	255	S23   
06931	255	S22   
06982	255	S18   
06983	255	S18   
06984	255	S2104 
06985	255	S2104 
07002	255	S222  
07005	255	S248  
07006	255	S247  
07007	255	S1164 
07008	255	S238  
07011	255	S227  
07011	255	S281  
07013	255	S242  
07013	255	S281  
07014	255	S281  
07015	255	S248  
07016	255	S248  
07018	255	S226  
07021	255	S237  
07022	255	S21   
07023	255	S242  
07027	255	S281  
07028	255	S225  
07028	255	S230  
07028	255	S281  
07029	255	S281  
07032	255	S281  
07034	255	S249  
07038	255	S281  
07039	255	S244  
07043	255	S230  
07052	255	S227  
07056	255	S248  
07057	255	S281  
07058	255	S237  
07063	255	S1164 
07063	255	S582  
07064	255	S1164 
07068	255	S1041 
07072	255	S281  
07075	255	S1164 
07078	255	S228  
07078	255	S281  
07079	255	S13   
07079	255	S227  
07079	255	S281  
07080	255	S227  
07083	255	S281  
07089	255	S241  
07089	255	S251  
07201	255	S281  
07202	255	S281  
07205	255	S281  
07207	255	S281  
07209	255	S281  
07211	255	S281  
07212	255	S281  
07213	255	S281  
07230	255	S281  
07233	255	S281  
07240	255	S281  
07241	255	S21   
07242	255	S281  
07254	255	S281  
07255	255	S281  
07256	255	S281  
07268	255	S281  
07276	255	S281  
07278	255	S259  
07279	255	S259  
07905	255	S281  
07906	255	S281  
07908	255	S281  
07909	255	S259  
07910	255	S245  
07911	255	S226  
07912	255	S226  
07913	255	S238  
07914	255	S252  
07915	255	S281  
07916	255	S242  
07917	255	S242  
07918	255	S242  
07919	255	S252  
07920	255	S242  
07921	255	S228  
07922	255	S242  
07923	255	S245  
07924	255	S242  
07925	255	S281  
07926	255	S228  
07927	255	S227  
07928	255	S225  
07929	255	S227  
07930	255	S222  
07931	255	S222  
07932	255	S224  
07933	255	S224  
07934	255	S281  
07935	255	S224  
07936	255	S247  
07938	255	S233  
07939	255	S235  
07940	255	S237  
07941	255	S281  
07942	255	S281  
07943	255	S281  
07944	255	S227  
07945	255	S21   
07949	255	S23   
07950	255	S23   
07951	255	S243  
07952	255	S1164 
07953	255	S1164 
07953	255	S582  
07954	255	S582  
07955	255	S1164 
07956	255	S1164 
07957	255	S1164 
07958	255	S1164 
07959	255	S1164 
07960	255	S1164 
08001	255	S1065 
08003	255	S2664 
08005	255	S2664 
08010	255	S702  
08011	255	S702  
08012	255	S1065 
08013	255	S1065 
08014	255	S1065 
08017	255	S603  
08018	255	S702  
08019	255	S603  
08020	255	S1065 
08023	255	S2664 
08025	255	S2662 
08026	255	S603  
08028	255	S2664 
08030	255	S1065 
08031	255	S2664 
08032	255	S2664 
08035	255	S603  
08045	255	S603  
08047	255	S702  
08048	255	S603  
08049	255	S702  
08050	255	S603  
08054	255	S702  
08057	255	S603  
08058	255	S2664 
08059	255	S702  
08060	255	S2664 
08061	255	S1065 
08064	255	S603  
08065	255	S1065 
08065	255	S2662 
08066	255	S702  
08067	255	S2664 
08068	255	S2664 
08069	255	S2664 
08071	255	S2664 
08074	255	S2662 
08077	255	S1065 
08078	255	S603  
08082	255	S603  
08083	255	S2502 
08085	255	S702  
08086	255	S603  
08087	255	S603  
08089	255	S603  
08092	255	S702  
08094	255	S702  
08116	255	S2502 
08124	255	S702  
08128	255	S702  
08130	255	S702  
08138	255	S2502 
08139	255	S603  
08146	255	S702  
08147	255	S1065 
08147	255	S2422 
08177	255	S2502 
08189	255	S2664 
08190	255	S603  
08194	255	S603  
08200	255	S702  
08202	255	S603  
08206	255	S2502 
08210	255	S702  
08211	255	S702  
08212	255	S702  
08214	255	S702  
08215	255	S702  
08216	255	S702  
08217	255	S2664 
08218	255	S1065 
08219	255	S702  
08220	255	S702  
08221	255	S702  
08225	255	S702  
08229	255	S702  
08231	255	S702  
08232	255	S702  
08243	255	S603  
08244	255	S603  
08245	255	S603  
08247	255	S603  
08253	255	S2664 
08258	255	S2664 
08259	255	S2662 
08262	255	S603  
08263	255	S603  
08266	255	S603  
08267	255	S603  
08268	255	S603  
08269	255	S603  
08270	255	S603  
08271	255	S603  
08272	255	S603  
08273	255	S603  
08274	255	S603  
08277	255	S603  
08278	255	S603  
08283	255	S2664 
08284	255	S2664 
08286	255	S2664 
08287	255	S2664 
08288	255	S2664 
08289	255	S2664 
08293	255	S702  
08294	255	S702  
08299	255	S702  
08309	255	S2664 
08315	255	S702  
08316	255	S702  
08317	255	S702  
08318	255	S2664 
08319	255	S2664 
08345	255	S603  
08346	255	S2502 
08347	255	S2502 
08348	255	S2502 
08349	255	S2502 
08350	255	S2502 
08351	255	S702  
08352	255	S702  
08353	255	S702  
08354	255	S702  
08355	255	S702  
08357	255	S702  
08358	255	S702  
08359	255	S702  
08360	255	S702  
08361	255	S702  
08362	255	S702  
08363	255	S702  
08364	255	S702  
08366	255	S702  
08367	255	S603  
08368	255	S603  
08370	255	S603  
08371	255	S603  
08372	255	S603  
08374	255	S2664 
08376	255	S2664 
08378	255	S2161 
08379	255	S2664 
08380	255	S2664 
08383	255	S2664 
08384	255	S2664 
08385	255	S2664 
08386	255	S2664 
08387	255	S2664 
08388	255	S2664 
08389	255	S2664 
08390	255	S2664 
08391	255	S682  
08392	255	S2664 
08393	255	S2664 
08394	255	S702  
08395	255	S702  
08396	255	S702  
08397	255	S603  
08398	255	S603  
08399	255	S603  
08400	255	S881  
08401	255	S881  
08402	255	S702  
08403	255	S1209 
08408	255	S2502 
08409	255	S2502 
08410	255	S702  
08411	255	S702  
08412	255	S702  
08413	255	S702  
08414	255	S702  
08415	255	S702  
08416	255	S702  
08417	255	S702  
08418	255	S702  
08419	255	S702  
08420	255	S702  
08421	255	S702  
08422	255	S702  
08435	255	S1065 
08436	255	S702  
08444	255	S702  
08446	255	S702  
08448	255	S702  
08449	255	S702  
08450	255	S702  
08454	255	S2664 
08455	255	S2664 
08456	255	S2664 
08457	255	S2664 
08458	255	S2664 
08459	255	S2664 
08460	255	S2664 
08461	255	S2664 
08462	255	S2664 
08463	255	S2664 
08464	255	S2664 
08465	255	S2664 
08466	255	S2664 
08467	255	S2161 
08468	255	S2664 
08469	255	S2664 
08470	255	S2664 
08471	255	S2664 
08472	255	S2664 
08473	255	S2664 
08474	255	S2664 
08476	255	S2502 
08478	255	S2502 
08481	255	S2502 
08482	255	S2502 
08483	255	S2502 
08484	255	S2502 
08487	255	S2502 
08488	255	S2502 
08489	255	S2502 
08490	255	S2502 
08491	255	S2502 
08492	255	S2502 
08493	255	S2502 
08494	255	S2502 
08495	255	S2502 
08497	255	S2502 
08498	255	S2502 
08500	255	S2502 
08501	255	S2502 
08504	255	S2662 
08505	255	S2662 
08506	255	S2662 
08507	255	S2662 
08508	255	S2662 
08509	255	S2662 
09003	255	S1183 
09003	255	S502  
09003	255	S561  
09003	255	S87   
09004	255	S502  
09004	255	S84   
09032	255	D3780 
09032	255	S21   
09037	255	S1031 
09037	255	S121  
09037	255	S1401 
09037	255	S1621 
09037	255	S381  
09037	255	S481  
09037	255	S502  
09037	255	S837  
09038	255	S1031 
09038	255	S121  
09038	255	S1401 
09038	255	S1621 
09038	255	S481  
09038	255	S502  
09038	255	S837  
09039	255	S121  
09039	255	S1401 
09039	255	S381  
09039	255	S837  
09040	255	D3764 
09040	255	S1023 
09040	255	S121  
09040	255	S481  
09040	255	S562  
09040	255	S87   
09042	255	S461  
09042	255	S566  
09050	255	S1141 
09050	255	S421  
09050	255	S441  
09060	255	S381  
09062	255	S381  
09062	255	S404  
09070	255	D3344 
09070	255	S121  
09070	255	S53   
09070	255	S582  
09078	255	S561  
09079	255	S1701 
09087	255	S1032 
09087	255	S564  
09087	255	S582  
09094	255	S363  
09094	255	S582  
09112	255	D3764 
09112	255	S482  
09112	255	S563  
09132	255	S1062 
09139	255	S381  
09148	255	S1033 
09148	255	S363  
09148	255	S582  
09149	255	S381  
09160	255	S1065 
09181	255	S1024 
09181	255	S1121 
09181	255	S121  
09181	255	S461  
09181	255	S604  
09181	255	S606  
09181	255	S87   
09183	255	S381  
09184	255	D3765 
09184	255	S1026 
09184	255	S562  
09184	255	S565  
09191	255	D3344 
09191	255	D3764 
09191	255	S1206 
09191	255	S421  
09191	255	S582  
09191	255	S837  
09191	255	S84   
09195	255	S1202 
09195	255	S1562 
09195	255	S84   
09202	255	S482  
09202	255	S564  
09202	255	S837  
09218	255	D3764 
09218	255	S1065 
09218	255	S1161 
09218	255	S1222 
09218	255	S606  
09236	255	S121  
09236	255	S461  
09236	255	S582  
09252	255	S482  
09252	255	S541  
09266	255	S1167 
09266	255	S441  
09266	255	S561  
09273	255	S2104 
09279	255	S121  
09279	255	S421  
09279	255	S582  
09291	255	D3780 
09291	255	S121  
09291	255	S564  
09291	255	S566  
09291	255	S606  
09291	255	S837  
09298	255	D3764 
09298	255	D3779 
09298	255	S121  
09298	255	S564  
09298	255	S566  
09302	255	D3780 
09302	255	S381  
09302	255	S461  
09302	255	S566  
09302	255	S963  
09316	255	D3764 
09316	255	S1162 
09316	255	S421  
09316	255	S566  
09316	255	S581  
09316	255	S604  
09316	255	S606  
09326	255	D3764 
09326	255	S1027 
09326	255	S441  
09326	255	S461  
09326	255	S837  
09326	255	S84   
09328	255	S1206 
09409	255	S2104 
09421	255	S564  
09421	255	S582  
09422	255	S1202 
09427	255	D4053 
09428	255	D4053 
09429	255	S1167 
09429	255	S441  
09430	255	S441  
09430	255	S561  
09431	255	S2203 
09432	255	S2203 
09433	255	S2105 
09433	255	S2961 
10007	255	S1082 
10066	255	S1082 
10066	255	S1166 
10067	255	S1082 
10067	255	S1166 
10068	255	S1082 
10068	255	S1166 
10098	255	S1581 
10099	255	S1581 
10102	255	S1581 
10119	255	S1581 
10123	255	S1082 
10124	255	S1082 
10173	255	S1581 
10858	255	S1082 
10858	255	S1166 
10860	255	S1082 
10861	255	S1082 
10862	255	S1082 
10863	255	S1581 
10864	255	S1082 
11011	255	D3326 
11011	255	S1069 
11011	255	S81   
11012	255	S1069 
11090	255	D3773 
11090	255	S1121 
11090	255	S121  
11090	255	S2122 
11090	255	S564  
11090	255	S604  
11090	255	S606  
11090	255	S619  
11090	255	S837  
11090	255	S87   
11091	255	S1121 
11091	255	S564  
11091	255	S606  
11091	255	S837  
11096	255	S1121 
11096	255	S482  
11097	255	S482  
11112	255	D3326 
11112	255	S1065 
11113	255	S1065 
11124	255	S1062 
11124	255	S604  
11124	255	S606  
11124	255	S618  
11124	255	S837  
11124	255	S84   
11124	255	S87   
11125	255	S1062 
11130	255	S25   
11131	255	S25   
11143	255	S1121 
11143	255	S564  
11143	255	S604  
11143	255	S84   
11143	255	S87   
11157	255	S1202 
11179	255	S405  
11179	255	S604  
11179	255	S822  
11179	255	S837  
11179	255	S84   
11205	255	D3773 
11205	255	S1062 
11205	255	S121  
11205	255	S604  
11206	255	S1062 
11206	255	S121  
11206	255	S81   
11243	255	S2941 
11250	255	S562  
11250	255	S565  
11251	255	S481  
11251	255	S503  
11251	255	S620  
11252	255	D3765 
11252	255	S1206 
11252	255	S121  
11252	255	S2121 
11252	255	S481  
11252	255	S562  
11252	255	S604  
11252	255	S624  
11252	255	S81   
11252	255	S837  
11252	255	S87   
11253	255	S541  
11253	255	S565  
11257	255	S541  
11257	255	S565  
11260	255	D389  
11260	255	D566  
11260	255	S121  
11260	255	S1821 
11260	255	S2941 
11260	255	S604  
11260	255	S606  
11260	255	S78   
11260	255	S80   
11263	255	S2941 
11267	255	S2941 
11279	255	S84   
11282	255	D3306 
11282	255	S1062 
11282	255	S121  
11282	255	S837  
11286	255	S1062 
11294	255	S563  
11294	255	S582  
11333	255	D3326 
11333	255	D3764 
11333	255	D3776 
11333	255	S1062 
11333	255	S604  
11333	255	S611  
11333	255	S837  
11339	255	S1062 
11352	255	S563  
11352	255	S566  
11353	255	S563  
11353	255	S566  
11354	255	S563  
11354	255	S566  
11355	255	S563  
11355	255	S566  
11356	255	S563  
11356	255	S566  
11357	255	S563  
11357	255	S566  
11358	255	S563  
11358	255	S566  
11359	255	D3764 
11359	255	S2105 
11359	255	S2581 
11360	255	S2105 
11394	255	S2105 
11395	255	S2105 
11398	255	S2105 
11399	255	S2105 
11402	255	S2105 
11403	255	D3764 
11403	255	S2105 
11403	255	S2581 
11411	255	S2105 
11412	255	S2105 
11429	255	S1121 
11429	255	S363  
11429	255	S604  
11429	255	S617  
11457	255	D3326 
11457	255	D3777 
11457	255	S604  
11457	255	S606  
11457	255	S837  
11457	255	S84   
11457	255	S87   
11463	255	S25   
11464	255	S25   
11507	255	S1062 
11507	255	S606  
11508	255	S1062 
11508	255	S121  
11508	255	S606  
11510	255	S1062 
11529	255	D3306 
11529	255	D3326 
11529	255	S441  
11529	255	S503  
11529	255	S604  
11529	255	S608  
11529	255	S837  
11529	255	S84   
11529	255	S87   
11530	255	S441  
11531	255	S27   
11531	255	S604  
11531	255	S625  
11531	255	S626  
11531	255	S627  
11531	255	S641  
11533	255	S625  
11533	255	S626  
11533	255	S627  
11533	255	S641  
11533	255	S81   
11546	255	S21   
11546	255	S5    
11546	255	S625  
11546	255	S626  
11546	255	S627  
11546	255	S641  
11546	255	S81   
11547	255	S21   
11547	255	S625  
11547	255	S626  
11547	255	S627  
11547	255	S641  
11568	255	D3326 
11568	255	S81   
11674	255	S563  
11674	255	S566  
11705	255	S1069 
11752	255	S1065 
11757	255	S1062 
11760	255	S25   
11774	255	S405  
11774	255	S604  
11774	255	S822  
11774	255	S837  
11774	255	S84   
11803	255	S84   
11821	255	S1062 
11828	255	S563  
11828	255	S566  
11841	255	S2105 
11842	255	S2105 
11856	255	S25   
11875	255	S1062 
11875	255	S121  
11875	255	S606  
11876	255	S1062 
11884	255	S441  
11887	255	S21   
11887	255	S5    
11887	255	S625  
11887	255	S626  
11887	255	S627  
11887	255	S641  
11887	255	S81   
11888	255	S21   
11888	255	S625  
11888	255	S626  
11888	255	S627  
11888	255	S641  
11921	255	S1062 
11935	255	S22   
11935	255	S5    
11935	255	S81   
11949	255	S22   
11949	255	S5    
11949	255	S81   
11950	255	S2941 
11960	255	S481  
11960	255	S562  
11987	255	S1202 
11987	255	S2941 
11990	255	S1202 
11991	255	S1202 
11992	255	S2941 
12006	255	D4822 
12006	255	S1783 
12038	255	S606  
12038	255	S661  
12038	255	S961  
12061	255	S141  
12062	255	S141  
12063	255	S141  
12065	255	S141  
12078	255	S1063 
12078	255	S503  
12078	255	S81   
12086	255	S343  
12087	255	S343  
12120	255	S83   
12121	255	S83   
12122	255	S83   
12131	255	S77   
12132	255	S77   
12142	255	S85   
12143	255	S85   
12144	255	S85   
12147	255	S502  
12147	255	S564  
12151	255	S101  
12151	255	S86   
12152	255	S101  
12152	255	S86   
12154	255	S941  
12155	255	S79   
12201	255	S1164 
12220	255	S1221 
12220	255	S2109 
12538	255	S606  
12538	255	S661  
12538	255	S961  
12563	255	S141  
12565	255	S141  
12586	255	S343  
12586	255	S363  
12586	255	S5    
12586	255	S502  
12586	255	S82   
12632	255	S77   
12643	255	S85   
12644	255	S85   
12652	255	S86   
13019	255	S2    
13020	255	S2    
13039	255	S221  
13055	255	S2    
13065	255	S2    
13067	255	S2    
13068	255	S2    
13070	255	S2    
13096	255	S2    
13098	255	S2    
13165	255	S2    
13318	255	S1581 
13320	255	S1581 
13321	255	S1581 
13322	255	S1581 
13323	255	S1581 
13324	255	S1581 
13325	255	S1082 
13326	255	S1082 
13327	255	S1082 
13340	255	S1581 
13341	255	S1581 
13343	255	S2    
13355	255	S230  
13369	255	S2    
13370	255	S2    
13373	255	S2    
13375	255	S2    
13377	255	S2    
13378	255	S2    
13391	255	S2    
13394	255	S2    
13398	255	S2    
13399	255	S2    
13401	255	S2    
13402	255	S2    
13404	255	S2    
13405	255	S2    
13407	255	S2    
13408	255	S2    
13410	255	S2    
13411	255	S2    
13413	255	S2    
13414	255	S2    
13415	255	S2    
13416	255	S2    
13417	255	S2    
13418	255	S2    
13419	255	S2    
13420	255	S2    
13421	255	S2    
13422	255	S2    
13423	255	S2    
13424	255	S2    
13425	255	S2    
13426	255	S2    
13439	255	S2    
13440	255	S2    
13441	255	S2    
13442	255	S2    
13443	255	S2    
13444	255	S2    
13445	255	S2    
13446	255	S2    
13447	255	S2    
13448	255	S2    
13449	255	S2    
13450	255	S2    
13451	255	S2    
13452	255	S2    
13453	255	S2    
13454	255	S2    
13455	255	S2    
13456	255	S2    
13467	255	S221  
13468	255	S221  
13469	255	S221  
13470	255	S221  
13481	255	S221  
13482	255	S221  
13483	255	S221  
13484	255	S221  
13485	255	S2    
13486	255	S2    
13487	255	S2    
13488	255	S2    
13490	255	S2    
13491	255	S2    
13492	255	S2    
13493	255	S2    
13494	255	S14   
13495	255	S14   
13496	255	S14   
13497	255	S14   
13498	255	S14   
13565	255	S2703 
13566	255	S2703 
13567	255	S2703 
13568	255	S2703 
13569	255	S2703 
13805	255	S2    
13806	255	S2    
13809	255	S2    
13810	255	S2    
13811	255	S2    
13812	255	S2    
13813	255	S2    
13814	255	S2    
13850	255	S2    
13851	255	S2    
13853	255	S2    
13854	255	S2    
13856	255	S2    
13857	255	S2    
13868	255	S2    
13869	255	S2    
13870	255	S2    
13871	255	S2    
13872	255	S2    
13873	255	S2    
13874	255	S2    
13875	255	S2    
13876	255	S2    
13877	255	S2    
13878	255	S2    
13879	255	S2    
13880	255	S2    
13881	255	S2    
13882	255	S2    
13891	255	S2    
13893	255	S2    
13894	255	S2    
13896	255	S2    
13898	255	S2    
13900	255	S2    
13909	255	S2    
13910	255	S2    
13911	255	S2    
13912	255	S2    
13913	255	S2    
13914	255	S2    
13917	255	S2    
13918	255	S2    
13920	255	S2    
13921	255	S2    
13923	255	S2    
13924	255	S2    
13929	255	S2    
13930	255	S2    
13931	255	S2    
13932	255	S2    
13934	255	S2    
13935	255	S2    
13936	255	S221  
13937	255	S221  
13938	255	S221  
13939	255	S221  
13940	255	S221  
13941	255	S221  
13942	255	S221  
13943	255	S221  
13944	255	S221  
13945	255	S221  
13946	255	S221  
13947	255	S221  
13948	255	S2    
13949	255	S2    
13950	255	S2    
13951	255	S2    
13952	255	S2    
13953	255	S2    
13954	255	S2    
13955	255	S2    
13956	255	S2    
13957	255	S2    
13958	255	S2    
13959	255	S2    
13960	255	S221  
13961	255	S221  
13962	255	S221  
13963	255	S221  
13964	255	S221  
13965	255	S221  
13966	255	S221  
13967	255	S221  
13968	255	S2    
13969	255	S2    
13970	255	S2    
13971	255	S2    
13976	255	S221  
13977	255	S221  
13978	255	S221  
13979	255	S221  
13985	255	S2    
13987	255	S221  
13988	255	S2703 
13989	255	S2703 
13990	255	S2703 
13991	255	S2703 
13992	255	S2703 
13994	255	S2703 
13995	255	S2703 
13996	255	S2703 
13997	255	S2703 
13998	255	S2703 
14137	255	S1068 
14144	255	S1068 
14145	255	S1064 
14145	255	S1066 
14145	255	S1068 
14145	255	S1122 
14146	255	S1068 
14147	255	S1068 
14148	255	S1068 
14149	255	S1068 
14154	255	S2702 
14156	255	S2702 
14209	255	S1064 
14209	255	S1066 
14209	255	S1122 
14209	255	S23   
14238	255	S2104 
14242	255	S2104 
14267	255	D657  
14323	255	S1067 
14347	255	S1064 
14347	255	S1122 
14366	255	S2104 
14370	255	S2104 
14382	255	S1164 
14400	255	S1064 
14400	255	S1066 
14400	255	S1068 
14400	255	S1122 
14416	255	S1064 
14416	255	S1066 
14416	255	S1068 
14416	255	S1122 
14432	255	S1068 
14433	255	S1068 
14434	255	S1068 
14437	255	S27   
14438	255	S27   
14439	255	S27   
14440	255	S2109 
14450	255	S1164 
14460	255	S1164 
14461	255	S1164 
14462	255	S2109 
14475	255	S1068 
14476	255	S1068 
14555	255	S1068 
14555	255	S27   
14559	255	S1068 
14559	255	S27   
14601	255	S1066 
14602	255	S2103 
15027	255	S1163 
15073	255	S1163 
15078	255	D1066 
15078	255	D1107 
15078	255	D2793 
15078	255	D3410 
15078	255	S2621 
15087	255	S2109 
15152	255	S2104 
15232	255	S1163 
15260	255	S2109 
15261	255	S1163 
15262	255	S1163 
16006	255	S1164 
16006	255	S1401 
16010	255	S1164 
16010	255	S2581 
16010	255	S604  
16010	255	S606  
16011	255	S1164 
16011	255	S2581 
16011	255	S604  
16011	255	S606  
16029	255	S1164 
16037	255	S1164 
16037	255	S2202 
16038	255	S1164 
16038	255	S2202 
16042	255	S1065 
16042	255	S2202 
16043	255	S1065 
16043	255	S2202 
16069	255	S2202 
16069	255	S84   
16089	255	S563  
16097	255	D3765 
16097	255	S22   
16098	255	S22   
16098	255	S404  
16098	255	S837  
16098	255	S84   
16098	255	S87   
16112	255	S39   
16112	255	S604  
16112	255	S81   
16114	255	S39   
16120	255	S39   
16123	255	S1401 
16123	255	S39   
16126	255	S1202 
16126	255	S1401 
16126	255	S39   
16139	255	S39   
16147	255	S2104 
16159	255	D342  
16159	255	S39   
16167	255	S2203 
16174	255	S18   
16338	255	S1164 
16338	255	S2202 
16343	255	S1065 
16343	255	S2202 
16397	255	D3765 
16397	255	S22   
16398	255	S22   
16398	255	S404  
16398	255	S837  
16398	255	S84   
16398	255	S87   
17202	255	S1082 
17203	255	S1082 
17204	255	S1082 
17218	255	S1581 
17219	255	S1581 
17332	255	S3    
17335	255	S3    
17340	255	S3    
17341	255	S3    
17342	255	S3    
17345	255	S3    
17346	255	S3    
17347	255	S3    
17348	255	S3    
18001	255	S1162 
18002	255	S1162 
18069	255	S20   
18079	255	S25   
18159	255	S21   
18166	255	S25   
18168	255	S25   
18215	255	S25   
18228	255	S23   
18231	255	S25   
18258	255	S1162 
18259	255	S1162 
18262	255	S1162 
18263	255	S1162 
18288	255	S27   
18350	255	S21   
18363	255	S22   
18364	255	S22   
18365	255	S27   
18376	255	S25   
18403	255	S27   
18927	255	S25   
18930	255	S2203 
18931	255	S2203 
18932	255	S27   
18933	255	S27   
18934	255	S27   
18935	255	S27   
18936	255	S27   
19003	255	S26   
19014	255	S5    
19034	255	S26   
19035	255	S26   
19047	255	S1162 
19056	255	S26   
19057	255	S2109 
19058	255	S2109 
19064	255	S1164 
19076	255	S1164 
19078	255	S1069 
19109	255	S1164 
19120	255	S1069 
19155	255	S1164 
19230	255	S1063 
19283	255	S1067 
19300	255	S5    
19337	255	S2109 
19350	255	S1164 
19411	255	S26   
19856	255	S1067 
19868	255	S2109 
19873	255	S1067 
20046	255	S20   
20046	255	S604  
20046	255	S606  
20047	255	S20   
20047	255	S2123 
20047	255	S604  
20047	255	S606  
20048	255	S1206 
20048	255	S20   
20049	255	S1206 
20049	255	S20   
20049	255	S2123 
20099	255	S1163 
20099	255	S20   
20099	255	S5    
20099	255	S606  
20100	255	D3764 
20100	255	D3765 
20100	255	S1163 
20100	255	S20   
20100	255	S2901 
20100	255	S606  
20100	255	S837  
20109	255	S2105 
20109	255	S606  
20110	255	D3764 
20110	255	S1401 
20110	255	S2105 
20110	255	S606  
20120	255	S1163 
20120	255	S20   
20120	255	S5    
20120	255	S606  
20121	255	D3764 
20121	255	D3765 
20121	255	S1163 
20121	255	S20   
20121	255	S2901 
20121	255	S606  
20121	255	S837  
20132	255	S1202 
20310	255	D3764 
20310	255	S1401 
20310	255	S2105 
20310	255	S606  
20321	255	D3764 
20321	255	D3765 
20321	255	S1163 
20321	255	S20   
20321	255	S2901 
20321	255	S606  
20321	255	S837  
20400	255	D3764 
20400	255	D3765 
20400	255	S1163 
20400	255	S20   
20400	255	S2901 
20400	255	S606  
20400	255	S837  
20409	255	S2105 
20409	255	S606  
20410	255	D3764 
20410	255	S1401 
20410	255	S2105 
20410	255	S606  
20420	255	S1163 
20420	255	S20   
20420	255	S5    
20420	255	S606  
20421	255	D3764 
20421	255	D3765 
20421	255	S1163 
20421	255	S20   
20421	255	S2901 
20421	255	S606  
20421	255	S837  
20446	255	S20   
20446	255	S604  
20446	255	S606  
20447	255	S20   
20447	255	S2123 
20447	255	S604  
20447	255	S606  
20499	255	S1163 
20499	255	S20   
20499	255	S5    
20499	255	S606  
20510	255	D3764 
20510	255	S1401 
20510	255	S2105 
20510	255	S606  
20521	255	D3764 
20521	255	D3765 
20521	255	S1163 
20521	255	S20   
20521	255	S2901 
20521	255	S606  
20521	255	S837  
20623	255	S1742 
20624	255	S1742 
20628	255	S1742 
20629	255	S1742 
20630	255	S1742 
20634	255	S1742 
20635	255	S1742 
20636	255	S1742 
20640	255	S1742 
20641	255	S1742 
20645	255	S1742 
20646	255	S1742 
21138	255	S2801 
21141	255	S1064 
21224	255	S19   
21225	255	S19   
21226	255	S22   
21227	255	S22   
21229	255	S1122 
21238	255	S2801 
21239	255	S1066 
21240	255	S1066 
21241	255	S1066 
21242	255	S1066 
21243	255	S1066 
21244	255	S1066 
21245	255	S1066 
21246	255	S1066 
21247	255	S1066 
21248	255	S1066 
21249	255	S1064 
21250	255	S1064 
21251	255	S1064 
21252	255	S1064 
21253	255	S1064 
21254	255	S1064 
21255	255	S1064 
21256	255	S1064 
21257	255	S1064 
21259	255	S1064 
21260	255	S1082 
21261	255	S1082 
21262	255	S1082 
21263	255	S1082 
21264	255	S1082 
21265	255	S1082 
21266	255	S1082 
21267	255	S1082 
21268	255	S1082 
21269	255	S1082 
21270	255	S1082 
21271	255	S2108 
21272	255	S2108 
21273	255	S2108 
21274	255	S2108 
21275	255	S2108 
21276	255	S2108 
21277	255	S2110 
21278	255	S2110 
21279	255	S2110 
21280	255	S2110 
21281	255	S2110 
21282	255	S2110 
21283	255	S2111 
21284	255	S2111 
21285	255	S2111 
21286	255	S2111 
21287	255	S2112 
21288	255	S2112 
21289	255	S2112 
21290	255	S2112 
21291	255	S2112 
21292	255	S2112 
21293	255	S2782 
21294	255	S2782 
21295	255	S2782 
21296	255	S2782 
21297	255	S2782 
21298	255	S2782 
21299	255	S2110 
21299	255	S2111 
21299	255	S2112 
21299	255	S2782 
21300	255	S2110 
21300	255	S2112 
21300	255	S2782 
21301	255	S2110 
21301	255	S2111 
21301	255	S2112 
21301	255	S2782 
21302	255	S2110 
21302	255	S2111 
21302	255	S2112 
21302	255	S2782 
21303	255	S2110 
21303	255	S2112 
21303	255	S2782 
21304	255	S2110 
21304	255	S2111 
21304	255	S2112 
21304	255	S2782 
21308	255	S2801 
21309	255	S2801 
21310	255	S2801 
21311	255	S2801 
21312	255	S2801 
21313	255	S2801 
21314	255	S2801 
21315	255	S2801 
21316	255	S2801 
21317	255	S2801 
21318	255	S2801 
21319	255	S2801 
21320	255	S2801 
21321	255	S2801 
21322	255	S2801 
21323	255	S2801 
21324	255	S2801 
21325	255	S2801 
21326	255	S2801 
21337	255	S2801 
21342	255	S2801 
21343	255	S2801 
21346	255	S2801 
21347	255	S2801 
21348	255	S2801 
22247	255	S20   
22903	255	S21   
22904	255	S18   
22909	255	S22   
22911	255	S18   
22912	255	S19   
22914	255	S19   
22915	255	S19   
22916	255	S19   
23009	255	S2703 
23010	255	S2703 
23011	255	S2703 
23012	255	S2703 
23013	255	S2703 
23014	255	S2703 
23015	255	S2703 
23016	255	S2703 
23017	255	S2703 
23018	255	S2703 
23019	255	S2703 
23020	255	S2703 
23021	255	S2703 
23022	255	S2703 
23023	255	S2703 
23024	255	S2703 
23025	255	S2703 
23027	255	S2703 
23028	255	S2703 
23029	255	S2703 
23030	255	S2703 
23031	255	S2703 
23032	255	S2703 
23033	255	S2703 
23034	255	S2703 
23035	255	S2703 
23036	255	S2703 
23037	255	S2703 
23038	255	S2703 
23039	255	S2703 
23040	255	S2703 
23041	255	S2703 
23042	255	S2703 
23043	255	S2703 
23044	255	S2703 
23045	255	S2703 
23046	255	S2703 
23047	255	S2703 
23048	255	S2703 
23049	255	S2703 
23050	255	S2703 
23051	255	S2703 
23052	255	S2703 
23053	255	S2703 
23054	255	S2703 
23055	255	S2703 
23056	255	S2703 
23057	255	S2703 
23058	255	S2703 
23059	255	S2703 
23060	255	S2703 
23061	255	S2703 
23062	255	S2703 
23063	255	S2703 
23064	255	S2703 
23065	255	S2703 
23557	255	S14   
23558	255	S14   
23559	255	S14   
23560	255	S14   
23561	255	S14   
23562	255	S14   
23563	255	S14   
23564	255	S14   
23565	255	S14   
23566	255	S14   
23567	255	S14   
23568	255	S14   
23569	255	S14   
23570	255	S14   
23571	255	S14   
23572	255	S14   
23573	255	S14   
23574	255	S14   
23575	255	S14   
23576	255	S14   
23577	255	S14   
23578	255	S14   
23579	255	S14   
23580	255	S14   
23581	255	S14   
23582	255	S2    
23583	255	S2    
23584	255	S2    
23585	255	S2    
23586	255	S2    
23587	255	S2    
23588	255	S2    
23589	255	S2    
23590	255	S2    
23591	255	S2    
23592	255	S2    
23593	255	S2    
23594	255	S2    
23595	255	S2    
23596	255	S2    
23597	255	S2    
23598	255	S2    
23599	255	S2    
23600	255	S2    
23601	255	S2    
23602	255	S2    
23603	255	S2    
23604	255	S2    
23605	255	S2    
23606	255	S2    
23607	255	S2    
23608	255	S2    
23609	255	S2    
23610	255	S2    
23611	255	S2    
23612	255	S2    
23613	255	S2    
23614	255	S2    
23615	255	S2    
23616	255	S2    
23617	255	S2    
23618	255	S2    
23619	255	S2    
23620	255	S2    
23621	255	S2    
23622	255	S2    
23623	255	S2    
23624	255	S2    
23625	255	S2    
23626	255	S2    
23627	255	S2    
23628	255	S2    
23629	255	S2    
23630	255	S2    
23631	255	S2    
23632	255	S2    
23633	255	S2    
23634	255	S2    
23635	255	S2    
23636	255	S2    
23637	255	S2    
23638	255	S2    
23640	255	S1581 
23646	255	S2    
23647	255	S2    
23648	255	S2    
23649	255	S2    
23650	255	S2    
23651	255	S2    
23652	255	S2    
23653	255	S2    
23654	255	S2    
23655	255	S2    
23656	255	S2    
23657	255	S2    
23658	255	S2    
23659	255	S2    
23660	255	S2    
35001	255	D4961 
35002	255	D4961 
35003	255	D4961 
35004	255	D4961 
35008	255	D4961 
35009	255	D4961 
35010	255	D4961 
35011	255	D4961 
35012	255	D4961 
35013	255	D4961 
35014	255	D4961 
35015	255	D4961 
35016	255	D4961 
35017	255	D4961 
35021	255	D4961 
35022	255	D4961 
35023	255	D4961 
35024	255	D4961 
35025	255	D4961 
35026	255	D4961 
35027	255	D4961 
35028	255	D4961 
35029	255	D4961 
35030	255	D4961 
35034	255	D4961 
35038	255	D4961 
35039	255	D4961 
35040	255	D4961 
35041	255	D4961 
35042	255	D4961 
35043	255	D4961 
35046	255	D4961 
35047	255	D4961 
35048	255	D4961 
35050	255	D4961 
35051	255	D4961 
35054	255	D4961 
35055	255	D4961 
35056	255	D4961 
35057	255	D4961 
35058	255	D4961 
35059	255	D4961 
35060	255	D4961 
35063	255	D4961 
35064	255	D4961 
35065	255	D4961 
35066	255	D4961 
35067	255	D4961 
35068	255	D4961 
35070	255	D4961 
35071	255	D4961 
35072	255	D4961 
35073	255	D4961 
35074	255	D4961 
35075	255	D4961 
35078	255	D4961 
35079	255	D4961 
35080	255	D4961 
35081	255	D4961 
35082	255	D4961 
35083	255	D4961 
35084	255	D4961 
35085	255	D4961 
35086	255	D4961 
35087	255	D4961 
35088	255	D4961 
35089	255	D4961 
35090	255	D4961 
35091	255	D4961 
35092	255	D4961 
35093	255	D4961 
35130	255	S2381 
35131	255	S2381 
35132	255	S2381 
35133	255	S2381 
35134	255	S2381 
35135	255	S2381 
35136	255	S2381 
35137	255	S2381 
35138	255	S2381 
35139	255	S2381 
35140	255	S2381 
35141	255	S2381 
35142	255	S2381 
35143	255	S2381 
35144	255	S2381 
35145	255	S2381 
35146	255	S2381 
35147	255	S2381 
35148	255	S2381 
42161	255	S281  
42190	255	S243  
42190	255	S281  
42190	255	S282  
43158	255	S2109 
43215	255	S26   
43364	255	S26   
43372	255	S5    
43378	255	S1082 
43514	255	S1067 
48052	255	S1362 
11260	257	D566  
11260	257	S1821 
11260	257	S78   
11260	257	S80   
19078	257	S1069 
01103	262	S1163 
01202	262	S1163 
07002	262	S222  
07004	262	S248  
07005	262	S248  
07015	262	S248  
07016	262	S248  
07017	262	S248  
07035	262	S248  
07039	262	S244  
07056	262	S248  
07083	262	S281  
07276	262	S259  
07276	262	S281  
07277	262	S259  
07278	262	S259  
07906	262	S281  
07908	262	S281  
07909	262	S259  
07910	262	S245  
07911	262	S226  
07912	262	S226  
07913	262	S238  
07914	262	S252  
07915	262	S281  
07916	262	S242  
07917	262	S242  
07918	262	S242  
07919	262	S252  
07920	262	S242  
07921	262	S228  
07922	262	S242  
07923	262	S245  
07924	262	S242  
07925	262	S281  
07926	262	S228  
07927	262	S227  
07928	262	S225  
07929	262	S227  
07930	262	S222  
07931	262	S222  
07932	262	S224  
07933	262	S224  
07934	262	S281  
07935	262	S224  
07936	262	S247  
07937	262	S239  
07938	262	S233  
07939	262	S235  
07940	262	S237  
07941	262	S281  
07943	262	S281  
07944	262	S227  
08147	262	S2422 
13067	262	S2    
13070	262	S2    
13096	262	S2    
13098	262	S2    
13165	262	S2    
13343	262	S2    
13369	262	S2    
13370	262	S2    
13373	262	S2    
13375	262	S2    
13377	262	S2    
13378	262	S2    
13391	262	S2    
13394	262	S2    
13398	262	S2    
13399	262	S2    
13401	262	S2    
13402	262	S2    
13404	262	S2    
13405	262	S2    
13407	262	S2    
13408	262	S2    
13410	262	S2    
13411	262	S2    
13413	262	S2    
13414	262	S2    
13415	262	S2    
13416	262	S2    
13417	262	S2    
13418	262	S2    
13419	262	S2    
13420	262	S2    
13422	262	S2    
13423	262	S2    
13424	262	S2    
13425	262	S2    
13426	262	S2    
13439	262	S2    
13440	262	S2    
13441	262	S2    
13442	262	S2    
13443	262	S2    
13444	262	S2    
13445	262	S2    
13446	262	S2    
13447	262	S2    
13448	262	S2    
13449	262	S2    
13450	262	S2    
13451	262	S2    
13452	262	S2    
13453	262	S2    
13455	262	S2    
13456	262	S2    
13485	262	S2    
13486	262	S2    
13487	262	S2    
13488	262	S2    
13490	262	S2    
13491	262	S2    
13492	262	S2    
13493	262	S2    
13805	262	S2    
13806	262	S2    
13809	262	S2    
13811	262	S2    
13813	262	S2    
13850	262	S2    
13853	262	S2    
13854	262	S2    
13856	262	S2    
13857	262	S2    
13868	262	S2    
13870	262	S2    
13871	262	S2    
13873	262	S2    
13874	262	S2    
13875	262	S2    
13876	262	S2    
13877	262	S2    
13879	262	S2    
13880	262	S2    
13881	262	S2    
13882	262	S2    
13891	262	S2    
13894	262	S2    
13896	262	S2    
13898	262	S2    
13900	262	S2    
13909	262	S2    
13911	262	S2    
13912	262	S2    
13913	262	S2    
13914	262	S2    
13917	262	S2    
13920	262	S2    
13921	262	S2    
13923	262	S2    
13924	262	S2    
13929	262	S2    
13931	262	S2    
13932	262	S2    
13934	262	S2    
13935	262	S2    
13948	262	S2    
13949	262	S2    
13950	262	S2    
13951	262	S2    
13952	262	S2    
13953	262	S2    
13954	262	S2    
13955	262	S2    
13956	262	S2    
13957	262	S2    
13958	262	S2    
13959	262	S2    
13968	262	S2    
13969	262	S2    
13970	262	S2    
13971	262	S2    
13985	262	S2    
14137	262	S1068 
14145	262	S1068 
14145	262	S1122 
14148	262	S1068 
14149	262	S1068 
14154	262	S2702 
14156	262	S2702 
14209	262	S1064 
14209	262	S1066 
14209	262	S1122 
14209	262	S23   
14366	262	S2104 
14370	262	S2104 
14400	262	S1064 
14400	262	S1066 
14400	262	S1068 
14400	262	S1122 
14416	262	S1064 
14416	262	S1066 
14416	262	S1068 
14416	262	S1122 
14475	262	S1068 
14476	262	S1068 
14601	262	S1066 
19064	262	S1164 
19076	262	S1164 
19078	262	S1069 
19109	262	S1164 
19120	262	S1069 
19155	262	S1164 
23582	262	S2    
23583	262	S2    
23585	262	S2    
23586	262	S2    
23587	262	S2    
23589	262	S2    
23590	262	S2    
23591	262	S2    
23592	262	S2    
23593	262	S2    
23594	262	S2    
23595	262	S2    
23596	262	S2    
23597	262	S2    
23599	262	S2    
23601	262	S2    
23603	262	S2    
23604	262	S2    
23607	262	S2    
23609	262	S2    
23613	262	S2    
23615	262	S2    
23616	262	S2    
23618	262	S2    
23619	262	S2    
23620	262	S2    
23623	262	S2    
23624	262	S2    
23626	262	S2    
23627	262	S2    
23628	262	S2    
23630	262	S2    
23631	262	S2    
23632	262	S2    
23634	262	S2    
23635	262	S2    
23636	262	S2    
23637	262	S2    
23646	262	S2    
23647	262	S2    
23648	262	S2    
23649	262	S2    
23650	262	S2    
23651	262	S2    
23652	262	S2    
23653	262	S2    
23654	262	S2    
23655	262	S2    
23656	262	S2    
23657	262	S2    
23658	262	S2    
23659	262	S2    
23660	262	S2    
01103	263	S1163 
01202	263	S1163 
07002	263	S222  
07083	263	S281  
07276	263	S259  
07276	263	S281  
07277	263	S259  
07278	263	S259  
07906	263	S281  
07908	263	S281  
07909	263	S259  
07910	263	S245  
07911	263	S226  
07912	263	S226  
07913	263	S238  
07914	263	S252  
07915	263	S281  
07916	263	S242  
07917	263	S242  
07918	263	S242  
07919	263	S252  
07920	263	S242  
07921	263	S228  
07922	263	S242  
07923	263	S245  
07924	263	S242  
07925	263	S281  
07926	263	S228  
07927	263	S227  
07928	263	S225  
07929	263	S227  
07930	263	S222  
07931	263	S222  
07932	263	S224  
07933	263	S224  
07934	263	S281  
07935	263	S224  
07936	263	S247  
07937	263	S239  
07938	263	S233  
07939	263	S235  
07940	263	S237  
07941	263	S281  
07943	263	S281  
07944	263	S227  
13067	263	S2    
13070	263	S2    
13096	263	S2    
13098	263	S2    
13165	263	S2    
13343	263	S2    
13369	263	S2    
13370	263	S2    
13373	263	S2    
13375	263	S2    
13377	263	S2    
13378	263	S2    
13391	263	S2    
13394	263	S2    
13398	263	S2    
13399	263	S2    
13401	263	S2    
13402	263	S2    
13404	263	S2    
13405	263	S2    
13407	263	S2    
13408	263	S2    
13410	263	S2    
13411	263	S2    
13413	263	S2    
13414	263	S2    
13415	263	S2    
13416	263	S2    
13417	263	S2    
13418	263	S2    
13419	263	S2    
13420	263	S2    
13422	263	S2    
13423	263	S2    
13424	263	S2    
13425	263	S2    
13426	263	S2    
13439	263	S2    
13440	263	S2    
13441	263	S2    
13442	263	S2    
13443	263	S2    
13444	263	S2    
13445	263	S2    
13446	263	S2    
13447	263	S2    
13448	263	S2    
13449	263	S2    
13450	263	S2    
13451	263	S2    
13452	263	S2    
13453	263	S2    
13455	263	S2    
13456	263	S2    
13485	263	S2    
13486	263	S2    
13487	263	S2    
13488	263	S2    
13490	263	S2    
13491	263	S2    
13492	263	S2    
13493	263	S2    
13805	263	S2    
13806	263	S2    
13809	263	S2    
13811	263	S2    
13813	263	S2    
13850	263	S2    
13853	263	S2    
13854	263	S2    
13856	263	S2    
13857	263	S2    
13868	263	S2    
13870	263	S2    
13871	263	S2    
13873	263	S2    
13874	263	S2    
13875	263	S2    
13876	263	S2    
13877	263	S2    
13879	263	S2    
13880	263	S2    
13881	263	S2    
13882	263	S2    
13891	263	S2    
13894	263	S2    
13896	263	S2    
13898	263	S2    
13900	263	S2    
13909	263	S2    
13911	263	S2    
13912	263	S2    
13913	263	S2    
13914	263	S2    
13917	263	S2    
13920	263	S2    
13921	263	S2    
13923	263	S2    
13924	263	S2    
13929	263	S2    
13931	263	S2    
13932	263	S2    
13934	263	S2    
13935	263	S2    
13948	263	S2    
13949	263	S2    
13950	263	S2    
13951	263	S2    
13952	263	S2    
13953	263	S2    
13954	263	S2    
13955	263	S2    
13956	263	S2    
13957	263	S2    
13958	263	S2    
13959	263	S2    
13968	263	S2    
13969	263	S2    
13970	263	S2    
13971	263	S2    
13985	263	S2    
14137	263	S1068 
14144	263	S1068 
14145	263	S1068 
14146	263	S1068 
14147	263	S1068 
14148	263	S1068 
14149	263	S1068 
14366	263	S2104 
14370	263	S2104 
14400	263	S1068 
14416	263	S1068 
14475	263	S1068 
14476	263	S1068 
14601	263	S1066 
19064	263	S1164 
19076	263	S1164 
19078	263	S1069 
19109	263	S1164 
19120	263	S1069 
19155	263	S1164 
23582	263	S2    
23583	263	S2    
23585	263	S2    
23586	263	S2    
23587	263	S2    
23589	263	S2    
23590	263	S2    
23591	263	S2    
23592	263	S2    
23593	263	S2    
23594	263	S2    
23595	263	S2    
23596	263	S2    
23597	263	S2    
23599	263	S2    
23601	263	S2    
23603	263	S2    
23604	263	S2    
23607	263	S2    
23609	263	S2    
23613	263	S2    
23615	263	S2    
23616	263	S2    
23618	263	S2    
23619	263	S2    
23620	263	S2    
23623	263	S2    
23624	263	S2    
23626	263	S2    
23627	263	S2    
23628	263	S2    
23630	263	S2    
23631	263	S2    
23632	263	S2    
23634	263	S2    
23635	263	S2    
23636	263	S2    
23637	263	S2    
23646	263	S2    
23647	263	S2    
23648	263	S2    
23649	263	S2    
23650	263	S2    
23651	263	S2    
23652	263	S2    
23653	263	S2    
23654	263	S2    
23655	263	S2    
23656	263	S2    
23657	263	S2    
23658	263	S2    
23659	263	S2    
23660	263	S2    
07056	268	S248  
01026	269	S25   
01026	269	S606  
01032	269	S19   
01077	269	S27   
01079	269	S1063 
01079	269	S20   
01082	269	S1063 
01085	269	S1063 
01123	269	S1063 
01123	269	S561  
01124	269	S1065 
01125	269	S1065 
02003	269	S1069 
02009	269	S1069 
02010	269	S1069 
02011	269	S1069 
02014	269	D4682 
02015	269	S1069 
02021	269	S1069 
02024	269	S1069 
02027	269	S1069 
02028	269	S1069 
02029	269	S1069 
02030	269	S1069 
02043	269	S1069 
02044	269	S1069 
04017	269	S19   
04021	269	S19   
04023	269	S19   
04114	269	S19   
04120	269	S19   
04141	269	S19   
04143	269	S19   
04144	269	S19   
04635	269	S19   
04636	269	S19   
04638	269	S26   
04639	269	S26   
04640	269	S26   
04641	269	S25   
04673	269	S2401 
04674	269	S2401 
04675	269	S2401 
04676	269	S2401 
04677	269	S2401 
06016	269	S18   
06019	269	S18   
06043	269	S18   
06094	269	S18   
06128	269	S18   
06159	269	S18   
06982	269	S18   
06983	269	S18   
06984	269	S2104 
06985	269	S2104 
07002	269	S222  
07004	269	S248  
07005	269	S248  
07008	269	S238  
07011	269	S227  
07013	269	S242  
07015	269	S248  
07016	269	S248  
07018	269	S226  
07023	269	S242  
07052	269	S227  
07057	269	S238  
07068	269	S1041 
07076	269	S239  
07078	269	S228  
07079	269	S227  
07080	269	S227  
07083	269	S281  
07089	269	S241  
07089	269	S251  
07278	269	S259  
07279	269	S259  
07906	269	S281  
07908	269	S281  
07909	269	S259  
07910	269	S245  
07911	269	S226  
07912	269	S226  
07913	269	S238  
07914	269	S252  
07915	269	S281  
07916	269	S242  
07917	269	S242  
07918	269	S242  
07919	269	S252  
07920	269	S242  
07921	269	S228  
07922	269	S242  
07923	269	S245  
07924	269	S242  
07925	269	S281  
07926	269	S228  
07927	269	S227  
07928	269	S225  
07929	269	S227  
07930	269	S222  
07931	269	S222  
07932	269	S224  
07933	269	S224  
07934	269	S281  
07935	269	S224  
07936	269	S247  
07937	269	S239  
07938	269	S233  
07939	269	S235  
07940	269	S237  
07941	269	S281  
07943	269	S281  
07944	269	S227  
08003	269	S2664 
08005	269	S2664 
08018	269	S702  
08023	269	S2664 
08025	269	S2662 
08028	269	S2664 
08031	269	S2664 
08032	269	S2664 
08058	269	S2664 
08059	269	S702  
08060	269	S2664 
08065	269	S2662 
08067	269	S2664 
08068	269	S2664 
08069	269	S2664 
08071	269	S2664 
08074	269	S2662 
08083	269	S2502 
08092	269	S702  
08094	269	S702  
08116	269	S2502 
08124	269	S702  
08128	269	S702  
08130	269	S702  
08138	269	S2502 
08147	269	S2422 
08177	269	S2502 
08189	269	S2664 
08200	269	S702  
08206	269	S2502 
08211	269	S702  
08217	269	S2664 
08219	269	S702  
08221	269	S702  
08225	269	S702  
08229	269	S702  
08231	269	S702  
08232	269	S702  
08245	269	S603  
08253	269	S2664 
08258	269	S2664 
08259	269	S2662 
08262	269	S603  
08271	269	S603  
08274	269	S603  
08283	269	S2664 
08284	269	S2664 
08286	269	S2664 
08287	269	S2664 
08288	269	S2664 
08289	269	S2664 
08309	269	S2664 
08315	269	S702  
08316	269	S702  
08317	269	S702  
08318	269	S2664 
08319	269	S2664 
08346	269	S2502 
08347	269	S2502 
08348	269	S2502 
08349	269	S2502 
08350	269	S2502 
08352	269	S702  
08357	269	S702  
08374	269	S2664 
08376	269	S2664 
08378	269	S2161 
08379	269	S2664 
08380	269	S2664 
08383	269	S2664 
08384	269	S2664 
08385	269	S2664 
08386	269	S2664 
08387	269	S2664 
08388	269	S2664 
08389	269	S2664 
08390	269	S2664 
08391	269	S682  
08392	269	S2664 
08393	269	S2664 
08399	269	S603  
08400	269	S881  
08401	269	S881  
08402	269	S702  
08403	269	S1209 
08408	269	S2502 
08409	269	S2502 
08410	269	S702  
08411	269	S702  
08412	269	S702  
08413	269	S702  
08414	269	S702  
08415	269	S702  
08416	269	S702  
08417	269	S702  
08418	269	S702  
08419	269	S702  
08420	269	S702  
08421	269	S702  
08422	269	S702  
08446	269	S702  
08448	269	S702  
08449	269	S702  
08454	269	S2664 
08455	269	S2664 
08456	269	S2664 
08457	269	S2664 
08458	269	S2664 
08459	269	S2664 
08460	269	S2664 
08461	269	S2664 
08462	269	S2664 
08463	269	S2664 
08464	269	S2664 
08465	269	S2664 
08466	269	S2664 
08467	269	S2161 
08468	269	S2664 
08469	269	S2664 
08470	269	S2664 
08471	269	S2664 
08472	269	S2664 
08473	269	S2664 
08474	269	S2664 
08476	269	S2502 
08478	269	S2502 
08481	269	S2502 
08482	269	S2502 
08483	269	S2502 
08484	269	S2502 
08487	269	S2502 
08488	269	S2502 
08489	269	S2502 
08490	269	S2502 
08491	269	S2502 
08492	269	S2502 
08493	269	S2502 
08494	269	S2502 
08495	269	S2502 
08497	269	S2502 
08498	269	S2502 
08500	269	S2502 
08501	269	S2502 
08504	269	S2662 
08505	269	S2662 
08506	269	S2662 
08507	269	S2662 
08508	269	S2662 
08509	269	S2662 
09003	269	S502  
09003	269	S561  
09004	269	S502  
09032	269	S21   
09037	269	S1621 
09037	269	S481  
09037	269	S502  
09037	269	S837  
09038	269	S1621 
09038	269	S481  
09038	269	S502  
09038	269	S837  
09039	269	S837  
09040	269	S481  
09040	269	S562  
09042	269	S461  
09042	269	S566  
09050	269	S421  
09050	269	S441  
09078	269	S561  
09079	269	S1701 
09087	269	S564  
09087	269	S582  
09094	269	S363  
09094	269	S582  
09112	269	S482  
09112	269	S563  
09132	269	S1062 
09148	269	S363  
09148	269	S582  
09160	269	S1065 
09184	269	S562  
09184	269	S565  
09191	269	S421  
09191	269	S582  
09202	269	S482  
09202	269	S564  
09202	269	S837  
09218	269	S1065 
09218	269	S606  
09236	269	S461  
09236	269	S582  
09252	269	S482  
09252	269	S541  
09263	269	D4941 
09263	269	S606  
09266	269	S441  
09266	269	S561  
09268	269	D3315 
09270	269	D3315 
09273	269	S2104 
09279	269	S421  
09279	269	S582  
09291	269	D3315 
09291	269	S566  
09291	269	S606  
09291	269	S837  
09298	269	D3315 
09298	269	S564  
09298	269	S566  
09298	269	S837  
09302	269	S461  
09302	269	S566  
09326	269	S441  
09326	269	S461  
09326	269	S837  
09409	269	S2104 
09421	269	S564  
09421	269	S582  
09427	269	D4053 
09428	269	D4053 
09429	269	S441  
09430	269	S441  
09430	269	S561  
09433	269	S2105 
11008	269	S565  
11011	269	D3326 
11038	269	S837  
11090	269	S564  
11090	269	S606  
11090	269	S837  
11091	269	S564  
11091	269	S837  
11096	269	S1121 
11109	269	S606  
11109	269	S837  
11112	269	D3326 
11131	269	S25   
11143	269	S564  
11179	269	S837  
11209	269	D3326 
11251	269	S503  
11252	269	S562  
11252	269	S837  
11260	269	S2941 
11260	269	S606  
11260	269	S80   
11263	269	S2941 
11267	269	S2941 
11282	269	S837  
11333	269	D3326 
11333	269	S837  
11352	269	S563  
11353	269	S563  
11355	269	S563  
11357	269	S563  
11359	269	S2105 
11360	269	S2105 
11394	269	S2105 
11395	269	S2105 
11398	269	S2105 
11399	269	S2105 
11402	269	S2105 
11403	269	S2105 
11411	269	S2105 
11412	269	S2105 
11429	269	S363  
11457	269	D3326 
11457	269	S606  
11457	269	S837  
11463	269	S25   
11464	269	S25   
11468	269	D3326 
11507	269	S606  
11508	269	S606  
11529	269	D3326 
11529	269	S503  
11529	269	S837  
11674	269	S563  
11702	269	S565  
11742	269	S564  
11742	269	S837  
11760	269	S25   
11812	269	S625  
11812	269	S626  
11812	269	S627  
11812	269	S641  
11828	269	S563  
11841	269	S2105 
11842	269	S2105 
11856	269	S25   
11875	269	S606  
11887	269	S5    
11887	269	S625  
11887	269	S626  
11887	269	S627  
11887	269	S641  
11950	269	S2941 
11960	269	S562  
11992	269	S2941 
12023	269	S606  
12038	269	S606  
12038	269	S661  
12038	269	S961  
12078	269	S1063 
12078	269	S503  
12086	269	S343  
12086	269	S363  
12086	269	S502  
12087	269	S343  
12147	269	S564  
12151	269	S101  
12151	269	S86   
12152	269	S101  
12152	269	S86   
12154	269	S941  
12201	269	S1164 
12201	269	S606  
12538	269	S606  
12538	269	S661  
12538	269	S961  
12586	269	S343  
12586	269	S363  
12586	269	S502  
12652	269	S101  
12652	269	S86   
13067	269	S2    
13070	269	S2    
13096	269	S2    
13098	269	S2    
13165	269	S2    
13343	269	S2    
13369	269	S2    
13370	269	S2    
13373	269	S2    
13375	269	S2    
13377	269	S2    
13378	269	S2    
13391	269	S2    
13394	269	S2    
13398	269	S2    
13399	269	S2    
13401	269	S2    
13402	269	S2    
13404	269	S2    
13405	269	S2    
13407	269	S2    
13408	269	S2    
13410	269	S2    
13411	269	S2    
13413	269	S2    
13414	269	S2    
13415	269	S2    
13416	269	S2    
13417	269	S2    
13418	269	S2    
13419	269	S2    
13420	269	S2    
13422	269	S2    
13423	269	S2    
13424	269	S2    
13425	269	S2    
13426	269	S2    
13439	269	S2    
13440	269	S2    
13441	269	S2    
13442	269	S2    
13443	269	S2    
13444	269	S2    
13445	269	S2    
13446	269	S2    
13447	269	S2    
13448	269	S2    
13449	269	S2    
13450	269	S2    
13451	269	S2    
13452	269	S2    
13453	269	S2    
13455	269	S2    
13456	269	S2    
13485	269	S2    
13486	269	S2    
13487	269	S2    
13488	269	S2    
13490	269	S2    
13491	269	S2    
13492	269	S2    
13493	269	S2    
13805	269	S2    
13806	269	S2    
13809	269	S2    
13811	269	S2    
13813	269	S2    
13850	269	S2    
13853	269	S2    
13854	269	S2    
13856	269	S2    
13857	269	S2    
13868	269	S2    
13870	269	S2    
13871	269	S2    
13873	269	S2    
13874	269	S2    
13875	269	S2    
13876	269	S2    
13877	269	S2    
13879	269	S2    
13880	269	S2    
13881	269	S2    
13882	269	S2    
13891	269	S2    
13894	269	S2    
13896	269	S2    
13898	269	S2    
13900	269	S2    
13909	269	S2    
13911	269	S2    
13912	269	S2    
13913	269	S2    
13914	269	S2    
13917	269	S2    
13920	269	S2    
13921	269	S2    
13923	269	S2    
13924	269	S2    
13929	269	S2    
13931	269	S2    
13932	269	S2    
13934	269	S2    
13935	269	S2    
13948	269	S2    
13949	269	S2    
13950	269	S2    
13951	269	S2    
13952	269	S2    
13953	269	S2    
13954	269	S2    
13955	269	S2    
13956	269	S2    
13957	269	S2    
13958	269	S2    
13959	269	S2    
13968	269	S2    
13969	269	S2    
13970	269	S2    
13971	269	S2    
14003	269	S2103 
14006	269	S2103 
14084	269	S2103 
14096	269	S2103 
14106	269	S2103 
14137	269	S1068 
14144	269	S1068 
14145	269	S1064 
14145	269	S1068 
14147	269	S1068 
14148	269	S1068 
14154	269	S2702 
14181	269	S5    
14209	269	S23   
14238	269	S2104 
14242	269	S2104 
14267	269	D657  
14323	269	S1067 
14347	269	S1064 
14366	269	S2104 
14370	269	S2104 
14416	269	S1064 
14475	269	S1068 
14476	269	S1068 
14602	269	S2103 
15027	269	S1163 
16006	269	S1164 
16010	269	S1164 
16010	269	S606  
16011	269	S1164 
16011	269	S606  
16029	269	S1164 
16037	269	S1164 
16038	269	S1164 
16089	269	S563  
16097	269	S22   
16098	269	S22   
16098	269	S837  
16147	269	S2104 
16338	269	S1164 
16397	269	S22   
16398	269	S22   
16398	269	S837  
18001	269	S1162 
18002	269	S1162 
18069	269	S20   
18079	269	S25   
18159	269	S21   
18166	269	S25   
18168	269	S25   
18258	269	S1162 
18259	269	S1162 
18262	269	S1162 
18263	269	S1162 
18288	269	S27   
18350	269	S21   
18351	269	S21   
18352	269	S21   
18365	269	S27   
18376	269	S25   
18403	269	S27   
18416	269	S20   
18932	269	S27   
18933	269	S27   
18934	269	S27   
18935	269	S27   
18936	269	S27   
19003	269	S26   
19034	269	S26   
19035	269	S26   
19047	269	S1162 
19056	269	S26   
19058	269	S2109 
19064	269	S1164 
19076	269	S1164 
19078	269	S1069 
19080	269	S5    
19095	269	S1067 
19109	269	S1164 
19120	269	S1069 
19155	269	S1164 
19300	269	S5    
19304	269	D3296 
19350	269	S1164 
19411	269	S26   
20010	269	S604  
20045	269	S1164 
20049	269	S20   
20081	269	S20   
20081	269	S606  
20081	269	S837  
20082	269	S606  
20099	269	S20   
20099	269	S606  
20100	269	S20   
20100	269	S606  
20100	269	S837  
20109	269	S2105 
20109	269	S606  
20110	269	S2105 
20110	269	S606  
20120	269	S20   
20120	269	S606  
20121	269	S20   
20121	269	S606  
20121	269	S837  
20310	269	S2105 
20310	269	S606  
20321	269	S20   
20321	269	S606  
20321	269	S837  
20400	269	S20   
20400	269	S606  
20400	269	S837  
20409	269	S2105 
20409	269	S606  
20410	269	S2105 
20410	269	S606  
20420	269	S20   
20420	269	S606  
20421	269	S20   
20421	269	S606  
20421	269	S837  
20499	269	S20   
20499	269	S606  
20510	269	S2105 
20510	269	S606  
20521	269	S20   
20521	269	S606  
20521	269	S837  
20581	269	S20   
20581	269	S606  
20581	269	S837  
20623	269	S1742 
20624	269	S1742 
20628	269	S1742 
20629	269	S1742 
20630	269	S1742 
20634	269	S1742 
20635	269	S1742 
20636	269	S1742 
20640	269	S1742 
20641	269	S1742 
20645	269	S1742 
20646	269	S1742 
21138	269	S1064 
21141	269	S1064 
21238	269	S2801 
21249	269	S1064 
21250	269	S1064 
21251	269	S1064 
21252	269	S1064 
21253	269	S1064 
21254	269	S1064 
21255	269	S1064 
21256	269	S1064 
21257	269	S1064 
21259	269	S1064 
21271	269	S2108 
21272	269	S2108 
21273	269	S2108 
21274	269	S2108 
21275	269	S2108 
21276	269	S2108 
21277	269	S2110 
21278	269	S2110 
21279	269	S2110 
21280	269	S2110 
21281	269	S2110 
21282	269	S2110 
21283	269	S2111 
21284	269	S2111 
21285	269	S2111 
21286	269	S2111 
21287	269	S2112 
21288	269	S2112 
21289	269	S2112 
21290	269	S2112 
21291	269	S2112 
21292	269	S2112 
21293	269	S2782 
21294	269	S2782 
21295	269	S2782 
21296	269	S2782 
21297	269	S2782 
21298	269	S2782 
21299	269	S2110 
21299	269	S2111 
21299	269	S2112 
21299	269	S2782 
21300	269	S2110 
21300	269	S2112 
21300	269	S2782 
21301	269	S2110 
21301	269	S2111 
21301	269	S2112 
21301	269	S2782 
21302	269	S2110 
21302	269	S2111 
21302	269	S2112 
21302	269	S2782 
21303	269	S2110 
21303	269	S2112 
21303	269	S2782 
21304	269	S2110 
21304	269	S2111 
21304	269	S2112 
21304	269	S2782 
21308	269	S2801 
21310	269	S2801 
21311	269	S2801 
21312	269	S2801 
21313	269	S2801 
21314	269	S2801 
21315	269	S2801 
21316	269	S2801 
21317	269	S2801 
21318	269	S2801 
21319	269	S2801 
21320	269	S2801 
21321	269	S2801 
21322	269	S2801 
21323	269	S2801 
21324	269	S2801 
21325	269	S2801 
21326	269	S2801 
21337	269	S2801 
21342	269	S2801 
21343	269	S2801 
21346	269	S2801 
21347	269	S2801 
21348	269	S2801 
21349	269	S2801 
22247	269	S20   
23582	269	S2    
23583	269	S2    
23585	269	S2    
23586	269	S2    
23587	269	S2    
23589	269	S2    
23590	269	S2    
23591	269	S2    
23592	269	S2    
23593	269	S2    
23594	269	S2    
23595	269	S2    
23596	269	S2    
23597	269	S2    
23599	269	S2    
23601	269	S2    
23603	269	S2    
23604	269	S2    
23607	269	S2    
23609	269	S2    
23613	269	S2    
23615	269	S2    
23616	269	S2    
23618	269	S2    
23619	269	S2    
23620	269	S2    
23623	269	S2    
23624	269	S2    
23626	269	S2    
23627	269	S2    
23628	269	S2    
23630	269	S2    
23631	269	S2    
23632	269	S2    
23634	269	S2    
23635	269	S2    
23636	269	S2    
23637	269	S2    
23646	269	S2    
23647	269	S2    
23648	269	S2    
23649	269	S2    
23650	269	S2    
23651	269	S2    
23652	269	S2    
23653	269	S2    
23654	269	S2    
23655	269	S2    
23656	269	S2    
23657	269	S2    
23658	269	S2    
23659	269	S2    
23660	269	S2    
35130	269	S2381 
35131	269	S2381 
35132	269	S2381 
35133	269	S2381 
35134	269	S2381 
35135	269	S2381 
35136	269	S2381 
35137	269	S2381 
35139	269	S2381 
35140	269	S2381 
35142	269	S2381 
35143	269	S2381 
35144	269	S2381 
35145	269	S2381 
35146	269	S2381 
35147	269	S2381 
35148	269	S2381 
43215	269	S26   
43329	269	S25   
43364	269	S26   
01026	287	S25   
01032	287	S19   
01077	287	S27   
01079	287	S1063 
01079	287	S20   
01082	287	S1063 
01085	287	S1063 
01123	287	S1063 
01123	287	S561  
01124	287	S1065 
01125	287	S1065 
02003	287	S1069 
02009	287	S1069 
02010	287	S1069 
02011	287	S1069 
02015	287	S1069 
02021	287	S1069 
02024	287	S1069 
02027	287	S1069 
02028	287	S1069 
02029	287	S1069 
02043	287	S1069 
04017	287	S19   
04021	287	S19   
04023	287	S19   
04114	287	S19   
04120	287	S19   
04141	287	S19   
04143	287	S19   
04144	287	S19   
04635	287	S19   
04636	287	S19   
04638	287	S26   
04639	287	S26   
04640	287	S26   
04641	287	S25   
06016	287	S18   
06019	287	S18   
06128	287	S18   
06159	287	S18   
06982	287	S18   
06983	287	S18   
06984	287	S2104 
06985	287	S2104 
07022	287	S21   
07945	287	S21   
08025	287	S2662 
08065	287	S2662 
08074	287	S2662 
08259	287	S2662 
08504	287	S2662 
08505	287	S2662 
08506	287	S2662 
08507	287	S2662 
08508	287	S2662 
08509	287	S2662 
09003	287	S502  
09003	287	S561  
09004	287	S502  
09032	287	S21   
09037	287	S481  
09037	287	S502  
09038	287	S481  
09038	287	S502  
09040	287	S481  
09040	287	S562  
09042	287	S461  
09042	287	S566  
09050	287	S421  
09050	287	S441  
09070	287	S582  
09078	287	S561  
09087	287	S564  
09087	287	S582  
09094	287	S363  
09094	287	S582  
09112	287	S482  
09112	287	S563  
09132	287	S1062 
09148	287	S363  
09148	287	S582  
09160	287	S1065 
09181	287	S1121 
09181	287	S461  
09184	287	S562  
09184	287	S565  
09191	287	S421  
09191	287	S582  
09202	287	S482  
09202	287	S564  
09218	287	S1065 
09236	287	S461  
09236	287	S582  
09252	287	S482  
09252	287	S541  
09266	287	S441  
09266	287	S561  
09273	287	S2104 
09279	287	S421  
09279	287	S582  
09291	287	S566  
09298	287	S564  
09298	287	S566  
09302	287	S461  
09302	287	S566  
09316	287	S421  
09316	287	S566  
09326	287	S441  
09326	287	S461  
09409	287	S2104 
09421	287	S564  
09421	287	S582  
09427	287	D4053 
09428	287	D4053 
09429	287	S441  
09430	287	S441  
09430	287	S561  
09433	287	S2105 
11090	287	D3305 
11090	287	S564  
11091	287	S564  
11096	287	S1121 
11130	287	S25   
11131	287	S25   
11143	287	S564  
11243	287	S2941 
11250	287	S562  
11251	287	S503  
11252	287	S562  
11253	287	S541  
11257	287	S541  
11260	287	S2941 
11263	287	S2941 
11267	287	S2941 
11294	287	S563  
11352	287	S563  
11353	287	S563  
11354	287	S563  
11355	287	S563  
11356	287	S563  
11357	287	S563  
11358	287	S563  
11359	287	S2105 
11360	287	S2105 
11394	287	S2105 
11395	287	S2105 
11398	287	S2105 
11399	287	S2105 
11402	287	S2105 
11403	287	S2105 
11411	287	S2105 
11412	287	S2105 
11429	287	S363  
11463	287	S25   
11464	287	S25   
11529	287	S503  
11674	287	S563  
11742	287	S564  
11760	287	S25   
11828	287	S563  
11841	287	S2105 
11842	287	S2105 
11856	287	S25   
11950	287	S2941 
11960	287	S562  
11987	287	S2941 
11992	287	S2941 
12078	287	S1063 
12078	287	S503  
12086	287	S363  
12086	287	S502  
12147	287	S564  
12201	287	S1164 
12586	287	S363  
12586	287	S502  
14003	287	S2103 
14006	287	S2103 
14209	287	S23   
14242	287	S2104 
15027	287	S1163 
16006	287	S1164 
16010	287	S1164 
16011	287	S1164 
16029	287	S1164 
16037	287	S1164 
16038	287	S1164 
16089	287	S563  
16097	287	S22   
16098	287	S22   
16147	287	S2104 
16338	287	S1164 
16397	287	S22   
16398	287	S22   
18001	287	S1162 
18002	287	S1162 
18069	287	S20   
18079	287	S25   
18159	287	S21   
18166	287	S25   
18168	287	S25   
18215	287	S25   
18231	287	S25   
18258	287	S1162 
18259	287	S1162 
18288	287	S27   
18350	287	S21   
18363	287	S22   
18364	287	S22   
18365	287	S27   
18376	287	S25   
18403	287	S27   
18927	287	S25   
18932	287	S27   
18933	287	S27   
18934	287	S27   
18935	287	S27   
18936	287	S27   
19003	287	S26   
19034	287	S26   
19035	287	S26   
19047	287	S1162 
19056	287	S26   
19057	287	S2109 
19058	287	S2109 
19064	287	S1164 
19109	287	S1164 
19155	287	S1164 
19296	287	D3342 
20109	287	S2105 
20110	287	S2105 
20310	287	S2105 
20409	287	S2105 
20410	287	S2105 
20510	287	S2105 
20623	287	S1742 
20624	287	S1742 
20628	287	S1742 
20629	287	S1742 
20630	287	S1742 
20634	287	S1742 
20635	287	S1742 
20636	287	S1742 
20640	287	S1742 
20641	287	S1742 
20645	287	S1742 
20646	287	S1742 
21141	287	S1064 
21226	287	S22   
21227	287	S22   
21238	287	S2801 
21249	287	S1064 
21250	287	S1064 
21251	287	S1064 
21252	287	S1064 
21253	287	S1064 
21254	287	S1064 
21255	287	S1064 
21256	287	S1064 
21257	287	S1064 
21259	287	S1064 
21271	287	S2108 
21272	287	S2108 
21273	287	S2108 
21274	287	S2108 
21275	287	S2108 
21276	287	S2108 
21277	287	S2110 
21278	287	S2110 
21279	287	S2110 
21280	287	S2110 
21281	287	S2110 
21282	287	S2110 
21283	287	S2111 
21284	287	S2111 
21285	287	S2111 
21286	287	S2111 
21287	287	S2112 
21288	287	S2112 
21289	287	S2112 
21290	287	S2112 
21291	287	S2112 
21292	287	S2112 
21293	287	S2782 
21294	287	S2782 
21295	287	S2782 
21296	287	S2782 
21297	287	S2782 
21298	287	S2782 
21299	287	S2110 
21299	287	S2111 
21299	287	S2112 
21299	287	S2782 
21300	287	S2110 
21300	287	S2112 
21300	287	S2782 
21301	287	S2110 
21301	287	S2111 
21301	287	S2112 
21301	287	S2782 
21302	287	S2110 
21302	287	S2111 
21302	287	S2112 
21302	287	S2782 
21303	287	S2110 
21303	287	S2112 
21303	287	S2782 
21304	287	S2110 
21304	287	S2111 
21304	287	S2112 
21304	287	S2782 
21308	287	S2801 
21310	287	S2801 
21311	287	S2801 
21312	287	S2801 
21313	287	S2801 
21314	287	S2801 
21315	287	S2801 
21316	287	S2801 
21317	287	S2801 
21318	287	S2801 
21319	287	S2801 
21320	287	S2801 
21321	287	S2801 
21322	287	S2801 
21323	287	S2801 
21324	287	S2801 
21325	287	S2801 
21326	287	S2801 
21337	287	S2801 
21342	287	S2801 
21343	287	S2801 
22247	287	S20   
22909	287	S22   
35130	287	S2381 
35131	287	S2381 
35132	287	S2381 
35133	287	S2381 
35134	287	S2381 
35135	287	S2381 
35136	287	S2381 
35137	287	S2381 
35138	287	S2381 
35139	287	S2381 
35140	287	S2381 
35142	287	S2381 
35143	287	S2381 
35144	287	S2381 
35145	287	S2381 
35146	287	S2381 
35147	287	S2381 
35148	287	S2381 
43215	287	S26   
43364	287	S26   
01103	291	S1163 
01123	291	S1063 
01202	291	S1163 
02028	291	S1069 
04017	291	S19   
04020	291	S19   
04021	291	S19   
04023	291	S19   
04114	291	S19   
04120	291	S19   
04141	291	S19   
04142	291	S19   
04143	291	S19   
04144	291	S19   
04367	291	S19   
04635	291	S19   
04636	291	S19   
04639	291	S26   
04640	291	S26   
04673	291	S2401 
04674	291	S2401 
04675	291	S2401 
04676	291	S2401 
04677	291	S2401 
05312	291	S26   
05313	291	S26   
05320	291	S26   
06016	291	S18   
06019	291	S18   
06043	291	S18   
06094	291	S18   
06128	291	S18   
06159	291	S18   
06931	291	S22   
06982	291	S18   
06983	291	S18   
06984	291	S2104 
06985	291	S2104 
07002	291	S222  
07005	291	S248  
07006	291	S247  
07008	291	S238  
07011	291	S227  
07013	291	S242  
07015	291	S248  
07016	291	S248  
07018	291	S226  
07039	291	S244  
07052	291	S227  
07056	291	S248  
07057	291	S235  
07057	291	S238  
07068	291	S1041 
07070	291	S238  
07076	291	S239  
07078	291	S228  
07079	291	S227  
07080	291	S227  
07089	291	S241  
07089	291	S251  
07277	291	S259  
07278	291	S259  
07279	291	S259  
07906	291	S281  
07908	291	S281  
07909	291	S259  
07910	291	S245  
07911	291	S226  
07912	291	S226  
07913	291	S238  
07914	291	S252  
07915	291	S281  
07916	291	S242  
07917	291	S242  
07918	291	S242  
07919	291	S252  
07920	291	S242  
07921	291	S228  
07922	291	S242  
07923	291	S245  
07924	291	S242  
07925	291	S281  
07926	291	S228  
07927	291	S227  
07928	291	S225  
07929	291	S227  
07930	291	S222  
07931	291	S222  
07932	291	S224  
07933	291	S224  
07934	291	S281  
07935	291	S224  
07936	291	S247  
07937	291	S239  
07938	291	S233  
07939	291	S235  
07940	291	S237  
07941	291	S281  
07943	291	S281  
07944	291	S227  
07951	291	S243  
08001	291	S1065 
08003	291	S2664 
08005	291	S2664 
08010	291	S702  
08011	291	S702  
08012	291	S1065 
08013	291	S1065 
08014	291	S1065 
08017	291	S603  
08018	291	S702  
08019	291	S603  
08020	291	S1065 
08023	291	S2664 
08025	291	S2662 
08026	291	S603  
08028	291	S2664 
08030	291	S1065 
08031	291	S2664 
08032	291	S2664 
08035	291	S603  
08045	291	S603  
08047	291	S702  
08048	291	S603  
08049	291	S702  
08050	291	S603  
08054	291	S702  
08057	291	S603  
08058	291	S2664 
08059	291	S702  
08060	291	S2664 
08061	291	S1065 
08064	291	S603  
08065	291	S1065 
08065	291	S2662 
08066	291	S702  
08067	291	S2664 
08068	291	S2664 
08069	291	S2664 
08071	291	S2664 
08074	291	S2662 
08077	291	S1065 
08078	291	S603  
08082	291	S603  
08083	291	S2502 
08085	291	S702  
08086	291	S603  
08087	291	S603  
08089	291	S603  
08092	291	S702  
08094	291	S702  
08116	291	S2502 
08120	291	D3771 
08124	291	S702  
08128	291	S702  
08130	291	S702  
08138	291	S2502 
08139	291	S603  
08146	291	S702  
08147	291	S1065 
08147	291	S2422 
08177	291	S2502 
08189	291	S2664 
08190	291	S603  
08194	291	S603  
08200	291	S702  
08202	291	S603  
08206	291	S2502 
08210	291	S702  
08211	291	S702  
08212	291	S702  
08214	291	S702  
08215	291	S702  
08216	291	S702  
08217	291	S2664 
08218	291	S1065 
08219	291	S702  
08220	291	S702  
08221	291	S702  
08225	291	S702  
08229	291	S702  
08231	291	S702  
08232	291	S702  
08243	291	S603  
08244	291	S603  
08245	291	S603  
08247	291	S603  
08253	291	S2664 
08258	291	S2664 
08259	291	S2662 
08262	291	S603  
08263	291	S603  
08266	291	S603  
08267	291	S603  
08268	291	S603  
08269	291	S603  
08270	291	S603  
08271	291	S603  
08272	291	S603  
08273	291	S603  
08274	291	S603  
08277	291	S603  
08278	291	S603  
08283	291	S2664 
08284	291	S2664 
08286	291	S2664 
08287	291	S2664 
08288	291	S2664 
08289	291	S2664 
08293	291	S702  
08294	291	S702  
08299	291	S702  
08309	291	S2664 
08315	291	S702  
08316	291	S702  
08317	291	S702  
08318	291	S2664 
08319	291	S2664 
08345	291	S603  
08346	291	S2502 
08347	291	S2502 
08348	291	S2502 
08349	291	S2502 
08350	291	S2502 
08351	291	S702  
08352	291	S702  
08353	291	S702  
08354	291	S702  
08355	291	S702  
08357	291	S702  
08358	291	S702  
08359	291	S702  
08360	291	S702  
08361	291	S702  
08362	291	S702  
08363	291	S702  
08364	291	S702  
08366	291	S702  
08367	291	S603  
08368	291	S603  
08370	291	S603  
08371	291	S603  
08372	291	S603  
08374	291	S2664 
08376	291	S2664 
08378	291	S2161 
08379	291	S2664 
08380	291	S2664 
08383	291	S2664 
08384	291	S2664 
08385	291	S2664 
08386	291	S2664 
08387	291	S2664 
08388	291	S2664 
08389	291	S2664 
08390	291	S2664 
08391	291	S682  
08392	291	S2664 
08393	291	S2664 
08394	291	S702  
08395	291	S702  
08396	291	S702  
08397	291	S603  
08398	291	S603  
08399	291	S603  
08400	291	S881  
08401	291	S881  
08402	291	S702  
08403	291	S1209 
08408	291	S2502 
08409	291	S2502 
08410	291	S702  
08411	291	S702  
08412	291	S702  
08413	291	S702  
08414	291	S702  
08415	291	S702  
08416	291	S702  
08417	291	S702  
08418	291	S702  
08419	291	S702  
08420	291	S702  
08421	291	S702  
08422	291	S702  
08435	291	S1065 
08436	291	S702  
08444	291	S702  
08446	291	S702  
08448	291	S702  
08449	291	S702  
08450	291	S702  
08454	291	S2664 
08455	291	S2664 
08456	291	S2664 
08457	291	S2664 
08458	291	S2664 
08459	291	S2664 
08460	291	S2664 
08461	291	S2664 
08462	291	S2664 
08463	291	S2664 
08464	291	S2664 
08465	291	S2664 
08466	291	S2664 
08467	291	S2161 
08468	291	S2664 
08469	291	S2664 
08470	291	S2664 
08471	291	S2664 
08472	291	S2664 
08473	291	S2664 
08474	291	S2664 
08476	291	S2502 
08478	291	S2502 
08481	291	S2502 
08482	291	S2502 
08483	291	S2502 
08484	291	S2502 
08487	291	S2502 
08488	291	S2502 
08489	291	S2502 
08490	291	S2502 
08491	291	S2502 
08492	291	S2502 
08493	291	S2502 
08494	291	S2502 
08495	291	S2502 
08497	291	S2502 
08498	291	S2502 
08500	291	S2502 
08501	291	S2502 
08504	291	S2662 
08505	291	S2662 
08506	291	S2662 
08507	291	S2662 
08508	291	S2662 
08509	291	S2662 
09003	291	S1183 
09003	291	S502  
09003	291	S561  
09004	291	S502  
09021	291	D3780 
09021	291	S604  
09032	291	D3780 
09032	291	S21   
09037	291	S1031 
09037	291	S1401 
09037	291	S1621 
09037	291	S381  
09037	291	S481  
09037	291	S502  
09037	291	S642  
09037	291	S837  
09038	291	S1031 
09038	291	S1401 
09038	291	S1621 
09038	291	S481  
09038	291	S502  
09038	291	S642  
09038	291	S837  
09039	291	S1401 
09039	291	S381  
09039	291	S837  
09040	291	D3764 
09040	291	S1023 
09040	291	S481  
09040	291	S562  
09040	291	S642  
09042	291	S461  
09042	291	S566  
09050	291	S421  
09060	291	S381  
09062	291	S381  
09070	291	S53   
09070	291	S582  
09078	291	S561  
09079	291	S1701 
09087	291	S1032 
09087	291	S564  
09087	291	S582  
09094	291	S363  
09094	291	S582  
09112	291	D3764 
09112	291	S563  
09132	291	S1062 
09148	291	S363  
09148	291	S582  
09149	291	S381  
09181	291	S1024 
09181	291	S1121 
09181	291	S461  
09183	291	S381  
09184	291	D3765 
09184	291	S1026 
09184	291	S562  
09184	291	S565  
09191	291	D3764 
09191	291	S1206 
09191	291	S421  
09191	291	S582  
09191	291	S837  
09195	291	S1202 
09195	291	S1562 
09202	291	S564  
09202	291	S837  
09218	291	D3764 
09218	291	S1065 
09218	291	S1222 
09218	291	S642  
09236	291	S461  
09236	291	S582  
09252	291	S482  
09252	291	S541  
09266	291	S561  
09273	291	S2104 
09279	291	S421  
09279	291	S582  
09291	291	D3780 
09291	291	S564  
09291	291	S566  
09298	291	D3764 
09298	291	D3779 
09298	291	S5    
09298	291	S564  
09298	291	S566  
09298	291	S837  
09302	291	D3780 
09302	291	S381  
09302	291	S461  
09302	291	S566  
09302	291	S963  
09316	291	D3764 
09316	291	S1162 
09316	291	S421  
09316	291	S566  
09316	291	S581  
09316	291	S604  
09316	291	S642  
09326	291	D3764 
09326	291	S1027 
09326	291	S461  
09326	291	S837  
09328	291	S1206 
09409	291	S2104 
09421	291	S564  
09421	291	S582  
09422	291	S1202 
09427	291	D4053 
09428	291	D4053 
09430	291	S561  
09431	291	S2203 
09432	291	S2203 
09433	291	S2105 
09433	291	S2961 
11012	291	S1069 
11090	291	D3773 
11090	291	S564  
11090	291	S604  
11090	291	S606  
11090	291	S837  
11091	291	S564  
11091	291	S606  
11091	291	S837  
11096	291	S1121 
11096	291	S482  
11097	291	S482  
11113	291	S1065 
11124	291	S1062 
11125	291	S1062 
11130	291	S25   
11131	291	S25   
11143	291	S1121 
11143	291	S564  
11157	291	S1202 
11243	291	S2941 
11250	291	S562  
11251	291	S481  
11251	291	S503  
11251	291	S620  
11252	291	D3765 
11252	291	S1206 
11252	291	S2121 
11252	291	S562  
11252	291	S604  
11252	291	S81   
11252	291	S837  
11253	291	S541  
11257	291	S541  
11260	291	S2941 
11260	291	S80   
11263	291	S2941 
11267	291	S2941 
11286	291	S1062 
11294	291	S563  
11294	291	S582  
11339	291	S1062 
11352	291	S563  
11353	291	S563  
11354	291	S563  
11355	291	S563  
11356	291	S563  
11356	291	S566  
11357	291	S563  
11357	291	S566  
11358	291	S563  
11358	291	S566  
11359	291	D3764 
11359	291	S2105 
11359	291	S2581 
11360	291	S2105 
11394	291	S2105 
11395	291	S2105 
11398	291	S2105 
11399	291	S2105 
11402	291	S2105 
11403	291	D3764 
11403	291	S2105 
11403	291	S2581 
11411	291	S2105 
11412	291	S2105 
11429	291	S1121 
11429	291	S363  
11463	291	S25   
11464	291	S25   
11508	291	S1062 
11510	291	S1062 
11529	291	S503  
11530	291	S441  
11546	291	S21   
11546	291	S625  
11546	291	S626  
11546	291	S627  
11546	291	S641  
11547	291	S21   
11547	291	S625  
11547	291	S626  
11547	291	S627  
11549	291	S21   
11674	291	S563  
11674	291	S566  
11705	291	S1069 
11742	291	S564  
11742	291	S606  
11742	291	S837  
11752	291	S1065 
11757	291	S1062 
11760	291	S25   
11828	291	S563  
11828	291	S566  
11841	291	S2105 
11842	291	S2105 
11856	291	S25   
11875	291	S1062 
11876	291	S1062 
11884	291	S441  
11887	291	S21   
11887	291	S625  
11887	291	S626  
11887	291	S627  
11887	291	S641  
11888	291	S21   
11888	291	S625  
11888	291	S626  
11888	291	S627  
11921	291	S1062 
11935	291	S22   
11949	291	S22   
11950	291	S2941 
11987	291	S1202 
11987	291	S2941 
11990	291	S1202 
11991	291	S1202 
11992	291	S2941 
12006	291	D4822 
12038	291	S661  
12061	291	S141  
12062	291	S141  
12063	291	S141  
12065	291	S141  
12078	291	S503  
12086	291	S363  
12086	291	S502  
12120	291	S83   
12121	291	S83   
12122	291	S83   
12131	291	S77   
12132	291	S77   
12142	291	S85   
12143	291	S85   
12144	291	S85   
12147	291	S502  
12147	291	S564  
12151	291	S101  
12151	291	S86   
12152	291	S101  
12152	291	S86   
12154	291	S941  
12155	291	S79   
12201	291	S1401 
12220	291	S1221 
12220	291	S2109 
12538	291	S661  
12563	291	S141  
12565	291	S141  
12586	291	S363  
12586	291	S502  
12632	291	S77   
12643	291	S85   
12644	291	S85   
12652	291	S101  
12652	291	S86   
13067	291	S2    
13070	291	S2    
13096	291	S2    
13098	291	S2    
13165	291	S2    
13343	291	S2    
13369	291	S2    
13370	291	S2    
13373	291	S2    
13375	291	S2    
13377	291	S2    
13378	291	S2    
13391	291	S2    
13394	291	S2    
13398	291	S2    
13399	291	S2    
13401	291	S2    
13402	291	S2    
13404	291	S2    
13405	291	S2    
13407	291	S2    
13408	291	S2    
13410	291	S2    
13411	291	S2    
13413	291	S2    
13414	291	S2    
13415	291	S2    
13416	291	S2    
13417	291	S2    
13418	291	S2    
13419	291	S2    
13420	291	S2    
13422	291	S2    
13423	291	S2    
13424	291	S2    
13425	291	S2    
13426	291	S2    
13439	291	S2    
13440	291	S2    
13441	291	S2    
13442	291	S2    
13443	291	S2    
13444	291	S2    
13445	291	S2    
13446	291	S2    
13447	291	S2    
13448	291	S2    
13449	291	S2    
13450	291	S2    
13451	291	S2    
13452	291	S2    
13453	291	S2    
13455	291	S2    
13456	291	S2    
13485	291	S2    
13486	291	S2    
13487	291	S2    
13488	291	S2    
13490	291	S2    
13491	291	S2    
13492	291	S2    
13493	291	S2    
13805	291	S2    
13806	291	S2    
13809	291	S2    
13811	291	S2    
13813	291	S2    
13850	291	S2    
13853	291	S2    
13854	291	S2    
13856	291	S2    
13857	291	S2    
13868	291	S2    
13870	291	S2    
13871	291	S2    
13873	291	S2    
13874	291	S2    
13875	291	S2    
13876	291	S2    
13877	291	S2    
13879	291	S2    
13880	291	S2    
13881	291	S2    
13882	291	S2    
13891	291	S2    
13894	291	S2    
13896	291	S2    
13898	291	S2    
13900	291	S2    
13909	291	S2    
13911	291	S2    
13912	291	S2    
13913	291	S2    
13914	291	S2    
13917	291	S2    
13920	291	S2    
13921	291	S2    
13923	291	S2    
13924	291	S2    
13929	291	S2    
13931	291	S2    
13932	291	S2    
13934	291	S2    
13935	291	S2    
13948	291	S2    
13949	291	S2    
13950	291	S2    
13951	291	S2    
13952	291	S2    
13953	291	S2    
13954	291	S2    
13955	291	S2    
13956	291	S2    
13957	291	S2    
13958	291	S2    
13959	291	S2    
13968	291	S2    
13969	291	S2    
13970	291	S2    
13971	291	S2    
13985	291	S2    
14003	291	S2103 
14006	291	S2103 
14084	291	S2103 
14096	291	S2103 
14106	291	S2103 
14238	291	S2104 
14242	291	S2104 
14347	291	S1064 
14347	291	S1122 
14366	291	S2104 
14370	291	S2104 
14602	291	S2103 
15027	291	S1163 
15260	291	S2109 
16006	291	S1164 
16006	291	S1401 
16010	291	S1164 
16010	291	S2581 
16011	291	S1164 
16011	291	S2581 
16038	291	S1164 
16042	291	S1065 
16043	291	S1065 
16089	291	S563  
16097	291	D3765 
16097	291	S22   
16098	291	S22   
16098	291	S837  
16126	291	S1202 
16126	291	S1401 
16147	291	S2104 
16167	291	S2203 
16338	291	S1164 
16343	291	S1065 
16397	291	D3765 
16397	291	S22   
16398	291	S22   
16398	291	S837  
18001	291	S1162 
18002	291	S1162 
18069	291	S20   
18079	291	S25   
18159	291	S21   
18166	291	S25   
18168	291	S25   
18258	291	S1162 
18259	291	S1162 
18262	291	S1162 
18263	291	S1162 
18288	291	S27   
18350	291	S21   
18365	291	S27   
18376	291	S25   
18403	291	S27   
18930	291	S2203 
18931	291	S2203 
18932	291	S27   
18933	291	S27   
18934	291	S27   
18935	291	S27   
18936	291	S27   
19003	291	S26   
19034	291	S26   
19035	291	S26   
19047	291	S1162 
19056	291	S26   
19057	291	S2109 
19058	291	S2109 
19064	291	S1164 
19076	291	S1164 
19078	291	S1069 
19109	291	S1164 
19120	291	S1069 
19155	291	S1164 
19283	291	S1067 
19411	291	S26   
19856	291	S1067 
19873	291	S1067 
20001	291	D5841 
20001	291	D5861 
20001	291	D5881 
20001	291	S743  
20015	291	D3766 
20015	291	D3771 
20015	291	D5202 
20046	291	S20   
20046	291	S604  
20047	291	S20   
20047	291	S604  
20048	291	S1206 
20048	291	S20   
20049	291	S1206 
20049	291	S20   
20067	291	S3081 
20089	291	S1401 
20089	291	S604  
20099	291	S1163 
20099	291	S20   
20099	291	S5    
20100	291	D3764 
20100	291	D3765 
20100	291	S1163 
20100	291	S20   
20100	291	S642  
20100	291	S837  
20109	291	S2105 
20110	291	D3764 
20110	291	S1401 
20110	291	S2105 
20110	291	S642  
20120	291	S1163 
20120	291	S20   
20120	291	S5    
20121	291	D3764 
20121	291	D3765 
20121	291	S1163 
20121	291	S20   
20121	291	S642  
20121	291	S837  
20132	291	S1202 
20310	291	D3764 
20310	291	S1401 
20310	291	S2105 
20310	291	S642  
20321	291	D3764 
20321	291	D3765 
20321	291	S1163 
20321	291	S20   
20321	291	S642  
20321	291	S837  
20400	291	D3764 
20400	291	D3765 
20400	291	S1163 
20400	291	S20   
20400	291	S642  
20400	291	S837  
20409	291	S2105 
20410	291	D3764 
20410	291	S1401 
20410	291	S2105 
20410	291	S642  
20420	291	S1163 
20420	291	S20   
20420	291	S5    
20421	291	D3764 
20421	291	D3765 
20421	291	S1163 
20421	291	S20   
20421	291	S642  
20421	291	S837  
20446	291	S20   
20446	291	S604  
20447	291	S20   
20447	291	S604  
20499	291	S1163 
20499	291	S20   
20499	291	S5    
20510	291	D3764 
20510	291	S1401 
20510	291	S2105 
20510	291	S642  
20521	291	D3764 
20521	291	D3765 
20521	291	S1163 
20521	291	S20   
20521	291	S642  
20521	291	S837  
21138	291	S1064 
21138	291	S1066 
21138	291	S1122 
21141	291	S1064 
21224	291	S19   
21225	291	S19   
21226	291	S22   
21227	291	S22   
21229	291	S1122 
21238	291	S2801 
21239	291	S1066 
21240	291	S1066 
21241	291	S1066 
21242	291	S1066 
21243	291	S1066 
21244	291	S1066 
21245	291	S1066 
21246	291	S1066 
21247	291	S1066 
21248	291	S1066 
21249	291	S1064 
21250	291	S1064 
21251	291	S1064 
21252	291	S1064 
21253	291	S1064 
21254	291	S1064 
21255	291	S1064 
21256	291	S1064 
21257	291	S1064 
21259	291	S1064 
21260	291	S1082 
21261	291	S1082 
21262	291	S1082 
21263	291	S1082 
21264	291	S1082 
21265	291	S1082 
21266	291	S1082 
21267	291	S1082 
21268	291	S1082 
21269	291	S1082 
21270	291	S1082 
21271	291	S2108 
21272	291	S2108 
21273	291	S2108 
21274	291	S2108 
21275	291	S2108 
21276	291	S2108 
21277	291	S2110 
21278	291	S2110 
21279	291	S2110 
21280	291	S2110 
21281	291	S2110 
21282	291	S2110 
21283	291	S2111 
21284	291	S2111 
21285	291	S2111 
21286	291	S2111 
21287	291	S2112 
21288	291	S2112 
21289	291	S2112 
21290	291	S2112 
21291	291	S2112 
21292	291	S2112 
21293	291	S2782 
21294	291	S2782 
21295	291	S2782 
21296	291	S2782 
21297	291	S2782 
21298	291	S2782 
21299	291	S2110 
21299	291	S2111 
21299	291	S2112 
21299	291	S2782 
21300	291	S2110 
21300	291	S2112 
21300	291	S2782 
21301	291	S2110 
21301	291	S2111 
21301	291	S2112 
21301	291	S2782 
21302	291	S2110 
21302	291	S2111 
21302	291	S2112 
21302	291	S2782 
21303	291	S2110 
21303	291	S2112 
21303	291	S2782 
21304	291	S2110 
21304	291	S2111 
21304	291	S2112 
21304	291	S2782 
21308	291	S2801 
21309	291	S2801 
21310	291	S2801 
21311	291	S2801 
21313	291	S2801 
21314	291	S2801 
21315	291	S2801 
21316	291	S2801 
21317	291	S2801 
21318	291	S2801 
21319	291	S2801 
21321	291	S2801 
21322	291	S2801 
21324	291	S2801 
21325	291	S2801 
21326	291	S2801 
21346	291	S2801 
21347	291	S2801 
21348	291	S2801 
21349	291	S2801 
22247	291	S20   
22903	291	S21   
22904	291	S18   
22915	291	S19   
22916	291	S19   
23582	291	S2    
23583	291	S2    
23585	291	S2    
23586	291	S2    
23587	291	S2    
23589	291	S2    
23590	291	S2    
23591	291	S2    
23592	291	S2    
23593	291	S2    
23594	291	S2    
23595	291	S2    
23596	291	S2    
23597	291	S2    
23599	291	S2    
23601	291	S2    
23603	291	S2    
23604	291	S2    
23607	291	S2    
23609	291	S2    
23613	291	S2    
23615	291	S2    
23616	291	S2    
23618	291	S2    
23619	291	S2    
23620	291	S2    
23623	291	S2    
23624	291	S2    
23626	291	S2    
23627	291	S2    
23628	291	S2    
23630	291	S2    
23631	291	S2    
23632	291	S2    
23634	291	S2    
23635	291	S2    
23636	291	S2    
23637	291	S2    
23646	291	S2    
23647	291	S2    
23648	291	S2    
23649	291	S2    
23650	291	S2    
23651	291	S2    
23652	291	S2    
23653	291	S2    
23654	291	S2    
23655	291	S2    
23656	291	S2    
23657	291	S2    
23658	291	S2    
23659	291	S2    
23660	291	S2    
35001	291	D4961 
35024	291	D4961 
35029	291	D4961 
35038	291	D4961 
35048	291	D4961 
35067	291	D4961 
35130	291	S2381 
35131	291	S2381 
35132	291	S2381 
35135	291	S2381 
35136	291	S2381 
35137	291	S2381 
35139	291	S2381 
35143	291	S2381 
35145	291	S2381 
35146	291	S2381 
35147	291	S2381 
35148	291	S2381 
42190	291	S243  
43215	291	S26   
43364	291	S26   
43514	291	S1067 
48052	291	S1362 
01001	301	S10   
01001	301	S11   
01001	301	S12   
01001	301	S6    
01001	301	S7    
01001	301	S8    
01001	301	S9    
01026	301	S25   
01032	301	S19   
01040	301	S10   
01040	301	S11   
01040	301	S12   
01040	301	S6    
01040	301	S7    
01040	301	S8    
01040	301	S9    
01042	301	S10   
01042	301	S11   
01042	301	S12   
01042	301	S19   
01042	301	S6    
01042	301	S7    
01042	301	S8    
01042	301	S9    
01046	301	S19   
01077	301	S10   
01077	301	S11   
01077	301	S12   
01077	301	S27   
01077	301	S6    
01077	301	S7    
01077	301	S8    
01077	301	S9    
01079	301	S10   
01079	301	S1063 
01079	301	S11   
01079	301	S12   
01079	301	S7    
01079	301	S8    
01079	301	S9    
01082	301	S1063 
01085	301	S10   
01085	301	S1063 
01085	301	S11   
01085	301	S12   
01085	301	S7    
01085	301	S8    
01085	301	S9    
01103	301	S1163 
01123	301	S1063 
01123	301	S561  
01124	301	S1065 
01125	301	S1065 
01145	301	S10   
01145	301	S11   
01145	301	S12   
01145	301	S6    
01145	301	S7    
01145	301	S8    
01145	301	S9    
01202	301	S1163 
02048	301	S2109 
02048	301	S2922 
02053	301	S2109 
02053	301	S2922 
04017	301	S19   
04020	301	S19   
04021	301	S19   
04023	301	S19   
04053	301	S19   
04114	301	S19   
04120	301	S19   
04141	301	S19   
04142	301	S19   
04143	301	S19   
04144	301	S19   
04367	301	S19   
04610	301	S18   
04628	301	S18   
04629	301	S18   
04630	301	S19   
04631	301	S20   
04635	301	S19   
04636	301	S19   
04638	301	S26   
04639	301	S26   
04640	301	S26   
04641	301	S25   
04656	301	S2221 
04657	301	S2221 
04658	301	S2221 
04659	301	S2221 
04660	301	S2221 
04661	301	S2221 
04662	301	S2221 
04663	301	S2221 
05023	301	S1581 
05024	301	S1581 
05027	301	S1082 
05028	301	S1082 
05173	301	S1581 
05174	301	S1581 
05175	301	S1581 
05176	301	S1581 
05177	301	S1581 
05178	301	S1581 
05312	301	S26   
05313	301	S26   
05320	301	S26   
05623	301	D4282 
05624	301	S3    
05625	301	D4282 
05626	301	D4281 
05626	301	D4282 
05627	301	D4282 
05628	301	D4281 
05628	301	D4282 
05629	301	D4281 
05630	301	D4282 
05631	301	D4282 
05632	301	S3    
05643	301	D4301 
05644	301	D4301 
05645	301	D4301 
05646	301	D4301 
05647	301	D4301 
05648	301	D4301 
05649	301	D4301 
05650	301	D4301 
05651	301	D4301 
05652	301	D4301 
05653	301	D4301 
05654	301	D4301 
05655	301	D4301 
05656	301	D4301 
05657	301	D4301 
05658	301	D4301 
05661	301	S1082 
06016	301	S18   
06019	301	S18   
06043	301	S18   
06094	301	S18   
06128	301	S18   
06159	301	S18   
06164	301	S23   
06931	301	S22   
06982	301	S18   
06983	301	S18   
06984	301	S2104 
06985	301	S2104 
07002	301	S222  
07005	301	S248  
07006	301	S247  
07007	301	S1164 
07008	301	S238  
07011	301	S227  
07013	301	S242  
07015	301	S248  
07016	301	S248  
07018	301	S226  
07021	301	S237  
07022	301	S21   
07028	301	S225  
07028	301	S230  
07034	301	S249  
07039	301	S244  
07043	301	S230  
07052	301	S227  
07056	301	S248  
07057	301	S235  
07057	301	S238  
07058	301	S237  
07063	301	S1164 
07063	301	S582  
07064	301	S1164 
07068	301	S1041 
07075	301	S1164 
07076	301	S239  
07078	301	S228  
07079	301	S227  
07080	301	S227  
07089	301	S241  
07089	301	S251  
07241	301	S21   
07276	301	S259  
07278	301	S259  
07279	301	S259  
07909	301	S259  
07910	301	S245  
07911	301	S226  
07912	301	S226  
07913	301	S238  
07914	301	S252  
07916	301	S242  
07917	301	S242  
07918	301	S242  
07919	301	S252  
07920	301	S242  
07921	301	S228  
07922	301	S242  
07923	301	S245  
07924	301	S242  
07926	301	S228  
07927	301	S227  
07928	301	S225  
07929	301	S227  
07930	301	S222  
07931	301	S222  
07932	301	S224  
07933	301	S224  
07935	301	S224  
07936	301	S247  
07937	301	S239  
07938	301	S233  
07939	301	S235  
07940	301	S237  
07944	301	S227  
07945	301	S21   
07949	301	S23   
07950	301	S23   
07951	301	S243  
07952	301	S1164 
07953	301	S1164 
07953	301	S582  
07954	301	S582  
07955	301	S1164 
07956	301	S1164 
07957	301	S1164 
07958	301	S1164 
07959	301	S1164 
07960	301	S1164 
08001	301	S1065 
08003	301	S2664 
08005	301	S2664 
08010	301	S702  
08011	301	S702  
08012	301	S1065 
08013	301	S1065 
08014	301	S2664 
08017	301	S603  
08018	301	S702  
08019	301	S603  
08020	301	S1065 
08023	301	S2664 
08025	301	S2662 
08026	301	S603  
08028	301	S2664 
08030	301	S1065 
08031	301	S2664 
08032	301	S2664 
08035	301	S603  
08045	301	S603  
08047	301	S702  
08048	301	S603  
08049	301	S702  
08050	301	S603  
08054	301	S702  
08057	301	S603  
08058	301	S2664 
08059	301	S702  
08060	301	S2664 
08061	301	S1065 
08064	301	S603  
08065	301	S1065 
08065	301	S2662 
08066	301	S702  
08067	301	S2664 
08068	301	S2664 
08069	301	S2664 
08071	301	S2664 
08074	301	S2662 
08077	301	S1065 
08078	301	S603  
08082	301	S603  
08083	301	S2502 
08085	301	S702  
08086	301	S603  
08087	301	S603  
08089	301	S603  
08092	301	S702  
08094	301	S702  
08116	301	S2502 
08124	301	S702  
08128	301	S702  
08130	301	S702  
08138	301	S2502 
08139	301	S603  
08146	301	S702  
08147	301	S1065 
08147	301	S2422 
08177	301	S2502 
08189	301	S2664 
08190	301	S603  
08194	301	S603  
08200	301	S702  
08202	301	S603  
08206	301	S2502 
08210	301	S702  
08211	301	S702  
08212	301	S702  
08214	301	S702  
08215	301	S702  
08216	301	S702  
08217	301	S2664 
08218	301	S1065 
08219	301	S702  
08220	301	S702  
08221	301	S702  
08225	301	S702  
08229	301	S702  
08231	301	S702  
08232	301	S702  
08243	301	S603  
08244	301	S603  
08245	301	S603  
08246	301	S603  
08247	301	S603  
08253	301	S2664 
08258	301	S2664 
08259	301	S2662 
08261	301	S603  
08262	301	S603  
08263	301	S603  
08266	301	S603  
08267	301	S603  
08268	301	S603  
08269	301	S603  
08270	301	S603  
08271	301	S603  
08272	301	S603  
08273	301	S603  
08274	301	S603  
08277	301	S603  
08278	301	S603  
08283	301	S2664 
08284	301	S2664 
08286	301	S2664 
08287	301	S2664 
08288	301	S2664 
08289	301	S2664 
08293	301	S702  
08294	301	S702  
08299	301	S702  
08309	301	S2664 
08315	301	S702  
08316	301	S702  
08317	301	S702  
08319	301	S2664 
08345	301	S603  
08347	301	S2502 
08348	301	S2502 
08349	301	S2502 
08350	301	S2502 
08351	301	S702  
08352	301	S702  
08353	301	S702  
08354	301	S702  
08355	301	S702  
08357	301	S702  
08358	301	S702  
08359	301	S702  
08360	301	S702  
08361	301	S702  
08362	301	S702  
08363	301	S702  
08364	301	S702  
08366	301	S702  
08367	301	S603  
08368	301	S603  
08370	301	S603  
08371	301	S603  
08372	301	S603  
08374	301	S2664 
08376	301	S2664 
08378	301	S2161 
08379	301	S2664 
08380	301	S2664 
08383	301	S2664 
08384	301	S2664 
08385	301	S2664 
08386	301	S2664 
08387	301	S2664 
08390	301	S2664 
08391	301	S682  
08392	301	S2664 
08393	301	S2664 
08394	301	S702  
08395	301	S702  
08396	301	S702  
08397	301	S603  
08398	301	S603  
08399	301	S603  
08400	301	S881  
08401	301	S881  
08402	301	S702  
08403	301	S1209 
08408	301	S2502 
08410	301	S702  
08411	301	S702  
08412	301	S702  
08413	301	S702  
08414	301	S702  
08415	301	S702  
08416	301	S702  
08417	301	S702  
08418	301	S702  
08419	301	S702  
08420	301	S702  
08421	301	S702  
08422	301	S702  
08435	301	S1065 
08436	301	S702  
08444	301	S702  
08446	301	S702  
08448	301	S702  
08449	301	S702  
08450	301	S702  
08454	301	S2664 
08455	301	S2664 
08457	301	S2664 
08458	301	S2664 
08459	301	S2664 
08460	301	S2664 
08461	301	S2664 
08462	301	S2664 
08463	301	S2664 
08464	301	S2664 
08465	301	S2664 
08466	301	S2664 
08468	301	S2664 
08469	301	S2664 
08470	301	S2664 
08471	301	S2664 
08472	301	S2664 
08473	301	S2664 
08474	301	S2664 
08476	301	S2502 
08481	301	S2502 
08482	301	S2502 
08483	301	S2502 
08484	301	S2502 
08487	301	S2502 
08488	301	S2502 
08489	301	S2502 
08490	301	S2502 
08491	301	S2502 
08492	301	S2502 
08493	301	S2502 
08494	301	S2502 
08495	301	S2502 
08497	301	S2502 
08498	301	S2502 
08500	301	S2502 
08501	301	S2502 
08504	301	S2662 
08505	301	S2662 
08506	301	S2662 
08507	301	S2662 
08508	301	S2662 
08509	301	S2662 
09003	301	D4070 
09003	301	S1183 
09003	301	S502  
09003	301	S561  
09004	301	S502  
09021	301	S10   
09021	301	S11   
09021	301	S12   
09021	301	S206  
09021	301	S208  
09021	301	S7    
09021	301	S8    
09021	301	S9    
09032	301	S21   
09037	301	D4070 
09037	301	S1031 
09037	301	S1621 
09037	301	S381  
09037	301	S481  
09037	301	S502  
09038	301	S1031 
09038	301	S1621 
09038	301	S481  
09038	301	S502  
09039	301	D4070 
09039	301	S381  
09040	301	S10   
09040	301	S1023 
09040	301	S11   
09040	301	S12   
09040	301	S206  
09040	301	S208  
09040	301	S481  
09040	301	S562  
09040	301	S6    
09040	301	S7    
09040	301	S73   
09040	301	S74   
09040	301	S8    
09040	301	S9    
09042	301	S461  
09042	301	S566  
09050	301	S1141 
09050	301	S421  
09050	301	S441  
09060	301	D4070 
09060	301	S381  
09062	301	S381  
09062	301	S404  
09070	301	D4070 
09070	301	S10   
09070	301	S11   
09070	301	S12   
09070	301	S182  
09070	301	S183  
09070	301	S201  
09070	301	S202  
09070	301	S203  
09070	301	S204  
09070	301	S205  
09070	301	S206  
09070	301	S208  
09070	301	S53   
09070	301	S582  
09070	301	S6    
09070	301	S73   
09070	301	S74   
09070	301	S8    
09070	301	S9    
09078	301	S561  
09079	301	S1701 
09087	301	S1032 
09087	301	S564  
09087	301	S582  
09094	301	S363  
09094	301	S582  
09112	301	D4070 
09112	301	S482  
09112	301	S563  
09132	301	D4070 
09132	301	S10   
09132	301	S1062 
09132	301	S11   
09132	301	S12   
09132	301	S206  
09132	301	S208  
09132	301	S6    
09132	301	S7    
09132	301	S8    
09132	301	S9    
09139	301	S381  
09148	301	D4070 
09148	301	S1033 
09148	301	S363  
09148	301	S582  
09149	301	S381  
09160	301	S1065 
09181	301	D4070 
09181	301	S10   
09181	301	S1024 
09181	301	S11   
09181	301	S1121 
09181	301	S12   
09181	301	S206  
09181	301	S208  
09181	301	S461  
09181	301	S6    
09181	301	S7    
09181	301	S73   
09181	301	S74   
09181	301	S8    
09181	301	S9    
09183	301	S381  
09184	301	D4070 
09184	301	S1026 
09184	301	S562  
09184	301	S565  
09191	301	D4070 
09191	301	S421  
09195	301	S1202 
09195	301	S1562 
09202	301	S482  
09202	301	S564  
09218	301	S1065 
09218	301	S1161 
09236	301	D4070 
09236	301	S10   
09236	301	S11   
09236	301	S12   
09236	301	S461  
09236	301	S6    
09236	301	S7    
09236	301	S73   
09236	301	S74   
09236	301	S8    
09236	301	S9    
09252	301	D4070 
09252	301	S10   
09252	301	S11   
09252	301	S12   
09252	301	S206  
09252	301	S208  
09252	301	S482  
09252	301	S541  
09252	301	S6    
09252	301	S7    
09252	301	S73   
09252	301	S74   
09252	301	S8    
09252	301	S9    
09266	301	D4070 
09266	301	S1167 
09266	301	S441  
09266	301	S561  
09273	301	S2104 
09273	301	S2985 
09279	301	S10   
09279	301	S11   
09279	301	S12   
09279	301	S206  
09279	301	S208  
09279	301	S421  
09279	301	S6    
09279	301	S7    
09279	301	S73   
09279	301	S74   
09279	301	S8    
09279	301	S9    
09291	301	S10   
09291	301	S11   
09291	301	S12   
09291	301	S206  
09291	301	S208  
09291	301	S564  
09291	301	S566  
09291	301	S6    
09291	301	S7    
09291	301	S73   
09291	301	S74   
09291	301	S8    
09291	301	S9    
09298	301	S10   
09298	301	S11   
09298	301	S12   
09298	301	S206  
09298	301	S208  
09298	301	S564  
09298	301	S566  
09298	301	S6    
09298	301	S7    
09298	301	S73   
09298	301	S74   
09298	301	S8    
09298	301	S9    
09302	301	S381  
09302	301	S461  
09302	301	S566  
09302	301	S963  
09316	301	S10   
09316	301	S11   
09316	301	S12   
09316	301	S182  
09316	301	S183  
09316	301	S201  
09316	301	S202  
09316	301	S203  
09316	301	S204  
09316	301	S205  
09316	301	S206  
09316	301	S208  
09316	301	S421  
09316	301	S566  
09316	301	S581  
09316	301	S6    
09316	301	S7    
09316	301	S73   
09316	301	S74   
09316	301	S8    
09316	301	S9    
09326	301	S10   
09326	301	S1027 
09326	301	S11   
09326	301	S12   
09326	301	S206  
09326	301	S208  
09326	301	S461  
09326	301	S6    
09326	301	S7    
09326	301	S73   
09326	301	S74   
09326	301	S8    
09326	301	S9    
09328	301	S1206 
09409	301	S2104 
09409	301	S2985 
09421	301	S564  
09421	301	S582  
09422	301	S1202 
09427	301	D4053 
09428	301	D4053 
09429	301	D4070 
09429	301	S1167 
09429	301	S441  
09430	301	S441  
09430	301	S561  
09431	301	S2203 
09432	301	S2203 
09433	301	S2105 
09433	301	S2961 
10007	301	S1082 
10066	301	S1082 
10067	301	S1082 
10068	301	S1082 
10098	301	S1581 
10099	301	S1581 
10102	301	S1581 
10119	301	S1581 
10123	301	S1082 
10124	301	S1082 
10173	301	S1581 
10858	301	S1082 
10860	301	S1082 
10861	301	S1082 
10862	301	S1082 
10863	301	S1581 
10864	301	S1082 
11011	301	S1069 
11012	301	S1069 
11019	301	S10   
11019	301	S11   
11019	301	S12   
11019	301	S6    
11019	301	S7    
11019	301	S8    
11019	301	S9    
11090	301	S1121 
11090	301	S564  
11090	301	S619  
11091	301	S1121 
11091	301	S564  
11096	301	S1121 
11096	301	S482  
11097	301	S482  
11101	301	S10   
11101	301	S11   
11101	301	S12   
11101	301	S6    
11101	301	S7    
11101	301	S8    
11101	301	S9    
11112	301	S1065 
11113	301	S1065 
11124	301	S1062 
11124	301	S183  
11124	301	S201  
11124	301	S202  
11124	301	S203  
11124	301	S6    
11124	301	S618  
11125	301	S1062 
11130	301	S25   
11131	301	S25   
11143	301	S1121 
11143	301	S183  
11143	301	S201  
11143	301	S202  
11143	301	S203  
11143	301	S564  
11143	301	S6    
11157	301	S1202 
11205	301	S1062 
11206	301	S1062 
11206	301	S183  
11206	301	S201  
11206	301	S202  
11206	301	S203  
11206	301	S6    
11210	301	S10   
11210	301	S11   
11210	301	S12   
11210	301	S6    
11210	301	S7    
11210	301	S8    
11210	301	S9    
11243	301	S2941 
11250	301	S562  
11250	301	S565  
11251	301	S481  
11251	301	S503  
11251	301	S620  
11252	301	S10   
11252	301	S11   
11252	301	S12   
11252	301	S183  
11252	301	S201  
11252	301	S202  
11252	301	S203  
11252	301	S481  
11252	301	S562  
11252	301	S6    
11252	301	S624  
11252	301	S7    
11252	301	S8    
11252	301	S9    
11253	301	S541  
11253	301	S565  
11257	301	S541  
11257	301	S565  
11260	301	D566  
11260	301	S10   
11260	301	S11   
11260	301	S12   
11260	301	S2941 
11260	301	S6    
11260	301	S7    
11260	301	S78   
11260	301	S8    
11260	301	S80   
11260	301	S9    
11263	301	S2941 
11267	301	S2941 
11279	301	S10   
11279	301	S11   
11279	301	S12   
11279	301	S6    
11279	301	S7    
11279	301	S8    
11279	301	S9    
11282	301	S10   
11282	301	S1062 
11282	301	S11   
11282	301	S12   
11282	301	S183  
11282	301	S201  
11282	301	S202  
11282	301	S203  
11282	301	S6    
11282	301	S7    
11282	301	S8    
11282	301	S9    
11286	301	S1062 
11294	301	S563  
11294	301	S582  
11333	301	S1062 
11333	301	S183  
11333	301	S201  
11333	301	S202  
11333	301	S203  
11333	301	S6    
11333	301	S611  
11339	301	S1062 
11352	301	S563  
11352	301	S566  
11353	301	S563  
11353	301	S566  
11354	301	S563  
11354	301	S566  
11355	301	S563  
11355	301	S566  
11356	301	S563  
11356	301	S566  
11357	301	S563  
11357	301	S566  
11358	301	S563  
11358	301	S566  
11359	301	S2105 
11360	301	S183  
11360	301	S201  
11360	301	S202  
11360	301	S203  
11360	301	S2105 
11360	301	S6    
11394	301	S2105 
11395	301	S2105 
11398	301	S2105 
11399	301	S2105 
11402	301	S2105 
11403	301	S183  
11403	301	S201  
11403	301	S202  
11403	301	S203  
11403	301	S2105 
11403	301	S6    
11411	301	S2105 
11412	301	S2105 
11429	301	S1121 
11429	301	S363  
11429	301	S617  
11463	301	S25   
11464	301	S25   
11468	301	S12   
11468	301	S183  
11468	301	S201  
11468	301	S202  
11468	301	S203  
11507	301	S1062 
11508	301	S10   
11508	301	S1062 
11508	301	S11   
11508	301	S12   
11508	301	S183  
11508	301	S201  
11508	301	S202  
11508	301	S203  
11508	301	S6    
11508	301	S7    
11508	301	S8    
11508	301	S9    
11510	301	S1062 
11529	301	S183  
11529	301	S201  
11529	301	S202  
11529	301	S203  
11529	301	S441  
11529	301	S503  
11529	301	S6    
11529	301	S608  
11530	301	S441  
11540	301	S10   
11540	301	S11   
11540	301	S12   
11540	301	S183  
11540	301	S201  
11540	301	S202  
11540	301	S203  
11540	301	S6    
11540	301	S7    
11540	301	S8    
11540	301	S9    
11546	301	S21   
11546	301	S625  
11546	301	S626  
11546	301	S627  
11547	301	S21   
11547	301	S625  
11547	301	S626  
11547	301	S627  
11549	301	S183  
11549	301	S201  
11549	301	S202  
11549	301	S203  
11549	301	S21   
11549	301	S6    
11565	301	S10   
11565	301	S11   
11565	301	S12   
11565	301	S6    
11565	301	S7    
11565	301	S8    
11565	301	S9    
11674	301	S183  
11674	301	S201  
11674	301	S202  
11674	301	S203  
11674	301	S563  
11674	301	S566  
11705	301	S1069 
11709	301	S10   
11709	301	S11   
11709	301	S12   
11709	301	S6    
11709	301	S7    
11709	301	S8    
11709	301	S9    
11742	301	S1121 
11742	301	S564  
11746	301	S10   
11746	301	S11   
11746	301	S12   
11746	301	S6    
11746	301	S7    
11746	301	S8    
11746	301	S9    
11752	301	S1065 
11757	301	S1062 
11760	301	S25   
11783	301	S10   
11783	301	S11   
11783	301	S12   
11783	301	S6    
11783	301	S7    
11783	301	S8    
11783	301	S9    
11803	301	S10   
11803	301	S11   
11803	301	S12   
11803	301	S6    
11803	301	S7    
11803	301	S8    
11803	301	S9    
11821	301	S1062 
11828	301	S183  
11828	301	S201  
11828	301	S202  
11828	301	S203  
11828	301	S563  
11828	301	S566  
11841	301	S183  
11841	301	S201  
11841	301	S202  
11841	301	S203  
11841	301	S2105 
11841	301	S6    
11842	301	S2105 
11856	301	S25   
11858	301	S12   
11858	301	S183  
11858	301	S201  
11858	301	S202  
11858	301	S203  
11875	301	S10   
11875	301	S1062 
11875	301	S11   
11875	301	S12   
11875	301	S183  
11875	301	S201  
11875	301	S202  
11875	301	S203  
11875	301	S6    
11875	301	S7    
11875	301	S8    
11875	301	S9    
11876	301	S1062 
11884	301	S441  
11886	301	S10   
11886	301	S11   
11886	301	S12   
11886	301	S183  
11886	301	S201  
11886	301	S202  
11886	301	S203  
11886	301	S6    
11886	301	S7    
11886	301	S8    
11886	301	S9    
11887	301	S21   
11887	301	S625  
11887	301	S626  
11887	301	S627  
11888	301	S21   
11888	301	S625  
11888	301	S626  
11888	301	S627  
11921	301	S1062 
11935	301	S183  
11935	301	S202  
11935	301	S203  
11935	301	S22   
11935	301	S6    
11949	301	S183  
11949	301	S202  
11949	301	S203  
11949	301	S22   
11949	301	S6    
11950	301	S2941 
11960	301	S481  
11960	301	S562  
11987	301	S1202 
11987	301	S2941 
11990	301	S1202 
11991	301	S1202 
11992	301	S2941 
12006	301	D4862 
12006	301	S1783 
12038	301	S661  
12038	301	S961  
12061	301	S141  
12062	301	S141  
12063	301	S141  
12065	301	S141  
12078	301	S1063 
12078	301	S503  
12086	301	S343  
12086	301	S363  
12086	301	S502  
12087	301	S343  
12120	301	S83   
12121	301	S83   
12122	301	S83   
12131	301	S77   
12132	301	S77   
12142	301	S85   
12143	301	S85   
12144	301	S85   
12147	301	S502  
12147	301	S564  
12151	301	S101  
12151	301	S86   
12152	301	S101  
12152	301	S86   
12154	301	S941  
12155	301	S79   
12201	301	S1164 
12220	301	D4743 
12220	301	S1221 
12220	301	S2109 
12538	301	S661  
12538	301	S961  
12563	301	S141  
12565	301	S141  
12586	301	S343  
12586	301	S363  
12586	301	S502  
12632	301	S77   
12643	301	S85   
12644	301	S85   
12652	301	S101  
12652	301	S86   
13019	301	S2    
13020	301	S2    
13055	301	S2    
13065	301	S2    
13067	301	S2    
13068	301	S2    
13070	301	S2    
13096	301	S2    
13098	301	S2    
13165	301	S2    
13232	301	S221  
13235	301	S221  
13318	301	S1581 
13320	301	S1581 
13321	301	S1581 
13322	301	S1581 
13323	301	S1581 
13324	301	S1581 
13325	301	S1082 
13326	301	S1082 
13327	301	S1082 
13340	301	S1581 
13341	301	S1581 
13343	301	S2    
13355	301	S230  
13369	301	S2    
13370	301	S2    
13373	301	S2    
13375	301	S2    
13377	301	S2    
13378	301	S2    
13391	301	S2    
13394	301	S2    
13398	301	S2    
13399	301	S2    
13401	301	S2    
13402	301	S2    
13404	301	S2    
13405	301	S2    
13407	301	S2    
13408	301	S2    
13410	301	S2    
13411	301	S2    
13413	301	S2    
13414	301	S2    
13415	301	S2    
13416	301	S2    
13417	301	S2    
13418	301	S2    
13419	301	S2    
13420	301	S2    
13421	301	S2    
13422	301	S2    
13423	301	S2    
13424	301	S2    
13425	301	S2    
13426	301	S2    
13439	301	S2    
13440	301	S2    
13441	301	S2    
13442	301	S2    
13443	301	S2    
13444	301	S2    
13445	301	S2    
13446	301	S2    
13447	301	S2    
13448	301	S2    
13449	301	S2    
13450	301	S2    
13451	301	S2    
13452	301	S2    
13453	301	S2    
13454	301	S2    
13455	301	S2    
13456	301	S2    
13467	301	S221  
13468	301	S221  
13469	301	S221  
13470	301	S221  
13481	301	S221  
13482	301	S221  
13483	301	S221  
13484	301	S221  
13485	301	S2    
13486	301	S2    
13487	301	S2    
13488	301	S2    
13490	301	S2    
13491	301	S2    
13492	301	S2    
13493	301	S2    
13494	301	S14   
13495	301	S14   
13496	301	S14   
13497	301	S14   
13498	301	S14   
13565	301	S2703 
13566	301	S2703 
13567	301	S2703 
13568	301	S2703 
13569	301	S2703 
13805	301	S2    
13806	301	S2    
13809	301	S2    
13810	301	S2    
13811	301	S2    
13812	301	S2    
13813	301	S2    
13814	301	S2    
13850	301	S2    
13851	301	S2    
13853	301	S2    
13854	301	S2    
13856	301	S2    
13857	301	S2    
13868	301	S2    
13869	301	S2    
13870	301	S2    
13871	301	S2    
13872	301	S2    
13873	301	S2    
13874	301	S2    
13875	301	S2    
13876	301	S2    
13877	301	S2    
13878	301	S2    
13879	301	S2    
13880	301	S2    
13881	301	S2    
13882	301	S2    
13891	301	S2    
13893	301	S2    
13894	301	S2    
13896	301	S2    
13898	301	S2    
13900	301	S2    
13909	301	S2    
13910	301	S2    
13911	301	S2    
13912	301	S2    
13913	301	S2    
13914	301	S2    
13917	301	S2    
13918	301	S2    
13920	301	S2    
13921	301	S2    
13923	301	S2    
13924	301	S2    
13929	301	S2    
13930	301	S2    
13931	301	S2    
13932	301	S2    
13934	301	S2    
13935	301	S2    
13948	301	S2    
13949	301	S2    
13950	301	S2    
13951	301	S2    
13952	301	S2    
13953	301	S2    
13954	301	S2    
13955	301	S2    
13956	301	S2    
13957	301	S2    
13958	301	S2    
13959	301	S2    
13968	301	S2    
13969	301	S2    
13970	301	S2    
13971	301	S2    
13985	301	S2    
13988	301	S2703 
13989	301	S2703 
13990	301	S2703 
13991	301	S2703 
13992	301	S2703 
13994	301	S2703 
13995	301	S2703 
13996	301	S2703 
13997	301	S2703 
13998	301	S2703 
14003	301	S2103 
14006	301	S2103 
14052	301	S10   
14052	301	S11   
14052	301	S12   
14052	301	S6    
14052	301	S7    
14052	301	S8    
14052	301	S9    
14084	301	S2103 
14096	301	S2103 
14106	301	S2103 
14137	301	S1068 
14144	301	S1068 
14145	301	S1064 
14145	301	S1066 
14145	301	S1068 
14145	301	S1122 
14146	301	S1068 
14147	301	S1068 
14148	301	S1068 
14149	301	S1068 
14154	301	S2702 
14156	301	S2702 
14166	301	S10   
14166	301	S11   
14166	301	S12   
14166	301	S6    
14166	301	S7    
14166	301	S8    
14166	301	S9    
14209	301	S1064 
14209	301	S1066 
14209	301	S1122 
14209	301	S23   
14219	301	S10   
14219	301	S11   
14219	301	S12   
14219	301	S6    
14219	301	S7    
14219	301	S8    
14219	301	S9    
14238	301	S2104 
14242	301	S2104 
14267	301	S10   
14267	301	S11   
14267	301	S12   
14267	301	S6    
14267	301	S7    
14267	301	S8    
14267	301	S9    
14323	301	S1067 
14347	301	S1064 
14347	301	S1122 
14366	301	S2104 
14370	301	S2104 
14382	301	S1164 
14400	301	S1064 
14400	301	S1066 
14400	301	S1068 
14400	301	S1122 
14407	301	D739  
14416	301	S1064 
14416	301	S1066 
14416	301	S1068 
14416	301	S1122 
14424	301	D739  
14429	301	S20   
14429	301	S23   
14429	301	S25   
14432	301	S1068 
14433	301	S1068 
14434	301	S1068 
14437	301	S27   
14438	301	S27   
14439	301	D4541 
14440	301	S2109 
14450	301	S1164 
14460	301	S1164 
14461	301	S1164 
14462	301	S2109 
14475	301	S1068 
14476	301	S1068 
14555	301	D4541 
14555	301	S1068 
14555	301	S27   
14559	301	S1068 
14559	301	S27   
14601	301	S1066 
14602	301	S2103 
15027	301	S10   
15027	301	S11   
15027	301	S1163 
15027	301	S12   
15027	301	S9    
15073	301	S1163 
15078	301	D1066 
15078	301	S2621 
15087	301	S2109 
15152	301	S2104 
15232	301	S1163 
15260	301	S2109 
15261	301	S1163 
15262	301	S1163 
16006	301	S1164 
16010	301	S1164 
16011	301	S1164 
16028	301	S10   
16028	301	S11   
16028	301	S12   
16028	301	S182  
16028	301	S183  
16028	301	S203  
16028	301	S6    
16028	301	S7    
16028	301	S8    
16028	301	S9    
16029	301	S1164 
16037	301	S1164 
16037	301	S2202 
16038	301	S1164 
16038	301	S182  
16038	301	S183  
16038	301	S203  
16038	301	S2202 
16042	301	S1065 
16042	301	S2202 
16043	301	S10   
16043	301	S1065 
16043	301	S11   
16043	301	S12   
16043	301	S182  
16043	301	S183  
16043	301	S203  
16043	301	S2202 
16043	301	S6    
16043	301	S7    
16043	301	S8    
16043	301	S9    
16089	301	S563  
16097	301	S22   
16098	301	S10   
16098	301	S11   
16098	301	S12   
16098	301	S182  
16098	301	S183  
16098	301	S203  
16098	301	S22   
16098	301	S6    
16098	301	S7    
16098	301	S8    
16098	301	S9    
16112	301	S39   
16114	301	S39   
16120	301	S39   
16123	301	S39   
16126	301	S39   
16139	301	S39   
16147	301	S2104 
16159	301	D342  
16159	301	S39   
16167	301	S2203 
16174	301	S18   
16338	301	S1164 
16338	301	S182  
16338	301	S183  
16338	301	S203  
16338	301	S2202 
16343	301	S10   
16343	301	S1065 
16343	301	S11   
16343	301	S12   
16343	301	S182  
16343	301	S183  
16343	301	S203  
16343	301	S2202 
16343	301	S6    
16343	301	S7    
16343	301	S8    
16343	301	S9    
16397	301	S22   
16398	301	S10   
16398	301	S11   
16398	301	S12   
16398	301	S182  
16398	301	S183  
16398	301	S203  
16398	301	S22   
16398	301	S6    
16398	301	S7    
16398	301	S8    
16398	301	S9    
17202	301	S1082 
17203	301	S1082 
17204	301	S1082 
17218	301	S1581 
17219	301	S1581 
17332	301	S3    
17335	301	S3    
17340	301	S3    
17341	301	S3    
17342	301	S3    
17345	301	S3    
17346	301	S3    
17347	301	S3    
17348	301	S3    
18001	301	S1162 
18002	301	S1162 
18069	301	S20   
18079	301	S25   
18159	301	S21   
18166	301	S25   
18168	301	S25   
18215	301	S25   
18228	301	S23   
18231	301	S25   
18258	301	S1162 
18259	301	S1162 
18262	301	S1162 
18263	301	S1162 
18288	301	S27   
18350	301	S21   
18363	301	S22   
18364	301	S22   
18365	301	S27   
18376	301	S25   
18403	301	S27   
18927	301	S25   
18930	301	S2203 
18931	301	S2203 
18932	301	S27   
18933	301	S27   
18934	301	S27   
18935	301	S27   
18936	301	S27   
19003	301	S26   
19034	301	S26   
19035	301	S26   
19047	301	S1162 
19056	301	S26   
19057	301	S2109 
19058	301	S2109 
19064	301	S1164 
19076	301	S1164 
19078	301	S1069 
19109	301	S1164 
19120	301	S10   
19120	301	S1069 
19120	301	S11   
19120	301	S12   
19120	301	S6    
19120	301	S7    
19120	301	S8    
19120	301	S9    
19129	301	S10   
19129	301	S11   
19129	301	S12   
19129	301	S6    
19129	301	S7    
19129	301	S8    
19129	301	S9    
19155	301	S1164 
19230	301	S1063 
19283	301	S1067 
19300	301	S10   
19300	301	S11   
19300	301	S12   
19300	301	S6    
19300	301	S7    
19300	301	S8    
19300	301	S9    
19335	301	S10   
19335	301	S11   
19335	301	S12   
19335	301	S6    
19335	301	S7    
19335	301	S8    
19335	301	S9    
19337	301	S2109 
19350	301	S1164 
19856	301	S1067 
19868	301	S2109 
19873	301	S1067 
20046	301	S20   
20047	301	S20   
20048	301	S20   
20049	301	S20   
20100	301	S10   
20100	301	S11   
20100	301	S12   
20100	301	S20   
20100	301	S206  
20100	301	S208  
20100	301	S2682 
20100	301	S2683 
20100	301	S2684 
20100	301	S6    
20100	301	S7    
20100	301	S8    
20100	301	S9    
20109	301	S2105 
20110	301	S10   
20110	301	S11   
20110	301	S12   
20110	301	S206  
20110	301	S208  
20110	301	S2105 
20110	301	S2682 
20110	301	S2683 
20110	301	S2684 
20110	301	S6    
20110	301	S7    
20110	301	S8    
20110	301	S9    
20121	301	S10   
20121	301	S11   
20121	301	S12   
20121	301	S20   
20121	301	S206  
20121	301	S208  
20121	301	S2682 
20121	301	S2683 
20121	301	S2684 
20121	301	S6    
20121	301	S7    
20121	301	S8    
20121	301	S9    
20132	301	S1202 
20310	301	S10   
20310	301	S11   
20310	301	S12   
20310	301	S206  
20310	301	S208  
20310	301	S2105 
20310	301	S2682 
20310	301	S2683 
20310	301	S2684 
20310	301	S6    
20310	301	S7    
20310	301	S8    
20310	301	S9    
20321	301	S10   
20321	301	S11   
20321	301	S12   
20321	301	S20   
20321	301	S206  
20321	301	S208  
20321	301	S2682 
20321	301	S2683 
20321	301	S2684 
20321	301	S6    
20321	301	S7    
20321	301	S8    
20321	301	S9    
20400	301	S10   
20400	301	S11   
20400	301	S12   
20400	301	S20   
20400	301	S206  
20400	301	S208  
20400	301	S2682 
20400	301	S2683 
20400	301	S2684 
20400	301	S6    
20400	301	S7    
20400	301	S8    
20400	301	S9    
20409	301	S2105 
20410	301	S10   
20410	301	S11   
20410	301	S12   
20410	301	S206  
20410	301	S208  
20410	301	S2105 
20410	301	S2682 
20410	301	S2683 
20410	301	S2684 
20410	301	S6    
20410	301	S7    
20410	301	S8    
20410	301	S9    
20421	301	S10   
20421	301	S11   
20421	301	S12   
20421	301	S20   
20421	301	S206  
20421	301	S208  
20421	301	S2682 
20421	301	S2683 
20421	301	S2684 
20421	301	S6    
20421	301	S7    
20421	301	S8    
20421	301	S9    
20446	301	S20   
20447	301	S20   
20510	301	S10   
20510	301	S11   
20510	301	S12   
20510	301	S206  
20510	301	S208  
20510	301	S2105 
20510	301	S2682 
20510	301	S2683 
20510	301	S2684 
20510	301	S6    
20510	301	S7    
20510	301	S8    
20510	301	S9    
20521	301	S10   
20521	301	S11   
20521	301	S12   
20521	301	S20   
20521	301	S206  
20521	301	S208  
20521	301	S2682 
20521	301	S2683 
20521	301	S2684 
20521	301	S6    
20521	301	S7    
20521	301	S8    
20521	301	S9    
20623	301	S1742 
20624	301	S1742 
20628	301	S1742 
20629	301	S1742 
20630	301	S1742 
20634	301	S1742 
20635	301	S1742 
20636	301	S1742 
20640	301	S1742 
20641	301	S1742 
20645	301	S1742 
20646	301	S1742 
21138	301	S1064 
21138	301	S1066 
21138	301	S1122 
21141	301	S1064 
21224	301	S19   
21225	301	S19   
21226	301	S22   
21227	301	S22   
21229	301	S1122 
21238	301	S2801 
21239	301	S1066 
21240	301	S1066 
21241	301	S1066 
21242	301	S1066 
21243	301	S1066 
21244	301	S1066 
21245	301	S1066 
21246	301	S1066 
21247	301	S1066 
21248	301	S1066 
21249	301	S1064 
21250	301	S1064 
21251	301	S1064 
21252	301	S1064 
21253	301	S1064 
21254	301	S1064 
21255	301	S1064 
21256	301	S1064 
21257	301	S1064 
21259	301	S1064 
21260	301	S1082 
21261	301	S1082 
21262	301	S1082 
21263	301	S1082 
21264	301	S1082 
21265	301	S1082 
21266	301	S1082 
21267	301	S1082 
21268	301	S1082 
21269	301	S1082 
21270	301	S1082 
21271	301	S2108 
21272	301	S2108 
21273	301	S2108 
21274	301	S2108 
21275	301	S2108 
21276	301	S2108 
21277	301	S2110 
21278	301	S2110 
21280	301	S2110 
21282	301	S2110 
21283	301	S2111 
21284	301	S2111 
21285	301	S2111 
21286	301	S2111 
21287	301	S2112 
21288	301	S2112 
21289	301	S2112 
21290	301	S2112 
21291	301	S2112 
21292	301	S2112 
21293	301	S2782 
21294	301	S2782 
21295	301	S2782 
21296	301	S2782 
21297	301	S2782 
21298	301	S2782 
21299	301	S2110 
21299	301	S2111 
21299	301	S2112 
21299	301	S2782 
21300	301	S2110 
21300	301	S2112 
21300	301	S2782 
21301	301	S2110 
21301	301	S2111 
21301	301	S2112 
21301	301	S2782 
21302	301	S2110 
21302	301	S2111 
21302	301	S2112 
21302	301	S2782 
21303	301	S2110 
21303	301	S2112 
21303	301	S2782 
21304	301	S2110 
21304	301	S2111 
21304	301	S2112 
21304	301	S2782 
21308	301	S2801 
21309	301	S2801 
21310	301	S2801 
21311	301	S2801 
21312	301	S2801 
21313	301	S2801 
21314	301	S2801 
21315	301	S2801 
21316	301	S2801 
21317	301	S2801 
21318	301	S2801 
21319	301	S2801 
21320	301	S2801 
21321	301	S2801 
21322	301	S2801 
21323	301	S2801 
21324	301	S2801 
21325	301	S2801 
21326	301	S2801 
21337	301	S2801 
21342	301	S2801 
21343	301	S2801 
21346	301	S2801 
21347	301	S2801 
21348	301	S2801 
21349	301	S2801 
22247	301	S20   
22903	301	S21   
22904	301	S18   
22909	301	S22   
22911	301	S18   
22912	301	S19   
22914	301	S19   
22915	301	S19   
22916	301	S19   
23009	301	S2703 
23010	301	S2703 
23011	301	S2703 
23012	301	S2703 
23013	301	S2703 
23014	301	S2703 
23015	301	S2703 
23016	301	S2703 
23017	301	S2703 
23018	301	S2703 
23019	301	S2703 
23020	301	S2703 
23021	301	S2703 
23022	301	S2703 
23023	301	S2703 
23024	301	S2703 
23025	301	S2703 
23027	301	S2703 
23028	301	S2703 
23029	301	S2703 
23030	301	S2703 
23031	301	S2703 
23032	301	S2703 
23033	301	S2703 
23034	301	S2703 
23035	301	S2703 
23036	301	S2703 
23037	301	S2703 
23038	301	S2703 
23039	301	S2703 
23040	301	S2703 
23041	301	S2703 
23042	301	S2703 
23043	301	S2703 
23044	301	S2703 
23045	301	S2703 
23046	301	S2703 
23047	301	S2703 
23048	301	S2703 
23049	301	S2703 
23050	301	S2703 
23051	301	S2703 
23052	301	S2703 
23053	301	S2703 
23054	301	S2703 
23055	301	S2703 
23056	301	S2703 
23057	301	S2703 
23058	301	S2703 
23059	301	S2703 
23060	301	S2703 
23061	301	S2703 
23062	301	S2703 
23063	301	S2703 
23064	301	S2703 
23065	301	S2703 
23557	301	S14   
23558	301	S14   
23559	301	S14   
23560	301	S14   
23561	301	S14   
23562	301	S14   
23563	301	S14   
23564	301	S14   
23565	301	S14   
23566	301	S14   
23567	301	S14   
23568	301	S14   
23569	301	S14   
23570	301	S14   
23571	301	S14   
23572	301	S14   
23573	301	S14   
23574	301	S14   
23575	301	S14   
23576	301	S14   
23577	301	S14   
23578	301	S14   
23579	301	S14   
23580	301	S14   
23581	301	S14   
23582	301	S2    
23583	301	S2    
23584	301	S2    
23585	301	S2    
23586	301	S2    
23587	301	S2    
23588	301	S2    
23589	301	S2    
23590	301	S2    
23591	301	S2    
23592	301	S2    
23593	301	S2    
23594	301	S2    
23595	301	S2    
23596	301	S2    
23597	301	S2    
23598	301	S2    
23599	301	S2    
23600	301	S2    
23601	301	S2    
23602	301	S2    
23603	301	S2    
23604	301	S2    
23605	301	S2    
23606	301	S2    
23607	301	S2    
23608	301	S2    
23609	301	S2    
23610	301	S2    
23611	301	S2    
23612	301	S2    
23613	301	S2    
23614	301	S2    
23615	301	S2    
23616	301	S2    
23617	301	S2    
23618	301	S2    
23619	301	S2    
23620	301	S2    
23621	301	S2    
23622	301	S2    
23623	301	S2    
23624	301	S2    
23625	301	S2    
23626	301	S2    
23627	301	S2    
23628	301	S2    
23629	301	S2    
23630	301	S2    
23631	301	S2    
23632	301	S2    
23633	301	S2    
23634	301	S2    
23635	301	S2    
23636	301	S2    
23637	301	S2    
23638	301	S2    
23640	301	S1581 
23646	301	S2    
23647	301	S2    
23648	301	S2    
23649	301	S2    
23650	301	S2    
23651	301	S2    
23652	301	S2    
23653	301	S2    
23654	301	S2    
23655	301	S2    
23656	301	S2    
23657	301	S2    
23658	301	S2    
23659	301	S2    
23660	301	S2    
35001	301	D4961 
35003	301	D4961 
35004	301	D4961 
35008	301	D4961 
35009	301	D4961 
35011	301	D4961 
35012	301	D4961 
35013	301	D4961 
35014	301	D4961 
35015	301	D4961 
35016	301	D4961 
35017	301	D4961 
35022	301	D4961 
35023	301	D4961 
35024	301	D4961 
35025	301	D4961 
35026	301	D4961 
35027	301	D4961 
35028	301	D4961 
35029	301	D4961 
35030	301	D4961 
35034	301	D4961 
35038	301	D4961 
35039	301	D4961 
35040	301	D4961 
35041	301	D4961 
35043	301	D4961 
35047	301	D4961 
35048	301	D4961 
35051	301	D4961 
35054	301	D4961 
35056	301	D4961 
35057	301	D4961 
35058	301	D4961 
35059	301	D4961 
35060	301	D4961 
35065	301	D4961 
35066	301	D4961 
35067	301	D4961 
35068	301	D4961 
35070	301	D4961 
35071	301	D4961 
35072	301	D4961 
35073	301	D4961 
35074	301	D4961 
35078	301	D4961 
35080	301	D4961 
35081	301	D4961 
35084	301	D4961 
35086	301	D4961 
35087	301	D4961 
35088	301	D4961 
35090	301	D4961 
35093	301	D4961 
35130	301	S2381 
35131	301	S2381 
35132	301	S2381 
35133	301	S2381 
35134	301	S2381 
35135	301	S2381 
35136	301	S2381 
35137	301	S2381 
35138	301	S2381 
35140	301	S2381 
35141	301	S2381 
35142	301	S2381 
35143	301	S2381 
35144	301	S2381 
35145	301	S2381 
35146	301	S2381 
35147	301	S2381 
35148	301	S2381 
42190	301	S243  
42304	301	S5    
43158	301	S2109 
43215	301	S26   
43364	301	S26   
43378	301	S1082 
43514	301	S1067 
48052	301	S1362 
01001	303	S10   
01001	303	S11   
01001	303	S12   
01001	303	S6    
01001	303	S7    
01001	303	S8    
01001	303	S9    
01026	303	S25   
01032	303	S19   
01040	303	S10   
01040	303	S11   
01040	303	S12   
01040	303	S6    
01040	303	S7    
01040	303	S8    
01040	303	S9    
01042	303	S10   
01042	303	S11   
01042	303	S12   
01042	303	S19   
01042	303	S7    
01042	303	S8    
01042	303	S9    
01046	303	S19   
01077	303	S10   
01077	303	S11   
01077	303	S12   
01077	303	S27   
01077	303	S6    
01077	303	S7    
01077	303	S8    
01077	303	S9    
01079	303	S1063 
01082	303	S1063 
01085	303	S1063 
01103	303	S1163 
01123	303	S1063 
01123	303	S561  
01124	303	S1065 
01125	303	S1065 
01145	303	S10   
01145	303	S11   
01145	303	S12   
01145	303	S6    
01145	303	S7    
01145	303	S8    
01145	303	S9    
01202	303	S1163 
02048	303	S2109 
02048	303	S2922 
02053	303	S2109 
04017	303	S19   
04020	303	S19   
04021	303	S19   
04023	303	S19   
04053	303	S19   
04114	303	S19   
04120	303	S19   
04141	303	S19   
04142	303	S19   
04143	303	S19   
04144	303	S19   
04367	303	S19   
04610	303	S18   
04628	303	S18   
04629	303	S18   
04630	303	S19   
04631	303	S20   
04635	303	S19   
04636	303	S19   
04638	303	S26   
04639	303	S26   
04640	303	S26   
04641	303	S25   
04656	303	S2221 
04657	303	S2221 
04658	303	S2221 
04659	303	S2221 
04660	303	S2221 
04661	303	S2221 
04662	303	S2221 
04663	303	S2221 
05023	303	S1581 
05024	303	S1581 
05027	303	S1082 
05028	303	S1082 
05173	303	S1581 
05174	303	S1581 
05175	303	S1581 
05176	303	S1581 
05177	303	S1581 
05178	303	S1581 
05312	303	S26   
05313	303	S26   
05320	303	S26   
05623	303	D4282 
05624	303	S3    
05625	303	D4282 
05626	303	D4281 
05626	303	D4282 
05627	303	D4282 
05628	303	D4281 
05628	303	D4282 
05629	303	D4281 
05630	303	D4282 
05631	303	D4282 
05632	303	S3    
05643	303	D4301 
05644	303	D4301 
05645	303	D4301 
05646	303	D4301 
05647	303	D4301 
05648	303	D4301 
05649	303	D4301 
05650	303	D4301 
05651	303	D4301 
05652	303	D4301 
05653	303	D4301 
05654	303	D4301 
05655	303	D4301 
05656	303	D4301 
05657	303	D4301 
05658	303	D4301 
05661	303	S1082 
06016	303	S18   
06019	303	S18   
06043	303	S18   
06094	303	S18   
06128	303	S18   
06159	303	S18   
06164	303	S23   
06931	303	S22   
06982	303	S18   
06983	303	S18   
06984	303	S2104 
06985	303	S2104 
07002	303	S222  
07005	303	S248  
07006	303	S247  
07007	303	S1164 
07008	303	S238  
07011	303	S227  
07013	303	S242  
07014	303	S281  
07015	303	S248  
07016	303	S248  
07018	303	S226  
07021	303	S237  
07022	303	S21   
07028	303	S225  
07028	303	S230  
07034	303	S249  
07038	303	S281  
07039	303	S244  
07043	303	S230  
07052	303	S227  
07056	303	S248  
07057	303	S235  
07057	303	S238  
07058	303	S237  
07063	303	S1164 
07063	303	S582  
07064	303	S1164 
07068	303	S1041 
07075	303	S1164 
07076	303	S239  
07078	303	S228  
07078	303	S281  
07079	303	S13   
07079	303	S227  
07080	303	S227  
07089	303	S241  
07089	303	S251  
07207	303	S281  
07241	303	S21   
07276	303	S259  
07278	303	S259  
07279	303	S259  
07909	303	S259  
07910	303	S245  
07911	303	S226  
07912	303	S226  
07913	303	S238  
07914	303	S252  
07915	303	S281  
07916	303	S242  
07917	303	S242  
07918	303	S242  
07919	303	S252  
07920	303	S242  
07921	303	S228  
07922	303	S242  
07923	303	S245  
07924	303	S242  
07925	303	S281  
07926	303	S228  
07927	303	S227  
07928	303	S225  
07929	303	S227  
07930	303	S222  
07931	303	S222  
07932	303	S224  
07933	303	S224  
07934	303	S281  
07935	303	S224  
07936	303	S247  
07937	303	S239  
07938	303	S233  
07939	303	S235  
07940	303	S237  
07942	303	S281  
07944	303	S227  
07945	303	S21   
07949	303	S23   
07950	303	S23   
07951	303	S243  
07952	303	S1164 
07953	303	S1164 
07953	303	S582  
07954	303	S582  
07955	303	S1164 
07956	303	S1164 
07957	303	S1164 
07958	303	S1164 
07959	303	S1164 
07960	303	S1164 
08001	303	S1065 
08003	303	S2664 
08005	303	S2664 
08010	303	S702  
08011	303	S702  
08012	303	S1065 
08013	303	S1065 
08014	303	S1065 
08017	303	S603  
08018	303	S702  
08019	303	S603  
08020	303	S1065 
08023	303	S2664 
08025	303	S2662 
08026	303	S603  
08028	303	S2664 
08030	303	S1065 
08031	303	S2664 
08032	303	S2664 
08035	303	S603  
08045	303	S603  
08047	303	S702  
08048	303	S603  
08049	303	S702  
08050	303	S603  
08054	303	S702  
08057	303	S603  
08058	303	S2664 
08059	303	S702  
08060	303	S2664 
08061	303	S1065 
08064	303	S603  
08065	303	S1065 
08065	303	S2662 
08066	303	S702  
08067	303	S2664 
08068	303	S2664 
08069	303	S2664 
08071	303	S2664 
08074	303	S2662 
08077	303	S1065 
08078	303	S603  
08082	303	S603  
08083	303	S2502 
08085	303	S702  
08086	303	S603  
08087	303	S603  
08089	303	S603  
08092	303	S702  
08094	303	S702  
08116	303	S2502 
08124	303	S702  
08128	303	S702  
08130	303	S702  
08138	303	S2502 
08139	303	S603  
08146	303	S702  
08147	303	S1065 
08147	303	S2422 
08177	303	S2502 
08189	303	S2664 
08190	303	S603  
08194	303	S603  
08200	303	S702  
08202	303	S603  
08206	303	S2502 
08210	303	S702  
08211	303	S702  
08212	303	S702  
08214	303	S702  
08215	303	S702  
08216	303	S702  
08217	303	S2664 
08218	303	S1065 
08219	303	S702  
08220	303	S702  
08221	303	S702  
08225	303	S702  
08229	303	S702  
08231	303	S702  
08232	303	S702  
08243	303	S603  
08244	303	S603  
08245	303	S603  
08246	303	S603  
08247	303	S603  
08253	303	S2664 
08258	303	S2664 
08259	303	S2662 
08261	303	S603  
08262	303	S603  
08263	303	S603  
08266	303	S603  
08267	303	S603  
08268	303	S603  
08269	303	S603  
08270	303	S603  
08271	303	S603  
08272	303	S603  
08273	303	S603  
08274	303	S603  
08277	303	S603  
08278	303	S603  
08283	303	S2664 
08284	303	S2664 
08286	303	S2664 
08287	303	S2664 
08288	303	S2664 
08289	303	S2664 
08293	303	S702  
08294	303	S702  
08299	303	S702  
08309	303	S2664 
08315	303	S702  
08316	303	S702  
08317	303	S702  
08318	303	S2664 
08319	303	S2664 
08345	303	S603  
08346	303	S2502 
08347	303	S2502 
08348	303	S2502 
08349	303	S2502 
08350	303	S2502 
08351	303	S702  
08352	303	S702  
08353	303	S702  
08354	303	S702  
08355	303	S702  
08357	303	S702  
08358	303	S702  
08359	303	S702  
08360	303	S702  
08361	303	S702  
08362	303	S702  
08363	303	S702  
08364	303	S702  
08366	303	S702  
08367	303	S603  
08368	303	S603  
08370	303	S603  
08371	303	S603  
08372	303	S603  
08374	303	S2664 
08376	303	S2664 
08378	303	S2161 
08380	303	S2664 
08383	303	S2664 
08384	303	S2664 
08385	303	S2664 
08386	303	S2664 
08387	303	S2664 
08388	303	S2664 
08389	303	S682  
08390	303	S2664 
08391	303	S682  
08392	303	S2664 
08393	303	S2664 
08394	303	S702  
08395	303	S702  
08396	303	S702  
08397	303	S603  
08398	303	S603  
08399	303	S603  
08400	303	S881  
08401	303	S881  
08402	303	S702  
08403	303	S1209 
08408	303	S2502 
08409	303	S2502 
08410	303	S702  
08411	303	S702  
08412	303	S702  
08413	303	S702  
08414	303	S702  
08415	303	S702  
08416	303	S702  
08417	303	S702  
08418	303	S702  
08419	303	S702  
08420	303	S702  
08421	303	S702  
08422	303	S702  
08435	303	S1065 
08436	303	S702  
08444	303	S702  
08446	303	S702  
08448	303	S702  
08449	303	S702  
08450	303	S702  
08454	303	S2664 
08455	303	S2664 
08456	303	S2664 
08457	303	S2664 
08458	303	S2664 
08459	303	S2664 
08460	303	S2664 
08461	303	S2664 
08462	303	S2664 
08463	303	S2664 
08464	303	S2664 
08465	303	S2664 
08466	303	S2664 
08467	303	S2161 
08468	303	S2664 
08469	303	S2664 
08470	303	S2664 
08471	303	S2664 
08472	303	S2664 
08473	303	S2664 
08474	303	S2664 
08476	303	S2502 
08478	303	S2502 
08481	303	S2502 
08482	303	S2502 
08483	303	S2502 
08484	303	S2502 
08487	303	S2502 
08488	303	S2502 
08489	303	S2502 
08490	303	S2502 
08491	303	S2502 
08492	303	S2502 
08493	303	S2502 
08494	303	S2502 
08495	303	S2502 
08497	303	S2502 
08498	303	S2502 
08500	303	S2502 
08501	303	S2502 
08504	303	S2662 
08505	303	S2662 
08506	303	S2662 
08507	303	S2662 
08508	303	S2662 
08509	303	S2662 
09003	303	D4070 
09003	303	S1183 
09003	303	S561  
09021	303	S10   
09021	303	S11   
09021	303	S12   
09021	303	S206  
09021	303	S208  
09021	303	S7    
09021	303	S8    
09021	303	S9    
09032	303	S21   
09037	303	D4070 
09037	303	S1031 
09037	303	S1621 
09037	303	S381  
09037	303	S481  
09037	303	S502  
09038	303	S1031 
09038	303	S1621 
09038	303	S481  
09038	303	S502  
09039	303	D4070 
09039	303	S381  
09040	303	S10   
09040	303	S1023 
09040	303	S11   
09040	303	S12   
09040	303	S206  
09040	303	S208  
09040	303	S562  
09040	303	S6    
09040	303	S7    
09040	303	S73   
09040	303	S74   
09040	303	S8    
09040	303	S9    
09042	303	S461  
09042	303	S566  
09050	303	S1141 
09050	303	S421  
09050	303	S441  
09060	303	D4070 
09060	303	S381  
09062	303	S381  
09062	303	S404  
09070	303	D4070 
09070	303	S10   
09070	303	S11   
09070	303	S12   
09070	303	S182  
09070	303	S183  
09070	303	S201  
09070	303	S202  
09070	303	S203  
09070	303	S204  
09070	303	S205  
09070	303	S206  
09070	303	S208  
09070	303	S53   
09070	303	S582  
09070	303	S6    
09070	303	S73   
09070	303	S74   
09070	303	S8    
09070	303	S9    
09078	303	S561  
09079	303	S1701 
09087	303	S1032 
09087	303	S564  
09087	303	S582  
09094	303	S363  
09094	303	S582  
09112	303	D4070 
09112	303	S563  
09132	303	D4070 
09132	303	S10   
09132	303	S1062 
09132	303	S11   
09132	303	S12   
09132	303	S206  
09132	303	S208  
09132	303	S6    
09132	303	S7    
09132	303	S8    
09132	303	S9    
09139	303	S381  
09148	303	D4070 
09148	303	S1033 
09148	303	S363  
09148	303	S582  
09149	303	S381  
09160	303	S1065 
09181	303	D4070 
09181	303	S10   
09181	303	S1024 
09181	303	S11   
09181	303	S1121 
09181	303	S12   
09181	303	S206  
09181	303	S208  
09181	303	S461  
09181	303	S6    
09181	303	S7    
09181	303	S73   
09181	303	S74   
09181	303	S8    
09181	303	S9    
09183	303	S381  
09184	303	D4070 
09184	303	S1026 
09184	303	S562  
09184	303	S565  
09191	303	D4070 
09191	303	S421  
09191	303	S582  
09195	303	S1202 
09195	303	S1562 
09202	303	S564  
09218	303	S1065 
09218	303	S1161 
09236	303	D4070 
09236	303	S10   
09236	303	S11   
09236	303	S12   
09236	303	S461  
09236	303	S582  
09236	303	S6    
09236	303	S7    
09236	303	S73   
09236	303	S74   
09236	303	S8    
09236	303	S9    
09252	303	D4070 
09252	303	S10   
09252	303	S11   
09252	303	S12   
09252	303	S206  
09252	303	S208  
09252	303	S482  
09252	303	S541  
09252	303	S6    
09252	303	S7    
09252	303	S73   
09252	303	S74   
09252	303	S8    
09252	303	S9    
09266	303	D4070 
09266	303	S1167 
09266	303	S441  
09266	303	S561  
09273	303	S2104 
09273	303	S2985 
09279	303	S10   
09279	303	S11   
09279	303	S12   
09279	303	S206  
09279	303	S208  
09279	303	S421  
09279	303	S582  
09279	303	S6    
09279	303	S7    
09279	303	S73   
09279	303	S74   
09279	303	S8    
09279	303	S9    
09291	303	S10   
09291	303	S11   
09291	303	S12   
09291	303	S206  
09291	303	S208  
09291	303	S564  
09291	303	S566  
09291	303	S6    
09291	303	S7    
09291	303	S73   
09291	303	S74   
09291	303	S8    
09291	303	S9    
09298	303	S10   
09298	303	S11   
09298	303	S12   
09298	303	S206  
09298	303	S208  
09298	303	S5    
09298	303	S564  
09298	303	S566  
09298	303	S6    
09298	303	S7    
09298	303	S73   
09298	303	S74   
09298	303	S8    
09298	303	S9    
09302	303	S381  
09302	303	S461  
09302	303	S566  
09302	303	S963  
09316	303	S10   
09316	303	S11   
09316	303	S12   
09316	303	S182  
09316	303	S183  
09316	303	S201  
09316	303	S202  
09316	303	S203  
09316	303	S204  
09316	303	S205  
09316	303	S206  
09316	303	S208  
09316	303	S421  
09316	303	S566  
09316	303	S581  
09316	303	S6    
09316	303	S7    
09316	303	S73   
09316	303	S74   
09316	303	S8    
09316	303	S9    
09326	303	S10   
09326	303	S1027 
09326	303	S11   
09326	303	S12   
09326	303	S206  
09326	303	S208  
09326	303	S441  
09326	303	S461  
09326	303	S6    
09326	303	S7    
09326	303	S73   
09326	303	S74   
09326	303	S8    
09326	303	S9    
09328	303	S1206 
09409	303	S2104 
09409	303	S2985 
09421	303	S564  
09421	303	S582  
09422	303	S1202 
09427	303	D4053 
09428	303	D4053 
09429	303	D4070 
09429	303	S1167 
09429	303	S441  
09430	303	S441  
09430	303	S561  
09431	303	S2203 
09433	303	S2105 
09433	303	S2961 
10007	303	S1082 
10066	303	S1082 
10067	303	S1082 
10068	303	S1082 
10098	303	S1581 
10099	303	S1581 
10102	303	S1581 
10119	303	S1581 
10123	303	S1082 
10124	303	S1082 
10173	303	S1581 
10858	303	S1082 
10860	303	S1082 
10861	303	S1082 
10862	303	S1082 
10863	303	S1581 
10864	303	S1082 
11011	303	S1069 
11012	303	S1069 
11019	303	S10   
11019	303	S11   
11019	303	S12   
11019	303	S6    
11019	303	S7    
11019	303	S8    
11019	303	S9    
11090	303	S1121 
11090	303	S564  
11090	303	S619  
11091	303	S1121 
11091	303	S564  
11096	303	S1121 
11096	303	S482  
11097	303	S482  
11101	303	S10   
11101	303	S11   
11101	303	S12   
11101	303	S6    
11101	303	S7    
11101	303	S8    
11101	303	S9    
11112	303	S1065 
11113	303	S1065 
11124	303	S1062 
11124	303	S183  
11124	303	S201  
11124	303	S202  
11124	303	S203  
11124	303	S6    
11124	303	S618  
11125	303	S1062 
11130	303	S25   
11131	303	S25   
11143	303	S1121 
11143	303	S183  
11143	303	S201  
11143	303	S202  
11143	303	S203  
11143	303	S564  
11143	303	S6    
11157	303	S1202 
11205	303	S1062 
11206	303	S1062 
11206	303	S183  
11206	303	S201  
11206	303	S202  
11206	303	S203  
11206	303	S6    
11210	303	S10   
11210	303	S11   
11210	303	S12   
11210	303	S6    
11210	303	S7    
11210	303	S8    
11210	303	S9    
11243	303	S2941 
11250	303	S562  
11250	303	S565  
11251	303	S481  
11251	303	S503  
11251	303	S620  
11252	303	S10   
11252	303	S11   
11252	303	S12   
11252	303	S183  
11252	303	S201  
11252	303	S202  
11252	303	S203  
11252	303	S481  
11252	303	S562  
11252	303	S6    
11252	303	S624  
11252	303	S7    
11252	303	S8    
11252	303	S9    
11253	303	S541  
11253	303	S565  
11257	303	S541  
11257	303	S565  
11260	303	D429  
11260	303	D566  
11260	303	S10   
11260	303	S11   
11260	303	S12   
11260	303	S1821 
11260	303	S2941 
11260	303	S6    
11260	303	S7    
11260	303	S78   
11260	303	S8    
11260	303	S9    
11263	303	S2941 
11267	303	S2941 
11279	303	S10   
11279	303	S11   
11279	303	S12   
11279	303	S6    
11279	303	S7    
11279	303	S8    
11279	303	S9    
11282	303	S10   
11282	303	S1062 
11282	303	S11   
11282	303	S12   
11282	303	S183  
11282	303	S201  
11282	303	S202  
11282	303	S203  
11282	303	S6    
11282	303	S7    
11282	303	S8    
11282	303	S9    
11286	303	S1062 
11294	303	S563  
11294	303	S582  
11333	303	S1062 
11333	303	S183  
11333	303	S201  
11333	303	S202  
11333	303	S203  
11333	303	S6    
11333	303	S611  
11339	303	S1062 
11352	303	S563  
11352	303	S566  
11353	303	S563  
11353	303	S566  
11354	303	S563  
11354	303	S566  
11355	303	S563  
11355	303	S566  
11356	303	S563  
11356	303	S566  
11357	303	S563  
11357	303	S566  
11358	303	S563  
11358	303	S566  
11359	303	S2105 
11360	303	S183  
11360	303	S201  
11360	303	S202  
11360	303	S203  
11360	303	S2105 
11360	303	S6    
11394	303	S2105 
11395	303	S2105 
11398	303	S2105 
11399	303	S2105 
11402	303	S2105 
11403	303	S183  
11403	303	S201  
11403	303	S202  
11403	303	S203  
11403	303	S2105 
11403	303	S6    
11411	303	S2105 
11412	303	S2105 
11429	303	S1121 
11429	303	S363  
11429	303	S617  
11463	303	S25   
11464	303	S25   
11468	303	S12   
11468	303	S183  
11468	303	S201  
11468	303	S202  
11468	303	S203  
11507	303	S1062 
11508	303	S10   
11508	303	S1062 
11508	303	S11   
11508	303	S12   
11508	303	S183  
11508	303	S201  
11508	303	S202  
11508	303	S203  
11508	303	S6    
11508	303	S7    
11508	303	S8    
11508	303	S9    
11510	303	S1062 
11529	303	S183  
11529	303	S201  
11529	303	S202  
11529	303	S203  
11529	303	S441  
11529	303	S503  
11529	303	S6    
11529	303	S608  
11530	303	S441  
11540	303	S10   
11540	303	S11   
11540	303	S12   
11540	303	S183  
11540	303	S201  
11540	303	S202  
11540	303	S203  
11540	303	S6    
11540	303	S7    
11540	303	S8    
11540	303	S9    
11546	303	S21   
11546	303	S625  
11546	303	S626  
11546	303	S627  
11546	303	S641  
11547	303	S21   
11547	303	S625  
11547	303	S626  
11547	303	S627  
11549	303	S183  
11549	303	S201  
11549	303	S202  
11549	303	S203  
11549	303	S21   
11549	303	S6    
11565	303	S10   
11565	303	S11   
11565	303	S12   
11565	303	S6    
11565	303	S7    
11565	303	S8    
11565	303	S9    
11674	303	S183  
11674	303	S201  
11674	303	S202  
11674	303	S203  
11674	303	S563  
11674	303	S566  
11705	303	S1069 
11709	303	S10   
11709	303	S11   
11709	303	S12   
11709	303	S6    
11709	303	S7    
11709	303	S8    
11709	303	S9    
11742	303	S1121 
11742	303	S564  
11746	303	S10   
11746	303	S11   
11746	303	S12   
11746	303	S6    
11746	303	S7    
11746	303	S8    
11746	303	S9    
11752	303	S1065 
11757	303	S1062 
11760	303	S25   
11783	303	S10   
11783	303	S11   
11783	303	S12   
11783	303	S6    
11783	303	S7    
11783	303	S8    
11783	303	S9    
11803	303	S10   
11803	303	S11   
11803	303	S12   
11803	303	S6    
11803	303	S7    
11803	303	S8    
11803	303	S9    
11821	303	S1062 
11828	303	S183  
11828	303	S201  
11828	303	S202  
11828	303	S203  
11828	303	S563  
11828	303	S566  
11841	303	S183  
11841	303	S201  
11841	303	S202  
11841	303	S203  
11841	303	S2105 
11841	303	S6    
11842	303	S2105 
11856	303	S25   
11858	303	S12   
11858	303	S183  
11858	303	S201  
11858	303	S202  
11858	303	S203  
11875	303	S10   
11875	303	S1062 
11875	303	S11   
11875	303	S12   
11875	303	S183  
11875	303	S201  
11875	303	S202  
11875	303	S203  
11875	303	S6    
11875	303	S7    
11875	303	S8    
11875	303	S9    
11876	303	S1062 
11884	303	S441  
11886	303	S10   
11886	303	S11   
11886	303	S12   
11886	303	S183  
11886	303	S201  
11886	303	S202  
11886	303	S203  
11886	303	S6    
11886	303	S7    
11886	303	S8    
11886	303	S9    
11887	303	S21   
11887	303	S625  
11887	303	S626  
11887	303	S627  
11887	303	S641  
11888	303	S21   
11888	303	S625  
11888	303	S626  
11888	303	S627  
11921	303	S1062 
11935	303	S183  
11935	303	S202  
11935	303	S203  
11935	303	S22   
11935	303	S6    
11949	303	S183  
11949	303	S202  
11949	303	S203  
11949	303	S22   
11949	303	S6    
11950	303	S2941 
11960	303	S481  
11960	303	S562  
11987	303	S1202 
11987	303	S2941 
11990	303	S1202 
11991	303	S1202 
11992	303	S2941 
12038	303	S661  
12038	303	S961  
12061	303	S141  
12062	303	S141  
12063	303	S141  
12065	303	S141  
12078	303	S1063 
12078	303	S503  
12086	303	S343  
12086	303	S363  
12086	303	S5    
12086	303	S502  
12087	303	S343  
12120	303	S83   
12121	303	S83   
12122	303	S83   
12131	303	S77   
12132	303	S77   
12142	303	S85   
12143	303	S85   
12144	303	S85   
12147	303	S502  
12147	303	S564  
12151	303	S101  
12151	303	S86   
12152	303	S101  
12152	303	S86   
12154	303	S941  
12155	303	S79   
12201	303	S1164 
12220	303	D4743 
12220	303	S1221 
12220	303	S2109 
12538	303	S661  
12538	303	S961  
12563	303	S141  
12565	303	S141  
12586	303	S343  
12586	303	S363  
12586	303	S5    
12586	303	S502  
12632	303	S77   
12643	303	S85   
12644	303	S85   
12652	303	S101  
12652	303	S86   
13019	303	S2    
13020	303	S2    
13055	303	S2    
13065	303	S2    
13067	303	S2    
13068	303	S2    
13070	303	S2    
13096	303	S2    
13098	303	S2    
13165	303	S2    
13232	303	S221  
13235	303	S221  
13236	303	S221  
13318	303	S1581 
13320	303	S1581 
13321	303	S1581 
13322	303	S1581 
13323	303	S1581 
13324	303	S1581 
13325	303	S1082 
13326	303	S1082 
13327	303	S1082 
13340	303	S1581 
13341	303	S1581 
13343	303	S2    
13355	303	S230  
13355	303	S231  
13369	303	S2    
13370	303	S2    
13373	303	S2    
13375	303	S2    
13377	303	S2    
13378	303	S2    
13391	303	S2    
13394	303	S2    
13398	303	S2    
13399	303	S2    
13401	303	S2    
13402	303	S2    
13404	303	S2    
13405	303	S2    
13407	303	S2    
13408	303	S2    
13410	303	S2    
13411	303	S2    
13413	303	S2    
13414	303	S2    
13415	303	S2    
13416	303	S2    
13417	303	S2    
13418	303	S2    
13419	303	S2    
13420	303	S2    
13421	303	S2    
13422	303	S2    
13423	303	S2    
13424	303	S2    
13425	303	S2    
13426	303	S2    
13439	303	S2    
13440	303	S2    
13441	303	S2    
13442	303	S2    
13443	303	S2    
13444	303	S2    
13445	303	S2    
13446	303	S2    
13447	303	S2    
13448	303	S2    
13449	303	S2    
13450	303	S2    
13451	303	S2    
13452	303	S2    
13453	303	S2    
13454	303	S2    
13455	303	S2    
13456	303	S2    
13467	303	S221  
13468	303	S221  
13469	303	S221  
13470	303	S221  
13481	303	S221  
13482	303	S221  
13483	303	S221  
13484	303	S221  
13485	303	S2    
13486	303	S2    
13487	303	S2    
13488	303	S2    
13490	303	S2    
13491	303	S2    
13492	303	S2    
13493	303	S2    
13494	303	S14   
13495	303	S14   
13496	303	S14   
13497	303	S14   
13498	303	S14   
13565	303	S2703 
13566	303	S2703 
13567	303	S2703 
13568	303	S2703 
13569	303	S2703 
13805	303	S2    
13806	303	S2    
13809	303	S2    
13810	303	S2    
13811	303	S2    
13812	303	S2    
13813	303	S2    
13814	303	S2    
13850	303	S2    
13851	303	S2    
13853	303	S2    
13854	303	S2    
13856	303	S2    
13857	303	S2    
13868	303	S2    
13869	303	S2    
13870	303	S2    
13871	303	S2    
13872	303	S2    
13873	303	S2    
13874	303	S2    
13875	303	S2    
13876	303	S2    
13877	303	S2    
13878	303	S2    
13879	303	S2    
13880	303	S2    
13881	303	S2    
13882	303	S2    
13891	303	S2    
13893	303	S2    
13894	303	S2    
13896	303	S2    
13898	303	S2    
13900	303	S2    
13909	303	S2    
13910	303	S2    
13911	303	S2    
13912	303	S2    
13913	303	S2    
13914	303	S2    
13917	303	S2    
13918	303	S2    
13920	303	S2    
13921	303	S2    
13923	303	S2    
13924	303	S2    
13929	303	S2    
13930	303	S2    
13931	303	S2    
13932	303	S2    
13934	303	S2    
13935	303	S2    
13943	303	S221  
13946	303	S221  
13947	303	S221  
13948	303	S2    
13949	303	S2    
13950	303	S2    
13951	303	S2    
13952	303	S2    
13953	303	S2    
13954	303	S2    
13955	303	S2    
13956	303	S2    
13957	303	S2    
13958	303	S2    
13959	303	S2    
13968	303	S2    
13969	303	S2    
13970	303	S2    
13971	303	S2    
13985	303	S2    
13988	303	S2703 
13989	303	S2703 
13990	303	S2703 
13991	303	S2703 
13992	303	S2703 
13994	303	S2703 
13995	303	S2703 
13996	303	S2703 
13997	303	S2703 
13998	303	S2703 
14003	303	S2103 
14006	303	S2103 
14052	303	S10   
14052	303	S11   
14052	303	S12   
14052	303	S6    
14052	303	S7    
14052	303	S8    
14052	303	S9    
14084	303	S2103 
14096	303	S2103 
14106	303	S2103 
14137	303	S1068 
14144	303	S1068 
14145	303	S1064 
14145	303	S1066 
14145	303	S1068 
14145	303	S1122 
14146	303	S1068 
14147	303	S1068 
14148	303	S1068 
14149	303	S1068 
14154	303	S2702 
14156	303	S2702 
14166	303	S10   
14166	303	S11   
14166	303	S12   
14166	303	S6    
14166	303	S7    
14166	303	S8    
14166	303	S9    
14209	303	S1064 
14209	303	S1066 
14209	303	S1122 
14209	303	S23   
14219	303	S10   
14219	303	S11   
14219	303	S12   
14219	303	S6    
14219	303	S7    
14219	303	S8    
14219	303	S9    
14238	303	S2104 
14242	303	S2104 
14267	303	S10   
14267	303	S11   
14267	303	S12   
14267	303	S6    
14267	303	S7    
14267	303	S8    
14267	303	S9    
14323	303	S1067 
14347	303	S1064 
14347	303	S1122 
14366	303	S2104 
14370	303	S2104 
14382	303	S1164 
14400	303	S1064 
14400	303	S1066 
14400	303	S1068 
14400	303	S1122 
14416	303	S1066 
14416	303	S1068 
14416	303	S1122 
14429	303	S20   
14429	303	S23   
14429	303	S25   
14432	303	S1068 
14433	303	S1068 
14434	303	S1068 
14440	303	S2109 
14450	303	S1164 
14460	303	S1164 
14461	303	S1164 
14462	303	S2109 
14475	303	S1068 
14476	303	S1068 
14555	303	S1068 
14559	303	S1068 
14601	303	S1066 
14602	303	S2103 
15027	303	S10   
15027	303	S11   
15027	303	S1163 
15027	303	S12   
15027	303	S9    
15073	303	S1163 
15078	303	S2621 
15087	303	S2109 
15152	303	S2104 
15232	303	S1163 
15260	303	S2109 
15261	303	S1163 
15262	303	S1163 
16006	303	S1164 
16010	303	S1164 
16011	303	S1164 
16028	303	S10   
16028	303	S11   
16028	303	S12   
16028	303	S182  
16028	303	S183  
16028	303	S203  
16028	303	S6    
16028	303	S7    
16028	303	S8    
16028	303	S9    
16029	303	S1164 
16037	303	S1164 
16037	303	S2202 
16038	303	S1164 
16038	303	S182  
16038	303	S183  
16038	303	S203  
16038	303	S2202 
16042	303	S1065 
16042	303	S2202 
16043	303	S10   
16043	303	S1065 
16043	303	S11   
16043	303	S12   
16043	303	S182  
16043	303	S183  
16043	303	S203  
16043	303	S2202 
16043	303	S6    
16043	303	S7    
16043	303	S8    
16043	303	S9    
16089	303	S563  
16097	303	S22   
16098	303	S10   
16098	303	S11   
16098	303	S12   
16098	303	S182  
16098	303	S183  
16098	303	S203  
16098	303	S22   
16098	303	S6    
16098	303	S7    
16098	303	S8    
16098	303	S9    
16112	303	S39   
16114	303	S39   
16120	303	S39   
16123	303	S39   
16126	303	S39   
16139	303	S39   
16147	303	S2104 
16159	303	D342  
16159	303	S39   
16167	303	S2203 
16174	303	S18   
16338	303	S1164 
16338	303	S182  
16338	303	S183  
16338	303	S203  
16338	303	S2202 
16343	303	S10   
16343	303	S1065 
16343	303	S11   
16343	303	S12   
16343	303	S182  
16343	303	S183  
16343	303	S203  
16343	303	S2202 
16343	303	S6    
16343	303	S7    
16343	303	S8    
16343	303	S9    
16397	303	S22   
16398	303	S10   
16398	303	S11   
16398	303	S12   
16398	303	S182  
16398	303	S183  
16398	303	S203  
16398	303	S22   
16398	303	S6    
16398	303	S7    
16398	303	S8    
16398	303	S9    
17202	303	S1082 
17203	303	S1082 
17204	303	S1082 
17218	303	S1581 
17219	303	S1581 
17332	303	S3    
17335	303	S3    
17340	303	S3    
17341	303	S3    
17342	303	S3    
17345	303	S3    
17346	303	S3    
17347	303	S3    
17348	303	S3    
18001	303	S1162 
18002	303	S1162 
18069	303	S20   
18079	303	S25   
18159	303	S21   
18166	303	S25   
18168	303	S25   
18215	303	S25   
18228	303	S23   
18231	303	S25   
18258	303	S1162 
18259	303	S1162 
18262	303	S1162 
18263	303	S1162 
18288	303	S27   
18350	303	S21   
18363	303	S22   
18364	303	S22   
18365	303	S27   
18376	303	S25   
18403	303	S27   
18927	303	S25   
18930	303	S2203 
18932	303	S27   
18933	303	S27   
18934	303	S27   
18935	303	S27   
18936	303	S27   
19003	303	S26   
19034	303	S26   
19035	303	S26   
19047	303	S1162 
19056	303	S26   
19057	303	S2109 
19058	303	S2109 
19064	303	S1164 
19076	303	S1164 
19078	303	S1069 
19109	303	S1164 
19120	303	S10   
19120	303	S1069 
19120	303	S11   
19120	303	S12   
19120	303	S6    
19120	303	S7    
19120	303	S8    
19120	303	S9    
19129	303	S10   
19129	303	S11   
19129	303	S12   
19129	303	S6    
19129	303	S7    
19129	303	S8    
19129	303	S9    
19155	303	S1164 
19230	303	S1063 
19283	303	S1067 
19300	303	S10   
19300	303	S11   
19300	303	S12   
19300	303	S6    
19300	303	S7    
19300	303	S8    
19300	303	S9    
19335	303	S10   
19335	303	S11   
19335	303	S12   
19335	303	S6    
19335	303	S7    
19335	303	S8    
19335	303	S9    
19337	303	S2109 
19350	303	S1164 
19411	303	S26   
19856	303	S1067 
19868	303	S2109 
19873	303	S1067 
20046	303	S20   
20047	303	S20   
20048	303	S20   
20049	303	S20   
20099	303	S1163 
20099	303	S20   
20099	303	S5    
20100	303	S10   
20100	303	S11   
20100	303	S1163 
20100	303	S12   
20100	303	S20   
20100	303	S206  
20100	303	S208  
20100	303	S2682 
20100	303	S2683 
20100	303	S2684 
20100	303	S6    
20100	303	S7    
20100	303	S8    
20100	303	S9    
20109	303	S2105 
20110	303	S10   
20110	303	S11   
20110	303	S12   
20110	303	S206  
20110	303	S208  
20110	303	S2105 
20110	303	S2682 
20110	303	S2683 
20110	303	S2684 
20110	303	S6    
20110	303	S7    
20110	303	S8    
20110	303	S9    
20120	303	S1163 
20120	303	S20   
20120	303	S5    
20121	303	S10   
20121	303	S11   
20121	303	S1163 
20121	303	S12   
20121	303	S20   
20121	303	S206  
20121	303	S208  
20121	303	S2682 
20121	303	S2683 
20121	303	S2684 
20121	303	S6    
20121	303	S7    
20121	303	S8    
20121	303	S9    
20132	303	S1202 
20310	303	S10   
20310	303	S11   
20310	303	S12   
20310	303	S206  
20310	303	S208  
20310	303	S2105 
20310	303	S2682 
20310	303	S2683 
20310	303	S2684 
20310	303	S6    
20310	303	S7    
20310	303	S8    
20310	303	S9    
20321	303	S10   
20321	303	S11   
20321	303	S1163 
20321	303	S12   
20321	303	S20   
20321	303	S206  
20321	303	S208  
20321	303	S2682 
20321	303	S2683 
20321	303	S2684 
20321	303	S6    
20321	303	S7    
20321	303	S8    
20321	303	S9    
20446	303	S2722 
20623	303	S1742 
20624	303	S1742 
20628	303	S1742 
20629	303	S1742 
20630	303	S1742 
20634	303	S1742 
20635	303	S1742 
20636	303	S1742 
20640	303	S1742 
20641	303	S1742 
20645	303	S1742 
20646	303	S1742 
21138	303	S1064 
21138	303	S1066 
21138	303	S1122 
21141	303	S1064 
21224	303	S19   
21225	303	S19   
21226	303	S22   
21227	303	S22   
21229	303	S1122 
21238	303	S2801 
21239	303	S1066 
21240	303	S1066 
21241	303	S1066 
21242	303	S1066 
21243	303	S1066 
21244	303	S1066 
21245	303	S1066 
21246	303	S1066 
21247	303	S1066 
21248	303	S1066 
21249	303	S1064 
21250	303	S1064 
21251	303	S1064 
21252	303	S1064 
21253	303	S1064 
21254	303	S1064 
21255	303	S1064 
21256	303	S1064 
21257	303	S1064 
21259	303	S1064 
21260	303	S1082 
21261	303	S1082 
21262	303	S1082 
21263	303	S1082 
21264	303	S1082 
21265	303	S1082 
21266	303	S1082 
21267	303	S1082 
21268	303	S1082 
21269	303	S1082 
21270	303	S1082 
21271	303	S2108 
21272	303	S2108 
21273	303	S2108 
21274	303	S2108 
21275	303	S2108 
21276	303	S2108 
21277	303	S2110 
21278	303	S2110 
21279	303	S2110 
21280	303	S2110 
21281	303	S2110 
21282	303	S2110 
21283	303	S2111 
21284	303	S2111 
21285	303	S2111 
21286	303	S2111 
21287	303	S2112 
21288	303	S2112 
21289	303	S2112 
21290	303	S2112 
21291	303	S2112 
21292	303	S2112 
21293	303	S2782 
21294	303	S2782 
21295	303	S2782 
21296	303	S2782 
21297	303	S2782 
21298	303	S2782 
21299	303	S2110 
21299	303	S2111 
21299	303	S2112 
21299	303	S2782 
21300	303	S2110 
21300	303	S2112 
21300	303	S2782 
21301	303	S2110 
21301	303	S2111 
21301	303	S2112 
21301	303	S2782 
21302	303	S2110 
21302	303	S2111 
21302	303	S2112 
21302	303	S2782 
21303	303	S2110 
21303	303	S2112 
21303	303	S2782 
21304	303	S2110 
21304	303	S2111 
21304	303	S2112 
21304	303	S2782 
21308	303	S2801 
21309	303	S2801 
21310	303	S2801 
21311	303	S2801 
21312	303	S2801 
21313	303	S2801 
21314	303	S2801 
21315	303	S2801 
21316	303	S2801 
21317	303	S2801 
21318	303	S2801 
21319	303	S2801 
21320	303	S2801 
21321	303	S2801 
21322	303	S2801 
21323	303	S2801 
21324	303	S2801 
21325	303	S2801 
21326	303	S2801 
21337	303	S2801 
21342	303	S2801 
21343	303	S2801 
21346	303	S2801 
21347	303	S2801 
21348	303	S2801 
21349	303	S2801 
22247	303	S20   
22903	303	S21   
22904	303	S18   
22909	303	S22   
22911	303	S18   
22912	303	S19   
22914	303	S19   
22915	303	S19   
22916	303	S19   
23009	303	S2703 
23010	303	S2703 
23011	303	S2703 
23012	303	S2703 
23013	303	S2703 
23014	303	S2703 
23015	303	S2703 
23016	303	S2703 
23017	303	S2703 
23018	303	S2703 
23019	303	S2703 
23020	303	S2703 
23021	303	S2703 
23022	303	S2703 
23023	303	S2703 
23024	303	S2703 
23025	303	S2703 
23027	303	S2703 
23028	303	S2703 
23029	303	S2703 
23030	303	S2703 
23031	303	S2703 
23032	303	S2703 
23033	303	S2703 
23034	303	S2703 
23035	303	S2703 
23036	303	S2703 
23037	303	S2703 
23038	303	S2703 
23039	303	S2703 
23040	303	S2703 
23041	303	S2703 
23042	303	S2703 
23043	303	S2703 
23044	303	S2703 
23045	303	S2703 
23046	303	S2703 
23047	303	S2703 
23048	303	S2703 
23049	303	S2703 
23050	303	S2703 
23051	303	S2703 
23052	303	S2703 
23053	303	S2703 
23054	303	S2703 
23055	303	S2703 
23056	303	S2703 
23057	303	S2703 
23058	303	S2703 
23059	303	S2703 
23060	303	S2703 
23061	303	S2703 
23062	303	S2703 
23063	303	S2703 
23064	303	S2703 
23065	303	S2703 
23557	303	S14   
23558	303	S14   
23559	303	S14   
23560	303	S14   
23561	303	S14   
23562	303	S14   
23563	303	S14   
23564	303	S14   
23565	303	S14   
23566	303	S14   
23567	303	S14   
23568	303	S14   
23569	303	S14   
23570	303	S14   
23571	303	S14   
23572	303	S14   
23573	303	S14   
23574	303	S14   
23575	303	S14   
23576	303	S14   
23577	303	S14   
23578	303	S14   
23579	303	S14   
23580	303	S14   
23581	303	S14   
23582	303	S2    
23583	303	S2    
23584	303	S2    
23585	303	S2    
23586	303	S2    
23587	303	S2    
23588	303	S2    
23589	303	S2    
23590	303	S2    
23591	303	S2    
23592	303	S2    
23593	303	S2    
23594	303	S2    
23595	303	S2    
23596	303	S2    
23597	303	S2    
23598	303	S2    
23599	303	S2    
23600	303	S2    
23601	303	S2    
23602	303	S2    
23603	303	S2    
23604	303	S2    
23605	303	S2    
23606	303	S2    
23607	303	S2    
23608	303	S2    
23609	303	S2    
23610	303	S2    
23611	303	S2    
23612	303	S2    
23613	303	S2    
23614	303	S2    
23615	303	S2    
23616	303	S2    
23617	303	S2    
23618	303	S2    
23619	303	S2    
23620	303	S2    
23621	303	S2    
23622	303	S2    
23623	303	S2    
23624	303	S2    
23625	303	S2    
23626	303	S2    
23627	303	S2    
23628	303	S2    
23629	303	S2    
23630	303	S2    
23631	303	S2    
23632	303	S2    
23633	303	S2    
23634	303	S2    
23635	303	S2    
23636	303	S2    
23637	303	S2    
23638	303	S2    
23640	303	S1581 
23646	303	S2    
23647	303	S2    
23648	303	S2    
23649	303	S2    
23650	303	S2    
23651	303	S2    
23652	303	S2    
23653	303	S2    
23654	303	S2    
23655	303	S2    
23656	303	S2    
23657	303	S2    
23658	303	S2    
23659	303	S2    
23660	303	S2    
35001	303	D4961 
35002	303	D4961 
35003	303	D4961 
35004	303	D4961 
35008	303	D4961 
35011	303	D4961 
35012	303	D4961 
35014	303	D4961 
35015	303	D4961 
35016	303	D4961 
35017	303	D4961 
35021	303	D4961 
35022	303	D4961 
35023	303	D4961 
35024	303	D4961 
35025	303	D4961 
35026	303	D4961 
35027	303	D4961 
35028	303	D4961 
35029	303	D4961 
35030	303	D4961 
35034	303	D4961 
35038	303	D4961 
35039	303	D4961 
35041	303	D4961 
35043	303	D4961 
35047	303	D4961 
35048	303	D4961 
35051	303	D4961 
35054	303	D4961 
35055	303	D4961 
35056	303	D4961 
35057	303	D4961 
35058	303	D4961 
35059	303	D4961 
35060	303	D4961 
35065	303	D4961 
35066	303	D4961 
35067	303	D4961 
35068	303	D4961 
35070	303	D4961 
35071	303	D4961 
35072	303	D4961 
35073	303	D4961 
35074	303	D4961 
35075	303	D4961 
35078	303	D4961 
35079	303	D4961 
35080	303	D4961 
35081	303	D4961 
35082	303	D4961 
35083	303	D4961 
35085	303	D4961 
35087	303	D4961 
35088	303	D4961 
35089	303	D4961 
35090	303	D4961 
35091	303	D4961 
35092	303	D4961 
35093	303	D4961 
35130	303	S2381 
35131	303	S2381 
35132	303	S2381 
35133	303	S2381 
35134	303	S2381 
35135	303	S2381 
35136	303	S2381 
35137	303	S2381 
35138	303	S2381 
35140	303	S2381 
35141	303	S2381 
35142	303	S2381 
35143	303	S2381 
35144	303	S2381 
35145	303	S2381 
35146	303	S2381 
35147	303	S2381 
35148	303	S2381 
42190	303	S243  
43158	303	S2109 
43215	303	S26   
43329	303	S25   
43364	303	S26   
43378	303	S1082 
43514	303	S1067 
48052	303	S1362 
01001	304	S10   
01001	304	S11   
01001	304	S12   
01001	304	S6    
01001	304	S7    
01001	304	S8    
01001	304	S9    
01026	304	S25   
01032	304	S19   
01040	304	S10   
01040	304	S11   
01040	304	S12   
01040	304	S6    
01040	304	S7    
01040	304	S8    
01040	304	S9    
01042	304	S10   
01042	304	S11   
01042	304	S12   
01042	304	S19   
01042	304	S6    
01042	304	S7    
01042	304	S8    
01042	304	S9    
01046	304	S19   
01077	304	S10   
01077	304	S11   
01077	304	S12   
01077	304	S27   
01077	304	S6    
01077	304	S7    
01077	304	S8    
01077	304	S9    
01079	304	S10   
01079	304	S1063 
01079	304	S11   
01079	304	S12   
01079	304	S7    
01079	304	S8    
01079	304	S9    
01082	304	S1063 
01085	304	S10   
01085	304	S1063 
01085	304	S11   
01085	304	S12   
01085	304	S6    
01085	304	S7    
01085	304	S8    
01085	304	S9    
01103	304	S1163 
01123	304	S1063 
01123	304	S561  
01124	304	S1065 
01125	304	S1065 
01145	304	S10   
01145	304	S11   
01145	304	S12   
01145	304	S6    
01145	304	S7    
01145	304	S8    
01145	304	S9    
01202	304	S1163 
02048	304	S2109 
02053	304	S2109 
04017	304	S19   
04020	304	S19   
04021	304	S19   
04023	304	S19   
04053	304	S19   
04114	304	S19   
04120	304	S19   
04141	304	S19   
04142	304	S19   
04143	304	S19   
04144	304	S19   
04367	304	S19   
04610	304	S18   
04628	304	S18   
04629	304	S18   
04630	304	S19   
04631	304	S20   
04635	304	S19   
04636	304	S19   
04638	304	S26   
04639	304	S26   
04640	304	S26   
04641	304	S25   
04656	304	S2221 
04657	304	S2221 
04658	304	S2221 
04659	304	S2221 
04660	304	S2221 
04661	304	S2221 
04662	304	S2221 
04663	304	S2221 
05023	304	S1581 
05024	304	S1581 
05027	304	S1082 
05028	304	S1082 
05173	304	S1581 
05174	304	S1581 
05175	304	S1581 
05176	304	S1581 
05177	304	S1581 
05178	304	S1581 
05312	304	S26   
05313	304	S26   
05320	304	S26   
05623	304	D4282 
05624	304	S3    
05625	304	D4282 
05626	304	D4282 
05628	304	D4282 
05630	304	D4282 
05631	304	D4282 
05632	304	S3    
05661	304	S1082 
06016	304	S18   
06019	304	S18   
06043	304	S18   
06094	304	S18   
06128	304	S18   
06159	304	S18   
06164	304	S23   
06931	304	S22   
06982	304	S18   
06983	304	S18   
06984	304	S2104 
06985	304	S2104 
07002	304	S222  
07005	304	S248  
07007	304	S1164 
07008	304	S238  
07015	304	S248  
07016	304	S248  
07022	304	S21   
07039	304	S244  
07056	304	S248  
07057	304	S238  
07063	304	S1164 
07063	304	S582  
07064	304	S1164 
07068	304	S1041 
07075	304	S1164 
07241	304	S21   
07276	304	S259  
07278	304	S259  
07279	304	S259  
07909	304	S259  
07910	304	S245  
07913	304	S238  
07923	304	S245  
07931	304	S222  
07938	304	S233  
07939	304	S235  
07945	304	S21   
07949	304	S23   
07950	304	S23   
07951	304	S243  
07952	304	S1164 
07953	304	S1164 
07953	304	S582  
07954	304	S582  
07955	304	S1164 
07956	304	S1164 
07957	304	S1164 
07958	304	S1164 
07959	304	S1164 
07960	304	S1164 
08001	304	S1065 
08003	304	S2664 
08005	304	S2664 
08010	304	S702  
08011	304	S702  
08012	304	S1065 
08013	304	S1065 
08014	304	S1065 
08018	304	S702  
08020	304	S1065 
08023	304	S2664 
08025	304	S2662 
08028	304	S2664 
08030	304	S1065 
08031	304	S2664 
08032	304	S2664 
08035	304	S603  
08045	304	S603  
08047	304	S702  
08048	304	S603  
08049	304	S702  
08050	304	S603  
08054	304	S702  
08057	304	S603  
08058	304	S2664 
08059	304	S702  
08060	304	S2664 
08061	304	S1065 
08065	304	S1065 
08065	304	S2662 
08066	304	S702  
08067	304	S2664 
08068	304	S2664 
08069	304	S2664 
08074	304	S2662 
08077	304	S1065 
08082	304	S603  
08085	304	S702  
08089	304	S603  
08092	304	S702  
08094	304	S702  
08124	304	S702  
08128	304	S702  
08130	304	S702  
08139	304	S603  
08146	304	S702  
08147	304	S1065 
08147	304	S2422 
08189	304	S2664 
08190	304	S603  
08200	304	S702  
08202	304	S603  
08210	304	S702  
08211	304	S702  
08212	304	S702  
08214	304	S702  
08215	304	S702  
08216	304	S702  
08217	304	S2664 
08218	304	S1065 
08219	304	S702  
08220	304	S702  
08221	304	S702  
08225	304	S702  
08229	304	S702  
08231	304	S702  
08232	304	S702  
08243	304	S603  
08244	304	S603  
08245	304	S603  
08247	304	S603  
08253	304	S2664 
08258	304	S2664 
08259	304	S2662 
08261	304	S603  
08271	304	S603  
08277	304	S603  
08278	304	S603  
08283	304	S2664 
08284	304	S2664 
08286	304	S2664 
08287	304	S2664 
08288	304	S2664 
08289	304	S2664 
08293	304	S702  
08294	304	S702  
08299	304	S702  
08309	304	S2664 
08315	304	S702  
08316	304	S702  
08317	304	S702  
08318	304	S2664 
08319	304	S2664 
08345	304	S603  
08348	304	S2502 
08349	304	S2502 
08350	304	S2502 
08351	304	S702  
08352	304	S702  
08353	304	S702  
08354	304	S702  
08355	304	S702  
08357	304	S702  
08358	304	S702  
08359	304	S702  
08360	304	S702  
08361	304	S702  
08362	304	S702  
08363	304	S702  
08364	304	S702  
08366	304	S702  
08367	304	S603  
08371	304	S603  
08372	304	S603  
08374	304	S2664 
08378	304	S2161 
08380	304	S2664 
08383	304	S2664 
08384	304	S2664 
08385	304	S2664 
08386	304	S2664 
08387	304	S2664 
08390	304	S2664 
08392	304	S2664 
08393	304	S2664 
08394	304	S702  
08395	304	S702  
08396	304	S702  
08398	304	S603  
08399	304	S603  
08400	304	S881  
08401	304	S881  
08402	304	S702  
08403	304	S1209 
08408	304	S2502 
08410	304	S702  
08411	304	S702  
08412	304	S702  
08413	304	S702  
08414	304	S702  
08415	304	S702  
08416	304	S702  
08417	304	S702  
08418	304	S702  
08419	304	S702  
08420	304	S702  
08421	304	S702  
08422	304	S702  
08435	304	S1065 
08436	304	S702  
08444	304	S702  
08446	304	S702  
08448	304	S702  
08449	304	S702  
08450	304	S702  
08454	304	S2664 
08455	304	S2664 
08457	304	S2664 
08458	304	S2664 
08459	304	S2664 
08460	304	S2664 
08461	304	S2664 
08462	304	S2664 
08463	304	S2664 
08465	304	S2664 
08466	304	S2664 
08468	304	S2664 
08469	304	S2664 
08470	304	S2664 
08471	304	S2664 
08472	304	S2664 
08473	304	S2664 
08474	304	S2664 
08476	304	S2502 
08478	304	S2502 
08481	304	S2502 
08484	304	S2502 
08487	304	S2502 
08490	304	S2502 
08491	304	S2502 
08493	304	S2502 
08494	304	S2502 
08495	304	S2502 
08498	304	S2502 
08500	304	S2502 
08504	304	S2662 
08505	304	S2662 
08506	304	S2662 
08507	304	S2662 
08508	304	S2662 
08509	304	S2662 
09003	304	D4070 
09003	304	S1183 
09003	304	S502  
09003	304	S561  
09004	304	S502  
09021	304	S10   
09021	304	S11   
09021	304	S12   
09021	304	S206  
09021	304	S208  
09021	304	S7    
09021	304	S8    
09021	304	S9    
09032	304	S21   
09037	304	D4070 
09037	304	S1031 
09037	304	S381  
09037	304	S481  
09037	304	S502  
09038	304	S1031 
09038	304	S481  
09038	304	S502  
09039	304	D4070 
09039	304	S381  
09040	304	S10   
09040	304	S1023 
09040	304	S11   
09040	304	S12   
09040	304	S206  
09040	304	S208  
09040	304	S481  
09040	304	S562  
09040	304	S6    
09040	304	S7    
09040	304	S73   
09040	304	S74   
09040	304	S8    
09040	304	S9    
09042	304	S461  
09042	304	S566  
09050	304	S1141 
09050	304	S421  
09050	304	S441  
09060	304	D4070 
09060	304	S381  
09062	304	S381  
09062	304	S404  
09070	304	D4070 
09070	304	S10   
09070	304	S11   
09070	304	S12   
09070	304	S182  
09070	304	S183  
09070	304	S201  
09070	304	S202  
09070	304	S203  
09070	304	S204  
09070	304	S205  
09070	304	S206  
09070	304	S208  
09070	304	S53   
09070	304	S582  
09070	304	S6    
09070	304	S73   
09070	304	S74   
09070	304	S8    
09070	304	S9    
09078	304	S561  
09079	304	S1701 
09087	304	S1032 
09087	304	S564  
09087	304	S582  
09094	304	S363  
09094	304	S582  
09112	304	D4070 
09112	304	S482  
09112	304	S563  
09132	304	D4070 
09132	304	S10   
09132	304	S1062 
09132	304	S11   
09132	304	S12   
09132	304	S206  
09132	304	S208  
09132	304	S6    
09132	304	S7    
09132	304	S8    
09132	304	S9    
09139	304	S381  
09148	304	D4070 
09148	304	S1033 
09148	304	S363  
09148	304	S582  
09149	304	S381  
09160	304	S1065 
09181	304	D4070 
09181	304	S10   
09181	304	S1024 
09181	304	S11   
09181	304	S1121 
09181	304	S12   
09181	304	S206  
09181	304	S208  
09181	304	S461  
09181	304	S6    
09181	304	S7    
09181	304	S73   
09181	304	S74   
09181	304	S8    
09181	304	S9    
09183	304	S381  
09184	304	D4070 
09184	304	S1026 
09184	304	S562  
09184	304	S565  
09191	304	D4070 
09191	304	S421  
09191	304	S582  
09195	304	S1202 
09202	304	S482  
09202	304	S564  
09218	304	S1065 
09218	304	S1161 
09236	304	D4070 
09236	304	S10   
09236	304	S11   
09236	304	S12   
09236	304	S461  
09236	304	S582  
09236	304	S6    
09236	304	S7    
09236	304	S73   
09236	304	S74   
09236	304	S8    
09236	304	S9    
09252	304	D4070 
09252	304	S10   
09252	304	S11   
09252	304	S12   
09252	304	S206  
09252	304	S208  
09252	304	S482  
09252	304	S541  
09252	304	S6    
09252	304	S7    
09252	304	S73   
09252	304	S74   
09252	304	S8    
09252	304	S9    
09266	304	D4070 
09266	304	S1167 
09266	304	S441  
09266	304	S561  
09273	304	S2104 
09279	304	S10   
09279	304	S11   
09279	304	S12   
09279	304	S206  
09279	304	S208  
09279	304	S421  
09279	304	S582  
09279	304	S6    
09279	304	S7    
09279	304	S73   
09279	304	S74   
09279	304	S8    
09279	304	S9    
09291	304	S10   
09291	304	S11   
09291	304	S12   
09291	304	S206  
09291	304	S208  
09291	304	S564  
09291	304	S566  
09291	304	S6    
09291	304	S7    
09291	304	S73   
09291	304	S74   
09291	304	S8    
09291	304	S9    
09298	304	S10   
09298	304	S11   
09298	304	S12   
09298	304	S206  
09298	304	S208  
09298	304	S564  
09298	304	S566  
09298	304	S6    
09298	304	S7    
09298	304	S73   
09298	304	S74   
09298	304	S8    
09298	304	S9    
09302	304	S381  
09302	304	S461  
09302	304	S566  
09302	304	S963  
09316	304	S10   
09316	304	S11   
09316	304	S12   
09316	304	S182  
09316	304	S183  
09316	304	S201  
09316	304	S202  
09316	304	S203  
09316	304	S204  
09316	304	S205  
09316	304	S206  
09316	304	S208  
09316	304	S421  
09316	304	S566  
09316	304	S581  
09316	304	S6    
09316	304	S7    
09316	304	S73   
09316	304	S74   
09316	304	S8    
09316	304	S9    
09326	304	S10   
09326	304	S1027 
09326	304	S11   
09326	304	S12   
09326	304	S206  
09326	304	S208  
09326	304	S441  
09326	304	S461  
09326	304	S6    
09326	304	S7    
09326	304	S73   
09326	304	S74   
09326	304	S8    
09326	304	S9    
09328	304	S1206 
09409	304	S2104 
09421	304	S564  
09421	304	S582  
09422	304	S1202 
09427	304	D4053 
09428	304	D4053 
09429	304	D4070 
09429	304	S1167 
09429	304	S441  
09430	304	S441  
09430	304	S561  
09431	304	S2203 
09432	304	S2203 
09433	304	S2105 
09433	304	S2961 
10007	304	S1082 
10066	304	S1082 
10067	304	S1082 
10068	304	S1082 
10098	304	S1581 
10099	304	S1581 
10102	304	S1581 
10119	304	S1581 
10123	304	S1082 
10124	304	S1082 
10173	304	S1581 
10858	304	S1082 
10860	304	S1082 
10861	304	S1082 
10862	304	S1082 
10863	304	S1581 
10864	304	S1082 
11011	304	S1069 
11012	304	S1069 
11019	304	S10   
11019	304	S11   
11019	304	S12   
11019	304	S6    
11019	304	S7    
11019	304	S8    
11019	304	S9    
11090	304	S1121 
11090	304	S564  
11090	304	S619  
11091	304	S1121 
11091	304	S564  
11096	304	S1121 
11096	304	S482  
11097	304	S482  
11101	304	S10   
11101	304	S11   
11101	304	S12   
11101	304	S6    
11101	304	S7    
11101	304	S8    
11101	304	S9    
11112	304	S1065 
11113	304	S1065 
11124	304	S1062 
11124	304	S183  
11124	304	S201  
11124	304	S202  
11124	304	S203  
11124	304	S6    
11124	304	S618  
11125	304	S1062 
11130	304	S25   
11131	304	S25   
11143	304	S1121 
11143	304	S183  
11143	304	S201  
11143	304	S202  
11143	304	S203  
11143	304	S564  
11143	304	S6    
11157	304	S1202 
11205	304	S1062 
11206	304	S1062 
11206	304	S183  
11206	304	S201  
11206	304	S202  
11206	304	S203  
11206	304	S6    
11210	304	S10   
11210	304	S11   
11210	304	S12   
11210	304	S6    
11210	304	S7    
11210	304	S8    
11210	304	S9    
11243	304	S2941 
11250	304	S562  
11250	304	S565  
11251	304	S481  
11251	304	S503  
11251	304	S620  
11252	304	S10   
11252	304	S11   
11252	304	S12   
11252	304	S183  
11252	304	S201  
11252	304	S202  
11252	304	S203  
11252	304	S481  
11252	304	S562  
11252	304	S6    
11252	304	S624  
11252	304	S7    
11252	304	S8    
11252	304	S9    
11253	304	S541  
11253	304	S565  
11257	304	S541  
11257	304	S565  
11260	304	S10   
11260	304	S11   
11260	304	S12   
11260	304	S2941 
11260	304	S6    
11260	304	S7    
11260	304	S78   
11260	304	S8    
11260	304	S9    
11263	304	S2941 
11267	304	S2941 
11279	304	S10   
11279	304	S11   
11279	304	S12   
11279	304	S6    
11279	304	S7    
11279	304	S8    
11279	304	S9    
11282	304	S10   
11282	304	S1062 
11282	304	S11   
11282	304	S12   
11282	304	S183  
11282	304	S201  
11282	304	S202  
11282	304	S203  
11282	304	S6    
11282	304	S7    
11282	304	S8    
11282	304	S9    
11286	304	S1062 
11294	304	S563  
11294	304	S582  
11333	304	S1062 
11333	304	S183  
11333	304	S201  
11333	304	S202  
11333	304	S203  
11333	304	S6    
11333	304	S611  
11339	304	S1062 
11352	304	S563  
11352	304	S566  
11353	304	S563  
11353	304	S566  
11354	304	S563  
11354	304	S566  
11355	304	S563  
11355	304	S566  
11356	304	S563  
11356	304	S566  
11357	304	S563  
11357	304	S566  
11358	304	S563  
11358	304	S566  
11359	304	S2105 
11360	304	S183  
11360	304	S201  
11360	304	S202  
11360	304	S203  
11360	304	S2105 
11360	304	S6    
11394	304	S2105 
11395	304	S2105 
11398	304	S2105 
11399	304	S2105 
11402	304	S2105 
11403	304	S183  
11403	304	S201  
11403	304	S202  
11403	304	S203  
11403	304	S2105 
11403	304	S6    
11411	304	S2105 
11412	304	S2105 
11429	304	S1121 
11429	304	S363  
11429	304	S617  
11463	304	S25   
11464	304	S25   
11468	304	S12   
11468	304	S183  
11468	304	S201  
11468	304	S202  
11468	304	S203  
11507	304	S1062 
11508	304	S10   
11508	304	S1062 
11508	304	S11   
11508	304	S12   
11508	304	S183  
11508	304	S201  
11508	304	S202  
11508	304	S203  
11508	304	S6    
11508	304	S7    
11508	304	S8    
11508	304	S9    
11510	304	S1062 
11529	304	S183  
11529	304	S201  
11529	304	S202  
11529	304	S203  
11529	304	S441  
11529	304	S503  
11529	304	S6    
11529	304	S608  
11530	304	S441  
11540	304	S10   
11540	304	S11   
11540	304	S12   
11540	304	S183  
11540	304	S201  
11540	304	S202  
11540	304	S203  
11540	304	S6    
11540	304	S7    
11540	304	S8    
11540	304	S9    
11546	304	S21   
11547	304	S21   
11549	304	S183  
11549	304	S201  
11549	304	S202  
11549	304	S203  
11549	304	S21   
11549	304	S6    
11565	304	S10   
11565	304	S11   
11565	304	S12   
11565	304	S6    
11565	304	S7    
11565	304	S8    
11565	304	S9    
11674	304	S183  
11674	304	S201  
11674	304	S202  
11674	304	S203  
11674	304	S563  
11674	304	S566  
11705	304	S1069 
11709	304	S10   
11709	304	S11   
11709	304	S12   
11709	304	S6    
11709	304	S7    
11709	304	S8    
11709	304	S9    
11742	304	S1121 
11742	304	S564  
11746	304	S10   
11746	304	S11   
11746	304	S12   
11746	304	S6    
11746	304	S7    
11746	304	S8    
11746	304	S9    
11752	304	S1065 
11757	304	S1062 
11760	304	S25   
11783	304	S10   
11783	304	S11   
11783	304	S12   
11783	304	S6    
11783	304	S7    
11783	304	S8    
11783	304	S9    
11803	304	S10   
11803	304	S11   
11803	304	S12   
11803	304	S6    
11803	304	S7    
11803	304	S8    
11803	304	S9    
11821	304	S1062 
11828	304	S183  
11828	304	S201  
11828	304	S202  
11828	304	S203  
11828	304	S563  
11828	304	S566  
11841	304	S183  
11841	304	S201  
11841	304	S202  
11841	304	S203  
11841	304	S2105 
11841	304	S6    
11842	304	S2105 
11856	304	S25   
11858	304	S12   
11858	304	S183  
11858	304	S201  
11858	304	S202  
11858	304	S203  
11875	304	S10   
11875	304	S1062 
11875	304	S11   
11875	304	S12   
11875	304	S183  
11875	304	S201  
11875	304	S202  
11875	304	S203  
11875	304	S6    
11875	304	S7    
11875	304	S8    
11875	304	S9    
11876	304	S1062 
11884	304	S441  
11886	304	S10   
11886	304	S11   
11886	304	S12   
11886	304	S183  
11886	304	S201  
11886	304	S202  
11886	304	S203  
11886	304	S6    
11886	304	S7    
11886	304	S8    
11886	304	S9    
11887	304	S21   
11888	304	S21   
11921	304	S1062 
11935	304	S183  
11935	304	S202  
11935	304	S203  
11935	304	S22   
11935	304	S6    
11949	304	S183  
11949	304	S202  
11949	304	S203  
11949	304	S22   
11949	304	S6    
11950	304	S2941 
11960	304	S481  
11960	304	S562  
11987	304	S1202 
11987	304	S2941 
11990	304	S1202 
11991	304	S1202 
11992	304	S2941 
12061	304	S141  
12062	304	S141  
12063	304	S141  
12065	304	S141  
12078	304	S1063 
12078	304	S503  
12086	304	S343  
12086	304	S363  
12086	304	S502  
12087	304	S343  
12120	304	S83   
12121	304	S83   
12122	304	S83   
12131	304	S77   
12132	304	S77   
12142	304	S85   
12143	304	S85   
12144	304	S85   
12147	304	S502  
12147	304	S564  
12151	304	S86   
12152	304	S86   
12154	304	S941  
12155	304	S79   
12201	304	S1164 
12220	304	D4743 
12220	304	S1221 
12220	304	S2109 
12563	304	S141  
12565	304	S141  
12586	304	S343  
12586	304	S363  
12586	304	S502  
12632	304	S77   
12643	304	S85   
12644	304	S85   
12652	304	S86   
13019	304	S2    
13020	304	S2    
13039	304	S221  
13055	304	S2    
13065	304	S2    
13067	304	S2    
13068	304	S2    
13070	304	S2    
13096	304	S2    
13098	304	S2    
13165	304	S2    
13231	304	S221  
13232	304	S221  
13235	304	S221  
13236	304	S221  
13318	304	S1581 
13320	304	S1581 
13321	304	S1581 
13322	304	S1581 
13323	304	S1581 
13324	304	S1581 
13325	304	S1082 
13326	304	S1082 
13327	304	S1082 
13340	304	S1581 
13341	304	S1581 
13343	304	S2    
13369	304	S2    
13370	304	S2    
13373	304	S2    
13375	304	S2    
13377	304	S2    
13378	304	S2    
13391	304	S2    
13394	304	S2    
13398	304	S2    
13399	304	S2    
13401	304	S2    
13402	304	S2    
13404	304	S2    
13405	304	S2    
13407	304	S2    
13408	304	S2    
13410	304	S2    
13411	304	S2    
13413	304	S2    
13414	304	S2    
13415	304	S2    
13416	304	S2    
13417	304	S2    
13418	304	S2    
13419	304	S2    
13420	304	S2    
13421	304	S2    
13422	304	S2    
13423	304	S2    
13424	304	S2    
13425	304	S2    
13426	304	S2    
13439	304	S2    
13440	304	S2    
13441	304	S2    
13442	304	S2    
13443	304	S2    
13444	304	S2    
13445	304	S2    
13446	304	S2    
13447	304	S2    
13448	304	S2    
13449	304	S2    
13450	304	S2    
13451	304	S2    
13452	304	S2    
13453	304	S2    
13454	304	S2    
13455	304	S2    
13456	304	S2    
13467	304	S221  
13468	304	S221  
13469	304	S221  
13470	304	S221  
13481	304	S221  
13482	304	S221  
13483	304	S221  
13484	304	S221  
13485	304	S2    
13486	304	S2    
13487	304	S2    
13488	304	S2    
13490	304	S2    
13491	304	S2    
13492	304	S2    
13493	304	S2    
13494	304	S14   
13495	304	S14   
13496	304	S14   
13497	304	S14   
13498	304	S14   
13565	304	S2703 
13566	304	S2703 
13567	304	S2703 
13568	304	S2703 
13569	304	S2703 
13805	304	S2    
13806	304	S2    
13809	304	S2    
13810	304	S2    
13811	304	S2    
13812	304	S2    
13813	304	S2    
13814	304	S2    
13850	304	S2    
13851	304	S2    
13853	304	S2    
13854	304	S2    
13856	304	S2    
13857	304	S2    
13868	304	S2    
13869	304	S2    
13870	304	S2    
13871	304	S2    
13872	304	S2    
13873	304	S2    
13874	304	S2    
13875	304	S2    
13876	304	S2    
13877	304	S2    
13878	304	S2    
13879	304	S2    
13880	304	S2    
13881	304	S2    
13882	304	S2    
13891	304	S2    
13893	304	S2    
13894	304	S2    
13896	304	S2    
13898	304	S2    
13900	304	S2    
13909	304	S2    
13910	304	S2    
13911	304	S2    
13912	304	S2    
13913	304	S2    
13914	304	S2    
13917	304	S2    
13918	304	S2    
13920	304	S2    
13921	304	S2    
13923	304	S2    
13924	304	S2    
13929	304	S2    
13930	304	S2    
13931	304	S2    
13932	304	S2    
13934	304	S2    
13935	304	S2    
13936	304	S221  
13937	304	S221  
13938	304	S221  
13939	304	S221  
13940	304	S221  
13941	304	S221  
13942	304	S221  
13943	304	S221  
13944	304	S221  
13945	304	S221  
13946	304	S221  
13947	304	S221  
13948	304	S2    
13949	304	S2    
13950	304	S2    
13951	304	S2    
13952	304	S2    
13953	304	S2    
13954	304	S2    
13955	304	S2    
13956	304	S2    
13957	304	S2    
13958	304	S2    
13959	304	S2    
13960	304	S221  
13961	304	S221  
13962	304	S221  
13963	304	S221  
13964	304	S221  
13965	304	S221  
13966	304	S221  
13967	304	S221  
13968	304	S2    
13969	304	S2    
13970	304	S2    
13971	304	S2    
13976	304	S221  
13977	304	S221  
13978	304	S221  
13979	304	S221  
13985	304	S2    
13987	304	S221  
13988	304	S2703 
13989	304	S2703 
13990	304	S2703 
13991	304	S2703 
13992	304	S2703 
13994	304	S2703 
13995	304	S2703 
13996	304	S2703 
13997	304	S2703 
13998	304	S2703 
14003	304	S2103 
14006	304	S2103 
14052	304	S10   
14052	304	S11   
14052	304	S12   
14052	304	S6    
14052	304	S7    
14052	304	S8    
14052	304	S9    
14084	304	S2103 
14096	304	S2103 
14106	304	S2103 
14137	304	S1068 
14144	304	S1068 
14145	304	S1064 
14145	304	S1066 
14145	304	S1068 
14145	304	S1122 
14146	304	S1068 
14147	304	S1068 
14148	304	S1068 
14149	304	S1068 
14154	304	S2702 
14156	304	S2702 
14166	304	S10   
14166	304	S11   
14166	304	S12   
14166	304	S6    
14166	304	S7    
14166	304	S8    
14166	304	S9    
14209	304	S1064 
14209	304	S1066 
14209	304	S1122 
14209	304	S23   
14219	304	S10   
14219	304	S11   
14219	304	S12   
14219	304	S6    
14219	304	S7    
14219	304	S8    
14219	304	S9    
14238	304	S2104 
14242	304	S2104 
14267	304	S10   
14267	304	S11   
14267	304	S12   
14267	304	S6    
14267	304	S7    
14267	304	S8    
14267	304	S9    
14323	304	S1067 
14347	304	S1064 
14347	304	S1122 
14366	304	S2104 
14370	304	S2104 
14382	304	S1164 
14400	304	S1064 
14400	304	S1066 
14400	304	S1068 
14400	304	S1122 
14416	304	S1064 
14416	304	S1066 
14416	304	S1068 
14416	304	S1122 
14429	304	S20   
14429	304	S23   
14429	304	S25   
14432	304	S1068 
14433	304	S1068 
14434	304	S1068 
14437	304	S27   
14438	304	S27   
14439	304	D4541 
14440	304	S2109 
14450	304	S1164 
14460	304	S1164 
14461	304	S1164 
14462	304	S2109 
14475	304	S1068 
14476	304	S1068 
14555	304	D4541 
14555	304	S1068 
14555	304	S27   
14559	304	S1068 
14559	304	S27   
14601	304	S1066 
14602	304	S2103 
15027	304	S10   
15027	304	S11   
15027	304	S1163 
15027	304	S12   
15027	304	S9    
15073	304	S1163 
15087	304	S2109 
15152	304	S2104 
15232	304	S1163 
15260	304	S2109 
15261	304	S1163 
15262	304	S1163 
16006	304	S1164 
16010	304	S1164 
16011	304	S1164 
16028	304	S10   
16028	304	S11   
16028	304	S12   
16028	304	S182  
16028	304	S183  
16028	304	S203  
16028	304	S6    
16028	304	S7    
16028	304	S8    
16028	304	S9    
16029	304	S1164 
16037	304	S1164 
16037	304	S2202 
16038	304	S1164 
16038	304	S182  
16038	304	S183  
16038	304	S203  
16038	304	S2202 
16042	304	S1065 
16042	304	S2202 
16043	304	S10   
16043	304	S1065 
16043	304	S11   
16043	304	S12   
16043	304	S182  
16043	304	S183  
16043	304	S203  
16043	304	S2202 
16043	304	S6    
16043	304	S7    
16043	304	S8    
16043	304	S9    
16089	304	S563  
16097	304	S22   
16098	304	S10   
16098	304	S11   
16098	304	S12   
16098	304	S182  
16098	304	S183  
16098	304	S203  
16098	304	S22   
16098	304	S6    
16098	304	S7    
16098	304	S8    
16098	304	S9    
16112	304	S39   
16114	304	S39   
16120	304	S39   
16123	304	S39   
16126	304	S39   
16139	304	S39   
16147	304	S2104 
16159	304	D342  
16159	304	S39   
16167	304	S2203 
16174	304	S18   
16338	304	S1164 
16338	304	S182  
16338	304	S183  
16338	304	S203  
16338	304	S2202 
16343	304	S10   
16343	304	S1065 
16343	304	S11   
16343	304	S12   
16343	304	S182  
16343	304	S183  
16343	304	S203  
16343	304	S2202 
16343	304	S6    
16343	304	S7    
16343	304	S8    
16343	304	S9    
16397	304	S22   
16398	304	S10   
16398	304	S11   
16398	304	S12   
16398	304	S182  
16398	304	S183  
16398	304	S203  
16398	304	S22   
16398	304	S6    
16398	304	S7    
16398	304	S8    
16398	304	S9    
17202	304	S1082 
17203	304	S1082 
17204	304	S1082 
17218	304	S1581 
17219	304	S1581 
17332	304	S3    
17335	304	S3    
17340	304	S3    
17341	304	S3    
17342	304	S3    
17345	304	S3    
17346	304	S3    
17347	304	S3    
17348	304	S3    
18001	304	S1162 
18002	304	S1162 
18069	304	S20   
18079	304	S25   
18159	304	S21   
18166	304	S25   
18168	304	S25   
18215	304	S25   
18228	304	S23   
18231	304	S25   
18258	304	S1162 
18259	304	S1162 
18262	304	S1162 
18263	304	S1162 
18288	304	S27   
18350	304	S21   
18363	304	S22   
18364	304	S22   
18365	304	S27   
18376	304	S25   
18403	304	S27   
18927	304	S25   
18930	304	S2203 
18931	304	S2203 
18932	304	S27   
18933	304	S27   
18934	304	S27   
18935	304	S27   
18936	304	S27   
19003	304	S26   
19034	304	S26   
19035	304	S26   
19047	304	S1162 
19056	304	S26   
19057	304	S2109 
19058	304	S2109 
19064	304	S1164 
19076	304	S1164 
19078	304	S1069 
19088	304	S10   
19088	304	S11   
19088	304	S12   
19088	304	S6    
19088	304	S7    
19088	304	S8    
19088	304	S9    
19109	304	S1164 
19120	304	S10   
19120	304	S1069 
19120	304	S11   
19120	304	S12   
19120	304	S6    
19120	304	S7    
19120	304	S8    
19120	304	S9    
19129	304	S10   
19129	304	S11   
19129	304	S12   
19129	304	S6    
19129	304	S7    
19129	304	S8    
19129	304	S9    
19155	304	S1164 
19230	304	S1063 
19283	304	S1067 
19300	304	S10   
19300	304	S11   
19300	304	S12   
19300	304	S6    
19300	304	S7    
19300	304	S8    
19300	304	S9    
19335	304	S10   
19335	304	S11   
19335	304	S12   
19335	304	S6    
19335	304	S7    
19335	304	S8    
19335	304	S9    
19337	304	S2109 
19350	304	S1164 
19411	304	S26   
19856	304	S1067 
19868	304	S2109 
19873	304	S1067 
20046	304	S20   
20047	304	S20   
20048	304	S20   
20049	304	S20   
20099	304	S1163 
20099	304	S20   
20100	304	S10   
20100	304	S11   
20100	304	S1163 
20100	304	S12   
20100	304	S20   
20100	304	S206  
20100	304	S208  
20100	304	S2682 
20100	304	S2683 
20100	304	S2684 
20100	304	S6    
20100	304	S7    
20100	304	S8    
20100	304	S9    
20109	304	S2105 
20110	304	S10   
20110	304	S11   
20110	304	S12   
20110	304	S206  
20110	304	S208  
20110	304	S2105 
20110	304	S2682 
20110	304	S2683 
20110	304	S2684 
20110	304	S6    
20110	304	S7    
20110	304	S8    
20110	304	S9    
20120	304	S1163 
20120	304	S20   
20121	304	S10   
20121	304	S11   
20121	304	S1163 
20121	304	S12   
20121	304	S20   
20121	304	S206  
20121	304	S208  
20121	304	S2682 
20121	304	S2683 
20121	304	S2684 
20121	304	S6    
20121	304	S7    
20121	304	S8    
20121	304	S9    
20132	304	S1202 
20310	304	S10   
20310	304	S11   
20310	304	S12   
20310	304	S206  
20310	304	S208  
20310	304	S2105 
20310	304	S2682 
20310	304	S2683 
20310	304	S2684 
20310	304	S6    
20310	304	S7    
20310	304	S8    
20310	304	S9    
20321	304	S10   
20321	304	S11   
20321	304	S1163 
20321	304	S12   
20321	304	S20   
20321	304	S206  
20321	304	S208  
20321	304	S2682 
20321	304	S2683 
20321	304	S2684 
20321	304	S6    
20321	304	S7    
20321	304	S8    
20321	304	S9    
20400	304	S10   
20400	304	S11   
20400	304	S1163 
20400	304	S12   
20400	304	S20   
20400	304	S206  
20400	304	S208  
20400	304	S2682 
20400	304	S2683 
20400	304	S2684 
20400	304	S6    
20400	304	S7    
20400	304	S8    
20400	304	S9    
20409	304	S2105 
20410	304	S10   
20410	304	S11   
20410	304	S12   
20410	304	S206  
20410	304	S208  
20410	304	S2105 
20410	304	S2682 
20410	304	S2683 
20410	304	S2684 
20410	304	S6    
20410	304	S7    
20410	304	S8    
20410	304	S9    
20420	304	S1163 
20420	304	S20   
20421	304	S10   
20421	304	S11   
20421	304	S1163 
20421	304	S12   
20421	304	S20   
20421	304	S206  
20421	304	S208  
20421	304	S2682 
20421	304	S2683 
20421	304	S2684 
20421	304	S6    
20421	304	S7    
20421	304	S8    
20421	304	S9    
20446	304	S20   
20447	304	S20   
20499	304	S1163 
20499	304	S20   
20510	304	S10   
20510	304	S11   
20510	304	S12   
20510	304	S206  
20510	304	S208  
20510	304	S2105 
20510	304	S2682 
20510	304	S2683 
20510	304	S2684 
20510	304	S6    
20510	304	S7    
20510	304	S8    
20510	304	S9    
20521	304	S10   
20521	304	S11   
20521	304	S1163 
20521	304	S12   
20521	304	S20   
20521	304	S206  
20521	304	S208  
20521	304	S2682 
20521	304	S2683 
20521	304	S2684 
20521	304	S6    
20521	304	S7    
20521	304	S8    
20521	304	S9    
20623	304	S1742 
20624	304	S1742 
20628	304	S1742 
20629	304	S1742 
20630	304	S1742 
20634	304	S1742 
20635	304	S1742 
20636	304	S1742 
20640	304	S1742 
20641	304	S1742 
20645	304	S1742 
20646	304	S1742 
21138	304	S1064 
21138	304	S1066 
21138	304	S1122 
21141	304	S1064 
21224	304	S19   
21225	304	S19   
21226	304	S22   
21227	304	S22   
21229	304	S1122 
21238	304	S2801 
21239	304	S1066 
21240	304	S1066 
21241	304	S1066 
21242	304	S1066 
21243	304	S1066 
21244	304	S1066 
21245	304	S1066 
21246	304	S1066 
21247	304	S1066 
21248	304	S1066 
21249	304	S1064 
21250	304	S1064 
21251	304	S1064 
21252	304	S1064 
21253	304	S1064 
21254	304	S1064 
21255	304	S1064 
21256	304	S1064 
21257	304	S1064 
21259	304	S1064 
21260	304	S1082 
21261	304	S1082 
21262	304	S1082 
21263	304	S1082 
21264	304	S1082 
21265	304	S1082 
21266	304	S1082 
21267	304	S1082 
21268	304	S1082 
21269	304	S1082 
21270	304	S1082 
21271	304	S2108 
21272	304	S2108 
21273	304	S2108 
21274	304	S2108 
21275	304	S2108 
21276	304	S2108 
21277	304	S2110 
21278	304	S2110 
21279	304	S2110 
21280	304	S2110 
21281	304	S2110 
21282	304	S2110 
21283	304	S2111 
21284	304	S2111 
21285	304	S2111 
21286	304	S2111 
21287	304	S2112 
21288	304	S2112 
21289	304	S2112 
21290	304	S2112 
21291	304	S2112 
21292	304	S2112 
21293	304	S2782 
21294	304	S2782 
21295	304	S2782 
21296	304	S2782 
21297	304	S2782 
21298	304	S2782 
21299	304	S2110 
21299	304	S2111 
21299	304	S2112 
21299	304	S2782 
21300	304	S2110 
21300	304	S2112 
21300	304	S2782 
21301	304	S2110 
21301	304	S2111 
21301	304	S2112 
21301	304	S2782 
21302	304	S2110 
21302	304	S2111 
21302	304	S2112 
21302	304	S2782 
21303	304	S2110 
21303	304	S2112 
21303	304	S2782 
21304	304	S2110 
21304	304	S2111 
21304	304	S2112 
21304	304	S2782 
21308	304	S2801 
21309	304	S2801 
21310	304	S2801 
21311	304	S2801 
21312	304	S2801 
21313	304	S2801 
21314	304	S2801 
21315	304	S2801 
21316	304	S2801 
21317	304	S2801 
21318	304	S2801 
21319	304	S2801 
21320	304	S2801 
21321	304	S2801 
21322	304	S2801 
21323	304	S2801 
21324	304	S2801 
21325	304	S2801 
21326	304	S2801 
21337	304	S2801 
21343	304	S2801 
21346	304	S2801 
21347	304	S2801 
21348	304	S2801 
21349	304	S2801 
22247	304	S20   
22903	304	S21   
22904	304	S18   
22909	304	S22   
22911	304	S18   
22912	304	S19   
22914	304	S19   
22915	304	S19   
22916	304	S19   
23009	304	S2703 
23010	304	S2703 
23011	304	S2703 
23012	304	S2703 
23013	304	S2703 
23014	304	S2703 
23015	304	S2703 
23016	304	S2703 
23017	304	S2703 
23018	304	S2703 
23019	304	S2703 
23020	304	S2703 
23021	304	S2703 
23022	304	S2703 
23023	304	S2703 
23024	304	S2703 
23025	304	S2703 
23027	304	S2703 
23028	304	S2703 
23029	304	S2703 
23030	304	S2703 
23031	304	S2703 
23032	304	S2703 
23033	304	S2703 
23034	304	S2703 
23035	304	S2703 
23036	304	S2703 
23037	304	S2703 
23038	304	S2703 
23039	304	S2703 
23040	304	S2703 
23041	304	S2703 
23042	304	S2703 
23043	304	S2703 
23044	304	S2703 
23045	304	S2703 
23046	304	S2703 
23047	304	S2703 
23048	304	S2703 
23049	304	S2703 
23050	304	S2703 
23051	304	S2703 
23052	304	S2703 
23053	304	S2703 
23054	304	S2703 
23055	304	S2703 
23056	304	S2703 
23057	304	S2703 
23058	304	S2703 
23059	304	S2703 
23060	304	S2703 
23061	304	S2703 
23062	304	S2703 
23063	304	S2703 
23064	304	S2703 
23065	304	S2703 
23557	304	S14   
23558	304	S14   
23559	304	S14   
23560	304	S14   
23561	304	S14   
23562	304	S14   
23563	304	S14   
23564	304	S14   
23565	304	S14   
23566	304	S14   
23567	304	S14   
23568	304	S14   
23569	304	S14   
23570	304	S14   
23571	304	S14   
23572	304	S14   
23573	304	S14   
23574	304	S14   
23575	304	S14   
23576	304	S14   
23577	304	S14   
23578	304	S14   
23579	304	S14   
23580	304	S14   
23581	304	S14   
23582	304	S2    
23583	304	S2    
23584	304	S2    
23585	304	S2    
23586	304	S2    
23587	304	S2    
23588	304	S2    
23589	304	S2    
23590	304	S2    
23591	304	S2    
23592	304	S2    
23593	304	S2    
23594	304	S2    
23595	304	S2    
23596	304	S2    
23597	304	S2    
23598	304	S2    
23599	304	S2    
23600	304	S2    
23601	304	S2    
23602	304	S2    
23603	304	S2    
23604	304	S2    
23605	304	S2    
23606	304	S2    
23607	304	S2    
23608	304	S2    
23609	304	S2    
23610	304	S2    
23611	304	S2    
23612	304	S2    
23613	304	S2    
23614	304	S2    
23615	304	S2    
23616	304	S2    
23617	304	S2    
23618	304	S2    
23619	304	S2    
23620	304	S2    
23621	304	S2    
23622	304	S2    
23623	304	S2    
23624	304	S2    
23625	304	S2    
23626	304	S2    
23627	304	S2    
23628	304	S2    
23629	304	S2    
23630	304	S2    
23631	304	S2    
23632	304	S2    
23633	304	S2    
23634	304	S2    
23635	304	S2    
23636	304	S2    
23637	304	S2    
23638	304	S2    
23640	304	S1581 
23646	304	S2    
23647	304	S2    
23648	304	S2    
23649	304	S2    
23650	304	S2    
23651	304	S2    
23652	304	S2    
23653	304	S2    
23654	304	S2    
23655	304	S2    
23656	304	S2    
23657	304	S2    
23658	304	S2    
23659	304	S2    
23660	304	S2    
35001	304	D4961 
35002	304	D4961 
35003	304	D4961 
35015	304	D4961 
35024	304	D4961 
35048	304	D4961 
35051	304	D4961 
35073	304	D4961 
35078	304	D4961 
35089	304	D4961 
35130	304	S2381 
35131	304	S2381 
35132	304	S2381 
35133	304	S2381 
35134	304	S2381 
35135	304	S2381 
35136	304	S2381 
35137	304	S2381 
35138	304	S2381 
35140	304	S2381 
35141	304	S2381 
35142	304	S2381 
35143	304	S2381 
35144	304	S2381 
35145	304	S2381 
35146	304	S2381 
35147	304	S2381 
35148	304	S2381 
42190	304	S243  
43158	304	S2109 
43215	304	S26   
43329	304	S25   
43364	304	S26   
43378	304	S1082 
43514	304	S1067 
01001	305	S10   
01001	305	S11   
01001	305	S12   
01001	305	S6    
01001	305	S7    
01001	305	S8    
01001	305	S9    
01026	305	S25   
01032	305	S19   
01040	305	S10   
01040	305	S11   
01040	305	S12   
01040	305	S6    
01040	305	S7    
01040	305	S8    
01040	305	S9    
01042	305	S10   
01042	305	S11   
01042	305	S12   
01042	305	S19   
01042	305	S6    
01042	305	S7    
01042	305	S8    
01042	305	S9    
01046	305	S19   
01077	305	S10   
01077	305	S11   
01077	305	S12   
01077	305	S27   
01077	305	S6    
01077	305	S7    
01077	305	S8    
01077	305	S9    
01079	305	S10   
01079	305	S1063 
01079	305	S11   
01079	305	S12   
01079	305	S7    
01079	305	S8    
01079	305	S9    
01082	305	S1063 
01085	305	S10   
01085	305	S1063 
01085	305	S11   
01085	305	S12   
01085	305	S6    
01085	305	S7    
01085	305	S8    
01085	305	S9    
01123	305	S1063 
01123	305	S561  
01124	305	S1065 
01125	305	S1065 
01145	305	S10   
01145	305	S11   
01145	305	S12   
01145	305	S6    
01145	305	S7    
01145	305	S8    
01145	305	S9    
01202	305	S1163 
02048	305	S2109 
02053	305	S2109 
04017	305	S19   
04020	305	S19   
04021	305	S19   
04023	305	S19   
04053	305	S19   
04114	305	S19   
04120	305	S19   
04141	305	S19   
04142	305	S19   
04143	305	S19   
04144	305	S19   
04367	305	S19   
04610	305	S18   
04628	305	S18   
04629	305	S18   
04630	305	S19   
04631	305	S20   
04635	305	S19   
04636	305	S19   
04638	305	S26   
04639	305	S26   
04640	305	S26   
04641	305	S25   
04656	305	S2221 
04657	305	S2221 
04658	305	S2221 
04659	305	S2221 
04660	305	S2221 
04661	305	S2221 
04662	305	S2221 
04663	305	S2221 
04673	305	S2401 
04674	305	S2401 
04675	305	S2401 
04676	305	S2401 
04677	305	S2401 
05023	305	S1581 
05024	305	S1581 
05027	305	S1082 
05028	305	S1082 
05173	305	S1581 
05174	305	S1581 
05175	305	S1581 
05176	305	S1581 
05177	305	S1581 
05178	305	S1581 
05312	305	S26   
05313	305	S26   
05320	305	S26   
05624	305	S3    
05632	305	S3    
05661	305	S1082 
06016	305	S18   
06019	305	S18   
06043	305	S18   
06094	305	S18   
06128	305	S18   
06159	305	S18   
06164	305	S23   
06931	305	S22   
06982	305	S18   
06983	305	S18   
06984	305	S2104 
06985	305	S2104 
07002	305	S222  
07005	305	S248  
07007	305	S1164 
07008	305	S238  
07015	305	S248  
07016	305	S248  
07022	305	S21   
07034	305	S249  
07039	305	S244  
07056	305	S248  
07057	305	S235  
07057	305	S238  
07063	305	S1164 
07063	305	S582  
07064	305	S1164 
07068	305	S1041 
07075	305	S1164 
07241	305	S21   
07910	305	S245  
07913	305	S238  
07923	305	S245  
07931	305	S222  
07938	305	S233  
07939	305	S235  
07945	305	S21   
07949	305	S23   
07950	305	S23   
07951	305	S243  
07952	305	S1164 
07953	305	S1164 
07953	305	S582  
07954	305	S582  
07955	305	S1164 
07956	305	S1164 
07957	305	S1164 
07958	305	S1164 
07959	305	S1164 
07960	305	S1164 
08001	305	S1065 
08003	305	S2664 
08005	305	S2664 
08010	305	S702  
08011	305	S702  
08012	305	S1065 
08013	305	S1065 
08014	305	S1065 
08017	305	S603  
08018	305	S702  
08020	305	S1065 
08023	305	S2664 
08025	305	S2662 
08028	305	S2664 
08030	305	S1065 
08031	305	S2664 
08032	305	S2664 
08035	305	S603  
08045	305	S603  
08047	305	S702  
08048	305	S603  
08049	305	S702  
08050	305	S603  
08054	305	S702  
08057	305	S603  
08058	305	S2664 
08059	305	S702  
08060	305	S2664 
08061	305	S1065 
08065	305	S1065 
08065	305	S2662 
08066	305	S702  
08067	305	S2664 
08068	305	S2664 
08069	305	S2664 
08071	305	S2664 
08074	305	S2662 
08077	305	S1065 
08078	305	S603  
08082	305	S603  
08085	305	S702  
08089	305	S603  
08092	305	S702  
08094	305	S702  
08116	305	S2502 
08124	305	S702  
08128	305	S702  
08130	305	S702  
08139	305	S603  
08146	305	S702  
08147	305	S1065 
08147	305	S2422 
08177	305	S2502 
08189	305	S2664 
08190	305	S603  
08194	305	S603  
08200	305	S702  
08202	305	S603  
08210	305	S702  
08211	305	S702  
08212	305	S702  
08214	305	S702  
08215	305	S702  
08216	305	S702  
08217	305	S2664 
08218	305	S1065 
08220	305	S702  
08221	305	S702  
08225	305	S702  
08229	305	S702  
08231	305	S702  
08232	305	S702  
08243	305	S603  
08244	305	S603  
08245	305	S603  
08247	305	S603  
08253	305	S2664 
08258	305	S2664 
08259	305	S2662 
08261	305	S603  
08266	305	S603  
08267	305	S603  
08269	305	S603  
08270	305	S603  
08271	305	S603  
08272	305	S603  
08273	305	S603  
08277	305	S603  
08278	305	S603  
08283	305	S2664 
08284	305	S2664 
08286	305	S2664 
08287	305	S2664 
08288	305	S2664 
08289	305	S2664 
08293	305	S702  
08294	305	S702  
08299	305	S702  
08309	305	S2664 
08315	305	S702  
08316	305	S702  
08317	305	S702  
08318	305	S2664 
08319	305	S2664 
08345	305	S603  
08348	305	S2502 
08349	305	S2502 
08350	305	S2502 
08351	305	S702  
08352	305	S702  
08353	305	S702  
08354	305	S702  
08355	305	S702  
08357	305	S702  
08358	305	S702  
08359	305	S702  
08360	305	S702  
08361	305	S702  
08362	305	S702  
08363	305	S702  
08364	305	S702  
08366	305	S702  
08367	305	S603  
08368	305	S603  
08371	305	S603  
08372	305	S603  
08374	305	S2664 
08376	305	S2664 
08378	305	S2161 
08379	305	S2664 
08380	305	S2664 
08383	305	S2664 
08384	305	S2664 
08385	305	S2664 
08386	305	S2664 
08387	305	S2664 
08388	305	S682  
08389	305	S2664 
08390	305	S2664 
08391	305	S682  
08392	305	S2664 
08393	305	S2664 
08394	305	S702  
08395	305	S702  
08396	305	S702  
08398	305	S603  
08399	305	S603  
08400	305	S881  
08401	305	S881  
08402	305	S702  
08403	305	S1209 
08408	305	S2502 
08410	305	S702  
08411	305	S702  
08412	305	S702  
08413	305	S702  
08414	305	S702  
08415	305	S702  
08416	305	S702  
08417	305	S702  
08418	305	S702  
08419	305	S702  
08420	305	S702  
08421	305	S702  
08422	305	S702  
08435	305	S1065 
08436	305	S702  
08444	305	S702  
08446	305	S702  
08448	305	S702  
08449	305	S702  
08450	305	S702  
08454	305	S2664 
08455	305	S2664 
08457	305	S2664 
08458	305	S2664 
08459	305	S2664 
08460	305	S2664 
08461	305	S2664 
08462	305	S2664 
08463	305	S2664 
08465	305	S2664 
08466	305	S2664 
08468	305	S2664 
08469	305	S2664 
08470	305	S2664 
08471	305	S2664 
08472	305	S2664 
08473	305	S2664 
08474	305	S2664 
08476	305	S2502 
08478	305	S2502 
08481	305	S2502 
08482	305	S2502 
08483	305	S2502 
08484	305	S2502 
08487	305	S2502 
08489	305	S2502 
08490	305	S2502 
08491	305	S2502 
08492	305	S2502 
08493	305	S2502 
08494	305	S2502 
08495	305	S2502 
08498	305	S2502 
08500	305	S2502 
08504	305	S2662 
08505	305	S2662 
08506	305	S2662 
08507	305	S2662 
08508	305	S2662 
08509	305	S2662 
09003	305	S1183 
09003	305	S502  
09003	305	S561  
09004	305	S502  
09021	305	S10   
09021	305	S11   
09021	305	S12   
09021	305	S206  
09021	305	S208  
09021	305	S7    
09021	305	S8    
09021	305	S9    
09032	305	S21   
09037	305	S1031 
09037	305	S381  
09037	305	S481  
09037	305	S502  
09038	305	S1031 
09038	305	S481  
09038	305	S502  
09039	305	S381  
09040	305	S10   
09040	305	S1023 
09040	305	S11   
09040	305	S12   
09040	305	S206  
09040	305	S208  
09040	305	S481  
09040	305	S562  
09040	305	S6    
09040	305	S7    
09040	305	S73   
09040	305	S74   
09040	305	S8    
09040	305	S9    
09042	305	S461  
09042	305	S566  
09050	305	S1141 
09050	305	S421  
09050	305	S441  
09060	305	S381  
09062	305	S381  
09062	305	S404  
09070	305	S10   
09070	305	S11   
09070	305	S12   
09070	305	S182  
09070	305	S183  
09070	305	S201  
09070	305	S202  
09070	305	S203  
09070	305	S204  
09070	305	S205  
09070	305	S206  
09070	305	S208  
09070	305	S53   
09070	305	S582  
09070	305	S6    
09070	305	S73   
09070	305	S74   
09070	305	S8    
09070	305	S9    
09078	305	S561  
09079	305	S1701 
09087	305	S1032 
09087	305	S564  
09087	305	S582  
09094	305	S363  
09094	305	S582  
09112	305	S482  
09112	305	S563  
09132	305	S10   
09132	305	S1062 
09132	305	S11   
09132	305	S12   
09132	305	S206  
09132	305	S208  
09132	305	S6    
09132	305	S7    
09132	305	S8    
09132	305	S9    
09139	305	S381  
09148	305	S1033 
09148	305	S363  
09148	305	S582  
09149	305	S381  
09160	305	S1065 
09181	305	S10   
09181	305	S1024 
09181	305	S11   
09181	305	S1121 
09181	305	S12   
09181	305	S206  
09181	305	S208  
09181	305	S461  
09181	305	S6    
09181	305	S7    
09181	305	S73   
09181	305	S74   
09181	305	S8    
09181	305	S9    
09183	305	S381  
09184	305	S1026 
09184	305	S562  
09184	305	S565  
09191	305	S421  
09191	305	S582  
09195	305	S1202 
09202	305	S482  
09202	305	S564  
09218	305	S1065 
09218	305	S1161 
09236	305	S10   
09236	305	S11   
09236	305	S12   
09236	305	S461  
09236	305	S582  
09236	305	S6    
09236	305	S7    
09236	305	S73   
09236	305	S74   
09236	305	S8    
09236	305	S9    
09252	305	S10   
09252	305	S11   
09252	305	S12   
09252	305	S206  
09252	305	S208  
09252	305	S482  
09252	305	S541  
09252	305	S6    
09252	305	S7    
09252	305	S73   
09252	305	S74   
09252	305	S8    
09252	305	S9    
09266	305	S1167 
09266	305	S441  
09266	305	S561  
09273	305	S2104 
09279	305	S10   
09279	305	S11   
09279	305	S12   
09279	305	S206  
09279	305	S208  
09279	305	S421  
09279	305	S582  
09279	305	S6    
09279	305	S7    
09279	305	S73   
09279	305	S74   
09279	305	S8    
09279	305	S9    
09291	305	S10   
09291	305	S11   
09291	305	S12   
09291	305	S206  
09291	305	S208  
09291	305	S564  
09291	305	S566  
09291	305	S6    
09291	305	S7    
09291	305	S73   
09291	305	S74   
09291	305	S8    
09291	305	S9    
09298	305	S10   
09298	305	S11   
09298	305	S12   
09298	305	S206  
09298	305	S208  
09298	305	S564  
09298	305	S566  
09298	305	S6    
09298	305	S7    
09298	305	S73   
09298	305	S74   
09298	305	S8    
09298	305	S9    
09302	305	S381  
09302	305	S461  
09302	305	S566  
09302	305	S963  
09316	305	S10   
09316	305	S11   
09316	305	S12   
09316	305	S182  
09316	305	S183  
09316	305	S201  
09316	305	S202  
09316	305	S203  
09316	305	S204  
09316	305	S205  
09316	305	S206  
09316	305	S208  
09316	305	S421  
09316	305	S566  
09316	305	S581  
09316	305	S6    
09316	305	S7    
09316	305	S73   
09316	305	S74   
09316	305	S8    
09316	305	S9    
09326	305	S10   
09326	305	S1027 
09326	305	S11   
09326	305	S12   
09326	305	S206  
09326	305	S208  
09326	305	S461  
09326	305	S6    
09326	305	S7    
09326	305	S73   
09326	305	S74   
09326	305	S8    
09326	305	S9    
09328	305	S1206 
09409	305	S2104 
09421	305	S564  
09421	305	S582  
09422	305	S1202 
09427	305	D4053 
09428	305	D4053 
09429	305	S1167 
09429	305	S441  
09430	305	S441  
09430	305	S561  
09431	305	S2203 
09432	305	S2203 
09433	305	S2105 
09433	305	S2961 
10007	305	S1082 
10066	305	S1082 
10067	305	S1082 
10068	305	S1082 
10098	305	S1581 
10099	305	S1581 
10102	305	S1581 
10119	305	S1581 
10123	305	S1082 
10124	305	S1082 
10173	305	S1581 
10858	305	S1082 
10860	305	S1082 
10861	305	S1082 
10862	305	S1082 
10863	305	S1581 
10864	305	S1082 
11011	305	S1069 
11012	305	S1069 
11019	305	S10   
11019	305	S11   
11019	305	S12   
11019	305	S6    
11019	305	S7    
11019	305	S8    
11019	305	S9    
11090	305	S1121 
11090	305	S564  
11090	305	S619  
11091	305	S1121 
11091	305	S564  
11096	305	S1121 
11096	305	S482  
11097	305	S482  
11101	305	S10   
11101	305	S11   
11101	305	S12   
11101	305	S6    
11101	305	S7    
11101	305	S8    
11101	305	S9    
11112	305	S1065 
11113	305	S1065 
11124	305	S1062 
11124	305	S183  
11124	305	S201  
11124	305	S202  
11124	305	S203  
11124	305	S6    
11124	305	S618  
11125	305	S1062 
11130	305	S25   
11131	305	S25   
11143	305	S1121 
11143	305	S183  
11143	305	S201  
11143	305	S202  
11143	305	S203  
11143	305	S564  
11143	305	S6    
11157	305	S1202 
11205	305	S1062 
11206	305	S1062 
11206	305	S183  
11206	305	S201  
11206	305	S202  
11206	305	S203  
11206	305	S6    
11210	305	S10   
11210	305	S11   
11210	305	S12   
11210	305	S6    
11210	305	S7    
11210	305	S8    
11210	305	S9    
11243	305	S2941 
11250	305	S562  
11250	305	S565  
11251	305	S481  
11251	305	S503  
11251	305	S620  
11252	305	S10   
11252	305	S11   
11252	305	S12   
11252	305	S183  
11252	305	S201  
11252	305	S202  
11252	305	S203  
11252	305	S481  
11252	305	S562  
11252	305	S6    
11252	305	S624  
11252	305	S7    
11252	305	S8    
11252	305	S9    
11253	305	S541  
11253	305	S565  
11257	305	S541  
11257	305	S565  
11260	305	S10   
11260	305	S11   
11260	305	S12   
11260	305	S2941 
11260	305	S6    
11260	305	S7    
11260	305	S78   
11260	305	S8    
11260	305	S80   
11260	305	S9    
11263	305	S2941 
11267	305	S2941 
11279	305	S10   
11279	305	S11   
11279	305	S12   
11279	305	S6    
11279	305	S7    
11279	305	S8    
11279	305	S9    
11282	305	S10   
11282	305	S1062 
11282	305	S11   
11282	305	S12   
11282	305	S183  
11282	305	S201  
11282	305	S202  
11282	305	S203  
11282	305	S6    
11282	305	S7    
11282	305	S8    
11282	305	S9    
11286	305	S1062 
11294	305	S563  
11294	305	S582  
11333	305	S1062 
11333	305	S183  
11333	305	S201  
11333	305	S202  
11333	305	S203  
11333	305	S6    
11333	305	S611  
11339	305	S1062 
11352	305	S563  
11352	305	S566  
11353	305	S563  
11353	305	S566  
11354	305	S563  
11354	305	S566  
11355	305	S563  
11355	305	S566  
11356	305	S563  
11356	305	S566  
11357	305	S563  
11357	305	S566  
11358	305	S563  
11358	305	S566  
11359	305	S2105 
11360	305	S183  
11360	305	S201  
11360	305	S202  
11360	305	S203  
11360	305	S2105 
11360	305	S6    
11394	305	S2105 
11395	305	S2105 
11398	305	S2105 
11399	305	S2105 
11402	305	S2105 
11403	305	S183  
11403	305	S201  
11403	305	S202  
11403	305	S203  
11403	305	S2105 
11403	305	S6    
11411	305	S2105 
11412	305	S2105 
11429	305	S1121 
11429	305	S363  
11429	305	S617  
11463	305	S25   
11464	305	S25   
11468	305	S12   
11468	305	S183  
11468	305	S201  
11468	305	S202  
11468	305	S203  
11507	305	S1062 
11508	305	S10   
11508	305	S1062 
11508	305	S11   
11508	305	S12   
11508	305	S183  
11508	305	S201  
11508	305	S202  
11508	305	S203  
11508	305	S6    
11508	305	S7    
11508	305	S8    
11508	305	S9    
11510	305	S1062 
11529	305	S183  
11529	305	S201  
11529	305	S202  
11529	305	S203  
11529	305	S441  
11529	305	S503  
11529	305	S6    
11529	305	S608  
11530	305	S441  
11540	305	S10   
11540	305	S11   
11540	305	S12   
11540	305	S183  
11540	305	S201  
11540	305	S202  
11540	305	S203  
11540	305	S6    
11540	305	S7    
11540	305	S8    
11540	305	S9    
11546	305	S21   
11547	305	S21   
11549	305	S183  
11549	305	S201  
11549	305	S202  
11549	305	S203  
11549	305	S21   
11549	305	S6    
11565	305	S10   
11565	305	S11   
11565	305	S12   
11565	305	S6    
11565	305	S7    
11565	305	S8    
11565	305	S9    
11674	305	S183  
11674	305	S201  
11674	305	S202  
11674	305	S203  
11674	305	S563  
11674	305	S566  
11705	305	S1069 
11709	305	S10   
11709	305	S11   
11709	305	S12   
11709	305	S6    
11709	305	S7    
11709	305	S8    
11709	305	S9    
11742	305	S1121 
11742	305	S564  
11746	305	S10   
11746	305	S11   
11746	305	S12   
11746	305	S6    
11746	305	S7    
11746	305	S8    
11746	305	S9    
11752	305	S1065 
11757	305	S1062 
11760	305	S25   
11783	305	S10   
11783	305	S11   
11783	305	S12   
11783	305	S6    
11783	305	S7    
11783	305	S8    
11783	305	S9    
11803	305	S10   
11803	305	S11   
11803	305	S12   
11803	305	S6    
11803	305	S7    
11803	305	S8    
11803	305	S9    
11821	305	S1062 
11828	305	S183  
11828	305	S201  
11828	305	S202  
11828	305	S203  
11828	305	S563  
11828	305	S566  
11841	305	S183  
11841	305	S201  
11841	305	S202  
11841	305	S203  
11841	305	S2105 
11841	305	S6    
11842	305	S2105 
11856	305	S25   
11858	305	S12   
11858	305	S183  
11858	305	S201  
11858	305	S202  
11858	305	S203  
11875	305	S10   
11875	305	S1062 
11875	305	S11   
11875	305	S12   
11875	305	S183  
11875	305	S201  
11875	305	S202  
11875	305	S203  
11875	305	S6    
11875	305	S7    
11875	305	S8    
11875	305	S9    
11876	305	S1062 
11884	305	S441  
11886	305	S10   
11886	305	S11   
11886	305	S12   
11886	305	S183  
11886	305	S201  
11886	305	S202  
11886	305	S203  
11886	305	S6    
11886	305	S7    
11886	305	S8    
11886	305	S9    
11887	305	S21   
11888	305	S21   
11921	305	S1062 
11935	305	S183  
11935	305	S202  
11935	305	S203  
11935	305	S22   
11935	305	S6    
11949	305	S183  
11949	305	S202  
11949	305	S203  
11949	305	S22   
11949	305	S6    
11950	305	S2941 
11960	305	S481  
11960	305	S562  
11987	305	S1202 
11987	305	S2941 
11990	305	S1202 
11991	305	S1202 
11992	305	S2941 
12006	305	D4862 
12006	305	S1783 
12061	305	S141  
12062	305	S141  
12063	305	S141  
12065	305	S141  
12078	305	S1063 
12078	305	S503  
12086	305	S343  
12086	305	S363  
12086	305	S502  
12087	305	S343  
12120	305	S83   
12121	305	S83   
12122	305	S83   
12131	305	S77   
12132	305	S77   
12142	305	S85   
12143	305	S85   
12144	305	S85   
12147	305	S502  
12147	305	S564  
12151	305	S86   
12152	305	S86   
12154	305	S941  
12155	305	S79   
12201	305	S1164 
12220	305	S1221 
12220	305	S2109 
12563	305	S141  
12565	305	S141  
12586	305	S343  
12586	305	S363  
12586	305	S502  
12632	305	S77   
12643	305	S85   
12644	305	S85   
12652	305	S86   
13019	305	S2    
13020	305	S2    
13055	305	S2    
13065	305	S2    
13067	305	S2    
13068	305	S2    
13070	305	S2    
13096	305	S2    
13098	305	S2    
13165	305	S2    
13318	305	S1581 
13320	305	S1581 
13321	305	S1581 
13322	305	S1581 
13323	305	S1581 
13324	305	S1581 
13325	305	S1082 
13326	305	S1082 
13327	305	S1082 
13340	305	S1581 
13341	305	S1581 
13343	305	S2    
13369	305	S2    
13370	305	S2    
13373	305	S2    
13375	305	S2    
13377	305	S2    
13378	305	S2    
13391	305	S2    
13394	305	S2    
13398	305	S2    
13399	305	S2    
13401	305	S2    
13402	305	S2    
13404	305	S2    
13405	305	S2    
13407	305	S2    
13408	305	S2    
13410	305	S2    
13411	305	S2    
13413	305	S2    
13414	305	S2    
13415	305	S2    
13416	305	S2    
13417	305	S2    
13418	305	S2    
13419	305	S2    
13420	305	S2    
13421	305	S2    
13422	305	S2    
13423	305	S2    
13424	305	S2    
13425	305	S2    
13426	305	S2    
13439	305	S2    
13440	305	S2    
13441	305	S2    
13442	305	S2    
13443	305	S2    
13444	305	S2    
13445	305	S2    
13446	305	S2    
13447	305	S2    
13448	305	S2    
13449	305	S2    
13450	305	S2    
13451	305	S2    
13452	305	S2    
13453	305	S2    
13454	305	S2    
13455	305	S2    
13456	305	S2    
13485	305	S2    
13486	305	S2    
13487	305	S2    
13488	305	S2    
13490	305	S2    
13491	305	S2    
13492	305	S2    
13493	305	S2    
13494	305	S14   
13495	305	S14   
13496	305	S14   
13497	305	S14   
13498	305	S14   
13565	305	S2703 
13566	305	S2703 
13567	305	S2703 
13568	305	S2703 
13569	305	S2703 
13805	305	S2    
13806	305	S2    
13809	305	S2    
13810	305	S2    
13811	305	S2    
13812	305	S2    
13813	305	S2    
13814	305	S2    
13850	305	S2    
13851	305	S2    
13853	305	S2    
13854	305	S2    
13856	305	S2    
13857	305	S2    
13868	305	S2    
13869	305	S2    
13870	305	S2    
13871	305	S2    
13872	305	S2    
13873	305	S2    
13874	305	S2    
13875	305	S2    
13876	305	S2    
13877	305	S2    
13878	305	S2    
13879	305	S2    
13880	305	S2    
13881	305	S2    
13882	305	S2    
13891	305	S2    
13893	305	S2    
13894	305	S2    
13896	305	S2    
13898	305	S2    
13900	305	S2    
13909	305	S2    
13910	305	S2    
13911	305	S2    
13912	305	S2    
13913	305	S2    
13914	305	S2    
13917	305	S2    
13918	305	S2    
13920	305	S2    
13921	305	S2    
13923	305	S2    
13924	305	S2    
13929	305	S2    
13930	305	S2    
13931	305	S2    
13932	305	S2    
13934	305	S2    
13935	305	S2    
13948	305	S2    
13949	305	S2    
13950	305	S2    
13951	305	S2    
13952	305	S2    
13953	305	S2    
13954	305	S2    
13955	305	S2    
13956	305	S2    
13957	305	S2    
13958	305	S2    
13959	305	S2    
13968	305	S2    
13969	305	S2    
13970	305	S2    
13971	305	S2    
13985	305	S2    
13988	305	S2703 
13989	305	S2703 
13990	305	S2703 
13991	305	S2703 
13992	305	S2703 
13994	305	S2703 
13995	305	S2703 
13996	305	S2703 
13997	305	S2703 
13998	305	S2703 
14003	305	S2103 
14006	305	S2103 
14052	305	S10   
14052	305	S11   
14052	305	S12   
14052	305	S6    
14052	305	S7    
14052	305	S8    
14052	305	S9    
14084	305	S2103 
14096	305	S2103 
14106	305	S2103 
14137	305	S1068 
14144	305	S1068 
14145	305	S1064 
14145	305	S1066 
14145	305	S1068 
14145	305	S1122 
14146	305	S1068 
14147	305	S1068 
14148	305	S1068 
14149	305	S1068 
14154	305	S2702 
14156	305	S2702 
14166	305	S10   
14166	305	S11   
14166	305	S12   
14166	305	S6    
14166	305	S7    
14166	305	S8    
14166	305	S9    
14209	305	S1064 
14209	305	S1066 
14209	305	S1122 
14209	305	S23   
14219	305	S10   
14219	305	S11   
14219	305	S12   
14219	305	S6    
14219	305	S7    
14219	305	S8    
14219	305	S9    
14238	305	S2104 
14242	305	S2104 
14267	305	S10   
14267	305	S11   
14267	305	S12   
14267	305	S6    
14267	305	S7    
14267	305	S8    
14267	305	S9    
14323	305	S1067 
14347	305	S1064 
14347	305	S1122 
14366	305	S2104 
14370	305	S2104 
14382	305	S1164 
14400	305	S1064 
14400	305	S1066 
14400	305	S1068 
14400	305	S1122 
14416	305	S1064 
14416	305	S1066 
14416	305	S1068 
14416	305	S1122 
14429	305	S20   
14429	305	S23   
14429	305	S25   
14432	305	S1068 
14433	305	S1068 
14434	305	S1068 
14440	305	S2109 
14450	305	S1164 
14460	305	S1164 
14461	305	S1164 
14462	305	S2109 
14475	305	S1068 
14476	305	S1068 
14559	305	S1068 
14601	305	S1066 
14602	305	S2103 
15027	305	S10   
15027	305	S11   
15027	305	S1163 
15027	305	S12   
15027	305	S9    
15073	305	S1163 
15087	305	S2109 
15152	305	S2104 
15232	305	S1163 
15260	305	S2109 
15261	305	S1163 
15262	305	S1163 
16006	305	S1164 
16010	305	S1164 
16011	305	S1164 
16028	305	S10   
16028	305	S11   
16028	305	S12   
16028	305	S182  
16028	305	S183  
16028	305	S203  
16028	305	S6    
16028	305	S7    
16028	305	S8    
16028	305	S9    
16029	305	S1164 
16037	305	S1164 
16037	305	S2202 
16038	305	S1164 
16038	305	S182  
16038	305	S183  
16038	305	S203  
16038	305	S2202 
16042	305	S1065 
16042	305	S2202 
16043	305	S10   
16043	305	S1065 
16043	305	S11   
16043	305	S12   
16043	305	S182  
16043	305	S183  
16043	305	S203  
16043	305	S2202 
16043	305	S6    
16043	305	S7    
16043	305	S8    
16043	305	S9    
16089	305	S563  
16097	305	S22   
16098	305	S10   
16098	305	S11   
16098	305	S12   
16098	305	S182  
16098	305	S183  
16098	305	S203  
16098	305	S22   
16098	305	S6    
16098	305	S7    
16098	305	S8    
16098	305	S9    
16112	305	S39   
16114	305	S39   
16120	305	S39   
16123	305	S39   
16126	305	S39   
16139	305	S39   
16147	305	S2104 
16159	305	D342  
16159	305	S39   
16167	305	S2203 
16174	305	S18   
16338	305	S1164 
16338	305	S182  
16338	305	S183  
16338	305	S203  
16338	305	S2202 
16343	305	S10   
16343	305	S1065 
16343	305	S11   
16343	305	S12   
16343	305	S182  
16343	305	S183  
16343	305	S203  
16343	305	S2202 
16343	305	S6    
16343	305	S7    
16343	305	S8    
16343	305	S9    
16397	305	S22   
16398	305	S10   
16398	305	S11   
16398	305	S12   
16398	305	S182  
16398	305	S183  
16398	305	S203  
16398	305	S22   
16398	305	S6    
16398	305	S7    
16398	305	S8    
16398	305	S9    
17202	305	S1082 
17203	305	S1082 
17204	305	S1082 
17218	305	S1581 
17219	305	S1581 
17332	305	S3    
17335	305	S3    
17340	305	S3    
17341	305	S3    
17342	305	S3    
17345	305	S3    
17346	305	S3    
17347	305	S3    
17348	305	S3    
18001	305	S1162 
18002	305	S1162 
18069	305	S20   
18079	305	S25   
18159	305	S21   
18166	305	S25   
18168	305	S25   
18215	305	S25   
18228	305	S23   
18231	305	S25   
18258	305	S1162 
18259	305	S1162 
18262	305	S1162 
18263	305	S1162 
18288	305	S27   
18350	305	S21   
18365	305	S27   
18376	305	S25   
18403	305	S27   
18927	305	S25   
18930	305	S2203 
18931	305	S2203 
18932	305	S27   
18933	305	S27   
18934	305	S27   
18935	305	S27   
18936	305	S27   
19003	305	S26   
19034	305	S26   
19035	305	S26   
19056	305	S26   
19057	305	S2109 
19058	305	S2109 
19064	305	S1164 
19076	305	S1164 
19078	305	S1069 
19088	305	S10   
19088	305	S11   
19088	305	S12   
19088	305	S6    
19088	305	S7    
19088	305	S8    
19088	305	S9    
19109	305	S1164 
19120	305	S10   
19120	305	S1069 
19120	305	S11   
19120	305	S12   
19120	305	S6    
19120	305	S7    
19120	305	S8    
19120	305	S9    
19129	305	S10   
19129	305	S11   
19129	305	S12   
19129	305	S6    
19129	305	S7    
19129	305	S8    
19129	305	S9    
19155	305	S1164 
19230	305	S1063 
19283	305	S1067 
19300	305	S10   
19300	305	S11   
19300	305	S12   
19300	305	S6    
19300	305	S7    
19300	305	S8    
19300	305	S9    
19335	305	S10   
19335	305	S11   
19335	305	S12   
19335	305	S6    
19335	305	S7    
19335	305	S8    
19335	305	S9    
19337	305	S2109 
19350	305	S1164 
19411	305	S26   
19856	305	S1067 
19868	305	S2109 
19873	305	S1067 
20046	305	S20   
20047	305	S20   
20048	305	S20   
20049	305	S20   
20100	305	S10   
20100	305	S11   
20100	305	S1163 
20100	305	S12   
20100	305	S20   
20100	305	S206  
20100	305	S208  
20100	305	S2682 
20100	305	S2683 
20100	305	S2684 
20100	305	S6    
20100	305	S7    
20100	305	S8    
20100	305	S9    
20109	305	S2105 
20110	305	S10   
20110	305	S11   
20110	305	S12   
20110	305	S206  
20110	305	S208  
20110	305	S2105 
20110	305	S2682 
20110	305	S2683 
20110	305	S2684 
20110	305	S6    
20110	305	S7    
20110	305	S8    
20110	305	S9    
20121	305	S10   
20121	305	S11   
20121	305	S1163 
20121	305	S12   
20121	305	S20   
20121	305	S206  
20121	305	S208  
20121	305	S2682 
20121	305	S2683 
20121	305	S2684 
20121	305	S6    
20121	305	S7    
20121	305	S8    
20121	305	S9    
20132	305	S1202 
20310	305	S10   
20310	305	S11   
20310	305	S12   
20310	305	S206  
20310	305	S208  
20310	305	S2105 
20310	305	S2682 
20310	305	S2683 
20310	305	S2684 
20310	305	S6    
20310	305	S7    
20310	305	S8    
20310	305	S9    
20321	305	S10   
20321	305	S11   
20321	305	S1163 
20321	305	S12   
20321	305	S20   
20321	305	S206  
20321	305	S208  
20321	305	S2682 
20321	305	S2683 
20321	305	S2684 
20321	305	S6    
20321	305	S7    
20321	305	S8    
20321	305	S9    
20400	305	S10   
20400	305	S11   
20400	305	S1163 
20400	305	S12   
20400	305	S20   
20400	305	S206  
20400	305	S208  
20400	305	S2682 
20400	305	S2683 
20400	305	S2684 
20400	305	S6    
20400	305	S7    
20400	305	S8    
20400	305	S9    
20409	305	S2105 
20410	305	S10   
20410	305	S11   
20410	305	S12   
20410	305	S206  
20410	305	S208  
20410	305	S2105 
20410	305	S2682 
20410	305	S2683 
20410	305	S2684 
20410	305	S6    
20410	305	S7    
20410	305	S8    
20410	305	S9    
20421	305	S10   
20421	305	S11   
20421	305	S1163 
20421	305	S12   
20421	305	S20   
20421	305	S206  
20421	305	S208  
20421	305	S2682 
20421	305	S2683 
20421	305	S2684 
20421	305	S6    
20421	305	S7    
20421	305	S8    
20421	305	S9    
20446	305	S20   
20447	305	S20   
20510	305	S10   
20510	305	S11   
20510	305	S12   
20510	305	S206  
20510	305	S208  
20510	305	S2105 
20510	305	S2682 
20510	305	S2683 
20510	305	S2684 
20510	305	S6    
20510	305	S7    
20510	305	S8    
20510	305	S9    
20521	305	S10   
20521	305	S11   
20521	305	S1163 
20521	305	S12   
20521	305	S20   
20521	305	S206  
20521	305	S208  
20521	305	S2682 
20521	305	S2683 
20521	305	S2684 
20521	305	S6    
20521	305	S7    
20521	305	S8    
20521	305	S9    
20623	305	S1742 
20624	305	S1742 
20628	305	S1742 
20629	305	S1742 
20630	305	S1742 
20634	305	S1742 
20635	305	S1742 
20636	305	S1742 
20640	305	S1742 
20641	305	S1742 
20645	305	S1742 
20646	305	S1742 
21138	305	S1064 
21138	305	S1066 
21138	305	S1122 
21141	305	S1064 
21224	305	S19   
21225	305	S19   
21226	305	S22   
21227	305	S22   
21229	305	S1122 
21238	305	S2801 
21239	305	S1066 
21240	305	S1066 
21241	305	S1066 
21242	305	S1066 
21243	305	S1066 
21244	305	S1066 
21245	305	S1066 
21246	305	S1066 
21247	305	S1066 
21248	305	S1066 
21249	305	S1064 
21250	305	S1064 
21251	305	S1064 
21252	305	S1064 
21253	305	S1064 
21254	305	S1064 
21255	305	S1064 
21256	305	S1064 
21257	305	S1064 
21259	305	S1064 
21260	305	S1082 
21261	305	S1082 
21262	305	S1082 
21263	305	S1082 
21264	305	S1082 
21265	305	S1082 
21266	305	S1082 
21267	305	S1082 
21268	305	S1082 
21269	305	S1082 
21270	305	S1082 
21271	305	S2108 
21272	305	S2108 
21273	305	S2108 
21274	305	S2108 
21275	305	S2108 
21276	305	S2108 
21277	305	S2110 
21278	305	S2110 
21279	305	S2110 
21280	305	S2110 
21281	305	S2110 
21282	305	S2110 
21283	305	S2111 
21284	305	S2111 
21285	305	S2111 
21286	305	S2111 
21287	305	S2112 
21288	305	S2112 
21289	305	S2112 
21290	305	S2112 
21291	305	S2112 
21292	305	S2112 
21293	305	S2782 
21294	305	S2782 
21295	305	S2782 
21296	305	S2782 
21297	305	S2782 
21298	305	S2782 
21299	305	S2110 
21299	305	S2111 
21299	305	S2112 
21299	305	S2782 
21300	305	S2110 
21300	305	S2112 
21300	305	S2782 
21301	305	S2110 
21301	305	S2111 
21301	305	S2112 
21301	305	S2782 
21302	305	S2110 
21302	305	S2111 
21302	305	S2112 
21302	305	S2782 
21303	305	S2110 
21303	305	S2112 
21303	305	S2782 
21304	305	S2110 
21304	305	S2111 
21304	305	S2112 
21304	305	S2782 
21308	305	S2801 
21309	305	S2801 
21310	305	S2801 
21311	305	S2801 
21312	305	S2801 
21313	305	S2801 
21314	305	S2801 
21315	305	S2801 
21316	305	S2801 
21317	305	S2801 
21318	305	S2801 
21319	305	S2801 
21320	305	S2801 
21321	305	S2801 
21322	305	S2801 
21323	305	S2801 
21324	305	S2801 
21325	305	S2801 
21326	305	S2801 
21337	305	S2801 
21343	305	S2801 
21346	305	S2801 
21347	305	S2801 
21348	305	S2801 
21349	305	S2801 
22247	305	S20   
22903	305	S21   
22904	305	S18   
22909	305	S22   
22911	305	S18   
22912	305	S19   
22914	305	S19   
22915	305	S19   
22916	305	S19   
23009	305	S2703 
23010	305	S2703 
23011	305	S2703 
23012	305	S2703 
23013	305	S2703 
23014	305	S2703 
23015	305	S2703 
23016	305	S2703 
23017	305	S2703 
23018	305	S2703 
23019	305	S2703 
23020	305	S2703 
23021	305	S2703 
23022	305	S2703 
23023	305	S2703 
23024	305	S2703 
23025	305	S2703 
23027	305	S2703 
23028	305	S2703 
23029	305	S2703 
23030	305	S2703 
23031	305	S2703 
23032	305	S2703 
23033	305	S2703 
23034	305	S2703 
23035	305	S2703 
23036	305	S2703 
23037	305	S2703 
23038	305	S2703 
23039	305	S2703 
23040	305	S2703 
23041	305	S2703 
23042	305	S2703 
23043	305	S2703 
23044	305	S2703 
23045	305	S2703 
23046	305	S2703 
23047	305	S2703 
23048	305	S2703 
23049	305	S2703 
23050	305	S2703 
23051	305	S2703 
23052	305	S2703 
23053	305	S2703 
23054	305	S2703 
23055	305	S2703 
23056	305	S2703 
23057	305	S2703 
23058	305	S2703 
23059	305	S2703 
23060	305	S2703 
23061	305	S2703 
23062	305	S2703 
23063	305	S2703 
23064	305	S2703 
23065	305	S2703 
23557	305	S14   
23558	305	S14   
23559	305	S14   
23560	305	S14   
23561	305	S14   
23562	305	S14   
23563	305	S14   
23564	305	S14   
23565	305	S14   
23566	305	S14   
23567	305	S14   
23568	305	S14   
23569	305	S14   
23570	305	S14   
23571	305	S14   
23572	305	S14   
23573	305	S14   
23574	305	S14   
23575	305	S14   
23576	305	S14   
23577	305	S14   
23578	305	S14   
23579	305	S14   
23580	305	S14   
23581	305	S14   
23582	305	S2    
23583	305	S2    
23584	305	S2    
23585	305	S2    
23586	305	S2    
23587	305	S2    
23588	305	S2    
23589	305	S2    
23590	305	S2    
23591	305	S2    
23592	305	S2    
23593	305	S2    
23594	305	S2    
23595	305	S2    
23596	305	S2    
23597	305	S2    
23598	305	S2    
23599	305	S2    
23600	305	S2    
23601	305	S2    
23602	305	S2    
23603	305	S2    
23604	305	S2    
23605	305	S2    
23606	305	S2    
23607	305	S2    
23608	305	S2    
23609	305	S2    
23610	305	S2    
23611	305	S2    
23612	305	S2    
23613	305	S2    
23614	305	S2    
23615	305	S2    
23616	305	S2    
23617	305	S2    
23618	305	S2    
23619	305	S2    
23620	305	S2    
23621	305	S2    
23622	305	S2    
23623	305	S2    
23624	305	S2    
23625	305	S2    
23626	305	S2    
23627	305	S2    
23628	305	S2    
23629	305	S2    
23630	305	S2    
23631	305	S2    
23632	305	S2    
23633	305	S2    
23634	305	S2    
23635	305	S2    
23636	305	S2    
23637	305	S2    
23638	305	S2    
23640	305	S1581 
23646	305	S2    
23647	305	S2    
23648	305	S2    
23649	305	S2    
23650	305	S2    
23651	305	S2    
23652	305	S2    
23653	305	S2    
23654	305	S2    
23655	305	S2    
23656	305	S2    
23657	305	S2    
23658	305	S2    
23659	305	S2    
23660	305	S2    
35001	305	D4961 
35002	305	D4961 
35003	305	D4961 
35009	305	D4961 
35010	305	D4961 
35011	305	D4961 
35012	305	D4961 
35013	305	D4961 
35014	305	D4961 
35015	305	D4961 
35016	305	D4961 
35021	305	D4961 
35022	305	D4961 
35023	305	D4961 
35024	305	D4961 
35025	305	D4961 
35027	305	D4961 
35029	305	D4961 
35030	305	D4961 
35034	305	D4961 
35038	305	D4961 
35040	305	D4961 
35042	305	D4961 
35047	305	D4961 
35048	305	D4961 
35050	305	D4961 
35051	305	D4961 
35054	305	D4961 
35055	305	D4961 
35056	305	D4961 
35057	305	D4961 
35058	305	D4961 
35059	305	D4961 
35060	305	D4961 
35063	305	D4961 
35064	305	D4961 
35068	305	D4961 
35071	305	D4961 
35072	305	D4961 
35073	305	D4961 
35074	305	D4961 
35075	305	D4961 
35078	305	D4961 
35079	305	D4961 
35081	305	D4961 
35082	305	D4961 
35083	305	D4961 
35085	305	D4961 
35086	305	D4961 
35087	305	D4961 
35088	305	D4961 
35089	305	D4961 
35090	305	D4961 
35091	305	D4961 
35092	305	D4961 
35093	305	D4961 
35130	305	S2381 
35131	305	S2381 
35132	305	S2381 
35133	305	S2381 
35134	305	S2381 
35135	305	S2381 
35136	305	S2381 
35137	305	S2381 
35138	305	S2381 
35140	305	S2381 
35141	305	S2381 
35142	305	S2381 
35143	305	S2381 
35144	305	S2381 
35145	305	S2381 
35146	305	S2381 
35147	305	S2381 
35148	305	S2381 
42190	305	S243  
43158	305	S2109 
43215	305	S26   
43329	305	S25   
43364	305	S26   
43378	305	S1082 
43514	305	S1067 
48052	305	S1362 
01001	306	S10   
01001	306	S11   
01001	306	S12   
01001	306	S6    
01001	306	S7    
01001	306	S8    
01001	306	S9    
01026	306	S25   
01032	306	S19   
01040	306	S10   
01040	306	S11   
01040	306	S12   
01040	306	S6    
01040	306	S7    
01040	306	S8    
01040	306	S9    
01042	306	S10   
01042	306	S11   
01042	306	S12   
01042	306	S19   
01042	306	S6    
01042	306	S7    
01042	306	S8    
01042	306	S9    
01046	306	S19   
01077	306	S10   
01077	306	S11   
01077	306	S12   
01077	306	S27   
01077	306	S6    
01077	306	S7    
01077	306	S8    
01077	306	S9    
01079	306	S10   
01079	306	S1063 
01079	306	S11   
01079	306	S12   
01079	306	S7    
01079	306	S8    
01079	306	S9    
01082	306	S1063 
01085	306	S10   
01085	306	S1063 
01085	306	S11   
01085	306	S12   
01085	306	S6    
01085	306	S7    
01085	306	S8    
01085	306	S9    
01123	306	S1063 
01123	306	S561  
01124	306	S1065 
01125	306	S1065 
01145	306	S10   
01145	306	S11   
01145	306	S12   
01145	306	S6    
01145	306	S7    
01145	306	S8    
01145	306	S9    
01202	306	S1163 
02048	306	S2109 
02048	306	S2922 
02053	306	S2109 
02053	306	S2922 
04017	306	S19   
04020	306	S19   
04021	306	S19   
04023	306	S19   
04053	306	S19   
04114	306	S19   
04120	306	S19   
04141	306	S19   
04142	306	S19   
04143	306	S19   
04144	306	S19   
04367	306	S19   
04610	306	S18   
04628	306	S18   
04629	306	S18   
04630	306	S19   
04631	306	S20   
04635	306	S19   
04636	306	S19   
04638	306	S26   
04639	306	S26   
04640	306	S26   
04641	306	S25   
04656	306	S2221 
04657	306	S2221 
04658	306	S2221 
04659	306	S2221 
04660	306	S2221 
04661	306	S2221 
04662	306	S2221 
04663	306	S2221 
04673	306	S2401 
04674	306	S2401 
04675	306	S2401 
04676	306	S2401 
04677	306	S2401 
05023	306	S1581 
05024	306	S1581 
05027	306	S1082 
05028	306	S1082 
05173	306	S1581 
05174	306	S1581 
05175	306	S1581 
05176	306	S1581 
05177	306	S1581 
05178	306	S1581 
05312	306	S26   
05313	306	S26   
05320	306	S26   
05623	306	D4282 
05624	306	S3    
05625	306	D4282 
05626	306	D4281 
05626	306	D4282 
05627	306	D4282 
05628	306	D4281 
05628	306	D4282 
05629	306	D4281 
05630	306	D4282 
05631	306	D4282 
05632	306	S3    
05661	306	S1082 
06016	306	S18   
06019	306	S18   
06043	306	S18   
06094	306	S18   
06128	306	S18   
06159	306	S18   
06164	306	S23   
06931	306	S22   
06982	306	S18   
06983	306	S18   
06984	306	S2104 
06985	306	S2104 
07002	306	S222  
07005	306	S248  
07007	306	S1164 
07008	306	S238  
07011	306	S227  
07015	306	S248  
07016	306	S248  
07022	306	S21   
07039	306	S244  
07052	306	S227  
07056	306	S248  
07057	306	S235  
07057	306	S238  
07063	306	S1164 
07063	306	S582  
07064	306	S1164 
07068	306	S1041 
07075	306	S1164 
07078	306	S228  
07079	306	S227  
07080	306	S227  
07241	306	S21   
07276	306	S259  
07278	306	S259  
07279	306	S259  
07909	306	S259  
07910	306	S245  
07913	306	S238  
07921	306	S228  
07923	306	S245  
07926	306	S228  
07927	306	S227  
07929	306	S227  
07931	306	S222  
07938	306	S233  
07939	306	S235  
07944	306	S227  
07945	306	S21   
07949	306	S23   
07950	306	S23   
07951	306	S243  
07952	306	S1164 
07953	306	S1164 
07953	306	S582  
07954	306	S582  
07955	306	S1164 
07956	306	S1164 
07957	306	S1164 
07958	306	S1164 
07959	306	S1164 
07960	306	S1164 
08001	306	S1065 
08003	306	S2664 
08005	306	S2664 
08010	306	S702  
08011	306	S702  
08012	306	S1065 
08013	306	S2421 
08014	306	S1065 
08017	306	S603  
08018	306	S702  
08019	306	S603  
08020	306	S1065 
08023	306	S2664 
08025	306	S2662 
08026	306	S603  
08028	306	S2664 
08030	306	S1065 
08031	306	S2664 
08032	306	S2664 
08035	306	S603  
08045	306	S603  
08047	306	S702  
08048	306	S603  
08049	306	S702  
08050	306	S603  
08054	306	S702  
08057	306	S603  
08058	306	S2664 
08059	306	S702  
08060	306	S2664 
08061	306	S1065 
08064	306	S603  
08065	306	S1065 
08065	306	S2662 
08066	306	S702  
08067	306	S2664 
08068	306	S2664 
08069	306	S2664 
08071	306	S2664 
08074	306	S2662 
08077	306	S1065 
08078	306	S603  
08082	306	S603  
08083	306	S2502 
08085	306	S702  
08086	306	S603  
08087	306	S603  
08089	306	S603  
08092	306	S702  
08094	306	S702  
08116	306	S2502 
08124	306	S702  
08128	306	S702  
08130	306	S702  
08138	306	S2502 
08139	306	S603  
08146	306	S702  
08147	306	S1065 
08147	306	S2422 
08177	306	S2502 
08189	306	S2664 
08190	306	S603  
08194	306	S603  
08200	306	S702  
08202	306	S603  
08206	306	S2502 
08210	306	S702  
08211	306	S702  
08212	306	S702  
08214	306	S702  
08215	306	S702  
08216	306	S702  
08217	306	S2664 
08218	306	S1065 
08219	306	S702  
08220	306	S702  
08221	306	S702  
08225	306	S702  
08229	306	S702  
08231	306	S702  
08232	306	S702  
08243	306	S603  
08244	306	S603  
08245	306	S603  
08246	306	S603  
08247	306	S603  
08253	306	S2664 
08258	306	S2664 
08259	306	S2662 
08261	306	S603  
08262	306	S603  
08263	306	S603  
08266	306	S603  
08267	306	S603  
08268	306	S603  
08269	306	S603  
08270	306	S603  
08271	306	S603  
08272	306	S603  
08273	306	S603  
08274	306	S603  
08277	306	S603  
08278	306	S603  
08283	306	S2664 
08284	306	S2664 
08286	306	S2664 
08287	306	S2664 
08288	306	S2664 
08289	306	S2664 
08293	306	S702  
08294	306	S702  
08299	306	S702  
08309	306	S2664 
08315	306	S702  
08316	306	S702  
08317	306	S702  
08318	306	S2664 
08319	306	S2664 
08345	306	S603  
08346	306	S2502 
08347	306	S2502 
08348	306	S2502 
08349	306	S2502 
08350	306	S2502 
08351	306	S702  
08352	306	S702  
08353	306	S702  
08354	306	S702  
08355	306	S702  
08357	306	S702  
08358	306	S702  
08359	306	S702  
08360	306	S702  
08361	306	S702  
08362	306	S702  
08363	306	S702  
08364	306	S702  
08366	306	S702  
08367	306	S603  
08368	306	S603  
08370	306	S603  
08371	306	S603  
08372	306	S603  
08374	306	S2664 
08376	306	S2664 
08378	306	S2161 
08379	306	S2664 
08380	306	S2664 
08383	306	S2664 
08384	306	S2664 
08385	306	S2664 
08386	306	S2664 
08387	306	S2664 
08388	306	S2664 
08389	306	S2664 
08390	306	S2664 
08391	306	S682  
08392	306	S2664 
08393	306	S2664 
08394	306	S702  
08395	306	S702  
08396	306	S702  
08397	306	S603  
08398	306	S603  
08399	306	S603  
08400	306	S881  
08401	306	S881  
08402	306	S702  
08403	306	S1209 
08408	306	S2502 
08409	306	S2502 
08410	306	S702  
08411	306	S702  
08412	306	S702  
08413	306	S702  
08414	306	S702  
08415	306	S702  
08416	306	S702  
08417	306	S702  
08418	306	S702  
08419	306	S702  
08420	306	S702  
08421	306	S702  
08422	306	S702  
08435	306	S1065 
08436	306	S702  
08444	306	S702  
08446	306	S702  
08448	306	S702  
08449	306	S702  
08450	306	S702  
08454	306	S2664 
08455	306	S2664 
08456	306	S2664 
08457	306	S2664 
08458	306	S2664 
08459	306	S2664 
08460	306	S2664 
08461	306	S2664 
08462	306	S2664 
08463	306	S2664 
08465	306	S2664 
08466	306	S2664 
08467	306	S2161 
08468	306	S2664 
08469	306	S2664 
08470	306	S2664 
08471	306	S2664 
08472	306	S2664 
08473	306	S2664 
08474	306	S2664 
08476	306	S2502 
08478	306	S2502 
08481	306	S2502 
08482	306	S2502 
08483	306	S2502 
08484	306	S2502 
08487	306	S2502 
08488	306	S2502 
08489	306	S2502 
08490	306	S2502 
08491	306	S2502 
08492	306	S2502 
08493	306	S2502 
08495	306	S2502 
08497	306	S2502 
08500	306	S2502 
08501	306	S2502 
08504	306	S2662 
08505	306	S2662 
08506	306	S2662 
08507	306	S2662 
08508	306	S2662 
08509	306	S2662 
09003	306	D4070 
09003	306	S1183 
09003	306	S502  
09003	306	S561  
09004	306	S502  
09021	306	S10   
09021	306	S11   
09021	306	S12   
09021	306	S206  
09021	306	S208  
09021	306	S7    
09021	306	S8    
09021	306	S9    
09032	306	S21   
09037	306	D4070 
09037	306	S1031 
09037	306	S1621 
09037	306	S381  
09037	306	S481  
09037	306	S502  
09038	306	S1031 
09038	306	S1621 
09038	306	S481  
09038	306	S502  
09039	306	D4070 
09039	306	S381  
09040	306	S10   
09040	306	S1023 
09040	306	S11   
09040	306	S12   
09040	306	S206  
09040	306	S208  
09040	306	S481  
09040	306	S562  
09040	306	S6    
09040	306	S7    
09040	306	S73   
09040	306	S74   
09040	306	S8    
09040	306	S9    
09042	306	S566  
09050	306	S1141 
09050	306	S441  
09060	306	D4070 
09060	306	S381  
09062	306	S381  
09062	306	S404  
09070	306	D4070 
09070	306	S10   
09070	306	S11   
09070	306	S12   
09070	306	S182  
09070	306	S183  
09070	306	S201  
09070	306	S202  
09070	306	S203  
09070	306	S204  
09070	306	S205  
09070	306	S206  
09070	306	S208  
09070	306	S53   
09070	306	S582  
09070	306	S6    
09070	306	S73   
09070	306	S74   
09070	306	S8    
09070	306	S9    
09078	306	S561  
09079	306	S1701 
09087	306	S1032 
09087	306	S564  
09087	306	S582  
09094	306	S363  
09094	306	S582  
09112	306	D4070 
09112	306	S482  
09112	306	S563  
09132	306	D4070 
09132	306	S10   
09132	306	S1062 
09132	306	S11   
09132	306	S12   
09132	306	S206  
09132	306	S208  
09132	306	S6    
09132	306	S7    
09132	306	S8    
09132	306	S9    
09139	306	S381  
09148	306	D4070 
09148	306	S1033 
09148	306	S363  
09149	306	S381  
09160	306	S1065 
09181	306	D4070 
09181	306	S10   
09181	306	S1024 
09181	306	S11   
09181	306	S1121 
09181	306	S12   
09181	306	S206  
09181	306	S208  
09181	306	S461  
09181	306	S6    
09181	306	S7    
09181	306	S73   
09181	306	S74   
09181	306	S8    
09181	306	S9    
09183	306	S381  
09184	306	D4070 
09184	306	S1026 
09184	306	S562  
09184	306	S565  
09191	306	D4070 
09191	306	S421  
09191	306	S582  
09195	306	S1202 
09195	306	S1562 
09202	306	S482  
09202	306	S564  
09218	306	S1065 
09218	306	S1161 
09236	306	D4070 
09236	306	S10   
09236	306	S11   
09236	306	S12   
09236	306	S461  
09236	306	S582  
09236	306	S6    
09236	306	S7    
09236	306	S73   
09236	306	S74   
09236	306	S8    
09236	306	S9    
09252	306	D4070 
09252	306	S10   
09252	306	S11   
09252	306	S12   
09252	306	S206  
09252	306	S208  
09252	306	S482  
09252	306	S541  
09252	306	S6    
09252	306	S7    
09252	306	S73   
09252	306	S74   
09252	306	S8    
09252	306	S9    
09266	306	D4070 
09266	306	S1167 
09266	306	S441  
09266	306	S561  
09273	306	S2104 
09273	306	S2985 
09279	306	S10   
09279	306	S11   
09279	306	S12   
09279	306	S206  
09279	306	S208  
09279	306	S421  
09279	306	S582  
09279	306	S6    
09279	306	S7    
09279	306	S73   
09279	306	S74   
09279	306	S8    
09279	306	S9    
09291	306	S10   
09291	306	S11   
09291	306	S12   
09291	306	S206  
09291	306	S208  
09291	306	S564  
09291	306	S566  
09291	306	S6    
09291	306	S7    
09291	306	S73   
09291	306	S74   
09291	306	S8    
09291	306	S9    
09298	306	S10   
09298	306	S11   
09298	306	S12   
09298	306	S206  
09298	306	S208  
09298	306	S564  
09298	306	S566  
09298	306	S6    
09298	306	S7    
09298	306	S73   
09298	306	S74   
09298	306	S8    
09298	306	S9    
09302	306	S381  
09302	306	S461  
09302	306	S566  
09302	306	S963  
09316	306	S10   
09316	306	S11   
09316	306	S1162 
09316	306	S12   
09316	306	S182  
09316	306	S183  
09316	306	S201  
09316	306	S202  
09316	306	S203  
09316	306	S204  
09316	306	S205  
09316	306	S206  
09316	306	S208  
09316	306	S421  
09316	306	S566  
09316	306	S581  
09316	306	S6    
09316	306	S7    
09316	306	S73   
09316	306	S74   
09316	306	S8    
09316	306	S9    
09326	306	S10   
09326	306	S1027 
09326	306	S11   
09326	306	S12   
09326	306	S206  
09326	306	S208  
09326	306	S441  
09326	306	S461  
09326	306	S6    
09326	306	S7    
09326	306	S73   
09326	306	S74   
09326	306	S8    
09326	306	S9    
09328	306	S1206 
09409	306	S2104 
09409	306	S2985 
09421	306	S564  
09421	306	S582  
09422	306	S1202 
09427	306	D4053 
09428	306	D4053 
09429	306	D4070 
09429	306	S1167 
09429	306	S441  
09430	306	S441  
09430	306	S561  
09431	306	S2203 
09432	306	S2203 
09433	306	S2105 
09433	306	S2961 
10007	306	S1082 
10066	306	S1082 
10067	306	S1082 
10068	306	S1082 
10098	306	S1581 
10099	306	S1581 
10102	306	S1581 
10119	306	S1581 
10123	306	S1082 
10124	306	S1082 
10173	306	S1581 
10858	306	S1082 
10860	306	S1082 
10861	306	S1082 
10862	306	S1082 
10863	306	S1581 
10864	306	S1082 
11011	306	S1069 
11012	306	S1069 
11019	306	S10   
11019	306	S11   
11019	306	S12   
11019	306	S6    
11019	306	S7    
11019	306	S8    
11019	306	S9    
11090	306	S1121 
11090	306	S1164 
11090	306	S564  
11090	306	S619  
11091	306	S1121 
11091	306	S564  
11096	306	S1121 
11096	306	S482  
11097	306	S482  
11101	306	S10   
11101	306	S11   
11101	306	S12   
11101	306	S6    
11101	306	S7    
11101	306	S8    
11101	306	S9    
11112	306	S1065 
11113	306	S1065 
11124	306	S1062 
11124	306	S183  
11124	306	S201  
11124	306	S202  
11124	306	S203  
11124	306	S6    
11124	306	S618  
11125	306	S1062 
11130	306	S25   
11131	306	S25   
11143	306	S1121 
11143	306	S183  
11143	306	S201  
11143	306	S202  
11143	306	S203  
11143	306	S564  
11143	306	S6    
11157	306	S1202 
11205	306	S1062 
11206	306	S1062 
11206	306	S183  
11206	306	S201  
11206	306	S202  
11206	306	S203  
11206	306	S6    
11210	306	S10   
11210	306	S11   
11210	306	S12   
11210	306	S6    
11210	306	S7    
11210	306	S8    
11210	306	S9    
11243	306	S2941 
11250	306	S562  
11250	306	S565  
11251	306	S481  
11251	306	S503  
11251	306	S620  
11252	306	S10   
11252	306	S11   
11252	306	S12   
11252	306	S183  
11252	306	S201  
11252	306	S202  
11252	306	S203  
11252	306	S481  
11252	306	S562  
11252	306	S6    
11252	306	S624  
11252	306	S7    
11252	306	S8    
11252	306	S9    
11253	306	S541  
11253	306	S565  
11257	306	S541  
11257	306	S565  
11260	306	S10   
11260	306	S11   
11260	306	S12   
11260	306	S2941 
11260	306	S6    
11260	306	S7    
11260	306	S78   
11260	306	S8    
11260	306	S80   
11260	306	S9    
11263	306	S2941 
11267	306	S2941 
11279	306	S10   
11279	306	S11   
11279	306	S12   
11279	306	S6    
11279	306	S7    
11279	306	S8    
11279	306	S9    
11282	306	S10   
11282	306	S1062 
11282	306	S11   
11282	306	S12   
11282	306	S183  
11282	306	S201  
11282	306	S202  
11282	306	S203  
11282	306	S6    
11282	306	S7    
11282	306	S8    
11282	306	S9    
11286	306	S1062 
11294	306	S563  
11294	306	S582  
11333	306	S1062 
11333	306	S183  
11333	306	S201  
11333	306	S202  
11333	306	S203  
11333	306	S6    
11333	306	S611  
11339	306	S1062 
11352	306	S563  
11352	306	S566  
11353	306	S563  
11353	306	S566  
11354	306	S563  
11354	306	S566  
11355	306	S563  
11355	306	S566  
11356	306	S563  
11356	306	S566  
11357	306	S563  
11357	306	S566  
11358	306	S563  
11358	306	S566  
11359	306	S2105 
11360	306	S183  
11360	306	S201  
11360	306	S202  
11360	306	S203  
11360	306	S2105 
11360	306	S6    
11394	306	S2105 
11395	306	S2105 
11398	306	S2105 
11399	306	S2105 
11402	306	S2105 
11403	306	S183  
11403	306	S201  
11403	306	S202  
11403	306	S203  
11403	306	S2105 
11403	306	S6    
11411	306	S2105 
11412	306	S2105 
11429	306	S1121 
11429	306	S363  
11429	306	S617  
11463	306	S25   
11464	306	S25   
11468	306	S12   
11468	306	S183  
11468	306	S201  
11468	306	S202  
11468	306	S203  
11507	306	S1062 
11508	306	S10   
11508	306	S1062 
11508	306	S11   
11508	306	S12   
11508	306	S183  
11508	306	S201  
11508	306	S202  
11508	306	S203  
11508	306	S6    
11508	306	S7    
11508	306	S8    
11508	306	S9    
11510	306	S1062 
11529	306	S183  
11529	306	S201  
11529	306	S202  
11529	306	S203  
11529	306	S441  
11529	306	S503  
11529	306	S6    
11529	306	S608  
11530	306	S441  
11540	306	S10   
11540	306	S11   
11540	306	S12   
11540	306	S183  
11540	306	S201  
11540	306	S202  
11540	306	S203  
11540	306	S6    
11540	306	S7    
11540	306	S8    
11540	306	S9    
11546	306	S21   
11546	306	S626  
11546	306	S627  
11547	306	S21   
11547	306	S625  
11547	306	S626  
11547	306	S627  
11549	306	S183  
11549	306	S201  
11549	306	S202  
11549	306	S203  
11549	306	S21   
11549	306	S6    
11565	306	S10   
11565	306	S11   
11565	306	S12   
11565	306	S6    
11565	306	S7    
11565	306	S8    
11565	306	S9    
11674	306	S183  
11674	306	S201  
11674	306	S202  
11674	306	S203  
11674	306	S563  
11674	306	S566  
11705	306	S1069 
11709	306	S10   
11709	306	S11   
11709	306	S12   
11709	306	S6    
11709	306	S7    
11709	306	S8    
11709	306	S9    
11742	306	S1121 
11742	306	S564  
11746	306	S10   
11746	306	S11   
11746	306	S12   
11746	306	S6    
11746	306	S7    
11746	306	S8    
11746	306	S9    
11752	306	S1065 
11757	306	S1062 
11760	306	S25   
11783	306	S10   
11783	306	S11   
11783	306	S12   
11783	306	S6    
11783	306	S7    
11783	306	S8    
11783	306	S9    
11803	306	S10   
11803	306	S11   
11803	306	S12   
11803	306	S6    
11803	306	S7    
11803	306	S8    
11803	306	S9    
11821	306	S1062 
11828	306	S183  
11828	306	S201  
11828	306	S202  
11828	306	S203  
11828	306	S563  
11828	306	S566  
11841	306	S183  
11841	306	S201  
11841	306	S202  
11841	306	S203  
11841	306	S2105 
11841	306	S6    
11842	306	S2105 
11856	306	S25   
11858	306	S12   
11858	306	S183  
11858	306	S201  
11858	306	S202  
11858	306	S203  
11875	306	S10   
11875	306	S1062 
11875	306	S11   
11875	306	S12   
11875	306	S183  
11875	306	S201  
11875	306	S202  
11875	306	S203  
11875	306	S6    
11875	306	S7    
11875	306	S8    
11875	306	S9    
11876	306	S1062 
11884	306	S441  
11886	306	S10   
11886	306	S11   
11886	306	S12   
11886	306	S183  
11886	306	S201  
11886	306	S202  
11886	306	S203  
11886	306	S6    
11886	306	S7    
11886	306	S8    
11886	306	S9    
11887	306	S21   
11887	306	S626  
11887	306	S627  
11888	306	S21   
11888	306	S625  
11888	306	S626  
11888	306	S627  
11921	306	S1062 
11935	306	S183  
11935	306	S202  
11935	306	S203  
11935	306	S22   
11935	306	S6    
11949	306	S183  
11949	306	S202  
11949	306	S203  
11949	306	S22   
11949	306	S6    
11950	306	S2941 
11960	306	S481  
11960	306	S562  
11987	306	S1202 
11987	306	S2941 
11990	306	S1202 
11991	306	S1202 
11992	306	S2941 
12006	306	S1783 
12061	306	S141  
12062	306	S141  
12063	306	S141  
12065	306	S141  
12078	306	S1063 
12078	306	S503  
12086	306	S343  
12086	306	S363  
12086	306	S502  
12087	306	S343  
12120	306	S83   
12121	306	S83   
12122	306	S83   
12131	306	S77   
12132	306	S77   
12142	306	S85   
12143	306	S85   
12144	306	S85   
12147	306	S502  
12147	306	S564  
12151	306	S101  
12151	306	S86   
12152	306	S101  
12152	306	S86   
12154	306	S941  
12155	306	S79   
12201	306	S1164 
12220	306	D4743 
12220	306	S1221 
12220	306	S2109 
12563	306	S141  
12565	306	S141  
12586	306	S343  
12586	306	S363  
12586	306	S502  
12632	306	S77   
12643	306	S85   
12644	306	S85   
12652	306	S101  
12652	306	S86   
13019	306	S2    
13020	306	S2    
13055	306	S2    
13065	306	S2    
13067	306	S2    
13068	306	S2    
13070	306	S2    
13096	306	S2    
13098	306	S2    
13165	306	S2    
13231	306	S221  
13232	306	S221  
13235	306	S221  
13236	306	S221  
13318	306	S1581 
13320	306	S1581 
13321	306	S1581 
13322	306	S1581 
13323	306	S1581 
13324	306	S1581 
13325	306	S1082 
13326	306	S1082 
13327	306	S1082 
13340	306	S1581 
13341	306	S1581 
13343	306	S2    
13369	306	S2    
13370	306	S2    
13373	306	S2    
13375	306	S2    
13377	306	S2    
13378	306	S2    
13391	306	S2    
13394	306	S2    
13398	306	S2    
13399	306	S2    
13401	306	S2    
13402	306	S2    
13404	306	S2    
13405	306	S2    
13407	306	S2    
13408	306	S2    
13410	306	S2    
13411	306	S2    
13413	306	S2    
13414	306	S2    
13415	306	S2    
13416	306	S2    
13417	306	S2    
13418	306	S2    
13419	306	S2    
13420	306	S2    
13421	306	S2    
13422	306	S2    
13423	306	S2    
13424	306	S2    
13425	306	S2    
13426	306	S2    
13439	306	S2    
13440	306	S2    
13441	306	S2    
13442	306	S2    
13443	306	S2    
13444	306	S2    
13445	306	S2    
13446	306	S2    
13447	306	S2    
13448	306	S2    
13449	306	S2    
13450	306	S2    
13451	306	S2    
13452	306	S2    
13453	306	S2    
13454	306	S2    
13455	306	S2    
13456	306	S2    
13467	306	S221  
13468	306	S221  
13469	306	S221  
13481	306	S221  
13482	306	S221  
13483	306	S221  
13484	306	S221  
13485	306	S2    
13486	306	S2    
13487	306	S2    
13488	306	S2    
13490	306	S2    
13491	306	S2    
13492	306	S2    
13493	306	S2    
13494	306	S14   
13495	306	S14   
13496	306	S14   
13497	306	S14   
13498	306	S14   
13565	306	S2703 
13566	306	S2703 
13567	306	S2703 
13568	306	S2703 
13569	306	S2703 
13805	306	S2    
13806	306	S2    
13809	306	S2    
13810	306	S2    
13811	306	S2    
13812	306	S2    
13813	306	S2    
13814	306	S2    
13850	306	S2    
13851	306	S2    
13853	306	S2    
13854	306	S2    
13856	306	S2    
13857	306	S2    
13868	306	S2    
13869	306	S2    
13870	306	S2    
13871	306	S2    
13872	306	S2    
13873	306	S2    
13874	306	S2    
13875	306	S2    
13876	306	S2    
13877	306	S2    
13878	306	S2    
13879	306	S2    
13880	306	S2    
13881	306	S2    
13882	306	S2    
13891	306	S2    
13893	306	S2    
13894	306	S2    
13896	306	S2    
13898	306	S2    
13900	306	S2    
13909	306	S2    
13910	306	S2    
13911	306	S2    
13912	306	S2    
13913	306	S2    
13914	306	S2    
13917	306	S2    
13918	306	S2    
13920	306	S2    
13921	306	S2    
13923	306	S2    
13924	306	S2    
13929	306	S2    
13930	306	S2    
13931	306	S2    
13932	306	S2    
13934	306	S2    
13935	306	S2    
13948	306	S2    
13949	306	S2    
13950	306	S2    
13951	306	S2    
13952	306	S2    
13953	306	S2    
13954	306	S2    
13955	306	S2    
13956	306	S2    
13957	306	S2    
13958	306	S2    
13959	306	S2    
13961	306	S221  
13963	306	S221  
13965	306	S221  
13967	306	S221  
13968	306	S2    
13969	306	S2    
13970	306	S2    
13971	306	S2    
13977	306	S221  
13985	306	S2    
13988	306	S2703 
13989	306	S2703 
13990	306	S2703 
13991	306	S2703 
13992	306	S2703 
13994	306	S2703 
13995	306	S2703 
13996	306	S2703 
13997	306	S2703 
13998	306	S2703 
14003	306	S2103 
14006	306	S2103 
14052	306	S10   
14052	306	S11   
14052	306	S12   
14052	306	S6    
14052	306	S7    
14052	306	S8    
14052	306	S9    
14084	306	S2103 
14096	306	S2103 
14106	306	S2103 
14137	306	S1068 
14144	306	S1068 
14145	306	S1064 
14145	306	S1066 
14145	306	S1068 
14145	306	S1122 
14146	306	S1068 
14147	306	S1068 
14148	306	S1068 
14149	306	S1068 
14154	306	S2702 
14156	306	S2702 
14166	306	S10   
14166	306	S11   
14166	306	S12   
14166	306	S6    
14166	306	S7    
14166	306	S8    
14166	306	S9    
14209	306	S1064 
14209	306	S1066 
14209	306	S1122 
14209	306	S23   
14219	306	S10   
14219	306	S11   
14219	306	S12   
14219	306	S6    
14219	306	S7    
14219	306	S8    
14219	306	S9    
14238	306	S2104 
14242	306	S2104 
14243	306	D673  
14267	306	S10   
14267	306	S11   
14267	306	S12   
14267	306	S6    
14267	306	S7    
14267	306	S8    
14267	306	S9    
14277	306	D672  
14277	306	D673  
14282	306	D672  
14347	306	S1064 
14347	306	S1122 
14366	306	S2104 
14370	306	S2104 
14382	306	S1164 
14400	306	S1064 
14400	306	S1066 
14400	306	S1068 
14400	306	S1122 
14416	306	S1064 
14416	306	S1066 
14416	306	S1068 
14416	306	S1122 
14427	306	D642  
14429	306	S20   
14429	306	S23   
14429	306	S25   
14432	306	S1068 
14433	306	S1068 
14434	306	S1068 
14437	306	S27   
14438	306	S27   
14439	306	D4541 
14440	306	S2109 
14450	306	S1164 
14460	306	S1164 
14461	306	S1164 
14462	306	S2109 
14475	306	S1068 
14476	306	S1068 
14555	306	D4541 
14555	306	S1068 
14555	306	S27   
14559	306	S1068 
14559	306	S27   
14601	306	S1066 
14602	306	S2103 
15027	306	S10   
15027	306	S11   
15027	306	S1163 
15027	306	S12   
15027	306	S9    
15073	306	S1163 
15087	306	S2109 
15152	306	S2104 
15232	306	S1163 
15260	306	S2109 
15261	306	S1163 
15262	306	S1163 
16006	306	S1164 
16010	306	S1164 
16011	306	S1164 
16028	306	S10   
16028	306	S11   
16028	306	S12   
16028	306	S182  
16028	306	S183  
16028	306	S203  
16028	306	S6    
16028	306	S7    
16028	306	S8    
16028	306	S9    
16029	306	S1164 
16037	306	S1164 
16037	306	S2202 
16038	306	S1164 
16038	306	S182  
16038	306	S183  
16038	306	S203  
16038	306	S2202 
16042	306	S1065 
16042	306	S2202 
16043	306	S10   
16043	306	S1065 
16043	306	S11   
16043	306	S12   
16043	306	S182  
16043	306	S183  
16043	306	S203  
16043	306	S2202 
16043	306	S6    
16043	306	S7    
16043	306	S8    
16043	306	S9    
16089	306	S563  
16097	306	S22   
16098	306	S10   
16098	306	S11   
16098	306	S12   
16098	306	S182  
16098	306	S183  
16098	306	S203  
16098	306	S22   
16098	306	S6    
16098	306	S7    
16098	306	S8    
16098	306	S9    
16112	306	S39   
16114	306	S39   
16120	306	S39   
16123	306	S39   
16126	306	S39   
16139	306	S39   
16147	306	S2104 
16159	306	D342  
16159	306	S39   
16167	306	S2203 
16174	306	S18   
16338	306	S1164 
16338	306	S182  
16338	306	S183  
16338	306	S203  
16338	306	S2202 
16343	306	S10   
16343	306	S1065 
16343	306	S11   
16343	306	S12   
16343	306	S182  
16343	306	S183  
16343	306	S203  
16343	306	S2202 
16343	306	S6    
16343	306	S7    
16343	306	S8    
16343	306	S9    
16397	306	S22   
16398	306	S10   
16398	306	S11   
16398	306	S12   
16398	306	S182  
16398	306	S183  
16398	306	S203  
16398	306	S22   
16398	306	S6    
16398	306	S7    
16398	306	S8    
16398	306	S9    
17202	306	S1082 
17203	306	S1082 
17204	306	S1082 
17218	306	S1581 
17219	306	S1581 
17332	306	S3    
17335	306	S3    
17340	306	S3    
17341	306	S3    
17342	306	S3    
17345	306	S3    
17346	306	S3    
17347	306	S3    
17348	306	S3    
18001	306	S1162 
18002	306	S1162 
18069	306	S20   
18079	306	S25   
18159	306	S21   
18166	306	S25   
18168	306	S25   
18215	306	S25   
18228	306	S23   
18231	306	S25   
18258	306	S1162 
18259	306	S1162 
18262	306	S1162 
18263	306	S1162 
18288	306	S27   
18350	306	S21   
18363	306	S22   
18364	306	S22   
18365	306	S27   
18376	306	S25   
18403	306	S27   
18927	306	S25   
18930	306	S2203 
18931	306	S2203 
18932	306	S27   
18933	306	S27   
18934	306	S27   
18935	306	S27   
18936	306	S27   
19003	306	S26   
19034	306	S26   
19035	306	S26   
19056	306	S26   
19057	306	S2109 
19058	306	S2109 
19064	306	S1164 
19076	306	S1164 
19078	306	S1069 
19088	306	S10   
19088	306	S11   
19088	306	S12   
19088	306	S6    
19088	306	S7    
19088	306	S8    
19088	306	S9    
19109	306	S1164 
19120	306	S10   
19120	306	S1069 
19120	306	S11   
19120	306	S12   
19120	306	S6    
19120	306	S7    
19120	306	S8    
19120	306	S9    
19129	306	S10   
19129	306	S11   
19129	306	S12   
19129	306	S6    
19129	306	S7    
19129	306	S8    
19129	306	S9    
19155	306	S1164 
19230	306	S1063 
19283	306	S1067 
19300	306	S10   
19300	306	S11   
19300	306	S12   
19300	306	S6    
19300	306	S7    
19300	306	S8    
19300	306	S9    
19335	306	S10   
19335	306	S11   
19335	306	S12   
19335	306	S6    
19335	306	S7    
19335	306	S8    
19335	306	S9    
19337	306	S2109 
19350	306	S1164 
19411	306	S26   
19856	306	S1067 
19868	306	S2109 
19873	306	S1067 
20046	306	S20   
20047	306	S20   
20048	306	S20   
20049	306	S20   
20100	306	S10   
20100	306	S11   
20100	306	S12   
20100	306	S20   
20100	306	S206  
20100	306	S208  
20100	306	S2682 
20100	306	S2683 
20100	306	S2684 
20100	306	S6    
20100	306	S7    
20100	306	S8    
20100	306	S9    
20109	306	S2105 
20110	306	S10   
20110	306	S11   
20110	306	S12   
20110	306	S206  
20110	306	S208  
20110	306	S2105 
20110	306	S2682 
20110	306	S2683 
20110	306	S2684 
20110	306	S6    
20110	306	S7    
20110	306	S8    
20110	306	S9    
20121	306	S10   
20121	306	S11   
20121	306	S12   
20121	306	S20   
20121	306	S206  
20121	306	S208  
20121	306	S2682 
20121	306	S2683 
20121	306	S2684 
20121	306	S6    
20121	306	S7    
20121	306	S8    
20121	306	S9    
20132	306	S1202 
20310	306	S10   
20310	306	S11   
20310	306	S12   
20310	306	S206  
20310	306	S208  
20310	306	S2105 
20310	306	S2682 
20310	306	S2683 
20310	306	S2684 
20310	306	S6    
20310	306	S7    
20310	306	S8    
20310	306	S9    
20321	306	S10   
20321	306	S11   
20321	306	S12   
20321	306	S20   
20321	306	S206  
20321	306	S208  
20321	306	S2682 
20321	306	S2683 
20321	306	S2684 
20321	306	S6    
20321	306	S7    
20321	306	S8    
20321	306	S9    
20400	306	S10   
20400	306	S11   
20400	306	S12   
20400	306	S20   
20400	306	S206  
20400	306	S208  
20400	306	S2682 
20400	306	S2683 
20400	306	S2684 
20400	306	S6    
20400	306	S7    
20400	306	S8    
20400	306	S9    
20409	306	S2105 
20410	306	S10   
20410	306	S11   
20410	306	S12   
20410	306	S206  
20410	306	S208  
20410	306	S2105 
20410	306	S2682 
20410	306	S2683 
20410	306	S2684 
20410	306	S6    
20410	306	S7    
20410	306	S8    
20410	306	S9    
20421	306	S10   
20421	306	S11   
20421	306	S12   
20421	306	S20   
20421	306	S206  
20421	306	S208  
20421	306	S2682 
20421	306	S2683 
20421	306	S2684 
20421	306	S6    
20421	306	S7    
20421	306	S8    
20421	306	S9    
20446	306	S20   
20447	306	S20   
20510	306	S10   
20510	306	S11   
20510	306	S12   
20510	306	S206  
20510	306	S208  
20510	306	S2105 
20510	306	S2682 
20510	306	S2683 
20510	306	S2684 
20510	306	S6    
20510	306	S7    
20510	306	S8    
20510	306	S9    
20521	306	S10   
20521	306	S11   
20521	306	S12   
20521	306	S20   
20521	306	S206  
20521	306	S208  
20521	306	S2682 
20521	306	S2683 
20521	306	S2684 
20521	306	S6    
20521	306	S7    
20521	306	S8    
20521	306	S9    
20623	306	S1742 
20624	306	S1742 
20628	306	S1742 
20629	306	S1742 
20630	306	S1742 
20634	306	S1742 
20635	306	S1742 
20636	306	S1742 
20640	306	S1742 
20641	306	S1742 
20645	306	S1742 
20646	306	S1742 
21138	306	S1064 
21138	306	S1066 
21138	306	S1122 
21141	306	S1064 
21224	306	S19   
21225	306	S19   
21226	306	S22   
21227	306	S22   
21229	306	S1122 
21238	306	S2801 
21239	306	S1066 
21240	306	S1066 
21241	306	S1066 
21242	306	S1066 
21243	306	S1066 
21244	306	S1066 
21245	306	S1066 
21246	306	S1066 
21247	306	S1066 
21248	306	S1066 
21249	306	S1064 
21250	306	S1064 
21251	306	S1064 
21252	306	S1064 
21253	306	S1064 
21254	306	S1064 
21255	306	S1064 
21256	306	S1064 
21257	306	S1064 
21259	306	S1064 
21260	306	S1082 
21261	306	S1082 
21262	306	S1082 
21263	306	S1082 
21264	306	S1082 
21265	306	S1082 
21266	306	S1082 
21267	306	S1082 
21268	306	S1082 
21269	306	S1082 
21270	306	S1082 
21271	306	S2108 
21272	306	S2108 
21273	306	S2108 
21274	306	S2108 
21275	306	S2108 
21276	306	S2108 
21277	306	S2110 
21278	306	S2110 
21279	306	S2110 
21280	306	S2110 
21281	306	S2110 
21282	306	S2110 
21283	306	S2111 
21284	306	S2111 
21285	306	S2111 
21286	306	S2111 
21287	306	S2112 
21288	306	S2112 
21289	306	S2112 
21290	306	S2112 
21291	306	S2112 
21292	306	S2112 
21293	306	S2782 
21294	306	S2782 
21295	306	S2782 
21296	306	S2782 
21297	306	S2782 
21298	306	S2782 
21299	306	S2110 
21299	306	S2111 
21299	306	S2112 
21299	306	S2782 
21300	306	S2110 
21300	306	S2112 
21300	306	S2782 
21301	306	S2110 
21301	306	S2111 
21301	306	S2112 
21301	306	S2782 
21302	306	S2110 
21302	306	S2111 
21302	306	S2112 
21302	306	S2782 
21303	306	S2110 
21303	306	S2112 
21303	306	S2782 
21304	306	S2110 
21304	306	S2111 
21304	306	S2112 
21304	306	S2782 
21308	306	S2801 
21309	306	S2801 
21310	306	S2801 
21311	306	S2801 
21312	306	S2801 
21313	306	S2801 
21314	306	S2801 
21315	306	S2801 
21316	306	S2801 
21317	306	S2801 
21318	306	S2801 
21319	306	S2801 
21320	306	S2801 
21321	306	S2801 
21322	306	S2801 
21323	306	S2801 
21324	306	S2801 
21325	306	S2801 
21326	306	S2801 
21337	306	S2801 
21343	306	S2801 
21346	306	S2801 
21347	306	S2801 
21348	306	S2801 
21349	306	S2801 
22247	306	S20   
22903	306	S21   
22904	306	S18   
22909	306	S22   
22911	306	S18   
22912	306	S19   
22914	306	S19   
22915	306	S19   
22916	306	S19   
23009	306	S2703 
23010	306	S2703 
23011	306	S2703 
23012	306	S2703 
23013	306	S2703 
23014	306	S2703 
23015	306	S2703 
23016	306	S2703 
23017	306	S2703 
23018	306	S2703 
23019	306	S2703 
23020	306	S2703 
23021	306	S2703 
23022	306	S2703 
23023	306	S2703 
23024	306	S2703 
23025	306	S2703 
23027	306	S2703 
23028	306	S2703 
23029	306	S2703 
23030	306	S2703 
23031	306	S2703 
23032	306	S2703 
23033	306	S2703 
23034	306	S2703 
23035	306	S2703 
23036	306	S2703 
23037	306	S2703 
23038	306	S2703 
23039	306	S2703 
23040	306	S2703 
23041	306	S2703 
23042	306	S2703 
23043	306	S2703 
23044	306	S2703 
23045	306	S2703 
23046	306	S2703 
23047	306	S2703 
23048	306	S2703 
23049	306	S2703 
23050	306	S2703 
23051	306	S2703 
23052	306	S2703 
23053	306	S2703 
23054	306	S2703 
23055	306	S2703 
23056	306	S2703 
23057	306	S2703 
23058	306	S2703 
23059	306	S2703 
23060	306	S2703 
23061	306	S2703 
23062	306	S2703 
23063	306	S2703 
23064	306	S2703 
23065	306	S2703 
23557	306	S14   
23558	306	S14   
23559	306	S14   
23560	306	S14   
23561	306	S14   
23562	306	S14   
23563	306	S14   
23564	306	S14   
23565	306	S14   
23566	306	S14   
23567	306	S14   
23568	306	S14   
23569	306	S14   
23570	306	S14   
23571	306	S14   
23572	306	S14   
23573	306	S14   
23574	306	S14   
23575	306	S14   
23576	306	S14   
23577	306	S14   
23578	306	S14   
23579	306	S14   
23580	306	S14   
23581	306	S14   
23582	306	S2    
23583	306	S2    
23584	306	S2    
23585	306	S2    
23586	306	S2    
23587	306	S2    
23588	306	S2    
23589	306	S2    
23590	306	S2    
23591	306	S2    
23592	306	S2    
23593	306	S2    
23594	306	S2    
23595	306	S2    
23596	306	S2    
23597	306	S2    
23598	306	S2    
23599	306	S2    
23600	306	S2    
23601	306	S2    
23602	306	S2    
23603	306	S2    
23604	306	S2    
23605	306	S2    
23606	306	S2    
23607	306	S2    
23608	306	S2    
23609	306	S2    
23610	306	S2    
23611	306	S2    
23612	306	S2    
23613	306	S2    
23614	306	S2    
23615	306	S2    
23616	306	S2    
23617	306	S2    
23618	306	S2    
23619	306	S2    
23620	306	S2    
23621	306	S2    
23622	306	S2    
23623	306	S2    
23624	306	S2    
23625	306	S2    
23626	306	S2    
23627	306	S2    
23628	306	S2    
23629	306	S2    
23630	306	S2    
23631	306	S2    
23632	306	S2    
23633	306	S2    
23634	306	S2    
23635	306	S2    
23636	306	S2    
23637	306	S2    
23638	306	S2    
23640	306	S1581 
23646	306	S2    
23647	306	S2    
23648	306	S2    
23649	306	S2    
23650	306	S2    
23651	306	S2    
23652	306	S2    
23653	306	S2    
23654	306	S2    
23655	306	S2    
23656	306	S2    
23657	306	S2    
23658	306	S2    
23659	306	S2    
23660	306	S2    
35001	306	D4961 
35002	306	D4961 
35003	306	D4961 
35004	306	D4961 
35008	306	D4961 
35024	306	D4961 
35029	306	D4961 
35038	306	D4961 
35046	306	D4961 
35048	306	D4961 
35051	306	D4961 
35067	306	D4961 
35073	306	D4961 
35078	306	D4961 
35089	306	D4961 
35130	306	S2381 
35131	306	S2381 
35132	306	S2381 
35133	306	S2381 
35134	306	S2381 
35135	306	S2381 
35136	306	S2381 
35137	306	S2381 
35138	306	S2381 
35140	306	S2381 
35141	306	S2381 
35142	306	S2381 
35143	306	S2381 
35144	306	S2381 
35145	306	S2381 
35146	306	S2381 
35147	306	S2381 
35148	306	S2381 
42190	306	S243  
43158	306	S2109 
43215	306	S26   
43329	306	S25   
43364	306	S26   
43378	306	S1082 
43514	306	S1067 
48052	306	S1362 
01001	307	S10   
01001	307	S11   
01001	307	S12   
01001	307	S6    
01001	307	S7    
01001	307	S8    
01001	307	S9    
01026	307	S25   
01032	307	S19   
01040	307	S10   
01040	307	S11   
01040	307	S12   
01040	307	S6    
01040	307	S7    
01040	307	S8    
01040	307	S9    
01042	307	S10   
01042	307	S11   
01042	307	S12   
01042	307	S19   
01042	307	S6    
01042	307	S7    
01042	307	S8    
01042	307	S9    
01046	307	S19   
01077	307	S10   
01077	307	S11   
01077	307	S12   
01077	307	S27   
01077	307	S6    
01077	307	S7    
01077	307	S8    
01077	307	S9    
01079	307	S10   
01079	307	S1063 
01079	307	S11   
01079	307	S12   
01079	307	S7    
01079	307	S8    
01079	307	S9    
01082	307	S1063 
01085	307	S10   
01085	307	S1063 
01085	307	S11   
01085	307	S12   
01085	307	S6    
01085	307	S7    
01085	307	S8    
01085	307	S9    
01103	307	S1163 
01123	307	S1063 
01123	307	S561  
01124	307	S1065 
01125	307	S1065 
01202	307	S1163 
02048	307	S2109 
02048	307	S2922 
02053	307	S2109 
02053	307	S2922 
04017	307	S19   
04020	307	S19   
04021	307	S19   
04023	307	S19   
04053	307	S19   
04114	307	S19   
04120	307	S19   
04367	307	S19   
04610	307	S18   
04628	307	S18   
04629	307	S18   
04630	307	S19   
04631	307	S20   
04635	307	S19   
04636	307	S19   
04638	307	S26   
04639	307	S26   
04640	307	S26   
04641	307	S25   
04656	307	S2221 
04657	307	S2221 
04658	307	S2221 
04659	307	S2221 
04660	307	S2221 
04661	307	S2221 
04662	307	S2221 
04663	307	S2221 
04673	307	S2401 
04674	307	S2401 
04675	307	S2401 
04676	307	S2401 
04677	307	S2401 
05023	307	S1581 
05024	307	S1581 
05027	307	S1082 
05028	307	S1082 
05173	307	S1581 
05174	307	S1581 
05175	307	S1581 
05176	307	S1581 
05177	307	S1581 
05178	307	S1581 
05312	307	S26   
05313	307	S26   
05320	307	S26   
05623	307	D4282 
05624	307	S3    
05625	307	D4282 
05626	307	D4281 
05626	307	D4282 
05627	307	D4282 
05628	307	D4281 
05628	307	D4282 
05629	307	D4281 
05630	307	D4282 
05631	307	D4282 
05632	307	S3    
05643	307	D4301 
05644	307	D4301 
05645	307	D4301 
05646	307	D4301 
05647	307	D4301 
05648	307	D4301 
05649	307	D4301 
05650	307	D4301 
05651	307	D4301 
05652	307	D4301 
05653	307	D4301 
05654	307	D4301 
05655	307	D4301 
05656	307	D4301 
05657	307	D4301 
05658	307	D4301 
05661	307	S1082 
06016	307	S18   
06019	307	S18   
06043	307	S18   
06094	307	S18   
06128	307	S18   
06159	307	S18   
06164	307	S23   
06931	307	S22   
06982	307	S18   
06983	307	S18   
06984	307	S2104 
06985	307	S2104 
07002	307	S222  
07005	307	S248  
07006	307	S247  
07007	307	S1164 
07008	307	S238  
07011	307	S227  
07011	307	S281  
07013	307	S242  
07013	307	S281  
07014	307	S281  
07015	307	S248  
07016	307	S248  
07018	307	S226  
07021	307	S237  
07022	307	S21   
07027	307	S281  
07028	307	S225  
07028	307	S230  
07028	307	S281  
07029	307	S281  
07032	307	S281  
07034	307	S249  
07038	307	S281  
07039	307	S244  
07043	307	S230  
07052	307	S227  
07056	307	S248  
07057	307	S281  
07058	307	S237  
07063	307	S1164 
07063	307	S582  
07064	307	S1164 
07068	307	S1041 
07072	307	S281  
07075	307	S1164 
07076	307	S239  
07078	307	S228  
07078	307	S281  
07079	307	S13   
07079	307	S227  
07079	307	S281  
07080	307	S227  
07083	307	S281  
07089	307	S241  
07089	307	S251  
07201	307	S281  
07202	307	S281  
07205	307	S281  
07207	307	S281  
07209	307	S281  
07211	307	S281  
07212	307	S281  
07213	307	S281  
07230	307	S281  
07233	307	S281  
07240	307	S281  
07241	307	S21   
07242	307	S281  
07254	307	S281  
07255	307	S281  
07256	307	S281  
07268	307	S281  
07276	307	S281  
07278	307	S259  
07279	307	S259  
07905	307	S281  
07906	307	S281  
07908	307	S281  
07909	307	S259  
07910	307	S245  
07911	307	S226  
07912	307	S226  
07913	307	S238  
07914	307	S252  
07915	307	S281  
07916	307	S242  
07917	307	S242  
07918	307	S242  
07919	307	S252  
07920	307	S242  
07921	307	S228  
07922	307	S242  
07923	307	S245  
07924	307	S242  
07925	307	S281  
07926	307	S228  
07927	307	S227  
07928	307	S225  
07929	307	S227  
07930	307	S222  
07931	307	S222  
07932	307	S224  
07933	307	S224  
07934	307	S281  
07935	307	S224  
07936	307	S247  
07937	307	S239  
07938	307	S233  
07939	307	S235  
07940	307	S237  
07941	307	S281  
07942	307	S281  
07943	307	S281  
07944	307	S227  
07945	307	S21   
07949	307	S23   
07950	307	S23   
07951	307	S243  
07952	307	S1164 
07953	307	S1164 
07953	307	S582  
07954	307	S582  
07955	307	S1164 
07956	307	S1164 
07957	307	S1164 
07958	307	S1164 
07959	307	S1164 
07960	307	S1164 
08001	307	S1065 
08003	307	S2664 
08005	307	S2664 
08010	307	S702  
08011	307	S702  
08012	307	S1065 
08013	307	S2421 
08014	307	S1065 
08017	307	S603  
08018	307	S702  
08019	307	S603  
08020	307	S1065 
08023	307	S2664 
08025	307	S2662 
08026	307	S603  
08028	307	S2664 
08030	307	S1065 
08031	307	S2664 
08032	307	S2664 
08035	307	S603  
08045	307	S603  
08047	307	S702  
08048	307	S603  
08049	307	S702  
08050	307	S603  
08054	307	S702  
08057	307	S603  
08058	307	S2664 
08059	307	S702  
08060	307	S2664 
08061	307	S1065 
08064	307	S603  
08065	307	S1065 
08065	307	S2662 
08066	307	S702  
08067	307	S2664 
08068	307	S2664 
08069	307	S2664 
08071	307	S2664 
08074	307	S2662 
08077	307	S603  
08078	307	S603  
08082	307	S603  
08083	307	S2502 
08085	307	S702  
08086	307	S603  
08087	307	S603  
08089	307	S603  
08092	307	S702  
08094	307	S702  
08116	307	S2502 
08124	307	S702  
08128	307	S702  
08130	307	S702  
08138	307	S2502 
08139	307	S603  
08146	307	S702  
08147	307	S1065 
08147	307	S2422 
08177	307	S2502 
08189	307	S2664 
08190	307	S603  
08194	307	S603  
08200	307	S702  
08202	307	S603  
08206	307	S2502 
08210	307	S702  
08211	307	S702  
08212	307	S702  
08214	307	S702  
08215	307	S702  
08216	307	S702  
08217	307	S2664 
08218	307	S1065 
08219	307	S702  
08220	307	S702  
08221	307	S702  
08225	307	S702  
08229	307	S702  
08231	307	S702  
08232	307	S702  
08243	307	S603  
08244	307	S603  
08245	307	S603  
08246	307	S603  
08247	307	S603  
08253	307	S2664 
08258	307	S2664 
08259	307	S2662 
08261	307	S603  
08262	307	S603  
08263	307	S603  
08266	307	S603  
08267	307	S603  
08268	307	S603  
08269	307	S603  
08270	307	S603  
08271	307	S603  
08272	307	S603  
08273	307	S603  
08274	307	S603  
08277	307	S603  
08278	307	S603  
08283	307	S2664 
08284	307	S2664 
08286	307	S2664 
08287	307	S2664 
08288	307	S2664 
08289	307	S2664 
08293	307	S702  
08294	307	S702  
08299	307	S702  
08309	307	S2664 
08315	307	S702  
08316	307	S702  
08317	307	S702  
08318	307	S2664 
08319	307	S2664 
08345	307	S603  
08346	307	S2502 
08347	307	S2502 
08348	307	S2502 
08349	307	S2502 
08350	307	S2502 
08351	307	S702  
08352	307	S702  
08353	307	S702  
08354	307	S702  
08355	307	S702  
08357	307	S702  
08358	307	S702  
08359	307	S702  
08360	307	S702  
08361	307	S702  
08362	307	S702  
08363	307	S702  
08364	307	S702  
08366	307	S702  
08367	307	S603  
08368	307	S603  
08370	307	S603  
08371	307	S603  
08372	307	S603  
08374	307	S2664 
08376	307	S2664 
08378	307	S2161 
08379	307	S2664 
08380	307	S2664 
08383	307	S2664 
08384	307	S2664 
08385	307	S2664 
08386	307	S2664 
08387	307	S2664 
08388	307	S2664 
08389	307	S2664 
08390	307	S2664 
08391	307	S682  
08392	307	S2664 
08393	307	S2664 
08394	307	S702  
08395	307	S702  
08396	307	S702  
08397	307	S603  
08398	307	S603  
08399	307	S603  
08400	307	S881  
08401	307	S881  
08402	307	S702  
08403	307	S1209 
08408	307	S2502 
08409	307	S2502 
08410	307	S702  
08411	307	S702  
08412	307	S702  
08413	307	S702  
08414	307	S702  
08415	307	S702  
08416	307	S702  
08417	307	S702  
08418	307	S702  
08419	307	S702  
08420	307	S702  
08421	307	S702  
08422	307	S702  
08435	307	S1065 
08436	307	S702  
08444	307	S702  
08446	307	S702  
08448	307	S702  
08449	307	S702  
08450	307	S702  
08454	307	S2664 
08455	307	S2664 
08456	307	S2664 
08457	307	S2664 
08458	307	S2664 
08459	307	S2664 
08460	307	S2664 
08461	307	S2664 
08462	307	S2664 
08463	307	S2664 
08464	307	S2664 
08465	307	S2664 
08466	307	S2664 
08467	307	S2161 
08468	307	S2664 
08469	307	S2664 
08470	307	S2664 
08471	307	S2664 
08472	307	S2664 
08473	307	S2664 
08474	307	S2664 
08476	307	S2502 
08478	307	S2502 
08481	307	S2502 
08482	307	S2502 
08483	307	S2502 
08484	307	S2502 
08487	307	S2502 
08488	307	S2502 
08489	307	S2502 
08490	307	S2502 
08491	307	S2502 
08492	307	S2502 
08493	307	S2502 
08494	307	S2502 
08495	307	S2502 
08497	307	S2502 
08498	307	S2502 
08500	307	S2502 
08501	307	S2502 
08504	307	S2662 
08505	307	S2662 
08506	307	S2662 
08507	307	S2662 
08508	307	S2662 
08509	307	S2662 
09003	307	D4070 
09003	307	S1183 
09037	307	D4070 
09037	307	S1031 
09037	307	S1621 
09037	307	S381  
09037	307	S481  
09038	307	S1031 
09038	307	S1621 
09038	307	S481  
09039	307	D4070 
09039	307	S381  
09040	307	S10   
09040	307	S1023 
09040	307	S11   
09040	307	S12   
09040	307	S206  
09040	307	S208  
09040	307	S481  
09040	307	S562  
09040	307	S6    
09040	307	S7    
09040	307	S73   
09040	307	S74   
09040	307	S8    
09040	307	S9    
09042	307	S566  
09050	307	S1141 
09050	307	S441  
09060	307	D4070 
09060	307	S381  
09062	307	S381  
09062	307	S404  
09070	307	D4070 
09070	307	S10   
09070	307	S11   
09070	307	S12   
09070	307	S182  
09070	307	S183  
09070	307	S201  
09070	307	S202  
09070	307	S203  
09070	307	S204  
09070	307	S205  
09070	307	S206  
09070	307	S208  
09070	307	S53   
09070	307	S582  
09070	307	S6    
09070	307	S73   
09070	307	S74   
09070	307	S8    
09070	307	S9    
09078	307	S561  
09079	307	S1701 
09087	307	S1032 
09087	307	S564  
09094	307	S363  
09094	307	S582  
09132	307	D4070 
09132	307	S10   
09132	307	S1062 
09132	307	S11   
09132	307	S12   
09132	307	S206  
09132	307	S208  
09132	307	S6    
09132	307	S7    
09132	307	S8    
09132	307	S9    
09139	307	S381  
09148	307	D4070 
09148	307	S1033 
09148	307	S363  
09148	307	S582  
09149	307	S381  
09160	307	S1065 
09181	307	D4070 
09181	307	S10   
09181	307	S1024 
09181	307	S11   
09181	307	S1121 
09181	307	S12   
09181	307	S206  
09181	307	S208  
09181	307	S6    
09181	307	S7    
09181	307	S73   
09181	307	S74   
09181	307	S8    
09181	307	S9    
09183	307	S381  
09184	307	D4070 
09184	307	S1026 
09184	307	S562  
09184	307	S565  
09191	307	D4070 
09191	307	S582  
09195	307	S1202 
09195	307	S1562 
09202	307	S564  
09218	307	S1065 
09236	307	D4070 
09236	307	S10   
09236	307	S11   
09236	307	S12   
09236	307	S582  
09236	307	S6    
09236	307	S7    
09236	307	S73   
09236	307	S74   
09236	307	S8    
09236	307	S9    
09252	307	D4070 
09252	307	S10   
09252	307	S11   
09252	307	S12   
09252	307	S206  
09252	307	S208  
09252	307	S541  
09252	307	S6    
09252	307	S7    
09252	307	S73   
09252	307	S74   
09252	307	S8    
09252	307	S9    
09273	307	S2104 
09273	307	S2985 
09279	307	S10   
09279	307	S11   
09279	307	S12   
09279	307	S206  
09279	307	S208  
09279	307	S582  
09279	307	S6    
09279	307	S7    
09279	307	S73   
09279	307	S74   
09279	307	S8    
09279	307	S9    
09291	307	S10   
09291	307	S11   
09291	307	S12   
09291	307	S206  
09291	307	S208  
09291	307	S564  
09291	307	S566  
09291	307	S6    
09291	307	S7    
09291	307	S73   
09291	307	S74   
09291	307	S8    
09291	307	S9    
09298	307	S10   
09298	307	S11   
09298	307	S12   
09298	307	S206  
09298	307	S208  
09298	307	S5    
09298	307	S564  
09298	307	S566  
09298	307	S6    
09298	307	S7    
09298	307	S73   
09298	307	S74   
09298	307	S8    
09298	307	S9    
09302	307	S381  
09302	307	S566  
09302	307	S963  
09316	307	S10   
09316	307	S11   
09316	307	S1162 
09316	307	S12   
09316	307	S182  
09316	307	S183  
09316	307	S201  
09316	307	S202  
09316	307	S203  
09316	307	S204  
09316	307	S205  
09316	307	S206  
09316	307	S208  
09316	307	S566  
09316	307	S581  
09316	307	S6    
09316	307	S7    
09316	307	S73   
09316	307	S74   
09316	307	S8    
09316	307	S9    
09326	307	S10   
09326	307	S1027 
09326	307	S11   
09326	307	S12   
09326	307	S206  
09326	307	S208  
09326	307	S441  
09326	307	S6    
09326	307	S7    
09326	307	S73   
09326	307	S74   
09326	307	S8    
09326	307	S9    
09328	307	S1206 
09409	307	S2104 
09409	307	S2985 
09421	307	S564  
09421	307	S582  
09422	307	S1202 
09427	307	D4053 
09428	307	D4053 
09431	307	S2203 
09432	307	S2203 
09433	307	S2961 
10007	307	S1082 
10066	307	S1082 
10067	307	S1082 
10068	307	S1082 
10098	307	S1581 
10099	307	S1581 
10102	307	S1581 
10119	307	S1581 
10123	307	S1082 
10124	307	S1082 
10173	307	S1581 
10858	307	S1082 
10860	307	S1082 
10861	307	S1082 
10862	307	S1082 
10863	307	S1581 
10864	307	S1082 
11012	307	S1069 
11019	307	S10   
11019	307	S11   
11019	307	S12   
11019	307	S6    
11019	307	S7    
11019	307	S8    
11019	307	S9    
11090	307	S1121 
11090	307	S1164 
11090	307	S564  
11090	307	S619  
11091	307	S1121 
11091	307	S564  
11096	307	S1121 
11096	307	S482  
11097	307	S482  
11101	307	S10   
11101	307	S11   
11101	307	S12   
11101	307	S6    
11101	307	S7    
11101	307	S8    
11101	307	S9    
11112	307	S1065 
11124	307	S1062 
11124	307	S183  
11124	307	S201  
11124	307	S202  
11124	307	S203  
11124	307	S6    
11124	307	S618  
11125	307	S1062 
11130	307	S25   
11131	307	S25   
11143	307	S1121 
11143	307	S183  
11143	307	S201  
11143	307	S202  
11143	307	S203  
11143	307	S564  
11143	307	S6    
11157	307	S1202 
11210	307	S10   
11210	307	S11   
11210	307	S12   
11210	307	S6    
11210	307	S7    
11210	307	S8    
11210	307	S9    
11243	307	S2941 
11252	307	S10   
11252	307	S11   
11252	307	S12   
11252	307	S183  
11252	307	S201  
11252	307	S202  
11252	307	S203  
11252	307	S481  
11252	307	S562  
11252	307	S6    
11252	307	S624  
11252	307	S7    
11252	307	S8    
11252	307	S9    
11253	307	S541  
11253	307	S565  
11257	307	S541  
11257	307	S565  
11260	307	S10   
11260	307	S11   
11260	307	S12   
11260	307	S2941 
11260	307	S6    
11260	307	S7    
11260	307	S78   
11260	307	S8    
11260	307	S80   
11260	307	S9    
11263	307	S2941 
11267	307	S2941 
11279	307	S10   
11279	307	S11   
11279	307	S12   
11279	307	S6    
11279	307	S7    
11279	307	S8    
11279	307	S9    
11286	307	S1062 
11294	307	S563  
11294	307	S582  
11333	307	S1062 
11333	307	S183  
11333	307	S201  
11333	307	S202  
11333	307	S203  
11333	307	S6    
11333	307	S611  
11339	307	S1062 
11353	307	S563  
11357	307	S563  
11357	307	S566  
11359	307	S2105 
11360	307	S2105 
11394	307	S2105 
11395	307	S2105 
11398	307	S2105 
11399	307	S2105 
11402	307	S2105 
11403	307	S2105 
11411	307	S2105 
11412	307	S2105 
11429	307	S1121 
11429	307	S363  
11429	307	S617  
11464	307	S25   
11468	307	S12   
11468	307	S183  
11468	307	S201  
11468	307	S202  
11468	307	S203  
11507	307	S1062 
11508	307	S10   
11508	307	S1062 
11508	307	S11   
11508	307	S12   
11508	307	S183  
11508	307	S201  
11508	307	S202  
11508	307	S203  
11508	307	S6    
11508	307	S7    
11508	307	S8    
11508	307	S9    
11510	307	S1062 
11529	307	S183  
11529	307	S201  
11529	307	S202  
11529	307	S203  
11529	307	S441  
11529	307	S503  
11529	307	S6    
11529	307	S608  
11540	307	S10   
11540	307	S11   
11540	307	S12   
11540	307	S183  
11540	307	S201  
11540	307	S202  
11540	307	S203  
11540	307	S6    
11540	307	S7    
11540	307	S8    
11540	307	S9    
11546	307	S21   
11546	307	S5    
11546	307	S625  
11546	307	S626  
11546	307	S627  
11546	307	S641  
11547	307	S21   
11547	307	S625  
11547	307	S626  
11547	307	S627  
11549	307	S183  
11549	307	S201  
11549	307	S202  
11549	307	S203  
11549	307	S21   
11549	307	S6    
11565	307	S10   
11565	307	S11   
11565	307	S12   
11565	307	S6    
11565	307	S7    
11565	307	S8    
11565	307	S9    
11674	307	S183  
11674	307	S201  
11674	307	S202  
11674	307	S203  
11674	307	S563  
11674	307	S566  
11746	307	S10   
11746	307	S11   
11746	307	S12   
11746	307	S6    
11746	307	S7    
11746	307	S8    
11746	307	S9    
11752	307	S1065 
11842	307	S2105 
11858	307	S12   
11858	307	S183  
11858	307	S201  
11858	307	S202  
11858	307	S203  
11876	307	S1062 
11921	307	S1062 
11935	307	S183  
11935	307	S202  
11935	307	S203  
11935	307	S22   
11935	307	S5    
11935	307	S6    
11950	307	S2941 
11960	307	S481  
11960	307	S562  
11987	307	S1202 
11987	307	S2941 
11990	307	S1202 
11991	307	S1202 
11992	307	S2941 
12006	307	S1783 
12061	307	S141  
12062	307	S141  
12063	307	S141  
12065	307	S141  
12078	307	S1063 
12078	307	S503  
12086	307	S343  
12087	307	S343  
12120	307	S83   
12121	307	S83   
12122	307	S83   
12131	307	S77   
12132	307	S77   
12142	307	S85   
12143	307	S85   
12144	307	S85   
12147	307	S564  
12151	307	S86   
12152	307	S86   
12154	307	S941  
12155	307	S79   
12201	307	S1164 
12220	307	D4743 
12220	307	S1221 
12220	307	S2109 
12538	307	S661  
12538	307	S961  
12586	307	S343  
12586	307	S363  
12586	307	S5    
12586	307	S502  
12632	307	S77   
12652	307	S101  
12652	307	S86   
13019	307	S2    
13020	307	S2    
13055	307	S2    
13065	307	S2    
13067	307	S2    
13068	307	S2    
13070	307	S2    
13096	307	S2    
13098	307	S2    
13165	307	S2    
13236	307	S221  
13318	307	S1581 
13320	307	S1581 
13321	307	S1581 
13322	307	S1581 
13323	307	S1581 
13324	307	S1581 
13325	307	S1082 
13326	307	S1082 
13327	307	S1082 
13340	307	S1581 
13341	307	S1581 
13343	307	S2    
13355	307	S230  
13355	307	S231  
13369	307	S2    
13370	307	S2    
13373	307	S2    
13375	307	S2    
13377	307	S2    
13378	307	S2    
13391	307	S2    
13394	307	S2    
13398	307	S2    
13399	307	S2    
13401	307	S2    
13402	307	S2    
13404	307	S2    
13405	307	S2    
13407	307	S2    
13408	307	S2    
13410	307	S2    
13411	307	S2    
13413	307	S2    
13414	307	S2    
13415	307	S2    
13416	307	S2    
13417	307	S2    
13418	307	S2    
13419	307	S2    
13420	307	S2    
13421	307	S2    
13422	307	S2    
13423	307	S2    
13424	307	S2    
13425	307	S2    
13426	307	S2    
13439	307	S2    
13440	307	S2    
13441	307	S2    
13442	307	S2    
13443	307	S2    
13444	307	S2    
13445	307	S2    
13446	307	S2    
13447	307	S2    
13448	307	S2    
13449	307	S2    
13450	307	S2    
13451	307	S2    
13452	307	S2    
13453	307	S2    
13454	307	S2    
13455	307	S2    
13456	307	S2    
13485	307	S2    
13486	307	S2    
13487	307	S2    
13488	307	S2    
13490	307	S2    
13491	307	S2    
13492	307	S2    
13493	307	S2    
13494	307	S14   
13495	307	S14   
13496	307	S14   
13497	307	S14   
13498	307	S14   
13565	307	S2703 
13566	307	S2703 
13567	307	S2703 
13568	307	S2703 
13569	307	S2703 
13805	307	S2    
13806	307	S2    
13809	307	S2    
13810	307	S2    
13811	307	S2    
13812	307	S2    
13813	307	S2    
13814	307	S2    
13850	307	S2    
13851	307	S2    
13853	307	S2    
13854	307	S2    
13856	307	S2    
13857	307	S2    
13868	307	S2    
13869	307	S2    
13870	307	S2    
13871	307	S2    
13872	307	S2    
13873	307	S2    
13874	307	S2    
13875	307	S2    
13876	307	S2    
13877	307	S2    
13878	307	S2    
13879	307	S2    
13880	307	S2    
13881	307	S2    
13882	307	S2    
13891	307	S2    
13893	307	S2    
13894	307	S2    
13896	307	S2    
13898	307	S2    
13900	307	S2    
13909	307	S2    
13910	307	S2    
13911	307	S2    
13912	307	S2    
13913	307	S2    
13914	307	S2    
13917	307	S2    
13918	307	S2    
13920	307	S2    
13921	307	S2    
13923	307	S2    
13924	307	S2    
13929	307	S2    
13930	307	S2    
13931	307	S2    
13932	307	S2    
13934	307	S2    
13935	307	S2    
13948	307	S2    
13949	307	S2    
13950	307	S2    
13951	307	S2    
13952	307	S2    
13953	307	S2    
13954	307	S2    
13955	307	S2    
13956	307	S2    
13957	307	S2    
13958	307	S2    
13959	307	S2    
13968	307	S2    
13969	307	S2    
13970	307	S2    
13971	307	S2    
13979	307	S221  
13985	307	S2    
13988	307	S2703 
13989	307	S2703 
13990	307	S2703 
13991	307	S2703 
13992	307	S2703 
13994	307	S2703 
13995	307	S2703 
13996	307	S2703 
13997	307	S2703 
13998	307	S2703 
14003	307	S2103 
14006	307	S2103 
14052	307	S10   
14052	307	S11   
14052	307	S12   
14052	307	S6    
14052	307	S7    
14052	307	S8    
14052	307	S9    
14084	307	S2103 
14096	307	S2103 
14106	307	S2103 
14137	307	S1068 
14144	307	S1068 
14145	307	S1064 
14145	307	S1066 
14145	307	S1068 
14145	307	S1122 
14146	307	S1068 
14147	307	S1068 
14148	307	S1068 
14149	307	S1068 
14154	307	S2702 
14156	307	S2702 
14209	307	S1064 
14209	307	S1066 
14209	307	S1122 
14209	307	S23   
14219	307	S10   
14219	307	S11   
14219	307	S12   
14219	307	S6    
14219	307	S7    
14219	307	S8    
14219	307	S9    
14238	307	S2104 
14242	307	S2104 
14323	307	S1067 
14347	307	S1064 
14347	307	S1122 
14366	307	S2104 
14370	307	S2104 
14382	307	S1164 
14400	307	S1064 
14400	307	S1066 
14400	307	S1068 
14400	307	S1122 
14416	307	S1064 
14416	307	S1066 
14416	307	S1068 
14416	307	S1122 
14427	307	D642  
14429	307	S20   
14429	307	S23   
14429	307	S25   
14432	307	S1068 
14433	307	S1068 
14434	307	S1068 
14437	307	S27   
14438	307	S27   
14439	307	D4541 
14440	307	S2109 
14450	307	S1164 
14460	307	S1164 
14461	307	S1164 
14462	307	S2109 
14475	307	S1068 
14476	307	S1068 
14555	307	D4541 
14555	307	S1068 
14555	307	S27   
14559	307	S1068 
14559	307	S27   
14601	307	S1066 
14602	307	S2103 
15027	307	S10   
15027	307	S11   
15027	307	S1163 
15027	307	S12   
15027	307	S9    
15073	307	S1163 
15078	307	D1073 
15078	307	S2621 
15087	307	S2109 
15152	307	S2104 
15232	307	S1163 
15260	307	S2109 
15261	307	S1163 
15262	307	S1163 
16006	307	S1164 
16010	307	S1164 
16011	307	S1164 
16028	307	S10   
16028	307	S11   
16028	307	S12   
16028	307	S182  
16028	307	S183  
16028	307	S203  
16028	307	S6    
16028	307	S7    
16028	307	S8    
16028	307	S9    
16029	307	S1164 
16037	307	S1164 
16037	307	S2202 
16038	307	S1164 
16038	307	S182  
16038	307	S183  
16038	307	S203  
16038	307	S2202 
16042	307	S1065 
16042	307	S2202 
16043	307	S10   
16043	307	S1065 
16043	307	S11   
16043	307	S12   
16043	307	S182  
16043	307	S183  
16043	307	S203  
16043	307	S2202 
16043	307	S6    
16043	307	S7    
16043	307	S8    
16043	307	S9    
16089	307	S563  
16097	307	S22   
16098	307	S10   
16098	307	S11   
16098	307	S12   
16098	307	S182  
16098	307	S183  
16098	307	S203  
16098	307	S22   
16098	307	S6    
16098	307	S7    
16098	307	S8    
16098	307	S9    
16112	307	S39   
16114	307	S39   
16120	307	S39   
16123	307	S39   
16126	307	S39   
16139	307	S39   
16147	307	S2104 
16159	307	D342  
16159	307	S39   
16167	307	S2203 
16174	307	S18   
17202	307	S1082 
17203	307	S1082 
17204	307	S1082 
17218	307	S1581 
17219	307	S1581 
17332	307	S3    
17335	307	S3    
17340	307	S3    
17341	307	S3    
17342	307	S3    
17345	307	S3    
17346	307	S3    
17347	307	S3    
17348	307	S3    
18001	307	S1162 
18002	307	S1162 
18069	307	S20   
18079	307	S25   
18159	307	S21   
18166	307	S25   
18168	307	S25   
18215	307	S25   
18228	307	S23   
18231	307	S25   
18258	307	S1162 
18259	307	S1162 
18262	307	S1162 
18263	307	S1162 
18288	307	S27   
18350	307	S21   
18363	307	S22   
18364	307	S22   
18365	307	S27   
18376	307	S25   
18403	307	S27   
18927	307	S25   
18930	307	S2203 
18931	307	S2203 
18932	307	S27   
18933	307	S27   
18934	307	S27   
18935	307	S27   
18936	307	S27   
19003	307	S26   
19014	307	S5    
19034	307	S26   
19035	307	S26   
19047	307	S1162 
19056	307	S26   
19057	307	S2109 
19058	307	S2109 
19064	307	S1164 
19076	307	S1164 
19078	307	S1069 
19088	307	S10   
19088	307	S11   
19088	307	S12   
19088	307	S6    
19088	307	S7    
19088	307	S8    
19088	307	S9    
19109	307	S1164 
19120	307	S10   
19120	307	S1069 
19120	307	S11   
19120	307	S12   
19120	307	S6    
19120	307	S7    
19120	307	S8    
19120	307	S9    
19129	307	S10   
19129	307	S11   
19129	307	S12   
19129	307	S6    
19129	307	S7    
19129	307	S8    
19129	307	S9    
19155	307	S1164 
19230	307	S1063 
19283	307	S1067 
19300	307	S10   
19300	307	S11   
19300	307	S12   
19300	307	S5    
19300	307	S6    
19300	307	S7    
19300	307	S8    
19300	307	S9    
19335	307	S10   
19335	307	S11   
19335	307	S12   
19335	307	S6    
19335	307	S7    
19335	307	S8    
19335	307	S9    
19337	307	S2109 
19350	307	S1164 
19411	307	S26   
19856	307	S1067 
19868	307	S2109 
19873	307	S1067 
20046	307	S20   
20047	307	S20   
20048	307	S20   
20049	307	S20   
20099	307	S1163 
20099	307	S20   
20099	307	S5    
20100	307	S10   
20100	307	S11   
20100	307	S12   
20100	307	S206  
20100	307	S208  
20100	307	S2682 
20100	307	S2683 
20100	307	S2684 
20100	307	S6    
20100	307	S7    
20100	307	S8    
20100	307	S9    
20109	307	S2105 
20110	307	S10   
20110	307	S11   
20110	307	S12   
20110	307	S206  
20110	307	S208  
20110	307	S2105 
20110	307	S2682 
20110	307	S2683 
20110	307	S2684 
20110	307	S6    
20110	307	S7    
20110	307	S8    
20110	307	S9    
20120	307	S1163 
20120	307	S20   
20120	307	S5    
20121	307	S10   
20121	307	S11   
20121	307	S12   
20121	307	S206  
20121	307	S208  
20121	307	S2682 
20121	307	S2683 
20121	307	S2684 
20121	307	S6    
20121	307	S7    
20121	307	S8    
20121	307	S9    
20132	307	S1202 
20321	307	S1163 
20400	307	S10   
20400	307	S11   
20400	307	S12   
20400	307	S206  
20400	307	S208  
20400	307	S2682 
20400	307	S2683 
20400	307	S2684 
20400	307	S6    
20400	307	S7    
20400	307	S8    
20400	307	S9    
20409	307	S2105 
20410	307	S10   
20410	307	S11   
20410	307	S12   
20410	307	S206  
20410	307	S208  
20410	307	S2105 
20410	307	S2682 
20410	307	S2683 
20410	307	S2684 
20410	307	S6    
20410	307	S7    
20410	307	S8    
20410	307	S9    
20420	307	S1163 
20420	307	S20   
20420	307	S5    
20421	307	S10   
20421	307	S11   
20421	307	S12   
20421	307	S206  
20421	307	S208  
20421	307	S2682 
20421	307	S2683 
20421	307	S2684 
20421	307	S6    
20421	307	S7    
20421	307	S8    
20421	307	S9    
20446	307	S20   
20447	307	S20   
20499	307	S1163 
20499	307	S20   
20499	307	S5    
20521	307	S1163 
21138	307	S2801 
21141	307	S1064 
21224	307	S19   
21225	307	S19   
21226	307	S22   
21227	307	S22   
21229	307	S1122 
21238	307	S2801 
21239	307	S1066 
21240	307	S1066 
21241	307	S1066 
21242	307	S1066 
21243	307	S1066 
21244	307	S1066 
21245	307	S1066 
21246	307	S1066 
21247	307	S1066 
21248	307	S1066 
21249	307	S1064 
21250	307	S1064 
21251	307	S1064 
21252	307	S1064 
21253	307	S1064 
21254	307	S1064 
21255	307	S1064 
21256	307	S1064 
21257	307	S1064 
21259	307	S1064 
21260	307	S1082 
21261	307	S1082 
21262	307	S1082 
21263	307	S1082 
21264	307	S1082 
21265	307	S1082 
21266	307	S1082 
21267	307	S1082 
21268	307	S1082 
21269	307	S1082 
21270	307	S1082 
21271	307	S2108 
21272	307	S2108 
21273	307	S2108 
21274	307	S2108 
21275	307	S2108 
21276	307	S2108 
21277	307	S2110 
21283	307	S2111 
21284	307	S2111 
21285	307	S2111 
21286	307	S2111 
21287	307	S2112 
21288	307	S2112 
21289	307	S2112 
21290	307	S2112 
21291	307	S2112 
21292	307	S2112 
21293	307	S2782 
21294	307	S2782 
21295	307	S2782 
21296	307	S2782 
21297	307	S2782 
21298	307	S2782 
21299	307	S2110 
21299	307	S2111 
21299	307	S2112 
21299	307	S2782 
21300	307	S2110 
21300	307	S2112 
21300	307	S2782 
21301	307	S2110 
21301	307	S2111 
21301	307	S2112 
21301	307	S2782 
21302	307	S2110 
21302	307	S2111 
21302	307	S2112 
21302	307	S2782 
21303	307	S2110 
21303	307	S2112 
21303	307	S2782 
21304	307	S2110 
21304	307	S2111 
21304	307	S2112 
21304	307	S2782 
21308	307	S2801 
21309	307	S2801 
21310	307	S2801 
21311	307	S2801 
21312	307	S2801 
21313	307	S2801 
21314	307	S2801 
21315	307	S2801 
21316	307	S2801 
21317	307	S2801 
21318	307	S2801 
21319	307	S2801 
21320	307	S2801 
21321	307	S2801 
21322	307	S2801 
21323	307	S2801 
21324	307	S2801 
21325	307	S2801 
21326	307	S2801 
21337	307	S2801 
21342	307	S2801 
21343	307	S2801 
21346	307	S2801 
21347	307	S2801 
21348	307	S2801 
21349	307	S2801 
22247	307	S20   
22903	307	S21   
22904	307	S18   
22909	307	S22   
22911	307	S18   
22912	307	S19   
22914	307	S19   
22915	307	S19   
22916	307	S19   
23009	307	S2703 
23010	307	S2703 
23011	307	S2703 
23012	307	S2703 
23013	307	S2703 
23014	307	S2703 
23015	307	S2703 
23016	307	S2703 
23017	307	S2703 
23018	307	S2703 
23019	307	S2703 
23020	307	S2703 
23021	307	S2703 
23022	307	S2703 
23023	307	S2703 
23024	307	S2703 
23025	307	S2703 
23027	307	S2703 
23028	307	S2703 
23029	307	S2703 
23030	307	S2703 
23031	307	S2703 
23032	307	S2703 
23033	307	S2703 
23034	307	S2703 
23035	307	S2703 
23036	307	S2703 
23037	307	S2703 
23038	307	S2703 
23039	307	S2703 
23040	307	S2703 
23041	307	S2703 
23042	307	S2703 
23043	307	S2703 
23044	307	S2703 
23045	307	S2703 
23046	307	S2703 
23047	307	S2703 
23048	307	S2703 
23049	307	S2703 
23050	307	S2703 
23051	307	S2703 
23052	307	S2703 
23053	307	S2703 
23054	307	S2703 
23055	307	S2703 
23056	307	S2703 
23057	307	S2703 
23058	307	S2703 
23059	307	S2703 
23060	307	S2703 
23061	307	S2703 
23062	307	S2703 
23063	307	S2703 
23064	307	S2703 
23065	307	S2703 
23557	307	S14   
23558	307	S14   
23559	307	S14   
23560	307	S14   
23561	307	S14   
23562	307	S14   
23563	307	S14   
23564	307	S14   
23565	307	S14   
23566	307	S14   
23567	307	S14   
23568	307	S14   
23569	307	S14   
23570	307	S14   
23571	307	S14   
23572	307	S14   
23573	307	S14   
23574	307	S14   
23575	307	S14   
23576	307	S14   
23577	307	S14   
23578	307	S14   
23579	307	S14   
23580	307	S14   
23581	307	S14   
23582	307	S2    
23583	307	S2    
23584	307	S2    
23585	307	S2    
23586	307	S2    
23587	307	S2    
23588	307	S2    
23589	307	S2    
23590	307	S2    
23591	307	S2    
23592	307	S2    
23593	307	S2    
23594	307	S2    
23595	307	S2    
23596	307	S2    
23597	307	S2    
23598	307	S2    
23599	307	S2    
23600	307	S2    
23601	307	S2    
23602	307	S2    
23603	307	S2    
23604	307	S2    
23605	307	S2    
23606	307	S2    
23607	307	S2    
23608	307	S2    
23609	307	S2    
23610	307	S2    
23611	307	S2    
23612	307	S2    
23613	307	S2    
23614	307	S2    
23615	307	S2    
23616	307	S2    
23617	307	S2    
23618	307	S2    
23619	307	S2    
23620	307	S2    
23621	307	S2    
23622	307	S2    
23623	307	S2    
23624	307	S2    
23625	307	S2    
23626	307	S2    
23627	307	S2    
23628	307	S2    
23629	307	S2    
23630	307	S2    
23631	307	S2    
23632	307	S2    
23633	307	S2    
23634	307	S2    
23635	307	S2    
23636	307	S2    
23637	307	S2    
23638	307	S2    
23640	307	S1581 
23646	307	S2    
23647	307	S2    
23648	307	S2    
23649	307	S2    
23650	307	S2    
23651	307	S2    
23652	307	S2    
23653	307	S2    
23654	307	S2    
23655	307	S2    
23656	307	S2    
23657	307	S2    
23658	307	S2    
23659	307	S2    
23660	307	S2    
35001	307	D4961 
35002	307	D4961 
35003	307	D4961 
35004	307	D4961 
35015	307	D4961 
35024	307	D4961 
35029	307	D4961 
35038	307	D4961 
35039	307	D4961 
35041	307	D4961 
35043	307	D4961 
35046	307	D4961 
35048	307	D4961 
35051	307	D4961 
35067	307	D4961 
35071	307	D4961 
35073	307	D4961 
35078	307	D4961 
35089	307	D4961 
35130	307	S2381 
35131	307	S2381 
35132	307	S2381 
35133	307	S2381 
35134	307	S2381 
35135	307	S2381 
35136	307	S2381 
35137	307	S2381 
35138	307	S2381 
35140	307	S2381 
35141	307	S2381 
35142	307	S2381 
35143	307	S2381 
35144	307	S2381 
35145	307	S2381 
35146	307	S2381 
35147	307	S2381 
35148	307	S2381 
42161	307	S281  
42190	307	S243  
42190	307	S281  
42190	307	S282  
42304	307	S5    
43158	307	S2109 
43215	307	S26   
43329	307	S25   
43514	307	S1067 
48052	307	S1362 
01001	309	S10   
01001	309	S11   
01001	309	S12   
01001	309	S6    
01001	309	S7    
01001	309	S8    
01001	309	S9    
01026	309	S25   
01032	309	S19   
01040	309	S10   
01040	309	S11   
01040	309	S12   
01040	309	S6    
01040	309	S7    
01040	309	S8    
01040	309	S9    
01042	309	S10   
01042	309	S11   
01042	309	S12   
01042	309	S19   
01042	309	S6    
01042	309	S7    
01042	309	S8    
01042	309	S9    
01046	309	S19   
01077	309	S10   
01077	309	S11   
01077	309	S12   
01077	309	S27   
01077	309	S6    
01077	309	S7    
01077	309	S8    
01077	309	S9    
01079	309	S10   
01079	309	S1063 
01079	309	S11   
01079	309	S12   
01079	309	S7    
01079	309	S8    
01079	309	S9    
01082	309	S1063 
01085	309	S10   
01085	309	S1063 
01085	309	S11   
01085	309	S12   
01085	309	S6    
01085	309	S7    
01085	309	S8    
01085	309	S9    
01103	309	S1163 
01123	309	S1063 
01123	309	S561  
01124	309	S1065 
01125	309	S1065 
01145	309	S10   
01145	309	S11   
01145	309	S12   
01145	309	S6    
01145	309	S7    
01145	309	S8    
01145	309	S9    
01202	309	S1163 
02048	309	S2109 
02053	309	S2109 
04017	309	S19   
04020	309	S19   
04021	309	S19   
04023	309	S19   
04053	309	S19   
04114	309	S19   
04120	309	S19   
04141	309	S19   
04142	309	S19   
04143	309	S19   
04144	309	S19   
04367	309	S19   
04610	309	S18   
04628	309	S18   
04629	309	S18   
04630	309	S19   
04631	309	S20   
04635	309	S19   
04636	309	S19   
04638	309	S26   
04639	309	S26   
04640	309	S26   
04641	309	S25   
04656	309	S2221 
04657	309	S2221 
04658	309	S2221 
04659	309	S2221 
04660	309	S2221 
04661	309	S2221 
04662	309	S2221 
04663	309	S2221 
05023	309	S1581 
05024	309	S1581 
05027	309	S1082 
05028	309	S1082 
05173	309	S1581 
05174	309	S1581 
05175	309	S1581 
05176	309	S1581 
05177	309	S1581 
05178	309	S1581 
05312	309	S26   
05313	309	S26   
05320	309	S26   
05623	309	D4282 
05624	309	S3    
05625	309	D4282 
05626	309	D4281 
05626	309	D4282 
05627	309	D4282 
05628	309	D4281 
05628	309	D4282 
05629	309	D4281 
05630	309	D4282 
05631	309	D4282 
05632	309	S3    
05661	309	S1082 
06016	309	S18   
06019	309	S18   
06043	309	S18   
06094	309	S18   
06128	309	S18   
06159	309	S18   
06164	309	S23   
06931	309	S22   
06982	309	S18   
06983	309	S18   
06984	309	S2104 
06985	309	S2104 
07002	309	S222  
07005	309	S248  
07007	309	S1164 
07008	309	S238  
07015	309	S248  
07016	309	S248  
07022	309	S21   
07034	309	S249  
07039	309	S244  
07056	309	S248  
07057	309	S238  
07063	309	S1164 
07063	309	S582  
07064	309	S1164 
07068	309	S1041 
07075	309	S1164 
07241	309	S21   
07276	309	S259  
07278	309	S259  
07279	309	S259  
07909	309	S259  
07910	309	S245  
07913	309	S238  
07923	309	S245  
07931	309	S222  
07938	309	S233  
07939	309	S235  
07945	309	S21   
07949	309	S23   
07950	309	S23   
07951	309	S243  
07952	309	S1164 
07953	309	S1164 
07953	309	S582  
07954	309	S582  
07955	309	S1164 
07956	309	S1164 
07957	309	S1164 
07958	309	S1164 
07959	309	S1164 
07960	309	S1164 
08001	309	S1065 
08003	309	S2664 
08005	309	S2664 
08010	309	S702  
08011	309	S702  
08012	309	S1065 
08013	309	S1065 
08014	309	S2664 
08017	309	S603  
08018	309	S702  
08019	309	S603  
08020	309	S1065 
08023	309	S2664 
08025	309	S2662 
08026	309	S603  
08028	309	S2664 
08030	309	S1065 
08031	309	S2664 
08032	309	S2664 
08035	309	S603  
08045	309	S603  
08047	309	S702  
08048	309	S603  
08049	309	S702  
08050	309	S603  
08054	309	S702  
08057	309	S603  
08058	309	S2664 
08059	309	S702  
08060	309	S2664 
08061	309	S1065 
08064	309	S603  
08065	309	S1065 
08065	309	S2662 
08066	309	S702  
08067	309	S2664 
08068	309	S2664 
08069	309	S2664 
08074	309	S2662 
08077	309	S1065 
08078	309	S603  
08082	309	S603  
08083	309	S2502 
08085	309	S702  
08086	309	S603  
08087	309	S603  
08089	309	S603  
08092	309	S702  
08094	309	S702  
08124	309	S702  
08128	309	S702  
08130	309	S702  
08138	309	S2502 
08139	309	S603  
08146	309	S702  
08147	309	S1065 
08147	309	S2422 
08189	309	S2664 
08190	309	S603  
08194	309	S603  
08200	309	S702  
08202	309	S603  
08206	309	S2502 
08210	309	S702  
08211	309	S702  
08212	309	S702  
08214	309	S702  
08215	309	S702  
08216	309	S702  
08217	309	S2664 
08218	309	S1065 
08219	309	S702  
08220	309	S702  
08221	309	S702  
08225	309	S702  
08229	309	S702  
08231	309	S702  
08232	309	S702  
08243	309	S603  
08244	309	S603  
08245	309	S603  
08246	309	S603  
08247	309	S603  
08253	309	S2664 
08258	309	S2664 
08259	309	S2662 
08261	309	S603  
08262	309	S603  
08263	309	S603  
08266	309	S603  
08267	309	S603  
08268	309	S603  
08269	309	S603  
08270	309	S603  
08271	309	S603  
08272	309	S603  
08273	309	S603  
08274	309	S603  
08277	309	S603  
08278	309	S603  
08283	309	S2664 
08284	309	S2664 
08286	309	S2664 
08287	309	S2664 
08288	309	S2664 
08289	309	S2664 
08293	309	S702  
08294	309	S702  
08299	309	S702  
08309	309	S2664 
08315	309	S702  
08316	309	S702  
08317	309	S702  
08318	309	S2664 
08319	309	S2664 
08345	309	S603  
08346	309	S2502 
08347	309	S2502 
08348	309	S2502 
08349	309	S2502 
08350	309	S2502 
08351	309	S702  
08352	309	S702  
08353	309	S702  
08354	309	S702  
08355	309	S702  
08357	309	S702  
08358	309	S702  
08359	309	S702  
08360	309	S702  
08361	309	S702  
08362	309	S702  
08363	309	S702  
08364	309	S702  
08366	309	S702  
08367	309	S603  
08368	309	S603  
08371	309	S603  
08372	309	S603  
08374	309	S2664 
08376	309	S2664 
08378	309	S2161 
08380	309	S2664 
08383	309	S2664 
08384	309	S2664 
08385	309	S2664 
08386	309	S2664 
08387	309	S2664 
08392	309	S2664 
08393	309	S2664 
08394	309	S702  
08395	309	S702  
08396	309	S702  
08397	309	S603  
08398	309	S603  
08399	309	S603  
08400	309	S881  
08401	309	S881  
08402	309	S702  
08403	309	S1209 
08408	309	S2502 
08410	309	S702  
08411	309	S702  
08412	309	S702  
08413	309	S702  
08414	309	S702  
08415	309	S702  
08416	309	S702  
08417	309	S702  
08418	309	S702  
08419	309	S702  
08420	309	S702  
08421	309	S702  
08422	309	S702  
08435	309	S1065 
08436	309	S702  
08444	309	S702  
08446	309	S702  
08448	309	S702  
08449	309	S702  
08450	309	S702  
08454	309	S2664 
08455	309	S2664 
08456	309	S2664 
08457	309	S2664 
08458	309	S2664 
08459	309	S2664 
08460	309	S2664 
08461	309	S2664 
08462	309	S2664 
08465	309	S2664 
08466	309	S2664 
08468	309	S2664 
08470	309	S2664 
08471	309	S2664 
08472	309	S2664 
08473	309	S2664 
08474	309	S2664 
08476	309	S2502 
08478	309	S2502 
08481	309	S2502 
08484	309	S2502 
08487	309	S2502 
08490	309	S2502 
08491	309	S2502 
08493	309	S2502 
08494	309	S2502 
08495	309	S2502 
08498	309	S2502 
08500	309	S2502 
08501	309	S2502 
08504	309	S2662 
08505	309	S2662 
08506	309	S2662 
08507	309	S2662 
08508	309	S2662 
08509	309	S2662 
09003	309	D4070 
09003	309	S1183 
09003	309	S502  
09003	309	S561  
09004	309	S502  
09021	309	S10   
09021	309	S11   
09021	309	S12   
09021	309	S206  
09021	309	S208  
09021	309	S7    
09021	309	S8    
09021	309	S9    
09032	309	S21   
09037	309	D4070 
09037	309	S1031 
09037	309	S381  
09037	309	S481  
09037	309	S502  
09038	309	S1031 
09038	309	S481  
09038	309	S502  
09039	309	D4070 
09039	309	S381  
09040	309	S10   
09040	309	S1023 
09040	309	S11   
09040	309	S12   
09040	309	S206  
09040	309	S208  
09040	309	S481  
09040	309	S562  
09040	309	S6    
09040	309	S7    
09040	309	S73   
09040	309	S74   
09040	309	S8    
09040	309	S9    
09042	309	S461  
09042	309	S566  
09050	309	S1141 
09050	309	S421  
09050	309	S441  
09060	309	D4070 
09060	309	S381  
09062	309	S381  
09062	309	S404  
09070	309	D4070 
09070	309	S10   
09070	309	S11   
09070	309	S12   
09070	309	S182  
09070	309	S183  
09070	309	S201  
09070	309	S202  
09070	309	S203  
09070	309	S204  
09070	309	S205  
09070	309	S206  
09070	309	S208  
09070	309	S53   
09070	309	S582  
09070	309	S6    
09070	309	S73   
09070	309	S74   
09070	309	S8    
09070	309	S9    
09078	309	S561  
09079	309	S1701 
09087	309	S1032 
09087	309	S564  
09087	309	S582  
09094	309	S363  
09094	309	S582  
09112	309	D4070 
09112	309	S482  
09112	309	S563  
09132	309	D4070 
09132	309	S10   
09132	309	S1062 
09132	309	S11   
09132	309	S12   
09132	309	S206  
09132	309	S208  
09132	309	S6    
09132	309	S7    
09132	309	S8    
09132	309	S9    
09139	309	S381  
09148	309	D4070 
09148	309	S1033 
09148	309	S363  
09148	309	S582  
09149	309	S381  
09160	309	S1065 
09181	309	D4070 
09181	309	S10   
09181	309	S1024 
09181	309	S11   
09181	309	S1121 
09181	309	S12   
09181	309	S206  
09181	309	S208  
09181	309	S461  
09181	309	S6    
09181	309	S7    
09181	309	S73   
09181	309	S74   
09181	309	S8    
09181	309	S9    
09183	309	S381  
09184	309	D4070 
09184	309	S1026 
09184	309	S562  
09184	309	S565  
09191	309	D4070 
09191	309	S421  
09191	309	S582  
09195	309	S1202 
09202	309	S482  
09202	309	S564  
09218	309	S1065 
09218	309	S1161 
09236	309	D4070 
09236	309	S10   
09236	309	S11   
09236	309	S12   
09236	309	S461  
09236	309	S582  
09236	309	S6    
09236	309	S7    
09236	309	S73   
09236	309	S74   
09236	309	S8    
09236	309	S9    
09252	309	D4070 
09252	309	S10   
09252	309	S11   
09252	309	S12   
09252	309	S206  
09252	309	S208  
09252	309	S482  
09252	309	S541  
09252	309	S6    
09252	309	S7    
09252	309	S73   
09252	309	S74   
09252	309	S8    
09252	309	S9    
09266	309	D4070 
09266	309	S1167 
09266	309	S441  
09266	309	S561  
09273	309	S2104 
09279	309	S10   
09279	309	S11   
09279	309	S12   
09279	309	S206  
09279	309	S208  
09279	309	S421  
09279	309	S582  
09279	309	S6    
09279	309	S7    
09279	309	S73   
09279	309	S74   
09279	309	S8    
09279	309	S9    
09291	309	S10   
09291	309	S11   
09291	309	S12   
09291	309	S206  
09291	309	S208  
09291	309	S564  
09291	309	S566  
09291	309	S6    
09291	309	S7    
09291	309	S73   
09291	309	S74   
09291	309	S8    
09291	309	S9    
09298	309	S10   
09298	309	S11   
09298	309	S12   
09298	309	S206  
09298	309	S208  
09298	309	S564  
09298	309	S566  
09298	309	S6    
09298	309	S7    
09298	309	S73   
09298	309	S74   
09298	309	S8    
09298	309	S9    
09302	309	S381  
09302	309	S461  
09302	309	S566  
09302	309	S963  
09316	309	S10   
09316	309	S11   
09316	309	S12   
09316	309	S182  
09316	309	S183  
09316	309	S201  
09316	309	S202  
09316	309	S203  
09316	309	S204  
09316	309	S205  
09316	309	S206  
09316	309	S208  
09316	309	S421  
09316	309	S566  
09316	309	S581  
09316	309	S6    
09316	309	S7    
09316	309	S73   
09316	309	S74   
09316	309	S8    
09316	309	S9    
09326	309	S10   
09326	309	S1027 
09326	309	S11   
09326	309	S12   
09326	309	S206  
09326	309	S208  
09326	309	S441  
09326	309	S461  
09326	309	S6    
09326	309	S7    
09326	309	S73   
09326	309	S74   
09326	309	S8    
09326	309	S9    
09328	309	S1206 
09409	309	S2104 
09421	309	S564  
09421	309	S582  
09422	309	S1202 
09427	309	D4053 
09428	309	D4053 
09429	309	D4070 
09429	309	S1167 
09429	309	S441  
09430	309	S441  
09430	309	S561  
09431	309	S2203 
09432	309	S2203 
09433	309	S2105 
09433	309	S2961 
10007	309	S1082 
10066	309	S1082 
10067	309	S1082 
10068	309	S1082 
10098	309	S1581 
10099	309	S1581 
10102	309	S1581 
10119	309	S1581 
10123	309	S1082 
10124	309	S1082 
10173	309	S1581 
10858	309	S1082 
10860	309	S1082 
10861	309	S1082 
10862	309	S1082 
10863	309	S1581 
10864	309	S1082 
11011	309	S1069 
11012	309	S1069 
11019	309	S10   
11019	309	S11   
11019	309	S12   
11019	309	S6    
11019	309	S7    
11019	309	S8    
11019	309	S9    
11090	309	S1121 
11090	309	S564  
11090	309	S619  
11091	309	S1121 
11091	309	S564  
11096	309	S1121 
11096	309	S482  
11097	309	S482  
11101	309	S10   
11101	309	S11   
11101	309	S12   
11101	309	S6    
11101	309	S7    
11101	309	S8    
11101	309	S9    
11112	309	S1065 
11113	309	S1065 
11124	309	S1062 
11124	309	S183  
11124	309	S201  
11124	309	S202  
11124	309	S203  
11124	309	S6    
11124	309	S618  
11125	309	S1062 
11130	309	S25   
11131	309	S25   
11143	309	S1121 
11143	309	S183  
11143	309	S201  
11143	309	S202  
11143	309	S203  
11143	309	S564  
11143	309	S6    
11157	309	S1202 
11205	309	S1062 
11206	309	S1062 
11206	309	S183  
11206	309	S201  
11206	309	S202  
11206	309	S203  
11206	309	S6    
11210	309	S10   
11210	309	S11   
11210	309	S12   
11210	309	S6    
11210	309	S7    
11210	309	S8    
11210	309	S9    
11243	309	S2941 
11250	309	S562  
11250	309	S565  
11251	309	S481  
11251	309	S503  
11251	309	S620  
11252	309	S10   
11252	309	S11   
11252	309	S12   
11252	309	S183  
11252	309	S201  
11252	309	S202  
11252	309	S203  
11252	309	S481  
11252	309	S562  
11252	309	S6    
11252	309	S624  
11252	309	S7    
11252	309	S8    
11252	309	S9    
11253	309	S541  
11253	309	S565  
11257	309	S541  
11257	309	S565  
11260	309	D429  
11260	309	D566  
11260	309	S10   
11260	309	S11   
11260	309	S12   
11260	309	S1821 
11260	309	S2941 
11260	309	S6    
11260	309	S7    
11260	309	S78   
11260	309	S8    
11260	309	S80   
11260	309	S9    
11263	309	S2941 
11267	309	S2941 
11279	309	S10   
11279	309	S11   
11279	309	S12   
11279	309	S6    
11279	309	S7    
11279	309	S8    
11279	309	S9    
11282	309	S10   
11282	309	S1062 
11282	309	S11   
11282	309	S12   
11282	309	S183  
11282	309	S201  
11282	309	S202  
11282	309	S203  
11282	309	S6    
11282	309	S7    
11282	309	S8    
11282	309	S9    
11286	309	S1062 
11294	309	S563  
11294	309	S582  
11333	309	S1062 
11333	309	S183  
11333	309	S201  
11333	309	S202  
11333	309	S203  
11333	309	S6    
11333	309	S611  
11339	309	S1062 
11352	309	S563  
11352	309	S566  
11353	309	S563  
11353	309	S566  
11354	309	S563  
11354	309	S566  
11355	309	S563  
11355	309	S566  
11356	309	S563  
11356	309	S566  
11357	309	S563  
11357	309	S566  
11358	309	S563  
11358	309	S566  
11359	309	S2105 
11360	309	S183  
11360	309	S201  
11360	309	S202  
11360	309	S203  
11360	309	S2105 
11360	309	S6    
11394	309	S2105 
11395	309	S2105 
11398	309	S2105 
11399	309	S2105 
11402	309	S2105 
11403	309	S183  
11403	309	S201  
11403	309	S202  
11403	309	S203  
11403	309	S2105 
11403	309	S6    
11411	309	S2105 
11412	309	S2105 
11429	309	S1121 
11429	309	S363  
11429	309	S617  
11463	309	S25   
11464	309	S25   
11468	309	S12   
11468	309	S183  
11468	309	S201  
11468	309	S202  
11468	309	S203  
11507	309	S1062 
11508	309	S10   
11508	309	S1062 
11508	309	S11   
11508	309	S12   
11508	309	S183  
11508	309	S201  
11508	309	S202  
11508	309	S203  
11508	309	S6    
11508	309	S7    
11508	309	S8    
11508	309	S9    
11510	309	S1062 
11529	309	S183  
11529	309	S201  
11529	309	S202  
11529	309	S203  
11529	309	S441  
11529	309	S503  
11529	309	S6    
11529	309	S608  
11530	309	S441  
11540	309	S10   
11540	309	S11   
11540	309	S12   
11540	309	S183  
11540	309	S201  
11540	309	S202  
11540	309	S203  
11540	309	S6    
11540	309	S7    
11540	309	S8    
11540	309	S9    
11546	309	S21   
11547	309	S21   
11549	309	S183  
11549	309	S201  
11549	309	S202  
11549	309	S203  
11549	309	S21   
11549	309	S6    
11565	309	S10   
11565	309	S11   
11565	309	S12   
11565	309	S6    
11565	309	S7    
11565	309	S8    
11565	309	S9    
11674	309	S183  
11674	309	S201  
11674	309	S202  
11674	309	S203  
11674	309	S563  
11674	309	S566  
11705	309	S1069 
11709	309	S10   
11709	309	S11   
11709	309	S12   
11709	309	S6    
11709	309	S7    
11709	309	S8    
11709	309	S9    
11742	309	S1121 
11742	309	S564  
11746	309	S10   
11746	309	S11   
11746	309	S12   
11746	309	S6    
11746	309	S7    
11746	309	S8    
11746	309	S9    
11752	309	S1065 
11757	309	S1062 
11760	309	S25   
11783	309	S10   
11783	309	S11   
11783	309	S12   
11783	309	S6    
11783	309	S7    
11783	309	S8    
11783	309	S9    
11803	309	S10   
11803	309	S11   
11803	309	S12   
11803	309	S6    
11803	309	S7    
11803	309	S8    
11803	309	S9    
11821	309	S1062 
11828	309	S183  
11828	309	S201  
11828	309	S202  
11828	309	S203  
11828	309	S563  
11828	309	S566  
11841	309	S183  
11841	309	S201  
11841	309	S202  
11841	309	S203  
11841	309	S2105 
11841	309	S6    
11842	309	S2105 
11856	309	S25   
11858	309	S12   
11858	309	S183  
11858	309	S201  
11858	309	S202  
11858	309	S203  
11875	309	S10   
11875	309	S1062 
11875	309	S11   
11875	309	S12   
11875	309	S183  
11875	309	S201  
11875	309	S202  
11875	309	S203  
11875	309	S6    
11875	309	S7    
11875	309	S8    
11875	309	S9    
11876	309	S1062 
11884	309	S441  
11886	309	S10   
11886	309	S11   
11886	309	S12   
11886	309	S183  
11886	309	S201  
11886	309	S202  
11886	309	S203  
11886	309	S6    
11886	309	S7    
11886	309	S8    
11886	309	S9    
11887	309	S21   
11888	309	S21   
11921	309	S1062 
11935	309	S183  
11935	309	S202  
11935	309	S203  
11935	309	S22   
11935	309	S6    
11949	309	S183  
11949	309	S202  
11949	309	S203  
11949	309	S22   
11949	309	S6    
11950	309	S2941 
11960	309	S481  
11960	309	S562  
11987	309	S1202 
11987	309	S2941 
11990	309	S1202 
11991	309	S1202 
11992	309	S2941 
12006	309	S1783 
12061	309	S141  
12062	309	S141  
12063	309	S141  
12065	309	S141  
12078	309	S1063 
12078	309	S503  
12086	309	S343  
12086	309	S363  
12086	309	S502  
12087	309	S343  
12120	309	S83   
12121	309	S83   
12122	309	S83   
12131	309	S77   
12132	309	S77   
12142	309	S85   
12143	309	S85   
12144	309	S85   
12147	309	S502  
12147	309	S564  
12151	309	S86   
12152	309	S86   
12154	309	S941  
12155	309	S79   
12201	309	S1164 
12220	309	D4743 
12220	309	S1221 
12220	309	S2109 
12563	309	S141  
12565	309	S141  
12586	309	S343  
12586	309	S363  
12586	309	S502  
12632	309	S77   
12643	309	S85   
12644	309	S85   
12652	309	S86   
13019	309	S2    
13020	309	S2    
13039	309	S221  
13055	309	S2    
13065	309	S2    
13067	309	S2    
13068	309	S2    
13070	309	S2    
13096	309	S2    
13098	309	S2    
13165	309	S2    
13231	309	S221  
13232	309	S221  
13235	309	S221  
13236	309	S221  
13318	309	S1581 
13320	309	S1581 
13321	309	S1581 
13322	309	S1581 
13323	309	S1581 
13324	309	S1581 
13325	309	S1082 
13326	309	S1082 
13327	309	S1082 
13340	309	S1581 
13341	309	S1581 
13343	309	S2    
13369	309	S2    
13370	309	S2    
13373	309	S2    
13375	309	S2    
13377	309	S2    
13378	309	S2    
13391	309	S2    
13394	309	S2    
13398	309	S2    
13399	309	S2    
13401	309	S2    
13402	309	S2    
13404	309	S2    
13405	309	S2    
13407	309	S2    
13408	309	S2    
13410	309	S2    
13411	309	S2    
13413	309	S2    
13414	309	S2    
13415	309	S2    
13416	309	S2    
13417	309	S2    
13418	309	S2    
13419	309	S2    
13420	309	S2    
13421	309	S2    
13422	309	S2    
13423	309	S2    
13424	309	S2    
13425	309	S2    
13426	309	S2    
13439	309	S2    
13440	309	S2    
13441	309	S2    
13442	309	S2    
13443	309	S2    
13444	309	S2    
13445	309	S2    
13446	309	S2    
13447	309	S2    
13448	309	S2    
13449	309	S2    
13450	309	S2    
13451	309	S2    
13452	309	S2    
13453	309	S2    
13454	309	S2    
13455	309	S2    
13456	309	S2    
13467	309	S221  
13468	309	S221  
13469	309	S221  
13470	309	S221  
13481	309	S221  
13482	309	S221  
13483	309	S221  
13484	309	S221  
13485	309	S2    
13486	309	S2    
13487	309	S2    
13488	309	S2    
13490	309	S2    
13491	309	S2    
13492	309	S2    
13493	309	S2    
13494	309	S14   
13495	309	S14   
13496	309	S14   
13497	309	S14   
13498	309	S14   
13565	309	S2703 
13566	309	S2703 
13567	309	S2703 
13568	309	S2703 
13569	309	S2703 
13805	309	S2    
13806	309	S2    
13809	309	S2    
13810	309	S2    
13811	309	S2    
13812	309	S2    
13813	309	S2    
13814	309	S2    
13850	309	S2    
13851	309	S2    
13853	309	S2    
13854	309	S2    
13856	309	S2    
13857	309	S2    
13868	309	S2    
13869	309	S2    
13870	309	S2    
13871	309	S2    
13872	309	S2    
13873	309	S2    
13874	309	S2    
13875	309	S2    
13876	309	S2    
13877	309	S2    
13878	309	S2    
13879	309	S2    
13880	309	S2    
13881	309	S2    
13882	309	S2    
13891	309	S2    
13893	309	S2    
13894	309	S2    
13896	309	S2    
13898	309	S2    
13900	309	S2    
13909	309	S2    
13910	309	S2    
13911	309	S2    
13912	309	S2    
13913	309	S2    
13914	309	S2    
13917	309	S2    
13918	309	S2    
13920	309	S2    
13921	309	S2    
13923	309	S2    
13924	309	S2    
13929	309	S2    
13930	309	S2    
13931	309	S2    
13932	309	S2    
13934	309	S2    
13935	309	S2    
13936	309	S221  
13937	309	S221  
13938	309	S221  
13939	309	S221  
13940	309	S221  
13941	309	S221  
13942	309	S221  
13945	309	S221  
13948	309	S2    
13949	309	S2    
13950	309	S2    
13951	309	S2    
13952	309	S2    
13953	309	S2    
13954	309	S2    
13955	309	S2    
13956	309	S2    
13957	309	S2    
13958	309	S2    
13959	309	S2    
13961	309	S221  
13962	309	S221  
13963	309	S221  
13964	309	S221  
13965	309	S221  
13966	309	S221  
13967	309	S221  
13968	309	S2    
13969	309	S2    
13970	309	S2    
13971	309	S2    
13977	309	S221  
13978	309	S221  
13979	309	S221  
13985	309	S2    
13988	309	S2703 
13989	309	S2703 
13990	309	S2703 
13991	309	S2703 
13992	309	S2703 
13994	309	S2703 
13995	309	S2703 
13996	309	S2703 
13997	309	S2703 
13998	309	S2703 
14003	309	S2103 
14006	309	S2103 
14052	309	S10   
14052	309	S11   
14052	309	S12   
14052	309	S6    
14052	309	S7    
14052	309	S8    
14052	309	S9    
14084	309	S2103 
14096	309	S2103 
14106	309	S2103 
14137	309	S1068 
14144	309	S1068 
14145	309	S1064 
14145	309	S1066 
14145	309	S1068 
14145	309	S1122 
14146	309	S1068 
14147	309	S1068 
14148	309	S1068 
14149	309	S1068 
14154	309	S2702 
14156	309	S2702 
14166	309	S10   
14166	309	S11   
14166	309	S12   
14166	309	S6    
14166	309	S7    
14166	309	S8    
14166	309	S9    
14209	309	S1064 
14209	309	S1066 
14209	309	S1122 
14209	309	S23   
14219	309	S10   
14219	309	S11   
14219	309	S12   
14219	309	S6    
14219	309	S7    
14219	309	S8    
14219	309	S9    
14238	309	S2104 
14242	309	S2104 
14267	309	S10   
14267	309	S11   
14267	309	S12   
14267	309	S6    
14267	309	S7    
14267	309	S8    
14267	309	S9    
14323	309	S1067 
14347	309	S1064 
14347	309	S1122 
14366	309	S2104 
14370	309	S2104 
14382	309	S1164 
14400	309	S1064 
14400	309	S1066 
14400	309	S1068 
14400	309	S1122 
14416	309	S1064 
14416	309	S1066 
14416	309	S1068 
14416	309	S1122 
14429	309	S20   
14429	309	S23   
14429	309	S25   
14432	309	S1068 
14433	309	S1068 
14434	309	S1068 
14440	309	S2109 
14450	309	S1164 
14460	309	S1164 
14461	309	S1164 
14462	309	S2109 
14475	309	S1068 
14476	309	S1068 
14559	309	S1068 
14601	309	S1066 
14602	309	S2103 
15027	309	S10   
15027	309	S11   
15027	309	S1163 
15027	309	S12   
15027	309	S9    
15073	309	S1163 
15087	309	S2109 
15152	309	S2104 
15232	309	S1163 
15260	309	S2109 
15261	309	S1163 
15262	309	S1163 
16006	309	S1164 
16010	309	S1164 
16011	309	S1164 
16028	309	S10   
16028	309	S11   
16028	309	S12   
16028	309	S182  
16028	309	S183  
16028	309	S203  
16028	309	S6    
16028	309	S7    
16028	309	S8    
16028	309	S9    
16029	309	S1164 
16037	309	S1164 
16037	309	S2202 
16038	309	S1164 
16038	309	S182  
16038	309	S183  
16038	309	S203  
16038	309	S2202 
16042	309	S1065 
16042	309	S2202 
16043	309	S10   
16043	309	S1065 
16043	309	S11   
16043	309	S12   
16043	309	S182  
16043	309	S183  
16043	309	S203  
16043	309	S2202 
16043	309	S6    
16043	309	S7    
16043	309	S8    
16043	309	S9    
16089	309	S563  
16097	309	S22   
16098	309	S10   
16098	309	S11   
16098	309	S12   
16098	309	S182  
16098	309	S183  
16098	309	S203  
16098	309	S22   
16098	309	S6    
16098	309	S7    
16098	309	S8    
16098	309	S9    
16112	309	S39   
16114	309	S39   
16120	309	S39   
16123	309	S39   
16126	309	S39   
16139	309	S39   
16147	309	S2104 
16159	309	D342  
16159	309	S39   
16167	309	S2203 
16174	309	S18   
16338	309	S1164 
16338	309	S182  
16338	309	S183  
16338	309	S203  
16338	309	S2202 
16343	309	S10   
16343	309	S1065 
16343	309	S11   
16343	309	S12   
16343	309	S182  
16343	309	S183  
16343	309	S203  
16343	309	S2202 
16343	309	S6    
16343	309	S7    
16343	309	S8    
16343	309	S9    
16397	309	S22   
16398	309	S10   
16398	309	S11   
16398	309	S12   
16398	309	S182  
16398	309	S183  
16398	309	S203  
16398	309	S22   
16398	309	S6    
16398	309	S7    
16398	309	S8    
16398	309	S9    
17202	309	S1082 
17203	309	S1082 
17204	309	S1082 
17218	309	S1581 
17219	309	S1581 
17332	309	S3    
17335	309	S3    
17340	309	S3    
17341	309	S3    
17342	309	S3    
17345	309	S3    
17346	309	S3    
17347	309	S3    
17348	309	S3    
18001	309	S1162 
18002	309	S1162 
18069	309	S20   
18079	309	S25   
18159	309	S21   
18166	309	S25   
18168	309	S25   
18215	309	S25   
18228	309	S23   
18231	309	S25   
18258	309	S1162 
18259	309	S1162 
18262	309	S1162 
18263	309	S1162 
18288	309	S27   
18350	309	S21   
18363	309	S22   
18364	309	S22   
18365	309	S27   
18376	309	S25   
18403	309	S27   
18927	309	S25   
18930	309	S2203 
18931	309	S2203 
18932	309	S27   
18933	309	S27   
18934	309	S27   
18935	309	S27   
18936	309	S27   
19003	309	S26   
19034	309	S26   
19035	309	S26   
19047	309	S1162 
19056	309	S26   
19057	309	S2109 
19058	309	S2109 
19064	309	S1164 
19076	309	S1164 
19078	309	S1069 
19088	309	S10   
19088	309	S11   
19088	309	S12   
19088	309	S6    
19088	309	S7    
19088	309	S8    
19088	309	S9    
19129	309	S10   
19129	309	S11   
19129	309	S12   
19129	309	S6    
19129	309	S7    
19129	309	S8    
19129	309	S9    
19155	309	S1164 
19230	309	S1063 
19283	309	S1067 
19300	309	S10   
19300	309	S11   
19300	309	S12   
19300	309	S6    
19300	309	S7    
19300	309	S8    
19300	309	S9    
19335	309	S10   
19335	309	S11   
19335	309	S12   
19335	309	S6    
19335	309	S7    
19335	309	S8    
19335	309	S9    
19337	309	S2109 
19350	309	S1164 
19411	309	S26   
19856	309	S1067 
19868	309	S2109 
19873	309	S1067 
20046	309	S20   
20047	309	S20   
20048	309	S20   
20049	309	S20   
20099	309	S20   
20100	309	S10   
20100	309	S11   
20100	309	S12   
20100	309	S20   
20100	309	S206  
20100	309	S208  
20100	309	S2682 
20100	309	S2683 
20100	309	S2684 
20100	309	S6    
20100	309	S7    
20100	309	S8    
20100	309	S9    
20109	309	S2105 
20110	309	S10   
20110	309	S11   
20110	309	S12   
20110	309	S206  
20110	309	S208  
20110	309	S2105 
20110	309	S2682 
20110	309	S2683 
20110	309	S2684 
20110	309	S6    
20110	309	S7    
20110	309	S8    
20110	309	S9    
20120	309	S20   
20121	309	S10   
20121	309	S11   
20121	309	S12   
20121	309	S20   
20121	309	S206  
20121	309	S208  
20121	309	S2682 
20121	309	S2683 
20121	309	S2684 
20121	309	S6    
20121	309	S7    
20121	309	S8    
20121	309	S9    
20132	309	S1202 
20310	309	S10   
20310	309	S11   
20310	309	S12   
20310	309	S206  
20310	309	S208  
20310	309	S2105 
20310	309	S2682 
20310	309	S2683 
20310	309	S2684 
20310	309	S6    
20310	309	S7    
20310	309	S8    
20310	309	S9    
20321	309	S10   
20321	309	S11   
20321	309	S12   
20321	309	S20   
20321	309	S206  
20321	309	S208  
20321	309	S2682 
20321	309	S2683 
20321	309	S2684 
20321	309	S6    
20321	309	S7    
20321	309	S8    
20321	309	S9    
20400	309	S10   
20400	309	S11   
20400	309	S12   
20400	309	S20   
20400	309	S206  
20400	309	S208  
20400	309	S2682 
20400	309	S2683 
20400	309	S2684 
20400	309	S6    
20400	309	S7    
20400	309	S8    
20400	309	S9    
20409	309	S2105 
20410	309	S10   
20410	309	S11   
20410	309	S12   
20410	309	S206  
20410	309	S208  
20410	309	S2105 
20410	309	S2682 
20410	309	S2683 
20410	309	S2684 
20410	309	S6    
20410	309	S7    
20410	309	S8    
20410	309	S9    
20420	309	S20   
20421	309	S10   
20421	309	S11   
20421	309	S12   
20421	309	S20   
20421	309	S206  
20421	309	S208  
20421	309	S2682 
20421	309	S2683 
20421	309	S2684 
20421	309	S6    
20421	309	S7    
20421	309	S8    
20421	309	S9    
20446	309	S20   
20447	309	S20   
20499	309	S20   
20510	309	S10   
20510	309	S11   
20510	309	S12   
20510	309	S206  
20510	309	S208  
20510	309	S2105 
20510	309	S2682 
20510	309	S2683 
20510	309	S2684 
20510	309	S6    
20510	309	S7    
20510	309	S8    
20510	309	S9    
20521	309	S10   
20521	309	S11   
20521	309	S12   
20521	309	S20   
20521	309	S206  
20521	309	S208  
20521	309	S2682 
20521	309	S2683 
20521	309	S2684 
20521	309	S6    
20521	309	S7    
20521	309	S8    
20521	309	S9    
20623	309	S1742 
20624	309	S1742 
20628	309	S1742 
20629	309	S1742 
20630	309	S1742 
20634	309	S1742 
20635	309	S1742 
20636	309	S1742 
20640	309	S1742 
20641	309	S1742 
20645	309	S1742 
20646	309	S1742 
21138	309	S1064 
21138	309	S1066 
21138	309	S1122 
21141	309	S1064 
21224	309	S19   
21225	309	S19   
21226	309	S22   
21227	309	S22   
21229	309	S1122 
21238	309	S2801 
21239	309	S1066 
21240	309	S1066 
21241	309	S1066 
21242	309	S1066 
21243	309	S1066 
21244	309	S1066 
21245	309	S1066 
21246	309	S1066 
21247	309	S1066 
21248	309	S1066 
21249	309	S1064 
21250	309	S1064 
21251	309	S1064 
21252	309	S1064 
21253	309	S1064 
21254	309	S1064 
21255	309	S1064 
21256	309	S1064 
21257	309	S1064 
21259	309	S1064 
21260	309	S1082 
21261	309	S1082 
21262	309	S1082 
21263	309	S1082 
21264	309	S1082 
21265	309	S1082 
21266	309	S1082 
21267	309	S1082 
21268	309	S1082 
21269	309	S1082 
21270	309	S1082 
21271	309	S2108 
21272	309	S2108 
21273	309	S2108 
21274	309	S2108 
21275	309	S2108 
21276	309	S2108 
21277	309	S2110 
21278	309	S2110 
21279	309	S2110 
21280	309	S2110 
21281	309	S2110 
21282	309	S2110 
21283	309	S2111 
21284	309	S2111 
21285	309	S2111 
21286	309	S2111 
21287	309	S2112 
21288	309	S2112 
21289	309	S2112 
21290	309	S2112 
21291	309	S2112 
21292	309	S2112 
21293	309	S2782 
21294	309	S2782 
21295	309	S2782 
21296	309	S2782 
21297	309	S2782 
21298	309	S2782 
21299	309	S2110 
21299	309	S2111 
21299	309	S2112 
21299	309	S2782 
21300	309	S2110 
21300	309	S2112 
21300	309	S2782 
21301	309	S2110 
21301	309	S2111 
21301	309	S2112 
21301	309	S2782 
21302	309	S2110 
21302	309	S2111 
21302	309	S2112 
21302	309	S2782 
21303	309	S2110 
21303	309	S2112 
21303	309	S2782 
21304	309	S2110 
21304	309	S2111 
21304	309	S2112 
21304	309	S2782 
21308	309	S2801 
21309	309	S2801 
21310	309	S2801 
21311	309	S2801 
21312	309	S2801 
21313	309	S2801 
21314	309	S2801 
21315	309	S2801 
21316	309	S2801 
21317	309	S2801 
21318	309	S2801 
21319	309	S2801 
21320	309	S2801 
21321	309	S2801 
21322	309	S2801 
21323	309	S2801 
21324	309	S2801 
21325	309	S2801 
21326	309	S2801 
21337	309	S2801 
21343	309	S2801 
21346	309	S2801 
21347	309	S2801 
21348	309	S2801 
21349	309	S2801 
22247	309	S20   
22903	309	S21   
22904	309	S18   
22909	309	S22   
22911	309	S18   
22912	309	S19   
22914	309	S19   
22915	309	S19   
22916	309	S19   
23009	309	S2703 
23010	309	S2703 
23011	309	S2703 
23012	309	S2703 
23013	309	S2703 
23014	309	S2703 
23015	309	S2703 
23016	309	S2703 
23017	309	S2703 
23018	309	S2703 
23019	309	S2703 
23020	309	S2703 
23021	309	S2703 
23022	309	S2703 
23023	309	S2703 
23024	309	S2703 
23025	309	S2703 
23027	309	S2703 
23028	309	S2703 
23029	309	S2703 
23030	309	S2703 
23031	309	S2703 
23032	309	S2703 
23033	309	S2703 
23034	309	S2703 
23035	309	S2703 
23036	309	S2703 
23037	309	S2703 
23038	309	S2703 
23039	309	S2703 
23040	309	S2703 
23041	309	S2703 
23042	309	S2703 
23043	309	S2703 
23044	309	S2703 
23045	309	S2703 
23046	309	S2703 
23047	309	S2703 
23048	309	S2703 
23049	309	S2703 
23050	309	S2703 
23051	309	S2703 
23052	309	S2703 
23053	309	S2703 
23054	309	S2703 
23055	309	S2703 
23056	309	S2703 
23057	309	S2703 
23058	309	S2703 
23059	309	S2703 
23060	309	S2703 
23061	309	S2703 
23062	309	S2703 
23063	309	S2703 
23064	309	S2703 
23065	309	S2703 
23557	309	S14   
23558	309	S14   
23559	309	S14   
23560	309	S14   
23561	309	S14   
23562	309	S14   
23563	309	S14   
23564	309	S14   
23565	309	S14   
23566	309	S14   
23567	309	S14   
23568	309	S14   
23569	309	S14   
23570	309	S14   
23571	309	S14   
23572	309	S14   
23573	309	S14   
23574	309	S14   
23575	309	S14   
23576	309	S14   
23577	309	S14   
23578	309	S14   
23579	309	S14   
23580	309	S14   
23581	309	S14   
23582	309	S2    
23583	309	S2    
23584	309	S2    
23585	309	S2    
23586	309	S2    
23587	309	S2    
23588	309	S2    
23589	309	S2    
23590	309	S2    
23591	309	S2    
23592	309	S2    
23593	309	S2    
23594	309	S2    
23595	309	S2    
23596	309	S2    
23597	309	S2    
23598	309	S2    
23599	309	S2    
23600	309	S2    
23601	309	S2    
23602	309	S2    
23603	309	S2    
23604	309	S2    
23605	309	S2    
23606	309	S2    
23607	309	S2    
23608	309	S2    
23609	309	S2    
23610	309	S2    
23611	309	S2    
23612	309	S2    
23613	309	S2    
23614	309	S2    
23615	309	S2    
23616	309	S2    
23617	309	S2    
23618	309	S2    
23619	309	S2    
23620	309	S2    
23621	309	S2    
23622	309	S2    
23623	309	S2    
23624	309	S2    
23625	309	S2    
23626	309	S2    
23627	309	S2    
23628	309	S2    
23629	309	S2    
23630	309	S2    
23631	309	S2    
23632	309	S2    
23633	309	S2    
23634	309	S2    
23635	309	S2    
23636	309	S2    
23637	309	S2    
23638	309	S2    
23640	309	S1581 
23646	309	S2    
23647	309	S2    
23648	309	S2    
23649	309	S2    
23650	309	S2    
23651	309	S2    
23652	309	S2    
23653	309	S2    
23654	309	S2    
23655	309	S2    
23656	309	S2    
23657	309	S2    
23658	309	S2    
23659	309	S2    
23660	309	S2    
35001	309	D4961 
35002	309	D4961 
35003	309	D4961 
35015	309	D4961 
35024	309	D4961 
35048	309	D4961 
35051	309	D4961 
35054	309	D4961 
35078	309	D4961 
35089	309	D4961 
35130	309	S2381 
35131	309	S2381 
35132	309	S2381 
35133	309	S2381 
35134	309	S2381 
35135	309	S2381 
35136	309	S2381 
35137	309	S2381 
35138	309	S2381 
35140	309	S2381 
35141	309	S2381 
35142	309	S2381 
35143	309	S2381 
35144	309	S2381 
35145	309	S2381 
35146	309	S2381 
35147	309	S2381 
35148	309	S2381 
42190	309	S243  
43158	309	S2109 
43215	309	S26   
43329	309	S25   
43364	309	S26   
43378	309	S1082 
43514	309	S1067 
01001	312	S10   
01001	312	S11   
01001	312	S12   
01001	312	S6    
01001	312	S7    
01001	312	S8    
01001	312	S9    
01026	312	S25   
01032	312	S19   
01040	312	S10   
01040	312	S11   
01040	312	S12   
01040	312	S6    
01040	312	S7    
01040	312	S8    
01040	312	S9    
01042	312	S10   
01042	312	S11   
01042	312	S12   
01042	312	S19   
01042	312	S6    
01042	312	S7    
01042	312	S8    
01042	312	S9    
01046	312	S19   
01077	312	S10   
01077	312	S11   
01077	312	S12   
01077	312	S27   
01077	312	S6    
01077	312	S7    
01077	312	S8    
01077	312	S9    
01079	312	S1063 
01082	312	S1063 
01085	312	S1063 
01103	312	S1163 
01123	312	S1063 
01123	312	S561  
01124	312	S1065 
01125	312	S1065 
01202	312	S1163 
02048	312	S2109 
02053	312	S2109 
04017	312	S19   
04020	312	S19   
04021	312	S19   
04023	312	S19   
04053	312	S19   
04114	312	S19   
04120	312	S19   
04141	312	S19   
04142	312	S19   
04143	312	S19   
04144	312	S19   
04367	312	S19   
04630	312	S19   
04631	312	S20   
04635	312	S19   
04636	312	S19   
04638	312	S26   
04639	312	S26   
04640	312	S26   
04641	312	S25   
04656	312	S2221 
04657	312	S2221 
04658	312	S2221 
04659	312	S2221 
04660	312	S2221 
04661	312	S2221 
04662	312	S2221 
04663	312	S2221 
05023	312	S1581 
05024	312	S1581 
05027	312	S1082 
05028	312	S1082 
05173	312	S1581 
05174	312	S1581 
05175	312	S1581 
05176	312	S1581 
05177	312	S1581 
05178	312	S1581 
05312	312	S26   
05313	312	S26   
05320	312	S26   
05624	312	S3    
05632	312	S3    
05661	312	S1082 
06016	312	S18   
06019	312	S18   
06043	312	S18   
06094	312	S18   
06128	312	S18   
06159	312	S18   
06164	312	S23   
06931	312	S22   
06982	312	S18   
06983	312	S18   
06984	312	S2104 
06985	312	S2104 
07002	312	S222  
07005	312	S248  
07007	312	S1164 
07008	312	S238  
07015	312	S248  
07016	312	S248  
07022	312	S21   
07039	312	S244  
07056	312	S248  
07057	312	S238  
07063	312	S1164 
07063	312	S582  
07064	312	S1164 
07068	312	S1041 
07075	312	S1164 
07241	312	S21   
07276	312	S259  
07278	312	S259  
07279	312	S259  
07909	312	S259  
07910	312	S245  
07913	312	S238  
07923	312	S245  
07931	312	S222  
07938	312	S233  
07939	312	S235  
07945	312	S21   
07949	312	S23   
07950	312	S23   
07951	312	S243  
07952	312	S1164 
07953	312	S1164 
07953	312	S582  
07954	312	S582  
07955	312	S1164 
07956	312	S1164 
07957	312	S1164 
07958	312	S1164 
07959	312	S1164 
07960	312	S1164 
08001	312	S1065 
08003	312	S2664 
08005	312	S2664 
08010	312	S702  
08011	312	S702  
08012	312	S1065 
08013	312	S1065 
08014	312	S1065 
08018	312	S702  
08020	312	S1065 
08023	312	S2664 
08025	312	S2662 
08028	312	S2664 
08030	312	S1065 
08031	312	S2664 
08032	312	S2664 
08045	312	S603  
08047	312	S702  
08049	312	S702  
08050	312	S603  
08054	312	S702  
08057	312	S603  
08058	312	S2664 
08059	312	S702  
08060	312	S2664 
08061	312	S1065 
08065	312	S1065 
08065	312	S2662 
08066	312	S702  
08067	312	S2664 
08068	312	S2664 
08069	312	S2664 
08074	312	S2662 
08077	312	S1065 
08082	312	S603  
08085	312	S702  
08089	312	S603  
08092	312	S702  
08094	312	S702  
08124	312	S702  
08128	312	S702  
08130	312	S702  
08146	312	S702  
08147	312	S1065 
08147	312	S2422 
08189	312	S2664 
08190	312	S603  
08200	312	S702  
08202	312	S603  
08210	312	S702  
08211	312	S702  
08212	312	S702  
08214	312	S702  
08215	312	S702  
08216	312	S702  
08217	312	S2664 
08218	312	S1065 
08219	312	S702  
08220	312	S702  
08221	312	S702  
08225	312	S702  
08229	312	S702  
08231	312	S702  
08232	312	S702  
08243	312	S603  
08244	312	S603  
08245	312	S603  
08247	312	S603  
08253	312	S2664 
08258	312	S2664 
08259	312	S2662 
08261	312	S603  
08270	312	S603  
08277	312	S603  
08283	312	S2664 
08284	312	S2664 
08286	312	S2664 
08287	312	S2664 
08288	312	S2664 
08289	312	S2664 
08293	312	S702  
08294	312	S702  
08299	312	S702  
08309	312	S2664 
08315	312	S702  
08316	312	S702  
08317	312	S702  
08318	312	S2664 
08319	312	S2664 
08345	312	S603  
08348	312	S2502 
08350	312	S2502 
08351	312	S702  
08352	312	S702  
08353	312	S702  
08354	312	S702  
08355	312	S702  
08357	312	S702  
08358	312	S702  
08359	312	S702  
08360	312	S702  
08361	312	S702  
08362	312	S702  
08363	312	S702  
08364	312	S702  
08366	312	S702  
08371	312	S603  
08372	312	S603  
08374	312	S2664 
08378	312	S2161 
08380	312	S2664 
08383	312	S2664 
08384	312	S2664 
08385	312	S2664 
08386	312	S2664 
08394	312	S702  
08395	312	S702  
08396	312	S702  
08398	312	S603  
08399	312	S603  
08400	312	S881  
08401	312	S881  
08402	312	S702  
08403	312	S1209 
08410	312	S702  
08411	312	S702  
08412	312	S702  
08413	312	S702  
08414	312	S702  
08415	312	S702  
08416	312	S702  
08417	312	S702  
08418	312	S702  
08419	312	S702  
08420	312	S702  
08421	312	S702  
08422	312	S702  
08435	312	S1065 
08436	312	S702  
08444	312	S702  
08446	312	S702  
08448	312	S702  
08449	312	S702  
08450	312	S702  
08454	312	S1209 
08455	312	S2664 
08471	312	S2664 
08473	312	S2664 
08478	312	S2502 
08484	312	S2502 
08487	312	S2502 
08490	312	S2502 
08491	312	S2502 
08493	312	S2502 
08494	312	S2502 
08495	312	S2502 
08498	312	S2502 
08500	312	S2502 
08504	312	S2662 
08505	312	S2662 
08506	312	S2662 
08507	312	S2662 
08508	312	S2662 
08509	312	S2662 
09003	312	D4070 
09003	312	S561  
09021	312	S10   
09021	312	S11   
09021	312	S12   
09021	312	S206  
09021	312	S208  
09021	312	S7    
09021	312	S8    
09021	312	S9    
09032	312	S21   
09037	312	D4070 
09037	312	S1031 
09037	312	S381  
09037	312	S481  
09037	312	S502  
09038	312	S1031 
09038	312	S481  
09038	312	S502  
09039	312	D4070 
09039	312	S381  
09040	312	S10   
09040	312	S1023 
09040	312	S11   
09040	312	S12   
09040	312	S206  
09040	312	S208  
09040	312	S481  
09040	312	S562  
09040	312	S6    
09040	312	S7    
09040	312	S73   
09040	312	S74   
09040	312	S8    
09040	312	S9    
09042	312	S461  
09042	312	S566  
09050	312	S1141 
09050	312	S421  
09050	312	S441  
09060	312	D4070 
09060	312	S381  
09062	312	S381  
09062	312	S404  
09070	312	D4070 
09070	312	S10   
09070	312	S11   
09070	312	S12   
09070	312	S182  
09070	312	S183  
09070	312	S201  
09070	312	S202  
09070	312	S203  
09070	312	S204  
09070	312	S205  
09070	312	S206  
09070	312	S208  
09070	312	S53   
09070	312	S582  
09070	312	S6    
09070	312	S73   
09070	312	S74   
09070	312	S8    
09070	312	S9    
09078	312	S561  
09079	312	S1701 
09087	312	S1032 
09087	312	S564  
09087	312	S582  
09094	312	S363  
09094	312	S582  
09112	312	D4070 
09112	312	S563  
09132	312	D4070 
09132	312	S10   
09132	312	S1062 
09132	312	S11   
09132	312	S12   
09132	312	S206  
09132	312	S208  
09132	312	S6    
09132	312	S7    
09132	312	S8    
09132	312	S9    
09139	312	S381  
09148	312	D4070 
09148	312	S1033 
09148	312	S363  
09148	312	S582  
09149	312	S381  
09160	312	S1065 
09181	312	D4070 
09181	312	S10   
09181	312	S1024 
09181	312	S11   
09181	312	S1121 
09181	312	S12   
09181	312	S206  
09181	312	S208  
09181	312	S461  
09181	312	S6    
09181	312	S7    
09181	312	S73   
09181	312	S74   
09181	312	S8    
09181	312	S9    
09183	312	S381  
09184	312	D4070 
09184	312	S1026 
09184	312	S562  
09184	312	S565  
09191	312	D4070 
09191	312	S421  
09191	312	S582  
09195	312	S1202 
09202	312	S564  
09218	312	S1065 
09218	312	S1161 
09236	312	D4070 
09236	312	S10   
09236	312	S11   
09236	312	S12   
09236	312	S461  
09236	312	S582  
09236	312	S6    
09236	312	S7    
09236	312	S73   
09236	312	S74   
09236	312	S8    
09236	312	S9    
09252	312	D4070 
09252	312	S10   
09252	312	S11   
09252	312	S12   
09252	312	S206  
09252	312	S208  
09252	312	S482  
09252	312	S541  
09252	312	S6    
09252	312	S7    
09252	312	S73   
09252	312	S74   
09252	312	S8    
09252	312	S9    
09266	312	D4070 
09266	312	S1167 
09266	312	S441  
09266	312	S561  
09273	312	S2104 
09279	312	S10   
09279	312	S11   
09279	312	S12   
09279	312	S206  
09279	312	S208  
09279	312	S421  
09279	312	S582  
09279	312	S6    
09279	312	S7    
09279	312	S73   
09279	312	S74   
09279	312	S8    
09279	312	S9    
09291	312	S10   
09291	312	S11   
09291	312	S12   
09291	312	S206  
09291	312	S208  
09291	312	S564  
09291	312	S566  
09291	312	S6    
09291	312	S7    
09291	312	S73   
09291	312	S74   
09291	312	S8    
09291	312	S9    
09298	312	S10   
09298	312	S11   
09298	312	S12   
09298	312	S206  
09298	312	S208  
09298	312	S564  
09298	312	S566  
09298	312	S6    
09298	312	S7    
09298	312	S73   
09298	312	S74   
09298	312	S8    
09298	312	S9    
09302	312	S381  
09302	312	S461  
09302	312	S566  
09302	312	S963  
09316	312	S10   
09316	312	S11   
09316	312	S12   
09316	312	S182  
09316	312	S183  
09316	312	S201  
09316	312	S202  
09316	312	S203  
09316	312	S204  
09316	312	S205  
09316	312	S206  
09316	312	S208  
09316	312	S421  
09316	312	S581  
09316	312	S6    
09316	312	S7    
09316	312	S73   
09316	312	S74   
09316	312	S8    
09316	312	S9    
09326	312	S10   
09326	312	S1027 
09326	312	S11   
09326	312	S12   
09326	312	S206  
09326	312	S208  
09326	312	S461  
09326	312	S6    
09326	312	S7    
09326	312	S73   
09326	312	S74   
09326	312	S8    
09326	312	S9    
09328	312	S1206 
09409	312	S2104 
09421	312	S564  
09421	312	S582  
09422	312	S1202 
09427	312	D4053 
09428	312	D4053 
09429	312	D4070 
09429	312	S1167 
09429	312	S441  
09430	312	S441  
09430	312	S561  
09431	312	S2203 
09432	312	S2203 
09433	312	S2105 
09433	312	S2961 
10007	312	S1082 
10066	312	S1082 
10067	312	S1082 
10068	312	S1082 
10098	312	S1581 
10099	312	S1581 
10102	312	S1581 
10119	312	S1581 
10123	312	S1082 
10124	312	S1082 
10173	312	S1581 
10858	312	S1082 
10860	312	S1082 
10861	312	S1082 
10862	312	S1082 
10863	312	S1581 
10864	312	S1082 
11011	312	S1069 
11012	312	S1069 
11019	312	S10   
11019	312	S11   
11019	312	S12   
11019	312	S6    
11019	312	S7    
11019	312	S8    
11019	312	S9    
11090	312	S1121 
11090	312	S564  
11090	312	S619  
11091	312	S1121 
11091	312	S564  
11096	312	S1121 
11096	312	S482  
11097	312	S482  
11101	312	S10   
11101	312	S11   
11101	312	S12   
11101	312	S6    
11101	312	S7    
11101	312	S8    
11101	312	S9    
11112	312	S1065 
11113	312	S1065 
11124	312	S1062 
11124	312	S183  
11124	312	S201  
11124	312	S202  
11124	312	S203  
11124	312	S6    
11124	312	S618  
11125	312	S1062 
11130	312	S25   
11131	312	S25   
11143	312	S1121 
11143	312	S183  
11143	312	S201  
11143	312	S202  
11143	312	S203  
11143	312	S564  
11143	312	S6    
11157	312	S1202 
11205	312	S1062 
11206	312	S1062 
11206	312	S183  
11206	312	S201  
11206	312	S202  
11206	312	S203  
11206	312	S6    
11210	312	S10   
11210	312	S11   
11210	312	S12   
11210	312	S6    
11210	312	S7    
11210	312	S8    
11210	312	S9    
11243	312	S2941 
11250	312	S562  
11250	312	S565  
11251	312	S481  
11251	312	S503  
11251	312	S620  
11252	312	S10   
11252	312	S11   
11252	312	S12   
11252	312	S183  
11252	312	S201  
11252	312	S202  
11252	312	S203  
11252	312	S481  
11252	312	S562  
11252	312	S6    
11252	312	S624  
11252	312	S7    
11252	312	S8    
11252	312	S9    
11253	312	S541  
11253	312	S565  
11257	312	S541  
11257	312	S565  
11260	312	D429  
11260	312	D566  
11260	312	S10   
11260	312	S11   
11260	312	S12   
11260	312	S1821 
11260	312	S2941 
11260	312	S6    
11260	312	S7    
11260	312	S78   
11260	312	S8    
11260	312	S80   
11260	312	S9    
11263	312	S2941 
11267	312	S2941 
11279	312	S10   
11279	312	S11   
11279	312	S12   
11279	312	S6    
11279	312	S7    
11279	312	S8    
11279	312	S9    
11282	312	S10   
11282	312	S1062 
11282	312	S11   
11282	312	S12   
11282	312	S183  
11282	312	S201  
11282	312	S202  
11282	312	S203  
11282	312	S6    
11282	312	S7    
11282	312	S8    
11282	312	S9    
11286	312	S1062 
11294	312	S563  
11294	312	S582  
11333	312	S1062 
11333	312	S183  
11333	312	S201  
11333	312	S202  
11333	312	S203  
11333	312	S6    
11333	312	S611  
11339	312	S1062 
11352	312	S563  
11352	312	S566  
11353	312	S563  
11353	312	S566  
11354	312	S563  
11354	312	S566  
11355	312	S563  
11355	312	S566  
11356	312	S563  
11356	312	S566  
11357	312	S563  
11357	312	S566  
11358	312	S563  
11358	312	S566  
11359	312	S2105 
11360	312	S183  
11360	312	S201  
11360	312	S202  
11360	312	S203  
11360	312	S2105 
11360	312	S6    
11394	312	S2105 
11395	312	S2105 
11398	312	S2105 
11399	312	S2105 
11402	312	S2105 
11403	312	S183  
11403	312	S201  
11403	312	S202  
11403	312	S203  
11403	312	S2105 
11403	312	S6    
11411	312	S2105 
11412	312	S2105 
11429	312	S1121 
11429	312	S363  
11429	312	S617  
11463	312	S25   
11464	312	S25   
11468	312	S12   
11468	312	S183  
11468	312	S201  
11468	312	S202  
11468	312	S203  
11507	312	S1062 
11508	312	S10   
11508	312	S1062 
11508	312	S11   
11508	312	S12   
11508	312	S183  
11508	312	S201  
11508	312	S202  
11508	312	S203  
11508	312	S6    
11508	312	S7    
11508	312	S8    
11508	312	S9    
11510	312	S1062 
11529	312	S183  
11529	312	S201  
11529	312	S202  
11529	312	S203  
11529	312	S441  
11529	312	S503  
11529	312	S6    
11529	312	S608  
11530	312	S441  
11540	312	S10   
11540	312	S11   
11540	312	S12   
11540	312	S183  
11540	312	S201  
11540	312	S202  
11540	312	S203  
11540	312	S6    
11540	312	S7    
11540	312	S8    
11540	312	S9    
11546	312	S21   
11547	312	S21   
11549	312	S183  
11549	312	S201  
11549	312	S202  
11549	312	S203  
11549	312	S21   
11549	312	S6    
11565	312	S10   
11565	312	S11   
11565	312	S12   
11565	312	S6    
11565	312	S7    
11565	312	S8    
11565	312	S9    
11674	312	S183  
11674	312	S201  
11674	312	S202  
11674	312	S203  
11674	312	S563  
11674	312	S566  
11705	312	S1069 
11709	312	S10   
11709	312	S11   
11709	312	S12   
11709	312	S6    
11709	312	S7    
11709	312	S8    
11709	312	S9    
11742	312	S1121 
11742	312	S564  
11746	312	S10   
11746	312	S11   
11746	312	S12   
11746	312	S6    
11746	312	S7    
11746	312	S8    
11746	312	S9    
11752	312	S1065 
11757	312	S1062 
11760	312	S25   
11783	312	S10   
11783	312	S11   
11783	312	S12   
11783	312	S6    
11783	312	S7    
11783	312	S8    
11783	312	S9    
11803	312	S10   
11803	312	S11   
11803	312	S12   
11803	312	S6    
11803	312	S7    
11803	312	S8    
11803	312	S9    
11821	312	S1062 
11828	312	S183  
11828	312	S201  
11828	312	S202  
11828	312	S203  
11828	312	S563  
11828	312	S566  
11841	312	S183  
11841	312	S201  
11841	312	S202  
11841	312	S203  
11841	312	S2105 
11841	312	S6    
11842	312	S2105 
11856	312	S25   
11858	312	S12   
11858	312	S183  
11858	312	S201  
11858	312	S202  
11858	312	S203  
11875	312	S10   
11875	312	S1062 
11875	312	S11   
11875	312	S12   
11875	312	S183  
11875	312	S201  
11875	312	S202  
11875	312	S203  
11875	312	S6    
11875	312	S7    
11875	312	S8    
11875	312	S9    
11876	312	S1062 
11884	312	S441  
11886	312	S10   
11886	312	S11   
11886	312	S12   
11886	312	S183  
11886	312	S201  
11886	312	S202  
11886	312	S203  
11886	312	S6    
11886	312	S7    
11886	312	S8    
11886	312	S9    
11887	312	S21   
11888	312	S21   
11921	312	S1062 
11935	312	S183  
11935	312	S202  
11935	312	S203  
11935	312	S22   
11935	312	S6    
11949	312	S183  
11949	312	S202  
11949	312	S203  
11949	312	S22   
11949	312	S6    
11950	312	S2941 
11960	312	S481  
11960	312	S562  
11987	312	S1202 
11987	312	S2941 
11990	312	S1202 
11991	312	S1202 
11992	312	S2941 
12006	312	S1783 
12061	312	S141  
12062	312	S141  
12063	312	S141  
12065	312	S141  
12078	312	S1063 
12078	312	S503  
12086	312	S343  
12086	312	S363  
12086	312	S502  
12087	312	S343  
12120	312	S83   
12121	312	S83   
12122	312	S83   
12131	312	S77   
12132	312	S77   
12142	312	S85   
12143	312	S85   
12144	312	S85   
12147	312	S502  
12147	312	S564  
12151	312	S86   
12152	312	S86   
12154	312	S941  
12155	312	S79   
12201	312	S1164 
12220	312	D4743 
12220	312	S1221 
12220	312	S2109 
12563	312	S141  
12565	312	S141  
12586	312	S343  
12586	312	S363  
12586	312	S502  
12632	312	S77   
12643	312	S85   
12644	312	S85   
12652	312	S86   
13019	312	S2    
13020	312	S2    
13055	312	S2    
13065	312	S2    
13067	312	S2    
13068	312	S2    
13070	312	S2    
13096	312	S2    
13098	312	S2    
13165	312	S2    
13318	312	S1581 
13320	312	S1581 
13321	312	S1581 
13322	312	S1581 
13323	312	S1581 
13324	312	S1581 
13325	312	S1082 
13326	312	S1082 
13327	312	S1082 
13340	312	S1581 
13341	312	S1581 
13343	312	S2    
13369	312	S2    
13370	312	S2    
13373	312	S2    
13375	312	S2    
13377	312	S2    
13378	312	S2    
13391	312	S2    
13394	312	S2    
13398	312	S2    
13399	312	S2    
13401	312	S2    
13402	312	S2    
13404	312	S2    
13405	312	S2    
13407	312	S2    
13408	312	S2    
13410	312	S2    
13411	312	S2    
13413	312	S2    
13414	312	S2    
13415	312	S2    
13416	312	S2    
13417	312	S2    
13418	312	S2    
13419	312	S2    
13420	312	S2    
13421	312	S2    
13422	312	S2    
13423	312	S2    
13424	312	S2    
13425	312	S2    
13426	312	S2    
13439	312	S2    
13440	312	S2    
13441	312	S2    
13442	312	S2    
13443	312	S2    
13444	312	S2    
13445	312	S2    
13446	312	S2    
13447	312	S2    
13448	312	S2    
13449	312	S2    
13450	312	S2    
13451	312	S2    
13452	312	S2    
13453	312	S2    
13454	312	S2    
13455	312	S2    
13456	312	S2    
13485	312	S2    
13486	312	S2    
13487	312	S2    
13488	312	S2    
13490	312	S2    
13491	312	S2    
13492	312	S2    
13493	312	S2    
13494	312	S14   
13495	312	S14   
13496	312	S14   
13497	312	S14   
13498	312	S14   
13565	312	S2703 
13566	312	S2703 
13567	312	S2703 
13568	312	S2703 
13569	312	S2703 
13805	312	S2    
13806	312	S2    
13809	312	S2    
13810	312	S2    
13811	312	S2    
13812	312	S2    
13813	312	S2    
13814	312	S2    
13850	312	S2    
13851	312	S2    
13853	312	S2    
13854	312	S2    
13856	312	S2    
13857	312	S2    
13868	312	S2    
13869	312	S2    
13870	312	S2    
13871	312	S2    
13872	312	S2    
13873	312	S2    
13874	312	S2    
13875	312	S2    
13876	312	S2    
13877	312	S2    
13878	312	S2    
13879	312	S2    
13880	312	S2    
13881	312	S2    
13882	312	S2    
13891	312	S2    
13893	312	S2    
13894	312	S2    
13896	312	S2    
13898	312	S2    
13900	312	S2    
13909	312	S2    
13910	312	S2    
13911	312	S2    
13912	312	S2    
13913	312	S2    
13914	312	S2    
13917	312	S2    
13918	312	S2    
13920	312	S2    
13921	312	S2    
13923	312	S2    
13924	312	S2    
13929	312	S2    
13930	312	S2    
13931	312	S2    
13932	312	S2    
13934	312	S2    
13935	312	S2    
13937	312	S221  
13938	312	S221  
13940	312	S221  
13941	312	S221  
13948	312	S2    
13949	312	S2    
13950	312	S2    
13951	312	S2    
13952	312	S2    
13953	312	S2    
13954	312	S2    
13955	312	S2    
13956	312	S2    
13957	312	S2    
13958	312	S2    
13959	312	S2    
13968	312	S2    
13969	312	S2    
13970	312	S2    
13971	312	S2    
13985	312	S2    
13988	312	S2703 
13989	312	S2703 
13990	312	S2703 
13991	312	S2703 
13992	312	S2703 
13994	312	S2703 
13995	312	S2703 
13996	312	S2703 
13997	312	S2703 
13998	312	S2703 
14003	312	S2103 
14006	312	S2103 
14052	312	S10   
14052	312	S11   
14052	312	S12   
14052	312	S6    
14052	312	S7    
14052	312	S8    
14052	312	S9    
14084	312	S2103 
14096	312	S2103 
14106	312	S2103 
14137	312	S1068 
14144	312	S1068 
14145	312	S1064 
14145	312	S1066 
14145	312	S1068 
14145	312	S1122 
14146	312	S1068 
14147	312	S1068 
14148	312	S1068 
14149	312	S1068 
14154	312	S2702 
14156	312	S2702 
14166	312	S10   
14166	312	S11   
14166	312	S12   
14166	312	S6    
14166	312	S7    
14166	312	S8    
14166	312	S9    
14209	312	S1064 
14209	312	S1066 
14209	312	S1122 
14238	312	S2104 
14242	312	S2104 
14267	312	D614  
14323	312	S1067 
14347	312	S1064 
14347	312	S1122 
14366	312	S2104 
14370	312	S2104 
14382	312	S1164 
14400	312	S1064 
14400	312	S1066 
14400	312	S1068 
14400	312	S1122 
14416	312	S1064 
14416	312	S1066 
14416	312	S1068 
14416	312	S1122 
14429	312	S20   
14429	312	S23   
14429	312	S25   
14432	312	S1068 
14433	312	S1068 
14434	312	S1068 
14440	312	S2109 
14450	312	S1164 
14460	312	S1164 
14461	312	S1164 
14462	312	S2109 
14475	312	S1068 
14476	312	S1068 
14559	312	S1068 
14601	312	S1066 
14602	312	S2103 
15027	312	S10   
15027	312	S11   
15027	312	S1163 
15027	312	S12   
15027	312	S9    
15073	312	S1163 
15087	312	S2109 
15152	312	S2104 
15232	312	S1163 
15260	312	S2109 
15261	312	S1163 
15262	312	S1163 
16006	312	S1164 
16010	312	S1164 
16011	312	S1164 
16028	312	S10   
16028	312	S11   
16028	312	S12   
16028	312	S182  
16028	312	S183  
16028	312	S203  
16028	312	S6    
16028	312	S7    
16028	312	S8    
16028	312	S9    
16029	312	S1164 
16037	312	S1164 
16037	312	S2202 
16038	312	S1164 
16038	312	S182  
16038	312	S183  
16038	312	S203  
16038	312	S2202 
16042	312	S1065 
16042	312	S2202 
16043	312	S10   
16043	312	S1065 
16043	312	S11   
16043	312	S12   
16043	312	S182  
16043	312	S183  
16043	312	S203  
16043	312	S2202 
16043	312	S6    
16043	312	S7    
16043	312	S8    
16043	312	S9    
16089	312	S563  
16097	312	S22   
16098	312	S10   
16098	312	S11   
16098	312	S12   
16098	312	S182  
16098	312	S183  
16098	312	S203  
16098	312	S22   
16098	312	S6    
16098	312	S7    
16098	312	S8    
16098	312	S9    
16112	312	S39   
16114	312	S39   
16120	312	S39   
16123	312	S39   
16126	312	S39   
16139	312	S39   
16147	312	S2104 
16159	312	D342  
16159	312	S39   
16167	312	S2203 
16174	312	S18   
16338	312	S1164 
16338	312	S182  
16338	312	S183  
16338	312	S203  
16338	312	S2202 
16343	312	S10   
16343	312	S1065 
16343	312	S11   
16343	312	S12   
16343	312	S182  
16343	312	S183  
16343	312	S203  
16343	312	S2202 
16343	312	S6    
16343	312	S7    
16343	312	S8    
16343	312	S9    
16397	312	S22   
16398	312	S10   
16398	312	S11   
16398	312	S12   
16398	312	S182  
16398	312	S183  
16398	312	S203  
16398	312	S22   
16398	312	S6    
16398	312	S7    
16398	312	S8    
16398	312	S9    
17202	312	S1082 
17203	312	S1082 
17204	312	S1082 
17218	312	S1581 
17219	312	S1581 
17332	312	S3    
17335	312	S3    
17340	312	S3    
17341	312	S3    
17342	312	S3    
17345	312	S3    
17346	312	S3    
17347	312	S3    
17348	312	S3    
18001	312	S1162 
18002	312	S1162 
18069	312	S20   
18079	312	S25   
18159	312	S21   
18166	312	S25   
18168	312	S25   
18215	312	S25   
18228	312	S23   
18231	312	S25   
18258	312	S1162 
18259	312	S1162 
18262	312	S1162 
18263	312	S1162 
18288	312	S27   
18350	312	S21   
18363	312	S22   
18364	312	S22   
18365	312	S27   
18376	312	S25   
18403	312	S27   
18927	312	S25   
18930	312	S2203 
18931	312	S2203 
18932	312	S27   
18933	312	S27   
18934	312	S27   
18935	312	S27   
18936	312	S27   
19003	312	S26   
19034	312	S26   
19035	312	S26   
19056	312	S26   
19057	312	S2109 
19058	312	S2109 
19064	312	S1164 
19076	312	S1164 
19078	312	S1069 
19109	312	S1164 
19120	312	S10   
19120	312	S1069 
19120	312	S11   
19120	312	S12   
19120	312	S6    
19120	312	S7    
19120	312	S8    
19120	312	S9    
19155	312	S1164 
19230	312	S1063 
19283	312	S1067 
19300	312	S10   
19300	312	S11   
19300	312	S12   
19300	312	S6    
19300	312	S7    
19300	312	S8    
19300	312	S9    
19335	312	S10   
19335	312	S11   
19335	312	S12   
19335	312	S6    
19335	312	S7    
19335	312	S8    
19335	312	S9    
19337	312	S2109 
19350	312	S1164 
19411	312	S26   
19856	312	S1067 
19868	312	S2109 
19873	312	S1067 
20046	312	S20   
20047	312	S20   
20048	312	S20   
20049	312	S20   
20099	312	S1163 
20099	312	S20   
20100	312	S10   
20100	312	S11   
20100	312	S1163 
20100	312	S12   
20100	312	S20   
20100	312	S206  
20100	312	S208  
20100	312	S2682 
20100	312	S2683 
20100	312	S2684 
20100	312	S6    
20100	312	S7    
20100	312	S8    
20100	312	S9    
20109	312	S2105 
20110	312	S10   
20110	312	S11   
20110	312	S12   
20110	312	S206  
20110	312	S208  
20110	312	S2105 
20110	312	S2682 
20110	312	S2683 
20110	312	S2684 
20110	312	S6    
20110	312	S7    
20110	312	S8    
20110	312	S9    
20120	312	S1163 
20120	312	S20   
20121	312	S10   
20121	312	S11   
20121	312	S1163 
20121	312	S12   
20121	312	S20   
20121	312	S206  
20121	312	S208  
20121	312	S2682 
20121	312	S2683 
20121	312	S2684 
20121	312	S6    
20121	312	S7    
20121	312	S8    
20121	312	S9    
20132	312	S1202 
20310	312	S10   
20310	312	S11   
20310	312	S12   
20310	312	S206  
20310	312	S208  
20310	312	S2105 
20310	312	S2682 
20310	312	S2683 
20310	312	S2684 
20310	312	S6    
20310	312	S7    
20310	312	S8    
20310	312	S9    
20321	312	S10   
20321	312	S11   
20321	312	S1163 
20321	312	S12   
20321	312	S20   
20321	312	S206  
20321	312	S208  
20321	312	S2682 
20321	312	S2683 
20321	312	S2684 
20321	312	S6    
20321	312	S7    
20321	312	S8    
20321	312	S9    
20400	312	S10   
20400	312	S11   
20400	312	S1163 
20400	312	S12   
20400	312	S20   
20400	312	S206  
20400	312	S208  
20400	312	S2682 
20400	312	S2683 
20400	312	S2684 
20400	312	S6    
20400	312	S7    
20400	312	S8    
20400	312	S9    
20409	312	S2105 
20410	312	S10   
20410	312	S11   
20410	312	S12   
20410	312	S206  
20410	312	S208  
20410	312	S2105 
20410	312	S2682 
20410	312	S2683 
20410	312	S2684 
20410	312	S6    
20410	312	S7    
20410	312	S8    
20410	312	S9    
20420	312	S1163 
20420	312	S20   
20421	312	S10   
20421	312	S11   
20421	312	S1163 
20421	312	S12   
20421	312	S20   
20421	312	S206  
20421	312	S208  
20421	312	S2682 
20421	312	S2683 
20421	312	S2684 
20421	312	S6    
20421	312	S7    
20421	312	S8    
20421	312	S9    
20446	312	S20   
20447	312	S20   
20499	312	S1163 
20499	312	S20   
20510	312	S10   
20510	312	S11   
20510	312	S12   
20510	312	S206  
20510	312	S208  
20510	312	S2105 
20510	312	S2682 
20510	312	S2683 
20510	312	S2684 
20510	312	S6    
20510	312	S7    
20510	312	S8    
20510	312	S9    
20521	312	S10   
20521	312	S11   
20521	312	S1163 
20521	312	S12   
20521	312	S20   
20521	312	S206  
20521	312	S208  
20521	312	S2682 
20521	312	S2683 
20521	312	S2684 
20521	312	S6    
20521	312	S7    
20521	312	S8    
20521	312	S9    
20623	312	S1742 
20624	312	S1742 
20628	312	S1742 
20629	312	S1742 
20630	312	S1742 
20634	312	S1742 
20635	312	S1742 
20636	312	S1742 
20640	312	S1742 
20641	312	S1742 
20645	312	S1742 
20646	312	S1742 
21138	312	S1064 
21138	312	S1066 
21138	312	S1122 
21141	312	S1064 
21224	312	S19   
21225	312	S19   
21226	312	S22   
21227	312	S22   
21229	312	S1122 
21238	312	S2801 
21239	312	S1066 
21240	312	S1066 
21241	312	S1066 
21242	312	S1066 
21243	312	S1066 
21244	312	S1066 
21245	312	S1066 
21246	312	S1066 
21247	312	S1066 
21248	312	S1066 
21249	312	S1064 
21250	312	S1064 
21251	312	S1064 
21252	312	S1064 
21253	312	S1064 
21254	312	S1064 
21255	312	S1064 
21256	312	S1064 
21257	312	S1064 
21259	312	S1064 
21260	312	S1082 
21261	312	S1082 
21262	312	S1082 
21263	312	S1082 
21264	312	S1082 
21265	312	S1082 
21266	312	S1082 
21267	312	S1082 
21268	312	S1082 
21269	312	S1082 
21270	312	S1082 
21271	312	S2108 
21272	312	S2108 
21273	312	S2108 
21274	312	S2108 
21275	312	S2108 
21276	312	S2108 
21277	312	S2110 
21278	312	S2110 
21279	312	S2110 
21280	312	S2110 
21281	312	S2110 
21282	312	S2110 
21283	312	S2111 
21284	312	S2111 
21285	312	S2111 
21286	312	S2111 
21287	312	S2112 
21288	312	S2112 
21289	312	S2112 
21290	312	S2112 
21291	312	S2112 
21292	312	S2112 
21293	312	S2782 
21295	312	S2782 
21296	312	S2782 
21298	312	S2782 
21299	312	S2110 
21299	312	S2111 
21299	312	S2112 
21299	312	S2782 
21300	312	S2110 
21300	312	S2112 
21301	312	S2110 
21301	312	S2111 
21301	312	S2112 
21301	312	S2782 
21302	312	S2110 
21302	312	S2111 
21302	312	S2112 
21302	312	S2782 
21303	312	S2110 
21303	312	S2112 
21304	312	S2110 
21304	312	S2111 
21304	312	S2112 
21304	312	S2782 
21308	312	S2801 
21309	312	S2801 
21310	312	S2801 
21311	312	S2801 
21312	312	S2801 
21313	312	S2801 
21314	312	S2801 
21315	312	S2801 
21316	312	S2801 
21317	312	S2801 
21318	312	S2801 
21319	312	S2801 
21320	312	S2801 
21321	312	S2801 
21322	312	S2801 
21323	312	S2801 
21324	312	S2801 
21325	312	S2801 
21326	312	S2801 
21337	312	S2801 
21343	312	S2801 
21346	312	S2801 
21347	312	S2801 
21348	312	S2801 
21349	312	S2801 
22247	312	S20   
22903	312	S21   
22904	312	S18   
22909	312	S22   
22911	312	S18   
22912	312	S19   
22914	312	S19   
22915	312	S19   
22916	312	S19   
23009	312	S2703 
23010	312	S2703 
23011	312	S2703 
23012	312	S2703 
23013	312	S2703 
23014	312	S2703 
23015	312	S2703 
23016	312	S2703 
23017	312	S2703 
23018	312	S2703 
23019	312	S2703 
23020	312	S2703 
23021	312	S2703 
23022	312	S2703 
23023	312	S2703 
23024	312	S2703 
23025	312	S2703 
23027	312	S2703 
23028	312	S2703 
23029	312	S2703 
23030	312	S2703 
23031	312	S2703 
23032	312	S2703 
23033	312	S2703 
23034	312	S2703 
23035	312	S2703 
23036	312	S2703 
23037	312	S2703 
23038	312	S2703 
23039	312	S2703 
23040	312	S2703 
23041	312	S2703 
23042	312	S2703 
23043	312	S2703 
23044	312	S2703 
23045	312	S2703 
23046	312	S2703 
23047	312	S2703 
23048	312	S2703 
23049	312	S2703 
23050	312	S2703 
23051	312	S2703 
23052	312	S2703 
23053	312	S2703 
23054	312	S2703 
23055	312	S2703 
23056	312	S2703 
23057	312	S2703 
23058	312	S2703 
23059	312	S2703 
23060	312	S2703 
23061	312	S2703 
23062	312	S2703 
23063	312	S2703 
23064	312	S2703 
23065	312	S2703 
23557	312	S14   
23558	312	S14   
23559	312	S14   
23560	312	S14   
23561	312	S14   
23562	312	S14   
23563	312	S14   
23564	312	S14   
23565	312	S14   
23566	312	S14   
23567	312	S14   
23568	312	S14   
23569	312	S14   
23570	312	S14   
23571	312	S14   
23572	312	S14   
23573	312	S14   
23574	312	S14   
23575	312	S14   
23576	312	S14   
23577	312	S14   
23578	312	S14   
23579	312	S14   
23580	312	S14   
23581	312	S14   
23582	312	S2    
23583	312	S2    
23584	312	S2    
23585	312	S2    
23586	312	S2    
23587	312	S2    
23588	312	S2    
23589	312	S2    
23590	312	S2    
23591	312	S2    
23592	312	S2    
23593	312	S2    
23594	312	S2    
23595	312	S2    
23596	312	S2    
23597	312	S2    
23598	312	S2    
23599	312	S2    
23600	312	S2    
23601	312	S2    
23602	312	S2    
23603	312	S2    
23604	312	S2    
23605	312	S2    
23606	312	S2    
23607	312	S2    
23608	312	S2    
23609	312	S2    
23610	312	S2    
23611	312	S2    
23612	312	S2    
23613	312	S2    
23614	312	S2    
23615	312	S2    
23616	312	S2    
23617	312	S2    
23618	312	S2    
23619	312	S2    
23620	312	S2    
23621	312	S2    
23622	312	S2    
23623	312	S2    
23624	312	S2    
23625	312	S2    
23626	312	S2    
23627	312	S2    
23628	312	S2    
23629	312	S2    
23630	312	S2    
23631	312	S2    
23632	312	S2    
23633	312	S2    
23634	312	S2    
23635	312	S2    
23636	312	S2    
23637	312	S2    
23638	312	S2    
23640	312	S1581 
23646	312	S2    
23647	312	S2    
23648	312	S2    
23649	312	S2    
23650	312	S2    
23651	312	S2    
23652	312	S2    
23653	312	S2    
23654	312	S2    
23655	312	S2    
23656	312	S2    
23657	312	S2    
23658	312	S2    
23659	312	S2    
23660	312	S2    
35001	312	D4961 
35002	312	D4961 
35003	312	D4961 
35015	312	D4961 
35024	312	D4961 
35048	312	D4961 
35051	312	D4961 
35054	312	D4961 
35078	312	D4961 
35089	312	D4961 
35130	312	S2381 
35131	312	S2381 
35132	312	S2381 
35133	312	S2381 
35134	312	S2381 
35135	312	S2381 
35136	312	S2381 
35137	312	S2381 
35138	312	S2381 
35140	312	S2381 
35141	312	S2381 
35142	312	S2381 
35143	312	S2381 
35144	312	S2381 
35145	312	S2381 
35146	312	S2381 
35147	312	S2381 
35148	312	S2381 
42190	312	S243  
43158	312	S2109 
43215	312	S26   
43378	312	S1082 
43514	312	S1067 
01001	315	S10   
01001	315	S11   
01001	315	S12   
01001	315	S6    
01001	315	S7    
01001	315	S8    
01001	315	S9    
01026	315	S25   
01032	315	S19   
01040	315	S10   
01040	315	S11   
01040	315	S12   
01040	315	S6    
01040	315	S7    
01040	315	S8    
01040	315	S9    
01042	315	S10   
01042	315	S11   
01042	315	S12   
01042	315	S19   
01042	315	S6    
01042	315	S7    
01042	315	S8    
01042	315	S9    
01046	315	S19   
01077	315	S10   
01077	315	S11   
01077	315	S12   
01077	315	S27   
01077	315	S7    
01077	315	S8    
01077	315	S9    
01079	315	S1063 
01082	315	S1063 
01085	315	S1063 
01103	315	S1163 
01123	315	S1063 
01123	315	S561  
01124	315	S1065 
01125	315	S1065 
01202	315	S1163 
02048	315	S2109 
02053	315	S2109 
04017	315	S19   
04020	315	S19   
04021	315	S19   
04023	315	S19   
04053	315	S19   
04114	315	S19   
04120	315	S19   
04141	315	S19   
04142	315	S19   
04143	315	S19   
04144	315	S19   
04367	315	S19   
04629	315	S18   
04630	315	S19   
04631	315	S20   
04635	315	S19   
04636	315	S19   
04638	315	S26   
04639	315	S26   
04640	315	S26   
04656	315	S2221 
04657	315	S2221 
04658	315	S2221 
04659	315	S2221 
04660	315	S2221 
04661	315	S2221 
04662	315	S2221 
04663	315	S2221 
05023	315	S1581 
05024	315	S1581 
05027	315	S1082 
05028	315	S1082 
05173	315	S1581 
05174	315	S1581 
05175	315	S1581 
05176	315	S1581 
05177	315	S1581 
05178	315	S1581 
05312	315	S26   
05313	315	S26   
05320	315	S26   
05624	315	S3    
05632	315	S3    
05661	315	S1082 
06016	315	S18   
06019	315	S18   
06043	315	S18   
06094	315	S18   
06128	315	S18   
06159	315	S18   
06164	315	S23   
06931	315	S22   
06982	315	S18   
06983	315	S18   
06984	315	S2104 
06985	315	S2104 
07002	315	S222  
07005	315	S248  
07007	315	S1164 
07015	315	S248  
07016	315	S248  
07022	315	S21   
07039	315	S244  
07056	315	S248  
07063	315	S1164 
07063	315	S582  
07064	315	S1164 
07075	315	S1164 
07241	315	S21   
07931	315	S222  
07938	315	S233  
07939	315	S235  
07945	315	S21   
07949	315	S23   
07950	315	S23   
07952	315	S1164 
07953	315	S1164 
07953	315	S582  
07954	315	S582  
07955	315	S1164 
07956	315	S1164 
07957	315	S1164 
07958	315	S1164 
07959	315	S1164 
07960	315	S1164 
08001	315	S1065 
08010	315	S702  
08011	315	S702  
08012	315	S1065 
08013	315	S1065 
08014	315	S1065 
08018	315	S702  
08020	315	S1065 
08025	315	S2662 
08030	315	S1065 
08047	315	S702  
08049	315	S702  
08054	315	S702  
08059	315	S702  
08061	315	S1065 
08065	315	S1065 
08065	315	S2662 
08066	315	S702  
08074	315	S2662 
08077	315	S1065 
08085	315	S702  
08092	315	S702  
08094	315	S702  
08124	315	S702  
08128	315	S702  
08130	315	S702  
08146	315	S702  
08147	315	S1065 
08200	315	S702  
08210	315	S702  
08211	315	S702  
08212	315	S702  
08214	315	S702  
08215	315	S702  
08216	315	S702  
08218	315	S1065 
08219	315	S702  
08220	315	S702  
08221	315	S702  
08225	315	S702  
08229	315	S702  
08231	315	S702  
08232	315	S702  
08259	315	S2662 
08293	315	S702  
08294	315	S702  
08299	315	S702  
08315	315	S702  
08316	315	S702  
08317	315	S702  
08351	315	S702  
08352	315	S702  
08353	315	S702  
08354	315	S702  
08355	315	S702  
08357	315	S702  
08358	315	S702  
08359	315	S702  
08360	315	S702  
08361	315	S702  
08362	315	S702  
08363	315	S702  
08364	315	S702  
08366	315	S702  
08385	315	S2664 
08386	315	S2664 
08394	315	S702  
08395	315	S702  
08396	315	S702  
08400	315	S881  
08401	315	S881  
08402	315	S702  
08410	315	S702  
08411	315	S702  
08412	315	S702  
08413	315	S702  
08414	315	S702  
08415	315	S702  
08416	315	S702  
08417	315	S702  
08418	315	S702  
08419	315	S702  
08420	315	S702  
08421	315	S702  
08422	315	S702  
08435	315	S1065 
08436	315	S702  
08444	315	S702  
08446	315	S702  
08448	315	S702  
08449	315	S702  
08450	315	S702  
08471	315	S2664 
08504	315	S2662 
08505	315	S2662 
08506	315	S2662 
08507	315	S2662 
08508	315	S2662 
08509	315	S2662 
09003	315	D4070 
09003	315	S1183 
09003	315	S502  
09003	315	S561  
09004	315	S502  
09021	315	S10   
09021	315	S11   
09021	315	S12   
09021	315	S206  
09021	315	S208  
09021	315	S7    
09021	315	S8    
09021	315	S9    
09032	315	S21   
09037	315	D4070 
09037	315	S1031 
09037	315	S381  
09037	315	S481  
09037	315	S502  
09038	315	S1031 
09038	315	S481  
09038	315	S502  
09039	315	D4070 
09039	315	S381  
09040	315	S10   
09040	315	S1023 
09040	315	S11   
09040	315	S12   
09040	315	S206  
09040	315	S208  
09040	315	S481  
09040	315	S562  
09040	315	S6    
09040	315	S7    
09040	315	S73   
09040	315	S74   
09040	315	S8    
09040	315	S9    
09042	315	S461  
09042	315	S566  
09050	315	S1141 
09050	315	S421  
09060	315	D4070 
09060	315	S381  
09062	315	S381  
09062	315	S404  
09070	315	D4070 
09070	315	S10   
09070	315	S11   
09070	315	S12   
09070	315	S182  
09070	315	S183  
09070	315	S201  
09070	315	S202  
09070	315	S203  
09070	315	S204  
09070	315	S205  
09070	315	S206  
09070	315	S208  
09070	315	S53   
09070	315	S582  
09070	315	S6    
09070	315	S73   
09070	315	S74   
09070	315	S8    
09070	315	S9    
09078	315	S561  
09087	315	S1032 
09087	315	S564  
09087	315	S582  
09094	315	S363  
09094	315	S582  
09112	315	D4070 
09112	315	S482  
09112	315	S563  
09132	315	D4070 
09132	315	S10   
09132	315	S1062 
09132	315	S11   
09132	315	S12   
09132	315	S206  
09132	315	S208  
09132	315	S6    
09132	315	S7    
09132	315	S8    
09132	315	S9    
09139	315	S381  
09148	315	D4070 
09148	315	S1033 
09148	315	S363  
09149	315	S381  
09160	315	S1065 
09181	315	D4070 
09181	315	S10   
09181	315	S1024 
09181	315	S11   
09181	315	S1121 
09181	315	S12   
09181	315	S206  
09181	315	S208  
09181	315	S461  
09181	315	S6    
09181	315	S7    
09181	315	S73   
09181	315	S74   
09181	315	S8    
09181	315	S9    
09183	315	S381  
09184	315	D4070 
09184	315	S1026 
09184	315	S562  
09184	315	S565  
09191	315	D4070 
09191	315	S421  
09191	315	S582  
09202	315	S482  
09202	315	S564  
09218	315	S1065 
09218	315	S1161 
09236	315	D4070 
09236	315	S10   
09236	315	S11   
09236	315	S12   
09236	315	S461  
09236	315	S6    
09236	315	S7    
09236	315	S73   
09236	315	S74   
09236	315	S8    
09236	315	S9    
09252	315	D4070 
09252	315	S10   
09252	315	S11   
09252	315	S12   
09252	315	S206  
09252	315	S208  
09252	315	S482  
09252	315	S541  
09252	315	S6    
09252	315	S7    
09252	315	S73   
09252	315	S74   
09252	315	S8    
09252	315	S9    
09266	315	D4070 
09266	315	S1167 
09266	315	S441  
09266	315	S561  
09273	315	S2104 
09279	315	S10   
09279	315	S11   
09279	315	S12   
09279	315	S206  
09279	315	S208  
09279	315	S421  
09279	315	S582  
09279	315	S6    
09279	315	S7    
09279	315	S73   
09279	315	S74   
09279	315	S8    
09279	315	S9    
09291	315	S10   
09291	315	S11   
09291	315	S12   
09291	315	S206  
09291	315	S208  
09291	315	S564  
09291	315	S566  
09291	315	S6    
09291	315	S7    
09291	315	S73   
09291	315	S74   
09291	315	S8    
09291	315	S9    
09298	315	S10   
09298	315	S11   
09298	315	S12   
09298	315	S206  
09298	315	S208  
09298	315	S564  
09298	315	S566  
09298	315	S6    
09298	315	S7    
09298	315	S73   
09298	315	S74   
09298	315	S8    
09298	315	S9    
09302	315	S381  
09302	315	S461  
09302	315	S566  
09302	315	S963  
09316	315	S10   
09316	315	S11   
09316	315	S12   
09316	315	S182  
09316	315	S183  
09316	315	S201  
09316	315	S202  
09316	315	S203  
09316	315	S204  
09316	315	S205  
09316	315	S206  
09316	315	S208  
09316	315	S421  
09316	315	S566  
09316	315	S581  
09316	315	S6    
09316	315	S7    
09316	315	S73   
09316	315	S74   
09316	315	S8    
09316	315	S9    
09326	315	S10   
09326	315	S1027 
09326	315	S11   
09326	315	S12   
09326	315	S206  
09326	315	S208  
09326	315	S441  
09326	315	S461  
09326	315	S6    
09326	315	S7    
09326	315	S73   
09326	315	S74   
09326	315	S8    
09326	315	S9    
09328	315	S1206 
09409	315	S2104 
09421	315	S564  
09421	315	S582  
09422	315	S1202 
09427	315	D4053 
09428	315	D4053 
09429	315	D4070 
09429	315	S1167 
09429	315	S441  
09430	315	S441  
09430	315	S561  
09431	315	S2203 
09432	315	S2203 
09433	315	S2105 
10007	315	S1082 
10066	315	S1082 
10067	315	S1082 
10068	315	S1082 
10098	315	S1581 
10099	315	S1581 
10102	315	S1581 
10119	315	S1581 
10123	315	S1082 
10124	315	S1082 
10173	315	S1581 
10858	315	S1082 
10860	315	S1082 
10861	315	S1082 
10862	315	S1082 
10863	315	S1581 
10864	315	S1082 
11011	315	S1069 
11012	315	S1069 
11019	315	S10   
11019	315	S11   
11019	315	S12   
11019	315	S6    
11019	315	S7    
11019	315	S8    
11019	315	S9    
11090	315	S1121 
11090	315	S564  
11090	315	S619  
11091	315	S1121 
11091	315	S564  
11096	315	S1121 
11096	315	S482  
11097	315	S482  
11101	315	S10   
11101	315	S11   
11101	315	S12   
11101	315	S6    
11101	315	S7    
11101	315	S8    
11101	315	S9    
11112	315	S1065 
11113	315	S1065 
11124	315	S1062 
11124	315	S183  
11124	315	S201  
11124	315	S202  
11124	315	S203  
11124	315	S6    
11124	315	S618  
11125	315	S1062 
11130	315	S25   
11131	315	S25   
11143	315	S1121 
11143	315	S183  
11143	315	S201  
11143	315	S202  
11143	315	S203  
11143	315	S564  
11143	315	S6    
11157	315	S1202 
11205	315	S1062 
11206	315	S1062 
11206	315	S183  
11206	315	S201  
11206	315	S202  
11206	315	S203  
11206	315	S6    
11210	315	S10   
11210	315	S11   
11210	315	S12   
11210	315	S6    
11210	315	S7    
11210	315	S8    
11210	315	S9    
11243	315	S2941 
11250	315	S562  
11250	315	S565  
11251	315	S481  
11251	315	S503  
11251	315	S620  
11252	315	S10   
11252	315	S11   
11252	315	S12   
11252	315	S183  
11252	315	S201  
11252	315	S202  
11252	315	S203  
11252	315	S481  
11252	315	S562  
11252	315	S6    
11252	315	S624  
11252	315	S7    
11252	315	S8    
11252	315	S9    
11253	315	S541  
11253	315	S565  
11257	315	S541  
11257	315	S565  
11260	315	S10   
11260	315	S11   
11260	315	S12   
11260	315	S1821 
11260	315	S2941 
11260	315	S6    
11260	315	S7    
11260	315	S78   
11260	315	S8    
11260	315	S80   
11260	315	S9    
11263	315	S2941 
11267	315	S2941 
11279	315	S10   
11279	315	S11   
11279	315	S12   
11279	315	S6    
11279	315	S7    
11279	315	S8    
11279	315	S9    
11282	315	S10   
11282	315	S1062 
11282	315	S11   
11282	315	S12   
11282	315	S183  
11282	315	S201  
11282	315	S202  
11282	315	S203  
11282	315	S6    
11282	315	S7    
11282	315	S8    
11282	315	S9    
11286	315	S1062 
11294	315	S563  
11294	315	S582  
11333	315	S1062 
11333	315	S183  
11333	315	S201  
11333	315	S202  
11333	315	S203  
11333	315	S6    
11333	315	S611  
11339	315	S1062 
11352	315	S563  
11352	315	S566  
11353	315	S563  
11353	315	S566  
11354	315	S563  
11354	315	S566  
11355	315	S563  
11355	315	S566  
11356	315	S563  
11356	315	S566  
11357	315	S563  
11357	315	S566  
11358	315	S563  
11358	315	S566  
11359	315	S2105 
11360	315	S183  
11360	315	S201  
11360	315	S202  
11360	315	S203  
11360	315	S2105 
11360	315	S6    
11394	315	S2105 
11395	315	S2105 
11398	315	S2105 
11399	315	S2105 
11402	315	S2105 
11403	315	S183  
11403	315	S201  
11403	315	S202  
11403	315	S203  
11403	315	S2105 
11403	315	S6    
11411	315	S2105 
11412	315	S2105 
11429	315	S1121 
11429	315	S363  
11429	315	S617  
11463	315	S25   
11464	315	S25   
11468	315	S12   
11468	315	S183  
11468	315	S201  
11468	315	S202  
11468	315	S203  
11507	315	S1062 
11508	315	S10   
11508	315	S1062 
11508	315	S11   
11508	315	S12   
11508	315	S183  
11508	315	S201  
11508	315	S202  
11508	315	S203  
11508	315	S6    
11508	315	S7    
11508	315	S8    
11508	315	S9    
11510	315	S1062 
11529	315	S183  
11529	315	S201  
11529	315	S202  
11529	315	S203  
11529	315	S441  
11529	315	S503  
11529	315	S6    
11529	315	S608  
11530	315	S441  
11540	315	S10   
11540	315	S11   
11540	315	S12   
11540	315	S183  
11540	315	S201  
11540	315	S202  
11540	315	S203  
11540	315	S6    
11540	315	S7    
11540	315	S8    
11540	315	S9    
11546	315	S21   
11547	315	S21   
11549	315	S183  
11549	315	S201  
11549	315	S202  
11549	315	S203  
11549	315	S21   
11549	315	S6    
11565	315	S10   
11565	315	S11   
11565	315	S12   
11565	315	S6    
11565	315	S7    
11565	315	S8    
11565	315	S9    
11674	315	S183  
11674	315	S201  
11674	315	S202  
11674	315	S203  
11674	315	S563  
11674	315	S566  
11705	315	S1069 
11709	315	S10   
11709	315	S11   
11709	315	S12   
11709	315	S6    
11709	315	S7    
11709	315	S8    
11709	315	S9    
11742	315	S1121 
11742	315	S564  
11746	315	S10   
11746	315	S11   
11746	315	S12   
11746	315	S6    
11746	315	S7    
11746	315	S8    
11746	315	S9    
11752	315	S1065 
11757	315	S1062 
11760	315	S25   
11783	315	S10   
11783	315	S11   
11783	315	S12   
11783	315	S6    
11783	315	S7    
11783	315	S8    
11783	315	S9    
11803	315	S10   
11803	315	S11   
11803	315	S12   
11803	315	S6    
11803	315	S7    
11803	315	S8    
11803	315	S9    
11821	315	S1062 
11828	315	S183  
11828	315	S201  
11828	315	S202  
11828	315	S203  
11828	315	S563  
11828	315	S566  
11841	315	S183  
11841	315	S201  
11841	315	S202  
11841	315	S203  
11841	315	S2105 
11841	315	S6    
11842	315	S2105 
11856	315	S25   
11858	315	S12   
11858	315	S183  
11858	315	S201  
11858	315	S202  
11858	315	S203  
11875	315	S10   
11875	315	S1062 
11875	315	S11   
11875	315	S12   
11875	315	S183  
11875	315	S201  
11875	315	S202  
11875	315	S203  
11875	315	S6    
11875	315	S7    
11875	315	S8    
11875	315	S9    
11876	315	S1062 
11884	315	S441  
11886	315	S10   
11886	315	S11   
11886	315	S12   
11886	315	S183  
11886	315	S201  
11886	315	S202  
11886	315	S203  
11886	315	S6    
11886	315	S7    
11886	315	S8    
11886	315	S9    
11887	315	S21   
11888	315	S21   
11921	315	S1062 
11935	315	S183  
11935	315	S202  
11935	315	S203  
11935	315	S22   
11935	315	S6    
11949	315	S183  
11949	315	S202  
11949	315	S203  
11949	315	S22   
11949	315	S6    
11950	315	S2941 
11960	315	S481  
11960	315	S562  
11987	315	S1202 
11987	315	S2941 
11990	315	S1202 
11991	315	S1202 
11992	315	S2941 
12006	315	S1783 
12061	315	S141  
12062	315	S141  
12063	315	S141  
12065	315	S141  
12078	315	S1063 
12078	315	S503  
12086	315	S343  
12086	315	S363  
12086	315	S502  
12087	315	S343  
12120	315	S83   
12121	315	S83   
12122	315	S83   
12131	315	S77   
12132	315	S77   
12142	315	S85   
12143	315	S85   
12144	315	S85   
12147	315	S502  
12147	315	S564  
12151	315	S86   
12152	315	S86   
12154	315	S941  
12155	315	S79   
12201	315	S1164 
12220	315	D4743 
12220	315	S1221 
12220	315	S2109 
12563	315	S141  
12565	315	S141  
12586	315	S343  
12586	315	S363  
12586	315	S502  
12632	315	S77   
12643	315	S85   
12644	315	S85   
12652	315	S86   
13019	315	S2    
13020	315	S2    
13055	315	S2    
13065	315	S2    
13067	315	S2    
13068	315	S2    
13070	315	S2    
13096	315	S2    
13098	315	S2    
13165	315	S2    
13318	315	S1581 
13320	315	S1581 
13321	315	S1581 
13322	315	S1581 
13323	315	S1581 
13324	315	S1581 
13325	315	S1082 
13326	315	S1082 
13327	315	S1082 
13340	315	S1581 
13341	315	S1581 
13343	315	S2    
13369	315	S2    
13370	315	S2    
13373	315	S2    
13375	315	S2    
13377	315	S2    
13378	315	S2    
13391	315	S2    
13394	315	S2    
13398	315	S2    
13399	315	S2    
13401	315	S2    
13402	315	S2    
13404	315	S2    
13405	315	S2    
13407	315	S2    
13408	315	S2    
13410	315	S2    
13411	315	S2    
13413	315	S2    
13414	315	S2    
13415	315	S2    
13416	315	S2    
13417	315	S2    
13418	315	S2    
13419	315	S2    
13420	315	S2    
13421	315	S2    
13422	315	S2    
13423	315	S2    
13424	315	S2    
13425	315	S2    
13426	315	S2    
13439	315	S2    
13440	315	S2    
13441	315	S2    
13442	315	S2    
13443	315	S2    
13444	315	S2    
13445	315	S2    
13446	315	S2    
13447	315	S2    
13448	315	S2    
13449	315	S2    
13450	315	S2    
13451	315	S2    
13452	315	S2    
13453	315	S2    
13454	315	S2    
13455	315	S2    
13456	315	S2    
13485	315	S2    
13486	315	S2    
13487	315	S2    
13488	315	S2    
13490	315	S2    
13491	315	S2    
13492	315	S2    
13493	315	S2    
13494	315	S14   
13495	315	S14   
13496	315	S14   
13497	315	S14   
13498	315	S14   
13565	315	S2703 
13566	315	S2703 
13567	315	S2703 
13568	315	S2703 
13569	315	S2703 
13805	315	S2    
13806	315	S2    
13809	315	S2    
13810	315	S2    
13811	315	S2    
13812	315	S2    
13813	315	S2    
13814	315	S2    
13850	315	S2    
13851	315	S2    
13853	315	S2    
13854	315	S2    
13856	315	S2    
13857	315	S2    
13868	315	S2    
13869	315	S2    
13870	315	S2    
13871	315	S2    
13872	315	S2    
13873	315	S2    
13874	315	S2    
13875	315	S2    
13876	315	S2    
13877	315	S2    
13878	315	S2    
13879	315	S2    
13880	315	S2    
13881	315	S2    
13882	315	S2    
13891	315	S2    
13893	315	S2    
13894	315	S2    
13896	315	S2    
13898	315	S2    
13900	315	S2    
13909	315	S2    
13910	315	S2    
13911	315	S2    
13912	315	S2    
13913	315	S2    
13914	315	S2    
13917	315	S2    
13918	315	S2    
13920	315	S2    
13921	315	S2    
13923	315	S2    
13924	315	S2    
13929	315	S2    
13930	315	S2    
13931	315	S2    
13932	315	S2    
13934	315	S2    
13935	315	S2    
13948	315	S2    
13949	315	S2    
13950	315	S2    
13951	315	S2    
13952	315	S2    
13953	315	S2    
13954	315	S2    
13955	315	S2    
13956	315	S2    
13957	315	S2    
13958	315	S2    
13959	315	S2    
13968	315	S2    
13969	315	S2    
13970	315	S2    
13971	315	S2    
13985	315	S2    
13988	315	S2703 
13989	315	S2703 
13990	315	S2703 
13991	315	S2703 
13992	315	S2703 
13994	315	S2703 
13995	315	S2703 
13996	315	S2703 
13997	315	S2703 
13998	315	S2703 
14003	315	S2103 
14006	315	S2103 
14052	315	S10   
14052	315	S11   
14052	315	S12   
14052	315	S6    
14052	315	S7    
14052	315	S8    
14052	315	S9    
14084	315	S2103 
14096	315	S2103 
14106	315	S2103 
14137	315	S1068 
14144	315	S1068 
14145	315	S1064 
14145	315	S1066 
14145	315	S1068 
14145	315	S1122 
14146	315	S1068 
14147	315	S1068 
14148	315	S1068 
14149	315	S1068 
14154	315	S2702 
14156	315	S2702 
14166	315	S10   
14166	315	S11   
14166	315	S12   
14166	315	S6    
14166	315	S7    
14166	315	S8    
14166	315	S9    
14209	315	S1064 
14209	315	S1066 
14209	315	S1122 
14209	315	S23   
14219	315	S10   
14219	315	S11   
14219	315	S12   
14219	315	S6    
14219	315	S7    
14219	315	S8    
14219	315	S9    
14238	315	S2104 
14242	315	S2104 
14267	315	S10   
14267	315	S11   
14267	315	S12   
14267	315	S6    
14267	315	S7    
14267	315	S8    
14267	315	S9    
14323	315	S1067 
14347	315	S1064 
14347	315	S1122 
14366	315	S2104 
14370	315	S2104 
14382	315	S1164 
14400	315	S1064 
14400	315	S1066 
14400	315	S1068 
14400	315	S1122 
14416	315	S1064 
14416	315	S1066 
14416	315	S1068 
14416	315	S1122 
14429	315	S20   
14429	315	S23   
14429	315	S25   
14432	315	S1068 
14433	315	S1068 
14434	315	S1068 
14440	315	S2109 
14450	315	S1164 
14460	315	S1164 
14461	315	S1164 
14462	315	S2109 
14475	315	S1068 
14476	315	S1068 
14559	315	S1068 
14601	315	S1066 
14602	315	S2103 
15027	315	S10   
15027	315	S11   
15027	315	S1163 
15027	315	S12   
15027	315	S9    
15073	315	S1163 
15087	315	S2109 
15152	315	S2104 
15232	315	S1163 
15260	315	S2109 
15261	315	S1163 
15262	315	S1163 
16006	315	S1164 
16010	315	S1164 
16011	315	S1164 
16028	315	S10   
16028	315	S11   
16028	315	S12   
16028	315	S182  
16028	315	S183  
16028	315	S203  
16028	315	S6    
16028	315	S7    
16028	315	S8    
16028	315	S9    
16029	315	S1164 
16037	315	S1164 
16037	315	S2202 
16038	315	S1164 
16038	315	S182  
16038	315	S183  
16038	315	S203  
16038	315	S2202 
16042	315	S1065 
16042	315	S2202 
16043	315	S10   
16043	315	S1065 
16043	315	S11   
16043	315	S12   
16043	315	S182  
16043	315	S183  
16043	315	S203  
16043	315	S2202 
16043	315	S6    
16043	315	S7    
16043	315	S8    
16043	315	S9    
16089	315	S563  
16097	315	S22   
16098	315	S10   
16098	315	S11   
16098	315	S12   
16098	315	S182  
16098	315	S183  
16098	315	S203  
16098	315	S22   
16098	315	S6    
16098	315	S7    
16098	315	S8    
16098	315	S9    
16112	315	S39   
16114	315	S39   
16120	315	S39   
16126	315	S39   
16139	315	S39   
16147	315	S2104 
16159	315	D342  
16159	315	S39   
16167	315	S2203 
16174	315	S18   
16338	315	S1164 
16338	315	S182  
16338	315	S183  
16338	315	S203  
16338	315	S2202 
16343	315	S10   
16343	315	S1065 
16343	315	S11   
16343	315	S12   
16343	315	S182  
16343	315	S183  
16343	315	S203  
16343	315	S2202 
16343	315	S6    
16343	315	S7    
16343	315	S8    
16343	315	S9    
16397	315	S22   
16398	315	S10   
16398	315	S11   
16398	315	S12   
16398	315	S182  
16398	315	S183  
16398	315	S203  
16398	315	S22   
16398	315	S6    
16398	315	S7    
16398	315	S8    
16398	315	S9    
17202	315	S1082 
17203	315	S1082 
17204	315	S1082 
17218	315	S1581 
17219	315	S1581 
17332	315	S3    
17335	315	S3    
17340	315	S3    
17341	315	S3    
17342	315	S3    
17345	315	S3    
17346	315	S3    
17347	315	S3    
17348	315	S3    
18001	315	S1162 
18002	315	S1162 
18069	315	S20   
18079	315	S25   
18159	315	S21   
18166	315	S25   
18168	315	S25   
18215	315	S25   
18228	315	S23   
18231	315	S25   
18258	315	S1162 
18259	315	S1162 
18262	315	S1162 
18263	315	S1162 
18288	315	S27   
18350	315	S21   
18363	315	S22   
18364	315	S22   
18365	315	S27   
18376	315	S25   
18403	315	S27   
18927	315	S25   
18930	315	S2203 
18931	315	S2203 
18932	315	S27   
18933	315	S27   
18934	315	S27   
18935	315	S27   
18936	315	S27   
19003	315	S26   
19034	315	S26   
19035	315	S26   
19056	315	S26   
19057	315	S2109 
19058	315	S2109 
19064	315	S1164 
19076	315	S1164 
19078	315	S1069 
19109	315	S1164 
19120	315	S10   
19120	315	S1069 
19120	315	S11   
19120	315	S12   
19120	315	S6    
19120	315	S7    
19120	315	S8    
19120	315	S9    
19129	315	S10   
19129	315	S11   
19129	315	S12   
19129	315	S6    
19129	315	S7    
19129	315	S8    
19129	315	S9    
19155	315	S1164 
19230	315	S1063 
19283	315	S1067 
19300	315	S10   
19300	315	S11   
19300	315	S12   
19300	315	S6    
19300	315	S7    
19300	315	S8    
19300	315	S9    
19335	315	S10   
19335	315	S11   
19335	315	S12   
19335	315	S6    
19335	315	S7    
19335	315	S8    
19335	315	S9    
19337	315	S2109 
19350	315	S1164 
19411	315	S26   
19856	315	S1067 
19868	315	S2109 
19873	315	S1067 
20046	315	S20   
20047	315	S20   
20048	315	S20   
20049	315	S20   
20099	315	S20   
20100	315	S10   
20100	315	S11   
20100	315	S12   
20100	315	S20   
20100	315	S206  
20100	315	S208  
20100	315	S2682 
20100	315	S2683 
20100	315	S2684 
20100	315	S6    
20100	315	S7    
20100	315	S8    
20100	315	S9    
20109	315	S2105 
20110	315	S10   
20110	315	S11   
20110	315	S12   
20110	315	S206  
20110	315	S208  
20110	315	S2105 
20110	315	S2682 
20110	315	S2683 
20110	315	S2684 
20110	315	S6    
20110	315	S7    
20110	315	S8    
20110	315	S9    
20120	315	S20   
20121	315	S10   
20121	315	S11   
20121	315	S12   
20121	315	S20   
20121	315	S206  
20121	315	S208  
20121	315	S2682 
20121	315	S2683 
20121	315	S2684 
20121	315	S6    
20121	315	S7    
20121	315	S8    
20121	315	S9    
20132	315	S1202 
20310	315	S10   
20310	315	S11   
20310	315	S12   
20310	315	S206  
20310	315	S208  
20310	315	S2105 
20310	315	S2682 
20310	315	S2683 
20310	315	S2684 
20310	315	S6    
20310	315	S7    
20310	315	S8    
20310	315	S9    
20321	315	S10   
20321	315	S11   
20321	315	S12   
20321	315	S20   
20321	315	S206  
20321	315	S208  
20321	315	S2682 
20321	315	S2683 
20321	315	S2684 
20321	315	S6    
20321	315	S7    
20321	315	S8    
20321	315	S9    
20400	315	S10   
20400	315	S11   
20400	315	S12   
20400	315	S20   
20400	315	S206  
20400	315	S208  
20400	315	S2682 
20400	315	S2683 
20400	315	S2684 
20400	315	S6    
20400	315	S7    
20400	315	S8    
20400	315	S9    
20409	315	S2105 
20410	315	S10   
20410	315	S11   
20410	315	S12   
20410	315	S206  
20410	315	S208  
20410	315	S2105 
20410	315	S2682 
20410	315	S2683 
20410	315	S2684 
20410	315	S6    
20410	315	S7    
20410	315	S8    
20410	315	S9    
20420	315	S20   
20421	315	S10   
20421	315	S11   
20421	315	S12   
20421	315	S20   
20421	315	S206  
20421	315	S208  
20421	315	S2682 
20421	315	S2683 
20421	315	S2684 
20421	315	S6    
20421	315	S7    
20421	315	S8    
20421	315	S9    
20446	315	S20   
20447	315	S20   
20499	315	S20   
20510	315	S10   
20510	315	S11   
20510	315	S12   
20510	315	S206  
20510	315	S208  
20510	315	S2105 
20510	315	S2682 
20510	315	S2683 
20510	315	S2684 
20510	315	S6    
20510	315	S7    
20510	315	S8    
20510	315	S9    
20521	315	S10   
20521	315	S11   
20521	315	S12   
20521	315	S20   
20521	315	S206  
20521	315	S208  
20521	315	S2682 
20521	315	S2683 
20521	315	S2684 
20521	315	S6    
20521	315	S7    
20521	315	S8    
20521	315	S9    
20623	315	S1742 
20624	315	S1742 
20628	315	S1742 
20629	315	S1742 
20630	315	S1742 
20634	315	S1742 
20635	315	S1742 
20636	315	S1742 
20640	315	S1742 
20641	315	S1742 
20645	315	S1742 
20646	315	S1742 
21138	315	S1064 
21138	315	S1066 
21138	315	S1122 
21141	315	S1064 
21224	315	S19   
21225	315	S19   
21226	315	S22   
21227	315	S22   
21229	315	S1122 
21238	315	S2801 
21239	315	S1066 
21240	315	S1066 
21241	315	S1066 
21242	315	S1066 
21243	315	S1066 
21244	315	S1066 
21245	315	S1066 
21246	315	S1066 
21247	315	S1066 
21248	315	S1066 
21249	315	S1064 
21250	315	S1064 
21251	315	S1064 
21252	315	S1064 
21253	315	S1064 
21254	315	S1064 
21255	315	S1064 
21256	315	S1064 
21257	315	S1064 
21259	315	S1064 
21260	315	S1082 
21261	315	S1082 
21262	315	S1082 
21263	315	S1082 
21264	315	S1082 
21265	315	S1082 
21266	315	S1082 
21267	315	S1082 
21268	315	S1082 
21269	315	S1082 
21270	315	S1082 
21271	315	S2108 
21272	315	S2108 
21273	315	S2108 
21274	315	S2108 
21275	315	S2108 
21276	315	S2108 
21277	315	S2110 
21278	315	S2110 
21279	315	S2110 
21280	315	S2110 
21281	315	S2110 
21282	315	S2110 
21283	315	S2111 
21284	315	S2111 
21285	315	S2111 
21286	315	S2111 
21287	315	S2112 
21288	315	S2112 
21289	315	S2112 
21290	315	S2112 
21291	315	S2112 
21292	315	S2112 
21293	315	S2782 
21294	315	S2782 
21295	315	S2782 
21296	315	S2782 
21297	315	S2782 
21298	315	S2782 
21299	315	S2110 
21299	315	S2111 
21299	315	S2112 
21299	315	S2782 
21300	315	S2110 
21300	315	S2112 
21300	315	S2782 
21301	315	S2110 
21301	315	S2111 
21301	315	S2112 
21301	315	S2782 
21302	315	S2110 
21302	315	S2111 
21302	315	S2112 
21302	315	S2782 
21303	315	S2110 
21303	315	S2112 
21303	315	S2782 
21304	315	S2110 
21304	315	S2111 
21304	315	S2112 
21304	315	S2782 
21308	315	S2801 
21309	315	S2801 
21310	315	S2801 
21311	315	S2801 
21312	315	S2801 
21313	315	S2801 
21314	315	S2801 
21315	315	S2801 
21316	315	S2801 
21317	315	S2801 
21318	315	S2801 
21319	315	S2801 
21320	315	S2801 
21321	315	S2801 
21322	315	S2801 
21323	315	S2801 
21324	315	S2801 
21325	315	S2801 
21326	315	S2801 
21337	315	S2801 
21343	315	S2801 
21346	315	S2801 
21348	315	S2801 
21349	315	S2801 
22247	315	S20   
22903	315	S21   
22904	315	S18   
22909	315	S22   
22911	315	S18   
22912	315	S19   
22914	315	S19   
22915	315	S19   
22916	315	S19   
23009	315	S2703 
23010	315	S2703 
23011	315	S2703 
23012	315	S2703 
23013	315	S2703 
23014	315	S2703 
23015	315	S2703 
23016	315	S2703 
23017	315	S2703 
23018	315	S2703 
23019	315	S2703 
23020	315	S2703 
23021	315	S2703 
23022	315	S2703 
23023	315	S2703 
23024	315	S2703 
23025	315	S2703 
23027	315	S2703 
23028	315	S2703 
23029	315	S2703 
23030	315	S2703 
23031	315	S2703 
23032	315	S2703 
23033	315	S2703 
23034	315	S2703 
23035	315	S2703 
23036	315	S2703 
23037	315	S2703 
23038	315	S2703 
23039	315	S2703 
23040	315	S2703 
23041	315	S2703 
23042	315	S2703 
23043	315	S2703 
23044	315	S2703 
23045	315	S2703 
23046	315	S2703 
23047	315	S2703 
23048	315	S2703 
23049	315	S2703 
23050	315	S2703 
23051	315	S2703 
23052	315	S2703 
23053	315	S2703 
23054	315	S2703 
23055	315	S2703 
23056	315	S2703 
23057	315	S2703 
23058	315	S2703 
23059	315	S2703 
23060	315	S2703 
23061	315	S2703 
23062	315	S2703 
23063	315	S2703 
23064	315	S2703 
23065	315	S2703 
23557	315	S14   
23558	315	S14   
23559	315	S14   
23560	315	S14   
23561	315	S14   
23562	315	S14   
23563	315	S14   
23564	315	S14   
23565	315	S14   
23566	315	S14   
23567	315	S14   
23568	315	S14   
23569	315	S14   
23570	315	S14   
23571	315	S14   
23572	315	S14   
23573	315	S14   
23574	315	S14   
23575	315	S14   
23576	315	S14   
23577	315	S14   
23578	315	S14   
23579	315	S14   
23580	315	S14   
23581	315	S14   
23582	315	S2    
23583	315	S2    
23584	315	S2    
23585	315	S2    
23586	315	S2    
23587	315	S2    
23588	315	S2    
23589	315	S2    
23590	315	S2    
23591	315	S2    
23592	315	S2    
23593	315	S2    
23594	315	S2    
23595	315	S2    
23596	315	S2    
23597	315	S2    
23598	315	S2    
23599	315	S2    
23600	315	S2    
23601	315	S2    
23602	315	S2    
23603	315	S2    
23604	315	S2    
23605	315	S2    
23606	315	S2    
23607	315	S2    
23608	315	S2    
23609	315	S2    
23610	315	S2    
23611	315	S2    
23612	315	S2    
23613	315	S2    
23614	315	S2    
23615	315	S2    
23616	315	S2    
23617	315	S2    
23618	315	S2    
23619	315	S2    
23620	315	S2    
23621	315	S2    
23622	315	S2    
23623	315	S2    
23624	315	S2    
23625	315	S2    
23626	315	S2    
23627	315	S2    
23628	315	S2    
23629	315	S2    
23630	315	S2    
23631	315	S2    
23632	315	S2    
23633	315	S2    
23634	315	S2    
23635	315	S2    
23636	315	S2    
23637	315	S2    
23638	315	S2    
23640	315	S1581 
23646	315	S2    
23647	315	S2    
23648	315	S2    
23649	315	S2    
23650	315	S2    
23651	315	S2    
23652	315	S2    
23653	315	S2    
23654	315	S2    
23655	315	S2    
23656	315	S2    
23657	315	S2    
23658	315	S2    
23659	315	S2    
23660	315	S2    
35001	315	D4961 
35003	315	D4961 
35015	315	D4961 
35024	315	D4961 
35048	315	D4961 
35051	315	D4961 
35054	315	D4961 
35073	315	D4961 
35078	315	D4961 
35130	315	S2381 
35131	315	S2381 
35132	315	S2381 
35133	315	S2381 
35134	315	S2381 
35135	315	S2381 
35136	315	S2381 
35137	315	S2381 
35138	315	S2381 
35140	315	S2381 
35141	315	S2381 
35142	315	S2381 
35143	315	S2381 
35144	315	S2381 
35145	315	S2381 
35146	315	S2381 
35147	315	S2381 
35148	315	S2381 
42190	315	S243  
43158	315	S2109 
43215	315	S26   
43378	315	S1082 
43514	315	S1067 
01026	317	S25   
01032	317	S19   
01040	317	S10   
01040	317	S11   
01040	317	S12   
01040	317	S6    
01040	317	S7    
01040	317	S8    
01040	317	S9    
01077	317	S10   
01077	317	S11   
01077	317	S12   
01077	317	S27   
01077	317	S6    
01077	317	S7    
01077	317	S8    
01077	317	S9    
01079	317	S10   
01079	317	S1063 
01079	317	S11   
01079	317	S12   
01079	317	S20   
01079	317	S6    
01079	317	S7    
01079	317	S8    
01079	317	S9    
01082	317	S1063 
01085	317	S1063 
01103	317	S1163 
01123	317	S1063 
01124	317	S1065 
01125	317	S1065 
01202	317	S1163 
02009	317	S1069 
04017	317	S19   
04021	317	S19   
04023	317	S19   
04053	317	S19   
04114	317	S19   
04120	317	S19   
04141	317	S19   
04143	317	S19   
04144	317	S19   
04367	317	S19   
04630	317	S19   
04631	317	S20   
04635	317	S19   
04636	317	S19   
04641	317	S25   
05023	317	S1581 
05024	317	S1581 
05027	317	S1082 
05028	317	S1082 
05173	317	S1581 
05174	317	S1581 
05175	317	S1581 
05176	317	S1581 
05177	317	S1581 
05178	317	S1581 
05312	317	S26   
05313	317	S26   
05320	317	S26   
05661	317	S1082 
06016	317	S18   
06019	317	S18   
06043	317	S18   
06094	317	S18   
06128	317	S18   
06159	317	S18   
06164	317	S23   
06931	317	S22   
06982	317	S18   
06983	317	S18   
06984	317	S2104 
06985	317	S2104 
07002	317	S222  
07007	317	S1164 
07015	317	S248  
07016	317	S248  
07022	317	S21   
07039	317	S244  
07056	317	S248  
07063	317	S1164 
07063	317	S582  
07064	317	S1164 
07075	317	S1164 
07241	317	S21   
07931	317	S222  
07938	317	S233  
07939	317	S235  
07945	317	S21   
07952	317	S1164 
07953	317	S1164 
07953	317	S582  
07954	317	S582  
07955	317	S1164 
07956	317	S1164 
07957	317	S1164 
07958	317	S1164 
07959	317	S1164 
07960	317	S1164 
08001	317	D3358 
08001	317	D3359 
08001	317	S1065 
08010	317	S702  
08011	317	S702  
08012	317	S1065 
08013	317	D3357 
08013	317	D3359 
08013	317	S1065 
08014	317	S1065 
08020	317	S1065 
08025	317	S2662 
08030	317	S1065 
08047	317	S702  
08054	317	S702  
08059	317	S702  
08061	317	S1065 
08065	317	S1065 
08065	317	S2662 
08074	317	S2662 
08077	317	S1065 
08147	317	S1065 
08210	317	S702  
08211	317	S702  
08214	317	S702  
08215	317	S702  
08216	317	S702  
08218	317	S1065 
08219	317	S702  
08220	317	S702  
08221	317	S702  
08231	317	S702  
08259	317	S2662 
08293	317	S702  
08317	317	S702  
08351	317	S702  
08352	317	S702  
08353	317	S702  
08360	317	S702  
08361	317	S702  
08362	317	S702  
08383	317	S2664 
08396	317	S702  
08400	317	S881  
08401	317	S881  
08410	317	S702  
08435	317	S1065 
08444	317	S702  
08448	317	S702  
08449	317	S702  
08450	317	S702  
08471	317	S2664 
08504	317	S2662 
08505	317	S2662 
08506	317	S2662 
08507	317	S2662 
08508	317	S2662 
08509	317	S2662 
09003	317	S502  
09003	317	S561  
09021	317	S10   
09021	317	S11   
09021	317	S12   
09021	317	S206  
09021	317	S208  
09021	317	S7    
09021	317	S8    
09021	317	S9    
09037	317	S481  
09037	317	S502  
09038	317	S481  
09038	317	S502  
09040	317	S10   
09040	317	S11   
09040	317	S12   
09040	317	S206  
09040	317	S208  
09040	317	S481  
09040	317	S562  
09040	317	S6    
09040	317	S7    
09040	317	S8    
09040	317	S9    
09042	317	S566  
09050	317	S441  
09070	317	S582  
09078	317	S561  
09087	317	S564  
09087	317	S582  
09094	317	S363  
09112	317	S563  
09132	317	S1062 
09148	317	S363  
09148	317	S582  
09160	317	S1065 
09181	317	S1121 
09184	317	S562  
09191	317	S582  
09202	317	S564  
09218	317	S1065 
09236	317	S582  
09252	317	S541  
09266	317	S441  
09266	317	S561  
09279	317	S582  
09291	317	S564  
09291	317	S566  
09298	317	S564  
09298	317	S566  
09302	317	S566  
09316	317	S566  
09326	317	S441  
09429	317	S441  
09430	317	S561  
09433	317	S2105 
10007	317	S1082 
10066	317	S1082 
10067	317	S1082 
10068	317	S1082 
10098	317	S1581 
10099	317	S1581 
10102	317	S1581 
10119	317	S1581 
10123	317	S1082 
10124	317	S1082 
10173	317	S1581 
10858	317	S1082 
10860	317	S1082 
10861	317	S1082 
10862	317	S1082 
10863	317	S1581 
10864	317	S1082 
11012	317	S1069 
11019	317	S10   
11019	317	S11   
11019	317	S12   
11019	317	S6    
11019	317	S7    
11019	317	S8    
11019	317	S9    
11090	317	S2122 
11090	317	S564  
11091	317	S1121 
11091	317	S564  
11096	317	S1121 
11097	317	S482  
11101	317	S10   
11101	317	S11   
11101	317	S12   
11101	317	S6    
11101	317	S7    
11101	317	S8    
11101	317	S9    
11112	317	S1065 
11113	317	S1065 
11125	317	S1062 
11143	317	S183  
11143	317	S564  
11143	317	S6    
11205	317	S1062 
11206	317	S1062 
11206	317	S183  
11206	317	S201  
11206	317	S202  
11206	317	S203  
11206	317	S6    
11210	317	S10   
11210	317	S11   
11210	317	S12   
11210	317	S6    
11210	317	S7    
11210	317	S8    
11210	317	S9    
11243	317	S2941 
11250	317	S562  
11250	317	S565  
11251	317	S481  
11251	317	S503  
11252	317	S10   
11252	317	S11   
11252	317	S12   
11252	317	S183  
11252	317	S202  
11252	317	S203  
11252	317	S481  
11252	317	S562  
11252	317	S6    
11252	317	S7    
11252	317	S8    
11252	317	S9    
11253	317	S541  
11253	317	S565  
11257	317	S541  
11260	317	D548  
11260	317	S10   
11260	317	S11   
11260	317	S12   
11260	317	S2941 
11260	317	S6    
11260	317	S7    
11260	317	S8    
11260	317	S80   
11260	317	S9    
11263	317	S2941 
11267	317	S2941 
11279	317	S10   
11279	317	S11   
11279	317	S12   
11279	317	S6    
11279	317	S7    
11279	317	S8    
11279	317	S9    
11282	317	S10   
11282	317	S11   
11282	317	S12   
11282	317	S183  
11282	317	S6    
11282	317	S7    
11282	317	S8    
11282	317	S9    
11294	317	S563  
11333	317	S1062 
11333	317	S183  
11333	317	S6    
11353	317	S563  
11356	317	S563  
11429	317	S363  
11463	317	S25   
11464	317	S25   
11468	317	S12   
11468	317	S183  
11468	317	S203  
11508	317	D4142 
11508	317	S10   
11508	317	S1062 
11508	317	S11   
11508	317	S12   
11508	317	S183  
11508	317	S203  
11508	317	S6    
11508	317	S7    
11508	317	S8    
11508	317	S9    
11510	317	S1062 
11529	317	S183  
11529	317	S503  
11529	317	S6    
11540	317	S10   
11540	317	S11   
11540	317	S12   
11540	317	S183  
11540	317	S202  
11540	317	S203  
11540	317	S6    
11540	317	S7    
11540	317	S8    
11540	317	S9    
11546	317	S21   
11565	317	S10   
11565	317	S11   
11565	317	S12   
11565	317	S6    
11565	317	S7    
11565	317	S8    
11565	317	S9    
11674	317	S183  
11674	317	S201  
11674	317	S202  
11674	317	S203  
11674	317	S563  
11705	317	S1069 
11709	317	S10   
11709	317	S11   
11709	317	S12   
11709	317	S6    
11709	317	S7    
11709	317	S8    
11709	317	S9    
11742	317	S1121 
11742	317	S564  
11746	317	S10   
11746	317	S11   
11746	317	S12   
11746	317	S6    
11746	317	S7    
11746	317	S8    
11746	317	S9    
11752	317	S1065 
11757	317	S1062 
11783	317	S10   
11783	317	S11   
11783	317	S12   
11783	317	S6    
11783	317	S7    
11783	317	S8    
11783	317	S9    
11803	317	S10   
11803	317	S11   
11803	317	S12   
11803	317	S6    
11803	317	S7    
11803	317	S8    
11803	317	S9    
11821	317	S1062 
11828	317	S183  
11828	317	S201  
11828	317	S202  
11828	317	S203  
11828	317	S563  
11856	317	S25   
11858	317	S12   
11858	317	S183  
11858	317	S203  
11875	317	D4142 
11875	317	S10   
11875	317	S1062 
11875	317	S11   
11875	317	S12   
11875	317	S183  
11875	317	S203  
11875	317	S6    
11875	317	S7    
11875	317	S8    
11875	317	S9    
11876	317	S1062 
11886	317	S10   
11886	317	S11   
11886	317	S12   
11886	317	S183  
11886	317	S202  
11886	317	S203  
11886	317	S6    
11886	317	S7    
11886	317	S8    
11886	317	S9    
11887	317	S21   
11935	317	S183  
11935	317	S22   
11935	317	S6    
11949	317	S183  
11949	317	S22   
11949	317	S6    
11950	317	S2941 
11960	317	S481  
11960	317	S562  
11987	317	S2941 
11992	317	S2941 
12061	317	S141  
12061	317	S441  
12061	317	S503  
12078	317	S1063 
12078	317	S503  
12086	317	D3358 
12086	317	D3359 
12086	317	S363  
12086	317	S502  
12120	317	S1063 
12120	317	S503  
12142	317	S1121 
12142	317	S363  
12142	317	S85   
12143	317	S85   
12144	317	S85   
12147	317	S564  
12151	317	S86   
12152	317	S563  
12152	317	S565  
12152	317	S86   
12155	317	S481  
12155	317	S563  
12201	317	S1164 
12220	317	S2109 
12586	317	D3358 
12586	317	D3359 
12586	317	S363  
12586	317	S502  
12632	317	S363  
12632	317	S566  
12643	317	S85   
12644	317	S85   
12652	317	S563  
12652	317	S565  
12652	317	S86   
13019	317	S2    
13020	317	S2    
13039	317	S221  
13055	317	S2    
13065	317	S2    
13067	317	S2    
13068	317	S2    
13070	317	S2    
13096	317	S2    
13098	317	S2    
13165	317	S2    
13231	317	S221  
13232	317	S221  
13235	317	S221  
13236	317	S221  
13318	317	S1581 
13320	317	S1581 
13321	317	S1581 
13322	317	S1581 
13323	317	S1581 
13324	317	S1581 
13325	317	S1082 
13326	317	S1082 
13327	317	S1082 
13340	317	S1581 
13341	317	S1581 
13343	317	S2    
13369	317	S2    
13370	317	S2    
13373	317	S2    
13375	317	S2    
13377	317	S2    
13378	317	S2    
13391	317	S2    
13394	317	S2    
13398	317	S2    
13399	317	S2    
13401	317	S2    
13402	317	S2    
13404	317	S2    
13405	317	S2    
13407	317	S2    
13408	317	S2    
13410	317	S2    
13411	317	S2    
13413	317	S2    
13414	317	S2    
13415	317	S2    
13416	317	S2    
13417	317	S2    
13418	317	S2    
13419	317	S2    
13420	317	S2    
13421	317	S2    
13422	317	S2    
13423	317	S2    
13424	317	S2    
13425	317	S2    
13426	317	S2    
13439	317	S2    
13440	317	S2    
13441	317	S2    
13442	317	S2    
13443	317	S2    
13444	317	S2    
13445	317	S2    
13446	317	S2    
13447	317	S2    
13448	317	S2    
13449	317	S2    
13450	317	S2    
13451	317	S2    
13452	317	S2    
13453	317	S2    
13454	317	S2    
13455	317	S2    
13456	317	S2    
13467	317	S221  
13468	317	S221  
13469	317	S221  
13470	317	S221  
13481	317	S221  
13482	317	S221  
13483	317	S221  
13484	317	S221  
13485	317	S2    
13486	317	S2    
13487	317	S2    
13488	317	S2    
13490	317	S2    
13491	317	S2    
13492	317	S2    
13493	317	S2    
13494	317	S14   
13495	317	S14   
13496	317	S14   
13497	317	S14   
13498	317	S14   
13565	317	S2703 
13566	317	S2703 
13567	317	S2703 
13568	317	S2703 
13569	317	S2703 
13805	317	S2    
13806	317	S2    
13809	317	S2    
13810	317	S2    
13811	317	S2    
13812	317	S2    
13813	317	S2    
13814	317	S2    
13850	317	S2    
13851	317	S2    
13853	317	S2    
13854	317	S2    
13856	317	S2    
13857	317	S2    
13868	317	S2    
13869	317	S2    
13870	317	S2    
13871	317	S2    
13872	317	S2    
13873	317	S2    
13874	317	S2    
13875	317	S2    
13876	317	S2    
13877	317	S2    
13878	317	S2    
13879	317	S2    
13880	317	S2    
13881	317	S2    
13882	317	S2    
13891	317	S2    
13893	317	S2    
13894	317	S2    
13896	317	S2    
13898	317	S2    
13900	317	S2    
13909	317	S2    
13910	317	S2    
13911	317	S2    
13912	317	S2    
13913	317	S2    
13914	317	S2    
13917	317	S2    
13918	317	S2    
13920	317	S2    
13921	317	S2    
13923	317	S2    
13924	317	S2    
13929	317	S2    
13930	317	S2    
13931	317	S2    
13932	317	S2    
13934	317	S2    
13935	317	S2    
13936	317	S221  
13937	317	S221  
13938	317	S221  
13939	317	S221  
13940	317	S221  
13941	317	S221  
13942	317	S221  
13943	317	S221  
13944	317	S221  
13945	317	S221  
13946	317	S221  
13947	317	S221  
13948	317	S2    
13949	317	S2    
13950	317	S2    
13951	317	S2    
13952	317	S2    
13953	317	S2    
13954	317	S2    
13955	317	S2    
13956	317	S2    
13957	317	S2    
13958	317	S2    
13959	317	S2    
13960	317	S221  
13962	317	S221  
13964	317	S221  
13965	317	S221  
13966	317	S221  
13967	317	S221  
13968	317	S2    
13969	317	S2    
13970	317	S2    
13971	317	S2    
13985	317	S2    
13987	317	S221  
13988	317	S2703 
13989	317	S2703 
13990	317	S2703 
13991	317	S2703 
13992	317	S2703 
13994	317	S2703 
13995	317	S2703 
13996	317	S2703 
13997	317	S2703 
13998	317	S2703 
14003	317	S2103 
14006	317	S2103 
14052	317	S10   
14052	317	S11   
14052	317	S12   
14052	317	S6    
14052	317	S7    
14052	317	S8    
14052	317	S9    
14084	317	S2103 
14096	317	S2103 
14106	317	S2103 
14149	317	S10   
14149	317	S11   
14149	317	S12   
14149	317	S6    
14149	317	S7    
14149	317	S8    
14149	317	S9    
14192	317	D3364 
14209	317	S1064 
14209	317	S1066 
14209	317	S1122 
14209	317	S23   
14219	317	S10   
14219	317	S11   
14219	317	S12   
14219	317	S6    
14219	317	S7    
14219	317	S8    
14219	317	S9    
14238	317	S2104 
14267	317	S10   
14267	317	S11   
14267	317	S12   
14267	317	S6    
14267	317	S7    
14267	317	S8    
14267	317	S9    
14347	317	S1064 
14400	317	S10   
14400	317	S11   
14400	317	S12   
14400	317	S6    
14400	317	S7    
14400	317	S8    
14400	317	S9    
14416	317	S10   
14416	317	S11   
14416	317	S12   
14416	317	S6    
14416	317	S7    
14416	317	S8    
14416	317	S9    
14601	317	S1066 
14602	317	S2103 
15027	317	S10   
15027	317	S11   
15027	317	S1163 
15027	317	S12   
15027	317	S9    
15073	317	S1163 
15087	317	S2109 
15152	317	S2104 
15232	317	S1163 
15260	317	S2109 
15261	317	S1163 
15262	317	S1163 
16006	317	S1164 
16010	317	S1164 
16011	317	S1164 
16028	317	S10   
16028	317	S11   
16028	317	S12   
16028	317	S182  
16028	317	S183  
16028	317	S203  
16028	317	S6    
16028	317	S7    
16028	317	S8    
16028	317	S9    
16029	317	S1164 
16038	317	S1164 
16038	317	S203  
16042	317	S1065 
16043	317	S10   
16043	317	S1065 
16043	317	S11   
16043	317	S12   
16043	317	S182  
16043	317	S183  
16043	317	S203  
16043	317	S6    
16043	317	S7    
16043	317	S8    
16043	317	S9    
16089	317	S563  
16097	317	S22   
16098	317	S10   
16098	317	S11   
16098	317	S12   
16098	317	S182  
16098	317	S183  
16098	317	S203  
16098	317	S22   
16098	317	S6    
16098	317	S7    
16098	317	S8    
16098	317	S9    
16112	317	S39   
16114	317	S39   
16120	317	S39   
16123	317	D3359 
16123	317	S2122 
16123	317	S39   
16126	317	S39   
16139	317	S39   
16147	317	S2104 
16159	317	D342  
16159	317	S39   
16167	317	S2203 
16174	317	S18   
16338	317	S1164 
16338	317	S203  
16343	317	S10   
16343	317	S1065 
16343	317	S11   
16343	317	S12   
16343	317	S182  
16343	317	S183  
16343	317	S203  
16343	317	S6    
16343	317	S7    
16343	317	S8    
16343	317	S9    
16397	317	S22   
16398	317	S10   
16398	317	S11   
16398	317	S12   
16398	317	S182  
16398	317	S183  
16398	317	S203  
16398	317	S22   
16398	317	S6    
16398	317	S7    
16398	317	S8    
16398	317	S9    
17202	317	S1082 
17203	317	S1082 
17204	317	S1082 
17218	317	S1581 
17219	317	S1581 
17345	317	S3    
17346	317	S3    
17347	317	S3    
17348	317	S3    
18001	317	S1162 
18002	317	S1162 
18069	317	S20   
18079	317	S25   
18159	317	S21   
18166	317	S25   
18168	317	S25   
18215	317	S25   
18228	317	S23   
18231	317	S25   
18258	317	S1162 
18259	317	S1162 
18262	317	S1162 
18263	317	S1162 
18288	317	S27   
18350	317	S21   
18363	317	S22   
18364	317	S22   
18365	317	S27   
18376	317	S25   
18403	317	S27   
18927	317	S25   
18930	317	S2203 
18931	317	S2203 
18932	317	S27   
18933	317	S27   
18934	317	S27   
18935	317	S27   
18936	317	S27   
19034	317	S26   
19035	317	S26   
19047	317	S1162 
19057	317	S2109 
19058	317	S2109 
19064	317	S1164 
19076	317	S1164 
19078	317	S1069 
19088	317	S10   
19088	317	S11   
19088	317	S12   
19088	317	S6    
19088	317	S7    
19088	317	S8    
19088	317	S9    
19095	317	S10   
19095	317	S11   
19095	317	S12   
19095	317	S6    
19095	317	S7    
19095	317	S8    
19095	317	S9    
19109	317	S1164 
19120	317	S10   
19120	317	S1069 
19120	317	S11   
19120	317	S12   
19120	317	S6    
19120	317	S7    
19120	317	S8    
19120	317	S9    
19129	317	D3364 
19129	317	S10   
19129	317	S11   
19129	317	S12   
19129	317	S6    
19129	317	S7    
19129	317	S8    
19129	317	S9    
19155	317	S1164 
19230	317	S1063 
19283	317	S10   
19283	317	S11   
19283	317	S12   
19283	317	S6    
19283	317	S7    
19283	317	S8    
19283	317	S9    
19300	317	D3359 
19300	317	S10   
19300	317	S11   
19300	317	S12   
19300	317	S6    
19300	317	S7    
19300	317	S8    
19300	317	S9    
19334	317	D3357 
19334	317	D3364 
19349	317	D3359 
19355	317	D3358 
20046	317	S20   
20047	317	S20   
20047	317	S2123 
20048	317	S20   
20049	317	S2123 
20099	317	D3358 
20099	317	D3359 
20099	317	S1163 
20100	317	S10   
20100	317	S11   
20100	317	S1163 
20100	317	S12   
20100	317	S20   
20100	317	S206  
20100	317	S208  
20100	317	S2682 
20100	317	S2683 
20100	317	S2684 
20100	317	S6    
20100	317	S7    
20100	317	S8    
20100	317	S9    
20109	317	S2105 
20110	317	S10   
20110	317	S11   
20110	317	S12   
20110	317	S206  
20110	317	S208  
20110	317	S2105 
20110	317	S2682 
20110	317	S2683 
20110	317	S2684 
20110	317	S6    
20110	317	S7    
20110	317	S8    
20110	317	S9    
20120	317	D3358 
20120	317	D3359 
20120	317	S1163 
20121	317	S10   
20121	317	S11   
20121	317	S1163 
20121	317	S12   
20121	317	S20   
20121	317	S206  
20121	317	S208  
20121	317	S2682 
20121	317	S2683 
20121	317	S2684 
20121	317	S6    
20121	317	S7    
20121	317	S8    
20121	317	S9    
20310	317	S10   
20310	317	S11   
20310	317	S12   
20310	317	S206  
20310	317	S208  
20310	317	S2105 
20310	317	S2682 
20310	317	S2683 
20310	317	S2684 
20310	317	S6    
20310	317	S7    
20310	317	S8    
20310	317	S9    
20321	317	S10   
20321	317	S11   
20321	317	S1163 
20321	317	S12   
20321	317	S20   
20321	317	S206  
20321	317	S208  
20321	317	S2682 
20321	317	S2683 
20321	317	S2684 
20321	317	S6    
20321	317	S7    
20321	317	S8    
20321	317	S9    
20400	317	S10   
20400	317	S11   
20400	317	S1163 
20400	317	S12   
20400	317	S20   
20400	317	S206  
20400	317	S208  
20400	317	S2682 
20400	317	S2683 
20400	317	S2684 
20400	317	S6    
20400	317	S7    
20400	317	S8    
20400	317	S9    
20409	317	S2105 
20410	317	S10   
20410	317	S11   
20410	317	S12   
20410	317	S206  
20410	317	S208  
20410	317	S2105 
20410	317	S2682 
20410	317	S2683 
20410	317	S2684 
20410	317	S6    
20410	317	S7    
20410	317	S8    
20410	317	S9    
20420	317	D3358 
20420	317	D3359 
20420	317	S1163 
20421	317	S10   
20421	317	S11   
20421	317	S1163 
20421	317	S12   
20421	317	S20   
20421	317	S206  
20421	317	S208  
20421	317	S2682 
20421	317	S2683 
20421	317	S2684 
20421	317	S6    
20421	317	S7    
20421	317	S8    
20421	317	S9    
20446	317	S20   
20447	317	S20   
20447	317	S2123 
20499	317	D3358 
20499	317	D3359 
20499	317	S1163 
20510	317	S10   
20510	317	S11   
20510	317	S12   
20510	317	S206  
20510	317	S208  
20510	317	S2105 
20510	317	S2682 
20510	317	S2683 
20510	317	S2684 
20510	317	S6    
20510	317	S7    
20510	317	S8    
20510	317	S9    
20521	317	S10   
20521	317	S11   
20521	317	S1163 
20521	317	S12   
20521	317	S20   
20521	317	S206  
20521	317	S208  
20521	317	S2682 
20521	317	S2683 
20521	317	S2684 
20521	317	S6    
20521	317	S7    
20521	317	S8    
20521	317	S9    
20623	317	S1742 
20624	317	S1742 
20628	317	S1742 
20629	317	S1742 
20630	317	S1742 
20634	317	S1742 
20635	317	S1742 
20636	317	S1742 
20640	317	S1742 
20641	317	S1742 
20645	317	S1742 
20646	317	S1742 
21138	317	S1064 
21138	317	S1066 
21138	317	S1122 
21141	317	S1064 
21224	317	S19   
21225	317	S19   
21226	317	S22   
21227	317	S22   
21229	317	S1122 
21239	317	S1066 
21240	317	S1066 
21241	317	S1066 
21242	317	S1066 
21243	317	S1066 
21244	317	S1066 
21245	317	S1066 
21246	317	S1066 
21247	317	S1066 
21248	317	S1066 
21249	317	S1064 
21250	317	S1064 
21251	317	S1064 
21252	317	S1064 
21253	317	S1064 
21254	317	S1064 
21255	317	S1064 
21256	317	S1064 
21257	317	S1064 
21259	317	S1064 
21260	317	S1082 
21261	317	S1082 
21262	317	S1082 
21263	317	S1082 
21264	317	S1082 
21265	317	S1082 
21266	317	S1082 
21267	317	S1082 
21268	317	S1082 
21269	317	S1082 
21270	317	S1082 
21271	317	S2108 
21272	317	S2108 
21273	317	S2108 
21274	317	S2108 
21275	317	S2108 
21276	317	S2108 
21277	317	S2110 
21278	317	S2110 
21279	317	S2110 
21280	317	S2110 
21281	317	S2110 
21282	317	S2110 
21283	317	S2111 
21284	317	S2111 
21285	317	S2111 
21286	317	S2111 
21287	317	S2112 
21288	317	S2112 
21289	317	S2112 
21290	317	S2112 
21291	317	S2112 
21292	317	S2112 
21293	317	S2782 
21294	317	S2782 
21295	317	S2782 
21296	317	S2782 
21297	317	S2782 
21298	317	S2782 
21299	317	S2110 
21299	317	S2111 
21299	317	S2112 
21299	317	S2782 
21300	317	S2110 
21300	317	S2112 
21300	317	S2782 
21301	317	S2110 
21301	317	S2111 
21301	317	S2112 
21301	317	S2782 
21302	317	S2110 
21302	317	S2111 
21302	317	S2112 
21302	317	S2782 
21303	317	S2110 
21303	317	S2112 
21303	317	S2782 
21304	317	S2110 
21304	317	S2111 
21304	317	S2112 
21304	317	S2782 
21346	317	S2801 
21347	317	S2801 
21348	317	S2801 
21349	317	S2801 
22247	317	S20   
22903	317	S21   
22904	317	S18   
22909	317	S22   
22911	317	S18   
22912	317	S19   
22914	317	S19   
22915	317	S19   
22916	317	S19   
23009	317	S2703 
23010	317	S2703 
23011	317	S2703 
23012	317	S2703 
23013	317	S2703 
23014	317	S2703 
23015	317	S2703 
23016	317	S2703 
23017	317	S2703 
23018	317	S2703 
23019	317	S2703 
23020	317	S2703 
23021	317	S2703 
23022	317	S2703 
23023	317	S2703 
23024	317	S2703 
23025	317	S2703 
23027	317	S2703 
23028	317	S2703 
23029	317	S2703 
23030	317	S2703 
23031	317	S2703 
23032	317	S2703 
23033	317	S2703 
23034	317	S2703 
23035	317	S2703 
23036	317	S2703 
23037	317	S2703 
23038	317	S2703 
23039	317	S2703 
23040	317	S2703 
23041	317	S2703 
23042	317	S2703 
23043	317	S2703 
23044	317	S2703 
23045	317	S2703 
23046	317	S2703 
23047	317	S2703 
23048	317	S2703 
23049	317	S2703 
23050	317	S2703 
23051	317	S2703 
23052	317	S2703 
23053	317	S2703 
23054	317	S2703 
23055	317	S2703 
23056	317	S2703 
23057	317	S2703 
23058	317	S2703 
23059	317	S2703 
23060	317	S2703 
23061	317	S2703 
23062	317	S2703 
23063	317	S2703 
23064	317	S2703 
23065	317	S2703 
23557	317	S14   
23558	317	S14   
23559	317	S14   
23560	317	S14   
23561	317	S14   
23562	317	S14   
23563	317	S14   
23564	317	S14   
23565	317	S14   
23566	317	S14   
23567	317	S14   
23568	317	S14   
23569	317	S14   
23570	317	S14   
23571	317	S14   
23572	317	S14   
23573	317	S14   
23574	317	S14   
23575	317	S14   
23576	317	S14   
23577	317	S14   
23578	317	S14   
23579	317	S14   
23580	317	S14   
23581	317	S14   
23582	317	S2    
23583	317	S2    
23584	317	S2    
23585	317	S2    
23586	317	S2    
23587	317	S2    
23588	317	S2    
23589	317	S2    
23590	317	S2    
23591	317	S2    
23592	317	S2    
23593	317	S2    
23594	317	S2    
23595	317	S2    
23596	317	S2    
23597	317	S2    
23598	317	S2    
23599	317	S2    
23600	317	S2    
23601	317	S2    
23602	317	S2    
23603	317	S2    
23604	317	S2    
23605	317	S2    
23606	317	S2    
23607	317	S2    
23608	317	S2    
23609	317	S2    
23610	317	S2    
23611	317	S2    
23612	317	S2    
23613	317	S2    
23614	317	S2    
23615	317	S2    
23616	317	S2    
23617	317	S2    
23618	317	S2    
23619	317	S2    
23620	317	S2    
23621	317	S2    
23622	317	S2    
23623	317	S2    
23624	317	S2    
23625	317	S2    
23626	317	S2    
23627	317	S2    
23628	317	S2    
23629	317	S2    
23630	317	S2    
23631	317	S2    
23632	317	S2    
23633	317	S2    
23634	317	S2    
23635	317	S2    
23636	317	S2    
23637	317	S2    
23638	317	S2    
23640	317	S1581 
23646	317	S2    
23647	317	S2    
23648	317	S2    
23649	317	S2    
23650	317	S2    
23651	317	S2    
23652	317	S2    
23653	317	S2    
23654	317	S2    
23655	317	S2    
23656	317	S2    
23657	317	S2    
23658	317	S2    
23659	317	S2    
23660	317	S2    
35130	317	S2381 
35131	317	S2381 
35132	317	S2381 
35137	317	S2381 
35140	317	S2381 
35141	317	S2381 
35142	317	S2381 
35143	317	S2381 
35144	317	S2381 
35145	317	S2381 
35146	317	S2381 
35147	317	S2381 
35148	317	S2381 
43378	317	S1082 
02009	318	S1069 
02010	318	S1069 
02020	318	S1069 
02026	318	S1069 
02029	318	S1069 
02030	318	S1069 
02033	318	S1069 
02043	318	S1069 
02049	318	S405  
02054	318	S1202 
04673	318	S2401 
04674	318	S2401 
04675	318	S2401 
04676	318	S2401 
04677	318	S2401 
05626	318	D4281 
05628	318	D4281 
07002	318	S222  
07005	318	S248  
07006	318	S247  
07008	318	S238  
07011	318	S227  
07013	318	S242  
07013	318	S281  
07015	318	S248  
07016	318	S248  
07018	318	S226  
07023	318	S242  
07027	318	S281  
07028	318	S281  
07029	318	S281  
07032	318	S281  
07039	318	S244  
07052	318	S227  
07056	318	S248  
07057	318	S281  
07058	318	S237  
07070	318	S238  
07072	318	S281  
07079	318	S227  
07080	318	S227  
07083	318	S281  
07089	318	S241  
07089	318	S251  
07201	318	S281  
07202	318	S281  
07205	318	S281  
07209	318	S281  
07211	318	S281  
07212	318	S281  
07213	318	S281  
07233	318	S281  
07240	318	S281  
07242	318	S281  
07276	318	S259  
07276	318	S281  
07278	318	S259  
07279	318	S259  
07905	318	S281  
07906	318	S281  
07908	318	S281  
07909	318	S259  
07910	318	S245  
07911	318	S226  
07912	318	S226  
07913	318	S238  
07915	318	S281  
07916	318	S242  
07918	318	S242  
07919	318	S252  
07920	318	S242  
07921	318	S228  
07922	318	S242  
07923	318	S245  
07924	318	S242  
07925	318	S281  
07927	318	S227  
07929	318	S227  
07930	318	S222  
07931	318	S222  
07932	318	S224  
07933	318	S224  
07934	318	S281  
07935	318	S224  
07936	318	S247  
07937	318	S239  
07938	318	S233  
07939	318	S235  
07941	318	S281  
07942	318	S281  
07943	318	S281  
07944	318	S227  
07951	318	S243  
08001	318	S2664 
08003	318	S2664 
08005	318	S2664 
08010	318	S702  
08012	318	S702  
08013	318	S603  
08014	318	S2664 
08017	318	S603  
08018	318	S702  
08023	318	S2664 
08026	318	S603  
08028	318	S2664 
08030	318	S2664 
08032	318	S2664 
08035	318	S603  
08045	318	S603  
08049	318	S702  
08050	318	S603  
08054	318	S702  
08057	318	S603  
08058	318	S2664 
08059	318	S702  
08060	318	S2664 
08064	318	S603  
08066	318	S702  
08067	318	S2664 
08069	318	S2664 
08071	318	S2664 
08077	318	S603  
08078	318	S603  
08082	318	S603  
08085	318	S702  
08086	318	S603  
08087	318	S603  
08089	318	S603  
08092	318	S702  
08116	318	S2502 
08120	318	D3921 
08124	318	S702  
08128	318	S702  
08130	318	S702  
08138	318	S2502 
08139	318	S603  
08146	318	S702  
08147	318	S2422 
08189	318	S2664 
08190	318	S603  
08202	318	S603  
08210	318	S702  
08211	318	S702  
08212	318	S702  
08214	318	S702  
08215	318	S702  
08216	318	S702  
08217	318	S2664 
08218	318	S702  
08219	318	S702  
08220	318	S702  
08221	318	S702  
08225	318	S702  
08229	318	S702  
08231	318	S702  
08232	318	S702  
08243	318	S603  
08245	318	S603  
08247	318	S603  
08253	318	S2664 
08258	318	S2664 
08261	318	S603  
08262	318	S603  
08263	318	S603  
08266	318	S603  
08267	318	S603  
08269	318	S603  
08272	318	S603  
08274	318	S603  
08277	318	S603  
08278	318	S603  
08283	318	S2664 
08284	318	S2664 
08286	318	S2664 
08288	318	S2664 
08293	318	S702  
08299	318	S702  
08315	318	S702  
08316	318	S702  
08317	318	S702  
08318	318	S2664 
08345	318	S603  
08348	318	S2502 
08349	318	S2502 
08350	318	S2502 
08351	318	S702  
08352	318	S702  
08353	318	S702  
08354	318	S702  
08355	318	S702  
08357	318	S702  
08358	318	S702  
08359	318	S702  
08360	318	S702  
08361	318	S702  
08362	318	S702  
08363	318	S702  
08364	318	S702  
08366	318	S702  
08367	318	S603  
08368	318	S603  
08370	318	S603  
08371	318	S603  
08372	318	S603  
08374	318	S2664 
08376	318	S2664 
08380	318	S2664 
08383	318	S2664 
08385	318	S2664 
08386	318	S2664 
08387	318	S2664 
08389	318	S2664 
08390	318	S2664 
08392	318	S2664 
08393	318	S2664 
08394	318	S702  
08395	318	S702  
08396	318	S702  
08397	318	S603  
08398	318	S603  
08399	318	S603  
08400	318	S881  
08401	318	S881  
08402	318	S702  
08408	318	S2502 
08409	318	S2502 
08410	318	S702  
08411	318	S702  
08412	318	S702  
08413	318	S702  
08414	318	S702  
08415	318	S702  
08416	318	S702  
08417	318	S702  
08418	318	S702  
08419	318	S702  
08420	318	S702  
08421	318	S702  
08422	318	S702  
08436	318	S702  
08444	318	S702  
08446	318	S702  
08448	318	S702  
08449	318	S702  
08450	318	S702  
08454	318	S2664 
08455	318	S2664 
08456	318	S2664 
08457	318	S2664 
08458	318	S2664 
08460	318	S2664 
08461	318	S2664 
08465	318	S2664 
08466	318	S2664 
08468	318	S2664 
08470	318	S2664 
08471	318	S2664 
08473	318	S2664 
08474	318	S2664 
08476	318	S2502 
08478	318	S2502 
08481	318	S2502 
08482	318	S2502 
08483	318	S2502 
08484	318	S2502 
08487	318	S2502 
08488	318	S2502 
08489	318	S2502 
08490	318	S2502 
08491	318	S2502 
08492	318	S2502 
08493	318	S2502 
08494	318	S2502 
08495	318	S2502 
08498	318	S2502 
08500	318	S2502 
08501	318	S2502 
09003	318	S502  
09003	318	S561  
09004	318	S502  
09021	318	D3887 
09021	318	D3924 
09021	318	D3949 
09032	318	S21   
09037	318	S1031 
09037	318	S1621 
09037	318	S381  
09037	318	S481  
09037	318	S502  
09037	318	S986  
09038	318	S1031 
09038	318	S1621 
09038	318	S502  
09038	318	S986  
09039	318	S381  
09040	318	S1023 
09040	318	S481  
09040	318	S562  
09042	318	S461  
09042	318	S566  
09050	318	S1141 
09050	318	S421  
09050	318	S441  
09059	318	D3899 
09060	318	S381  
09062	318	S381  
09070	318	S53   
09070	318	S582  
09078	318	S561  
09079	318	S1701 
09084	318	D3919 
09087	318	S564  
09087	318	S582  
09094	318	S363  
09094	318	S582  
09148	318	S1033 
09148	318	S363  
09148	318	S582  
09149	318	D3899 
09160	318	S1065 
09177	318	S1202 
09183	318	S381  
09184	318	S1026 
09184	318	S562  
09184	318	S565  
09195	318	D3919 
09195	318	S1202 
09195	318	S1562 
09200	318	D3887 
09200	318	S1203 
09200	318	S482  
09202	318	S1203 
09202	318	S482  
09215	318	D3848 
09215	318	S1203 
09215	318	S23   
09218	318	S1161 
09218	318	S1203 
09221	318	D3849 
09224	318	D3912 
09231	318	D3899 
09236	318	D3887 
09236	318	D3904 
09236	318	S1203 
09236	318	S461  
09236	318	S582  
09252	318	S1206 
09252	318	S482  
09252	318	S541  
09264	318	D3899 
09266	318	S1167 
09266	318	S441  
09266	318	S561  
09279	318	S421  
09279	318	S582  
09287	318	D3899 
09287	318	S1202 
09291	318	S1341 
09291	318	S564  
09291	318	S566  
09295	318	D3899 
09298	318	S564  
09298	318	S566  
09301	318	S1202 
09307	318	D3919 
09316	318	S421  
09316	318	S566  
09316	318	S581  
09326	318	S1027 
09326	318	S441  
09326	318	S461  
09351	318	S1203 
09370	318	D3843 
09370	318	D3904 
09370	318	D3912 
09421	318	S564  
09421	318	S582  
09422	318	S1202 
09427	318	D4053 
09428	318	D4053 
09429	318	S1167 
09429	318	S441  
09430	318	S441  
09430	318	S561  
11090	318	S619  
11124	318	D5261 
11209	318	S615  
11252	318	S624  
11333	318	S611  
11355	318	S566  
11429	318	S617  
11529	318	S608  
11531	318	S625  
11531	318	S626  
11531	318	S627  
11531	318	S641  
11533	318	S625  
11533	318	S626  
11533	318	S627  
11533	318	S641  
11546	318	S625  
11546	318	S626  
11546	318	S627  
11546	318	S641  
11547	318	S625  
11547	318	S626  
11547	318	S627  
11547	318	S641  
11887	318	S625  
11887	318	S626  
11887	318	S627  
11887	318	S641  
11888	318	S625  
11888	318	S626  
11888	318	S627  
11888	318	S641  
12038	318	S1202 
12038	318	S661  
12071	318	S1202 
12078	318	S503  
12122	318	S83   
12152	318	S563  
12152	318	S565  
12152	318	S86   
12154	318	S941  
12155	318	S481  
12155	318	S563  
12155	318	S79   
12220	318	S1221 
12220	318	S2109 
12538	318	S1202 
12538	318	S661  
12652	318	S563  
12652	318	S565  
12652	318	S86   
16114	318	S39   
20017	318	S1343 
20022	318	S1203 
20077	318	D3921 
20081	318	S20   
20083	318	S20   
20084	318	S20   
20130	318	D3921 
20130	318	S1202 
20322	318	S1343 
20581	318	S20   
21309	318	S2801 
21343	318	S2801 
21346	318	S2801 
21347	318	S2801 
21348	318	S2801 
21349	318	S2801 
35001	318	D4961 
35002	318	D4961 
35003	318	D4961 
35004	318	D4961 
35008	318	D4961 
35013	318	D4961 
35014	318	D4961 
35016	318	D4961 
35017	318	D4961 
35021	318	D4961 
35022	318	D4961 
35023	318	D4961 
35024	318	D4961 
35025	318	D4961 
35026	318	D4961 
35027	318	D4961 
35029	318	D4961 
35030	318	D4961 
35034	318	D4961 
35038	318	D4961 
35039	318	D4961 
35041	318	D4961 
35042	318	D4961 
35043	318	D4961 
35046	318	D4961 
35047	318	D4961 
35048	318	D4961 
35050	318	D4961 
35051	318	D4961 
35054	318	D4961 
35055	318	D4961 
35056	318	D4961 
35057	318	D4961 
35059	318	D4961 
35060	318	D4961 
35063	318	D4961 
35064	318	D4961 
35065	318	D4961 
35066	318	D4961 
35067	318	D4961 
35068	318	D4961 
35070	318	D4961 
35071	318	D4961 
35072	318	D4961 
35073	318	D4961 
35074	318	D4961 
35075	318	D4961 
35078	318	D4961 
35079	318	D4961 
35080	318	D4961 
35081	318	D4961 
35082	318	D4961 
35083	318	D4961 
35084	318	D4961 
35086	318	D4961 
35087	318	D4961 
35088	318	D4961 
35089	318	D4961 
35090	318	D4961 
35093	318	D4961 
42161	318	S281  
42190	318	S281  
01103	319	S1163 
01123	319	S1063 
01123	319	S561  
01202	319	S1163 
05023	319	S1581 
05024	319	S1581 
05027	319	S1082 
05028	319	S1082 
05173	319	S1581 
05174	319	S1581 
05175	319	S1581 
05176	319	S1581 
05177	319	S1581 
05178	319	S1581 
05312	319	S26   
05313	319	S26   
05320	319	S26   
05626	319	D4281 
05627	319	D4282 
05628	319	D4281 
05629	319	D4281 
05661	319	S1082 
07002	319	S222  
07007	319	S1164 
07052	319	S227  
07058	319	S237  
07063	319	S1164 
07063	319	S582  
07064	319	S1164 
07075	319	S1164 
07079	319	S227  
07089	319	S251  
07911	319	S226  
07952	319	S1164 
07953	319	S1164 
07953	319	S582  
07954	319	S582  
07955	319	S1164 
07956	319	S1164 
07957	319	S1164 
07958	319	S1164 
07959	319	S1164 
07960	319	S1164 
08025	319	S2662 
08065	319	S2662 
08074	319	S2662 
08147	319	S2422 
08259	319	S2662 
08504	319	S2662 
08505	319	S2662 
08506	319	S2662 
08507	319	S2662 
08508	319	S2662 
08509	319	S2662 
10007	319	S1082 
10066	319	S1082 
10067	319	S1082 
10068	319	S1082 
10098	319	S1581 
10099	319	S1581 
10102	319	S1581 
10119	319	S1581 
10123	319	S1082 
10124	319	S1082 
10173	319	S1581 
10858	319	S1082 
10860	319	S1082 
10861	319	S1082 
10862	319	S1082 
10863	319	S1581 
10864	319	S1082 
12038	319	S661  
12538	319	S661  
13019	319	S2    
13020	319	S2    
13055	319	S2    
13065	319	S2    
13067	319	S2    
13068	319	S2    
13070	319	S2    
13096	319	S2    
13098	319	S2    
13165	319	S2    
13318	319	S1581 
13320	319	S1581 
13321	319	S1581 
13322	319	S1581 
13323	319	S1581 
13324	319	S1581 
13325	319	S1082 
13326	319	S1082 
13327	319	S1082 
13340	319	S1581 
13341	319	S1581 
13343	319	S2    
13369	319	S2    
13370	319	S2    
13373	319	S2    
13375	319	S2    
13377	319	S2    
13378	319	S2    
13391	319	S2    
13394	319	S2    
13398	319	S2    
13399	319	S2    
13401	319	S2    
13402	319	S2    
13404	319	S2    
13405	319	S2    
13407	319	S2    
13408	319	S2    
13410	319	S2    
13411	319	S2    
13413	319	S2    
13414	319	S2    
13415	319	S2    
13416	319	S2    
13417	319	S2    
13418	319	S2    
13419	319	S2    
13420	319	S2    
13421	319	S2    
13422	319	S2    
13423	319	S2    
13424	319	S2    
13425	319	S2    
13426	319	S2    
13439	319	S2    
13440	319	S2    
13441	319	S2    
13442	319	S2    
13443	319	S2    
13444	319	S2    
13445	319	S2    
13446	319	S2    
13447	319	S2    
13448	319	S2    
13449	319	S2    
13450	319	S2    
13451	319	S2    
13452	319	S2    
13453	319	S2    
13454	319	S2    
13455	319	S2    
13456	319	S2    
13485	319	S2    
13486	319	S2    
13487	319	S2    
13488	319	S2    
13490	319	S2    
13491	319	S2    
13492	319	S2    
13493	319	S2    
13494	319	S14   
13495	319	S14   
13496	319	S14   
13497	319	S14   
13498	319	S14   
13565	319	S2703 
13566	319	S2703 
13567	319	S2703 
13805	319	S2    
13806	319	S2    
13809	319	S2    
13810	319	S2    
13811	319	S2    
13812	319	S2    
13813	319	S2    
13814	319	S2    
13850	319	S2    
13851	319	S2    
13853	319	S2    
13854	319	S2    
13856	319	S2    
13857	319	S2    
13868	319	S2    
13869	319	S2    
13870	319	S2    
13871	319	S2    
13872	319	S2    
13873	319	S2    
13874	319	S2    
13875	319	S2    
13876	319	S2    
13877	319	S2    
13878	319	S2    
13879	319	S2    
13880	319	S2    
13881	319	S2    
13882	319	S2    
13891	319	S2    
13893	319	S2    
13894	319	S2    
13896	319	S2    
13898	319	S2    
13900	319	S2    
13909	319	S2    
13910	319	S2    
13911	319	S2    
13912	319	S2    
13913	319	S2    
13914	319	S2    
13917	319	S2    
13918	319	S2    
13920	319	S2    
13921	319	S2    
13923	319	S2    
13924	319	S2    
13929	319	S2    
13930	319	S2    
13931	319	S2    
13932	319	S2    
13934	319	S2    
13935	319	S2    
13948	319	S2    
13949	319	S2    
13950	319	S2    
13951	319	S2    
13952	319	S2    
13953	319	S2    
13954	319	S2    
13955	319	S2    
13956	319	S2    
13957	319	S2    
13958	319	S2    
13959	319	S2    
13968	319	S2    
13969	319	S2    
13970	319	S2    
13971	319	S2    
13985	319	S2    
13988	319	S2703 
13989	319	S2703 
13992	319	S2703 
13994	319	S2703 
13997	319	S2703 
13998	319	S2703 
15087	319	S2109 
15260	319	S2109 
17202	319	S1082 
17203	319	S1082 
17204	319	S1082 
17218	319	S1581 
17219	319	S1581 
18932	319	S27   
18933	319	S27   
18934	319	S27   
18936	319	S27   
19109	319	S1164 
19155	319	S1164 
21271	319	S2108 
21272	319	S2108 
21273	319	S2108 
21274	319	S2108 
21275	319	S2108 
21276	319	S2108 
21277	319	S2110 
21278	319	S2110 
21279	319	S2110 
21280	319	S2110 
21281	319	S2110 
21282	319	S2110 
21283	319	S2111 
21284	319	S2111 
21285	319	S2111 
21286	319	S2111 
21287	319	S2112 
21288	319	S2112 
21289	319	S2112 
21290	319	S2112 
21291	319	S2112 
21292	319	S2112 
21293	319	S2782 
21294	319	S2782 
21295	319	S2782 
21296	319	S2782 
21297	319	S2782 
21298	319	S2782 
21299	319	S2110 
21299	319	S2111 
21299	319	S2112 
21299	319	S2782 
21300	319	S2110 
21300	319	S2112 
21300	319	S2782 
21301	319	S2110 
21301	319	S2111 
21301	319	S2112 
21301	319	S2782 
21302	319	S2110 
21302	319	S2111 
21302	319	S2112 
21302	319	S2782 
21303	319	S2110 
21303	319	S2112 
21303	319	S2782 
21304	319	S2110 
21304	319	S2111 
21304	319	S2112 
21304	319	S2782 
21308	319	S2801 
21311	319	S2801 
21313	319	S2801 
21316	319	S2801 
21317	319	S2801 
21318	319	S2801 
21320	319	S2801 
21321	319	S2801 
21322	319	S2801 
21323	319	S2801 
21325	319	S2801 
21326	319	S2801 
21342	319	S2801 
21343	319	S2801 
23011	319	S2703 
23014	319	S2703 
23015	319	S2703 
23018	319	S2703 
23019	319	S2703 
23020	319	S2703 
23021	319	S2703 
23022	319	S2703 
23023	319	S2703 
23024	319	S2703 
23025	319	S2703 
23027	319	S2703 
23028	319	S2703 
23029	319	S2703 
23030	319	S2703 
23031	319	S2703 
23034	319	S2703 
23035	319	S2703 
23037	319	S2703 
23038	319	S2703 
23041	319	S2703 
23042	319	S2703 
23045	319	S2703 
23046	319	S2703 
23049	319	S2703 
23050	319	S2703 
23053	319	S2703 
23054	319	S2703 
23055	319	S2703 
23056	319	S2703 
23057	319	S2703 
23058	319	S2703 
23059	319	S2703 
23060	319	S2703 
23061	319	S2703 
23062	319	S2703 
23063	319	S2703 
23064	319	S2703 
23557	319	S14   
23558	319	S14   
23560	319	S14   
23561	319	S14   
23562	319	S14   
23563	319	S14   
23565	319	S14   
23566	319	S14   
23567	319	S14   
23568	319	S14   
23570	319	S14   
23571	319	S14   
23572	319	S14   
23573	319	S14   
23575	319	S14   
23576	319	S14   
23577	319	S14   
23578	319	S14   
23580	319	S14   
23581	319	S14   
23582	319	S2    
23583	319	S2    
23584	319	S2    
23585	319	S2    
23586	319	S2    
23587	319	S2    
23588	319	S2    
23589	319	S2    
23590	319	S2    
23591	319	S2    
23592	319	S2    
23593	319	S2    
23594	319	S2    
23595	319	S2    
23596	319	S2    
23597	319	S2    
23598	319	S2    
23599	319	S2    
23600	319	S2    
23601	319	S2    
23602	319	S2    
23603	319	S2    
23604	319	S2    
23605	319	S2    
23606	319	S2    
23607	319	S2    
23608	319	S2    
23609	319	S2    
23610	319	S2    
23611	319	S2    
23612	319	S2    
23613	319	S2    
23614	319	S2    
23615	319	S2    
23616	319	S2    
23617	319	S2    
23618	319	S2    
23619	319	S2    
23620	319	S2    
23621	319	S2    
23622	319	S2    
23623	319	S2    
23624	319	S2    
23625	319	S2    
23626	319	S2    
23627	319	S2    
23628	319	S2    
23629	319	S2    
23630	319	S2    
23631	319	S2    
23632	319	S2    
23633	319	S2    
23634	319	S2    
23635	319	S2    
23636	319	S2    
23637	319	S2    
23638	319	S2    
23640	319	S1581 
23646	319	S2    
23647	319	S2    
23648	319	S2    
23649	319	S2    
23650	319	S2    
23651	319	S2    
23652	319	S2    
23653	319	S2    
23654	319	S2    
23655	319	S2    
23656	319	S2    
23657	319	S2    
23658	319	S2    
23659	319	S2    
23660	319	S2    
35144	319	S2381 
35145	319	S2381 
35146	319	S2381 
35147	319	S2381 
43378	319	S1082 
02009	320	S1069 
02010	320	S1069 
02020	320	S1069 
02026	320	S1069 
02029	320	S1069 
02030	320	S1069 
02033	320	S1069 
02043	320	S1069 
02049	320	S405  
02054	320	S1202 
07083	320	S281  
07910	320	S245  
07912	320	S226  
07913	320	S238  
07915	320	S281  
07916	320	S242  
07917	320	S242  
07918	320	S242  
07919	320	S252  
07921	320	S228  
07925	320	S281  
07932	320	S224  
07933	320	S224  
07934	320	S281  
07935	320	S224  
07943	320	S281  
08120	320	D3921 
09003	320	S502  
09003	320	S561  
09004	320	S502  
09021	320	D3887 
09021	320	D3924 
09021	320	D3949 
09032	320	S21   
09037	320	S1621 
09037	320	S381  
09037	320	S481  
09037	320	S502  
09037	320	S986  
09038	320	S481  
09038	320	S502  
09038	320	S986  
09039	320	S381  
09040	320	S1023 
09040	320	S481  
09040	320	S562  
09042	320	S461  
09042	320	S566  
09050	320	S1141 
09050	320	S421  
09050	320	S441  
09059	320	D3899 
09060	320	S381  
09062	320	S381  
09070	320	S53   
09070	320	S582  
09078	320	S561  
09084	320	D3919 
09087	320	S564  
09087	320	S582  
09094	320	S363  
09094	320	S582  
09148	320	S1033 
09148	320	S363  
09148	320	S582  
09149	320	D3899 
09160	320	S1065 
09177	320	S1202 
09183	320	S381  
09184	320	S1026 
09184	320	S562  
09184	320	S565  
09195	320	D3919 
09195	320	S1202 
09200	320	D3887 
09200	320	S1203 
09200	320	S482  
09202	320	S1203 
09202	320	S482  
09215	320	D3848 
09215	320	S1203 
09215	320	S23   
09218	320	S1161 
09218	320	S1203 
09221	320	D3849 
09224	320	D3912 
09231	320	D3899 
09236	320	D3887 
09236	320	D3904 
09236	320	S1203 
09236	320	S461  
09236	320	S582  
09252	320	S1206 
09252	320	S482  
09252	320	S541  
09264	320	D3899 
09266	320	S1167 
09266	320	S441  
09266	320	S561  
09279	320	S421  
09279	320	S582  
09287	320	D3899 
09287	320	S1202 
09291	320	S1341 
09291	320	S564  
09291	320	S566  
09295	320	D3899 
09298	320	S564  
09298	320	S566  
09301	320	S1202 
09307	320	D3919 
09316	320	S421  
09316	320	S566  
09316	320	S581  
09326	320	S441  
09326	320	S461  
09351	320	S1203 
09370	320	D3843 
09370	320	D3904 
09370	320	D3912 
09421	320	S564  
09421	320	S582  
09422	320	S1202 
09429	320	S1167 
09429	320	S441  
09430	320	S441  
09430	320	S561  
11124	320	D5261 
11355	320	S566  
12038	320	S1202 
12038	320	S661  
12071	320	S1202 
12078	320	S503  
12152	320	S563  
12152	320	S565  
12152	320	S86   
12154	320	S941  
12155	320	S481  
12155	320	S563  
12155	320	S79   
12220	320	S1221 
12220	320	S2109 
12538	320	S1202 
12538	320	S661  
12652	320	S563  
12652	320	S565  
12652	320	S86   
20017	320	S1343 
20022	320	S1203 
20077	320	D3921 
20081	320	S20   
20083	320	S20   
20130	320	D3921 
20130	320	S1202 
20322	320	S1343 
20581	320	S20   
01001	321	S1203 
01009	321	S1203 
01077	321	S1203 
01077	321	S27   
01103	321	S1163 
01123	321	S1063 
01123	321	S1203 
01125	321	S1065 
01145	321	S1203 
01202	321	S1163 
02009	321	S1069 
02010	321	S1069 
02020	321	S1069 
02026	321	S1069 
02028	321	D4721 
02028	321	D4722 
02028	321	S1069 
02029	321	S1069 
02030	321	S1069 
02033	321	S1069 
02043	321	S1069 
02044	321	D3964 
02044	321	D4701 
02044	321	S1069 
02049	321	S405  
02054	321	S1202 
04017	321	S19   
04020	321	S19   
04021	321	S19   
04023	321	S19   
04047	321	D3920 
04114	321	S19   
04120	321	S19   
04141	321	S19   
04142	321	S19   
04143	321	S19   
04144	321	S19   
04367	321	S19   
04635	321	S19   
04636	321	S19   
05023	321	S1581 
05024	321	S1581 
05027	321	S1082 
05028	321	S1082 
05173	321	S1581 
05175	321	S1581 
05177	321	S1581 
05178	321	S1581 
05661	321	S1082 
06019	321	S405  
06040	321	D3851 
06068	321	D3851 
06071	321	D3851 
06159	321	D3851 
06164	321	S23   
06931	321	S22   
07007	321	S1164 
07052	321	S227  
07063	321	S1164 
07063	321	S582  
07064	321	S1164 
07075	321	S1164 
07083	321	S281  
07276	321	S259  
07276	321	S281  
07277	321	S259  
07278	321	S259  
07906	321	S281  
07908	321	S281  
07909	321	S259  
07910	321	S245  
07911	321	S226  
07912	321	S226  
07913	321	S238  
07914	321	S252  
07915	321	S281  
07916	321	S242  
07917	321	S242  
07918	321	S242  
07919	321	S252  
07920	321	S242  
07921	321	S228  
07922	321	S242  
07923	321	S245  
07924	321	S242  
07925	321	S281  
07926	321	S228  
07927	321	S227  
07928	321	S225  
07929	321	S227  
07930	321	S222  
07932	321	S224  
07933	321	S224  
07934	321	S281  
07935	321	S224  
07936	321	S247  
07937	321	S239  
07938	321	S233  
07939	321	S235  
07940	321	S237  
07941	321	S281  
07942	321	S281  
07943	321	S281  
07944	321	S227  
07952	321	S1164 
07953	321	S1164 
07953	321	S582  
07954	321	S582  
07955	321	S1164 
07956	321	S1164 
07957	321	S1164 
07958	321	S1164 
07959	321	S1164 
07960	321	S1164 
08020	321	S1065 
08084	321	D3921 
08120	321	D3921 
08147	321	S2422 
08221	321	S702  
08259	321	S2662 
08410	321	S702  
08419	321	S702  
08505	321	S2662 
08506	321	S2662 
08507	321	S2662 
08508	321	S2662 
09003	321	S502  
09003	321	S561  
09004	321	S502  
09021	321	D3887 
09021	321	D3924 
09021	321	D3949 
09032	321	S21   
09037	321	S1031 
09037	321	S1621 
09037	321	S381  
09037	321	S481  
09037	321	S502  
09037	321	S986  
09038	321	S1031 
09038	321	S1621 
09038	321	S481  
09038	321	S502  
09038	321	S986  
09039	321	S381  
09040	321	S1023 
09040	321	S481  
09040	321	S562  
09042	321	S461  
09042	321	S566  
09050	321	D3887 
09050	321	S1141 
09050	321	S421  
09050	321	S441  
09059	321	D3899 
09060	321	D3899 
09062	321	S381  
09070	321	S53   
09070	321	S582  
09078	321	S561  
09084	321	D3919 
09087	321	S564  
09087	321	S582  
09094	321	S363  
09094	321	S582  
09112	321	D3845 
09112	321	D3887 
09112	321	D3888 
09112	321	D3904 
09112	321	D3912 
09112	321	S1203 
09112	321	S482  
09112	321	S563  
09116	321	D3888 
09132	321	S1206 
09139	321	D3899 
09139	321	D4863 
09139	321	D4864 
09148	321	S1033 
09148	321	S363  
09148	321	S582  
09149	321	D3899 
09149	321	S381  
09150	321	D3919 
09150	321	D3949 
09160	321	S1065 
09176	321	D3899 
09177	321	S1202 
09181	321	D3887 
09181	321	D3889 
09181	321	D3912 
09181	321	S1024 
09181	321	S1121 
09181	321	S1203 
09181	321	S461  
09183	321	S381  
09184	321	S1026 
09184	321	S562  
09184	321	S565  
09191	321	D3888 
09191	321	S1206 
09191	321	S421  
09191	321	S582  
09195	321	D3919 
09195	321	S1202 
09200	321	D3887 
09200	321	S1203 
09200	321	S482  
09202	321	S1203 
09202	321	S482  
09215	321	D3848 
09215	321	D3912 
09215	321	S1203 
09215	321	S23   
09218	321	S1065 
09218	321	S1161 
09218	321	S1203 
09221	321	D3849 
09224	321	D3912 
09226	321	D3842 
09226	321	D3912 
09226	321	S1203 
09231	321	D3899 
09236	321	D3887 
09236	321	D3904 
09236	321	S1203 
09236	321	S461  
09236	321	S582  
09252	321	S1206 
09252	321	S482  
09252	321	S541  
09263	321	D3842 
09263	321	D3912 
09264	321	D3899 
09266	321	S1167 
09266	321	S441  
09266	321	S561  
09279	321	S421  
09279	321	S582  
09287	321	D3899 
09287	321	S1202 
09291	321	S1341 
09291	321	S564  
09291	321	S566  
09295	321	D3899 
09298	321	S564  
09298	321	S566  
09301	321	S1202 
09302	321	D3887 
09302	321	D3899 
09302	321	S461  
09302	321	S566  
09302	321	S963  
09307	321	D3919 
09316	321	S421  
09316	321	S566  
09316	321	S581  
09326	321	D3912 
09326	321	S1027 
09326	321	S1203 
09326	321	S441  
09326	321	S461  
09351	321	S1203 
09354	321	D3912 
09357	321	D3843 
09357	321	D3846 
09357	321	D3912 
09357	321	D3919 
09357	321	D3924 
09370	321	D3843 
09370	321	D3904 
09370	321	D3912 
09374	321	D3843 
09421	321	S564  
09421	321	S582  
09422	321	S1202 
09427	321	D4053 
09428	321	D4053 
09429	321	S1167 
09429	321	S441  
09430	321	S441  
09430	321	S561  
09431	321	S2203 
09432	321	S2203 
10098	321	S1581 
10102	321	S1581 
10173	321	S1581 
10863	321	S1581 
11008	321	S565  
11011	321	D3887 
11011	321	D3888 
11012	321	S1069 
11024	321	D3844 
11052	321	D3853 
11052	321	D3887 
11052	321	D3889 
11052	321	D3905 
11060	321	D3853 
11086	321	D3846 
11086	321	D3887 
11090	321	D3846 
11090	321	D3853 
11090	321	D3887 
11090	321	D3888 
11090	321	D3889 
11090	321	D3901 
11090	321	S1121 
11090	321	S1164 
11090	321	S564  
11091	321	D3846 
11091	321	D3890 
11091	321	S1121 
11091	321	S564  
11092	321	D3846 
11096	321	S1121 
11096	321	S482  
11097	321	S482  
11098	321	D3846 
11098	321	D3889 
11098	321	D3901 
11099	321	D3846 
11099	321	D3901 
11100	321	D3846 
11109	321	D3901 
11109	321	S1202 
11112	321	S1065 
11113	321	S1065 
11124	321	D3843 
11124	321	D3846 
11124	321	D3847 
11124	321	D3850 
11124	321	D3885 
11124	321	D3887 
11124	321	D3888 
11124	321	D3889 
11124	321	D3900 
11124	321	D3909 
11124	321	D3911 
11124	321	D5261 
11124	321	S1062 
11124	321	S1381 
11124	321	S2644 
11125	321	D3846 
11125	321	D3885 
11125	321	S1062 
11128	321	D3843 
11128	321	D3846 
11128	321	D3902 
11128	321	D3911 
11143	321	S1121 
11143	321	S564  
11147	321	D3887 
11147	321	D3889 
11149	321	S1202 
11157	321	D3869 
11157	321	D3870 
11157	321	S1202 
11158	321	D3869 
11158	321	D3870 
11161	321	D3846 
11162	321	D3846 
11163	321	D3846 
11165	321	D3863 
11165	321	D3956 
11165	321	D3964 
11165	321	D3969 
11170	321	D3907 
11179	321	S405  
11233	321	D3843 
11233	321	D3846 
11233	321	D3901 
11234	321	D3901 
11250	321	S565  
11251	321	S481  
11251	321	S503  
11251	321	S620  
11252	321	D3887 
11252	321	S1203 
11252	321	S1206 
11252	321	S481  
11252	321	S562  
11253	321	S541  
11253	321	S565  
11257	321	S541  
11257	321	S565  
11294	321	S563  
11294	321	S582  
11297	321	D3919 
11297	321	D3924 
11297	321	D3956 
11304	321	D3887 
11304	321	D3889 
11308	321	S1203 
11333	321	D3887 
11333	321	D3888 
11333	321	D3889 
11333	321	S1062 
11333	321	S611  
11339	321	S1062 
11352	321	S563  
11352	321	S566  
11353	321	S563  
11353	321	S566  
11354	321	S566  
11355	321	S566  
11356	321	S563  
11356	321	S566  
11357	321	S563  
11357	321	S566  
11358	321	S563  
11358	321	S566  
11424	321	D3846 
11424	321	D3902 
11429	321	S1121 
11429	321	S363  
11457	321	D3846 
11457	321	D3887 
11457	321	D3888 
11457	321	D3901 
11457	321	D3905 
11458	321	D3846 
11458	321	D3905 
11467	321	S1203 
11467	321	S1322 
11467	321	S622  
11477	321	S1203 
11477	321	S1322 
11477	321	S622  
11482	321	D3903 
11484	321	D3903 
11485	321	D3843 
11485	321	D3846 
11485	321	D3847 
11489	321	D3846 
11489	321	D3847 
11507	321	D3843 
11507	321	D3846 
11507	321	D3887 
11507	321	D3888 
11507	321	D3891 
11507	321	D3902 
11507	321	S1062 
11510	321	D3846 
11510	321	D3852 
11510	321	D3891 
11510	321	D3902 
11516	321	D3846 
11529	321	D3889 
11529	321	D3905 
11529	321	D3912 
11529	321	D3933 
11529	321	S441  
11529	321	S503  
11530	321	D3905 
11530	321	S441  
11540	321	D3851 
11546	321	S21   
11546	321	S5    
11549	321	S21   
11578	321	D3851 
11641	321	S1203 
11641	321	S1322 
11641	321	S622  
11643	321	D3846 
11643	321	D3847 
11644	321	D3846 
11674	321	S563  
11674	321	S566  
11697	321	S1202 
11702	321	S565  
11705	321	S1069 
11742	321	D3846 
11742	321	D3890 
11742	321	S1121 
11742	321	S564  
11745	321	D3846 
11745	321	D3901 
11752	321	S1065 
11757	321	D3846 
11757	321	D3885 
11757	321	S1062 
11758	321	D3843 
11758	321	D3846 
11758	321	D3902 
11758	321	D3911 
11759	321	D3843 
11759	321	D3846 
11759	321	D3902 
11759	321	D3911 
11767	321	D3869 
11767	321	D3870 
11768	321	D3846 
11771	321	D3907 
11774	321	S405  
11790	321	D3901 
11813	321	S1203 
11821	321	D3846 
11821	321	D3894 
11821	321	D3912 
11821	321	S1062 
11828	321	S563  
11828	321	S566  
11854	321	D3846 
11854	321	D3905 
11876	321	D3846 
11876	321	D3852 
11876	321	D3891 
11876	321	D3902 
11884	321	D3905 
11884	321	S441  
11886	321	D3851 
11887	321	S21   
11887	321	S5    
11888	321	S21   
11921	321	S1062 
11935	321	S22   
11949	321	S22   
11951	321	D3912 
11960	321	D3900 
11970	321	S1202 
11972	321	S1202 
11973	321	S1202 
11975	321	S1202 
11976	321	S1202 
11989	321	S1202 
11990	321	S1202 
11991	321	S1202 
11995	321	D3885 
11995	321	D3886 
11996	321	D3886 
12038	321	S1202 
12038	321	S661  
12061	321	S141  
12061	321	S441  
12061	321	S503  
12062	321	S141  
12063	321	S141  
12065	321	S141  
12071	321	S1202 
12078	321	S503  
12086	321	S363  
12086	321	S502  
12120	321	S503  
12120	321	S83   
12121	321	S83   
12122	321	S83   
12132	321	S77   
12142	321	S1121 
12142	321	S363  
12142	321	S85   
12143	321	S85   
12144	321	S85   
12151	321	S86   
12152	321	S563  
12152	321	S565  
12152	321	S86   
12154	321	S941  
12155	321	S481  
12155	321	S563  
12155	321	S79   
12220	321	S1221 
12220	321	S2109 
12538	321	S1202 
12538	321	S661  
12563	321	S141  
12565	321	S141  
12586	321	S363  
12586	321	S502  
12632	321	S363  
12632	321	S566  
12632	321	S77   
12643	321	S85   
12644	321	S85   
12652	321	S563  
12652	321	S565  
12652	321	S86   
13067	321	S2    
13070	321	S2    
13096	321	S2    
13098	321	S2    
13165	321	S2    
13318	321	S1581 
13320	321	S1581 
13323	321	S1581 
13325	321	S1082 
13326	321	S1082 
13327	321	S1082 
13343	321	S2    
13369	321	S2    
13370	321	S2    
13373	321	S2    
13375	321	S2    
13377	321	S2    
13378	321	S2    
13391	321	S2    
13394	321	S2    
13398	321	S2    
13399	321	S2    
13401	321	S2    
13402	321	S2    
13404	321	S2    
13405	321	S2    
13407	321	S2    
13408	321	S2    
13410	321	S2    
13411	321	S2    
13413	321	S2    
13414	321	S2    
13415	321	S2    
13416	321	S2    
13417	321	S2    
13418	321	S2    
13419	321	S2    
13420	321	S2    
13422	321	S2    
13423	321	S2    
13424	321	S2    
13425	321	S2    
13426	321	S2    
13439	321	S2    
13440	321	S2    
13441	321	S2    
13442	321	S2    
13443	321	S2    
13444	321	S2    
13445	321	S2    
13446	321	S2    
13447	321	S2    
13448	321	S2    
13449	321	S2    
13450	321	S2    
13451	321	S2    
13452	321	S2    
13453	321	S2    
13455	321	S2    
13456	321	S2    
13485	321	S2    
13486	321	S2    
13487	321	S2    
13488	321	S2    
13490	321	S2    
13491	321	S2    
13492	321	S2    
13493	321	S2    
13805	321	S2    
13806	321	S2    
13809	321	S2    
13811	321	S2    
13813	321	S2    
13850	321	S2    
13853	321	S2    
13854	321	S2    
13856	321	S2    
13857	321	S2    
13868	321	S2    
13870	321	S2    
13871	321	S2    
13873	321	S2    
13874	321	S2    
13875	321	S2    
13876	321	S2    
13877	321	S2    
13879	321	S2    
13880	321	S2    
13881	321	S2    
13882	321	S2    
13891	321	S2    
13894	321	S2    
13896	321	S2    
13898	321	S2    
13900	321	S2    
13909	321	S2    
13911	321	S2    
13912	321	S2    
13913	321	S2    
13914	321	S2    
13917	321	S2    
13920	321	S2    
13921	321	S2    
13923	321	S2    
13924	321	S2    
13929	321	S2    
13931	321	S2    
13932	321	S2    
13934	321	S2    
13935	321	S2    
13948	321	S2    
13949	321	S2    
13950	321	S2    
13951	321	S2    
13952	321	S2    
13953	321	S2    
13954	321	S2    
13955	321	S2    
13956	321	S2    
13957	321	S2    
13958	321	S2    
13959	321	S2    
13968	321	S2    
13969	321	S2    
13970	321	S2    
13971	321	S2    
13985	321	S2    
16006	321	S1164 
16010	321	S1164 
16011	321	S1164 
16042	321	S1065 
16043	321	S1065 
16089	321	S563  
16126	321	S1202 
16144	321	S1202 
16343	321	S1065 
17202	321	S1082 
17203	321	S1082 
17204	321	S1082 
17218	321	S1581 
17219	321	S1581 
18079	321	S25   
18376	321	S25   
19003	321	S26   
19064	321	S1164 
19076	321	S1164 
19078	321	S1069 
19109	321	S1164 
19120	321	S1069 
19155	321	S1164 
20017	321	S1343 
20022	321	S1203 
20063	321	D3921 
20077	321	D3921 
20080	321	D3921 
20081	321	S20   
20083	321	S20   
20084	321	S20   
20130	321	D3921 
20130	321	S1202 
20322	321	S1343 
20581	321	S20   
21138	321	S1122 
21238	321	S2801 
21260	321	S1082 
21261	321	S1082 
21262	321	S1082 
21263	321	S1082 
21264	321	S1082 
21265	321	S1082 
21266	321	S1082 
21267	321	S1082 
21268	321	S1082 
21269	321	S1082 
21270	321	S1082 
21271	321	S2108 
21272	321	S2108 
21273	321	S2108 
21274	321	S2108 
21275	321	S2108 
21276	321	S2108 
21277	321	S2110 
21278	321	S2110 
21279	321	S2110 
21280	321	S2110 
21281	321	S2110 
21282	321	S2110 
21283	321	S2111 
21284	321	S2111 
21285	321	S2111 
21286	321	S2111 
21287	321	S2112 
21288	321	S2112 
21289	321	S2112 
21290	321	S2112 
21291	321	S2112 
21292	321	S2112 
21293	321	S2782 
21294	321	S2782 
21295	321	S2782 
21296	321	S2782 
21297	321	S2782 
21298	321	S2782 
21299	321	S2110 
21299	321	S2111 
21299	321	S2112 
21299	321	S2782 
21300	321	S2110 
21300	321	S2112 
21300	321	S2782 
21301	321	S2110 
21301	321	S2111 
21301	321	S2112 
21301	321	S2782 
21302	321	S2110 
21302	321	S2111 
21302	321	S2112 
21302	321	S2782 
21303	321	S2110 
21303	321	S2112 
21303	321	S2782 
21304	321	S2110 
21304	321	S2111 
21304	321	S2112 
21304	321	S2782 
21308	321	S2801 
21310	321	S2801 
21311	321	S2801 
21313	321	S2801 
21314	321	S2801 
21315	321	S2801 
21316	321	S2801 
21318	321	S2801 
21319	321	S2801 
21321	321	S2801 
21322	321	S2801 
23582	321	S2    
23583	321	S2    
23585	321	S2    
23586	321	S2    
23587	321	S2    
23589	321	S2    
23590	321	S2    
23591	321	S2    
23592	321	S2    
23593	321	S2    
23594	321	S2    
23595	321	S2    
23596	321	S2    
23597	321	S2    
23599	321	S2    
23601	321	S2    
23603	321	S2    
23604	321	S2    
23607	321	S2    
23609	321	S2    
23613	321	S2    
23615	321	S2    
23616	321	S2    
23618	321	S2    
23619	321	S2    
23620	321	S2    
23623	321	S2    
23624	321	S2    
23626	321	S2    
23627	321	S2    
23628	321	S2    
23630	321	S2    
23631	321	S2    
23632	321	S2    
23634	321	S2    
23635	321	S2    
23636	321	S2    
23637	321	S2    
23640	321	S1581 
23646	321	S2    
23647	321	S2    
23648	321	S2    
23649	321	S2    
23650	321	S2    
23651	321	S2    
23652	321	S2    
23653	321	S2    
23654	321	S2    
23655	321	S2    
23656	321	S2    
23657	321	S2    
23658	321	S2    
23659	321	S2    
23660	321	S2    
01001	322	S1203 
01009	322	S1203 
01077	322	S1203 
01077	322	S27   
01103	322	S1163 
01123	322	S1063 
01123	322	S1203 
01125	322	S1065 
01145	322	S1203 
01202	322	S1163 
02009	322	S1069 
02010	322	S1069 
02011	322	S1069 
02015	322	S1069 
02020	322	S1069 
02021	322	S1069 
02024	322	S1069 
02026	322	S1069 
02028	322	S1069 
02029	322	S1069 
02030	322	S1069 
02033	322	S1069 
02043	322	S1069 
02044	322	D4701 
02054	322	S1202 
02055	322	S1202 
05023	322	S1581 
05024	322	S1581 
05027	322	S1082 
05028	322	S1082 
05173	322	S1581 
05175	322	S1581 
05177	322	S1581 
05178	322	S1581 
05661	322	S1082 
06019	322	S405  
06040	322	D3851 
06068	322	D3851 
06071	322	D3851 
06159	322	D3851 
06164	322	S23   
06931	322	S22   
07007	322	S1164 
07063	322	S1164 
07063	322	S582  
07064	322	S1164 
07075	322	S1164 
07083	322	S281  
07276	322	S259  
07276	322	S281  
07277	322	S259  
07278	322	S259  
07906	322	S281  
07908	322	S281  
07909	322	S259  
07910	322	S245  
07911	322	S226  
07912	322	S226  
07913	322	S238  
07914	322	S252  
07915	322	S281  
07916	322	S242  
07917	322	S242  
07918	322	S242  
07919	322	S252  
07920	322	S242  
07921	322	S228  
07922	322	S242  
07923	322	S245  
07924	322	S242  
07925	322	S281  
07926	322	S228  
07927	322	S227  
07928	322	S225  
07929	322	S227  
07930	322	S222  
07932	322	S224  
07933	322	S224  
07934	322	S281  
07935	322	S224  
07936	322	S247  
07937	322	S239  
07938	322	S233  
07939	322	S235  
07940	322	S237  
07941	322	S281  
07943	322	S281  
07944	322	S227  
07952	322	S1164 
07953	322	S1164 
07953	322	S582  
07954	322	S582  
07955	322	S1164 
07956	322	S1164 
07957	322	S1164 
07958	322	S1164 
07959	322	S1164 
07960	322	S1164 
08020	322	S1065 
08259	322	S2662 
08505	322	S2662 
08506	322	S2662 
08507	322	S2662 
08508	322	S2662 
09003	322	S502  
09003	322	S561  
09004	322	S502  
09021	322	D3887 
09021	322	D3924 
09021	322	D3949 
09032	322	S21   
09037	322	S1031 
09037	322	S1621 
09037	322	S381  
09037	322	S481  
09037	322	S502  
09037	322	S986  
09038	322	S1031 
09038	322	S1621 
09038	322	S481  
09038	322	S502  
09038	322	S986  
09039	322	S381  
09040	322	S1023 
09040	322	S481  
09040	322	S562  
09042	322	S461  
09042	322	S566  
09050	322	D3887 
09050	322	S421  
09050	322	S441  
09059	322	D3899 
09060	322	D3899 
09062	322	S381  
09070	322	S582  
09078	322	S561  
09084	322	D3919 
09087	322	S564  
09087	322	S582  
09094	322	S363  
09094	322	S582  
09112	322	D3887 
09112	322	D3888 
09112	322	D3904 
09112	322	S1203 
09112	322	S482  
09112	322	S563  
09116	322	D3888 
09132	322	D3919 
09139	322	D3899 
09148	322	S363  
09148	322	S582  
09149	322	D3899 
09149	322	S381  
09150	322	D3919 
09150	322	D3949 
09160	322	S1065 
09176	322	D3899 
09177	322	S1202 
09181	322	D3887 
09181	322	D3889 
09181	322	D3904 
09181	322	S1121 
09181	322	S1203 
09181	322	S461  
09183	322	S381  
09184	322	S562  
09184	322	S565  
09191	322	D3888 
09191	322	S421  
09191	322	S582  
09195	322	D3919 
09200	322	D3887 
09200	322	S1203 
09200	322	S482  
09202	322	S1203 
09202	322	S482  
09215	322	D3848 
09215	322	S1203 
09215	322	S23   
09218	322	S1065 
09218	322	S1203 
09221	322	D3849 
09226	322	S1203 
09231	322	D3899 
09236	322	D3887 
09236	322	D3904 
09236	322	S1203 
09236	322	S461  
09236	322	S582  
09252	322	S1206 
09252	322	S482  
09252	322	S541  
09264	322	D3899 
09266	322	S441  
09266	322	S561  
09279	322	S421  
09279	322	S582  
09287	322	D3899 
09287	322	S1202 
09291	322	S1341 
09291	322	S564  
09291	322	S566  
09295	322	D3899 
09298	322	S564  
09298	322	S566  
09301	322	S1202 
09302	322	D3887 
09302	322	D3899 
09302	322	S461  
09302	322	S566  
09307	322	D3919 
09316	322	S421  
09316	322	S566  
09326	322	S1203 
09326	322	S441  
09326	322	S461  
09351	322	S1203 
09357	322	D3919 
09357	322	D3924 
09370	322	D3904 
09421	322	S564  
09421	322	S582  
09422	322	S1202 
09427	322	D4053 
09428	322	D4053 
09429	322	S441  
09430	322	S441  
09430	322	S561  
09431	322	S2203 
09432	322	S2203 
10098	322	S1581 
10102	322	S1581 
10173	322	S1581 
10863	322	S1581 
11008	322	S565  
11011	322	D3887 
11011	322	D3888 
11012	322	S1069 
11024	322	D3844 
11052	322	D3887 
11052	322	D3889 
11052	322	D3905 
11086	322	D3887 
11090	322	D3887 
11090	322	D3888 
11090	322	D3901 
11090	322	S1121 
11090	322	S1164 
11090	322	S564  
11091	322	S1121 
11091	322	S564  
11096	322	S1121 
11096	322	S482  
11097	322	S482  
11098	322	D3889 
11098	322	D3901 
11099	322	D3901 
11109	322	D3901 
11109	322	S1202 
11112	322	S1065 
11113	322	S1065 
11124	322	D3846 
11124	322	D3847 
11124	322	D3850 
11124	322	D3885 
11124	322	D3887 
11124	322	D3888 
11124	322	D3889 
11124	322	D3900 
11124	322	D3909 
11124	322	D3911 
11124	322	S1062 
11124	322	S1381 
11124	322	S2644 
11125	322	D3846 
11125	322	D3885 
11125	322	S1062 
11128	322	D3846 
11128	322	D3902 
11128	322	D3911 
11143	322	S1121 
11143	322	S564  
11147	322	D3887 
11147	322	D3889 
11149	322	S1202 
11157	322	D3870 
11158	322	D3870 
11165	322	D3969 
11170	322	D3907 
11179	322	S405  
11233	322	D3901 
11234	322	D3901 
11250	322	S565  
11251	322	S481  
11251	322	S503  
11252	322	D3887 
11252	322	S1203 
11252	322	S481  
11252	322	S562  
11253	322	S541  
11253	322	S565  
11257	322	S541  
11257	322	S565  
11294	322	S563  
11294	322	S582  
11297	322	D3919 
11304	322	D3887 
11304	322	D3889 
11308	322	S1203 
11333	322	D3887 
11333	322	D3888 
11333	322	D3889 
11333	322	S1062 
11339	322	S1062 
11352	322	S563  
11352	322	S566  
11353	322	S563  
11353	322	S566  
11354	322	S566  
11355	322	S566  
11356	322	S563  
11356	322	S566  
11357	322	S563  
11357	322	S566  
11358	322	S563  
11358	322	S566  
11424	322	D3846 
11424	322	D3902 
11429	322	S1121 
11429	322	S363  
11457	322	D3887 
11457	322	D3888 
11457	322	D3901 
11457	322	D3905 
11458	322	D3905 
11467	322	S1203 
11477	322	S1203 
11482	322	D3903 
11484	322	D3903 
11485	322	D3846 
11485	322	D3847 
11489	322	D3846 
11507	322	D3887 
11507	322	D3888 
11507	322	D3902 
11507	322	S1062 
11510	322	D3902 
11529	322	D3889 
11529	322	D3905 
11529	322	S441  
11529	322	S503  
11530	322	D3905 
11530	322	S441  
11540	322	D3851 
11546	322	S21   
11549	322	S21   
11578	322	D3851 
11641	322	S1203 
11643	322	D3846 
11644	322	D3846 
11674	322	S563  
11674	322	S566  
11697	322	S1202 
11702	322	S565  
11705	322	S1069 
11742	322	S1121 
11742	322	S564  
11745	322	D3901 
11752	322	S1065 
11757	322	D3846 
11757	322	D3885 
11757	322	S1062 
11758	322	D3846 
11758	322	D3902 
11758	322	D3911 
11759	322	D3846 
11759	322	D3902 
11759	322	D3911 
11767	322	D3870 
11771	322	D3907 
11774	322	S405  
11790	322	D3901 
11813	322	S1203 
11821	322	D3846 
11821	322	S1062 
11828	322	S563  
11828	322	S566  
11854	322	D3905 
11876	322	D3902 
11884	322	D3905 
11884	322	S441  
11886	322	D3851 
11887	322	S21   
11888	322	S21   
11921	322	S1062 
11935	322	S22   
11949	322	S22   
11960	322	D3900 
11970	322	S1202 
11972	322	S1202 
11973	322	S1202 
11975	322	S1202 
11976	322	S1202 
11989	322	S1202 
11990	322	S1202 
11991	322	S1202 
11995	322	D3885 
11995	322	D3886 
11996	322	D3886 
12038	322	S1202 
12061	322	S141  
12061	322	S441  
12061	322	S503  
12062	322	S141  
12063	322	S141  
12065	322	S141  
12071	322	S1202 
12078	322	S503  
12086	322	S363  
12086	322	S502  
12120	322	S503  
12120	322	S83   
12121	322	S83   
12122	322	S83   
12132	322	S77   
12142	322	S1121 
12142	322	S363  
12142	322	S85   
12143	322	S85   
12144	322	S85   
12151	322	S86   
12152	322	S563  
12152	322	S565  
12152	322	S86   
12154	322	S941  
12155	322	S481  
12155	322	S563  
12155	322	S79   
12220	322	S1221 
12220	322	S2109 
12538	322	S1202 
12563	322	S141  
12565	322	S141  
12586	322	S363  
12586	322	S502  
12632	322	S363  
12632	322	S566  
12632	322	S77   
12643	322	S85   
12644	322	S85   
12652	322	S563  
12652	322	S565  
12652	322	S86   
13067	322	S2    
13070	322	S2    
13096	322	S2    
13098	322	S2    
13165	322	S2    
13318	322	S1581 
13321	322	S1581 
13323	322	S1581 
13325	322	S1082 
13326	322	S1082 
13327	322	S1082 
13343	322	S2    
13369	322	S2    
13370	322	S2    
13373	322	S2    
13375	322	S2    
13377	322	S2    
13378	322	S2    
13391	322	S2    
13394	322	S2    
13398	322	S2    
13399	322	S2    
13401	322	S2    
13402	322	S2    
13404	322	S2    
13405	322	S2    
13407	322	S2    
13408	322	S2    
13410	322	S2    
13411	322	S2    
13413	322	S2    
13414	322	S2    
13415	322	S2    
13416	322	S2    
13417	322	S2    
13418	322	S2    
13419	322	S2    
13420	322	S2    
13422	322	S2    
13423	322	S2    
13424	322	S2    
13425	322	S2    
13426	322	S2    
13439	322	S2    
13440	322	S2    
13441	322	S2    
13442	322	S2    
13443	322	S2    
13444	322	S2    
13445	322	S2    
13446	322	S2    
13447	322	S2    
13448	322	S2    
13449	322	S2    
13450	322	S2    
13451	322	S2    
13452	322	S2    
13453	322	S2    
13455	322	S2    
13456	322	S2    
13485	322	S2    
13486	322	S2    
13487	322	S2    
13488	322	S2    
13490	322	S2    
13491	322	S2    
13492	322	S2    
13493	322	S2    
13805	322	S2    
13806	322	S2    
13809	322	S2    
13811	322	S2    
13813	322	S2    
13850	322	S2    
13853	322	S2    
13854	322	S2    
13856	322	S2    
13857	322	S2    
13868	322	S2    
13870	322	S2    
13871	322	S2    
13873	322	S2    
13874	322	S2    
13875	322	S2    
13876	322	S2    
13877	322	S2    
13879	322	S2    
13880	322	S2    
13881	322	S2    
13882	322	S2    
13891	322	S2    
13894	322	S2    
13896	322	S2    
13898	322	S2    
13900	322	S2    
13909	322	S2    
13911	322	S2    
13912	322	S2    
13913	322	S2    
13914	322	S2    
13917	322	S2    
13920	322	S2    
13921	322	S2    
13923	322	S2    
13924	322	S2    
13929	322	S2    
13931	322	S2    
13932	322	S2    
13934	322	S2    
13935	322	S2    
13948	322	S2    
13949	322	S2    
13950	322	S2    
13951	322	S2    
13952	322	S2    
13953	322	S2    
13954	322	S2    
13955	322	S2    
13956	322	S2    
13957	322	S2    
13958	322	S2    
13959	322	S2    
13968	322	S2    
13969	322	S2    
13970	322	S2    
13971	322	S2    
13985	322	S2    
14242	322	S2104 
16006	322	S1164 
16010	322	S1164 
16011	322	S1164 
16042	322	S1065 
16043	322	S1065 
16089	322	S563  
16126	322	S1202 
16144	322	S1202 
16343	322	S1065 
17202	322	S1082 
17203	322	S1082 
17204	322	S1082 
17218	322	S1581 
17219	322	S1581 
18079	322	S25   
18376	322	S25   
19003	322	S26   
19064	322	S1164 
19076	322	S1164 
19078	322	S1069 
19109	322	S1164 
19120	322	S1069 
19155	322	S1164 
20017	322	S1343 
20022	322	S1203 
20081	322	S20   
20083	322	S20   
20084	322	S20   
20130	322	S1202 
20322	322	S1343 
20581	322	S20   
21138	322	S1122 
21260	322	S1082 
21261	322	S1082 
21262	322	S1082 
21263	322	S1082 
21264	322	S1082 
21265	322	S1082 
21266	322	S1082 
21267	322	S1082 
21268	322	S1082 
21269	322	S1082 
21270	322	S1082 
21271	322	S2108 
21272	322	S2108 
21273	322	S2108 
21274	322	S2108 
21275	322	S2108 
21276	322	S2108 
21277	322	S2110 
21278	322	S2110 
21279	322	S2110 
21280	322	S2110 
21281	322	S2110 
21282	322	S2110 
21283	322	S2111 
21284	322	S2111 
21285	322	S2111 
21286	322	S2111 
21287	322	S2112 
21288	322	S2112 
21289	322	S2112 
21290	322	S2112 
21291	322	S2112 
21292	322	S2112 
21293	322	S2782 
21294	322	S2782 
21295	322	S2782 
21296	322	S2782 
21297	322	S2782 
21298	322	S2782 
21299	322	S2110 
21299	322	S2111 
21299	322	S2112 
21299	322	S2782 
21300	322	S2110 
21300	322	S2112 
21300	322	S2782 
21301	322	S2110 
21301	322	S2111 
21301	322	S2112 
21301	322	S2782 
21302	322	S2110 
21302	322	S2111 
21302	322	S2112 
21302	322	S2782 
21303	322	S2110 
21303	322	S2112 
21303	322	S2782 
21304	322	S2110 
21304	322	S2111 
21304	322	S2112 
21304	322	S2782 
23582	322	S2    
23583	322	S2    
23585	322	S2    
23586	322	S2    
23587	322	S2    
23589	322	S2    
23590	322	S2    
23591	322	S2    
23592	322	S2    
23593	322	S2    
23594	322	S2    
23595	322	S2    
23596	322	S2    
23597	322	S2    
23599	322	S2    
23601	322	S2    
23603	322	S2    
23604	322	S2    
23607	322	S2    
23609	322	S2    
23613	322	S2    
23615	322	S2    
23616	322	S2    
23618	322	S2    
23619	322	S2    
23620	322	S2    
23623	322	S2    
23624	322	S2    
23626	322	S2    
23627	322	S2    
23628	322	S2    
23630	322	S2    
23631	322	S2    
23632	322	S2    
23634	322	S2    
23635	322	S2    
23636	322	S2    
23637	322	S2    
23640	322	S1581 
23646	322	S2    
23647	322	S2    
23648	322	S2    
23649	322	S2    
23650	322	S2    
23651	322	S2    
23652	322	S2    
23653	322	S2    
23654	322	S2    
23655	322	S2    
23656	322	S2    
23657	322	S2    
23658	322	S2    
23659	322	S2    
23660	322	S2    
01009	323	S81   
01029	323	S27   
01040	323	S27   
01069	323	S84   
01077	323	S27   
01079	323	S1063 
01082	323	S1063 
01085	323	S1063 
01088	323	S82   
01091	323	S82   
01103	323	S1163 
01123	323	S1063 
01123	323	S561  
01145	323	S84   
01202	323	S1163 
02003	323	S1069 
02007	323	D4561 
02009	323	S1069 
02010	323	S1069 
02011	323	D4561 
02014	323	D4561 
02015	323	S1069 
02020	323	S1069 
02021	323	S1069 
02024	323	S1069 
02025	323	D4561 
02026	323	S1069 
02027	323	S1069 
02028	323	S1069 
02029	323	S1069 
02030	323	S1069 
02033	323	S1069 
02043	323	S1069 
02046	323	S84   
04002	323	S84   
04018	323	S84   
04025	323	S22   
04031	323	S81   
04031	323	S87   
04042	323	S87   
04044	323	S87   
04047	323	S84   
04053	323	S87   
04055	323	S84   
04060	323	S84   
04506	323	S84   
04547	323	S81   
04547	323	S87   
04548	323	S81   
04548	323	S87   
04552	323	S81   
04552	323	S87   
04554	323	S81   
04554	323	S87   
04560	323	S81   
04560	323	S87   
04582	323	S82   
04582	323	S87   
04584	323	S84   
04586	323	S81   
04586	323	S87   
04587	323	S81   
04587	323	S87   
04610	323	S18   
04615	323	S81   
04615	323	S87   
04628	323	S18   
04630	323	S19   
04631	323	S20   
04641	323	S25   
04673	323	S2401 
04674	323	S2401 
04675	323	S2401 
04676	323	S2401 
04677	323	S2401 
05023	323	S1581 
05024	323	S1581 
05027	323	S1166 
05028	323	S1166 
05173	323	S1581 
05174	323	S1581 
05175	323	S1581 
05176	323	S1581 
05177	323	S1581 
05178	323	S1581 
05312	323	S26   
05313	323	S26   
05320	323	S26   
05661	323	S1166 
06094	323	S18   
06128	323	S18   
06159	323	S18   
06982	323	S18   
06983	323	S18   
07007	323	S1164 
07063	323	S1164 
07064	323	S1164 
07075	323	S1164 
07952	323	S1164 
07953	323	S1164 
07954	323	S1164 
07955	323	S1164 
07956	323	S1164 
07957	323	S1164 
07958	323	S1164 
07959	323	S1164 
07960	323	S1164 
08013	323	S84   
08025	323	S2662 
08028	323	S2664 
08058	323	S2664 
08065	323	S2662 
08067	323	S2664 
08074	323	S2662 
08147	323	S2422 
08258	323	S2664 
08259	323	S2662 
08283	323	S2664 
08284	323	S2664 
08286	323	S2664 
08318	323	S2664 
08345	323	S84   
08383	323	S2664 
08385	323	S2664 
08386	323	S2664 
08387	323	S2664 
08471	323	S2664 
08490	323	S2502 
08498	323	S2502 
08504	323	S2662 
08505	323	S2662 
08506	323	S2662 
08507	323	S2662 
08508	323	S2662 
08509	323	S2662 
09003	323	S561  
09003	323	S87   
09004	323	S84   
09011	323	S121  
09020	323	S84   
09032	323	S21   
09037	323	S1031 
09037	323	S121  
09037	323	S1621 
09037	323	S481  
09037	323	S502  
09038	323	S1031 
09038	323	S121  
09038	323	S1621 
09038	323	S481  
09038	323	S502  
09039	323	S121  
09040	323	S121  
09040	323	S481  
09040	323	S562  
09040	323	S87   
09042	323	S461  
09042	323	S566  
09050	323	S421  
09070	323	S121  
09070	323	S582  
09074	323	S84   
09078	323	S561  
09087	323	S564  
09094	323	S363  
09099	323	S84   
09100	323	S84   
09112	323	S482  
09112	323	S563  
09128	323	S84   
09132	323	S1062 
09132	323	S121  
09135	323	S121  
09135	323	S81   
09148	323	S1033 
09148	323	S363  
09160	323	S1065 
09181	323	S121  
09181	323	S461  
09181	323	S87   
09184	323	S562  
09191	323	S421  
09191	323	S84   
09193	323	S84   
09194	323	S84   
09195	323	S84   
09200	323	S482  
09200	323	S564  
09200	323	S84   
09202	323	S482  
09202	323	S564  
09215	323	S81   
09215	323	S84   
09218	323	S1065 
09236	323	S121  
09236	323	S461  
09246	323	S121  
09252	323	S541  
09259	323	S121  
09266	323	S441  
09266	323	S561  
09279	323	S121  
09279	323	S421  
09291	323	S121  
09291	323	S564  
09294	323	S84   
09298	323	S121  
09298	323	S564  
09302	323	S461  
09302	323	S566  
09316	323	S421  
09316	323	S566  
09326	323	S441  
09326	323	S461  
09326	323	S84   
09430	323	S441  
09430	323	S561  
09433	323	S2105 
10007	323	S1166 
10066	323	S1166 
10067	323	S1166 
10068	323	S1166 
10098	323	S1581 
10099	323	S1581 
10102	323	S1581 
10119	323	S1581 
10123	323	S1166 
10124	323	S1166 
10173	323	S1581 
10858	323	S1166 
10860	323	S1166 
10861	323	S1166 
10861	323	S502  
10862	323	S1166 
10863	323	S1581 
11090	323	S1121 
11090	323	S121  
11090	323	S564  
11090	323	S87   
11091	323	S1121 
11091	323	S564  
11096	323	S1121 
11096	323	S482  
11097	323	S482  
11124	323	S1062 
11124	323	S84   
11124	323	S87   
11125	323	S1062 
11143	323	S1121 
11143	323	S564  
11143	323	S84   
11143	323	S87   
11205	323	S1062 
11205	323	S121  
11206	323	S1062 
11206	323	S121  
11206	323	S81   
11243	323	S2941 
11250	323	S565  
11251	323	S481  
11251	323	S503  
11252	323	S121  
11252	323	S481  
11252	323	S562  
11252	323	S87   
11253	323	S565  
11257	323	S565  
11260	323	S121  
11260	323	S2941 
11263	323	S2941 
11265	323	S2941 
11267	323	S2941 
11282	323	S1062 
11282	323	S121  
11286	323	S1062 
11294	323	S563  
11333	323	S1062 
11333	323	S84   
11339	323	S1062 
11352	323	S563  
11353	323	S563  
11356	323	S563  
11359	323	S2105 
11360	323	S2105 
11394	323	S2105 
11395	323	S2105 
11398	323	S2105 
11399	323	S2105 
11402	323	S2105 
11403	323	S2105 
11411	323	S2105 
11412	323	S2105 
11429	323	S363  
11463	323	S25   
11464	323	S25   
11507	323	S1062 
11508	323	S1062 
11508	323	S121  
11510	323	S1062 
11529	323	S441  
11529	323	S503  
11529	323	S84   
11529	323	S87   
11530	323	S441  
11549	323	S81   
11549	323	S87   
11674	323	S563  
11709	323	S84   
11742	323	S1121 
11742	323	S564  
11757	323	S1062 
11771	323	S121  
11772	323	S84   
11774	323	S84   
11812	323	S121  
11821	323	S1062 
11828	323	S563  
11841	323	S2105 
11842	323	S2105 
11856	323	S25   
11875	323	S1062 
11875	323	S121  
11876	323	S1062 
11884	323	S441  
11886	323	S87   
11887	323	S81   
11921	323	S1062 
11935	323	S81   
11949	323	S81   
11950	323	S2941 
11987	323	S2941 
11992	323	S2941 
12014	323	D4561 
12036	323	S1504 
12037	323	S2142 
12037	323	S84   
12038	323	S2142 
12061	323	S141  
12062	323	S141  
12063	323	S141  
12065	323	S141  
12078	323	S1063 
12078	323	S503  
12078	323	S81   
12086	323	S502  
12086	323	S82   
12120	323	S83   
12121	323	S83   
12122	323	S83   
12131	323	S77   
12132	323	S77   
12142	323	S85   
12143	323	S85   
12144	323	S85   
12147	323	S502  
12147	323	S564  
12151	323	S86   
12152	323	S86   
12154	323	S941  
12155	323	S79   
12155	323	S87   
12201	323	S1164 
12220	323	D4743 
12220	323	S2109 
12537	323	S2142 
12537	323	S84   
12538	323	S2142 
12563	323	S141  
12565	323	S141  
12586	323	S502  
12586	323	S82   
12632	323	S77   
12643	323	S85   
12644	323	S85   
12652	323	S86   
13019	323	S2    
13020	323	S2    
13055	323	S2    
13065	323	S2    
13067	323	S2    
13068	323	S2    
13070	323	S2    
13096	323	S2    
13098	323	S2    
13165	323	S2    
13318	323	S1581 
13320	323	S1581 
13321	323	S1581 
13322	323	S1581 
13323	323	S1581 
13324	323	S1581 
13325	323	S1166 
13326	323	S1166 
13327	323	S1166 
13340	323	S1581 
13341	323	S1581 
13343	323	S2    
13369	323	S2    
13370	323	S2    
13373	323	S2    
13375	323	S2    
13377	323	S2    
13378	323	S2    
13391	323	S2    
13394	323	S2    
13398	323	S2    
13399	323	S2    
13401	323	S2    
13402	323	S2    
13404	323	S2    
13405	323	S2    
13407	323	S2    
13408	323	S2    
13410	323	S2    
13411	323	S2    
13413	323	S2    
13414	323	S2    
13415	323	S2    
13416	323	S2    
13417	323	S2    
13418	323	S2    
13419	323	S2    
13420	323	S2    
13421	323	S2    
13422	323	S2    
13423	323	S2    
13424	323	S2    
13425	323	S2    
13426	323	S2    
13439	323	S2    
13440	323	S2    
13441	323	S2    
13442	323	S2    
13443	323	S2    
13444	323	S2    
13445	323	S2    
13446	323	S2    
13447	323	S2    
13448	323	S2    
13449	323	S2    
13450	323	S2    
13451	323	S2    
13452	323	S2    
13453	323	S2    
13454	323	S2    
13455	323	S2    
13456	323	S2    
13485	323	S2    
13486	323	S2    
13487	323	S2    
13488	323	S2    
13490	323	S2    
13491	323	S2    
13492	323	S2    
13493	323	S2    
13565	323	S2703 
13566	323	S2703 
13567	323	S2703 
13805	323	S2    
13806	323	S2    
13809	323	S2    
13810	323	S2    
13811	323	S2    
13812	323	S2    
13813	323	S2    
13814	323	S2    
13850	323	S2    
13851	323	S2    
13853	323	S2    
13854	323	S2    
13856	323	S2    
13857	323	S2    
13868	323	S2    
13869	323	S2    
13870	323	S2    
13871	323	S2    
13872	323	S2    
13873	323	S2    
13874	323	S2    
13875	323	S2    
13876	323	S2    
13877	323	S2    
13878	323	S2    
13879	323	S2    
13880	323	S2    
13881	323	S2    
13882	323	S2    
13891	323	S2    
13893	323	S2    
13894	323	S2    
13896	323	S2    
13898	323	S2    
13900	323	S2    
13909	323	S2    
13910	323	S2    
13911	323	S2    
13912	323	S2    
13913	323	S2    
13914	323	S2    
13917	323	S2    
13918	323	S2    
13920	323	S2    
13921	323	S2    
13923	323	S2    
13924	323	S2    
13929	323	S2    
13930	323	S2    
13931	323	S2    
13932	323	S2    
13934	323	S2    
13935	323	S2    
13948	323	S2    
13949	323	S2    
13950	323	S2    
13951	323	S2    
13952	323	S2    
13953	323	S2    
13954	323	S2    
13955	323	S2    
13956	323	S2    
13957	323	S2    
13958	323	S2    
13959	323	S2    
13968	323	S2    
13969	323	S2    
13970	323	S2    
13971	323	S2    
13985	323	S2    
13988	323	S2703 
13989	323	S2703 
13992	323	S2703 
13994	323	S2703 
13997	323	S2703 
13998	323	S2703 
14003	323	S87   
14209	323	S1064 
14209	323	S1122 
14355	323	S81   
14462	323	S2109 
15015	323	S84   
15027	323	S1163 
15028	323	S84   
15028	323	S87   
15066	323	S84   
15073	323	S1163 
15083	323	S81   
15084	323	S81   
15087	323	S2109 
15119	323	S121  
15119	323	S81   
15121	323	S27   
15121	323	S87   
15126	323	S121  
15140	323	S121  
15141	323	S121  
15149	323	S84   
15149	323	S87   
15152	323	S84   
15152	323	S87   
15157	323	S121  
15162	323	S121  
15164	323	S121  
15172	323	S84   
15232	323	S1163 
15260	323	S2109 
15261	323	S1163 
15262	323	S1163 
16006	323	S1164 
16010	323	S1164 
16011	323	S1164 
16011	323	S87   
16028	323	S84   
16029	323	S1164 
16037	323	S1164 
16038	323	S1164 
16097	323	S22   
16098	323	S22   
16098	323	S84   
16098	323	S87   
16167	323	S2203 
16338	323	S1164 
16397	323	S22   
16398	323	S22   
16398	323	S84   
16398	323	S87   
17202	323	S1166 
17203	323	S1166 
17204	323	S1166 
17204	323	S502  
17218	323	S1581 
17219	323	S1581 
18001	323	S1162 
18002	323	S1162 
18079	323	S25   
18159	323	S21   
18166	323	S25   
18168	323	S25   
18215	323	S25   
18228	323	S23   
18231	323	S25   
18288	323	S27   
18350	323	S21   
18351	323	S21   
18352	323	S21   
18363	323	S22   
18364	323	S22   
18365	323	S27   
18376	323	S25   
18403	323	S27   
18927	323	S25   
18932	323	S27   
18933	323	S27   
18934	323	S27   
18935	323	S27   
18936	323	S27   
19064	323	S1164 
19078	323	S84   
19109	323	S1164 
19120	323	S81   
19155	323	S1164 
19226	323	S84   
20020	323	S84   
20027	323	S84   
20033	323	S121  
20036	323	S84   
20037	323	S84   
20046	323	S20   
20048	323	S20   
20081	323	S20   
20081	323	S82   
20081	323	S87   
20082	323	S20   
20083	323	S20   
20084	323	S20   
20099	323	S1163 
20099	323	S20   
20099	323	S82   
20100	323	S1163 
20100	323	S20   
20109	323	S2105 
20110	323	S2105 
20120	323	S1163 
20120	323	S20   
20120	323	S82   
20121	323	S1163 
20121	323	S20   
20310	323	S2105 
20321	323	S1163 
20321	323	S20   
20400	323	S1163 
20400	323	S20   
20409	323	S2105 
20410	323	S2105 
20420	323	S1163 
20420	323	S20   
20420	323	S82   
20421	323	S1163 
20421	323	S20   
20446	323	S20   
20499	323	S1163 
20499	323	S20   
20499	323	S82   
20510	323	S2105 
20521	323	S1163 
20521	323	S20   
20581	323	S20   
20623	323	S1742 
20624	323	S1742 
20628	323	S1742 
20629	323	S1742 
20630	323	S1742 
20634	323	S1742 
20635	323	S1742 
20636	323	S1742 
20640	323	S1742 
20641	323	S1742 
20645	323	S1742 
20646	323	S1742 
21138	323	S1064 
21138	323	S1122 
21141	323	S1064 
21229	323	S1122 
21238	323	S2801 
21249	323	S1064 
21250	323	S1064 
21251	323	S1064 
21252	323	S1064 
21253	323	S1064 
21255	323	S1064 
21256	323	S1064 
21260	323	S1082 
21261	323	S1082 
21262	323	S1082 
21263	323	S1082 
21264	323	S1082 
21265	323	S1082 
21266	323	S1082 
21267	323	S1082 
21268	323	S1082 
21269	323	S1082 
21270	323	S1082 
21271	323	S2108 
21272	323	S2108 
21273	323	S2108 
21274	323	S2108 
21275	323	S2108 
21276	323	S2108 
21277	323	S2110 
21278	323	S2110 
21279	323	S2110 
21280	323	S2110 
21281	323	S2110 
21282	323	S2110 
21283	323	S2111 
21284	323	S2111 
21285	323	S2111 
21286	323	S2111 
21287	323	S2112 
21288	323	S2112 
21289	323	S2112 
21290	323	S2112 
21291	323	S2112 
21292	323	S2112 
21293	323	S2782 
21294	323	S2782 
21295	323	S2782 
21296	323	S2782 
21297	323	S2782 
21298	323	S2782 
21299	323	S2110 
21299	323	S2111 
21299	323	S2112 
21299	323	S2782 
21300	323	S2110 
21300	323	S2112 
21300	323	S2782 
21301	323	S2110 
21301	323	S2111 
21301	323	S2112 
21301	323	S2782 
21302	323	S2110 
21302	323	S2111 
21302	323	S2112 
21302	323	S2782 
21303	323	S2110 
21303	323	S2112 
21303	323	S2782 
21304	323	S2110 
21304	323	S2111 
21304	323	S2112 
21304	323	S2782 
21308	323	S2801 
21310	323	S2801 
21311	323	S2801 
21313	323	S2801 
21314	323	S2801 
21315	323	S2801 
21316	323	S2801 
21317	323	S2801 
21318	323	S2801 
21319	323	S2801 
21320	323	S2801 
21321	323	S2801 
21322	323	S2801 
21323	323	S2801 
21324	323	S2801 
21325	323	S2801 
21326	323	S2801 
21337	323	S2801 
21342	323	S2801 
21343	323	S2801 
21346	323	S2801 
21347	323	S2801 
21348	323	S2801 
22909	323	S22   
23011	323	S2703 
23014	323	S2703 
23015	323	S2703 
23018	323	S2703 
23019	323	S2703 
23020	323	S2703 
23021	323	S2703 
23022	323	S2703 
23023	323	S2703 
23024	323	S2703 
23025	323	S2703 
23027	323	S2703 
23028	323	S2703 
23029	323	S2703 
23030	323	S2703 
23031	323	S2703 
23034	323	S2703 
23035	323	S2703 
23037	323	S2703 
23038	323	S2703 
23041	323	S2703 
23042	323	S2703 
23045	323	S2703 
23046	323	S2703 
23049	323	S2703 
23050	323	S2703 
23053	323	S2703 
23054	323	S2703 
23055	323	S2703 
23056	323	S2703 
23057	323	S2703 
23058	323	S2703 
23059	323	S2703 
23060	323	S2703 
23061	323	S2703 
23062	323	S2703 
23063	323	S2703 
23064	323	S2703 
23568	323	S14   
23582	323	S2    
23583	323	S2    
23584	323	S2    
23585	323	S2    
23586	323	S2    
23587	323	S2    
23588	323	S2    
23589	323	S2    
23590	323	S2    
23591	323	S2    
23592	323	S2    
23593	323	S2    
23594	323	S2    
23595	323	S2    
23596	323	S2    
23597	323	S2    
23598	323	S2    
23599	323	S2    
23600	323	S2    
23601	323	S2    
23602	323	S2    
23603	323	S2    
23604	323	S2    
23605	323	S2    
23606	323	S2    
23607	323	S2    
23608	323	S2    
23609	323	S2    
23610	323	S2    
23611	323	S2    
23612	323	S2    
23613	323	S2    
23614	323	S2    
23615	323	S2    
23616	323	S2    
23617	323	S2    
23618	323	S2    
23619	323	S2    
23620	323	S2    
23621	323	S2    
23622	323	S2    
23623	323	S2    
23624	323	S2    
23625	323	S2    
23626	323	S2    
23627	323	S2    
23628	323	S2    
23629	323	S2    
23630	323	S2    
23631	323	S2    
23632	323	S2    
23633	323	S2    
23634	323	S2    
23635	323	S2    
23636	323	S2    
23637	323	S2    
23638	323	S2    
23640	323	S1581 
23646	323	S2    
23647	323	S2    
23648	323	S2    
23649	323	S2    
23650	323	S2    
23651	323	S2    
23652	323	S2    
23653	323	S2    
23654	323	S2    
23655	323	S2    
23656	323	S2    
23657	323	S2    
23658	323	S2    
23659	323	S2    
23660	323	S2    
35001	323	D4961 
35002	323	D4961 
35009	323	D4961 
35010	323	D4961 
35011	323	D4961 
35012	323	D4961 
35130	323	S2381 
35131	323	S2381 
35132	323	S2381 
35133	323	S2381 
35134	323	S2381 
35135	323	S2381 
35136	323	S2381 
35137	323	S2381 
35138	323	S2381 
35140	323	S2381 
35141	323	S2381 
35142	323	S2381 
35143	323	S2381 
35144	323	S2381 
35145	323	S2381 
35146	323	S2381 
35147	323	S2381 
35148	323	S2381 
43329	323	S25   
43378	323	S1166 
01077	324	S27   
01079	324	S1063 
01079	324	S20   
01082	324	S1063 
01085	324	S1063 
01123	324	S1063 
01123	324	S561  
01125	324	S1065 
07004	324	S248  
07008	324	S238  
07015	324	S248  
07016	324	S248  
07035	324	S248  
07056	324	S248  
07057	324	S238  
07070	324	S238  
07913	324	S238  
08001	324	S2664 
08003	324	S2664 
08005	324	S2664 
08010	324	S702  
08011	324	S702  
08012	324	S702  
08013	324	S603  
08014	324	S2664 
08017	324	S603  
08018	324	S702  
08020	324	S2664 
08023	324	S2664 
08026	324	S603  
08028	324	S2664 
08030	324	S2161 
08032	324	S2664 
08035	324	S603  
08045	324	S603  
08047	324	S702  
08048	324	S603  
08049	324	S702  
08050	324	S603  
08054	324	S702  
08057	324	S603  
08058	324	S2664 
08059	324	S702  
08060	324	S2664 
08064	324	S603  
08066	324	S702  
08068	324	S2664 
08069	324	S2664 
08071	324	S2664 
08077	324	S603  
08078	324	S603  
08082	324	S603  
08083	324	S2502 
08085	324	S702  
08086	324	S603  
08087	324	S603  
08089	324	S603  
08092	324	S702  
08094	324	S702  
08124	324	S702  
08128	324	S702  
08130	324	S702  
08138	324	S2502 
08139	324	S603  
08146	324	S702  
08147	324	S2422 
08189	324	S2664 
08190	324	S603  
08194	324	S603  
08200	324	S702  
08202	324	S603  
08206	324	S2502 
08210	324	S702  
08211	324	S702  
08212	324	S702  
08214	324	S702  
08215	324	S702  
08216	324	S702  
08217	324	S2664 
08218	324	S702  
08219	324	S702  
08220	324	S702  
08221	324	S702  
08225	324	S702  
08229	324	S702  
08231	324	S702  
08232	324	S702  
08243	324	S603  
08245	324	S603  
08246	324	S603  
08247	324	S603  
08253	324	S2664 
08258	324	S2664 
08259	324	S2664 
08261	324	S603  
08262	324	S603  
08263	324	S603  
08266	324	S603  
08267	324	S603  
08269	324	S603  
08272	324	S603  
08273	324	S603  
08274	324	S603  
08278	324	S603  
08283	324	S2664 
08284	324	S2664 
08286	324	S2664 
08288	324	S2664 
08293	324	S702  
08294	324	S702  
08299	324	S702  
08309	324	S2664 
08317	324	S702  
08318	324	S2664 
08345	324	S603  
08348	324	S2502 
08349	324	S2502 
08350	324	S2502 
08351	324	S702  
08352	324	S702  
08353	324	S702  
08354	324	S702  
08355	324	S702  
08357	324	S702  
08358	324	S702  
08359	324	S702  
08360	324	S702  
08361	324	S702  
08362	324	S702  
08363	324	S702  
08364	324	S702  
08366	324	S702  
08367	324	S603  
08368	324	S603  
08370	324	S603  
08371	324	S603  
08372	324	S603  
08374	324	S2664 
08376	324	S2664 
08380	324	S2664 
08385	324	S2664 
08394	324	S702  
08395	324	S702  
08396	324	S702  
08397	324	S603  
08398	324	S603  
08399	324	S603  
08400	324	S881  
08401	324	S881  
08402	324	S702  
08403	324	S1209 
08408	324	S2502 
08409	324	S2502 
08410	324	S702  
08411	324	S702  
08412	324	S702  
08413	324	S702  
08414	324	S702  
08415	324	S702  
08416	324	S702  
08417	324	S702  
08418	324	S702  
08419	324	S702  
08420	324	S702  
08421	324	S702  
08422	324	S702  
08436	324	S702  
08444	324	S702  
08446	324	S702  
08448	324	S702  
08449	324	S702  
08450	324	S702  
08454	324	S2664 
08455	324	S2664 
08456	324	S2664 
08457	324	S2664 
08458	324	S2664 
08460	324	S2664 
08465	324	S2664 
08466	324	S2664 
08468	324	S2664 
08469	324	S2664 
08470	324	S2664 
08472	324	S2664 
08473	324	S2664 
08474	324	S2664 
08476	324	S2502 
08478	324	S2502 
08481	324	S2502 
08484	324	S2502 
08487	324	S2502 
08490	324	S2502 
08491	324	S2502 
08493	324	S2502 
08494	324	S2502 
08495	324	S2502 
08497	324	S2502 
08498	324	S2502 
08501	324	S2502 
15087	324	S2109 
15260	324	S2109 
21265	324	S1082 
21277	324	S2110 
21280	324	S2110 
21283	324	S2111 
21284	324	S2111 
21287	324	S2112 
21288	324	S2112 
21293	324	S2782 
21294	324	S2782 
21296	324	S2782 
21297	324	S2782 
21299	324	S2110 
21299	324	S2111 
21299	324	S2112 
21299	324	S2782 
21300	324	S2782 
21302	324	S2110 
21302	324	S2111 
21302	324	S2112 
21302	324	S2782 
21303	324	S2782 
21346	324	S2801 
21348	324	S2801 
01001	334	S1203 
01009	334	S1203 
01077	334	S1203 
01077	334	S27   
01103	334	S1163 
01123	334	S1063 
01123	334	S1203 
01125	334	S1065 
01145	334	S1203 
01202	334	S1163 
02009	334	S1069 
02010	334	S1069 
02015	334	S1069 
02020	334	S1069 
02021	334	S1069 
02024	334	S1069 
02026	334	S1069 
02028	334	D4721 
02028	334	S1069 
02029	334	S1069 
02030	334	S1069 
02033	334	S1069 
02043	334	S1069 
02044	334	D4701 
02044	334	S1069 
02054	334	S1202 
02055	334	S1202 
04017	334	S19   
04020	334	S19   
04021	334	S19   
04023	334	S19   
04114	334	S19   
04120	334	S19   
04141	334	S19   
04142	334	S19   
04143	334	S19   
04144	334	S19   
04367	334	S19   
04635	334	S19   
04636	334	S19   
05023	334	S1581 
05024	334	S1581 
05027	334	S1082 
05028	334	S1082 
05173	334	S1581 
05175	334	S1581 
05177	334	S1581 
05178	334	S1581 
05661	334	S1082 
06040	334	D3851 
06068	334	D3851 
06071	334	D3851 
06159	334	D3851 
06164	334	S23   
06931	334	S22   
07007	334	S1164 
07063	334	S1164 
07063	334	S582  
07064	334	S1164 
07075	334	S1164 
07083	334	S281  
07276	334	S259  
07276	334	S281  
07277	334	S259  
07278	334	S259  
07906	334	S281  
07908	334	S281  
07909	334	S259  
07910	334	S245  
07911	334	S226  
07912	334	S226  
07913	334	S238  
07914	334	S252  
07915	334	S281  
07916	334	S242  
07917	334	S242  
07918	334	S242  
07919	334	S252  
07920	334	S242  
07921	334	S228  
07922	334	S242  
07923	334	S245  
07924	334	S242  
07925	334	S281  
07926	334	S228  
07927	334	S227  
07928	334	S225  
07929	334	S227  
07930	334	S222  
07932	334	S224  
07933	334	S224  
07934	334	S281  
07935	334	S224  
07936	334	S247  
07937	334	S239  
07938	334	S233  
07939	334	S235  
07940	334	S237  
07941	334	S281  
07943	334	S281  
07944	334	S227  
07952	334	S1164 
07953	334	S1164 
07953	334	S582  
07954	334	S582  
07955	334	S1164 
07956	334	S1164 
07957	334	S1164 
07958	334	S1164 
07959	334	S1164 
07960	334	S1164 
08020	334	S1065 
08259	334	S2662 
08505	334	S2662 
08506	334	S2662 
08507	334	S2662 
08508	334	S2662 
09003	334	S502  
09003	334	S561  
09004	334	S502  
09021	334	D3887 
09021	334	D3924 
09021	334	D3949 
09032	334	S21   
09037	334	S1621 
09037	334	S381  
09037	334	S481  
09037	334	S502  
09037	334	S986  
09038	334	S1621 
09038	334	S481  
09038	334	S502  
09038	334	S986  
09039	334	S381  
09040	334	S481  
09040	334	S562  
09042	334	S461  
09042	334	S566  
09050	334	D3887 
09050	334	S421  
09050	334	S441  
09059	334	D3899 
09060	334	D3899 
09062	334	S381  
09070	334	S582  
09078	334	S561  
09084	334	D3919 
09087	334	S564  
09087	334	S582  
09094	334	S363  
09094	334	S582  
09112	334	D3887 
09112	334	D3904 
09112	334	D3912 
09112	334	S1203 
09112	334	S482  
09112	334	S563  
09116	334	D3919 
09139	334	D3899 
09148	334	S363  
09148	334	S582  
09149	334	D3899 
09149	334	S381  
09150	334	D3949 
09160	334	S1065 
09176	334	D3899 
09177	334	S1202 
09181	334	D3887 
09181	334	D3904 
09181	334	S1121 
09181	334	S1203 
09181	334	S461  
09183	334	S381  
09184	334	S562  
09184	334	S565  
09191	334	S1206 
09191	334	S421  
09191	334	S582  
09195	334	D3919 
09195	334	S1202 
09200	334	S1203 
09200	334	S482  
09202	334	S1203 
09202	334	S482  
09215	334	D3848 
09215	334	D3912 
09215	334	S1203 
09215	334	S23   
09218	334	S1065 
09218	334	S1203 
09221	334	D3849 
09224	334	D3912 
09226	334	D3842 
09226	334	D3912 
09226	334	S1203 
09231	334	D3899 
09236	334	D3887 
09236	334	D3904 
09236	334	S1203 
09236	334	S461  
09236	334	S582  
09252	334	S482  
09252	334	S541  
09263	334	D3842 
09263	334	D3912 
09264	334	D3899 
09266	334	S441  
09266	334	S561  
09279	334	S421  
09279	334	S582  
09287	334	D3899 
09287	334	S1202 
09291	334	S1341 
09291	334	S564  
09291	334	S566  
09295	334	D3899 
09298	334	S564  
09298	334	S566  
09301	334	S1202 
09302	334	D3887 
09302	334	D3899 
09302	334	S461  
09302	334	S566  
09307	334	D3919 
09316	334	S421  
09316	334	S566  
09326	334	D3912 
09326	334	S1203 
09326	334	S441  
09326	334	S461  
09351	334	S1203 
09357	334	D3919 
09357	334	D3924 
09370	334	D3904 
09370	334	D3912 
09421	334	S564  
09421	334	S582  
09422	334	S1202 
09429	334	S441  
09430	334	S441  
09430	334	S561  
09431	334	S2203 
09432	334	S2203 
10098	334	S1581 
10102	334	S1581 
10173	334	S1581 
10863	334	S1581 
11008	334	S565  
11011	334	D3887 
11012	334	S1069 
11052	334	D3887 
11052	334	D3905 
11086	334	D3887 
11090	334	D3887 
11090	334	D3901 
11090	334	S1121 
11090	334	S1164 
11090	334	S564  
11091	334	S1121 
11091	334	S564  
11096	334	S1121 
11096	334	S482  
11097	334	S482  
11098	334	D3901 
11099	334	D3901 
11109	334	D3901 
11109	334	S1202 
11112	334	S1065 
11113	334	S1065 
11124	334	D3887 
11124	334	S1062 
11125	334	S1062 
11128	334	D3902 
11143	334	S1121 
11143	334	S564  
11147	334	D3887 
11149	334	S1202 
11157	334	D3870 
11157	334	S1202 
11158	334	D3870 
11165	334	D3969 
11170	334	D3907 
11179	334	S405  
11233	334	D3901 
11234	334	D3901 
11250	334	S565  
11251	334	S481  
11251	334	S503  
11252	334	D3887 
11252	334	S1203 
11252	334	S481  
11252	334	S562  
11253	334	S541  
11253	334	S565  
11257	334	S541  
11257	334	S565  
11294	334	S563  
11294	334	S582  
11297	334	D3919 
11304	334	D3887 
11308	334	S1203 
11333	334	D3887 
11333	334	S1062 
11339	334	S1062 
11352	334	S563  
11352	334	S566  
11353	334	S563  
11353	334	S566  
11354	334	S566  
11355	334	S566  
11356	334	S563  
11356	334	S566  
11357	334	S563  
11357	334	S566  
11358	334	S563  
11358	334	S566  
11424	334	D3902 
11429	334	S1121 
11429	334	S363  
11457	334	D3887 
11457	334	D3901 
11457	334	D3905 
11458	334	D3905 
11467	334	S1203 
11477	334	S1203 
11482	334	D3903 
11484	334	D3903 
11507	334	D3887 
11507	334	D3902 
11507	334	S1062 
11510	334	D3902 
11529	334	D3905 
11529	334	S441  
11529	334	S503  
11530	334	D3905 
11530	334	S441  
11540	334	D3851 
11546	334	S21   
11549	334	S21   
11578	334	D3851 
11641	334	S1203 
11674	334	S563  
11674	334	S566  
11697	334	S1202 
11702	334	S565  
11705	334	S1069 
11742	334	S1121 
11742	334	S564  
11745	334	D3901 
11752	334	S1065 
11758	334	D3902 
11759	334	D3902 
11767	334	D3870 
11771	334	D3907 
11774	334	S405  
11790	334	D3901 
11813	334	S1203 
11821	334	D3912 
11821	334	S1062 
11828	334	S563  
11828	334	S566  
11854	334	D3905 
11876	334	D3902 
11884	334	D3905 
11884	334	S441  
11886	334	D3851 
11887	334	S21   
11888	334	S21   
11921	334	S1062 
11935	334	S22   
11949	334	S22   
11970	334	S1202 
11972	334	S1202 
11973	334	S1202 
11975	334	S1202 
11976	334	S1202 
11989	334	S1202 
11990	334	S1202 
11991	334	S1202 
12038	334	S1202 
12061	334	S441  
12061	334	S503  
12071	334	S1202 
12078	334	S503  
12086	334	S363  
12086	334	S502  
12120	334	S503  
12142	334	S1121 
12142	334	S363  
12152	334	S563  
12152	334	S565  
12155	334	S481  
12155	334	S563  
12220	334	S2109 
12538	334	S1202 
12586	334	S363  
12586	334	S502  
12632	334	S363  
12632	334	S566  
12652	334	S563  
12652	334	S565  
13067	334	S2    
13070	334	S2    
13096	334	S2    
13098	334	S2    
13165	334	S2    
13318	334	S1581 
13321	334	S1581 
13323	334	S1581 
13325	334	S1082 
13326	334	S1082 
13327	334	S1082 
13343	334	S2    
13369	334	S2    
13370	334	S2    
13373	334	S2    
13375	334	S2    
13377	334	S2    
13378	334	S2    
13391	334	S2    
13394	334	S2    
13398	334	S2    
13399	334	S2    
13401	334	S2    
13402	334	S2    
13404	334	S2    
13405	334	S2    
13407	334	S2    
13408	334	S2    
13410	334	S2    
13411	334	S2    
13413	334	S2    
13414	334	S2    
13415	334	S2    
13416	334	S2    
13417	334	S2    
13418	334	S2    
13419	334	S2    
13420	334	S2    
13422	334	S2    
13423	334	S2    
13424	334	S2    
13425	334	S2    
13426	334	S2    
13439	334	S2    
13440	334	S2    
13441	334	S2    
13442	334	S2    
13443	334	S2    
13444	334	S2    
13445	334	S2    
13446	334	S2    
13447	334	S2    
13448	334	S2    
13449	334	S2    
13450	334	S2    
13451	334	S2    
13452	334	S2    
13453	334	S2    
13455	334	S2    
13456	334	S2    
13485	334	S2    
13486	334	S2    
13487	334	S2    
13488	334	S2    
13490	334	S2    
13491	334	S2    
13492	334	S2    
13493	334	S2    
13805	334	S2    
13806	334	S2    
13809	334	S2    
13811	334	S2    
13813	334	S2    
13850	334	S2    
13853	334	S2    
13854	334	S2    
13856	334	S2    
13857	334	S2    
13868	334	S2    
13870	334	S2    
13871	334	S2    
13873	334	S2    
13874	334	S2    
13875	334	S2    
13876	334	S2    
13877	334	S2    
13879	334	S2    
13880	334	S2    
13881	334	S2    
13882	334	S2    
13891	334	S2    
13894	334	S2    
13896	334	S2    
13898	334	S2    
13900	334	S2    
13909	334	S2    
13911	334	S2    
13912	334	S2    
13913	334	S2    
13914	334	S2    
13917	334	S2    
13920	334	S2    
13921	334	S2    
13923	334	S2    
13924	334	S2    
13929	334	S2    
13931	334	S2    
13932	334	S2    
13934	334	S2    
13935	334	S2    
13948	334	S2    
13949	334	S2    
13950	334	S2    
13951	334	S2    
13952	334	S2    
13953	334	S2    
13954	334	S2    
13955	334	S2    
13956	334	S2    
13957	334	S2    
13958	334	S2    
13959	334	S2    
13968	334	S2    
13969	334	S2    
13970	334	S2    
13971	334	S2    
13985	334	S2    
14242	334	S2104 
16006	334	S1164 
16010	334	S1164 
16011	334	S1164 
16042	334	S1065 
16043	334	S1065 
16089	334	S563  
16126	334	S1202 
16144	334	S1202 
16343	334	S1065 
17202	334	S1082 
17203	334	S1082 
17204	334	S1082 
17218	334	S1581 
17219	334	S1581 
18079	334	S25   
18376	334	S25   
19003	334	S26   
19064	334	S1164 
19076	334	S1164 
19078	334	S1069 
19109	334	S1164 
19120	334	S1069 
19155	334	S1164 
20017	334	S1343 
20022	334	S1203 
20081	334	S20   
20083	334	S20   
20084	334	S20   
20130	334	S1202 
20322	334	S1343 
20581	334	S20   
21138	334	S1122 
21260	334	S1082 
21261	334	S1082 
21262	334	S1082 
21263	334	S1082 
21264	334	S1082 
21265	334	S1082 
21266	334	S1082 
21267	334	S1082 
21268	334	S1082 
21269	334	S1082 
21270	334	S1082 
21271	334	S2108 
21272	334	S2108 
21273	334	S2108 
21274	334	S2108 
21275	334	S2108 
21276	334	S2108 
21277	334	S2110 
21278	334	S2110 
21279	334	S2110 
21280	334	S2110 
21281	334	S2110 
21282	334	S2110 
21283	334	S2111 
21284	334	S2111 
21285	334	S2111 
21286	334	S2111 
21287	334	S2112 
21288	334	S2112 
21289	334	S2112 
21290	334	S2112 
21291	334	S2112 
21292	334	S2112 
21293	334	S2782 
21294	334	S2782 
21295	334	S2782 
21296	334	S2782 
21297	334	S2782 
21298	334	S2782 
21299	334	S2110 
21299	334	S2111 
21299	334	S2112 
21299	334	S2782 
21300	334	S2110 
21300	334	S2112 
21300	334	S2782 
21301	334	S2110 
21301	334	S2111 
21301	334	S2112 
21301	334	S2782 
21302	334	S2110 
21302	334	S2111 
21302	334	S2112 
21302	334	S2782 
21303	334	S2110 
21303	334	S2112 
21303	334	S2782 
21304	334	S2110 
21304	334	S2111 
21304	334	S2112 
21304	334	S2782 
23582	334	S2    
23583	334	S2    
23585	334	S2    
23586	334	S2    
23587	334	S2    
23589	334	S2    
23590	334	S2    
23591	334	S2    
23592	334	S2    
23593	334	S2    
23594	334	S2    
23595	334	S2    
23596	334	S2    
23597	334	S2    
23599	334	S2    
23601	334	S2    
23603	334	S2    
23604	334	S2    
23607	334	S2    
23609	334	S2    
23613	334	S2    
23615	334	S2    
23616	334	S2    
23618	334	S2    
23619	334	S2    
23620	334	S2    
23623	334	S2    
23624	334	S2    
23626	334	S2    
23627	334	S2    
23628	334	S2    
23630	334	S2    
23631	334	S2    
23632	334	S2    
23634	334	S2    
23635	334	S2    
23636	334	S2    
23637	334	S2    
23640	334	S1581 
23646	334	S2    
23647	334	S2    
23648	334	S2    
23649	334	S2    
23650	334	S2    
23651	334	S2    
23652	334	S2    
23653	334	S2    
23654	334	S2    
23655	334	S2    
23656	334	S2    
23657	334	S2    
23658	334	S2    
23659	334	S2    
23660	334	S2    
01001	337	S1203 
01009	337	S1203 
01077	337	S1203 
01077	337	S27   
01103	337	S1163 
01123	337	S1063 
01123	337	S1203 
01125	337	S1065 
01145	337	S1203 
01202	337	S1163 
02003	337	S1069 
02009	337	S1069 
02010	337	S1069 
02011	337	S1069 
02015	337	S1069 
02020	337	S1069 
02021	337	S1069 
02024	337	S1069 
02026	337	S1069 
02027	337	S1069 
02028	337	S1069 
02029	337	S1069 
02030	337	S1069 
02033	337	S1069 
02043	337	S1069 
02044	337	D4701 
04017	337	S19   
04020	337	S19   
04021	337	S19   
04023	337	S19   
04114	337	S19   
04120	337	S19   
04141	337	S19   
04142	337	S19   
04143	337	S19   
04144	337	S19   
04367	337	S19   
04635	337	S19   
04636	337	S19   
05023	337	S1581 
05024	337	S1581 
05027	337	S1082 
05028	337	S1082 
05173	337	S1581 
05175	337	S1581 
05176	337	S1581 
05177	337	S1581 
05178	337	S1581 
05661	337	S1082 
06040	337	D3851 
06068	337	D3851 
06071	337	D3851 
06159	337	D3851 
06164	337	S23   
06931	337	S22   
07007	337	S1164 
07063	337	S1164 
07063	337	S582  
07064	337	S1164 
07075	337	S1164 
07083	337	S281  
07276	337	S259  
07276	337	S281  
07277	337	S259  
07278	337	S259  
07906	337	S281  
07908	337	S281  
07909	337	S259  
07910	337	S245  
07911	337	S226  
07912	337	S226  
07913	337	S238  
07914	337	S252  
07915	337	S281  
07916	337	S242  
07917	337	S242  
07918	337	S242  
07919	337	S252  
07920	337	S242  
07921	337	S228  
07922	337	S242  
07923	337	S245  
07924	337	S242  
07925	337	S281  
07926	337	S228  
07927	337	S227  
07928	337	S225  
07929	337	S227  
07930	337	S222  
07932	337	S224  
07933	337	S224  
07934	337	S281  
07935	337	S224  
07936	337	S247  
07937	337	S239  
07938	337	S233  
07939	337	S235  
07940	337	S237  
07941	337	S281  
07943	337	S281  
07944	337	S227  
07952	337	S1164 
07953	337	S1164 
07953	337	S582  
07954	337	S582  
07955	337	S1164 
07956	337	S1164 
07957	337	S1164 
07958	337	S1164 
07959	337	S1164 
07960	337	S1164 
08020	337	S1065 
08259	337	S2662 
08505	337	S2662 
08506	337	S2662 
08507	337	S2662 
08508	337	S2662 
09003	337	S502  
09003	337	S561  
09004	337	S502  
09032	337	S21   
09037	337	S481  
09037	337	S502  
09038	337	S481  
09038	337	S502  
09040	337	S481  
09040	337	S562  
09042	337	S461  
09042	337	S566  
09050	337	S421  
09050	337	S441  
09060	337	D3969 
09070	337	S582  
09078	337	S561  
09084	337	D3919 
09087	337	S564  
09087	337	S582  
09094	337	S363  
09094	337	S582  
09112	337	D3845 
09112	337	D3904 
09112	337	S1203 
09112	337	S482  
09112	337	S563  
09116	337	D3919 
09132	337	D3919 
09139	337	D4863 
09139	337	D4864 
09148	337	S363  
09148	337	S582  
09150	337	D3919 
09160	337	S1065 
09181	337	D3904 
09181	337	S1121 
09181	337	S1203 
09181	337	S461  
09184	337	S562  
09184	337	S565  
09191	337	S421  
09191	337	S582  
09195	337	D3919 
09200	337	S1203 
09200	337	S482  
09202	337	S1203 
09202	337	S482  
09215	337	S1203 
09215	337	S23   
09218	337	S1065 
09218	337	S1203 
09226	337	S1203 
09236	337	D3904 
09236	337	S1203 
09236	337	S461  
09236	337	S582  
09252	337	S482  
09252	337	S541  
09263	337	D3842 
09266	337	S441  
09266	337	S561  
09279	337	S421  
09279	337	S582  
09291	337	S564  
09291	337	S566  
09298	337	S564  
09298	337	S566  
09302	337	S461  
09302	337	S566  
09307	337	D3919 
09316	337	S421  
09316	337	S566  
09326	337	D4801 
09326	337	S1203 
09326	337	S441  
09326	337	S461  
09351	337	S1203 
09370	337	D3904 
09421	337	S564  
09421	337	S582  
09429	337	S441  
09430	337	S441  
09430	337	S561  
09431	337	S2203 
09432	337	S2203 
10098	337	S1581 
10102	337	S1581 
10173	337	S1581 
10863	337	S1581 
11008	337	S565  
11012	337	S1069 
11052	337	D3905 
11090	337	D3901 
11090	337	S1121 
11090	337	S1164 
11090	337	S564  
11091	337	S1121 
11091	337	S564  
11096	337	S1121 
11096	337	S482  
11097	337	S482  
11098	337	D3901 
11099	337	D3901 
11109	337	D3901 
11112	337	S1065 
11113	337	S1065 
11124	337	D3911 
11124	337	S1062 
11125	337	S1062 
11128	337	D3902 
11143	337	S1121 
11143	337	S564  
11165	337	D3969 
11233	337	D3901 
11234	337	D3901 
11250	337	S565  
11251	337	S481  
11251	337	S503  
11252	337	S1203 
11252	337	S481  
11252	337	S562  
11253	337	S541  
11253	337	S565  
11257	337	S541  
11257	337	S565  
11294	337	S563  
11294	337	S582  
11297	337	D3919 
11308	337	S1203 
11333	337	S1062 
11339	337	S1062 
11352	337	S563  
11352	337	S566  
11353	337	S563  
11353	337	S566  
11354	337	S566  
11355	337	S566  
11356	337	S563  
11356	337	S566  
11357	337	S563  
11357	337	S566  
11358	337	S563  
11358	337	S566  
11424	337	D3902 
11429	337	S1121 
11429	337	S363  
11457	337	D3901 
11457	337	D3905 
11458	337	D3905 
11467	337	S1203 
11477	337	S1203 
11482	337	D3903 
11484	337	D3903 
11507	337	D3902 
11507	337	S1062 
11510	337	D3902 
11529	337	D3905 
11529	337	D3933 
11529	337	S441  
11529	337	S503  
11530	337	D3905 
11530	337	S441  
11540	337	D3851 
11540	337	D3890 
11540	337	S1381 
11546	337	S21   
11549	337	S21   
11578	337	D3851 
11641	337	S1203 
11674	337	S563  
11674	337	S566  
11702	337	S565  
11705	337	S1069 
11742	337	S1121 
11742	337	S564  
11745	337	D3901 
11752	337	S1065 
11758	337	D3902 
11759	337	D3902 
11790	337	D3901 
11813	337	S1203 
11821	337	S1062 
11828	337	S563  
11828	337	S566  
11854	337	D3905 
11876	337	D3902 
11884	337	D3905 
11884	337	S441  
11886	337	D3851 
11886	337	D3890 
11886	337	S1381 
11887	337	S21   
11888	337	S21   
11921	337	S1062 
11935	337	S22   
11949	337	S22   
12061	337	S441  
12061	337	S503  
12078	337	S503  
12086	337	S363  
12086	337	S502  
12120	337	S503  
12142	337	S1121 
12142	337	S363  
12152	337	S563  
12152	337	S565  
12155	337	S481  
12155	337	S563  
12220	337	S2109 
12586	337	S363  
12586	337	S502  
12632	337	S363  
12632	337	S566  
12652	337	S563  
12652	337	S565  
13067	337	S2    
13070	337	S2    
13096	337	S2    
13098	337	S2    
13165	337	S2    
13318	337	S1581 
13321	337	S1581 
13323	337	S1581 
13324	337	S1581 
13325	337	S1082 
13343	337	S2    
13369	337	S2    
13370	337	S2    
13373	337	S2    
13375	337	S2    
13377	337	S2    
13378	337	S2    
13391	337	S2    
13394	337	S2    
13398	337	S2    
13399	337	S2    
13401	337	S2    
13402	337	S2    
13404	337	S2    
13405	337	S2    
13407	337	S2    
13408	337	S2    
13410	337	S2    
13411	337	S2    
13413	337	S2    
13414	337	S2    
13415	337	S2    
13416	337	S2    
13417	337	S2    
13418	337	S2    
13419	337	S2    
13420	337	S2    
13422	337	S2    
13423	337	S2    
13424	337	S2    
13425	337	S2    
13426	337	S2    
13439	337	S2    
13440	337	S2    
13441	337	S2    
13442	337	S2    
13443	337	S2    
13444	337	S2    
13445	337	S2    
13446	337	S2    
13447	337	S2    
13448	337	S2    
13449	337	S2    
13450	337	S2    
13451	337	S2    
13452	337	S2    
13453	337	S2    
13455	337	S2    
13456	337	S2    
13485	337	S2    
13486	337	S2    
13487	337	S2    
13488	337	S2    
13490	337	S2    
13491	337	S2    
13492	337	S2    
13493	337	S2    
13805	337	S2    
13806	337	S2    
13809	337	S2    
13811	337	S2    
13813	337	S2    
13850	337	S2    
13853	337	S2    
13854	337	S2    
13856	337	S2    
13857	337	S2    
13868	337	S2    
13870	337	S2    
13871	337	S2    
13873	337	S2    
13874	337	S2    
13875	337	S2    
13876	337	S2    
13877	337	S2    
13879	337	S2    
13880	337	S2    
13881	337	S2    
13882	337	S2    
13891	337	S2    
13894	337	S2    
13896	337	S2    
13898	337	S2    
13900	337	S2    
13909	337	S2    
13911	337	S2    
13912	337	S2    
13913	337	S2    
13914	337	S2    
13917	337	S2    
13920	337	S2    
13921	337	S2    
13923	337	S2    
13924	337	S2    
13929	337	S2    
13931	337	S2    
13932	337	S2    
13934	337	S2    
13935	337	S2    
13948	337	S2    
13949	337	S2    
13950	337	S2    
13951	337	S2    
13952	337	S2    
13953	337	S2    
13954	337	S2    
13955	337	S2    
13956	337	S2    
13957	337	S2    
13958	337	S2    
13959	337	S2    
13968	337	S2    
13969	337	S2    
13970	337	S2    
13971	337	S2    
13985	337	S2    
14242	337	S2104 
16006	337	S1164 
16010	337	S1164 
16011	337	S1164 
16042	337	S1065 
16043	337	S1065 
16089	337	S563  
16343	337	S1065 
17202	337	S1082 
17203	337	S1082 
17204	337	S1082 
17218	337	S1581 
17219	337	S1581 
18079	337	S25   
18376	337	S25   
19064	337	S1164 
19076	337	S1164 
19078	337	S1069 
19109	337	S1164 
19120	337	S1069 
19155	337	S1164 
20017	337	S1343 
20022	337	S1203 
20081	337	S20   
20083	337	S20   
20084	337	S20   
20322	337	S1343 
20581	337	S20   
21138	337	S1122 
21271	337	S2108 
21272	337	S2108 
21273	337	S2108 
21274	337	S2108 
21275	337	S2108 
21276	337	S2108 
21277	337	S2110 
21278	337	S2110 
21279	337	S2110 
21280	337	S2110 
21281	337	S2110 
21282	337	S2110 
21283	337	S2111 
21284	337	S2111 
21285	337	S2111 
21286	337	S2111 
21287	337	S2112 
21288	337	S2112 
21289	337	S2112 
21290	337	S2112 
21291	337	S2112 
21292	337	S2112 
21293	337	S2782 
21294	337	S2782 
21295	337	S2782 
21296	337	S2782 
21297	337	S2782 
21298	337	S2782 
21299	337	S2110 
21299	337	S2111 
21299	337	S2112 
21299	337	S2782 
21300	337	S2110 
21300	337	S2112 
21300	337	S2782 
21301	337	S2110 
21301	337	S2111 
21301	337	S2112 
21301	337	S2782 
21302	337	S2110 
21302	337	S2111 
21302	337	S2112 
21302	337	S2782 
21303	337	S2110 
21303	337	S2112 
21303	337	S2782 
21304	337	S2110 
21304	337	S2111 
21304	337	S2112 
21304	337	S2782 
23582	337	S2    
23583	337	S2    
23585	337	S2    
23586	337	S2    
23587	337	S2    
23589	337	S2    
23590	337	S2    
23591	337	S2    
23592	337	S2    
23593	337	S2    
23594	337	S2    
23595	337	S2    
23596	337	S2    
23597	337	S2    
23599	337	S2    
23601	337	S2    
23603	337	S2    
23604	337	S2    
23607	337	S2    
23609	337	S2    
23613	337	S2    
23615	337	S2    
23616	337	S2    
23618	337	S2    
23619	337	S2    
23620	337	S2    
23623	337	S2    
23624	337	S2    
23626	337	S2    
23627	337	S2    
23628	337	S2    
23630	337	S2    
23631	337	S2    
23632	337	S2    
23634	337	S2    
23635	337	S2    
23636	337	S2    
23637	337	S2    
23640	337	S1581 
23646	337	S2    
23647	337	S2    
23648	337	S2    
23649	337	S2    
23650	337	S2    
23651	337	S2    
23652	337	S2    
23653	337	S2    
23654	337	S2    
23655	337	S2    
23656	337	S2    
23657	337	S2    
23658	337	S2    
23659	337	S2    
23660	337	S2    
01001	338	S1203 
01009	338	S1203 
01077	338	S1203 
01077	338	S27   
01145	338	S1203 
02003	338	S1069 
02009	338	S1069 
02010	338	S1069 
02011	338	S1069 
02015	338	S1069 
02020	338	S1069 
02021	338	S1069 
02024	338	S1069 
02026	338	S1069 
02027	338	S1069 
02028	338	D4721 
02028	338	S1069 
02029	338	S1069 
02030	338	S1069 
02033	338	S1069 
02043	338	S1069 
02044	338	D4701 
02044	338	S1069 
06040	338	D3851 
06068	338	D3851 
06071	338	D3851 
06159	338	D3851 
06164	338	S23   
06931	338	S22   
07083	338	S281  
07276	338	S259  
07276	338	S281  
07277	338	S259  
07278	338	S259  
07906	338	S281  
07908	338	S281  
07909	338	S259  
07910	338	S245  
07911	338	S226  
07912	338	S226  
07913	338	S238  
07914	338	S252  
07915	338	S281  
07916	338	S242  
07917	338	S242  
07918	338	S242  
07919	338	S252  
07920	338	S242  
07921	338	S228  
07922	338	S242  
07923	338	S245  
07924	338	S242  
07925	338	S281  
07926	338	S228  
07927	338	S227  
07928	338	S225  
07929	338	S227  
07930	338	S222  
07932	338	S224  
07933	338	S224  
07934	338	S281  
07935	338	S224  
07936	338	S247  
07937	338	S239  
07938	338	S233  
07939	338	S235  
07941	338	S281  
07943	338	S281  
07944	338	S227  
08084	338	D3921 
08120	338	D3921 
09003	338	S502  
09003	338	S561  
09004	338	S502  
09021	338	D3924 
09021	338	D3949 
09032	338	S21   
09037	338	S1621 
09037	338	S481  
09037	338	S502  
09038	338	S1621 
09038	338	S481  
09038	338	S502  
09040	338	S481  
09040	338	S562  
09042	338	S461  
09042	338	S566  
09050	338	S421  
09050	338	S441  
09060	338	D3969 
09070	338	S582  
09078	338	S561  
09084	338	D3919 
09087	338	S564  
09087	338	S582  
09094	338	S363  
09094	338	S582  
09112	338	D3904 
09112	338	S1203 
09112	338	S482  
09112	338	S563  
09116	338	D3919 
09132	338	D3919 
09148	338	S363  
09148	338	S582  
09150	338	D3919 
09150	338	D3949 
09160	338	S1065 
09181	338	D3904 
09181	338	S1121 
09181	338	S1203 
09181	338	S461  
09184	338	S562  
09184	338	S565  
09191	338	S421  
09191	338	S582  
09195	338	D3919 
09200	338	S1203 
09200	338	S482  
09202	338	S1203 
09202	338	S482  
09215	338	S1203 
09215	338	S23   
09218	338	S1065 
09218	338	S1203 
09221	338	D3849 
09226	338	S1203 
09236	338	D3904 
09236	338	S1203 
09236	338	S461  
09236	338	S582  
09252	338	S482  
09252	338	S541  
09263	338	D3842 
09266	338	S441  
09266	338	S561  
09279	338	S421  
09279	338	S582  
09291	338	S1341 
09291	338	S564  
09291	338	S566  
09298	338	S564  
09298	338	S566  
09302	338	S461  
09302	338	S566  
09307	338	D3919 
09316	338	S421  
09316	338	S566  
09326	338	S1203 
09326	338	S441  
09326	338	S461  
09351	338	S1203 
09357	338	D3919 
09357	338	D3924 
09370	338	D3904 
09421	338	S564  
09421	338	S582  
09429	338	S441  
09430	338	S441  
09430	338	S561  
09431	338	S2203 
09432	338	S2203 
11008	338	S565  
11024	338	D3844 
11052	338	D3905 
11090	338	D3901 
11090	338	S1121 
11090	338	S564  
11091	338	D3890 
11091	338	S1121 
11091	338	S564  
11096	338	S1121 
11096	338	S482  
11097	338	S482  
11098	338	D3901 
11099	338	D3901 
11109	338	D3901 
11128	338	D3902 
11143	338	S1121 
11143	338	S564  
11157	338	D3869 
11158	338	D3869 
11165	338	D3956 
11165	338	D3969 
11233	338	D3901 
11234	338	D3901 
11250	338	S565  
11251	338	S481  
11251	338	S503  
11252	338	S1203 
11252	338	S481  
11252	338	S562  
11253	338	S565  
11257	338	S565  
11294	338	S563  
11294	338	S582  
11297	338	D3919 
11297	338	D3924 
11297	338	D3956 
11308	338	S1203 
11352	338	S563  
11352	338	S566  
11353	338	S563  
11355	338	S566  
11357	338	S563  
11358	338	S563  
11424	338	D3902 
11429	338	S1121 
11429	338	S363  
11457	338	D3901 
11457	338	D3905 
11458	338	D3905 
11467	338	S1203 
11477	338	S1203 
11482	338	D3903 
11484	338	D3903 
11507	338	D3902 
11510	338	D3902 
11529	338	D3905 
11529	338	S441  
11529	338	S503  
11530	338	D3905 
11530	338	S441  
11540	338	D3851 
11546	338	S21   
11549	338	S21   
11578	338	D3851 
11641	338	S1203 
11674	338	S563  
11702	338	S565  
11742	338	D3890 
11742	338	S1121 
11742	338	S564  
11745	338	D3901 
11758	338	D3902 
11759	338	D3902 
11767	338	D3869 
11790	338	D3901 
11813	338	S1203 
11828	338	S563  
11854	338	D3905 
11876	338	D3902 
11884	338	D3905 
11884	338	S441  
11886	338	D3851 
11887	338	S21   
11888	338	S21   
11935	338	S22   
11949	338	S22   
12061	338	S441  
12061	338	S503  
12078	338	S503  
12086	338	S363  
12086	338	S502  
12120	338	S503  
12142	338	S1121 
12142	338	S363  
12152	338	S563  
12152	338	S565  
12155	338	S481  
12155	338	S563  
12220	338	D4743 
12586	338	S363  
12586	338	S502  
12632	338	S363  
12632	338	S566  
12652	338	S563  
12652	338	S565  
13067	338	S2    
13070	338	S2    
13096	338	S2    
13098	338	S2    
13165	338	S2    
13343	338	S2    
13369	338	S2    
13370	338	S2    
13373	338	S2    
13375	338	S2    
13377	338	S2    
13378	338	S2    
13391	338	S2    
13394	338	S2    
13398	338	S2    
13399	338	S2    
13401	338	S2    
13402	338	S2    
13404	338	S2    
13405	338	S2    
13407	338	S2    
13408	338	S2    
13410	338	S2    
13411	338	S2    
13413	338	S2    
13414	338	S2    
13415	338	S2    
13416	338	S2    
13417	338	S2    
13418	338	S2    
13419	338	S2    
13420	338	S2    
13422	338	S2    
13423	338	S2    
13424	338	S2    
13425	338	S2    
13426	338	S2    
13439	338	S2    
13440	338	S2    
13441	338	S2    
13442	338	S2    
13443	338	S2    
13444	338	S2    
13445	338	S2    
13446	338	S2    
13447	338	S2    
13448	338	S2    
13449	338	S2    
13450	338	S2    
13451	338	S2    
13452	338	S2    
13453	338	S2    
13455	338	S2    
13456	338	S2    
13485	338	S2    
13486	338	S2    
13487	338	S2    
13488	338	S2    
13490	338	S2    
13491	338	S2    
13492	338	S2    
13493	338	S2    
13805	338	S2    
13806	338	S2    
13809	338	S2    
13811	338	S2    
13813	338	S2    
13850	338	S2    
13853	338	S2    
13854	338	S2    
13856	338	S2    
13857	338	S2    
13868	338	S2    
13870	338	S2    
13871	338	S2    
13873	338	S2    
13874	338	S2    
13875	338	S2    
13876	338	S2    
13877	338	S2    
13879	338	S2    
13880	338	S2    
13881	338	S2    
13882	338	S2    
13891	338	S2    
13894	338	S2    
13896	338	S2    
13898	338	S2    
13900	338	S2    
13909	338	S2    
13911	338	S2    
13912	338	S2    
13913	338	S2    
13914	338	S2    
13917	338	S2    
13920	338	S2    
13921	338	S2    
13923	338	S2    
13924	338	S2    
13929	338	S2    
13931	338	S2    
13932	338	S2    
13934	338	S2    
13935	338	S2    
13948	338	S2    
13949	338	S2    
13950	338	S2    
13951	338	S2    
13952	338	S2    
13953	338	S2    
13954	338	S2    
13955	338	S2    
13956	338	S2    
13957	338	S2    
13958	338	S2    
13959	338	S2    
13968	338	S2    
13969	338	S2    
13970	338	S2    
13971	338	S2    
13985	338	S2    
16089	338	S563  
20017	338	S1343 
20022	338	S1203 
20063	338	D3921 
20077	338	D3921 
20080	338	D3921 
20081	338	S20   
20083	338	S20   
20084	338	S20   
20130	338	D3921 
20322	338	S1343 
20581	338	S20   
21138	338	S1122 
23582	338	S2    
23583	338	S2    
23585	338	S2    
23586	338	S2    
23587	338	S2    
23589	338	S2    
23590	338	S2    
23591	338	S2    
23592	338	S2    
23593	338	S2    
23594	338	S2    
23595	338	S2    
23596	338	S2    
23597	338	S2    
23599	338	S2    
23601	338	S2    
23603	338	S2    
23604	338	S2    
23607	338	S2    
23609	338	S2    
23613	338	S2    
23615	338	S2    
23616	338	S2    
23618	338	S2    
23619	338	S2    
23620	338	S2    
23623	338	S2    
23624	338	S2    
23626	338	S2    
23627	338	S2    
23628	338	S2    
23630	338	S2    
23631	338	S2    
23632	338	S2    
23634	338	S2    
23635	338	S2    
23636	338	S2    
23637	338	S2    
23646	338	S2    
23647	338	S2    
23648	338	S2    
23649	338	S2    
23650	338	S2    
23651	338	S2    
23652	338	S2    
23653	338	S2    
23654	338	S2    
23655	338	S2    
23656	338	S2    
23657	338	S2    
23658	338	S2    
23659	338	S2    
23660	338	S2    
01029	341	S27   
01040	341	S27   
01069	341	S84   
01077	341	S27   
01079	341	S1063 
01082	341	S1063 
01085	341	S1063 
01088	341	S82   
01091	341	S82   
01103	341	S1163 
01123	341	S1063 
01123	341	S561  
01145	341	S84   
01202	341	S1163 
02003	341	S1069 
02007	341	D4561 
02009	341	S1069 
02010	341	S1069 
02015	341	S1069 
02020	341	S1069 
02021	341	S1069 
02024	341	S1069 
02025	341	D4561 
02026	341	S1069 
02028	341	S1069 
02029	341	S1069 
02030	341	S1069 
02033	341	S1069 
02043	341	S1069 
02046	341	S84   
04002	341	S84   
04018	341	S84   
04025	341	S22   
04031	341	S87   
04042	341	S87   
04047	341	S84   
04053	341	S87   
04055	341	S84   
04547	341	S87   
04548	341	S87   
04552	341	S87   
04554	341	S87   
04560	341	S87   
04582	341	S82   
04582	341	S87   
04586	341	S87   
04587	341	S87   
04615	341	S87   
04641	341	S25   
05023	341	S1581 
05024	341	S1581 
05027	341	S1166 
05028	341	S1166 
05173	341	S1581 
05174	341	S1581 
05175	341	S1581 
05176	341	S1581 
05177	341	S1581 
05178	341	S1581 
05312	341	S26   
05313	341	S26   
05320	341	S26   
05661	341	S1166 
06094	341	S18   
06128	341	S18   
06159	341	S18   
06982	341	S18   
06983	341	S18   
07007	341	S1164 
07063	341	S1164 
07064	341	S1164 
07075	341	S1164 
07952	341	S1164 
07953	341	S1164 
07954	341	S1164 
07955	341	S1164 
07956	341	S1164 
07957	341	S1164 
07958	341	S1164 
07959	341	S1164 
07960	341	S1164 
08025	341	S2662 
08065	341	S2662 
08074	341	S2662 
08259	341	S2662 
08504	341	S2662 
08505	341	S2662 
08506	341	S2662 
08507	341	S2662 
08508	341	S2662 
08509	341	S2662 
09003	341	S561  
09003	341	S87   
09004	341	S84   
09011	341	S121  
09020	341	S84   
09032	341	S21   
09037	341	S121  
09037	341	S481  
09037	341	S502  
09038	341	S121  
09038	341	S481  
09038	341	S502  
09039	341	S121  
09040	341	S121  
09040	341	S481  
09040	341	S562  
09040	341	S87   
09042	341	S461  
09042	341	S566  
09050	341	S421  
09070	341	S121  
09070	341	S582  
09074	341	S84   
09078	341	S561  
09087	341	S564  
09094	341	S363  
09099	341	S84   
09100	341	S84   
09112	341	S482  
09112	341	S563  
09128	341	S84   
09132	341	S1062 
09132	341	S121  
09135	341	S121  
09135	341	S81   
09148	341	S363  
09160	341	S1065 
09181	341	S121  
09181	341	S461  
09181	341	S87   
09184	341	S562  
09191	341	S421  
09191	341	S84   
09193	341	S84   
09194	341	S84   
09195	341	S84   
09202	341	S482  
09202	341	S564  
09215	341	S81   
09215	341	S84   
09218	341	S1065 
09236	341	S121  
09236	341	S461  
09246	341	S121  
09252	341	S541  
09259	341	S121  
09266	341	S441  
09266	341	S561  
09279	341	S121  
09279	341	S421  
09291	341	S121  
09291	341	S564  
09294	341	S84   
09298	341	S121  
09298	341	S564  
09302	341	S461  
09302	341	S566  
09316	341	S421  
09316	341	S566  
09326	341	S441  
09326	341	S461  
09326	341	S84   
09430	341	S441  
09430	341	S561  
09433	341	S2105 
10007	341	S1166 
10058	341	S1166 
10066	341	S1166 
10067	341	S1166 
10068	341	S1166 
10098	341	S1581 
10099	341	S1581 
10102	341	S1581 
10119	341	S1581 
10123	341	S1166 
10124	341	S1166 
10173	341	S1581 
10858	341	S1166 
10860	341	S1166 
10861	341	S1166 
10861	341	S502  
10862	341	S1166 
10863	341	S1581 
11090	341	S1121 
11090	341	S121  
11090	341	S564  
11090	341	S87   
11091	341	S1121 
11091	341	S564  
11096	341	S1121 
11096	341	S482  
11097	341	S482  
11124	341	S1062 
11124	341	S84   
11124	341	S87   
11125	341	S1062 
11143	341	S1121 
11143	341	S564  
11143	341	S84   
11143	341	S87   
11205	341	S1062 
11205	341	S121  
11206	341	S1062 
11206	341	S121  
11206	341	S81   
11243	341	S2941 
11250	341	S565  
11251	341	S481  
11251	341	S503  
11252	341	S121  
11252	341	S481  
11252	341	S562  
11252	341	S87   
11253	341	S565  
11257	341	S565  
11260	341	S121  
11260	341	S2941 
11263	341	S2941 
11265	341	S2941 
11267	341	S2941 
11282	341	S1062 
11282	341	S121  
11286	341	S1062 
11294	341	S563  
11333	341	S1062 
11333	341	S84   
11339	341	S1062 
11352	341	S563  
11353	341	S563  
11356	341	S563  
11359	341	S2105 
11360	341	S2105 
11394	341	S2105 
11395	341	S2105 
11398	341	S2105 
11399	341	S2105 
11402	341	S2105 
11403	341	S2105 
11411	341	S2105 
11412	341	S2105 
11429	341	S363  
11463	341	S25   
11464	341	S25   
11507	341	S1062 
11508	341	S1062 
11508	341	S121  
11510	341	S1062 
11529	341	S441  
11529	341	S503  
11529	341	S84   
11529	341	S87   
11530	341	S441  
11549	341	S81   
11549	341	S87   
11578	341	S84   
11674	341	S563  
11709	341	S84   
11742	341	S1121 
11742	341	S564  
11757	341	S1062 
11771	341	S121  
11772	341	S84   
11774	341	S84   
11812	341	S121  
11821	341	S1062 
11828	341	S563  
11841	341	S2105 
11842	341	S2105 
11856	341	S25   
11875	341	S1062 
11875	341	S121  
11876	341	S1062 
11884	341	S441  
11886	341	S87   
11887	341	S81   
11921	341	S1062 
11935	341	S81   
11949	341	S81   
11950	341	S2941 
11987	341	S2941 
11992	341	S2941 
12036	341	S1504 
12037	341	S2142 
12037	341	S84   
12038	341	S2142 
12061	341	S141  
12062	341	S141  
12063	341	S141  
12065	341	S141  
12078	341	S1063 
12078	341	S503  
12078	341	S81   
12086	341	S502  
12086	341	S82   
12120	341	S83   
12121	341	S83   
12122	341	S83   
12131	341	S77   
12132	341	S77   
12142	341	S85   
12143	341	S85   
12144	341	S85   
12147	341	S502  
12147	341	S564  
12151	341	S86   
12152	341	S86   
12154	341	S941  
12155	341	S79   
12155	341	S87   
12201	341	S1164 
12220	341	S2109 
12537	341	S2142 
12537	341	S84   
12538	341	S2142 
12563	341	S141  
12565	341	S141  
12586	341	S502  
12586	341	S82   
12632	341	S77   
12643	341	S85   
12644	341	S85   
12652	341	S86   
13019	341	S2    
13020	341	S2    
13055	341	S2    
13065	341	S2    
13067	341	S2    
13068	341	S2    
13070	341	S2    
13096	341	S2    
13098	341	S2    
13165	341	S2    
13318	341	S1581 
13320	341	S1581 
13321	341	S1581 
13322	341	S1581 
13323	341	S1581 
13324	341	S1581 
13325	341	S1166 
13326	341	S1166 
13327	341	S1166 
13340	341	S1581 
13341	341	S1581 
13343	341	S2    
13369	341	S2    
13370	341	S2    
13373	341	S2    
13375	341	S2    
13377	341	S2    
13378	341	S2    
13391	341	S2    
13394	341	S2    
13398	341	S2    
13399	341	S2    
13401	341	S2    
13402	341	S2    
13404	341	S2    
13405	341	S2    
13407	341	S2    
13408	341	S2    
13410	341	S2    
13411	341	S2    
13413	341	S2    
13414	341	S2    
13415	341	S2    
13416	341	S2    
13417	341	S2    
13418	341	S2    
13419	341	S2    
13420	341	S2    
13421	341	S2    
13422	341	S2    
13423	341	S2    
13424	341	S2    
13425	341	S2    
13426	341	S2    
13439	341	S2    
13440	341	S2    
13441	341	S2    
13442	341	S2    
13443	341	S2    
13444	341	S2    
13445	341	S2    
13446	341	S2    
13447	341	S2    
13448	341	S2    
13449	341	S2    
13450	341	S2    
13451	341	S2    
13452	341	S2    
13453	341	S2    
13454	341	S2    
13455	341	S2    
13456	341	S2    
13485	341	S2    
13486	341	S2    
13487	341	S2    
13488	341	S2    
13490	341	S2    
13491	341	S2    
13492	341	S2    
13493	341	S2    
13565	341	S2703 
13566	341	S2703 
13567	341	S2703 
13805	341	S2    
13806	341	S2    
13809	341	S2    
13810	341	S2    
13811	341	S2    
13812	341	S2    
13813	341	S2    
13814	341	S2    
13850	341	S2    
13851	341	S2    
13853	341	S2    
13854	341	S2    
13856	341	S2    
13857	341	S2    
13868	341	S2    
13869	341	S2    
13870	341	S2    
13871	341	S2    
13872	341	S2    
13873	341	S2    
13874	341	S2    
13875	341	S2    
13876	341	S2    
13877	341	S2    
13878	341	S2    
13879	341	S2    
13880	341	S2    
13881	341	S2    
13882	341	S2    
13891	341	S2    
13893	341	S2    
13894	341	S2    
13896	341	S2    
13898	341	S2    
13900	341	S2    
13909	341	S2    
13910	341	S2    
13911	341	S2    
13912	341	S2    
13913	341	S2    
13914	341	S2    
13917	341	S2    
13918	341	S2    
13920	341	S2    
13921	341	S2    
13923	341	S2    
13924	341	S2    
13929	341	S2    
13930	341	S2    
13931	341	S2    
13932	341	S2    
13934	341	S2    
13935	341	S2    
13948	341	S2    
13949	341	S2    
13950	341	S2    
13951	341	S2    
13952	341	S2    
13953	341	S2    
13954	341	S2    
13955	341	S2    
13956	341	S2    
13957	341	S2    
13958	341	S2    
13959	341	S2    
13968	341	S2    
13969	341	S2    
13970	341	S2    
13971	341	S2    
13985	341	S2    
13988	341	S2703 
13989	341	S2703 
13992	341	S2703 
13994	341	S2703 
13997	341	S2703 
13998	341	S2703 
14003	341	S87   
14209	341	S1064 
14209	341	S1122 
15015	341	S84   
15027	341	S1163 
15028	341	S84   
15028	341	S87   
15073	341	S1163 
15083	341	S81   
15084	341	S81   
15087	341	S2109 
15119	341	S121  
15119	341	S81   
15121	341	S27   
15121	341	S87   
15126	341	S121  
15140	341	S121  
15141	341	S121  
15149	341	S84   
15149	341	S87   
15152	341	S84   
15152	341	S87   
15157	341	S121  
15162	341	S121  
15164	341	S121  
15172	341	S84   
15232	341	S1163 
15260	341	S2109 
15261	341	S1163 
15262	341	S1163 
16006	341	S1164 
16010	341	S1164 
16011	341	S1164 
16011	341	S87   
16028	341	S84   
16029	341	S1164 
16037	341	S1164 
16038	341	S1164 
16097	341	S22   
16098	341	S22   
16098	341	S84   
16098	341	S87   
16167	341	S2203 
16338	341	S1164 
16397	341	S22   
16398	341	S22   
16398	341	S84   
16398	341	S87   
17202	341	S1166 
17203	341	S1166 
17204	341	S1166 
17204	341	S502  
17218	341	S1581 
17219	341	S1581 
18079	341	S25   
18159	341	S21   
18166	341	S25   
18168	341	S25   
18215	341	S25   
18228	341	S23   
18231	341	S25   
18288	341	S27   
18350	341	S21   
18363	341	S22   
18364	341	S22   
18365	341	S27   
18376	341	S25   
18927	341	S25   
18932	341	S27   
18933	341	S27   
18934	341	S27   
18935	341	S27   
18936	341	S27   
19064	341	S1164 
19078	341	S84   
19109	341	S1164 
19155	341	S1164 
19226	341	S84   
20020	341	S84   
20027	341	S84   
20033	341	S121  
20036	341	S84   
20037	341	S84   
20046	341	S20   
20048	341	S20   
20081	341	S20   
20081	341	S82   
20081	341	S87   
20082	341	S20   
20083	341	S20   
20084	341	S20   
20099	341	S1163 
20099	341	S20   
20099	341	S82   
20100	341	S1163 
20100	341	S20   
20109	341	S2105 
20110	341	S2105 
20120	341	S1163 
20120	341	S20   
20120	341	S82   
20121	341	S1163 
20121	341	S20   
20310	341	S2105 
20321	341	S1163 
20321	341	S20   
20400	341	S1163 
20400	341	S20   
20409	341	S2105 
20410	341	S2105 
20420	341	S1163 
20420	341	S20   
20420	341	S82   
20421	341	S1163 
20421	341	S20   
20446	341	S20   
20499	341	S1163 
20499	341	S20   
20499	341	S82   
20510	341	S2105 
20521	341	S1163 
20521	341	S20   
20581	341	S20   
20623	341	S1742 
20624	341	S1742 
20628	341	S1742 
20629	341	S1742 
20630	341	S1742 
20634	341	S1742 
20635	341	S1742 
20636	341	S1742 
20640	341	S1742 
20641	341	S1742 
20645	341	S1742 
20646	341	S1742 
21138	341	S1064 
21138	341	S1122 
21229	341	S1122 
21249	341	S1064 
21251	341	S1064 
21252	341	S1064 
21253	341	S1064 
21255	341	S1064 
21256	341	S1064 
21260	341	S1082 
21261	341	S1082 
21262	341	S1082 
21263	341	S1082 
21264	341	S1082 
21265	341	S1082 
21266	341	S1082 
21267	341	S1082 
21268	341	S1082 
21269	341	S1082 
21270	341	S1082 
21271	341	S2108 
21272	341	S2108 
21273	341	S2108 
21274	341	S2108 
21275	341	S2108 
21276	341	S2108 
21277	341	S2110 
21278	341	S2110 
21279	341	S2110 
21280	341	S2110 
21281	341	S2110 
21282	341	S2110 
21283	341	S2111 
21284	341	S2111 
21285	341	S2111 
21286	341	S2111 
21287	341	S2112 
21288	341	S2112 
21289	341	S2112 
21290	341	S2112 
21291	341	S2112 
21292	341	S2112 
21293	341	S2782 
21294	341	S2782 
21295	341	S2782 
21296	341	S2782 
21297	341	S2782 
21298	341	S2782 
21299	341	S2110 
21299	341	S2111 
21299	341	S2112 
21299	341	S2782 
21300	341	S2110 
21300	341	S2112 
21300	341	S2782 
21301	341	S2110 
21301	341	S2111 
21301	341	S2112 
21301	341	S2782 
21302	341	S2110 
21302	341	S2111 
21302	341	S2112 
21302	341	S2782 
21303	341	S2110 
21303	341	S2112 
21303	341	S2782 
21304	341	S2110 
21304	341	S2111 
21304	341	S2112 
21304	341	S2782 
22909	341	S22   
23011	341	S2703 
23014	341	S2703 
23015	341	S2703 
23018	341	S2703 
23019	341	S2703 
23020	341	S2703 
23021	341	S2703 
23022	341	S2703 
23023	341	S2703 
23024	341	S2703 
23025	341	S2703 
23027	341	S2703 
23028	341	S2703 
23029	341	S2703 
23030	341	S2703 
23031	341	S2703 
23034	341	S2703 
23035	341	S2703 
23037	341	S2703 
23038	341	S2703 
23041	341	S2703 
23042	341	S2703 
23045	341	S2703 
23046	341	S2703 
23049	341	S2703 
23050	341	S2703 
23053	341	S2703 
23054	341	S2703 
23055	341	S2703 
23056	341	S2703 
23057	341	S2703 
23058	341	S2703 
23059	341	S2703 
23060	341	S2703 
23061	341	S2703 
23062	341	S2703 
23063	341	S2703 
23064	341	S2703 
23582	341	S2    
23583	341	S2    
23584	341	S2    
23585	341	S2    
23586	341	S2    
23587	341	S2    
23588	341	S2    
23589	341	S2    
23590	341	S2    
23591	341	S2    
23592	341	S2    
23593	341	S2    
23594	341	S2    
23595	341	S2    
23596	341	S2    
23597	341	S2    
23598	341	S2    
23599	341	S2    
23600	341	S2    
23601	341	S2    
23602	341	S2    
23603	341	S2    
23604	341	S2    
23605	341	S2    
23606	341	S2    
23607	341	S2    
23608	341	S2    
23609	341	S2    
23610	341	S2    
23611	341	S2    
23612	341	S2    
23613	341	S2    
23614	341	S2    
23615	341	S2    
23616	341	S2    
23618	341	S2    
23619	341	S2    
23620	341	S2    
23622	341	S2    
23623	341	S2    
23624	341	S2    
23625	341	S2    
23626	341	S2    
23627	341	S2    
23628	341	S2    
23629	341	S2    
23630	341	S2    
23631	341	S2    
23632	341	S2    
23633	341	S2    
23634	341	S2    
23635	341	S2    
23636	341	S2    
23637	341	S2    
23638	341	S2    
23640	341	S1581 
23646	341	S2    
23647	341	S2    
23648	341	S2    
23649	341	S2    
23650	341	S2    
23651	341	S2    
23652	341	S2    
23653	341	S2    
23654	341	S2    
23655	341	S2    
23656	341	S2    
23657	341	S2    
23658	341	S2    
23659	341	S2    
23660	341	S2    
35130	341	S2381 
35131	341	S2381 
35132	341	S2381 
35133	341	S2381 
35134	341	S2381 
35135	341	S2381 
35136	341	S2381 
35137	341	S2381 
35138	341	S2381 
35140	341	S2381 
35141	341	S2381 
35142	341	S2381 
35143	341	S2381 
35144	341	S2381 
35145	341	S2381 
35146	341	S2381 
35147	341	S2381 
35148	341	S2381 
43378	341	S1166 
01009	342	S81   
01029	342	S27   
01040	342	S27   
01040	342	S81   
01069	342	S84   
01077	342	S27   
01079	342	S1063 
01082	342	S1063 
01085	342	S1063 
01088	342	S82   
01091	342	S82   
01103	342	S1163 
01123	342	S1063 
01123	342	S561  
01145	342	S84   
01202	342	S1163 
02003	342	S1069 
02007	342	D4561 
02009	342	S1069 
02010	342	S1069 
02015	342	S1069 
02020	342	S1069 
02021	342	S1069 
02024	342	S1069 
02025	342	D4561 
02026	342	S1069 
02028	342	S1069 
02029	342	S1069 
02030	342	S1069 
02033	342	S1069 
02043	342	S1069 
02046	342	S84   
04002	342	S84   
04018	342	S84   
04025	342	S22   
04031	342	S81   
04031	342	S87   
04042	342	S87   
04047	342	S84   
04053	342	S87   
04055	342	S84   
04547	342	S81   
04547	342	S87   
04548	342	S81   
04548	342	S87   
04552	342	S81   
04552	342	S87   
04554	342	S81   
04554	342	S87   
04560	342	S81   
04560	342	S87   
04582	342	S82   
04582	342	S87   
04586	342	S81   
04586	342	S87   
04587	342	S81   
04587	342	S87   
04615	342	S81   
04615	342	S87   
04641	342	S25   
05023	342	S1581 
05024	342	S1581 
05027	342	S1166 
05028	342	S1166 
05173	342	S1581 
05174	342	S1581 
05175	342	S1581 
05176	342	S1581 
05177	342	S1581 
05178	342	S1581 
05312	342	S26   
05313	342	S26   
05320	342	S26   
05661	342	S1166 
06094	342	S18   
06128	342	S18   
06159	342	S18   
06982	342	S18   
06983	342	S18   
07007	342	S1164 
07063	342	S1164 
07064	342	S1164 
07075	342	S1164 
07952	342	S1164 
07953	342	S1164 
07954	342	S1164 
07955	342	S1164 
07956	342	S1164 
07957	342	S1164 
07958	342	S1164 
07959	342	S1164 
07960	342	S1164 
08025	342	S2662 
08065	342	S2662 
08074	342	S2662 
08259	342	S2662 
08504	342	S2662 
08505	342	S2662 
08506	342	S2662 
08507	342	S2662 
08508	342	S2662 
08509	342	S2662 
09003	342	S561  
09003	342	S87   
09004	342	S84   
09011	342	S121  
09020	342	S84   
09032	342	S21   
09037	342	S121  
09037	342	S1621 
09037	342	S481  
09037	342	S502  
09038	342	S121  
09038	342	S1621 
09038	342	S481  
09038	342	S502  
09039	342	S121  
09040	342	S121  
09040	342	S481  
09040	342	S562  
09040	342	S87   
09042	342	S461  
09042	342	S566  
09050	342	S421  
09070	342	S121  
09070	342	S582  
09074	342	S84   
09078	342	S561  
09087	342	S564  
09094	342	S363  
09099	342	S84   
09100	342	S84   
09112	342	S482  
09112	342	S563  
09128	342	S84   
09132	342	S1062 
09132	342	S121  
09135	342	S121  
09135	342	S81   
09148	342	S363  
09160	342	S1065 
09181	342	S121  
09181	342	S461  
09181	342	S87   
09184	342	S562  
09191	342	S421  
09191	342	S84   
09193	342	S84   
09194	342	S84   
09195	342	S84   
09202	342	S482  
09202	342	S564  
09215	342	S81   
09215	342	S84   
09218	342	S1065 
09236	342	S121  
09236	342	S461  
09246	342	S121  
09252	342	S541  
09259	342	S121  
09266	342	S441  
09266	342	S561  
09279	342	S121  
09279	342	S421  
09291	342	S121  
09291	342	S564  
09298	342	S121  
09298	342	S564  
09302	342	S461  
09302	342	S566  
09316	342	S421  
09316	342	S566  
09326	342	S441  
09326	342	S461  
09326	342	S84   
09430	342	S441  
09430	342	S561  
09433	342	S2105 
10007	342	S1166 
10058	342	S1166 
10066	342	S1166 
10067	342	S1166 
10068	342	S1166 
10098	342	S1581 
10099	342	S1581 
10102	342	S1581 
10119	342	S1581 
10123	342	S1166 
10124	342	S1166 
10173	342	S1581 
10858	342	S1166 
10860	342	S1166 
10861	342	S1166 
10861	342	S502  
10862	342	S1166 
10863	342	S1581 
11090	342	S1121 
11090	342	S121  
11090	342	S564  
11090	342	S87   
11091	342	S1121 
11091	342	S564  
11096	342	S1121 
11096	342	S482  
11097	342	S482  
11124	342	S1062 
11124	342	S84   
11124	342	S87   
11125	342	S1062 
11143	342	S1121 
11143	342	S564  
11143	342	S84   
11143	342	S87   
11205	342	S1062 
11205	342	S121  
11206	342	S1062 
11206	342	S121  
11206	342	S81   
11243	342	S2941 
11250	342	S565  
11251	342	S481  
11251	342	S503  
11252	342	S121  
11252	342	S481  
11252	342	S562  
11252	342	S87   
11253	342	S565  
11257	342	S565  
11260	342	S121  
11260	342	S2941 
11263	342	S2941 
11265	342	S2941 
11267	342	S2941 
11282	342	S1062 
11282	342	S121  
11286	342	S1062 
11294	342	S563  
11333	342	S1062 
11333	342	S84   
11339	342	S1062 
11352	342	S563  
11353	342	S563  
11356	342	S563  
11359	342	S2105 
11360	342	S2105 
11394	342	S2105 
11395	342	S2105 
11398	342	S2105 
11399	342	S2105 
11402	342	S2105 
11403	342	S2105 
11411	342	S2105 
11412	342	S2105 
11429	342	S363  
11463	342	S25   
11464	342	S25   
11507	342	S1062 
11508	342	S1062 
11508	342	S121  
11510	342	S1062 
11529	342	S441  
11529	342	S503  
11529	342	S84   
11529	342	S87   
11530	342	S441  
11549	342	S81   
11549	342	S87   
11578	342	S84   
11674	342	S563  
11709	342	S84   
11742	342	S1121 
11742	342	S564  
11757	342	S1062 
11771	342	S121  
11772	342	S84   
11774	342	S84   
11812	342	S121  
11821	342	S1062 
11828	342	S563  
11841	342	S2105 
11842	342	S2105 
11856	342	S25   
11875	342	S1062 
11875	342	S121  
11876	342	S1062 
11884	342	S441  
11886	342	S87   
11887	342	S81   
11921	342	S1062 
11935	342	S81   
11949	342	S81   
11950	342	S2941 
11987	342	S2941 
11992	342	S2941 
12014	342	D4561 
12036	342	S1504 
12037	342	S2142 
12037	342	S84   
12038	342	S2142 
12061	342	S141  
12062	342	S141  
12063	342	S141  
12065	342	S141  
12078	342	S1063 
12078	342	S503  
12078	342	S81   
12086	342	S502  
12086	342	S82   
12120	342	S83   
12121	342	S83   
12122	342	S83   
12131	342	S77   
12132	342	S77   
12142	342	S85   
12143	342	S85   
12144	342	S85   
12147	342	S502  
12147	342	S564  
12151	342	S86   
12152	342	S86   
12154	342	S941  
12155	342	S79   
12155	342	S87   
12201	342	S1164 
12220	342	D4743 
12220	342	S2109 
12537	342	S2142 
12537	342	S84   
12538	342	S2142 
12563	342	S141  
12565	342	S141  
12586	342	S502  
12586	342	S82   
12632	342	S77   
12643	342	S85   
12644	342	S85   
12652	342	S86   
13019	342	S2    
13020	342	S2    
13055	342	S2    
13065	342	S2    
13067	342	S2    
13068	342	S2    
13070	342	S2    
13096	342	S2    
13098	342	S2    
13165	342	S2    
13318	342	S1581 
13320	342	S1581 
13321	342	S1581 
13322	342	S1581 
13323	342	S1581 
13324	342	S1581 
13325	342	S1166 
13326	342	S1166 
13327	342	S1166 
13340	342	S1581 
13341	342	S1581 
13343	342	S2    
13369	342	S2    
13370	342	S2    
13373	342	S2    
13375	342	S2    
13377	342	S2    
13378	342	S2    
13391	342	S2    
13394	342	S2    
13398	342	S2    
13399	342	S2    
13401	342	S2    
13402	342	S2    
13404	342	S2    
13405	342	S2    
13407	342	S2    
13408	342	S2    
13410	342	S2    
13411	342	S2    
13413	342	S2    
13414	342	S2    
13415	342	S2    
13416	342	S2    
13417	342	S2    
13418	342	S2    
13419	342	S2    
13420	342	S2    
13421	342	S2    
13422	342	S2    
13423	342	S2    
13424	342	S2    
13425	342	S2    
13426	342	S2    
13439	342	S2    
13440	342	S2    
13441	342	S2    
13442	342	S2    
13443	342	S2    
13444	342	S2    
13445	342	S2    
13446	342	S2    
13447	342	S2    
13448	342	S2    
13449	342	S2    
13450	342	S2    
13451	342	S2    
13452	342	S2    
13453	342	S2    
13454	342	S2    
13455	342	S2    
13456	342	S2    
13485	342	S2    
13486	342	S2    
13487	342	S2    
13488	342	S2    
13490	342	S2    
13491	342	S2    
13492	342	S2    
13493	342	S2    
13565	342	S2703 
13566	342	S2703 
13567	342	S2703 
13805	342	S2    
13806	342	S2    
13809	342	S2    
13810	342	S2    
13811	342	S2    
13812	342	S2    
13813	342	S2    
13814	342	S2    
13850	342	S2    
13851	342	S2    
13853	342	S2    
13854	342	S2    
13856	342	S2    
13857	342	S2    
13868	342	S2    
13869	342	S2    
13870	342	S2    
13871	342	S2    
13872	342	S2    
13873	342	S2    
13874	342	S2    
13875	342	S2    
13876	342	S2    
13877	342	S2    
13878	342	S2    
13879	342	S2    
13880	342	S2    
13881	342	S2    
13882	342	S2    
13891	342	S2    
13893	342	S2    
13894	342	S2    
13896	342	S2    
13898	342	S2    
13900	342	S2    
13909	342	S2    
13910	342	S2    
13911	342	S2    
13912	342	S2    
13913	342	S2    
13914	342	S2    
13917	342	S2    
13918	342	S2    
13920	342	S2    
13921	342	S2    
13923	342	S2    
13924	342	S2    
13929	342	S2    
13930	342	S2    
13931	342	S2    
13932	342	S2    
13934	342	S2    
13935	342	S2    
13948	342	S2    
13949	342	S2    
13950	342	S2    
13951	342	S2    
13952	342	S2    
13953	342	S2    
13954	342	S2    
13955	342	S2    
13956	342	S2    
13957	342	S2    
13958	342	S2    
13959	342	S2    
13968	342	S2    
13969	342	S2    
13970	342	S2    
13971	342	S2    
13985	342	S2    
13988	342	S2703 
13989	342	S2703 
13992	342	S2703 
13994	342	S2703 
13997	342	S2703 
13998	342	S2703 
14003	342	S87   
14209	342	S1064 
14209	342	S1122 
14355	342	S81   
15015	342	S84   
15027	342	S1163 
15028	342	S84   
15028	342	S87   
15073	342	S1163 
15083	342	S81   
15084	342	S81   
15087	342	S2109 
15119	342	S121  
15119	342	S81   
15121	342	S27   
15121	342	S87   
15126	342	S121  
15140	342	S121  
15141	342	S121  
15149	342	S84   
15149	342	S87   
15152	342	S84   
15152	342	S87   
15157	342	S121  
15162	342	S121  
15164	342	S121  
15172	342	S84   
15232	342	S1163 
15260	342	S2109 
15261	342	S1163 
15262	342	S1163 
16006	342	S1164 
16010	342	S1164 
16011	342	S1164 
16011	342	S87   
16028	342	S84   
16029	342	S1164 
16037	342	S1164 
16038	342	S1164 
16097	342	S22   
16098	342	S22   
16098	342	S84   
16098	342	S87   
16167	342	S2203 
16338	342	S1164 
16397	342	S22   
16398	342	S22   
16398	342	S84   
16398	342	S87   
17202	342	S1166 
17203	342	S1166 
17204	342	S1166 
17204	342	S502  
17218	342	S1581 
17219	342	S1581 
18079	342	S25   
18159	342	S21   
18166	342	S25   
18168	342	S25   
18215	342	S25   
18228	342	S23   
18231	342	S25   
18288	342	S27   
18350	342	S21   
18363	342	S22   
18364	342	S22   
18365	342	S27   
18376	342	S25   
18927	342	S25   
18932	342	S27   
18933	342	S27   
18934	342	S27   
18935	342	S27   
18936	342	S27   
19064	342	S1164 
19078	342	S84   
19109	342	S1164 
19155	342	S1164 
19226	342	S84   
20020	342	S84   
20027	342	S84   
20033	342	S121  
20036	342	S84   
20037	342	S84   
20046	342	S20   
20048	342	S20   
20081	342	S20   
20081	342	S82   
20081	342	S87   
20082	342	S20   
20083	342	S20   
20084	342	S20   
20099	342	S1163 
20099	342	S20   
20099	342	S82   
20100	342	S1163 
20100	342	S20   
20109	342	S2105 
20110	342	S2105 
20120	342	S1163 
20120	342	S20   
20120	342	S82   
20121	342	S1163 
20121	342	S20   
20310	342	S2105 
20321	342	S1163 
20321	342	S20   
20400	342	S1163 
20400	342	S20   
20409	342	S2105 
20410	342	S2105 
20420	342	S1163 
20420	342	S20   
20420	342	S82   
20421	342	S1163 
20421	342	S20   
20446	342	S20   
20499	342	S1163 
20499	342	S20   
20499	342	S82   
20510	342	S2105 
20521	342	S1163 
20521	342	S20   
20581	342	S20   
20623	342	S1742 
20624	342	S1742 
20628	342	S1742 
20629	342	S1742 
20630	342	S1742 
20634	342	S1742 
20635	342	S1742 
20636	342	S1742 
20640	342	S1742 
20641	342	S1742 
20645	342	S1742 
20646	342	S1742 
21138	342	S1064 
21138	342	S1122 
21229	342	S1122 
21249	342	S1064 
21251	342	S1064 
21252	342	S1064 
21253	342	S1064 
21255	342	S1064 
21256	342	S1064 
21260	342	S1082 
21261	342	S1082 
21262	342	S1082 
21263	342	S1082 
21264	342	S1082 
21265	342	S1082 
21266	342	S1082 
21267	342	S1082 
21268	342	S1082 
21269	342	S1082 
21270	342	S1082 
21271	342	S2108 
21272	342	S2108 
21273	342	S2108 
21274	342	S2108 
21275	342	S2108 
21276	342	S2108 
21277	342	S2110 
21278	342	S2110 
21279	342	S2110 
21280	342	S2110 
21281	342	S2110 
21282	342	S2110 
21283	342	S2111 
21284	342	S2111 
21285	342	S2111 
21286	342	S2111 
21287	342	S2112 
21288	342	S2112 
21289	342	S2112 
21290	342	S2112 
21291	342	S2112 
21292	342	S2112 
21293	342	S2782 
21294	342	S2782 
21295	342	S2782 
21296	342	S2782 
21297	342	S2782 
21298	342	S2782 
21299	342	S2110 
21299	342	S2111 
21299	342	S2112 
21299	342	S2782 
21300	342	S2110 
21300	342	S2112 
21300	342	S2782 
21301	342	S2110 
21301	342	S2111 
21301	342	S2112 
21301	342	S2782 
21302	342	S2110 
21302	342	S2111 
21302	342	S2112 
21302	342	S2782 
21303	342	S2110 
21303	342	S2112 
21303	342	S2782 
21304	342	S2110 
21304	342	S2111 
21304	342	S2112 
21304	342	S2782 
22909	342	S22   
23011	342	S2703 
23014	342	S2703 
23015	342	S2703 
23018	342	S2703 
23019	342	S2703 
23020	342	S2703 
23021	342	S2703 
23022	342	S2703 
23023	342	S2703 
23024	342	S2703 
23025	342	S2703 
23027	342	S2703 
23028	342	S2703 
23029	342	S2703 
23030	342	S2703 
23031	342	S2703 
23034	342	S2703 
23035	342	S2703 
23037	342	S2703 
23038	342	S2703 
23041	342	S2703 
23042	342	S2703 
23045	342	S2703 
23046	342	S2703 
23049	342	S2703 
23050	342	S2703 
23053	342	S2703 
23054	342	S2703 
23055	342	S2703 
23056	342	S2703 
23057	342	S2703 
23058	342	S2703 
23059	342	S2703 
23060	342	S2703 
23061	342	S2703 
23062	342	S2703 
23063	342	S2703 
23064	342	S2703 
23582	342	S2    
23583	342	S2    
23584	342	S2    
23585	342	S2    
23586	342	S2    
23587	342	S2    
23588	342	S2    
23589	342	S2    
23590	342	S2    
23591	342	S2    
23592	342	S2    
23593	342	S2    
23594	342	S2    
23595	342	S2    
23596	342	S2    
23597	342	S2    
23598	342	S2    
23599	342	S2    
23600	342	S2    
23601	342	S2    
23602	342	S2    
23603	342	S2    
23604	342	S2    
23605	342	S2    
23606	342	S2    
23607	342	S2    
23608	342	S2    
23609	342	S2    
23610	342	S2    
23611	342	S2    
23612	342	S2    
23613	342	S2    
23614	342	S2    
23615	342	S2    
23616	342	S2    
23618	342	S2    
23619	342	S2    
23620	342	S2    
23622	342	S2    
23623	342	S2    
23624	342	S2    
23625	342	S2    
23626	342	S2    
23627	342	S2    
23628	342	S2    
23629	342	S2    
23630	342	S2    
23631	342	S2    
23632	342	S2    
23633	342	S2    
23634	342	S2    
23635	342	S2    
23636	342	S2    
23637	342	S2    
23638	342	S2    
23640	342	S1581 
23646	342	S2    
23647	342	S2    
23648	342	S2    
23649	342	S2    
23650	342	S2    
23651	342	S2    
23652	342	S2    
23653	342	S2    
23654	342	S2    
23655	342	S2    
23656	342	S2    
23657	342	S2    
23658	342	S2    
23659	342	S2    
23660	342	S2    
35130	342	S2381 
35131	342	S2381 
35132	342	S2381 
35133	342	S2381 
35134	342	S2381 
35135	342	S2381 
35136	342	S2381 
35137	342	S2381 
35138	342	S2381 
35140	342	S2381 
35141	342	S2381 
35142	342	S2381 
35143	342	S2381 
35144	342	S2381 
35145	342	S2381 
35146	342	S2381 
35147	342	S2381 
35148	342	S2381 
43378	342	S1166 
01009	343	S81   
01029	343	S27   
01040	343	S27   
01040	343	S81   
01069	343	S84   
01077	343	S27   
01079	343	S1063 
01082	343	S1063 
01085	343	S1063 
01088	343	S82   
01091	343	S82   
01103	343	S1163 
01123	343	S1063 
01123	343	S561  
01145	343	S84   
01202	343	S1163 
02003	343	S1069 
02007	343	D4561 
02009	343	S1069 
02010	343	S1069 
02015	343	S1069 
02020	343	S1069 
02021	343	S1069 
02024	343	S1069 
02025	343	D4561 
02026	343	S1069 
02028	343	S1069 
02029	343	S1069 
02030	343	S1069 
02033	343	S1069 
02043	343	S1069 
02046	343	S84   
04002	343	S84   
04018	343	S84   
04025	343	S22   
04031	343	S81   
04031	343	S87   
04042	343	S87   
04047	343	S84   
04053	343	S87   
04055	343	S84   
04547	343	S81   
04547	343	S87   
04548	343	S81   
04548	343	S87   
04552	343	S81   
04552	343	S87   
04554	343	S81   
04554	343	S87   
04560	343	S81   
04560	343	S87   
04582	343	S82   
04582	343	S87   
04586	343	S81   
04586	343	S87   
04587	343	S81   
04587	343	S87   
04615	343	S81   
04615	343	S87   
04641	343	S25   
05023	343	S1581 
05024	343	S1581 
05027	343	S1166 
05028	343	S1166 
05173	343	S1581 
05174	343	S1581 
05175	343	S1581 
05176	343	S1581 
05177	343	S1581 
05178	343	S1581 
05312	343	S26   
05313	343	S26   
05320	343	S26   
05661	343	S1166 
06094	343	S18   
06128	343	S18   
06159	343	S18   
06982	343	S18   
06983	343	S18   
07007	343	S1164 
07063	343	S1164 
07064	343	S1164 
07075	343	S1164 
07952	343	S1164 
07953	343	S1164 
07954	343	S1164 
07955	343	S1164 
07956	343	S1164 
07957	343	S1164 
07958	343	S1164 
07959	343	S1164 
07960	343	S1164 
08025	343	S2662 
08065	343	S2662 
08074	343	S2662 
08259	343	S2662 
08504	343	S2662 
08505	343	S2662 
08506	343	S2662 
08507	343	S2662 
08508	343	S2662 
08509	343	S2662 
09003	343	S561  
09003	343	S87   
09004	343	S84   
09011	343	S121  
09020	343	S84   
09032	343	S21   
09037	343	S121  
09037	343	S481  
09037	343	S502  
09038	343	S121  
09038	343	S481  
09038	343	S502  
09039	343	S121  
09040	343	S121  
09040	343	S481  
09040	343	S562  
09040	343	S87   
09042	343	S461  
09042	343	S566  
09050	343	S421  
09070	343	S121  
09070	343	S582  
09074	343	S84   
09078	343	S561  
09087	343	S564  
09094	343	S363  
09099	343	S84   
09100	343	S84   
09112	343	S482  
09112	343	S563  
09128	343	S84   
09132	343	S1062 
09132	343	S121  
09135	343	S121  
09135	343	S81   
09148	343	S363  
09160	343	S1065 
09181	343	S121  
09181	343	S461  
09181	343	S87   
09184	343	S562  
09191	343	S421  
09191	343	S84   
09193	343	S84   
09194	343	S84   
09195	343	S84   
09202	343	S482  
09202	343	S564  
09215	343	S81   
09215	343	S84   
09218	343	S1065 
09236	343	S121  
09236	343	S461  
09246	343	S121  
09252	343	S541  
09259	343	S121  
09266	343	S441  
09266	343	S561  
09279	343	S121  
09279	343	S421  
09291	343	S121  
09291	343	S564  
09294	343	S84   
09298	343	S121  
09298	343	S564  
09302	343	S461  
09302	343	S566  
09316	343	S421  
09316	343	S566  
09326	343	S441  
09326	343	S461  
09326	343	S84   
09430	343	S441  
09430	343	S561  
09433	343	S2105 
10007	343	S1166 
10058	343	S1166 
10066	343	S1166 
10067	343	S1166 
10068	343	S1166 
10098	343	S1581 
10099	343	S1581 
10102	343	S1581 
10119	343	S1581 
10123	343	S1166 
10124	343	S1166 
10173	343	S1581 
10858	343	S1166 
10860	343	S1166 
10861	343	S1166 
10861	343	S502  
10862	343	S1166 
10863	343	S1581 
11090	343	S1121 
11090	343	S121  
11090	343	S564  
11090	343	S87   
11091	343	S1121 
11091	343	S564  
11096	343	S1121 
11096	343	S482  
11097	343	S482  
11124	343	S1062 
11124	343	S84   
11124	343	S87   
11125	343	S1062 
11143	343	S1121 
11143	343	S564  
11143	343	S84   
11143	343	S87   
11205	343	S1062 
11205	343	S121  
11206	343	S1062 
11206	343	S121  
11206	343	S81   
11243	343	S2941 
11250	343	S565  
11251	343	S481  
11251	343	S503  
11252	343	S121  
11252	343	S481  
11252	343	S562  
11252	343	S87   
11253	343	S565  
11257	343	S565  
11260	343	S121  
11260	343	S2941 
11263	343	S2941 
11265	343	S2941 
11267	343	S2941 
11282	343	S1062 
11282	343	S121  
11286	343	S1062 
11294	343	S563  
11333	343	S1062 
11333	343	S84   
11339	343	S1062 
11352	343	S563  
11353	343	S563  
11356	343	S563  
11359	343	S2105 
11360	343	S2105 
11394	343	S2105 
11395	343	S2105 
11398	343	S2105 
11399	343	S2105 
11402	343	S2105 
11403	343	S2105 
11411	343	S2105 
11412	343	S2105 
11429	343	S363  
11463	343	S25   
11464	343	S25   
11507	343	S1062 
11508	343	S1062 
11508	343	S121  
11510	343	S1062 
11529	343	S441  
11529	343	S503  
11529	343	S84   
11529	343	S87   
11530	343	S441  
11549	343	S81   
11549	343	S87   
11578	343	S84   
11674	343	S563  
11709	343	S84   
11742	343	S1121 
11742	343	S564  
11757	343	S1062 
11771	343	S121  
11772	343	S84   
11774	343	S84   
11812	343	S121  
11821	343	S1062 
11828	343	S563  
11841	343	S2105 
11842	343	S2105 
11856	343	S25   
11875	343	S1062 
11875	343	S121  
11876	343	S1062 
11884	343	S441  
11886	343	S87   
11887	343	S81   
11921	343	S1062 
11935	343	S81   
11949	343	S81   
11950	343	S2941 
11987	343	S2941 
11992	343	S2941 
12036	343	S1504 
12037	343	S2142 
12037	343	S84   
12038	343	S2142 
12061	343	S141  
12062	343	S141  
12063	343	S141  
12065	343	S141  
12078	343	S1063 
12078	343	S503  
12078	343	S81   
12086	343	S502  
12086	343	S82   
12120	343	S83   
12121	343	S83   
12122	343	S83   
12131	343	S77   
12132	343	S77   
12142	343	S85   
12143	343	S85   
12144	343	S85   
12147	343	S502  
12147	343	S564  
12151	343	S86   
12152	343	S86   
12154	343	S941  
12155	343	S79   
12155	343	S87   
12201	343	S1164 
12220	343	D4743 
12220	343	S2109 
12537	343	S2142 
12537	343	S84   
12538	343	S2142 
12563	343	S141  
12565	343	S141  
12586	343	S502  
12586	343	S82   
12632	343	S77   
12643	343	S85   
12644	343	S85   
12652	343	S86   
13019	343	S2    
13020	343	S2    
13055	343	S2    
13065	343	S2    
13067	343	S2    
13068	343	S2    
13070	343	S2    
13096	343	S2    
13098	343	S2    
13165	343	S2    
13318	343	S1581 
13320	343	S1581 
13321	343	S1581 
13322	343	S1581 
13323	343	S1581 
13324	343	S1581 
13325	343	S1166 
13326	343	S1166 
13327	343	S1166 
13340	343	S1581 
13341	343	S1581 
13343	343	S2    
13369	343	S2    
13370	343	S2    
13373	343	S2    
13375	343	S2    
13377	343	S2    
13378	343	S2    
13391	343	S2    
13394	343	S2    
13398	343	S2    
13399	343	S2    
13401	343	S2    
13402	343	S2    
13404	343	S2    
13405	343	S2    
13407	343	S2    
13408	343	S2    
13410	343	S2    
13411	343	S2    
13413	343	S2    
13414	343	S2    
13415	343	S2    
13416	343	S2    
13417	343	S2    
13418	343	S2    
13419	343	S2    
13420	343	S2    
13421	343	S2    
13422	343	S2    
13423	343	S2    
13424	343	S2    
13425	343	S2    
13426	343	S2    
13439	343	S2    
13440	343	S2    
13441	343	S2    
13442	343	S2    
13443	343	S2    
13444	343	S2    
13445	343	S2    
13446	343	S2    
13447	343	S2    
13448	343	S2    
13449	343	S2    
13450	343	S2    
13451	343	S2    
13452	343	S2    
13453	343	S2    
13454	343	S2    
13455	343	S2    
13456	343	S2    
13485	343	S2    
13486	343	S2    
13487	343	S2    
13488	343	S2    
13490	343	S2    
13491	343	S2    
13492	343	S2    
13493	343	S2    
13565	343	S2703 
13566	343	S2703 
13567	343	S2703 
13805	343	S2    
13806	343	S2    
13809	343	S2    
13810	343	S2    
13811	343	S2    
13812	343	S2    
13813	343	S2    
13814	343	S2    
13850	343	S2    
13851	343	S2    
13853	343	S2    
13854	343	S2    
13856	343	S2    
13857	343	S2    
13868	343	S2    
13869	343	S2    
13870	343	S2    
13871	343	S2    
13872	343	S2    
13873	343	S2    
13874	343	S2    
13875	343	S2    
13876	343	S2    
13877	343	S2    
13878	343	S2    
13879	343	S2    
13880	343	S2    
13881	343	S2    
13882	343	S2    
13891	343	S2    
13893	343	S2    
13894	343	S2    
13896	343	S2    
13898	343	S2    
13900	343	S2    
13909	343	S2    
13910	343	S2    
13911	343	S2    
13912	343	S2    
13913	343	S2    
13914	343	S2    
13917	343	S2    
13918	343	S2    
13920	343	S2    
13921	343	S2    
13923	343	S2    
13924	343	S2    
13929	343	S2    
13930	343	S2    
13931	343	S2    
13932	343	S2    
13934	343	S2    
13935	343	S2    
13948	343	S2    
13949	343	S2    
13950	343	S2    
13951	343	S2    
13952	343	S2    
13953	343	S2    
13954	343	S2    
13955	343	S2    
13956	343	S2    
13957	343	S2    
13958	343	S2    
13959	343	S2    
13968	343	S2    
13969	343	S2    
13970	343	S2    
13971	343	S2    
13985	343	S2    
13988	343	S2703 
13989	343	S2703 
13992	343	S2703 
13994	343	S2703 
13997	343	S2703 
13998	343	S2703 
14003	343	S87   
14209	343	S1064 
14209	343	S1122 
14355	343	S81   
15015	343	S84   
15027	343	S1163 
15028	343	S84   
15028	343	S87   
15073	343	S1163 
15083	343	S81   
15084	343	S81   
15087	343	S2109 
15119	343	S121  
15119	343	S81   
15121	343	S27   
15121	343	S87   
15126	343	S121  
15140	343	S121  
15141	343	S121  
15149	343	S84   
15149	343	S87   
15152	343	S84   
15152	343	S87   
15157	343	S121  
15162	343	S121  
15164	343	S121  
15172	343	S84   
15232	343	S1163 
15260	343	S2109 
15261	343	S1163 
15262	343	S1163 
16006	343	S1164 
16010	343	S1164 
16011	343	S1164 
16011	343	S87   
16028	343	S84   
16029	343	S1164 
16037	343	S1164 
16038	343	S1164 
16097	343	S22   
16098	343	S22   
16098	343	S84   
16098	343	S87   
16167	343	S2203 
16338	343	S1164 
16397	343	S22   
16398	343	S22   
16398	343	S84   
16398	343	S87   
17202	343	S1166 
17203	343	S1166 
17204	343	S1166 
17204	343	S502  
17218	343	S1581 
17219	343	S1581 
18079	343	S25   
18159	343	S21   
18166	343	S25   
18168	343	S25   
18215	343	S25   
18228	343	S23   
18231	343	S25   
18288	343	S27   
18350	343	S21   
18363	343	S22   
18364	343	S22   
18365	343	S27   
18376	343	S25   
18927	343	S25   
18932	343	S27   
18933	343	S27   
18934	343	S27   
18935	343	S27   
18936	343	S27   
19064	343	S1164 
19078	343	S84   
19109	343	S1164 
19155	343	S1164 
19226	343	S84   
20020	343	S84   
20027	343	S84   
20033	343	S121  
20036	343	S84   
20037	343	S84   
20046	343	S20   
20048	343	S20   
20081	343	S20   
20081	343	S82   
20081	343	S87   
20082	343	S20   
20083	343	S20   
20084	343	S20   
20099	343	S1163 
20099	343	S20   
20099	343	S82   
20100	343	S1163 
20100	343	S20   
20109	343	S2105 
20110	343	S2105 
20120	343	S1163 
20120	343	S20   
20120	343	S82   
20121	343	S1163 
20121	343	S20   
20310	343	S2105 
20321	343	S1163 
20321	343	S20   
20400	343	S1163 
20400	343	S20   
20409	343	S2105 
20410	343	S2105 
20420	343	S1163 
20420	343	S20   
20420	343	S82   
20421	343	S1163 
20421	343	S20   
20446	343	S20   
20499	343	S1163 
20499	343	S20   
20499	343	S82   
20510	343	S2105 
20521	343	S1163 
20521	343	S20   
20581	343	S20   
20623	343	S1742 
20624	343	S1742 
20628	343	S1742 
20629	343	S1742 
20630	343	S1742 
20634	343	S1742 
20635	343	S1742 
20636	343	S1742 
20640	343	S1742 
20641	343	S1742 
20645	343	S1742 
20646	343	S1742 
21138	343	S1064 
21138	343	S1122 
21229	343	S1122 
21249	343	S1064 
21250	343	S1064 
21251	343	S1064 
21252	343	S1064 
21253	343	S1064 
21255	343	S1064 
21256	343	S1064 
21260	343	S1082 
21261	343	S1082 
21262	343	S1082 
21263	343	S1082 
21264	343	S1082 
21265	343	S1082 
21266	343	S1082 
21267	343	S1082 
21268	343	S1082 
21269	343	S1082 
21270	343	S1082 
21271	343	S2108 
21272	343	S2108 
21273	343	S2108 
21274	343	S2108 
21275	343	S2108 
21276	343	S2108 
21277	343	S2110 
21278	343	S2110 
21279	343	S2110 
21280	343	S2110 
21281	343	S2110 
21282	343	S2110 
21283	343	S2111 
21284	343	S2111 
21285	343	S2111 
21286	343	S2111 
21287	343	S2112 
21288	343	S2112 
21289	343	S2112 
21290	343	S2112 
21291	343	S2112 
21292	343	S2112 
21293	343	S2782 
21294	343	S2782 
21295	343	S2782 
21296	343	S2782 
21297	343	S2782 
21298	343	S2782 
21299	343	S2110 
21299	343	S2111 
21299	343	S2112 
21299	343	S2782 
21300	343	S2110 
21300	343	S2112 
21300	343	S2782 
21301	343	S2110 
21301	343	S2111 
21301	343	S2112 
21301	343	S2782 
21302	343	S2110 
21302	343	S2111 
21302	343	S2112 
21302	343	S2782 
21303	343	S2110 
21303	343	S2112 
21303	343	S2782 
21304	343	S2110 
21304	343	S2111 
21304	343	S2112 
21304	343	S2782 
22909	343	S22   
23011	343	S2703 
23014	343	S2703 
23015	343	S2703 
23018	343	S2703 
23019	343	S2703 
23020	343	S2703 
23021	343	S2703 
23022	343	S2703 
23023	343	S2703 
23024	343	S2703 
23025	343	S2703 
23027	343	S2703 
23028	343	S2703 
23029	343	S2703 
23030	343	S2703 
23031	343	S2703 
23034	343	S2703 
23035	343	S2703 
23037	343	S2703 
23038	343	S2703 
23041	343	S2703 
23042	343	S2703 
23045	343	S2703 
23046	343	S2703 
23049	343	S2703 
23050	343	S2703 
23053	343	S2703 
23054	343	S2703 
23055	343	S2703 
23056	343	S2703 
23057	343	S2703 
23058	343	S2703 
23059	343	S2703 
23060	343	S2703 
23061	343	S2703 
23062	343	S2703 
23063	343	S2703 
23064	343	S2703 
23582	343	S2    
23583	343	S2    
23584	343	S2    
23585	343	S2    
23586	343	S2    
23587	343	S2    
23588	343	S2    
23589	343	S2    
23590	343	S2    
23591	343	S2    
23592	343	S2    
23593	343	S2    
23594	343	S2    
23595	343	S2    
23596	343	S2    
23597	343	S2    
23598	343	S2    
23599	343	S2    
23600	343	S2    
23601	343	S2    
23602	343	S2    
23603	343	S2    
23604	343	S2    
23605	343	S2    
23606	343	S2    
23607	343	S2    
23608	343	S2    
23609	343	S2    
23610	343	S2    
23611	343	S2    
23612	343	S2    
23613	343	S2    
23614	343	S2    
23615	343	S2    
23616	343	S2    
23618	343	S2    
23619	343	S2    
23620	343	S2    
23622	343	S2    
23623	343	S2    
23624	343	S2    
23625	343	S2    
23626	343	S2    
23627	343	S2    
23628	343	S2    
23629	343	S2    
23630	343	S2    
23631	343	S2    
23632	343	S2    
23633	343	S2    
23634	343	S2    
23635	343	S2    
23636	343	S2    
23637	343	S2    
23638	343	S2    
23640	343	S1581 
23646	343	S2    
23647	343	S2    
23648	343	S2    
23649	343	S2    
23650	343	S2    
23651	343	S2    
23652	343	S2    
23653	343	S2    
23654	343	S2    
23655	343	S2    
23656	343	S2    
23657	343	S2    
23658	343	S2    
23659	343	S2    
23660	343	S2    
35130	343	S2381 
35131	343	S2381 
35132	343	S2381 
35133	343	S2381 
35134	343	S2381 
35135	343	S2381 
35136	343	S2381 
35137	343	S2381 
35138	343	S2381 
35140	343	S2381 
35141	343	S2381 
35142	343	S2381 
35143	343	S2381 
35144	343	S2381 
35145	343	S2381 
35146	343	S2381 
35147	343	S2381 
35148	343	S2381 
43378	343	S1166 
01077	401	S27   
01079	401	S1063 
01079	401	S20   
01082	401	S1063 
01085	401	S1063 
01103	401	S1163 
01123	401	S1063 
01123	401	S561  
01124	401	S1065 
01202	401	S1163 
04017	401	S19   
04023	401	S19   
04635	401	S19   
04638	401	S26   
04639	401	S26   
04640	401	S26   
04641	401	S25   
05023	401	S1581 
05027	401	S1082 
05173	401	S1581 
05174	401	S1581 
05175	401	S1581 
05176	401	S1581 
05177	401	S1581 
05178	401	S1581 
05312	401	S26   
05313	401	S26   
05320	401	S26   
05626	401	D4281 
05627	401	D4282 
05628	401	D4281 
05629	401	D4281 
05661	401	S1082 
06043	401	S18   
06094	401	S18   
06128	401	S18   
06159	401	S18   
06164	401	S23   
06931	401	S22   
06982	401	S18   
06983	401	S18   
06984	401	S2104 
06985	401	S2104 
07002	401	S222  
07005	401	S248  
07006	401	S247  
07007	401	S1164 
07008	401	S238  
07011	401	S227  
07013	401	S242  
07015	401	S248  
07016	401	S248  
07039	401	S244  
07052	401	S227  
07056	401	S248  
07057	401	S235  
07057	401	S238  
07058	401	S237  
07063	401	S1164 
07063	401	S582  
07064	401	S1164 
07068	401	S1041 
07076	401	S239  
07078	401	S228  
07078	401	S281  
07079	401	S227  
07089	401	S241  
07089	401	S251  
07276	401	S259  
07278	401	S259  
07279	401	S259  
07905	401	S281  
07906	401	S281  
07909	401	S259  
07910	401	S245  
07911	401	S226  
07912	401	S226  
07913	401	S238  
07916	401	S242  
07917	401	S242  
07918	401	S242  
07920	401	S242  
07922	401	S242  
07923	401	S245  
07924	401	S242  
07925	401	S281  
07926	401	S228  
07927	401	S227  
07928	401	S225  
07929	401	S227  
07930	401	S222  
07931	401	S222  
07932	401	S224  
07933	401	S224  
07934	401	S281  
07935	401	S224  
07936	401	S247  
07937	401	S239  
07938	401	S233  
07939	401	S235  
07941	401	S281  
07944	401	S227  
07951	401	S243  
07952	401	S1164 
07953	401	S1164 
07953	401	S582  
07954	401	S582  
07955	401	S1164 
07956	401	S1164 
07957	401	S1164 
07958	401	S1164 
07959	401	S1164 
07960	401	S1164 
08001	401	S2664 
08003	401	S2664 
08005	401	S2664 
08010	401	S702  
08011	401	S702  
08012	401	S702  
08013	401	S603  
08014	401	S2664 
08017	401	S603  
08018	401	S702  
08019	401	S603  
08020	401	S2664 
08023	401	S2664 
08025	401	S2662 
08026	401	S603  
08028	401	S2664 
08030	401	S2664 
08032	401	S2664 
08035	401	S603  
08045	401	S603  
08047	401	S702  
08048	401	S603  
08049	401	S702  
08050	401	S603  
08054	401	S702  
08057	401	S603  
08058	401	S2664 
08059	401	S702  
08060	401	S2664 
08061	401	S1065 
08064	401	S603  
08065	401	S1065 
08065	401	S2662 
08066	401	S702  
08067	401	S2664 
08068	401	S2664 
08069	401	S2664 
08071	401	S2664 
08074	401	S2662 
08077	401	S603  
08078	401	S603  
08082	401	S603  
08083	401	S2502 
08085	401	S702  
08086	401	S603  
08087	401	S603  
08089	401	S603  
08092	401	S702  
08094	401	S702  
08116	401	S2502 
08124	401	S702  
08128	401	S702  
08130	401	S702  
08138	401	S2502 
08139	401	S603  
08146	401	S702  
08147	401	S1065 
08147	401	S2422 
08177	401	S2502 
08189	401	S2664 
08190	401	S603  
08194	401	S603  
08200	401	S702  
08202	401	S603  
08206	401	S2502 
08210	401	S702  
08211	401	S702  
08212	401	S702  
08214	401	S702  
08215	401	S702  
08216	401	S702  
08217	401	S2664 
08218	401	S1065 
08219	401	S702  
08220	401	S702  
08221	401	S702  
08225	401	S702  
08229	401	S702  
08231	401	S702  
08232	401	S702  
08243	401	S603  
08244	401	S603  
08245	401	S603  
08246	401	S603  
08247	401	S603  
08253	401	S2664 
08258	401	S2664 
08259	401	S2662 
08261	401	S603  
08262	401	S603  
08263	401	S603  
08266	401	S603  
08267	401	S603  
08268	401	S603  
08269	401	S603  
08270	401	S603  
08271	401	S603  
08272	401	S603  
08273	401	S603  
08274	401	S603  
08277	401	S603  
08278	401	S603  
08284	401	S2664 
08286	401	S2664 
08288	401	S2664 
08293	401	S702  
08294	401	S702  
08299	401	S702  
08309	401	S2664 
08315	401	S702  
08316	401	S702  
08317	401	S702  
08318	401	S2664 
08345	401	S603  
08347	401	S2502 
08348	401	S2502 
08349	401	S2502 
08350	401	S2502 
08351	401	S702  
08352	401	S702  
08353	401	S702  
08354	401	S702  
08355	401	S702  
08357	401	S702  
08358	401	S702  
08359	401	S702  
08360	401	S702  
08361	401	S702  
08362	401	S702  
08363	401	S702  
08364	401	S702  
08366	401	S702  
08367	401	S603  
08368	401	S603  
08370	401	S603  
08371	401	S603  
08372	401	S603  
08374	401	S2664 
08376	401	S2664 
08380	401	S2664 
08383	401	S2664 
08385	401	S2664 
08386	401	S2664 
08387	401	S2664 
08394	401	S702  
08395	401	S702  
08396	401	S702  
08397	401	S603  
08398	401	S603  
08399	401	S603  
08400	401	S881  
08401	401	S881  
08402	401	S702  
08403	401	S1209 
08408	401	S2502 
08409	401	S2502 
08410	401	S702  
08411	401	S702  
08412	401	S702  
08413	401	S702  
08414	401	S702  
08415	401	S702  
08416	401	S702  
08417	401	S702  
08418	401	S702  
08419	401	S702  
08420	401	S702  
08421	401	S702  
08422	401	S702  
08435	401	S1065 
08436	401	S702  
08444	401	S702  
08446	401	S702  
08448	401	S702  
08449	401	S702  
08450	401	S702  
08454	401	S2664 
08455	401	S2664 
08457	401	S2664 
08458	401	S2664 
08460	401	S2664 
08465	401	S2664 
08466	401	S2664 
08468	401	S2664 
08469	401	S2664 
08470	401	S2664 
08471	401	S2664 
08472	401	S2664 
08473	401	S2664 
08474	401	S2664 
08476	401	S2502 
08481	401	S2502 
08482	401	S2502 
08483	401	S2502 
08484	401	S2502 
08487	401	S2502 
08488	401	S2502 
08489	401	S2502 
08490	401	S2502 
08491	401	S2502 
08492	401	S2502 
08493	401	S2502 
08494	401	S2502 
08495	401	S2502 
08497	401	S2502 
08498	401	S2502 
08500	401	S2502 
08501	401	S2502 
08504	401	S2662 
08505	401	S2662 
08506	401	S2662 
08507	401	S2662 
08508	401	S2662 
08509	401	S2662 
09003	401	S1183 
09032	401	S21   
09037	401	S1031 
09037	401	S1621 
09037	401	S381  
09038	401	S1031 
09038	401	S1621 
09039	401	S381  
09040	401	S1023 
09040	401	S562  
09050	401	S1141 
09060	401	S381  
09062	401	S381  
09070	401	S53   
09070	401	S582  
09078	401	S561  
09079	401	S1701 
09087	401	S564  
09087	401	S582  
09094	401	S363  
09094	401	S582  
09112	401	S482  
09112	401	S563  
09139	401	S381  
09148	401	S1033 
09148	401	S582  
09149	401	S381  
09160	401	S1065 
09181	401	S1024 
09183	401	S381  
09184	401	S1026 
09184	401	S562  
09195	401	S1202 
09195	401	S1562 
09202	401	S482  
09202	401	S564  
09218	401	S1065 
09218	401	S1161 
09252	401	S482  
09252	401	S541  
09266	401	S1167 
09266	401	S441  
09266	401	S561  
09291	401	S564  
09291	401	S566  
09298	401	S5    
09298	401	S564  
09298	401	S566  
09302	401	S381  
09302	401	S461  
09302	401	S566  
09302	401	S963  
09316	401	S1162 
09316	401	S421  
09316	401	S581  
09326	401	S1027 
09326	401	S461  
09409	401	S2104 
09421	401	S564  
09421	401	S582  
09422	401	S1202 
09427	401	D4053 
09428	401	D4053 
09429	401	S1167 
09429	401	S441  
09430	401	S441  
09430	401	S561  
09431	401	S2203 
09432	401	S2203 
09433	401	S2105 
10098	401	S1581 
10102	401	S1581 
10173	401	S1581 
10863	401	S1581 
11011	401	S1069 
11012	401	S1069 
11090	401	S1164 
11090	401	S619  
11091	401	S564  
11096	401	S1121 
11096	401	S482  
11097	401	S482  
11113	401	S1065 
11124	401	S1062 
11124	401	S618  
11125	401	S1062 
11130	401	S25   
11131	401	S25   
11143	401	S1121 
11143	401	S564  
11157	401	S1202 
11205	401	S1062 
11206	401	S1062 
11243	401	S2941 
11250	401	S562  
11250	401	S565  
11252	401	S481  
11252	401	S562  
11252	401	S624  
11257	401	S541  
11257	401	S565  
11260	401	D566  
11260	401	S2941 
11260	401	S78   
11260	401	S80   
11263	401	S2941 
11267	401	S2941 
11286	401	S1062 
11294	401	S563  
11294	401	S582  
11333	401	S1062 
11333	401	S611  
11339	401	S1062 
11357	401	S563  
11357	401	S566  
11358	401	S563  
11358	401	S566  
11359	401	S2105 
11360	401	S2105 
11394	401	S2105 
11395	401	S2105 
11398	401	S2105 
11399	401	S2105 
11402	401	S2105 
11403	401	S2105 
11411	401	S2105 
11412	401	S2105 
11429	401	S1121 
11429	401	S363  
11429	401	S617  
11464	401	S25   
11507	401	S1062 
11508	401	S1062 
11510	401	S1062 
11529	401	S441  
11529	401	S503  
11529	401	S608  
11546	401	S21   
11546	401	S5    
11546	401	S625  
11546	401	S626  
11546	401	S627  
11546	401	S641  
11547	401	S21   
11547	401	S625  
11547	401	S626  
11547	401	S627  
11547	401	S641  
11549	401	S21   
11674	401	S563  
11674	401	S566  
11705	401	S1069 
11742	401	S564  
11752	401	S1065 
11757	401	S1062 
11760	401	S25   
11828	401	S563  
11828	401	S566  
11841	401	S2105 
11842	401	S2105 
11856	401	S25   
11875	401	S1062 
11876	401	S1062 
11887	401	S21   
11887	401	S5    
11887	401	S625  
11887	401	S626  
11887	401	S627  
11887	401	S641  
11888	401	S21   
11888	401	S625  
11888	401	S626  
11888	401	S627  
11888	401	S641  
11921	401	S1062 
11950	401	S2941 
11987	401	S2941 
11990	401	S1202 
11991	401	S1202 
11992	401	S2941 
12038	401	S661  
12038	401	S961  
12061	401	S141  
12062	401	S141  
12063	401	S141  
12065	401	S141  
12078	401	S1063 
12078	401	S503  
12086	401	S343  
12086	401	S363  
12086	401	S502  
12087	401	S343  
12120	401	S83   
12121	401	S83   
12122	401	S83   
12131	401	S77   
12132	401	S77   
12142	401	S85   
12143	401	S85   
12144	401	S85   
12147	401	S502  
12147	401	S564  
12151	401	S86   
12152	401	S86   
12154	401	S941  
12155	401	S79   
12220	401	S1221 
12220	401	S2109 
12538	401	S661  
12538	401	S961  
12563	401	S141  
12565	401	S141  
12586	401	S343  
12586	401	S363  
12586	401	S502  
12632	401	S77   
12643	401	S85   
12644	401	S85   
12652	401	S86   
13067	401	S2    
13070	401	S2    
13096	401	S2    
13098	401	S2    
13165	401	S2    
13318	401	S1581 
13320	401	S1581 
13321	401	S1581 
13323	401	S1581 
13325	401	S1082 
13327	401	S1082 
13340	401	S1581 
13343	401	S2    
13369	401	S2    
13370	401	S2    
13373	401	S2    
13375	401	S2    
13377	401	S2    
13378	401	S2    
13391	401	S2    
13394	401	S2    
13398	401	S2    
13399	401	S2    
13401	401	S2    
13402	401	S2    
13404	401	S2    
13405	401	S2    
13407	401	S2    
13408	401	S2    
13410	401	S2    
13411	401	S2    
13413	401	S2    
13414	401	S2    
13415	401	S2    
13416	401	S2    
13417	401	S2    
13418	401	S2    
13419	401	S2    
13420	401	S2    
13422	401	S2    
13423	401	S2    
13424	401	S2    
13425	401	S2    
13426	401	S2    
13439	401	S2    
13440	401	S2    
13441	401	S2    
13442	401	S2    
13443	401	S2    
13444	401	S2    
13445	401	S2    
13446	401	S2    
13447	401	S2    
13448	401	S2    
13449	401	S2    
13450	401	S2    
13451	401	S2    
13452	401	S2    
13453	401	S2    
13455	401	S2    
13456	401	S2    
13485	401	S2    
13486	401	S2    
13487	401	S2    
13488	401	S2    
13490	401	S2    
13491	401	S2    
13492	401	S2    
13493	401	S2    
13805	401	S2    
13806	401	S2    
13809	401	S2    
13811	401	S2    
13813	401	S2    
13850	401	S2    
13853	401	S2    
13854	401	S2    
13856	401	S2    
13857	401	S2    
13868	401	S2    
13870	401	S2    
13871	401	S2    
13873	401	S2    
13874	401	S2    
13875	401	S2    
13876	401	S2    
13877	401	S2    
13879	401	S2    
13880	401	S2    
13881	401	S2    
13882	401	S2    
13891	401	S2    
13894	401	S2    
13896	401	S2    
13898	401	S2    
13900	401	S2    
13909	401	S2    
13911	401	S2    
13912	401	S2    
13913	401	S2    
13914	401	S2    
13917	401	S2    
13920	401	S2    
13921	401	S2    
13923	401	S2    
13924	401	S2    
13929	401	S2    
13931	401	S2    
13932	401	S2    
13934	401	S2    
13935	401	S2    
13948	401	S2    
13949	401	S2    
13950	401	S2    
13951	401	S2    
13952	401	S2    
13953	401	S2    
13954	401	S2    
13955	401	S2    
13956	401	S2    
13957	401	S2    
13958	401	S2    
13959	401	S2    
13968	401	S2    
13969	401	S2    
13970	401	S2    
13971	401	S2    
13985	401	S2    
14003	401	S2103 
14006	401	S2103 
14084	401	S2103 
14096	401	S2103 
14106	401	S2103 
14209	401	S23   
14238	401	S2104 
14242	401	S2104 
14323	401	S1067 
14347	401	S1064 
14347	401	S1122 
14366	401	S2104 
14370	401	S2104 
14382	401	S1164 
14450	401	S1164 
14460	401	S1164 
14461	401	S1164 
14462	401	S2109 
14602	401	S2103 
15027	401	S1163 
15073	401	S1163 
15087	401	S2109 
15152	401	S2104 
15260	401	S2109 
16006	401	S1164 
16010	401	S1164 
16011	401	S1164 
16042	401	S1065 
16043	401	S1065 
16089	401	S563  
16147	401	S2104 
16167	401	S2203 
16343	401	S1065 
17202	401	S1082 
17204	401	S1082 
17218	401	S1581 
17219	401	S1581 
18001	401	S1162 
18069	401	S20   
18166	401	S25   
18168	401	S25   
18215	401	S25   
18228	401	S23   
18231	401	S25   
18258	401	S1162 
18259	401	S1162 
18262	401	S1162 
18263	401	S1162 
18376	401	S25   
18927	401	S25   
18930	401	S2203 
18931	401	S2203 
18932	401	S27   
18933	401	S27   
18934	401	S27   
19003	401	S26   
19008	401	S2109 
19014	401	S5    
19056	401	S26   
19057	401	S2109 
19058	401	S2109 
19064	401	S1164 
19076	401	S1164 
19078	401	S1069 
19109	401	S1164 
19120	401	S1069 
19155	401	S1164 
19283	401	S1067 
19411	401	S26   
19802	401	S2109 
19856	401	S1067 
19873	401	S1067 
20623	401	S1742 
20624	401	S1742 
20628	401	S1742 
20629	401	S1742 
20630	401	S1742 
20634	401	S1742 
20635	401	S1742 
20636	401	S1742 
20640	401	S1742 
20641	401	S1742 
20645	401	S1742 
20646	401	S1742 
21138	401	S1064 
21138	401	S1066 
21138	401	S1122 
21141	401	S1064 
21224	401	S19   
21225	401	S19   
21226	401	S22   
21227	401	S22   
21229	401	S1122 
21238	401	S2801 
21239	401	S1066 
21240	401	S1066 
21241	401	S1066 
21242	401	S1066 
21243	401	S1066 
21244	401	S1066 
21245	401	S1066 
21246	401	S1066 
21247	401	S1066 
21248	401	S1066 
21249	401	S1064 
21250	401	S1064 
21251	401	S1064 
21252	401	S1064 
21253	401	S1064 
21254	401	S1064 
21255	401	S1064 
21256	401	S1064 
21257	401	S1064 
21259	401	S1064 
21271	401	S2108 
21272	401	S2108 
21273	401	S2108 
21274	401	S2108 
21275	401	S2108 
21276	401	S2108 
21277	401	S2110 
21278	401	S2110 
21279	401	S2110 
21280	401	S2110 
21281	401	S2110 
21282	401	S2110 
21283	401	S2111 
21284	401	S2111 
21285	401	S2111 
21286	401	S2111 
21287	401	S2112 
21288	401	S2112 
21289	401	S2112 
21290	401	S2112 
21291	401	S2112 
21292	401	S2112 
21293	401	S2782 
21294	401	S2782 
21295	401	S2782 
21296	401	S2782 
21297	401	S2782 
21298	401	S2782 
21299	401	S2110 
21299	401	S2111 
21299	401	S2112 
21299	401	S2782 
21300	401	S2110 
21300	401	S2112 
21300	401	S2782 
21301	401	S2110 
21301	401	S2111 
21301	401	S2112 
21301	401	S2782 
21302	401	S2110 
21302	401	S2111 
21302	401	S2112 
21302	401	S2782 
21303	401	S2110 
21303	401	S2112 
21303	401	S2782 
21304	401	S2110 
21304	401	S2111 
21304	401	S2112 
21304	401	S2782 
21308	401	S2801 
21309	401	S2801 
21310	401	S2801 
21311	401	S2801 
21312	401	S2801 
21313	401	S2801 
21314	401	S2801 
21315	401	S2801 
21316	401	S2801 
21318	401	S2801 
21319	401	S2801 
21322	401	S2801 
21323	401	S2801 
21324	401	S2801 
21342	401	S2801 
21346	401	S2801 
21347	401	S2801 
21348	401	S2801 
21349	401	S2801 
22247	401	S20   
22903	401	S21   
22904	401	S18   
22909	401	S22   
22911	401	S18   
22915	401	S19   
22916	401	S19   
23582	401	S2    
23583	401	S2    
23585	401	S2    
23586	401	S2    
23587	401	S2    
23589	401	S2    
23590	401	S2    
23591	401	S2    
23592	401	S2    
23593	401	S2    
23594	401	S2    
23595	401	S2    
23596	401	S2    
23597	401	S2    
23599	401	S2    
23601	401	S2    
23603	401	S2    
23604	401	S2    
23607	401	S2    
23609	401	S2    
23613	401	S2    
23615	401	S2    
23616	401	S2    
23618	401	S2    
23619	401	S2    
23620	401	S2    
23623	401	S2    
23624	401	S2    
23626	401	S2    
23627	401	S2    
23628	401	S2    
23630	401	S2    
23631	401	S2    
23632	401	S2    
23634	401	S2    
23635	401	S2    
23636	401	S2    
23637	401	S2    
23640	401	S1581 
23646	401	S2    
23647	401	S2    
23648	401	S2    
23649	401	S2    
23650	401	S2    
23651	401	S2    
23652	401	S2    
23653	401	S2    
23654	401	S2    
23655	401	S2    
23656	401	S2    
23657	401	S2    
23658	401	S2    
23659	401	S2    
23660	401	S2    
35001	401	D4961 
35003	401	D4961 
35004	401	D4961 
35008	401	D4961 
35017	401	D4961 
35024	401	D4961 
35026	401	D4961 
35027	401	D4961 
35029	401	D4961 
35030	401	D4961 
35034	401	D4961 
35038	401	D4961 
35041	401	D4961 
35043	401	D4961 
35047	401	D4961 
35048	401	D4961 
35050	401	D4961 
35051	401	D4961 
35054	401	D4961 
35063	401	D4961 
35073	401	D4961 
35074	401	D4961 
35078	401	D4961 
35080	401	D4961 
35093	401	D4961 
35130	401	S2381 
35131	401	S2381 
35132	401	S2381 
35134	401	S2381 
35135	401	S2381 
35136	401	S2381 
35137	401	S2381 
35138	401	S2381 
35143	401	S2381 
35144	401	S2381 
35145	401	S2381 
35146	401	S2381 
35147	401	S2381 
35148	401	S2381 
42190	401	S243  
43215	401	S26   
43364	401	S26   
43372	401	S5    
43514	401	S1067 
01026	404	S25   
01029	404	S27   
01032	404	S19   
01040	404	S27   
01046	404	S19   
01077	404	S27   
01079	404	S1063 
01079	404	S20   
01082	404	S1063 
01085	404	S1063 
01103	404	S1163 
01123	404	S1063 
01123	404	S561  
01124	404	S1065 
01125	404	S1065 
01202	404	S1163 
04017	404	S19   
04020	404	S19   
04021	404	S19   
04023	404	S19   
04114	404	S19   
04120	404	S19   
04141	404	S19   
04142	404	S19   
04143	404	S19   
04144	404	S19   
04367	404	S19   
04610	404	S18   
04628	404	S18   
04629	404	S18   
04630	404	S19   
04631	404	S20   
04635	404	S19   
04636	404	S19   
04638	404	S26   
04639	404	S26   
04640	404	S26   
04641	404	S25   
05023	404	S1581 
05024	404	S1581 
05027	404	S1082 
05028	404	S1082 
05173	404	S1581 
05174	404	S1581 
05175	404	S1581 
05176	404	S1581 
05177	404	S1581 
05178	404	S1581 
05312	404	S26   
05313	404	S26   
05320	404	S26   
05626	404	D4281 
05627	404	D4282 
05628	404	D4281 
05629	404	D4281 
05661	404	S1082 
06016	404	S18   
06019	404	S18   
06043	404	S18   
06094	404	S18   
06128	404	S18   
06159	404	S18   
06164	404	S23   
06931	404	S22   
06982	404	S18   
06983	404	S18   
06984	404	S2104 
06985	404	S2104 
07002	404	S222  
07005	404	S248  
07007	404	S1164 
07008	404	S238  
07015	404	S248  
07016	404	S248  
07022	404	S21   
07034	404	S249  
07039	404	S244  
07056	404	S248  
07057	404	S235  
07057	404	S238  
07063	404	S1164 
07063	404	S582  
07064	404	S1164 
07070	404	S238  
07075	404	S1164 
07079	404	S227  
07241	404	S21   
07910	404	S245  
07913	404	S238  
07923	404	S245  
07931	404	S222  
07938	404	S233  
07939	404	S235  
07945	404	S21   
07951	404	S243  
07952	404	S1164 
07953	404	S1164 
07953	404	S582  
07954	404	S582  
07955	404	S1164 
07956	404	S1164 
07957	404	S1164 
07958	404	S1164 
07959	404	S1164 
07960	404	S1164 
08001	404	S1065 
08003	404	S2664 
08005	404	S2664 
08010	404	S702  
08011	404	S702  
08012	404	S1065 
08013	404	S1065 
08014	404	S1065 
08017	404	S603  
08018	404	S702  
08019	404	S603  
08020	404	S1065 
08023	404	S2664 
08025	404	S2662 
08026	404	S603  
08028	404	S2664 
08030	404	S1065 
08031	404	S2664 
08032	404	S2664 
08035	404	S603  
08045	404	S603  
08047	404	S702  
08048	404	S603  
08049	404	S702  
08050	404	S603  
08054	404	S702  
08057	404	S603  
08058	404	S2664 
08059	404	S702  
08060	404	S2664 
08061	404	S1065 
08064	404	S603  
08065	404	S1065 
08065	404	S2662 
08066	404	S702  
08067	404	S2664 
08068	404	S2664 
08069	404	S2664 
08071	404	S2664 
08074	404	S2662 
08077	404	S2421 
08078	404	S603  
08082	404	S603  
08083	404	S2502 
08085	404	S702  
08086	404	S603  
08087	404	S603  
08089	404	S603  
08092	404	S702  
08094	404	S702  
08116	404	S2502 
08124	404	S702  
08128	404	S702  
08130	404	S702  
08138	404	S2502 
08139	404	S603  
08146	404	S702  
08147	404	S1065 
08147	404	S2422 
08177	404	S2502 
08189	404	S2664 
08190	404	S603  
08194	404	S603  
08200	404	S702  
08202	404	S603  
08206	404	S2502 
08210	404	S702  
08211	404	S702  
08212	404	S702  
08214	404	S702  
08215	404	S702  
08216	404	S702  
08217	404	S2664 
08218	404	S1065 
08219	404	S702  
08220	404	S702  
08221	404	S702  
08225	404	S702  
08229	404	S702  
08231	404	S702  
08232	404	S702  
08243	404	S603  
08244	404	S603  
08245	404	S603  
08246	404	S603  
08247	404	S603  
08253	404	S2664 
08258	404	S2664 
08259	404	S2662 
08261	404	S603  
08262	404	S603  
08263	404	S603  
08266	404	S603  
08267	404	S603  
08268	404	S603  
08269	404	S603  
08270	404	S603  
08271	404	S603  
08272	404	S603  
08273	404	S603  
08274	404	S603  
08277	404	S603  
08278	404	S603  
08283	404	S2664 
08284	404	S2664 
08286	404	S2664 
08287	404	S2664 
08288	404	S2664 
08289	404	S2664 
08293	404	S702  
08294	404	S702  
08299	404	S702  
08309	404	S2664 
08315	404	S702  
08316	404	S702  
08317	404	S702  
08318	404	S2664 
08319	404	S2664 
08345	404	S603  
08346	404	S2502 
08347	404	S2502 
08348	404	S2502 
08349	404	S2502 
08350	404	S2502 
08351	404	S702  
08352	404	S702  
08353	404	S702  
08354	404	S702  
08355	404	S702  
08357	404	S702  
08358	404	S702  
08359	404	S702  
08360	404	S702  
08361	404	S702  
08362	404	S702  
08363	404	S702  
08364	404	S702  
08366	404	S702  
08367	404	S603  
08368	404	S603  
08370	404	S603  
08371	404	S603  
08372	404	S603  
08374	404	S2664 
08376	404	S2664 
08380	404	S2664 
08383	404	S2664 
08384	404	S2664 
08385	404	S2664 
08386	404	S2664 
08388	404	S682  
08389	404	S682  
08390	404	S682  
08391	404	S682  
08392	404	S682  
08394	404	S702  
08395	404	S702  
08396	404	S702  
08397	404	S603  
08398	404	S603  
08399	404	S603  
08400	404	S881  
08401	404	S881  
08402	404	S702  
08403	404	S1209 
08408	404	S2502 
08409	404	S2502 
08410	404	S702  
08411	404	S702  
08412	404	S702  
08413	404	S702  
08414	404	S702  
08415	404	S702  
08416	404	S702  
08417	404	S702  
08418	404	S702  
08419	404	S702  
08420	404	S702  
08421	404	S702  
08422	404	S702  
08435	404	S1065 
08436	404	S702  
08444	404	S702  
08446	404	S702  
08448	404	S702  
08449	404	S702  
08450	404	S702  
08454	404	S2664 
08455	404	S2664 
08456	404	S2664 
08457	404	S2664 
08458	404	S2664 
08459	404	S2664 
08460	404	S2664 
08465	404	S2664 
08466	404	S2664 
08468	404	S2664 
08469	404	S2664 
08470	404	S2664 
08471	404	S2664 
08472	404	S2664 
08473	404	S2664 
08474	404	S2664 
08476	404	S2502 
08478	404	S2502 
08481	404	S2502 
08482	404	S2502 
08483	404	S2502 
08484	404	S2502 
08487	404	S2502 
08488	404	S2502 
08489	404	S2502 
08490	404	S2502 
08491	404	S2502 
08492	404	S2502 
08493	404	S2502 
08494	404	S2502 
08495	404	S2502 
08497	404	S2502 
08498	404	S2502 
08500	404	S2502 
08501	404	S2502 
08504	404	S2662 
08505	404	S2662 
08506	404	S2662 
08507	404	S2662 
08508	404	S2662 
08509	404	S2662 
09003	404	S1183 
09003	404	S502  
09003	404	S561  
09004	404	S502  
09032	404	S21   
09037	404	S1031 
09037	404	S381  
09037	404	S481  
09037	404	S502  
09038	404	S1031 
09038	404	S481  
09038	404	S502  
09039	404	S381  
09040	404	S1023 
09040	404	S481  
09040	404	S562  
09042	404	S461  
09042	404	S566  
09050	404	S1141 
09050	404	S421  
09050	404	S441  
09060	404	S381  
09062	404	S381  
09062	404	S404  
09070	404	S53   
09070	404	S582  
09078	404	S561  
09079	404	S1701 
09087	404	S1032 
09087	404	S564  
09087	404	S582  
09094	404	S363  
09094	404	S582  
09112	404	S482  
09112	404	S563  
09132	404	S1062 
09139	404	S381  
09148	404	S582  
09149	404	S381  
09160	404	S1065 
09181	404	S1024 
09181	404	S1121 
09181	404	S461  
09183	404	S381  
09184	404	S1026 
09184	404	S562  
09191	404	S421  
09191	404	S582  
09195	404	S1202 
09202	404	S482  
09202	404	S564  
09218	404	S1065 
09218	404	S1161 
09236	404	S461  
09236	404	S582  
09252	404	S482  
09252	404	S541  
09266	404	S1167 
09266	404	S441  
09266	404	S561  
09273	404	S2104 
09273	404	S2985 
09279	404	S421  
09279	404	S582  
09291	404	S564  
09291	404	S566  
09298	404	S564  
09298	404	S566  
09302	404	S381  
09302	404	S461  
09302	404	S566  
09302	404	S963  
09316	404	S421  
09316	404	S566  
09316	404	S581  
09326	404	S1027 
09326	404	S441  
09326	404	S461  
09409	404	S2104 
09409	404	S2985 
09421	404	S564  
09421	404	S582  
09422	404	S1202 
09429	404	S1167 
09429	404	S441  
09430	404	S441  
09430	404	S561  
09431	404	S2203 
09432	404	S2203 
09433	404	S2105 
09433	404	S2961 
10007	404	S1082 
10066	404	S1082 
10067	404	S1082 
10068	404	S1082 
10098	404	S1581 
10099	404	S1581 
10102	404	S1581 
10119	404	S1581 
10123	404	S1082 
10124	404	S1082 
10173	404	S1581 
10858	404	S1082 
10860	404	S1082 
10861	404	S1082 
10862	404	S1082 
10863	404	S1581 
10864	404	S1082 
11011	404	S1069 
11012	404	S1069 
11090	404	S1121 
11090	404	S564  
11090	404	S619  
11091	404	S1121 
11091	404	S564  
11096	404	S1121 
11096	404	S482  
11097	404	S482  
11112	404	S1065 
11113	404	S1065 
11124	404	S1062 
11124	404	S618  
11125	404	S1062 
11130	404	S25   
11131	404	S25   
11143	404	S1121 
11143	404	S564  
11157	404	S1202 
11205	404	S1062 
11206	404	S1062 
11243	404	S2941 
11250	404	S562  
11250	404	S565  
11251	404	S481  
11251	404	S503  
11251	404	S620  
11252	404	S481  
11252	404	S562  
11252	404	S624  
11253	404	S541  
11253	404	S565  
11257	404	S541  
11257	404	S565  
11260	404	S2941 
11260	404	S78   
11260	404	S80   
11263	404	S2941 
11267	404	S2941 
11282	404	S1062 
11286	404	S1062 
11294	404	S563  
11294	404	S582  
11333	404	S1062 
11333	404	S611  
11339	404	S1062 
11352	404	S563  
11352	404	S566  
11353	404	S563  
11353	404	S566  
11354	404	S563  
11354	404	S566  
11355	404	S563  
11355	404	S566  
11356	404	S563  
11356	404	S566  
11357	404	S563  
11357	404	S566  
11358	404	S563  
11358	404	S566  
11359	404	S2105 
11360	404	S2105 
11394	404	S2105 
11395	404	S2105 
11398	404	S2105 
11399	404	S2105 
11402	404	S2105 
11403	404	S2105 
11411	404	S2105 
11412	404	S2105 
11429	404	S1121 
11429	404	S363  
11429	404	S617  
11463	404	S25   
11464	404	S25   
11507	404	S1062 
11508	404	S1062 
11510	404	S1062 
11529	404	S441  
11529	404	S503  
11529	404	S608  
11530	404	S441  
11546	404	S21   
11547	404	S21   
11549	404	S21   
11674	404	S563  
11674	404	S566  
11705	404	S1069 
11742	404	S1121 
11742	404	S564  
11752	404	S1065 
11757	404	S1062 
11760	404	S25   
11821	404	S1062 
11828	404	S563  
11828	404	S566  
11841	404	S2105 
11842	404	S2105 
11856	404	S25   
11875	404	S1062 
11876	404	S1062 
11884	404	S441  
11887	404	S21   
11888	404	S21   
11921	404	S1062 
11935	404	S22   
11949	404	S22   
11950	404	S2941 
11960	404	S481  
11960	404	S562  
11987	404	S1202 
11987	404	S2941 
11990	404	S1202 
11991	404	S1202 
11992	404	S2941 
12061	404	S141  
12062	404	S141  
12063	404	S141  
12065	404	S141  
12078	404	S1063 
12078	404	S503  
12086	404	S343  
12086	404	S363  
12086	404	S502  
12087	404	S343  
12120	404	S83   
12121	404	S83   
12122	404	S83   
12131	404	S77   
12132	404	S77   
12142	404	S85   
12143	404	S85   
12144	404	S85   
12147	404	S502  
12147	404	S564  
12151	404	S86   
12152	404	S86   
12154	404	S941  
12155	404	S79   
12201	404	S1164 
12220	404	S1221 
12220	404	S2109 
12563	404	S141  
12565	404	S141  
12586	404	S343  
12586	404	S363  
12586	404	S502  
12632	404	S77   
12643	404	S85   
12644	404	S85   
12652	404	S86   
13019	404	S2    
13020	404	S2    
13055	404	S2    
13065	404	S2    
13067	404	S2    
13068	404	S2    
13070	404	S2    
13096	404	S2    
13098	404	S2    
13165	404	S2    
13318	404	S1581 
13320	404	S1581 
13321	404	S1581 
13322	404	S1581 
13323	404	S1581 
13324	404	S1581 
13325	404	S1082 
13326	404	S1082 
13327	404	S1082 
13340	404	S1581 
13341	404	S1581 
13343	404	S2    
13369	404	S2    
13370	404	S2    
13373	404	S2    
13375	404	S2    
13377	404	S2    
13378	404	S2    
13391	404	S2    
13394	404	S2    
13398	404	S2    
13399	404	S2    
13401	404	S2    
13402	404	S2    
13404	404	S2    
13405	404	S2    
13407	404	S2    
13408	404	S2    
13410	404	S2    
13411	404	S2    
13413	404	S2    
13414	404	S2    
13415	404	S2    
13416	404	S2    
13417	404	S2    
13418	404	S2    
13419	404	S2    
13420	404	S2    
13421	404	S2    
13422	404	S2    
13423	404	S2    
13424	404	S2    
13425	404	S2    
13426	404	S2    
13439	404	S2    
13440	404	S2    
13441	404	S2    
13442	404	S2    
13443	404	S2    
13444	404	S2    
13445	404	S2    
13446	404	S2    
13447	404	S2    
13448	404	S2    
13449	404	S2    
13450	404	S2    
13451	404	S2    
13452	404	S2    
13453	404	S2    
13454	404	S2    
13455	404	S2    
13456	404	S2    
13485	404	S2    
13486	404	S2    
13487	404	S2    
13488	404	S2    
13490	404	S2    
13491	404	S2    
13492	404	S2    
13493	404	S2    
13494	404	S14   
13495	404	S14   
13496	404	S14   
13497	404	S14   
13498	404	S14   
13565	404	S2703 
13566	404	S2703 
13567	404	S2703 
13568	404	S2703 
13569	404	S2703 
13805	404	S2    
13806	404	S2    
13809	404	S2    
13810	404	S2    
13811	404	S2    
13812	404	S2    
13813	404	S2    
13814	404	S2    
13850	404	S2    
13851	404	S2    
13853	404	S2    
13854	404	S2    
13856	404	S2    
13857	404	S2    
13868	404	S2    
13869	404	S2    
13870	404	S2    
13871	404	S2    
13872	404	S2    
13873	404	S2    
13874	404	S2    
13875	404	S2    
13876	404	S2    
13877	404	S2    
13878	404	S2    
13879	404	S2    
13880	404	S2    
13881	404	S2    
13882	404	S2    
13891	404	S2    
13893	404	S2    
13894	404	S2    
13896	404	S2    
13898	404	S2    
13900	404	S2    
13909	404	S2    
13910	404	S2    
13911	404	S2    
13912	404	S2    
13913	404	S2    
13914	404	S2    
13917	404	S2    
13918	404	S2    
13920	404	S2    
13921	404	S2    
13923	404	S2    
13924	404	S2    
13929	404	S2    
13930	404	S2    
13931	404	S2    
13932	404	S2    
13934	404	S2    
13935	404	S2    
13948	404	S2    
13949	404	S2    
13950	404	S2    
13951	404	S2    
13952	404	S2    
13953	404	S2    
13954	404	S2    
13955	404	S2    
13956	404	S2    
13957	404	S2    
13958	404	S2    
13959	404	S2    
13968	404	S2    
13969	404	S2    
13970	404	S2    
13971	404	S2    
13985	404	S2    
13988	404	S2703 
13989	404	S2703 
13990	404	S2703 
13991	404	S2703 
13992	404	S2703 
13994	404	S2703 
13995	404	S2703 
13996	404	S2703 
13997	404	S2703 
13998	404	S2703 
14003	404	S2103 
14006	404	S2103 
14084	404	S2103 
14096	404	S2103 
14106	404	S2103 
14154	404	S2702 
14156	404	S2702 
14209	404	S1064 
14209	404	S1066 
14209	404	S1122 
14238	404	S2104 
14242	404	S2104 
14323	404	S1067 
14347	404	S1064 
14347	404	S1122 
14366	404	S2104 
14370	404	S2104 
14382	404	S1164 
14450	404	S1164 
14460	404	S1164 
14461	404	S1164 
14601	404	S1066 
14602	404	S2103 
15027	404	S1163 
15073	404	S1163 
15087	404	S2109 
15152	404	S2104 
15232	404	S1163 
15260	404	S2109 
15261	404	S1163 
15262	404	S1163 
16006	404	S1164 
16010	404	S1164 
16011	404	S1164 
16029	404	S1164 
16037	404	S1164 
16037	404	S2202 
16038	404	S1164 
16038	404	S2202 
16042	404	S1065 
16042	404	S2202 
16043	404	S1065 
16043	404	S2202 
16089	404	S563  
16097	404	S22   
16098	404	S22   
16112	404	S39   
16114	404	S39   
16120	404	S39   
16123	404	S39   
16126	404	S39   
16139	404	S39   
16147	404	S2104 
16159	404	D342  
16159	404	S39   
16167	404	S2203 
16174	404	S18   
16338	404	S1164 
16338	404	S2202 
16343	404	S1065 
16343	404	S2202 
16397	404	S22   
16398	404	S22   
17202	404	S1082 
17203	404	S1082 
17204	404	S1082 
17218	404	S1581 
17219	404	S1581 
17332	404	S3    
17335	404	S3    
17340	404	S3    
17341	404	S3    
17345	404	S3    
17346	404	S3    
17347	404	S3    
17348	404	S3    
18001	404	S1162 
18002	404	S1162 
18069	404	S20   
18079	404	S25   
18159	404	S21   
18166	404	S25   
18168	404	S25   
18215	404	S25   
18228	404	S23   
18231	404	S25   
18258	404	S1162 
18259	404	S1162 
18262	404	S1162 
18263	404	S1162 
18288	404	S27   
18350	404	S21   
18363	404	S22   
18364	404	S22   
18365	404	S27   
18376	404	S25   
18403	404	S27   
18927	404	S25   
18930	404	S2203 
18931	404	S2203 
18932	404	S27   
18933	404	S27   
18934	404	S27   
18935	404	S27   
18936	404	S27   
19003	404	S26   
19034	404	S26   
19056	404	S26   
19057	404	S2109 
19058	404	S2109 
19064	404	S1164 
19076	404	S1164 
19078	404	S1069 
19109	404	S1164 
19120	404	S1069 
19155	404	S1164 
19230	404	S1063 
19350	404	S1164 
19411	404	S26   
20046	404	S20   
20047	404	S20   
20048	404	S20   
20099	404	S1163 
20099	404	S20   
20100	404	S1163 
20100	404	S20   
20109	404	S2105 
20110	404	S2105 
20120	404	S1163 
20120	404	S20   
20121	404	S1163 
20121	404	S20   
20132	404	S1202 
20310	404	S2105 
20321	404	S1163 
20321	404	S20   
20446	404	S2722 
20623	404	S1742 
20624	404	S1742 
20628	404	S1742 
20629	404	S1742 
20630	404	S1742 
20634	404	S1742 
20635	404	S1742 
20636	404	S1742 
20640	404	S1742 
20641	404	S1742 
20645	404	S1742 
20646	404	S1742 
21138	404	S1064 
21138	404	S1066 
21138	404	S1122 
21141	404	S1064 
21224	404	S19   
21225	404	S19   
21226	404	S22   
21227	404	S22   
21229	404	S1122 
21238	404	S2801 
21239	404	S1066 
21240	404	S1066 
21241	404	S1066 
21242	404	S1066 
21243	404	S1066 
21244	404	S1066 
21245	404	S1066 
21246	404	S1066 
21247	404	S1066 
21248	404	S1066 
21249	404	S1064 
21250	404	S1064 
21251	404	S1064 
21252	404	S1064 
21253	404	S1064 
21254	404	S1064 
21255	404	S1064 
21256	404	S1064 
21257	404	S1064 
21259	404	S1064 
21260	404	S1082 
21261	404	S1082 
21262	404	S1082 
21263	404	S1082 
21264	404	S1082 
21265	404	S1082 
21266	404	S1082 
21267	404	S1082 
21268	404	S1082 
21269	404	S1082 
21270	404	S1082 
21271	404	S2108 
21272	404	S2108 
21273	404	S2108 
21274	404	S2108 
21275	404	S2108 
21276	404	S2108 
21277	404	S2110 
21278	404	S2110 
21279	404	S2110 
21280	404	S2110 
21281	404	S2110 
21282	404	S2110 
21283	404	S2111 
21284	404	S2111 
21285	404	S2111 
21286	404	S2111 
21287	404	S2112 
21288	404	S2112 
21289	404	S2112 
21290	404	S2112 
21291	404	S2112 
21292	404	S2112 
21293	404	S2782 
21294	404	S2782 
21295	404	S2782 
21296	404	S2782 
21297	404	S2782 
21298	404	S2782 
21299	404	S2110 
21299	404	S2111 
21299	404	S2112 
21299	404	S2782 
21300	404	S2110 
21300	404	S2112 
21300	404	S2782 
21301	404	S2110 
21301	404	S2111 
21301	404	S2112 
21301	404	S2782 
21302	404	S2110 
21302	404	S2111 
21302	404	S2112 
21302	404	S2782 
21303	404	S2110 
21303	404	S2112 
21303	404	S2782 
21304	404	S2110 
21304	404	S2111 
21304	404	S2112 
21304	404	S2782 
21308	404	S2801 
21309	404	S2801 
21310	404	S2801 
21311	404	S2801 
21312	404	S2801 
21313	404	S2801 
21314	404	S2801 
21315	404	S2801 
21316	404	S2801 
21317	404	S2801 
21318	404	S2801 
21319	404	S2801 
21320	404	S2801 
21321	404	S2801 
21322	404	S2801 
21323	404	S2801 
21324	404	S2801 
21325	404	S2801 
21326	404	S2801 
21337	404	S2801 
21343	404	S2801 
21346	404	S2801 
21347	404	S2801 
21348	404	S2801 
21349	404	S2801 
22247	404	S20   
22903	404	S21   
22904	404	S18   
22909	404	S22   
22911	404	S18   
22912	404	S19   
22914	404	S19   
22915	404	S19   
22916	404	S19   
23009	404	S2703 
23010	404	S2703 
23011	404	S2703 
23012	404	S2703 
23013	404	S2703 
23014	404	S2703 
23015	404	S2703 
23016	404	S2703 
23017	404	S2703 
23018	404	S2703 
23019	404	S2703 
23020	404	S2703 
23021	404	S2703 
23022	404	S2703 
23023	404	S2703 
23024	404	S2703 
23025	404	S2703 
23027	404	S2703 
23028	404	S2703 
23029	404	S2703 
23030	404	S2703 
23031	404	S2703 
23032	404	S2703 
23033	404	S2703 
23034	404	S2703 
23035	404	S2703 
23036	404	S2703 
23037	404	S2703 
23038	404	S2703 
23039	404	S2703 
23040	404	S2703 
23041	404	S2703 
23042	404	S2703 
23043	404	S2703 
23044	404	S2703 
23045	404	S2703 
23046	404	S2703 
23047	404	S2703 
23048	404	S2703 
23049	404	S2703 
23050	404	S2703 
23051	404	S2703 
23052	404	S2703 
23053	404	S2703 
23054	404	S2703 
23055	404	S2703 
23056	404	S2703 
23057	404	S2703 
23058	404	S2703 
23059	404	S2703 
23060	404	S2703 
23061	404	S2703 
23062	404	S2703 
23063	404	S2703 
23064	404	S2703 
23065	404	S2703 
23557	404	S14   
23558	404	S14   
23559	404	S14   
23560	404	S14   
23561	404	S14   
23562	404	S14   
23563	404	S14   
23564	404	S14   
23565	404	S14   
23566	404	S14   
23567	404	S14   
23568	404	S14   
23569	404	S14   
23570	404	S14   
23571	404	S14   
23572	404	S14   
23573	404	S14   
23574	404	S14   
23575	404	S14   
23576	404	S14   
23577	404	S14   
23578	404	S14   
23579	404	S14   
23580	404	S14   
23581	404	S14   
23582	404	S2    
23583	404	S2    
23584	404	S2    
23585	404	S2    
23586	404	S2    
23587	404	S2    
23588	404	S2    
23589	404	S2    
23590	404	S2    
23591	404	S2    
23592	404	S2    
23593	404	S2    
23594	404	S2    
23595	404	S2    
23596	404	S2    
23597	404	S2    
23598	404	S2    
23599	404	S2    
23600	404	S2    
23601	404	S2    
23602	404	S2    
23603	404	S2    
23604	404	S2    
23605	404	S2    
23606	404	S2    
23607	404	S2    
23608	404	S2    
23609	404	S2    
23610	404	S2    
23611	404	S2    
23612	404	S2    
23613	404	S2    
23614	404	S2    
23615	404	S2    
23616	404	S2    
23617	404	S2    
23618	404	S2    
23619	404	S2    
23620	404	S2    
23621	404	S2    
23622	404	S2    
23623	404	S2    
23624	404	S2    
23625	404	S2    
23626	404	S2    
23627	404	S2    
23628	404	S2    
23629	404	S2    
23630	404	S2    
23631	404	S2    
23632	404	S2    
23633	404	S2    
23634	404	S2    
23635	404	S2    
23636	404	S2    
23637	404	S2    
23638	404	S2    
23640	404	S1581 
23646	404	S2    
23647	404	S2    
23648	404	S2    
23649	404	S2    
23650	404	S2    
23651	404	S2    
23652	404	S2    
23653	404	S2    
23654	404	S2    
23655	404	S2    
23656	404	S2    
23657	404	S2    
23658	404	S2    
23659	404	S2    
23660	404	S2    
35001	404	D4961 
35002	404	D4961 
35003	404	D4961 
35004	404	D4961 
35008	404	D4961 
35014	404	D4961 
35016	404	D4961 
35017	404	D4961 
35021	404	D4961 
35022	404	D4961 
35024	404	D4961 
35025	404	D4961 
35026	404	D4961 
35027	404	D4961 
35028	404	D4961 
35029	404	D4961 
35030	404	D4961 
35034	404	D4961 
35038	404	D4961 
35039	404	D4961 
35040	404	D4961 
35041	404	D4961 
35042	404	D4961 
35043	404	D4961 
35046	404	D4961 
35047	404	D4961 
35048	404	D4961 
35050	404	D4961 
35051	404	D4961 
35054	404	D4961 
35055	404	D4961 
35056	404	D4961 
35057	404	D4961 
35060	404	D4961 
35063	404	D4961 
35064	404	D4961 
35065	404	D4961 
35066	404	D4961 
35067	404	D4961 
35068	404	D4961 
35070	404	D4961 
35071	404	D4961 
35072	404	D4961 
35073	404	D4961 
35074	404	D4961 
35078	404	D4961 
35079	404	D4961 
35080	404	D4961 
35081	404	D4961 
35082	404	D4961 
35083	404	D4961 
35084	404	D4961 
35086	404	D4961 
35087	404	D4961 
35088	404	D4961 
35089	404	D4961 
35090	404	D4961 
35130	404	S2381 
35131	404	S2381 
35132	404	S2381 
35133	404	S2381 
35134	404	S2381 
35135	404	S2381 
35136	404	S2381 
35137	404	S2381 
35138	404	S2381 
35139	404	S2381 
35140	404	S2381 
35141	404	S2381 
35142	404	S2381 
35143	404	S2381 
35144	404	S2381 
35145	404	S2381 
35146	404	S2381 
35147	404	S2381 
35148	404	S2381 
42190	404	S243  
43215	404	S26   
43364	404	S26   
43378	404	S1082 
01026	405	S25   
01029	405	S27   
01032	405	S19   
01040	405	S27   
01046	405	S19   
01077	405	S27   
01079	405	S1063 
01079	405	S20   
01082	405	S1063 
01085	405	S1063 
01103	405	S1163 
01123	405	S1063 
01123	405	S561  
01124	405	S1065 
01125	405	S1065 
01202	405	S1163 
04017	405	S19   
04020	405	S19   
04021	405	S19   
04023	405	S19   
04114	405	S19   
04120	405	S19   
04141	405	S19   
04142	405	S19   
04143	405	S19   
04144	405	S19   
04367	405	S19   
04610	405	S18   
04628	405	S18   
04629	405	S18   
04630	405	S19   
04631	405	S20   
04635	405	S19   
04636	405	S19   
04638	405	S26   
04639	405	S26   
04640	405	S26   
04641	405	S25   
05023	405	S1581 
05024	405	S1581 
05027	405	S1082 
05028	405	S1082 
05173	405	S1581 
05174	405	S1581 
05175	405	S1581 
05176	405	S1581 
05177	405	S1581 
05178	405	S1581 
05312	405	S26   
05313	405	S26   
05320	405	S26   
05661	405	S1082 
06016	405	S18   
06019	405	S18   
06043	405	S18   
06094	405	S18   
06128	405	S18   
06159	405	S18   
06931	405	S22   
06982	405	S18   
06983	405	S18   
06984	405	S2104 
06985	405	S2104 
07002	405	S222  
07005	405	S248  
07007	405	S1164 
07008	405	S238  
07015	405	S248  
07016	405	S248  
07022	405	S21   
07034	405	S249  
07039	405	S244  
07056	405	S248  
07057	405	S235  
07057	405	S238  
07063	405	S1164 
07063	405	S582  
07064	405	S1164 
07070	405	S238  
07075	405	S1164 
07079	405	S227  
07910	405	S245  
07913	405	S238  
07923	405	S245  
07931	405	S222  
07938	405	S233  
07939	405	S235  
07945	405	S21   
07951	405	S243  
07952	405	S1164 
07953	405	S1164 
07953	405	S582  
07954	405	S582  
07955	405	S1164 
07956	405	S1164 
07957	405	S1164 
07958	405	S1164 
07959	405	S1164 
07960	405	S1164 
08001	405	S1065 
08003	405	S2664 
08005	405	S2664 
08010	405	S702  
08011	405	S702  
08012	405	S702  
08013	405	S1065 
08014	405	S1065 
08017	405	S603  
08018	405	S702  
08019	405	S603  
08020	405	S1065 
08023	405	S2664 
08025	405	S2662 
08026	405	S603  
08028	405	S2664 
08030	405	S1065 
08031	405	S2664 
08032	405	S2664 
08035	405	S603  
08045	405	S603  
08047	405	S702  
08048	405	S603  
08049	405	S702  
08050	405	S603  
08054	405	S702  
08057	405	S603  
08058	405	S2664 
08059	405	S702  
08060	405	S2664 
08061	405	S1065 
08064	405	S603  
08065	405	S1065 
08065	405	S2662 
08066	405	S702  
08067	405	S2664 
08068	405	S2664 
08069	405	S2664 
08071	405	S2664 
08074	405	S2662 
08077	405	S2421 
08078	405	S603  
08082	405	S603  
08083	405	S2502 
08085	405	S702  
08086	405	S603  
08087	405	S603  
08089	405	S603  
08092	405	S702  
08094	405	S702  
08116	405	S2502 
08124	405	S702  
08128	405	S702  
08130	405	S702  
08138	405	S2502 
08139	405	S603  
08146	405	S702  
08147	405	S1065 
08147	405	S2422 
08177	405	S2502 
08189	405	S2664 
08190	405	S603  
08194	405	S603  
08200	405	S702  
08202	405	S603  
08206	405	S2502 
08210	405	S702  
08211	405	S702  
08212	405	S702  
08214	405	S702  
08215	405	S702  
08216	405	S702  
08217	405	S2664 
08218	405	S1065 
08219	405	S702  
08220	405	S702  
08221	405	S702  
08225	405	S702  
08229	405	S702  
08231	405	S702  
08232	405	S702  
08243	405	S603  
08244	405	S603  
08245	405	S603  
08246	405	S603  
08247	405	S603  
08253	405	S2664 
08258	405	S2664 
08259	405	S2662 
08261	405	S603  
08262	405	S603  
08263	405	S603  
08266	405	S603  
08267	405	S603  
08268	405	S603  
08269	405	S603  
08270	405	S603  
08271	405	S603  
08272	405	S603  
08273	405	S603  
08274	405	S603  
08277	405	S603  
08278	405	S603  
08283	405	S2664 
08284	405	S2664 
08286	405	S2664 
08287	405	S2664 
08288	405	S2664 
08289	405	S2664 
08293	405	S702  
08294	405	S702  
08299	405	S702  
08309	405	S2664 
08315	405	S702  
08316	405	S702  
08317	405	S702  
08318	405	S2664 
08319	405	S2664 
08345	405	S603  
08346	405	S2502 
08347	405	S2502 
08348	405	S2502 
08349	405	S2502 
08350	405	S2502 
08351	405	S702  
08352	405	S702  
08353	405	S702  
08354	405	S702  
08355	405	S702  
08357	405	S702  
08358	405	S702  
08359	405	S702  
08360	405	S702  
08361	405	S702  
08362	405	S702  
08363	405	S702  
08364	405	S702  
08366	405	S702  
08367	405	S603  
08368	405	S603  
08370	405	S603  
08371	405	S603  
08372	405	S603  
08374	405	S2664 
08376	405	S2664 
08380	405	S2664 
08383	405	S2664 
08384	405	S2664 
08385	405	S2664 
08386	405	S2664 
08388	405	S2664 
08389	405	S682  
08390	405	S682  
08391	405	S682  
08392	405	S682  
08394	405	S702  
08395	405	S702  
08396	405	S702  
08397	405	S603  
08398	405	S603  
08399	405	S603  
08400	405	S881  
08401	405	S881  
08402	405	S702  
08403	405	S1209 
08408	405	S2502 
08409	405	S2502 
08410	405	S702  
08411	405	S702  
08412	405	S702  
08413	405	S702  
08414	405	S702  
08415	405	S702  
08416	405	S702  
08417	405	S702  
08418	405	S702  
08419	405	S702  
08420	405	S702  
08421	405	S702  
08422	405	S702  
08435	405	S1065 
08436	405	S702  
08444	405	S702  
08446	405	S702  
08448	405	S702  
08449	405	S702  
08450	405	S702  
08454	405	S2664 
08455	405	S2664 
08456	405	S2664 
08457	405	S2664 
08458	405	S2664 
08459	405	S2664 
08460	405	S2664 
08465	405	S2664 
08466	405	S2664 
08468	405	S2664 
08469	405	S2664 
08470	405	S2664 
08471	405	S2664 
08472	405	S2664 
08473	405	S2664 
08474	405	S2664 
08476	405	S2502 
08478	405	S2502 
08481	405	S2502 
08482	405	S2502 
08483	405	S2502 
08484	405	S2502 
08487	405	S2502 
08488	405	S2502 
08489	405	S2502 
08490	405	S2502 
08491	405	S2502 
08492	405	S2502 
08493	405	S2502 
08494	405	S2502 
08495	405	S2502 
08497	405	S2502 
08498	405	S2502 
08500	405	S2502 
08501	405	S2502 
08504	405	S2662 
08505	405	S2662 
08506	405	S2662 
08507	405	S2662 
08508	405	S2662 
08509	405	S2662 
09003	405	S502  
09003	405	S561  
09004	405	S502  
09032	405	S21   
09037	405	S1031 
09037	405	S381  
09037	405	S481  
09037	405	S502  
09038	405	S1031 
09038	405	S481  
09038	405	S502  
09039	405	S381  
09040	405	S1023 
09040	405	S481  
09040	405	S562  
09042	405	S461  
09042	405	S566  
09050	405	S1141 
09050	405	S421  
09050	405	S441  
09060	405	S381  
09062	405	S381  
09062	405	S404  
09070	405	S53   
09070	405	S582  
09078	405	S561  
09079	405	S1701 
09087	405	S1032 
09087	405	S564  
09087	405	S582  
09094	405	S363  
09094	405	S582  
09112	405	S482  
09112	405	S563  
09132	405	S1062 
09139	405	S381  
09148	405	S1033 
09148	405	S363  
09148	405	S582  
09149	405	S381  
09160	405	S1065 
09181	405	S1121 
09183	405	S381  
09184	405	S562  
09184	405	S565  
09191	405	S421  
09191	405	S582  
09195	405	S1202 
09202	405	S482  
09202	405	S564  
09218	405	S1065 
09218	405	S1161 
09236	405	S461  
09236	405	S582  
09252	405	S482  
09252	405	S541  
09266	405	S1167 
09266	405	S441  
09266	405	S561  
09273	405	S2104 
09273	405	S2985 
09279	405	S421  
09279	405	S582  
09291	405	S564  
09291	405	S566  
09298	405	S564  
09298	405	S566  
09302	405	S381  
09302	405	S461  
09302	405	S566  
09302	405	S963  
09316	405	S421  
09316	405	S566  
09316	405	S581  
09326	405	S1027 
09326	405	S441  
09326	405	S461  
09328	405	S1206 
09409	405	S2104 
09409	405	S2985 
09421	405	S564  
09421	405	S582  
09422	405	S1202 
09429	405	S1167 
09429	405	S441  
09430	405	S441  
09430	405	S561  
09431	405	S2203 
09432	405	S2203 
09433	405	S2105 
09433	405	S2961 
10007	405	S1082 
10066	405	S1082 
10067	405	S1082 
10068	405	S1082 
10098	405	S1581 
10099	405	S1581 
10102	405	S1581 
10119	405	S1581 
10123	405	S1082 
10124	405	S1082 
10173	405	S1581 
10858	405	S1082 
10860	405	S1082 
10861	405	S1082 
10862	405	S1082 
10863	405	S1581 
10864	405	S1082 
11011	405	S1069 
11012	405	S1069 
11090	405	S1121 
11090	405	S564  
11090	405	S619  
11091	405	S1121 
11091	405	S564  
11096	405	S1121 
11096	405	S482  
11097	405	S482  
11112	405	S1065 
11113	405	S1065 
11124	405	S1062 
11124	405	S618  
11125	405	S1062 
11130	405	S25   
11131	405	S25   
11143	405	S1121 
11143	405	S564  
11157	405	S1202 
11205	405	S1062 
11206	405	S1062 
11243	405	S2941 
11250	405	S562  
11250	405	S565  
11251	405	S481  
11251	405	S503  
11251	405	S620  
11252	405	S481  
11252	405	S562  
11252	405	S624  
11253	405	S541  
11253	405	S565  
11257	405	S541  
11257	405	S565  
11260	405	S2941 
11260	405	S78   
11260	405	S80   
11263	405	S2941 
11267	405	S2941 
11282	405	S1062 
11286	405	S1062 
11294	405	S563  
11294	405	S582  
11333	405	S1062 
11333	405	S611  
11339	405	S1062 
11352	405	S563  
11352	405	S566  
11353	405	S563  
11353	405	S566  
11354	405	S563  
11354	405	S566  
11355	405	S563  
11355	405	S566  
11356	405	S563  
11356	405	S566  
11357	405	S563  
11357	405	S566  
11358	405	S563  
11358	405	S566  
11359	405	S2105 
11360	405	S2105 
11394	405	S2105 
11395	405	S2105 
11398	405	S2105 
11399	405	S2105 
11402	405	S2105 
11403	405	S2105 
11411	405	S2105 
11412	405	S2105 
11429	405	S1121 
11429	405	S363  
11429	405	S617  
11463	405	S25   
11464	405	S25   
11507	405	S1062 
11508	405	S1062 
11510	405	S1062 
11529	405	S441  
11529	405	S503  
11529	405	S608  
11530	405	S441  
11531	405	S27   
11546	405	S21   
11547	405	S21   
11549	405	S21   
11674	405	S563  
11674	405	S566  
11705	405	S1069 
11742	405	S1121 
11742	405	S564  
11752	405	S1065 
11757	405	S1062 
11760	405	S25   
11821	405	S1062 
11828	405	S563  
11828	405	S566  
11841	405	S2105 
11842	405	S2105 
11856	405	S25   
11875	405	S1062 
11876	405	S1062 
11884	405	S441  
11887	405	S21   
11888	405	S21   
11921	405	S1062 
11935	405	S22   
11949	405	S22   
11960	405	S481  
11960	405	S562  
11987	405	S1202 
11987	405	S2941 
11990	405	S1202 
11991	405	S1202 
11992	405	S2941 
12061	405	S141  
12062	405	S141  
12063	405	S141  
12065	405	S141  
12078	405	S1063 
12078	405	S503  
12086	405	S343  
12086	405	S363  
12086	405	S502  
12087	405	S343  
12120	405	S83   
12121	405	S83   
12122	405	S83   
12131	405	S77   
12132	405	S77   
12142	405	S85   
12143	405	S85   
12144	405	S85   
12147	405	S502  
12151	405	S86   
12152	405	S86   
12154	405	S941  
12155	405	S79   
12201	405	S1164 
12220	405	S1221 
12220	405	S2109 
12563	405	S141  
12565	405	S141  
12586	405	S343  
12586	405	S363  
12586	405	S502  
12632	405	S77   
12643	405	S85   
12644	405	S85   
12652	405	S86   
13019	405	S2    
13020	405	S2    
13055	405	S2    
13065	405	S2    
13067	405	S2    
13068	405	S2    
13070	405	S2    
13096	405	S2    
13098	405	S2    
13165	405	S2    
13318	405	S1581 
13320	405	S1581 
13321	405	S1581 
13322	405	S1581 
13323	405	S1581 
13324	405	S1581 
13325	405	S1082 
13326	405	S1082 
13327	405	S1082 
13340	405	S1581 
13341	405	S1581 
13343	405	S2    
13369	405	S2    
13370	405	S2    
13373	405	S2    
13375	405	S2    
13377	405	S2    
13378	405	S2    
13391	405	S2    
13394	405	S2    
13398	405	S2    
13399	405	S2    
13401	405	S2    
13402	405	S2    
13404	405	S2    
13405	405	S2    
13407	405	S2    
13408	405	S2    
13410	405	S2    
13411	405	S2    
13413	405	S2    
13414	405	S2    
13415	405	S2    
13416	405	S2    
13417	405	S2    
13418	405	S2    
13419	405	S2    
13420	405	S2    
13421	405	S2    
13422	405	S2    
13423	405	S2    
13424	405	S2    
13425	405	S2    
13426	405	S2    
13439	405	S2    
13440	405	S2    
13441	405	S2    
13442	405	S2    
13443	405	S2    
13444	405	S2    
13445	405	S2    
13446	405	S2    
13447	405	S2    
13448	405	S2    
13449	405	S2    
13450	405	S2    
13451	405	S2    
13452	405	S2    
13453	405	S2    
13454	405	S2    
13455	405	S2    
13456	405	S2    
13485	405	S2    
13486	405	S2    
13487	405	S2    
13488	405	S2    
13490	405	S2    
13491	405	S2    
13492	405	S2    
13493	405	S2    
13494	405	S14   
13495	405	S14   
13496	405	S14   
13497	405	S14   
13498	405	S14   
13565	405	S2703 
13566	405	S2703 
13567	405	S2703 
13568	405	S2703 
13569	405	S2703 
13805	405	S2    
13806	405	S2    
13809	405	S2    
13810	405	S2    
13811	405	S2    
13812	405	S2    
13813	405	S2    
13814	405	S2    
13850	405	S2    
13851	405	S2    
13853	405	S2    
13854	405	S2    
13856	405	S2    
13857	405	S2    
13868	405	S2    
13869	405	S2    
13870	405	S2    
13871	405	S2    
13872	405	S2    
13873	405	S2    
13874	405	S2    
13875	405	S2    
13876	405	S2    
13877	405	S2    
13878	405	S2    
13879	405	S2    
13880	405	S2    
13881	405	S2    
13882	405	S2    
13891	405	S2    
13893	405	S2    
13894	405	S2    
13896	405	S2    
13898	405	S2    
13900	405	S2    
13909	405	S2    
13910	405	S2    
13911	405	S2    
13912	405	S2    
13913	405	S2    
13914	405	S2    
13917	405	S2    
13918	405	S2    
13920	405	S2    
13921	405	S2    
13923	405	S2    
13924	405	S2    
13929	405	S2    
13930	405	S2    
13931	405	S2    
13932	405	S2    
13934	405	S2    
13935	405	S2    
13948	405	S2    
13949	405	S2    
13950	405	S2    
13951	405	S2    
13952	405	S2    
13953	405	S2    
13954	405	S2    
13955	405	S2    
13956	405	S2    
13957	405	S2    
13958	405	S2    
13959	405	S2    
13968	405	S2    
13969	405	S2    
13970	405	S2    
13971	405	S2    
13985	405	S2    
13988	405	S2703 
13989	405	S2703 
13990	405	S2703 
13991	405	S2703 
13992	405	S2703 
13994	405	S2703 
13995	405	S2703 
13996	405	S2703 
13997	405	S2703 
13998	405	S2703 
14003	405	S2103 
14006	405	S2103 
14084	405	S2103 
14096	405	S2103 
14106	405	S2103 
14154	405	S2702 
14156	405	S2702 
14209	405	S1064 
14209	405	S1066 
14209	405	S1122 
14209	405	S23   
14238	405	S2104 
14242	405	S2104 
14323	405	S1067 
14347	405	S1064 
14347	405	S1122 
14366	405	S2104 
14370	405	S2104 
14382	405	S1164 
14450	405	S1164 
14461	405	S1164 
14601	405	S1066 
14602	405	S2103 
15027	405	S1163 
15073	405	S1163 
15087	405	S2109 
15152	405	S2104 
15232	405	S1163 
15260	405	S2109 
15261	405	S1163 
15262	405	S1163 
16006	405	S1164 
16010	405	S1164 
16011	405	S1164 
16029	405	S1164 
16037	405	S1164 
16037	405	S2202 
16038	405	S1164 
16038	405	S2202 
16042	405	S1065 
16042	405	S2202 
16043	405	S1065 
16043	405	S2202 
16089	405	S563  
16112	405	S39   
16114	405	S39   
16120	405	S39   
16123	405	S39   
16126	405	S39   
16139	405	S39   
16147	405	S2104 
16159	405	D342  
16159	405	S39   
16174	405	S18   
16338	405	S1164 
16338	405	S2202 
16343	405	S1065 
16343	405	S2202 
17202	405	S1082 
17203	405	S1082 
17204	405	S1082 
17218	405	S1581 
17219	405	S1581 
17332	405	S3    
17335	405	S3    
17340	405	S3    
17341	405	S3    
17345	405	S3    
17346	405	S3    
17347	405	S3    
17348	405	S3    
18001	405	S1162 
18002	405	S1162 
18069	405	S20   
18079	405	S25   
18159	405	S21   
18166	405	S25   
18168	405	S25   
18215	405	S25   
18228	405	S23   
18231	405	S25   
18258	405	S1162 
18259	405	S1162 
18262	405	S1162 
18263	405	S1162 
18288	405	S27   
18350	405	S21   
18363	405	S22   
18364	405	S22   
18365	405	S27   
18376	405	S25   
18403	405	S27   
18927	405	S25   
18930	405	S2203 
18931	405	S2203 
18932	405	S27   
18933	405	S27   
18934	405	S27   
18935	405	S27   
18936	405	S27   
19003	405	S26   
19034	405	S26   
19035	405	S26   
19047	405	S1162 
19056	405	S26   
19057	405	S2109 
19058	405	S2109 
19064	405	S1164 
19076	405	S1164 
19078	405	S1069 
19109	405	S1164 
19120	405	S1069 
19155	405	S1164 
19230	405	S1063 
19350	405	S1164 
19411	405	S26   
20046	405	S20   
20047	405	S20   
20048	405	S20   
20049	405	S20   
20099	405	S1163 
20099	405	S20   
20100	405	S1163 
20100	405	S20   
20109	405	S2105 
20110	405	S2105 
20120	405	S1163 
20120	405	S20   
20121	405	S1163 
20121	405	S20   
20132	405	S1202 
20310	405	S2105 
20321	405	S1163 
20321	405	S20   
20446	405	S20   
20447	405	S20   
20623	405	S1742 
20624	405	S1742 
20628	405	S1742 
20629	405	S1742 
20630	405	S1742 
20634	405	S1742 
20635	405	S1742 
20636	405	S1742 
20640	405	S1742 
20641	405	S1742 
20645	405	S1742 
20646	405	S1742 
21138	405	S1064 
21138	405	S1066 
21138	405	S1122 
21141	405	S1064 
21224	405	S19   
21225	405	S19   
21226	405	S22   
21227	405	S22   
21229	405	S1122 
21238	405	S2801 
21239	405	S1066 
21240	405	S1066 
21241	405	S1066 
21242	405	S1066 
21243	405	S1066 
21244	405	S1066 
21245	405	S1066 
21246	405	S1066 
21247	405	S1066 
21248	405	S1066 
21249	405	S1064 
21250	405	S1064 
21251	405	S1064 
21252	405	S1064 
21253	405	S1064 
21254	405	S1064 
21255	405	S1064 
21256	405	S1064 
21257	405	S1064 
21259	405	S1064 
21260	405	S1082 
21261	405	S1082 
21262	405	S1082 
21263	405	S1082 
21264	405	S1082 
21265	405	S1082 
21266	405	S1082 
21267	405	S1082 
21268	405	S1082 
21269	405	S1082 
21270	405	S1082 
21271	405	S2108 
21272	405	S2108 
21273	405	S2108 
21274	405	S2108 
21275	405	S2108 
21276	405	S2108 
21277	405	S2110 
21278	405	S2110 
21279	405	S2110 
21280	405	S2110 
21281	405	S2110 
21282	405	S2110 
21283	405	S2111 
21284	405	S2111 
21285	405	S2111 
21286	405	S2111 
21287	405	S2112 
21288	405	S2112 
21289	405	S2112 
21290	405	S2112 
21291	405	S2112 
21292	405	S2112 
21293	405	S2782 
21294	405	S2782 
21295	405	S2782 
21296	405	S2782 
21297	405	S2782 
21298	405	S2782 
21299	405	S2110 
21299	405	S2111 
21299	405	S2112 
21299	405	S2782 
21300	405	S2110 
21300	405	S2112 
21300	405	S2782 
21301	405	S2110 
21301	405	S2111 
21301	405	S2112 
21301	405	S2782 
21302	405	S2110 
21302	405	S2111 
21302	405	S2112 
21302	405	S2782 
21303	405	S2110 
21303	405	S2112 
21303	405	S2782 
21304	405	S2110 
21304	405	S2111 
21304	405	S2112 
21304	405	S2782 
21308	405	S2801 
21309	405	S2801 
21310	405	S2801 
21311	405	S2801 
21312	405	S2801 
21313	405	S2801 
21314	405	S2801 
21315	405	S2801 
21316	405	S2801 
21317	405	S2801 
21318	405	S2801 
21319	405	S2801 
21320	405	S2801 
21321	405	S2801 
21322	405	S2801 
21323	405	S2801 
21324	405	S2801 
21325	405	S2801 
21326	405	S2801 
21337	405	S2801 
21343	405	S2801 
21346	405	S2801 
21347	405	S2801 
21348	405	S2801 
21349	405	S2801 
22247	405	S20   
22903	405	S21   
22904	405	S18   
22909	405	S22   
22911	405	S18   
22912	405	S19   
22914	405	S19   
22915	405	S19   
22916	405	S19   
23009	405	S2703 
23010	405	S2703 
23011	405	S2703 
23012	405	S2703 
23013	405	S2703 
23014	405	S2703 
23015	405	S2703 
23016	405	S2703 
23017	405	S2703 
23018	405	S2703 
23019	405	S2703 
23020	405	S2703 
23021	405	S2703 
23022	405	S2703 
23023	405	S2703 
23024	405	S2703 
23025	405	S2703 
23027	405	S2703 
23028	405	S2703 
23029	405	S2703 
23030	405	S2703 
23031	405	S2703 
23032	405	S2703 
23033	405	S2703 
23034	405	S2703 
23035	405	S2703 
23036	405	S2703 
23037	405	S2703 
23038	405	S2703 
23039	405	S2703 
23040	405	S2703 
23041	405	S2703 
23042	405	S2703 
23043	405	S2703 
23044	405	S2703 
23045	405	S2703 
23046	405	S2703 
23047	405	S2703 
23048	405	S2703 
23049	405	S2703 
23050	405	S2703 
23051	405	S2703 
23052	405	S2703 
23053	405	S2703 
23054	405	S2703 
23055	405	S2703 
23056	405	S2703 
23057	405	S2703 
23058	405	S2703 
23059	405	S2703 
23060	405	S2703 
23061	405	S2703 
23062	405	S2703 
23063	405	S2703 
23064	405	S2703 
23065	405	S2703 
23557	405	S14   
23558	405	S14   
23559	405	S14   
23560	405	S14   
23561	405	S14   
23562	405	S14   
23563	405	S14   
23564	405	S14   
23565	405	S14   
23566	405	S14   
23567	405	S14   
23568	405	S14   
23569	405	S14   
23570	405	S14   
23571	405	S14   
23572	405	S14   
23573	405	S14   
23574	405	S14   
23575	405	S14   
23576	405	S14   
23577	405	S14   
23578	405	S14   
23579	405	S14   
23580	405	S14   
23581	405	S14   
23582	405	S2    
23583	405	S2    
23584	405	S2    
23585	405	S2    
23586	405	S2    
23587	405	S2    
23588	405	S2    
23589	405	S2    
23590	405	S2    
23591	405	S2    
23592	405	S2    
23593	405	S2    
23594	405	S2    
23595	405	S2    
23596	405	S2    
23597	405	S2    
23598	405	S2    
23599	405	S2    
23600	405	S2    
23601	405	S2    
23602	405	S2    
23603	405	S2    
23604	405	S2    
23605	405	S2    
23606	405	S2    
23607	405	S2    
23608	405	S2    
23609	405	S2    
23610	405	S2    
23611	405	S2    
23612	405	S2    
23613	405	S2    
23614	405	S2    
23615	405	S2    
23616	405	S2    
23617	405	S2    
23618	405	S2    
23619	405	S2    
23620	405	S2    
23621	405	S2    
23622	405	S2    
23623	405	S2    
23624	405	S2    
23625	405	S2    
23626	405	S2    
23627	405	S2    
23628	405	S2    
23629	405	S2    
23630	405	S2    
23631	405	S2    
23632	405	S2    
23633	405	S2    
23634	405	S2    
23635	405	S2    
23636	405	S2    
23637	405	S2    
23638	405	S2    
23640	405	S1581 
23646	405	S2    
23647	405	S2    
23648	405	S2    
23649	405	S2    
23650	405	S2    
23651	405	S2    
23652	405	S2    
23653	405	S2    
23654	405	S2    
23655	405	S2    
23656	405	S2    
23657	405	S2    
23658	405	S2    
23659	405	S2    
23660	405	S2    
35001	405	D4961 
35002	405	D4961 
35003	405	D4961 
35004	405	D4961 
35008	405	D4961 
35014	405	D4961 
35016	405	D4961 
35017	405	D4961 
35022	405	D4961 
35024	405	D4961 
35026	405	D4961 
35027	405	D4961 
35028	405	D4961 
35029	405	D4961 
35030	405	D4961 
35034	405	D4961 
35038	405	D4961 
35039	405	D4961 
35040	405	D4961 
35041	405	D4961 
35043	405	D4961 
35046	405	D4961 
35048	405	D4961 
35050	405	D4961 
35051	405	D4961 
35054	405	D4961 
35055	405	D4961 
35056	405	D4961 
35057	405	D4961 
35058	405	D4961 
35060	405	D4961 
35064	405	D4961 
35065	405	D4961 
35066	405	D4961 
35067	405	D4961 
35068	405	D4961 
35070	405	D4961 
35071	405	D4961 
35073	405	D4961 
35074	405	D4961 
35078	405	D4961 
35079	405	D4961 
35080	405	D4961 
35081	405	D4961 
35082	405	D4961 
35083	405	D4961 
35084	405	D4961 
35086	405	D4961 
35087	405	D4961 
35088	405	D4961 
35089	405	D4961 
35130	405	S2381 
35131	405	S2381 
35132	405	S2381 
35133	405	S2381 
35134	405	S2381 
35135	405	S2381 
35136	405	S2381 
35137	405	S2381 
35138	405	S2381 
35139	405	S2381 
35140	405	S2381 
35141	405	S2381 
35142	405	S2381 
35143	405	S2381 
35144	405	S2381 
35145	405	S2381 
35146	405	S2381 
35147	405	S2381 
35148	405	S2381 
42190	405	S243  
43215	405	S26   
43364	405	S26   
43378	405	S1082 
01026	406	S25   
01032	406	S19   
01046	406	S19   
01077	406	S27   
01079	406	S1063 
01079	406	S20   
01082	406	S1063 
01085	406	S1063 
01103	406	S1163 
01123	406	S1063 
01124	406	S1065 
01125	406	S1065 
01202	406	S1163 
04017	406	S19   
04020	406	S19   
04021	406	S19   
04023	406	S19   
04114	406	S19   
04120	406	S19   
04141	406	S19   
04142	406	S19   
04143	406	S19   
04144	406	S19   
04367	406	S19   
04610	406	S18   
04628	406	S18   
04630	406	S19   
04631	406	S20   
04635	406	S19   
04636	406	S19   
04638	406	S26   
04639	406	S26   
04640	406	S26   
04641	406	S25   
05023	406	S1581 
05024	406	S1581 
05027	406	S1082 
05028	406	S1082 
05173	406	S1581 
05174	406	S1581 
05175	406	S1581 
05176	406	S1581 
05177	406	S1581 
05178	406	S1581 
05312	406	S26   
05313	406	S26   
05320	406	S26   
05661	406	S1082 
06016	406	S18   
06019	406	S18   
06043	406	S18   
06094	406	S18   
06128	406	S18   
06159	406	S18   
06164	406	S23   
06931	406	S22   
06982	406	S18   
06983	406	S18   
06984	406	S2104 
06985	406	S2104 
07002	406	S222  
07005	406	S248  
07007	406	S1164 
07008	406	S238  
07015	406	S248  
07016	406	S248  
07022	406	S21   
07028	406	S230  
07034	406	S249  
07039	406	S244  
07043	406	S230  
07056	406	S248  
07057	406	S235  
07057	406	S238  
07063	406	S1164 
07063	406	S582  
07064	406	S1164 
07070	406	S238  
07075	406	S1164 
07079	406	S227  
07241	406	S21   
07910	406	S245  
07913	406	S238  
07923	406	S245  
07931	406	S222  
07938	406	S233  
07939	406	S235  
07945	406	S21   
07951	406	S243  
07952	406	S1164 
07953	406	S1164 
07953	406	S582  
07954	406	S582  
07955	406	S1164 
07956	406	S1164 
07957	406	S1164 
07958	406	S1164 
07959	406	S1164 
07960	406	S1164 
08001	406	S1065 
08003	406	S2664 
08005	406	S2664 
08010	406	S702  
08011	406	S702  
08012	406	S1065 
08013	406	S1065 
08014	406	S2664 
08017	406	S603  
08018	406	S702  
08019	406	S603  
08020	406	S1065 
08023	406	S2664 
08025	406	S2662 
08026	406	S603  
08028	406	S2664 
08030	406	S1065 
08031	406	S2664 
08032	406	S2664 
08035	406	S603  
08045	406	S603  
08047	406	S702  
08048	406	S603  
08049	406	S702  
08050	406	S603  
08054	406	S702  
08057	406	S603  
08058	406	S2664 
08059	406	S702  
08060	406	S2664 
08061	406	S1065 
08064	406	S603  
08065	406	S1065 
08065	406	S2662 
08066	406	S702  
08067	406	S2664 
08068	406	S2664 
08069	406	S2664 
08071	406	S2664 
08074	406	S2662 
08077	406	S2421 
08078	406	S603  
08082	406	S603  
08083	406	S2502 
08085	406	S702  
08086	406	S603  
08087	406	S603  
08089	406	S603  
08092	406	S702  
08094	406	S702  
08116	406	S2502 
08124	406	S702  
08128	406	S702  
08130	406	S702  
08138	406	S2502 
08139	406	S603  
08146	406	S702  
08147	406	S1065 
08147	406	S2422 
08177	406	S2502 
08189	406	S2664 
08190	406	S603  
08194	406	S603  
08200	406	S702  
08202	406	S603  
08206	406	S2502 
08210	406	S702  
08211	406	S702  
08212	406	S702  
08214	406	S702  
08215	406	S702  
08216	406	S702  
08217	406	S2664 
08218	406	S1065 
08219	406	S702  
08220	406	S702  
08221	406	S702  
08225	406	S702  
08229	406	S702  
08231	406	S702  
08232	406	S702  
08243	406	S603  
08244	406	S603  
08245	406	S603  
08246	406	S603  
08247	406	S603  
08253	406	S2664 
08258	406	S2664 
08259	406	S2662 
08261	406	S603  
08262	406	S603  
08263	406	S603  
08266	406	S603  
08267	406	S603  
08268	406	S603  
08269	406	S603  
08270	406	S603  
08271	406	S603  
08272	406	S603  
08273	406	S603  
08274	406	S603  
08278	406	S603  
08283	406	S2664 
08284	406	S2664 
08286	406	S2664 
08287	406	S2664 
08288	406	S2664 
08289	406	S2664 
08293	406	S702  
08294	406	S702  
08299	406	S702  
08309	406	S2664 
08315	406	S702  
08316	406	S702  
08317	406	S702  
08318	406	S2664 
08319	406	S2664 
08345	406	S603  
08346	406	S2502 
08347	406	S2502 
08348	406	S2502 
08349	406	S2502 
08350	406	S2502 
08351	406	S702  
08352	406	S702  
08353	406	S702  
08354	406	S702  
08355	406	S702  
08357	406	S702  
08358	406	S702  
08359	406	S702  
08360	406	S702  
08361	406	S702  
08362	406	S702  
08363	406	S702  
08364	406	S702  
08366	406	S702  
08367	406	S603  
08368	406	S603  
08370	406	S603  
08371	406	S603  
08372	406	S603  
08374	406	S2664 
08376	406	S2664 
08380	406	S2664 
08383	406	S2664 
08384	406	S2664 
08385	406	S2664 
08386	406	S2664 
08388	406	S682  
08389	406	S2664 
08390	406	S682  
08391	406	S682  
08392	406	S682  
08394	406	S702  
08395	406	S702  
08396	406	S702  
08397	406	S603  
08398	406	S603  
08399	406	S603  
08400	406	S881  
08401	406	S881  
08402	406	S702  
08403	406	S1209 
08408	406	S2502 
08409	406	S2502 
08410	406	S702  
08411	406	S702  
08412	406	S702  
08413	406	S702  
08414	406	S702  
08415	406	S702  
08416	406	S702  
08417	406	S702  
08418	406	S702  
08419	406	S702  
08420	406	S702  
08421	406	S702  
08422	406	S702  
08435	406	S1065 
08436	406	S702  
08444	406	S702  
08446	406	S702  
08448	406	S702  
08449	406	S702  
08450	406	S702  
08454	406	S2664 
08455	406	S2664 
08456	406	S2664 
08457	406	S2664 
08458	406	S2664 
08459	406	S2664 
08460	406	S2664 
08465	406	S2664 
08466	406	S2664 
08468	406	S2664 
08469	406	S2664 
08470	406	S2664 
08471	406	S2664 
08472	406	S2664 
08473	406	S2664 
08474	406	S2664 
08476	406	S2502 
08478	406	S2502 
08481	406	S2502 
08482	406	S2502 
08483	406	S2502 
08484	406	S2502 
08487	406	S2502 
08488	406	S2502 
08489	406	S2502 
08490	406	S2502 
08491	406	S2502 
08492	406	S2502 
08493	406	S2502 
08494	406	S2502 
08495	406	S2502 
08497	406	S2502 
08498	406	S2502 
08500	406	S2502 
08501	406	S2502 
08504	406	S2662 
08505	406	S2662 
08506	406	S2662 
08507	406	S2662 
08508	406	S2662 
08509	406	S2662 
09003	406	S1183 
09003	406	S561  
09032	406	S21   
09037	406	S1031 
09037	406	S381  
09037	406	S481  
09037	406	S502  
09038	406	S1031 
09038	406	S481  
09038	406	S502  
09039	406	S381  
09040	406	S1023 
09040	406	S481  
09040	406	S562  
09042	406	S461  
09042	406	S566  
09050	406	S1141 
09050	406	S421  
09050	406	S441  
09060	406	S381  
09062	406	S381  
09062	406	S404  
09070	406	S53   
09070	406	S582  
09078	406	S561  
09079	406	S1701 
09087	406	S1032 
09087	406	S564  
09087	406	S582  
09094	406	S363  
09094	406	S582  
09112	406	S482  
09112	406	S563  
09132	406	S1062 
09139	406	S381  
09148	406	S1033 
09148	406	S363  
09148	406	S582  
09149	406	S381  
09160	406	S1065 
09181	406	S1024 
09181	406	S1121 
09181	406	S461  
09183	406	S381  
09184	406	S1026 
09184	406	S562  
09184	406	S565  
09191	406	S421  
09191	406	S582  
09195	406	S1202 
09202	406	S482  
09202	406	S564  
09218	406	S1065 
09218	406	S1161 
09236	406	S461  
09236	406	S582  
09252	406	S482  
09252	406	S541  
09266	406	S1167 
09266	406	S441  
09266	406	S561  
09273	406	S2104 
09273	406	S2985 
09279	406	S421  
09279	406	S582  
09291	406	S564  
09291	406	S566  
09298	406	S564  
09298	406	S566  
09302	406	S381  
09302	406	S461  
09302	406	S566  
09302	406	S963  
09316	406	S421  
09316	406	S566  
09316	406	S581  
09326	406	S1027 
09326	406	S441  
09326	406	S461  
09328	406	S1206 
09409	406	S2104 
09409	406	S2985 
09421	406	S564  
09421	406	S582  
09422	406	S1202 
09429	406	S1167 
09429	406	S441  
09430	406	S441  
09430	406	S561  
09431	406	S2203 
09432	406	S2203 
09433	406	S2105 
09433	406	S2961 
10007	406	S1082 
10066	406	S1082 
10067	406	S1082 
10068	406	S1082 
10098	406	S1581 
10099	406	S1581 
10102	406	S1581 
10119	406	S1581 
10123	406	S1082 
10124	406	S1082 
10173	406	S1581 
10858	406	S1082 
10860	406	S1082 
10861	406	S1082 
10862	406	S1082 
10863	406	S1581 
10864	406	S1082 
11011	406	S1069 
11012	406	S1069 
11090	406	S1121 
11090	406	S564  
11090	406	S619  
11091	406	S1121 
11091	406	S564  
11096	406	S1121 
11096	406	S482  
11097	406	S482  
11112	406	S1065 
11113	406	S1065 
11124	406	S1062 
11124	406	S618  
11125	406	S1062 
11130	406	S25   
11131	406	S25   
11143	406	S1121 
11143	406	S564  
11157	406	S1202 
11205	406	S1062 
11206	406	S1062 
11243	406	S2941 
11250	406	S562  
11250	406	S565  
11251	406	S481  
11251	406	S503  
11251	406	S620  
11252	406	S481  
11252	406	S562  
11252	406	S624  
11253	406	S541  
11253	406	S565  
11257	406	S541  
11257	406	S565  
11260	406	S2941 
11260	406	S78   
11260	406	S80   
11263	406	S2941 
11267	406	S2941 
11282	406	S1062 
11286	406	S1062 
11294	406	S563  
11294	406	S582  
11333	406	S1062 
11333	406	S611  
11339	406	S1062 
11352	406	S563  
11352	406	S566  
11353	406	S563  
11353	406	S566  
11354	406	S563  
11354	406	S566  
11355	406	S563  
11355	406	S566  
11356	406	S563  
11356	406	S566  
11357	406	S563  
11357	406	S566  
11358	406	S563  
11358	406	S566  
11359	406	S2105 
11360	406	S2105 
11394	406	S2105 
11395	406	S2105 
11398	406	S2105 
11399	406	S2105 
11402	406	S2105 
11403	406	S2105 
11411	406	S2105 
11412	406	S2105 
11429	406	S1121 
11429	406	S363  
11429	406	S617  
11463	406	S25   
11464	406	S25   
11507	406	S1062 
11508	406	S1062 
11510	406	S1062 
11529	406	S441  
11529	406	S503  
11529	406	S608  
11530	406	S441  
11546	406	S21   
11547	406	S21   
11549	406	S21   
11674	406	S563  
11674	406	S566  
11705	406	S1069 
11742	406	S1121 
11742	406	S564  
11752	406	S1065 
11757	406	S1062 
11760	406	S25   
11821	406	S1062 
11828	406	S563  
11828	406	S566  
11841	406	S2105 
11842	406	S2105 
11856	406	S25   
11875	406	S1062 
11876	406	S1062 
11884	406	S441  
11887	406	S21   
11888	406	S21   
11921	406	S1062 
11935	406	S22   
11949	406	S22   
11950	406	S2941 
11960	406	S481  
11960	406	S562  
11987	406	S1202 
11987	406	S2941 
11990	406	S1202 
11991	406	S1202 
11992	406	S2941 
12061	406	S141  
12062	406	S141  
12063	406	S141  
12065	406	S141  
12078	406	S1063 
12078	406	S503  
12086	406	S343  
12086	406	S363  
12086	406	S502  
12087	406	S343  
12120	406	S83   
12121	406	S83   
12122	406	S83   
12131	406	S77   
12132	406	S77   
12142	406	S85   
12143	406	S85   
12144	406	S85   
12147	406	S502  
12147	406	S564  
12151	406	S86   
12152	406	S86   
12154	406	S941  
12155	406	S481  
12155	406	S563  
12201	406	S1164 
12220	406	S1221 
12220	406	S2109 
12563	406	S141  
12565	406	S141  
12586	406	S343  
12586	406	S363  
12586	406	S502  
12632	406	S77   
12643	406	S85   
12644	406	S85   
12652	406	S86   
13019	406	S2    
13020	406	S2    
13055	406	S2    
13065	406	S2    
13067	406	S2    
13068	406	S2    
13070	406	S2    
13096	406	S2    
13098	406	S2    
13165	406	S2    
13318	406	S1581 
13320	406	S1581 
13321	406	S1581 
13322	406	S1581 
13323	406	S1581 
13324	406	S1581 
13325	406	S1082 
13326	406	S1082 
13327	406	S1082 
13340	406	S1581 
13341	406	S1581 
13343	406	S2    
13355	406	S230  
13369	406	S2    
13370	406	S2    
13373	406	S2    
13375	406	S2    
13377	406	S2    
13378	406	S2    
13391	406	S2    
13394	406	S2    
13398	406	S2    
13399	406	S2    
13401	406	S2    
13402	406	S2    
13404	406	S2    
13405	406	S2    
13407	406	S2    
13408	406	S2    
13410	406	S2    
13411	406	S2    
13413	406	S2    
13414	406	S2    
13415	406	S2    
13416	406	S2    
13417	406	S2    
13418	406	S2    
13419	406	S2    
13420	406	S2    
13421	406	S2    
13422	406	S2    
13423	406	S2    
13424	406	S2    
13425	406	S2    
13426	406	S2    
13439	406	S2    
13440	406	S2    
13441	406	S2    
13442	406	S2    
13443	406	S2    
13444	406	S2    
13445	406	S2    
13446	406	S2    
13447	406	S2    
13448	406	S2    
13449	406	S2    
13450	406	S2    
13451	406	S2    
13452	406	S2    
13453	406	S2    
13454	406	S2    
13455	406	S2    
13456	406	S2    
13485	406	S2    
13486	406	S2    
13487	406	S2    
13488	406	S2    
13490	406	S2    
13491	406	S2    
13492	406	S2    
13493	406	S2    
13494	406	S14   
13495	406	S14   
13496	406	S14   
13497	406	S14   
13498	406	S14   
13565	406	S2703 
13566	406	S2703 
13567	406	S2703 
13568	406	S2703 
13569	406	S2703 
13805	406	S2    
13806	406	S2    
13809	406	S2    
13810	406	S2    
13811	406	S2    
13812	406	S2    
13813	406	S2    
13814	406	S2    
13850	406	S2    
13851	406	S2    
13853	406	S2    
13854	406	S2    
13856	406	S2    
13857	406	S2    
13868	406	S2    
13869	406	S2    
13870	406	S2    
13871	406	S2    
13872	406	S2    
13873	406	S2    
13874	406	S2    
13875	406	S2    
13876	406	S2    
13877	406	S2    
13878	406	S2    
13879	406	S2    
13880	406	S2    
13881	406	S2    
13882	406	S2    
13891	406	S2    
13893	406	S2    
13894	406	S2    
13896	406	S2    
13898	406	S2    
13900	406	S2    
13909	406	S2    
13910	406	S2    
13911	406	S2    
13912	406	S2    
13913	406	S2    
13914	406	S2    
13917	406	S2    
13918	406	S2    
13920	406	S2    
13921	406	S2    
13923	406	S2    
13924	406	S2    
13929	406	S2    
13930	406	S2    
13931	406	S2    
13932	406	S2    
13934	406	S2    
13935	406	S2    
13948	406	S2    
13949	406	S2    
13950	406	S2    
13951	406	S2    
13952	406	S2    
13953	406	S2    
13954	406	S2    
13955	406	S2    
13956	406	S2    
13957	406	S2    
13958	406	S2    
13959	406	S2    
13968	406	S2    
13969	406	S2    
13970	406	S2    
13971	406	S2    
13985	406	S2    
13988	406	S2703 
13989	406	S2703 
13990	406	S2703 
13991	406	S2703 
13992	406	S2703 
13994	406	S2703 
13995	406	S2703 
13996	406	S2703 
13997	406	S2703 
13998	406	S2703 
14003	406	S2103 
14006	406	S2103 
14084	406	S2103 
14096	406	S2103 
14106	406	S2103 
14154	406	S2702 
14156	406	S2702 
14209	406	S1064 
14209	406	S1066 
14209	406	S1122 
14209	406	S23   
14238	406	S2104 
14242	406	S2104 
14323	406	S1067 
14347	406	S1064 
14347	406	S1122 
14366	406	S2104 
14370	406	S2104 
14382	406	S1164 
14450	406	S1164 
14460	406	S1164 
14461	406	S1164 
14462	406	S2109 
14601	406	S1066 
14602	406	S2103 
15027	406	S1163 
15073	406	S1163 
15087	406	S2109 
15152	406	S2104 
15232	406	S1163 
15260	406	S2109 
15261	406	S1163 
15262	406	S1163 
16006	406	S1164 
16010	406	S1164 
16011	406	S1164 
16029	406	S1164 
16037	406	S1164 
16037	406	S2202 
16038	406	S1164 
16038	406	S2202 
16042	406	S1065 
16042	406	S2202 
16043	406	S1065 
16043	406	S2202 
16089	406	S563  
16112	406	S39   
16114	406	S39   
16120	406	S39   
16123	406	S39   
16126	406	S39   
16139	406	S39   
16147	406	S2104 
16159	406	D342  
16159	406	S39   
16167	406	S2203 
16174	406	S18   
16338	406	S1164 
16338	406	S2202 
16343	406	S1065 
16343	406	S2202 
17202	406	S1082 
17203	406	S1082 
17204	406	S1082 
17218	406	S1581 
17219	406	S1581 
17332	406	S3    
17335	406	S3    
17340	406	S3    
17341	406	S3    
17345	406	S3    
17346	406	S3    
17347	406	S3    
17348	406	S3    
18001	406	S1162 
18002	406	S1162 
18069	406	S20   
18079	406	S25   
18159	406	S21   
18166	406	S25   
18168	406	S25   
18215	406	S25   
18231	406	S25   
18258	406	S1162 
18259	406	S1162 
18262	406	S1162 
18263	406	S1162 
18288	406	S27   
18350	406	S21   
18365	406	S27   
18376	406	S25   
18403	406	S27   
18927	406	S25   
18932	406	S27   
18933	406	S27   
18934	406	S27   
18935	406	S27   
18936	406	S27   
19003	406	S26   
19034	406	S26   
19035	406	S26   
19047	406	S1162 
19056	406	S26   
19057	406	S2109 
19058	406	S2109 
19064	406	S1164 
19076	406	S1164 
19078	406	S1069 
19109	406	S1164 
19120	406	S1069 
19155	406	S1164 
19230	406	S1063 
19350	406	S1164 
19411	406	S26   
20046	406	S20   
20046	406	S2722 
20046	406	S2921 
20047	406	S20   
20048	406	S20   
20049	406	S20   
20099	406	S1163 
20099	406	S20   
20100	406	S1163 
20100	406	S20   
20109	406	S2105 
20110	406	S2105 
20120	406	S1163 
20120	406	S20   
20121	406	S1163 
20121	406	S20   
20132	406	S1202 
20310	406	S2105 
20321	406	S1163 
20321	406	S20   
20446	406	S20   
20446	406	S2722 
20446	406	S2921 
20447	406	S20   
20623	406	S1742 
20624	406	S1742 
20628	406	S1742 
20629	406	S1742 
20630	406	S1742 
20634	406	S1742 
20635	406	S1742 
20636	406	S1742 
20640	406	S1742 
20641	406	S1742 
20645	406	S1742 
20646	406	S1742 
21138	406	S1064 
21138	406	S1066 
21138	406	S1122 
21141	406	S1064 
21224	406	S19   
21225	406	S19   
21226	406	S22   
21227	406	S22   
21229	406	S1122 
21238	406	S2801 
21239	406	S1066 
21240	406	S1066 
21241	406	S1066 
21242	406	S1066 
21243	406	S1066 
21244	406	S1066 
21245	406	S1066 
21246	406	S1066 
21247	406	S1066 
21248	406	S1066 
21249	406	S1064 
21250	406	S1064 
21251	406	S1064 
21252	406	S1064 
21253	406	S1064 
21254	406	S1064 
21255	406	S1064 
21256	406	S1064 
21257	406	S1064 
21259	406	S1064 
21260	406	S1082 
21261	406	S1082 
21262	406	S1082 
21263	406	S1082 
21264	406	S1082 
21265	406	S1082 
21266	406	S1082 
21267	406	S1082 
21268	406	S1082 
21269	406	S1082 
21270	406	S1082 
21271	406	S2108 
21272	406	S2108 
21273	406	S2108 
21274	406	S2108 
21275	406	S2108 
21276	406	S2108 
21277	406	S2110 
21278	406	S2110 
21279	406	S2110 
21280	406	S2110 
21281	406	S2110 
21282	406	S2110 
21283	406	S2111 
21284	406	S2111 
21285	406	S2111 
21286	406	S2111 
21287	406	S2112 
21288	406	S2112 
21289	406	S2112 
21290	406	S2112 
21291	406	S2112 
21292	406	S2112 
21293	406	S2782 
21294	406	S2782 
21295	406	S2782 
21296	406	S2782 
21297	406	S2782 
21298	406	S2782 
21299	406	S2110 
21299	406	S2111 
21299	406	S2112 
21299	406	S2782 
21300	406	S2110 
21300	406	S2112 
21300	406	S2782 
21301	406	S2110 
21301	406	S2111 
21301	406	S2112 
21301	406	S2782 
21302	406	S2110 
21302	406	S2111 
21302	406	S2112 
21302	406	S2782 
21303	406	S2110 
21303	406	S2112 
21303	406	S2782 
21304	406	S2110 
21304	406	S2111 
21304	406	S2112 
21304	406	S2782 
21308	406	S2801 
21309	406	S2801 
21310	406	S2801 
21311	406	S2801 
21312	406	S2801 
21313	406	S2801 
21314	406	S2801 
21315	406	S2801 
21316	406	S2801 
21317	406	S2801 
21318	406	S2801 
21319	406	S2801 
21320	406	S2801 
21321	406	S2801 
21322	406	S2801 
21323	406	S2801 
21324	406	S2801 
21325	406	S2801 
21326	406	S2801 
21337	406	S2801 
21343	406	S2801 
21346	406	S2801 
21347	406	S2801 
21348	406	S2801 
21349	406	S2801 
22247	406	S20   
22903	406	S21   
22904	406	S18   
22909	406	S22   
22911	406	S18   
22912	406	S19   
22914	406	S19   
22915	406	S19   
22916	406	S19   
23009	406	S2703 
23010	406	S2703 
23011	406	S2703 
23012	406	S2703 
23013	406	S2703 
23014	406	S2703 
23015	406	S2703 
23016	406	S2703 
23017	406	S2703 
23018	406	S2703 
23019	406	S2703 
23020	406	S2703 
23021	406	S2703 
23022	406	S2703 
23023	406	S2703 
23024	406	S2703 
23025	406	S2703 
23027	406	S2703 
23028	406	S2703 
23029	406	S2703 
23030	406	S2703 
23031	406	S2703 
23032	406	S2703 
23033	406	S2703 
23034	406	S2703 
23035	406	S2703 
23036	406	S2703 
23037	406	S2703 
23038	406	S2703 
23039	406	S2703 
23040	406	S2703 
23041	406	S2703 
23042	406	S2703 
23043	406	S2703 
23044	406	S2703 
23045	406	S2703 
23046	406	S2703 
23047	406	S2703 
23048	406	S2703 
23049	406	S2703 
23050	406	S2703 
23051	406	S2703 
23052	406	S2703 
23053	406	S2703 
23054	406	S2703 
23055	406	S2703 
23056	406	S2703 
23057	406	S2703 
23058	406	S2703 
23059	406	S2703 
23060	406	S2703 
23061	406	S2703 
23062	406	S2703 
23063	406	S2703 
23064	406	S2703 
23065	406	S2703 
23557	406	S14   
23558	406	S14   
23559	406	S14   
23560	406	S14   
23561	406	S14   
23562	406	S14   
23563	406	S14   
23564	406	S14   
23565	406	S14   
23566	406	S14   
23567	406	S14   
23568	406	S14   
23569	406	S14   
23570	406	S14   
23571	406	S14   
23572	406	S14   
23573	406	S14   
23574	406	S14   
23575	406	S14   
23576	406	S14   
23577	406	S14   
23578	406	S14   
23579	406	S14   
23580	406	S14   
23581	406	S14   
23582	406	S2    
23583	406	S2    
23584	406	S2    
23585	406	S2    
23586	406	S2    
23587	406	S2    
23588	406	S2    
23589	406	S2    
23590	406	S2    
23591	406	S2    
23592	406	S2    
23593	406	S2    
23594	406	S2    
23595	406	S2    
23596	406	S2    
23597	406	S2    
23598	406	S2    
23599	406	S2    
23600	406	S2    
23601	406	S2    
23602	406	S2    
23603	406	S2    
23604	406	S2    
23605	406	S2    
23606	406	S2    
23607	406	S2    
23608	406	S2    
23609	406	S2    
23610	406	S2    
23611	406	S2    
23612	406	S2    
23613	406	S2    
23614	406	S2    
23615	406	S2    
23616	406	S2    
23617	406	S2    
23618	406	S2    
23619	406	S2    
23620	406	S2    
23621	406	S2    
23622	406	S2    
23623	406	S2    
23624	406	S2    
23625	406	S2    
23626	406	S2    
23627	406	S2    
23628	406	S2    
23629	406	S2    
23630	406	S2    
23631	406	S2    
23632	406	S2    
23633	406	S2    
23634	406	S2    
23635	406	S2    
23636	406	S2    
23637	406	S2    
23638	406	S2    
23640	406	S1581 
23646	406	S2    
23647	406	S2    
23648	406	S2    
23649	406	S2    
23650	406	S2    
23651	406	S2    
23652	406	S2    
23653	406	S2    
23654	406	S2    
23655	406	S2    
23656	406	S2    
23657	406	S2    
23658	406	S2    
23659	406	S2    
23660	406	S2    
35001	406	D4961 
35002	406	D4961 
35003	406	D4961 
35004	406	D4961 
35008	406	D4961 
35014	406	D4961 
35016	406	D4961 
35017	406	D4961 
35021	406	D4961 
35022	406	D4961 
35024	406	D4961 
35026	406	D4961 
35027	406	D4961 
35028	406	D4961 
35029	406	D4961 
35030	406	D4961 
35034	406	D4961 
35038	406	D4961 
35039	406	D4961 
35040	406	D4961 
35041	406	D4961 
35042	406	D4961 
35043	406	D4961 
35047	406	D4961 
35048	406	D4961 
35050	406	D4961 
35051	406	D4961 
35054	406	D4961 
35056	406	D4961 
35057	406	D4961 
35058	406	D4961 
35060	406	D4961 
35063	406	D4961 
35064	406	D4961 
35065	406	D4961 
35066	406	D4961 
35067	406	D4961 
35068	406	D4961 
35070	406	D4961 
35073	406	D4961 
35074	406	D4961 
35078	406	D4961 
35079	406	D4961 
35080	406	D4961 
35081	406	D4961 
35084	406	D4961 
35086	406	D4961 
35087	406	D4961 
35088	406	D4961 
35090	406	D4961 
35093	406	D4961 
35130	406	S2381 
35131	406	S2381 
35132	406	S2381 
35133	406	S2381 
35134	406	S2381 
35135	406	S2381 
35136	406	S2381 
35137	406	S2381 
35138	406	S2381 
35139	406	S2381 
35140	406	S2381 
35141	406	S2381 
35142	406	S2381 
35143	406	S2381 
35144	406	S2381 
35145	406	S2381 
35146	406	S2381 
35147	406	S2381 
35148	406	S2381 
42190	406	S243  
43215	406	S26   
43364	406	S26   
43378	406	S1082 
01026	410	S25   
01032	410	S19   
01046	410	S19   
01077	410	S27   
01079	410	S1063 
01079	410	S20   
01082	410	S1063 
01085	410	S1063 
01103	410	S1163 
01123	410	S1063 
01123	410	S561  
01124	410	S1065 
01125	410	S1065 
01202	410	S1163 
04017	410	S19   
04021	410	S19   
04023	410	S19   
04114	410	S19   
04120	410	S19   
04141	410	S19   
04143	410	S19   
04144	410	S19   
04610	410	S18   
04628	410	S18   
04629	410	S18   
04630	410	S19   
04631	410	S20   
04635	410	S19   
04636	410	S19   
04638	410	S26   
04639	410	S26   
04640	410	S26   
04641	410	S25   
05023	410	S1581 
05024	410	S1581 
05027	410	S1082 
05028	410	S1082 
05173	410	S1581 
05174	410	S1581 
05175	410	S1581 
05176	410	S1581 
05177	410	S1581 
05178	410	S1581 
05312	410	S26   
05313	410	S26   
05320	410	S26   
05661	410	S1082 
06016	410	S18   
06019	410	S18   
06043	410	S18   
06094	410	S18   
06128	410	S18   
06159	410	S18   
06164	410	S23   
06931	410	S22   
06982	410	S18   
06983	410	S18   
06984	410	S2104 
06985	410	S2104 
07002	410	S222  
07005	410	S248  
07007	410	S1164 
07008	410	S238  
07015	410	S248  
07016	410	S248  
07022	410	S21   
07039	410	S244  
07056	410	S248  
07057	410	S238  
07063	410	S1164 
07063	410	S582  
07064	410	S1164 
07070	410	S238  
07075	410	S1164 
07241	410	S21   
07910	410	S245  
07913	410	S238  
07923	410	S245  
07931	410	S222  
07938	410	S233  
07939	410	S235  
07945	410	S21   
07952	410	S1164 
07953	410	S1164 
07953	410	S582  
07954	410	S582  
07955	410	S1164 
07956	410	S1164 
07957	410	S1164 
07958	410	S1164 
07959	410	S1164 
07960	410	S1164 
08001	410	S1065 
08010	410	S702  
08011	410	S702  
08012	410	S702  
08013	410	S1065 
08014	410	S1065 
08018	410	S702  
08020	410	S1065 
08025	410	S2662 
08028	410	S2664 
08030	410	S1065 
08047	410	S702  
08049	410	S702  
08054	410	S702  
08058	410	S2664 
08059	410	S702  
08061	410	S1065 
08065	410	S1065 
08065	410	S2662 
08066	410	S702  
08074	410	S2662 
08077	410	S2421 
08085	410	S702  
08087	410	S603  
08092	410	S702  
08094	410	S702  
08124	410	S702  
08128	410	S702  
08130	410	S702  
08146	410	S702  
08147	410	S1065 
08147	410	S2422 
08200	410	S702  
08210	410	S702  
08211	410	S702  
08212	410	S702  
08214	410	S702  
08215	410	S702  
08216	410	S702  
08218	410	S1065 
08219	410	S702  
08220	410	S702  
08221	410	S702  
08225	410	S702  
08229	410	S702  
08231	410	S702  
08232	410	S702  
08246	410	S603  
08247	410	S603  
08258	410	S2664 
08259	410	S2662 
08286	410	S2664 
08293	410	S702  
08294	410	S702  
08299	410	S702  
08315	410	S702  
08316	410	S702  
08317	410	S702  
08318	410	S2664 
08351	410	S702  
08352	410	S702  
08353	410	S702  
08354	410	S702  
08355	410	S702  
08357	410	S702  
08358	410	S702  
08359	410	S702  
08360	410	S702  
08361	410	S702  
08362	410	S702  
08363	410	S702  
08364	410	S702  
08366	410	S702  
08385	410	S2664 
08394	410	S702  
08395	410	S702  
08396	410	S702  
08399	410	S603  
08400	410	S881  
08401	410	S881  
08402	410	S702  
08410	410	S702  
08411	410	S702  
08412	410	S702  
08413	410	S702  
08414	410	S702  
08415	410	S702  
08416	410	S702  
08417	410	S702  
08418	410	S702  
08419	410	S702  
08420	410	S702  
08421	410	S702  
08422	410	S702  
08435	410	S1065 
08436	410	S702  
08444	410	S702  
08446	410	S702  
08448	410	S702  
08449	410	S702  
08450	410	S702  
08504	410	S2662 
08505	410	S2662 
08506	410	S2662 
08507	410	S2662 
08508	410	S2662 
08509	410	S2662 
09003	410	S1183 
09003	410	S502  
09003	410	S561  
09004	410	S502  
09032	410	S21   
09037	410	S1031 
09037	410	S381  
09037	410	S481  
09037	410	S502  
09038	410	S1031 
09038	410	S481  
09038	410	S502  
09039	410	S381  
09040	410	S1023 
09040	410	S481  
09040	410	S562  
09042	410	S461  
09042	410	S566  
09050	410	S1141 
09050	410	S421  
09050	410	S441  
09060	410	S381  
09062	410	S381  
09062	410	S404  
09070	410	S53   
09070	410	S582  
09078	410	S561  
09087	410	S1032 
09087	410	S564  
09087	410	S582  
09094	410	S363  
09094	410	S582  
09112	410	S482  
09112	410	S563  
09132	410	S1062 
09139	410	S381  
09148	410	S1033 
09148	410	S363  
09148	410	S582  
09149	410	S381  
09160	410	S1065 
09181	410	S1024 
09181	410	S1121 
09181	410	S461  
09183	410	S381  
09184	410	S562  
09184	410	S565  
09191	410	S421  
09191	410	S582  
09195	410	S1202 
09202	410	S482  
09202	410	S564  
09218	410	S1065 
09218	410	S1161 
09236	410	S461  
09236	410	S582  
09252	410	S482  
09252	410	S541  
09266	410	S1167 
09266	410	S441  
09266	410	S561  
09273	410	S2104 
09279	410	S421  
09279	410	S582  
09291	410	S564  
09291	410	S566  
09298	410	S564  
09298	410	S566  
09302	410	S381  
09302	410	S461  
09302	410	S566  
09302	410	S963  
09316	410	S421  
09316	410	S566  
09316	410	S581  
09326	410	S1027 
09326	410	S441  
09326	410	S461  
09328	410	S1206 
09409	410	S2104 
09421	410	S564  
09421	410	S582  
09422	410	S1202 
09429	410	S1167 
09429	410	S441  
09430	410	S441  
09430	410	S561  
09431	410	S2203 
09432	410	S2203 
09433	410	S2105 
09433	410	S2961 
10007	410	S1082 
10066	410	S1082 
10067	410	S1082 
10068	410	S1082 
10098	410	S1581 
10099	410	S1581 
10102	410	S1581 
10119	410	S1581 
10123	410	S1082 
10124	410	S1082 
10173	410	S1581 
10858	410	S1082 
10860	410	S1082 
10861	410	S1082 
10862	410	S1082 
10863	410	S1581 
10864	410	S1082 
11011	410	S1069 
11012	410	S1069 
11090	410	S1121 
11090	410	S564  
11090	410	S619  
11091	410	S1121 
11091	410	S564  
11096	410	S1121 
11096	410	S482  
11097	410	S482  
11112	410	S1065 
11113	410	S1065 
11124	410	S1062 
11124	410	S618  
11125	410	S1062 
11130	410	S25   
11131	410	S25   
11143	410	S1121 
11143	410	S564  
11157	410	S1202 
11205	410	S1062 
11206	410	S1062 
11243	410	S2941 
11250	410	S562  
11250	410	S565  
11251	410	S481  
11251	410	S503  
11251	410	S620  
11252	410	S481  
11252	410	S562  
11252	410	S624  
11253	410	S541  
11253	410	S565  
11257	410	S541  
11257	410	S565  
11260	410	S2941 
11260	410	S78   
11260	410	S80   
11263	410	S2941 
11267	410	S2941 
11282	410	S1062 
11286	410	S1062 
11294	410	S563  
11294	410	S582  
11333	410	S1062 
11333	410	S611  
11339	410	S1062 
11352	410	S563  
11352	410	S566  
11353	410	S563  
11353	410	S566  
11354	410	S563  
11354	410	S566  
11355	410	S563  
11355	410	S566  
11356	410	S563  
11356	410	S566  
11357	410	S563  
11357	410	S566  
11358	410	S563  
11358	410	S566  
11359	410	S2105 
11360	410	S2105 
11394	410	S2105 
11395	410	S2105 
11398	410	S2105 
11399	410	S2105 
11402	410	S2105 
11403	410	S2105 
11411	410	S2105 
11412	410	S2105 
11429	410	S1121 
11429	410	S363  
11429	410	S617  
11463	410	S25   
11464	410	S25   
11507	410	S1062 
11508	410	S1062 
11510	410	S1062 
11529	410	S441  
11529	410	S503  
11529	410	S608  
11530	410	S441  
11546	410	S21   
11674	410	S563  
11674	410	S566  
11705	410	S1069 
11742	410	S1121 
11742	410	S564  
11752	410	S1065 
11757	410	S1062 
11760	410	S25   
11821	410	S1062 
11828	410	S563  
11828	410	S566  
11841	410	S2105 
11842	410	S2105 
11856	410	S25   
11875	410	S1062 
11876	410	S1062 
11884	410	S441  
11887	410	S21   
11921	410	S1062 
11935	410	S22   
11949	410	S22   
11960	410	S481  
11960	410	S562  
11987	410	S1202 
11987	410	S2941 
11990	410	S1202 
11991	410	S1202 
11992	410	S2941 
12061	410	S141  
12062	410	S141  
12063	410	S141  
12065	410	S141  
12078	410	S1063 
12078	410	S503  
12086	410	S363  
12086	410	S502  
12120	410	S83   
12121	410	S83   
12122	410	S83   
12131	410	S77   
12132	410	S77   
12142	410	S85   
12143	410	S85   
12144	410	S85   
12147	410	S502  
12147	410	S564  
12151	410	S86   
12152	410	S86   
12154	410	S941  
12155	410	S79   
12201	410	S1164 
12220	410	S1221 
12220	410	S2109 
12563	410	S141  
12565	410	S141  
12586	410	S363  
12586	410	S502  
12632	410	S77   
12643	410	S85   
12644	410	S85   
12652	410	S86   
13019	410	S2    
13020	410	S2    
13055	410	S2    
13065	410	S2    
13067	410	S2    
13068	410	S2    
13070	410	S2    
13096	410	S2    
13098	410	S2    
13165	410	S2    
13318	410	S1581 
13320	410	S1581 
13321	410	S1581 
13322	410	S1581 
13323	410	S1581 
13324	410	S1581 
13325	410	S1082 
13326	410	S1082 
13327	410	S1082 
13340	410	S1581 
13341	410	S1581 
13343	410	S2    
13369	410	S2    
13370	410	S2    
13373	410	S2    
13375	410	S2    
13377	410	S2    
13378	410	S2    
13391	410	S2    
13394	410	S2    
13398	410	S2    
13399	410	S2    
13401	410	S2    
13402	410	S2    
13404	410	S2    
13405	410	S2    
13407	410	S2    
13408	410	S2    
13410	410	S2    
13411	410	S2    
13413	410	S2    
13414	410	S2    
13415	410	S2    
13416	410	S2    
13417	410	S2    
13418	410	S2    
13419	410	S2    
13420	410	S2    
13421	410	S2    
13422	410	S2    
13423	410	S2    
13424	410	S2    
13425	410	S2    
13426	410	S2    
13439	410	S2    
13440	410	S2    
13441	410	S2    
13442	410	S2    
13443	410	S2    
13444	410	S2    
13445	410	S2    
13446	410	S2    
13447	410	S2    
13448	410	S2    
13449	410	S2    
13450	410	S2    
13451	410	S2    
13452	410	S2    
13453	410	S2    
13454	410	S2    
13455	410	S2    
13456	410	S2    
13485	410	S2    
13486	410	S2    
13487	410	S2    
13488	410	S2    
13490	410	S2    
13491	410	S2    
13492	410	S2    
13493	410	S2    
13494	410	S14   
13495	410	S14   
13497	410	S14   
13498	410	S14   
13565	410	S2703 
13566	410	S2703 
13567	410	S2703 
13568	410	S2703 
13569	410	S2703 
13805	410	S2    
13806	410	S2    
13809	410	S2    
13810	410	S2    
13811	410	S2    
13812	410	S2    
13813	410	S2    
13814	410	S2    
13850	410	S2    
13851	410	S2    
13853	410	S2    
13854	410	S2    
13856	410	S2    
13857	410	S2    
13868	410	S2    
13869	410	S2    
13870	410	S2    
13871	410	S2    
13872	410	S2    
13873	410	S2    
13874	410	S2    
13875	410	S2    
13876	410	S2    
13877	410	S2    
13878	410	S2    
13879	410	S2    
13880	410	S2    
13881	410	S2    
13882	410	S2    
13891	410	S2    
13893	410	S2    
13894	410	S2    
13896	410	S2    
13898	410	S2    
13900	410	S2    
13909	410	S2    
13910	410	S2    
13911	410	S2    
13912	410	S2    
13913	410	S2    
13914	410	S2    
13917	410	S2    
13918	410	S2    
13920	410	S2    
13921	410	S2    
13923	410	S2    
13924	410	S2    
13929	410	S2    
13930	410	S2    
13931	410	S2    
13932	410	S2    
13934	410	S2    
13935	410	S2    
13948	410	S2    
13949	410	S2    
13950	410	S2    
13951	410	S2    
13952	410	S2    
13953	410	S2    
13954	410	S2    
13955	410	S2    
13956	410	S2    
13957	410	S2    
13958	410	S2    
13959	410	S2    
13968	410	S2    
13969	410	S2    
13970	410	S2    
13971	410	S2    
13985	410	S2    
13988	410	S2703 
13989	410	S2703 
13990	410	S2703 
13991	410	S2703 
13992	410	S2703 
13994	410	S2703 
13995	410	S2703 
13996	410	S2703 
13997	410	S2703 
13998	410	S2703 
14003	410	S2103 
14006	410	S2103 
14084	410	S2103 
14096	410	S2103 
14106	410	S2103 
14154	410	S2702 
14156	410	S2702 
14209	410	S1064 
14209	410	S1066 
14209	410	S1122 
14209	410	S23   
14238	410	S2104 
14242	410	S2104 
14347	410	S1064 
14347	410	S1122 
14366	410	S2104 
14370	410	S2104 
14382	410	S1164 
14450	410	S1164 
14460	410	S1164 
14461	410	S1164 
14462	410	S2109 
14601	410	S1066 
14602	410	S2103 
15027	410	S1163 
15073	410	S1163 
15087	410	S2109 
15152	410	S2104 
15232	410	S1163 
15260	410	S2109 
15261	410	S1163 
15262	410	S1163 
16006	410	S1164 
16010	410	S1164 
16011	410	S1164 
16029	410	S1164 
16037	410	S1164 
16037	410	S2202 
16038	410	S1164 
16038	410	S2202 
16042	410	S1065 
16042	410	S2202 
16043	410	S1065 
16043	410	S2202 
16089	410	S563  
16097	410	S22   
16098	410	S22   
16112	410	S39   
16114	410	S39   
16120	410	S39   
16123	410	S39   
16126	410	S39   
16139	410	S39   
16147	410	S2104 
16159	410	D342  
16159	410	S39   
16167	410	S2203 
16174	410	S18   
16338	410	S1164 
16338	410	S2202 
16343	410	S1065 
16343	410	S2202 
16397	410	S22   
16398	410	S22   
17202	410	S1082 
17203	410	S1082 
17204	410	S1082 
17218	410	S1581 
17219	410	S1581 
18001	410	S1162 
18002	410	S1162 
18069	410	S20   
18079	410	S25   
18159	410	S21   
18166	410	S25   
18168	410	S25   
18215	410	S25   
18228	410	S23   
18231	410	S25   
18258	410	S1162 
18259	410	S1162 
18262	410	S1162 
18263	410	S1162 
18288	410	S27   
18350	410	S21   
18363	410	S22   
18364	410	S22   
18365	410	S27   
18376	410	S25   
18403	410	S27   
18927	410	S25   
18930	410	S2203 
18931	410	S2203 
18932	410	S27   
18933	410	S27   
18934	410	S27   
18935	410	S27   
18936	410	S27   
19003	410	S26   
19034	410	S26   
19035	410	S26   
19047	410	S1162 
19056	410	S26   
19057	410	S2109 
19058	410	S2109 
19064	410	S1164 
19076	410	S1164 
19078	410	S1069 
19109	410	S1164 
19120	410	S1069 
19155	410	S1164 
19230	410	S1063 
19350	410	S1164 
19411	410	S26   
20047	410	S20   
20049	410	S20   
20109	410	S2105 
20110	410	S2105 
20132	410	S1202 
20310	410	S2105 
20409	410	S2105 
20410	410	S2105 
20447	410	S20   
20510	410	S2105 
20623	410	S1742 
20624	410	S1742 
20628	410	S1742 
20629	410	S1742 
20630	410	S1742 
20634	410	S1742 
20635	410	S1742 
20636	410	S1742 
20640	410	S1742 
20641	410	S1742 
20645	410	S1742 
20646	410	S1742 
21138	410	S1064 
21138	410	S1066 
21138	410	S1122 
21141	410	S1064 
21224	410	S19   
21225	410	S19   
21226	410	S22   
21227	410	S22   
21229	410	S1122 
21238	410	S2801 
21239	410	S1066 
21240	410	S1066 
21241	410	S1066 
21242	410	S1066 
21243	410	S1066 
21244	410	S1066 
21246	410	S1066 
21247	410	S1066 
21248	410	S1066 
21249	410	S1064 
21250	410	S1064 
21251	410	S1064 
21252	410	S1064 
21253	410	S1064 
21254	410	S1064 
21255	410	S1064 
21256	410	S1064 
21257	410	S1064 
21259	410	S1064 
21260	410	S1082 
21261	410	S1082 
21262	410	S1082 
21263	410	S1082 
21264	410	S1082 
21265	410	S1082 
21266	410	S1082 
21267	410	S1082 
21268	410	S1082 
21269	410	S1082 
21270	410	S1082 
21271	410	S2108 
21272	410	S2108 
21273	410	S2108 
21274	410	S2108 
21275	410	S2108 
21276	410	S2108 
21277	410	S2110 
21278	410	S2110 
21279	410	S2110 
21280	410	S2110 
21281	410	S2110 
21282	410	S2110 
21283	410	S2111 
21284	410	S2111 
21285	410	S2111 
21286	410	S2111 
21287	410	S2112 
21288	410	S2112 
21289	410	S2112 
21290	410	S2112 
21291	410	S2112 
21292	410	S2112 
21293	410	S2782 
21294	410	S2782 
21295	410	S2782 
21296	410	S2782 
21297	410	S2782 
21298	410	S2782 
21299	410	S2110 
21299	410	S2111 
21299	410	S2112 
21299	410	S2782 
21300	410	S2110 
21300	410	S2112 
21300	410	S2782 
21301	410	S2110 
21301	410	S2111 
21301	410	S2112 
21301	410	S2782 
21302	410	S2110 
21302	410	S2111 
21302	410	S2112 
21302	410	S2782 
21303	410	S2110 
21303	410	S2112 
21303	410	S2782 
21304	410	S2110 
21304	410	S2111 
21304	410	S2112 
21304	410	S2782 
21308	410	S2801 
21309	410	S2801 
21310	410	S2801 
21311	410	S2801 
21312	410	S2801 
21313	410	S2801 
21314	410	S2801 
21315	410	S2801 
21316	410	S2801 
21317	410	S2801 
21318	410	S2801 
21319	410	S2801 
21320	410	S2801 
21321	410	S2801 
21322	410	S2801 
21323	410	S2801 
21324	410	S2801 
21325	410	S2801 
21326	410	S2801 
21337	410	S2801 
21343	410	S2801 
21346	410	S2801 
21347	410	S2801 
21348	410	S2801 
21349	410	S2801 
22247	410	S20   
22903	410	S21   
22904	410	S18   
22909	410	S22   
22911	410	S18   
22915	410	S19   
22916	410	S19   
23009	410	S2703 
23010	410	S2703 
23011	410	S2703 
23012	410	S2703 
23013	410	S2703 
23014	410	S2703 
23015	410	S2703 
23016	410	S2703 
23017	410	S2703 
23018	410	S2703 
23019	410	S2703 
23020	410	S2703 
23021	410	S2703 
23022	410	S2703 
23023	410	S2703 
23024	410	S2703 
23025	410	S2703 
23027	410	S2703 
23028	410	S2703 
23029	410	S2703 
23030	410	S2703 
23031	410	S2703 
23032	410	S2703 
23033	410	S2703 
23034	410	S2703 
23035	410	S2703 
23036	410	S2703 
23037	410	S2703 
23038	410	S2703 
23039	410	S2703 
23040	410	S2703 
23041	410	S2703 
23042	410	S2703 
23043	410	S2703 
23044	410	S2703 
23045	410	S2703 
23046	410	S2703 
23047	410	S2703 
23048	410	S2703 
23049	410	S2703 
23050	410	S2703 
23051	410	S2703 
23052	410	S2703 
23053	410	S2703 
23054	410	S2703 
23055	410	S2703 
23056	410	S2703 
23057	410	S2703 
23058	410	S2703 
23059	410	S2703 
23060	410	S2703 
23061	410	S2703 
23062	410	S2703 
23063	410	S2703 
23064	410	S2703 
23065	410	S2703 
23557	410	S14   
23558	410	S14   
23560	410	S14   
23561	410	S14   
23562	410	S14   
23563	410	S14   
23565	410	S14   
23566	410	S14   
23567	410	S14   
23568	410	S14   
23570	410	S14   
23571	410	S14   
23572	410	S14   
23573	410	S14   
23575	410	S14   
23576	410	S14   
23577	410	S14   
23578	410	S14   
23580	410	S14   
23581	410	S14   
23582	410	S2    
23583	410	S2    
23584	410	S2    
23585	410	S2    
23586	410	S2    
23587	410	S2    
23588	410	S2    
23589	410	S2    
23590	410	S2    
23591	410	S2    
23592	410	S2    
23593	410	S2    
23594	410	S2    
23595	410	S2    
23596	410	S2    
23597	410	S2    
23598	410	S2    
23599	410	S2    
23600	410	S2    
23601	410	S2    
23602	410	S2    
23603	410	S2    
23604	410	S2    
23605	410	S2    
23606	410	S2    
23607	410	S2    
23608	410	S2    
23609	410	S2    
23610	410	S2    
23611	410	S2    
23612	410	S2    
23613	410	S2    
23614	410	S2    
23615	410	S2    
23616	410	S2    
23617	410	S2    
23618	410	S2    
23619	410	S2    
23620	410	S2    
23621	410	S2    
23622	410	S2    
23623	410	S2    
23624	410	S2    
23625	410	S2    
23626	410	S2    
23627	410	S2    
23628	410	S2    
23629	410	S2    
23630	410	S2    
23631	410	S2    
23632	410	S2    
23633	410	S2    
23634	410	S2    
23635	410	S2    
23636	410	S2    
23637	410	S2    
23638	410	S2    
23640	410	S1581 
23646	410	S2    
23647	410	S2    
23648	410	S2    
23649	410	S2    
23650	410	S2    
23651	410	S2    
23652	410	S2    
23653	410	S2    
23654	410	S2    
23655	410	S2    
23656	410	S2    
23657	410	S2    
23658	410	S2    
23659	410	S2    
23660	410	S2    
35001	410	D4961 
35003	410	D4961 
35012	410	D4961 
35024	410	D4961 
35048	410	D4961 
35051	410	D4961 
35071	410	D4961 
35073	410	D4961 
35078	410	D4961 
35130	410	S2381 
35131	410	S2381 
35132	410	S2381 
35133	410	S2381 
35134	410	S2381 
35135	410	S2381 
35136	410	S2381 
35137	410	S2381 
35138	410	S2381 
35139	410	S2381 
35140	410	S2381 
35141	410	S2381 
35142	410	S2381 
35143	410	S2381 
35144	410	S2381 
35146	410	S2381 
35147	410	S2381 
35148	410	S2381 
43215	410	S26   
43329	410	S25   
43364	410	S26   
43378	410	S1082 
01026	415	S25   
01032	415	S19   
01046	415	S19   
01077	415	S27   
01079	415	S1063 
01079	415	S20   
01082	415	S1063 
01085	415	S1063 
01103	415	S1163 
01123	415	S1063 
01124	415	S1065 
01125	415	S1065 
01202	415	S1163 
02001	415	D4381 
02002	415	D4381 
02003	415	D4381 
02004	415	D4381 
02005	415	D4381 
02006	415	D4381 
02007	415	D4381 
02008	415	D4381 
02009	415	D4381 
02010	415	D4381 
02011	415	D4381 
02012	415	D4381 
02014	415	D4381 
02015	415	D4381 
02016	415	D4381 
02017	415	D4381 
02018	415	D4381 
02019	415	D4381 
02020	415	D4381 
02021	415	D4381 
02022	415	D4381 
02023	415	D4381 
02024	415	D4381 
02025	415	D4381 
02026	415	D4381 
02028	415	D4381 
02031	415	D4381 
02032	415	D4381 
02034	415	D4381 
02035	415	D4381 
02036	415	D4381 
02037	415	D4381 
02038	415	D4381 
02039	415	D4381 
02041	415	D4381 
02042	415	D4381 
04017	415	S19   
04020	415	S19   
04021	415	S19   
04023	415	S19   
04114	415	S19   
04120	415	S19   
04141	415	S19   
04142	415	S19   
04143	415	S19   
04144	415	S19   
04610	415	S18   
04628	415	S18   
04629	415	S18   
04630	415	S19   
04631	415	S20   
04635	415	S19   
04636	415	S19   
04638	415	S26   
04639	415	S26   
04640	415	S26   
04641	415	S25   
05023	415	S1581 
05024	415	S1581 
05027	415	S1082 
05028	415	S1082 
05173	415	S1581 
05174	415	S1581 
05175	415	S1581 
05176	415	S1581 
05177	415	S1581 
05178	415	S1581 
05312	415	S26   
05313	415	S26   
05320	415	S26   
05661	415	S1082 
06016	415	S18   
06019	415	S18   
06043	415	S18   
06094	415	S18   
06128	415	S18   
06159	415	S18   
06164	415	S23   
06931	415	S22   
06982	415	S18   
06983	415	S18   
06984	415	S2104 
06985	415	S2104 
07002	415	S222  
07005	415	S248  
07007	415	S1164 
07008	415	S238  
07015	415	S248  
07016	415	S248  
07022	415	S21   
07039	415	S244  
07056	415	S248  
07057	415	S238  
07063	415	S1164 
07063	415	S582  
07064	415	S1164 
07070	415	S238  
07075	415	S1164 
07241	415	S21   
07910	415	S245  
07913	415	S238  
07923	415	S245  
07931	415	S222  
07938	415	S233  
07939	415	S235  
07945	415	S21   
07952	415	S1164 
07953	415	S1164 
07953	415	S582  
07954	415	S582  
07955	415	S1164 
07956	415	S1164 
07957	415	S1164 
07958	415	S1164 
07959	415	S1164 
07960	415	S1164 
08001	415	S1065 
08003	415	S2664 
08005	415	S2664 
08010	415	S702  
08011	415	S702  
08012	415	S1065 
08013	415	S1065 
08014	415	S1065 
08017	415	S603  
08018	415	S702  
08019	415	S603  
08020	415	S1065 
08023	415	S2664 
08025	415	S2662 
08026	415	S603  
08028	415	S2664 
08030	415	S1065 
08031	415	S2664 
08032	415	S2664 
08035	415	S603  
08045	415	S603  
08047	415	S702  
08048	415	S603  
08049	415	S702  
08050	415	S603  
08054	415	S702  
08057	415	S603  
08058	415	S2664 
08059	415	S702  
08060	415	S2664 
08061	415	S1065 
08064	415	S603  
08065	415	S1065 
08065	415	S2662 
08066	415	S702  
08067	415	S2664 
08068	415	S2664 
08069	415	S2664 
08071	415	S2664 
08074	415	S2662 
08077	415	S2421 
08078	415	S603  
08082	415	S603  
08083	415	S2502 
08085	415	S702  
08086	415	S603  
08087	415	S603  
08089	415	S603  
08092	415	S702  
08094	415	S702  
08116	415	S2502 
08124	415	S702  
08128	415	S702  
08130	415	S702  
08138	415	S2502 
08139	415	S603  
08146	415	S702  
08147	415	S1065 
08147	415	S2422 
08177	415	S2502 
08189	415	S2664 
08190	415	S603  
08194	415	S603  
08200	415	S702  
08202	415	S603  
08206	415	S2502 
08210	415	S702  
08211	415	S702  
08212	415	S702  
08214	415	S702  
08215	415	S702  
08216	415	S702  
08217	415	S2664 
08218	415	S1065 
08219	415	S702  
08220	415	S702  
08221	415	S702  
08225	415	S702  
08229	415	S702  
08231	415	S702  
08232	415	S702  
08243	415	S603  
08244	415	S603  
08245	415	S603  
08246	415	S603  
08247	415	S603  
08253	415	S2664 
08258	415	S2664 
08259	415	S2662 
08261	415	S603  
08262	415	S603  
08263	415	S603  
08266	415	S603  
08267	415	S603  
08268	415	S603  
08269	415	S603  
08270	415	S603  
08271	415	S603  
08272	415	S603  
08273	415	S603  
08274	415	S603  
08278	415	S603  
08283	415	S2664 
08284	415	S2664 
08286	415	S2664 
08287	415	S2664 
08288	415	S2664 
08289	415	S2664 
08293	415	S702  
08294	415	S702  
08299	415	S702  
08309	415	S2664 
08315	415	S702  
08316	415	S702  
08317	415	S702  
08318	415	S2664 
08319	415	S2664 
08345	415	S603  
08346	415	S2502 
08347	415	S2502 
08348	415	S2502 
08349	415	S2502 
08350	415	S2502 
08351	415	S702  
08352	415	S702  
08353	415	S702  
08354	415	S702  
08355	415	S702  
08357	415	S702  
08358	415	S702  
08359	415	S702  
08360	415	S702  
08361	415	S702  
08362	415	S702  
08363	415	S702  
08364	415	S702  
08366	415	S702  
08367	415	S603  
08368	415	S603  
08370	415	S603  
08371	415	S603  
08372	415	S603  
08374	415	S2664 
08376	415	S2664 
08380	415	S2664 
08383	415	S2664 
08384	415	S2664 
08385	415	S2664 
08386	415	S2664 
08387	415	S2664 
08389	415	S682  
08390	415	S682  
08391	415	S682  
08392	415	S682  
08394	415	S702  
08395	415	S702  
08396	415	S702  
08397	415	S603  
08398	415	S603  
08399	415	S603  
08400	415	S881  
08401	415	S881  
08402	415	S702  
08403	415	S1209 
08408	415	S2502 
08409	415	S2502 
08410	415	S702  
08411	415	S702  
08412	415	S702  
08413	415	S702  
08414	415	S702  
08415	415	S702  
08416	415	S702  
08417	415	S702  
08418	415	S702  
08419	415	S702  
08420	415	S702  
08421	415	S702  
08422	415	S702  
08435	415	S1065 
08436	415	S702  
08444	415	S702  
08446	415	S702  
08448	415	S702  
08449	415	S702  
08450	415	S702  
08454	415	S2664 
08455	415	S2664 
08456	415	S2664 
08457	415	S2664 
08458	415	S2664 
08459	415	S2664 
08460	415	S2664 
08465	415	S2664 
08466	415	S2664 
08468	415	S2664 
08469	415	S2664 
08470	415	S2664 
08471	415	S2664 
08472	415	S2664 
08473	415	S2664 
08474	415	S2664 
08476	415	S2502 
08478	415	S2502 
08481	415	S2502 
08482	415	S2502 
08484	415	S2502 
08487	415	S2502 
08488	415	S2502 
08489	415	S2502 
08490	415	S2502 
08491	415	S2502 
08493	415	S2502 
08494	415	S2502 
08495	415	S2502 
08497	415	S2502 
08498	415	S2502 
08500	415	S2502 
08501	415	S2502 
08504	415	S2662 
08505	415	S2662 
08506	415	S2662 
08507	415	S2662 
08508	415	S2662 
08509	415	S2662 
09003	415	S1183 
09003	415	S502  
09003	415	S561  
09004	415	S502  
09032	415	S21   
09037	415	S1031 
09037	415	S381  
09037	415	S481  
09037	415	S502  
09038	415	S1031 
09038	415	S481  
09038	415	S502  
09039	415	S381  
09040	415	S1023 
09040	415	S481  
09040	415	S562  
09042	415	S461  
09042	415	S566  
09050	415	S1141 
09050	415	S421  
09050	415	S441  
09060	415	S381  
09062	415	S381  
09062	415	S404  
09070	415	S53   
09070	415	S582  
09078	415	S561  
09087	415	S1032 
09087	415	S564  
09087	415	S582  
09094	415	S363  
09094	415	S582  
09112	415	S482  
09112	415	S563  
09132	415	S1062 
09139	415	S381  
09148	415	S1033 
09148	415	S363  
09148	415	S582  
09149	415	S381  
09160	415	S1065 
09181	415	S1024 
09181	415	S1121 
09183	415	S381  
09184	415	S1026 
09184	415	S562  
09184	415	S565  
09191	415	S421  
09191	415	S582  
09195	415	S1202 
09202	415	S482  
09202	415	S564  
09218	415	S1065 
09218	415	S1161 
09236	415	S461  
09236	415	S582  
09252	415	S482  
09252	415	S541  
09266	415	S1167 
09266	415	S441  
09266	415	S561  
09273	415	S2104 
09279	415	S421  
09279	415	S582  
09291	415	S564  
09291	415	S566  
09298	415	S564  
09298	415	S566  
09302	415	S381  
09302	415	S461  
09302	415	S566  
09302	415	S963  
09316	415	S421  
09316	415	S566  
09316	415	S581  
09326	415	S1027 
09326	415	S441  
09326	415	S461  
09328	415	S1206 
09409	415	S2104 
09421	415	S564  
09421	415	S582  
09422	415	S1202 
09429	415	S1167 
09429	415	S441  
09430	415	S441  
09430	415	S561  
09431	415	S2203 
09432	415	S2203 
09433	415	S2105 
09433	415	S2961 
10007	415	S1082 
10066	415	S1082 
10067	415	S1082 
10068	415	S1082 
10098	415	S1581 
10099	415	S1581 
10102	415	S1581 
10119	415	S1581 
10123	415	S1082 
10124	415	S1082 
10173	415	S1581 
10858	415	S1082 
10860	415	S1082 
10861	415	S1082 
10862	415	S1082 
10863	415	S1581 
10864	415	S1082 
11011	415	S1069 
11012	415	S1069 
11090	415	S1121 
11090	415	S564  
11090	415	S619  
11091	415	S1121 
11091	415	S564  
11096	415	S1121 
11096	415	S482  
11097	415	S482  
11112	415	S1065 
11113	415	S1065 
11124	415	S1062 
11124	415	S618  
11125	415	S1062 
11130	415	S25   
11131	415	S25   
11143	415	S1121 
11143	415	S564  
11157	415	S1202 
11205	415	S1062 
11206	415	S1062 
11243	415	S2941 
11250	415	S562  
11250	415	S565  
11251	415	S481  
11251	415	S503  
11251	415	S620  
11252	415	S481  
11252	415	S562  
11252	415	S624  
11253	415	S541  
11253	415	S565  
11257	415	S541  
11257	415	S565  
11260	415	D390  
11260	415	S2941 
11260	415	S78   
11260	415	S80   
11263	415	S2941 
11267	415	S2941 
11282	415	S1062 
11286	415	S1062 
11294	415	S563  
11294	415	S582  
11333	415	S1062 
11333	415	S611  
11339	415	S1062 
11352	415	S563  
11352	415	S566  
11353	415	S563  
11353	415	S566  
11354	415	S563  
11354	415	S566  
11355	415	S563  
11355	415	S566  
11356	415	S563  
11356	415	S566  
11357	415	S563  
11357	415	S566  
11358	415	S563  
11358	415	S566  
11359	415	S2105 
11360	415	S2105 
11394	415	S2105 
11395	415	S2105 
11398	415	S2105 
11399	415	S2105 
11402	415	S2105 
11403	415	S2105 
11411	415	S2105 
11412	415	S2105 
11429	415	S1121 
11429	415	S363  
11429	415	S617  
11463	415	S25   
11464	415	S25   
11507	415	S1062 
11508	415	S1062 
11510	415	S1062 
11529	415	S441  
11529	415	S503  
11529	415	S608  
11530	415	S441  
11546	415	S21   
11547	415	S21   
11549	415	S21   
11674	415	S563  
11674	415	S566  
11705	415	S1069 
11742	415	S1121 
11742	415	S564  
11752	415	S1065 
11757	415	S1062 
11760	415	S25   
11821	415	S1062 
11828	415	S563  
11828	415	S566  
11841	415	S2105 
11842	415	S2105 
11856	415	S25   
11875	415	S1062 
11876	415	S1062 
11884	415	S441  
11887	415	S21   
11888	415	S21   
11921	415	S1062 
11935	415	S22   
11949	415	S22   
11950	415	S2941 
11960	415	S481  
11960	415	S562  
11987	415	S1202 
11987	415	S2941 
11990	415	S1202 
11991	415	S1202 
11992	415	S2941 
12061	415	S141  
12062	415	S141  
12063	415	S141  
12065	415	S141  
12078	415	S1063 
12078	415	S503  
12086	415	S343  
12086	415	S363  
12086	415	S502  
12087	415	S343  
12120	415	S83   
12121	415	S83   
12122	415	S83   
12131	415	S77   
12132	415	S77   
12142	415	S85   
12143	415	S85   
12144	415	S85   
12147	415	S502  
12147	415	S564  
12151	415	S86   
12152	415	S563  
12152	415	S565  
12152	415	S86   
12154	415	S941  
12155	415	S79   
12201	415	D4381 
12201	415	S1164 
12220	415	S1221 
12220	415	S2109 
12563	415	S141  
12565	415	S141  
12586	415	S343  
12586	415	S363  
12586	415	S502  
12632	415	S77   
12643	415	S85   
12644	415	S85   
12652	415	S563  
12652	415	S565  
12652	415	S86   
13019	415	S2    
13020	415	S2    
13055	415	S2    
13065	415	S2    
13067	415	S2    
13068	415	S2    
13070	415	S2    
13096	415	S2    
13098	415	S2    
13165	415	S2    
13318	415	S1581 
13320	415	S1581 
13321	415	S1581 
13322	415	S1581 
13323	415	S1581 
13324	415	S1581 
13325	415	S1082 
13326	415	S1082 
13327	415	S1082 
13340	415	S1581 
13341	415	S1581 
13343	415	S2    
13369	415	S2    
13370	415	S2    
13373	415	S2    
13375	415	S2    
13377	415	S2    
13378	415	S2    
13391	415	S2    
13394	415	S2    
13398	415	S2    
13399	415	S2    
13401	415	S2    
13402	415	S2    
13404	415	S2    
13405	415	S2    
13407	415	S2    
13408	415	S2    
13410	415	S2    
13411	415	S2    
13413	415	S2    
13414	415	S2    
13415	415	S2    
13416	415	S2    
13417	415	S2    
13418	415	S2    
13419	415	S2    
13420	415	S2    
13421	415	S2    
13422	415	S2    
13423	415	S2    
13424	415	S2    
13425	415	S2    
13426	415	S2    
13439	415	S2    
13440	415	S2    
13441	415	S2    
13442	415	S2    
13443	415	S2    
13444	415	S2    
13445	415	S2    
13446	415	S2    
13447	415	S2    
13448	415	S2    
13449	415	S2    
13450	415	S2    
13451	415	S2    
13452	415	S2    
13453	415	S2    
13454	415	S2    
13455	415	S2    
13456	415	S2    
13485	415	S2    
13486	415	S2    
13487	415	S2    
13488	415	S2    
13490	415	S2    
13491	415	S2    
13492	415	S2    
13493	415	S2    
13494	415	S14   
13495	415	S14   
13496	415	S14   
13497	415	S14   
13498	415	S14   
13565	415	S2703 
13566	415	S2703 
13567	415	S2703 
13568	415	S2703 
13569	415	S2703 
13805	415	S2    
13806	415	S2    
13809	415	S2    
13810	415	S2    
13811	415	S2    
13813	415	S2    
13814	415	S2    
13850	415	S2    
13851	415	S2    
13853	415	S2    
13854	415	S2    
13856	415	S2    
13857	415	S2    
13868	415	S2    
13869	415	S2    
13870	415	S2    
13871	415	S2    
13872	415	S2    
13873	415	S2    
13874	415	S2    
13875	415	S2    
13876	415	S2    
13877	415	S2    
13878	415	S2    
13879	415	S2    
13880	415	S2    
13881	415	S2    
13882	415	S2    
13891	415	S2    
13893	415	S2    
13894	415	S2    
13896	415	S2    
13898	415	S2    
13900	415	S2    
13909	415	S2    
13910	415	S2    
13911	415	S2    
13912	415	S2    
13913	415	S2    
13914	415	S2    
13917	415	S2    
13918	415	S2    
13920	415	S2    
13921	415	S2    
13923	415	S2    
13924	415	S2    
13929	415	S2    
13930	415	S2    
13931	415	S2    
13932	415	S2    
13934	415	S2    
13935	415	S2    
13948	415	S2    
13949	415	S2    
13950	415	S2    
13951	415	S2    
13952	415	S2    
13953	415	S2    
13954	415	S2    
13955	415	S2    
13956	415	S2    
13957	415	S2    
13958	415	S2    
13959	415	S2    
13968	415	S2    
13969	415	S2    
13970	415	S2    
13971	415	S2    
13985	415	S2    
13988	415	S2703 
13989	415	S2703 
13990	415	S2703 
13991	415	S2703 
13992	415	S2703 
13994	415	S2703 
13995	415	S2703 
13996	415	S2703 
13997	415	S2703 
13998	415	S2703 
14003	415	S2103 
14006	415	S2103 
14084	415	S2103 
14096	415	S2103 
14106	415	S2103 
14154	415	S2702 
14156	415	S2702 
14209	415	S1064 
14209	415	S1066 
14209	415	S1122 
14209	415	S23   
14238	415	S2104 
14242	415	S2104 
14323	415	S1067 
14347	415	S1064 
14347	415	S1122 
14366	415	S2104 
14370	415	S2104 
14382	415	S1164 
14450	415	S1164 
14460	415	S1164 
14461	415	S1164 
14462	415	S2109 
14601	415	S1066 
14602	415	S2103 
15027	415	S1163 
15073	415	S1163 
15087	415	S2109 
15152	415	S2104 
15232	415	S1163 
15260	415	S2109 
15261	415	S1163 
15262	415	S1163 
16006	415	S1164 
16010	415	S1164 
16011	415	S1164 
16029	415	S1164 
16037	415	S1164 
16037	415	S2202 
16038	415	S1164 
16038	415	S2202 
16042	415	S1065 
16042	415	S2202 
16043	415	S1065 
16043	415	S2202 
16089	415	S563  
16097	415	S22   
16098	415	S22   
16112	415	S39   
16114	415	S39   
16120	415	S39   
16123	415	S39   
16126	415	S39   
16139	415	S39   
16147	415	S2104 
16159	415	D342  
16159	415	S39   
16167	415	S2203 
16174	415	S18   
16338	415	S1164 
16338	415	S2202 
16343	415	S1065 
16343	415	S2202 
16397	415	S22   
16398	415	S22   
17202	415	S1082 
17203	415	S1082 
17204	415	S1082 
17218	415	S1581 
17219	415	S1581 
17332	415	S3    
17335	415	S3    
17340	415	S3    
17341	415	S3    
17345	415	S3    
17346	415	S3    
17347	415	S3    
17348	415	S3    
18001	415	S1162 
18002	415	S1162 
18069	415	S20   
18079	415	S25   
18159	415	S21   
18166	415	S25   
18168	415	S25   
18215	415	S25   
18228	415	S23   
18231	415	S25   
18258	415	S1162 
18259	415	S1162 
18262	415	S1162 
18263	415	S1162 
18288	415	S27   
18350	415	S21   
18365	415	S27   
18376	415	S25   
18403	415	S27   
18927	415	S25   
18930	415	S2203 
18931	415	S2203 
18932	415	S27   
18933	415	S27   
18934	415	S27   
18935	415	S27   
18936	415	S27   
19003	415	S26   
19034	415	S26   
19035	415	S26   
19047	415	S1162 
19056	415	S26   
19057	415	S2109 
19058	415	S2109 
19064	415	S1164 
19076	415	S1164 
19078	415	S1069 
19109	415	S1164 
19120	415	S1069 
19155	415	S1164 
19230	415	S1063 
19350	415	S1164 
19411	415	S26   
20046	415	S20   
20047	415	S20   
20048	415	S20   
20049	415	S20   
20099	415	S1163 
20099	415	S20   
20100	415	S1163 
20100	415	S20   
20109	415	S2105 
20110	415	S2105 
20120	415	S1163 
20120	415	S20   
20121	415	S1163 
20121	415	S20   
20132	415	S1202 
20310	415	S2105 
20321	415	S1163 
20321	415	S20   
20400	415	S1163 
20400	415	S20   
20409	415	S2105 
20410	415	S2105 
20420	415	S1163 
20420	415	S20   
20421	415	S1163 
20421	415	S20   
20446	415	S20   
20447	415	S20   
20499	415	S1163 
20499	415	S20   
20510	415	S2105 
20521	415	S1163 
20521	415	S20   
20623	415	S1742 
20624	415	S1742 
20628	415	S1742 
20629	415	S1742 
20630	415	S1742 
20634	415	S1742 
20635	415	S1742 
20636	415	S1742 
20640	415	S1742 
20641	415	S1742 
20645	415	S1742 
20646	415	S1742 
21138	415	S1064 
21138	415	S1066 
21138	415	S1122 
21141	415	S1064 
21224	415	S19   
21225	415	S19   
21226	415	S22   
21227	415	S22   
21229	415	S1122 
21238	415	S2801 
21239	415	S1066 
21240	415	S1066 
21241	415	S1066 
21242	415	S1066 
21243	415	S1066 
21244	415	S1066 
21245	415	S1066 
21246	415	S1066 
21247	415	S1066 
21248	415	S1066 
21249	415	S1064 
21250	415	S1064 
21251	415	S1064 
21252	415	S1064 
21253	415	S1064 
21254	415	S1064 
21255	415	S1064 
21256	415	S1064 
21257	415	S1064 
21259	415	S1064 
21260	415	S1082 
21261	415	S1082 
21262	415	S1082 
21263	415	S1082 
21264	415	S1082 
21265	415	S1082 
21266	415	S1082 
21267	415	S1082 
21268	415	S1082 
21269	415	S1082 
21270	415	S1082 
21271	415	S2108 
21272	415	S2108 
21273	415	S2108 
21274	415	S2108 
21275	415	S2108 
21276	415	S2108 
21277	415	S2110 
21280	415	S2110 
21283	415	S2111 
21284	415	S2111 
21293	415	S2782 
21294	415	S2782 
21295	415	S2782 
21296	415	S2782 
21297	415	S2782 
21298	415	S2782 
21299	415	S2110 
21299	415	S2111 
21299	415	S2782 
21300	415	S2782 
21301	415	S2782 
21302	415	S2110 
21302	415	S2111 
21302	415	S2782 
21303	415	S2782 
21304	415	S2782 
21308	415	S2801 
21309	415	S2801 
21310	415	S2801 
21311	415	S2801 
21312	415	S2801 
21313	415	S2801 
21314	415	S2801 
21315	415	S2801 
21316	415	S2801 
21317	415	S2801 
21318	415	S2801 
21319	415	S2801 
21320	415	S2801 
21321	415	S2801 
21322	415	S2801 
21323	415	S2801 
21324	415	S2801 
21325	415	S2801 
21326	415	S2801 
21337	415	S2801 
21343	415	S2801 
21346	415	S2801 
21347	415	S2801 
21348	415	S2801 
21349	415	S2801 
22247	415	S20   
22903	415	S21   
22904	415	S18   
22909	415	S22   
22911	415	S18   
22912	415	S19   
22914	415	S19   
22915	415	S19   
22916	415	S19   
23009	415	S2703 
23010	415	S2703 
23011	415	S2703 
23012	415	S2703 
23013	415	S2703 
23014	415	S2703 
23015	415	S2703 
23016	415	S2703 
23017	415	S2703 
23018	415	S2703 
23019	415	S2703 
23020	415	S2703 
23021	415	S2703 
23022	415	S2703 
23023	415	S2703 
23024	415	S2703 
23025	415	S2703 
23027	415	S2703 
23028	415	S2703 
23029	415	S2703 
23030	415	S2703 
23031	415	S2703 
23032	415	S2703 
23033	415	S2703 
23034	415	S2703 
23035	415	S2703 
23036	415	S2703 
23037	415	S2703 
23038	415	S2703 
23039	415	S2703 
23040	415	S2703 
23041	415	S2703 
23042	415	S2703 
23043	415	S2703 
23044	415	S2703 
23045	415	S2703 
23046	415	S2703 
23047	415	S2703 
23048	415	S2703 
23049	415	S2703 
23050	415	S2703 
23051	415	S2703 
23052	415	S2703 
23053	415	S2703 
23054	415	S2703 
23055	415	S2703 
23056	415	S2703 
23057	415	S2703 
23058	415	S2703 
23059	415	S2703 
23060	415	S2703 
23061	415	S2703 
23062	415	S2703 
23063	415	S2703 
23064	415	S2703 
23065	415	S2703 
23557	415	S14   
23558	415	S14   
23559	415	S14   
23560	415	S14   
23561	415	S14   
23562	415	S14   
23563	415	S14   
23564	415	S14   
23565	415	S14   
23566	415	S14   
23567	415	S14   
23568	415	S14   
23569	415	S14   
23570	415	S14   
23571	415	S14   
23572	415	S14   
23573	415	S14   
23574	415	S14   
23575	415	S14   
23576	415	S14   
23577	415	S14   
23578	415	S14   
23579	415	S14   
23580	415	S14   
23581	415	S14   
23582	415	S2    
23583	415	S2    
23584	415	S2    
23585	415	S2    
23586	415	S2    
23587	415	S2    
23588	415	S2    
23589	415	S2    
23590	415	S2    
23591	415	S2    
23592	415	S2    
23593	415	S2    
23594	415	S2    
23595	415	S2    
23596	415	S2    
23597	415	S2    
23598	415	S2    
23599	415	S2    
23600	415	S2    
23601	415	S2    
23602	415	S2    
23603	415	S2    
23604	415	S2    
23605	415	S2    
23606	415	S2    
23607	415	S2    
23608	415	S2    
23609	415	S2    
23610	415	S2    
23611	415	S2    
23612	415	S2    
23613	415	S2    
23614	415	S2    
23615	415	S2    
23616	415	S2    
23617	415	S2    
23618	415	S2    
23619	415	S2    
23620	415	S2    
23621	415	S2    
23622	415	S2    
23623	415	S2    
23624	415	S2    
23625	415	S2    
23626	415	S2    
23627	415	S2    
23628	415	S2    
23629	415	S2    
23630	415	S2    
23631	415	S2    
23632	415	S2    
23633	415	S2    
23634	415	S2    
23635	415	S2    
23636	415	S2    
23637	415	S2    
23638	415	S2    
23640	415	S1581 
23646	415	S2    
23647	415	S2    
23648	415	S2    
23649	415	S2    
23650	415	S2    
23651	415	S2    
23652	415	S2    
23653	415	S2    
23654	415	S2    
23655	415	S2    
23656	415	S2    
23657	415	S2    
23658	415	S2    
23659	415	S2    
23660	415	S2    
35001	415	D4961 
35003	415	D4961 
35024	415	D4961 
35048	415	D4961 
35051	415	D4961 
35073	415	D4961 
35078	415	D4961 
35130	415	S2381 
35131	415	S2381 
35132	415	S2381 
35133	415	S2381 
35134	415	S2381 
35135	415	S2381 
35136	415	S2381 
35137	415	S2381 
35138	415	S2381 
35139	415	S2381 
35141	415	S2381 
35142	415	S2381 
35143	415	S2381 
35144	415	S2381 
35145	415	S2381 
35146	415	S2381 
35147	415	S2381 
35148	415	S2381 
43215	415	S26   
43364	415	S26   
43378	415	S1082 
01026	417	S25   
01032	417	S19   
01079	417	S1063 
01082	417	S1063 
01085	417	S1063 
01103	417	S1163 
01123	417	S1063 
01123	417	S561  
01124	417	S1065 
01202	417	S1163 
04017	417	S19   
04021	417	S19   
04023	417	S19   
04114	417	S19   
04120	417	S19   
04141	417	S19   
04143	417	S19   
04144	417	S19   
04367	417	S19   
04610	417	S18   
04628	417	S18   
04629	417	S18   
04630	417	S19   
04635	417	S19   
04636	417	S19   
04638	417	S26   
04639	417	S26   
04640	417	S26   
05023	417	S1581 
05024	417	S1581 
05027	417	S1166 
05028	417	S1166 
05173	417	S1581 
05174	417	S1581 
05175	417	S1581 
05176	417	S1581 
05177	417	S1581 
05178	417	S1581 
05312	417	S26   
05313	417	S26   
05320	417	S26   
05661	417	S1166 
06016	417	S18   
06019	417	S18   
06043	417	S18   
06094	417	S18   
06128	417	S18   
06159	417	S18   
06164	417	S23   
06982	417	S18   
06983	417	S18   
06984	417	S2104 
06985	417	S2104 
07002	417	S222  
07005	417	S248  
07007	417	S1164 
07008	417	S238  
07013	417	S242  
07015	417	S248  
07016	417	S248  
07022	417	S21   
07039	417	S244  
07056	417	S248  
07057	417	S238  
07063	417	S1164 
07064	417	S1164 
07070	417	S238  
07075	417	S1164 
07241	417	S21   
07910	417	S245  
07913	417	S238  
07916	417	S242  
07917	417	S242  
07918	417	S242  
07920	417	S242  
07922	417	S242  
07923	417	S245  
07924	417	S242  
07931	417	S222  
07938	417	S233  
07939	417	S235  
07945	417	S21   
07952	417	S1164 
07953	417	S1164 
07954	417	S1164 
07955	417	S1164 
07956	417	S1164 
07957	417	S1164 
07958	417	S1164 
07959	417	S1164 
07960	417	S1164 
08001	417	S2664 
08003	417	S2664 
08005	417	S2664 
08010	417	S702  
08011	417	S702  
08012	417	S702  
08013	417	S603  
08014	417	S1065 
08017	417	S603  
08018	417	S702  
08019	417	S603  
08020	417	S1065 
08023	417	S2664 
08026	417	S603  
08028	417	S2664 
08030	417	S1065 
08031	417	S2664 
08032	417	S2664 
08035	417	S603  
08045	417	S603  
08047	417	S702  
08048	417	S603  
08049	417	S702  
08050	417	S603  
08054	417	S702  
08057	417	S603  
08058	417	S2664 
08059	417	S702  
08060	417	S2664 
08061	417	S1065 
08064	417	S603  
08065	417	S1065 
08066	417	S702  
08067	417	S2664 
08068	417	S2664 
08069	417	S2664 
08071	417	S2664 
08077	417	S2421 
08078	417	S603  
08082	417	S603  
08085	417	S702  
08086	417	S603  
08087	417	S603  
08089	417	S603  
08090	417	D4901 
08092	417	S702  
08094	417	S702  
08112	417	D4901 
08124	417	S702  
08128	417	S702  
08130	417	S702  
08139	417	S603  
08146	417	S702  
08147	417	S1065 
08147	417	S2422 
08189	417	S2664 
08190	417	S603  
08194	417	S603  
08200	417	S702  
08202	417	S603  
08210	417	S702  
08211	417	S702  
08212	417	S702  
08214	417	S702  
08215	417	S702  
08216	417	S702  
08217	417	S2664 
08218	417	S1065 
08219	417	S702  
08220	417	S702  
08221	417	S702  
08225	417	S702  
08229	417	S702  
08231	417	S702  
08232	417	S702  
08243	417	S603  
08244	417	S603  
08245	417	S603  
08246	417	S603  
08247	417	S603  
08253	417	S2664 
08258	417	S2664 
08259	417	S2664 
08261	417	S603  
08262	417	S603  
08263	417	S603  
08266	417	S603  
08267	417	S603  
08268	417	S603  
08269	417	S603  
08270	417	S603  
08271	417	S603  
08272	417	S603  
08273	417	S603  
08274	417	S603  
08278	417	S603  
08283	417	S2664 
08284	417	S2664 
08286	417	S2664 
08287	417	S2664 
08288	417	S2664 
08289	417	S2664 
08293	417	S702  
08294	417	S702  
08299	417	S702  
08309	417	S2664 
08315	417	S702  
08316	417	S702  
08317	417	S702  
08318	417	S2664 
08319	417	S2664 
08345	417	S603  
08351	417	S702  
08352	417	S702  
08353	417	S702  
08354	417	S702  
08355	417	S702  
08357	417	S702  
08358	417	S702  
08359	417	S702  
08360	417	S702  
08361	417	S702  
08362	417	S702  
08363	417	S702  
08364	417	S702  
08366	417	S702  
08367	417	S603  
08368	417	S603  
08370	417	S603  
08371	417	S603  
08372	417	S603  
08374	417	S2664 
08376	417	S2664 
08380	417	S2664 
08383	417	S2664 
08384	417	S2664 
08385	417	S2664 
08386	417	S2664 
08387	417	S2664 
08389	417	S682  
08391	417	S682  
08392	417	S682  
08394	417	S702  
08395	417	S702  
08396	417	S702  
08397	417	S603  
08398	417	S603  
08399	417	S603  
08400	417	S881  
08401	417	S881  
08403	417	S1209 
08410	417	S702  
08411	417	S702  
08412	417	S702  
08413	417	S702  
08414	417	S702  
08415	417	S702  
08416	417	S702  
08417	417	S702  
08418	417	S702  
08419	417	S702  
08420	417	S702  
08421	417	S702  
08422	417	S702  
08435	417	S1065 
08436	417	S702  
08444	417	S702  
08446	417	S702  
08448	417	S702  
08449	417	S702  
08450	417	S702  
08454	417	S2664 
08455	417	S2664 
08456	417	S2664 
08457	417	S2664 
08458	417	S2664 
08459	417	S2664 
08460	417	S2664 
08465	417	S2664 
08466	417	S2664 
08468	417	S2664 
08469	417	S2664 
08470	417	S2664 
08471	417	S2664 
08472	417	S2664 
08473	417	S2664 
08474	417	S2664 
09032	417	S21   
09037	417	S1031 
09037	417	S1621 
09037	417	S381  
09037	417	S481  
09038	417	S1031 
09038	417	S1621 
09038	417	S481  
09039	417	S381  
09040	417	S1023 
09040	417	S481  
09040	417	S562  
09042	417	S461  
09042	417	S566  
09050	417	S1141 
09050	417	S421  
09050	417	S441  
09060	417	S381  
09062	417	S381  
09070	417	S53   
09078	417	S561  
09087	417	S1032 
09087	417	S564  
09087	417	S582  
09094	417	S363  
09094	417	S582  
09112	417	S482  
09112	417	S563  
09132	417	S1062 
09139	417	S381  
09148	417	S1033 
09148	417	S363  
09148	417	S582  
09149	417	S381  
09160	417	S1065 
09181	417	S1024 
09181	417	S1121 
09181	417	S461  
09183	417	S381  
09184	417	S1026 
09184	417	S562  
09184	417	S565  
09191	417	S582  
09195	417	S1202 
09218	417	S1065 
09218	417	S1161 
09236	417	S582  
09252	417	S482  
09252	417	S541  
09266	417	S1167 
09266	417	S441  
09266	417	S561  
09273	417	S2104 
09279	417	S421  
09279	417	S582  
09291	417	S564  
09298	417	S564  
09302	417	S381  
09302	417	S461  
09302	417	S566  
09302	417	S963  
09316	417	D4781 
09316	417	S1662 
09326	417	S441  
09409	417	S2104 
09421	417	S564  
09422	417	S1202 
09429	417	S1167 
09429	417	S441  
09430	417	S441  
09430	417	S561  
09431	417	S2203 
09432	417	S2203 
09433	417	S2105 
09433	417	S2961 
10007	417	S1166 
10058	417	S1166 
10066	417	S1166 
10067	417	S1166 
10068	417	S1166 
10093	417	S1166 
10098	417	S1581 
10099	417	S1581 
10102	417	S1581 
10119	417	S1581 
10123	417	S1166 
10124	417	S1166 
10173	417	S1581 
10858	417	S1166 
10860	417	S1166 
10861	417	S1166 
10861	417	S502  
10862	417	S1166 
10863	417	S1581 
11011	417	S1069 
11012	417	S1069 
11090	417	S1121 
11090	417	S1164 
11090	417	S564  
11090	417	S619  
11091	417	S1121 
11091	417	S564  
11096	417	S1121 
11096	417	S482  
11097	417	S482  
11112	417	S1065 
11113	417	S1065 
11124	417	S1062 
11124	417	S618  
11143	417	S1121 
11143	417	S564  
11157	417	S1202 
11205	417	S1062 
11243	417	S2941 
11252	417	S481  
11252	417	S562  
11252	417	S624  
11253	417	S541  
11253	417	S565  
11257	417	S541  
11257	417	S565  
11260	417	D389  
11260	417	D566  
11260	417	S2941 
11260	417	S78   
11260	417	S80   
11263	417	S2941 
11267	417	S2941 
11286	417	S1062 
11294	417	S563  
11294	417	S582  
11333	417	S1062 
11333	417	S611  
11339	417	S1062 
11352	417	S563  
11352	417	S566  
11353	417	S563  
11353	417	S566  
11354	417	S563  
11354	417	S566  
11355	417	S563  
11355	417	S566  
11357	417	S563  
11357	417	S566  
11358	417	S563  
11358	417	S566  
11359	417	S2105 
11360	417	S2105 
11394	417	S2105 
11395	417	S2105 
11398	417	S2105 
11399	417	S2105 
11402	417	S2105 
11403	417	S2105 
11411	417	S2105 
11412	417	S2105 
11429	417	S1121 
11429	417	S363  
11429	417	S617  
11463	417	S25   
11464	417	S25   
11507	417	S1062 
11508	417	S1062 
11510	417	S1062 
11529	417	S441  
11529	417	S503  
11529	417	S608  
11546	417	S21   
11674	417	S563  
11674	417	S566  
11705	417	S1069 
11742	417	S1121 
11742	417	S564  
11752	417	S1065 
11757	417	S1062 
11821	417	S1062 
11828	417	S563  
11828	417	S566  
11841	417	S2105 
11842	417	S2105 
11856	417	S25   
11875	417	S1062 
11876	417	S1062 
11887	417	S21   
11921	417	S1062 
11935	417	S22   
11949	417	S22   
11950	417	S2941 
11987	417	S1202 
11987	417	S2941 
11990	417	S1202 
11991	417	S1202 
11992	417	S2941 
12061	417	S141  
12062	417	S141  
12063	417	S141  
12065	417	S141  
12078	417	S1063 
12086	417	S363  
12086	417	S502  
12120	417	S83   
12121	417	S83   
12122	417	S83   
12131	417	S77   
12132	417	S77   
12142	417	S85   
12143	417	S85   
12144	417	S85   
12147	417	S502  
12147	417	S564  
12151	417	S86   
12152	417	S86   
12154	417	S941  
12155	417	S79   
12201	417	S1164 
12220	417	S1221 
12220	417	S2109 
12563	417	S141  
12565	417	S141  
12586	417	S363  
12586	417	S502  
12632	417	S77   
12643	417	S85   
12644	417	S85   
12652	417	S86   
13019	417	S2    
13020	417	S2    
13055	417	S2    
13065	417	S2    
13067	417	S2    
13068	417	S2    
13070	417	S2    
13096	417	S2    
13098	417	S2    
13165	417	S2    
13318	417	S1581 
13320	417	S1581 
13321	417	S1581 
13322	417	S1581 
13323	417	S1581 
13324	417	S1581 
13325	417	S1166 
13326	417	S1166 
13327	417	S1166 
13340	417	S1581 
13341	417	S1581 
13343	417	S2    
13369	417	S2    
13370	417	S2    
13373	417	S2    
13375	417	S2    
13377	417	S2    
13378	417	S2    
13391	417	S2    
13394	417	S2    
13398	417	S2    
13399	417	S2    
13401	417	S2    
13402	417	S2    
13404	417	S2    
13405	417	S2    
13407	417	S2    
13408	417	S2    
13410	417	S2    
13411	417	S2    
13413	417	S2    
13414	417	S2    
13415	417	S2    
13416	417	S2    
13417	417	S2    
13418	417	S2    
13419	417	S2    
13420	417	S2    
13421	417	S2    
13422	417	S2    
13423	417	S2    
13424	417	S2    
13425	417	S2    
13426	417	S2    
13439	417	S2    
13440	417	S2    
13441	417	S2    
13442	417	S2    
13443	417	S2    
13444	417	S2    
13445	417	S2    
13446	417	S2    
13447	417	S2    
13448	417	S2    
13449	417	S2    
13450	417	S2    
13451	417	S2    
13452	417	S2    
13453	417	S2    
13454	417	S2    
13455	417	S2    
13456	417	S2    
13485	417	S2    
13486	417	S2    
13487	417	S2    
13488	417	S2    
13490	417	S2    
13491	417	S2    
13492	417	S2    
13493	417	S2    
13494	417	S14   
13495	417	S14   
13497	417	S14   
13498	417	S14   
13565	417	S2703 
13566	417	S2703 
13567	417	S2703 
13805	417	S2    
13806	417	S2    
13809	417	S2    
13810	417	S2    
13811	417	S2    
13812	417	S2    
13813	417	S2    
13814	417	S2    
13850	417	S2    
13851	417	S2    
13853	417	S2    
13854	417	S2    
13856	417	S2    
13857	417	S2    
13868	417	S2    
13869	417	S2    
13870	417	S2    
13871	417	S2    
13872	417	S2    
13873	417	S2    
13874	417	S2    
13875	417	S2    
13876	417	S2    
13877	417	S2    
13878	417	S2    
13879	417	S2    
13880	417	S2    
13881	417	S2    
13882	417	S2    
13891	417	S2    
13893	417	S2    
13894	417	S2    
13896	417	S2    
13898	417	S2    
13900	417	S2    
13909	417	S2    
13910	417	S2    
13911	417	S2    
13912	417	S2    
13913	417	S2    
13914	417	S2    
13917	417	S2    
13918	417	S2    
13920	417	S2    
13921	417	S2    
13923	417	S2    
13924	417	S2    
13929	417	S2    
13930	417	S2    
13931	417	S2    
13932	417	S2    
13934	417	S2    
13935	417	S2    
13948	417	S2    
13949	417	S2    
13950	417	S2    
13951	417	S2    
13952	417	S2    
13953	417	S2    
13954	417	S2    
13955	417	S2    
13956	417	S2    
13957	417	S2    
13958	417	S2    
13959	417	S2    
13968	417	S2    
13969	417	S2    
13970	417	S2    
13971	417	S2    
13985	417	S2    
13988	417	S2703 
13989	417	S2703 
13992	417	S2703 
13994	417	S2703 
13997	417	S2703 
13998	417	S2703 
14003	417	S2103 
14006	417	S2103 
14084	417	S2103 
14096	417	S2103 
14106	417	S2103 
14209	417	S1064 
14209	417	S1066 
14209	417	S1122 
14209	417	S23   
14347	417	S1122 
14602	417	S2103 
15027	417	S1163 
15073	417	S1163 
15087	417	S2109 
15152	417	S2104 
15232	417	S1163 
15260	417	S2109 
15261	417	S1163 
15262	417	S1163 
16006	417	S1164 
16010	417	S1164 
16011	417	S1164 
16029	417	S1164 
16037	417	S1164 
16037	417	S2202 
16038	417	S2202 
16042	417	S2202 
16043	417	S2202 
16089	417	S563  
16112	417	S39   
16114	417	S39   
16120	417	S39   
16123	417	S39   
16126	417	S39   
16139	417	S39   
16159	417	D342  
16159	417	S39   
16167	417	S2203 
16174	417	S18   
16338	417	S2202 
17202	417	S1166 
17203	417	S1166 
17204	417	S1166 
17204	417	S502  
17218	417	S1581 
17219	417	S1581 
18001	417	S1162 
18002	417	S1162 
18029	417	D4901 
18033	417	D4901 
18069	417	S20   
18079	417	S25   
18135	417	D4901 
18137	417	D4901 
18142	417	D4901 
18144	417	D4901 
18159	417	S21   
18166	417	S25   
18168	417	S25   
18214	417	D4901 
18215	417	S25   
18228	417	S23   
18231	417	S25   
18232	417	D4901 
18258	417	S1162 
18259	417	S1162 
18262	417	S1162 
18263	417	S1162 
18275	417	D4901 
18351	417	S20   
18352	417	S20   
18363	417	S22   
18365	417	S27   
18376	417	S25   
18403	417	S27   
18416	417	S20   
18927	417	S25   
18932	417	S27   
18933	417	S27   
18934	417	S27   
18935	417	S27   
18936	417	S27   
19003	417	S26   
19034	417	S26   
19064	417	S1164 
19076	417	S1164 
19078	417	S1069 
19109	417	S1164 
19120	417	S1069 
19155	417	S1164 
19230	417	S1063 
19411	417	S26   
20022	417	D4901 
20024	417	D4901 
20046	417	S20   
20047	417	S20   
20048	417	S20   
20049	417	S20   
20081	417	S20   
20082	417	S20   
20083	417	S20   
20084	417	S20   
20099	417	D4901 
20099	417	S1163 
20099	417	S20   
20100	417	S1163 
20100	417	S20   
20109	417	D4901 
20109	417	S2105 
20110	417	S2105 
20120	417	D4901 
20120	417	S1163 
20120	417	S20   
20121	417	S1163 
20121	417	S20   
20310	417	S2105 
20321	417	S1163 
20321	417	S20   
20324	417	D4901 
20581	417	S20   
20623	417	S1742 
20624	417	S1742 
20628	417	S1742 
20629	417	S1742 
20630	417	S1742 
20634	417	S1742 
20635	417	S1742 
20636	417	S1742 
20640	417	S1742 
20641	417	S1742 
20645	417	S1742 
20646	417	S1742 
21138	417	S1064 
21138	417	S1066 
21138	417	S1122 
21224	417	S19   
21225	417	S19   
21226	417	S22   
21227	417	S22   
21229	417	S1122 
21238	417	S2801 
21247	417	S1066 
21250	417	S1064 
21252	417	S1064 
21253	417	S1064 
21254	417	S1064 
21255	417	S1064 
21256	417	S1064 
21257	417	S1064 
21259	417	S1064 
21260	417	S1082 
21261	417	S1082 
21262	417	S1082 
21263	417	S1082 
21264	417	S1082 
21265	417	S1082 
21266	417	S1082 
21267	417	S1082 
21268	417	S1082 
21269	417	S1082 
21270	417	S1082 
21283	417	S2111 
21284	417	S2111 
21285	417	S2111 
21293	417	S2782 
21294	417	S2782 
21295	417	S2782 
21296	417	S2782 
21297	417	S2782 
21298	417	S2782 
21299	417	S2111 
21299	417	S2782 
21300	417	S2782 
21301	417	S2782 
21302	417	S2111 
21302	417	S2782 
21303	417	S2782 
21304	417	S2111 
21304	417	S2782 
21308	417	S2801 
21309	417	S2801 
21310	417	S2801 
21311	417	S2801 
21312	417	S2801 
21313	417	S2801 
21314	417	S2801 
21315	417	S2801 
21316	417	S2801 
21317	417	S2801 
21318	417	S2801 
21319	417	S2801 
21320	417	S2801 
21321	417	S2801 
21322	417	S2801 
21324	417	S2801 
21325	417	S2801 
21326	417	S2801 
21337	417	S2801 
21343	417	S2801 
21346	417	S2801 
21347	417	S2801 
21348	417	S2801 
21349	417	S2801 
22903	417	S21   
22909	417	S22   
22912	417	S19   
22914	417	S19   
22915	417	S19   
22916	417	S19   
23011	417	S2703 
23014	417	S2703 
23015	417	S2703 
23018	417	S2703 
23019	417	S2703 
23020	417	S2703 
23021	417	S2703 
23022	417	S2703 
23023	417	S2703 
23024	417	S2703 
23025	417	S2703 
23027	417	S2703 
23028	417	S2703 
23029	417	S2703 
23030	417	S2703 
23031	417	S2703 
23034	417	S2703 
23035	417	S2703 
23037	417	S2703 
23038	417	S2703 
23041	417	S2703 
23042	417	S2703 
23045	417	S2703 
23046	417	S2703 
23049	417	S2703 
23050	417	S2703 
23053	417	S2703 
23054	417	S2703 
23055	417	S2703 
23056	417	S2703 
23057	417	S2703 
23058	417	S2703 
23059	417	S2703 
23060	417	S2703 
23061	417	S2703 
23062	417	S2703 
23063	417	S2703 
23064	417	S2703 
23557	417	S14   
23558	417	S14   
23560	417	S14   
23561	417	S14   
23562	417	S14   
23563	417	S14   
23565	417	S14   
23566	417	S14   
23567	417	S14   
23568	417	S14   
23570	417	S14   
23571	417	S14   
23572	417	S14   
23573	417	S14   
23575	417	S14   
23576	417	S14   
23577	417	S14   
23578	417	S14   
23580	417	S14   
23581	417	S14   
23582	417	S2    
23583	417	S2    
23584	417	S2    
23585	417	S2    
23586	417	S2    
23587	417	S2    
23588	417	S2    
23589	417	S2    
23590	417	S2    
23591	417	S2    
23592	417	S2    
23593	417	S2    
23594	417	S2    
23595	417	S2    
23596	417	S2    
23597	417	S2    
23598	417	S2    
23599	417	S2    
23600	417	S2    
23601	417	S2    
23602	417	S2    
23603	417	S2    
23604	417	S2    
23605	417	S2    
23606	417	S2    
23607	417	S2    
23608	417	S2    
23609	417	S2    
23610	417	S2    
23611	417	S2    
23612	417	S2    
23613	417	S2    
23614	417	S2    
23615	417	S2    
23616	417	S2    
23617	417	S2    
23618	417	S2    
23619	417	S2    
23620	417	S2    
23621	417	S2    
23622	417	S2    
23623	417	S2    
23624	417	S2    
23625	417	S2    
23626	417	S2    
23627	417	S2    
23628	417	S2    
23629	417	S2    
23630	417	S2    
23631	417	S2    
23632	417	S2    
23633	417	S2    
23634	417	S2    
23635	417	S2    
23636	417	S2    
23637	417	S2    
23638	417	S2    
23640	417	S1581 
23646	417	S2    
23647	417	S2    
23648	417	S2    
23649	417	S2    
23650	417	S2    
23651	417	S2    
23652	417	S2    
23653	417	S2    
23654	417	S2    
23655	417	S2    
23656	417	S2    
23657	417	S2    
23658	417	S2    
23659	417	S2    
23660	417	S2    
35001	417	D4961 
35003	417	D4961 
35024	417	D4961 
35048	417	D4961 
35051	417	D4961 
35073	417	D4961 
35078	417	D4961 
35130	417	S2381 
35131	417	S2381 
35132	417	S2381 
35133	417	S2381 
35134	417	S2381 
35135	417	S2381 
35136	417	S2381 
35137	417	S2381 
35138	417	S2381 
35139	417	S2381 
35140	417	S2381 
35141	417	S2381 
35142	417	S2381 
35143	417	S2381 
35144	417	S2381 
35145	417	S2381 
35146	417	S2381 
35147	417	S2381 
35148	417	S2381 
43215	417	S26   
43378	417	S1166 
01026	418	S25   
01029	418	S27   
01032	418	S19   
01040	418	S27   
01046	418	S19   
01077	418	S27   
01079	418	S1063 
01079	418	S20   
01082	418	S1063 
01085	418	S1063 
01103	418	S1163 
01123	418	S1063 
01123	418	S561  
01124	418	S1065 
01125	418	S1065 
01202	418	S1163 
04017	418	S19   
04021	418	S19   
04023	418	S19   
04114	418	S19   
04143	418	S19   
04144	418	S19   
04635	418	S19   
04636	418	S19   
04638	418	S26   
04639	418	S26   
04640	418	S26   
04641	418	S25   
05023	418	S1581 
05024	418	S1581 
05027	418	S1082 
05028	418	S1082 
05173	418	S1581 
05174	418	S1581 
05175	418	S1581 
05176	418	S1581 
05177	418	S1581 
05178	418	S1581 
05312	418	S26   
05313	418	S26   
05320	418	S26   
05626	418	D4281 
05627	418	D4282 
05628	418	D4281 
05629	418	D4281 
05661	418	S1082 
06016	418	S18   
06019	418	S18   
06043	418	S18   
06128	418	S18   
06982	418	S18   
06983	418	S18   
06984	418	S2104 
06985	418	S2104 
07002	418	S222  
07005	418	S248  
07007	418	S1164 
07008	418	S238  
07015	418	S248  
07016	418	S248  
07022	418	S21   
07039	418	S244  
07056	418	S248  
07057	418	S238  
07063	418	S1164 
07063	418	S582  
07064	418	S1164 
07070	418	S238  
07075	418	S1164 
07241	418	S21   
07910	418	S245  
07913	418	S238  
07923	418	S245  
07931	418	S222  
07938	418	S233  
07939	418	S235  
07945	418	S21   
07952	418	S1164 
07953	418	S1164 
07953	418	S582  
07954	418	S582  
07955	418	S1164 
07956	418	S1164 
07957	418	S1164 
07958	418	S1164 
07959	418	S1164 
07960	418	S1164 
08001	418	S1065 
08003	418	S2664 
08005	418	S2664 
08010	418	S702  
08011	418	S702  
08012	418	S1065 
08013	418	S1065 
08014	418	S1065 
08017	418	S603  
08018	418	S702  
08019	418	S603  
08020	418	S1065 
08023	418	S2664 
08026	418	S603  
08028	418	S2664 
08030	418	S1065 
08031	418	S2664 
08032	418	S2664 
08035	418	S603  
08045	418	S603  
08047	418	S702  
08048	418	S603  
08049	418	S702  
08050	418	S603  
08054	418	S702  
08057	418	S603  
08058	418	S2664 
08059	418	S702  
08060	418	S2664 
08061	418	S1065 
08064	418	S603  
08065	418	S1065 
08066	418	S702  
08067	418	S2664 
08068	418	S2664 
08069	418	S2664 
08071	418	S2664 
08077	418	S2421 
08078	418	S603  
08082	418	S603  
08083	418	S2502 
08085	418	S702  
08086	418	S603  
08087	418	S603  
08089	418	S603  
08092	418	S702  
08094	418	S702  
08124	418	S702  
08128	418	S702  
08130	418	S702  
08138	418	S2502 
08139	418	S603  
08146	418	S702  
08147	418	S1065 
08147	418	S2422 
08189	418	S2664 
08190	418	S603  
08194	418	S603  
08200	418	S702  
08202	418	S603  
08206	418	S2502 
08210	418	S702  
08211	418	S702  
08212	418	S702  
08214	418	S702  
08215	418	S702  
08216	418	S702  
08217	418	S2664 
08218	418	S1065 
08219	418	S702  
08220	418	S702  
08221	418	S702  
08225	418	S702  
08229	418	S702  
08231	418	S702  
08232	418	S702  
08243	418	S603  
08245	418	S603  
08246	418	S603  
08247	418	S603  
08253	418	S2664 
08258	418	S2664 
08259	418	S2664 
08261	418	S603  
08262	418	S603  
08263	418	S603  
08266	418	S603  
08267	418	S603  
08268	418	S603  
08269	418	S603  
08270	418	S603  
08271	418	S603  
08272	418	S603  
08273	418	S603  
08274	418	S603  
08278	418	S603  
08283	418	S2664 
08284	418	S2664 
08286	418	S2664 
08287	418	S2664 
08288	418	S2664 
08289	418	S2664 
08293	418	S702  
08294	418	S702  
08299	418	S702  
08309	418	S2664 
08315	418	S702  
08316	418	S702  
08317	418	S702  
08318	418	S2664 
08319	418	S2664 
08345	418	S603  
08348	418	S2502 
08349	418	S2502 
08350	418	S2502 
08351	418	S702  
08352	418	S702  
08353	418	S702  
08354	418	S702  
08355	418	S702  
08357	418	S702  
08358	418	S702  
08359	418	S702  
08360	418	S702  
08361	418	S702  
08362	418	S702  
08363	418	S702  
08364	418	S702  
08366	418	S702  
08368	418	S603  
08370	418	S603  
08371	418	S603  
08372	418	S603  
08374	418	S2664 
08376	418	S2664 
08380	418	S2664 
08383	418	S2664 
08384	418	S2664 
08385	418	S2664 
08387	418	S2664 
08394	418	S702  
08395	418	S702  
08396	418	S702  
08397	418	S603  
08398	418	S603  
08399	418	S603  
08400	418	S881  
08401	418	S881  
08402	418	S702  
08403	418	S1209 
08408	418	S2502 
08409	418	S2502 
08410	418	S702  
08411	418	S702  
08412	418	S702  
08413	418	S702  
08414	418	S702  
08415	418	S702  
08416	418	S702  
08417	418	S702  
08418	418	S702  
08419	418	S702  
08420	418	S702  
08421	418	S702  
08422	418	S702  
08435	418	S1065 
08436	418	S702  
08444	418	S702  
08446	418	S702  
08448	418	S702  
08449	418	S702  
08450	418	S702  
08454	418	S2664 
08455	418	S2664 
08456	418	S2664 
08457	418	S2664 
08458	418	S2664 
08459	418	S2664 
08460	418	S2664 
08465	418	S2664 
08466	418	S2664 
08468	418	S2664 
08469	418	S2664 
08470	418	S2664 
08471	418	S2664 
08472	418	S2664 
08473	418	S2664 
08474	418	S2664 
08476	418	S2502 
08478	418	S2502 
08481	418	S2502 
08484	418	S2502 
08487	418	S2502 
08490	418	S2502 
08491	418	S2502 
08493	418	S2502 
08494	418	S2502 
08495	418	S2502 
08498	418	S2502 
08500	418	S2502 
08501	418	S2502 
10007	418	S1082 
10066	418	S1082 
10067	418	S1082 
10068	418	S1082 
10098	418	S1581 
10099	418	S1581 
10102	418	S1581 
10119	418	S1581 
10123	418	S1082 
10124	418	S1082 
10173	418	S1581 
10858	418	S1082 
10860	418	S1082 
10861	418	S1082 
10862	418	S1082 
10863	418	S1581 
10864	418	S1082 
12220	418	S1221 
13019	418	S2    
13020	418	S2    
13055	418	S2    
13065	418	S2    
13067	418	S2    
13068	418	S2    
13070	418	S2    
13096	418	S2    
13098	418	S2    
13165	418	S2    
13318	418	S1581 
13320	418	S1581 
13321	418	S1581 
13322	418	S1581 
13323	418	S1581 
13324	418	S1581 
13325	418	S1082 
13326	418	S1082 
13327	418	S1082 
13340	418	S1581 
13341	418	S1581 
13343	418	S2    
13369	418	S2    
13370	418	S2    
13373	418	S2    
13375	418	S2    
13377	418	S2    
13378	418	S2    
13391	418	S2    
13394	418	S2    
13398	418	S2    
13399	418	S2    
13401	418	S2    
13402	418	S2    
13404	418	S2    
13405	418	S2    
13407	418	S2    
13408	418	S2    
13410	418	S2    
13411	418	S2    
13413	418	S2    
13414	418	S2    
13415	418	S2    
13416	418	S2    
13417	418	S2    
13418	418	S2    
13419	418	S2    
13420	418	S2    
13421	418	S2    
13422	418	S2    
13423	418	S2    
13424	418	S2    
13425	418	S2    
13426	418	S2    
13439	418	S2    
13440	418	S2    
13441	418	S2    
13442	418	S2    
13443	418	S2    
13444	418	S2    
13445	418	S2    
13446	418	S2    
13447	418	S2    
13448	418	S2    
13449	418	S2    
13450	418	S2    
13451	418	S2    
13452	418	S2    
13453	418	S2    
13454	418	S2    
13455	418	S2    
13456	418	S2    
13485	418	S2    
13486	418	S2    
13487	418	S2    
13488	418	S2    
13490	418	S2    
13491	418	S2    
13492	418	S2    
13493	418	S2    
13494	418	S14   
13495	418	S14   
13496	418	S14   
13497	418	S14   
13498	418	S14   
13565	418	S2703 
13566	418	S2703 
13567	418	S2703 
13568	418	S2703 
13569	418	S2703 
13805	418	S2    
13806	418	S2    
13809	418	S2    
13810	418	S2    
13811	418	S2    
13812	418	S2    
13813	418	S2    
13814	418	S2    
13850	418	S2    
13851	418	S2    
13853	418	S2    
13854	418	S2    
13856	418	S2    
13857	418	S2    
13868	418	S2    
13869	418	S2    
13870	418	S2    
13871	418	S2    
13872	418	S2    
13873	418	S2    
13874	418	S2    
13875	418	S2    
13876	418	S2    
13877	418	S2    
13878	418	S2    
13879	418	S2    
13880	418	S2    
13881	418	S2    
13882	418	S2    
13891	418	S2    
13893	418	S2    
13894	418	S2    
13896	418	S2    
13898	418	S2    
13900	418	S2    
13909	418	S2    
13910	418	S2    
13911	418	S2    
13912	418	S2    
13913	418	S2    
13914	418	S2    
13917	418	S2    
13918	418	S2    
13920	418	S2    
13921	418	S2    
13923	418	S2    
13924	418	S2    
13929	418	S2    
13930	418	S2    
13931	418	S2    
13932	418	S2    
13934	418	S2    
13935	418	S2    
13948	418	S2    
13949	418	S2    
13950	418	S2    
13951	418	S2    
13952	418	S2    
13953	418	S2    
13954	418	S2    
13955	418	S2    
13956	418	S2    
13957	418	S2    
13958	418	S2    
13959	418	S2    
13968	418	S2    
13969	418	S2    
13970	418	S2    
13971	418	S2    
13985	418	S2    
13988	418	S2703 
13989	418	S2703 
13990	418	S2703 
13991	418	S2703 
13992	418	S2703 
13994	418	S2703 
13995	418	S2703 
13996	418	S2703 
13997	418	S2703 
13998	418	S2703 
14006	418	S2103 
14084	418	S2103 
14096	418	S2103 
14106	418	S2103 
14154	418	S2702 
14156	418	S2702 
14347	418	S1064 
14347	418	S1122 
14461	418	S1164 
14462	418	S2109 
14602	418	S2103 
15027	418	S1163 
15073	418	S1163 
15078	418	S2621 
15087	418	S2109 
15152	418	S2104 
15232	418	S1163 
15260	418	S2109 
15261	418	S1163 
15262	418	S1163 
16010	418	S1164 
16011	418	S1164 
16112	418	S39   
16114	418	S39   
16123	418	S39   
16147	418	S2104 
16174	418	S18   
17202	418	S1082 
17203	418	S1082 
17204	418	S1082 
17218	418	S1581 
17219	418	S1581 
17332	418	S3    
17335	418	S3    
17340	418	S3    
17341	418	S3    
17345	418	S3    
17346	418	S3    
17347	418	S3    
17348	418	S3    
18069	418	S20   
18079	418	S25   
18215	418	S25   
18350	418	S21   
18365	418	S27   
18403	418	S27   
18927	418	S25   
18932	418	S27   
18933	418	S27   
18934	418	S27   
18935	418	S27   
19056	418	S26   
19064	418	S1164 
19076	418	S1164 
19109	418	S1164 
19155	418	S1164 
19802	418	S26   
20109	418	S2105 
20110	418	S2105 
20310	418	S2105 
20409	418	S2105 
20410	418	S2105 
20510	418	S2105 
21141	418	S1064 
21224	418	S19   
21225	418	S19   
21226	418	S22   
21227	418	S22   
21229	418	S1122 
21239	418	S1066 
21240	418	S1066 
21241	418	S1066 
21242	418	S1066 
21243	418	S1066 
21244	418	S1066 
21245	418	S1066 
21246	418	S1066 
21248	418	S1066 
21260	418	S1082 
21261	418	S1082 
21262	418	S1082 
21263	418	S1082 
21264	418	S1082 
21265	418	S1082 
21266	418	S1082 
21267	418	S1082 
21268	418	S1082 
21269	418	S1082 
21270	418	S1082 
21271	418	S2108 
21272	418	S2108 
21273	418	S2108 
21274	418	S2108 
21275	418	S2108 
21276	418	S2108 
21277	418	S2110 
21278	418	S2110 
21279	418	S2110 
21280	418	S2110 
21281	418	S2110 
21282	418	S2110 
21283	418	S2111 
21284	418	S2111 
21285	418	S2111 
21286	418	S2111 
21287	418	S2112 
21288	418	S2112 
21289	418	S2112 
21290	418	S2112 
21291	418	S2112 
21292	418	S2112 
21293	418	S2782 
21294	418	S2782 
21295	418	S2782 
21296	418	S2782 
21297	418	S2782 
21298	418	S2782 
21299	418	S2110 
21299	418	S2111 
21299	418	S2112 
21299	418	S2782 
21300	418	S2110 
21300	418	S2112 
21300	418	S2782 
21301	418	S2110 
21301	418	S2111 
21301	418	S2112 
21301	418	S2782 
21302	418	S2110 
21302	418	S2111 
21302	418	S2112 
21302	418	S2782 
21303	418	S2110 
21303	418	S2112 
21303	418	S2782 
21304	418	S2110 
21304	418	S2111 
21304	418	S2112 
21304	418	S2782 
21308	418	S2801 
21309	418	S2801 
21311	418	S2801 
21313	418	S2801 
21314	418	S2801 
21316	418	S2801 
21317	418	S2801 
21320	418	S2801 
21323	418	S2801 
21325	418	S2801 
21342	418	S2801 
21343	418	S2801 
21346	418	S2801 
21347	418	S2801 
21348	418	S2801 
21349	418	S2801 
22247	418	S20   
22903	418	S21   
22904	418	S18   
22909	418	S22   
22911	418	S18   
22912	418	S19   
22915	418	S19   
22916	418	S19   
23009	418	S2703 
23010	418	S2703 
23011	418	S2703 
23012	418	S2703 
23013	418	S2703 
23014	418	S2703 
23015	418	S2703 
23016	418	S2703 
23017	418	S2703 
23018	418	S2703 
23019	418	S2703 
23020	418	S2703 
23021	418	S2703 
23022	418	S2703 
23023	418	S2703 
23024	418	S2703 
23025	418	S2703 
23027	418	S2703 
23028	418	S2703 
23029	418	S2703 
23030	418	S2703 
23031	418	S2703 
23032	418	S2703 
23033	418	S2703 
23034	418	S2703 
23035	418	S2703 
23036	418	S2703 
23037	418	S2703 
23038	418	S2703 
23039	418	S2703 
23040	418	S2703 
23041	418	S2703 
23042	418	S2703 
23043	418	S2703 
23044	418	S2703 
23045	418	S2703 
23046	418	S2703 
23047	418	S2703 
23048	418	S2703 
23049	418	S2703 
23050	418	S2703 
23051	418	S2703 
23052	418	S2703 
23053	418	S2703 
23054	418	S2703 
23055	418	S2703 
23056	418	S2703 
23057	418	S2703 
23058	418	S2703 
23059	418	S2703 
23060	418	S2703 
23061	418	S2703 
23062	418	S2703 
23063	418	S2703 
23064	418	S2703 
23065	418	S2703 
23557	418	S14   
23558	418	S14   
23559	418	S14   
23560	418	S14   
23561	418	S14   
23562	418	S14   
23563	418	S14   
23564	418	S14   
23565	418	S14   
23566	418	S14   
23567	418	S14   
23568	418	S14   
23569	418	S14   
23570	418	S14   
23571	418	S14   
23572	418	S14   
23573	418	S14   
23574	418	S14   
23575	418	S14   
23576	418	S14   
23577	418	S14   
23578	418	S14   
23579	418	S14   
23580	418	S14   
23581	418	S14   
23582	418	S2    
23583	418	S2    
23584	418	S2    
23585	418	S2    
23586	418	S2    
23587	418	S2    
23588	418	S2    
23589	418	S2    
23590	418	S2    
23591	418	S2    
23592	418	S2    
23593	418	S2    
23594	418	S2    
23595	418	S2    
23596	418	S2    
23597	418	S2    
23598	418	S2    
23599	418	S2    
23600	418	S2    
23601	418	S2    
23602	418	S2    
23603	418	S2    
23604	418	S2    
23605	418	S2    
23606	418	S2    
23607	418	S2    
23608	418	S2    
23609	418	S2    
23610	418	S2    
23611	418	S2    
23612	418	S2    
23613	418	S2    
23614	418	S2    
23615	418	S2    
23616	418	S2    
23617	418	S2    
23618	418	S2    
23619	418	S2    
23620	418	S2    
23621	418	S2    
23622	418	S2    
23623	418	S2    
23624	418	S2    
23625	418	S2    
23626	418	S2    
23627	418	S2    
23628	418	S2    
23629	418	S2    
23630	418	S2    
23631	418	S2    
23632	418	S2    
23633	418	S2    
23634	418	S2    
23635	418	S2    
23636	418	S2    
23637	418	S2    
23638	418	S2    
23640	418	S1581 
23646	418	S2    
23647	418	S2    
23648	418	S2    
23649	418	S2    
23650	418	S2    
23651	418	S2    
23652	418	S2    
23653	418	S2    
23654	418	S2    
23655	418	S2    
23656	418	S2    
23657	418	S2    
23658	418	S2    
23659	418	S2    
23660	418	S2    
35003	418	D4961 
35051	418	D4961 
35078	418	D4961 
35141	418	S2381 
35142	418	S2381 
35144	418	S2381 
35145	418	S2381 
35146	418	S2381 
35147	418	S2381 
43215	418	S26   
43364	418	S26   
43378	418	S1082 
01009	430	D4002 
01009	430	S26   
01017	430	D4002 
01026	430	S25   
01029	430	S27   
01032	430	S19   
01040	430	S27   
01046	430	S19   
01049	430	D4002 
01056	430	D4002 
01077	430	S27   
01079	430	S1063 
01082	430	S1063 
01085	430	S1063 
01103	430	S1163 
01117	430	D4002 
01117	430	D4043 
01118	430	D4002 
01118	430	D4043 
01123	430	S1063 
01123	430	S561  
01124	430	S1065 
01125	430	S1065 
01145	430	D4002 
01202	430	S1163 
02003	430	S1069 
02009	430	S1069 
02010	430	S1069 
02011	430	S1069 
02015	430	S1069 
02020	430	S1069 
02021	430	S1069 
02024	430	S1069 
02026	430	S1069 
02027	430	S1069 
02028	430	S1069 
02029	430	S1069 
02030	430	S1069 
02033	430	S1069 
02043	430	S1069 
02044	430	S1069 
02046	430	D4002 
02050	430	D4048 
02053	430	D4048 
04017	430	S19   
04018	430	D4002 
04018	430	D4072 
04025	430	D4002 
04025	430	D4072 
04026	430	D4043 
04026	430	D4048 
04026	430	D4050 
04026	430	D4051 
04026	430	D4072 
04026	430	D4073 
04026	430	D4074 
04026	430	S19   
04034	430	D4043 
04034	430	D4048 
04034	430	D4050 
04034	430	D4051 
04034	430	D4072 
04034	430	D4073 
04034	430	D4074 
04034	430	S19   
04037	430	D4043 
04037	430	D4048 
04037	430	D4050 
04037	430	D4051 
04037	430	D4072 
04037	430	D4073 
04037	430	D4074 
04037	430	S19   
04038	430	D4043 
04038	430	D4048 
04038	430	D4050 
04038	430	D4051 
04038	430	D4072 
04038	430	D4073 
04038	430	D4074 
04038	430	S19   
04042	430	D4050 
04042	430	D4051 
04044	430	D4042 
04044	430	D4051 
04044	430	D4071 
04044	430	D4072 
04044	430	D4074 
04044	430	D4077 
04047	430	D4050 
04053	430	S19   
04055	430	D4050 
04058	430	D4050 
04058	430	D4051 
04060	430	D4043 
04060	430	D4050 
04060	430	D4051 
04060	430	D4071 
04060	430	D4073 
04120	430	S19   
04141	430	S19   
04501	430	D4043 
04501	430	D4048 
04501	430	D4050 
04501	430	D4051 
04501	430	D4072 
04501	430	D4073 
04501	430	D4074 
04501	430	S19   
04502	430	D4043 
04502	430	D4048 
04502	430	D4050 
04502	430	D4051 
04502	430	D4072 
04502	430	D4073 
04502	430	D4074 
04502	430	S19   
04506	430	D4043 
04506	430	D4050 
04506	430	D4051 
04506	430	D4071 
04506	430	D4073 
04510	430	D4048 
04510	430	D4050 
04510	430	D4051 
04513	430	D4043 
04513	430	D4048 
04513	430	D4050 
04513	430	D4051 
04513	430	D4072 
04513	430	D4073 
04513	430	D4074 
04513	430	S19   
04518	430	D4043 
04518	430	D4051 
04518	430	D4072 
04518	430	D4073 
04543	430	D4043 
04543	430	D4048 
04543	430	D4050 
04543	430	D4051 
04543	430	D4072 
04543	430	D4073 
04543	430	D4074 
04543	430	S19   
04545	430	D4043 
04545	430	D4050 
04545	430	D4051 
04545	430	D4071 
04545	430	D4073 
04582	430	D4042 
04582	430	D4051 
04582	430	D4071 
04582	430	D4072 
04584	430	D4043 
04584	430	D4050 
04584	430	D4051 
04584	430	D4071 
04584	430	D4073 
04588	430	D4043 
04588	430	D4048 
04588	430	D4050 
04588	430	D4051 
04588	430	D4072 
04588	430	D4073 
04588	430	D4074 
04588	430	S19   
04612	430	S19   
04613	430	S19   
04614	430	S19   
04619	430	S19   
04620	430	S19   
04624	430	S20   
04628	430	S18   
04630	430	S19   
04631	430	S20   
04635	430	S19   
04638	430	S26   
04639	430	S26   
04640	430	S26   
04673	430	S2401 
04674	430	S2401 
04675	430	S2401 
04676	430	S2401 
04677	430	S2401 
05023	430	S1581 
05024	430	S1581 
05027	430	S1082 
05028	430	S1082 
05028	430	S1166 
05173	430	S1581 
05174	430	S1581 
05175	430	S1581 
05176	430	S1581 
05177	430	S1581 
05178	430	S1581 
05661	430	S1082 
06164	430	S23   
06931	430	S22   
06984	430	S2104 
07007	430	S1164 
07063	430	S1164 
07064	430	S1164 
07075	430	S1164 
07952	430	S1164 
07953	430	S1164 
07954	430	S1164 
07955	430	S1164 
07956	430	S1164 
07957	430	S1164 
07958	430	S1164 
07959	430	S1164 
07960	430	S1164 
08001	430	S1065 
08012	430	S1065 
08013	430	S1065 
08014	430	S1065 
08020	430	S1065 
08025	430	S2662 
08030	430	S1065 
08061	430	S1065 
08065	430	S1065 
08065	430	S2662 
08074	430	S2662 
08077	430	S1065 
08084	430	D4068 
08120	430	D4043 
08120	430	D4048 
08120	430	D4068 
08120	430	D4073 
08147	430	S1065 
08218	430	S1065 
08259	430	S2662 
08435	430	S1065 
08504	430	S2662 
08505	430	S2662 
08506	430	S2662 
08507	430	S2662 
08508	430	S2662 
08509	430	S2662 
09003	430	S502  
09003	430	S561  
09004	430	S502  
09016	430	D4002 
09020	430	D4002 
09020	430	D4048 
09021	430	D4002 
09032	430	D4002 
09032	430	S21   
09037	430	S481  
09037	430	S502  
09038	430	S481  
09038	430	S502  
09040	430	D4002 
09040	430	D4048 
09040	430	S562  
09042	430	S461  
09042	430	S566  
09050	430	S421  
09050	430	S441  
09052	430	D4048 
09070	430	D4002 
09070	430	S582  
09078	430	S561  
09081	430	D4048 
09084	430	D4052 
09087	430	S564  
09087	430	S582  
09094	430	S363  
09094	430	S582  
09100	430	D4002 
09112	430	S482  
09112	430	S563  
09123	430	D4048 
09132	430	D4002 
09132	430	S1062 
09135	430	D4002 
09137	430	D4002 
09148	430	S363  
09148	430	S582  
09153	430	D4048 
09160	430	S1065 
09181	430	S1121 
09181	430	S461  
09184	430	S562  
09184	430	S565  
09191	430	S421  
09191	430	S582  
09193	430	D4002 
09194	430	D4002 
09200	430	D4002 
09200	430	D4048 
09200	430	S482  
09200	430	S564  
09202	430	S482  
09202	430	S564  
09214	430	S23   
09218	430	S1065 
09236	430	D4002 
09236	430	S582  
09252	430	S482  
09252	430	S541  
09253	430	D4002 
09253	430	D4048 
09254	430	D4002 
09254	430	D4048 
09256	430	D4002 
09256	430	D4048 
09257	430	D4002 
09257	430	D4048 
09266	430	S441  
09266	430	S561  
09268	430	D4002 
09275	430	D4002 
09279	430	D4002 
09279	430	S421  
09279	430	S582  
09291	430	S564  
09291	430	S566  
09294	430	D4002 
09298	430	D4002 
09298	430	S564  
09298	430	S566  
09302	430	S461  
09302	430	S566  
09316	430	D4002 
09316	430	S421  
09316	430	S566  
09326	430	D4002 
09326	430	S441  
09326	430	S461  
09421	430	S564  
09421	430	S582  
09429	430	S441  
09430	430	S441  
09430	430	S561  
09431	430	S2203 
09432	430	S2203 
09433	430	S2105 
10007	430	S1082 
10066	430	D1243 
10066	430	S1082 
10067	430	S1082 
10068	430	S1082 
10098	430	S1581 
10099	430	S1581 
10102	430	S1581 
10119	430	S1581 
10123	430	S1166 
10124	430	S1166 
10173	430	S1581 
10858	430	S1082 
10860	430	S1166 
10861	430	S1166 
10862	430	S1166 
10863	430	S1581 
11008	430	S565  
11011	430	S1069 
11012	430	S1069 
11090	430	S1121 
11090	430	S564  
11091	430	S1121 
11091	430	S564  
11096	430	S1121 
11096	430	S482  
11097	430	S482  
11112	430	S1065 
11113	430	S1065 
11124	430	S1062 
11125	430	S1062 
11130	430	S25   
11131	430	S25   
11143	430	D4002 
11143	430	S1121 
11143	430	S564  
11205	430	S1062 
11206	430	D4002 
11206	430	D4052 
11206	430	S1062 
11243	430	S2941 
11250	430	S562  
11250	430	S565  
11251	430	S481  
11251	430	S503  
11252	430	S481  
11252	430	S562  
11253	430	S541  
11253	430	S565  
11257	430	S541  
11257	430	S565  
11260	430	D4002 
11260	430	S2941 
11263	430	S2941 
11265	430	S2941 
11267	430	S2941 
11282	430	D4002 
11282	430	D4048 
11282	430	D4052 
11282	430	S1062 
11286	430	S1062 
11294	430	S563  
11294	430	S582  
11333	430	D4002 
11333	430	D4052 
11333	430	S1062 
11339	430	S1062 
11352	430	S563  
11352	430	S566  
11353	430	S563  
11353	430	S566  
11354	430	S563  
11354	430	S566  
11355	430	S563  
11355	430	S566  
11356	430	S563  
11356	430	S566  
11357	430	S563  
11357	430	S566  
11358	430	S563  
11358	430	S566  
11359	430	S2105 
11360	430	S2105 
11394	430	S2105 
11395	430	S2105 
11398	430	S2105 
11399	430	S2105 
11402	430	S2105 
11403	430	S2105 
11411	430	S2105 
11412	430	S2105 
11429	430	S1121 
11429	430	S363  
11463	430	S25   
11464	430	S25   
11507	430	S1062 
11508	430	D4002 
11508	430	S1062 
11510	430	S1062 
11529	430	D4002 
11529	430	D4052 
11529	430	D4066 
11529	430	D4072 
11529	430	S441  
11529	430	S503  
11530	430	S441  
11549	430	D4002 
11549	430	S21   
11578	430	D4041 
11674	430	D4002 
11674	430	S563  
11674	430	S566  
11702	430	S565  
11705	430	S1069 
11709	430	D4002 
11742	430	S1121 
11742	430	S564  
11752	430	S1065 
11757	430	S1062 
11760	430	S25   
11768	430	D4002 
11772	430	D4002 
11774	430	D4002 
11821	430	S1062 
11828	430	D4002 
11828	430	S563  
11828	430	S566  
11841	430	S2105 
11842	430	S2105 
11856	430	S25   
11875	430	D4002 
11875	430	S1062 
11876	430	S1062 
11884	430	S441  
11886	430	D4002 
11887	430	D4048 
11887	430	S21   
11888	430	S21   
11921	430	S1062 
11935	430	S22   
11949	430	S22   
11950	430	S2941 
11960	430	S481  
11960	430	S562  
11987	430	S2941 
11992	430	S2941 
12061	430	S441  
12061	430	S503  
12078	430	S1063 
12078	430	S503  
12086	430	S363  
12086	430	S502  
12120	430	S1063 
12120	430	S503  
12142	430	S1121 
12142	430	S363  
12147	430	S502  
12147	430	S564  
12152	430	S563  
12152	430	S565  
12155	430	S481  
12155	430	S563  
12201	430	S1164 
12220	430	S2109 
12586	430	S363  
12586	430	S502  
12632	430	S363  
12652	430	S563  
12652	430	S565  
13055	430	S2    
13065	430	S2    
13067	430	S2    
13068	430	S2    
13070	430	S2    
13096	430	S2    
13098	430	S2    
13165	430	S2    
13318	430	S1581 
13320	430	S1581 
13321	430	S1581 
13322	430	S1581 
13323	430	S1581 
13324	430	S1581 
13325	430	S1082 
13326	430	S1082 
13327	430	S1082 
13340	430	S1581 
13341	430	S1581 
13343	430	S2    
13369	430	S2    
13370	430	S2    
13373	430	S2    
13375	430	S2    
13377	430	S2    
13378	430	S2    
13391	430	S2    
13394	430	S2    
13398	430	S2    
13399	430	S2    
13401	430	S2    
13402	430	S2    
13404	430	S2    
13405	430	S2    
13407	430	S2    
13408	430	S2    
13410	430	S2    
13411	430	S2    
13413	430	S2    
13414	430	S2    
13415	430	S2    
13416	430	S2    
13417	430	S2    
13418	430	S2    
13419	430	S2    
13420	430	S2    
13421	430	S2    
13422	430	S2    
13423	430	S2    
13424	430	S2    
13425	430	S2    
13426	430	S2    
13439	430	S2    
13440	430	S2    
13441	430	S2    
13442	430	S2    
13443	430	S2    
13444	430	S2    
13445	430	S2    
13446	430	S2    
13447	430	S2    
13448	430	S2    
13449	430	S2    
13450	430	S2    
13451	430	S2    
13452	430	S2    
13453	430	S2    
13454	430	S2    
13455	430	S2    
13456	430	S2    
13485	430	S2    
13486	430	S2    
13487	430	S2    
13488	430	S2    
13490	430	S2    
13491	430	S2    
13492	430	S2    
13493	430	S2    
13497	430	S14   
13498	430	S14   
13565	430	S2703 
13567	430	S2703 
13805	430	S2    
13806	430	S2    
13809	430	S2    
13810	430	S2    
13811	430	S2    
13812	430	S2    
13813	430	S2    
13814	430	S2    
13850	430	S2    
13851	430	S2    
13853	430	S2    
13854	430	S2    
13856	430	S2    
13857	430	S2    
13868	430	S2    
13869	430	S2    
13870	430	S2    
13871	430	S2    
13872	430	S2    
13873	430	S2    
13874	430	S2    
13875	430	S2    
13876	430	S2    
13877	430	S2    
13878	430	S2    
13879	430	S2    
13880	430	S2    
13881	430	S2    
13882	430	S2    
13891	430	S2    
13893	430	S2    
13894	430	S2    
13896	430	S2    
13898	430	S2    
13900	430	S2    
13909	430	S2    
13910	430	S2    
13911	430	S2    
13912	430	S2    
13913	430	S2    
13914	430	S2    
13917	430	S2    
13918	430	S2    
13920	430	S2    
13921	430	S2    
13923	430	S2    
13924	430	S2    
13929	430	S2    
13930	430	S2    
13931	430	S2    
13932	430	S2    
13934	430	S2    
13935	430	S2    
13948	430	S2    
13949	430	S2    
13950	430	S2    
13951	430	S2    
13952	430	S2    
13953	430	S2    
13954	430	S2    
13955	430	S2    
13956	430	S2    
13957	430	S2    
13958	430	S2    
13959	430	S2    
13968	430	S2    
13969	430	S2    
13970	430	S2    
13971	430	S2    
13985	430	S2    
13988	430	S2703 
13989	430	S2703 
13992	430	S2703 
13994	430	S2703 
13997	430	S2703 
13998	430	S2703 
14003	430	S2103 
14006	430	S2103 
14057	430	D4048 
14084	430	D4072 
14143	430	D4048 
14149	430	D4002 
14149	430	D4048 
14166	430	D4002 
14166	430	D4048 
14209	430	D4002 
14209	430	D4048 
14209	430	D4069 
14209	430	D4072 
14219	430	D4002 
14267	430	D4002 
14347	430	S1122 
14355	430	D4069 
14400	430	D4002 
14400	430	D4048 
14416	430	D4002 
14416	430	D4048 
15015	430	D4072 
15027	430	S1163 
15066	430	D4072 
15073	430	S1163 
15087	430	S2109 
15119	430	D4002 
15119	430	D4072 
15121	430	S27   
15126	430	D4072 
15149	430	D4002 
15152	430	D4002 
15232	430	S1163 
15260	430	S2109 
15261	430	S1163 
15262	430	S1163 
16006	430	S1164 
16010	430	S1164 
16011	430	S1164 
16028	430	D4002 
16029	430	S1164 
16037	430	S1164 
16038	430	S1164 
16042	430	S1065 
16043	430	D4002 
16043	430	S1065 
16089	430	S563  
16097	430	S22   
16098	430	D4002 
16098	430	S22   
16147	430	S2104 
16167	430	S2203 
16338	430	S1164 
16343	430	D4002 
16343	430	S1065 
16397	430	S22   
16398	430	D4002 
16398	430	S22   
17202	430	S1082 
17203	430	D463  
17203	430	S1082 
17204	430	S1082 
17218	430	S1581 
17219	430	S1581 
18001	430	S1162 
18002	430	S1162 
18079	430	S25   
18159	430	S21   
18166	430	S25   
18215	430	S25   
18228	430	S23   
18231	430	S25   
18258	430	S1162 
18259	430	S1162 
18262	430	S1162 
18263	430	S1162 
18288	430	S27   
18363	430	S22   
18364	430	S22   
18365	430	S27   
18376	430	S25   
18403	430	S27   
18927	430	S25   
18930	430	S2203 
18932	430	S27   
18933	430	S27   
18934	430	S27   
18935	430	S27   
18936	430	S27   
19003	430	S26   
19056	430	S26   
19057	430	S2109 
19058	430	S2109 
19064	430	S1164 
19076	430	S1164 
19078	430	S1069 
19095	430	D4002 
19109	430	S1164 
19120	430	S1069 
19129	430	D4002 
19155	430	S1164 
19230	430	S1063 
19283	430	D4002 
19296	430	D4002 
19296	430	D4048 
19335	430	D4002 
19335	430	D4048 
19411	430	S26   
20045	430	D4002 
20045	430	D4048 
20045	430	S1164 
20061	430	D4048 
20063	430	D4068 
20080	430	D4048 
20080	430	D4068 
20081	430	S20   
20099	430	D4048 
20099	430	S1163 
20100	430	D4002 
20100	430	S1163 
20100	430	S20   
20109	430	S2105 
20110	430	D4002 
20110	430	S2105 
20120	430	D4048 
20120	430	S1163 
20121	430	D4002 
20121	430	S1163 
20121	430	S20   
20130	430	D4068 
20310	430	D4002 
20310	430	S2105 
20321	430	D4002 
20321	430	S1163 
20321	430	S20   
20400	430	D4002 
20400	430	S1163 
20400	430	S20   
20409	430	S2105 
20410	430	D4002 
20410	430	S2105 
20420	430	D4048 
20420	430	S1163 
20421	430	D4002 
20421	430	S1163 
20421	430	S20   
20499	430	D4048 
20499	430	S1163 
20510	430	D4002 
20510	430	S2105 
20521	430	D4002 
20521	430	S1163 
20521	430	S20   
21138	430	S1064 
21138	430	S1066 
21138	430	S1122 
21229	430	S1122 
21239	430	S1066 
21240	430	S1066 
21241	430	S1066 
21242	430	S1066 
21243	430	S1066 
21244	430	S1066 
21245	430	S1066 
21246	430	S1066 
21247	430	S1066 
21248	430	S1066 
21249	430	S1064 
21250	430	S1064 
21251	430	S1064 
21252	430	S1064 
21253	430	S1064 
21254	430	S1064 
21255	430	S1064 
21256	430	S1064 
21257	430	S1064 
21259	430	S1064 
21260	430	S1082 
21261	430	S1082 
21262	430	S1082 
21263	430	S1082 
21264	430	S1082 
21265	430	S1082 
21266	430	S1082 
21267	430	S1082 
21268	430	S1082 
21269	430	S1082 
21270	430	S1082 
21271	430	S2108 
21272	430	S2108 
21273	430	S2108 
21274	430	S2108 
21275	430	S2108 
21276	430	S2108 
21277	430	S2110 
21278	430	S2110 
21279	430	S2110 
21280	430	S2110 
21281	430	S2110 
21282	430	S2110 
21283	430	S2111 
21284	430	S2111 
21285	430	S2111 
21286	430	S2111 
21287	430	S2112 
21288	430	S2112 
21289	430	S2112 
21290	430	S2112 
21291	430	S2112 
21292	430	S2112 
21293	430	S2782 
21294	430	S2782 
21295	430	S2782 
21296	430	S2782 
21297	430	S2782 
21298	430	S2782 
21299	430	S2110 
21299	430	S2111 
21299	430	S2112 
21299	430	S2782 
21300	430	S2110 
21300	430	S2112 
21300	430	S2782 
21301	430	S2110 
21301	430	S2111 
21301	430	S2112 
21301	430	S2782 
21302	430	S2110 
21302	430	S2111 
21302	430	S2112 
21302	430	S2782 
21303	430	S2110 
21303	430	S2112 
21303	430	S2782 
21304	430	S2110 
21304	430	S2111 
21304	430	S2112 
21304	430	S2782 
22909	430	S22   
22912	430	S19   
22914	430	S19   
23011	430	S2703 
23014	430	S2703 
23015	430	S2703 
23019	430	S2703 
23020	430	S2703 
23021	430	S2703 
23022	430	S2703 
23023	430	S2703 
23024	430	S2703 
23025	430	S2703 
23027	430	S2703 
23028	430	S2703 
23029	430	S2703 
23030	430	S2703 
23031	430	S2703 
23035	430	S2703 
23037	430	S2703 
23038	430	S2703 
23041	430	S2703 
23042	430	S2703 
23045	430	S2703 
23046	430	S2703 
23049	430	S2703 
23050	430	S2703 
23054	430	S2703 
23055	430	S2703 
23056	430	S2703 
23057	430	S2703 
23058	430	S2703 
23059	430	S2703 
23060	430	S2703 
23061	430	S2703 
23062	430	S2703 
23063	430	S2703 
23064	430	S2703 
23557	430	S14   
23558	430	S14   
23562	430	S14   
23563	430	S14   
23567	430	S14   
23568	430	S14   
23572	430	S14   
23573	430	S14   
23577	430	S14   
23578	430	S14   
23582	430	S2    
23583	430	S2    
23584	430	S2    
23585	430	S2    
23586	430	S2    
23587	430	S2    
23588	430	S2    
23589	430	S2    
23590	430	S2    
23591	430	S2    
23592	430	S2    
23593	430	S2    
23594	430	S2    
23595	430	S2    
23596	430	S2    
23597	430	S2    
23598	430	S2    
23599	430	S2    
23600	430	S2    
23601	430	S2    
23602	430	S2    
23603	430	S2    
23604	430	S2    
23605	430	S2    
23606	430	S2    
23607	430	S2    
23608	430	S2    
23609	430	S2    
23610	430	S2    
23611	430	S2    
23612	430	S2    
23613	430	S2    
23614	430	S2    
23615	430	S2    
23616	430	S2    
23617	430	S2    
23618	430	S2    
23619	430	S2    
23620	430	S2    
23621	430	S2    
23622	430	S2    
23623	430	S2    
23624	430	S2    
23625	430	S2    
23626	430	S2    
23627	430	S2    
23628	430	S2    
23629	430	S2    
23630	430	S2    
23631	430	S2    
23632	430	S2    
23633	430	S2    
23634	430	S2    
23635	430	S2    
23636	430	S2    
23637	430	S2    
23638	430	S2    
23640	430	S1581 
23646	430	S2    
23647	430	S2    
23648	430	S2    
23649	430	S2    
23650	430	S2    
23651	430	S2    
23652	430	S2    
23653	430	S2    
23654	430	S2    
23655	430	S2    
23656	430	S2    
23657	430	S2    
23658	430	S2    
23659	430	S2    
23660	430	S2    
35130	430	S2381 
35131	430	S2381 
35132	430	S2381 
35133	430	S2381 
35134	430	S2381 
35135	430	S2381 
35136	430	S2381 
35137	430	S2381 
35140	430	S2381 
35142	430	S2381 
35143	430	S2381 
35144	430	S2381 
35145	430	S2381 
35146	430	S2381 
35148	430	S2381 
43215	430	S26   
43364	430	S26   
43378	430	S1166 
04641	431	S25   
07007	431	S1164 
07952	431	S1164 
07958	431	S1164 
07959	431	S1164 
07960	431	S1164 
08083	431	S2502 
08116	431	S2502 
08138	431	S2502 
08177	431	S2502 
08206	431	S2502 
08346	431	S2502 
08347	431	S2502 
08348	431	S2502 
08349	431	S2502 
08350	431	S2502 
08408	431	S2502 
08409	431	S2502 
08476	431	S2502 
08478	431	S2502 
08481	431	S2502 
08482	431	S2502 
08484	431	S2502 
08487	431	S2502 
08488	431	S2502 
08489	431	S2502 
08490	431	S2502 
08491	431	S2502 
08493	431	S2502 
08494	431	S2502 
08495	431	S2502 
08497	431	S2502 
08498	431	S2502 
08500	431	S2502 
08501	431	S2502 
14209	431	S1064 
14209	431	S1066 
14347	431	S1122 
15027	431	S1163 
18001	431	S1162 
18002	431	S1162 
18069	431	S20   
18166	431	S25   
18258	431	S1162 
18259	431	S1162 
18262	431	S1162 
18263	431	S1162 
18351	431	S20   
18352	431	S20   
18365	431	S27   
18403	431	S27   
18416	431	S20   
18932	431	S27   
18933	431	S27   
18934	431	S27   
18935	431	S27   
18936	431	S27   
19047	431	S1162 
19064	431	S1164 
19076	431	S1164 
19109	431	S1164 
19155	431	S1164 
20046	431	S20   
20047	431	S20   
20048	431	S20   
20049	431	S20   
20081	431	S20   
20082	431	S20   
20083	431	S20   
20084	431	S20   
20581	431	S20   
21229	431	S1122 
21250	431	S1064 
21252	431	S1064 
21253	431	S1064 
21254	431	S1064 
21255	431	S1064 
21256	431	S1064 
21257	431	S1064 
21259	431	S1064 
21260	431	S1082 
21261	431	S1082 
21262	431	S1082 
21263	431	S1082 
21264	431	S1082 
21265	431	S1082 
21266	431	S1082 
21267	431	S1082 
21268	431	S1082 
21269	431	S1082 
21270	431	S1082 
21283	431	S2111 
21284	431	S2111 
21285	431	S2111 
21293	431	S2782 
21294	431	S2782 
21295	431	S2782 
21296	431	S2782 
21297	431	S2782 
21298	431	S2782 
21299	431	S2111 
21299	431	S2782 
21300	431	S2782 
21301	431	S2782 
21302	431	S2111 
21302	431	S2782 
21303	431	S2782 
21304	431	S2111 
21304	431	S2782 
35136	431	S2381 
35137	431	S2381 
35142	431	S2381 
35143	431	S2381 
43329	431	S25   
14347	432	S1122 
15027	432	S1163 
18001	432	S1162 
18002	432	S1162 
18069	432	S20   
18168	432	S25   
18258	432	S1162 
18259	432	S1162 
18262	432	S1162 
18263	432	S1162 
18351	432	S20   
18352	432	S20   
18365	432	S27   
18403	432	S27   
18416	432	S20   
18932	432	S27   
18933	432	S27   
18934	432	S27   
18935	432	S27   
18936	432	S27   
19047	432	S1162 
19064	432	S1164 
19076	432	S1164 
19109	432	S1164 
19155	432	S1164 
20046	432	S20   
20047	432	S20   
20048	432	S20   
20049	432	S20   
20081	432	S20   
20082	432	S20   
20083	432	S20   
20084	432	S20   
20446	432	S20   
20447	432	S20   
20581	432	S20   
21229	432	S1122 
21250	432	S1064 
21252	432	S1064 
21253	432	S1064 
21254	432	S1064 
21255	432	S1064 
21256	432	S1064 
21257	432	S1064 
21259	432	S1064 
21260	432	S1082 
21261	432	S1082 
21262	432	S1082 
21263	432	S1082 
21264	432	S1082 
21265	432	S1082 
21266	432	S1082 
21267	432	S1082 
21268	432	S1082 
21269	432	S1082 
21270	432	S1082 
21283	432	S2111 
21284	432	S2111 
21285	432	S2111 
21293	432	S2782 
21294	432	S2782 
21295	432	S2782 
21296	432	S2782 
21297	432	S2782 
21298	432	S2782 
21299	432	S2111 
21299	432	S2782 
21300	432	S2782 
21301	432	S2782 
21302	432	S2111 
21302	432	S2782 
21303	432	S2782 
21304	432	S2111 
21304	432	S2782 
23557	432	S14   
23558	432	S14   
23560	432	S14   
23561	432	S14   
23562	432	S14   
23563	432	S14   
23565	432	S14   
23566	432	S14   
23567	432	S14   
23568	432	S14   
23570	432	S14   
23571	432	S14   
23572	432	S14   
23573	432	S14   
23575	432	S14   
23576	432	S14   
23577	432	S14   
23578	432	S14   
23580	432	S14   
23581	432	S14   
35136	432	S2381 
35137	432	S2381 
35142	432	S2381 
35143	432	S2381 
01026	501	S27   
01029	501	S27   
01032	501	S19   
01046	501	S19   
01077	501	S27   
01079	501	S1063 
01079	501	S20   
01082	501	S1063 
01085	501	S1063 
01103	501	S1163 
01123	501	S1063 
01123	501	S561  
01124	501	S1065 
01125	501	S1065 
01128	501	S1063 
01128	501	S561  
01130	501	S1063 
01130	501	S561  
01131	501	S1063 
01131	501	S561  
01202	501	S1163 
04017	501	S19   
04023	501	S19   
04114	501	S19   
04640	501	S26   
05027	501	S1082 
05028	501	S1082 
05312	501	S26   
05313	501	S26   
05320	501	S26   
05661	501	S1082 
06019	501	S18   
06128	501	S18   
06982	501	S18   
06983	501	S18   
06984	501	S2104 
06985	501	S2104 
07005	501	S248  
07015	501	S248  
07016	501	S248  
07022	501	S2    
07063	501	S1164 
07063	501	S582  
07945	501	S2    
07949	501	S2    
07950	501	S2    
07953	501	S1164 
07953	501	S582  
07954	501	S582  
07955	501	S1164 
07956	501	S1164 
07957	501	S1164 
07958	501	S1164 
07960	501	S1164 
08001	501	S1065 
08012	501	S1065 
08013	501	S1065 
08014	501	S1065 
08020	501	S1065 
08025	501	S2662 
08030	501	S1065 
08061	501	S1065 
08065	501	S1065 
08065	501	S2662 
08074	501	S2662 
08077	501	S1065 
08147	501	S1065 
08218	501	S1065 
08259	501	S2662 
08504	501	S2662 
08505	501	S2662 
08506	501	S2662 
08507	501	S2662 
08508	501	S2662 
08509	501	S2662 
09003	501	S561  
09004	501	S561  
09032	501	S21   
09033	501	S21   
09038	501	S481  
09038	501	S502  
09040	501	S481  
09040	501	S562  
09070	501	S582  
09078	501	S561  
09087	501	S564  
09087	501	S582  
09094	501	S363  
09094	501	S582  
09095	501	S363  
09095	501	S582  
09111	501	S482  
09111	501	S563  
09112	501	S482  
09112	501	S563  
09114	501	S482  
09114	501	S563  
09116	501	S482  
09116	501	S563  
09117	501	S482  
09117	501	S563  
09118	501	S482  
09118	501	S563  
09120	501	S482  
09120	501	S563  
09121	501	S482  
09121	501	S563  
09132	501	S1062 
09148	501	S363  
09148	501	S582  
09160	501	S1065 
09181	501	S1121 
09184	501	S562  
09184	501	S565  
09191	501	S421  
09191	501	S582  
09202	501	S482  
09202	501	S564  
09218	501	S1065 
09236	501	S582  
09252	501	S541  
09266	501	S441  
09266	501	S561  
09279	501	S582  
09291	501	S564  
09291	501	S566  
09298	501	S564  
09298	501	S566  
09421	501	S564  
09421	501	S582  
10007	501	S1082 
10066	501	S1082 
10067	501	S1082 
10068	501	S1082 
10123	501	S1082 
10124	501	S1082 
10858	501	S1082 
10860	501	S1082 
10861	501	S1082 
10862	501	S1082 
11090	501	S1121 
11090	501	S564  
11096	501	S1121 
11096	501	S482  
11097	501	S1121 
11097	501	S482  
11112	501	S1065 
11243	501	S2941 
11260	501	S2941 
11263	501	S2941 
11265	501	S2941 
11294	501	S563  
11294	501	S582  
11339	501	S1062 
11353	501	S563  
11353	501	S566  
11354	501	S563  
11354	501	S566  
11357	501	S563  
11357	501	S566  
11359	501	S2105 
11360	501	S2105 
11394	501	S2105 
11395	501	S2105 
11398	501	S2105 
11399	501	S2105 
11402	501	S2105 
11403	501	S2105 
11411	501	S2105 
11463	501	S25   
11464	501	S25   
11856	501	S25   
11921	501	S1062 
11950	501	S2941 
11987	501	S2941 
11992	501	S2941 
12006	501	S1782 
12061	501	S141  
12062	501	S141  
12063	501	S141  
12065	501	S141  
12078	501	S1063 
12078	501	S503  
12086	501	S363  
12086	501	S502  
12087	501	S363  
12087	501	S502  
12120	501	S83   
12121	501	S83   
12122	501	S83   
12131	501	S77   
12132	501	S77   
12142	501	S85   
12143	501	S85   
12144	501	S85   
12147	501	S502  
12147	501	S564  
12151	501	S86   
12152	501	S86   
12154	501	S1001 
12155	501	S79   
12201	501	S1164 
12220	501	D4743 
12220	501	S2109 
12563	501	S141  
12565	501	S141  
12586	501	S363  
12586	501	S502  
12632	501	S77   
12643	501	S85   
12644	501	S85   
12652	501	S86   
13004	501	S14   
13004	501	S2    
13011	501	S14   
13011	501	S2    
13012	501	S14   
13012	501	S2    
13019	501	S14   
13019	501	S2    
13020	501	S14   
13020	501	S2    
13022	501	S14   
13022	501	S2    
13024	501	S14   
13024	501	S2    
13039	501	S2    
13052	501	S14   
13052	501	S2    
13055	501	S14   
13055	501	S2    
13058	501	S14   
13058	501	S2    
13060	501	S14   
13060	501	S2    
13061	501	S14   
13061	501	S2    
13062	501	S14   
13062	501	S2    
13065	501	S14   
13065	501	S2    
13067	501	S14   
13067	501	S2    
13068	501	S14   
13068	501	S2    
13069	501	S14   
13069	501	S2    
13070	501	S14   
13070	501	S2    
13072	501	S14   
13072	501	S2    
13088	501	S14   
13088	501	S2    
13092	501	S14   
13092	501	S2    
13096	501	S14   
13096	501	S2    
13098	501	S14   
13098	501	S2    
13113	501	S14   
13113	501	S2    
13143	501	S14   
13143	501	S2    
13148	501	S14   
13148	501	S2    
13150	501	S14   
13150	501	S2    
13151	501	S14   
13151	501	S2    
13152	501	S14   
13152	501	S2    
13155	501	S14   
13155	501	S2    
13156	501	S14   
13156	501	S2    
13165	501	S14   
13165	501	S2    
13192	501	S14   
13192	501	S2    
13194	501	S14   
13194	501	S2    
13196	501	S14   
13196	501	S2    
13200	501	S14   
13200	501	S2    
13202	501	S14   
13202	501	S2    
13204	501	S14   
13204	501	S2    
13211	501	S14   
13211	501	S2    
13220	501	S14   
13220	501	S2    
13231	501	S2    
13232	501	S2    
13235	501	S2    
13236	501	S2    
13260	501	S14   
13260	501	S2    
13281	501	S14   
13281	501	S2    
13290	501	S14   
13290	501	S2    
13325	501	S1082 
13326	501	S1082 
13327	501	S1082 
13335	501	S14   
13335	501	S2    
13343	501	S14   
13343	501	S2    
13347	501	S14   
13347	501	S2    
13361	501	S14   
13361	501	S2    
13364	501	S14   
13364	501	S2    
13367	501	S14   
13367	501	S2    
13368	501	S14   
13368	501	S2    
13369	501	S14   
13369	501	S2    
13370	501	S14   
13370	501	S2    
13373	501	S14   
13373	501	S2    
13375	501	S14   
13375	501	S2    
13377	501	S14   
13377	501	S2    
13378	501	S14   
13378	501	S2    
13382	501	S14   
13382	501	S2    
13388	501	S14   
13388	501	S2    
13391	501	S14   
13391	501	S2    
13394	501	S14   
13394	501	S2    
13398	501	S14   
13398	501	S2    
13399	501	S14   
13399	501	S2    
13401	501	S14   
13401	501	S2    
13402	501	S14   
13402	501	S2    
13404	501	S14   
13404	501	S2    
13405	501	S14   
13405	501	S2    
13407	501	S14   
13407	501	S2    
13408	501	S14   
13408	501	S2    
13410	501	S14   
13410	501	S2    
13411	501	S14   
13411	501	S2    
13413	501	S14   
13413	501	S2    
13414	501	S14   
13414	501	S2    
13415	501	S14   
13415	501	S2    
13416	501	S14   
13416	501	S2    
13417	501	S14   
13417	501	S2    
13419	501	S14   
13419	501	S2    
13420	501	S14   
13420	501	S2    
13421	501	S14   
13421	501	S2    
13422	501	S14   
13422	501	S2    
13423	501	S14   
13423	501	S2    
13424	501	S14   
13424	501	S2    
13425	501	S14   
13425	501	S2    
13426	501	S14   
13426	501	S2    
13427	501	S14   
13427	501	S2    
13428	501	S14   
13428	501	S2    
13431	501	S14   
13431	501	S2    
13433	501	S14   
13433	501	S2    
13434	501	S14   
13434	501	S2    
13439	501	S14   
13439	501	S2    
13440	501	S14   
13440	501	S2    
13441	501	S14   
13441	501	S2    
13443	501	S14   
13443	501	S2    
13444	501	S14   
13444	501	S2    
13445	501	S14   
13445	501	S2    
13446	501	S14   
13446	501	S2    
13447	501	S14   
13447	501	S2    
13448	501	S14   
13448	501	S2    
13449	501	S14   
13449	501	S2    
13450	501	S14   
13450	501	S2    
13451	501	S14   
13451	501	S2    
13452	501	S14   
13452	501	S2    
13453	501	S14   
13453	501	S2    
13454	501	S14   
13454	501	S2    
13455	501	S14   
13455	501	S2    
13456	501	S14   
13456	501	S2    
13467	501	S2    
13468	501	S2    
13469	501	S2    
13470	501	S2    
13481	501	S2    
13482	501	S2    
13483	501	S2    
13484	501	S2    
13485	501	S14   
13485	501	S2    
13486	501	S14   
13486	501	S2    
13487	501	S14   
13487	501	S2    
13488	501	S14   
13488	501	S2    
13490	501	S14   
13490	501	S2    
13491	501	S14   
13491	501	S2    
13492	501	S14   
13492	501	S2    
13493	501	S14   
13493	501	S2    
13494	501	S14   
13495	501	S14   
13496	501	S14   
13497	501	S14   
13498	501	S14   
13565	501	S14   
13565	501	S2    
13566	501	S14   
13566	501	S2    
13567	501	S14   
13567	501	S2    
13568	501	S14   
13568	501	S2    
13569	501	S14   
13569	501	S2    
13805	501	S14   
13805	501	S2    
13806	501	S14   
13806	501	S2    
13809	501	S14   
13809	501	S2    
13810	501	S14   
13810	501	S2    
13811	501	S14   
13811	501	S2    
13812	501	S14   
13812	501	S2    
13813	501	S14   
13813	501	S2    
13814	501	S14   
13814	501	S2    
13850	501	S14   
13850	501	S2    
13851	501	S14   
13851	501	S2    
13853	501	S14   
13853	501	S2    
13854	501	S14   
13854	501	S2    
13856	501	S14   
13856	501	S2    
13857	501	S14   
13857	501	S2    
13868	501	S14   
13868	501	S2    
13869	501	S14   
13869	501	S2    
13870	501	S14   
13870	501	S2    
13871	501	S14   
13871	501	S2    
13872	501	S14   
13872	501	S2    
13873	501	S14   
13873	501	S2    
13874	501	S14   
13874	501	S2    
13875	501	S14   
13875	501	S2    
13876	501	S14   
13876	501	S2    
13877	501	S14   
13877	501	S2    
13878	501	S14   
13878	501	S2    
13879	501	S14   
13879	501	S2    
13880	501	S14   
13880	501	S2    
13881	501	S14   
13881	501	S2    
13882	501	S14   
13882	501	S2    
13891	501	S14   
13891	501	S2    
13893	501	S14   
13893	501	S2    
13894	501	S14   
13894	501	S2    
13896	501	S14   
13896	501	S2    
13898	501	S14   
13898	501	S2    
13900	501	S14   
13900	501	S2    
13909	501	S14   
13909	501	S2    
13910	501	S14   
13910	501	S2    
13911	501	S14   
13911	501	S2    
13912	501	S14   
13912	501	S2    
13913	501	S14   
13913	501	S2    
13914	501	S14   
13914	501	S2    
13917	501	S14   
13917	501	S2    
13918	501	S14   
13918	501	S2    
13920	501	S14   
13920	501	S2    
13921	501	S14   
13921	501	S2    
13923	501	S14   
13923	501	S2    
13924	501	S14   
13924	501	S2    
13929	501	S14   
13929	501	S2    
13930	501	S14   
13930	501	S2    
13931	501	S14   
13931	501	S2    
13932	501	S14   
13932	501	S2    
13934	501	S14   
13934	501	S2    
13935	501	S14   
13935	501	S2    
13936	501	S2    
13937	501	S2    
13938	501	S2    
13939	501	S2    
13940	501	S2    
13941	501	S2    
13942	501	S2    
13943	501	S2    
13944	501	S2    
13945	501	S2    
13946	501	S2    
13947	501	S2    
13948	501	S14   
13948	501	S2    
13949	501	S14   
13949	501	S2    
13950	501	S14   
13950	501	S2    
13951	501	S14   
13951	501	S2    
13952	501	S14   
13952	501	S2    
13953	501	S14   
13953	501	S2    
13954	501	S14   
13954	501	S2    
13955	501	S14   
13955	501	S2    
13956	501	S14   
13956	501	S2    
13957	501	S14   
13957	501	S2    
13958	501	S14   
13958	501	S2    
13959	501	S14   
13959	501	S2    
13960	501	S2    
13961	501	S2    
13962	501	S2    
13963	501	S2    
13964	501	S2    
13965	501	S2    
13966	501	S2    
13967	501	S2    
13968	501	S14   
13968	501	S2    
13969	501	S14   
13969	501	S2    
13970	501	S14   
13970	501	S2    
13971	501	S14   
13971	501	S2    
13976	501	S2    
13977	501	S2    
13978	501	S2    
13979	501	S2    
13985	501	S14   
13985	501	S2    
13987	501	S2    
13988	501	S14   
13988	501	S2    
13989	501	S14   
13989	501	S2    
13990	501	S14   
13990	501	S2    
13991	501	S14   
13991	501	S2    
13992	501	S14   
13992	501	S2    
13994	501	S14   
13994	501	S2    
13995	501	S14   
13995	501	S2    
13996	501	S14   
13996	501	S2    
13997	501	S14   
13997	501	S2    
13998	501	S14   
13998	501	S2    
14003	501	S2103 
14006	501	S2103 
14347	501	S1064 
14347	501	S1122 
15073	501	S1163 
15087	501	S2109 
15152	501	S2104 
15232	501	S1163 
15260	501	S2109 
15261	501	S1163 
15262	501	S1163 
16006	501	S1164 
16011	501	S1164 
16037	501	S1164 
16038	501	S1164 
16042	501	S1065 
16089	501	S563  
16114	501	S39   
16120	501	S39   
16139	501	S39   
16147	501	S2104 
16338	501	S1164 
17202	501	S1082 
17203	501	S1082 
17204	501	S1082 
18166	501	S25   
19064	501	S1164 
19078	501	S1069 
19109	501	S1164 
19155	501	S1164 
19337	501	S2109 
20046	501	S1164 
20046	501	S20   
20047	501	S1164 
20047	501	S20   
20048	501	S1164 
20048	501	S20   
20049	501	S1164 
20049	501	S20   
20099	501	S1163 
20099	501	S20   
20100	501	S1163 
20100	501	S20   
20109	501	S2105 
20110	501	S2105 
20120	501	S1163 
20120	501	S20   
20121	501	S1163 
20121	501	S20   
20310	501	S2105 
20321	501	S1163 
20321	501	S20   
20400	501	S1163 
20400	501	S20   
20409	501	S2105 
20410	501	S2105 
20420	501	S1163 
20420	501	S20   
20421	501	S1163 
20421	501	S20   
20446	501	S1164 
20446	501	S20   
20447	501	S1164 
20447	501	S20   
20499	501	S1163 
20499	501	S20   
20510	501	S2105 
20521	501	S1163 
20521	501	S20   
20623	501	S1742 
20624	501	S1742 
20628	501	S1742 
20629	501	S1742 
20630	501	S1742 
20634	501	S1742 
20635	501	S1742 
20636	501	S1742 
20640	501	S1742 
20641	501	S1742 
20645	501	S1742 
20646	501	S1742 
21138	501	S1064 
21138	501	S1066 
21138	501	S1122 
21224	501	S19   
21225	501	S19   
21229	501	S1122 
21239	501	S1066 
21240	501	S1066 
21241	501	S1066 
21242	501	S1066 
21243	501	S1066 
21244	501	S1066 
21245	501	S1066 
21246	501	S1066 
21247	501	S1066 
21248	501	S1066 
21249	501	S1064 
21250	501	S1064 
21251	501	S1064 
21252	501	S1064 
21253	501	S1064 
21254	501	S1064 
21255	501	S1064 
21256	501	S1064 
21257	501	S1064 
21259	501	S1064 
21260	501	S1082 
21261	501	S1082 
21262	501	S1082 
21263	501	S1082 
21264	501	S1082 
21265	501	S1082 
21266	501	S1082 
21267	501	S1082 
21268	501	S1082 
21269	501	S1082 
21270	501	S1082 
21271	501	S2108 
21272	501	S2108 
21273	501	S2108 
21274	501	S2108 
21275	501	S2108 
21276	501	S2108 
21278	501	S2110 
21279	501	S2110 
21280	501	S2110 
21281	501	S2110 
21282	501	S2110 
21285	501	S2111 
21286	501	S2111 
21289	501	S2112 
21290	501	S2112 
21291	501	S2112 
21292	501	S2112 
21295	501	S2782 
21298	501	S2782 
21299	501	S2108 
21300	501	S2108 
21300	501	S2110 
21300	501	S2112 
21301	501	S2108 
21301	501	S2110 
21301	501	S2111 
21301	501	S2112 
21301	501	S2782 
21302	501	S2108 
21303	501	S2108 
21303	501	S2110 
21303	501	S2112 
21304	501	S2108 
21304	501	S2110 
21304	501	S2111 
21304	501	S2112 
21304	501	S2782 
23009	501	S14   
23009	501	S2    
23010	501	S14   
23010	501	S2    
23011	501	S14   
23011	501	S2    
23012	501	S14   
23012	501	S2    
23013	501	S14   
23013	501	S2    
23014	501	S14   
23014	501	S2    
23015	501	S14   
23015	501	S2    
23016	501	S14   
23016	501	S2    
23017	501	S14   
23017	501	S2    
23018	501	S14   
23018	501	S2    
23019	501	S14   
23019	501	S2    
23020	501	S14   
23020	501	S2    
23021	501	S14   
23021	501	S2    
23022	501	S14   
23022	501	S2    
23023	501	S14   
23023	501	S2    
23024	501	S14   
23024	501	S2    
23025	501	S14   
23025	501	S2    
23027	501	S14   
23027	501	S2    
23028	501	S14   
23028	501	S2    
23029	501	S14   
23029	501	S2    
23030	501	S14   
23030	501	S2    
23031	501	S14   
23031	501	S2    
23032	501	S14   
23032	501	S2    
23033	501	S14   
23033	501	S2    
23034	501	S14   
23034	501	S2    
23035	501	S14   
23035	501	S2    
23036	501	S14   
23036	501	S2    
23037	501	S14   
23037	501	S2    
23038	501	S14   
23038	501	S2    
23039	501	S14   
23039	501	S2    
23040	501	S14   
23040	501	S2    
23041	501	S14   
23041	501	S2    
23042	501	S14   
23042	501	S2    
23043	501	S14   
23043	501	S2    
23044	501	S14   
23044	501	S2    
23045	501	S14   
23045	501	S2    
23046	501	S14   
23046	501	S2    
23047	501	S14   
23047	501	S2    
23048	501	S14   
23048	501	S2    
23049	501	S14   
23049	501	S2    
23050	501	S14   
23050	501	S2    
23051	501	S14   
23051	501	S2    
23052	501	S14   
23052	501	S2    
23053	501	S14   
23053	501	S2    
23054	501	S14   
23054	501	S2    
23055	501	S14   
23055	501	S2    
23056	501	S14   
23056	501	S2    
23057	501	S14   
23057	501	S2    
23058	501	S14   
23058	501	S2    
23059	501	S14   
23059	501	S2    
23060	501	S14   
23060	501	S2    
23061	501	S14   
23061	501	S2    
23062	501	S14   
23062	501	S2    
23063	501	S14   
23063	501	S2    
23064	501	S14   
23064	501	S2    
23065	501	S14   
23065	501	S2    
23557	501	S14   
23558	501	S14   
23559	501	S14   
23560	501	S14   
23561	501	S14   
23562	501	S14   
23563	501	S14   
23564	501	S14   
23565	501	S14   
23566	501	S14   
23567	501	S14   
23568	501	S14   
23569	501	S14   
23570	501	S14   
23571	501	S14   
23572	501	S14   
23573	501	S14   
23574	501	S14   
23575	501	S14   
23576	501	S14   
23577	501	S14   
23578	501	S14   
23579	501	S14   
23580	501	S14   
23581	501	S14   
23582	501	S14   
23582	501	S2    
23583	501	S14   
23583	501	S2    
23584	501	S14   
23584	501	S2    
23585	501	S14   
23585	501	S2    
23586	501	S14   
23586	501	S2    
23587	501	S14   
23587	501	S2    
23588	501	S14   
23588	501	S2    
23589	501	S14   
23589	501	S2    
23590	501	S14   
23590	501	S2    
23591	501	S14   
23591	501	S2    
23592	501	S14   
23592	501	S2    
23593	501	S14   
23593	501	S2    
23594	501	S14   
23594	501	S2    
23595	501	S14   
23595	501	S2    
23596	501	S14   
23596	501	S2    
23597	501	S14   
23597	501	S2    
23598	501	S14   
23598	501	S2    
23599	501	S14   
23599	501	S2    
23600	501	S14   
23600	501	S2    
23601	501	S14   
23601	501	S2    
23602	501	S14   
23602	501	S2    
23603	501	S14   
23603	501	S2    
23604	501	S14   
23604	501	S2    
23605	501	S14   
23605	501	S2    
23606	501	S14   
23606	501	S2    
23607	501	S14   
23607	501	S2    
23608	501	S14   
23608	501	S2    
23609	501	S14   
23609	501	S2    
23610	501	S14   
23610	501	S2    
23611	501	S14   
23611	501	S2    
23612	501	S14   
23612	501	S2    
23613	501	S14   
23613	501	S2    
23614	501	S14   
23614	501	S2    
23615	501	S14   
23615	501	S2    
23616	501	S14   
23616	501	S2    
23617	501	S14   
23617	501	S2    
23618	501	S14   
23618	501	S2    
23619	501	S14   
23619	501	S2    
23620	501	S14   
23620	501	S2    
23621	501	S14   
23621	501	S2    
23622	501	S14   
23622	501	S2    
23623	501	S14   
23623	501	S2    
23624	501	S14   
23624	501	S2    
23625	501	S14   
23625	501	S2    
23626	501	S14   
23626	501	S2    
23627	501	S14   
23627	501	S2    
23628	501	S14   
23628	501	S2    
23629	501	S14   
23629	501	S2    
23630	501	S14   
23630	501	S2    
23631	501	S14   
23631	501	S2    
23632	501	S14   
23632	501	S2    
23633	501	S14   
23633	501	S2    
23634	501	S14   
23634	501	S2    
23635	501	S14   
23635	501	S2    
23636	501	S14   
23636	501	S2    
23637	501	S14   
23637	501	S2    
23638	501	S14   
23638	501	S2    
23646	501	S14   
23646	501	S2    
23647	501	S14   
23647	501	S2    
23648	501	S14   
23648	501	S2    
23649	501	S14   
23649	501	S2    
23650	501	S14   
23650	501	S2    
23651	501	S14   
23651	501	S2    
23652	501	S14   
23652	501	S2    
23653	501	S14   
23653	501	S2    
23654	501	S14   
23654	501	S2    
23655	501	S14   
23655	501	S2    
23656	501	S14   
23656	501	S2    
23657	501	S14   
23657	501	S2    
23658	501	S14   
23658	501	S2    
23659	501	S14   
23659	501	S2    
23660	501	S14   
23660	501	S2    
35135	501	S2381 
35136	501	S2381 
35137	501	S2381 
35141	501	S2381 
35143	501	S2381 
35145	501	S2381 
35146	501	S2381 
35147	501	S2381 
43297	501	S1082 
43378	501	S1082 
01026	502	S27   
01029	502	S27   
01032	502	S19   
01046	502	S19   
01077	502	S27   
01079	502	S1063 
01079	502	S20   
01082	502	S1063 
01085	502	S1063 
01103	502	S1163 
01123	502	S1063 
01123	502	S561  
01124	502	S1065 
01125	502	S1065 
01128	502	S1063 
01128	502	S561  
01130	502	S1063 
01130	502	S561  
01131	502	S1063 
01131	502	S561  
01202	502	S1163 
04017	502	S19   
04023	502	S19   
04114	502	S19   
04640	502	S26   
05027	502	S1082 
05028	502	S1082 
05312	502	S26   
05313	502	S26   
05320	502	S26   
05661	502	S1082 
06019	502	S18   
06128	502	S18   
06982	502	S18   
06983	502	S18   
06984	502	S2104 
06985	502	S2104 
07005	502	S248  
07015	502	S248  
07016	502	S248  
07022	502	S2    
07063	502	S1164 
07063	502	S582  
07945	502	S2    
07949	502	S2    
07950	502	S2    
07953	502	S1164 
07953	502	S582  
07954	502	S582  
07955	502	S1164 
07956	502	S1164 
07957	502	S1164 
07958	502	S1164 
07960	502	S1164 
08001	502	S1065 
08012	502	S1065 
08013	502	S1065 
08014	502	S1065 
08020	502	S1065 
08025	502	S2662 
08030	502	S1065 
08061	502	S1065 
08065	502	S1065 
08065	502	S2662 
08074	502	S2662 
08077	502	S1065 
08147	502	S1065 
08218	502	S1065 
08259	502	S2662 
08504	502	S2662 
08505	502	S2662 
08506	502	S2662 
08507	502	S2662 
08508	502	S2662 
08509	502	S2662 
09003	502	S561  
09004	502	S561  
09032	502	S21   
09033	502	S21   
09038	502	S481  
09038	502	S502  
09040	502	S481  
09040	502	S562  
09070	502	S582  
09078	502	S561  
09087	502	S564  
09087	502	S582  
09094	502	S363  
09094	502	S582  
09095	502	S363  
09095	502	S582  
09111	502	S482  
09111	502	S563  
09112	502	S482  
09112	502	S563  
09114	502	S482  
09114	502	S563  
09116	502	S482  
09116	502	S563  
09117	502	S482  
09117	502	S563  
09118	502	S482  
09118	502	S563  
09120	502	S482  
09120	502	S563  
09121	502	S482  
09121	502	S563  
09132	502	S1062 
09148	502	S363  
09148	502	S582  
09160	502	S1065 
09181	502	S1121 
09184	502	S562  
09184	502	S565  
09191	502	S421  
09191	502	S582  
09202	502	S482  
09202	502	S564  
09218	502	S1065 
09236	502	S582  
09252	502	S541  
09266	502	S441  
09266	502	S561  
09279	502	S582  
09291	502	S564  
09291	502	S566  
09298	502	S564  
09298	502	S566  
09421	502	S564  
09421	502	S582  
10007	502	S1082 
10066	502	S1082 
10067	502	S1082 
10068	502	S1082 
10123	502	S1082 
10124	502	S1082 
10858	502	S1082 
10860	502	S1082 
10861	502	S1082 
10862	502	S1082 
11090	502	S1121 
11090	502	S564  
11096	502	S1121 
11096	502	S482  
11097	502	S1121 
11097	502	S482  
11112	502	S1065 
11243	502	S2941 
11260	502	S2941 
11263	502	S2941 
11265	502	S2941 
11294	502	S563  
11294	502	S582  
11339	502	S1062 
11353	502	S563  
11353	502	S566  
11354	502	S563  
11354	502	S566  
11357	502	S563  
11357	502	S566  
11359	502	S2105 
11360	502	S2105 
11394	502	S2105 
11395	502	S2105 
11398	502	S2105 
11399	502	S2105 
11402	502	S2105 
11403	502	S2105 
11411	502	S2105 
11463	502	S25   
11464	502	S25   
11546	502	S21   
11856	502	S25   
11887	502	S21   
11921	502	S1062 
11950	502	S2941 
11987	502	S2941 
11992	502	S2941 
12006	502	D4822 
12006	502	D4861 
12006	502	S1782 
12061	502	S141  
12062	502	S141  
12063	502	S141  
12065	502	S141  
12078	502	S1063 
12078	502	S503  
12086	502	S363  
12086	502	S502  
12087	502	S363  
12087	502	S502  
12120	502	S83   
12121	502	S83   
12122	502	S83   
12131	502	S77   
12132	502	S77   
12142	502	S85   
12143	502	S85   
12144	502	S85   
12147	502	S502  
12147	502	S564  
12151	502	S86   
12152	502	S86   
12154	502	S1001 
12155	502	S79   
12201	502	S1164 
12220	502	D4743 
12220	502	S2109 
12563	502	S141  
12565	502	S141  
12586	502	S363  
12586	502	S502  
12632	502	S77   
12643	502	S85   
12644	502	S85   
12652	502	S86   
13004	502	S14   
13004	502	S2    
13011	502	S14   
13011	502	S2    
13012	502	S14   
13012	502	S2    
13019	502	S14   
13019	502	S2    
13020	502	S14   
13020	502	S2    
13022	502	S14   
13022	502	S2    
13024	502	S14   
13024	502	S2    
13039	502	S2    
13052	502	S14   
13052	502	S2    
13055	502	S14   
13055	502	S2    
13058	502	S14   
13058	502	S2    
13060	502	S14   
13060	502	S2    
13061	502	S14   
13061	502	S2    
13062	502	S14   
13062	502	S2    
13065	502	S14   
13065	502	S2    
13067	502	S14   
13067	502	S2    
13068	502	S14   
13068	502	S2    
13069	502	S14   
13069	502	S2    
13070	502	S14   
13070	502	S2    
13072	502	S14   
13072	502	S2    
13088	502	S14   
13088	502	S2    
13092	502	S14   
13092	502	S2    
13096	502	S14   
13096	502	S2    
13098	502	S14   
13098	502	S2    
13113	502	S14   
13113	502	S2    
13143	502	S14   
13143	502	S2    
13148	502	S14   
13148	502	S2    
13150	502	S14   
13150	502	S2    
13151	502	S14   
13151	502	S2    
13152	502	S14   
13152	502	S2    
13155	502	S14   
13155	502	S2    
13156	502	S14   
13156	502	S2    
13165	502	S14   
13165	502	S2    
13192	502	S14   
13192	502	S2    
13194	502	S14   
13194	502	S2    
13196	502	S14   
13196	502	S2    
13200	502	S14   
13200	502	S2    
13202	502	S14   
13202	502	S2    
13204	502	S14   
13204	502	S2    
13211	502	S14   
13211	502	S2    
13220	502	S14   
13220	502	S2    
13231	502	S2    
13232	502	S2    
13235	502	S2    
13236	502	S2    
13260	502	S14   
13260	502	S2    
13281	502	S14   
13281	502	S2    
13290	502	S14   
13290	502	S2    
13325	502	S1082 
13326	502	S1082 
13327	502	S1082 
13335	502	S14   
13335	502	S2    
13343	502	S14   
13343	502	S2    
13347	502	S14   
13347	502	S2    
13361	502	S14   
13361	502	S2    
13364	502	S14   
13364	502	S2    
13367	502	S14   
13367	502	S2    
13368	502	S14   
13368	502	S2    
13369	502	S14   
13369	502	S2    
13370	502	S14   
13370	502	S2    
13373	502	S14   
13373	502	S2    
13375	502	S14   
13375	502	S2    
13377	502	S14   
13377	502	S2    
13378	502	S14   
13378	502	S2    
13382	502	S14   
13382	502	S2    
13388	502	S14   
13388	502	S2    
13391	502	S14   
13391	502	S2    
13394	502	S14   
13394	502	S2    
13398	502	S14   
13398	502	S2    
13399	502	S14   
13399	502	S2    
13401	502	S14   
13401	502	S2    
13402	502	S14   
13402	502	S2    
13404	502	S14   
13404	502	S2    
13405	502	S14   
13405	502	S2    
13407	502	S14   
13407	502	S2    
13408	502	S14   
13408	502	S2    
13410	502	S14   
13410	502	S2    
13411	502	S14   
13411	502	S2    
13413	502	S14   
13413	502	S2    
13414	502	S14   
13414	502	S2    
13415	502	S14   
13415	502	S2    
13416	502	S14   
13416	502	S2    
13417	502	S14   
13417	502	S2    
13419	502	S14   
13419	502	S2    
13420	502	S14   
13420	502	S2    
13421	502	S14   
13421	502	S2    
13422	502	S14   
13422	502	S2    
13423	502	S14   
13423	502	S2    
13424	502	S14   
13424	502	S2    
13425	502	S14   
13425	502	S2    
13426	502	S14   
13426	502	S2    
13427	502	S14   
13427	502	S2    
13428	502	S14   
13428	502	S2    
13431	502	S14   
13431	502	S2    
13433	502	S14   
13433	502	S2    
13434	502	S14   
13434	502	S2    
13439	502	S14   
13439	502	S2    
13440	502	S14   
13440	502	S2    
13441	502	S14   
13441	502	S2    
13443	502	S14   
13443	502	S2    
13444	502	S14   
13444	502	S2    
13445	502	S14   
13445	502	S2    
13446	502	S14   
13446	502	S2    
13447	502	S14   
13447	502	S2    
13448	502	S14   
13448	502	S2    
13449	502	S14   
13449	502	S2    
13450	502	S14   
13450	502	S2    
13451	502	S14   
13451	502	S2    
13452	502	S14   
13452	502	S2    
13453	502	S14   
13453	502	S2    
13454	502	S14   
13454	502	S2    
13455	502	S14   
13455	502	S2    
13456	502	S14   
13456	502	S2    
13467	502	S2    
13468	502	S2    
13469	502	S2    
13470	502	S2    
13481	502	S2    
13482	502	S2    
13483	502	S2    
13484	502	S2    
13485	502	S14   
13485	502	S2    
13486	502	S14   
13486	502	S2    
13487	502	S14   
13487	502	S2    
13488	502	S14   
13488	502	S2    
13490	502	S14   
13490	502	S2    
13491	502	S14   
13491	502	S2    
13492	502	S14   
13492	502	S2    
13493	502	S14   
13493	502	S2    
13494	502	S14   
13495	502	S14   
13496	502	S14   
13497	502	S14   
13498	502	S14   
13565	502	S14   
13565	502	S2    
13566	502	S14   
13566	502	S2    
13567	502	S14   
13567	502	S2    
13568	502	S14   
13568	502	S2    
13569	502	S14   
13569	502	S2    
13805	502	S14   
13805	502	S2    
13806	502	S14   
13806	502	S2    
13809	502	S14   
13809	502	S2    
13810	502	S14   
13810	502	S2    
13811	502	S14   
13811	502	S2    
13812	502	S14   
13812	502	S2    
13813	502	S14   
13813	502	S2    
13814	502	S14   
13814	502	S2    
13850	502	S14   
13850	502	S2    
13851	502	S14   
13851	502	S2    
13853	502	S14   
13853	502	S2    
13854	502	S14   
13854	502	S2    
13856	502	S14   
13856	502	S2    
13857	502	S14   
13857	502	S2    
13868	502	S14   
13868	502	S2    
13869	502	S14   
13869	502	S2    
13870	502	S14   
13870	502	S2    
13871	502	S14   
13871	502	S2    
13872	502	S14   
13872	502	S2    
13873	502	S14   
13873	502	S2    
13874	502	S14   
13874	502	S2    
13875	502	S14   
13875	502	S2    
13876	502	S14   
13876	502	S2    
13877	502	S14   
13877	502	S2    
13878	502	S14   
13878	502	S2    
13879	502	S14   
13879	502	S2    
13880	502	S14   
13880	502	S2    
13881	502	S14   
13881	502	S2    
13882	502	S14   
13882	502	S2    
13891	502	S14   
13891	502	S2    
13893	502	S14   
13893	502	S2    
13894	502	S14   
13894	502	S2    
13896	502	S14   
13896	502	S2    
13898	502	S14   
13898	502	S2    
13900	502	S14   
13900	502	S2    
13909	502	S14   
13909	502	S2    
13910	502	S14   
13910	502	S2    
13911	502	S14   
13911	502	S2    
13912	502	S14   
13912	502	S2    
13913	502	S14   
13913	502	S2    
13914	502	S14   
13914	502	S2    
13917	502	S14   
13917	502	S2    
13918	502	S14   
13918	502	S2    
13920	502	S14   
13920	502	S2    
13921	502	S14   
13921	502	S2    
13923	502	S14   
13923	502	S2    
13924	502	S14   
13924	502	S2    
13929	502	S14   
13929	502	S2    
13930	502	S14   
13930	502	S2    
13931	502	S14   
13931	502	S2    
13932	502	S14   
13932	502	S2    
13934	502	S14   
13934	502	S2    
13935	502	S14   
13935	502	S2    
13936	502	S2    
13937	502	S2    
13938	502	S2    
13939	502	S2    
13940	502	S2    
13941	502	S2    
13942	502	S2    
13943	502	S2    
13944	502	S2    
13945	502	S2    
13946	502	S2    
13947	502	S2    
13948	502	S14   
13948	502	S2    
13949	502	S14   
13949	502	S2    
13950	502	S14   
13950	502	S2    
13951	502	S14   
13951	502	S2    
13952	502	S14   
13952	502	S2    
13953	502	S14   
13953	502	S2    
13954	502	S14   
13954	502	S2    
13955	502	S14   
13955	502	S2    
13956	502	S14   
13956	502	S2    
13957	502	S14   
13957	502	S2    
13958	502	S14   
13958	502	S2    
13959	502	S14   
13959	502	S2    
13960	502	S2    
13961	502	S2    
13962	502	S2    
13963	502	S2    
13964	502	S2    
13965	502	S2    
13966	502	S2    
13967	502	S2    
13968	502	S14   
13968	502	S2    
13969	502	S14   
13969	502	S2    
13970	502	S14   
13970	502	S2    
13971	502	S14   
13971	502	S2    
13976	502	S2    
13977	502	S2    
13978	502	S2    
13979	502	S2    
13985	502	S14   
13985	502	S2    
13987	502	S2    
13988	502	S14   
13988	502	S2    
13989	502	S14   
13989	502	S2    
13990	502	S14   
13990	502	S2    
13991	502	S14   
13991	502	S2    
13992	502	S14   
13992	502	S2    
13994	502	S14   
13994	502	S2    
13995	502	S14   
13995	502	S2    
13996	502	S14   
13996	502	S2    
13997	502	S14   
13997	502	S2    
13998	502	S14   
13998	502	S2    
14003	502	S2103 
14006	502	S2103 
14347	502	S1064 
14347	502	S1122 
15073	502	S1163 
15087	502	S2109 
15152	502	S2104 
15232	502	S1163 
15260	502	S2109 
15261	502	S1163 
15262	502	S1163 
16006	502	S1164 
16011	502	S1164 
16037	502	S1164 
16038	502	S1164 
16042	502	S1065 
16089	502	S563  
16114	502	S39   
16120	502	S39   
16139	502	S39   
16147	502	S2104 
16338	502	S1164 
17202	502	S1082 
17203	502	S1082 
17204	502	S1082 
18166	502	S25   
19064	502	S1164 
19078	502	S1069 
19109	502	S1164 
19155	502	S1164 
19337	502	S2109 
20046	502	S1164 
20046	502	S20   
20047	502	S1164 
20047	502	S20   
20048	502	S1164 
20048	502	S20   
20049	502	S1164 
20049	502	S20   
20099	502	S1163 
20099	502	S20   
20100	502	S1163 
20100	502	S20   
20109	502	S2105 
20110	502	S2105 
20120	502	S1163 
20120	502	S20   
20121	502	S1163 
20121	502	S20   
20310	502	S2105 
20321	502	S1163 
20321	502	S20   
20400	502	S1163 
20400	502	S20   
20409	502	S2105 
20410	502	S2105 
20420	502	S1163 
20420	502	S20   
20421	502	S1163 
20421	502	S20   
20446	502	S1164 
20446	502	S20   
20447	502	S1164 
20447	502	S20   
20499	502	S1163 
20499	502	S20   
20510	502	S2105 
20521	502	S1163 
20521	502	S20   
20623	502	S1742 
20624	502	S1742 
20628	502	S1742 
20629	502	S1742 
20630	502	S1742 
20634	502	S1742 
20635	502	S1742 
20636	502	S1742 
20640	502	S1742 
20641	502	S1742 
20645	502	S1742 
20646	502	S1742 
21138	502	S1064 
21138	502	S1066 
21138	502	S1122 
21224	502	S19   
21225	502	S19   
21229	502	S1122 
21239	502	S1066 
21240	502	S1066 
21241	502	S1066 
21242	502	S1066 
21243	502	S1066 
21244	502	S1066 
21245	502	S1066 
21246	502	S1066 
21247	502	S1066 
21248	502	S1066 
21249	502	S1064 
21250	502	S1064 
21251	502	S1064 
21252	502	S1064 
21253	502	S1064 
21254	502	S1064 
21255	502	S1064 
21256	502	S1064 
21257	502	S1064 
21259	502	S1064 
21260	502	S1082 
21261	502	S1082 
21262	502	S1082 
21263	502	S1082 
21264	502	S1082 
21265	502	S1082 
21266	502	S1082 
21267	502	S1082 
21268	502	S1082 
21269	502	S1082 
21270	502	S1082 
21271	502	S2108 
21272	502	S2108 
21273	502	S2108 
21274	502	S2108 
21275	502	S2108 
21276	502	S2108 
21278	502	S2110 
21279	502	S2110 
21280	502	S2110 
21281	502	S2110 
21282	502	S2110 
21285	502	S2111 
21286	502	S2111 
21289	502	S2112 
21290	502	S2112 
21291	502	S2112 
21292	502	S2112 
21295	502	S2782 
21298	502	S2782 
21299	502	S2108 
21300	502	S2108 
21300	502	S2110 
21300	502	S2112 
21301	502	S2108 
21301	502	S2110 
21301	502	S2111 
21301	502	S2112 
21301	502	S2782 
21302	502	S2108 
21303	502	S2108 
21303	502	S2110 
21303	502	S2112 
21304	502	S2108 
21304	502	S2110 
21304	502	S2111 
21304	502	S2112 
21304	502	S2782 
22911	502	S18   
23009	502	S14   
23009	502	S2    
23010	502	S14   
23010	502	S2    
23011	502	S14   
23011	502	S2    
23012	502	S14   
23012	502	S2    
23013	502	S14   
23013	502	S2    
23014	502	S14   
23014	502	S2    
23015	502	S14   
23015	502	S2    
23016	502	S14   
23016	502	S2    
23017	502	S14   
23017	502	S2    
23018	502	S14   
23018	502	S2    
23019	502	S14   
23019	502	S2    
23020	502	S14   
23020	502	S2    
23021	502	S14   
23021	502	S2    
23022	502	S14   
23022	502	S2    
23023	502	S14   
23023	502	S2    
23024	502	S14   
23024	502	S2    
23025	502	S14   
23025	502	S2    
23027	502	S14   
23027	502	S2    
23028	502	S14   
23028	502	S2    
23029	502	S14   
23029	502	S2    
23030	502	S14   
23030	502	S2    
23031	502	S14   
23031	502	S2    
23032	502	S14   
23032	502	S2    
23033	502	S14   
23033	502	S2    
23034	502	S14   
23034	502	S2    
23035	502	S14   
23035	502	S2    
23036	502	S14   
23036	502	S2    
23037	502	S14   
23037	502	S2    
23038	502	S14   
23038	502	S2    
23039	502	S14   
23039	502	S2    
23040	502	S14   
23040	502	S2    
23041	502	S14   
23041	502	S2    
23042	502	S14   
23042	502	S2    
23043	502	S14   
23043	502	S2    
23044	502	S14   
23044	502	S2    
23045	502	S14   
23045	502	S2    
23046	502	S14   
23046	502	S2    
23047	502	S14   
23047	502	S2    
23048	502	S14   
23048	502	S2    
23049	502	S14   
23049	502	S2    
23050	502	S14   
23050	502	S2    
23051	502	S14   
23051	502	S2    
23052	502	S14   
23052	502	S2    
23053	502	S14   
23053	502	S2    
23054	502	S14   
23054	502	S2    
23055	502	S14   
23055	502	S2    
23056	502	S14   
23056	502	S2    
23057	502	S14   
23057	502	S2    
23058	502	S14   
23058	502	S2    
23059	502	S14   
23059	502	S2    
23060	502	S14   
23060	502	S2    
23061	502	S14   
23061	502	S2    
23062	502	S14   
23062	502	S2    
23063	502	S14   
23063	502	S2    
23064	502	S14   
23064	502	S2    
23065	502	S14   
23065	502	S2    
23557	502	S14   
23558	502	S14   
23559	502	S14   
23560	502	S14   
23561	502	S14   
23562	502	S14   
23563	502	S14   
23564	502	S14   
23565	502	S14   
23566	502	S14   
23567	502	S14   
23568	502	S14   
23569	502	S14   
23570	502	S14   
23571	502	S14   
23572	502	S14   
23573	502	S14   
23574	502	S14   
23575	502	S14   
23576	502	S14   
23577	502	S14   
23578	502	S14   
23579	502	S14   
23580	502	S14   
23581	502	S14   
23582	502	S14   
23582	502	S2    
23583	502	S14   
23583	502	S2    
23584	502	S14   
23584	502	S2    
23585	502	S14   
23585	502	S2    
23586	502	S14   
23586	502	S2    
23587	502	S14   
23587	502	S2    
23588	502	S14   
23588	502	S2    
23589	502	S14   
23589	502	S2    
23590	502	S14   
23590	502	S2    
23591	502	S14   
23591	502	S2    
23592	502	S14   
23592	502	S2    
23593	502	S14   
23593	502	S2    
23594	502	S14   
23594	502	S2    
23595	502	S14   
23595	502	S2    
23596	502	S14   
23596	502	S2    
23597	502	S14   
23597	502	S2    
23598	502	S14   
23598	502	S2    
23599	502	S14   
23599	502	S2    
23600	502	S14   
23600	502	S2    
23601	502	S14   
23601	502	S2    
23602	502	S14   
23602	502	S2    
23603	502	S14   
23603	502	S2    
23604	502	S14   
23604	502	S2    
23605	502	S14   
23605	502	S2    
23606	502	S14   
23606	502	S2    
23607	502	S14   
23607	502	S2    
23608	502	S14   
23608	502	S2    
23609	502	S14   
23609	502	S2    
23610	502	S14   
23610	502	S2    
23611	502	S14   
23611	502	S2    
23612	502	S14   
23612	502	S2    
23613	502	S14   
23613	502	S2    
23614	502	S14   
23614	502	S2    
23615	502	S14   
23615	502	S2    
23616	502	S14   
23616	502	S2    
23617	502	S14   
23617	502	S2    
23618	502	S14   
23618	502	S2    
23619	502	S14   
23619	502	S2    
23620	502	S14   
23620	502	S2    
23621	502	S14   
23621	502	S2    
23622	502	S14   
23622	502	S2    
23623	502	S14   
23623	502	S2    
23624	502	S14   
23624	502	S2    
23625	502	S14   
23625	502	S2    
23626	502	S14   
23626	502	S2    
23627	502	S14   
23627	502	S2    
23628	502	S14   
23628	502	S2    
23629	502	S14   
23629	502	S2    
23630	502	S14   
23630	502	S2    
23631	502	S14   
23631	502	S2    
23632	502	S14   
23632	502	S2    
23633	502	S14   
23633	502	S2    
23634	502	S14   
23634	502	S2    
23635	502	S14   
23635	502	S2    
23636	502	S14   
23636	502	S2    
23637	502	S14   
23637	502	S2    
23638	502	S14   
23638	502	S2    
23646	502	S14   
23646	502	S2    
23647	502	S14   
23647	502	S2    
23648	502	S14   
23648	502	S2    
23649	502	S14   
23649	502	S2    
23650	502	S14   
23650	502	S2    
23651	502	S14   
23651	502	S2    
23652	502	S14   
23652	502	S2    
23653	502	S14   
23653	502	S2    
23654	502	S14   
23654	502	S2    
23655	502	S14   
23655	502	S2    
23656	502	S14   
23656	502	S2    
23657	502	S14   
23657	502	S2    
23658	502	S14   
23658	502	S2    
23659	502	S14   
23659	502	S2    
23660	502	S14   
23660	502	S2    
35135	502	S2381 
35136	502	S2381 
35137	502	S2381 
35141	502	S2381 
35143	502	S2381 
35145	502	S2381 
35146	502	S2381 
35147	502	S2381 
43297	502	S1082 
43378	502	S1082 
01026	503	S27   
01029	503	S27   
01032	503	S19   
01046	503	S19   
01077	503	S27   
01079	503	S1063 
01079	503	S20   
01082	503	S1063 
01085	503	S1063 
01103	503	S1163 
01123	503	S1063 
01123	503	S561  
01124	503	S1065 
01125	503	S1065 
01128	503	S1063 
01128	503	S561  
01130	503	S1063 
01130	503	S561  
01131	503	S1063 
01131	503	S561  
01202	503	S1163 
04017	503	S19   
04023	503	S19   
04114	503	S19   
04640	503	S26   
05027	503	S1082 
05028	503	S1082 
05312	503	S26   
05313	503	S26   
05320	503	S26   
05661	503	S1082 
06019	503	S18   
06128	503	S18   
06982	503	S18   
06983	503	S18   
06984	503	S2104 
06985	503	S2104 
07005	503	S248  
07015	503	S248  
07016	503	S248  
07022	503	S2    
07063	503	S1164 
07063	503	S582  
07945	503	S2    
07949	503	S2    
07950	503	S2    
07953	503	S1164 
07953	503	S582  
07954	503	S582  
07955	503	S1164 
07956	503	S1164 
07957	503	S1164 
07958	503	S1164 
07960	503	S1164 
08001	503	S1065 
08012	503	S1065 
08013	503	S1065 
08014	503	S1065 
08020	503	S1065 
08025	503	S2662 
08030	503	S1065 
08061	503	S1065 
08065	503	S1065 
08065	503	S2662 
08074	503	S2662 
08077	503	S1065 
08147	503	S1065 
08218	503	S1065 
08259	503	S2662 
08504	503	S2662 
08505	503	S2662 
08506	503	S2662 
08507	503	S2662 
08508	503	S2662 
08509	503	S2662 
09003	503	S561  
09004	503	S561  
09032	503	S21   
09033	503	S21   
09038	503	S481  
09038	503	S502  
09040	503	S481  
09040	503	S562  
09070	503	S582  
09078	503	S561  
09087	503	S564  
09087	503	S582  
09094	503	S363  
09094	503	S582  
09095	503	S363  
09095	503	S582  
09111	503	S482  
09111	503	S563  
09112	503	S482  
09112	503	S563  
09114	503	S482  
09114	503	S563  
09116	503	S482  
09116	503	S563  
09117	503	S482  
09117	503	S563  
09118	503	S482  
09118	503	S563  
09120	503	S482  
09120	503	S563  
09121	503	S482  
09121	503	S563  
09132	503	S1062 
09148	503	S363  
09148	503	S582  
09160	503	S1065 
09181	503	S1121 
09184	503	S562  
09184	503	S565  
09191	503	S421  
09191	503	S582  
09202	503	S482  
09202	503	S564  
09218	503	S1065 
09236	503	S582  
09252	503	S541  
09266	503	S441  
09266	503	S561  
09279	503	S582  
09291	503	S564  
09291	503	S566  
09298	503	S564  
09298	503	S566  
09421	503	S564  
09421	503	S582  
10007	503	S1082 
10066	503	S1082 
10067	503	S1082 
10068	503	S1082 
10123	503	S1082 
10124	503	S1082 
10858	503	S1082 
10860	503	S1082 
10861	503	S1082 
10862	503	S1082 
11090	503	S1121 
11090	503	S564  
11096	503	S1121 
11096	503	S482  
11097	503	S1121 
11097	503	S482  
11112	503	S1065 
11243	503	S2941 
11260	503	S2941 
11263	503	S2941 
11265	503	S2941 
11294	503	S563  
11294	503	S582  
11339	503	S1062 
11353	503	S563  
11353	503	S566  
11354	503	S563  
11354	503	S566  
11357	503	S563  
11357	503	S566  
11359	503	S2105 
11360	503	S2105 
11394	503	S2105 
11395	503	S2105 
11398	503	S2105 
11399	503	S2105 
11402	503	S2105 
11403	503	S2105 
11411	503	S2105 
11463	503	S25   
11464	503	S25   
11856	503	S25   
11921	503	S1062 
11950	503	S2941 
11987	503	S2941 
11992	503	S2941 
12006	503	D4822 
12006	503	D4861 
12006	503	S1782 
12061	503	S141  
12062	503	S141  
12063	503	S141  
12065	503	S141  
12078	503	S1063 
12078	503	S503  
12086	503	S363  
12086	503	S502  
12087	503	S363  
12087	503	S502  
12120	503	S83   
12121	503	S83   
12122	503	S83   
12131	503	S77   
12132	503	S77   
12142	503	S85   
12143	503	S85   
12144	503	S85   
12147	503	S502  
12147	503	S564  
12151	503	S86   
12152	503	S86   
12154	503	S1001 
12155	503	S79   
12201	503	S1164 
12220	503	D4743 
12220	503	S2109 
12563	503	S141  
12565	503	S141  
12586	503	S363  
12586	503	S502  
12632	503	S77   
12643	503	S85   
12644	503	S85   
12652	503	S86   
13004	503	S14   
13004	503	S2    
13011	503	S14   
13011	503	S2    
13012	503	S14   
13012	503	S2    
13019	503	S14   
13019	503	S2    
13020	503	S14   
13020	503	S2    
13022	503	S14   
13022	503	S2    
13024	503	S14   
13024	503	S2    
13039	503	S2    
13052	503	S14   
13052	503	S2    
13055	503	S14   
13055	503	S2    
13058	503	S14   
13058	503	S2    
13060	503	S14   
13060	503	S2    
13061	503	S14   
13061	503	S2    
13062	503	S14   
13062	503	S2    
13065	503	S14   
13065	503	S2    
13067	503	S14   
13067	503	S2    
13068	503	S14   
13068	503	S2    
13069	503	S14   
13069	503	S2    
13070	503	S14   
13070	503	S2    
13072	503	S14   
13072	503	S2    
13088	503	S14   
13088	503	S2    
13092	503	S14   
13092	503	S2    
13096	503	S14   
13096	503	S2    
13098	503	S14   
13098	503	S2    
13113	503	S14   
13113	503	S2    
13143	503	S14   
13143	503	S2    
13148	503	S14   
13148	503	S2    
13150	503	S14   
13150	503	S2    
13151	503	S14   
13151	503	S2    
13152	503	S14   
13152	503	S2    
13155	503	S14   
13155	503	S2    
13156	503	S14   
13156	503	S2    
13165	503	S14   
13165	503	S2    
13192	503	S14   
13192	503	S2    
13194	503	S14   
13194	503	S2    
13196	503	S14   
13196	503	S2    
13200	503	S14   
13200	503	S2    
13202	503	S14   
13202	503	S2    
13204	503	S14   
13204	503	S2    
13211	503	S14   
13211	503	S2    
13220	503	S14   
13220	503	S2    
13231	503	S2    
13232	503	S2    
13235	503	S2    
13236	503	S2    
13260	503	S14   
13260	503	S2    
13281	503	S14   
13281	503	S2    
13290	503	S14   
13290	503	S2    
13325	503	S1082 
13326	503	S1082 
13327	503	S1082 
13335	503	S14   
13335	503	S2    
13343	503	S14   
13343	503	S2    
13347	503	S14   
13347	503	S2    
13361	503	S14   
13361	503	S2    
13364	503	S14   
13364	503	S2    
13367	503	S14   
13367	503	S2    
13368	503	S14   
13368	503	S2    
13369	503	S14   
13369	503	S2    
13370	503	S14   
13370	503	S2    
13373	503	S14   
13373	503	S2    
13375	503	S14   
13375	503	S2    
13377	503	S14   
13377	503	S2    
13378	503	S14   
13378	503	S2    
13382	503	S14   
13382	503	S2    
13388	503	S14   
13388	503	S2    
13391	503	S14   
13391	503	S2    
13394	503	S14   
13394	503	S2    
13398	503	S14   
13398	503	S2    
13399	503	S14   
13399	503	S2    
13401	503	S14   
13401	503	S2    
13402	503	S14   
13402	503	S2    
13404	503	S14   
13404	503	S2    
13405	503	S14   
13405	503	S2    
13407	503	S14   
13407	503	S2    
13408	503	S14   
13408	503	S2    
13410	503	S14   
13410	503	S2    
13411	503	S14   
13411	503	S2    
13413	503	S14   
13413	503	S2    
13414	503	S14   
13414	503	S2    
13415	503	S14   
13415	503	S2    
13416	503	S14   
13416	503	S2    
13417	503	S14   
13417	503	S2    
13419	503	S14   
13419	503	S2    
13420	503	S14   
13420	503	S2    
13421	503	S14   
13421	503	S2    
13422	503	S14   
13422	503	S2    
13423	503	S14   
13423	503	S2    
13424	503	S14   
13424	503	S2    
13425	503	S14   
13425	503	S2    
13426	503	S14   
13426	503	S2    
13427	503	S14   
13427	503	S2    
13428	503	S14   
13428	503	S2    
13431	503	S14   
13431	503	S2    
13433	503	S14   
13433	503	S2    
13434	503	S14   
13434	503	S2    
13439	503	S14   
13439	503	S2    
13440	503	S14   
13440	503	S2    
13441	503	S14   
13441	503	S2    
13443	503	S14   
13443	503	S2    
13444	503	S14   
13444	503	S2    
13445	503	S14   
13445	503	S2    
13446	503	S14   
13446	503	S2    
13447	503	S14   
13447	503	S2    
13448	503	S14   
13448	503	S2    
13449	503	S14   
13449	503	S2    
13450	503	S14   
13450	503	S2    
13451	503	S14   
13451	503	S2    
13452	503	S14   
13452	503	S2    
13453	503	S14   
13453	503	S2    
13454	503	S14   
13454	503	S2    
13455	503	S14   
13455	503	S2    
13456	503	S14   
13456	503	S2    
13467	503	S2    
13468	503	S2    
13469	503	S2    
13470	503	S2    
13481	503	S2    
13482	503	S2    
13483	503	S2    
13484	503	S2    
13485	503	S14   
13485	503	S2    
13486	503	S14   
13486	503	S2    
13487	503	S14   
13487	503	S2    
13488	503	S14   
13488	503	S2    
13490	503	S14   
13490	503	S2    
13491	503	S14   
13491	503	S2    
13492	503	S14   
13492	503	S2    
13493	503	S14   
13493	503	S2    
13494	503	S14   
13495	503	S14   
13496	503	S14   
13497	503	S14   
13498	503	S14   
13565	503	S14   
13565	503	S2    
13566	503	S14   
13566	503	S2    
13567	503	S14   
13567	503	S2    
13568	503	S14   
13568	503	S2    
13569	503	S14   
13569	503	S2    
13805	503	S14   
13805	503	S2    
13806	503	S14   
13806	503	S2    
13809	503	S14   
13809	503	S2    
13810	503	S14   
13810	503	S2    
13811	503	S14   
13811	503	S2    
13812	503	S14   
13812	503	S2    
13813	503	S14   
13813	503	S2    
13814	503	S14   
13814	503	S2    
13850	503	S14   
13850	503	S2    
13851	503	S14   
13851	503	S2    
13853	503	S14   
13853	503	S2    
13854	503	S14   
13854	503	S2    
13856	503	S14   
13856	503	S2    
13857	503	S14   
13857	503	S2    
13868	503	S14   
13868	503	S2    
13869	503	S14   
13869	503	S2    
13870	503	S14   
13870	503	S2    
13871	503	S14   
13871	503	S2    
13872	503	S14   
13872	503	S2    
13873	503	S14   
13873	503	S2    
13874	503	S14   
13874	503	S2    
13875	503	S14   
13875	503	S2    
13876	503	S14   
13876	503	S2    
13877	503	S14   
13877	503	S2    
13878	503	S14   
13878	503	S2    
13879	503	S14   
13879	503	S2    
13880	503	S14   
13880	503	S2    
13881	503	S14   
13881	503	S2    
13882	503	S14   
13882	503	S2    
13891	503	S14   
13891	503	S2    
13893	503	S14   
13893	503	S2    
13894	503	S14   
13894	503	S2    
13896	503	S14   
13896	503	S2    
13898	503	S14   
13898	503	S2    
13900	503	S14   
13900	503	S2    
13909	503	S14   
13909	503	S2    
13910	503	S14   
13910	503	S2    
13911	503	S14   
13911	503	S2    
13912	503	S14   
13912	503	S2    
13913	503	S14   
13913	503	S2    
13914	503	S14   
13914	503	S2    
13917	503	S14   
13917	503	S2    
13918	503	S14   
13918	503	S2    
13920	503	S14   
13920	503	S2    
13921	503	S14   
13921	503	S2    
13923	503	S14   
13923	503	S2    
13924	503	S14   
13924	503	S2    
13929	503	S14   
13929	503	S2    
13930	503	S14   
13930	503	S2    
13931	503	S14   
13931	503	S2    
13932	503	S14   
13932	503	S2    
13934	503	S14   
13934	503	S2    
13935	503	S14   
13935	503	S2    
13936	503	S2    
13937	503	S2    
13938	503	S2    
13939	503	S2    
13940	503	S2    
13941	503	S2    
13942	503	S2    
13943	503	S2    
13944	503	S2    
13945	503	S2    
13946	503	S2    
13947	503	S2    
13948	503	S14   
13948	503	S2    
13949	503	S14   
13949	503	S2    
13950	503	S14   
13950	503	S2    
13951	503	S14   
13951	503	S2    
13952	503	S14   
13952	503	S2    
13953	503	S14   
13953	503	S2    
13954	503	S14   
13954	503	S2    
13955	503	S14   
13955	503	S2    
13956	503	S14   
13956	503	S2    
13957	503	S14   
13957	503	S2    
13958	503	S14   
13958	503	S2    
13959	503	S14   
13959	503	S2    
13960	503	S2    
13961	503	S2    
13962	503	S2    
13963	503	S2    
13964	503	S2    
13965	503	S2    
13966	503	S2    
13967	503	S2    
13968	503	S14   
13968	503	S2    
13969	503	S14   
13969	503	S2    
13970	503	S14   
13970	503	S2    
13971	503	S14   
13971	503	S2    
13976	503	S2    
13977	503	S2    
13978	503	S2    
13979	503	S2    
13985	503	S14   
13985	503	S2    
13987	503	S2    
13988	503	S14   
13988	503	S2    
13989	503	S14   
13989	503	S2    
13990	503	S14   
13990	503	S2    
13991	503	S14   
13991	503	S2    
13992	503	S14   
13992	503	S2    
13994	503	S14   
13994	503	S2    
13995	503	S14   
13995	503	S2    
13996	503	S14   
13996	503	S2    
13997	503	S14   
13997	503	S2    
13998	503	S14   
13998	503	S2    
14003	503	S2103 
14006	503	S2103 
14347	503	S1064 
14347	503	S1122 
15073	503	S1163 
15087	503	S2109 
15152	503	S2104 
15232	503	S1163 
15260	503	S2109 
15261	503	S1163 
15262	503	S1163 
16006	503	S1164 
16011	503	S1164 
16037	503	S1164 
16038	503	S1164 
16042	503	S1065 
16089	503	S563  
16114	503	S39   
16120	503	S39   
16139	503	S39   
16147	503	S2104 
16338	503	S1164 
17202	503	S1082 
17203	503	S1082 
17204	503	S1082 
18166	503	S25   
19064	503	S1164 
19078	503	S1069 
19109	503	S1164 
19155	503	S1164 
19337	503	S2109 
20046	503	S1164 
20046	503	S20   
20047	503	S1164 
20047	503	S20   
20048	503	S1164 
20048	503	S20   
20049	503	S1164 
20049	503	S20   
20099	503	S1163 
20099	503	S20   
20100	503	S1163 
20100	503	S20   
20109	503	S2105 
20110	503	S2105 
20120	503	S1163 
20120	503	S20   
20121	503	S1163 
20121	503	S20   
20310	503	S2105 
20321	503	S1163 
20321	503	S20   
20400	503	S1163 
20400	503	S20   
20409	503	S2105 
20410	503	S2105 
20420	503	S1163 
20420	503	S20   
20421	503	S1163 
20421	503	S20   
20446	503	S1164 
20446	503	S20   
20447	503	S1164 
20447	503	S20   
20499	503	S1163 
20499	503	S20   
20510	503	S2105 
20521	503	S1163 
20521	503	S20   
20623	503	S1742 
20624	503	S1742 
20628	503	S1742 
20629	503	S1742 
20630	503	S1742 
20634	503	S1742 
20635	503	S1742 
20636	503	S1742 
20640	503	S1742 
20641	503	S1742 
20645	503	S1742 
20646	503	S1742 
21138	503	S1064 
21138	503	S1066 
21138	503	S1122 
21224	503	S19   
21225	503	S19   
21229	503	S1122 
21239	503	S1066 
21240	503	S1066 
21241	503	S1066 
21242	503	S1066 
21243	503	S1066 
21244	503	S1066 
21245	503	S1066 
21246	503	S1066 
21247	503	S1066 
21248	503	S1066 
21249	503	S1064 
21250	503	S1064 
21251	503	S1064 
21252	503	S1064 
21253	503	S1064 
21254	503	S1064 
21255	503	S1064 
21256	503	S1064 
21257	503	S1064 
21259	503	S1064 
21260	503	S1082 
21261	503	S1082 
21262	503	S1082 
21263	503	S1082 
21264	503	S1082 
21265	503	S1082 
21266	503	S1082 
21267	503	S1082 
21268	503	S1082 
21269	503	S1082 
21270	503	S1082 
21271	503	S2108 
21272	503	S2108 
21273	503	S2108 
21274	503	S2108 
21275	503	S2108 
21276	503	S2108 
21278	503	S2110 
21279	503	S2110 
21280	503	S2110 
21281	503	S2110 
21282	503	S2110 
21285	503	S2111 
21286	503	S2111 
21289	503	S2112 
21290	503	S2112 
21291	503	S2112 
21292	503	S2112 
21295	503	S2782 
21298	503	S2782 
21299	503	S2108 
21300	503	S2108 
21300	503	S2110 
21300	503	S2112 
21301	503	S2108 
21301	503	S2110 
21301	503	S2111 
21301	503	S2112 
21301	503	S2782 
21302	503	S2108 
21303	503	S2108 
21303	503	S2110 
21303	503	S2112 
21304	503	S2108 
21304	503	S2110 
21304	503	S2111 
21304	503	S2112 
21304	503	S2782 
22911	503	S18   
23009	503	S14   
23009	503	S2    
23010	503	S14   
23010	503	S2    
23011	503	S14   
23011	503	S2    
23012	503	S14   
23012	503	S2    
23013	503	S14   
23013	503	S2    
23014	503	S14   
23014	503	S2    
23015	503	S14   
23015	503	S2    
23016	503	S14   
23016	503	S2    
23017	503	S14   
23017	503	S2    
23018	503	S14   
23018	503	S2    
23019	503	S14   
23019	503	S2    
23020	503	S14   
23020	503	S2    
23021	503	S14   
23021	503	S2    
23022	503	S14   
23022	503	S2    
23023	503	S14   
23023	503	S2    
23024	503	S14   
23024	503	S2    
23025	503	S14   
23025	503	S2    
23027	503	S14   
23027	503	S2    
23028	503	S14   
23028	503	S2    
23029	503	S14   
23029	503	S2    
23030	503	S14   
23030	503	S2    
23031	503	S14   
23031	503	S2    
23032	503	S14   
23032	503	S2    
23033	503	S14   
23033	503	S2    
23034	503	S14   
23034	503	S2    
23035	503	S14   
23035	503	S2    
23036	503	S14   
23036	503	S2    
23037	503	S14   
23037	503	S2    
23038	503	S14   
23038	503	S2    
23039	503	S14   
23039	503	S2    
23040	503	S14   
23040	503	S2    
23041	503	S14   
23041	503	S2    
23042	503	S14   
23042	503	S2    
23043	503	S14   
23043	503	S2    
23044	503	S14   
23044	503	S2    
23045	503	S14   
23045	503	S2    
23046	503	S14   
23046	503	S2    
23047	503	S14   
23047	503	S2    
23048	503	S14   
23048	503	S2    
23049	503	S14   
23049	503	S2    
23050	503	S14   
23050	503	S2    
23051	503	S14   
23051	503	S2    
23052	503	S14   
23052	503	S2    
23053	503	S14   
23053	503	S2    
23054	503	S14   
23054	503	S2    
23055	503	S14   
23055	503	S2    
23056	503	S14   
23056	503	S2    
23057	503	S14   
23057	503	S2    
23058	503	S14   
23058	503	S2    
23059	503	S14   
23059	503	S2    
23060	503	S14   
23060	503	S2    
23061	503	S14   
23061	503	S2    
23062	503	S14   
23062	503	S2    
23063	503	S14   
23063	503	S2    
23064	503	S14   
23064	503	S2    
23065	503	S14   
23065	503	S2    
23557	503	S14   
23558	503	S14   
23559	503	S14   
23560	503	S14   
23561	503	S14   
23562	503	S14   
23563	503	S14   
23564	503	S14   
23565	503	S14   
23566	503	S14   
23567	503	S14   
23568	503	S14   
23569	503	S14   
23570	503	S14   
23571	503	S14   
23572	503	S14   
23573	503	S14   
23574	503	S14   
23575	503	S14   
23576	503	S14   
23577	503	S14   
23578	503	S14   
23579	503	S14   
23580	503	S14   
23581	503	S14   
23582	503	S14   
23582	503	S2    
23583	503	S14   
23583	503	S2    
23584	503	S14   
23584	503	S2    
23585	503	S14   
23585	503	S2    
23586	503	S14   
23586	503	S2    
23587	503	S14   
23587	503	S2    
23588	503	S14   
23588	503	S2    
23589	503	S14   
23589	503	S2    
23590	503	S14   
23590	503	S2    
23591	503	S14   
23591	503	S2    
23592	503	S14   
23592	503	S2    
23593	503	S14   
23593	503	S2    
23594	503	S14   
23594	503	S2    
23595	503	S14   
23595	503	S2    
23596	503	S14   
23596	503	S2    
23597	503	S14   
23597	503	S2    
23598	503	S14   
23598	503	S2    
23599	503	S14   
23599	503	S2    
23600	503	S14   
23600	503	S2    
23601	503	S14   
23601	503	S2    
23602	503	S14   
23602	503	S2    
23603	503	S14   
23603	503	S2    
23604	503	S14   
23604	503	S2    
23605	503	S14   
23605	503	S2    
23606	503	S14   
23606	503	S2    
23607	503	S14   
23607	503	S2    
23608	503	S14   
23608	503	S2    
23609	503	S14   
23609	503	S2    
23610	503	S14   
23610	503	S2    
23611	503	S14   
23611	503	S2    
23612	503	S14   
23612	503	S2    
23613	503	S14   
23613	503	S2    
23614	503	S14   
23614	503	S2    
23615	503	S14   
23615	503	S2    
23616	503	S14   
23616	503	S2    
23617	503	S14   
23617	503	S2    
23618	503	S14   
23618	503	S2    
23619	503	S14   
23619	503	S2    
23620	503	S14   
23620	503	S2    
23621	503	S14   
23621	503	S2    
23622	503	S14   
23622	503	S2    
23623	503	S14   
23623	503	S2    
23624	503	S14   
23624	503	S2    
23625	503	S14   
23625	503	S2    
23626	503	S14   
23626	503	S2    
23627	503	S14   
23627	503	S2    
23628	503	S14   
23628	503	S2    
23629	503	S14   
23629	503	S2    
23630	503	S14   
23630	503	S2    
23631	503	S14   
23631	503	S2    
23632	503	S14   
23632	503	S2    
23633	503	S14   
23633	503	S2    
23634	503	S14   
23634	503	S2    
23635	503	S14   
23635	503	S2    
23636	503	S14   
23636	503	S2    
23637	503	S14   
23637	503	S2    
23638	503	S14   
23638	503	S2    
23646	503	S14   
23646	503	S2    
23647	503	S14   
23647	503	S2    
23648	503	S14   
23648	503	S2    
23649	503	S14   
23649	503	S2    
23650	503	S14   
23650	503	S2    
23651	503	S14   
23651	503	S2    
23652	503	S14   
23652	503	S2    
23653	503	S14   
23653	503	S2    
23654	503	S14   
23654	503	S2    
23655	503	S14   
23655	503	S2    
23656	503	S14   
23656	503	S2    
23657	503	S14   
23657	503	S2    
23658	503	S14   
23658	503	S2    
23659	503	S14   
23659	503	S2    
23660	503	S14   
23660	503	S2    
35135	503	S2381 
35136	503	S2381 
35137	503	S2381 
35141	503	S2381 
35143	503	S2381 
35145	503	S2381 
35146	503	S2381 
35147	503	S2381 
43297	503	S1082 
43378	503	S1082 
01026	504	S27   
01029	504	S27   
01032	504	S19   
01046	504	S19   
01077	504	S27   
01079	504	S1063 
01079	504	S20   
01082	504	S1063 
01085	504	S1063 
01103	504	S1163 
01123	504	S1063 
01123	504	S561  
01124	504	S1065 
01125	504	S1065 
01128	504	S1063 
01128	504	S561  
01130	504	S1063 
01130	504	S561  
01131	504	S1063 
01131	504	S561  
01202	504	S1163 
04017	504	S19   
04023	504	S19   
04114	504	S19   
04640	504	S26   
05027	504	S1082 
05028	504	S1082 
05312	504	S26   
05313	504	S26   
05320	504	S26   
05661	504	S1082 
06019	504	S18   
06128	504	S18   
06982	504	S18   
06983	504	S18   
06984	504	S2104 
06985	504	S2104 
07005	504	S248  
07015	504	S248  
07016	504	S248  
07022	504	S2    
07063	504	S1164 
07063	504	S582  
07945	504	S2    
07949	504	S2    
07950	504	S2    
07953	504	S1164 
07953	504	S582  
07954	504	S582  
07955	504	S1164 
07956	504	S1164 
07957	504	S1164 
07958	504	S1164 
07960	504	S1164 
08001	504	S1065 
08012	504	S1065 
08013	504	S1065 
08014	504	S1065 
08020	504	S1065 
08025	504	S2662 
08030	504	S1065 
08061	504	S1065 
08065	504	S1065 
08065	504	S2662 
08074	504	S2662 
08077	504	S1065 
08147	504	S1065 
08218	504	S1065 
08259	504	S2662 
08504	504	S2662 
08505	504	S2662 
08506	504	S2662 
08507	504	S2662 
08508	504	S2662 
08509	504	S2662 
09003	504	S561  
09004	504	S561  
09032	504	S21   
09033	504	S21   
09038	504	S481  
09038	504	S502  
09040	504	S481  
09040	504	S562  
09070	504	S582  
09078	504	S561  
09087	504	S564  
09087	504	S582  
09094	504	S363  
09094	504	S582  
09095	504	S363  
09095	504	S582  
09111	504	S482  
09111	504	S563  
09112	504	S482  
09112	504	S563  
09114	504	S482  
09114	504	S563  
09116	504	S482  
09116	504	S563  
09117	504	S482  
09117	504	S563  
09118	504	S482  
09118	504	S563  
09120	504	S482  
09120	504	S563  
09121	504	S482  
09121	504	S563  
09132	504	S1062 
09148	504	S363  
09148	504	S582  
09160	504	S1065 
09181	504	S1121 
09184	504	S562  
09184	504	S565  
09191	504	S421  
09191	504	S582  
09202	504	S482  
09202	504	S564  
09218	504	S1065 
09236	504	S582  
09252	504	S541  
09266	504	S441  
09266	504	S561  
09279	504	S582  
09291	504	S564  
09291	504	S566  
09298	504	S564  
09298	504	S566  
09421	504	S564  
09421	504	S582  
10007	504	S1082 
10066	504	S1082 
10067	504	S1082 
10068	504	S1082 
10123	504	S1082 
10124	504	S1082 
10858	504	S1082 
10860	504	S1082 
10861	504	S1082 
10862	504	S1082 
11090	504	S1121 
11090	504	S564  
11096	504	S1121 
11096	504	S482  
11097	504	S1121 
11097	504	S482  
11112	504	S1065 
11243	504	S2941 
11260	504	S2941 
11263	504	S2941 
11265	504	S2941 
11294	504	S563  
11294	504	S582  
11339	504	S1062 
11353	504	S563  
11353	504	S566  
11354	504	S563  
11354	504	S566  
11357	504	S563  
11357	504	S566  
11359	504	S2105 
11360	504	S2105 
11394	504	S2105 
11395	504	S2105 
11398	504	S2105 
11399	504	S2105 
11402	504	S2105 
11403	504	S2105 
11411	504	S2105 
11463	504	S25   
11464	504	S25   
11546	504	S21   
11856	504	S25   
11887	504	S21   
11921	504	S1062 
11950	504	S2941 
11987	504	S2941 
11992	504	S2941 
12006	504	D4822 
12006	504	D4861 
12006	504	S1782 
12061	504	S141  
12062	504	S141  
12063	504	S141  
12065	504	S141  
12078	504	S1063 
12078	504	S503  
12086	504	S363  
12086	504	S502  
12087	504	S363  
12087	504	S502  
12120	504	S83   
12121	504	S83   
12122	504	S83   
12131	504	S77   
12132	504	S77   
12142	504	S85   
12143	504	S85   
12144	504	S85   
12147	504	S502  
12147	504	S564  
12151	504	S86   
12152	504	S86   
12154	504	S1001 
12155	504	S79   
12201	504	S1164 
12220	504	D4743 
12220	504	S2109 
12563	504	S141  
12565	504	S141  
12586	504	S363  
12586	504	S502  
12632	504	S77   
12643	504	S85   
12644	504	S85   
12652	504	S86   
13004	504	S14   
13004	504	S2    
13011	504	S14   
13011	504	S2    
13012	504	S14   
13012	504	S2    
13019	504	S14   
13019	504	S2    
13020	504	S14   
13020	504	S2    
13022	504	S14   
13022	504	S2    
13024	504	S14   
13024	504	S2    
13039	504	S2    
13052	504	S14   
13052	504	S2    
13055	504	S14   
13055	504	S2    
13058	504	S14   
13058	504	S2    
13060	504	S14   
13060	504	S2    
13061	504	S14   
13061	504	S2    
13062	504	S14   
13062	504	S2    
13065	504	S14   
13065	504	S2    
13067	504	S14   
13067	504	S2    
13068	504	S14   
13068	504	S2    
13069	504	S14   
13069	504	S2    
13070	504	S14   
13070	504	S2    
13072	504	S14   
13072	504	S2    
13088	504	S14   
13088	504	S2    
13092	504	S14   
13092	504	S2    
13096	504	S14   
13096	504	S2    
13098	504	S14   
13098	504	S2    
13113	504	S14   
13113	504	S2    
13143	504	S14   
13143	504	S2    
13148	504	S14   
13148	504	S2    
13150	504	S14   
13150	504	S2    
13151	504	S14   
13151	504	S2    
13152	504	S14   
13152	504	S2    
13155	504	S14   
13155	504	S2    
13156	504	S14   
13156	504	S2    
13165	504	S14   
13165	504	S2    
13192	504	S14   
13192	504	S2    
13194	504	S14   
13194	504	S2    
13196	504	S14   
13196	504	S2    
13200	504	S14   
13200	504	S2    
13202	504	S14   
13202	504	S2    
13204	504	S14   
13204	504	S2    
13211	504	S14   
13211	504	S2    
13220	504	S14   
13220	504	S2    
13231	504	S2    
13232	504	S2    
13235	504	S2    
13236	504	S2    
13260	504	S14   
13260	504	S2    
13281	504	S14   
13281	504	S2    
13290	504	S14   
13290	504	S2    
13325	504	S1082 
13326	504	S1082 
13327	504	S1082 
13335	504	S14   
13335	504	S2    
13343	504	S14   
13343	504	S2    
13347	504	S14   
13347	504	S2    
13361	504	S14   
13361	504	S2    
13364	504	S14   
13364	504	S2    
13367	504	S14   
13367	504	S2    
13368	504	S14   
13368	504	S2    
13369	504	S14   
13369	504	S2    
13370	504	S14   
13370	504	S2    
13373	504	S14   
13373	504	S2    
13375	504	S14   
13375	504	S2    
13377	504	S14   
13377	504	S2    
13378	504	S14   
13378	504	S2    
13382	504	S14   
13382	504	S2    
13388	504	S14   
13388	504	S2    
13391	504	S14   
13391	504	S2    
13394	504	S14   
13394	504	S2    
13398	504	S14   
13398	504	S2    
13399	504	S14   
13399	504	S2    
13401	504	S14   
13401	504	S2    
13402	504	S14   
13402	504	S2    
13404	504	S14   
13404	504	S2    
13405	504	S14   
13405	504	S2    
13407	504	S14   
13407	504	S2    
13408	504	S14   
13408	504	S2    
13410	504	S14   
13410	504	S2    
13411	504	S14   
13411	504	S2    
13413	504	S14   
13413	504	S2    
13414	504	S14   
13414	504	S2    
13415	504	S14   
13415	504	S2    
13416	504	S14   
13416	504	S2    
13417	504	S14   
13417	504	S2    
13419	504	S14   
13419	504	S2    
13420	504	S14   
13420	504	S2    
13421	504	S14   
13421	504	S2    
13422	504	S14   
13422	504	S2    
13423	504	S14   
13423	504	S2    
13424	504	S14   
13424	504	S2    
13425	504	S14   
13425	504	S2    
13426	504	S14   
13426	504	S2    
13427	504	S14   
13427	504	S2    
13428	504	S14   
13428	504	S2    
13431	504	S14   
13431	504	S2    
13433	504	S14   
13433	504	S2    
13434	504	S14   
13434	504	S2    
13439	504	S14   
13439	504	S2    
13440	504	S14   
13440	504	S2    
13441	504	S14   
13441	504	S2    
13443	504	S14   
13443	504	S2    
13444	504	S14   
13444	504	S2    
13445	504	S14   
13445	504	S2    
13446	504	S14   
13446	504	S2    
13447	504	S14   
13447	504	S2    
13448	504	S14   
13448	504	S2    
13449	504	S14   
13449	504	S2    
13450	504	S14   
13450	504	S2    
13451	504	S14   
13451	504	S2    
13452	504	S14   
13452	504	S2    
13453	504	S14   
13453	504	S2    
13454	504	S14   
13454	504	S2    
13455	504	S14   
13455	504	S2    
13456	504	S14   
13456	504	S2    
13467	504	S2    
13468	504	S2    
13469	504	S2    
13470	504	S2    
13481	504	S2    
13482	504	S2    
13483	504	S2    
13484	504	S2    
13485	504	S14   
13485	504	S2    
13486	504	S14   
13486	504	S2    
13487	504	S14   
13487	504	S2    
13488	504	S14   
13488	504	S2    
13490	504	S14   
13490	504	S2    
13491	504	S14   
13491	504	S2    
13492	504	S14   
13492	504	S2    
13493	504	S14   
13493	504	S2    
13494	504	S14   
13495	504	S14   
13496	504	S14   
13497	504	S14   
13498	504	S14   
13565	504	S14   
13565	504	S2    
13566	504	S14   
13566	504	S2    
13567	504	S14   
13567	504	S2    
13568	504	S14   
13568	504	S2    
13569	504	S14   
13569	504	S2    
13805	504	S14   
13805	504	S2    
13806	504	S14   
13806	504	S2    
13809	504	S14   
13809	504	S2    
13810	504	S14   
13810	504	S2    
13811	504	S14   
13811	504	S2    
13812	504	S14   
13812	504	S2    
13813	504	S14   
13813	504	S2    
13814	504	S14   
13814	504	S2    
13850	504	S14   
13850	504	S2    
13851	504	S14   
13851	504	S2    
13853	504	S14   
13853	504	S2    
13854	504	S14   
13854	504	S2    
13856	504	S14   
13856	504	S2    
13857	504	S14   
13857	504	S2    
13868	504	S14   
13868	504	S2    
13869	504	S14   
13869	504	S2    
13870	504	S14   
13870	504	S2    
13871	504	S14   
13871	504	S2    
13872	504	S14   
13872	504	S2    
13873	504	S14   
13873	504	S2    
13874	504	S14   
13874	504	S2    
13875	504	S14   
13875	504	S2    
13876	504	S14   
13876	504	S2    
13877	504	S14   
13877	504	S2    
13878	504	S14   
13878	504	S2    
13879	504	S14   
13879	504	S2    
13880	504	S14   
13880	504	S2    
13881	504	S14   
13881	504	S2    
13882	504	S14   
13882	504	S2    
13891	504	S14   
13891	504	S2    
13893	504	S14   
13893	504	S2    
13894	504	S14   
13894	504	S2    
13896	504	S14   
13896	504	S2    
13898	504	S14   
13898	504	S2    
13900	504	S14   
13900	504	S2    
13909	504	S14   
13909	504	S2    
13910	504	S14   
13910	504	S2    
13911	504	S14   
13911	504	S2    
13912	504	S14   
13912	504	S2    
13913	504	S14   
13913	504	S2    
13914	504	S14   
13914	504	S2    
13917	504	S14   
13917	504	S2    
13918	504	S14   
13918	504	S2    
13920	504	S14   
13920	504	S2    
13921	504	S14   
13921	504	S2    
13923	504	S14   
13923	504	S2    
13924	504	S14   
13924	504	S2    
13929	504	S14   
13929	504	S2    
13930	504	S14   
13930	504	S2    
13931	504	S14   
13931	504	S2    
13932	504	S14   
13932	504	S2    
13934	504	S14   
13934	504	S2    
13935	504	S14   
13935	504	S2    
13936	504	S2    
13937	504	S2    
13938	504	S2    
13939	504	S2    
13940	504	S2    
13941	504	S2    
13942	504	S2    
13943	504	S2    
13944	504	S2    
13945	504	S2    
13946	504	S2    
13947	504	S2    
13948	504	S14   
13948	504	S2    
13949	504	S14   
13949	504	S2    
13950	504	S14   
13950	504	S2    
13951	504	S14   
13951	504	S2    
13952	504	S14   
13952	504	S2    
13953	504	S14   
13953	504	S2    
13954	504	S14   
13954	504	S2    
13955	504	S14   
13955	504	S2    
13956	504	S14   
13956	504	S2    
13957	504	S14   
13957	504	S2    
13958	504	S14   
13958	504	S2    
13959	504	S14   
13959	504	S2    
13960	504	S2    
13961	504	S2    
13962	504	S2    
13963	504	S2    
13964	504	S2    
13965	504	S2    
13966	504	S2    
13967	504	S2    
13968	504	S14   
13968	504	S2    
13969	504	S14   
13969	504	S2    
13970	504	S14   
13970	504	S2    
13971	504	S14   
13971	504	S2    
13976	504	S2    
13977	504	S2    
13978	504	S2    
13979	504	S2    
13985	504	S14   
13985	504	S2    
13987	504	S2    
13988	504	S14   
13988	504	S2    
13989	504	S14   
13989	504	S2    
13990	504	S14   
13990	504	S2    
13991	504	S14   
13991	504	S2    
13992	504	S14   
13992	504	S2    
13994	504	S14   
13994	504	S2    
13995	504	S14   
13995	504	S2    
13996	504	S14   
13996	504	S2    
13997	504	S14   
13997	504	S2    
13998	504	S14   
13998	504	S2    
14003	504	S2103 
14006	504	S2103 
14347	504	S1064 
14347	504	S1122 
15073	504	S1163 
15087	504	S2109 
15152	504	S2104 
15232	504	S1163 
15260	504	S2109 
15261	504	S1163 
15262	504	S1163 
16006	504	S1164 
16011	504	S1164 
16037	504	S1164 
16038	504	S1164 
16042	504	S1065 
16089	504	S563  
16114	504	S39   
16120	504	S39   
16139	504	S39   
16147	504	S2104 
16338	504	S1164 
17202	504	S1082 
17203	504	S1082 
17204	504	S1082 
18166	504	S25   
19064	504	S1164 
19078	504	S1069 
19109	504	S1164 
19155	504	S1164 
19337	504	S2109 
20046	504	S1164 
20046	504	S20   
20047	504	S1164 
20047	504	S20   
20048	504	S1164 
20048	504	S20   
20049	504	S1164 
20049	504	S20   
20099	504	S1163 
20099	504	S20   
20100	504	S1163 
20100	504	S20   
20109	504	S2105 
20110	504	S2105 
20120	504	S1163 
20120	504	S20   
20121	504	S1163 
20121	504	S20   
20310	504	S2105 
20321	504	S1163 
20321	504	S20   
20400	504	S1163 
20400	504	S20   
20409	504	S2105 
20410	504	S2105 
20420	504	S1163 
20420	504	S20   
20421	504	S1163 
20421	504	S20   
20446	504	S1164 
20446	504	S20   
20447	504	S1164 
20447	504	S20   
20499	504	S1163 
20499	504	S20   
20510	504	S2105 
20521	504	S1163 
20521	504	S20   
20623	504	S1742 
20624	504	S1742 
20628	504	S1742 
20629	504	S1742 
20630	504	S1742 
20634	504	S1742 
20635	504	S1742 
20636	504	S1742 
20640	504	S1742 
20641	504	S1742 
20645	504	S1742 
20646	504	S1742 
21138	504	S1064 
21138	504	S1066 
21138	504	S1122 
21224	504	S19   
21225	504	S19   
21229	504	S1122 
21239	504	S1066 
21240	504	S1066 
21241	504	S1066 
21242	504	S1066 
21243	504	S1066 
21244	504	S1066 
21245	504	S1066 
21246	504	S1066 
21247	504	S1066 
21248	504	S1066 
21249	504	S1064 
21250	504	S1064 
21251	504	S1064 
21252	504	S1064 
21253	504	S1064 
21254	504	S1064 
21255	504	S1064 
21256	504	S1064 
21257	504	S1064 
21259	504	S1064 
21260	504	S1082 
21261	504	S1082 
21262	504	S1082 
21263	504	S1082 
21264	504	S1082 
21265	504	S1082 
21266	504	S1082 
21267	504	S1082 
21268	504	S1082 
21269	504	S1082 
21270	504	S1082 
21271	504	S2108 
21272	504	S2108 
21273	504	S2108 
21274	504	S2108 
21275	504	S2108 
21276	504	S2108 
21278	504	S2110 
21279	504	S2110 
21280	504	S2110 
21281	504	S2110 
21282	504	S2110 
21285	504	S2111 
21286	504	S2111 
21289	504	S2112 
21290	504	S2112 
21291	504	S2112 
21292	504	S2112 
21295	504	S2782 
21298	504	S2782 
21299	504	S2108 
21300	504	S2108 
21300	504	S2110 
21300	504	S2112 
21301	504	S2108 
21301	504	S2110 
21301	504	S2111 
21301	504	S2112 
21301	504	S2782 
21302	504	S2108 
21303	504	S2108 
21303	504	S2110 
21303	504	S2112 
21304	504	S2108 
21304	504	S2110 
21304	504	S2111 
21304	504	S2112 
21304	504	S2782 
22911	504	S18   
23009	504	S14   
23009	504	S2    
23010	504	S14   
23010	504	S2    
23011	504	S14   
23011	504	S2    
23012	504	S14   
23012	504	S2    
23013	504	S14   
23013	504	S2    
23014	504	S14   
23014	504	S2    
23015	504	S14   
23015	504	S2    
23016	504	S14   
23016	504	S2    
23017	504	S14   
23017	504	S2    
23018	504	S14   
23018	504	S2    
23019	504	S14   
23019	504	S2    
23020	504	S14   
23020	504	S2    
23021	504	S14   
23021	504	S2    
23022	504	S14   
23022	504	S2    
23023	504	S14   
23023	504	S2    
23024	504	S14   
23024	504	S2    
23025	504	S14   
23025	504	S2    
23027	504	S14   
23027	504	S2    
23028	504	S14   
23028	504	S2    
23029	504	S14   
23029	504	S2    
23030	504	S14   
23030	504	S2    
23031	504	S14   
23031	504	S2    
23032	504	S14   
23032	504	S2    
23033	504	S14   
23033	504	S2    
23034	504	S14   
23034	504	S2    
23035	504	S14   
23035	504	S2    
23036	504	S14   
23036	504	S2    
23037	504	S14   
23037	504	S2    
23038	504	S14   
23038	504	S2    
23039	504	S14   
23039	504	S2    
23040	504	S14   
23040	504	S2    
23041	504	S14   
23041	504	S2    
23042	504	S14   
23042	504	S2    
23043	504	S14   
23043	504	S2    
23044	504	S14   
23044	504	S2    
23045	504	S14   
23045	504	S2    
23046	504	S14   
23046	504	S2    
23047	504	S14   
23047	504	S2    
23048	504	S14   
23048	504	S2    
23049	504	S14   
23049	504	S2    
23050	504	S14   
23050	504	S2    
23051	504	S14   
23051	504	S2    
23052	504	S14   
23052	504	S2    
23053	504	S14   
23053	504	S2    
23054	504	S14   
23054	504	S2    
23055	504	S14   
23055	504	S2    
23056	504	S14   
23056	504	S2    
23057	504	S14   
23057	504	S2    
23058	504	S14   
23058	504	S2    
23059	504	S14   
23059	504	S2    
23060	504	S14   
23060	504	S2    
23061	504	S14   
23061	504	S2    
23062	504	S14   
23062	504	S2    
23063	504	S14   
23063	504	S2    
23064	504	S14   
23064	504	S2    
23065	504	S14   
23065	504	S2    
23557	504	S14   
23558	504	S14   
23559	504	S14   
23560	504	S14   
23561	504	S14   
23562	504	S14   
23563	504	S14   
23564	504	S14   
23565	504	S14   
23566	504	S14   
23567	504	S14   
23568	504	S14   
23569	504	S14   
23570	504	S14   
23571	504	S14   
23572	504	S14   
23573	504	S14   
23574	504	S14   
23575	504	S14   
23576	504	S14   
23577	504	S14   
23578	504	S14   
23579	504	S14   
23580	504	S14   
23581	504	S14   
23582	504	S14   
23582	504	S2    
23583	504	S14   
23583	504	S2    
23584	504	S14   
23584	504	S2    
23585	504	S14   
23585	504	S2    
23586	504	S14   
23586	504	S2    
23587	504	S14   
23587	504	S2    
23588	504	S14   
23588	504	S2    
23589	504	S14   
23589	504	S2    
23590	504	S14   
23590	504	S2    
23591	504	S14   
23591	504	S2    
23592	504	S14   
23592	504	S2    
23593	504	S14   
23593	504	S2    
23594	504	S14   
23594	504	S2    
23595	504	S14   
23595	504	S2    
23596	504	S14   
23596	504	S2    
23597	504	S14   
23597	504	S2    
23598	504	S14   
23598	504	S2    
23599	504	S14   
23599	504	S2    
23600	504	S14   
23600	504	S2    
23601	504	S14   
23601	504	S2    
23602	504	S14   
23602	504	S2    
23603	504	S14   
23603	504	S2    
23604	504	S14   
23604	504	S2    
23605	504	S14   
23605	504	S2    
23606	504	S14   
23606	504	S2    
23607	504	S14   
23607	504	S2    
23608	504	S14   
23608	504	S2    
23609	504	S14   
23609	504	S2    
23610	504	S14   
23610	504	S2    
23611	504	S14   
23611	504	S2    
23612	504	S14   
23612	504	S2    
23613	504	S14   
23613	504	S2    
23614	504	S14   
23614	504	S2    
23615	504	S14   
23615	504	S2    
23616	504	S14   
23616	504	S2    
23617	504	S14   
23617	504	S2    
23618	504	S14   
23618	504	S2    
23619	504	S14   
23619	504	S2    
23620	504	S14   
23620	504	S2    
23621	504	S14   
23621	504	S2    
23622	504	S14   
23622	504	S2    
23623	504	S14   
23623	504	S2    
23624	504	S14   
23624	504	S2    
23625	504	S14   
23625	504	S2    
23626	504	S14   
23626	504	S2    
23627	504	S14   
23627	504	S2    
23628	504	S14   
23628	504	S2    
23629	504	S14   
23629	504	S2    
23630	504	S14   
23630	504	S2    
23631	504	S14   
23631	504	S2    
23632	504	S14   
23632	504	S2    
23633	504	S14   
23633	504	S2    
23634	504	S14   
23634	504	S2    
23635	504	S14   
23635	504	S2    
23636	504	S14   
23636	504	S2    
23637	504	S14   
23637	504	S2    
23638	504	S14   
23638	504	S2    
23646	504	S14   
23646	504	S2    
23647	504	S14   
23647	504	S2    
23648	504	S14   
23648	504	S2    
23649	504	S14   
23649	504	S2    
23650	504	S14   
23650	504	S2    
23651	504	S14   
23651	504	S2    
23652	504	S14   
23652	504	S2    
23653	504	S14   
23653	504	S2    
23654	504	S14   
23654	504	S2    
23655	504	S14   
23655	504	S2    
23656	504	S14   
23656	504	S2    
23657	504	S14   
23657	504	S2    
23658	504	S14   
23658	504	S2    
23659	504	S14   
23659	504	S2    
23660	504	S14   
23660	504	S2    
35135	504	S2381 
35136	504	S2381 
35137	504	S2381 
35141	504	S2381 
35143	504	S2381 
35145	504	S2381 
35146	504	S2381 
35147	504	S2381 
43297	504	S1082 
43378	504	S1082 
01026	505	S27   
01029	505	S27   
01032	505	S19   
01046	505	S19   
01077	505	S27   
01079	505	S1063 
01079	505	S20   
01082	505	S1063 
01085	505	S1063 
01103	505	S1163 
01123	505	S1063 
01123	505	S561  
01124	505	S1065 
01125	505	S1065 
01128	505	S1063 
01128	505	S561  
01130	505	S1063 
01130	505	S561  
01131	505	S1063 
01131	505	S561  
01202	505	S1163 
04017	505	S19   
04023	505	S19   
04114	505	S19   
04640	505	S26   
05027	505	S1082 
05028	505	S1082 
05312	505	S26   
05313	505	S26   
05320	505	S26   
05661	505	S1082 
06019	505	S18   
06128	505	S18   
06982	505	S18   
06983	505	S18   
06984	505	S2104 
06985	505	S2104 
07005	505	S248  
07015	505	S248  
07016	505	S248  
07022	505	S2    
07063	505	S1164 
07063	505	S582  
07945	505	S2    
07949	505	S2    
07950	505	S2    
07953	505	S1164 
07953	505	S582  
07954	505	S582  
07955	505	S1164 
07956	505	S1164 
07957	505	S1164 
07958	505	S1164 
07960	505	S1164 
08001	505	S1065 
08012	505	S1065 
08013	505	S1065 
08014	505	S1065 
08020	505	S1065 
08025	505	S2662 
08030	505	S1065 
08061	505	S1065 
08065	505	S1065 
08065	505	S2662 
08074	505	S2662 
08077	505	S1065 
08147	505	S1065 
08218	505	S1065 
08259	505	S2662 
08504	505	S2662 
08505	505	S2662 
08506	505	S2662 
08507	505	S2662 
08508	505	S2662 
08509	505	S2662 
09003	505	S561  
09004	505	S561  
09032	505	S21   
09033	505	S21   
09038	505	S481  
09038	505	S502  
09040	505	S481  
09040	505	S562  
09070	505	S582  
09078	505	S561  
09087	505	S564  
09087	505	S582  
09094	505	S363  
09094	505	S582  
09095	505	S363  
09095	505	S582  
09111	505	S482  
09111	505	S563  
09112	505	S482  
09112	505	S563  
09114	505	S482  
09114	505	S563  
09116	505	S482  
09116	505	S563  
09117	505	S482  
09117	505	S563  
09118	505	S482  
09118	505	S563  
09120	505	S482  
09120	505	S563  
09121	505	S482  
09121	505	S563  
09132	505	S1062 
09148	505	S363  
09148	505	S582  
09160	505	S1065 
09181	505	S1121 
09184	505	S562  
09184	505	S565  
09191	505	S421  
09191	505	S582  
09202	505	S482  
09202	505	S564  
09218	505	S1065 
09236	505	S582  
09252	505	S541  
09266	505	S441  
09266	505	S561  
09279	505	S582  
09291	505	S564  
09291	505	S566  
09298	505	S564  
09298	505	S566  
09421	505	S564  
09421	505	S582  
10007	505	S1082 
10066	505	S1082 
10067	505	S1082 
10068	505	S1082 
10123	505	S1082 
10124	505	S1082 
10858	505	S1082 
10860	505	S1082 
10861	505	S1082 
10862	505	S1082 
11090	505	S1121 
11090	505	S564  
11096	505	S1121 
11096	505	S482  
11097	505	S1121 
11097	505	S482  
11112	505	S1065 
11243	505	S2941 
11260	505	S2941 
11263	505	S2941 
11265	505	S2941 
11294	505	S563  
11294	505	S582  
11339	505	S1062 
11353	505	S563  
11353	505	S566  
11354	505	S563  
11354	505	S566  
11357	505	S563  
11357	505	S566  
11359	505	S2105 
11360	505	S2105 
11394	505	S2105 
11395	505	S2105 
11398	505	S2105 
11399	505	S2105 
11402	505	S2105 
11403	505	S2105 
11411	505	S2105 
11463	505	S25   
11464	505	S25   
11546	505	S21   
11856	505	S25   
11887	505	S21   
11921	505	S1062 
11950	505	S2941 
11987	505	S2941 
11992	505	S2941 
12006	505	D4822 
12006	505	D4861 
12006	505	S1782 
12061	505	S141  
12062	505	S141  
12063	505	S141  
12065	505	S141  
12078	505	S1063 
12078	505	S503  
12086	505	S363  
12086	505	S502  
12087	505	S363  
12087	505	S502  
12120	505	S83   
12121	505	S83   
12122	505	S83   
12131	505	S77   
12132	505	S77   
12142	505	S85   
12143	505	S85   
12144	505	S85   
12147	505	S502  
12147	505	S564  
12151	505	S86   
12152	505	S86   
12154	505	S1001 
12155	505	S79   
12201	505	S1164 
12220	505	D4743 
12220	505	S2109 
12563	505	S141  
12565	505	S141  
12586	505	S363  
12586	505	S502  
12632	505	S77   
12643	505	S85   
12644	505	S85   
12652	505	S86   
13004	505	S14   
13004	505	S2    
13011	505	S14   
13011	505	S2    
13012	505	S14   
13012	505	S2    
13019	505	S14   
13019	505	S2    
13020	505	S14   
13020	505	S2    
13022	505	S14   
13022	505	S2    
13024	505	S14   
13024	505	S2    
13039	505	S2    
13052	505	S14   
13052	505	S2    
13055	505	S14   
13055	505	S2    
13058	505	S14   
13058	505	S2    
13060	505	S14   
13060	505	S2    
13061	505	S14   
13061	505	S2    
13062	505	S14   
13062	505	S2    
13065	505	S14   
13065	505	S2    
13067	505	S14   
13067	505	S2    
13068	505	S14   
13068	505	S2    
13069	505	S14   
13069	505	S2    
13070	505	S14   
13070	505	S2    
13072	505	S14   
13072	505	S2    
13088	505	S14   
13088	505	S2    
13092	505	S14   
13092	505	S2    
13096	505	S14   
13096	505	S2    
13098	505	S14   
13098	505	S2    
13113	505	S14   
13113	505	S2    
13143	505	S14   
13143	505	S2    
13148	505	S14   
13148	505	S2    
13150	505	S14   
13150	505	S2    
13151	505	S14   
13151	505	S2    
13152	505	S14   
13152	505	S2    
13155	505	S14   
13155	505	S2    
13156	505	S14   
13156	505	S2    
13165	505	S14   
13165	505	S2    
13192	505	S14   
13192	505	S2    
13194	505	S14   
13194	505	S2    
13196	505	S14   
13196	505	S2    
13200	505	S14   
13200	505	S2    
13202	505	S14   
13202	505	S2    
13204	505	S14   
13204	505	S2    
13211	505	S14   
13211	505	S2    
13220	505	S14   
13220	505	S2    
13231	505	S2    
13232	505	S2    
13235	505	S2    
13236	505	S2    
13260	505	S14   
13260	505	S2    
13281	505	S14   
13281	505	S2    
13290	505	S14   
13290	505	S2    
13325	505	S1082 
13326	505	S1082 
13327	505	S1082 
13335	505	S14   
13335	505	S2    
13343	505	S14   
13343	505	S2    
13347	505	S14   
13347	505	S2    
13361	505	S14   
13361	505	S2    
13364	505	S14   
13364	505	S2    
13367	505	S14   
13367	505	S2    
13368	505	S14   
13368	505	S2    
13369	505	S14   
13369	505	S2    
13370	505	S14   
13370	505	S2    
13373	505	S14   
13373	505	S2    
13375	505	S14   
13375	505	S2    
13377	505	S14   
13377	505	S2    
13378	505	S14   
13378	505	S2    
13382	505	S14   
13382	505	S2    
13388	505	S14   
13388	505	S2    
13391	505	S14   
13391	505	S2    
13394	505	S14   
13394	505	S2    
13398	505	S14   
13398	505	S2    
13399	505	S14   
13399	505	S2    
13401	505	S14   
13401	505	S2    
13402	505	S14   
13402	505	S2    
13404	505	S14   
13404	505	S2    
13405	505	S14   
13405	505	S2    
13407	505	S14   
13407	505	S2    
13408	505	S14   
13408	505	S2    
13410	505	S14   
13410	505	S2    
13411	505	S14   
13411	505	S2    
13413	505	S14   
13413	505	S2    
13414	505	S14   
13414	505	S2    
13415	505	S14   
13415	505	S2    
13416	505	S14   
13416	505	S2    
13417	505	S14   
13417	505	S2    
13419	505	S14   
13419	505	S2    
13420	505	S14   
13420	505	S2    
13421	505	S14   
13421	505	S2    
13422	505	S14   
13422	505	S2    
13423	505	S14   
13423	505	S2    
13424	505	S14   
13424	505	S2    
13425	505	S14   
13425	505	S2    
13426	505	S14   
13426	505	S2    
13427	505	S14   
13427	505	S2    
13428	505	S14   
13428	505	S2    
13431	505	S14   
13431	505	S2    
13433	505	S14   
13433	505	S2    
13434	505	S14   
13434	505	S2    
13439	505	S14   
13439	505	S2    
13440	505	S14   
13440	505	S2    
13441	505	S14   
13441	505	S2    
13443	505	S14   
13443	505	S2    
13444	505	S14   
13444	505	S2    
13445	505	S14   
13445	505	S2    
13446	505	S14   
13446	505	S2    
13447	505	S14   
13447	505	S2    
13448	505	S14   
13448	505	S2    
13449	505	S14   
13449	505	S2    
13450	505	S14   
13450	505	S2    
13451	505	S14   
13451	505	S2    
13452	505	S14   
13452	505	S2    
13453	505	S14   
13453	505	S2    
13454	505	S14   
13454	505	S2    
13455	505	S14   
13455	505	S2    
13456	505	S14   
13456	505	S2    
13467	505	S2    
13468	505	S2    
13469	505	S2    
13470	505	S2    
13481	505	S2    
13482	505	S2    
13483	505	S2    
13484	505	S2    
13485	505	S14   
13485	505	S2    
13486	505	S14   
13486	505	S2    
13487	505	S14   
13487	505	S2    
13488	505	S14   
13488	505	S2    
13490	505	S14   
13490	505	S2    
13491	505	S14   
13491	505	S2    
13492	505	S14   
13492	505	S2    
13493	505	S14   
13493	505	S2    
13494	505	S14   
13495	505	S14   
13496	505	S14   
13497	505	S14   
13498	505	S14   
13565	505	S14   
13565	505	S2    
13566	505	S14   
13566	505	S2    
13567	505	S14   
13567	505	S2    
13568	505	S14   
13568	505	S2    
13569	505	S14   
13569	505	S2    
13805	505	S14   
13805	505	S2    
13806	505	S14   
13806	505	S2    
13809	505	S14   
13809	505	S2    
13810	505	S14   
13810	505	S2    
13811	505	S14   
13811	505	S2    
13812	505	S14   
13812	505	S2    
13813	505	S14   
13813	505	S2    
13814	505	S14   
13814	505	S2    
13850	505	S14   
13850	505	S2    
13851	505	S14   
13851	505	S2    
13853	505	S14   
13853	505	S2    
13854	505	S14   
13854	505	S2    
13856	505	S14   
13856	505	S2    
13857	505	S14   
13857	505	S2    
13868	505	S14   
13868	505	S2    
13869	505	S14   
13869	505	S2    
13870	505	S14   
13870	505	S2    
13871	505	S14   
13871	505	S2    
13872	505	S14   
13872	505	S2    
13873	505	S14   
13873	505	S2    
13874	505	S14   
13874	505	S2    
13875	505	S14   
13875	505	S2    
13876	505	S14   
13876	505	S2    
13877	505	S14   
13877	505	S2    
13878	505	S14   
13878	505	S2    
13879	505	S14   
13879	505	S2    
13880	505	S14   
13880	505	S2    
13881	505	S14   
13881	505	S2    
13882	505	S14   
13882	505	S2    
13891	505	S14   
13891	505	S2    
13893	505	S14   
13893	505	S2    
13894	505	S14   
13894	505	S2    
13896	505	S14   
13896	505	S2    
13898	505	S14   
13898	505	S2    
13900	505	S14   
13900	505	S2    
13909	505	S14   
13909	505	S2    
13910	505	S14   
13910	505	S2    
13911	505	S14   
13911	505	S2    
13912	505	S14   
13912	505	S2    
13913	505	S14   
13913	505	S2    
13914	505	S14   
13914	505	S2    
13917	505	S14   
13917	505	S2    
13918	505	S14   
13918	505	S2    
13920	505	S14   
13920	505	S2    
13921	505	S14   
13921	505	S2    
13923	505	S14   
13923	505	S2    
13924	505	S14   
13924	505	S2    
13929	505	S14   
13929	505	S2    
13930	505	S14   
13930	505	S2    
13931	505	S14   
13931	505	S2    
13932	505	S14   
13932	505	S2    
13934	505	S14   
13934	505	S2    
13935	505	S14   
13935	505	S2    
13936	505	S2    
13937	505	S2    
13938	505	S2    
13939	505	S2    
13940	505	S2    
13941	505	S2    
13942	505	S2    
13943	505	S2    
13944	505	S2    
13945	505	S2    
13946	505	S2    
13947	505	S2    
13948	505	S14   
13948	505	S2    
13949	505	S14   
13949	505	S2    
13950	505	S14   
13950	505	S2    
13951	505	S14   
13951	505	S2    
13952	505	S14   
13952	505	S2    
13953	505	S14   
13953	505	S2    
13954	505	S14   
13954	505	S2    
13955	505	S14   
13955	505	S2    
13956	505	S14   
13956	505	S2    
13957	505	S14   
13957	505	S2    
13958	505	S14   
13958	505	S2    
13959	505	S14   
13959	505	S2    
13960	505	S2    
13961	505	S2    
13962	505	S2    
13963	505	S2    
13964	505	S2    
13965	505	S2    
13966	505	S2    
13967	505	S2    
13968	505	S14   
13968	505	S2    
13969	505	S14   
13969	505	S2    
13970	505	S14   
13970	505	S2    
13971	505	S14   
13971	505	S2    
13976	505	S2    
13977	505	S2    
13978	505	S2    
13979	505	S2    
13985	505	S14   
13985	505	S2    
13987	505	S2    
13988	505	S14   
13988	505	S2    
13989	505	S14   
13989	505	S2    
13990	505	S14   
13990	505	S2    
13991	505	S14   
13991	505	S2    
13992	505	S14   
13992	505	S2    
13994	505	S14   
13994	505	S2    
13995	505	S14   
13995	505	S2    
13996	505	S14   
13996	505	S2    
13997	505	S14   
13997	505	S2    
13998	505	S14   
13998	505	S2    
14003	505	S2103 
14006	505	S2103 
14347	505	S1064 
14347	505	S1122 
15073	505	S1163 
15087	505	S2109 
15152	505	S2104 
15232	505	S1163 
15260	505	S2109 
15261	505	S1163 
15262	505	S1163 
16006	505	S1164 
16011	505	S1164 
16037	505	S1164 
16038	505	S1164 
16042	505	S1065 
16089	505	S563  
16114	505	S39   
16120	505	S39   
16139	505	S39   
16147	505	S2104 
16338	505	S1164 
17202	505	S1082 
17203	505	S1082 
17204	505	S1082 
18166	505	S25   
19064	505	S1164 
19078	505	S1069 
19109	505	S1164 
19155	505	S1164 
19337	505	S2109 
20046	505	S1164 
20046	505	S20   
20047	505	S1164 
20047	505	S20   
20048	505	S1164 
20048	505	S20   
20049	505	S1164 
20049	505	S20   
20099	505	S1163 
20099	505	S20   
20100	505	S1163 
20100	505	S20   
20109	505	S2105 
20110	505	S2105 
20120	505	S1163 
20120	505	S20   
20121	505	S1163 
20121	505	S20   
20310	505	S2105 
20321	505	S1163 
20321	505	S20   
20400	505	S1163 
20400	505	S20   
20409	505	S2105 
20410	505	S2105 
20420	505	S1163 
20420	505	S20   
20421	505	S1163 
20421	505	S20   
20446	505	S1164 
20446	505	S20   
20447	505	S1164 
20447	505	S20   
20499	505	S1163 
20499	505	S20   
20510	505	S2105 
20521	505	S1163 
20521	505	S20   
20623	505	S1742 
20624	505	S1742 
20628	505	S1742 
20629	505	S1742 
20630	505	S1742 
20634	505	S1742 
20635	505	S1742 
20636	505	S1742 
20640	505	S1742 
20641	505	S1742 
20645	505	S1742 
20646	505	S1742 
21138	505	S1064 
21138	505	S1066 
21138	505	S1122 
21224	505	S19   
21225	505	S19   
21229	505	S1122 
21239	505	S1066 
21240	505	S1066 
21241	505	S1066 
21242	505	S1066 
21243	505	S1066 
21244	505	S1066 
21245	505	S1066 
21246	505	S1066 
21247	505	S1066 
21248	505	S1066 
21249	505	S1064 
21250	505	S1064 
21251	505	S1064 
21252	505	S1064 
21253	505	S1064 
21254	505	S1064 
21255	505	S1064 
21256	505	S1064 
21257	505	S1064 
21259	505	S1064 
21260	505	S1082 
21261	505	S1082 
21262	505	S1082 
21263	505	S1082 
21264	505	S1082 
21265	505	S1082 
21266	505	S1082 
21267	505	S1082 
21268	505	S1082 
21269	505	S1082 
21270	505	S1082 
21271	505	S2108 
21272	505	S2108 
21273	505	S2108 
21274	505	S2108 
21275	505	S2108 
21276	505	S2108 
21278	505	S2110 
21279	505	S2110 
21280	505	S2110 
21281	505	S2110 
21282	505	S2110 
21285	505	S2111 
21286	505	S2111 
21289	505	S2112 
21290	505	S2112 
21291	505	S2112 
21292	505	S2112 
21295	505	S2782 
21298	505	S2782 
21299	505	S2108 
21300	505	S2108 
21300	505	S2110 
21300	505	S2112 
21301	505	S2108 
21301	505	S2110 
21301	505	S2111 
21301	505	S2112 
21301	505	S2782 
21302	505	S2108 
21303	505	S2108 
21303	505	S2110 
21303	505	S2112 
21304	505	S2108 
21304	505	S2110 
21304	505	S2111 
21304	505	S2112 
21304	505	S2782 
22911	505	S18   
23009	505	S14   
23009	505	S2    
23010	505	S14   
23010	505	S2    
23011	505	S14   
23011	505	S2    
23012	505	S14   
23012	505	S2    
23013	505	S14   
23013	505	S2    
23014	505	S14   
23014	505	S2    
23015	505	S14   
23015	505	S2    
23016	505	S14   
23016	505	S2    
23017	505	S14   
23017	505	S2    
23018	505	S14   
23018	505	S2    
23019	505	S14   
23019	505	S2    
23020	505	S14   
23020	505	S2    
23021	505	S14   
23021	505	S2    
23022	505	S14   
23022	505	S2    
23023	505	S14   
23023	505	S2    
23024	505	S14   
23024	505	S2    
23025	505	S14   
23025	505	S2    
23027	505	S14   
23027	505	S2    
23028	505	S14   
23028	505	S2    
23029	505	S14   
23029	505	S2    
23030	505	S14   
23030	505	S2    
23031	505	S14   
23031	505	S2    
23032	505	S14   
23032	505	S2    
23033	505	S14   
23033	505	S2    
23034	505	S14   
23034	505	S2    
23035	505	S14   
23035	505	S2    
23036	505	S14   
23036	505	S2    
23037	505	S14   
23037	505	S2    
23038	505	S14   
23038	505	S2    
23039	505	S14   
23039	505	S2    
23040	505	S14   
23040	505	S2    
23041	505	S14   
23041	505	S2    
23042	505	S14   
23042	505	S2    
23043	505	S14   
23043	505	S2    
23044	505	S14   
23044	505	S2    
23045	505	S14   
23045	505	S2    
23046	505	S14   
23046	505	S2    
23047	505	S14   
23047	505	S2    
23048	505	S14   
23048	505	S2    
23049	505	S14   
23049	505	S2    
23050	505	S14   
23050	505	S2    
23051	505	S14   
23051	505	S2    
23052	505	S14   
23052	505	S2    
23053	505	S14   
23053	505	S2    
23054	505	S14   
23054	505	S2    
23055	505	S14   
23055	505	S2    
23056	505	S14   
23056	505	S2    
23057	505	S14   
23057	505	S2    
23058	505	S14   
23058	505	S2    
23059	505	S14   
23059	505	S2    
23060	505	S14   
23060	505	S2    
23061	505	S14   
23061	505	S2    
23062	505	S14   
23062	505	S2    
23063	505	S14   
23063	505	S2    
23064	505	S14   
23064	505	S2    
23065	505	S14   
23065	505	S2    
23557	505	S14   
23558	505	S14   
23559	505	S14   
23560	505	S14   
23561	505	S14   
23562	505	S14   
23563	505	S14   
23564	505	S14   
23565	505	S14   
23566	505	S14   
23567	505	S14   
23568	505	S14   
23569	505	S14   
23570	505	S14   
23571	505	S14   
23572	505	S14   
23573	505	S14   
23574	505	S14   
23575	505	S14   
23576	505	S14   
23577	505	S14   
23578	505	S14   
23579	505	S14   
23580	505	S14   
23581	505	S14   
23582	505	S14   
23582	505	S2    
23583	505	S14   
23583	505	S2    
23584	505	S14   
23584	505	S2    
23585	505	S14   
23585	505	S2    
23586	505	S14   
23586	505	S2    
23587	505	S14   
23587	505	S2    
23588	505	S14   
23588	505	S2    
23589	505	S14   
23589	505	S2    
23590	505	S14   
23590	505	S2    
23591	505	S14   
23591	505	S2    
23592	505	S14   
23592	505	S2    
23593	505	S14   
23593	505	S2    
23594	505	S14   
23594	505	S2    
23595	505	S14   
23595	505	S2    
23596	505	S14   
23596	505	S2    
23597	505	S14   
23597	505	S2    
23598	505	S14   
23598	505	S2    
23599	505	S14   
23599	505	S2    
23600	505	S14   
23600	505	S2    
23601	505	S14   
23601	505	S2    
23602	505	S14   
23602	505	S2    
23603	505	S14   
23603	505	S2    
23604	505	S14   
23604	505	S2    
23605	505	S14   
23605	505	S2    
23606	505	S14   
23606	505	S2    
23607	505	S14   
23607	505	S2    
23608	505	S14   
23608	505	S2    
23609	505	S14   
23609	505	S2    
23610	505	S14   
23610	505	S2    
23611	505	S14   
23611	505	S2    
23612	505	S14   
23612	505	S2    
23613	505	S14   
23613	505	S2    
23614	505	S14   
23614	505	S2    
23615	505	S14   
23615	505	S2    
23616	505	S14   
23616	505	S2    
23617	505	S14   
23617	505	S2    
23618	505	S14   
23618	505	S2    
23619	505	S14   
23619	505	S2    
23620	505	S14   
23620	505	S2    
23621	505	S14   
23621	505	S2    
23622	505	S14   
23622	505	S2    
23623	505	S14   
23623	505	S2    
23624	505	S14   
23624	505	S2    
23625	505	S14   
23625	505	S2    
23626	505	S14   
23626	505	S2    
23627	505	S14   
23627	505	S2    
23628	505	S14   
23628	505	S2    
23629	505	S14   
23629	505	S2    
23630	505	S14   
23630	505	S2    
23631	505	S14   
23631	505	S2    
23632	505	S14   
23632	505	S2    
23633	505	S14   
23633	505	S2    
23634	505	S14   
23634	505	S2    
23635	505	S14   
23635	505	S2    
23636	505	S14   
23636	505	S2    
23637	505	S14   
23637	505	S2    
23638	505	S14   
23638	505	S2    
23646	505	S14   
23646	505	S2    
23647	505	S14   
23647	505	S2    
23648	505	S14   
23648	505	S2    
23649	505	S14   
23649	505	S2    
23650	505	S14   
23650	505	S2    
23651	505	S14   
23651	505	S2    
23652	505	S14   
23652	505	S2    
23653	505	S14   
23653	505	S2    
23654	505	S14   
23654	505	S2    
23655	505	S14   
23655	505	S2    
23656	505	S14   
23656	505	S2    
23657	505	S14   
23657	505	S2    
23658	505	S14   
23658	505	S2    
23659	505	S14   
23659	505	S2    
23660	505	S14   
23660	505	S2    
35135	505	S2381 
35136	505	S2381 
35137	505	S2381 
35141	505	S2381 
35143	505	S2381 
35145	505	S2381 
35146	505	S2381 
35147	505	S2381 
43297	505	S1082 
43378	505	S1082 
01026	506	S27   
01029	506	S27   
01032	506	S19   
01046	506	S19   
01077	506	S27   
01079	506	S1063 
01079	506	S20   
01082	506	S1063 
01085	506	S1063 
01103	506	S1163 
01123	506	S1063 
01123	506	S561  
01124	506	S1065 
01125	506	S1065 
01128	506	S1063 
01128	506	S561  
01130	506	S1063 
01130	506	S561  
01131	506	S1063 
01131	506	S561  
01202	506	S1163 
04017	506	S19   
04023	506	S19   
04114	506	S19   
04640	506	S26   
05027	506	S1082 
05028	506	S1082 
05312	506	S26   
05313	506	S26   
05320	506	S26   
05661	506	S1082 
06019	506	S18   
06128	506	S18   
06982	506	S18   
06983	506	S18   
06984	506	S2104 
06985	506	S2104 
07005	506	S248  
07015	506	S248  
07016	506	S248  
07022	506	S2    
07063	506	S1164 
07063	506	S582  
07945	506	S2    
07949	506	S2    
07950	506	S2    
07953	506	S1164 
07953	506	S582  
07954	506	S582  
07955	506	S1164 
07956	506	S1164 
07957	506	S1164 
07958	506	S1164 
07960	506	S1164 
08001	506	S1065 
08012	506	S1065 
08013	506	S1065 
08014	506	S1065 
08020	506	S10