#!/usr/sbin/dtrace -qs

/*
 * Usage      : txn_time.d
 * Description: Measure processing time for each transaction
 * Author     : Robert Lor
 */

postgresql*:::transaction-start
{
	self->ts  = timestamp;
}

postgresql*:::transaction-commit
/self->ts/
{
	@commit[pid, arg0] = sum(timestamp - self->ts);
	self->ts=0;
}

postgresql*:::transaction-abort
/self->ts/
{
	@abort[pid, arg0] = sum(timestamp - self->ts);
	self->ts=0;
}

profile:::tick-1s
{
        printf("Committed Transactions");
        printf("\n%5s %15s %15s\n","PID", "Tx Id", "Time (ns)");
        printa("%5d %15d %@15d\n",@commit);

        printf("\nAborted Transactions");
        printf("\n%5s %15s %15s\n","PID", "Tx Id", "Time (ns)");
        printa("%5d %15d %@15d\n",@abort);

        printf("\n---------------------------------------\n\n");

}

tick-1msec
{
	trunc (@commit, 20);
	trunc (@abort, 20);
}
