#!/usr/sbin/dtrace -s
/*
 * USAGE      : ./dirty_buffer_write.d 
 *
 * DESCRIPTION:
 *   This script prints the number of writes performed by the server process
 *   because the bgwriter is ineffective or shared_buffers is too small.
 *   If shared_buffers is set to the appropriate value and the bgwriter works
 *   properly, you won't see the backend doing many dirty buffer writes.
 *
 * EXAMPLE    : (1) run pgbench (2) run dirty_buffer_write.d
 *
 * AUTHOR     : Robert Lor <robert.lor@sun.com>
 *
 * $Header$
 */

#pragma D option quiet

postgresql*:::buffer-write-dirty-start
{
	self->ts = timestamp;
	self->pid = pid;
}
postgresql*:::buffer-write-dirty-done
/self->ts && self->pid == pid/
{
	@count[pid, "Dirty buffers written   "] = count();
	@countpersec[pid, "Dirty buffer writes/sec "] = count();
	@avgtime[pid, "Average write time (ns) "] = avg (timestamp - self->ts);
        self->ts = 0;
	self->pid = 0;
}

profile:::tick-1s
{
	printf("%5s %16s %20s\n","PID", "Description", "Count/Time");
        printf("-------------------------------------------\n");
        printa("%5d %22s %@12d\n",@count);
        printa("%5d %22s %@12d\n",@countpersec);
        printa("%5d %22s %@12d\n",@avgtime);
	printf("\n");

	clear(@countpersec);
}
