
#=====================================================================
# SQL-Ledger Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Genereal Ledger
#
#======================================================================


use SL::ob_report;

1;
# end of main


# this is for our long dates
# $locale->text('January')
# $locale->text('February')
# $locale->text('March')
# $locale->text('April')
# $locale->text('May ')
# $locale->text('June')
# $locale->text('July')
# $locale->text('August')
# $locale->text('September')
# $locale->text('October')
# $locale->text('November')
# $locale->text('December')

# this is for our short month
# $locale->text('Jan')
# $locale->text('Feb')
# $locale->text('Mar')
# $locale->text('Apr')
# $locale->text('May')
# $locale->text('Jun')
# $locale->text('Jul')
# $locale->text('Aug')
# $locale->text('Sep')
# $locale->text('Oct')
# $locale->text('Nov')
# $locale->text('Dec')


sub print_report{
	$form->{print}="true";
	&generate_report;
}



sub generate_report {
  map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr));

  if(!$form->{print}){
    $listheading="class=listheading";
    $listheadingcolor="color=ffffff";
    $listtop="class=listtop";
    $listrow="class=listrow";
    $listtotal="class=listtotal";
    $listsubtotal="class=listsubtotal";
    $lastline=$locale->text('Click on "Partnumber" or "INV" to edit transaction');
    $file="print_report";
 }else{
    $line = "<hr size=2 noshade>";
    $fontsize="size=1";
     $file="generate_report";
     $listprint="class=print";
   $listheading="class=print";
    $listtop="class=print";
    $listrow="class=print";
    $listsubtotal="class=print";
  }

  ob_report->all_transactions(\%myconfig, \%$form);

  $callback = "$form->{script}?action=$file&print=$form->{print}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";

  %acctype = ( 'A' => $locale->text('Asset'),
               'L' => $locale->text('Liability'),
	       'Q' => $locale->text('Equity'),
	       'I' => $locale->text('Income'),
	       'E' => $locale->text('Expense'),
	     );

  $form->{title} = $locale->text('Opening Balance as at ').$form->{datefrom};

  unless ($form->{category} eq 'X') {
    $form->{title} .= "  ".$locale->text($acctype{$form->{category}});
  }


  if ($form->{datefrom}) {
    $callback .= "&datefrom=$form->{datefrom}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('From :')." ".$locale->date(\%myconfig, $form->{datefrom}, 1);
  }



  @columns = $form->sort_columns(qw(  transno transdate accno accdesc debit credit));





  $href = "$callback&sort=$form->{sort}";        # needed for accno
 # $callback += "&sort=$form->{sort}";        # needed for accno

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
 
    }
  }

  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
  }

  $callback .= "&category=$form->{category}";
  $href .= "&category=$form->{category}";

  $column_header{transdate} = "<th><a $listheading href=$callback&sort=transdate><font $fontsize color=ffffff>".$locale->text('Date')."$line</a></th>";
  $column_header{accno} = "<th><a $listheading href=$callback&sort=accno><font $fontsize color=ffffff>".$locale->text('ACC NO.')."$line</a></th>";
  $column_header{accdesc} = "<th><a $listheading href=$callback&sort=accno><font $fontsize $listheadingcolor>".$locale->text('Acc Desc')."</a>$line</th>";
  $column_header{transno} = "<th><a $listheading href=$callback&sort=accno><font $fontsize $listheadingcolor>".$locale->text('Trans No.')."</a>$line</th>";
  $column_header{debit} = "<th ><font $fontsize $listheadingcolor>".$locale->text('Debit')."$line</th>";
  $column_header{credit} = "<th ><font $fontsize $listheadingcolor>".$locale->text('Credit')."$line</th>";


  $colspan = $#column_index + 1;

  $form->header;

  print  qq|
<body $listprint  bgcolor=ffffff>
<h1  $listprint align=center>$form->{company}<br>$form->{title}</h1><Br>
|;
#$option
 print  qq|<table  $listprintborder=0 width=100%>

<thead $listheading bgcolor=336666>
|;

map { print  "$column_header{$_}\n" } @column_index;

print  "</thead>";

  # add sort to callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");

  # initial item for subtotals
  if (@{ $form->{report} }) {
    $sameitem = $form->{report}->[0]->{$form->{sort}};
#    print  "$sameitem<br>";
 }

 $x='001';
  foreach $ref (@{ $form->{report} }) {

    # if item ne sort print subtotal
    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ref->{$form->{sort}}) {
	&gl_subtotal;
    #print  "$sameitem<br>";
 }
    }
    if($ref->{amount} <0){
    	$ref->{debit} =$ref->{amount}*-1;
    }else{
    	$ref->{credit} =$ref->{amount};

    }

    $subtotaldebit += $ref->{debit};
    $subtotalcredit += $ref->{credit};
 #  print  "$subtotalcredit<br>";

    $totaldebit += $ref->{debit};
    $totalcredit += $ref->{credit};

    $pagetotaldebit += $ref->{debit};
    $pagetotalcredit += $ref->{credit};

    $ref->{subtotal1} = $form->format_amount(\%myconfig, $ref->{subtotal1}, 2, "&nbsp;");
    #$ref->{credit} = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");
    $column_data{transdate} = "<td $listprint ><font $fontsize>$form->{datefrom}</td>";
    $column_data{accno} = "<td $listprint ><font $fontsize>$ref->{accno}</td>";
    $column_data{accdesc} = "<td $listprint ><font $fontsize>$ref->{accdesc}</td>";
    $column_data{transno} = "<td $listprint ><font $fontsize>00-00-$x</td>";
    $column_data{debit} = "<td  $listprint align=right> <font $fontsize>$ref->{debit}</td>";
    $column_data{credit} = "<td  $listprint align=right><font $fontsize>$ref->{credit}</td>";
       $x++;

    $i++; $i %= 2;$r++;
    print  "<tr $listrow$i>";
    map { print "$column_data{$_}\n" } @column_index;
    print  "</tr>";

    
        #pagebreak printing
if($form->{rowcount} && $form->{print} && $form->{rowcount} <= $r){
$pagenum++;
    print "<tr $listrow$i >";
if($form->{l_sr}){
	print "<td $listprint >$line&nbsp;</td>";
}
	
	  map { $column_data{$_} = "<td $listprint >$line&nbsp;</td>" } @column_index;
     $column_data{accdesc} = "<td $listprint >$line SubTotal</td>";
    $column_data{debit} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotaldebit , 2, "&nbsp;") . "</td>";
    $column_data{credit} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "&nbsp;") . "</td>";
     map { print "\n$column_data{$_}" } @column_index;

     print qq|
     </tr>
</table>

 <p style="page-break-before: always">F/Y : $form->{fy}</p>
<H1  $listprint align=center >$form->{company}<br>$form->{title}</h1>
<table  $listprint border=0 width=100%>

<tr $listheading >|;
if($form->{l_sr}){
	print "<th $listprint ><font $listheadingcolor>".$locale->text('SR')."$line</font></th>";
}
map { print "\n$column_header{$_}" } @column_index;

print qq|
</tr><tr>
|;
if($form->{l_sr}){
	print "<td $listprint >&nbsp;</td>";
}

 	  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } @column_index;
     $column_data{accdesc} = "<td $listprint >**Subtotal B/F for Page $pagenum </td>";
    $column_data{debit} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotaldebit , 2, "&nbsp;") . "</td>";
    $column_data{credit} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "&nbsp;") . "</td>";
    map { print "\n$column_data{$_}" } @column_index;
print qq|
</tr>
|;
$r=0;

}


  }

  &gl_subtotal if ($form->{l_subtotal} eq 'Y');

  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } @column_index;

#  $column_data{debit} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totaldebit, 2, "&nbsp;")."</th>";
 # $column_data{subtotal1} = "<th align=right><font $fontsize color=ffffff>$line".$form->format_amount(\%myconfig, $totalcredit, 2, "&nbsp;")."$line</th>";


  print  qq|
 </table>

<p>

$lastline


</body>
</html>
|;

}



sub gl_subtotal {

  $subtotaldebit = $form->format_amount(\%myconfig, $subtotaldebit, 2, "&nbsp;");
  $subtotalcredit = $form->format_amount(\%myconfig, $subtotalcredit, 2, "&nbsp;");

  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } qw(transdate accno accdesc transno );
  $column_data{debit} = "<th  $listprint align=right><font $fontsize color=ffffff>$line $subtotaldebit $line </font></td>";
  $column_data{credit} = "<th  $listprint align=right><font $fontsize color=ffffff>$line $subtotalcredit $line </font></td>";


  print "<tr $listtotal bgcolor=333366>";
  map { print "$column_data{$_}\n" } @column_index;
  print "</tr>";

  $subtotaldebit = 0;
  $subtotalcredit = 0;
  $subtotalqtykg=0;
  $sameitem = $ref->{$form->{sort}};

}







sub search {

  $form->{title} = $locale->text('Invoice Listing')." ".$locale->text('Reports');

  $form->header;
 #$form->all_vc(\%myconfig, "customer");

  #$selection = "<option selected>" . $locale->text('All Customers') . "\n";

  #foreach $ref (@{ $form->{all_customer} }) {
  #  $selection .= "<option>$ref->{name}--$ref->{id}\n";
  #}

   #$form->all_vc(\%myconfig, "vendor");

  #$selectionvc = "<option selected>" . $locale->text('All Vendors') . "\n";

 # foreach $ref (@{ $form->{all_vendor} }) {
 #   $selectionvc .= "<option>$ref->{name}--$ref->{id}\n";
 # }
  

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>

<input type=hidden name=sort value=partnumber>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>


<tr>

  <th align=right>|.$locale->text('Opening Balance Trans. Type').qq| </th>
  <td><input name=transtype1 size=11 value="$form->{transtype1}"></td>

</tr>



<tr>

  <th align=right>|.$locale->text('From').qq| ($myconfig{dateformat})</th>
  <td><input name=datefrom size=11></td>

</tr>


<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>

    <input name="l_transdate" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Date').qq|
    <input name="l_accno" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Acc no').qq|
    <input name="l_accdesc" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Description').qq|<br>
    <input name="l_transno" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Trans No.').qq|<br>
    <input name="l_debit" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Debit').qq|
    <input name="l_credit" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Credit').qq|
    <input name="l_subtotal" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Total').qq|

    </td>

  </tr>

</table>
</td>

</tr>
</table>
<input type=hidden name=rowcount value=$form->{rowcount}>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=transtype value=$form->{transtype}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Generate Report').qq|">

<br><br><br>
<input class=submit type=submit name=action value="|.$locale->text('Print Report').qq|">

</form>

<p>
|.$locale->text('To display all transactions, leave fields blank')

  .qq|

</body>
</html>
|;
}


