#ifndef __ODBC__
#define __ODBC__


/*-----------------------------------------------------------------------------
 * Main 
 *-----------------------------------------------------------------------------
 */
#define _MULTITHREAD_SUPPORT

#ifdef WIN32
	#include <windows.h>
	#include <windowsx.h>
	#include <winsock.h>
	#include <stdarg.h>
	#include <tchar.h>

	#define _CRITICAL_SECTION(cs) CRITICAL_SECTION cs

	#define INIT_CRITICAL_SECTION(handle)    InitializeCriticalSection(&((handle)->cs))
	#define ENTER_CRITICAL_SECTION(handle)   EnterCriticalSection(&((handle)->cs))
	#define LEAVE_CRITICAL_SECTION(handle)   LeaveCriticalSection(&((handle)->cs))
	#define DELETE_CRITICAL_SECTION(handle)  DeleteCriticalSection(&((handle)->cs))

#else
	#include <netinet/tcp.h>
	#include <netinet/in.h>
	#include <sys/socket.h>
	#include <sys/types.h>
	#include <arpa/inet.h>
	#include <pthread.h>
	#include <string.h>
	#include <stdlib.h>
	#include <math.h>
	#include <netdb.h>
	#include <langinfo.h>


	#define _CRITICAL_SECTION(cs) pthread_mutex_t cs

	#define INIT_CRITICAL_SECTION(handle)    pthread_mutex_init(&((handle)->cs), 0)
	#define ENTER_CRITICAL_SECTION(handle)   pthread_mutex_lock(&((handle)->cs))
	#define LEAVE_CRITICAL_SECTION(handle)   pthread_mutex_unlock(&((handle)->cs))
	#define DELETE_CRITICAL_SECTION(handle)  pthread_mutex_destroy(&((handle)->cs))


	#define SOCKET_ERROR   -1
	#define FALSE           0
	#define TRUE            1
	
	#define closesocket close
	#define SOCKET      int
	#define BOOL        int

#endif /* WIN32 */

#include <locale.h>
#include <odbcinst.h>
#include <sqlext.h>
#include <stdio.h>
#include <sql.h>

#ifdef USE_SSL
#include "openssl/ssl.h"
#include "openssl/err.h"
#endif /* USE_SSL */


typedef unsigned char  uint8;
typedef unsigned short uint16;
typedef unsigned int   uint32;


#ifdef UNICODE

	#define SQL_TCHAR            SQL_WCHAR
	#define SQL_TVARCHAR         SQL_WVARCHAR

	#define BYTES_TO_CHARACTERS(length)   ((SQL_NTS == length) ? length : (length / sizeof(WCHAR)))
	#define SEND_STRLEN(str, n)           utf8len(str, n)

	#define SQLDriverConnect_    SQLDriverConnectW
	#define SQLConnect_          SQLConnectW
	#define SQLPrepare_          SQLPrepareW
	#define SQLExecDirect_       SQLExecDirectW
	#define ConfigDSN_           ConfigDSNW
	#define SQLGetDiagRec_       SQLGetDiagRecW
	#define SQLBrowseConnect_    SQLBrowseConnectW
	#define SQLForeignKeys_      SQLForeignKeysW
	#define SQLColumns_          SQLColumnsW
	#define SQLSpecialColumns_   SQLSpecialColumnsW
	#define SQLProcedureColumns_ SQLProcedureColumnsW
	#define SQLTablePrivileges_  SQLTablePrivilegesW
	#define SQLDescribeCol_      SQLDescribeColW
	#define SQLPrimaryKeys_      SQLPrimaryKeysW
	#define SQLProcedures_       SQLProceduresW
	#define SQLGetCursorName_    SQLGetCursorNameW
	#define SQLGetDescRec_       SQLGetDescRecW
	#define SQLNativeSql_        SQLNativeSqlW
	#define SQLSetCursorName_    SQLSetCursorNameW
	#define SQLError_            SQLErrorW
	#define SQLStatistics_       SQLStatisticsW
	#define SQLTables_           SQLTablesW
	#define SQLGetStmtAttr_      SQLGetStmtAttrW
	#define SQLGetConnectAttr_   SQLGetConnectAttrW
	#define SQLGetDiagField_     SQLGetDiagFieldW
	#define SQLGetInfo_          SQLGetInfoW
	#define SQLGetDescField_     SQLGetDescFieldW
	#define SQLColAttribute_     SQLColAttributeW
	#define SQLColAttributes_    SQLColAttributesW
	#define SQLSetDescField_     SQLSetDescFieldW
	#define SQLSetConnectAttr_   SQLSetConnectAttrW
	#define SQLGetConnectOption_ SQLGetConnectOptionW
	#define SQLSetConnectOption_ SQLSetConnectOptionW
	#define SQLSetStmtAttr_      SQLSetStmtAttrW
	#define SQLColumnPrivileges_ SQLColumnPrivilegesW

#else

	#define SQL_TCHAR            SQL_CHAR
	#define SQL_TVARCHAR         SQL_VARCHAR

	#define BYTES_TO_CHARACTERS(length)    length
	#define SEND_STRLEN(str, n)            ((SQL_NTS == n) ? strlen(str) : n)

	#define SQLDriverConnect_    SQLDriverConnect
	#define SQLConnect_          SQLConnect
	#define SQLPrepare_          SQLPrepare
	#define SQLExecDirect_       SQLExecDirect
	#define ConfigDSN_           ConfigDSN
	#define SQLGetDiagRec_       SQLGetDiagRec
	#define SQLBrowseConnect_    SQLBrowseConnect
	#define SQLForeignKeys_      SQLForeignKeys
	#define SQLColumns_          SQLColumns
	#define SQLSpecialColumns_   SQLSpecialColumns
	#define SQLProcedureColumns_ SQLProcedureColumns
	#define SQLTablePrivileges_  SQLTablePrivileges
	#define SQLDescribeCol_      SQLDescribeCol
	#define SQLPrimaryKeys_      SQLPrimaryKeys
	#define SQLProcedures_       SQLProcedures
	#define SQLGetCursorName_    SQLGetCursorName
	#define SQLGetDescRec_       SQLGetDescRec
	#define SQLNativeSql_        SQLNativeSql
	#define SQLSetCursorName_    SQLSetCursorName
	#define SQLError_            SQLError
	#define SQLStatistics_       SQLStatistics
	#define SQLTables_           SQLTables
	#define SQLGetStmtAttr_      SQLGetStmtAttr
	#define SQLGetConnectAttr_   SQLGetConnectAttr
	#define SQLGetDiagField_     SQLGetDiagField
	#define SQLGetInfo_          SQLGetInfo
	#define SQLGetDescField_     SQLGetDescField
	#define SQLColAttribute_     SQLColAttribute
	#define SQLColAttributes_    SQLColAttributes
	#define SQLSetDescField_     SQLSetDescField
	#define SQLSetConnectAttr_   SQLSetConnectAttr
	#define SQLGetConnectOption_ SQLGetConnectOption
	#define SQLSetConnectOption_ SQLSetConnectOption
	#define SQLSetStmtAttr_      SQLSetStmtAttr
	#define SQLColumnPrivileges_ SQLColumnPrivileges

#endif /* _UNICODE */

#define STR_SIZEOF(str)  (sizeof(_T(str))/sizeof(TCHAR)-1)
#define CHR_SIZEOF(str)  (sizeof(str)/sizeof(TCHAR)-1)

#endif /* __ODBC__ */
