/*
 * Written by Tomas Dosoudil
 * This file is distributed under BSD-style license.
 *
 */

#ifndef _INPUT_PARSER_H_
#define _INPUT_PARSER_H_

/* 
 * structure for linked list, where range is save 
 *
 * 'from' and 'to' can be number greather than 0 as an user's input 
 * - means range X..Y
 * or 0 as a first or last
 * - means half range ..X or X..
 * or 'to' is -1
 * - means that only one number was demanded X 
 */

typedef struct LinkedList {
		int from;
		int to;
		struct LinkedList *next;
} LinkedList;

#define		DEBUG_INPUT			0
#define		MAX_STRING_LENGTH	100				/* max length of string */
#define		POINT(c) 			((c) == '.')
#define		COMMA(c) 			((c) == ',')
#define		NUMBER(c) 			(isdigit(c))
#define		InputError(c)		(printf("Parser error: Invalid syntax (%s)\n", symbName[c]))

/* function returns pointer to list of range */
extern LinkedList* GetLinkedList(char*, int);

/* functions returns allocated structure */
extern LinkedList* AllocateNewNode(void);

/* deallocated linked list */
extern void FreeLinkedList(LinkedList**);

#endif /* _INPUT_PARSER_H_ */
