/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONTINUE = 265,
     SQL_COUNT = 266,
     SQL_DATA = 267,
     SQL_DATETIME_INTERVAL_CODE = 268,
     SQL_DATETIME_INTERVAL_PRECISION = 269,
     SQL_DESCRIBE = 270,
     SQL_DESCRIPTOR = 271,
     SQL_DISCONNECT = 272,
     SQL_FOUND = 273,
     SQL_FREE = 274,
     SQL_GO = 275,
     SQL_GOTO = 276,
     SQL_IDENTIFIED = 277,
     SQL_INDICATOR = 278,
     SQL_KEY_MEMBER = 279,
     SQL_LENGTH = 280,
     SQL_LONG = 281,
     SQL_NULLABLE = 282,
     SQL_OCTET_LENGTH = 283,
     SQL_OPEN = 284,
     SQL_OUTPUT = 285,
     SQL_REFERENCE = 286,
     SQL_RETURNED_LENGTH = 287,
     SQL_RETURNED_OCTET_LENGTH = 288,
     SQL_SCALE = 289,
     SQL_SECTION = 290,
     SQL_SHORT = 291,
     SQL_SIGNED = 292,
     SQL_SQL = 293,
     SQL_SQLERROR = 294,
     SQL_SQLPRINT = 295,
     SQL_SQLWARNING = 296,
     SQL_START = 297,
     SQL_STOP = 298,
     SQL_STRUCT = 299,
     SQL_UNSIGNED = 300,
     SQL_VAR = 301,
     SQL_WHENEVER = 302,
     S_ADD = 303,
     S_AND = 304,
     S_ANYTHING = 305,
     S_AUTO = 306,
     S_CONST = 307,
     S_DEC = 308,
     S_DIV = 309,
     S_DOTPOINT = 310,
     S_EQUAL = 311,
     S_EXTERN = 312,
     S_INC = 313,
     S_LSHIFT = 314,
     S_MEMPOINT = 315,
     S_MEMBER = 316,
     S_MOD = 317,
     S_MUL = 318,
     S_NEQUAL = 319,
     S_OR = 320,
     S_REGISTER = 321,
     S_RSHIFT = 322,
     S_STATIC = 323,
     S_SUB = 324,
     S_VOLATILE = 325,
     S_TYPEDEF = 326,
     TYPECAST = 327,
     ABORT_P = 328,
     ABSOLUTE_P = 329,
     ACCESS = 330,
     ACTION = 331,
     ADD_P = 332,
     ADMIN = 333,
     AFTER = 334,
     AGGREGATE = 335,
     ALL = 336,
     ALSO = 337,
     ALTER = 338,
     ALWAYS = 339,
     ANALYSE = 340,
     ANALYZE = 341,
     AND = 342,
     ANY = 343,
     ARRAY = 344,
     AS = 345,
     ASC = 346,
     ASSERTION = 347,
     ASSIGNMENT = 348,
     ASYMMETRIC = 349,
     AT = 350,
     AUTHORIZATION = 351,
     BACKWARD = 352,
     BEFORE = 353,
     BEGIN_P = 354,
     BETWEEN = 355,
     BIGINT = 356,
     BINARY = 357,
     BIT = 358,
     BOOLEAN_P = 359,
     BOTH = 360,
     BY = 361,
     CACHE = 362,
     CALLED = 363,
     CASCADE = 364,
     CASCADED = 365,
     CASE = 366,
     CAST = 367,
     CHAIN = 368,
     CHAR_P = 369,
     CHARACTER = 370,
     CHARACTERISTICS = 371,
     CHECK = 372,
     CHECKPOINT = 373,
     CLASS = 374,
     CLOSE = 375,
     CLUSTER = 376,
     COALESCE = 377,
     COLLATE = 378,
     COLUMN = 379,
     COMMENT = 380,
     COMMIT = 381,
     COMMITTED = 382,
     CONCURRENTLY = 383,
     CONFIGURATION = 384,
     CONNECTION = 385,
     CONSTRAINT = 386,
     CONSTRAINTS = 387,
     CONTENT_P = 388,
     CONVERSION_P = 389,
     COPY = 390,
     COST = 391,
     CREATE = 392,
     CREATEDB = 393,
     CREATEROLE = 394,
     CREATEUSER = 395,
     CROSS = 396,
     CSV = 397,
     CURRENT_P = 398,
     CURRENT_DATE = 399,
     CURRENT_ROLE = 400,
     CURRENT_TIME = 401,
     CURRENT_TIMESTAMP = 402,
     CURRENT_USER = 403,
     CURSOR = 404,
     CYCLE = 405,
     DATABASE = 406,
     DAY_P = 407,
     DEALLOCATE = 408,
     DEC = 409,
     DECIMAL_P = 410,
     DECLARE = 411,
     DEFAULT = 412,
     DEFAULTS = 413,
     DEFERRABLE = 414,
     DEFERRED = 415,
     DEFINER = 416,
     DELETE_P = 417,
     DELIMITER = 418,
     DELIMITERS = 419,
     DESC = 420,
     DICTIONARY = 421,
     DISABLE_P = 422,
     DISCARD = 423,
     DISTINCT = 424,
     DO = 425,
     DOCUMENT_P = 426,
     DOMAIN_P = 427,
     DOUBLE_P = 428,
     DROP = 429,
     EACH = 430,
     ELSE = 431,
     ENABLE_P = 432,
     ENCODING = 433,
     ENCRYPTED = 434,
     END_P = 435,
     ENUM_P = 436,
     ESCAPE = 437,
     EXCEPT = 438,
     EXCLUSIVE = 439,
     EXCLUDING = 440,
     EXECUTE = 441,
     EXISTS = 442,
     EXPLAIN = 443,
     EXTERNAL = 444,
     EXTRACT = 445,
     FALSE_P = 446,
     FAMILY = 447,
     FETCH = 448,
     FIRST_P = 449,
     FLOAT_P = 450,
     FOR = 451,
     FORCE = 452,
     FOREIGN = 453,
     FORWARD = 454,
     FREEZE = 455,
     FROM = 456,
     FULL = 457,
     FUNCTION = 458,
     GET = 459,
     GLOBAL = 460,
     GRANT = 461,
     GRANTED = 462,
     GREATEST = 463,
     GROUP_P = 464,
     HANDLER = 465,
     HAVING = 466,
     HEADER_P = 467,
     HOLD = 468,
     HOUR_P = 469,
     IF_P = 470,
     ILIKE = 471,
     IMMEDIATE = 472,
     IMMUTABLE = 473,
     IMPLICIT_P = 474,
     IN_P = 475,
     INCLUDING = 476,
     INCREMENT = 477,
     INDEX = 478,
     INDEXES = 479,
     INHERIT = 480,
     INHERITS = 481,
     INITIALLY = 482,
     INNER_P = 483,
     INOUT = 484,
     INPUT_P = 485,
     INSENSITIVE = 486,
     INSERT = 487,
     INSTEAD = 488,
     INT_P = 489,
     INTEGER = 490,
     INTERSECT = 491,
     INTERVAL = 492,
     INTO = 493,
     INVOKER = 494,
     IS = 495,
     ISNULL = 496,
     ISOLATION = 497,
     JOIN = 498,
     KEY = 499,
     LANCOMPILER = 500,
     LANGUAGE = 501,
     LARGE_P = 502,
     LAST_P = 503,
     LEADING = 504,
     LEAST = 505,
     LEFT = 506,
     LEVEL = 507,
     LIKE = 508,
     LIMIT = 509,
     LISTEN = 510,
     LOAD = 511,
     LOCAL = 512,
     LOCALTIME = 513,
     LOCALTIMESTAMP = 514,
     LOCATION = 515,
     LOCK_P = 516,
     LOGIN_P = 517,
     MAPPING = 518,
     MATCH = 519,
     MAXVALUE = 520,
     MINUTE_P = 521,
     MINVALUE = 522,
     MODE = 523,
     MONTH_P = 524,
     MOVE = 525,
     NAME_P = 526,
     NAMES = 527,
     NATIONAL = 528,
     NATURAL = 529,
     NCHAR = 530,
     NEW = 531,
     NEXT = 532,
     NO = 533,
     NOCREATEDB = 534,
     NOCREATEROLE = 535,
     NOCREATEUSER = 536,
     NOINHERIT = 537,
     NOLOGIN_P = 538,
     NONE = 539,
     NOSUPERUSER = 540,
     NOT = 541,
     NOTHING = 542,
     NOTIFY = 543,
     NOTNULL = 544,
     NOWAIT = 545,
     NULL_P = 546,
     NULLIF = 547,
     NULLS_P = 548,
     NUMERIC = 549,
     OBJECT_P = 550,
     OF = 551,
     OFF = 552,
     OFFSET = 553,
     OIDS = 554,
     OLD = 555,
     ON = 556,
     ONLY = 557,
     OPERATOR = 558,
     OPTION = 559,
     OR = 560,
     ORDER = 561,
     OUT_P = 562,
     OUTER_P = 563,
     OVERLAPS = 564,
     OVERLAY = 565,
     OWNED = 566,
     OWNER = 567,
     PARSER = 568,
     PARTIAL = 569,
     PASSWORD = 570,
     PLACING = 571,
     PLANS = 572,
     POSITION = 573,
     PRECISION = 574,
     PRESERVE = 575,
     PREPARE = 576,
     PREPARED = 577,
     PRIMARY = 578,
     PRIOR = 579,
     PRIVILEGES = 580,
     PROCEDURAL = 581,
     PROCEDURE = 582,
     QUOTE = 583,
     READ = 584,
     REAL = 585,
     REASSIGN = 586,
     RECHECK = 587,
     REFERENCES = 588,
     REINDEX = 589,
     RELATIVE_P = 590,
     RELEASE = 591,
     RENAME = 592,
     REPEATABLE = 593,
     REPLACE = 594,
     REPLICA = 595,
     RESET = 596,
     RESTART = 597,
     RESTRICT = 598,
     RETURNING = 599,
     RETURNS = 600,
     REVOKE = 601,
     RIGHT = 602,
     ROLE = 603,
     ROLLBACK = 604,
     ROW = 605,
     ROWS = 606,
     RULE = 607,
     SAVEPOINT = 608,
     SCHEMA = 609,
     SCROLL = 610,
     SEARCH = 611,
     SECOND_P = 612,
     SECURITY = 613,
     SELECT = 614,
     SEQUENCE = 615,
     SERIALIZABLE = 616,
     SESSION = 617,
     SESSION_USER = 618,
     SET = 619,
     SETOF = 620,
     SHARE = 621,
     SHOW = 622,
     SIMILAR = 623,
     SIMPLE = 624,
     SMALLINT = 625,
     SOME = 626,
     STABLE = 627,
     STANDALONE_P = 628,
     START = 629,
     STATEMENT = 630,
     STATISTICS = 631,
     STDIN = 632,
     STDOUT = 633,
     STORAGE = 634,
     STRICT_P = 635,
     STRIP_P = 636,
     SUBSTRING = 637,
     SUPERUSER_P = 638,
     SYMMETRIC = 639,
     SYSID = 640,
     SYSTEM_P = 641,
     TABLE = 642,
     TABLESPACE = 643,
     TEMP = 644,
     TEMPLATE = 645,
     TEMPORARY = 646,
     TEXT_P = 647,
     THEN = 648,
     TIME = 649,
     TIMESTAMP = 650,
     TO = 651,
     TRAILING = 652,
     TRANSACTION = 653,
     TREAT = 654,
     TRIGGER = 655,
     TRIM = 656,
     TRUE_P = 657,
     TRUNCATE = 658,
     TRUSTED = 659,
     TYPE_P = 660,
     UNCOMMITTED = 661,
     UNENCRYPTED = 662,
     UNION = 663,
     UNIQUE = 664,
     UNKNOWN = 665,
     UNLISTEN = 666,
     UNTIL = 667,
     UPDATE = 668,
     USER = 669,
     USING = 670,
     VACUUM = 671,
     VALID = 672,
     VALIDATOR = 673,
     VALUE_P = 674,
     VALUES = 675,
     VARCHAR = 676,
     VARYING = 677,
     VERBOSE = 678,
     VERSION_P = 679,
     VIEW = 680,
     VOLATILE = 681,
     WHEN = 682,
     WHERE = 683,
     WHITESPACE_P = 684,
     WITH = 685,
     WITHOUT = 686,
     WORK = 687,
     WRITE = 688,
     XML_P = 689,
     XMLATTRIBUTES = 690,
     XMLCONCAT = 691,
     XMLELEMENT = 692,
     XMLFOREST = 693,
     XMLPARSE = 694,
     XMLPI = 695,
     XMLROOT = 696,
     XMLSERIALIZE = 697,
     YEAR_P = 698,
     YES_P = 699,
     ZONE = 700,
     NULLS_FIRST = 701,
     NULLS_LAST = 702,
     WITH_CASCADED = 703,
     WITH_LOCAL = 704,
     WITH_CHECK = 705,
     IDENT = 706,
     SCONST = 707,
     Op = 708,
     CSTRING = 709,
     CVARIABLE = 710,
     CPP_LINE = 711,
     IP = 712,
     BCONST = 713,
     XCONST = 714,
     DOLCONST = 715,
     ECONST = 716,
     NCONST = 717,
     ICONST = 718,
     PARAM = 719,
     FCONST = 720,
     POSTFIXOP = 721,
     UMINUS = 722
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONTINUE 265
#define SQL_COUNT 266
#define SQL_DATA 267
#define SQL_DATETIME_INTERVAL_CODE 268
#define SQL_DATETIME_INTERVAL_PRECISION 269
#define SQL_DESCRIBE 270
#define SQL_DESCRIPTOR 271
#define SQL_DISCONNECT 272
#define SQL_FOUND 273
#define SQL_FREE 274
#define SQL_GO 275
#define SQL_GOTO 276
#define SQL_IDENTIFIED 277
#define SQL_INDICATOR 278
#define SQL_KEY_MEMBER 279
#define SQL_LENGTH 280
#define SQL_LONG 281
#define SQL_NULLABLE 282
#define SQL_OCTET_LENGTH 283
#define SQL_OPEN 284
#define SQL_OUTPUT 285
#define SQL_REFERENCE 286
#define SQL_RETURNED_LENGTH 287
#define SQL_RETURNED_OCTET_LENGTH 288
#define SQL_SCALE 289
#define SQL_SECTION 290
#define SQL_SHORT 291
#define SQL_SIGNED 292
#define SQL_SQL 293
#define SQL_SQLERROR 294
#define SQL_SQLPRINT 295
#define SQL_SQLWARNING 296
#define SQL_START 297
#define SQL_STOP 298
#define SQL_STRUCT 299
#define SQL_UNSIGNED 300
#define SQL_VAR 301
#define SQL_WHENEVER 302
#define S_ADD 303
#define S_AND 304
#define S_ANYTHING 305
#define S_AUTO 306
#define S_CONST 307
#define S_DEC 308
#define S_DIV 309
#define S_DOTPOINT 310
#define S_EQUAL 311
#define S_EXTERN 312
#define S_INC 313
#define S_LSHIFT 314
#define S_MEMPOINT 315
#define S_MEMBER 316
#define S_MOD 317
#define S_MUL 318
#define S_NEQUAL 319
#define S_OR 320
#define S_REGISTER 321
#define S_RSHIFT 322
#define S_STATIC 323
#define S_SUB 324
#define S_VOLATILE 325
#define S_TYPEDEF 326
#define TYPECAST 327
#define ABORT_P 328
#define ABSOLUTE_P 329
#define ACCESS 330
#define ACTION 331
#define ADD_P 332
#define ADMIN 333
#define AFTER 334
#define AGGREGATE 335
#define ALL 336
#define ALSO 337
#define ALTER 338
#define ALWAYS 339
#define ANALYSE 340
#define ANALYZE 341
#define AND 342
#define ANY 343
#define ARRAY 344
#define AS 345
#define ASC 346
#define ASSERTION 347
#define ASSIGNMENT 348
#define ASYMMETRIC 349
#define AT 350
#define AUTHORIZATION 351
#define BACKWARD 352
#define BEFORE 353
#define BEGIN_P 354
#define BETWEEN 355
#define BIGINT 356
#define BINARY 357
#define BIT 358
#define BOOLEAN_P 359
#define BOTH 360
#define BY 361
#define CACHE 362
#define CALLED 363
#define CASCADE 364
#define CASCADED 365
#define CASE 366
#define CAST 367
#define CHAIN 368
#define CHAR_P 369
#define CHARACTER 370
#define CHARACTERISTICS 371
#define CHECK 372
#define CHECKPOINT 373
#define CLASS 374
#define CLOSE 375
#define CLUSTER 376
#define COALESCE 377
#define COLLATE 378
#define COLUMN 379
#define COMMENT 380
#define COMMIT 381
#define COMMITTED 382
#define CONCURRENTLY 383
#define CONFIGURATION 384
#define CONNECTION 385
#define CONSTRAINT 386
#define CONSTRAINTS 387
#define CONTENT_P 388
#define CONVERSION_P 389
#define COPY 390
#define COST 391
#define CREATE 392
#define CREATEDB 393
#define CREATEROLE 394
#define CREATEUSER 395
#define CROSS 396
#define CSV 397
#define CURRENT_P 398
#define CURRENT_DATE 399
#define CURRENT_ROLE 400
#define CURRENT_TIME 401
#define CURRENT_TIMESTAMP 402
#define CURRENT_USER 403
#define CURSOR 404
#define CYCLE 405
#define DATABASE 406
#define DAY_P 407
#define DEALLOCATE 408
#define DEC 409
#define DECIMAL_P 410
#define DECLARE 411
#define DEFAULT 412
#define DEFAULTS 413
#define DEFERRABLE 414
#define DEFERRED 415
#define DEFINER 416
#define DELETE_P 417
#define DELIMITER 418
#define DELIMITERS 419
#define DESC 420
#define DICTIONARY 421
#define DISABLE_P 422
#define DISCARD 423
#define DISTINCT 424
#define DO 425
#define DOCUMENT_P 426
#define DOMAIN_P 427
#define DOUBLE_P 428
#define DROP 429
#define EACH 430
#define ELSE 431
#define ENABLE_P 432
#define ENCODING 433
#define ENCRYPTED 434
#define END_P 435
#define ENUM_P 436
#define ESCAPE 437
#define EXCEPT 438
#define EXCLUSIVE 439
#define EXCLUDING 440
#define EXECUTE 441
#define EXISTS 442
#define EXPLAIN 443
#define EXTERNAL 444
#define EXTRACT 445
#define FALSE_P 446
#define FAMILY 447
#define FETCH 448
#define FIRST_P 449
#define FLOAT_P 450
#define FOR 451
#define FORCE 452
#define FOREIGN 453
#define FORWARD 454
#define FREEZE 455
#define FROM 456
#define FULL 457
#define FUNCTION 458
#define GET 459
#define GLOBAL 460
#define GRANT 461
#define GRANTED 462
#define GREATEST 463
#define GROUP_P 464
#define HANDLER 465
#define HAVING 466
#define HEADER_P 467
#define HOLD 468
#define HOUR_P 469
#define IF_P 470
#define ILIKE 471
#define IMMEDIATE 472
#define IMMUTABLE 473
#define IMPLICIT_P 474
#define IN_P 475
#define INCLUDING 476
#define INCREMENT 477
#define INDEX 478
#define INDEXES 479
#define INHERIT 480
#define INHERITS 481
#define INITIALLY 482
#define INNER_P 483
#define INOUT 484
#define INPUT_P 485
#define INSENSITIVE 486
#define INSERT 487
#define INSTEAD 488
#define INT_P 489
#define INTEGER 490
#define INTERSECT 491
#define INTERVAL 492
#define INTO 493
#define INVOKER 494
#define IS 495
#define ISNULL 496
#define ISOLATION 497
#define JOIN 498
#define KEY 499
#define LANCOMPILER 500
#define LANGUAGE 501
#define LARGE_P 502
#define LAST_P 503
#define LEADING 504
#define LEAST 505
#define LEFT 506
#define LEVEL 507
#define LIKE 508
#define LIMIT 509
#define LISTEN 510
#define LOAD 511
#define LOCAL 512
#define LOCALTIME 513
#define LOCALTIMESTAMP 514
#define LOCATION 515
#define LOCK_P 516
#define LOGIN_P 517
#define MAPPING 518
#define MATCH 519
#define MAXVALUE 520
#define MINUTE_P 521
#define MINVALUE 522
#define MODE 523
#define MONTH_P 524
#define MOVE 525
#define NAME_P 526
#define NAMES 527
#define NATIONAL 528
#define NATURAL 529
#define NCHAR 530
#define NEW 531
#define NEXT 532
#define NO 533
#define NOCREATEDB 534
#define NOCREATEROLE 535
#define NOCREATEUSER 536
#define NOINHERIT 537
#define NOLOGIN_P 538
#define NONE 539
#define NOSUPERUSER 540
#define NOT 541
#define NOTHING 542
#define NOTIFY 543
#define NOTNULL 544
#define NOWAIT 545
#define NULL_P 546
#define NULLIF 547
#define NULLS_P 548
#define NUMERIC 549
#define OBJECT_P 550
#define OF 551
#define OFF 552
#define OFFSET 553
#define OIDS 554
#define OLD 555
#define ON 556
#define ONLY 557
#define OPERATOR 558
#define OPTION 559
#define OR 560
#define ORDER 561
#define OUT_P 562
#define OUTER_P 563
#define OVERLAPS 564
#define OVERLAY 565
#define OWNED 566
#define OWNER 567
#define PARSER 568
#define PARTIAL 569
#define PASSWORD 570
#define PLACING 571
#define PLANS 572
#define POSITION 573
#define PRECISION 574
#define PRESERVE 575
#define PREPARE 576
#define PREPARED 577
#define PRIMARY 578
#define PRIOR 579
#define PRIVILEGES 580
#define PROCEDURAL 581
#define PROCEDURE 582
#define QUOTE 583
#define READ 584
#define REAL 585
#define REASSIGN 586
#define RECHECK 587
#define REFERENCES 588
#define REINDEX 589
#define RELATIVE_P 590
#define RELEASE 591
#define RENAME 592
#define REPEATABLE 593
#define REPLACE 594
#define REPLICA 595
#define RESET 596
#define RESTART 597
#define RESTRICT 598
#define RETURNING 599
#define RETURNS 600
#define REVOKE 601
#define RIGHT 602
#define ROLE 603
#define ROLLBACK 604
#define ROW 605
#define ROWS 606
#define RULE 607
#define SAVEPOINT 608
#define SCHEMA 609
#define SCROLL 610
#define SEARCH 611
#define SECOND_P 612
#define SECURITY 613
#define SELECT 614
#define SEQUENCE 615
#define SERIALIZABLE 616
#define SESSION 617
#define SESSION_USER 618
#define SET 619
#define SETOF 620
#define SHARE 621
#define SHOW 622
#define SIMILAR 623
#define SIMPLE 624
#define SMALLINT 625
#define SOME 626
#define STABLE 627
#define STANDALONE_P 628
#define START 629
#define STATEMENT 630
#define STATISTICS 631
#define STDIN 632
#define STDOUT 633
#define STORAGE 634
#define STRICT_P 635
#define STRIP_P 636
#define SUBSTRING 637
#define SUPERUSER_P 638
#define SYMMETRIC 639
#define SYSID 640
#define SYSTEM_P 641
#define TABLE 642
#define TABLESPACE 643
#define TEMP 644
#define TEMPLATE 645
#define TEMPORARY 646
#define TEXT_P 647
#define THEN 648
#define TIME 649
#define TIMESTAMP 650
#define TO 651
#define TRAILING 652
#define TRANSACTION 653
#define TREAT 654
#define TRIGGER 655
#define TRIM 656
#define TRUE_P 657
#define TRUNCATE 658
#define TRUSTED 659
#define TYPE_P 660
#define UNCOMMITTED 661
#define UNENCRYPTED 662
#define UNION 663
#define UNIQUE 664
#define UNKNOWN 665
#define UNLISTEN 666
#define UNTIL 667
#define UPDATE 668
#define USER 669
#define USING 670
#define VACUUM 671
#define VALID 672
#define VALIDATOR 673
#define VALUE_P 674
#define VALUES 675
#define VARCHAR 676
#define VARYING 677
#define VERBOSE 678
#define VERSION_P 679
#define VIEW 680
#define VOLATILE 681
#define WHEN 682
#define WHERE 683
#define WHITESPACE_P 684
#define WITH 685
#define WITHOUT 686
#define WORK 687
#define WRITE 688
#define XML_P 689
#define XMLATTRIBUTES 690
#define XMLCONCAT 691
#define XMLELEMENT 692
#define XMLFOREST 693
#define XMLPARSE 694
#define XMLPI 695
#define XMLROOT 696
#define XMLSERIALIZE 697
#define YEAR_P 698
#define YES_P 699
#define ZONE 700
#define NULLS_FIRST 701
#define NULLS_LAST 702
#define WITH_CASCADED 703
#define WITH_LOCAL 704
#define WITH_CHECK 705
#define IDENT 706
#define SCONST 707
#define Op 708
#define CSTRING 709
#define CVARIABLE 710
#define CPP_LINE 711
#define IP 712
#define BCONST 713
#define XCONST 714
#define DOLCONST 715
#define ECONST 716
#define NCONST 717
#define ICONST 718
#define PARAM 719
#define FCONST 720
#define POSTFIXOP 721
#define UMINUS 722




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			fclose(yyin);
			fclose(yyout);
			if (unlink(output_filename) != 0 && *output_filename != '-')
			        fprintf(stderr, "Could not remove output file %s!\n", output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->lineno), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "Initializer not allowed in typedef command");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "Type %s already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "No multidimensional array support for simple data types");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 372 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1398 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1422 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   72778

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  488
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  566
/* YYNRULES -- Number of rules. */
#define YYNRULES  2241
/* YYNRULES -- Number of states. */
#define YYNSTATES  3863

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   723

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   474,     2,     2,
     479,   480,   472,   470,   486,   471,   481,   473,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   487,   482,
     467,   466,   468,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   477,     2,   478,   475,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   483,     2,   484,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   469,   476,   485
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   220,   222,   224,
     226,   228,   230,   232,   234,   236,   238,   240,   242,   244,
     246,   248,   250,   252,   254,   260,   262,   263,   266,   269,
     273,   277,   279,   281,   283,   285,   287,   289,   291,   293,
     295,   297,   301,   305,   308,   311,   314,   317,   321,   325,
     331,   337,   342,   348,   353,   357,   363,   367,   373,   379,
     386,   388,   390,   394,   400,   407,   412,   414,   415,   418,
     419,   421,   423,   425,   427,   429,   431,   434,   438,   442,
     446,   450,   454,   458,   462,   466,   469,   475,   478,   481,
     485,   489,   493,   495,   499,   501,   505,   508,   511,   514,
     516,   518,   520,   522,   524,   526,   528,   530,   532,   534,
     538,   545,   547,   549,   551,   553,   554,   556,   558,   562,
     567,   573,   578,   581,   584,   588,   593,   597,   600,   603,
     605,   610,   612,   614,   616,   618,   620,   623,   626,   629,
     632,   637,   642,   644,   648,   652,   657,   664,   671,   678,
     685,   690,   697,   700,   705,   709,   713,   717,   721,   726,
     731,   735,   739,   743,   747,   751,   755,   760,   765,   769,
     772,   776,   778,   780,   784,   788,   792,   795,   798,   802,
     805,   807,   809,   810,   813,   814,   817,   820,   830,   837,
     839,   841,   843,   845,   847,   850,   851,   853,   855,   859,
     863,   865,   867,   871,   875,   879,   884,   886,   887,   890,
     891,   895,   896,   898,   899,   911,   924,   926,   928,   931,
     934,   937,   940,   941,   943,   944,   946,   950,   952,   954,
     956,   960,   963,   964,   968,   970,   972,   975,   977,   981,
     986,   991,   994,  1000,  1002,  1005,  1008,  1011,  1015,  1018,
    1019,  1022,  1025,  1028,  1031,  1034,  1037,  1041,  1043,  1048,
    1055,  1063,  1075,  1079,  1080,  1084,  1086,  1088,  1091,  1094,
    1095,  1097,  1099,  1102,  1105,  1106,  1110,  1114,  1117,  1119,
    1121,  1124,  1127,  1132,  1133,  1136,  1139,  1142,  1143,  1147,
    1152,  1157,  1158,  1161,  1162,  1167,  1168,  1169,  1177,  1183,
    1187,  1188,  1192,  1194,  1196,  1202,  1207,  1210,  1211,  1214,
    1216,  1219,  1223,  1226,  1229,  1232,  1235,  1239,  1243,  1247,
    1249,  1250,  1256,  1266,  1268,  1269,  1271,  1274,  1277,  1278,
    1281,  1282,  1288,  1296,  1298,  1299,  1306,  1309,  1310,  1314,
    1320,  1335,  1355,  1357,  1359,  1361,  1365,  1371,  1373,  1375,
    1377,  1381,  1382,  1384,  1385,  1387,  1389,  1391,  1395,  1396,
    1398,  1400,  1401,  1404,  1406,  1409,  1411,  1414,  1415,  1418,
    1420,  1423,  1426,  1433,  1442,  1451,  1455,  1461,  1466,  1471,
    1476,  1480,  1488,  1497,  1504,  1511,  1518,  1525,  1529,  1531,
    1535,  1539,  1541,  1543,  1545,  1547,  1549,  1553,  1557,  1561,
    1563,  1567,  1571,  1573,  1577,  1591,  1593,  1597,  1602,  1610,
    1615,  1623,  1626,  1628,  1629,  1632,  1633,  1635,  1636,  1643,
    1652,  1661,  1663,  1667,  1673,  1679,  1687,  1697,  1705,  1715,
    1721,  1728,  1735,  1740,  1742,  1744,  1746,  1748,  1750,  1752,
    1754,  1756,  1760,  1764,  1768,  1772,  1774,  1778,  1780,  1783,
    1786,  1790,  1795,  1801,  1806,  1811,  1815,  1820,  1824,  1828,
    1831,  1836,  1839,  1841,  1843,  1845,  1847,  1850,  1853,  1855,
    1857,  1859,  1862,  1865,  1867,  1870,  1873,  1875,  1877,  1879,
    1886,  1894,  1902,  1912,  1921,  1930,  1937,  1947,  1957,  1965,
    1976,  1984,  1993,  2002,  2011,  2020,  2022,  2024,  2026,  2028,
    2030,  2032,  2034,  2036,  2038,  2040,  2042,  2044,  2046,  2048,
    2056,  2064,  2075,  2078,  2080,  2082,  2084,  2088,  2090,  2092,
    2094,  2096,  2098,  2101,  2104,  2107,  2110,  2113,  2116,  2119,
    2121,  2125,  2127,  2130,  2134,  2135,  2137,  2141,  2144,  2151,
    2158,  2162,  2163,  2167,  2168,  2182,  2197,  2199,  2200,  2203,
    2204,  2206,  2210,  2215,  2220,  2227,  2229,  2232,  2233,  2235,
    2237,  2238,  2240,  2242,  2243,  2253,  2261,  2264,  2265,  2269,
    2272,  2274,  2278,  2282,  2286,  2289,  2292,  2294,  2296,  2298,
    2300,  2303,  2305,  2309,  2311,  2313,  2315,  2320,  2326,  2328,
    2331,  2336,  2342,  2344,  2346,  2348,  2350,  2354,  2358,  2361,
    2364,  2367,  2370,  2372,  2375,  2378,  2380,  2383,  2384,  2390,
    2392,  2395,  2397,  2398,  2404,  2412,  2418,  2426,  2434,  2444,
    2446,  2450,  2454,  2458,  2460,  2464,  2476,  2487,  2490,  2491,
    2501,  2504,  2505,  2510,  2515,  2520,  2522,  2524,  2526,  2527,
    2535,  2542,  2549,  2556,  2563,  2571,  2581,  2591,  2598,  2605,
    2612,  2619,  2626,  2635,  2644,  2651,  2658,  2667,  2676,  2685,
    2694,  2696,  2697,  2705,  2712,  2719,  2726,  2733,  2740,  2748,
    2755,  2762,  2769,  2776,  2784,  2794,  2804,  2814,  2821,  2828,
    2835,  2844,  2853,  2854,  2869,  2871,  2873,  2877,  2881,  2883,
    2885,  2887,  2889,  2891,  2893,  2895,  2896,  2898,  2900,  2902,
    2904,  2906,  2908,  2909,  2916,  2925,  2928,  2931,  2934,  2937,
    2940,  2944,  2948,  2951,  2954,  2957,  2960,  2964,  2967,  2973,
    2978,  2982,  2986,  2990,  2992,  2994,  2995,  2999,  3002,  3005,
    3007,  3011,  3014,  3016,  3017,  3026,  3037,  3040,  3044,  3048,
    3049,  3052,  3058,  3062,  3064,  3067,  3071,  3075,  3079,  3083,
    3087,  3091,  3095,  3099,  3104,  3108,  3112,  3114,  3115,  3121,
    3126,  3129,  3130,  3135,  3139,  3145,  3152,  3157,  3164,  3171,
    3177,  3185,  3187,  3188,  3195,  3207,  3219,  3231,  3245,  3255,
    3267,  3278,  3282,  3284,  3289,  3292,  3293,  3298,  3304,  3310,
    3313,  3318,  3320,  3322,  3324,  3325,  3327,  3328,  3330,  3331,
    3335,  3336,  3341,  3343,  3345,  3347,  3349,  3351,  3353,  3355,
    3356,  3362,  3367,  3369,  3371,  3373,  3375,  3379,  3380,  3385,
    3394,  3398,  3399,  3402,  3406,  3409,  3413,  3419,  3421,  3426,
    3429,  3433,  3435,  3438,  3441,  3442,  3449,  3452,  3453,  3459,
    3463,  3464,  3467,  3470,  3473,  3477,  3479,  3483,  3485,  3488,
    3490,  3491,  3499,  3501,  3505,  3507,  3509,  3513,  3519,  3522,
    3524,  3528,  3536,  3537,  3540,  3543,  3546,  3550,  3551,  3554,
    3557,  3559,  3561,  3565,  3569,  3571,  3574,  3579,  3584,  3586,
    3588,  3597,  3599,  3604,  3609,  3614,  3617,  3619,  3620,  3624,
    3628,  3633,  3638,  3643,  3648,  3651,  3653,  3655,  3656,  3658,
    3659,  3661,  3667,  3669,  3670,  3672,  3673,  3677,  3679,  3683,
    3688,  3692,  3697,  3702,  3705,  3708,  3713,  3715,  3716,  3718,
    3720,  3722,  3726,  3727,  3730,  3731,  3733,  3737,  3739,  3740,
    3742,  3745,  3750,  3755,  3758,  3759,  3762,  3766,  3769,  3770,
    3774,  3776,  3778,  3781,  3783,  3786,  3792,  3799,  3805,  3807,
    3810,  3812,  3817,  3821,  3826,  3832,  3837,  3843,  3848,  3854,
    3857,  3862,  3864,  3867,  3870,  3873,  3875,  3877,  3878,  3883,
    3886,  3888,  3891,  3894,  3899,  3901,  3904,  3908,  3910,  3913,
    3914,  3917,  3922,  3927,  3928,  3930,  3934,  3937,  3940,  3944,
    3950,  3957,  3961,  3966,  3967,  3969,  3973,  3977,  3981,  3985,
    3989,  3993,  3995,  3997,  3999,  4001,  4003,  4005,  4007,  4010,
    4016,  4018,  4020,  4022,  4024,  4027,  4031,  4035,  4036,  4038,
    4040,  4042,  4044,  4046,  4049,  4052,  4055,  4058,  4061,  4063,
    4067,  4068,  4070,  4072,  4074,  4076,  4082,  4085,  4087,  4089,
    4091,  4093,  4099,  4102,  4105,  4108,  4110,  4114,  4118,  4121,
    4123,  4124,  4128,  4129,  4135,  4138,  4144,  4147,  4149,  4153,
    4157,  4158,  4160,  4162,  4164,  4166,  4168,  4170,  4174,  4178,
    4182,  4186,  4190,  4194,  4198,  4199,  4201,  4205,  4211,  4214,
    4217,  4221,  4225,  4229,  4233,  4237,  4241,  4245,  4249,  4253,
    4257,  4260,  4263,  4267,  4271,  4274,  4278,  4284,  4289,  4296,
    4300,  4306,  4311,  4318,  4323,  4330,  4336,  4344,  4347,  4351,
    4354,  4359,  4363,  4367,  4372,  4376,  4381,  4385,  4390,  4396,
    4403,  4410,  4418,  4425,  4433,  4440,  4448,  4452,  4457,  4462,
    4469,  4472,  4476,  4481,  4483,  4487,  4490,  4494,  4498,  4502,
    4506,  4510,  4514,  4518,  4522,  4526,  4530,  4533,  4536,  4542,
    4549,  4556,  4564,  4568,  4573,  4575,  4577,  4580,  4585,  4587,
    4589,  4591,  4594,  4597,  4600,  4602,  4606,  4611,  4617,  4623,
    4628,  4630,  4632,  4637,  4639,  4644,  4646,  4651,  4653,  4658,
    4660,  4662,  4664,  4666,  4673,  4678,  4683,  4688,  4693,  4700,
    4706,  4712,  4718,  4723,  4730,  4735,  4740,  4745,  4750,  4756,
    4764,  4772,  4782,  4787,  4794,  4800,  4808,  4816,  4819,  4823,
    4827,  4831,  4836,  4837,  4842,  4844,  4848,  4852,  4854,  4856,
    4858,  4861,  4864,  4865,  4870,  4874,  4880,  4882,  4884,  4886,
    4888,  4890,  4892,  4894,  4896,  4898,  4900,  4902,  4904,  4906,
    4908,  4910,  4915,  4917,  4922,  4924,  4929,  4931,  4934,  4936,
    4939,  4941,  4945,  4949,  4950,  4952,  4956,  4958,  4962,  4966,
    4970,  4972,  4974,  4976,  4978,  4980,  4982,  4984,  4986,  4991,
    4995,  4998,  5002,  5003,  5007,  5011,  5014,  5017,  5019,  5020,
    5023,  5026,  5030,  5033,  5035,  5037,  5041,  5047,  5050,  5052,
    5057,  5060,  5061,  5063,  5064,  5066,  5069,  5072,  5075,  5079,
    5085,  5087,  5090,  5091,  5094,  5096,  5097,  5099,  5101,  5103,
    5107,  5111,  5115,  5117,  5121,  5123,  5125,  5127,  5129,  5131,
    5135,  5137,  5140,  5142,  5146,  5148,  5150,  5152,  5154,  5156,
    5158,  5160,  5163,  5165,  5168,  5172,  5179,  5181,  5183,  5185,
    5187,  5189,  5191,  5193,  5195,  5197,  5199,  5201,  5203,  5205,
    5207,  5209,  5212,  5214,  5216,  5218,  5220,  5223,  5226,  5228,
    5230,  5232,  5234,  5236,  5238,  5240,  5242,  5245,  5248,  5250,
    5252,  5254,  5256,  5258,  5260,  5262,  5264,  5267,  5273,  5275,
    5277,  5279,  5281,  5287,  5291,  5294,  5297,  5301,  5309,  5311,
    5313,  5315,  5316,  5319,  5322,  5324,  5325,  5327,  5331,  5333,
    5336,  5337,  5340,  5341,  5344,  5345,  5347,  5351,  5356,  5360,
    5362,  5364,  5366,  5369,  5370,  5378,  5382,  5384,  5386,  5388,
    5390,  5393,  5394,  5396,  5400,  5404,  5408,  5412,  5413,  5418,
    5424,  5430,  5431,  5433,  5435,  5437,  5439,  5442,  5445,  5448,
    5450,  5453,  5454,  5462,  5463,  5469,  5470,  5475,  5478,  5481,
    5482,  5485,  5487,  5489,  5491,  5493,  5495,  5497,  5499,  5501,
    5503,  5505,  5507,  5513,  5516,  5518,  5522,  5525,  5528,  5532,
    5533,  5539,  5541,  5542,  5548,  5551,  5554,  5556,  5558,  5560,
    5563,  5566,  5570,  5572,  5575,  5578,  5582,  5586,  5591,  5594,
    5596,  5599,  5601,  5603,  5606,  5609,  5613,  5615,  5617,  5619,
    5621,  5622,  5624,  5628,  5634,  5635,  5638,  5639,  5641,  5644,
    5648,  5651,  5653,  5655,  5657,  5658,  5660,  5662,  5664,  5667,
    5670,  5672,  5674,  5675,  5677,  5679,  5681,  5683,  5686,  5689,
    5693,  5694,  5696,  5699,  5701,  5706,  5711,  5712,  5714,  5717,
    5719,  5721,  5725,  5727,  5729,  5734,  5739,  5744,  5746,  5747,
    5751,  5755,  5760,  5762,  5766,  5770,  5775,  5777,  5781,  5785,
    5787,  5794,  5796,  5800,  5804,  5811,  5813,  5817,  5821,  5823,
    5825,  5827,  5829,  5831,  5833,  5835,  5837,  5839,  5841,  5843,
    5845,  5847,  5849,  5851,  5856,  5861,  5863,  5865,  5870,  5875,
    5879,  5880,  5888,  5890,  5891,  5892,  5900,  5904,  5909,  5913,
    5915,  5917,  5919,  5922,  5926,  5932,  5935,  5941,  5944,  5946,
    5948,  5950,  5952,  5954,  5956,  5958,  5960,  5962,  5964,  5966,
    5968,  5970,  5972,  5974,  5976,  5978,  5980,  5982,  5984,  5986,
    5988,  5990,  5992,  5994,  5996,  5998,  6000,  6002,  6004,  6006,
    6008,  6010,  6012,  6014,  6016,  6018,  6020,  6022,  6024,  6026,
    6028,  6030,  6032,  6034,  6036,  6038,  6040,  6042,  6044,  6046,
    6048,  6050,  6052,  6054,  6056,  6058,  6060,  6062,  6064,  6066,
    6068,  6070,  6072,  6074,  6076,  6078,  6080,  6082,  6084,  6086,
    6088,  6090,  6092,  6094,  6096,  6098,  6100,  6102,  6104,  6106,
    6108,  6110,  6112,  6114,  6116,  6118,  6120,  6122,  6124,  6126,
    6128,  6130,  6132,  6134,  6136,  6138,  6140,  6142,  6144,  6146,
    6148,  6150,  6152,  6154,  6156,  6158,  6160,  6162,  6164,  6166,
    6168,  6170,  6172,  6174,  6176,  6178,  6180,  6182,  6184,  6186,
    6188,  6190,  6192,  6194,  6196,  6198,  6200,  6202,  6204,  6206,
    6208,  6210,  6212,  6214,  6216,  6218,  6220,  6222,  6224,  6226,
    6228,  6230,  6232,  6234,  6236,  6238,  6240,  6242,  6244,  6246,
    6248,  6250,  6252,  6254,  6256,  6258,  6260,  6262,  6264,  6266,
    6268,  6270,  6272,  6274,  6276,  6278,  6280,  6282,  6284,  6286,
    6288,  6290,  6292,  6294,  6296,  6298,  6300,  6302,  6304,  6306,
    6308,  6310,  6312,  6314,  6316,  6318,  6320,  6322,  6324,  6326,
    6328,  6330,  6332,  6334,  6336,  6338,  6340,  6342,  6344,  6346,
    6348,  6350,  6352,  6354,  6356,  6358,  6360,  6362,  6364,  6366,
    6368,  6370,  6372,  6374,  6376,  6378,  6380,  6382,  6384,  6386,
    6388,  6390,  6392,  6394,  6396,  6398,  6400,  6402,  6404,  6406,
    6408,  6410,  6412,  6414,  6416,  6418,  6420,  6422,  6424,  6426,
    6428,  6430,  6432,  6434,  6436,  6438,  6440,  6442,  6444,  6446,
    6448,  6450,  6452,  6454,  6456,  6458,  6460,  6462,  6464,  6466,
    6468,  6470,  6472,  6474,  6476,  6478,  6480,  6482,  6484,  6486,
    6488,  6490,  6492,  6494,  6496,  6498,  6500,  6502,  6504,  6506,
    6508,  6510,  6512,  6514,  6516,  6518,  6520,  6522,  6524,  6526,
    6528,  6530,  6532,  6534,  6536,  6538,  6540,  6542,  6544,  6546,
    6548,  6550,  6552,  6554,  6556,  6558,  6560,  6562,  6564,  6566,
    6568,  6570,  6572,  6574,  6576,  6578,  6580,  6582,  6584,  6586,
    6588,  6590,  6592,  6594,  6596,  6598,  6600,  6602,  6604,  6606,
    6608,  6610,  6612,  6614,  6616,  6618,  6620,  6622,  6624,  6626,
    6628,  6630,  6632,  6634,  6636,  6638,  6640,  6642,  6644,  6646,
    6648,  6650,  6652,  6654,  6656,  6658,  6660,  6662,  6664,  6666,
    6668,  6670,  6672,  6674,  6676,  6678,  6680,  6682,  6684,  6686,
    6688,  6690,  6692,  6694,  6696,  6698,  6700,  6702,  6704,  6706,
    6708,  6710,  6712,  6714,  6716,  6718,  6720,  6722,  6724,  6726,
    6728,  6730,  6732,  6734,  6736,  6738,  6740,  6742,  6744,  6746,
    6748,  6750,  6752,  6754,  6756,  6758,  6760,  6762,  6764,  6766,
    6768,  6770,  6772,  6774,  6776,  6778,  6780,  6782,  6784,  6786,
    6788,  6790,  6792,  6794,  6796,  6798,  6800,  6802,  6804,  6806,
    6808,  6810,  6812,  6814,  6816,  6818,  6820,  6822,  6824,  6826,
    6828,  6830,  6832,  6834,  6836,  6838,  6842,  6844,  6845,  6847,
    6850,  6852,  6855,  6857,  6859,  6862,  6865,  6867,  6869,  6871,
    6873,  6875,  6877,  6880,  6884,  6886,  6889,  6891,  6895,  6897,
    6901,  6903,  6905,  6907,  6909,  6911,  6913,  6915,  6917,  6919,
    6921,  6923,  6925,  6927,  6929,  6931,  6933,  6935,  6937,  6939,
    6941,  6943,  6945,  6947,  6949,  6951,  6953,  6955,  6957,  6959,
    6961,  6963,  6965,  6967,  6969,  6971,  6973,  6975,  6977,  6979,
    6981,  6983,  6985,  6987,  6989,  6991,  6993,  6995,  6997,  6999,
    7001,  7003,  7005,  7007,  7009,  7011,  7013,  7015,  7017,  7019,
    7021,  7023
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     489,     0,    -1,   490,    -1,    -1,   490,   491,    -1,  1039,
     492,   493,   482,    -1,  1039,   493,   482,    -1,  1039,   936,
      -1,   941,    -1,  1052,    -1,   456,    -1,   483,    -1,   484,
      -1,    95,   977,    -1,   730,    -1,   731,    -1,   736,    -1,
     687,    -1,   505,    -1,   704,    -1,   705,    -1,   583,    -1,
     530,    -1,   499,    -1,   498,    -1,   739,    -1,   738,    -1,
     500,    -1,   501,    -1,   744,    -1,   528,    -1,   538,    -1,
     741,    -1,   647,    -1,   525,    -1,   539,    -1,   576,    -1,
     611,    -1,   695,    -1,   740,    -1,   735,    -1,   673,    -1,
     504,    -1,   587,    -1,   623,    -1,   629,    -1,   630,    -1,
     494,    -1,   508,    -1,   582,    -1,   548,    -1,   594,    -1,
     597,    -1,   497,    -1,   726,    -1,   758,    -1,   777,    -1,
     613,    -1,   764,    -1,   529,    -1,   612,    -1,   697,    -1,
     507,    -1,   633,    -1,   634,    -1,   635,    -1,   592,    -1,
     502,    -1,   714,    -1,   637,    -1,   596,    -1,   610,    -1,
     503,    -1,   734,    -1,   750,    -1,   756,    -1,   643,    -1,
     650,    -1,   661,    -1,   665,    -1,   759,    -1,   716,    -1,
     725,    -1,   766,    -1,   715,    -1,   753,    -1,   636,    -1,
     699,    -1,   691,    -1,   692,    -1,   690,    -1,   702,    -1,
     651,    -1,   662,    -1,   706,    -1,   780,    -1,   718,    -1,
     642,    -1,   717,    -1,   770,    -1,   743,    -1,   512,    -1,
     522,    -1,   523,    -1,   723,    -1,   993,    -1,   920,    -1,
     934,    -1,   994,    -1,   974,    -1,   991,    -1,   975,    -1,
     935,    -1,   981,    -1,  1002,    -1,   995,    -1,   982,    -1,
    1009,    -1,  1011,    -1,  1005,    -1,   998,    -1,  1012,    -1,
    1015,    -1,  1017,    -1,   137,   348,   918,   495,   496,    -1,
     430,    -1,    -1,   315,   908,    -1,   315,   291,    -1,   179,
     315,   908,    -1,   407,   315,   908,    -1,   383,    -1,   285,
      -1,   225,    -1,   282,    -1,   138,    -1,   279,    -1,   139,
      -1,   280,    -1,   262,    -1,   283,    -1,   130,   254,   910,
      -1,   417,   412,   908,    -1,   414,   895,    -1,   385,   909,
      -1,    78,   895,    -1,   348,   895,    -1,   220,   348,   895,
      -1,   220,   209,   895,    -1,   137,   414,   918,   495,   496,
      -1,    83,   348,   918,   495,   496,    -1,    83,   348,   918,
     524,    -1,    83,   414,   918,   495,   496,    -1,    83,   414,
     918,   524,    -1,   174,   348,   895,    -1,   174,   348,   215,
     187,   895,    -1,   174,   414,   895,    -1,   174,   414,   215,
     187,   895,    -1,   137,   209,   918,   495,   496,    -1,    83,
     209,   918,   506,   414,   895,    -1,    77,    -1,   174,    -1,
     174,   209,   895,    -1,   174,   209,   215,   187,   895,    -1,
     137,   354,   509,    96,   918,   510,    -1,   137,   354,  1025,
     510,    -1,  1025,    -1,    -1,   510,   511,    -1,    -1,   548,
      -1,   665,    -1,   582,    -1,   597,    -1,   650,    -1,   723,
      -1,   364,   513,    -1,   364,   257,   513,    -1,   364,   362,
     513,    -1,   514,   396,   515,    -1,   514,   485,   515,    -1,
     514,   396,   157,    -1,   514,   485,   157,    -1,   514,   201,
     143,    -1,   394,   445,   519,    -1,   398,   721,    -1,   362,
     116,    90,   398,   721,    -1,   272,   520,    -1,   348,   521,
      -1,   362,    96,   521,    -1,   362,    96,   157,    -1,   434,
     304,   854,    -1,  1024,    -1,   514,   481,  1025,    -1,   517,
      -1,   515,   486,   517,    -1,   329,   406,    -1,   329,   127,
      -1,   338,   329,    -1,   361,    -1,   518,    -1,   916,    -1,
    1025,    -1,   402,    -1,   191,    -1,   301,    -1,   297,    -1,
     916,    -1,  1046,    -1,   842,   913,   844,    -1,   842,   479,
     909,   480,   913,   844,    -1,   157,    -1,   257,    -1,   913,
      -1,   157,    -1,    -1,  1025,    -1,   913,    -1,   367,   514,
     988,    -1,   367,   394,   445,   988,    -1,   367,   398,   242,
     252,   988,    -1,   367,   362,    96,   988,    -1,   367,    81,
      -1,   341,   514,    -1,   341,   394,   445,    -1,   341,   398,
     242,   252,    -1,   341,   362,    96,    -1,   341,    81,    -1,
     364,   513,    -1,   523,    -1,   364,   132,   526,   527,    -1,
      81,    -1,   893,    -1,   160,    -1,   217,    -1,   118,    -1,
     168,    81,    -1,   168,   389,    -1,   168,   391,    -1,   168,
     317,    -1,    83,   387,   814,   531,    -1,    83,   223,   814,
     533,    -1,   532,    -1,   531,   486,   532,    -1,    77,   703,
     553,    -1,    83,   703,  1025,   535,    -1,    83,   703,  1025,
     174,   286,   291,    -1,    83,   703,  1025,   364,   286,   291,
      -1,    83,   703,  1025,   364,   376,   909,    -1,    83,   703,
    1025,   364,   379,  1025,    -1,   174,   703,  1025,   536,    -1,
      83,   703,  1025,   405,   821,   537,    -1,    77,   561,    -1,
     174,   131,   896,   536,    -1,   364,   431,   299,    -1,   121,
     301,   896,    -1,   364,   431,   121,    -1,   177,   400,   896,
      -1,   177,    84,   400,   896,    -1,   177,   340,   400,   896,
      -1,   177,   400,    81,    -1,   177,   400,   414,    -1,   167,
     400,   896,    -1,   167,   400,    81,    -1,   167,   400,   414,
      -1,   177,   352,   896,    -1,   177,    84,   352,   896,    -1,
     177,   340,   352,   896,    -1,   167,   352,   896,    -1,   225,
     894,    -1,   278,   225,   894,    -1,   534,    -1,   534,    -1,
     533,   486,   534,    -1,   312,   396,   918,    -1,   364,   388,
     896,    -1,   364,   614,    -1,   341,   614,    -1,   364,   157,
     845,    -1,   174,   157,    -1,   109,    -1,   343,    -1,    -1,
     415,   845,    -1,    -1,   120,   896,    -1,   120,    81,    -1,
     135,   544,   894,   545,   540,   541,   546,   495,   542,    -1,
     135,   781,   396,   541,   495,   542,    -1,   396,    -1,   201,
      -1,   913,    -1,   377,    -1,   378,    -1,   542,   543,    -1,
      -1,   102,    -1,   299,    -1,   163,   737,   913,    -1,   291,
     737,   913,    -1,   142,    -1,   212,    -1,   328,   737,   908,
      -1,   182,   737,   908,    -1,   197,   328,   564,    -1,   197,
     286,   291,   564,    -1,   102,    -1,    -1,   430,   299,    -1,
      -1,   547,   164,   913,    -1,    -1,   415,    -1,    -1,   137,
     549,   387,   894,   479,   550,   480,   571,   572,   573,   574,
      -1,   137,   549,   387,   894,   296,   894,   479,   550,   480,
     572,   573,   574,    -1,   391,    -1,   389,    -1,   257,   391,
      -1,   257,   389,    -1,   205,   391,    -1,   205,   389,    -1,
      -1,   551,    -1,    -1,   552,    -1,   551,   486,   552,    -1,
     553,    -1,   558,    -1,   561,    -1,  1025,   821,   554,    -1,
     554,   555,    -1,    -1,   131,   896,   556,    -1,   556,    -1,
     557,    -1,   286,   291,    -1,   291,    -1,   409,   686,   575,
      -1,   323,   244,   686,   575,    -1,   117,   479,   845,   480,
      -1,   157,   846,    -1,   333,   894,   563,   566,   567,    -1,
     159,    -1,   286,   159,    -1,   227,   160,    -1,   227,   217,
      -1,   253,   894,   559,    -1,   559,   560,    -1,    -1,   221,
     158,    -1,   185,   158,    -1,   221,   132,    -1,   185,   132,
      -1,   221,   224,    -1,   185,   224,    -1,   131,   896,   562,
      -1,   562,    -1,   117,   479,   845,   480,    -1,   409,   479,
     564,   480,   686,   575,    -1,   323,   244,   479,   564,   480,
     686,   575,    -1,   198,   244,   479,   564,   480,   333,   894,
     563,   566,   567,   607,    -1,   479,   564,   480,    -1,    -1,
     564,   486,   565,    -1,   565,    -1,  1025,    -1,   264,   202,
      -1,   264,   314,    -1,    -1,   568,    -1,   569,    -1,   568,
     569,    -1,   569,   568,    -1,    -1,   301,   162,   570,    -1,
     301,   413,   570,    -1,   278,    76,    -1,   343,    -1,   109,
      -1,   364,   157,    -1,   364,   291,    -1,   226,   479,   893,
     480,    -1,    -1,   430,   614,    -1,   430,   299,    -1,   431,
     299,    -1,    -1,   301,   126,   174,    -1,   301,   126,   162,
     351,    -1,   301,   126,   320,   351,    -1,    -1,   388,   896,
      -1,    -1,   415,   223,   388,   896,    -1,    -1,    -1,   137,
     549,   387,   578,    90,   577,   780,    -1,   894,   579,   572,
     573,   574,    -1,   479,   580,   480,    -1,    -1,   580,   486,
     581,    -1,   581,    -1,  1025,    -1,   137,   549,   360,   894,
     584,    -1,    83,   360,   894,   584,    -1,   584,   585,    -1,
      -1,   107,   915,    -1,   150,    -1,   278,   150,    -1,   222,
     586,   915,    -1,   265,   915,    -1,   267,   915,    -1,   278,
     265,    -1,   278,   267,    -1,   311,   106,   640,    -1,   374,
     495,   915,    -1,   342,   495,   915,    -1,   106,    -1,    -1,
     137,   588,   593,   246,   521,    -1,   137,   588,   593,   246,
     521,   210,   589,   590,   591,    -1,   404,    -1,    -1,   896,
      -1,   896,   641,    -1,   418,   589,    -1,    -1,   245,   913,
      -1,    -1,   174,   593,   246,   913,   536,    -1,   174,   593,
     246,   215,   187,   913,   536,    -1,   326,    -1,    -1,   137,
     388,   896,   595,   260,   908,    -1,   312,   896,    -1,    -1,
     174,   388,   896,    -1,   174,   388,   215,   187,   896,    -1,
     137,   400,   896,   598,   599,   301,   894,   601,   186,   327,
     896,   479,   604,   480,    -1,   137,   131,   400,   896,    79,
     599,   301,   894,   606,   607,   196,   175,   350,   186,   327,
     902,   479,   604,   480,    -1,    98,    -1,    79,    -1,   600,
      -1,   600,   305,   600,    -1,   600,   305,   600,   305,   600,
      -1,   232,    -1,   162,    -1,   413,    -1,   196,   602,   603,
      -1,    -1,   175,    -1,    -1,   350,    -1,   375,    -1,   605,
      -1,   604,   486,   605,    -1,    -1,   917,    -1,  1025,    -1,
      -1,   201,   894,    -1,   608,    -1,   608,   609,    -1,   609,
      -1,   609,   608,    -1,    -1,   286,   159,    -1,   159,    -1,
     227,   217,    -1,   227,   160,    -1,   174,   400,   896,   301,
     894,   536,    -1,   174,   400,   215,   187,   896,   301,   894,
     536,    -1,   137,    92,   896,   117,   479,   845,   480,   607,
      -1,   174,    92,   896,    -1,   137,    80,   902,   618,   614,
      -1,   137,    80,   902,   619,    -1,   137,   303,   858,   614,
      -1,   137,   405,   640,   614,    -1,   137,   405,   640,    -1,
     137,   405,   640,    90,   479,   819,   480,    -1,   137,   405,
     640,    90,   181,   479,   622,   480,    -1,   137,   392,   356,
     313,   640,   614,    -1,   137,   392,   356,   166,   640,   614,
      -1,   137,   392,   356,   390,   640,   614,    -1,   137,   392,
     356,   129,   640,   614,    -1,   479,   615,   480,    -1,   616,
      -1,   615,   486,   616,    -1,  1027,   466,   617,    -1,  1027,
      -1,   682,    -1,  1037,    -1,   861,    -1,   916,    -1,   479,
     865,   480,    -1,   479,   472,   480,    -1,   479,   620,   480,
      -1,   621,    -1,   620,   486,   621,    -1,  1046,   466,   617,
      -1,   913,    -1,   622,   486,   913,    -1,   137,   303,   119,
     640,   626,   196,   405,   821,   415,   898,   627,    90,   624,
      -1,   625,    -1,   624,   486,   625,    -1,   303,   909,   694,
     628,    -1,   303,   909,   694,   479,   693,   480,   628,    -1,
     203,   909,   902,   675,    -1,   203,   909,   479,   865,   480,
     902,   675,    -1,   379,   821,    -1,   157,    -1,    -1,   192,
     640,    -1,    -1,   332,    -1,    -1,   137,   303,   192,   640,
     415,   898,    -1,    83,   303,   192,   640,   415,   898,    77,
     624,    -1,    83,   303,   192,   640,   415,   898,   174,   631,
      -1,   632,    -1,   631,   486,   632,    -1,   303,   909,   479,
     865,   480,    -1,   203,   909,   479,   865,   480,    -1,   174,
     303,   119,   640,   415,   898,   536,    -1,   174,   303,   119,
     215,   187,   640,   415,   898,   536,    -1,   174,   303,   192,
     640,   415,   898,   536,    -1,   174,   303,   192,   215,   187,
     640,   415,   898,   536,    -1,   174,   311,   106,   895,   536,
      -1,   331,   311,   106,   895,   396,   896,    -1,   174,   638,
     215,   187,   639,   536,    -1,   174,   638,   639,   536,    -1,
     387,    -1,   360,    -1,   425,    -1,   223,    -1,   405,    -1,
     172,    -1,   134,    -1,   354,    -1,   392,   356,   313,    -1,
     392,   356,   166,    -1,   392,   356,   390,    -1,   392,   356,
     129,    -1,   640,    -1,   639,   486,   640,    -1,  1025,    -1,
    1025,   641,    -1,   481,   899,    -1,   641,   481,   899,    -1,
     403,   787,   893,   536,    -1,   193,   644,   646,   896,   988,
      -1,   193,   644,   896,   988,    -1,   193,   646,   896,   988,
      -1,   193,   896,   988,    -1,   193,   644,   646,   896,    -1,
     193,   644,   896,    -1,   193,   646,   896,    -1,   193,   896,
      -1,   270,   644,   646,   896,    -1,   270,   896,    -1,   277,
      -1,   324,    -1,   194,    -1,   248,    -1,    74,   645,    -1,
     335,   645,    -1,   645,    -1,    81,    -1,   199,    -1,   199,
     645,    -1,   199,    81,    -1,    97,    -1,    97,   645,    -1,
      97,    81,    -1,   910,    -1,   220,    -1,   201,    -1,   125,
     301,   648,   896,   240,   649,    -1,   125,   301,    80,   902,
     618,   240,   649,    -1,   125,   301,   203,   902,   675,   240,
     649,    -1,   125,   301,   303,   858,   479,   693,   480,   240,
     649,    -1,   125,   301,   400,   896,   301,   640,   240,   649,
      -1,   125,   301,   352,   896,   301,   640,   240,   649,    -1,
     125,   301,   352,   896,   240,   649,    -1,   125,   301,   303,
     119,   640,   415,   898,   240,   649,    -1,   125,   301,   303,
     192,   640,   415,   898,   240,   649,    -1,   125,   301,   247,
     295,   915,   240,   649,    -1,   125,   301,   112,   479,   821,
      90,   821,   480,   240,   649,    -1,   125,   301,   593,   246,
     640,   240,   649,    -1,   125,   301,   392,   356,   313,   640,
     240,   649,    -1,   125,   301,   392,   356,   166,   640,   240,
     649,    -1,   125,   301,   392,   356,   390,   640,   240,   649,
      -1,   125,   301,   392,   356,   129,   640,   240,   649,    -1,
     124,    -1,   151,    -1,   354,    -1,   223,    -1,   360,    -1,
     387,    -1,   172,    -1,   405,    -1,   425,    -1,   134,    -1,
     388,    -1,   348,    -1,   913,    -1,   291,    -1,   206,   652,
     301,   655,   396,   656,   658,    -1,   346,   652,   301,   655,
     201,   656,   536,    -1,   346,   206,   304,   196,   652,   301,
     655,   201,   656,   536,    -1,    81,   325,    -1,    81,    -1,
     653,    -1,   654,    -1,   653,   486,   654,    -1,   359,    -1,
     333,    -1,   137,    -1,  1025,    -1,   893,    -1,   387,   893,
      -1,   360,   893,    -1,   203,   659,    -1,   151,   895,    -1,
     246,   895,    -1,   354,   895,    -1,   388,   895,    -1,   657,
      -1,   656,   486,   657,    -1,   918,    -1,   209,   918,    -1,
     430,   206,   304,    -1,    -1,   660,    -1,   659,   486,   660,
      -1,   902,   675,    -1,   206,   653,   396,   895,   663,   664,
      -1,   346,   653,   201,   895,   664,   536,    -1,   430,    78,
     304,    -1,    -1,   207,   106,   918,    -1,    -1,   137,   666,
     223,   900,   301,   894,   667,   479,   668,   480,   686,   574,
     817,    -1,   137,   666,   223,   128,   900,   301,   894,   667,
     479,   668,   480,   686,   574,   817,    -1,   409,    -1,    -1,
     415,   898,    -1,    -1,   669,    -1,   668,   486,   669,    -1,
    1025,   670,   671,   672,    -1,   848,   670,   671,   672,    -1,
     479,   845,   480,   670,   671,   672,    -1,   640,    -1,   415,
     640,    -1,    -1,    91,    -1,   165,    -1,    -1,   446,    -1,
     447,    -1,    -1,   137,   674,   203,   902,   675,   345,   681,
     683,   686,    -1,   137,   674,   203,   902,   675,   683,   686,
      -1,   305,   339,    -1,    -1,   479,   676,   480,    -1,   479,
     480,    -1,   677,    -1,   676,   486,   677,    -1,   678,   680,
     682,    -1,   680,   678,   682,    -1,   680,   682,    -1,   678,
     682,    -1,   682,    -1,   220,    -1,   307,    -1,   229,    -1,
     220,   307,    -1,   913,    -1,   913,   486,   913,    -1,  1026,
      -1,   682,    -1,   821,    -1,  1026,   641,   474,   405,    -1,
     365,  1026,   641,   474,   405,    -1,   685,    -1,   683,   685,
      -1,   108,   301,   291,   230,    -1,   345,   291,   301,   291,
     230,    -1,   380,    -1,   218,    -1,   372,    -1,   426,    -1,
     189,   358,   161,    -1,   189,   358,   239,    -1,   358,   161,
      -1,   358,   239,    -1,   136,   915,    -1,   351,   915,    -1,
     524,    -1,    90,   679,    -1,   246,   521,    -1,   684,    -1,
     430,   614,    -1,    -1,    83,   203,   660,   688,   689,    -1,
     684,    -1,   688,   684,    -1,   343,    -1,    -1,   174,   203,
     902,   675,   536,    -1,   174,   203,   215,   187,   902,   675,
     536,    -1,   174,    80,   902,   618,   536,    -1,   174,    80,
     215,   187,   902,   618,   536,    -1,   174,   303,   858,   479,
     693,   480,   536,    -1,   174,   303,   215,   187,   694,   479,
     693,   480,   536,    -1,   821,    -1,   821,   486,   821,    -1,
     284,   486,   821,    -1,   821,   486,   284,    -1,   858,    -1,
    1025,   481,   694,    -1,   137,   112,   479,   821,    90,   821,
     480,   430,   203,   660,   696,    -1,   137,   112,   479,   821,
      90,   821,   480,   431,   203,   696,    -1,    90,    93,    -1,
      -1,   174,   112,   698,   479,   821,    90,   821,   480,   536,
      -1,   215,   187,    -1,    -1,   334,   700,   894,   701,    -1,
     334,   386,   896,   701,    -1,   334,   151,   896,   701,    -1,
     223,    -1,   387,    -1,   197,    -1,    -1,    83,    80,   902,
     618,   337,   396,   896,    -1,    83,   134,   640,   337,   396,
     896,    -1,    83,   151,   897,   337,   396,   897,    -1,    83,
     203,   660,   337,   396,   896,    -1,    83,   209,   918,   337,
     396,   918,    -1,    83,   593,   246,   896,   337,   396,   896,
      -1,    83,   303,   119,   640,   415,   898,   337,   396,   896,
      -1,    83,   303,   192,   640,   415,   898,   337,   396,   896,
      -1,    83,   354,   896,   337,   396,   896,    -1,    83,   387,
     814,   337,   396,   896,    -1,    83,   360,   814,   337,   396,
     896,    -1,    83,   425,   814,   337,   396,   896,    -1,    83,
     223,   814,   337,   396,   896,    -1,    83,   387,   814,   337,
     703,   896,   396,   896,    -1,    83,   400,   896,   301,   814,
     337,   396,   896,    -1,    83,   414,   918,   337,   396,   918,
      -1,    83,   388,   896,   337,   396,   896,    -1,    83,   392,
     356,   313,   640,   337,   396,   896,    -1,    83,   392,   356,
     166,   640,   337,   396,   896,    -1,    83,   392,   356,   390,
     640,   337,   396,   896,    -1,    83,   392,   356,   129,   640,
     337,   396,   896,    -1,   124,    -1,    -1,    83,    80,   902,
     618,   364,   354,   896,    -1,    83,   172,   640,   364,   354,
     896,    -1,    83,   203,   660,   364,   354,   896,    -1,    83,
     360,   814,   364,   354,   896,    -1,    83,   387,   814,   364,
     354,   896,    -1,    83,   405,   640,   364,   354,   896,    -1,
      83,    80,   902,   618,   312,   396,   918,    -1,    83,   134,
     640,   312,   396,   918,    -1,    83,   151,   897,   312,   396,
     918,    -1,    83,   172,   897,   312,   396,   918,    -1,    83,
     203,   660,   312,   396,   918,    -1,    83,   593,   246,   896,
     312,   396,   918,    -1,    83,   303,   694,   479,   693,   480,
     312,   396,   918,    -1,    83,   303,   119,   640,   415,   898,
     312,   396,   918,    -1,    83,   303,   192,   640,   415,   898,
     312,   396,   918,    -1,    83,   354,   896,   312,   396,   918,
      -1,    83,   405,   640,   312,   396,   918,    -1,    83,   388,
     896,   312,   396,   918,    -1,    83,   392,   356,   166,   640,
     312,   396,   918,    -1,    83,   392,   356,   129,   640,   312,
     396,   918,    -1,    -1,   137,   674,   352,   896,    90,   707,
     301,   712,   396,   894,   817,   170,   713,   708,    -1,   287,
      -1,   710,    -1,   479,   709,   480,    -1,   709,   482,   711,
      -1,   711,    -1,   780,    -1,   759,    -1,   770,    -1,   764,
      -1,   715,    -1,   710,    -1,    -1,   359,    -1,   413,    -1,
     162,    -1,   232,    -1,   233,    -1,    82,    -1,    -1,   174,
     352,   896,   301,   894,   536,    -1,   174,   352,   215,   187,
     896,   301,   894,   536,    -1,   288,  1025,    -1,   255,  1025,
      -1,   411,  1025,    -1,   411,   472,    -1,    73,   719,    -1,
      99,   719,   722,    -1,   374,   398,   722,    -1,   126,   719,
      -1,   180,   719,    -1,   349,   719,    -1,   353,  1025,    -1,
     336,   353,  1025,    -1,   336,  1025,    -1,   349,   719,   396,
     353,  1025,    -1,   349,   719,   396,  1025,    -1,   321,   398,
     913,    -1,   126,   322,   913,    -1,   349,   322,   913,    -1,
     432,    -1,   398,    -1,    -1,   242,   252,   516,    -1,   329,
     302,    -1,   329,   433,    -1,   720,    -1,   721,   486,   720,
      -1,   721,   720,    -1,   721,    -1,    -1,   137,   549,   425,
     894,   563,    90,   780,   724,    -1,   137,   305,   339,   549,
     425,   894,   563,    90,   780,   724,    -1,   450,   304,    -1,
     448,   117,   304,    -1,   449,   117,   304,    -1,    -1,   256,
     901,    -1,   137,   151,   897,   430,   727,    -1,   137,   151,
     897,    -1,   728,    -1,   727,   728,    -1,   388,   729,   896,
      -1,   388,   729,   157,    -1,   260,   729,   913,    -1,   260,
     729,   157,    -1,   390,   729,   896,    -1,   390,   729,   157,
      -1,   178,   729,   914,    -1,   178,   729,   157,    -1,   130,
     254,   729,   909,    -1,   312,   729,   896,    -1,   312,   729,
     157,    -1,   466,    -1,    -1,    83,   151,   897,   495,   732,
      -1,    83,   151,   897,   524,    -1,   732,   733,    -1,    -1,
     130,   254,   729,   909,    -1,   174,   151,   897,    -1,   174,
     151,   215,   187,   897,    -1,   137,   172,   640,   737,   821,
     554,    -1,    83,   172,   640,   535,    -1,    83,   172,   640,
     174,   286,   291,    -1,    83,   172,   640,   364,   286,   291,
      -1,    83,   172,   640,    77,   561,    -1,    83,   172,   640,
     174,   131,   896,   536,    -1,    90,    -1,    -1,    83,   392,
     356,   166,   640,   614,    -1,    83,   392,   356,   129,   640,
      77,   263,   196,   895,   430,   639,    -1,    83,   392,   356,
     129,   640,    83,   263,   196,   895,   430,   639,    -1,    83,
     392,   356,   129,   640,    83,   263,   339,   640,   430,   640,
      -1,    83,   392,   356,   129,   640,    83,   263,   196,   895,
     339,   640,   430,   640,    -1,    83,   392,   356,   129,   640,
     174,   263,   196,   895,    -1,    83,   392,   356,   129,   640,
     174,   263,   215,   187,   196,   895,    -1,   137,   626,   134,
     640,   196,   913,   396,   913,   201,   640,    -1,   121,   894,
     742,    -1,   121,    -1,   121,   894,   301,   894,    -1,   415,
     900,    -1,    -1,   416,   747,   748,   746,    -1,   416,   747,
     748,   746,   894,    -1,   416,   747,   748,   746,   744,    -1,
     745,   746,    -1,   745,   746,   894,   749,    -1,    86,    -1,
      85,    -1,   423,    -1,    -1,   202,    -1,    -1,   200,    -1,
      -1,   479,   895,   480,    -1,    -1,   188,   752,   746,   751,
      -1,   780,    -1,   759,    -1,   770,    -1,   764,    -1,   777,
      -1,   756,    -1,   745,    -1,    -1,   321,   980,   755,    90,
     754,    -1,   321,   980,   201,   979,    -1,   780,    -1,   759,
      -1,   770,    -1,   764,    -1,   479,   865,   480,    -1,    -1,
     186,   980,   757,   978,    -1,   137,   549,   387,   578,    90,
     186,   980,   757,    -1,   479,   863,   480,    -1,    -1,   153,
     980,    -1,   153,   321,   980,    -1,   153,    81,    -1,   153,
     321,    81,    -1,   232,   238,   894,   760,   763,    -1,   780,
      -1,   479,   761,   480,   780,    -1,   157,   420,    -1,   761,
     486,   762,    -1,   762,    -1,  1025,   885,    -1,   344,   890,
      -1,    -1,   162,   201,   815,   765,   818,   763,    -1,   415,
     807,    -1,    -1,   261,   787,   893,   767,   769,    -1,   220,
     768,   268,    -1,    -1,    75,   366,    -1,   350,   366,    -1,
     350,   184,    -1,   366,   413,   184,    -1,   366,    -1,   366,
     350,   184,    -1,   184,    -1,    75,   184,    -1,   290,    -1,
      -1,   413,   815,   364,   771,   806,   818,   763,    -1,   772,
      -1,   771,   486,   772,    -1,   773,    -1,   774,    -1,   775,
     466,   887,    -1,   479,   776,   480,   466,   889,    -1,  1025,
     885,    -1,   775,    -1,   776,   486,   775,    -1,   156,   896,
     778,   149,   779,   196,   780,    -1,    -1,   778,   102,    -1,
     778,   231,    -1,   778,   355,    -1,   778,   278,   355,    -1,
      -1,   430,   213,    -1,   431,   213,    -1,   782,    -1,   781,
      -1,   479,   782,   480,    -1,   479,   781,   480,    -1,   784,
      -1,   783,   791,    -1,   783,   790,   800,   795,    -1,   783,
     790,   794,   801,    -1,   784,    -1,   781,    -1,   359,   789,
     890,   785,   806,   817,   798,   799,    -1,   805,    -1,   783,
     408,   788,   783,    -1,   783,   236,   788,   783,    -1,   783,
     183,   788,   783,    -1,   238,   786,    -1,   988,    -1,    -1,
     391,   787,   894,    -1,   389,   787,   894,    -1,   257,   391,
     787,   894,    -1,   257,   389,   787,   894,    -1,   205,   391,
     787,   894,    -1,   205,   389,   787,   894,    -1,   387,   894,
      -1,   894,    -1,   387,    -1,    -1,    81,    -1,    -1,   169,
      -1,   169,   301,   479,   863,   480,    -1,    81,    -1,    -1,
     791,    -1,    -1,   306,   106,   792,    -1,   793,    -1,   792,
     486,   793,    -1,   845,   415,   861,   672,    -1,   845,   671,
     672,    -1,   254,   796,   298,   797,    -1,   298,   797,   254,
     796,    -1,   254,   796,    -1,   298,   797,    -1,   254,   796,
     486,   797,    -1,   794,    -1,    -1,   845,    -1,    81,    -1,
     845,    -1,   209,   106,   863,    -1,    -1,   211,   845,    -1,
      -1,   802,    -1,   196,   329,   302,    -1,   800,    -1,    -1,
     803,    -1,   802,   803,    -1,   196,   413,   804,   769,    -1,
     196,   366,   804,   769,    -1,   296,   895,    -1,    -1,   420,
     889,    -1,   805,   486,   889,    -1,   201,   807,    -1,    -1,
     807,   486,   808,    -1,   808,    -1,   814,    -1,   814,   810,
      -1,   816,    -1,   816,   810,    -1,   816,    90,   479,   819,
     480,    -1,   816,    90,  1025,   479,   819,   480,    -1,   816,
    1025,   479,   819,   480,    -1,   781,    -1,   781,   810,    -1,
     809,    -1,   479,   809,   480,   810,    -1,   479,   809,   480,
      -1,   808,   141,   243,   808,    -1,   808,   811,   243,   808,
     813,    -1,   808,   243,   808,   813,    -1,   808,   274,   811,
     243,   808,    -1,   808,   274,   243,   808,    -1,    90,  1025,
     479,   895,   480,    -1,    90,  1025,    -1,  1025,   479,   895,
     480,    -1,  1025,    -1,   202,   812,    -1,   251,   812,    -1,
     347,   812,    -1,   228,    -1,   308,    -1,    -1,   415,   479,
     895,   480,    -1,   301,   845,    -1,   894,    -1,   894,   472,
      -1,   302,   894,    -1,   302,   479,   894,   480,    -1,   814,
      -1,   814,  1025,    -1,   814,    90,  1025,    -1,   848,    -1,
     428,   845,    -1,    -1,   428,   845,    -1,   428,   143,   296,
     896,    -1,   428,   143,   296,   464,    -1,    -1,   820,    -1,
     819,   486,   820,    -1,  1025,   821,    -1,   824,   822,    -1,
     365,   824,   822,    -1,   824,    89,   477,   909,   478,    -1,
     365,   824,    89,   477,   909,   478,    -1,   477,   478,   822,
      -1,   477,   823,   478,   822,    -1,    -1,   909,    -1,   479,
     823,   480,    -1,   823,   470,   823,    -1,   823,   471,   823,
      -1,   823,   472,   823,    -1,   823,   473,   823,    -1,   823,
     474,   823,    -1,   908,    -1,  1025,    -1,   826,    -1,   841,
      -1,   828,    -1,   830,    -1,   834,    -1,   842,   844,    -1,
     842,   479,   909,   480,   844,    -1,   828,    -1,   831,    -1,
     835,    -1,   841,    -1,  1026,   827,    -1,  1026,   641,   827,
      -1,   479,   863,   480,    -1,    -1,   234,    -1,   235,    -1,
     370,    -1,   101,    -1,   330,    -1,   195,   829,    -1,   173,
     319,    -1,   155,   827,    -1,   154,   827,    -1,   294,   827,
      -1,   104,    -1,   479,   909,   480,    -1,    -1,   832,    -1,
     833,    -1,   832,    -1,   833,    -1,   103,   839,   479,   863,
     480,    -1,   103,   839,    -1,   836,    -1,   837,    -1,   836,
      -1,   837,    -1,   838,   479,   909,   480,   840,    -1,   838,
     840,    -1,   115,   839,    -1,   114,   839,    -1,   421,    -1,
     273,   115,   839,    -1,   273,   114,   839,    -1,   275,   839,
      -1,   422,    -1,    -1,   115,   364,  1025,    -1,    -1,   395,
     479,   909,   480,   843,    -1,   395,   843,    -1,   394,   479,
     909,   480,   843,    -1,   394,   843,    -1,   237,    -1,   430,
     394,   445,    -1,   431,   394,   445,    -1,    -1,   443,    -1,
     269,    -1,   152,    -1,   214,    -1,   266,    -1,   357,    -1,
     443,   396,   269,    -1,   152,   396,   214,    -1,   152,   396,
     266,    -1,   152,   396,   357,    -1,   214,   396,   266,    -1,
     266,   396,   357,    -1,   214,   396,   357,    -1,    -1,   847,
      -1,   845,    72,   821,    -1,   845,    95,   394,   445,   845,
      -1,   470,   845,    -1,   471,   845,    -1,   845,   470,   845,
      -1,   845,   471,   845,    -1,   845,   472,   845,    -1,   845,
     473,   845,    -1,   845,   474,   845,    -1,   845,   475,   845,
      -1,   845,   467,   845,    -1,   845,   468,   845,    -1,   845,
     466,   845,    -1,   845,   860,   845,    -1,   860,   845,    -1,
     845,   860,    -1,   845,    87,   845,    -1,   845,   305,   845,
      -1,   286,   845,    -1,   845,   253,   845,    -1,   845,   253,
     845,   182,   845,    -1,   845,   286,   253,   845,    -1,   845,
     286,   253,   845,   182,   845,    -1,   845,   216,   845,    -1,
     845,   216,   845,   182,   845,    -1,   845,   286,   216,   845,
      -1,   845,   286,   216,   845,   182,   845,    -1,   845,   368,
     396,   845,    -1,   845,   368,   396,   845,   182,   845,    -1,
     845,   286,   368,   396,   845,    -1,   845,   286,   368,   396,
     845,   182,   845,    -1,   845,   241,    -1,   845,   240,   291,
      -1,   845,   289,    -1,   845,   240,   286,   291,    -1,   856,
     309,   856,    -1,   845,   240,   402,    -1,   845,   240,   286,
     402,    -1,   845,   240,   191,    -1,   845,   240,   286,   191,
      -1,   845,   240,   410,    -1,   845,   240,   286,   410,    -1,
     845,   240,   169,   201,   845,    -1,   845,   240,   286,   169,
     201,   845,    -1,   845,   240,   296,   479,   865,   480,    -1,
     845,   240,   286,   296,   479,   865,   480,    -1,   845,   100,
     886,   846,    87,   846,    -1,   845,   286,   100,   886,   846,
      87,   846,    -1,   845,   100,   384,   846,    87,   846,    -1,
     845,   286,   100,   384,   846,    87,   846,    -1,   845,   220,
     876,    -1,   845,   286,   220,   876,    -1,   845,   862,   857,
     781,    -1,   845,   862,   857,   479,   845,   480,    -1,   409,
     781,    -1,   845,   240,   171,    -1,   845,   240,   286,   171,
      -1,   847,    -1,   846,    72,   821,    -1,   471,   846,    -1,
     846,   470,   846,    -1,   846,   471,   846,    -1,   846,   472,
     846,    -1,   846,   473,   846,    -1,   846,   474,   846,    -1,
     846,   475,   846,    -1,   846,   467,   846,    -1,   846,   468,
     846,    -1,   846,   466,   846,    -1,   846,   453,   846,    -1,
     860,   846,    -1,   846,   860,    -1,   846,   240,   169,   201,
     846,    -1,   846,   240,   286,   169,   201,   846,    -1,   846,
     240,   296,   479,   846,   480,    -1,   846,   240,   286,   296,
     479,   846,   480,    -1,   846,   240,   171,    -1,   846,   240,
     286,   171,    -1,   882,    -1,   903,    -1,   464,   885,    -1,
     479,   845,   480,   885,    -1,   877,    -1,   848,    -1,   781,
      -1,   187,   781,    -1,    89,   781,    -1,    89,   867,    -1,
     856,    -1,   902,   479,   480,    -1,   902,   479,   863,   480,
      -1,   902,   479,    81,   863,   480,    -1,   902,   479,   169,
     863,   480,    -1,   902,   479,   472,   480,    -1,   144,    -1,
     146,    -1,   146,   479,   909,   480,    -1,   147,    -1,   147,
     479,   909,   480,    -1,   258,    -1,   258,   479,   909,   480,
      -1,   259,    -1,   259,   479,   909,   480,    -1,   145,    -1,
     148,    -1,   363,    -1,   414,    -1,   112,   479,   845,    90,
     821,   480,    -1,   190,   479,   864,   480,    -1,   310,   479,
     869,   480,    -1,   318,   479,   871,   480,    -1,   382,   479,
     872,   480,    -1,   399,   479,   845,    90,   821,   480,    -1,
     401,   479,   105,   875,   480,    -1,   401,   479,   249,   875,
     480,    -1,   401,   479,   397,   875,   480,    -1,   401,   479,
     875,   480,    -1,   292,   479,   845,   486,   845,   480,    -1,
     122,   479,   863,   480,    -1,   208,   479,   863,   480,    -1,
     250,   479,   863,   480,    -1,   436,   479,   863,   480,    -1,
     437,   479,   271,  1027,   480,    -1,   437,   479,   271,  1027,
     486,   851,   480,    -1,   437,   479,   271,  1027,   486,   863,
     480,    -1,   437,   479,   271,  1027,   486,   851,   486,   863,
     480,    -1,   438,   479,   852,   480,    -1,   439,   479,   854,
     845,   855,   480,    -1,   440,   479,   271,  1027,   480,    -1,
     440,   479,   271,  1027,   486,   845,   480,    -1,   441,   479,
     845,   486,   849,   850,   480,    -1,   424,   845,    -1,   424,
     278,   419,    -1,   486,   373,   444,    -1,   486,   373,   278,
      -1,   486,   373,   278,   419,    -1,    -1,   435,   479,   852,
     480,    -1,   853,    -1,   852,   486,   853,    -1,   845,    90,
    1027,    -1,   845,    -1,   171,    -1,   133,    -1,   320,   429,
      -1,   381,   429,    -1,    -1,   350,   479,   863,   480,    -1,
     350,   479,   480,    -1,   479,   863,   486,   845,   480,    -1,
      88,    -1,   371,    -1,    81,    -1,   453,    -1,   859,    -1,
     470,    -1,   471,    -1,   472,    -1,   474,    -1,   475,    -1,
     473,    -1,   467,    -1,   468,    -1,   466,    -1,   453,    -1,
     303,   479,   694,   480,    -1,   858,    -1,   303,   479,   694,
     480,    -1,   858,    -1,   303,   479,   694,   480,    -1,   253,
      -1,   286,   253,    -1,   216,    -1,   286,   216,    -1,   845,
      -1,   863,   486,   845,    -1,   868,   201,   845,    -1,    -1,
     821,    -1,   865,   486,   821,    -1,   867,    -1,   866,   486,
     867,    -1,   477,   863,   478,    -1,   477,   866,   478,    -1,
    1046,    -1,   443,    -1,   269,    -1,   152,    -1,   214,    -1,
     266,    -1,   357,    -1,   913,    -1,   845,   870,   873,   874,
      -1,   845,   870,   873,    -1,   316,   845,    -1,   846,   220,
     846,    -1,    -1,   845,   873,   874,    -1,   845,   874,   873,
      -1,   845,   873,    -1,   845,   874,    -1,   863,    -1,    -1,
     201,   845,    -1,   196,   845,    -1,   845,   201,   863,    -1,
     201,   863,    -1,   863,    -1,   781,    -1,   479,   863,   480,
      -1,   111,   881,   878,   880,   180,    -1,   878,   879,    -1,
     879,    -1,   427,   845,   393,   845,    -1,   176,   845,    -1,
      -1,   845,    -1,    -1,   892,    -1,   892,   884,    -1,   481,
     899,    -1,   481,   472,    -1,   477,   845,   478,    -1,   477,
     845,   487,   845,   478,    -1,   883,    -1,   884,   883,    -1,
      -1,   885,   883,    -1,    94,    -1,    -1,   845,    -1,   157,
      -1,   887,    -1,   888,   486,   887,    -1,   479,   888,   480,
      -1,   890,   486,   891,    -1,   891,    -1,   845,    90,  1027,
      -1,   845,    -1,   472,    -1,   919,    -1,  1025,    -1,   894,
      -1,   893,   486,   894,    -1,   892,    -1,   892,   884,    -1,
     896,    -1,   895,   486,   896,    -1,  1025,    -1,  1025,    -1,
    1025,    -1,  1027,    -1,  1025,    -1,   913,    -1,  1026,    -1,
     892,   884,    -1,   917,    -1,   825,   913,    -1,   842,   913,
     844,    -1,   842,   479,   909,   480,   913,   844,    -1,   402,
      -1,   191,    -1,   291,    -1,  1042,    -1,   463,    -1,   465,
      -1,   458,    -1,   459,    -1,   452,    -1,   461,    -1,   462,
      -1,   460,    -1,   904,    -1,  1043,    -1,   909,    -1,   471,
     909,    -1,   904,    -1,  1045,    -1,   905,    -1,   911,    -1,
     471,   905,    -1,   471,   904,    -1,   908,    -1,   908,    -1,
    1043,    -1,   904,    -1,   908,    -1,  1043,    -1,   905,    -1,
     904,    -1,   471,   905,    -1,   471,   904,    -1,  1043,    -1,
     908,    -1,   915,    -1,   908,    -1,   905,    -1,   904,    -1,
     906,    -1,   907,    -1,   902,   908,    -1,   902,   479,   863,
     480,   908,    -1,  1043,    -1,  1025,    -1,   300,    -1,   276,
      -1,     9,   396,   921,   928,   929,    -1,     9,   396,   157,
      -1,     9,   930,    -1,   151,   921,    -1,   922,   925,   927,
      -1,   923,   487,   924,   927,   473,   922,   933,    -1,   932,
      -1,   908,    -1,   897,    -1,    -1,  1046,  1045,    -1,   453,
     926,    -1,   924,    -1,    -1,  1025,    -1,  1025,   481,   926,
      -1,   457,    -1,   487,   909,    -1,    -1,    90,   977,    -1,
      -1,   414,   930,    -1,    -1,   931,    -1,   931,   473,   931,
      -1,   931,    22,   106,   931,    -1,   931,   415,   931,    -1,
     918,    -1,   913,    -1,  1045,    -1,   453,  1025,    -1,    -1,
     156,   896,   778,   149,   779,   196,   980,    -1,   186,   217,
     979,    -1,   937,    -1,   948,    -1,   950,    -1,   915,    -1,
     486,   915,    -1,    -1,   844,    -1,   443,   396,   266,    -1,
     443,   396,   357,    -1,   152,   396,   152,    -1,   269,   396,
     269,    -1,    -1,   943,   942,   945,   944,    -1,  1039,    99,
     156,    35,   482,    -1,  1039,   180,   156,    35,   482,    -1,
      -1,   946,    -1,   456,    -1,   950,    -1,   948,    -1,   946,
     950,    -1,   946,   948,    -1,   946,   456,    -1,   950,    -1,
     947,   950,    -1,    -1,    71,   949,   957,   973,  1028,   822,
     482,    -1,    -1,   954,   957,   951,   970,   482,    -1,    -1,
     957,   952,   970,   482,    -1,   960,   482,    -1,   487,   904,
      -1,    -1,   955,   956,    -1,   955,    -1,   956,    -1,    57,
      -1,    68,    -1,    66,    -1,    51,    -1,    52,    -1,    70,
      -1,   966,    -1,   962,    -1,   958,    -1,  1028,   479,   938,
     939,   480,    -1,  1028,   940,    -1,   964,    -1,   181,  1023,
     959,    -1,   181,   959,    -1,   181,  1023,    -1,   483,  1050,
     484,    -1,    -1,   964,   961,   483,   947,   484,    -1,   960,
      -1,    -1,   965,   963,   483,   947,   484,    -1,    44,  1023,
      -1,   408,  1023,    -1,    44,    -1,   408,    -1,   967,    -1,
     969,   968,    -1,    45,    36,    -1,    45,    36,   234,    -1,
      45,    -1,    45,   234,    -1,    45,    26,    -1,    45,    26,
     234,    -1,    45,    26,    26,    -1,    45,    26,    26,   234,
      -1,    45,   114,    -1,    36,    -1,    36,   234,    -1,   234,
      -1,    26,    -1,    26,   234,    -1,    26,    26,    -1,    26,
      26,   234,    -1,     5,    -1,   114,    -1,   173,    -1,    37,
      -1,    -1,   971,    -1,   970,   486,   971,    -1,   973,  1029,
     822,   953,   972,    -1,    -1,   466,  1051,    -1,    -1,   472,
      -1,   472,   472,    -1,   156,   375,  1046,    -1,    17,   976,
      -1,   977,    -1,   143,    -1,    81,    -1,    -1,   897,    -1,
     157,    -1,   932,    -1,   984,   988,    -1,   988,   984,    -1,
     984,    -1,   988,    -1,    -1,   932,    -1,   454,    -1,   896,
      -1,   932,    -1,    19,   896,    -1,    19,    81,    -1,    29,
     896,   983,    -1,    -1,   984,    -1,   415,   989,    -1,   985,
      -1,   415,   987,    16,  1047,    -1,   238,   987,    16,  1047,
      -1,    -1,    38,    -1,   238,  1038,    -1,   986,    -1,   990,
      -1,   990,   486,   989,    -1,   916,    -1,  1042,    -1,    15,
     230,   896,   985,    -1,    15,   992,   896,   985,    -1,    15,
     992,   896,   986,    -1,    30,    -1,    -1,     3,    16,  1047,
      -1,   153,    16,  1047,    -1,   204,    16,  1047,   996,    -1,
     997,    -1,   996,   486,   997,    -1,  1045,   466,  1001,    -1,
     364,    16,  1047,   999,    -1,  1000,    -1,   999,   486,  1000,
      -1,  1001,   466,   911,    -1,    11,    -1,   204,    16,  1047,
     419,   911,  1003,    -1,  1004,    -1,  1003,   486,  1004,    -1,
    1045,   466,  1008,    -1,   364,    16,  1047,   419,   911,  1006,
      -1,  1007,    -1,  1006,   486,  1007,    -1,  1008,   466,   912,
      -1,     8,    -1,    12,    -1,    13,    -1,    14,    -1,    23,
      -1,    24,    -1,    25,    -1,   271,    -1,    27,    -1,    28,
      -1,   319,    -1,    32,    -1,    33,    -1,    34,    -1,   405,
      -1,   364,     4,   466,  1010,    -1,   364,     4,   396,  1010,
      -1,   301,    -1,   297,    -1,   364,   130,   396,   977,    -1,
     364,   130,   466,   977,    -1,   364,   130,   977,    -1,    -1,
     405,  1013,  1028,   240,   957,   822,  1014,    -1,    31,    -1,
      -1,    -1,    46,  1016,  1027,   240,   957,   822,  1014,    -1,
      47,    39,  1018,    -1,    47,   286,    18,  1018,    -1,    47,
      41,  1018,    -1,    10,    -1,    40,    -1,    43,    -1,    21,
     896,    -1,    20,   396,   896,    -1,   170,   896,   479,  1040,
     480,    -1,   170,     6,    -1,     7,   896,   479,  1040,   480,
      -1,     7,   896,    -1,  1020,    -1,  1021,    -1,     6,    -1,
       7,    -1,     8,    -1,    10,    -1,    11,    -1,    12,    -1,
      13,    -1,    14,    -1,    18,    -1,    20,    -1,    21,    -1,
      22,    -1,    23,    -1,    24,    -1,    25,    -1,    27,    -1,
      28,    -1,    32,    -1,    33,    -1,    34,    -1,    35,    -1,
      39,    -1,    40,    -1,    41,    -1,    43,    -1,     9,    -1,
      15,    -1,    17,    -1,    29,    -1,    46,    -1,    47,    -1,
       5,    -1,    26,    -1,    30,    -1,    36,    -1,    44,    -1,
      37,    -1,    45,    -1,  1027,    -1,  1046,    -1,  1032,    -1,
    1034,    -1,  1035,    -1,  1019,    -1,  1030,    -1,   114,    -1,
     420,    -1,  1046,    -1,  1031,    -1,  1035,    -1,  1019,    -1,
    1030,    -1,   114,    -1,   420,    -1,  1046,    -1,  1031,    -1,
    1036,    -1,  1019,    -1,  1022,    -1,  1030,    -1,  1029,    -1,
    1022,    -1,   114,    -1,   230,    -1,   234,    -1,   408,    -1,
     396,    -1,  1030,    -1,  1032,    -1,  1046,    -1,  1035,    -1,
    1036,    -1,  1020,    -1,  1028,    -1,  1037,    -1,  1033,    -1,
    1021,    -1,    51,    -1,    52,    -1,    57,    -1,    66,    -1,
      68,    -1,    71,    -1,    70,    -1,  1032,    -1,  1033,    -1,
     152,    -1,   214,    -1,   266,    -1,   269,    -1,   357,    -1,
     443,    -1,  1034,    -1,   130,    -1,    73,    -1,    74,    -1,
      75,    -1,    76,    -1,    77,    -1,    78,    -1,    79,    -1,
      80,    -1,    82,    -1,    83,    -1,    84,    -1,    92,    -1,
      93,    -1,    95,    -1,    97,    -1,    98,    -1,    99,    -1,
     106,    -1,   107,    -1,   109,    -1,   110,    -1,   113,    -1,
     116,    -1,   118,    -1,   119,    -1,   120,    -1,   121,    -1,
     125,    -1,   126,    -1,   127,    -1,   128,    -1,   129,    -1,
     132,    -1,   133,    -1,   134,    -1,   135,    -1,   136,    -1,
     138,    -1,   139,    -1,   140,    -1,   142,    -1,   149,    -1,
     150,    -1,   151,    -1,   153,    -1,   156,    -1,   158,    -1,
     160,    -1,   162,    -1,   163,    -1,   164,    -1,   166,    -1,
     167,    -1,   168,    -1,   171,    -1,   172,    -1,   173,    -1,
     174,    -1,   175,    -1,   177,    -1,   178,    -1,   179,    -1,
     182,    -1,   185,    -1,   184,    -1,   186,    -1,   188,    -1,
     189,    -1,   192,    -1,   193,    -1,   194,    -1,   197,    -1,
     199,    -1,   203,    -1,   205,    -1,   207,    -1,   210,    -1,
     212,    -1,   213,    -1,   215,    -1,   217,    -1,   218,    -1,
     219,    -1,   221,    -1,   222,    -1,   223,    -1,   224,    -1,
     225,    -1,   226,    -1,   231,    -1,   232,    -1,   233,    -1,
     242,    -1,   244,    -1,   245,    -1,   246,    -1,   247,    -1,
     248,    -1,   252,    -1,   255,    -1,   256,    -1,   257,    -1,
     260,    -1,   261,    -1,   262,    -1,   263,    -1,   264,    -1,
     265,    -1,   267,    -1,   268,    -1,   270,    -1,   271,    -1,
     272,    -1,   277,    -1,   278,    -1,   279,    -1,   280,    -1,
     281,    -1,   282,    -1,   283,    -1,   285,    -1,   287,    -1,
     288,    -1,   290,    -1,   293,    -1,   295,    -1,   296,    -1,
     299,    -1,   303,    -1,   304,    -1,   311,    -1,   312,    -1,
     313,    -1,   314,    -1,   315,    -1,   317,    -1,   321,    -1,
     322,    -1,   320,    -1,   324,    -1,   325,    -1,   326,    -1,
     327,    -1,   328,    -1,   329,    -1,   331,    -1,   332,    -1,
     334,    -1,   335,    -1,   336,    -1,   337,    -1,   338,    -1,
     339,    -1,   340,    -1,   341,    -1,   342,    -1,   343,    -1,
     345,    -1,   346,    -1,   348,    -1,   349,    -1,   351,    -1,
     352,    -1,   353,    -1,   354,    -1,   355,    -1,   356,    -1,
     360,    -1,   361,    -1,   362,    -1,   364,    -1,   366,    -1,
     367,    -1,   369,    -1,   372,    -1,   373,    -1,   374,    -1,
     375,    -1,   376,    -1,   377,    -1,   378,    -1,   379,    -1,
     380,    -1,   381,    -1,   383,    -1,   386,    -1,   385,    -1,
     388,    -1,   389,    -1,   390,    -1,   391,    -1,   392,    -1,
     398,    -1,   400,    -1,   403,    -1,   404,    -1,   405,    -1,
     406,    -1,   407,    -1,   410,    -1,   411,    -1,   412,    -1,
     413,    -1,   416,    -1,   417,    -1,   418,    -1,   419,    -1,
     422,    -1,   424,    -1,   425,    -1,   426,    -1,   429,    -1,
     430,    -1,   431,    -1,   432,    -1,   433,    -1,   434,    -1,
     444,    -1,   445,    -1,   101,    -1,   103,    -1,   115,    -1,
     122,    -1,   154,    -1,   155,    -1,   187,    -1,   190,    -1,
     195,    -1,   208,    -1,   229,    -1,   235,    -1,   237,    -1,
     250,    -1,   273,    -1,   275,    -1,   284,    -1,   292,    -1,
     294,    -1,   307,    -1,   310,    -1,   318,    -1,   319,    -1,
     330,    -1,   350,    -1,   365,    -1,   370,    -1,   382,    -1,
     394,    -1,   395,    -1,   399,    -1,   401,    -1,   421,    -1,
     435,    -1,   436,    -1,   437,    -1,   438,    -1,   439,    -1,
     440,    -1,   441,    -1,   442,    -1,    96,    -1,   100,    -1,
     102,    -1,   141,    -1,   200,    -1,   202,    -1,   216,    -1,
     228,    -1,   240,    -1,   241,    -1,   243,    -1,   251,    -1,
     253,    -1,   274,    -1,   289,    -1,   308,    -1,   309,    -1,
     347,    -1,   368,    -1,   423,    -1,    81,    -1,    85,    -1,
      86,    -1,    87,    -1,    88,    -1,    89,    -1,    90,    -1,
      91,    -1,    94,    -1,   105,    -1,   111,    -1,   112,    -1,
     117,    -1,   123,    -1,   124,    -1,   131,    -1,   137,    -1,
     143,    -1,   144,    -1,   146,    -1,   147,    -1,   145,    -1,
     148,    -1,   157,    -1,   159,    -1,   165,    -1,   169,    -1,
     170,    -1,   176,    -1,   180,    -1,   183,    -1,   191,    -1,
     196,    -1,   198,    -1,   201,    -1,   206,    -1,   209,    -1,
     211,    -1,   220,    -1,   227,    -1,   236,    -1,   238,    -1,
     249,    -1,   254,    -1,   276,    -1,   286,    -1,   291,    -1,
     297,    -1,   298,    -1,   300,    -1,   301,    -1,   302,    -1,
     305,    -1,   306,    -1,   323,    -1,   333,    -1,   344,    -1,
     359,    -1,   363,    -1,   371,    -1,   384,    -1,   387,    -1,
     393,    -1,   397,    -1,   402,    -1,   409,    -1,   414,    -1,
     415,    -1,   427,    -1,   428,    -1,  1041,    -1,  1038,   486,
    1041,    -1,    42,    -1,    -1,  1050,    -1,  1045,  1044,    -1,
    1045,    -1,  1045,  1044,    -1,  1045,    -1,  1045,    -1,    23,
    1045,    -1,    23,   896,    -1,   455,    -1,   451,    -1,   454,
      -1,   896,    -1,   932,    -1,  1053,    -1,   479,   480,    -1,
     479,  1049,   480,    -1,  1048,    -1,  1049,  1048,    -1,  1051,
      -1,  1050,   486,  1051,    -1,  1049,    -1,   483,  1050,   484,
      -1,  1053,    -1,   479,    -1,   480,    -1,   486,    -1,   482,
      -1,   451,    -1,   454,    -1,   904,    -1,   905,    -1,   908,
      -1,   472,    -1,   470,    -1,   471,    -1,   473,    -1,   474,
      -1,   291,    -1,    48,    -1,    49,    -1,    50,    -1,    51,
      -1,    52,    -1,    53,    -1,    54,    -1,    55,    -1,    56,
      -1,    57,    -1,    58,    -1,    59,    -1,    61,    -1,    60,
      -1,    62,    -1,    63,    -1,    64,    -1,    65,    -1,    66,
      -1,    67,    -1,    68,    -1,    69,    -1,    71,    -1,    70,
      -1,     5,    -1,   181,    -1,   214,    -1,   234,    -1,    26,
      -1,   266,    -1,   269,    -1,   357,    -1,    36,    -1,    37,
      -1,    44,    -1,    45,    -1,   443,    -1,   114,    -1,   195,
      -1,   396,    -1,   408,    -1,   421,    -1,   477,    -1,   478,
      -1,   466,    -1,   487,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   686,   686,   688,   689,   692,   693,   694,   700,   701,
     702,   703,   704,   707,   720,   721,   722,   723,   724,   725,
     726,   727,   728,   729,   730,   731,   732,   733,   734,   735,
     736,   737,   761,   762,   763,   764,   765,   766,   767,   768,
     769,   770,   771,   772,   773,   774,   775,   776,   777,   778,
     779,   780,   781,   782,   783,   784,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   829,   830,   831,   832,
     833,   834,   835,   836,   837,   838,   839,   845,   846,   847,
     848,   849,   850,   851,   852,   853,   859,   869,   873,   881,
     885,   896,   906,   907,   918,   925,   931,   942,   948,   957,
     964,   970,   979,   986,  1007,  1011,  1012,  1021,  1022,  1023,
    1024,  1025,  1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033,
    1034,  1035,  1036,  1037,  1038,  1039,  1040,  1041,  1042,  1052,
    1063,  1067,  1077,  1080,  1090,  1092,  1102,  1104,  1115,  1125,
    1129,  1130,  1139,  1141,  1152,  1154,  1158,  1159,  1162,  1163,
    1170,  1171,  1172,  1173,  1174,  1175,  1188,  1190,  1192,  1197,
    1199,  1201,  1203,  1205,  1208,  1210,  1212,  1214,  1216,  1218,
    1220,  1222,  1226,  1227,  1231,  1233,  1237,  1238,  1239,  1240,
    1243,  1244,  1245,  1248,  1249,  1250,  1251,  1261,  1262,  1263,
    1265,  1267,  1269,  1273,  1274,  1275,  1278,  1279,  1282,  1284,
    1286,  1288,  1290,  1297,  1299,  1301,  1303,  1305,  1311,  1312,
    1315,  1319,  1321,  1325,  1326,  1332,  1336,  1337,  1338,  1339,
    1349,  1351,  1357,  1358,  1362,  1366,  1369,  1372,  1375,  1378,
    1381,  1384,  1387,  1390,  1393,  1396,  1399,  1402,  1405,  1408,
    1411,  1414,  1417,  1420,  1423,  1426,  1429,  1432,  1435,  1438,
    1441,  1443,  1447,  1448,  1454,  1457,  1459,  1461,  1466,  1467,
    1470,  1471,  1472,  1475,  1476,  1486,  1488,  1492,  1504,  1513,
    1514,  1517,  1518,  1519,  1522,  1523,  1526,  1527,  1528,  1530,
    1532,  1533,  1534,  1536,  1538,  1540,  1545,  1546,  1549,  1550,
    1557,  1560,  1563,  1564,  1574,  1577,  1587,  1588,  1589,  1590,
    1591,  1592,  1593,  1597,  1600,  1602,  1604,  1608,  1609,  1610,
    1613,  1617,  1618,  1621,  1623,  1624,  1638,  1640,  1642,  1644,
    1646,  1648,  1650,  1665,  1666,  1667,  1668,  1671,  1675,  1677,
    1681,  1682,  1683,  1684,  1685,  1686,  1693,  1695,  1699,  1701,
    1703,  1705,  1710,  1711,  1714,  1716,  1720,  1723,  1725,  1731,
    1734,  1735,  1736,  1737,  1738,  1741,  1745,  1749,  1750,  1751,
    1752,  1753,  1756,  1759,  1762,  1763,  1764,  1765,  1768,  1769,
    1770,  1771,  1774,  1775,  1778,  1779,  1788,  1787,  1798,  1804,
    1807,  1810,  1812,  1816,  1827,  1831,  1835,  1836,  1839,  1841,
    1843,  1845,  1847,  1849,  1851,  1853,  1855,  1857,  1859,  1863,
    1864,  1875,  1877,  1882,  1883,  1890,  1891,  1894,  1897,  1899,
    1902,  1905,  1907,  1911,  1912,  1922,  1926,  1927,  1941,  1943,
    1956,  1960,  1967,  1968,  1971,  1973,  1975,  1979,  1980,  1981,
    1984,  1987,  1990,  1991,  1994,  1995,  1998,  2000,  2003,  2006,
    2007,  2010,  2011,  2014,  2015,  2022,  2023,  2031,  2036,  2038,
    2042,  2044,  2048,  2050,  2061,  2069,  2084,  2086,  2088,  2090,
    2092,  2094,  2096,  2098,  2100,  2102,  2104,  2108,  2112,  2113,
    2116,  2117,  2121,  2122,  2123,  2124,  2127,  2128,  2131,  2134,
    2135,  2138,  2141,  2142,  2145,  2152,  2153,  2156,  2158,  2160,
    2162,  2164,  2168,  2169,  2172,  2173,  2176,  2177,  2180,  2184,
    2186,  2190,  2191,  2195,  2197,  2201,  2203,  2207,  2209,  2222,
    2227,  2239,  2241,  2245,  2246,  2247,  2248,  2249,  2250,  2251,
    2252,  2253,  2254,  2255,  2256,  2259,  2261,  2265,  2266,  2269,
    2270,  2279,  2294,  2299,  2304,  2309,  2314,  2319,  2324,  2329,
    2334,  2336,  2340,  2341,  2342,  2343,  2344,  2345,  2346,  2347,
    2348,  2349,  2350,  2351,  2352,  2353,  2356,  2367,  2368,  2371,
    2373,  2375,  2377,  2379,  2381,  2383,  2385,  2387,  2389,  2391,
    2393,  2395,  2397,  2399,  2401,  2405,  2406,  2407,  2408,  2409,
    2410,  2411,  2412,  2413,  2414,  2415,  2416,  2419,  2420,  2430,
    2434,  2436,  2440,  2441,  2442,  2445,  2447,  2451,  2452,  2453,
    2454,  2457,  2459,  2461,  2463,  2465,  2467,  2469,  2471,  2475,
    2477,  2481,  2482,  2485,  2490,  2493,  2495,  2499,  2508,  2513,
    2517,  2518,  2521,  2522,  2538,  2541,  2546,  2547,  2550,  2553,
    2556,  2557,  2560,  2562,  2564,  2568,  2569,  2570,  2573,  2574,
    2575,  2578,  2579,  2580,  2583,  2586,  2591,  2592,  2595,  2597,
    2601,  2603,  2607,  2608,  2609,  2610,  2611,  2614,  2615,  2616,
    2617,  2620,  2622,  2626,  2628,  2638,  2640,  2642,  2647,  2649,
    2654,  2656,  2658,  2660,  2662,  2664,  2666,  2668,  2670,  2672,
    2674,  2676,  2678,  2682,  2684,  2686,  2690,  2691,  2695,  2699,
    2700,  2703,  2704,  2717,  2719,  2723,  2725,  2729,  2731,  2735,
    2740,  2742,  2744,  2749,  2751,  2755,  2758,  2763,  2764,  2768,
    2772,  2773,  2783,  2785,  2787,  2791,  2792,  2795,  2796,  2807,
    2809,  2811,  2813,  2815,  2817,  2819,  2821,  2823,  2825,  2827,
    2829,  2831,  2833,  2835,  2837,  2839,  2841,  2843,  2845,  2847,
    2851,  2852,  2862,  2864,  2866,  2868,  2870,  2872,  2882,  2884,
    2886,  2888,  2890,  2892,  2894,  2896,  2898,  2900,  2902,  2904,
    2906,  2908,  2920,  2919,  2929,  2930,  2931,  2935,  2937,  2941,
    2942,  2943,  2944,  2945,  2948,  2949,  2953,  2954,  2955,  2956,
    2959,  2960,  2961,  2964,  2966,  2978,  2982,  2986,  2988,  3001,
    3002,  3003,  3004,  3005,  3006,  3007,  3008,  3009,  3010,  3011,
    3012,  3013,  3014,  3017,  3018,  3019,  3023,  3025,  3026,  3030,
    3031,  3032,  3036,  3037,  3048,  3050,  3059,  3064,  3069,  3075,
    3085,  3097,  3099,  3103,  3105,  3109,  3111,  3113,  3115,  3117,
    3119,  3121,  3123,  3125,  3127,  3129,  3133,  3134,  3145,  3149,
    3154,  3155,  3159,  3169,  3171,  3182,  3189,  3191,  3193,  3195,
    3197,  3201,  3202,  3206,  3211,  3213,  3215,  3217,  3219,  3221,
    3226,  3240,  3242,  3244,  3249,  3250,  3261,  3263,  3265,  3269,
    3271,  3275,  3276,  3279,  3280,  3283,  3284,  3287,  3288,  3291,
    3294,  3305,  3310,  3311,  3312,  3313,  3314,  3315,  3318,  3319,
    3322,  3328,  3337,  3338,  3339,  3340,  3343,  3344,  3347,  3352,
    3357,  3358,  3361,  3362,  3363,  3364,  3374,  3379,  3381,  3383,
    3387,  3389,  3393,  3397,  3398,  3408,  3412,  3413,  3416,  3420,
    3423,  3426,  3427,  3428,  3429,  3430,  3431,  3432,  3433,  3436,
    3437,  3447,  3456,  3457,  3461,  3462,  3466,  3469,  3472,  3475,
    3476,  3485,  3516,  3517,  3518,  3519,  3520,  3524,  3530,  3531,
    3541,  3543,  3547,  3549,  3553,  3555,  3557,  3559,  3563,  3564,
    3567,  3571,  3573,  3575,  3577,  3581,  3586,  3587,  3597,  3599,
    3601,  3603,  3605,  3607,  3609,  3611,  3615,  3616,  3619,  3620,
    3623,  3625,  3627,  3630,  3633,  3634,  3637,  3641,  3642,  3645,
    3647,  3651,  3653,  3655,  3657,  3659,  3666,  3667,  3670,  3671,
    3674,  3684,  3687,  3690,  3693,  3697,  3698,  3702,  3703,  3707,
    3708,  3712,  3714,  3719,  3720,  3723,  3725,  3737,  3738,  3741,
    3742,  3752,  3754,  3756,  3758,  3760,  3762,  3764,  3766,  3771,
    3773,  3775,  3796,  3798,  3800,  3802,  3804,  3806,  3810,  3812,
    3814,  3816,  3820,  3821,  3822,  3823,  3827,  3828,  3838,  3840,
    3844,  3846,  3848,  3850,  3854,  3856,  3858,  3862,  3865,  3866,
    3869,  3870,  3871,  3872,  3875,  3877,  3881,  3894,  3896,  3898,
    3900,  3905,  3911,  3918,  3925,  3926,  3927,  3928,  3929,  3930,
    3931,  3932,  3933,  3936,  3937,  3938,  3939,  3940,  3941,  3943,
    3947,  3948,  3949,  3950,  3953,  3954,  3957,  3958,  3966,  3968,
    3970,  3972,  3974,  3976,  3978,  3980,  3982,  3984,  3986,  3990,
    3993,  4001,  4002,  4005,  4006,  4009,  4013,  4022,  4023,  4026,
    4027,  4030,  4034,  4038,  4040,  4042,  4044,  4046,  4048,  4052,
    4055,  4058,  4061,  4064,  4066,  4068,  4070,  4074,  4078,  4080,
    4083,  4086,  4087,  4088,  4089,  4090,  4091,  4092,  4093,  4094,
    4095,  4096,  4097,  4098,  4099,  4125,  4127,  4129,  4140,  4142,
    4144,  4146,  4148,  4150,  4152,  4154,  4156,  4158,  4160,  4162,
    4164,  4166,  4168,  4170,  4172,  4174,  4176,  4178,  4180,  4182,
    4184,  4186,  4188,  4190,  4192,  4194,  4196,  4198,  4200,  4202,
    4204,  4206,  4217,  4219,  4221,  4223,  4225,  4227,  4229,  4231,
    4233,  4235,  4237,  4239,  4241,  4243,  4245,  4247,  4249,  4251,
    4253,  4255,  4257,  4269,  4271,  4273,  4275,  4277,  4279,  4281,
    4283,  4285,  4287,  4289,  4291,  4293,  4295,  4297,  4299,  4301,
    4303,  4305,  4307,  4309,  4321,  4323,  4325,  4327,  4329,  4331,
    4333,  4335,  4337,  4339,  4341,  4353,  4355,  4357,  4359,  4361,
    4363,  4365,  4367,  4369,  4371,  4373,  4375,  4377,  4379,  4381,
    4383,  4385,  4387,  4389,  4391,  4393,  4395,  4397,  4399,  4402,
    4404,  4406,  4408,  4410,  4412,  4414,  4416,  4418,  4420,  4422,
    4424,  4426,  4428,  4430,  4432,  4434,  4436,  4444,  4446,  4450,
    4452,  4454,  4457,  4460,  4464,  4466,  4470,  4472,  4476,  4477,
    4480,  4481,  4482,  4485,  4487,  4489,  4493,  4494,  4495,  4498,
    4499,  4502,  4503,  4504,  4505,  4506,  4507,  4508,  4509,  4510,
    4513,  4514,  4517,  4518,  4521,  4522,  4523,  4524,  4525,  4526,
    4529,  4531,  4535,  4538,  4541,  4543,  4547,  4548,  4552,  4553,
    4559,  4560,  4561,  4562,  4563,  4564,  4565,  4566,  4570,  4572,
    4577,  4581,  4584,  4587,  4589,  4591,  4593,  4595,  4598,  4601,
    4605,  4609,  4611,  4613,  4617,  4619,  4626,  4630,  4632,  4636,
    4640,  4643,  4646,  4647,  4650,  4651,  4655,  4656,  4657,  4658,
    4661,  4662,  4666,  4667,  4670,  4671,  4675,  4676,  4680,  4681,
    4684,  4692,  4694,  4699,  4701,  4703,  4779,  4780,  4783,  4785,
    4789,  4791,  4795,  4797,  4802,  4803,  4804,  4805,  4806,  4808,
    4810,  4812,  4820,  4822,  4824,  4826,  4828,  4830,  4832,  4834,
    4838,  4839,  4840,  4841,  4842,  4852,  4863,  4874,  4880,  4881,
    4884,  4885,  4888,  4896,  4899,  4907,  4908,  4917,  4926,  4938,
    4939,  4942,  4943,  4944,  4947,  4948,  4949,  4950,  4951,  4954,
    4955,  4958,  4959,  4960,  4961,  4962,  4963,  4964,  4966,  4969,
    4971,  4978,  4994,  4996,  4999,  5001,  5005,  5017,  5033,  5037,
    5048,  5049,  5052,  5064,  5073,  5074,  5077,  5078,  5079,  5082,
    5083,  5086,  5087,  5090,  5091,  5094,  5096,  5098,  5100,  5104,
    5111,  5134,  5167,  5177,  5184,  5221,  5230,  5232,  5233,  5236,
    5238,  5239,  5242,  5243,  5244,  5245,  5246,  5253,  5252,  5262,
    5264,  5266,  5267,  5268,  5271,  5272,  5273,  5274,  5275,  5278,
    5279,  5283,  5282,  5299,  5297,  5312,  5311,  5324,  5330,  5331,
    5334,  5336,  5337,  5340,  5341,  5342,  5343,  5346,  5347,  5350,
    5358,  5375,  5383,  5406,  5504,  5538,  5540,  5542,  5546,  5550,
    5549,  5600,  5602,  5601,  5616,  5622,  5629,  5634,  5637,  5638,
    5641,  5642,  5643,  5644,  5645,  5646,  5647,  5655,  5663,  5666,
    5667,  5668,  5669,  5670,  5671,  5679,  5687,  5688,  5689,  5692,
    5693,  5696,  5698,  5702,  5788,  5789,  5796,  5797,  5798,  5804,
    5813,  5816,  5817,  5818,  5819,  5822,  5823,  5824,  5827,  5828,
    5829,  5830,  5831,  5834,  5836,  5840,  5853,  5860,  5861,  5867,
    5869,  5870,  5873,  5874,  5877,  5884,  5891,  5891,  5893,  5894,
    5897,  5897,  5899,  5909,  5916,  5923,  5930,  5939,  5940,  5952,
    5963,  5974,  5978,  5979,  5982,  5987,  5991,  5992,  5995,  6002,
    6009,  6013,  6014,  6017,  6020,  6024,  6025,  6028,  6035,  6036,
    6037,  6038,  6039,  6040,  6041,  6042,  6043,  6044,  6045,  6046,
    6047,  6048,  6049,  6056,  6057,  6060,  6061,  6068,  6069,  6070,
    6077,  6076,  6093,  6094,  6101,  6100,  6169,  6175,  6181,  6189,
    6195,  6201,  6207,  6213,  6219,  6225,  6231,  6237,  6248,  6249,
    6252,  6253,  6254,  6255,  6256,  6257,  6258,  6259,  6260,  6261,
    6262,  6263,  6264,  6265,  6266,  6267,  6268,  6269,  6270,  6271,
    6272,  6273,  6274,  6275,  6276,  6279,  6280,  6281,  6282,  6283,
    6284,  6288,  6289,  6290,  6291,  6292,  6293,  6294,  6297,  6311,
    6312,  6313,  6314,  6315,  6316,  6317,  6318,  6322,  6323,  6324,
    6325,  6326,  6327,  6328,  6332,  6333,  6334,  6335,  6336,  6337,
    6343,  6344,  6345,  6346,  6347,  6348,  6349,  6350,  6351,  6354,
    6355,  6356,  6357,  6360,  6361,  6362,  6363,  6366,  6367,  6368,
    6369,  6370,  6371,  6372,  6390,  6390,  6392,  6393,  6394,  6395,
    6396,  6397,  6403,  6404,  6407,  6408,  6409,  6410,  6411,  6412,
    6413,  6414,  6415,  6416,  6417,  6418,  6419,  6420,  6421,  6422,
    6423,  6424,  6425,  6426,  6427,  6428,  6429,  6430,  6431,  6432,
    6433,  6434,  6435,  6436,  6437,  6438,  6440,  6441,  6442,  6443,
    6444,  6445,  6446,  6447,  6448,  6449,  6450,  6451,  6453,  6454,
    6455,  6456,  6457,  6458,  6459,  6460,  6461,  6462,  6463,  6464,
    6465,  6466,  6467,  6468,  6469,  6470,  6472,  6473,  6474,  6475,
    6476,  6477,  6478,  6479,  6480,  6481,  6482,  6483,  6484,  6485,
    6486,  6487,  6488,  6490,  6491,  6492,  6493,  6494,  6495,  6496,
    6497,  6498,  6499,  6500,  6501,  6502,  6503,  6504,  6505,  6506,
    6507,  6508,  6509,  6510,  6511,  6512,  6513,  6514,  6515,  6516,
    6517,  6518,  6520,  6521,  6523,  6524,  6525,  6526,  6527,  6528,
    6529,  6530,  6531,  6532,  6533,  6534,  6535,  6536,  6537,  6538,
    6539,  6540,  6541,  6542,  6543,  6544,  6545,  6546,  6547,  6548,
    6549,  6550,  6551,  6552,  6553,  6554,  6555,  6556,  6557,  6558,
    6559,  6560,  6561,  6562,  6563,  6564,  6565,  6566,  6567,  6568,
    6569,  6570,  6571,  6572,  6573,  6574,  6575,  6576,  6577,  6578,
    6579,  6581,  6582,  6583,  6584,  6585,  6586,  6587,  6588,  6589,
    6590,  6591,  6592,  6593,  6594,  6595,  6596,  6597,  6598,  6599,
    6600,  6601,  6602,  6603,  6604,  6605,  6606,  6607,  6608,  6609,
    6610,  6611,  6612,  6613,  6614,  6615,  6616,  6617,  6618,  6619,
    6620,  6621,  6622,  6623,  6624,  6625,  6626,  6627,  6628,  6629,
    6630,  6631,  6633,  6647,  6648,  6652,  6653,  6654,  6655,  6656,
    6657,  6658,  6659,  6660,  6664,  6665,  6666,  6667,  6668,  6669,
    6670,  6671,  6672,  6673,  6674,  6675,  6676,  6677,  6678,  6679,
    6680,  6681,  6682,  6683,  6684,  6687,  6688,  6689,  6690,  6691,
    6692,  6693,  6694,  6695,  6709,  6710,  6711,  6712,  6713,  6714,
    6715,  6716,  6717,  6718,  6719,  6720,  6721,  6722,  6723,  6724,
    6725,  6726,  6727,  6728,  6738,  6739,  6740,  6741,  6742,  6743,
    6744,  6745,  6746,  6747,  6748,  6749,  6750,  6751,  6752,  6753,
    6754,  6755,  6756,  6757,  6758,  6759,  6760,  6761,  6762,  6763,
    6764,  6765,  6766,  6767,  6768,  6769,  6770,  6771,  6772,  6773,
    6774,  6775,  6776,  6777,  6778,  6779,  6780,  6781,  6782,  6783,
    6784,  6785,  6786,  6787,  6788,  6789,  6790,  6791,  6792,  6793,
    6794,  6795,  6796,  6797,  6798,  6799,  6800,  6804,  6805,  6809,
    6810,  6811,  6812,  6813,  6817,  6817,  6820,  6826,  6827,  6830,
    6832,  6837,  6847,  6854,  6855,  6856,  6859,  6891,  6892,  6895,
    6897,  6905,  6906,  6907,  6911,  6912,  6916,  6917,  6920,  6921,
    6924,  6925,  6926,  6927,  6928,  6931,  6932,  6933,  6934,  6935,
    6936,  6937,  6938,  6939,  6940,  6941,  6942,  6943,  6944,  6945,
    6946,  6947,  6948,  6949,  6950,  6951,  6952,  6953,  6954,  6955,
    6956,  6957,  6958,  6959,  6960,  6961,  6962,  6963,  6964,  6965,
    6966,  6967,  6968,  6969,  6970,  6971,  6972,  6973,  6974,  6975,
    6976,  6977,  6978,  6979,  6980,  6981,  6982,  6983,  6984,  6985,
    6986,  6987
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONTINUE", "SQL_COUNT", "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GO", "SQL_GOTO", 
  "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", "SQL_LENGTH", 
  "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN", 
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", 
  "ACCESS", "ACTION", "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", 
  "ALSO", "ALTER", "ALWAYS", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", 
  "AS", "ASC", "ASSERTION", "ASSIGNMENT", "ASYMMETRIC", "AT", 
  "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", 
  "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", 
  "CASCADE", "CASCADED", "CASE", "CAST", "CHAIN", "CHAR_P", "CHARACTER", 
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", 
  "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", "COMMITTED", 
  "CONCURRENTLY", "CONFIGURATION", "CONNECTION", "CONSTRAINT", 
  "CONSTRAINTS", "CONTENT_P", "CONVERSION_P", "COPY", "COST", "CREATE", 
  "CREATEDB", "CREATEROLE", "CREATEUSER", "CROSS", "CSV", "CURRENT_P", 
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", 
  "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", "DAY_P", "DEALLOCATE", 
  "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", 
  "DEFERRED", "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", 
  "DICTIONARY", "DISABLE_P", "DISCARD", "DISTINCT", "DO", "DOCUMENT_P", 
  "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", 
  "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE", "EXCEPT", "EXCLUSIVE", 
  "EXCLUDING", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", 
  "FALSE_P", "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", 
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GET", 
  "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", 
  "HAVING", "HEADER_P", "HOLD", "HOUR_P", "IF_P", "ILIKE", "IMMEDIATE", 
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", 
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INNER_P", "INOUT", 
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER", 
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", 
  "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LEADING", "LEAST", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", 
  "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", 
  "MAPPING", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", 
  "MONTH_P", "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", 
  "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", "NOTHING", 
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL", "PASSWORD", "PLACING", 
  "PLANS", "POSITION", "PRECISION", "PRESERVE", "PREPARE", "PREPARED", 
  "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", 
  "READ", "REAL", "REASSIGN", "RECHECK", "REFERENCES", "REINDEX", 
  "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", 
  "RESET", "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", 
  "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", 
  "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "STABLE", 
  "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", 
  "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SUPERUSER_P", 
  "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", 
  "TEMPLATE", "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNCOMMITTED", "UNENCRYPTED", "UNION", 
  "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", 
  "VACUUM", "VALID", "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", 
  "VARYING", "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE", 
  "WHITESPACE_P", "WITH", "WITHOUT", "WORK", "WRITE", "XML_P", 
  "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLFOREST", "XMLPARSE", 
  "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", "YES_P", "ZONE", 
  "NULLS_FIRST", "NULLS_LAST", "WITH_CASCADED", "WITH_LOCAL", 
  "WITH_CHECK", "IDENT", "SCONST", "Op", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "BCONST", "XCONST", "DOLCONST", "ECONST", "NCONST", 
  "ICONST", "PARAM", "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", 
  "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", 
  "'.'", "';'", "'{'", "'}'", "\"=\"", "','", "':'", "$accept", "prog", 
  "statements", "statement", "at", "stmt", "CreateRoleStmt", "opt_with", 
  "OptRoleList", "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", 
  "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", 
  "CreateGroupStmt", "AlterGroupStmt", "add_drop", "DropGroupStmt", 
  "CreateSchemaStmt", "OptSchemaName", "OptSchemaEltList", "schema_stmt", 
  "VariableSetStmt", "set_rest", "var_name", "var_list", "iso_level", 
  "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "SetResetClause", "ConstraintsSetStmt", "constraints_set_list", 
  "constraints_set_mode", "CheckPointStmt", "DiscardStmt", 
  "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_rel_cmds", "alter_rel_cmd", "alter_column_default", 
  "opt_drop_behavior", "alter_using", "ClosePortalStmt", "CopyStmt", 
  "copy_from", "copy_file_name", "copy_opt_list", "copy_opt_item", 
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", 
  "OptTemp", "OptTableElementList", "TableElementList", "TableElement", 
  "columnDef", "ColQualList", "ColConstraint", "ColConstraintElem", 
  "ConstraintAttr", "TableLikeClause", "TableLikeOptionList", 
  "TableLikeOption", "TableConstraint", "ConstraintElem", 
  "opt_column_list", "columnList", "columnElem", "key_match", 
  "key_actions", "key_delete", "key_update", "key_action", "OptInherit", 
  "OptWith", "OnCommitOption", "OptTableSpace", "OptConsTableSpace", 
  "CreateAsStmt", "@1", "create_as_target", "OptCreateAs", "CreateAsList", 
  "CreateAsElement", "CreateSeqStmt", "AlterSeqStmt", "OptSeqList", 
  "OptSeqElem", "opt_by", "CreatePLangStmt", "opt_trusted", 
  "handler_name", "opt_validator", "opt_lancompiler", "DropPLangStmt", 
  "opt_procedural", "CreateTableSpaceStmt", "OptTableSpaceOwner", 
  "DropTableSpaceStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "enum_val_list", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_opfamily", 
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt", 
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt", 
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt", 
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt", 
  "FetchStmt", "fetch_direction", "fetch_count", "from_in", "CommentStmt", 
  "comment_type", "comment_text", "GrantStmt", "RevokeStmt", "privileges", 
  "privilege_list", "privilege", "privilege_target", "grantee_list", 
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt", 
  "opt_grant_admin_option", "opt_granted_by", "IndexStmt", 
  "index_opt_unique", "access_method_clause", "index_params", 
  "index_elem", "opt_class", "opt_asc_desc", "opt_nulls_order", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "opt_definition", "AlterFunctionStmt", 
  "alterfunc_opt_list", "opt_restrict", "RemoveFuncStmt", 
  "RemoveAggrStmt", "RemoveOperStmt", "oper_argtypes", "any_operator", 
  "CreateCastStmt", "cast_context", "DropCastStmt", "opt_if_exists", 
  "ReindexStmt", "reindex_type", "opt_force", "RenameStmt", "opt_column", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "PrepareStmt", "PreparableStmt", 
  "prep_type_clause", "ExecuteStmt", "execute_param_clause", 
  "DeallocateStmt", "InsertStmt", "insert_rest", "insert_column_list", 
  "insert_column_item", "returning_clause", "DeleteStmt", "using_clause", 
  "LockStmt", "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "set_clause_list", "set_clause", "single_set_clause", 
  "multiple_set_clause", "set_target", "set_target_list", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_opt_alias", "func_table", 
  "where_clause", "where_or_current_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "opt_type_modifiers", 
  "Numeric", "opt_float", "Bit", "ConstBit", "BitWithLength", 
  "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", 
  "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "row", "sub_type", 
  "all_Op", "MathOp", "qual_Op", "qual_all_Op", "subquery_Op", 
  "expr_list", "extract_list", "type_list", "array_expr_list", 
  "array_expr", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "indirection_el", 
  "indirection", "opt_indirection", "opt_asymmetric", "ctext_expr", 
  "ctext_expr_list", "ctext_row", "target_list", "target_el", 
  "relation_name", "qualified_name_list", "qualified_name", "name_list", 
  "name", "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "Fconst", "Bconst", 
  "Xconst", "Sconst", "PosIntConst", "IntConst", "IntConstVar", 
  "AllConstVar", "StringConst", "PosIntStringConst", "NumConst", 
  "AllConst", "PosAllConst", "RoleId", "SpecialRuleRelation", 
  "ECPGConnect", "connection_target", "opt_database_name", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", 
  "ECPGExecuteImmediateStmt", "ECPGVarDeclaration", 
  "single_vt_declaration", "precision", "opt_scale", "ecpg_interval", 
  "ECPGDeclaration", "@3", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@4", "var_declaration", "@5", "@6", 
  "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@7", "struct_union_type", "@8", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execute_rest", 
  "execstring", "prepared_name", "ECPGFree", "ECPGOpen", "opt_ecpg_using", 
  "ecpg_using", "using_descriptor", "into_descriptor", "opt_sql", 
  "ecpg_into", "using_list", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", "@9", 
  "opt_reference", "ECPGVar", "@10", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ECPGColId", "ColId", "type_function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "ECPGunreserved_con", "col_name_keyword", "type_func_name_keyword", 
  "reserved_keyword", "into_list", "ecpgstart", "c_args", 
  "coutputvariable", "civarind", "civar", "indicator", "cvariable", 
  "ident", "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", 
  "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,    61,    60,    62,   721,
      43,    45,    42,    47,    37,    94,   722,    91,    93,    40,
      41,    46,    59,   123,   125,   723,    44,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   488,   489,   490,   490,   491,   491,   491,   491,   491,
     491,   491,   491,   492,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   494,   495,   495,   496,   496,   496,
     496,   496,   496,   496,   496,   496,   496,   496,   496,   496,
     496,   496,   496,   496,   496,   496,   496,   496,   496,   497,
     498,   499,   500,   501,   502,   502,   503,   503,   504,   505,
     506,   506,   507,   507,   508,   508,   509,   509,   510,   510,
     511,   511,   511,   511,   511,   511,   512,   512,   512,   513,
     513,   513,   513,   513,   513,   513,   513,   513,   513,   513,
     513,   513,   514,   514,   515,   515,   516,   516,   516,   516,
     517,   517,   517,   518,   518,   518,   518,   519,   519,   519,
     519,   519,   519,   520,   520,   520,   521,   521,   522,   522,
     522,   522,   522,   523,   523,   523,   523,   523,   524,   524,
     525,   526,   526,   527,   527,   528,   529,   529,   529,   529,
     530,   530,   531,   531,   532,   532,   532,   532,   532,   532,
     532,   532,   532,   532,   532,   532,   532,   532,   532,   532,
     532,   532,   532,   532,   532,   532,   532,   532,   532,   532,
     532,   532,   533,   533,   534,   534,   534,   534,   535,   535,
     536,   536,   536,   537,   537,   538,   538,   539,   539,   540,
     540,   541,   541,   541,   542,   542,   543,   543,   543,   543,
     543,   543,   543,   543,   543,   543,   544,   544,   545,   545,
     546,   546,   547,   547,   548,   548,   549,   549,   549,   549,
     549,   549,   549,   550,   550,   551,   551,   552,   552,   552,
     553,   554,   554,   555,   555,   555,   556,   556,   556,   556,
     556,   556,   556,   557,   557,   557,   557,   558,   559,   559,
     560,   560,   560,   560,   560,   560,   561,   561,   562,   562,
     562,   562,   563,   563,   564,   564,   565,   566,   566,   566,
     567,   567,   567,   567,   567,   568,   569,   570,   570,   570,
     570,   570,   571,   571,   572,   572,   572,   572,   573,   573,
     573,   573,   574,   574,   575,   575,   577,   576,   578,   579,
     579,   580,   580,   581,   582,   583,   584,   584,   585,   585,
     585,   585,   585,   585,   585,   585,   585,   585,   585,   586,
     586,   587,   587,   588,   588,   589,   589,   590,   590,   591,
     591,   592,   592,   593,   593,   594,   595,   595,   596,   596,
     597,   597,   598,   598,   599,   599,   599,   600,   600,   600,
     601,   601,   602,   602,   603,   603,   604,   604,   604,   605,
     605,   606,   606,   607,   607,   607,   607,   607,   608,   608,
     609,   609,   610,   610,   611,   612,   613,   613,   613,   613,
     613,   613,   613,   613,   613,   613,   613,   614,   615,   615,
     616,   616,   617,   617,   617,   617,   618,   618,   619,   620,
     620,   621,   622,   622,   623,   624,   624,   625,   625,   625,
     625,   625,   626,   626,   627,   627,   628,   628,   629,   630,
     630,   631,   631,   632,   632,   633,   633,   634,   634,   635,
     636,   637,   637,   638,   638,   638,   638,   638,   638,   638,
     638,   638,   638,   638,   638,   639,   639,   640,   640,   641,
     641,   642,   643,   643,   643,   643,   643,   643,   643,   643,
     643,   643,   644,   644,   644,   644,   644,   644,   644,   644,
     644,   644,   644,   644,   644,   644,   645,   646,   646,   647,
     647,   647,   647,   647,   647,   647,   647,   647,   647,   647,
     647,   647,   647,   647,   647,   648,   648,   648,   648,   648,
     648,   648,   648,   648,   648,   648,   648,   649,   649,   650,
     651,   651,   652,   652,   652,   653,   653,   654,   654,   654,
     654,   655,   655,   655,   655,   655,   655,   655,   655,   656,
     656,   657,   657,   658,   658,   659,   659,   660,   661,   662,
     663,   663,   664,   664,   665,   665,   666,   666,   667,   667,
     668,   668,   669,   669,   669,   670,   670,   670,   671,   671,
     671,   672,   672,   672,   673,   673,   674,   674,   675,   675,
     676,   676,   677,   677,   677,   677,   677,   678,   678,   678,
     678,   679,   679,   680,   681,   682,   682,   682,   683,   683,
     684,   684,   684,   684,   684,   684,   684,   684,   684,   684,
     684,   684,   684,   685,   685,   685,   686,   686,   687,   688,
     688,   689,   689,   690,   690,   691,   691,   692,   692,   693,
     693,   693,   693,   694,   694,   695,   695,   696,   696,   697,
     698,   698,   699,   699,   699,   700,   700,   701,   701,   702,
     702,   702,   702,   702,   702,   702,   702,   702,   702,   702,
     702,   702,   702,   702,   702,   702,   702,   702,   702,   702,
     703,   703,   704,   704,   704,   704,   704,   704,   705,   705,
     705,   705,   705,   705,   705,   705,   705,   705,   705,   705,
     705,   705,   707,   706,   708,   708,   708,   709,   709,   710,
     710,   710,   710,   710,   711,   711,   712,   712,   712,   712,
     713,   713,   713,   714,   714,   715,   716,   717,   717,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   719,   719,   719,   720,   720,   720,   721,
     721,   721,   722,   722,   723,   723,   724,   724,   724,   724,
     725,   726,   726,   727,   727,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   729,   729,   730,   731,
     732,   732,   733,   734,   734,   735,   736,   736,   736,   736,
     736,   737,   737,   738,   739,   739,   739,   739,   739,   739,
     740,   741,   741,   741,   742,   742,   743,   743,   743,   744,
     744,   745,   745,   746,   746,   747,   747,   748,   748,   749,
     749,   750,   751,   751,   751,   751,   751,   751,   752,   752,
     753,   753,   754,   754,   754,   754,   755,   755,   756,   756,
     757,   757,   758,   758,   758,   758,   759,   760,   760,   760,
     761,   761,   762,   763,   763,   764,   765,   765,   766,   767,
     767,   768,   768,   768,   768,   768,   768,   768,   768,   769,
     769,   770,   771,   771,   772,   772,   773,   774,   775,   776,
     776,   777,   778,   778,   778,   778,   778,   779,   779,   779,
     780,   780,   781,   781,   782,   782,   782,   782,   783,   783,
     784,   784,   784,   784,   784,   785,   785,   785,   786,   786,
     786,   786,   786,   786,   786,   786,   787,   787,   788,   788,
     789,   789,   789,   789,   790,   790,   791,   792,   792,   793,
     793,   794,   794,   794,   794,   794,   795,   795,   796,   796,
     797,   798,   798,   799,   799,   800,   800,   801,   801,   802,
     802,   803,   803,   804,   804,   805,   805,   806,   806,   807,
     807,   808,   808,   808,   808,   808,   808,   808,   808,   808,
     808,   808,   809,   809,   809,   809,   809,   809,   810,   810,
     810,   810,   811,   811,   811,   811,   812,   812,   813,   813,
     814,   814,   814,   814,   815,   815,   815,   816,   817,   817,
     818,   818,   818,   818,   819,   819,   820,   821,   821,   821,
     821,   822,   822,   822,   823,   823,   823,   823,   823,   823,
     823,   823,   823,   824,   824,   824,   824,   824,   824,   824,
     825,   825,   825,   825,   826,   826,   827,   827,   828,   828,
     828,   828,   828,   828,   828,   828,   828,   828,   828,   829,
     829,   830,   830,   831,   831,   832,   833,   834,   834,   835,
     835,   836,   837,   838,   838,   838,   838,   838,   838,   839,
     839,   840,   840,   841,   841,   841,   841,   842,   843,   843,
     843,   844,   844,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   844,   844,   844,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   846,   846,   846,   846,   846,   846,   846,
     846,   846,   846,   846,   846,   846,   846,   846,   846,   846,
     846,   846,   846,   846,   847,   847,   847,   847,   847,   847,
     847,   847,   847,   847,   847,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   849,   849,   850,
     850,   850,   850,   851,   852,   852,   853,   853,   854,   854,
     855,   855,   855,   856,   856,   856,   857,   857,   857,   858,
     858,   859,   859,   859,   859,   859,   859,   859,   859,   859,
     860,   860,   861,   861,   862,   862,   862,   862,   862,   862,
     863,   863,   864,   864,   865,   865,   866,   866,   867,   867,
     868,   868,   868,   868,   868,   868,   868,   868,   869,   869,
     870,   871,   871,   872,   872,   872,   872,   872,   872,   873,
     874,   875,   875,   875,   876,   876,   877,   878,   878,   879,
     880,   880,   881,   881,   882,   882,   883,   883,   883,   883,
     884,   884,   885,   885,   886,   886,   887,   887,   888,   888,
     889,   890,   890,   891,   891,   891,   892,   892,   893,   893,
     894,   894,   895,   895,   896,   897,   898,   899,   900,   901,
     902,   902,   903,   903,   903,   903,   903,   903,   903,   903,
     904,   905,   906,   907,   908,   908,   908,   908,   909,   909,
     910,   910,   911,   911,   912,   912,   912,   912,   912,   913,
     913,   914,   914,   914,   915,   915,   915,   915,   915,   916,
     916,   917,   917,   917,   917,   917,   917,   917,   917,   918,
     919,   919,   920,   920,   920,   920,   921,   921,   921,   921,
     922,   922,   923,   924,   925,   925,   926,   926,   926,   927,
     927,   928,   928,   929,   929,   930,   930,   930,   930,   931,
     931,   932,   933,   933,   934,   935,   936,   937,   937,   938,
     939,   939,   940,   940,   940,   940,   940,   942,   941,   943,
     944,   945,   945,   945,   946,   946,   946,   946,   946,   947,
     947,   949,   948,   951,   950,   952,   950,   950,   953,   953,
     954,   954,   954,   955,   955,   955,   955,   956,   956,   957,
     957,   957,   957,   957,   957,   958,   958,   958,   959,   961,
     960,   962,   963,   962,   964,   964,   965,   965,   966,   966,
     967,   967,   967,   967,   967,   967,   967,   967,   967,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   969,
     969,   970,   970,   971,   972,   972,   973,   973,   973,   974,
     975,   976,   976,   976,   976,   977,   977,   977,   978,   978,
     978,   978,   978,   979,   979,   980,   980,   981,   981,   982,
     983,   983,   984,   984,   985,   986,   987,   987,   988,   988,
     989,   989,   990,   990,   991,   991,   991,   992,   992,   993,
     994,   995,   996,   996,   997,   998,   999,   999,  1000,  1001,
    1002,  1003,  1003,  1004,  1005,  1006,  1006,  1007,  1008,  1008,
    1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,
    1008,  1008,  1008,  1009,  1009,  1010,  1010,  1011,  1011,  1011,
    1013,  1012,  1014,  1014,  1016,  1015,  1017,  1017,  1017,  1018,
    1018,  1018,  1018,  1018,  1018,  1018,  1018,  1018,  1019,  1019,
    1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,
    1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,
    1020,  1020,  1020,  1020,  1020,  1021,  1021,  1021,  1021,  1021,
    1021,  1022,  1022,  1022,  1022,  1022,  1022,  1022,  1023,  1024,
    1024,  1024,  1024,  1024,  1024,  1024,  1024,  1025,  1025,  1025,
    1025,  1025,  1025,  1025,  1026,  1026,  1026,  1026,  1026,  1026,
    1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,  1028,
    1028,  1028,  1028,  1029,  1029,  1029,  1029,  1030,  1030,  1030,
    1030,  1030,  1030,  1030,  1031,  1031,  1032,  1032,  1032,  1032,
    1032,  1032,  1033,  1033,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1038,  1038,  1039,  1040,  1040,  1041,
    1041,  1042,  1043,  1044,  1044,  1044,  1045,  1046,  1046,  1047,
    1047,  1048,  1048,  1048,  1049,  1049,  1050,  1050,  1051,  1051,
    1052,  1052,  1052,  1052,  1052,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     1,     0,     2,     2,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     2,     2,     2,     2,     3,     3,     5,
       5,     4,     5,     4,     3,     5,     3,     5,     5,     6,
       1,     1,     3,     5,     6,     4,     1,     0,     2,     0,
       1,     1,     1,     1,     1,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     5,     2,     2,     3,
       3,     3,     1,     3,     1,     3,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       6,     1,     1,     1,     1,     0,     1,     1,     3,     4,
       5,     4,     2,     2,     3,     4,     3,     2,     2,     1,
       4,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       4,     4,     1,     3,     3,     4,     6,     6,     6,     6,
       4,     6,     2,     4,     3,     3,     3,     3,     4,     4,
       3,     3,     3,     3,     3,     3,     4,     4,     3,     2,
       3,     1,     1,     3,     3,     3,     2,     2,     3,     2,
       1,     1,     0,     2,     0,     2,     2,     9,     6,     1,
       1,     1,     1,     1,     2,     0,     1,     1,     3,     3,
       1,     1,     3,     3,     3,     4,     1,     0,     2,     0,
       3,     0,     1,     0,    11,    12,     1,     1,     2,     2,
       2,     2,     0,     1,     0,     1,     3,     1,     1,     1,
       3,     2,     0,     3,     1,     1,     2,     1,     3,     4,
       4,     2,     5,     1,     2,     2,     2,     3,     2,     0,
       2,     2,     2,     2,     2,     2,     3,     1,     4,     6,
       7,    11,     3,     0,     3,     1,     1,     2,     2,     0,
       1,     1,     2,     2,     0,     3,     3,     2,     1,     1,
       2,     2,     4,     0,     2,     2,     2,     0,     3,     4,
       4,     0,     2,     0,     4,     0,     0,     7,     5,     3,
       0,     3,     1,     1,     5,     4,     2,     0,     2,     1,
       2,     3,     2,     2,     2,     2,     3,     3,     3,     1,
       0,     5,     9,     1,     0,     1,     2,     2,     0,     2,
       0,     5,     7,     1,     0,     6,     2,     0,     3,     5,
      14,    19,     1,     1,     1,     3,     5,     1,     1,     1,
       3,     0,     1,     0,     1,     1,     1,     3,     0,     1,
       1,     0,     2,     1,     2,     1,     2,     0,     2,     1,
       2,     2,     6,     8,     8,     3,     5,     4,     4,     4,
       3,     7,     8,     6,     6,     6,     6,     3,     1,     3,
       3,     1,     1,     1,     1,     1,     3,     3,     3,     1,
       3,     3,     1,     3,    13,     1,     3,     4,     7,     4,
       7,     2,     1,     0,     2,     0,     1,     0,     6,     8,
       8,     1,     3,     5,     5,     7,     9,     7,     9,     5,
       6,     6,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     3,     3,     1,     3,     1,     2,     2,
       3,     4,     5,     4,     4,     3,     4,     3,     3,     2,
       4,     2,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     2,     2,     1,     2,     2,     1,     1,     1,     6,
       7,     7,     9,     8,     8,     6,     9,     9,     7,    10,
       7,     8,     8,     8,     8,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     7,
       7,    10,     2,     1,     1,     1,     3,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     2,     2,     1,
       3,     1,     2,     3,     0,     1,     3,     2,     6,     6,
       3,     0,     3,     0,    13,    14,     1,     0,     2,     0,
       1,     3,     4,     4,     6,     1,     2,     0,     1,     1,
       0,     1,     1,     0,     9,     7,     2,     0,     3,     2,
       1,     3,     3,     3,     2,     2,     1,     1,     1,     1,
       2,     1,     3,     1,     1,     1,     4,     5,     1,     2,
       4,     5,     1,     1,     1,     1,     3,     3,     2,     2,
       2,     2,     1,     2,     2,     1,     2,     0,     5,     1,
       2,     1,     0,     5,     7,     5,     7,     7,     9,     1,
       3,     3,     3,     1,     3,    11,    10,     2,     0,     9,
       2,     0,     4,     4,     4,     1,     1,     1,     0,     7,
       6,     6,     6,     6,     7,     9,     9,     6,     6,     6,
       6,     6,     8,     8,     6,     6,     8,     8,     8,     8,
       1,     0,     7,     6,     6,     6,     6,     6,     7,     6,
       6,     6,     6,     7,     9,     9,     9,     6,     6,     6,
       8,     8,     0,    14,     1,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     0,     6,     8,     2,     2,     2,     2,     2,
       3,     3,     2,     2,     2,     2,     3,     2,     5,     4,
       3,     3,     3,     1,     1,     0,     3,     2,     2,     1,
       3,     2,     1,     0,     8,    10,     2,     3,     3,     0,
       2,     5,     3,     1,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     4,     3,     3,     1,     0,     5,     4,
       2,     0,     4,     3,     5,     6,     4,     6,     6,     5,
       7,     1,     0,     6,    11,    11,    11,    13,     9,    11,
      10,     3,     1,     4,     2,     0,     4,     5,     5,     2,
       4,     1,     1,     1,     0,     1,     0,     1,     0,     3,
       0,     4,     1,     1,     1,     1,     1,     1,     1,     0,
       5,     4,     1,     1,     1,     1,     3,     0,     4,     8,
       3,     0,     2,     3,     2,     3,     5,     1,     4,     2,
       3,     1,     2,     2,     0,     6,     2,     0,     5,     3,
       0,     2,     2,     2,     3,     1,     3,     1,     2,     1,
       0,     7,     1,     3,     1,     1,     3,     5,     2,     1,
       3,     7,     0,     2,     2,     2,     3,     0,     2,     2,
       1,     1,     3,     3,     1,     2,     4,     4,     1,     1,
       8,     1,     4,     4,     4,     2,     1,     0,     3,     3,
       4,     4,     4,     4,     2,     1,     1,     0,     1,     0,
       1,     5,     1,     0,     1,     0,     3,     1,     3,     4,
       3,     4,     4,     2,     2,     4,     1,     0,     1,     1,
       1,     3,     0,     2,     0,     1,     3,     1,     0,     1,
       2,     4,     4,     2,     0,     2,     3,     2,     0,     3,
       1,     1,     2,     1,     2,     5,     6,     5,     1,     2,
       1,     4,     3,     4,     5,     4,     5,     4,     5,     2,
       4,     1,     2,     2,     2,     1,     1,     0,     4,     2,
       1,     2,     2,     4,     1,     2,     3,     1,     2,     0,
       2,     4,     4,     0,     1,     3,     2,     2,     3,     5,
       6,     3,     4,     0,     1,     3,     3,     3,     3,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     5,
       1,     1,     1,     1,     2,     3,     3,     0,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     1,     3,
       0,     1,     1,     1,     1,     5,     2,     1,     1,     1,
       1,     5,     2,     2,     2,     1,     3,     3,     2,     1,
       0,     3,     0,     5,     2,     5,     2,     1,     3,     3,
       0,     1,     1,     1,     1,     1,     1,     3,     3,     3,
       3,     3,     3,     3,     0,     1,     3,     5,     2,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     3,     3,     2,     3,     5,     4,     6,     3,
       5,     4,     6,     4,     6,     5,     7,     2,     3,     2,
       4,     3,     3,     4,     3,     4,     3,     4,     5,     6,
       6,     7,     6,     7,     6,     7,     3,     4,     4,     6,
       2,     3,     4,     1,     3,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     5,     6,
       6,     7,     3,     4,     1,     1,     2,     4,     1,     1,
       1,     2,     2,     2,     1,     3,     4,     5,     5,     4,
       1,     1,     4,     1,     4,     1,     4,     1,     4,     1,
       1,     1,     1,     6,     4,     4,     4,     4,     6,     5,
       5,     5,     4,     6,     4,     4,     4,     4,     5,     7,
       7,     9,     4,     6,     5,     7,     7,     2,     3,     3,
       3,     4,     0,     4,     1,     3,     3,     1,     1,     1,
       2,     2,     0,     4,     3,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     4,     1,     4,     1,     2,     1,     2,
       1,     3,     3,     0,     1,     3,     1,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     3,
       2,     3,     0,     3,     3,     2,     2,     1,     0,     2,
       2,     3,     2,     1,     1,     3,     5,     2,     1,     4,
       2,     0,     1,     0,     1,     2,     2,     2,     3,     5,
       1,     2,     0,     2,     1,     0,     1,     1,     1,     3,
       3,     3,     1,     3,     1,     1,     1,     1,     1,     3,
       1,     2,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     2,     3,     6,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     5,     1,     1,
       1,     1,     5,     3,     2,     2,     3,     7,     1,     1,
       1,     0,     2,     2,     1,     0,     1,     3,     1,     2,
       0,     2,     0,     2,     0,     1,     3,     4,     3,     1,
       1,     1,     2,     0,     7,     3,     1,     1,     1,     1,
       2,     0,     1,     3,     3,     3,     3,     0,     4,     5,
       5,     0,     1,     1,     1,     1,     2,     2,     2,     1,
       2,     0,     7,     0,     5,     0,     4,     2,     2,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     5,     2,     1,     3,     2,     2,     3,     0,
       5,     1,     0,     5,     2,     2,     1,     1,     1,     2,
       2,     3,     1,     2,     2,     3,     3,     4,     2,     1,
       2,     1,     1,     2,     2,     3,     1,     1,     1,     1,
       0,     1,     3,     5,     0,     2,     0,     1,     2,     3,
       2,     1,     1,     1,     0,     1,     1,     1,     2,     2,
       1,     1,     0,     1,     1,     1,     1,     2,     2,     3,
       0,     1,     2,     1,     4,     4,     0,     1,     2,     1,
       1,     3,     1,     1,     4,     4,     4,     1,     0,     3,
       3,     4,     1,     3,     3,     4,     1,     3,     3,     1,
       6,     1,     3,     3,     6,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     4,     1,     1,     4,     4,     3,
       0,     7,     1,     0,     0,     7,     3,     4,     3,     1,
       1,     1,     2,     3,     5,     2,     5,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     0,     1,     2,
       1,     2,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     2,     3,     1,     2,     1,     3,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  2220,  2224,  2228,  2229,  2156,  2230,
    2231,  2196,  2197,  2198,  2199,  2200,  2201,  2202,  2203,  2204,
    2205,  2206,  2207,  2209,  2208,  2210,  2211,  2212,  2213,  2214,
    2215,  2216,  2217,  2219,  2218,  2233,  2221,  2234,  2222,  2223,
    2225,  2226,  2195,  2227,  2235,  2236,  2237,  2232,  2185,  1444,
    2186,    10,  1447,  1445,  1446,  1440,  1441,  2240,  2191,  2192,
    2190,  2193,  2194,  2238,  2239,  2181,  2182,  2184,    11,    12,
    2183,  2241,     4,  2187,  2188,  2189,     8,  1527,  1600,     9,
    2180,  1600,     0,  1710,  1711,  1712,     0,  1713,  1714,  1715,
    1716,  1717,  1648,  1614,  1718,     0,  1719,  1720,  1721,  1722,
    1723,  1724,  1725,  1726,     0,  1727,  1728,  1729,  1730,  1599,
    1731,  1732,  1733,  1734,  1576,  1582,  1694,     0,  1556,  1557,
    1553,  1555,  1554,  1558,  1541,   825,   434,   892,   891,     0,
    2064,   825,  2065,  2023,  2066,  2024,  2025,   235,     0,   882,
    2026,     0,   825,   307,   322,  2067,  1491,     0,  2027,  2028,
       0,     0,     0,   434,   825,     0,     0,  2029,   909,  2030,
       0,  2031,  2068,  2069,     0,     0,  2032,  2070,  2071,  2033,
       0,  2034,  2035,  2072,  2073,  2074,  2036,  2075,  2076,     0,
       0,   997,     0,  2037,  2077,  2038,  2039,     0,  2078,  2040,
    2041,  2042,  2079,  2080,  2043,  2044,  2045,     0,  2046,     0,
       0,     0,     0,     0,  2081,   825,  2047,     0,  1003,     0,
    2048,     0,  2082,  2049,     0,  2050,  2051,  2052,  2053,  2054,
     997,  1690,  1577,     0,     0,   896,     0,  2055,  2083,  2056,
    2057,  2058,  2059,  2060,  2061,  2062,  2063,  2167,  2168,     0,
       0,     0,    47,    53,    24,    23,    27,    28,    67,    72,
      42,    18,    62,    48,   101,   102,   103,    34,    30,    59,
      22,    31,    35,    50,    36,    49,    21,    43,    66,    51,
      70,    52,    71,    37,    60,    57,    44,    45,    46,    63,
      64,    65,    86,    69,    97,    76,    33,    77,    92,    78,
      93,    79,    41,    17,    90,    88,    89,    38,    61,    87,
      91,    19,    20,    94,    68,    84,    81,    98,    96,   104,
      82,    54,    14,    15,    73,    40,    16,    26,    25,    39,
      32,   100,    29,   894,    74,    85,    75,    55,    80,    58,
      83,    99,    56,    95,   971,   970,  1005,   974,   981,   106,
     107,   112,     7,  1516,  1517,  1518,  1600,  1551,  1552,  1545,
    1561,  1571,  1560,  1564,  1572,  1559,  1578,     0,   109,   111,
     113,   116,   110,   105,   108,   115,   120,   114,   119,   117,
     118,   121,   122,   123,  1782,  1174,  1780,  1781,  1779,  1533,
       0,  1600,  1535,  1534,     0,  1735,  1736,  1737,  1738,  1739,
    1740,  1787,  1788,  1789,  1790,  1791,  1793,  1792,  1804,  1805,
    1806,  1807,  1808,  1809,  1810,  1811,  1812,  1813,  1814,  1815,
    1816,  1817,  1818,  1819,  1820,  1821,  1822,  1823,  1824,  1825,
    1762,  1826,  1827,  1828,  1829,  1830,  1831,  1832,  1833,  1834,
    1835,  1803,  1836,  1837,  1838,  1839,  1840,  1841,  1842,  1843,
    1844,  1845,  1846,  1847,  1796,  1848,  1849,  1850,  1851,  1852,
    1853,  1854,  1855,  1856,  1857,  1858,  1859,  1860,  1861,  1862,
    1863,  1864,  1865,  1866,  1868,  1867,  1869,  1870,  1871,  1872,
    1873,  1874,  1875,  1876,  1877,  1878,  1879,  1880,  1881,  1882,
    1797,  1883,  1884,  1885,  1886,  1887,  1888,  1889,  1890,  1891,
    1892,  1893,  1894,  1895,  1896,  1897,  1898,  1899,  1900,  1901,
    1902,  1903,  1904,  1905,  1906,  1907,  1908,  1909,  1910,  1911,
    1798,  1912,  1913,  1799,  1914,  1915,  1916,  1917,  1918,  1919,
    1920,  1921,  1922,  1923,  1924,  1925,  1926,  1927,  1928,  1929,
    1930,  1931,  1932,  1933,  1934,  1935,  1936,  1937,  1938,  1939,
    1942,  1940,  1941,  1943,  1944,  1945,  1946,  1947,  1948,  1949,
    1950,  1951,  1952,  1953,  1954,  1955,  1956,  1957,  1958,  1959,
    1960,  1961,  1962,  1963,  1964,  1965,  1966,  1967,  1968,  1969,
    1970,  1800,  1971,  1972,  1973,  1974,  1975,  1976,  1977,  1978,
    1979,  1980,  1981,  1982,  1983,  1984,  1985,  1986,  1987,  1988,
    1990,  1989,  1991,  1992,  1993,  1994,  1995,  1491,  1996,  1997,
    1998,  1999,  2000,  2001,  2002,  2003,  2004,  2005,  2006,  2007,
    2008,  2009,  2010,  1763,  2011,  2012,  2013,  2014,  2015,  2016,
    2017,  2018,  2019,  2020,  1801,  2021,  2022,  2166,  1459,  1510,
    1509,  1484,  1505,  1760,  1708,  1709,  1479,  1761,  1758,  1794,
    1795,  1802,  1759,  1460,  2162,  1757,  1647,     0,     0,  1613,
    1612,  1616,  1615,  1617,  1610,  1611,  1425,  1511,  1628,  1627,
    1424,  1630,  1741,  1742,  1743,  1744,  1746,  1745,  1747,  2084,
    2085,  2086,  2087,  2088,  2089,  2090,  2091,  2092,  2093,  2094,
    2095,  1772,  2096,  2097,  2098,  2099,  2100,  2101,  2102,  2105,
    2103,  2104,  2106,  2107,  2108,  2109,  2110,  2111,  2112,  2113,
    2114,  2115,  2116,  2117,  2118,  2119,  2120,  2121,  2122,  2123,
    1773,  1774,  2124,  2125,  2126,  2127,  2128,  2129,  2130,  2131,
    2132,  2133,  2134,  2135,  2136,  2137,  2138,  2139,  2140,  2141,
    2142,  2143,  2144,  2145,  2146,  1776,  2147,  2148,  1775,  2149,
    2150,  2151,  2152,  2153,  1786,  1771,  1574,  1748,  1783,  1770,
    1777,  1778,  1785,  1784,  1584,  1580,  1588,  1583,     0,     0,
       0,     0,  1600,   824,   823,   809,     0,     0,     0,     0,
       0,     0,     0,     0,   433,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    13,     0,   833,   286,
     285,  1481,  1480,  1420,   885,  1416,  1417,   434,     0,   812,
     306,     0,     0,     0,     0,     0,     0,     0,   512,     0,
       0,     0,     0,     0,     0,     0,   167,     0,   317,   316,
       0,     0,   423,     0,   646,     0,     0,   434,     0,     0,
       0,  1490,  1489,  1485,  1495,     0,  1488,  1757,     0,   924,
    1940,  1625,  1626,   922,  1981,   962,     0,   236,   239,   237,
     238,     0,     0,   731,   539,     0,   538,     0,     0,   536,
       0,     0,     0,     0,   540,   534,   533,     0,     0,     0,
     537,     0,   535,     0,     0,   813,     0,  1566,  1567,  1884,
     921,   908,   894,  1805,   569,   573,   564,   570,   578,   577,
     565,   562,   563,  1952,     0,     0,   568,     0,   559,  1448,
    1450,   576,  1449,     0,   613,   619,   618,   617,     0,   614,
     615,   620,     0,   806,   840,  1429,   996,     0,     0,   561,
     805,  1996,   917,     0,     0,   735,     0,   736,     0,  1967,
     817,   227,  1755,  1973,  2051,  1996,  1756,   223,  1753,   192,
    1754,  1750,  1751,  1752,  1749,     0,     0,   614,     0,   814,
     815,  1002,  1000,     0,     0,     0,     0,  1836,  1905,   215,
    1963,  1973,  2051,  1996,  2020,   176,     0,   222,  1973,  2051,
    1996,     0,   833,     0,     0,  1575,   808,   807,     0,  1074,
       0,  1070,   895,   898,     0,  1035,   979,     0,   825,     0,
       6,   893,   889,   999,   999,     0,   999,     0,   975,     0,
    1543,  1571,  1550,  1606,  1547,     0,     0,  1596,  1592,  1589,
    1597,  1598,  1591,  1579,  1163,  1164,  1165,  1162,  1166,  1161,
       0,  1522,  1563,  1528,     0,  1538,  1537,  1536,  2169,  2170,
    1649,  1483,  1502,     0,     0,     0,     0,     0,  1636,  1629,
    1631,  1633,  1586,  1585,  1581,     0,     0,  1699,     0,     0,
    1700,  1701,     0,  1696,  1698,     0,  1606,     0,     0,  1760,
    1768,  1430,  1761,  1758,  1766,  1757,     0,   547,   126,     0,
       0,   547,     0,     0,     0,     0,  1828,  1872,  1329,  1339,
    1337,  1338,  1331,  1332,  1333,  1336,  1334,  1335,     0,   723,
    1330,     0,   126,     0,     0,   407,     0,     0,     0,     0,
       0,   126,     0,     0,     0,     0,     0,   829,   832,   810,
       0,     0,  1400,  1421,     0,     0,   881,     0,     0,   595,
     604,   596,   601,     0,   598,     0,     0,   606,     0,   597,
     599,   600,   605,     0,     0,   602,   603,     0,     0,   821,
     309,     0,     0,     0,     0,     0,   842,   872,   321,   320,
     126,   319,   318,     0,     0,     0,   666,   126,     0,   169,
     437,     0,     0,   480,   126,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1494,  1500,     0,  1492,  1650,   925,
     923,  1609,     0,   937,  1883,     0,   475,     0,     0,  1883,
     863,  1883,     0,  1883,   162,  1422,     0,     0,     0,     0,
       0,  1883,   154,  1883,     0,  1883,   438,     0,  1883,     0,
    1883,   156,     0,  1883,   282,   545,     0,     0,  2174,  2178,
       0,  2176,  2171,  1565,  1624,  1623,  1515,     0,  1622,     0,
     566,   575,   574,   572,   571,   567,  1451,     0,   557,   558,
    1636,  1639,   555,     0,   612,     0,     0,     0,     0,   940,
    1418,     0,   820,     0,     0,     0,     0,   738,   738,   738,
     816,   226,   224,     0,     0,     0,     0,     0,   822,     0,
       0,     0,  2023,  2024,  1128,  1393,     0,  1762,  2025,  2026,
    1270,  1279,  1271,  1273,  1280,  2027,  2028,  1860,  2029,  2030,
    1437,  2031,  2032,  1118,  2034,  2035,  2036,  1275,  1277,  2037,
    2038,     0,  1438,  2040,  2041,  1932,  2043,  2044,  2046,  2047,
    1281,  2049,  2050,  2051,  2052,  2053,  2054,  1436,     0,  1282,
    2055,  2057,  2058,  2059,  2060,  2061,  2062,  1340,  1442,  1443,
    1402,     0,     0,  1415,     0,  1260,     0,  1110,  1111,  1133,
    1134,  1112,  1139,  1140,  1152,  1113,     0,  1414,  1175,  1259,
    1264,     0,  1258,  1254,   987,  1412,  1394,     0,  1255,  1473,
    1472,  1474,  1475,  1471,  1432,  1439,  1478,  2162,     0,     0,
       0,     0,     0,  1689,   231,     0,   232,  1973,   177,   214,
     187,   213,   188,   217,   216,     0,  1826,   178,     0,   185,
       0,     0,     0,     0,     0,     0,     0,   218,   811,   282,
       0,     0,  1072,     0,  1075,     0,  1071,   897,   894,  1407,
    1406,  1408,     0,   973,   972,     5,   900,   998,     0,     0,
       0,     0,     0,     0,     0,  1028,  1017,  1025,  1029,  1036,
    1606,  1607,     0,  1601,     0,  1600,  1600,  1594,  1593,  1590,
       0,     0,     0,     0,     0,     0,  1465,  1464,  1519,  1521,
    1468,     0,     0,  1504,     0,  1508,  1506,  1636,  1644,  1636,
    1645,  1646,  1637,  1469,  1470,  1642,     0,  1632,  1640,  1643,
    1587,  1600,  1707,     0,  1702,  1705,     0,  1697,     0,  1431,
       0,     0,     0,     0,     0,   548,     0,     0,     0,   125,
     861,   229,   859,     0,     0,     0,   866,     0,     0,     0,
       0,   693,     0,     0,     0,     0,     0,     0,   694,   692,
     695,   702,   709,   712,     0,   637,   160,   161,     0,     0,
       0,     0,     0,     0,   241,   272,     0,     0,     0,     0,
       0,   151,     0,     0,     0,     0,   405,   761,   761,     0,
       0,   761,     0,     0,     0,   761,     0,   240,   242,   271,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   153,     0,     0,  1529,     0,   827,   828,     0,   831,
       0,  1397,  1396,  1427,  1401,   883,   884,  1428,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   292,   293,   126,   291,     0,     0,   477,     0,
    1121,  1150,  1150,  1150,  1117,  1117,  1130,  1119,  1157,     0,
    1150,  1117,  1122,     0,  1120,  1160,  1160,  1145,     0,  1093,
    1103,  1105,  1106,  1131,  1132,  1107,  1137,  1138,  1104,  1174,
    1767,  1117,  1769,  1765,  1764,     0,     0,   871,     0,     0,
     513,     0,     0,   478,     0,     0,     0,   165,     0,     0,
       0,     0,     0,     0,   443,   442,     0,     0,   479,     0,
     407,     0,   400,   363,     0,     0,  1834,     0,     0,     0,
    1498,  1493,  1496,     0,  1486,  1500,   963,   967,   964,     0,
     965,     0,  1083,     0,   282,   730,     0,     0,     0,   282,
       0,     0,  1883,     0,  1883,     0,     0,     0,   282,     0,
       0,     0,     0,   544,   542,   541,   543,     0,     0,     0,
       0,   282,     0,   280,   281,     0,   532,  2172,     0,     0,
    2175,  1568,     0,  1350,     0,   918,  1620,  1621,   322,     0,
       0,   901,   907,   903,   905,   904,   906,   902,   556,   553,
     554,     0,  1638,  2154,  2160,     0,  1651,  1652,     0,  1847,
    1877,  1899,  1968,  1971,     0,  1991,     0,   621,   641,   616,
       0,     0,   934,   927,     0,     0,   950,   560,   911,  1354,
       0,     0,     0,   737,   734,   733,   732,   225,   193,     0,
       0,   643,  1967,   819,     0,     0,  1262,  1263,  1149,  1136,
    1392,     0,     0,  1144,  1143,     0,     0,     0,     0,  1126,
    1125,  1124,  1261,  1353,     0,  1123,     0,     0,     0,     0,
    1150,  1150,  1148,  1194,     0,  1127,     0,     0,  1372,     0,
    1378,     0,     0,     0,  1156,     0,  1154,     0,     0,  1230,
       0,     0,     0,     0,     0,     0,  1256,  1178,  1179,  1763,
    1260,  1350,     0,  1433,     0,     0,  1142,     0,  1174,     0,
       0,     0,     0,  1405,  1348,     0,     0,  1207,  1346,     0,
    1209,     0,     0,     0,  1340,  1339,  1337,  1338,  1331,  1332,
    1333,  1336,  1334,  1335,  1344,  1191,     0,     0,  1190,  1636,
       0,  1038,   986,  1395,     0,  1476,     0,  2161,  2163,  1686,
    1685,  1684,  1683,  1659,     0,  1655,  1656,     0,  1687,  1688,
     233,   234,   230,     0,   190,   189,     0,   211,   212,   184,
       0,   207,   208,  1319,  1318,   191,   183,   181,   204,   206,
     205,   203,   179,   194,   200,   201,   202,   182,   180,   221,
     219,     0,   551,  1600,     0,  1076,     0,  1038,   952,   954,
     955,     0,  1402,   886,  1410,     0,     0,   890,   979,   984,
     978,   983,  1006,  1007,   660,   982,     0,  1034,  1034,  1019,
    1013,  1018,  1014,  1020,  1027,   977,  1016,   976,     0,  1030,
       0,  1608,  1546,  1606,  1093,  1600,  1539,  1600,  1595,  1525,
    1168,  1169,  1170,  1171,  1173,  1172,  1526,  1523,  1167,  1524,
    1467,  1466,     0,     0,     0,  1501,     0,  1482,  1507,     0,
       0,  1093,  2157,  1703,  2157,  1093,     0,     0,     0,     0,
       0,     0,     0,   549,     0,     0,     0,   228,   858,     0,
       0,     0,     0,     0,   869,   357,     0,   279,     0,     0,
       0,     0,     0,     0,   700,     0,     0,     0,     0,   701,
     698,   699,  1968,   711,   710,   708,   677,   679,   678,     0,
     669,     0,   670,     0,     0,   676,   685,   683,     0,     0,
       0,     0,   277,     0,   276,     0,     0,     0,     0,     0,
     719,   724,     0,     0,   135,   137,     0,     0,   133,   139,
     136,   138,   134,   140,   132,     0,     0,   131,     0,     0,
       0,     0,   150,     0,     0,     0,     0,     0,   409,   420,
       0,     0,     0,     0,   126,   126,   406,   760,   252,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     269,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,     0,   199,   826,   830,  1398,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   308,   290,   289,     0,   295,     0,
     499,  1764,   476,     0,  1093,     0,     0,     0,  1087,  1163,
    1162,  1161,     0,  1108,  1117,  1114,     0,     0,   857,   857,
     857,   857,   857,   841,   843,   332,   158,     0,     0,     0,
     488,   491,     0,   124,   169,   322,     0,   168,   170,   172,
     173,   174,   171,   175,   436,     0,     0,     0,     0,     0,
     448,   447,   449,     0,   444,     0,     0,   149,   404,   396,
       0,   324,   387,     0,     0,   421,     0,     0,     0,     0,
     782,     0,  1499,     0,     0,     0,     0,   966,     0,  1048,
     936,  1040,  1050,  1041,  1043,  1077,  1420,     0,     0,   934,
       0,   715,     0,   864,     0,   713,   163,  1423,     0,     0,
       0,     0,     0,     0,   529,   155,     0,   282,   439,     0,
     282,   157,     0,   431,   282,   546,  2173,  2179,  2177,   920,
       0,  1618,  1619,     0,   962,   552,     0,     0,  2159,  1452,
       0,  1453,     0,     0,   625,   624,   635,   626,   627,   623,
     622,   628,     0,     0,   643,   929,     0,   931,  1402,     0,
     926,     0,   947,     0,   945,     0,  1419,   949,   938,   916,
       0,   910,   913,   915,   914,   912,     0,     0,   614,     0,
       0,   282,   818,     0,     0,     0,  1356,     0,     0,  1391,
    1388,     0,     0,     0,     0,     0,  1363,  1364,  1365,  1362,
    1366,  1361,     0,     0,  1367,  1360,     0,     0,     0,     0,
       0,  1147,  1146,     0,     0,     0,     0,     0,     0,  1233,
    1264,     0,     0,  1324,     0,  1350,  1377,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1350,  1383,     0,
       0,     0,  1317,     0,  1314,     0,     0,     0,  1403,  1402,
       0,     0,     0,     0,  1434,  1176,  1192,  1413,     0,  1404,
       0,     0,  1199,     0,  1384,  1226,     0,  1231,  1214,     0,
    1208,     0,  1212,  1216,  1195,  1405,  1349,     0,  1347,     0,
       0,  1193,     0,  1188,  1186,  1187,  1180,  1181,  1182,  1183,
    1184,  1185,  1189,  1328,  1326,  1327,     0,     0,     0,  1211,
    1878,  1905,     0,   997,   997,   985,   995,  1411,     0,  1079,
       0,     0,     0,  1265,     0,  2165,  2164,     0,     0,     0,
       0,     0,  1174,     0,   220,  1093,  1073,   959,     0,     0,
    1083,     0,   958,   888,   887,  1409,     0,     0,   658,   659,
       0,   663,  1026,     0,   950,   950,     0,     0,     0,  1544,
    1602,  1549,  1570,  1540,  1573,  1520,  1562,     0,  1503,  1634,
    1641,  1693,     0,  2158,     0,     0,   497,   496,     0,     0,
       0,   769,   740,   550,   770,   741,     0,   860,     0,     0,
       0,     0,     0,   282,   867,   278,   868,   763,   771,     0,
     696,   697,   772,   742,     0,   764,   680,  1117,   668,     0,
       0,   675,     0,   674,  1117,  1117,   743,   159,   274,   751,
     275,   273,     0,  1426,     0,     0,     0,     0,   145,     0,
       0,     0,     0,   128,   127,   146,   144,     0,   143,     0,
     777,   747,   749,   765,   408,   419,     0,   412,   413,   410,
     414,   415,     0,     0,     0,   244,     0,     0,   255,   268,
     263,   264,   262,   282,   282,     0,     0,     0,     0,   265,
     260,   261,   257,   270,   748,     0,   766,   256,   254,     0,
     243,   779,   755,     0,     0,     0,     0,     0,     0,     0,
     873,     0,     0,     0,   778,   767,   754,   750,     0,     0,
     197,   196,   198,     0,     0,     0,     0,     0,     0,     0,
       0,   608,   585,   607,     0,     0,     0,     0,     0,     0,
       0,   579,   311,   288,   498,     0,     0,     0,     0,  1088,
       0,     0,  1093,     0,     0,  1101,  1094,  1102,     0,     0,
       0,  1115,     0,   857,   856,     0,     0,     0,     0,     0,
     844,   865,     0,   518,   487,     0,     0,   363,   164,     0,
       0,   435,   486,   484,   483,   485,     0,     0,     0,     0,
    1084,     0,     0,     0,     0,     0,     0,   323,   325,   327,
     328,   329,     0,   402,   403,     0,     0,   391,     0,   365,
     366,     0,     0,     0,     0,   649,     0,     0,     0,   707,
     705,   688,     0,  1497,  1491,   968,   969,     0,   979,     0,
    1050,     0,  1049,  1061,     0,     0,  1067,  1065,     0,  1067,
       0,  1067,     0,  1042,     0,  1044,  1061,  1421,     0,     0,
    1080,   935,   282,     0,   282,     0,   282,     0,   282,     0,
     282,     0,   803,     0,   472,   282,   531,  1351,     0,     0,
    1635,  2155,  1660,  1661,     0,  1653,  1654,     0,     0,   634,
     629,   631,     0,   638,     0,     0,   932,   933,   948,   941,
     943,   942,     0,     0,   939,  1355,   530,     0,   282,     0,
     639,  1001,  1358,  1359,     0,     0,     0,     0,  1387,     0,
       0,  1294,  1272,  1274,  1116,  1284,     0,  1129,  1295,  1296,
    1276,  1278,     0,  1341,     0,     0,  1285,  1235,     0,     0,
       0,     0,  1340,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1247,  1246,  1286,  1323,     0,     0,  1375,  1376,
    1287,  1158,  1159,  1160,  1160,     0,     0,  1382,     0,     0,
       0,  1292,  1297,     0,     0,  1302,     0,  1322,     0,     0,
    1257,  1351,  1151,  1152,     0,     0,     0,     0,     0,     0,
       0,     0,  1232,  1215,  1210,     0,  1213,  1217,     0,     0,
       0,     0,  1201,  1227,  1197,     0,     0,  1203,     0,  1228,
     997,   997,   997,   997,   994,     0,     0,  1037,     0,  1022,
       0,     0,  1269,  1266,  1668,  1669,  1670,  1671,  1672,  1673,
    1674,  1676,  1677,  1679,  1680,  1681,  1675,  1678,  1682,  1664,
    1665,     0,  1657,  1658,   186,     0,   209,   195,  1693,     0,
       0,   953,   934,   956,   899,  1008,     0,  1342,   663,   661,
     662,  1010,  1033,  1032,  1031,  1011,  1015,  1012,     0,  1604,
    1530,  1692,  1695,  1706,  1704,  1542,   768,   739,   762,   857,
       0,   356,     0,     0,     0,   870,   690,     0,  1117,   671,
     672,   673,     0,     0,     0,     0,     0,     0,     0,   721,
       0,   722,   720,   141,   129,   148,   147,   130,   142,   411,
     416,   418,   417,   332,     0,     0,     0,   245,   253,   250,
     266,   258,   267,   259,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   773,   744,  1399,   580,     0,
     581,   588,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   590,   312,   126,     0,   296,   300,   872,   872,     0,
     301,   872,   297,   872,   294,   500,     0,  1932,  1332,   501,
     492,   494,   495,   493,   467,     0,     0,     0,  1091,     0,
       0,     0,     0,     0,     0,  1093,  1174,     0,     0,   852,
    1461,  1462,   851,  1463,   848,   847,   855,   854,   846,   845,
     850,   849,     0,     0,     0,   343,     0,     0,   337,     0,
       0,   707,   331,   334,   335,     0,   489,   490,     0,   322,
       0,   451,   445,     0,   502,   481,     0,  1086,   921,   397,
     324,   349,   383,     0,   399,     0,   385,   384,   386,     0,
     393,   362,     0,   839,   428,   425,     0,   649,     0,     0,
     703,   681,   704,     0,   684,     0,   689,   665,     0,  1513,
     961,  1514,  1052,  1059,     0,  1039,     0,  1066,  1062,     0,
    1063,     0,     0,  1064,     0,     0,  1059,     0,     0,     0,
     716,     0,   714,     0,   525,     0,   527,     0,   717,   282,
     282,   432,     0,   400,   967,     0,     0,   636,   632,     0,
       0,   609,   640,   928,   930,   946,   944,     0,   610,   642,
    1357,  1135,     0,  1390,  1386,     0,  1352,     0,  1370,  1369,
    1234,  1371,     0,  1252,     0,     0,  1245,  1244,  1242,  1243,
    1236,  1237,  1238,  1239,  1240,  1241,  1380,  1379,  1373,  1374,
    1155,  1153,     0,  1289,  1290,  1291,  1381,  1298,     0,  1316,
    1315,     0,     0,     0,  1304,     0,     0,  1312,  1325,  1141,
    1174,  1177,     0,     0,  1200,  1385,  1218,     0,     0,     0,
    1196,     0,     0,     0,     0,  1205,  1341,     0,     0,     0,
       0,     0,     0,   989,   988,  1078,     0,  1024,  1267,  1268,
    1477,     0,     0,     0,  1691,     0,   960,   951,     0,  1009,
    1548,     0,  1603,     0,   358,     0,     0,   707,   691,     0,
     686,     0,     0,     0,     0,     0,   519,   505,     0,     0,
     520,   521,     0,     0,     0,   330,     0,     0,     0,     0,
     284,   752,     0,     0,     0,     0,     0,   781,   759,   780,
     757,   756,   758,   753,     0,     0,     0,     0,   584,   594,
     592,   591,   593,   583,   295,     0,     0,     0,     0,     0,
       0,     0,   469,     0,     0,   474,   463,   465,     0,     0,
       0,  1089,  1095,  1096,  1097,  1098,  1099,  1100,  1092,  1109,
     461,   853,     0,     0,   341,   345,   346,   344,   336,   707,
     363,   395,     0,     0,     0,   453,     0,     0,   482,     0,
    1085,   919,     0,   347,     0,   387,   326,   401,   403,     0,
       0,   398,   364,     0,     0,     0,   834,     0,   430,   426,
       0,     0,   648,     0,     0,   707,   706,   798,   799,   796,
     797,     0,     0,  1487,  1051,     0,     0,  1053,     0,     0,
    1055,  1057,     0,     0,     0,     0,     0,  1424,  1266,  1082,
    1081,   282,   282,   282,   282,   804,   473,     0,     0,     0,
    1662,  1663,     0,   630,     0,  1389,  1283,  1293,  1368,     0,
       0,  1253,     0,     0,  1288,  2056,     0,     0,  1320,  1321,
    1303,     0,  1918,  1307,     0,     0,  1435,  1224,  1222,  1219,
       0,  1220,     0,     0,  1202,  1198,     0,  1204,  1229,   993,
     992,   991,   990,     0,     0,   980,  1666,     0,  1454,  1458,
    1455,  1667,  1174,   957,     0,  1605,   862,     0,   707,   395,
     687,   775,   745,     0,     0,   511,     0,     0,     0,     0,
     776,   746,   774,   246,   247,   248,   249,     0,   251,     0,
       0,     0,   878,     0,     0,   586,   587,   582,   287,   310,
     298,   303,     0,   304,   299,   302,   471,   470,   468,   464,
     466,  1090,     0,   728,     0,   467,     0,     0,   333,   395,
     369,     0,   338,     0,   839,   324,   452,     0,     0,   446,
     503,   387,     0,     0,   348,     0,   391,     0,   388,     0,
     392,     0,     0,   836,   427,     0,   422,     0,     0,     0,
       0,   650,   657,   657,   682,   664,     0,  1512,     0,  1060,
    1069,     0,  1056,  1054,  1045,     0,  1047,   729,   526,   528,
     718,     0,   633,   282,  1248,     0,     0,     0,     0,  1299,
       0,  1300,  1305,  1308,     0,  1306,  1221,  1225,  1223,  1206,
    1021,  1023,  1457,  1456,   210,  1343,     0,   395,   359,     0,
       0,   517,   506,     0,     0,   522,   283,     0,     0,     0,
       0,     0,   589,   305,   728,     0,   726,   462,     0,   340,
     339,     0,   374,     0,   515,   835,   454,   455,   450,     0,
     391,   353,   351,   355,   352,   350,   354,     0,   393,   389,
     390,   837,   838,   429,   880,     0,     0,   707,     0,     0,
     655,   660,   660,  1079,  1058,     0,  1046,   611,  1249,     0,
    1250,     0,     0,  1310,  1309,   363,   360,     0,   509,   516,
       0,   507,     0,     0,   874,     0,   875,   876,   879,   725,
     727,     0,   367,   368,     0,   342,   370,   371,     0,     0,
       0,     0,   393,   382,   314,   707,   657,   393,   651,   656,
     663,   663,     0,  1068,  1251,  1313,  1301,  1311,   369,     0,
       0,   524,   523,     0,     0,     0,     0,     0,   372,     0,
     373,   394,   514,     0,   458,   315,   393,   660,  1079,   653,
     652,   802,   374,     0,   517,   877,     0,   379,     0,   378,
       0,   375,   376,   504,     0,   456,     0,   459,   460,  1079,
     663,   644,   801,   800,     0,   467,   510,   508,     0,   377,
     380,   381,   440,     0,     0,   645,   654,   784,   795,   783,
     785,   793,   790,   792,   791,   789,   361,     0,   457,     0,
       0,   794,   788,   979,   970,     0,     0,   786,   795,   458,
     787,     0,   441
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    72,   240,   241,   242,  1490,  2092,   243,
     244,   245,   246,   247,   248,   249,   250,   251,  1519,   252,
     253,  1158,  1647,  2207,   254,  2017,   966,  1922,  2144,  1923,
    1924,  1909,  1380,  1382,   255,  1491,  1511,   257,  1375,  1902,
     258,   259,   260,  1547,  1548,  1524,  1549,  1496,  1716,  3558,
     261,   262,  2167,  1594,  2673,  3084,   801,  1591,  3073,  3074,
     263,  1644,  2726,  2727,  2728,  2729,  2701,  3132,  3133,  3134,
    2730,  3423,  3604,  2731,  2025,  2234,  2738,  2739,  3692,  3755,
    3756,  3757,  3811,  3425,  2737,  3160,  3431,  3592,   264,  2723,
    1661,  2232,  2732,  2733,   265,   266,  1536,  2106,  2596,   267,
     827,  3164,  3438,  3616,   268,   785,   269,  1649,   270,   271,
    1656,  2223,  2224,  3416,  3597,  3698,  3814,  3815,  3585,  3385,
    3386,  3387,   272,   273,   274,   275,  2064,  2199,  2200,  3089,
    1481,  1598,  2169,  2170,  3143,   276,  3336,  3337,   828,  3760,
    3741,   277,   278,  3340,  3341,   279,   280,   281,   282,   283,
     874,  1214,  1215,  1485,   284,   285,   895,   896,   897,   286,
    1138,  2662,   287,   288,   908,  2338,   910,  1756,  2809,  2810,
    3221,  2305,  1072,   289,   290,  2314,  2341,   291,   829,  3169,
    3620,  3621,  3721,  2501,  2981,   292,   830,  1515,  2051,  2052,
    2053,  3170,  2054,  3173,  2055,  2749,  2750,  2751,  3177,   293,
    1513,  2045,   294,   295,   296,  2069,  1088,   297,  3686,   298,
    1188,   299,   928,  1774,   300,  2109,   301,   302,   303,  2752,
    3839,  3850,  3851,  3852,  3451,  3824,   304,  3841,   306,   307,
     308,   788,  1107,  1108,  1109,   309,  3436,   310,   311,  2193,
    2194,  2695,   312,   313,  2018,  2537,   314,   315,   316,  1638,
     317,   318,   319,   320,  1116,   321,   322,   323,   992,   983,
    1408,  1947,   324,  1731,   882,   325,  2331,  1255,   326,  1228,
     327,  3842,  1762,  2316,  2317,  2320,  3843,  1682,   330,  1766,
    2325,  2328,  3844,  1937,  1938,  1939,  1940,  1941,  2488,   332,
    1182,  2246,  3845,  1335,   335,   336,   337,  1881,  2465,   917,
    1418,   953,   997,   998,  1952,  1953,  1425,  1967,  1960,  1962,
    3307,  3525,  1426,  1965,  1427,  1428,  2504,   338,  2469,  2250,
    2251,  2252,  2762,  2772,  3188,  3460,  2253,   980,  2254,  2939,
    2259,  2719,  2720,  2056,  2178,  2684,  1619,  1336,  1620,  2185,
    1337,  1805,  1622,  1338,  1339,  1340,  1625,  1341,  1342,  1343,
    1344,  1789,  1846,  1345,  1346,  1824,  1021,  1723,  2378,  1348,
    1349,  3277,  3505,  3496,  2403,  2404,  1915,  3273,  1350,  2456,
    1874,  1090,  1351,  3091,  1876,  2398,  2362,  2007,  2345,  1787,
    2363,  2376,  2855,  2382,  2387,  2878,  2879,  2399,  2425,  1352,
    2349,  2350,  2839,  1791,  1353,  1112,  1113,  1836,  2421,  1411,
    1412,   985,  1354,  1355,  1356,  1757,   981,  3456,  1195,   652,
    2572,  1572,  1576,   914,  1357,  1358,  1359,  1360,  1361,  1362,
    1363,   900,   901,  2300,  3531,  2663,  3112,  1464,  1925,  1364,
     630,   795,   339,   833,   834,   835,  1174,  1175,  1671,  1674,
    1453,  1997,   631,   632,   842,  3453,   340,   341,   342,   343,
    1449,  1993,  1022,    76,    81,    77,  1023,   380,   381,  1975,
     344,   762,  1976,  1430,  1003,  2989,   346,   347,   348,   349,
     350,   877,   351,  1005,   352,  1006,   353,   354,   355,   356,
    1013,   357,  1432,  1433,  3322,  1434,   358,   359,   654,   655,
    1725,  1226,   880,   360,   361,  1039,  1040,  1041,  1241,  1741,
    1242,  1467,  1468,   362,   648,   363,   364,   365,  1746,  1747,
     366,  1895,  1896,  1897,   367,  2802,  2803,   368,  2959,  2960,
    2961,   369,  1891,   370,   371,   974,  2992,   372,   758,   373,
    1053,   633,   634,   635,  1060,   746,   939,   796,  1061,   747,
     748,   749,   637,   638,   639,   640,   641,   642,  1064,   753,
    1742,    78,  2522,  1743,  1365,  1366,  1887,  1367,   645,  1030,
    1218,  1219,  2523,  1221,    79,  1222
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3469
static const int yypact[] =
{
   -3469,   307, 15044, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, 18559, -3469,
   -3469, 42218,   305, -3469, -3469, -3469, 39489, -3469, -3469, -3469,
   -3469, -3469,   176, 47170, -3469, 57507, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, 61548, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, 43121,   613, -3469,   316, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469,   800,  5138, -3469, -3469, 49420,
   -3469,    41, -3469, -3469, -3469, -3469, -3469, -3469, 57956, 55711,
   -3469,   144,   561,    88,  9559, -3469, 40860, 48520, -3469, -3469,
   61997,   417,    76,  9449,   800, 17201, 50320, -3469,  1542, -3469,
   37187, -3469, -3469, -3469,   334, 53017, -3469, -3469, -3469, -3469,
     385, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, 61548,
    1054,   591, 37653, -3469, -3469, -3469, -3469, 61548, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, 50770, -3469,   677,
     683, 62446, 62895, 52568, -3469,   578, -3469, 61548,   647, 41769,
   -3469, 63344, -3469, -3469,   625, -3469, -3469, -3469, -3469, -3469,
     591, -3469, 43121, 35336, 53915,   909,   643, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,   -88,
    8493,   725, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469,   852, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469,  1799, -3469,   444,  2187,   873, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, 71875,  1432, -3469, -3469,
   -3469,   880, -3469,   898, -3469, -3469, -3469,  1330, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469,   701, -3469, -3469, -3469, -3469,
    1382, 42669, -3469, -3469, 51220, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, 39946, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469,   108, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, 61548, 61548, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469,  1026, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469,   563,  1169, -3469, -3469, 43121,  1708,
    1708,  1433, 71875, -3469, -3469, -3469, 43571, 61548, 61548, 61548,
   43571, 61548, 53915, 33489, -3469, 61548, 61548, 53915, 53915, 61548,
    1126, 61548, 61548, 61548, 53915,  1239, -3469,  1464,    49, -3469,
   -3469, -3469, -3469,  1190,   396, -3469, -3469,  8880,  1054, -3469,
   -3469, 55711,  1121, 43571, 61548,  1064,  1153, 61548, -3469, 61548,
     831, 61548,  1225,  1168,  1229, 61548, 61548, 61548, -3469, -3469,
    1236, 61548, -3469, 61548, -3469, 61548,   946,  1255,  1465,  1431,
      60, -3469, -3469, -3469,  1217,  1188, -3469,  1223, 51220, -3469,
   49870, -3469, -3469, -3469,   268, -3469, 53915, -3469, -3469, -3469,
   -3469, 44021, 61548,  1474, -3469, 63793, -3469, 44471, 64242, -3469,
     879,  1594, 64691, 65140, -3469, -3469, -3469, 65589,  1358, 66038,
   -3469, 66487, -3469,  1507, 66936, -3469, 15598, -3469,  1288,  1337,
    1243, -3469,   852,  1112, -3469,   166,   -61,   180, -3469, -3469,
      14,    98,   100,  1112,  1139, 56160, -3469, 61548,  1518, -3469,
   -3469, -3469, -3469, 51220,  1492, -3469, -3469, -3469,  1498,  -110,
   -3469, -3469, 55711, -3469, -3469, -3469, -3469, 55711,   516, -3469,
   -3469,  1054,   -42,  1719, 61548, -3469, 61548, -3469, 55711, 61548,
   -3469, -3469, -3469,  1736,  1406,  1612, -3469,  1384, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469,  1565,  1595,    21,  1054,  1527,
   -3469, -3469,  1613, 21372,   762, 51220, 38580, 54364, 70528,   435,
   40860, 67385,  1481,    49,  1638, -3469,   143, -3469,  1849,  1524,
    1730,   104,    49, 55711, 72324, -3469, -3469, -3469, 30759, 67834,
    1620,  1504, -3469,  1788, 21847, -3469,  1519,  1531,   800,  1522,
   -3469, -3469, 55711,  1943,  1943,  1933,  1943,   768,   925,   643,
   -3469, -3469, -3469,  1591, -3469,  1573,  1624, -3469,   678,  1843,
   -3469, -3469, -3469, -3469,  1724,  1738,  1745,  1759, -3469,  1784,
    1111, -3469, -3469, -3469,  1932, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469,  2061,  2057, 40860, 40860,  1768,    38,   208, -3469,
   -3469, -3469,  1957, -3469, -3469,  1955, 61548, -3469,  1807, 61548,
   -3469, -3469, 68283, -3469, -3469,  1708,  1591,  1190,  1740,  1273,
   -3469, -3469,  1308,  1376, -3469,  2132,    15,  1747,  1332,   124,
    1934,   -59,  1950,  1791,   167,  1232, 61548, 61548, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,  1803, -3469,
   -3469,  1796,   875,   602,   739,   -36,  2015,   894,   479,  1984,
     901,  1163,  1949, 61548,  1808,  2037,   521, -3469,   365, -3469,
   24697, 34430, -3469,  1190, 55711, 61548, -3469, 43571,  1824, -3469,
   -3469, -3469, -3469, 43571, -3469,  2003,  1658, -3469, 61548, -3469,
   -3469, -3469, -3469,  1960, 61548, -3469, -3469,  2078, 61548, -3469,
    1876,  1470,  1828,  2211, 47621, 61548,  1899,  2243, -3469, -3469,
    1944, -3469, -3469, 61548, 61548,  1902,   855,  1944,  2282,  2286,
    2079,   548,  1214,    52,  1944, 55711, 55711, 55711,  2149, 61548,
   68732, 43571, 61548, 41317, -3469,  1916,  1217, -3469, -3469, -3469,
   -3469, -3469,   760,  1993,  2226,  1740, -3469,  2228,  1938,  2231,
   -3469,  2233,  1791,  2238,  1940, -3469, 69181, 69630,  2241,  1952,
   61548,  2249,  1940,  2250,  2129,  2252, -3469,   572,  2257,  2145,
    2267,  1940,   740,  2268,    54, -3469, 16172, 15598, -3469, 16718,
    1386, -3469, -3469, -3469, -3469, -3469, -3469, 24697,   421,   770,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, 61548,  1518,  1518,
      95, -3469, -3469,   829, -3469, 54813, 61548, 55262,     4,   -11,
   -3469, 61548, -3469,  1337, 47621,  2368, 61548,  2271,  2271,  2271,
   -3469, -3469, -3469,  2217, 61548,  2274, 54813, 61548, -3469, 70079,
    1994,  1405,  1754,  1600, -3469, 24697,  1995,   645,   645,  1996,
   -3469, -3469,  1999,  2004, -3469,  1557,  1557,  2153,  2007,  2012,
   -3469,  1661,  2016, -3469,  2060,  1726,  2026,  2029,  2034,  1688,
     645, 24697, -3469,  2038,  1557,  2039,  2045,  2048,  2227,  2053,
   -3469,  2296,  2054,  1769,  2100,  2062,  2069, -3469,  2007, -3469,
      50,  2070,  2077,  2084,  2090,  2091,  2092, -3469, -3469, -3469,
   -3469, 24697, 24697, -3469, 22322, -3469,  1054, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469,    40, -3469,  2005,  7581, -3469, -3469,
    2185, 24697, -3469, -3469,    91, -3469,  1190,  2144, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469,   109,  1393,  1393,
     123, 49420, 49420, -3469, -3469,  1155,  2030,  1385, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, 40403,  2438, -3469,  2800,   365,
     956,  2393, 35789, 36255,  1518,  1518,  2305, -3469, -3469,    55,
    2336, 55711, -3469, 61548, -3469, 32110, -3469, -3469,   852, -3469,
    9136, -3469,   249, -3469, -3469, -3469,  2098, -3469,   -88,   -88,
   24697,   -88,   897, 22797, 24697,  2385,    35,  2386, -3469, -3469,
    1591,  2111,  1260, -3469, 51670, 71426, 71426,  2354, -3469, -3469,
     579,   752,  2232,  2321,   711,  1442, -3469, -3469, -3469,  2113,
   -3469,  2442, 49420,  2186, 40860, -3469, -3469,  2569, -3469,  2569,
   -3469, -3469, -3469, -3469, -3469, -3469,  2593, -3469,  2124, -3469,
   -3469, 71875,  2137, 61548, -3469,  2139,  2151, -3469, 72324,  1190,
   34883,  1253,  2246,  2247, 43121,  2143,  2248,  2254, 70528, -3469,
   -3469, -3469, -3469,   955,   719,    73, -3469,  2261,  2344,  1111,
    2290, -3469,  2264,  2265,  2362,  1111,   774, 70977, -3469, -3469,
   -3469, -3469, -3469,  1548, 19971, -3469, -3469, -3469,  2266,  2251,
    2275,  2277,  1902,   693,  2177, -3469,  2255,  2260, 45371, 33959,
    4132, -3469,  2280,  2281,  2287,  2310,  2212,    86,  2562,  2394,
     698,  1447,   149, 55711,  2473,   102,   730,  2213, -3469, -3469,
    2307,  2312, 61548, 61548, 61548, 61548, 53915,  2313,  2347,  2315,
    4132, -3469,  2317,  1073, -3469,  1078, -3469, -3469,    49, -3469,
    3673, -3469, -3469, -3469, -3469, -3469, -3469, -3469,  1740, 47621,
    1791,  1111, 61548, 61548,  2235,   723,   576,  2405, 61548,  2475,
    2418,    33, -3469, -3469,  1944, -3469, 34883,  1902, -3469,  2239,
   -3469,  2297,  2297,  2297,  2242,  2242,  2244, -3469, -3469,  1688,
    2297,  2242, -3469, 48971, -3469,   878,  1004, -3469,  2632,    56,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,   726,
   -3469,  1570, -3469, -3469, -3469,  2647,   874, -3469, 47621,  4132,
    2570,  2316, 43121, -3469,  2324,  4132, 61548,   958, 61548,  2470,
   61548, 61548, 61548, 61548, -3469, -3469,    10,    -8, -3469,  4132,
   -3469,  2650,   -76,  2258, 40860,  2550, 61548,  2449,  1791,  2662,
   -3469, -3469,  2272,  1139, -3469,  1916, -3469,  1456, -3469,  2408,
   -3469, 28007,  2337, 43571,    99, -3469, 47621, 61548, 43571,    99,
   61548, 61548,  2577,  2351,  2580,  2356, 33959, 45371,    65, 61548,
   61548, 55711, 61548, -3469, -3469, -3469, -3469, 61548, 55711, 61548,
    2585,    99, 61548, -3469, -3469, 61548, -3469, -3469, 16259,  1471,
   -3469, -3469, 15598,  9136,  1032, -3469,  1518,  1026,   608, 61548,
   51220, -3469, -3469, -3469, -3469, -3469, -3469, -3469,  1518, -3469,
   -3469,  2757,  2291, -3469,   109,  1139,  2292, -3469,  2318, 61548,
   43571, 61548, 61548, 55711, 55711, 61548,  2380,  2030,   265, -3469,
    2359, 31661,  2439, -3469,    94, 55711,  2492, -3469, -3469, -3469,
    1076,   979,   442, -3469, -3469, -3469, -3469, -3469, -3469, 53017,
    2584,     0, 61548, -3469, 24697, 23272, -3469, -3469, -3469,  2308,
    9136,  2361, 24697, -3469, -3469, 24697,  1139,  1139, 24697, -3469,
   -3469, -3469, -3469,  2049,  1139, -3469, 24697, 24697,  1139,  1139,
    2297,  2297, -3469,  5871, 24697, -3469, 33959, 24697, 26122, 19495,
   24697,  2392,  2398,  1139, -3469,  1139, -3469, 24697, 20897, -3469,
   24697,  2524, 24697,   956,  2525, 24697,  1190,  2727,  2727,   643,
      68,  3963,  2314, -3469,  2440,  1139, -3469,  1139,    31, 47621,
   24697, 43121,  2409,    82, 24697,  2328,  1810, -3469, 24697,   505,
   -3469,  2329, 24697,  2413,   135, 24697, 24697, 24697, 24697, 24697,
   24697, 24697, 24697, 24697, -3469, 26597,   147,   353,   948, 45820,
   21372,  2610, -3469,  1928, 19019, -3469, 51220, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469,  1139,  2326, -3469,  2348, -3469, -3469,
   -3469, -3469, -3469,  2438, -3469, -3469,  2417, -3469, -3469, -3469,
    2112, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469,  2330, -3469, -3469, -3469, -3469, -3469,  2330, -3469,
   -3469,  1518, -3469, 71875,  2339, -3469, 61548,    23, -3469, -3469,
   -3469,  2358, -3469, 53466, -3469, 21847, 61548, -3469, -3469,  2581,
   -3469, -3469,  2341, -3469,  6937,  2581,  2520,  2529,  2529, -3469,
     -86,  9136,  2575,  9136, -3469, -3469, -3469, -3469,   -67, -3469,
    1263, -3469, -3469,  1591,  2353, 17653, -3469, 18106, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469,  1111,  2352,  2803, -3469, 40860, -3469, -3469, 51220,
    2462,  2353, 15598, -3469, 15598,  2353,  2355,  1151,  2443,  2444,
    2487, 61548, 61548, -3469, 43121, 61548, 61548, -3469,  2712,  2373,
   61548,  2621,  2622,  2390, -3469, -3469, 61548, -3469,  2579, 24697,
    2582, 61548, 61548,  2583, -3469,   892, 61548, 61548,  2571, -3469,
   -3469, -3469, 61548, -3469, -3469, -3469,  2564, -3469, -3469, 48971,
   -3469,  1200, -3469, 48071, 44921, -3469, -3469,   229, 61548, 61548,
   61548, 61548, -3469, 61548, -3469,   999, 61548, 61548,  2389,  2397,
    2396, -3469, 61548,  2624, -3469, -3469,  2568,   493, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469,   995, 61548, -3469,  1139,  2573,
   61548,  2467, -3469, 61548, 61548, 61548, 61548,  1111, -3469,  2778,
    1111,  1111,   754,  2784,  1944,  1944, -3469, -3469, -3469, 61548,
   61548, 61548, 61548, 56609, 61548, 61548,   830,   835, 61548, 57058,
   -3469, 55711, 61548, 61548, 61548,   118,  2482, 61548, 61548,   718,
     492,  2554,  2555,  2556, 61548, 61548, 61548, -3469, 61548,  2501,
    2502,   111,  2574, -3469, -3469, -3469, -3469, 24697,  2660,  2814,
    2665,  2666,  2493,  2500, 45371,   988, 61548, 61548, 61548, 61548,
   61548, 61548,  2680,   988, -3469, -3469, -3469,  1470, -3469,  1212,
   -3469,  2460, -3469, 24697,    59, 47621,  2451, 29825, -3469,  2535,
   -3469,  2539,  1139, -3469,  1614, -3469,    10,  2682,  2471,  2471,
    2471,  2471,  2471,   874, -3469, -3469, -3469,  2743, 61548,  1258,
   -3469,  2474, 55711, -3469, -3469,  1951, 53017, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469,  1249,  1902,  1902,  1902,  1902,
   -3469, -3469, -3469,  2641,  2640,  2469, 61548, -3469,  2212,  2760,
   55711, 52119,  1488, 61548,  2859,  2741,  1054,  2653, 55711,  2602,
   -3469, 41317, -3469,  2483,  2742,  2745,  2763, -3469, 27547, 58405,
    2476,  1763, -3469, 58405, 58854, -3469,  1190,  2484, 23747,  2439,
    1740, -3469,  2871, -3469,  1791, -3469,  1940, -3469, 61548, 61548,
   61548, 61548,  2486,  2488, -3469,  1940,  2668,    99, -3469,  2669,
      99,  1940,  1054, -3469,    54, -3469, -3469, -3469, -3469, -3469,
   24697, -3469, -3469,  2586, -3469, -3469, 51220,  1223, -3469, -3469,
    1223, -3469,  1223,  2960,  1940,  2490, -3469,  1940,  1940,  2030,
    2030,  1940, 59303,  2894,  2770, -3469,  1279, -3469, -3469, 21372,
   -3469,    64, -3469,    66,   821,  2710, -3469, -3469, -3469, -3469,
   47621, -3469, -3469, -3469, -3469, -3469, 61548,  2683,  2495, 59303,
    2879,    99, -3469,  1287,  1035,  1132, -3469, 24697, 24697,    19,
   -3469,  7625,  1310,  2506,  2507,  1320, -3469, -3469, -3469, -3469,
   -3469, -3469,  2508,  2788, -3469, -3469,  2510,  1349,  1353,  2512,
    2513, -3469, -3469,  2072,  2514,  7868,  2519, 26122,   273, -3469,
   -3469, 26122,  2526, -3469,  1399,  5754,  2522,  2531,  2565,  2567,
    2533,  2534,  8515, 24222, 24697, 24222, 24222,  8670,  2522,  2536,
    1414, 43121,  8846,  1455, -3469, 24697, 43121,  3556, -3469, -3469,
   24697, 61548,  2540,  2541, -3469, -3469,  5871, -3469,  2578, -3469,
   26122, 26122,  3067, 22322, -3469, -3469,  2808, -3469, -3469,  1370,
   -3469,  2543, -3469, -3469,  3748,    93, 24697,  2328, 24697,  2619,
   33959,  4563, 24697,  5010,  5098,  5098,   126,   126,    63,    63,
      63,  1425,   948, -3469, -3469, -3469,  2546,  2053, 24697, -3469,
    1711,  1728, 55711,  2996,  7976, -3469, -3469, -3469, 28007,  2601,
   24697, 24697,  2552, -3469,  1476, -3469, -3469,  1926,  2960,  1139,
      49,  1139,    31, 36721, -3469,  2353, -3469, -3469,  1491, 32110,
    2337, 21847,  1190, -3469, -3469, -3469,  1506, 24697, -3469, -3469,
    2161,  1561, -3469, 61548,  2492,  2492, 24697, 24697, 22797, -3469,
   -3469,  2547, -3469, -3469, -3469, -3469, -3469,  2548, -3469, -3469,
   -3469,  3002,  2560,  2557,  2566,  2563, -3469, -3469, 61548, 61548,
   61548, -3469, -3469, -3469, -3469, -3469,  2782, -3469, 24697,   156,
    2572,  2591, 61548,    99, -3469,  9136, -3469, -3469, -3469,  2823,
   -3469, -3469, -3469, -3469,  2753, -3469, -3469,  1570, -3469, 44921,
   48071, -3469, 48071, -3469,  1570,  1300, -3469,  1940, -3469, -3469,
   -3469, -3469,  1101, -3469,   266, 47621,  2747, 46271,  1940,  1112,
    1249, 61548, 61548, -3469, -3469,  1940, -3469,  1249,  1940,  1249,
   -3469, -3469, -3469, -3469, -3469, -3469,  1111, -3469, -3469, -3469,
   -3469, -3469, 61548,  1111,  1111, -3469, 47621,   220, -3469, -3469,
   -3469, -3469, -3469,    99,    99, 61548, 61548, 61548, 61548, -3469,
   -3469, -3469, -3469, -3469, -3469,  2658, -3469, -3469, -3469,   811,
   -3469, -3469, -3469,  2798,  2809,  2810,  2675,  2686,  2687,  2688,
   -3469,  2689,  2690,  2692, -3469, -3469, -3469, -3469, 61548, 61548,
   -3469, -3469, -3469,  6399,   988, 47621,   988,   988, 61548, 61548,
    2595, -3469, -3469, -3469,  2836,  2839,  2849,  2850,  2852,  2853,
     988, -3469,   129,  2639, -3469,   268, 33019,  4271,  2617, -3469,
    2623,  1139,  2353, 30299,  1875, -3469, -3469, -3469,   523,  2828,
    2625, -3469,  2805,  2471, -3469,   839,   713, 59752, 60201, 60650,
   -3469,   157,  2699, -3469, -3469, 43121, 33019,  2258,   958,  2768,
     971, -3469, -3469, -3469, -3469, -3469, 55711,    10,  1054,  1517,
   -3469, 47621, 51220,   -88,  2633, 55711,  2631,  2628, -3469, -3469,
   -3469, -3469,  1535, -3469, 47621,   -45,  2817,  2816,  1543, -3469,
   -3469,   -88, 61548,  2723, 55711,  2705,  1054, 40860, 46721,  1853,
   -3469, -3469,  2821, -3469, 61548, -3469, -3469, 31208, 29376,  1763,
    2643, 61548, -3469,  2645, 28007,  2882,  2819, -3469, 28007,  2819,
    1480,  2819,  2886, -3469, 32559, -3469,  2651,  1134, 19019,  2835,
    9136, -3469,    99, 47621,    99,  2720,    99,  2721,    99, 45371,
      99, 55711, -3469, 55711, -3469,    99, -3469,  9136, 55711,   888,
   -3469, -3469,  2654, -3469,  2671, -3469, -3469, 43571, 61548,   483,
   -3469, -3469,  2837, -3469,   -88, 61548,  1190,  2656, -3469, -3469,
   -3469, -3469,  2959,  2961, -3469, -3469, -3469, 54813,    77, 61548,
   -3469, -3469, -3469, -3469,  2667,  1545,  9006, 24697, -3469,  2966,
   47621, -3469, -3469, -3469, -3469, -3469, 24697, -3469, -3469, -3469,
   -3469, -3469, 24697, -3469, 24697,  2946, -3469,  3077, 47621, 26122,
     547,  2039, 27072, 26122, 26122, 26122, 26122, 26122, 26122, 26122,
   26122, 26122, -3469,   292, -3469, -3469, 24697, 24697,  2954,  2946,
   -3469, -3469, -3469,  1597,  1597, 47621,  2672,  2522,  2673,  2676,
   24697, -3469, -3469,  1552, 43121, -3469, 24697,  7135,  1568,  2731,
    1190,  4431, -3469,  3036,  1054, 24697,   993,  1058, 24697,  1579,
   24697,  2956, -3469, -3469, -3469,  2681, -3469, -3469, 47621, 24697,
   26122, 26122,  4139, -3469,  5670, 24697,  2678,  6299, 22322, -3469,
     591,   591,   591,   591, -3469, 55711, 55711,  2476, 24697,  2950,
    1584,  1588, -3469,  1249, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,  2677,
   -3469,  2700, -3469, -3469,   365,  2691, -3469, -3469,  3002,  2702,
   61548, -3469,  2439, -3469, -3469, -3469,  2693, -3469,  1561, -3469,
   -3469, -3469,  1940, -3469, -3469, -3469, -3469, -3469,  2706,  2708,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,  2471,
    4604, -3469, 61548, 61548,  1605, -3469, -3469,  2945,  1314, -3469,
   -3469, -3469,  2771,  2785,  2787,   509,   691,  2790,  2791, -3469,
    2797, -3469, -3469, -3469, -3469,  1940,  1940, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469,   641,   624, 47621, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, 61548,  2982,   451,  1133, 61548, 61548,
   61548, 61548, 61548, 61548, 61548, -3469, -3469, -3469, -3469,  2714,
   -3469, -3469,  2940,  2955,  2958,   988,   988,   988,   988,   988,
     988, -3469, -3469,  1944,  3032, -3469, -3469,  2243,  2243,    34,
   -3469,  2243, -3469,  2243, -3469, -3469,  2460,  2693,  1442, -3469,
   -3469, -3469, -3469, -3469,    81,  1139,  1636,  2722, -3469,  1233,
   30299, 30299, 30299, 30299, 30299,  2353,    31, 55711,  1139, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469,  2724, 61548, 26122, -3469,  1167,   491, -3469,  2957,
   55711,  2769, -3469, -3469, -3469, 47621, -3469, -3469,  3114,   608,
   55711,  3010,  2903,  1623, -3469, -3469, 61548, -3469,  1243, -3469,
   52119, -3469,  2983, 52119, -3469, 61548, -3469, -3469, -3469,  3084,
    2824, -3469, 61548,  1365,  2793,  1747,  1054,  2705, 61548,  2734,
   -3469,  2728, -3469,  2972, -3469,  1902, -3469, -3469,   178,  2762,
   -3469, -3469, 58405,  2737, 61548,  1763, 28007, -3469, -3469,  1742,
   -3469, 28007,  2976, -3469, 28007, 61548,  2746, 61548,  1657, 39030,
   -3469,  2744, -3469, 61548, -3469, 61548, -3469,  2749, -3469,    99,
      99, -3469,  3131,  2751,  1456,  1223,  1926, -3469, -3469,  3016,
   59303, -3469, -3469, -3469, -3469, -3469, -3469,  3025, -3469, -3469,
   -3469, -3469, 24697,  9136, -3469,  2754,  9136,  4680,  9136,  2954,
   -3469,   785,  3030, -3469,   715,  2756,   292,   785,  1021,  1021,
     139,   139,    71,    71,    71,  3077,  9136,  9136, -3469, -3469,
   -3469, -3469,  2758, -3469, -3469, -3469,  2522, -3469, 25172, -3469,
   -3469,  2804,  2807,  2759, -3469, 24697, 25647,  2755, -3469, -3469,
      31,  2727, 26122, 26122,   211, -3469,   218, 24697, 47621,  1666,
     211,  1801,  2530, 24697, 24697,  7265,   155, 24697,  5133, 55711,
   55711, 55711, 55711, -3469, -3469,  9136,  3134,  3026, -3469, -3469,
   -3469,  1926,  2587,  1054, -3469,   643, -3469, -3469, 33959, -3469,
   -3469, 15598, -3469,  1139, -3469,  1690,  1691,  2769, -3469,  2838,
   -3469, 61548, 61548,  1139,  1139, 47621,  2761, -3469,  1139,  1139,
    2767, -3469, 61548, 61548, 61548,   157,  2951,  2953,  1139, 61548,
    2830, -3469, 61548, 61548, 61548, 61548,  3061, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469,  3017,   988,   988,   988, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469,  1054,  1054,  1249,  2965, 61548,
    1054,  1249, -3469,  1176,  3099, -3469,  3037,   632,  2792,  3065,
    3069, -3469, -3469,  1978,  1978, -3469, -3469, -3469, -3469, -3469,
    3074, -3469, 24697,  1604,   785, -3469, -3469, -3469, -3469,  2769,
    2258,  2861,  2862,   -88,   -65,  3105,  3095,    10, -3469,  1054,
   -3469, -3469,  2802,  1086,  2811,  1488, -3469, -3469, -3469,    96,
   61548, -3469, -3469,  3169,  3172,  2987, -3469, 61548,  3047,  2143,
    3092,  2818, -3469, 28467,  1054,  1853, -3469, -3469, -3469, -3469,
   -3469,  2900, 61548, -3469, -3469, 61548,  1693, -3469, 24697,  2822,
   -3469, -3469, 28007,  1742,  1704, 61548,  1716, 47621, -3469, -3469,
   -3469,    99,    99,    99,    99, -3469, -3469,  2760, 61548,  3102,
   -3469, -3469,  2999, -3469, 59303,  9136, -3469, -3469, -3469, 26122,
    3103, -3469,  2826, 26122, -3469,  2827,  1746,  1755, -3469, -3469,
   -3469,  5407,  2881,  9136,  2936,  2832, -3469,   335,   335,   218,
    1756, -3469, 26122, 26122,   211,   211, 24697,   211, -3469, -3469,
   -3469, -3469, -3469, 24697, 24697, -3469, -3469,  1442, -3469, -3469,
   -3469, -3469,    31, -3469,  2834, -3469, -3469,  2985,  2769,  2861,
   -3469, -3469, -3469, 28927, 33959, -3469,   509,  2842,  2843,   691,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, 24697, -3469,   599,
     293,  2895,  1940,  3120,   988, -3469, -3469, -3469,  2639, -3469,
   -3469, -3469, 61548,  2841, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, 43571,  3234, 55711,    81,  5724,  3038, -3469,  2861,
    3064,  3108, -3469, 61548,  1365, 52119, -3469,  1067,  3005, -3469,
   -3469,  1488,   924,  1071, -3469, 55711,  2816,  2986, -3469,  2988,
   -3469,  3029,  3034, -3469, -3469,  1054, -3469, 61548, 28467, 24697,
    1757, -3469, 61099, 20420, -3469, -3469, 55711, -3469,  1764, -3469,
    9136, 61548, -3469, -3469, -3469,  1767, -3469, -3469, -3469, -3469,
   -3469,   -88, -3469,    77,   347, 26122, 26122,   303, 24697, -3469,
   24697, -3469, -3469, -3469,   -74, -3469, -3469,   335,   335,   211,
    2522,  9136, -3469, -3469, -3469, -3469, 55711,  2861, -3469, 47621,
    1791,   400, -3469, 47621, 47621, -3469,  9136, 61548, 61548, 61548,
   61548, 61548, -3469,  2841,  3234,  3241, -3469, -3469,  3146, -3469,
   -3469,    75,  3042,  2962,  3153, -3469, -3469, -3469, -3469, 61548,
    2816, -3469, -3469, -3469, -3469, -3469, -3469,  1771,  2824, -3469,
   -3469, -3469, -3469, -3469, -3469,  1798,  6061,  2769, 28467, 61548,
   -3469,   808,   808,  2601, -3469,  1819, -3469, -3469,   347,   574,
   -3469,  1837,  1846,  2927, -3469,  2258, -3469,  1864, -3469, -3469,
   45371, -3469,  1885,  1887,  2863,  2917,  2863, -3469,  1940, -3469,
   -3469,  3176, -3469, -3469,   132, -3469,  3052,  3053, 61548, 61548,
    3265,  2880,  2824, -3469, -3469,  2769, 61099,  2824, -3469, -3469,
    1561,  1561,  3190, -3469, -3469, -3469, -3469, -3469,  3064, 43571,
    2887, -3469, -3469, 61548,  3011,   604,   604,  2963, -3469,  3204,
   -3469, -3469, -3469,   509, 38120, -3469,  2824,   808,  2601, -3469,
   -3469,   159,  3042,  1791,  3039, -3469,  3182, -3469,  3293, -3469,
     630, -3469, -3469,  2761,  1913, -3469,  2160, -3469,  1301,  2601,
    1561, -3469, -3469, -3469,    37,    81, -3469, -3469,  3045, -3469,
   -3469, -3469, -3469, 38120, 24697, -3469, -3469, -3469,    43, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, 43571, -3469,  1914,
    1814, -3469, -3469,  1861,  1531,  2898,  1249, -3469,    43, 38120,
   -3469,  1924, -3469
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3469, -3469, -3469, -3469, -3469,  3140, -3469, -1026,  -503, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469,  1177, -3469, -3469,   -94,  1074,  1989, -3469,   903,
   -3469, -3469, -3469, -1338, -3469,   171,   386, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469,  1261, -3469,  -975,   777, -1137, -3469,
   -3469, -3469, -3469,  1221,    16, -3469, -3469, -3469, -3469, -3469,
   -1576,  -130,   241, -3469,   242,  1285,   363, -3469,    -4, -3469,
   -3469, -3469, -3469, -1184,   861, -2625, -2468,   240,  -373,  -395,
    -349,  -347,  -376, -3469, -3188, -3340, -2394, -2641, -3469, -3469,
     615, -3469, -3469,   256, -1570, -3469,  1752, -3469, -3469, -3469,
   -3469,   -23, -3469, -3469, -3469,   -43, -3469, -3469, -3469, -1562,
   -3469,  1230, -2614, -3469, -3469, -3469,  -444,  -415, -3469, -3229,
      32,    36, -3469, -3469, -3469, -3469, -1067, -3469,   716,   714,
   -1093, -3469, -3469,   748, -3469, -3469,  -368,  -119,  1790, -3469,
    -372, -3469, -3469, -3469,  -118, -3469, -3469, -3469, -3469, -3469,
   -3469, -1704,  -728, -1585, -3469, -3469,  3251,   937,   639, -3469,
   -3469, -2084, -1554, -3469,  -179,  1123,  2189, -1241, -2287,   217,
   -3469, -3469, -1730, -3469, -3469, -3469,  1124, -1553, -3469,   272,
    -178,  -275, -2936, -3426, -2869, -3469, -3469, -1190, -3469,   889,
    1396, -3469,  1394, -3469, -1904,   279,  -944, -2645, -3010, -3469,
   -3469, -3469, -3469, -3469, -3469, -1690, -1511, -3469,  -229, -3469,
   -3469, -3469, -3469,   822, -3469,   114, -3469, -3469, -3469, -3469,
   -3469, -3469,  -365,  -402, -3469, -3469, -3469,   484, -3469, -3469,
   -3469,  1240, -1087,  -921,  2499, -1549,  -120, -3469, -3469, -3469,
    1282, -2038, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -1180,
   -3469, -3469, -3469, -3469, -3469, -3469,  1538,  3324,  -768, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,  2256,   338,
   -3469,   -69, -3469, -3469,   668, -2157,   -52, -3469, -3469, -3469,
   -3469,  -357,   -44, -3469,   998, -3469, -3469, -1850, -3469,  2259,
    1195,   276,   -72,   -21,  -238,   425,  1003, -3469, -3469,  -198,
    1361, -3469, -3469, -3469, -3469,   994,  2066, -3469,   985,  -284,
   -3469, -3469,  2071, -3469, -3469,  2067,  1537, -3469,  1560,  1030,
   -2185,  1252, -2147,   731,  -405,    39,  -168,  2659, -3469, -3468,
    1016, -2938,   362,   614, -1914, -2547, -1490, -3469, -3469, -1224,
    4323, -3469, -3469, -3469,  5218,  7007, -3469, -3469,  9463,  9544,
   -3469, -1111,   606, 11664,  2679, -1277, -1616, 12326,   598,  1008,
   -1631, -3469, -3469, -3469,  -138,   616,  1678, -3469,   807, -3469,
    -743, -3469, 12902,  1013, -3469, -1154, -3469, -1231, -3469, -1709,
   -3469, -3469, -3469, -3469, -3469, -1536, -2731,  -923,  1079, -3469,
   -3469,  1172, -3469, -3469, -3469, -1084, -1009, -1815,  1082, -1834,
   -3469,  -995,  1203,  1643,  6277,  -914,  3160,  -818,  7389,  -135,
   -1984, -1372, -1044, -3469,  -738, -3469, 10107,   158, -3469, -3469,
      -2,  1778,   945, -1859, -3469,   -18, -3469,  -984, -1011, -2455,
    -410, -3469, -3469,  2928,   772, -3469,  2357, -3469,  1286,  1854,
   -3469, -3469,  1534,  -894,   136, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469, -3469,  2095,
      89, -3469,   -62, -3469, -3469, -3469, -3469, -3469,  3188,  -308,
   -3469,  2674,  -301, -3469, -3469, -3469, -3469, -3469, -3469, -3469,
   -3469, -3469,  2106,  1571, -3469,  2489, -3469, -3469, -3469,   -51,
   -3469,  2293,  -142, -3469, -3469, -3469, -1112,  1224,  2516,  -899,
    -870,  1547, -3469, -3469, -3469, -3469, -3469, -3469, -3469,  1241,
   -3469, -3469,  1072,  1246, -3469, -3469,   336, -3469, -3469,   243,
     339, -3469,  2188, -3469, -3469, -3469,   588, -3469, -3469, -3469,
    -568,  8343,   113,  -104,   -47,   112, -3469,  2931, 11720,  -725,
     -66,  2125,  5512, 11201,    70,   -97,  -112,   101,   512, -1403,
   -3469,  3178,  1556,  1264,  -949,  9562,  1820,  4409,    -9,  -774,
   -1099,  2349,  -720, -1691, -3469,  3561
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1995
static const short yytable[] =
{
      75,   987,  1689,  1249,  1429,   843,   333,  2273,  2284,   328,
     744,   831,   375,  2183,   826,   375,   345,   752,  2071,   383,
    2306,  1569,   973,  1770,   946,  1780,   329,  1465,  1058,  1574,
    1089,  2288,  1073,  1045,   331,  2477,  1448,  1826,  1000,  1066,
    1194,  1069,  1389,  1376,  1202,  1001,  2184,  1905,  1479,  1597,
    2255,   744,  2828,  1211,  1100,   922,   979,   334,   752,  1399,
    2511,  1799,  1800,  2759,  1178,  1142,  1530,   745,   629,   378,
    1155,  2208,   378,  1724,  3004,  1560,  2346,  2209,   786,  2671,
    1815,  1147,  3138,  2574,   628,  2210,  2487,  2521,  1643,  1469,
     942,  2525,  1684,  2211,  2212,  1163,  1658,   942,  2213,   942,
    1525,  1397,  2781,  3142,  3176,   378,  2773,  2775,   745,  3319,
     873,  2495,  2013,  1185,  1229,   965,  1726,  1199,   744,  1192,
    1720,  3411,   802,  2174,  1639,   752,  1667,  2492,  1512,  1243,
    1033,  1645,  1886,  1462,  1893,  1849,  3099,   837,  1659,  1466,
    1455,  1456,  1657,  2858,   832,  2176,   378,  3258,  2678,  2561,
    2563,  2696,  2697,  2698,  2699,  1844,  1220,   847,  1852,  1253,
      74,  1760,   915,  1713,  1713, -1145,  1793,  1794,   333,  2321,
     382,   328,  2220,  2225,  1713,   745,  2419, -1874,   628,   376,
    1842,  1370,   376,  2179,   751,  2272,  1713,  2419,   329,  1812,
     800,   374,  1054,   944,   374,  2837,   331,   787,  1849,   151,
     944,  1493,   944,  2019,  3733,   151,   646,  2340,  1713,  1764,
    2107,  2858,  2506,   378,  2703,   376, -1329,  2020,   986,   334,
    2230,  1852,  1267, -1329,  2468,   751,  2107,   374,  2453,   653,
    2029,  2230,  2414,  2116,  2165,  2454, -1345,  3606,  2650,  2627,
    3382,  3822,  2221, -1345,  1516,  1015,  1462,  1231,  2818,   256,
    2820,  -979, -1901, -1425,  3156,  3772,   376,  3464,  3607,  3466,
    2679,  1233,  1932,  1171,  -979,   653,  3708,   878,   374,   170,
    3608,   208,   941,  2019,  3122,   170,  1459,  3752,  2322,   941,
     375,   941,   836,  1849,  2021,  2786,  1246,  2788,  3123,  1423,
    1849,  1105,   751,  -313,  3785,  3770,  3771,  1016,  1494,  1957,
    2180, -1070,  1569,   943,  -979,  2374,  1852,     3,  3383,  2024,
     943,  1853,   943,  1852,  3124,   375,  3125,  3539, -1117,  1027,
    3378,   384,  -979,   376,  3837,   187,  2235,  1482, -1070,  1879,
    3821,   187,   226,  1424,   975,   374, -1917,   378, -1943,  1826,
    3447,  1517,  1240,  3015,  1391,  2858,  1958,  1883,  1526,  1527,
     903,  3835,  1483,  2108,  2021,   759,  3688,   760,  1727,  2030,
    3762,  1074,  3379,   208,  2858,  1092,  -979,  3384,  1739,  1740,
    3734,  3820,   378,  1101,  -979,  2858,  1247,  1911,  1106,  1578,
    1799,  1800,  1698,  1584,  3126,  1580,  1573,  1815,  1018,  3753,
    2150,   239,  3823,   848,  3034,  1574,   208,  1714,  1714,  3589,
    2507,  1150,   208,  2231, -1818,  1157,   647,  2858,  1714,  2022,
    3448,   256,  1172,  3700,  3595,  1164,  3609,  2628, -1876,  2858,
    1714, -1874,  1484,  2222,   226,  1640,  1641,  2031,  1758,  2166,
    2819,  1855,  2821,  1668,  1642,  3625,  1406,  1254,  1772,   763,
    3016,  1665,  1714,  3127,  2323,   797,  2348,   376,  3128,  1781,
     224,  1856,  1857,  1457,  1056,  2062,   224,   226, -1995,   374,
    2324,  1001,   831,   226,  2660,   849,  2420,   850,  1693,  1695,
    1026,  2226,  2565,   764,  2181,  1765,  -979,  2920,  2239,  2022,
    3129,  2145,   376,  1761,  1882,  2148,  1691,  1477,  1495,  2117,
    3130,  1793,  1794,  2859,   374,  2023, -1901,  1719,  2122,  1812,
    1860,  2118, -1145,  2816,  1518, -1145, -1329,  1247,  3488,  2489,
   -1145, -1145, -1145,  2860,  1861,  2034,  3838,  2651,  2455,  1845,
    1029,  2039,   239,  1034,  1929,  1930, -1345,  3635,  3667, -1145,
    2172,  1642,  2860,  2177,  3325,  3326,  2177,  3449,  1873,  1392,
    1715,  1765,  1894,  2860,  3072,  3786,  2871,  2261,  1413,  2119,
     627,  1691,  2265,  3393,  3394,  3395,  3396,  3397,  1466,  2174,
    1998,  2274,   305,  3220,   627,  2023,  3131,   239,  2168,  2044,
    3058,  2968,  3060,  3061,  2283,  2860,  2861,  1880,  3017,  3185,
   -1917,  1035, -1943,  3189,  3035,  1264,  3071, -1995,   837,  1042,
     377,  3450,  1379,   377,  2900,   832,  3846,  2151,  1870,  1871,
    1872,  1873,   761,  3018,  1075,  2435,  2861,  1105,  1552,  1094,
    1096,  2868,  2869,  2870,  2871,  2292,  1102,  2255,   846,  1720,
    2963,   627,  2237,   912,  1264,  3036,   377,   993,  1393,    55,
    2343,  2344,  3678,  1068,  1070,   627, -1916,   894,  2861,   754,
    1943,  2352,  2533,    55,  2355,  1553,  2858,  3353, -1818,   755,
    3407,   894,  2367,  2368,   744,  3108,  3010,  2973,  3011,  1240,
      49,   752, -1876,   627,  1864,  2384,  2386,   377,    52,    53,
      54,    55,  1146,    56,  3062,  3063,  2400,  1650,   979,  1445,
     994,  1868,  1869,  1870,  1871,  1872,  1873,  3722,  1868,  1869,
    1870,  1871,  1872,  1873,  1106,  2313,   375,  1114,  1180,  2371,
    2372,  1703,  2581,  2457,  1437,  2157, -1117,  3767,  1798, -1117,
    1484,   745,  3333,  3807,  1651, -1117,  3242,   888,  3243,   237,
    1190,  2436,   238,  3679,   305,  2437,  2862,   756,   951,  1944,
    2474,  1979,  3739,   836,   377,  1945,   889,  1980,  1704,  2863,
    2864,  2865,  2158,  2866,  2867,  2868,  2869,  2870,  2871,   378,
     995,  1691,  2408,   378,  1137,  3796,  2862,  1065,  2438,  1573,
   -1150,  1065,  2866,  2867,  2868,  2869,  2870,  2871,  3098,  2863,
    2864,  2865,  3090,  2866,  2867,  2868,  2869,  2870,  2871,  1691,
    1139,  2029,  3408,  3730,  1168,  3590,  1089,  3830,  2862,  1981,
    3354,  3382,  1554,  1980,  1065,  2633,   628,  1043,  2027,  1574,
    3176,  2634,  3090,  3599,  2638,  2866,  2867,  2868,  2869,  2870,
    2871,  1115,  3334,   810,  2860,  3317,   952,  2866,  2867,  2868,
    2869,  2870,  2871,  1566,  2129,  2130,  2131,  2132,   751,  2639,
    3797, -1916,  2458,  3244,   924,  1181,  1038,  2255,  2336,  2309,
    2310,  2582,  1065,  3245,  3174,  1981,   942,   757,  1065,   942,
    2026,  1568,   996,  1014,  2152,  2153,  2291,  2858,   377,   376,
    2162,  1652,  1676,   376,  1378,   812,  2966,  1387,  2295,  1555,
    3114,   374,  2266,  2439,    75,   374,  2027,  2861,  2179,  3740,
    1982,  2275,  3808,   798,  3490,  1705,  3491,    49,  3335,  2159,
     627,  2281,  2635,   377,  3338,    52,    53,    54,  3668,  2498,
     948,  3799,  3800,  1252,  2599,  1373,   925,  1728,  1400,  1677,
    3347,  3573,  1438,  3219,  1532,  1015, -1916,  2201,  3384,   628,
   -1916,  3831,  2216,  2217,  2218,  2219,  1729,  3346,  1691,  2926,
    1268,  2304,   151,  2307,  2308,  2040,  1982,  2311,  1653,  1533,
    1015,  1381,  1383,  2257,  1065,  2260,   628,  3809,  3690,   944,
    2264,  3836,   944,  1089,  1567,  1710,  1730,   628,   628,   763,
    2691,  3323,  1706,  2155,  1422,   378,  2160,  1016,  3810,  3220,
    1017,  1642,  3008,  2499,  1029,  1065,   763,  1987,   916,  2565,
    1988,  3368,  3369,  3370,  3371,  3372,  3373,  2285,   923,  1465,
    1676,  1678,  1016,   764,  3339,  2180,  3109,   818,  1196,   819,
    3348,  3457,   170,  3349,  2187,  2028,  3461,   744,  2515,  3463,
     764,  3492,  1073,  2041,   752,  1225,   629,   629,  1983,  2600,
    1849,  2601,  1423,   972,  2156,  2860,  3736,  2862,   941,  3677,
    2636,   941,   628,   628,    74,  3454,  1463,  3214,  1679,  1029,
    2863,  2864,  2865,  1852,  2866,  2867,  2868,  2869,  2870,  2871,
    2112,  1469,  2188,  2550,  3774,  2637,  3701,  2137,  1018,   943,
     810,  2484,   943,  2640,   745,  2858,  1424,  1788,  1989,   926,
     927,  1197,  2019,  1089,  2784,   376,  1534,  3217,  2603,  2604,
    3282,  2063,  3702,  1018,  2124,  1691,  2020,   374,  2861,  1913,
    2571,  1029,   653,  2858,  1198,  2205,   987, -1150,  2113,  3207,
   -1150,  1065,   378,  1535,  3683, -1150, -1150, -1150,  1065,  1984,
    3778,   982,   812,  2594,  1065,  1680,  2597,  2598,  2063,  1678,
    3316, -1004,   984,  1595, -1150,  3230,  2417,  1914,  2496,   208,
    2858,  2551,  2208,  2255,  2189,  1634,  2196,  2255,  2209,   628,
    2792,   151,  2203,  2794,  1019,  3283,  2210,  2796,  3703,  2712,
    2713,  2714,  2715,  2021,  2211,  2212,  2227,  1737,  1368,  2213,
    1733,  2125,  1065,  2001,  2206,    49,  1679,  2782,   627,  2181,
    1001,  2822,  1642,    52,    53,    54,  1763,  1734,  1447, -1004,
    1020,   751,  2615,   224,  3442,  1735,  2190,  2617,  1856,  1857,
     226,  3398,    49,  2835,  1711,   627,  1447,  3643,   763,  2063,
      52,    53,    54,  3704,  2830,  2182,  1550,   990,   334,  1642,
     628,   170,   376,  1557,    75,    75,   202,    75,  1065,  3472,
    1148,  3473,  1149, -1004,   374,  2519,  1956,   334,  1369,  3705,
    2616,  1551,   764,  2860,  2823,  2618,  2204,  1860,  2862,  1488,
    2887,  2567,  2125,  1680,   818,  1634,   819,  2777,  1745,   239,
    1786,  2863,  2864,  2865,  2578,  2866,  2867,  2868,  2869,  2870,
    2871,  2860,  2191,  1957,  2192,  1558,  1065,  1802,  2585,  2909,
     377,  3602,  2588,  3093,   377,   991,   937,  3632,  2022,  2661,
    -322,  3565,  3566,  3567,   627,   971,  2583,  1153,   909,  1573,
    1642,    49,  1065,  1654,   627,  3706,  2861,  1829,  2860,    52,
      53,    54,    55,  3093,  1842,  1489,  1165,  3603,  1821,  1822,
    1958,  1520,  1655,  1840,  3764,  1900,  2940,  2941,  1843,  3239,
    1898,  1899,  1065,  1065,  2861,  1065,   947,  3405,  1848,  3355,
     744,  1165,  1078,  1166,   628,  1007,  3576,   752,   208,  3817,
    1522,  2691,  1065,  3259,   628,  1079,  1080,  1081,  3356,  1082,
    1083,  1084,  1085,  1086,  1087,  1885,  1008,  1823,  3140,   999,
    1154,  2861,  1004,  1523,  2023,   765,  1009,  1383,  3795,   375,
     375,  1167,  1901,  3798,    74,    74,   942,    74,  3817,  1912,
     744, -1569,   799,   628,  3406,  2139,  1463,   752,  2133,  1225,
    1463,  1463,   224,  3577,   875,   942,  1167,  1948,  1948,   226,
    1948,  1995,  3819,  1044,  3817,   375,  3005,  2141,  2408,  3172,
    2140,  1065,  2005,  3013,  1065,  1065,  2142,  3696,  1868,  1869,
    1870,  1871,  1872,  1873,     8,   378,   378,   378,  2664,  2665,
    2666,  2667,  2668,  2669,  1821,  1822,   629,   745,  3014,  2143,
      49,  1038,  3697,   627,  1010,   949,  2862,    49,    52,    53,
      54,  1055,   628,  3530,  1492,    52,    53,    54,   239,  2863,
    2864,  2865,   378,  2866,  2867,  2868,  2869,  2870,  2871,   378,
    2886,  1634,  2888,  2889,  2862,   378,  3038,  3039,  1531,   944,
    3682,  1385,  1098,  1825,   119,  1103,   377,  1561, -1995, -1995,
    3399,  2866,  2867,  2868,  2869,  2870,  2871,  1849,   944,  1104,
    1559,  1903,   123,  1011,   202,  1634,    49,   653,   653,   627,
    2257,  2862,  2289,  2832,    52,    53,    54,  1141,  2290,  1634,
    1852,  2290,  2800,   987,  2863,  2864,  2865,  1488,  2866,  2867,
    2868,  2869,  2870,  2871,  1237,   376,   376,   376,   744,  2911,
    2785,  2912,  2787,  1144,  1520,   752,  1447,   374,   374,   374,
    1447,  1447,  2263,  1145,   751,  2255,  2329,  1251,   941,  2964,
    2255,  2913,  2330,  2255,  1012,  2008,   627,   627,  1156,  1521,
    1634,  2107,   376,  1522,    55,    55,    56,   941,  2114,   376,
    3439,   774,  1445,   894,   374,   376,  3227,  2171,   653,   943,
    2009,   374,  1161,  1489,   627,   745,  1523,   374,  2293,  1169,
    2337,  2531,    55,  1991,  1634,  2534,  3260,  3261,   943,  3694,
    2833,  1110,  3029, -1431,  1151,  1111,  1152,  2010,  2834,  3031,
    3032,  1078,  2548,   377,  3198,  2485,  2552,   127,   128,  1634,
    3535,  2527,  1001,   378,  1079,  1080,  1081,  2330,  1082,  1083,
    1084,  1085,  1086,  1087,  1486,  3200,  1383,  3202,  2566,  3204,
    2568,  3206,  2110,  3208,  1170,  2115,  1498,  1447,  3211,  2123,
    2249,  2914,   628,  1447,  3506,  3092,  2915,  1110,  3157,  1487,
    1173,  1111,  1065,   202,  1065,  1176,  2893,  1634,   627,  1065,
    2558,  2898,  2766,  2590,  1499,  2982,  2559,  3289,  1634,  1187,
    1889,  3228,  2674,  1574,  1890,  3092,  1488,  1089,  2675,  2335,
    1200,    49,  2332,  3100,  3101,  3102,  3103,  3104,  2767,    52,
      53,    54,   751,  3392,  1207,  1046,    75,  2631,  1047,  2333,
      75,  3122,  1227,  3191,  2644, -1767,  2646,  2334,  1048,  1049,
    2257,  2769,  2408, -1767, -1767, -1767,  3266,  1500,  2704,  1447,
     986,  1065,  1972,   376,  2705,  2509,  1973,   744,  1050,  1973,
     334,  1051, -1767,  1212,   752,   374,  1240,  2977,  1618,  2814,
   -1769,  3124,  1489,  3025,  3026,  2815,  1501,  2831, -1769, -1769,
   -1769,   876,  2916,  2290,  3012,  1065,  1065,  1582, -1417,  1798,
    2917,  2014, -1417,  1065,  2691,  2364,  1065, -1769,  3329,  1065,
    2841,  1224,   627,  1798,  2365,  2014,  2290,  1065,  1065,  1245,
    2844,   628,  1810,  1811,   745,  1065,  2290,  3534,  1065,  1065,
    1065,  1065,  3622,  3433,  3434,  3435,  2408,  1244,  1065,  1065,
    1230,  1065,  1232,  1065,  1234,  1256,  1065,  2771, -1765,  2848,
    1235,  2255,  1261,  2849,  2424,  2290, -1765, -1765, -1765,  2290,
    1634,  1065,   378,  1949,  1951,  1065,  1955,  1592,  1593,  1065,
    1583,  1262,  3684,  1065,  1263, -1765,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1264,  1065,   375,  1769,  1265,
    1721,  1065,  1722,  2858,  3030,  1065,    74,  1569,  1052,  2875,
      74,  2535,  1785,  2765,   239,  2290,  2244,  2245,  3512,   202,
    3587,  2043,  2482,  1504,  2892,  3128,  1266,  3376,  3377,  1505,
    2290,  3380,  2811,  3381,  2765,    55,  1506,    56,   628,   375,
     744,   375,  1488,  2513,  1270,  2513,  3664,   752,  2735,  2736,
    1508,   751,    49,  1269,   378,   627,  1388,  3129,  1509,  2811,
      52,    53,    54,  2977,  2944,  2895,  1065,  3130,  2945,  2946,
    2947,  2896,  1390,  2746,  2766,  1394,   377,   377,   377,  2948,
    2949,  2950,   376,  2951,  2952,  2287,  2943,  1722,  2953,  2954,
    2955,  1498,  2290,  2977,   374,  2766,   378,   745,   378,  1395,
    2767,  2969,  1396,  3744,  1510,  3746,  1406,  2970,   629,  2426,
    2201,  2427,  -979,   377,  1405,  2768,  2974,  3622,  1407,  1499,
     377,  2767,  1691,  2769,   628,  -979,   377,  3145,  1463,  1413,
      75,  2428,    75,  3146,  1415,   378,  2768,  2979,  2980, -1117,
     987,  1414, -1117,  3131,  2769,  3154,  2770, -1117, -1117, -1117,
    1065,  3155,  1788,  3161,  1417,  3231,  2257,  1821,  1822,  3162,
    2257,  2290,  3267,  3671,   376,  -979,  1798,  2770,  3268,  1420,
    1634,  2860,  1500,  3458,  1634,  1634,   374,  3374,  3274,  1798,
    3780,  1484, -1150,  -979,  3275, -1150,  1435,  3510,  1498,  3285,
   -1150, -1150, -1150,  1431,  3308,  2290,  3389,  3390,  3309,  1073,
    2290,  1501,  3475,  3476,  2290,  2710,   376,  1439,   376, -1150,
    1775,  1776,   806,  2584,   751,  3327,  1499,  3622,   374,  2771,
     374,  3162,  1537,  1798,  1769,  2014,  2429,  -979,  1538,  2747,
    2930,  2430,  2931,  3418,  2861,  -979,  2431,  1436,  3446,  3419,
    2771,  1078,  1451, -1130,  3497,   376, -1130,  2932,  2996,  2933,
    1440, -1130, -1130, -1130,  1079,  1080,  1081,   374,  1082,  1083,
    1084,  1085,  1086,  1087,  1441,  1029,  1539,  3468,  1065,  1500,
    1804,  1442,  2070,  2290,  1849,  1634,  3511,  2983,  2984,  1595,
    1447,  1452,  2330,   628,   377,  1443,   810,  3459,  1447,  1850,
      74,   628,    74,  1454,  1065,   628,  1634,  1852,  1501,  3269,
    3537,  3538,  1853,  3629,  -647,  2685,  3162,  3162, -1157,  1691,
    1444, -1157,  1540,  1457,  3634,   987, -1157, -1157, -1157,  1541,
    3146,  1470,  1542,  2149,   202,  1471,  3636,  2956,  1504,  1821,
    1822,  2356,  3146,  1473,  1505, -1157, -1121,  -979,   812, -1121,
    1769,  1506,  2432,  2711, -1121, -1121, -1121,  1488,  2743,  1480,
    2433, -1160,  2985,  2986, -1160,  1508,  3649,  2758,  1484, -1160,
   -1160, -1160,  3650,  1509,   628,  3651,  3656,  3717,  3055,  1065,
    1543,  2290,  2330,  3718,  3724,  2957,  1497,  3726,  1823,  1065,
    1691,  3763,  2195,  3146,  2862,  1447,  2709,  1765,  1447,  1447,
    1458,  1460,  1502,  2357,  2795,  2935,  2936,  2863,  2864,  2865,
    1514,  2866,  2867,  2868,  2869,  2870,  2871,  1529,  3765,  1510,
     628,  1065,  1528,  3175,  3718,  1556,  1562,  1503,  1854,  1565,
    1564,   202,  1855,  1544,  3857,  1504,  3858,   744,  1581,  3773,
    2262,  1505,   744,  1579,   752,  1691,  1590,  1596,  1506,   752,
    1065,  2070,  1856,  1857,  1507,  2358,  1586,  3775,  2359,  2097,
    3533,  1634,  1508,  2896,  1588,  1858,  3776,  1520,  1599,  1636,
    1509,  2958,  2290,  1637,  3637,  3638,  3639,  3640,  1065,  1065,
     818,  1413,   819,  -971,  3779,  3100,  3101,  3102,  3103,  3104,
    2330,   821,  1545,  3105,   745,  1419,  1522,  1421,  1859,   745,
     824,  1860,  2098,   377,  3190,  3781,  3193,  3782,  1065,  3660,
    -978,  2330,  1065,  2330,  1489,  1861,  1510,  1862,  1646,  1546,
   -1431,  1642,  -166,  -978,  1065,  1065,  1065,  1065, -1431, -1431,
   -1431,  1648,   378,  3832,  3856,  1664,  1065,   378,  3218,  3833,
    2290,  1065,  1840,  1673,  3862,  1110,  2360, -1431,  1681,  1111,
    3833,  1065,  1065,  1683,  1065,  1685,  2424,  1686,  1687,  3229,
    1688,  1950,  1950,  -978,  1950,  1690,  1691,  1065,  1696,  1065,
    1701,  1697,  1029,  1065,  2099,  2929,  1699,  1700,  3737,  1702,
    1863,  -978,  3742,  3743,  1707,   377,  1708,  2249,  2257,  1065,
    3102,  3103,  3104,  2257,  1709,  1712,  2257,    49,  1771,  1065,
     627,  1065,  1065,  2415,  2976,    52,    53,    54,  1773,  1777,
    1779,   751,  1801,  1784,  1792,  1795,   751,  2100,  1796,  2101,
    3738,  1463,  1065,  1797,  1847,  -978,   239,   377,  1065,   377,
    2102,  1803,  2361,  -978,  1877,  1806,  3732,  1065,  1065,  1065,
     237,    49,   376,   238,   627,  1807,  3727,   376,  1808,    52,
      53,    54, -1119,  1809,   374, -1119,  1765,  1814,  1816,   374,
   -1119, -1119, -1119,  2103,  1817,  1864,   377,  1818,  1906,  1065,
    1821,  1822,  1819,  1820,  3559,  3560,  1916,  3562,  1865,  1866,
    1867,  1827,  1868,  1869,  1870,  1871,  1872,  1873,  1828,  1830,
    1634,  1634, -1160,  1634,  2104, -1160,  1831,  1931,  2852,  1537,
   -1160, -1160, -1160,  1832,    49,  1538,  1634,   627,  1634,  1833,
    1834,  1835,    52,    53,    54,  1089,  1933,  1946,  3024,  1825,
    3148,  1422,  1968,  1971, -1764,  3027,  2105,  3028,  1978,  1985,
    1986,  2481, -1764, -1764, -1764,  -978,    49,  1634,  1994,  1992,
    1996,   744,  2858,  1539,    52,    53,    54,  1462,   752,  1999,
    2000, -1764,    49,  3826,  1078,  3181,  2002,  3513, -1710,   831,
      52,    53,    54,  1884,  2014,  2380,  3561,  1079,  1080,  1081,
    2004,  1082,  1083,  1084,  1085,  1086,  1087,  3628,  3357,  3834,
    3359,  1447,  2011,  2012,  2015,  2033,  1634,  3628,  2035,  1540,
    2016,  3149,   628,  2038,   628,   628,  1541,  2032,   745,  1542,
    2036,  2037,  2058,  2065,  2096,  2059,  3086,  1634,   628,  3163,
    2066,  2060,  1236,  2061,  1463,  2067,  2093,  2094,  3115, -1122,
    3849,  2685, -1122,  2095,  2459,  3180,  2107, -1122, -1122, -1122,
     987,  3707,  2746,  3111,   628,  2111,   378,  1634,  2121,  2126,
    3144,  2135,   334,  2127,  1463,  2257,  2161,  1543,  2128,  2134,
    1498,  2136,  1634,  2138,  2154,  2163,   628,  2164,  2173,  1788,
     334,  1798,  2175,  1804,  2257,  1634,  2186,   808,  3171,  1383,
    2215,  2198,  3299,  3300,  3301,  3302,   334,  2233,  1499,  1634,
    2229,  3075,  3223,  2249,   628,   628,  2236,  2249, -1120,  2202,
    2238, -1120,  2240,  2241,  1447,  1065, -1120, -1120, -1120,  1065,
    1544,  1447,  1447,  2247,  2268,  2258,  2269,  2270,  2070,  1065,
    2860,  2271,  2282,  2296,  1634,   751,  2312,  2297,  2302,  2315,
    1634,  3076,  2327,  2319,  2303,  2339,  2388,  2347,  2348,  2680,
     744,  1500,  2389,   334,  1520,  2401,  2406,   752,  1065,  1849,
    2410,  1089,  3077,  2418,  2411,  3670,   376,  2423,  2440,  2442,
    2811,  2468,  2478,  3725,  2479,  2480,  2483,   994,   374,  2486,
    1501,  3078,  2502,  1522,  2491,  2503,  2379,  2497,  1065,  2508,
    2177,  1634,  2516,  2861,  1447,  2526,  3079,  1065,  2517,  2528,
    2529,  2530,  2536,  1065,  1073,  1065,  2629,   745,  2747,  1634,
    1065,  3080,  2538,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  3748,  1447,  2540,  2541,  1065,  1065,  2542,
    2544,  2556,  2554,  2546,  2549,  2575,  1634,  2576,  2579,  2589,
    2257,  1065,  2577,  2580,  2595,   378,  3280,  1065,  2587,  3714,
    2602,  2641,  2642,  2643,  3720,  3720,  1065,  2648,  2649,  1065,
    2654,  1065,   628,  2652,  2655,  2656,  2657,  1840,  2658,  1634,
    1065,  1065,  1065,   377,    49,  2659,  1065,   627,   377,  1065,
    2670,  3541,    52,    53,    54,    55,  2676,    56,  2681,  1065,
    3081,  2688,  3550,  1445,  3552,  2689,  2693,  2694,  3082,  2702,
    2706,  3310,  2716,   202,  2825,  2717,  2722,  2748,  2718,  2741,
    3745,  2742,  3747,  1505,  2744,  2755,  2754,  1907,  2756,  2757,
    1506,  2783,  2764,  2778,   751,  2789,  1488,  3083,  2790,  2791,
    2793,  1893,  2812,  2798,  1508,  2857,  2807,  2340,  2824,  2873,
    2257,  1247,  1509,  2862,  2827,  2829,  2842,  2843,  2845,  2846,
    2847,  3769,  2850,  2851,  2853,   376,  2863,  2864,  2865,  2856,
    2866,  2867,  2868,  2869,  2870,  2871,  2874,   374,  2290,  2910,
    2881,  2880,  2882,  2883,  2884,  2925,  2891,   636,  2906,  2907,
    2903,  2904,  2918,  2905,   656,  2928,   660,  1634,  1510,  2938,
    2990,  3792,  2942,  2991,  2988,   660,  2999,  1608,  3720,    49,
    2993,  3803,   627,  1722,  3007,  2995,  2994,    52,    53,    54,
      55,  3002,    56,  3006,  3044,  3805,  3816,  1908,  3527,  3020,
     656,  3045,  2746,   628,   628,   628,   628,   628,   628,   660,
    3003,  3048,  3046,  3047,  2811,  3064,  3065,   656,   660,  3066,
    1498,   660,  3049,  3050,  3051,  3052,  3053,   660,  3054,  3067,
    3068,   660,  3069,  3070,  3095,  3816,   911,  1988,  2685,  2685,
    2685,  2685,  2685,  3096,  3135,  3106,  3107,  3139,  1499,  3855,
     913,  3152,  3150,   660,  3153,  1065,  3158,  3159,   920,  3166,
    3168,  3816,  3178,  3182,  3184,  3186,  1634,  3187,   660,  3194,
    3197,  3199,   930, -1992,   911,  3203,  3205,  3216,   950,  1849,
    3215,  3222,  1880,  3225,  1785,  3226,  3234,  2877,  3440,  2858,
    2876,  1844,  3263,  3264,   977,  3276,  3265,  3287,  3296,  3306,
    3288,  1500,  1852,  3311,   628,  2249,  3312,  1853,  3315,    55,
    2249,  3313,  3318,  2249,  3321,  3328,  3330,  1065,  3352, -1992,
    3365,  3331,  1065,  3332,  2380,  1065,  3342,  3343,  2380,  3019,
    1501,  3022, -1992,  3344,  3364,  3366,  3375, -1992,  3367,  3175,
    3391,  3409, -1992,  3402,  3413, -1992,  3415, -1992,  3417,  3424,
    3429,  3437,  3430,  3443,  3444,  3452,  3455,   377,  2747,  3462,
    3033,  3477,  3482,  1065,  3471,  3465,  3484,  2380,  2380,  3474,
    3478,  3489, -1992,  3498,  3486,  3493,  3499,  3524,  3494,  3500,
    3523,  3504,  3553,  3540,  3554,  3557,  1991,  3546,  3563,  2908,
   -1992,   237,    49,  3549,   238,   627,  3572,  3564,  3578,  1065,
      52,    53,    54,    55,  3383,    56,  1065,  1065,  3582,  3059,
    3581,  1445,  3583,  1065,  1065,  3584,  3591,  3593,  1065,  1634,
    3596,  3598,  3601, -1995,  1065,  1065,  3611,  1855,  1065,  3612,
    3605,  3613,  3615,  3617, -1992,  3532,  3626,  3618,  3641,   794,
    3653,  3631, -1992,  3642,  3645,  3646,  3648,  1856,  1857,  3654,
    3529,   628,  3655,   202,  3665,   660,  3681,  1504,  3666,    75,
   -1995,  3673,  3674,  1505,  3685,  3680,  1634,  3162,  3691,  3408,
    1506,  3693,  3699,  3711,  3750,  3147,  1488,  3709,  3712,  3710,
   -1992,  3594,  3751,  3754,  1508,  3759,  3777,  3783,  3033,  1715,
    3758,  3784,  1509,  3787,  3789,  3793,  1860,  3569,  3570,  3794,
    3801,  3806,  3574,   628,   628,   628,  3785,  3804,  3828,  3829,
    1861,  3739,  3847,   628,   628,  3571,  3786,  3859,   628,  3575,
     989,  2708,  1928,   916,  3037,  2379,  2967,  2630,  2672,  2379,
    3568,  3422,   334,  1065,  2605,  3426,  3345,  3201,  1510,  3588,
    3001,  3600,  3432,  2070, -1992,  3802,   377,  3825,  3790,  3788,
    3812,  3427,  2228,  3212,  3614,  3861,  2692,   628,  3848,  3580,
    3137,  3136,  3579,  3085, -1992,  3813,  3624,  3672,  2379,  2379,
    2197,  3675,  3827,   918,  1065, -1995,  1759,  3483,  2813,  3441,
    3715,  2249,   628,  3768, -1992, -1992, -1992,  2560,  3009,  1065,
    2562,  2242,  3445,  1065,  3235,  3749,  3860,  3241,  1634,  3840,
    3246,  3247,  3248,  3249,  3250,  3251,  3252,  3253,  3254,  3255,
    3528,  1398,  3240, -1992,  3695,  2700, -1992, -1992, -1992,    74,
    1065,  2493,   881,  3224,  1065,  1732,  3421,  2971,  1736,  2799,
    3479,  2975,  1966,  2987,  1969,  2505,  1964,  2490,  2937,  3262,
    2760,  3192,  3633,  1065,  1065,  1183,  2972,  1065,  3420,  3279,
    3731,  2405,  3270,  2978,  1065,  1065,  2923,  2921,  3291,  3292,
    1864,  2838,  2817,  2467,  3023,  1032,  3179,  2753,   656,  2243,
    2518,  1977,  1769,  1675,  1065,  1002,  1970,  1868,  1869,  1870,
    1871,  1872,  1873,  2805,  2510,  1478,  1768,  2520,  1065,  2806,
    2962,  3480,  1223,  1461,  3526,  3481,  3314,  1892,  1024,  1974,
    2524,  2801,   628,    80,  2298,  1718,     0,     0,     0,  3180,
       0,     0,     0,  1065,  2353,  2354,     0,     0,   660,   660,
       0,     0,  2366,     0,     0,     0,  2369,  2370,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3713,     0,     0,
    3854,  2390,     0,  2391,     0,     0,     0,     0,     0,  1065,
    1065,     0,     0,   628,     0,     0,     0,     0,     0,     0,
     334,     0,     0,  2412,     0,  2413,     0,     0,  1849,     0,
       0,     0,     0,     0,     0,     0,  1065,  1065,     0,  1065,
       0,  1065,     0,  1850,     0,     0,     0,     0,     0,     0,
    3350,  1852,     0,     0,     0,     0,  1853,     0,     0,     0,
    1634,     0,     0,     0,  1634,  1634,  2380,     0,     0,  2380,
    2380,  2380,  2380,  2380,  2380,  2380,  2380,  2380,  2380,     0,
       0,     0,     0,     0,     0,  3663,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1067,   656,
    1071,     0,   636,     0,  1091,     0,   636,   660,     0,  1065,
     660,     0,   660,  1067,   636,     0,     0,     0,     0,     0,
       0,     0,  3404,     0,     0,     0,     0,  2380,  2380,     0,
       0,  1634,     0,     0,     0,   660,     0,     0,   656,     0,
    1067,     0,   636,     0,     0,  1849,   636,  1159,   660,  3412,
       0,     0,   660,     0,  1067,     0,   636,     0,     0,     0,
    1850,     0,     0,     0,     0,     0,     0,     0,  1852,   660,
    1065,   660,  1854,  1853,     0,     0,  1855,     0,     0,     0,
       0,     0,     0,   660,     0,  1065,   656,     0,     0,   660,
       0,     0,     0,   660,   660,     0,  1856,  1857,   660,     0,
     660,     0,   660,   334,     0,  1067,     0,     0,     0,  1858,
       0,     0,     0,     0,  1885,     0,     0,  3853,     0,     0,
    1849,     0,     0,  1629,  1065,  1065,   660,     0,   660,     0,
       0,     0,     0,     0,   660,     0,     0,   334,  1065,     0,
       0,     0,  1859,  1852,     0,  1860,     0,     0,  1853,     0,
    1065,     0,     0,     0,  3310,   660,     0,   660,     0,  1861,
    1260,  1862,     0,     0,     0,     0,  2586,  2379,     0,     0,
    2379,  2379,  2379,  2379,  2379,  2379,  2379,  2379,  2379,  2379,
    3507,  3508,     0,     0,     0,     0,   660,   656,     0,  1854,
       0,  1384,     0,  1855,     0,     0,     0,     0,     0,     0,
       0,     0,  1769,     0,     0,     0,     0,     0,     0,     0,
    1404,     0,     0,  1856,  1857,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1863,     0,  1858,     0,  2379,  2379,
    2919,  2380,     0,  1629,     0,     0,     0,  1095,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3545,
       0,     0,     0,     0,     0,  2686,     0,     0,     0,  1859,
    2690,  1140,  1860,     0, -1995,   636,   636,     0,  1855,     0,
       0,     0,     0,     0,     0,     0,  1861,   660,  1862,     0,
     660,     0,     0,   660,     0,     0,     0,     0,  1856,  1857,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1995,     0,     0,     0,     0,     0,  1067,  1067,  1864,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1865,  1866,  1867,     0,  1868,  1869,  1870,  1871,
    1872,  1873,     0,     0,   660,  1849,     0,  1860,     0,     0,
       0,  1863,  2899,     0,     0,     0,  1577,     0,     0,     0,
    1850,  1861,     0,     0,     0,     0,     0,     0,  1852,   660,
       0,     0,     0,  1853,     0,   660,     0,  1910,     0,   660,
       0,     0,  1248,     0,     0,     0,   660,  1250,     0,     0,
       0,  3147,     0,     0,  1067,  1067,     0,  3644,  1259,  2380,
    2380,  3647,     0,     0,     0,     0,     0,     0,     0,     0,
    1067,  1577,     0,   660,  1672,     0,     0,     0,     0,     0,
    3657,  3658,     0,     0,     0,     0, -1995,  1250,     0,     0,
       0,     0,     0,     0,     0,     0,  1864,  1067,  1067,     0,
       0,   660,  2379,  1250,     0,     0,     0,     0,  1402,  1865,
    1866,  1867,     0,  1868,  1869,  1870,  1871,  1872,  1873,     0,
       0,  2146,  1416,     0,     0,     0,     0,     0,     0,  1629,
    2147,     0,     0,     0,     0,     0,     0,     0,   660,     0,
       0,     0,     0,     0,     0,     0,     0,   660,   911,  1854,
       0,     0,   660,  1855,     0,     0,     0,   660,     0,     0,
       0,     0,     0,  1629,     0,  1778,     0,     0,   660,     0,
    1783,  1864,     0,  1856,  1857,     0,     0,  1629,     0,     0,
    2072,  1849,     0,     0,     0,     0,  1858,     0,  1868,  1869,
    1870,  1871,  1872,  1873,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1852,     0,     0,     0,     0,  1853,
       0,     0,     0,  3728,  3729,     0,     0,     0,     0,  1859,
       0,     0,  1860,     0,     0,     0,     0,     0,  1629,  2965,
       0,     0,  2073,     0,     0,     0,  1861,     0,  1862,     0,
    2074,  2075,     0,     0,  1575,  1629,     0,     0,     0,     0,
       0,     0,     0,  1769,     0,     0,     0,  1769,  1769,     0,
    2379,  2379,  1629,     0,     0,     0,  2380,     0,     0,     0,
    2380,     0,   656,   656,     0,     0,     0,     0,     0,     0,
       0,  2076,     0,     0,     0,     0,  1384,  1629,     0,  2380,
    2380,  3293,     0,  1926,  1926,  1660,  1662,  1663,     0,     0,
       0,  1863,     0,     0,  1935,     0,  1942,     0,     0,     0,
       0,     0,     0,  1849,     0,     0,     0,     0,     0,     0,
       0,     0,  2077,     0,  2070, -1995,     0,  2078,  1850,  1855,
       0,     0,     0,     0,     0,  1629,  1852,     0,     0,     0,
       0,  1853,     0,     0,     0,     0,  1629,     0,     0,  1856,
    1857,     0,     0,   656,     0,   636,     0,     0,     0,     0,
       0,     0, -1995,     0,  2079,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   660,  1250,     0,     0,     0,     0,
       0,  2080,  2081,     0,  2082,  2083,  1864,  2084,     0,     0,
       0,     0,     0,     0,     0,     0,  1250,     0,  1860,  1865,
    1866,  1867,     0,  1868,  1869,  1870,  1871,  1872,  1873,     0,
       0,     0,  1861,  2409,     0,     0,     0,  2085,     0,     0,
       0,     0,  2380,  2380,     0,     0,     0,     0,     0,  3097,
    1091,  2686,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2086,     0,     0,  1067,  1067,  1067,  1067,  1854,     0,     0,
       0,  1855,     0,     0,     0,   644,     0,  2379,     0,     0,
       0,  2379,   657,  1849,     0,     0,     0, -1995,     0,     0,
       0,  1856,  1857,  1067,  1067,  2087,     0,  2088,  1850,  1067,
    2379,  2379,     0,     0,  1858,     0,  1852,     0,  1629,     0,
       0,  1853,     0,     0,     0,     0,     0,     0,   657,  2089,
       0,     0,     0,     0,     0,     0,  2090,     0,     0,  2091,
       0,     0,     0,     0,     0,   657,   657,  1859,     0,     0,
    1860,  1934,     0,     0,     0,   657,     0,     0,     0,   644,
       0,     0,     0,     0,  1861,     0,  1862,   636,     0,   660,
       0,  1067,  1067,  1067,  1067,     0,     0,     0,     0,   644,
       0,   644,  1864,     0,     0,  1384,     0,  1577,     0,     0,
       0,     0,     0,     0,     0,     0,   657,     0,     0,  1868,
    1869,  1870,  1871,  1872,  1873,     0,     0,     0,   656,     0,
       0,   660,   660,     0,     0,     0,     0,  1091,     0,     0,
     660,   660,     0,   660,     0,  1849,     0,     0,   660,  1863,
     660,     0,     0,  1067,     0,     0,  1067,  1854,     0,     0,
    1850,  1855,     0,  2379,  2379,     0,     0,     0,  1852,     0,
     660,   660,     0,  1853,     0,     0,     0,     0,     0,     0,
       0,  1856,  1857,     0,     0,     0,  1849,     0,     0,     0,
     660,     0,   660,   660,  1858,     0,   660,     0,     0,     0,
       0,  1850,  2318,     0,     0,     0,     0,     0,     0,  1852,
       0,     0,     0,  2120,  1853,     0,     0,     0,     0,     0,
     911,     0,     0,  2342,     0,     0,     0,  1859,     0,     0,
    1860,     0,     0,     0,  1864,     0,     0,     0,  1629,     0,
       0,     0,  1629,  1629,  1861,     0,  1862,  1865,  1866,  1867,
       0,  1868,  1869,  1870,  1871,  1872,  1873,  1091,     0,     0,
       0,  3094,  1849,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1850,     0,     0,
       0,     0,     0,     0,     0,  1852,     0,     0,     0,  1854,
    1853,     0,     0,  1855,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   657,     0,     0,     0,     0,     0,  1863,
       0,     0,     0,  1856,  1857,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1858,   660,     0,     0,
    1854,     0,     0,     0,  1855,     0,     0,     0,     0,     0,
       0,     0,     0,  1629,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1856,  1857,     0,     0,     0,  1859,
       0,     0,  1860,     0,  1629,     0,     0,  1858,     0,     0,
       0,  2277,     0,     0,     0,     0,  1861,  1942,  2280,     0,
       0,     0,     0,  3388,     0,     0,     0,   660,  2686,  2686,
    2686,  2686,  2686,     0,  1864,     0,  3401,     0,     0,     0,
    1859,     0,     0,  1860,     0,     0,  1854,  1865,  1866,  1867,
    1855,  1868,  1869,  1870,  1871,  1872,  1873,  1861,     0,  1862,
       0,  3278,     0,  1250,  1250,     0,     0,     0,     0,     0,
    1856,  1857,     0,     0,     0,  2326,     0,   636,     0,     0,
     660,  1863,     0,  1858,     0,     0,     0,     0,     0,     0,
       0,     0,   636,   660,     0,     0,   636,   656,     0,     0,
       0,   660,     0,     0,     0,     0,     0,   660,     0,     0,
       0,     0,   660,   636,     0,     0,  1859,   636,   660,  1860,
       0,     0,  1863,   660,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1861,     0,  1862,     0,     0,     0,   636,
     660,   636,   660,     0,   660,     0,     0,  2573,  2573,     0,
       0,     0,     0,   660,     0,     0,   657,     0,     0,  1629,
       0,     0,     0,     0,     0,     0,  1864,   660,     0,     0,
       0,   660,     0,     0,   636,   660,   660,   660,     0,  1865,
    1866,  1867,     0,  1868,  1869,  1870,  1871,  1872,  1873,  2466,
    2606,  2607,   660,   660,   660,   660,  2614,     0,  1863,   660,
     660,     0,     0,   660,   660,   660,     0,  1864,   636,   660,
       0,     0,     0,     0,     0,   636,   660,   636,     0,   660,
    1865,  1866,  1867,     0,  1868,  1869,  1870,  1871,  1872,  1873,
       0,     0,  1849,     0,  3324,     0,     0,  1067,  1067,  1067,
    1067,  1067,  1067,     0,     0,     0,     0,     0,     0,     0,
       0,  3536,     0,  2494,     0,  1852,     0,     0,  2687,     0,
    1853,  3543,  3544,     0,     0,     0,  3547,  3548,     0,     0,
       0,     0,     0,     0,     0,     0,  3555,     0,     0,  2573,
       0,     0,     0,  1864,     0,     0,     0,   911,     0,     0,
       0,     0,     0,     0,     0,     0,  1865,  1866,  1867,     0,
    1868,  1869,  1870,  1871,  1872,  1873,     0,  2721,     0,     0,
    3487,     0,  2734,     0,  2740,     0,     0,     0,     0,     0,
    1849,     0,  1672,     0,     0,     0,     0,     0,     0,     0,
    2763,     0,     0,     0,  2763,  2776,     0,     0,     0,     0,
       0,     0,     0,  1852,     0,     0,     0,     0,  1853,  1067,
    2573,  1067,  2573,     0,     0,  1849,     0,   644,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   766,     0,
    1850,     0,     0,     0,     0,     0,  1854,   660,  1852,     0,
    1855,     0,     0,  1853,     0,     0,     0,     0,  1629,  1629,
       0,  1629,     0,   636,     0,     0,  1177,   657,     0,   657,
    1856,  1857,     0,     0,  1629,     0,  1629,     0,     0,     0,
       0,     0,     0,  1858,     0,     0,     0,   660,     0,     0,
     636,     0,   767,     0,     0,     0,     0,     0,     0,     0,
       0,  2623,     0,     0,     0,  1629,     0,     0,   657,   768,
       0,     0,   644,     0,   644,     0,   644,     0,     0,  1860,
       0,     0,   644,   644,     0,     0,     0,     0,     0,     0,
     769,     0,   657,  1861,  1854,     0,     0,     0,  1855,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     644,     0,     0,     0,  1629,     0,     0,     0,  1856,  1857,
       0,   770,  2902,     0,     0,     0,     0,   771,     0,  1854,
       0,  1858,     0,  1855,     0,  1629,     0,   644,     0,     0,
       0,   772,  2707,     0,   657,   657,     0,     0,   644,   644,
       0,  1091,     0,  1856,  1857,     0,     0,     0,  1863,     0,
       0,     0,     0,     0,     0,  1629,  1858,  1860,     0,     0,
    2724,     0,     0,     0,     0,     0,     0,     0,  2745,     0,
    1629,  1861,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1629,  1926,     0,     0,     0,     0,  1859,
    1942,     0,  1860,     0,     0,     0,     0,  1629,     0,   644,
       0,     0,     0,     0,   660,     0,  1861,     0,  1862,     0,
       0,   773,     0,   644,   644,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   636,
     660,   660,  1629,  1864,   774,     0,  1863,  1621,  1629,     0,
       0,     0,     0,  2740,     0,     0,  1865,  1866,  1867,  1849,
    1868,  1869,  1870,  1871,  1872,  1873,   775,     0,     0,     0,
       0,     0,   776,     0,  1850,     0,     0,     0,   777,     0,
       0,  1863,  1852,     0,     0,     0,     0,  1853,     0,     0,
       0,     0,   660,   660,     0,     0,     0,     0,     0,  1629,
       0,     0,     0,     0,     0,   778,   779,     0,     0,     0,
     780,     0,     0,  1067,     0,     0,     0,  1629,   781,     0,
       0,     0,     0,   782,     0,     0,   660,   660,   660,   660,
     644,  1864,   783,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   784,  1629, -1995, -1995,     0,  1868,  1869,
    1870,  1871,  1872,  1873,     0,     0,     0,  1621,     0,   636,
     660,     0,     0,     0,     0,     0,  1864,     0,     0,  2573,
    2573,     0,     0,     0,     0,     0,     0,  1629,     0,  1865,
    1866,  1867,     0,  1868,  1869,  1870,  1871,  1872,  1873,     0,
       0,     0,     0,  3518,  2687,     0,     0,     0,     0,     0,
       0,   644,  2934,  1854,     0,     0,   750,  1855,   660,   660,
     660,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1856,  1857,  1744,
       0,     0,  1748,   660,     0,     0,     0,     0,     0,     0,
    1858,     0,   657,     0,     0,     0,     0,   750,     0,     0,
       0,     0,     0,   660,     0,     0,     0,     0,  1384,     0,
       0,     0,     0,     0,     0,   656,     0,     0,   660,  2763,
       0,     0,  3183,  1859,     0,     0,  1860,     0,     0,     0,
       0,     0,     0,     0,     0,  3196,     0,     0,     0,     0,
    1861,     0,  1862,     0,   940,  1629,     0,     0,     0,     0,
       0,   940,     0,   940,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   750,     0,     0,     0,     0,   636,
       0,     0,  1849,     0,     0,   644,  2318,     0,     0,     0,
       0,     0,     0,     0,     0,   644,     0,     0,     0,     0,
     636,     0,     0,     0,     0,  1852,     0,     0,     0,     0,
    1853,     0,     0,     0,     0,  1863,  1888,     0,     0,     0,
     657,   657,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   644,     0,  1849,   644,     0,     0,
       0,   644,   644,  1621,     0,     0,     0,     0,     0,     0,
       0,  1850,     0,     0,  1629,     0,     0,     0,     0,  1852,
       0,     0,     0,     0,  1853,     0,  1849,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1621,     0,     0,
       0,  1850,     0,     0,     0,     0,     0,     0,     0,  1852,
       0,  1621,  3294,     0,  1853,     0,     0,     0,     0,     0,
    1864,   657,     0,   644,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1865,  1866,  1867,  3141,  1868,  1869,  1870,
    1871,  1872,  1873,     0,     0,  3151, -1995,  3652,     0,     0,
    1855,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1942,  1621,     0,  3167,     0,     0,     0,   644,     0,
    1856,  1857,     0,     0,   644,     0,     0,     0,     0,  1621,
       0,     0,     0, -1995,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2740,  2740,     0,  1621,     0,     0,     0,
    1854,     0,     0,  1849,  1855,     0,     0,     0,     0,     0,
    2876,  3209,     0,  3210,     0,  2877,     0,     0,  3213,  1860,
       0,  1621,     0,     0,  1856,  1857,  1852,  1629,     0,     0,
    1854,  1853,     0,  1861,  1855,   660,     0,  1858,     0,   636,
     660,   636,   660,   660,   660,   660,     0,  1250,     0,     0,
     644,     0,     0,     0,  1856,  1857,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1858,     0,  1621,
    1859,     0,     0,  1860,  1629,     0,     0,     0,     0,     0,
    1621,     0,     0,     0,     0,     0,     0,  1861,     0,  1862,
       0,  2687,  2687,  2687,  2687,  2687,     0,     0, -1995,     0,
    1859,     0,     0,  1860,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   660,     0,     0,  1861,     0,  1862,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   644,     0,     0,     0,  2721,     0,     0,
       0,  2606,   644,     0,  2606,     0,  3428,  1854,     0,     0,
       0,  1855,  1863,  2740,     0,  3303,  3304,     0,     0,  2573,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1856,  1857,  2763,     0,   660,     0,     0,     0,     0,
       0,     0,  1863,  1864,  1858,     0,  2721,     0,  3467,     0,
     660,     0,     0,  1849,  2573,     0,  2573,     0,     0,   657,
    1868,  1869,  1870,  1871,  1872,  1873,  1629,     0,  1850,     0,
       0,   636,     0,  1888,  2301,     0,  1852,  1859,     0,     0,
    1860,  1853,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1621,     0,  1861,     0,     0,  1864,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1865,  1866,  1867,     0,  1868,  1869,  1870,  1871,  1872,  1873,
       0,     0,     0,     0,  3689,   644,   644,  1864,     0,     0,
       0,     0,   644,   644,     0,     0,     0,   644,   644,     0,
    1865,  1866,  1867,     0,  1868,  1869,  1870,  1871,  1872,  1873,
       0,     0,   644,     0,   644,     0,     0,     0,     0,  1863,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1091,
       0,     0,     0,     0,   644,     0,   644,     0,     0,     0,
       0,     0,   636,   660,     0,     0,     0,  3400,     0,     0,
     750,     0,     0,   636,   660,   636,     0,  1854,  1062,     0,
    3556,  1855,  1062,   660,   660,  1067,   660,     0,  1744,     0,
    3410,     0,     0,     0,     0,  2476,     0,     0,     0,     0,
    3414,  1856,  1857,  2301,     0,     0,     0,     0,     0,     0,
    2740,     0,     0,     0,  1858,  1062,     0,     0,     0,   644,
       0,     0,     0,     0,  1864,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1865,  1866,  1867,
       0,  1868,  1869,  1870,  1871,  1872,  1873,  1859,  1629,     0,
    1860,     0,  1629,  1629,     0,     0,     0,     0,     0,     0,
       0,   660,  1623,  1062,  1861,     0,  1862,     0,   660,  1062,
       0,  1849,  1621,     0,  3623,     0,  1621,  1621,     0,     0,
       0,     0,     0,  3627,     0,     0,   660,     0,     0,     0,
       0,     0,     0,     0,  1852,     0,  3467,     0,     0,  1853,
       0,   644,     0,     0,     0,   644,     0,     0,   657,  3428,
       0,     0,     0,     0,     0,   636,   793,     0,     0,  1629,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1863,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3519,
    3520,  3521,  3522,     0,     0,  1062,     0,     0,     0,     0,
     940,  1849,  1623,   940,     0,  1091,     0,  1621,     0,     0,
       0,  3297,     0,     0,     0,     0,  1850,     0,     0,     0,
       0,     0,     0,     0,  1852,     0,  1062,   644,  1621,  1853,
       0,   793,     0,  2740,     0,     0,   644,     0,     0,   644,
     644,     0,     0,     0,  1864, -1995,     0,     0,     0,  1855,
       0,     0,     0,     0,  2573,     0,  2606,  1865,  1866,  1867,
       0,  1868,  1869,  1870,  1871,  1872,  1873,     0,     0,  1856,
    1857,  3766,     0,     0,     0,     0,     0,     0,  1067,  3623,
       0,     0, -1995,  1067,  1067,     0,     0,     0,     0,     0,
       0,     0,   660,     0,   644,     0,     0,     0,     0,     0,
       0,     0,   644,     0,     0,     0,   644,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   644,     0,  1860,     0,
       0,   644,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1861,     0,     0,     0,     0,     0,  1067,  1067,
    1067,  1067,   660,     0,     0,  1854,     0,     0,     0,  1855,
       0,     0,  1062,   750,     0,     0,     0,     0,     0,  1062,
     660,     0,     0,     0,     0,  1062,     0,     0,     0,  1856,
    1857,     0,     0,     0,     0,   644,     0,     0,     0,  3623,
    1067,     0,  1858,  1621,     0,     0,  1632,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1995,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1062,     0,  1859,     0,     0,  1860,   660,
    1067,   644,     0,     0,     0,     0,     0,  1067,  1623,     0,
       0,     0,  1861,     0,  1862,   657,  1744,     0,     0,  2804,
       0,  1748,     0,     0,  1067,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3818,     0,     0,     0,     0,
       0,     0,  1623,     0,     0,     0,     0,     0,     0,  1062,
       0,     0,     0,     0,  3687,     0,  1623,     0,     0,     0,
       0,     0,  1864,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3818,  1250,  1632,  1863,     0,  1868,
    1869,  1870,  1871,  1872,  1873,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3723,  1062,     0,     0,
    3818,     0,     0,     0,     0,     0,     0,  1623,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1062,  1623,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3735,     0,     0,     0,
       0,  1623,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1062,  1062,     0,  1062,     0,     0,     0,
       0,     0,  1864,     0,     0,     0,  1623,     0,     0,     0,
       0,     0,     0,  1062,     0,  1865,  1866,  1867,     0,  1868,
    1869,  1870,  1871,  1872,  1873,     0,     0,  3057,     0,     0,
       0,     0,  1621,  1621,     0,  1621,     0,     0,  2301,     0,
     644,     0,   644,     0,     0,     0,     0,     0,  1621,     0,
    1621,     0,     0,     0,  1623,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1623,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1621,
       0,     0,  1062,     0,     0,  1062,  1062,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1621,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   644,     0,
       0,     0,  1632,     0,     0,     0,   750,     0,     0,  1621,
     940,     0,     0,     0,     0,   644,     0,     0,     0,  1849,
       0,     0,   644,   644,     0,     0,     0,     0,     0,   940,
       0,     0,     0,     0,  1850,     0,  1632,     0,  2498,  1621,
       0,     0,  1852,     0,     0,     0,     0,  1853,     0,     0,
    1632,     0,     0,  1057,  1621,     0,     0,  1057,     0,   793,
       0,     0,     0,     0,   793,   793,     0,  1621,     0,     0,
       0,   793,     0,   644,     0,   644,   644,  1623,     0,     0,
       0,  1621,     0,     0,     0,     0,     0,     0,   793,   644,
    1057,     0,     0,     0,     0,   644,     0,     0,     0,     0,
     644,  1632,   644,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2499,     0,   644,   644,  1621,     0,  1632,     0,
       0,     0,  1621,     0,     0,   644,     0,     0,     0,     0,
       0,     0,     0,   793,     0,  1632,     0,   644,  1057,     0,
       0,   657,     0,     0,  1057,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1632,     0,     0,  1854,   750,   644,   644,  1855,     0,     0,
       0,     0,     0,  1621,     0,     0,   657,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1856,  1857,     0,
       0,  1621,     0,     0,     0,     0,     0,     0,     0,   793,
    1858,     0,     0,  1062,   793,  1062,     0,     0,  1632,     0,
    1062,     0,     0,     0,     0,   793,     0,  1849,  1621,  1632,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1850,  1859,     0,     0,  1860,     0,     0,     0,
    1852,     0,     0,     0,   793,  1853,     0,     0,     0,     0,
    1861,  1621,  1862,     0,     0,     0,     0,     0,     0,     0,
     793,     0,     0,     0,     0,   793,     0,     0,     0,     0,
       0,     0,  1062,     0,     0,     0,     0,  1623,     0,   793,
       0,  1623,  1623,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1062,  1062,     0,     0,
       0,     0,     0,     0,  1062,  1863,     0,  1062,     0,     0,
    1062,     0,     0,   644,     0,     0,     0,     0,  1062,  1062,
       0,     0,     0,     0,     0,     0,  1062,     0,     0,  1062,
    1062,  1062,  1062,     0,     0,     0,     0,  1849,     0,  1062,
    1062,     0,  1062,     0,  1062,     0,     0,  1062,     0,     0,
       0,  1854,  2500,     0,     0,  1855,     0,     0,     0,  1621,
    1852,  1632,  1062,   750,     0,  1853,  1062,     0,     0,     0,
    1062,     0,  1623,     0,  1062,  1856,  1857,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,     0,  1062,  1858,     0,
    1864,   793,  1062,  1623,  1057,     0,  1062,     0,     0,     0,
    1057,     0,     0,  1865,  1866,  1867,     0,  1868,  1869,  1870,
    1871,  1872,  1873,     0,     0,     0,     0,     0,     0,     0,
       0,  1859,     0,     0,  1860,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1861,     0,
    1862,     0,   793,   793,   793,     0,     0,  3516,  1057,     0,
       0,     0,     0,     0,     0,  3271,     0,  1062,  1621,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   644,   644,   644,   644,   644,   644,
       0, -1995,     0,     0,   659,  1855,     0,     0,     0,     0,
       0,     0,     0,   661,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1863,   644,  1856,  1857,     0,     0,   644,
     644,   644,   644,   644,     0,     0,  3272,   644, -1995,     0,
       0,     0,   793,     0,     0,     0,   750,   790,     0,     0,
       0,     0,     0,     0,     0,     0,   841,     0,     0,   845,
       0,  1062,     0,   793,     0,   841,     0,     0,  1623,   898,
       0,     0,     0,     0,  1860,     0,     0,     0,     0,     0,
       0,  1632,     0,     0,     0,  1632,  1632,     0,  1861,     0,
       0,   919,     0,     0,     0,   644,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   841,     0,  1864,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1865,  1866,  1867,     0,  1868,  1869,  1870,  1871,  1872,
    1873,  1621,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2804,     0,     0,     0,     0,     0,
       0,     0,     0, -1995,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1849,     0,     0,     0,     0,  1621,  1062,
       0,     0,     0,     0,     0,     0,  1632,     0,  1850,     0,
       0,  1851,     0,     0,     0,     0,  1852,     0,   793,     0,
       0,  1853,     0,     0,     0,  1062,     0,  1632,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1849,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1850,     0,     0,  2840,     0,     0,  1864,     0,
    1852,  2301,   644,     0,     0,  1853,     0,     0,     0,     0,
       0,     0,   644,     0,     0,  1868,  1869,  1870,  1871,  1872,
    1873,     0,   644,   644,     0,     0,     0,   644,   644,     0,
       0,     0,     0,     0,     0,     0,     0,   644,     0,     0,
    1062,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,     0,     0,  1028,   644,   644,   644,  1623,  1623,     0,
    1623,     0,     0,     0,   644,   644,     0,     0,     0,   644,
    1621,     0,     0,  1623,     0,  1623,     0,  1854,     0,     0,
       0,  1855,  1062,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     793,  1856,  1857,     0,  1623,     0,     0,     0,   644,     0,
       0,  1062,     0,   793,  1858,     0,     0,     0,     0,     0,
       0,  1854,  1632,     0,     0,  1855,     0,     0,     0,     0,
       0,     0,     0,   644,     0,     0,     0,     0,     0,  1062,
    1062,     0,     0,     0,     0,  1856,  1857,  1859,     0,     0,
    1860,     0,     0,  1623,     0,     0,     0,     0,  1858,     0,
       0,     0,     0,     0,  1861,     0,  1862,     0,     0,  1062,
       0,     0,     0,  1062,  1623,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1062,  1062,  1062,  1062,     0,
       0,  1859,     0,   750,  1860,     0,     0,  1062,   750,     0,
       0,     0,  1062,     0,  1623,     0,     0,     0,  1861,     0,
    1862,     0,  1062,  1062,     0,  1062,     0,     0,     0,  1623,
    1849,     0,     0,     0,     0,     0,     0,     0,  1062,  1863,
    1062,     0,  1623,     0,  1062,  1850,     0,     0,  2256,     0,
    1057,     0,     0,  1852,     0,  1057,  1623,     0,  1853,     0,
    1062,     0,     0,   644,     0,     0,     0,     0,   793,     0,
    1062,     0,  1062,  1062,     0,   793,     0,     0,     0,     0,
       0,     0,  1621,  1863,     0,     0,  1621,  1621,     0,     0,
       0,  1623,     0,  1062,     0,     0,     0,  1623,     0,  1062,
       0,     0,     0,     0,     0,     0,     0,     0,  1062,  1062,
    1062,     0,     0,     0,   644,     0,     0,  1057,     0,     0,
     793,   793,     0,     0,  1864,     0,  1036,  1037,     0,     0,
       0,     0,   793,     0,     0,     0,     0,  1865,  1866,  1867,
    1062,  1868,  1869,  1870,  1871,  1872,  1873,     0,  1623,     0,
       0,     0,     0,  1621,     0,     0,     0,     0,     0,     0,
       0,  1632,  1632,     0,  1632,     0,  1623,     0,  1864,     0,
       0,     0,     0,     0,  1854,     0,     0,  1632,  1855,  1632,
       0,  1865,  1866,  1867,     0,  1868,  1869,  1870,  1871,  1872,
    1873,     0,     0,  1623,     0,     0,     0,     0,  1856,  1857,
       0,     0,     0, -1994,     0,     0,     0,     0,  1632,     0,
       0,  1858,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1623,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1624,     0,     0,  1859,     0,   793,  1860,     0, -1994,
       0,     0,     0,     0,     0,  1093,     0,  1632,  1097,     0,
    1099,  1861, -1994,  1862,     0,     0,     0, -1994,     0,     0,
       0,     0, -1994,     0,  2854, -1994,     0, -1994,  1632,     0,
       0,     0,     0,  1143,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   644,     0,     0,  1160,     0,     0,     0,
    1162,     0, -1994,     0,     0,     0,     0,   750,  1632,     0,
     793,     0,     0,     0,     0,     0,     0,  1028,     0,   841,
   -1994,     0,     0,  1632,     0,     0,  1863,     0,     0,     0,
       0,  1186,   644,     0,     0,     0,  1632,     0,     0,     0,
       0,     0,  1204,     0,  1623,     0,  1206,     0,  1209,     0,
    1632,  1624,     0,     0,     0,     0,     0,     0,   644,     0,
       0,     0,     0,     0, -1994,     0,  1062,     0,     0,     0,
    1062,     0, -1994,     0,  1238,     0,  1239,     0,     0,     0,
    1062,     0,  1028,     0,     0,  1632,     0,     0,     0,     0,
       0,  1632,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1257,     0,  1258,     0,     0,     0,  1062,
   -1994,  1864,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1865,  1866,  1867,     0,  1868,  1869,
    1870,  1871,  1872,  1873,  1028,     0,     0,     0,     0,  1062,
       0,     0,  1632,  1623,     0,     0,     0,     0,  1062,     0,
       0,     0,     0,   916,  1062,     0,  1062,     0,     0,     0,
    1632,  1062,     0,     0,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062, -1994,     0,     0,     0,  1062,  1062,
       0,     0,     0,     0,     0,     0,     0,  1632,   793,     0,
       0,     0,  1062,     0, -1994,     0,   750,     0,  1062,     0,
       0,     0,     0,     0,     0,     0,     0,  1062,     0,     0,
    1062,     0,  1062,     0, -1994, -1994, -1994,     0,     0,     0,
    1632,  1062,  1062,  1062,     0,  1472,     0,  1062,  1474,     0,
    1062,  1476,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,     0,     0, -1994,     0,     0, -1994, -1994, -1994,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   793,
       0,     0,     0,     0,     0,     0,     0,  1624,     0,     0,
       0,     0,  1563,     0,     0,     0,    82,     0,     0,     0,
       0,     0,    86,     0,     0,     0,  1623,   793,    92,     0,
      93,     0,    95,     0,     0,   793,     0,  1585,     0,     0,
       0,  1624,   104,  1587,     0,  2256,     0,  1589,     0,     0,
       0,     0,     0,     0,  1635,  1624,     0,     0,     0,   116,
     117,     0,     0,     0,     0,   938,     0,     0,  1632,     0,
       0,     0,   938,  1623,   938,     0,     0,     0,     0,     0,
       0,  1669,     0,     0,     0,     0,   125,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   126,     0,   127,   128,
       0,     0,     0,     0,     0,     0,  1624,  1849,     0,     0,
       0,     0,   988,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1850,  1624,     0,  2885,     0,     0,     0,     0,
    1852,   137,     0,   138,   139,  1853,     0,     0,   141,   142,
    1624,     0,     0,     0,     0,     0,  1738,     0,   143,     0,
     144,     0,     0,     0,     0,     0,  1062,     0,     0,     0,
    1767,     0,     0,     0,   146,  1624,   147,  1632,     0,   150,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,   153,     0,     0,
       0,     0,     0,   154,     0,     0,     0,     0,     0,   156,
       0,   158,     0,     0,     0,  1623,   160,     0,     0,     0,
       0,     0,     0,  1624,     0,     0,     0,   164,  1062,   165,
       0,     0,     0,  1062,  1624,     0,  1062,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,  1854,     0,     0,     0,  1855,     0,     0,     0,   793,
       0,     0,  1849,     0,  1062,  2256,     0,     0,   179,   180,
       0,     0,     0,     0,   181,  1856,  1857,  1850,     0,     0,
       0,     0,     0,   182,     0,  1852,     0,     0,  1858,     0,
    1853,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,   187,     0,     0,     0,     0,     0,  1062,  1062,     0,
       0,     0,     0,     0,  1062,  1062,     0,     0,     0,  1062,
    1632,  1859,     0,     0,  1860,  1062,  1062,     0,     0,  1062,
       0,     0,     0,     0,   197,     0,     0,     0,  1861,     0,
    1862,     0,     0,     0,   199,     0,     0,   200,     0,   201,
       0,     0,     0,     0,   202,     0,     0,     0,     0,   203,
       0,     0,   205,     0,     0,     0,   207,  1632,     0,     0,
       0,     0,   208,     0,     0,     0,  1624,   209,     0,     0,
     211,     0,  2003,     0,     0,     0,     0,   214,     0,     0,
       0,  2890,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1863,     0,     0,  1854,  1623,     0,     0,
    1855,  1623,  1623,     0,     0,     0,   220,     0,   221,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
    1856,  1857,     0,   226,  1062,     0,     0,     0,  1849,     0,
       0,     0,     0,  1858,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1850,     0,     0,  2894,     0,     0,     0,
       0,  1852,     0,     0,     0,     0,  1853,     0,     0,     0,
       0,     0,     0,     0,     0,  1062,  1859,     0,  1623,  1860,
    1117,     0,     0,     0,     0,     0,     0,     0,  1864,     0,
    1062,     0,   239,  1861,  1062,  1862,     0,     0,     0,  1632,
       0,  1865,  1866,  1867,     0,  1868,  1869,  1870,  1871,  1872,
    1873,     0,  1118,   793,     0,     0,     0,     0,     0,     0,
       0,  1062,   793,     0,  1119,  1062,     0,     0,     0,     0,
       0,     0,     0,     0,  1120,     0,     0,     0,     0,     0,
       0,   793,     0,     0,  1062,  1062,     0,     0,  1062,     0,
       0,  1121,     0,     0,     0,  1062,  1062,  2214,  1863,     0,
       0,  2256,     0,     0,     0,  2256,     0,     0,     0,     0,
       0,     0,  1122,     0,     0,  1062,  1624,     0,     0,     0,
    1624,  1624,  1854,     0,     0,     0,  1855,     0,   793,  1062,
     793,     0,     0,     0,     0,   793,     0,     0,  1849,     0,
    2267,     0,     0,  1123,  1057,     0,  1856,  1857,     0,  2276,
       0,  2278,     0,  1850,  1062,     0,  2279,     0,     0,  1858,
       0,  1852,     0,  1124,   793,     0,  1853,     0,     0,  1059,
       0,     0,     0,  1059,     0,     0,     0,     0,  2294,   841,
       0,     0,     0,  1864,     0,     0,     0,  1125,     0,     0,
    1062,  1062,  1859,     0,     0,  1860,  1865,  1866,  1867,     0,
    1868,  1869,  1870,  1871,  1872,  1873,  1059,     0,     0,  1861,
       0,  1862,     0,     0,     0,     0,     0,  1062,  1062,     0,
    1062,  1624,  1062,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1632,  1624,  1126,     0,  1632,  1632,     0,     0,     0,
       0,     0,     0,     0,  1059,     0,     0,     0,     0,     0,
    1059,     0,     0,     0,     0,     0,   774,     0,  1849,     0,
       0,     0,   793,   793,  1863,     0,     0,     0,     0,     0,
       0,     0,  1854,  1850,     0,     0,  1855,     0,  1127,     0,
    1062,  1852,  1128,     0,  1129,     0,  1853,     0,     0,     0,
    1130,     0,     0,     0,     0,     0,  1856,  1857,     0,     0,
       0,     0,  1632,     0,     0,     0,     0,     0,     0,  1858,
       0,     0,     0,     0,     0,     0,     0,  1131,  1132,     0,
       0,     0,  1133,     0,     0,  2475,     0,     0,     0,     0,
    1134,     0,     0,     0,     0,  1135,     0,     0,     0,     0,
       0,  1062,  1859,     0,     0,  1860,  1059,     0,     0,  1864,
       0,   938,     0,     0,   938,  1136,  1062,     0,     0,  1861,
       0,  1862,  1865,  1866,  1867,     0,  1868,  1869,  1870,  1871,
    1872,  1873,     0,     0,     0,     0,     0,  1059,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1624,     0,     0,
       0,     0,     0,     0,     0,  1062,  1062,     0,     0,     0,
       0,     0,  1854,     0,     0,     0,  1855,     0,     0,  1062,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1062,     0,     0,  1863,     0,  1856,  1857,     0,     0,
       0,     0,     0,     0,   793,     0,     0,     0,  1028,  1858,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3232,
       0,  2532,     0,     0,     0,     0,     0,   793,     0,  2539,
       0,     0,     0,     0,     0,  2543,     0,   793,     0,     0,
    2547,     0,  1859,     0,     0,  1860,  2553,     0,     0,     0,
       0,  2555,     0,     0,     0,     0,     0,     0,     0,  1861,
       0,  1862,     0,     0,     0,     0,     0,     0,     0,     0,
    2569,     0,  2570,  1059,     0,     0,     0,     0,     0,  1864,
    1059,     0,     0,  2256,     0,     0,  1059,     0,  2256,     0,
       0,  2256,  1865,  1866,  1867,     0,  1868,  1869,  1870,  1871,
    1872,  1873,     0,  2591,  2592,  2593,     0,  1630,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2608,  2609,  2612,  2613,  1863,     0,     0,  2619,  2622,     0,
       0,  2624,  2625,  2626,  1059,     0,     0,  2632,     0,     0,
       0,     0,     0,     0,  2645,     0,     0,  2647,     0,   851,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   852,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   853,     0,     0,     0,     0,  1624,  1624,     0,  1624,
    1059,     0,     0,     0,     0,     0,   793,   793,   793,   793,
       0,     0,  1624,   854,  1624,     0,     0,     0,     0,  1864,
       0,     0,     0,     0,     0,     0,     0,  1630,     0,     0,
     855,     0,  1865,  1866,  1867,     0,  1868,  1869,  1870,  1871,
    1872,  1873,     0,  1624,     0,     0,     0,     0,  1059,     0,
       0,   856,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   803,
       0,     0,     0,     0,  1059,     0,     0,     0,   643,     0,
       0,   804,   857,     0,     0,     0,     0,     0,   858,     0,
       0,     0,  1624,     0,     0,     0,     0,     0,     0,     0,
       0,   805,   859,     0,  1059,  1059,     0,  1059,     0,     0,
       0,     0,     0,  1624,     0,  1028,     0,     0,     0,     0,
     806,     0,     0,  -513,  1059,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     807,     0,     0,  1624,     0,     0,   808,     0,     0,     0,
    1057,     0,   902,     0,     0,  2826,     0,     0,  1624,     0,
       0,   809,     0,     0,     0,     0,     0,     0,     0,  2256,
       0,  1624,   643,     0,   902,     0,     0,     0,     0,     0,
       0,     0,   860,     0,     0,  1624,     0,     0,     0,     0,
     861,     0,  -667,  1059,   810,     0,  1059,  1059,   811,     0,
       0,     0,     0,     0,     0,   774,     0,     0,     0,     0,
       0,     0,  -647,     0,     0,     0,     0,     0,     0,     0,
    1624,     0,     0,     0,     0,     0,  1624,   862,     0,     0,
       0,   863,     0,   864,     0,  -424,     0,     0,     0,   865,
       0,     0,     0,     0,     0,     0,   812,     0,     0,     0,
    1057,     0,     0,  1630,     0,     0,     0,     0,     0,     0,
       0,   938,     0,     0,     0,     0,   866,   867,     0,     0,
       0,   868,     0,     0,     0,     0,     0,  1624,     0,   869,
     938,     0,     0,     0,   870,     0,     0,  1630,     0,  1057,
       0,   793,   813,   871,   814,  1624,     0,     0,     0,     0,
       0,  1630,     0,     0,   872,     0,     0,     0,     0,     0,
       0,     0,   793,     0,     0,  -424,     0,     0,     0,     0,
       0,     0,  1624,     0,     0,  1057,     0,     0,     0,     0,
       0,     0,     0,   793,     0,     0,     0,   815,     0,     0,
       0,  -667,     0,   816,     0,     0,     0,     0,  2997,  2998,
       0,     0,  1630,     0,     0,  1624,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1630,
       0,     0,     0,   793,     0,     0,     0,   817,   818,     0,
     819,   820,     0,     0,     0,     0,  1630,     0,     0,   821,
       0,     0,     0,   822,   823,     0,     0,     0,   824,     0,
       0,     0,     0,   825,     0,     0,     0,     0,     0,     0,
       0,  1630,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1057,     0,     0,     0,     0,
       0,     0,     0,     0,  3040,  3041,  3042,  3043,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1059,     0,  1059,     0,     0,  1630,
       0,  1059,     0,     0,     0,     0,     0,     0,  3056,     0,
    1630,     0,     0,  1624,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1057,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1057,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3117,  3119,  3121,     0,
       0,     0,     0,  1059,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
    1057,   841,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1057,     0,     0,  1059,  1059,     0,
       0,  3165,     0,     0,     0,  1059,  1057,     0,  1059,     0,
       0,  1059,  1624,     0,     0,     0,   841,     0,     0,  1059,
    1059,     0,     0,     0,     0,     0,     0,  1059,     0,     0,
    1059,  1059,  1059,  1059,     0,     0,     0,     0,     0,     0,
    1059,  1059,     0,  1059,     0,  1059,     0,     0,  1059,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1630,  1059,     0,     0,     0,  1059,     0,     0,
       0,  1059,     0,     0,     0,  1059,     0,     0,  1059,  1059,
    1059,  1059,  1059,  1059,  1059,  1059,  1059,     0,  1059,     0,
       0,     0,     0,  1059,     0,     0,     0,  1059,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   899,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1059,   899,
       0,     0,     0,     0,     0,  1624,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1624,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     643,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1059,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1630,     0,     0,     0,  1630,  1630,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3351,     0,     0,     0,     0,  3358,     0,
    3360,  3361,  3362,  3363,     0,   902,     0,   902,     0,   902,
       0,     0,     0,     0,     0,   902,   902,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1624,     0,     0,     0,     0,     0,
       0,     0,     0,   643,     0,     0,     0,     0,     0,     0,
    1059,     0,     0,     0,     0,     0,     0,  1630,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     643,     0,  3403,     0,     0,     0,  1059,     0,  1630,     0,
       0,   643,   643,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1450,     0,     0,     0,     0,     0,  3470,     0,
       0,  1059,     0,     0,     0,     0,   643,   643,     0,     0,
    1450,  1059,     0,     0,     0,     0,     0,  1626,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1059,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1059,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1630,     0,     0,  1624,     0,     0,     0,
    1624,  1624,     0,     0,     0,     0,     0,     0,  1627,     0,
    1059,  1059,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   643,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1626,     0,     0,
    1059,  3542,     0,     0,  1059,     0,     0,     0,     0,     0,
       0,     0,  3551,     0,     0,     0,  1059,  1059,  1059,  1059,
       0,     0,     0,     0,     0,     0,     0,  1624,  1059,     0,
       0,     0,     0,  1059,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1059,  1059,     0,  1059,     0,     0,     0,
       0,     0,     0,     0,   643,     0,     0,     0,     0,  1059,
       0,  1059,     0,     0,     0,  1059,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1627,     0,
       0,  1059,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1059,     0,  1059,  1059,     0,     0,     0,     0,  3610,
       0,     0,     0,     0,     0,     0,  3165,     0,     0,     0,
       0,     0,     0,     0,  1059,     0,     0,     0,     0,     0,
    1059,     0,     0,     0,     0,     0,     0,     0,     0,  1059,
    1059,  1059,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1059,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   643,     0,
       0,     0,  1630,  1630,     0,  1630,     0,     0,   643,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1630,     0,
    1630,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1626,     0,     0,     0,   643,     0,  1630,
    1450,     0,     0,     0,  1450,  1450,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1626,     0,     0,
       0,     0,     0,    73,     0,     0,     0,     0,     0,     0,
     899,  1626,   899,     0,   899,     0,     0,     0,  1630,     0,
     899,   899,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   643,     0,     0,  1630,
       0,     0,     0,     0,  1627,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1626,     0,     0,     0,     0,     0,     0,  1630,
       0,     0,     0,     0,     0,     0,     0,     0,  1627,  1626,
       0,  1450,     0,     0,  1630,     0,     0,  1450,     0,     0,
       0,     0,  1627,     0,     0,     0,  1626,  1630,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3761,     0,
       0,  1630,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1626,     0,     0,     0,     0,     0,  1059,     0,     0,
       0,  1059,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1059,     0,  1627,     0,     0,  1630,  1446,     0,     0,
       0,     0,  1630,     0,     0,     0,     0,     0,     0,     0,
    1627,     0,     0,  1450,     0,  1446,     0,  3791,     0,  1626,
    1059,     0,     0,     0,     0,     0,     0,  1627,     0,     0,
    1626,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1059,     0,  1627,  1630,     0,     0,     0,     0,     0,  1059,
       0,     0,     0,     0,     0,  1059,     0,  1059,     0,     0,
       0,  1630,  1059,     0,     0,  1059,  1059,  1059,  1059,  1059,
    1059,  1059,  1059,  1059,  1059,     0,     0,     0,     0,  1059,
    1059,     0,     0,     0,     0,     0,   643,     0,  1630,     0,
    1627,     0,     0,  1059,     0,   902,     0,     0,     0,  1059,
       0,  1627,     0,     0,     0,     0,     0,     0,  1059,     0,
       0,  1059,     0,  1059,     0,     0,     0,     0,     0,     0,
       0,  1630,  1059,  1059,  1059,     0,     0,     0,  1059,     0,
       0,  1059,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1059,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1626,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,    73,     0,    73,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   902,   902,
       0,     0,     0,     0,     0,   643,   902,     0,     0,     0,
     902,   902,     0,     0,     0,     0,     0,     0,     0,  1630,
       0,     0,     0,     0,     0,   902,     0,   902,     0,     0,
       0,     0,     0,  1627,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   902,     0,   902,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1059,     0,     0,
       0,     0,   643,     0,     0,     0,     0,     0,  1630,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1446,     0,     0,     0,  1446,
    1446,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1626,     0,     0,     0,  1626,  1626,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1059,
       0,     0,     0,     0,  1059,     0,     0,  1059,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1990,     0,  1450,     0,     0,     0,   643,     0,
       0,     0,  1450,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1059,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1627,     0,     0,     0,  1627,  1627,     0,
       0,     0,     0,     0,     0,     0,  1446,     0,     0,     0,
       0,  1059,  1446,     0,     0,     0,     0,  1626,  1059,  1059,
       0,     0,     0,     0,     0,  1059,  1059,     0,     0,     0,
    1059,  1630,     0,     0,     0,     0,  1059,  1059,  1626,     0,
    1059,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     902,     0,     0,     0,     0,     0,     0,     0,     0,  1450,
       0,     0,  1450,  1450,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1630,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1446,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1627,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   643,     0,  1627,
       0,     0,     0,     0,     0,   643,     0,     0,     0,   643,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   902,
       0,     0,     0,     0,   902,  1059,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     899,     0,     0,     0,     0,     0,  1059,     0,     0,     0,
       0,     0,     0,  1626,     0,     0,     0,     0,   643,     0,
       0,  1059,     0,     0,     0,  1059,     0,     0,     0,     0,
    1630,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,     0,     0,     0,    73,
       0,     0,  1059,     0,     0,     0,  1059,     0,     0,     0,
       0,     0,     0,     0,   643,     0,     0,     0,     0,     0,
       0,     0,  2299,     0,     0,  1059,  1059,     0,     0,  1059,
       0,     0,     0,     0,     0,     0,  1059,  1059,     0,     0,
       0,     0,     0,     0,  1627,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1059,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1059,     0,     0,   899,   899,     0,     0,     0,     0,     0,
       0,   899,     0,     0,     0,   899,   899,     0,     0,     0,
       0,     0,     0,     0,     0,  1059,     0,     0,     0,     0,
     899,     0,   899,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   899,     0,   899,     0,     0,     0,     0,     0,
       0,  1059,  1059,     0,     0,     0,     0,  1063,     0,     0,
       0,  1063,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1059,  1059,
       0,  1059,     0,  1059,     0,     0,     0,     0,     0,     0,
       0,  2299,     0,     0,  1063,     0,     0,     0,     0,     0,
       0,     0,  1630,     0,     0,     0,  1630,  1630,     0,     0,
       0,     0,  1626,  1626,     0,  1626,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1626,     0,
    1626,     0,     0,   902,     0,  1450,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,     0,     0,     0,  1063,     0,
       0,  1059,     0,     0,     0,     0,     0,     0,     0,  1626,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1630,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1446,
       0,     0,     0,  1627,  1627,     0,  1627,  1446,     0,    73,
       0,    73,     0,     0,     0,     0,     0,     0,  1626,  1627,
       0,  1627,  1059,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1059,     0,  1626,
       0,   902,     0,     0,     0,     0,     0,     0,     0,     0,
    1627,     0,     0,     0,  1063,     0,     0,     0,  1450,     0,
       0,     0,     0,     0,     0,  1450,  1450,     0,     0,  1626,
       0,     0,     0,     0,     0,     0,  1059,  1059,     0,     0,
       0,     0,     0,     0,  1626,  1063,     0,     0,     0,     0,
    1059,     0,     0,     0,     0,   899,     0,  1626,     0,  1627,
       0,     0,  1059,     0,  1446,     0,     0,  1446,  1446,     0,
       0,  1626,     0,     0,     0,     0,   643,     0,   643,   643,
    1627,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   643,     0,     0,     0,     0,     0,  1450,     0,
       0,     0,     0,   902,     0,   902,  1626,     0,     0,     0,
    1627,     0,  1626,     0,     0,     0,     0,  3113,   643,     0,
       0,     0,     0,     0,     0,  1627,     0,     0,  1450,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1627,     0,
     643,     0,     0,     0,   899,     0,     0,     0,     0,   899,
       0,     0,  1627,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1626,     0,     0,     0,     0,   643,   643,
       0,  1063,     0,     0,     0,     0,     0,     0,  1063,     0,
       0,  1626,     0,     0,  1063,     0,     0,  1627,     0,     0,
       0,     0,     0,  1627,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1633,     0,     0,  1626,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
       0,  1626,     0,     0,  1627,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1627,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1063,  1627,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1633,     0,     0,     0,     0,
       0,     0,  1627,     0,     0,     0,   643,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1063,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1626,
       0,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,  1063,     0,  1063,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1627,     0,     0,     0,     0,     0,  2299,     0,   899,     0,
    1446,     0,     0,     0,     0,     0,     0,     0,  1626,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1063,     0,     0,  1063,  1063,     0,   643,   643,   643,
     643,   643,   643,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   902,     0,     0,
       0,     0,   902,   902,   902,   902,   902,     0,     0,     0,
     902,     0,     0,     0,     0,     0,     0,     0,     0,  1627,
       0,  1633,     0,     0,     0,     0,   899,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1446,     0,     0,     0,     0,     0,     0,
    1446,  1446,     0,     0,     0,  1633,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   643,  1633,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1626,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1633,     0,     0,  1446,     0,     0,     0,     0,   899,     0,
     899,     0,     0,     0,     0,     0,     0,  1633,  1626,     0,
       0,     0,  3110,     0,     0,     0,     0,     0,  1628,     0,
       0,     0,     0,  1446,  1633,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1627,     0,     0,     0,     0,     0,     0,  1633,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1631,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   643,     0,     0,     0,  1627,
       0,     0,  1063,     0,  1063,   902,     0,  1633,     0,  1063,
       0,     0,     0,     0,     0,   902,   902,     0,  1633,     0,
     902,   902,     0,     0,     0,     0,     0,     0,     0,     0,
     902,     0,     0,     0,     0,     0,     0,     0,  1628,     0,
       0,     0,     0,     0,     0,     0,     0,   643,   643,   643,
    1626,     0,     0,     0,     0,     0,     0,   643,   643,     0,
       0,     0,   643,     0,     0,     0,     0,     0,     0,     0,
       0,  1063,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1631,     0,     0,     0,     0,     0,
       0,   643,     0,     0,     0,  1063,  1063,     0,     0,     0,
       0,     0,     0,  1063,     0,     0,  1063,     0,     0,  1063,
       0,     0,     0,     0,     0,     0,   643,  1063,  1063,     0,
       0,  1627,     0,     0,     0,  1063,     0,     0,  1063,  1063,
    1063,  1063,     0,     0,     0,     0,     0,     0,  1063,  1063,
       0,  1063,     0,  1063,     0,     0,  1063,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1633,  1063,     0,     0,     0,  1063,     0,     0,     0,  1063,
       0,     0,     0,  1063,     0,     0,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,     0,  1063,     0,     0,     0,
       0,  1063,     0,     0,     0,  1063,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   643,     0,     0,     0,
       0,     0,  1626,     0,     0,     0,  1626,  1626,     0,     0,
       0,     0,     0,     0,  1628,     0,  1063,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   643,  1628,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1628,     0,     0,  1990,     0,     0,     0,     0,
    1631,     0,   899,  1626,     0,     0,     0,   899,   899,   899,
     899,   899,     0,  1627,     0,   899,     0,  1627,  1627,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1063,     0,     0,     0,  2057,     0,     0,     0,     0,     0,
       0,     0,     0,  1628,     0,     0,     0,     0,  1631,     0,
    1633,     0,     0,     0,  1633,  1633,     0,     0,     0,     0,
    1628,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1628,     0,  1347,
       0,     0,     0,     0,  1627,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1631,
       0,     0,  1628,     0,     0,     0,     0,     0,     0,     0,
    1410,     0,     0,     0,     0,     0,  1631,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1631,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1063,     0,
    1628,     0,     0,     0,     0,  1633,     0,     0,  1631,     0,
       0,  1628,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1063,     0,  1633,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1631,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1631,     0,  2299,
       0,     0,     0,     0,     0,     0,     0,     0,    73,     0,
     899,     0,     0,     0,     0,     0,  1570,     0,     0,     0,
     899,   899,     0,     0,     0,   899,   899,     0,     0,  1063,
       0,     0,     0,     0,     0,   899,     0,     0,     0,  1063,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1063,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1628,     0,     0,     0,     0,     0,     0,
    1063,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1633,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1063,  1063,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1631,
       0,     0,     0,     0,     0,     0,     0,     0,  1063,     0,
       0,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1063,  1063,  1063,  1063,     0,     0,
       0,  1790,     0,     0,     0,     0,  1063,     0,     0,     0,
       0,  1063,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1063,  1063,     0,  1063,     0,     0,  1813,     0,     0,
       0,     0,     0,     0,  3662,     0,     0,  1063,     0,  1063,
       0,     0,     0,  1063,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1837,  1838,  1063,
    1841,     0,     0,     0,     0,     0,     0,     0,     0,  1063,
       0,  1063,  1063,     0,     0,     0,     0,  1878,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,     0,     0,     0,  1063,     0,
       0,     0,     0,     0,     0,     0,     0,  1063,  1063,  1063,
       0,     0,     0,  1628,     0,     0,     0,  1628,  1628,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1063,
       0,     0,     0,     0,     0,     0,  1954,     0,     0,  1961,
    1963,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1633,  1633,     0,  1633,     0,     0,     0,     0,     0,  2557,
       0,     0,     0,  2057,  2564,     0,  1633,     0,  1633,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1633,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1628,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1628,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1633,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1631,     0,     0,  1633,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1631,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1633,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1633,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1633,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1633,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1063,     0,     0,     0,  1063,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1063,
       0,     0,     0,     0,  1633,     0,     0,     0,     0,     0,
    1633,     0,     0,     0,  1628,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1063,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1063,     0,
       0,  1633,     0,     0,     0,     0,     0,  1063,     0,     0,
    1631,     0,     0,  1063,     0,  1063,     0,     0,     0,  1633,
    1063,     0,     0,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,     0,     0,     0,     0,  1063,  1063,     0,
       0,     0,     0,     0,     0,     0,  1633,     0,     0,     0,
       0,  1063,     0,     0,     0,     0,     0,  1063,     0,     0,
       0,     0,     0,     0,     0,     0,  1063,     0,     0,  1063,
       0,  1063,     0,     0,     0,     0,     0,     0,  2351,  1633,
    1063,  1063,  1063,     0,     0,     0,  1063,     0,     0,  1063,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1063,
    2373,     0,     0,  2375,     0,     0,  2385,     0,     0,     0,
       0,     0,     0,  2392,  2397,     0,     0,     0,  2402,     0,
       0,  2407,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2416,     0,     0,     0,
    2422,     0,     0,     0,  2434,     0,     0,     0,  2441,     0,
       0,  2443,  2444,  2445,  2446,  2447,  2448,  2449,  2450,  2451,
       0,  2452,     0,     0,     0,     0,  1347,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1628,  1628,     0,  1628,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1633,     0,  1628,
       0,  1628,     0,     0,     0,     0,     0,     0,     0,  1875,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1628,  1410,     0,     0,     0,     0,     0,     0,     0,  2057,
    2564,     0,  2564,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1631,     0,  1631,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1875,     0,     0,     0,     0,     0,     0,  1628,
       0,     0,     0,     0,     0,  1063,  1631,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1633,     0,     0,     0,
    1628,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2545,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1628,     0,     0,     0,     0,  1631,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1628,     0,  1063,     0,     0,
       0,     0,  1063,     0,     0,  1063,  2564,     0,  1628,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1628,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2564,     0,     0,     0,
       0,     0,     0,  1063,     0,     0,     0,     0,     0,     0,
       0,  1631,     0,     0,     0,     0,     0,  1628,     0,     0,
       0,     0,     0,  1628,  1631,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2564,  1063,
       0,     0,  1875,  2653,     0,     0,  1063,  1063,     0,     0,
       0,     0,     0,  1063,  1063,     0,     0,     0,  1063,  1633,
       0,     0,     0,     0,  1063,  1063,     0,     0,  1063,  2677,
       0,     0,     0,  1631,  1628,     0,     0,     0,     0,  1631,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1628,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1633,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1628,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1631,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1631,     0,
       0,     0,  1628,     0,  2780,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1063,     0,  1631,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2797,     0,     0,     0,
       0,     0,     0,     0,     0,  1875,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1631,     0,
       0,     0,     0,     0,  1063,  1347,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1063,
       0,     0,     0,  1063,     0,     0,     0,     0,  1633,     0,
       0,     0,     0,     0,  2836,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1063,     0,  1875,     0,  1063,     0,     0,     0,     0,     0,
    1628,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1063,  1063,  1875,     0,  1063,     0,  2397,
    2381,  2397,  2397,     0,  1063,  1063,     0,     0,     0,     0,
       0,  2897,     0,     0,     0,     0,  2901,     0,     0,  1875,
    1875,     0,     0,  1875,  1063,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1631,     0,  1063,     0,
       0,     0,  2922,     0,  2924,     0,     0,     0,  2927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1875,     0,     0,  1063,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1628,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1410,     0,  1063,
    1063,     0,     0,  1954,     0,     0,     0,     0,     0,     0,
       0,     0,  1963,  1963,  1961,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1063,  1063,     0,  1063,
       0,  1063,     0,     0,     0,  1631,  1875,     0,     0,     0,
       0,     0,     0,  1875,  3000,  1875,     0,     0,     0,     0,
    1633,     0,     0,     0,  1633,  1633,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1063,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1633,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1628,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1063,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1063,     0,     0,     0,  1628,
       0,     0,     0,     0,     0,     0,     0,     0,  1631,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1063,  1063,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1063,     4,
       0,     0,     0,     0,     0,  1631,     0,     0,     0,     0,
    1063,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     7,     0,     0,     0,     0,     8,     0,     9,    10,
       0,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1628,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,     0,
       0,     0,     0,  3233,     0,     0,     0,     0,     0,     0,
       0,     0,  3236,     0,     0,     0,     0,     0,  3237,     0,
    3238,     0,     0,     0,     0,     0,     0,  1631,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3256,  3257,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2402,     0,     0,    36,     0,     0,     0,     0,
       0,  3281,     0,     0,  3284,     0,  3286,     0,     0,    37,
       0,     0,     0,     0,     0,  3290,     0,     0,     0,     0,
       0,  3295,     0,  1875,  3298,     0,     0,     0,    38,     0,
       0,     0,     0,     0,  3305,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1875,     0,  1875,    39,  2381,
    2872,     0,     0,  2381,     0,     0,     0,  1875,     0,     0,
       0,     0,     0,     0,  1875,     0,     0,     0,     0,  1875,
       0,     0,     0,     0,  1875,     0,     0,     0,     0,  1875,
      40,     0,     0,    41,     0,     0,     0,     0,  1875,     0,
       0,     0,  2381,  2381,  1875,     0,     0,     0,     0,     0,
       0,     0,     0,  1628,     0,    42,  1875,  1628,  1628,     0,
       0,     0,     0,  1875,     0,  1875,  1875,  1875,  1875,  1875,
    1875,  1875,  1875,  1875,  1875,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1631,
       0,     0,     0,  1631,  1631,     0,     0,     0,     0,     0,
       0,    43,     0,     0,  1628,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      44,     0,     0,     0,     0,     0,     0,  1875,     0,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
    1631,     0,     0,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
       0,     0,     0,     0,     0,    48,    49,     0,    50,     0,
      51,     0,     0,     0,    52,    53,    54,    55,     0,    56,
      57,     0,     0,     0,    58,    59,    60,    61,    62,     0,
       0,    63,    64,    65,    66,     0,    67,    68,    69,     0,
      70,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1875,     0,     0,  3485,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1875,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3501,  3503,     4,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3509,     0,     0,     0,     0,     0,  3514,
    3515,     0,     0,  3517,     5,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     0,     0,     0,     0,
       0,     0,     9,    10,     0,     0,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1875,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1875,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3586,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1875,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2872,
       0,  2381,     0,     0,  2381,  2381,  2381,  2381,  2381,  2381,
    2381,  2381,  2381,  2381,     0,  2872,     0,     0,     0,    36,
       0,     0,     0,     0,  3630,     0,     0,     0,     0,     0,
       0,     0,     0,    37,     0,     0,     0,     0,     0,  1875,
       0,     0,     0,  1875,     0,     0,     0,     0,  2872,  2872,
       0,     0,    38,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2381,  2381,  1875,     0,  1875,     0,     0,  1875,
       0,     0,    39,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3659,     0,     0,     0,     0,     0,     0,     0,
    3661,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    40,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3676,     0,     0,     0,     0,     0,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1875,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3716,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2402,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,  2381,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,    50,     0,     0,     0,     0,     0,    52,    53,
      54,    55,     0,    56,    57,     0,     0,     0,    58,    59,
      60,    61,    62,     0,     0,    63,    64,  1216,     0,     0,
       0,  1217,     0,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1875,     0,     0,  1875,  1875,
    1875,     0,     0,  2872,     0,     0,     0,     0,  2872,  2872,
    2872,  2872,  2872,  2872,  2872,  2872,  2872,  2872,  1875,  1875,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     4,     0,     0,
       0,     0,     0,  1875,  2381,  2381,  1875,     0,  1875,     0,
       0,     0,  1875,  2872,  2872,     0,     0,  1875,     5,     0,
    1875,     0,     0,     0,     0,     0,     0,  1875,     6,     7,
       0,     0,     0,     0,     0,     0,     9,    10,     0,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     4,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     5,    35,     0,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     0,     0,     0,
       0,     0,     0,     9,    10,     0,  2872,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,     0,     0,
       0,     0,     0,    35,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    38,  1875,     0,     0,
       0,  2381,     0,     0,     0,  2381,     0,     0,     0,     0,
       0,     0,     0,  1875,     0,  1875,    39,     0,     0,  2872,
    2872,  1875,     0,     0,  2381,  2381,  1875,  1875,     0,  1875,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    40,     0,
      36,    41,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,     0,     0,     0,
       0,     0,     0,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    38,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1875,     0,
       0,     0,     0,    39,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    40,     0,     0,    41,    43,
       0,     0,  1875,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2872,  2381,  2381,  2872,
      42,     0,     0,     0,     0,     0,     0,     0,     0,  2872,
    2872,  1875,     0,  1875,     0,     0,     0,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1875,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    43,     0,  1875,     0,
       0,     0,     0,    48,    49,     0,    50,     0,     0,     0,
    2872,  2872,    52,    53,    54,    55,     0,    56,    57,     0,
       0,     0,    58,    59,    60,    61,    62,     0,     0,    63,
      64,  1216,  1717,     0,     0,    44,     0,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,     0,     0,     0,     0,
      48,    49,     0,    50,     0,     0,     0,     0,     0,    52,
      53,    54,    55,     4,    56,    57,     0,     0,     0,    58,
      59,    60,    61,    62,     0,     0,    63,    64,  1216,  2286,
       0,     0,     0,     0,     5,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     0,     0,     0,     0,
       0,     0,     9,    10,     0,     0,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    38,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    40,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,    50,     0,     0,     0,     0,     0,    52,    53,
      54,    55,     0,    56,    57,     0,     0,     0,    58,    59,
      60,    61,    62,     0,     0,    63,    64,  1216,     0,     0,
       0,     0,     0,     0,     0,    71,   662,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   663,   102,   103,
     388,   664,     0,   105,   106,   107,   108,   665,   666,     0,
     110,   111,   112,     0,   113,   667,   668,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,   669,   406,   407,   408,   670,   671,   672,   673,
     674,   675,   676,   409,   410,   677,   411,   130,   412,   413,
     414,   132,   133,   134,   135,     0,   678,   415,   416,     0,
     417,   418,   679,   680,   419,   681,   136,   421,   682,   422,
     423,   424,   425,   140,   683,   684,   426,   427,   428,   429,
     430,   431,   685,   432,   433,   434,   435,   436,   686,   437,
     438,   439,   145,   440,   687,   688,   689,   690,   691,   692,
     441,   442,   443,   444,   445,   148,   149,   446,   693,   447,
     694,   448,     0,   449,   450,   451,   695,   452,   453,   454,
     696,   697,   455,   456,   457,   458,   459,   698,   460,   461,
     462,   699,     0,   463,   700,   464,   465,   466,   157,   467,
     468,   159,   701,   469,   470,   471,   161,   702,   472,   703,
     473,   162,   704,   163,   474,     0,   475,   705,   476,   166,
     706,   477,   707,   478,   479,   480,   481,   167,   482,   483,
     484,   708,   485,   486,   487,   488,   489,   490,   709,   168,
     169,   710,   491,   492,   493,   711,   171,   712,   172,   713,
       0,   173,   174,   494,   175,   495,   496,   497,   498,   499,
     714,   176,   177,   500,   178,   715,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,   184,   185,   716,   517,   518,
     519,   520,   521,   522,   523,   186,   524,   717,   525,   526,
     188,   527,   718,   189,   528,   190,   529,   530,   719,   720,
     531,   721,   722,   723,   532,   533,   724,   725,   191,   192,
     193,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,   726,   543,   544,   545,   546,   547,
     548,   198,   549,   550,   727,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   728,   561,   562,   204,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
     729,   572,   573,   574,   730,   575,   210,   576,   577,   212,
     578,   213,   731,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,   732,   590,   591,   733,   592,
     593,   594,   595,   596,   734,   216,   217,   735,   736,   598,
     218,   599,   219,   737,   600,   601,   602,   603,   604,   738,
     739,   605,   606,   607,   608,   740,   741,   609,   610,   611,
     612,     0,   227,   614,   228,   615,   616,   617,   742,   743,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,     0,     0,     0,    83,
      84,    85,     0,    87,    88,    89,    90,    91,     0,     0,
       0,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,     0,     0,   876,   105,   106,   107,   108,     0,
     109,     0,   110,   111,   112,     0,   113,   114,   115,     0,
       0,     0,     0,     0,   118,   119,     0,     0,     0,     0,
     120,     0,     0,     0,     0,     0,     0,     0,     0,   121,
       0,   122,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   130,
       0,     0,     0,   132,   133,   134,   135,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   136,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   148,   149,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,     0,     0,     0,     0,     0,
     157,     0,     0,   159,     0,     0,     0,     0,   161,     0,
       0,     0,     0,   162,     0,   163,     0,     0,     0,     0,
       0,   166,     0,     0,     0,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   168,   169,     0,     0,     0,     0,     0,   171,     0,
     172,     0,     0,   173,   174,     0,   175,     0,     0,     0,
       0,     0,     0,   176,   177,     0,   178,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   183,   184,   185,     0,
       0,     0,     0,     0,     0,     0,     0,   186,     0,     0,
       0,     0,   188,     0,     0,   189,     0,   190,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     191,   192,   193,   194,     0,     0,     0,     0,     0,     0,
       0,   195,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   198,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     204,     0,     0,   206,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   210,     0,
       0,   212,     0,   213,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   215,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   216,   217,     0,
       0,     0,   218,     0,   219,     0,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,     0,   228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   229,   230,
     231,   232,   233,   234,   235,   236,     0,     0,     0,     0,
       0,     0,     0,     0,   237,     0,     0,   238,     0,     0,
       0,     0,    83,    84,    85,     0,    87,    88,    89,    90,
      91,     0,     0,     0,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,     0,     0,  2512,   105,   106,
     107,   108,     0,   109,     0,   110,   111,   112,     0,   113,
     114,   115,     0,     0,     0,     0,     0,   118,   119,     0,
       0,     0,     0,   120,     0,     0,     0,     0,     0,     0,
       0,     0,   121,     0,   122,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   130,     0,     0,     0,   132,   133,   134,   135,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   136,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     148,   149,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   155,     0,     0,
       0,     0,     0,   157,     0,     0,   159,     0,     0,     0,
       0,   161,     0,     0,     0,     0,   162,     0,   163,     0,
       0,     0,     0,     0,   166,     0,     0,     0,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   168,   169,     0,     0,     0,     0,
       0,   171,     0,   172,     0,     0,   173,   174,     0,   175,
       0,     0,     0,     0,     0,     0,   176,   177,     0,   178,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   183,
     184,   185,     0,     0,     0,     0,     0,     0,     0,     0,
     186,     0,     0,     0,     0,   188,     0,     0,   189,     0,
     190,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   191,   192,   193,   194,     0,     0,     0,
       0,     0,     0,     0,   195,   196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   198,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   204,     0,     0,   206,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   210,     0,     0,   212,     0,   213,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   215,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     216,   217,     0,     0,     0,   218,     0,   219,     0,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,     0,   228,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   229,   230,   231,   232,   233,   234,   235,   236,     0,
       0,     0,     0,     0,     0,     0,     0,   237,     0,     0,
     238,     0,    82,     0,     0,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,     0,    93,    94,    95,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   104,     0,
    2514,   105,   106,   107,   108,     0,   109,     0,   110,   111,
     112,     0,   113,   114,   115,   116,   117,     0,     0,     0,
     118,   119,     0,     0,     0,     0,   120,     0,     0,     0,
       0,     0,     0,     0,     0,   121,     0,   122,     0,   123,
     124,     0,   125,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   126,     0,   127,   128,     0,     0,     0,     0,
       0,     0,     0,     0,   129,   130,     0,     0,   131,   132,
     133,   134,   135,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   136,     0,     0,   137,     0,   138,
     139,   140,     0,     0,   141,   142,     0,     0,     0,     0,
       0,     0,     0,     0,   143,     0,   144,     0,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     146,     0,   147,   148,   149,   150,     0,     0,     0,     0,
       0,   151,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,     0,   153,     0,     0,     0,     0,     0,   154,
     155,     0,     0,     0,     0,   156,   157,   158,     0,   159,
       0,     0,   160,     0,   161,     0,     0,     0,     0,   162,
       0,   163,     0,   164,     0,   165,     0,   166,     0,     0,
       0,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   168,   169,     0,
       0,   170,     0,     0,   171,     0,   172,     0,     0,   173,
     174,     0,   175,     0,     0,     0,     0,     0,     0,   176,
     177,     0,   178,     0,   179,   180,     0,     0,     0,     0,
     181,     0,     0,     0,     0,     0,     0,     0,     0,   182,
       0,     0,   183,   184,   185,     0,     0,     0,     0,     0,
       0,     0,     0,   186,     0,     0,     0,   187,   188,     0,
       0,   189,     0,   190,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   191,   192,   193,   194,
       0,     0,     0,     0,     0,     0,     0,   195,   196,     0,
     197,     0,     0,     0,     0,     0,     0,     0,     0,   198,
     199,     0,     0,   200,     0,   201,     0,     0,     0,     0,
     202,     0,     0,     0,     0,   203,   204,     0,   205,   206,
       0,     0,   207,     0,     0,     0,     0,     0,   208,     0,
       0,     0,     0,   209,   210,     0,   211,   212,     0,   213,
       0,     0,     0,   214,     0,     0,     0,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   216,   217,     0,     0,     0,   218,     0,
     219,     0,   220,     0,   221,     0,     0,   222,     0,     0,
     223,     0,   224,     0,     0,   225,     0,     0,     0,   226,
     227,     0,   228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   229,   230,   231,   232,   233,   234,
     235,   236,     0,     0,     0,     0,     0,     0,     0,     0,
     237,     0,     0,   238,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   662,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,   239,    96,
      97,    98,    99,   100,   101,   663,   102,   103,   388,   664,
       0,   105,   106,   107,   108,   665,   666,     0,   110,   111,
     112,     0,   113,   667,   668,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
    2470,   406,   407,   408,     0,     0,     0,     0,  1271,     0,
       0,   409,   410,     0,   411,   130,   412,   413,   414,   132,
    1272,   134,  1273,  1274,     0,   415,   416,     0,   417,   418,
    1275,  1276,   419,  1277,  1278,   421,     0,   422,   423,   424,
     425,  1279,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
     145,   440,     0,  1280,  1281,  1282,  1283,  1284,   441,   442,
     443,   444,   445,  1285,  1286,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,  2471,     0,
     455,   456,  1287,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,  1288,   467,   468,  1289,
    1290,   469,   470,   471,  1291,     0,   472,     0,   473,   162,
       0,   163,   474,     0,   475,     0,   476,  1292,     0,   477,
       0,   478,   479,   480,   481,   167,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,   168,   169,     0,
     491,   492,   493,  1293,  1294,     0,  1295,     0,     0,   173,
     174,   494,   175,   495,   496,   497,   498,   499,     0,  1296,
     177,   500,   178,     0,   501,   502,   503,  1297,  1298,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,  1299,   184,  1300,   791,   517,   518,   519,   520,
     521,   522,   523,   186,   524,  1301,   525,   526,   188,   527,
    1302,  1303,   528,  1304,   529,   530,     0,     0,   531,   792,
       0,     0,  1305,   533,     0,     0,   191,   192,   193,  1306,
     534,   535,   536,   537,   538,     0,   539,  1307,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,  1308,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,   204,   563,   564,  1309,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,  1310,   575,   210,   576,   577,   212,   578,  1311,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,  1312,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,  1313,  1314,     0,     0,   598,  1315,   599,
    1316,  1317,   600,   601,   602,   603,   604,     0,  1318,   605,
     606,   607,   608,  1319,     0,   609,   610,   611,   612,   613,
    1320,   614,   228,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,  1321,  1322,  1323,  1324,  1325,
    1326,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,    49,  1327,   238,   627,     0,     0,  1328,  1329,    52,
      53,    54,    55,  1330,    56,     0,     0,     0,     0,  1331,
    1332,  2472,     0,     0,     0,     0,     0,     0,  1334,  2473,
     662,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,   663,   102,   103,   388,   664,     0,   105,   106,   107,
     108,   665,   666,     0,   110,   111,   112,     0,   113,   667,
     668,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,  1271,     0,     0,   409,   410,     0,
     411,   130,   412,   413,   414,   132,  1272,   134,  1273,  1274,
       0,   415,   416,     0,   417,   418,  1275,  1276,   419,  1277,
    1278,   421,     0,   422,   423,   424,   425,  1279,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,   145,   440,     0,  1280,
    1281,  1282,  1283,  1284,   441,   442,   443,   444,   445,  1285,
    1286,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,  1287,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,  1288,   467,   468,  1289,  1290,   469,   470,   471,
    1291,     0,   472,     0,   473,   162,     0,   163,   474,     0,
     475,     0,   476,  1292,     0,   477,     0,   478,   479,   480,
     481,   167,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,   168,   169,     0,   491,   492,   493,  1293,
    1294,     0,  1295,     0,     0,   173,   174,   494,   175,   495,
     496,   497,   498,   499,     0,  1296,   177,   500,   178,     0,
     501,   502,   503,  1297,  1298,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,  1299,   184,
    1300,   791,   517,   518,   519,   520,   521,   522,   523,   186,
     524,  1301,   525,   526,   188,   527,  1302,  1303,   528,  1304,
     529,   530,     0,     0,   531,   792,     0,     0,  1305,   533,
       0,     0,   191,   192,   193,  1306,   534,   535,   536,   537,
     538,     0,   539,  1307,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,  1308,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,   204,   563,   564,  1309,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,  1310,   575,
     210,   576,   577,   212,   578,  1311,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,  1312,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,  1313,
    1314,     0,     0,   598,  1315,   599,  1316,  1317,   600,   601,
     602,   603,   604,     0,  1318,   605,   606,   607,   608,  1319,
       0,   609,   610,   611,   612,   613,  1320,   614,   228,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,  1321,  1322,  1323,  1324,  1325,  1326,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,    49,  1327,   238,
     627,     0,     0,  1328,  1329,    52,    53,    54,    55,  1330,
      56,     0,     0,     0,     0,  1331,  1332,     0,     0,     0,
       0,     0,     0,     0,  1334,  2383,   662,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   663,   102,   103,
     388,   664,     0,   105,   106,   107,   108,   665,   666,     0,
     110,   111,   112,     0,   113,   667,   668,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,   130,   412,   413,
     414,   132,  1600,   134,  1601,  1274,     0,   415,   416,     0,
     417,   418,     0,     0,   419,  1602,  1603,   421,     0,   422,
     423,   424,   425,     0,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,   145,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,  1604,  1605,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,  1287,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,     0,   467,
     468,     0,     0,   469,   470,   471,  1606,     0,   472,     0,
     473,   162,     0,   163,   474,     0,   475,     0,   476,     0,
       0,   477,     0,   478,   479,   480,   481,   167,   482,   483,
     484,  2046,   485,   486,   487,   488,   489,   490,     0,   168,
    2047,     0,   491,   492,   493,  1293,  1607,     0,  1608,     0,
       0,   173,   174,   494,   175,   495,   496,   497,   498,   499,
       0,     0,   177,   500,   178,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,  1609,   184,  1610,     0,   517,   518,
     519,   520,   521,   522,   523,     0,   524,     0,   525,   526,
     188,   527,     0,     0,   528,  1611,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,  2048,   192,
     193,     0,   534,   535,   536,   537,   538,     0,   539,     0,
       0,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,  1612,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,   204,   563,
     564,     0,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,  2049,   576,   577,   212,
     578,  1614,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,     0,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,  1615,  1616,     0,     0,   598,
       0,   599,     0,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,     0,  1617,   614,   228,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,     0,     0,     0,     0,
       0,     0,     0,     0,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,  2050,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,  3719,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1417,     0,     0,
       0, -1417,   662,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,   663,   102,   103,   388,   664,     0,   105,
     106,   107,   108,   665,   666,     0,   110,   111,   112,     0,
     113,   667,   668,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,  1271,     0,     0,   409,
     410,     0,   411,   130,   412,   413,   414,   132,  1272,   134,
    1273,  1274,  2393,   415,   416,     0,   417,   418,  1275,  1276,
     419,  1277,  1278,   421,     0,   422,   423,   424,   425,  1279,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,   145,   440,
       0,  1280,  1281,  1282,  1283,  1284,   441,   442,   443,   444,
     445,  1285,  1286,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
    1287,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,  1288,   467,   468,  1289,  1290,   469,
     470,   471,  1291,     0,   472,     0,   473,   162,  2394,   163,
     474,     0,   475,     0,   476,  1292,     0,   477,     0,   478,
     479,   480,   481,   167,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,   168,   169,     0,   491,   492,
     493,  1293,  1294,     0,  1295,     0,     0,   173,   174,   494,
     175,   495,   496,   497,   498,   499,  2395,  1296,   177,   500,
     178,     0,   501,   502,   503,  1297,  1298,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
    1299,   184,  1300,   791,   517,   518,   519,   520,   521,   522,
     523,   186,   524,  1301,   525,   526,   188,   527,  1302,  1303,
     528,  1304,   529,   530,     0,     0,   531,   792,     0,     0,
    1305,   533,     0,     0,   191,   192,   193,  1306,   534,   535,
     536,   537,   538,     0,   539,  1307,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,  1308,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,   204,   563,   564,  1309,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
    1310,   575,   210,   576,   577,   212,   578,  1311,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,  1312,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,  1313,  1314,     0,  2396,   598,  1315,   599,  1316,  1317,
     600,   601,   602,   603,   604,     0,  1318,   605,   606,   607,
     608,  1319,     0,   609,   610,   611,   612,   613,  1320,   614,
     228,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,  1321,  1322,  1323,  1324,  1325,  1326,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,    49,
    1327,   238,   627,     0,     0,  1328,  1329,    52,    53,    54,
      55,  1330,    56,     0,     0,     0,     0,  1331,  1332,     0,
       0,     0,     0,     0,     0,     0,  1334,   662,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,   663,   102,
     103,   388,   664,     0,   105,   106,   107,   108,   665,   666,
       0,   110,   111,   112,     0,   113,   667,   668,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,  1271,     0,     0,   409,   410,     0,   411,   130,   412,
     413,   414,   132,  1272,   134,  1273,  1274,     0,   415,   416,
       0,   417,   418,  1275,  1276,   419,  1277,  1278,   421,     0,
     422,   423,   424,   425,  1279,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,   145,   440,     0,  1280,  1281,  1282,  1283,
    1284,   441,   442,   443,   444,   445,  1285,  1286,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,  1287,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,  1288,
     467,   468,  1289,  1290,   469,   470,   471,  1291,     0,   472,
       0,   473,   162,     0,   163,   474,     0,   475,     0,   476,
    1292,     0,   477,     0,   478,   479,   480,   481,   167,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
     168,   169,     0,   491,   492,   493,  1293,  1294,     0,  1295,
       0,     0,   173,   174,   494,   175,   495,   496,   497,   498,
     499,     0,  1296,   177,   500,   178,     0,   501,   502,   503,
    1297,  1298,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,  1299,   184,  1300,   791,   517,
     518,   519,   520,   521,   522,   523,   186,   524,  1301,   525,
     526,   188,   527,  1302,  1303,   528,  1304,   529,   530,     0,
       0,   531,   792,     0,     0,  1305,   533,     0,     0,   191,
     192,   193,  1306,   534,   535,   536,   537,   538,     0,   539,
    1307,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,  1308,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,   204,
     563,   564,  1309,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,  1310,   575,   210,   576,   577,
     212,   578,  1311,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,  1312,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,  1313,  1314,     0,     0,
     598,  1315,   599,  1316,  1317,   600,   601,   602,   603,   604,
       0,  1318,   605,   606,   607,   608,  1319,     0,   609,   610,
     611,   612,   613,  1320,   614,   228,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,  1321,  1322,
    1323,  1324,  1325,  1326,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,    49,  1327,   238,   627,     0,     0,
    1328,  1329,    52,    53,    54,    55,  1330,    56,     0,     0,
       0,     0,  1331,  1332,  1333,     0,     0,     0,     0,     0,
       0,  1334,   662,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,   663,   102,   103,   388,   664,     0,   105,
     106,   107,   108,   665,   666,     0,   110,   111,   112,     0,
     113,   667,   668,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,  1271,     0,     0,   409,
     410,     0,   411,   130,   412,   413,   414,   132,  1272,   134,
    1273,  1274,     0,   415,   416,     0,   417,   418,  1275,  1276,
     419,  1277,  1278,   421,     0,   422,   423,   424,   425,  1279,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,   145,   440,
       0,  1280,  1281,  1282,  1283,  1284,   441,   442,   443,   444,
     445,  1285,  1286,   446,  1409,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
    1287,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,  1288,   467,   468,  1289,  1290,   469,
     470,   471,  1291,     0,   472,     0,   473,   162,     0,   163,
     474,     0,   475,     0,   476,  1292,     0,   477,     0,   478,
     479,   480,   481,   167,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,   168,   169,     0,   491,   492,
     493,  1293,  1294,     0,  1295,     0,     0,   173,   174,   494,
     175,   495,   496,   497,   498,   499,     0,  1296,   177,   500,
     178,     0,   501,   502,   503,  1297,  1298,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
    1299,   184,  1300,   791,   517,   518,   519,   520,   521,   522,
     523,   186,   524,  1301,   525,   526,   188,   527,  1302,  1303,
     528,  1304,   529,   530,     0,     0,   531,   792,     0,     0,
    1305,   533,     0,     0,   191,   192,   193,  1306,   534,   535,
     536,   537,   538,     0,   539,  1307,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,  1308,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,   204,   563,   564,  1309,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
    1310,   575,   210,   576,   577,   212,   578,  1311,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,  1312,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,  1313,  1314,     0,     0,   598,  1315,   599,  1316,  1317,
     600,   601,   602,   603,   604,     0,  1318,   605,   606,   607,
     608,  1319,     0,   609,   610,   611,   612,   613,  1320,   614,
     228,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,  1321,  1322,  1323,  1324,  1325,  1326,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,    49,
    1327,   238,   627,     0,     0,  1328,  1329,    52,    53,    54,
      55,  1330,    56,     0,     0,     0,     0,  1331,  1332,     0,
       0,     0,     0,     0,     0,     0,  1334,   662,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,   663,   102,
     103,   388,   664,     0,   105,   106,   107,   108,   665,   666,
       0,   110,   111,   112,     0,   113,   667,   668,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,  1271,     0,     0,   409,   410,     0,   411,   130,   412,
     413,   414,   132,  1272,   134,  1273,  1274,     0,   415,   416,
       0,   417,   418,  1275,  1276,   419,  1277,  1278,   421,     0,
     422,   423,   424,   425,  1279,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,   145,   440,     0,  1280,  1281,  1282,  1283,
    1284,   441,   442,   443,   444,   445,  1285,  1286,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,  1287,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,  1288,
     467,   468,  1289,  1290,   469,   470,   471,  1291,     0,   472,
       0,   473,   162,     0,   163,   474,     0,   475,     0,   476,
    1292,     0,   477,     0,   478,   479,   480,   481,   167,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
     168,   169,     0,   491,   492,   493,  1293,  1294,     0,  1295,
       0,     0,   173,   174,   494,   175,   495,   496,   497,   498,
     499,     0,  1296,   177,   500,   178,     0,   501,   502,   503,
    1297,  1298,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,  1299,   184,  1300,   791,   517,
     518,   519,   520,   521,   522,   523,   186,   524,  1301,   525,
     526,   188,   527,  1302,  1303,   528,  1304,   529,   530,     0,
       0,   531,   792,     0,     0,  1305,   533,     0,     0,   191,
     192,   193,  1306,   534,   535,   536,   537,   538,     0,   539,
    1307,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,  1308,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,   204,
     563,   564,  1309,   565,   566,   567,   568,   569,   570,   571,
       0,   208,   572,   573,   574,  1310,   575,   210,   576,   577,
     212,   578,  1311,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,  1312,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,  1313,  1314,     0,     0,
     598,  1315,   599,  1316,  1317,   600,   601,   602,   603,   604,
       0,  1318,   605,   606,   607,   608,  1319,     0,   609,   610,
     611,   612,  1839,  1320,   614,   228,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,  1321,  1322,
    1323,  1324,  1325,  1326,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,    49,  1327,   238,   627,     0,     0,
    1328,  1329,    52,    53,    54,    55,  1330,    56,     0,     0,
       0,     0,  1331,  1332,     0,     0,     0,     0,     0,     0,
       0,  1334,   662,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,   663,   102,   103,   388,   664,     0,   105,
     106,   107,   108,   665,   666,     0,   110,   111,   112,     0,
     113,   667,   668,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,  1959,   406,
     407,   408,     0,     0,     0,     0,  1271,     0,     0,   409,
     410,     0,   411,   130,   412,   413,   414,   132,  1272,   134,
    1273,  1274,     0,   415,   416,     0,   417,   418,  1275,  1276,
     419,  1277,  1278,   421,     0,   422,   423,   424,   425,  1279,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,   145,   440,
       0,  1280,  1281,  1282,  1283,  1284,   441,   442,   443,   444,
     445,  1285,  1286,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
    1287,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,  1288,   467,   468,  1289,  1290,   469,
     470,   471,  1291,     0,   472,     0,   473,   162,     0,   163,
     474,     0,   475,     0,   476,  1292,     0,   477,     0,   478,
     479,   480,   481,   167,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,   168,   169,     0,   491,   492,
     493,  1293,  1294,     0,  1295,     0,     0,   173,   174,   494,
     175,   495,   496,   497,   498,   499,     0,  1296,   177,   500,
     178,     0,   501,   502,   503,  1297,  1298,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
    1299,   184,  1300,   791,   517,   518,   519,   520,   521,   522,
     523,   186,   524,  1301,   525,   526,   188,   527,  1302,  1303,
     528,  1304,   529,   530,     0,     0,   531,   792,     0,     0,
    1305,   533,     0,     0,   191,   192,   193,  1306,   534,   535,
     536,   537,   538,     0,   539,  1307,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,  1308,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,   204,   563,   564,  1309,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
    1310,   575,   210,   576,   577,   212,   578,  1311,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,  1312,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,  1313,  1314,     0,     0,   598,  1315,   599,  1316,  1317,
     600,   601,   602,   603,   604,     0,  1318,   605,   606,   607,
     608,  1319,     0,   609,   610,   611,   612,   613,  1320,   614,
     228,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,  1321,  1322,  1323,  1324,  1325,  1326,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,    49,
    1327,   238,   627,     0,     0,  1328,  1329,    52,    53,    54,
      55,  1330,    56,     0,     0,     0,     0,  1331,  1332,     0,
       0,     0,     0,     0,     0,     0,  1334,   662,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,   663,   102,
     103,   388,   664,     0,   105,   106,   107,   108,   665,   666,
       0,   110,   111,   112,     0,   113,   667,   668,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,  1271,     0,     0,   409,   410,     0,   411,   130,   412,
     413,   414,   132,  1272,   134,  1273,  1274,     0,   415,   416,
       0,   417,   418,  1275,  1276,   419,  1277,  1278,   421,     0,
     422,   423,   424,   425,  1279,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,   145,   440,     0,  1280,  1281,  1282,  1283,
    1284,   441,   442,   443,   444,   445,  1285,  1286,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,  1287,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,  1288,
     467,   468,  1289,  1290,   469,   470,   471,  1291,     0,   472,
       0,   473,   162,     0,   163,   474,     0,   475,     0,   476,
    1292,     0,   477,     0,   478,   479,   480,   481,   167,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
     168,   169,     0,   491,   492,   493,  1293,  1294,     0,  1295,
       0,     0,   173,   174,   494,   175,   495,   496,   497,   498,
     499,     0,  1296,   177,   500,   178,     0,   501,   502,   503,
    1297,  1298,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,  1299,   184,  1300,   791,   517,
     518,   519,   520,   521,   522,   523,   186,   524,  1301,   525,
     526,   188,   527,  1302,  1303,   528,  1304,   529,   530,     0,
       0,   531,   792,     0,     0,  1305,   533,     0,     0,   191,
     192,   193,  1306,   534,   535,   536,   537,   538,     0,   539,
    1307,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,  1308,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,   204,
     563,   564,  1309,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,  1310,   575,   210,   576,   577,
     212,   578,  1311,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,  1312,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,  1313,  1314,     0,     0,
     598,  1315,   599,  1316,  1317,   600,   601,   602,   603,   604,
       0,  1318,   605,   606,   607,   608,  1319,     0,   609,   610,
     611,   612,   613,  1320,   614,   228,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,  1321,  1322,
    1323,  1324,  1325,  1326,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,    49,  1327,   238,   627,     0,     0,
    1328,  1329,    52,    53,    54,    55,  1330,    56,     0,     0,
       0,     0,  1331,  1332,     0,     0,     0,     0,     0,  1785,
       0,  1334,   662,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,   663,   102,   103,   388,   664,     0,   105,
     106,   107,   108,   665,   666,     0,   110,   111,   112,     0,
     113,   667,   668,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,  1271,     0,     0,   409,
     410,     0,   411,   130,   412,   413,   414,   132,  1272,   134,
    1273,  1274,     0,   415,   416,     0,   417,   418,  1275,  1276,
     419,  1277,  1278,   421,     0,   422,   423,   424,   425,  1279,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,   145,   440,
    2779,  1280,  1281,  1282,  1283,  1284,   441,   442,   443,   444,
     445,  1285,  1286,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
    1287,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,  1288,   467,   468,  1289,  1290,   469,
     470,   471,  1291,     0,   472,     0,   473,   162,     0,   163,
     474,     0,   475,     0,   476,  1292,     0,   477,     0,   478,
     479,   480,   481,   167,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,   168,   169,     0,   491,   492,
     493,  1293,  1294,     0,  1295,     0,     0,   173,   174,   494,
     175,   495,   496,   497,   498,   499,     0,  1296,   177,   500,
     178,     0,   501,   502,   503,  1297,  1298,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
    1299,   184,  1300,   791,   517,   518,   519,   520,   521,   522,
     523,   186,   524,  1301,   525,   526,   188,   527,  1302,  1303,
     528,  1304,   529,   530,     0,     0,   531,   792,     0,     0,
    1305,   533,     0,     0,   191,   192,   193,  1306,   534,   535,
     536,   537,   538,     0,   539,  1307,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,  1308,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,   204,   563,   564,  1309,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
    1310,   575,   210,   576,   577,   212,   578,  1311,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,  1312,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,  1313,  1314,     0,     0,   598,  1315,   599,  1316,  1317,
     600,   601,   602,   603,   604,     0,  1318,   605,   606,   607,
     608,  1319,     0,   609,   610,   611,   612,   613,  1320,   614,
     228,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,  1321,  1322,  1323,  1324,  1325,  1326,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,    49,
    1327,   238,   627,     0,     0,  1328,  1329,    52,    53,    54,
      55,  1330,    56,     0,     0,     0,     0,  1331,  1332,     0,
       0,     0,     0,     0,     0,     0,  1334,   662,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,   663,   102,
     103,   388,   664,     0,   105,   106,   107,   108,   665,   666,
       0,   110,   111,   112,     0,   113,   667,   668,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,  1271,     0,     0,   409,   410,     0,   411,   130,   412,
     413,   414,   132,  1272,   134,  1273,  1274,     0,   415,   416,
       0,   417,   418,  1275,  1276,   419,  1277,  1278,   421,     0,
     422,   423,   424,   425,  1279,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,   145,   440,     0,  1280,  1281,  1282,  1283,
    1284,   441,   442,   443,   444,   445,  1285,  1286,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,  1287,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,  1288,
     467,   468,  1289,  1290,   469,   470,   471,  1291,     0,   472,
       0,   473,   162,  2394,   163,   474,     0,   475,     0,   476,
    1292,     0,   477,     0,   478,   479,   480,   481,   167,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
     168,   169,     0,   491,   492,   493,  1293,  1294,     0,  1295,
       0,     0,   173,   174,   494,   175,   495,   496,   497,   498,
     499,     0,  1296,   177,   500,   178,     0,   501,   502,   503,
    1297,  1298,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,  1299,   184,  1300,   791,   517,
     518,   519,   520,   521,   522,   523,   186,   524,  1301,   525,
     526,   188,   527,  1302,  1303,   528,  1304,   529,   530,     0,
       0,   531,   792,     0,     0,  1305,   533,     0,     0,   191,
     192,   193,  1306,   534,   535,   536,   537,   538,     0,   539,
    1307,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,  1308,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,   204,
     563,   564,  1309,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,  1310,   575,   210,   576,   577,
     212,   578,  1311,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,  1312,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,  1313,  1314,     0,     0,
     598,  1315,   599,  1316,  1317,   600,   601,   602,   603,   604,
       0,  1318,   605,   606,   607,   608,  1319,     0,   609,   610,
     611,   612,   613,  1320,   614,   228,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,  1321,  1322,
    1323,  1324,  1325,  1326,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,    49,  1327,   238,   627,     0,     0,
    1328,  1329,    52,    53,    54,    55,  1330,    56,     0,     0,
       0,     0,  1331,  1332,     0,     0,     0,     0,     0,     0,
       0,  1334,   662,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,   663,   102,   103,   388,   664,     0,   105,
     106,   107,   108,   665,   666,     0,   110,   111,   112,     0,
     113,   667,   668,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,  1271,     0,     0,   409,
     410,     0,   411,   130,   412,   413,   414,   132,  1272,   134,
    1273,  1274,     0,   415,   416,     0,   417,   418,  1275,  1276,
     419,  1277,  1278,   421,     0,   422,   423,   424,   425,  1279,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,   145,   440,
       0,  1280,  1281,  1282,  1283,  1284,   441,   442,   443,   444,
     445,  1285,  1286,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
    1287,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,  1288,   467,   468,  1289,  1290,   469,
     470,   471,  1291,     0,   472,     0,   473,   162,     0,   163,
     474,     0,   475,     0,   476,  1292,     0,   477,     0,   478,
     479,   480,   481,   167,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,   168,   169,     0,   491,   492,
     493,  1293,  1294,     0,  1295,     0,     0,   173,   174,   494,
     175,   495,   496,   497,   498,   499,     0,  1296,   177,   500,
     178,     0,   501,   502,   503,  1297,  1298,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
    1299,   184,  1300,   791,   517,   518,   519,   520,   521,   522,
     523,   186,   524,  1301,   525,   526,   188,   527,  1302,  1303,
     528,  1304,   529,   530,     0,     0,   531,   792,     0,     0,
    1305,   533,     0,     0,   191,   192,   193,  1306,   534,   535,
     536,   537,   538,     0,   539,  1307,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,  1308,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,   204,   563,   564,  1309,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
    1310,   575,   210,   576,   577,   212,   578,  1311,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,  1312,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,  1313,  1314,     0,     0,   598,  1315,   599,  1316,  1317,
     600,   601,   602,   603,   604,     0,  1318,   605,   606,   607,
     608,  1319,     0,   609,   610,   611,   612,   613,  1320,   614,
     228,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,  1321,  1322,  1323,  1324,  1325,  1326,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,    49,
    1327,   238,   627,     0,     0,  1328,  1329,    52,    53,    54,
      55,  1330,    56,     0,     0,     0,     0,  1331,  1332,     0,
       0,     0,     0,     0,     0,     0,  1334,   662,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,   663,   102,
     103,   388,   664,     0,   105,   106,   107,   108,   665,   666,
       0,   110,   111,   112,     0,   113,   667,   668,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,  1271,     0,     0,   409,   410,     0,   411,   130,   412,
     413,   414,   132,  1272,   134,  1273,  1274,     0,   415,   416,
       0,   417,   418,  1275,  1276,   419,  1277,  1278,   421,     0,
     422,   423,   424,   425,  1279,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,   145,   440,     0,  1280,  1281,  1282,  1283,
    1284,   441,   442,   443,   444,   445,  1285,  1286,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,  1287,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,  1288,
     467,   468,  1289,  1290,   469,   470,   471,  1291,     0,   472,
       0,   473,   162,     0,   163,   474,     0,   475,     0,   476,
    1292,     0,   477,     0,   478,   479,   480,   481,   167,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
     168,   169,     0,   491,   492,   493,  1293,  1294,     0,  1295,
       0,     0,   173,   174,   494,   175,   495,   496,   497,   498,
     499,     0,  1296,   177,   500,   178,     0,   501,   502,   503,
    1297,  1298,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,  1299,   184,  1300,   791,   517,
     518,   519,   520,   521,   522,   523,   186,   524,  1301,   525,
     526,   188,   527,  1302,  1303,   528,  1304,   529,   530,     0,
       0,   531,   792,     0,     0,  1305,   533,     0,     0,   191,
     192,   193,  1306,   534,   535,   536,   537,   538,     0,   539,
    1307,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,  1308,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,   204,
     563,   564,  1309,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,  1310,   575,   210,   576,   577,
     212,   578,  1311,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,  1312,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,  1313,  1314,     0,     0,
     598,  1315,   599,  1316,  1317,   600,   601,   602,   603,   604,
       0,  1318,   605,   606,   607,   608,  1319,     0,   609,   610,
     611,   612,   613,  1320,   614,   228,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,  3495,  1321,  1322,
    1323,  1324,  1325,  1326,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,    49,  1327,   238,   627,     0,     0,
    1328,  1329,    52,    53,    54,    55,  1330,    56,     0,     0,
       0,     0,  1331,  1332,     0,     0,     0,     0,     0,     0,
       0,  1334,   662,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,   663,   102,   103,   388,   664,     0,   105,
     106,   107,   108,   665,   666,     0,   110,   111,   112,     0,
     113,   667,   668,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,  1271,     0,     0,   409,
     410,     0,   411,   130,   412,   413,   414,   132,  1272,   134,
    1273,  1274,     0,   415,   416,     0,   417,   418,  1275,  1276,
     419,  1277,  1278,   421,     0,   422,   423,   424,   425,  1279,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,   145,   440,
       0,  1280,  1281,  1282,  1283,  1284,   441,   442,   443,   444,
     445,  1285,  1286,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
    1287,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,  1288,   467,   468,  1289,  1290,   469,
     470,   471,  1291,     0,   472,     0,   473,   162,     0,   163,
     474,     0,   475,     0,   476,  1292,     0,   477,     0,   478,
     479,   480,   481,   167,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,   168,   169,     0,   491,   492,
     493,  1293,  1294,     0,  1295,     0,     0,   173,   174,   494,
     175,   495,   496,   497,   498,   499,     0,  1296,   177,   500,
     178,     0,   501,   502,   503,  1297,  1298,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
    1299,   184,  1300,   791,   517,  3502,   519,   520,   521,   522,
     523,   186,   524,  1301,   525,   526,   188,   527,  1302,  1303,
     528,  1304,   529,   530,     0,     0,   531,   792,     0,     0,
    1305,   533,     0,     0,   191,   192,   193,  1306,   534,   535,
     536,   537,   538,     0,   539,  1307,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,  1308,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,   204,   563,   564,  1309,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
    1310,   575,   210,   576,   577,   212,   578,  1311,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,  1312,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,  1313,  1314,     0,     0,   598,  1315,   599,  1316,  1317,
     600,   601,   602,   603,   604,     0,  1318,   605,   606,   607,
     608,  1319,     0,   609,   610,   611,   612,   613,  1320,   614,
     228,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,  1321,  1322,  1323,  1324,  1325,  1326,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,    49,
    1327,   238,   627,     0,     0,  1328,  1329,    52,    53,    54,
      55,  1330,    56,     0,     0,     0,     0,  1331,  1332,     0,
       0,     0,     0,     0,     0,     0,  1334,   662,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,   663,   102,
     103,   388,   664,     0,   105,   106,   107,   108,   665,   666,
       0,   110,   111,   112,     0,   113,   667,   668,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,  1271,     0,     0,   409,   410,     0,   411,   130,   412,
     413,   414,   132,  1272,   134,  1273,  1274,     0,   415,   416,
       0,   417,   418,  1275,  1276,   419,  1277,  1278,   421,     0,
     422,   423,   424,   425,  1279,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,   145,   440,     0,  1280,  1281,  1282,  1283,
    1284,   441,   442,   443,   444,   445,  1285,  1286,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,  1287,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,  1288,
     467,   468,  1289,  1290,   469,   470,   471,  1291,     0,   472,
       0,   473,   162,     0,   163,   474,     0,   475,     0,   476,
    1292,     0,   477,     0,   478,   479,   480,   481,   167,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
     168,   169,     0,   491,   492,   493,  1293,  1294,     0,  1295,
       0,     0,   173,   174,   494,   175,   495,   496,   497,   498,
     499,     0,  1296,   177,   500,   178,     0,   501,   502,   503,
    1297,  1298,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,  1299,   184,  1300,   791,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,   188,   527,  1302,  1303,   528,  1304,   529,   530,     0,
       0,   531,   792,     0,     0,  1305,   533,     0,     0,   191,
     192,   193,  1306,   534,   535,   536,   537,   538,     0,   539,
    1307,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,  1308,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,   204,
     563,   564,  1309,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,  1310,   575,   210,   576,   577,
     212,   578,  1311,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,  1312,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,  1313,  1314,     0,     0,
     598,  1315,   599,  1316,  1317,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,  1319,     0,   609,   610,
     611,   612,   613,  1320,   614,   228,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,  1321,  1322,
    1323,  1324,  1325,  1326,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,    49,  1327,   238,   627,     0,     0,
    1328,  1329,    52,    53,    54,    55,  1330,    56,     0,     0,
       0,     0,     0,  2377,     0,     0,     0,     0,     0,     0,
       0,  1334,   662,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,   663,   102,   103,   388,   664,     0,   105,
     106,   107,   108,   665,   666,     0,   110,   111,   112,     0,
     113,   667,   668,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,  1271,     0,     0,   409,
     410,     0,   411,   130,   412,   413,   414,     0,  1272,   134,
    1273,  1274,     0,   415,   416,     0,   417,   418,  1275,  1276,
     419,  1277,  1278,   421,     0,   422,   423,   424,   425,  1279,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,   145,   440,
       0,  1280,  1281,  1282,  1283,  1284,   441,   442,   443,   444,
     445,  1285,  1286,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
    1287,   458,   459,     0,   460,   461,   462,     0,     0,     0,
       0,   464,   465,   466,  1288,   467,   468,  1289,  1290,   469,
     470,   471,  1291,     0,   472,     0,   473,   162,     0,   163,
     474,     0,   475,     0,   476,  1292,     0,   477,     0,   478,
     479,   480,   481,     0,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,   168,   169,     0,   491,   492,
     493,  1293,  1294,     0,  1295,     0,     0,   173,   174,   494,
     175,   495,   496,   497,   498,   499,     0,  1296,   177,   500,
       0,     0,   501,   502,   503,  1297,  1298,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
    1299,   184,  1300,   791,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,   188,   527,  1302,  1303,
     528,  1304,   529,   530,     0,     0,   531,   792,     0,     0,
    1305,   533,     0,     0,   191,   192,   193,  1306,   534,   535,
     536,   537,   538,     0,   539,  1307,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,  1308,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,   204,   563,   564,  1309,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
    1310,   575,   210,   576,   577,     0,   578,  1311,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,  1312,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,  1313,  1314,     0,     0,   598,  1315,   599,  1316,  1317,
     600,   601,   602,   603,   604,     0,  1318,   605,   606,   607,
     608,  1319,     0,   609,   610,   611,   612,   613,  1320,   614,
     228,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,  1321,  1322,  1323,  1324,  1325,  1326,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,    49,
    1327,   238,   627,     0,     0,  1328,  1329,    52,    53,    54,
      55,  1330,    56,     0,     0,     0,     0,  1331,  1332,     0,
       0,     0,     0,     0,     0,     0,  1334,   662,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,   663,   102,
     103,   388,   664,     0,   105,   106,   107,   108,   665,   666,
       0,   110,   111,   112,     0,   113,   667,   668,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,  1271,     0,     0,   409,   410,     0,   411,   130,   412,
     413,   414,     0,  1272,   134,  1273,  1274,     0,   415,   416,
       0,   417,   418,  1275,  1276,   419,  1277,  1278,   421,     0,
     422,   423,   424,   425,  1279,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,   145,   440,     0,  1280,  1281,  1282,  1283,
    1284,   441,   442,   443,   444,   445,  1285,  1286,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,  1287,   458,   459,     0,   460,
     461,   462,     0,     0,     0,     0,   464,   465,   466,  1288,
     467,   468,  1289,  1290,   469,   470,   471,  1291,     0,   472,
       0,   473,   162,     0,   163,   474,     0,   475,     0,   476,
    1292,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
     168,   169,     0,   491,   492,   493,  1293,  1294,     0,  1295,
       0,     0,   173,   174,   494,   175,   495,   496,   497,   498,
     499,     0,  1296,   177,   500,     0,     0,   501,   502,   503,
    1297,  1298,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,  1299,   184,  1300,   791,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,   188,   527,  1302,  1303,   528,  1304,   529,   530,     0,
       0,   531,   792,     0,     0,     0,   533,     0,     0,   191,
     192,   193,  1306,   534,   535,   536,   537,   538,     0,   539,
    1307,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,  1308,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,   204,
     563,   564,  1309,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,  1310,   575,   210,   576,   577,
       0,   578,  1311,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,  1312,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,  1313,  1314,     0,     0,
     598,  1315,   599,  1316,  1317,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,  1319,     0,   609,   610,
     611,   612,   613,  1320,   614,   228,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,  1321,  1322,
    1323,  1324,  1325,  1326,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,    49,     0,   238,   627,     0,     0,
    1328,  1329,    52,    53,    54,    55,  1330,    56,     0,     0,
       0,     0,     0,  2377,     0,     0,     0,     0,     0,     0,
       0,  1334,   662,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,   663,   102,   103,   388,   664,     0,   105,
     106,   107,   108,   665,   666,     0,   110,   111,   112,     0,
     113,   667,   668,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,     0,     0,     0,   409,
     410,     0,   411,   130,   412,   413,   414,   132,   133,   134,
     135,     0,     0,   415,   416,     0,   417,   418,     0,  1276,
     419,   420,   136,   421,     0,   422,   423,   424,   425,  1279,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,   145,   440,
       0,  1280,  1281,  1282,  1283,  1284,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,  1289,     0,   469,
     470,   471,   161,     0,   472,     0,   473,   162,     0,   163,
     474,     0,   475,     0,   476,  1292,     0,   477,     0,   478,
     479,   480,   481,   167,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,   168,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,   173,   174,   494,
     175,   495,   496,   497,   498,   499,     0,  1296,   177,   500,
     178,     0,   501,   502,   503,  1297,  1298,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,   184,   185,   791,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,   188,   527,     0,  1303,
     528,   190,   529,   530,     0,     0,   531,   792,     0,   978,
     532,   533,     0,     0,   191,   192,   193,  1306,   534,   535,
     536,   537,   538,     0,   539,  1307,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,   204,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,   208,   572,   573,   574,
    1310,   575,   210,   576,   577,   212,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,  1312,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   216,   217,     0,     0,   598,  1315,   599,  1316,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,  1319,     0,   609,   610,   611,   612,  1839,   227,   614,
     228,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,  1321,  1322,  1323,  1324,  1325,  1326,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   662,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,  2248,    96,    97,    98,
      99,   100,   101,   663,   102,   103,   388,   664,     0,   105,
     106,   107,   108,   665,   666,     0,   110,   111,   112,     0,
     113,   667,   668,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,     0,     0,     0,   409,
     410,     0,   411,   130,   412,   413,   414,   132,   133,   134,
     135,     0,     0,   415,   416,     0,   417,   418,     0,  1276,
     419,   420,   136,   421,     0,   422,   423,   424,   425,  1279,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,   145,   440,
       0,  1280,  1281,  1282,  1283,  1284,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,  1289,     0,   469,
     470,   471,   161,     0,   472,     0,   473,   162,     0,   163,
     474,     0,   475,     0,   476,  1292,     0,   477,     0,   478,
     479,   480,   481,   167,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,   168,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,   173,   174,   494,
     175,   495,   496,   497,   498,   499,     0,  1296,   177,   500,
     178,     0,   501,   502,   503,  1297,  1298,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,   184,   185,   791,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,   188,   527,     0,  1303,
     528,   190,   529,   530,     0,     0,   531,   792,     0,   978,
     532,   533,     0,     0,   191,   192,   193,  1306,   534,   535,
     536,   537,   538,     0,   539,  1307,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,   204,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
    1310,   575,   210,   576,   577,   212,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,  1312,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   216,   217,     0,     0,   598,  1315,   599,  1316,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,  1319,     0,   609,   610,   611,   612,   613,   227,   614,
     228,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,  1321,  1322,  1323,  1324,  1325,  1326,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   662,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,  2248,    96,    97,    98,
      99,   100,   101,   663,   102,   103,   388,   664,     0,   105,
     106,   107,   108,   665,   666,     0,   110,   111,   112,     0,
     113,   667,   668,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,     0,     0,     0,   409,
     410,     0,   411,   130,   412,   413,   414,   132,   133,   134,
     135,     0,     0,   415,   416,     0,   417,   418,     0,  1276,
     419,   420,   136,   421,     0,   422,   423,   424,   425,  1279,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,   145,   440,
       0,  1280,  1281,  1282,  1283,  1284,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,  1289,     0,   469,
     470,   471,   161,     0,   472,     0,   473,   162,     0,   163,
     474,     0,   475,     0,   476,  1292,     0,   477,     0,   478,
     479,   480,   481,   167,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,   168,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,   173,   174,   494,
     175,   495,   496,   497,   498,   499,     0,  1296,   177,   500,
     178,     0,   501,   502,   503,  1297,  1298,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,   184,   185,   791,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,   188,   527,     0,  1303,
     528,   190,   529,   530,     0,     0,   531,   792,     0,     0,
     532,   533,     0,     0,   191,   192,   193,  1306,   534,   535,
     536,   537,   538,     0,   539,  1307,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,   204,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
    1310,   575,   210,   576,   577,   212,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,  1312,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   216,   217,     0,     0,   598,  1315,   599,  1316,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,  1319,     0,   609,   610,   611,   612,   613,   227,   614,
     228,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,  1321,  1322,  1323,  1324,  1325,  1326,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   662,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,  3619,    96,    97,    98,
      99,   100,   101,   663,   102,   103,   388,   664,     0,   105,
     106,   107,   108,   665,   666,     0,   110,   111,   112,     0,
     113,   667,   668,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,     0,     0,     0,   409,
     410,     0,   411,   130,   412,   413,   414,   132,   133,   134,
     135,     0,     0,   415,   416,     0,   417,   418,     0,     0,
     419,   420,   136,   421,     0,   422,   423,   424,   425,   140,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,   145,   440,
       0,     0,     0,     0,     0,     0,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,   159,     0,   469,
     470,   471,   161,     0,   472,     0,   473,   162,     0,   163,
     474,     0,   475,     0,   476,   166,     0,   477,     0,   478,
     479,   480,   481,   167,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,   168,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,   173,   174,   494,
     175,   495,   496,   497,   498,   499,     0,   176,   177,   500,
     178,     0,   501,   502,   503,     0,     0,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,   184,   185,   791,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,   188,   527,     0,   189,
     528,   190,   529,   530,     0,     0,   531,   792,     0,     0,
     532,   533,     0,     0,   191,   192,   193,   194,   534,   535,
     536,   537,   538,     0,   539,   195,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,   204,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
       0,   575,   210,   576,   577,   212,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   215,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   216,   217,     0,     0,   598,   218,   599,   219,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,     0,     0,   609,   610,   611,   612,   613,   227,   614,
     228,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,   230,   231,   232,   233,   234,   235,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,    83,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   388,  3669,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
     408,     0,     0,     0,     0,     0,  2761,     0,   409,   410,
       0,   411,     0,   412,   413,   414,     0,   133,     0,   135,
       0,     0,   415,   416,     0,   417,   418,     0,     0,   419,
     420,   136,   421,     0,   422,   423,   424,   425,   140,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439, -1048,   440,     0,
       0,     0,     0,     0,     0,   441,   442,   443,   444,   445,
     148,   149,   446,     0,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,   457,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,   157,   467,   468,   159,     0,   469,   470,
     471,   161,     0,   472,     0,   473,     0,     0, -1048,   474,
       0,   475,     0,   476,   166,     0,   477,     0,   478,   479,
     480,   481,     0,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0, -1048,   169,     0,   491,   492,   493,
       0,   171,     0,   172,     0,     0,     0,     0,   494, -1048,
     495,   496,   497,   498,   499,     0,   176, -1048,   500,     0,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   183,
   -1048,   185,     0,   517,   518,   519,   520,   521,   522,   523,
     186,   524,     0,   525,   526,     0,   527,     0,   189,   528,
     190,   529,   530,     0,     0,   531,     0,     0,     0,   532,
     533,     0,     0,   191,     0,     0,   194,   534,   535,   536,
     537,   538,     0,   539,   195,   196,   540,   541,   542,     0,
     543,   544,   545,   546,   547,   548,   198,   549,   550,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562, -1048,   563,   564,   206,   565,   566,   567,
     568,   569,   570,   571,     0,     0,   572,   573,   574,     0,
     575,   210,   576,   577,     0,   578,   213,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   215,   589,
       0,   590,   591,     0,   592,   593,   594,   595,   596,     0,
     216,   217,     0,     0,   598,   218,   599,   219,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,   613,   227,   614,     0,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,   229,   230,   231,   232,   233,   234,   235,   236,   624,
     625,   626,     0,     0,     0,     0,     0,   237,     0,     0,
     238,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   388,     0,  1413,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,     0,     0,     0,   409,   410,     0,
     411,     0,   412,   413,   414,     0,   133,     0,   135,     0,
       0,   415,   416,     0,   417,   418,     0,     0,   419,   420,
     136,   421,     0,   422,   423,   424,   425,   140,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,     0,   440,     0,     0,
       0,     0,     0,     0,   441,   442,   443,   444,   445,   148,
     149,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,   457,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,   157,   467,   468,   159,     0,   469,   470,   471,
     161,     0,   472,     0,   473,     0,     0,     0,   474,     0,
     475,     0,   476,   166,     0,   477,     0,   478,   479,   480,
     481,     0,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,     0,   169,     0,   491,   492,   493,     0,
     171,     0,   172,     0,     0,     0,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   176,     0,   500,     0,     0,
     501,   502,   503,     0,     0,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   183,     0,
     185,     0,   517,   518,   519,   520,   521,   522,   523,   186,
     524,     0,   525,   526,     0,   527,     0,   189,   528,   190,
     529,   530,     0,     0,   531,     0,     0,     0,   532,   533,
       0,     0,   191,     0,     0,   194,   534,   535,   536,   537,
     538,     0,   539,   195,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,   198,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,     0,   563,   564,   206,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,     0,   575,
     210,   576,   577,     0,   578,   213,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   215,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,   216,
     217,     0,     0,   598,   218,   599,   219,     0,   600,   601,
     602,   603,   604,     0,     0,   605,   606,   607,   608,     0,
       0,   609,   610,   611,   612,   613,   227,   614,     0,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,   230,   231,   232,   233,   234,   235,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,    49,     0,   238,
     627,     0,     0,     0,     0,    52,    53,    54,    55,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2682,  2683,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,    49,     0,   238,   627,     0,     0,     0,     0,    52,
      53,    54,    55,     0,     0,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,  2683,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,   791,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,   792,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   388,  1401,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   389,   390,     0,     0,     0,   391,
     392,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,     0,
     406,   407,   408,     0,     0,     0,     0,     0,     0,     0,
     409,   410,     0,   411,     0,   412,   413,   414,     0,   133,
       0,   135,     0,     0,   415,   416,     0,   417,   418,     0,
       0,   419,   420,   136,   421,     0,   422,   423,   424,   425,
     140,     0,     0,   426,   427,   428,   429,   430,   431,     0,
     432,   433,   434,   435,   436,     0,   437,   438,   439,     0,
     440,     0,     0,     0,     0,     0,     0,   441,   442,   443,
     444,   445,   148,   149,   446,     0,   447,     0,   448,     0,
     449,   450,   451,     0,   452,   453,   454,     0,     0,   455,
     456,   457,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,   464,   465,   466,   157,   467,   468,   159,     0,
     469,   470,   471,   161,     0,   472,     0,   473,     0,     0,
       0,   474,     0,   475,     0,   476,   166,     0,   477,     0,
     478,   479,   480,   481,     0,   482,   483,   484,     0,   485,
     486,   487,   488,   489,   490,     0,     0,   169,     0,   491,
     492,   493,     0,   171,     0,   172,     0,     0,     0,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   176,     0,
     500,     0,     0,   501,   502,   503,     0,     0,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   183,     0,   185,     0,   517,   518,   519,   520,   521,
     522,   523,   186,   524,     0,   525,   526,     0,   527,     0,
     189,   528,   190,   529,   530,     0,     0,   531,     0,     0,
       0,   532,   533,     0,     0,   191,     0,     0,   194,   534,
     535,   536,   537,   538,     0,   539,   195,   196,   540,   541,
     542,     0,   543,   544,   545,   546,   547,   548,   198,   549,
     550,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,     0,   561,   562,     0,   563,   564,   206,   565,
     566,   567,   568,   569,   570,   571,     0,   208,   572,   573,
     574,     0,   575,   210,   576,   577,     0,   578,   213,     0,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     215,   589,     0,   590,   591,     0,   592,   593,   594,   595,
     596,     0,   216,   217,     0,     0,   598,   218,   599,   219,
       0,   600,   601,   602,   603,   604,     0,     0,   605,   606,
     607,   608,     0,     0,   609,   610,   611,   612,  1839,   227,
     614,     0,   615,   616,   617,     0,     0,   618,   619,   620,
     621,   622,   623,   229,   230,   231,   232,   233,   234,   235,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
       0,     0,   238,   627,     0,     0,     0,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   239,   102,   103,
     388,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,     0,   412,   413,
     414,     0,   133,     0,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,     0,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,     0,     0,     0,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,   481,     0,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,     0,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,     0,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   176,     0,   500,     0,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,     0,   185,     0,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
       0,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,   191,     0,
       0,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,     0,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
     208,   572,   573,   574,     0,   575,   210,   576,   577,     0,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,  1839,   227,   614,     0,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
     239,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,  1936,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   662,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,  3195,    96,
      97,    98,    99,   100,   101,   663,   102,   103,   388,   664,
       0,   105,   106,   107,   108,   665,   666,     0,   110,   111,
     112,     0,   113,   667,   668,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
     669,   406,   407,   408,   670,   671,   672,   673,   674,   675,
     676,   409,   410,   677,   411,   130,   412,   413,   414,   132,
    1600,   134,  1601,  1274,   678,   415,   416,     0,   417,   418,
     679,   680,   419,  1602,  1603,   421,   682,   422,   423,   424,
     425,     0,   683,   684,   426,   427,   428,   429,   430,   431,
     685,   432,   433,   434,   435,   436,   686,   437,   438,   439,
     145,   440,   687,   688,   689,   690,   691,   692,   441,   442,
     443,   444,   445,  1604,  1605,   446,   693,   447,   694,   448,
       0,   449,   450,   451,   695,   452,   453,   454,   696,   697,
     455,   456,  1287,   458,   459,   698,   460,   461,   462,   699,
       0,   463,   700,   464,   465,   466,     0,   467,   468,     0,
     701,   469,   470,   471,  1606,   702,   472,   703,   473,   162,
     704,   163,   474,     0,   475,   705,   476,     0,   706,   477,
     707,   478,   479,   480,   481,   167,   482,   483,   484,   708,
     485,   486,   487,   488,   489,   490,   709,   168,     0,     0,
     491,   492,   493,  1293,  1607,   712,  1608,   713,     0,   173,
     174,   494,   175,   495,   496,   497,   498,   499,   714,     0,
     177,   500,   178,   715,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,  1609,   184,  1610,   716,   517,   518,   519,   520,
     521,   522,   523,     0,   524,   717,   525,   526,   188,   527,
     718,     0,   528,  1611,   529,   530,   719,   720,   531,   721,
     722,   723,  3087,   533,   724,   725,     0,   192,   193,     0,
     534,   535,   536,   537,   538,     0,   539,     0,     0,   540,
     541,   542,   726,   543,   544,   545,   546,   547,   548,  1612,
     549,   550,   727,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   728,   561,   562,   204,   563,   564,     0,
     565,   566,   567,   568,   569,   570,   571,     0,   729,   572,
     573,   574,   730,   575,  2049,   576,   577,   212,   578,  1614,
     731,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,     0,   589,   732,   590,   591,   733,   592,   593,   594,
     595,   596,   734,  1615,  1616,     0,   736,   598,     0,   599,
       0,   737,   600,   601,   602,   603,   604,     0,   739,   605,
     606,   607,   608,   740,   741,   609,   610,   611,   612,     0,
    1617,   614,   228,   615,   616,   617,   742,   743,   618,   619,
     620,   621,   622,   623,     0,     0,     0,     0,     0,     0,
       0,     0,   624,   625,   626,     0,     0,     0,     0,     0,
     237,    49,  1078,   238,   627,     0,     0,     0,     0,    52,
      53,    54,    55,     0,    56,  1079,  1080,  1081,     0,  1082,
    3088,  1084,  1085,  1086,  1087,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,  1076,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,  1077,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,  1078,   238,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1079,  1080,  1081,     0,  1082,
    1083,  1084,  1085,  1086,  1087,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,  1078,   238,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1079,  1080,  1081,     0,  1082,
    1083,  1084,  1085,  1086,  1087,   662,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,   663,   102,   103,   388,
     664,     0,   105,   106,   107,   108,   665,   666,     0,   110,
     111,   112,     0,   113,   667,   668,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,   669,   406,   407,   408,   670,   671,   672,   673,   674,
     675,   676,   409,   410,   677,   411,   130,   412,   413,   414,
     132,   133,   134,   135,     0,   678,   415,   416,     0,   417,
     418,   679,   680,   419,   681,   136,   421,   682,   422,   423,
     424,   425,   140,   683,   684,   426,   427,   428,   429,   430,
     431,   685,   432,   433,   434,   435,   436,   686,   437,   438,
     439,   145,   440,   687,   688,   689,   690,   691,   692,   441,
     442,   443,   444,   445,   148,   149,   446,   693,   447,   694,
     448,     0,   449,   450,   451,   695,   452,   453,   454,   696,
     697,   455,   456,   457,   458,   459,   698,   460,   461,   462,
     699,     0,   463,   700,   464,   465,   466,   157,   467,   468,
     159,   701,   469,   470,   471,   161,   702,   472,   703,   473,
     162,   704,   163,   474,     0,   475,   705,   476,   166,   706,
     477,   707,   478,   479,   480,   481,   167,   482,   483,   484,
     708,   485,   486,   487,   488,   489,   490,   709,   168,   169,
     710,   491,   492,   493,   711,   171,   712,   172,   713,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,   714,
     176,   177,   500,   178,   715,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,   184,   185,   716,   517,   518,   519,
     520,   521,   522,   523,   186,   524,   717,   525,   526,   188,
     527,   718,   189,   528,   190,   529,   530,   719,   720,   531,
     721,   722,   723,   532,   533,   724,   725,   191,   192,   193,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,   726,   543,   544,   545,   546,   547,   548,
     198,   549,   550,   727,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   728,   561,   562,   204,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,   729,
     572,   573,   574,   730,   575,   210,   576,   577,   212,   578,
     213,   731,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,   732,   590,   591,   733,   592,   593,
     594,   595,   596,   734,   216,   217,   735,   736,   598,   218,
     599,   219,   737,   600,   601,   602,   603,   604,   738,   739,
     605,   606,   607,   608,   740,   741,   609,   610,   611,   612,
       0,   227,   614,   228,   615,   616,   617,   742,   743,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,     0,     0,     0,   662,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,  1571,    96,    97,    98,    99,   100,   101,   663,
     102,   103,   388,   664,     0,   105,   106,   107,   108,   665,
     666,     0,   110,   111,   112,     0,   113,   667,   668,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,   130,
     412,   413,   414,   132,  1600,   134,  1601,  1274,     0,   415,
     416,     0,   417,   418,     0,     0,   419,  1602,  1603,   421,
       0,   422,   423,   424,   425,     0,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,   145,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,  1604,  1605,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,  1287,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
       0,   467,   468,     0,     0,   469,   470,   471,  1606,     0,
     472,     0,   473,   162,     0,   163,   474,     0,   475,     0,
     476,     0,     0,   477,     0,   478,   479,   480,   481,   167,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,   168,     0,     0,   491,   492,   493,  1293,  1607,     0,
    1608,     0,     0,   173,   174,   494,   175,   495,   496,   497,
     498,   499,     0,     0,   177,   500,   178,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,  1609,   184,  1610,     0,
     517,   518,   519,   520,   521,   522,   523,     0,   524,     0,
     525,   526,   188,   527,     0,     0,   528,  1611,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
       0,   192,   193,     0,   534,   535,   536,   537,   538,     0,
     539,     0,     0,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,  1612,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
     204,   563,   564,     0,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,  1613,   576,
     577,   212,   578,  1614,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,     0,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,  1615,  1616,     0,
       0,   598,     0,   599,     0,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,     0,  1617,   614,   228,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,     0,     0,
       0,     0,     0,     0,     0,     0,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,     0,     0,
       0,     0,    83,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,  2006,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   388,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
     408,     0,     0,     0,     0,     0,     0,     0,   409,   410,
       0,   411,     0,   412,   413,   414,     0,   133,     0,   135,
       0,     0,   415,   416,     0,   417,   418,     0,     0,   419,
     420,   136,   421,     0,   422,   423,   424,   425,   140,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439,     0,   440,     0,
       0,     0,     0,     0,     0,   441,   442,   443,   444,   445,
     148,   149,   446,     0,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,   457,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,   157,   467,   468,   159,     0,   469,   470,
     471,   161,     0,   472,     0,   473,     0,     0,     0,   474,
       0,   475,     0,   476,   166,     0,   477,     0,   478,   479,
     480,   481,     0,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0,     0,   169,     0,   491,   492,   493,
       0,   171,     0,   172,     0,     0,     0,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   176,     0,   500,     0,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   183,
       0,   185,     0,   517,   518,   519,   520,   521,   522,   523,
     186,   524,     0,   525,   526,     0,   527,     0,   189,   528,
     190,   529,   530,     0,     0,   531,     0,     0,     0,   532,
     533,     0,     0,   191,     0,     0,   194,   534,   535,   536,
     537,   538,     0,   539,   195,   196,   540,   541,   542,     0,
     543,   544,   545,   546,   547,   548,   198,   549,   550,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562,     0,   563,   564,   206,   565,   566,   567,
     568,   569,   570,   571,     0,     0,   572,   573,   574,     0,
     575,   210,   576,   577,     0,   578,   213,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   215,   589,
       0,   590,   591,     0,   592,   593,   594,   595,   596,     0,
     216,   217,     0,     0,   598,   218,   599,   219,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,   613,   227,   614,     0,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,   229,   230,   231,   232,   233,   234,   235,   236,   624,
     625,   626,     0,     0,     0,     0,     0,   237,     0,     0,
     238,     0,     0,     0,     0,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,   976,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,  1917,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
    1918,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,  1919,     0,   531,     0,
    1920,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,  1921,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,    49,     0,   238,   627,     0,     0,     0,     0,    52,
      53,    54,    55,     0,    56,     0,     0,     0,     0,     0,
    1445,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   388,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,     0,     0,     0,   409,   410,     0,
     411,     0,   412,   413,   414,     0,   133,     0,   135,     0,
       0,   415,   416,     0,   417,   418,     0,     0,   419,   420,
     136,   421,     0,   422,   423,   424,   425,   140,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,     0,   440,     0,     0,
       0,     0,     0,     0,   441,   442,   443,   444,   445,   148,
     149,   446,  1927,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,   457,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,   157,   467,   468,   159,  1918,   469,   470,   471,
     161,     0,   472,     0,   473,     0,     0,     0,   474,     0,
     475,     0,   476,   166,     0,   477,     0,   478,   479,   480,
     481,     0,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,     0,   169,     0,   491,   492,   493,     0,
     171,     0,   172,     0,     0,     0,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   176,     0,   500,     0,     0,
     501,   502,   503,     0,     0,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   183,     0,
     185,     0,   517,   518,   519,   520,   521,   522,   523,   186,
     524,     0,   525,   526,     0,   527,     0,   189,   528,   190,
     529,   530,  1919,     0,   531,     0,  1920,     0,   532,   533,
       0,     0,   191,     0,     0,   194,   534,   535,   536,   537,
     538,     0,   539,   195,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,   198,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,     0,   563,   564,   206,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,     0,   575,
     210,   576,   577,     0,   578,   213,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   215,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,   216,
     217,     0,     0,   598,   218,   599,   219,  1921,   600,   601,
     602,   603,   604,     0,     0,   605,   606,   607,   608,     0,
       0,   609,   610,   611,   612,   613,   227,   614,     0,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,   230,   231,   232,   233,   234,   235,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,    49,     0,   238,
     627,     0,     0,     0,     0,    52,    53,    54,    55,     0,
      56,     0,     0,     0,     0,     0,  1445,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     388,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,     0,   412,   413,
     414,     0,   133,     0,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,     0,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,  1918,   469,   470,   471,   161,     0,   472,     0,
     473,     0,     0,     0,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,   481,     0,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,     0,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,     0,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   176,     0,   500,     0,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,     0,   185,     0,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
       0,   527,     0,   189,   528,   190,   529,   530,  1919,     0,
     531,     0,  1920,     0,   532,   533,     0,     0,   191,     0,
       0,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,     0,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,   210,   576,   577,     0,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,  1921,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,   613,   227,   614,     0,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,    49,     0,   238,   627,     0,     0,     0,
       0,    52,    53,    54,    55,     0,    56,     0,     0,     0,
       0,     0,  1445,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   388,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   883,   400,   401,   402,   403,   404,   405,   884,   406,
     407,   408,     0,     0,     0,     0,     0,     0,     0,   409,
     410,     0,   411,     0,   885,   413,   414,     0,   133,     0,
     135,     0,     0,   415,   416,     0,   417,   418,     0,     0,
     419,   420,   136,   421,     0,   422,   423,   424,   425,   140,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,     0,   440,
       0,     0,     0,     0,     0,     0,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,   159,     0,   469,
     470,   886,   161,     0,   472,     0,   887,     0,   888,     0,
     474,     0,   475,     0,   476,   166,     0,   477,     0,   478,
     479,   480,   481,     0,   482,   483,   484,   889,   485,   486,
     487,   488,   489,   490,     0,     0,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,     0,     0,   494,
       0,   495,   496,   497,   498,   890,     0,   176,     0,   500,
       0,     0,   501,   502,   503,     0,     0,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,     0,   185,     0,   891,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,     0,   527,     0,   189,
     528,   190,   529,   530,     0,     0,   531,     0,     0,     0,
     532,   533,     0,     0,   191,     0,     0,   194,   534,   535,
     536,   537,   538,     0,   539,   195,   196,   540,   541,   542,
       0,   892,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   893,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,     0,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
       0,   575,   210,   576,   577,     0,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   215,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   216,   217,     0,     0,   598,   218,   599,   219,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,     0,     0,   609,   610,   611,   612,   613,   227,   614,
       0,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,   230,   231,   232,   233,   234,   235,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,   627,     0,     0,     0,     0,     0,     0,     0,
      55,     0,     0,     0,     0,     0,     0,     0,   894,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   883,   400,   401,
     402,   403,   404,   405,   884,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     885,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   886,   161,     0,
     472,     0,   887,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   890,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     891,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   892,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   893,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,   627,     0,
       0,     0,     0,     0,     0,     0,    55,     0,     0,     0,
       0,     0,     0,     0,   894,   662,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,   663,   102,   103,   388,
     664,     0,   105,   106,   107,   108,   665,   666,     0,   110,
     111,   112,     0,   113,   667,   668,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,   130,   412,   413,   414,
     132,   133,   134,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,   145,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
     162,     0,   163,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,   167,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,   168,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,     0,
     176,   177,   500,   178,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,   184,   185,   791,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,   188,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
     792,     0,     0,   532,   533,     0,     0,   191,   192,   193,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,   204,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,   212,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,   228,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,    49,     0,   238,   627,     0,     0,  1328,  1329,
      52,    53,    54,    55,     0,    56,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,   651,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,  1371,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,   627,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,  1372,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3469,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,   597,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,    49,     0,   238,   627,     0,     0,     0,     0,    52,
      53,    54,    83,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   388,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
     408,     0,     0,     0,     0,     0,     0,     0,   409,   410,
       0,   411,     0,   412,   413,   414,     0,   133,     0,   135,
       0,     0,   415,   416,     0,   417,   418,     0,     0,   419,
     420,   136,   421,     0,   422,   423,   424,   425,   140,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439,     0,   440,     0,
       0,     0,     0,     0,     0,   441,   442,   443,   444,   445,
     148,   149,   446,  1031,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,   457,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,   157,   467,   468,   159,     0,   469,   470,
     471,   161,     0,   472,     0,   473,     0,     0,     0,   474,
       0,   475,     0,   476,   166,     0,   477,     0,   478,   479,
     480,   481,     0,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0,     0,   169,     0,   491,   492,   493,
       0,   171,     0,   172,     0,     0,     0,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   176,     0,   500,     0,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   183,
       0,   185,     0,   517,   518,   519,   520,   521,   522,   523,
     186,   524,     0,   525,   526,     0,   527,     0,   189,   528,
     190,   529,   530,     0,     0,   531,     0,     0,     0,   532,
     533,     0,     0,   191,     0,     0,   194,   534,   535,   536,
     537,   538,     0,   539,   195,   196,   540,   541,   542,     0,
     543,   544,   545,   546,   547,   548,   198,   549,   550,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562,     0,   563,   564,   206,   565,   566,   567,
     568,   569,   570,   571,     0,     0,   572,   573,   574,     0,
     575,   210,   576,   577,     0,   578,   213,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   215,   589,
       0,   590,   591,     0,   592,   593,   594,   595,   596,     0,
     216,   217,     0,     0,   598,   218,   599,   219,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,   613,   227,   614,     0,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,   229,   230,   231,   232,   233,   234,   235,   236,   624,
     625,   626,     0,     0,     0,     0,     0,   237,    49,     0,
     238,   627,     0,     0,     0,     0,    52,    53,    54,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
    1904,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,    49,     0,   238,   627,     0,
       0,     0,     0,    52,    53,    54,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,    49,     0,   238,   627,     0,     0,     0,     0,
      52,    53,    54,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   388,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,     0,     0,     0,   409,
     410,     0,   411,     0,   412,   413,   414,     0,   133,     0,
     135,     0,     0,   415,   416,     0,   417,   418,     0,     0,
     419,   420,   136,   421,     0,   422,   423,   424,   425,   140,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,     0,   440,
       0,     0,     0,     0,     0,     0,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,   159,     0,   469,
     470,   471,   161,     0,   472,     0,   473,     0,     0,     0,
     474,     0,   475,     0,   476,   166,     0,   477,     0,   478,
     479,   480,   481,     0,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,     0,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,     0,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   176,     0,   500,
       0,     0,   501,   502,   503,     0,     0,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,     0,   185,     0,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,     0,   527,     0,   189,
     528,   190,   529,   530,     0,     0,   531,     0,     0,     0,
     532,   533,     0,     0,   191,     0,     0,   194,   534,   535,
     536,   537,   538,     0,   539,   195,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,     0,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
       0,   575,   210,   576,   577,     0,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   215,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   216,   217,     0,     0,   598,   218,   599,   219,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,     0,     0,   609,   610,   611,   612,   613,   227,   614,
       0,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,   230,   231,   232,   233,   234,   235,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,     0,   954,  1670,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,   955,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   932,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   956,
       0,   957,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   958,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   959,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   960,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   961,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   962,   217,     0,     0,   963,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   936,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   964,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,    83,    84,    85,     0,    87,    88,
      89,    90,    91,     0,     0,     0,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,     0,     0,     0,
     105,   106,   107,   108,     0,   109,     0,   110,   111,   112,
   -1531,   113,   114,   115,     0,     0,     0,     0,     0,   118,
     119,     0,     0,     0,     0,   120,     0,     0,     0,     0,
       0,     0,     0,     0,   121,     0,   122,     0,   123,   124,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   130,     0,     0,     0,   132,   133,
     134,   135,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   136,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   148,   149,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   155,
       0,     0,     0,     0,     0,   157,     0,     0,   159,     0,
       0,     0,     0,   161,     0,     0,     0,     0,   162,     0,
     163,     0,     0,     0,     0,     0,   166,     0,     0,     0,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   168,   169,     0,     0,
       0,     0,     0,   171,     0,   172,     0,     0,   173,   174,
       0,   175,     0,     0,     0,     0,     0,     0,   176,   177,
       0,   178,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   183,   184,   185,     0,     0,     0,     0,     0,     0,
       0,     0,   186,     0,     0,     0,     0,   188,     0,     0,
     189,     0,   190,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   191,   192,   193,   194,     0,
       0,     0,     0,     0,     0,     0,   195,   196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   198,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   204,     0,     0,   206,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   210,     0,     0,   212,     0,   213,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     215,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   216,   217,     0,     0,     0,   218,     0,   219,
       0,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
       0,   228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   229,   230,   231,   232,   233,   234,   235,
     236,     0,     0,     0,     0,     0,     0,     0,     0,   237,
       0,     0,   238,     0,   379,    83,    84,    85,     0,    87,
      88,    89,    90,    91,     0,     0,     0,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,     0,     0,
       0,   105,   106,   107,   108,     0,   109,     0,   110,   111,
     112, -1532,   113,   114,   115,     0,     0,     0,     0,     0,
     118,   119,     0,     0,     0,     0,   120,     0,     0,     0,
       0,     0,     0,     0,     0,   121,     0,   122,     0,   123,
     124,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   130,     0,     0,     0,   132,
     133,   134,   135,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   136,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   148,   149,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,     0,     0,     0,     0,     0,   157,     0,     0,   159,
       0,     0,     0,     0,   161,     0,     0,     0,     0,   162,
       0,   163,     0,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   168,   169,     0,
       0,     0,     0,     0,   171,     0,   172,     0,     0,   173,
     174,     0,   175,     0,     0,     0,     0,     0,     0,   176,
     177,     0,   178,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   183,   184,   185,     0,     0,     0,     0,     0,
       0,     0,     0,   186,     0,     0,     0,     0,   188,     0,
       0,   189,     0,   190,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   191,   192,   193,   194,
       0,     0,     0,     0,     0,     0,     0,   195,   196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   198,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   204,     0,     0,   206,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   210,     0,     0,   212,     0,   213,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   216,   217,     0,     0,     0,   218,     0,
     219,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,     0,   228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   229,   230,   231,   232,   233,   234,
     235,   236,     0,     0,     0,     0,     0,     0,     0,     0,
     237,     0,     0,   238,     0,  1025,   662,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   663,   102,   103,
     388,   664,     0,   105,   106,   107,   108,   665,   666,     0,
     110,   111,   112,     0,   113,   667,   668,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,   669,   406,   407,   408,   670,   671,   672,   673,
     674,   675,   676,   409,   410,   677,   411,   130,   412,   413,
     414,   132,   133,   134,   135,     0,   678,   415,   416,     0,
     417,   418,   679,   680,   419,   681,   136,   421,   682,   422,
     423,   424,   425,   140,   683,   684,   426,   427,   428,   429,
     430,   431,   685,   432,   433,   434,   435,   436,   686,   437,
     438,   439,   145,   440,   687,   688,   689,   690,   691,   692,
     441,   442,   443,   444,   445,   148,   149,   446,   693,   447,
     694,   448,     0,   449,   450,   451,   695,   452,   453,   454,
     696,   697,   455,   456,   457,   458,   459,   698,   460,   461,
     462,   699,     0,   463,   700,   464,   465,   466,   157,   467,
     468,   159,   701,   469,   470,   471,   161,   702,   472,   703,
     473,   162,   704,   163,   474,     0,   475,   705,   476,   166,
     706,   477,   707,   478,   479,   480,   481,   167,   482,   483,
     484,   708,   485,   486,   487,   488,   489,   490,   709,   168,
     169,   710,   491,   492,   493,   711,   171,   712,   172,   713,
       0,   173,   174,   494,   175,   495,   496,   497,   498,   499,
     714,   176,   177,   500,   178,   715,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,   184,   185,   716,   517,   518,
     519,   520,   521,   522,   523,   186,   524,   717,   525,   526,
     188,   527,   718,   189,   528,   190,   529,   530,   719,   720,
     531,   721,   722,   723,   532,   533,   724,   725,   191,   192,
     193,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,   726,   543,   544,   545,   546,   547,
     548,   198,   549,   550,   727,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   728,   561,   562,   204,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
     729,   572,   573,   574,   730,   575,   210,   576,   577,   212,
     578,   213,   731,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,   732,   590,   591,   733,   592,
     593,   594,   595,   596,   734,   216,   217,   735,   736,   598,
     218,   599,   219,   737,   600,   601,   602,   603,   604,   738,
     739,   605,   606,   607,   608,   740,   741,   609,   610,   611,
     612,     0,   227,   614,   228,   615,   616,   617,   742,   743,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,   662,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   663,   102,   103,
     388,   664,     0,   105,   106,   107,   108,   665,   666,     0,
     110,   111,   112,     0,   113,   667,   668,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,   130,   412,   413,
     414,   132,   133,   134,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,   145,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,   162,     0,   163,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,   481,   167,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,   168,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,   173,   174,   494,   175,   495,   496,   497,   498,   499,
       0,   176,   177,   500,   178,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,   184,   185,   791,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
     188,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,   792,     0,     0,   532,   533,     0,     0,   191,   192,
     193,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,   204,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,   210,   576,   577,   212,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,   613,   227,   614,   228,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,   662,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   663,   102,   103,
     388,   664,     0,   105,   106,   107,   108,   665,   666,     0,
     110,   111,   112,     0,   113,   667,   668,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,   130,   412,   413,
     414,   132,   133,   134,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,   145,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,   162,     0,   163,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,  1184,   167,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,   168,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,   173,   174,   494,   175,   495,   496,   497,   498,   499,
       0,   176,   177,   500,   178,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,   184,   185,   791,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
     188,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,   792,     0,     0,   532,   533,     0,     0,   191,   192,
     193,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,   204,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,   210,   576,   577,   212,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,   613,   227,   614,   228,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,   662,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   663,   102,   103,
     388,   664,     0,   105,   106,   107,   108,   665,   666,     0,
     110,   111,   112,     0,   113,   667,   668,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,   130,   412,   413,
     414,   132,   133,   134,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,   145,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,   162,     0,   163,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,  1191,   167,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,   168,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,   173,   174,   494,   175,   495,   496,   497,   498,   499,
       0,   176,   177,   500,   178,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,   184,   185,   791,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
     188,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,   792,     0,     0,   532,   533,     0,     0,   191,   192,
     193,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,   204,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,   210,   576,   577,   212,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,   613,   227,   614,   228,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,   662,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   663,   102,   103,
     388,   664,     0,   105,   106,   107,   108,   665,   666,     0,
     110,   111,   112,     0,   113,   667,   668,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,   130,   412,   413,
     414,   132,  1600,   134,  1601,  1274,     0,   415,   416,     0,
     417,   418,     0,     0,   419,  1602,  1603,   421,     0,   422,
     423,   424,   425,     0,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,   145,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,  1604,  1605,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,  1287,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,     0,   467,
     468,     0,     0,   469,   470,   471,  1606,     0,   472,     0,
     473,   162,     0,   163,   474,     0,   475,     0,   476,     0,
       0,   477,     0,   478,   479,   480,   481,   167,   482,   483,
     484,  2046,   485,   486,   487,   488,   489,   490,     0,   168,
    2047,     0,   491,   492,   493,  1293,  1607,     0,  1608,     0,
       0,   173,   174,   494,   175,   495,   496,   497,   498,   499,
       0,     0,   177,   500,   178,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,  1609,   184,  1610,     0,   517,   518,
     519,   520,   521,   522,   523,     0,   524,     0,   525,   526,
     188,   527,     0,     0,   528,  1611,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,  2048,   192,
     193,     0,   534,   535,   536,   537,   538,     0,   539,     0,
       0,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,  1612,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,   204,   563,
     564,     0,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,  2049,   576,   577,   212,
     578,  1614,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,     0,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,  1615,  1616,     0,     0,   598,
       0,   599,     0,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,     0,  1617,   614,   228,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,     0,     0,     0,     0,
       0,     0,     0,     0,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,   662,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   663,   102,   103,
     388,   664,     0,   105,   106,   107,   108,   665,   666,     0,
     110,   111,   112,     0,   113,   667,   668,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,   130,   412,   413,
     414,   132,  1600,   134,  1601,  1274,     0,   415,   416,     0,
     417,   418,     0,     0,   419,  1602,  1603,   421,     0,   422,
     423,   424,   425,     0,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,   145,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,  1604,  1605,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,  1287,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,     0,   467,
     468,     0,     0,   469,   470,   471,  1606,     0,   472,     0,
     473,   162,     0,   163,   474,     0,   475,     0,   476,     0,
       0,   477,     0,   478,   479,   480,   481,   167,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,   168,
       0,     0,   491,   492,   493,  1293,  1607,     0,  1608,     0,
       0,   173,   174,   494,   175,   495,   496,   497,   498,   499,
       0,     0,   177,   500,   178,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,  1609,   184,  1610,     0,   517,   518,
     519,   520,   521,   522,   523,  2068,   524,     0,   525,   526,
     188,   527,     0,     0,   528,  1611,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,     0,   192,
     193,     0,   534,   535,   536,   537,   538,     0,   539,     0,
       0,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,  1612,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,   204,   563,
     564,     0,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,  1613,   576,   577,   212,
     578,  1614,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,     0,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,  1615,  1616,     0,     0,   598,
       0,   599,     0,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,     0,  1617,   614,   228,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,     0,     0,     0,     0,
       0,     0,     0,     0,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,  1462,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,  2460,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,  2461,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,   791,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
     792,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,  2462,   592,  2463,
     594,  2464,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,   627,   662,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   663,   102,   103,
     388,   664,     0,   105,   106,   107,   108,   665,   666,     0,
     110,   111,   112,     0,   113,   667,   668,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,   130,   412,   413,
     414,   132,  1600,   134,  1601,  1274,     0,   415,   416,     0,
     417,   418,     0,     0,   419,  1602,  1603,   421,     0,   422,
     423,   424,   425,     0,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,   145,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,  1604,  1605,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,  1287,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,     0,   467,
     468,     0,     0,   469,   470,   471,  1606,     0,   472,     0,
     473,   162,     0,   163,   474,     0,   475,     0,   476,     0,
       0,   477,     0,   478,   479,   480,   481,   167,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,   168,
       0,     0,   491,   492,   493,  1293,  1607,     0,  1608,     0,
       0,   173,   174,   494,   175,   495,   496,   497,   498,   499,
       0,     0,   177,   500,   178,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,  1609,   184,  1610,     0,   517,   518,
     519,   520,   521,   522,   523,  3021,   524,     0,   525,   526,
     188,   527,     0,     0,   528,  1611,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,     0,   192,
     193,     0,   534,   535,   536,   537,   538,     0,   539,     0,
       0,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,  1612,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,   204,   563,
     564,     0,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,  1613,   576,   577,   212,
     578,  1614,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,     0,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,  1615,  1616,     0,     0,   598,
       0,   599,     0,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,     0,  1617,   614,   228,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,     0,     0,     0,     0,
       0,     0,     0,     0,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,   662,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   663,   102,   103,
     388,   664,     0,   105,   106,   107,   108,   665,   666,     0,
     110,   111,   112,     0,   113,   667,   668,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,   130,   412,   413,
     414,   132,  1600,   134,  1601,  1274,     0,   415,   416,     0,
     417,   418,     0,     0,   419,  1602,  1603,   421,     0,   422,
     423,   424,   425,     0,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,   145,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,  1604,  1605,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,  1287,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,     0,   467,
     468,     0,     0,   469,   470,   471,  1606,     0,   472,     0,
     473,   162,     0,   163,   474,     0,   475,     0,   476,     0,
       0,   477,     0,   478,   479,   480,   481,   167,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,   168,
       0,     0,   491,   492,   493,  1293,  1607,     0,  1608,     0,
       0,   173,   174,   494,   175,   495,   496,   497,   498,   499,
       0,     0,   177,   500,   178,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,  1609,   184,  1610,     0,   517,   518,
     519,   520,   521,   522,   523,     0,   524,     0,   525,   526,
     188,   527,  2038,     0,   528,  1611,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,     0,   192,
     193,     0,   534,   535,   536,   537,   538,     0,   539,     0,
       0,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,  1612,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,   204,   563,
     564,     0,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,  2049,   576,   577,   212,
     578,  1614,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,     0,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,  1615,  1616,     0,     0,   598,
       0,   599,     0,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,     0,  1617,   614,   228,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,     0,     0,     0,     0,
       0,     0,     0,     0,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,   649,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,   650,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,   651,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,   627,   662,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   663,   102,   103,
     388,   664,     0,   105,   106,   107,   108,   665,   666,     0,
     110,   111,   112,     0,   113,   667,   668,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,   130,   412,   413,
     414,   132,  1600,   134,  1601,  1274,     0,   415,   416,     0,
     417,   418,     0,     0,   419,  1602,  1603,   421,     0,   422,
     423,   424,   425,     0,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,   145,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,  1604,  1605,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,  1287,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,     0,   467,
     468,     0,     0,   469,   470,   471,  1606,     0,   472,     0,
     473,   162,     0,   163,   474,     0,   475,     0,   476,     0,
       0,   477,     0,   478,   479,   480,   481,   167,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,   168,
       0,     0,   491,   492,   493,  1293,  1607,     0,  1608,     0,
       0,   173,   174,   494,   175,   495,   496,   497,   498,   499,
       0,     0,   177,   500,   178,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,  1609,   184,  1610,     0,   517,   518,
     519,   520,   521,   522,   523,     0,   524,     0,   525,   526,
     188,   527,     0,     0,   528,  1611,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,     0,   192,
     193,     0,   534,   535,   536,   537,   538,     0,   539,     0,
       0,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,  1612,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,   204,   563,
     564,     0,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,  1613,   576,   577,   212,
     578,  1614,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,     0,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,  1615,  1616,     0,     0,   598,
       0,   599,     0,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,     0,  1617,   614,   228,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,     0,     0,     0,     0,
       0,     0,     0,     0,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,   662,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   663,   102,   103,
     388,   664,     0,   105,   106,   107,   108,   665,   666,     0,
     110,   111,   112,     0,   113,   667,   668,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,   130,   412,   413,
     414,   132,  1600,   134,  1601,  1274,     0,   415,   416,     0,
     417,   418,     0,     0,   419,  1602,  1603,   421,     0,   422,
     423,   424,   425,     0,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,   145,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,  1604,  1605,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,  1287,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,     0,   467,
     468,     0,     0,   469,   470,   471,  1606,     0,   472,     0,
     473,   162,     0,   163,   474,     0,   475,     0,   476,     0,
       0,   477,     0,   478,   479,   480,   481,   167,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,   168,
       0,     0,   491,   492,   493,  1293,  1607,     0,  1608,     0,
       0,   173,   174,   494,   175,   495,   496,   497,   498,   499,
       0,     0,   177,   500,   178,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,  1609,   184,  1610,     0,   517,   518,
     519,   520,   521,   522,   523,     0,   524,     0,   525,   526,
     188,   527,     0,     0,   528,  1611,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,     0,   192,
     193,     0,   534,   535,   536,   537,   538,     0,   539,     0,
       0,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,  1612,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,   204,   563,
     564,     0,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,  2049,   576,   577,   212,
     578,  1614,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,     0,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,  1615,  1616,     0,     0,   598,
       0,   599,     0,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,     0,  1617,   614,   228,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,     0,     0,     0,     0,
       0,     0,     0,     0,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,   838,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,   839,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   840,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,   627,   662,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,   663,   102,   103,
     388,   664,     0,   105,   106,   107,   108,   665,   666,     0,
     110,   111,   112,     0,   113,   667,   668,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,   130,   412,   413,
     414,   132,  1600,   134,  1601,  1274,     0,   415,   416,     0,
     417,   418,     0,     0,   419,  1602,  1603,   421,     0,   422,
     423,   424,   425,     0,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,   145,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,  1604,  1605,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,  1287,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,     0,   467,
     468,     0,     0,   469,   470,   471,  1606,     0,   472,     0,
     473,   162,     0,   163,   474,     0,   475,     0,   476,     0,
       0,   477,     0,   478,   479,   480,   481,   167,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,   168,
       0,     0,   491,   492,   493,  1293,  1607,     0,  1608,     0,
       0,   173,   174,   494,   175,   495,   496,   497,   498,   499,
       0,     0,   177,   500,   178,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,  1609,   184,  1610,     0,   517,   518,
     519,   520,   521,   522,   523,     0,   524,     0,   525,   526,
     188,   527,     0,     0,   528,  1611,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,     0,   192,
     193,     0,   534,   535,   536,   537,   538,     0,   539,     0,
       0,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,  1612,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,   204,   563,
     564,     0,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,     0,   576,   577,   212,
     578,  1614,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,     0,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,  1615,  1616,     0,     0,   598,
       0,   599,     0,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,     0,  1617,   614,   228,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,     0,     0,     0,     0,
       0,     0,     0,     0,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,   651,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,   627,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,  1179,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,   627,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   879,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,   627,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   921,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,   627,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,   627,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   398,   399,   400,   401,   402,   403,   404,
     405,   669,   406,   407,   408,   670,   671,   672,   673,   674,
     675,   676,   409,   410,   677,   411,   130,   412,   413,   414,
     132,   133,   134,   135,     0,   678,   415,   416,     0,   417,
     418,   679,   680,   419,     0,   136,   421,   682,   422,   423,
     424,   425,   140,   683,   684,   426,   427,   428,   429,   430,
     431,   685,   432,   433,   434,   435,   436,   686,   437,   438,
     439,   145,   440,   687,   688,   689,   690,   691,   692,   441,
     442,   443,     0,   445,   148,   149,   446,   693,   447,   694,
     448,     0,   449,   450,   451,   695,   452,   453,   454,   696,
     697,   455,   456,   457,   458,   459,   698,   460,   461,   462,
     699,     0,   463,   700,   464,   465,   466,   157,   467,   468,
     159,   701,   469,   470,   471,   161,   702,   472,   703,   473,
     162,   704,   163,   474,     0,   475,   705,   476,   166,   706,
     477,   707,   478,   479,     0,   481,   167,   482,   483,   484,
     708,   485,   486,   487,   488,   489,   490,   709,   168,   169,
       0,   491,   492,   493,     0,   171,   712,   172,   713,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,   714,
     176,   177,   500,   178,   715,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,     0,   511,   512,     0,
     514,   515,   516,   183,   184,   185,   716,   517,   518,   519,
     520,   521,   522,   523,   186,   524,   717,   525,   526,   188,
     527,   718,   189,   528,   190,   529,   530,   719,   720,   531,
     721,   722,   723,   532,   533,   724,   725,   191,   192,   193,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,   726,   543,   544,   545,   546,   547,   548,
     198,   549,   550,   727,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   728,   561,   562,   204,   563,   564,
     206,   565,   566,   567,   568,   569,   570,     0,     0,   729,
     572,   573,   574,   730,   575,   210,   576,   577,   212,   578,
     213,   731,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,   732,   590,   591,   733,   592,   593,
     594,   595,   596,   734,   216,   217,     0,   736,   598,   218,
     599,   219,   737,   600,   601,   602,   603,   604,     0,   739,
     605,   606,   607,   608,   740,   741,   609,   610,   611,   612,
       0,   227,   614,   228,   615,   616,   617,   742,   743,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,     0,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,  2019,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
    2020,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,  2021,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,  2725,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,  2022,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,  2023,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   388,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   389,   390,     0,     0,     0,   391,
     392,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,   904,
     406,   407,   408,     0,     0,     0,     0,     0,     0,     0,
     409,   410,     0,   411,     0,   412,   413,   414,     0,   133,
       0,   135,     0,     0,   415,   416,     0,   417,   418,     0,
       0,   419,   420,   136,   421,     0,   422,   423,   424,   425,
     140,     0,     0,   426,   427,   428,   429,   430,   431,     0,
     432,   433,   434,   435,   436,   905,   437,   438,   439,     0,
     440,     0,     0,     0,     0,     0,     0,   441,   442,   443,
     444,   445,   148,   149,   446,     0,   447,     0,   448,     0,
     449,   450,   451,     0,   452,   453,   454,     0,     0,   455,
     456,   457,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,   464,   465,   466,   157,   467,   468,   159,     0,
     469,   470,   471,   161,     0,   472,     0,   473,     0,     0,
       0,   474,     0,   475,   945,   476,   166,     0,   477,     0,
     478,   479,   480,   481,     0,   482,   483,   484,     0,   485,
     486,   487,   488,   489,   490,     0,     0,   169,     0,   491,
     492,   493,     0,   171,     0,   172,     0,     0,     0,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   176,     0,
     500,     0,     0,   501,   502,   503,     0,     0,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   183,     0,   185,     0,   517,   518,   519,   520,   521,
     522,   523,   186,   524,     0,   525,   526,     0,   527,     0,
     189,   528,   190,   529,   530,     0,     0,   531,     0,     0,
       0,   532,   533,     0,     0,   191,     0,     0,   194,   534,
     535,   536,   537,   538,     0,   539,   195,   196,   540,   541,
     542,     0,   543,   544,   545,   546,   547,   548,   198,   549,
     550,   906,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,     0,   561,   562,     0,   563,   564,   206,   565,
     566,   567,   568,   569,   570,   571,     0,   907,   572,   573,
     574,     0,   575,   210,   576,   577,     0,   578,   213,     0,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     215,   589,     0,   590,   591,     0,   592,   593,   594,   595,
     596,     0,   216,   217,     0,     0,   598,   218,   599,   219,
       0,   600,   601,   602,   603,   604,     0,     0,   605,   606,
     607,   608,     0,     0,   609,   610,   611,   612,   613,   227,
     614,     0,   615,   616,   617,     0,     0,   618,   619,   620,
     621,   622,   623,   229,   230,   231,   232,   233,   234,   235,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
       0,     0,   238,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   388,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   904,   406,
     407,   408,     0,     0,     0,     0,     0,     0,     0,   409,
     410,     0,   411,     0,   412,   413,   414,     0,   133,     0,
     135,     0,     0,   415,   416,     0,   417,   418,     0,     0,
     419,   420,   136,   421,     0,   422,   423,   424,   425,   140,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,   905,   437,   438,   439,     0,   440,
       0,     0,     0,     0,     0,     0,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,   159,     0,   469,
     470,   471,   161,     0,   472,     0,   473,     0,     0,     0,
     474,     0,   475,     0,   476,   166,     0,   477,     0,   478,
     479,   480,   481,     0,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,     0,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,     0,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   176,     0,   500,
       0,     0,   501,   502,   503,     0,     0,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,     0,   185,     0,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,     0,   527,     0,   189,
     528,   190,   529,   530,     0,     0,   531,     0,     0,     0,
     532,   533,     0,     0,   191,     0,     0,   194,   534,   535,
     536,   537,   538,     0,   539,   195,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
     906,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,     0,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,   907,   572,   573,   574,
       0,   575,   210,   576,   577,     0,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   215,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   216,   217,     0,     0,   598,   218,   599,   219,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,     0,     0,   609,   610,   611,   612,   613,   227,   614,
       0,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,   230,   231,   232,   233,   234,   235,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,    83,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   388,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
     408,   127,   128,     0,     0,     0,     0,     0,   409,   410,
       0,   411,     0,   412,   413,   414,     0,   133,     0,   135,
       0,     0,   415,   416,     0,   417,   418,     0,     0,   419,
     420,   136,   421,     0,   422,   423,   424,   425,   140,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439,     0,   440,     0,
       0,     0,     0,     0,     0,   441,   442,   443,   444,   445,
     148,   149,   446,     0,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,   457,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,   157,   467,   468,   159,     0,   469,   470,
     471,   161,     0,   472,     0,   473,     0,     0,     0,   474,
       0,   475,     0,   476,   166,     0,   477,     0,   478,   479,
     480,   481,     0,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0,     0,   169,     0,   491,   492,   493,
       0,   171,     0,   172,     0,     0,     0,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   176,     0,   500,     0,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   183,
       0,   185,   791,   517,   518,   519,   520,   521,   522,   523,
     186,   524,     0,   525,   526,     0,   527,     0,   189,   528,
     190,   529,   530,     0,     0,   531,   792,     0,     0,   532,
     533,     0,     0,   191,     0,     0,   194,   534,   535,   536,
     537,   538,     0,   539,   195,   196,   540,   541,   542,     0,
     543,   544,   545,   546,   547,   548,   198,   549,   550,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562,     0,   563,   564,   206,   565,   566,   567,
     568,   569,   570,   571,     0,     0,   572,   573,   574,     0,
     575,   210,   576,   577,     0,   578,   213,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   215,   589,
       0,   590,   591,     0,   592,   593,   594,   595,   596,     0,
     216,   217,     0,     0,   598,   218,   599,   219,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,   613,   227,   614,     0,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,   229,   230,   231,   232,   233,   234,   235,   236,   624,
     625,   626,     0,     0,     0,     0,     0,   237,     0,     0,
     238,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   388,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,     0,     0,     0,   409,   410,     0,
     411,     0,   412,   413,   414,     0,   133,     0,   135,     0,
       0,   415,   416,     0,   417,   418,     0,     0,   419,   420,
     136,   421,     0,   422,   423,   424,   425,   140,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,     0,   440,     0,     0,
       0,     0,     0,     0,   441,   442,   443,   444,   445,   148,
     149,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,   457,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,   157,   467,   468,   159,     0,   469,   470,   471,
     161,     0,   472,     0,   473,     0,     0,     0,   474,     0,
     475,     0,   476,   166,     0,   477,     0,   478,   479,   480,
     481,     0,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,     0,   169,     0,   491,   492,   493,     0,
     171,     0,   172,     0,     0,     0,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   176,     0,   500,     0,     0,
     501,   502,   503,     0,     0,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   183,     0,
     185,   791,   517,   518,   519,   520,   521,   522,   523,   186,
     524,     0,   525,   526,     0,   527,     0,   189,   528,   190,
     529,   530,     0,     0,   531,   792,     0,   978,   532,   533,
       0,     0,   191,     0,     0,   194,   534,   535,   536,   537,
     538,     0,   539,   195,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,   198,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,     0,   563,   564,   206,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,     0,   575,
     210,   576,   577,     0,   578,   213,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   215,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,   216,
     217,     0,     0,   598,   218,   599,   219,     0,   600,   601,
     602,   603,   604,     0,     0,   605,   606,   607,   608,     0,
       0,   609,   610,   611,   612,   613,   227,   614,     0,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,   230,   231,   232,   233,   234,   235,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,     0,     0,   238,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   388,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,  1374,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
       0,   412,   413,   414,     0,   133,     0,   135,     0,     0,
     415,   416,     0,   417,   418,     0,     0,   419,   420,   136,
     421,     0,   422,   423,   424,   425,   140,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,     0,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,   148,   149,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,   457,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,   157,   467,   468,   159,     0,   469,   470,   471,   161,
       0,   472,     0,   473,     0,     0,     0,   474,     0,   475,
       0,   476,   166,     0,   477,     0,   478,   479,   480,   481,
       0,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,     0,   169,     0,   491,   492,   493,     0,   171,
       0,   172,     0,     0,     0,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   176,     0,   500,     0,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,     0,   185,
     791,   517,   518,   519,   520,   521,   522,   523,   186,   524,
       0,   525,   526,     0,   527,     0,   189,   528,   190,   529,
     530,     0,     0,   531,   792,     0,     0,   532,   533,     0,
       0,   191,     0,     0,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,   198,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,     0,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,   210,
     576,   577,     0,   578,   213,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,   216,   217,
       0,     0,   598,   218,   599,   219,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,   613,   227,   614,     0,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,  1749,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,  1750,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,  1751,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,   791,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,   792,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,  1752,   569,   570,
     571,     0,     0,  1753,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
    1754,  1755,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,   905,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,   906,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,   907,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,     0,   238,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     388,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,     0,   412,   413,
     414,     0,   133,     0,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,     0,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,     0,     0,     0,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,   481,     0,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,     0,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,     0,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   176,     0,   500,     0,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,     0,   185,   791,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
       0,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,   792,     0,     0,   532,   533,     0,     0,   191,     0,
       0,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,     0,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,   210,   576,   577,     0,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,   613,   227,   614,     0,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,   888,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
     889,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
    2610,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,  2611,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   388,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   389,   390,     0,     0,     0,   391,
     392,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,  2620,
     406,   407,   408,     0,     0,     0,     0,     0,     0,     0,
     409,   410,     0,   411,     0,   412,   413,   414,     0,   133,
       0,   135,     0,     0,   415,   416,     0,   417,   418,     0,
       0,   419,   420,   136,   421,     0,   422,   423,   424,   425,
     140,     0,     0,   426,   427,   428,   429,   430,   431,     0,
     432,   433,   434,   435,   436,     0,   437,   438,   439,     0,
     440,     0,     0,     0,     0,     0,     0,   441,   442,   443,
     444,   445,   148,   149,   446,     0,   447,     0,   448,     0,
     449,   450,   451,     0,   452,   453,   454,     0,     0,   455,
     456,   457,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,   464,   465,   466,   157,   467,   468,   159,     0,
     469,   470,   471,   161,     0,   472,     0,   473,     0,     0,
       0,   474,     0,   475,     0,   476,   166,     0,   477,     0,
     478,   479,   480,   481,     0,   482,   483,   484,     0,   485,
     486,   487,   488,   489,   490,     0,     0,   169,     0,   491,
     492,   493,     0,   171,     0,   172,     0,     0,     0,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   176,     0,
     500,     0,     0,   501,   502,   503,     0,     0,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   183,     0,   185,     0,   517,   518,   519,   520,   521,
     522,   523,   186,   524,     0,   525,   526,     0,   527,     0,
     189,   528,   190,   529,   530,     0,     0,   531,     0,     0,
       0,   532,   533,     0,     0,   191,     0,     0,   194,   534,
     535,   536,   537,   538,     0,   539,   195,   196,   540,   541,
     542,     0,   543,   544,   545,   546,   547,   548,   198,   549,
     550,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,     0,   561,   562,     0,   563,   564,   206,   565,
     566,   567,   568,   569,   570,   571,     0,     0,   572,   573,
     574,     0,   575,   210,   576,   577,     0,   578,   213,     0,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     215,   589,     0,   590,   591,     0,   592,   593,   594,   595,
     596,     0,   216,   217,     0,     0,   598,   218,   599,   219,
       0,   600,   601,   602,   603,   604,     0,     0,   605,   606,
     607,   608,  2621,     0,   609,   610,   611,   612,   613,   227,
     614,     0,   615,   616,   617,     0,     0,   618,   619,   620,
     621,   622,   623,   229,   230,   231,   232,   233,   234,   235,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
       0,     0,   238,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   388,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   658,   406,
     407,   408,     0,     0,     0,     0,     0,     0,     0,   409,
     410,     0,   411,     0,   412,   413,   414,     0,   133,     0,
     135,     0,     0,   415,   416,     0,   417,   418,     0,     0,
     419,   420,   136,   421,     0,   422,   423,   424,   425,   140,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,     0,   440,
       0,     0,     0,     0,     0,     0,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,   159,     0,   469,
     470,   471,   161,     0,   472,     0,   473,     0,     0,     0,
     474,     0,   475,     0,   476,   166,     0,   477,     0,   478,
     479,   480,   481,     0,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,     0,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,     0,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   176,     0,   500,
       0,     0,   501,   502,   503,     0,     0,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,     0,   185,     0,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,     0,   527,     0,   189,
     528,   190,   529,   530,     0,     0,   531,     0,     0,     0,
     532,   533,     0,     0,   191,     0,     0,   194,   534,   535,
     536,   537,   538,     0,   539,   195,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,     0,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
       0,   575,   210,   576,   577,     0,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   215,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   216,   217,     0,     0,   598,   218,   599,   219,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,     0,     0,   609,   610,   611,   612,   613,   227,   614,
       0,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,   230,   231,   232,   233,   234,   235,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,    83,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   388,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     399,   400,   401,   402,   403,   404,   405,   789,   406,   407,
     408,     0,     0,     0,     0,     0,     0,     0,   409,   410,
       0,   411,     0,   412,   413,   414,     0,   133,     0,   135,
       0,     0,   415,   416,     0,   417,   418,     0,     0,   419,
     420,   136,   421,     0,   422,   423,   424,   425,   140,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439,     0,   440,     0,
       0,     0,     0,     0,     0,   441,   442,   443,   444,   445,
     148,   149,   446,     0,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,   457,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,   157,   467,   468,   159,     0,   469,   470,
     471,   161,     0,   472,     0,   473,     0,     0,     0,   474,
       0,   475,     0,   476,   166,     0,   477,     0,   478,   479,
     480,   481,     0,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0,     0,   169,     0,   491,   492,   493,
       0,   171,     0,   172,     0,     0,     0,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   176,     0,   500,     0,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   183,
       0,   185,     0,   517,   518,   519,   520,   521,   522,   523,
     186,   524,     0,   525,   526,     0,   527,     0,   189,   528,
     190,   529,   530,     0,     0,   531,     0,     0,     0,   532,
     533,     0,     0,   191,     0,     0,   194,   534,   535,   536,
     537,   538,     0,   539,   195,   196,   540,   541,   542,     0,
     543,   544,   545,   546,   547,   548,   198,   549,   550,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562,     0,   563,   564,   206,   565,   566,   567,
     568,   569,   570,   571,     0,     0,   572,   573,   574,     0,
     575,   210,   576,   577,     0,   578,   213,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   215,   589,
       0,   590,   591,     0,   592,   593,   594,   595,   596,     0,
     216,   217,     0,     0,   598,   218,   599,   219,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,   613,   227,   614,     0,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,   229,   230,   231,   232,   233,   234,   235,   236,   624,
     625,   626,     0,     0,     0,     0,     0,   237,     0,     0,
     238,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   388,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,     0,  2761,     0,   409,   410,     0,
     411,     0,   412,   413,   414,     0,   133,     0,   135,     0,
       0,   415,   416,     0,   417,   418,     0,     0,   419,   420,
     136,   421,     0,   422,   423,   424,   425,   140,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,     0,   440,     0,     0,
       0,     0,     0,     0,   441,   442,   443,   444,   445,   148,
     149,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,   457,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,   157,   467,   468,   159,     0,   469,   470,   471,
     161,     0,   472,     0,   473,     0,     0,     0,   474,     0,
     475,     0,   476,   166,     0,   477,     0,   478,   479,   480,
     481,     0,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,     0,   169,     0,   491,   492,   493,     0,
     171,     0,   172,     0,     0,     0,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   176,     0,   500,     0,     0,
     501,   502,   503,     0,     0,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   183,     0,
     185,     0,   517,   518,   519,   520,   521,   522,   523,   186,
     524,     0,   525,   526,     0,   527,     0,   189,   528,   190,
     529,   530,     0,     0,   531,     0,     0,     0,   532,   533,
       0,     0,   191,     0,     0,   194,   534,   535,   536,   537,
     538,     0,   539,   195,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,   198,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,     0,   563,   564,   206,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,     0,   575,
     210,   576,   577,     0,   578,   213,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   215,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,   216,
     217,     0,     0,   598,   218,   599,   219,     0,   600,   601,
     602,   603,   604,     0,     0,   605,   606,   607,   608,     0,
       0,   609,   610,   611,   612,   613,   227,   614,     0,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,   230,   231,   232,   233,   234,   235,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,     0,     0,   238,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   388,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,  2774,     0,   409,   410,     0,   411,
       0,   412,   413,   414,     0,   133,     0,   135,     0,     0,
     415,   416,     0,   417,   418,     0,     0,   419,   420,   136,
     421,     0,   422,   423,   424,   425,   140,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,     0,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,   148,   149,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,   457,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,   157,   467,   468,   159,     0,   469,   470,   471,   161,
       0,   472,     0,   473,     0,     0,     0,   474,     0,   475,
       0,   476,   166,     0,   477,     0,   478,   479,   480,   481,
       0,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,     0,   169,     0,   491,   492,   493,     0,   171,
       0,   172,     0,     0,     0,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   176,     0,   500,     0,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,     0,   185,
       0,   517,   518,   519,   520,   521,   522,   523,   186,   524,
       0,   525,   526,     0,   527,     0,   189,   528,   190,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,   191,     0,     0,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,   198,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,     0,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,   210,
     576,   577,     0,   578,   213,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,   216,   217,
       0,     0,   598,   218,   599,   219,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,   613,   227,   614,     0,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,  2808,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,  3116,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,     0,   238,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     388,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,     0,   412,   413,
     414,     0,   133,     0,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,     0,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,  3118,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,     0,     0,     0,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,   481,     0,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,     0,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,     0,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   176,     0,   500,     0,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,     0,   185,     0,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
       0,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,   191,     0,
       0,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,     0,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,   210,   576,   577,     0,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,   613,   227,   614,     0,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,  3120,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,  3719,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   388,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   389,   390,     0,     0,     0,   391,
     392,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,     0,
     406,   407,   408,     0,     0,     0,     0,     0,     0,     0,
     409,   410,     0,   411,     0,   412,   413,   414,     0,   133,
       0,   135,     0,     0,   415,   416,     0,   417,   418,     0,
       0,   419,   420,   136,   421,     0,   422,   423,   424,   425,
     140,     0,     0,   426,   427,   428,   429,   430,   431,     0,
     432,   433,   434,   435,   436,     0,   437,   438,   439,     0,
     440,     0,     0,     0,     0,     0,     0,   441,   442,   443,
     444,   445,   148,   149,   446,     0,   447,     0,   448,     0,
     449,   450,   451,     0,   452,   453,   454,     0,     0,   455,
     456,   457,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,   464,   465,   466,   157,   467,   468,   159,     0,
     469,   470,   471,   161,     0,   472,     0,   473,     0,     0,
       0,   474,     0,   475,     0,   476,   166,     0,   477,     0,
     478,   479,   480,   481,     0,   482,   483,   484,     0,   485,
     486,   487,   488,   489,   490,     0,     0,   169,     0,   491,
     492,   493,     0,   171,     0,   172,     0,     0,     0,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   176,     0,
     500,     0,     0,   501,   502,   503,     0,     0,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   183,     0,   185,     0,   517,   518,   519,   520,   521,
     522,   523,   186,   524,     0,   525,   526,     0,   527,     0,
     189,   528,   190,   529,   530,     0,     0,   531,     0,     0,
       0,   532,   533,     0,     0,   191,     0,     0,   194,   534,
     535,   536,   537,   538,     0,   539,   195,   196,   540,   541,
     542,     0,   543,   544,   545,   546,   547,   548,   198,   549,
     550,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,     0,   561,   562,     0,   563,   564,   206,   565,
     566,   567,   568,   569,   570,   571,     0,     0,   572,   573,
     574,     0,   575,   210,   576,   577,     0,   578,   213,     0,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     215,   589,     0,   590,   591,     0,   592,   593,   594,   595,
     596,     0,   216,   217,     0,     0,   598,   218,   599,   219,
       0,   600,   601,   602,   603,   604,     0,     0,   605,   606,
     607,   608,     0,     0,   609,   610,   611,   612,   613,   227,
     614,     0,   615,   616,   617,     0,     0,   618,   619,   620,
     621,   622,   623,   229,   230,   231,   232,   233,   234,   235,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
       0,     0,   238,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   388,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,     0,     0,     0,   409,
     410,     0,   411,     0,   412,   413,   414,     0,   133,     0,
     135,     0,     0,   415,   416,     0,   417,   418,     0,     0,
     419,   420,   136,   421,     0,   422,   423,   424,   425,   140,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,     0,   440,
       0,     0,     0,     0,     0,     0,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,   159,     0,   469,
     470,   471,   161,     0,   472,     0,   473,     0,     0,     0,
     474,     0,   475,     0,   476,   166,     0,   477,     0,   478,
     479,   480,   481,     0,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,     0,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,     0,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   176,     0,   500,
       0,     0,   501,   502,   503,     0,     0,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,     0,   185,     0,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,     0,   527,     0,   189,
     528,   190,   529,   530,     0,     0,   531,     0,     0,     0,
     532,   533,     0,     0,   191,     0,     0,   194,   534,   535,
     536,   537,   538,     0,   539,   195,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,     0,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
       0,   575,   210,   576,   577,     0,   578,   213,     0,   579,
     580,   581,   844,   583,   584,   585,   586,   587,   588,   215,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   216,   217,     0,     0,   598,   218,   599,   219,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,     0,     0,   609,   610,   611,   612,   613,   227,   614,
       0,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,   230,   231,   232,   233,   234,   235,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,    83,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   388,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
     408,     0,     0,     0,     0,     0,     0,     0,   409,   410,
       0,   411,     0,   412,   413,   414,     0,   133,     0,   135,
       0,     0,   415,   416,     0,   417,   418,     0,     0,   419,
     420,   136,   421,     0,   422,   423,   424,   425,   140,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439,     0,   440,     0,
       0,     0,     0,     0,     0,   441,   442,   443,   444,   445,
     148,   149,   446,     0,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,   457,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,   157,   467,   468,   159,     0,   469,   470,
     471,   161,     0,   472,     0,   473,     0,     0,     0,   474,
       0,   475,     0,   476,   166,     0,   477,     0,   478,   479,
     480,   481,     0,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0,     0,   169,     0,   491,   492,   493,
       0,   171,     0,   172,     0,     0,     0,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   176,     0,   500,     0,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   183,
       0,   185,     0,   517,   518,   519,   520,   521,   522,   523,
     186,   524,     0,   525,   526,     0,   527,     0,   189,   528,
     190,   529,   530,     0,     0,   531,     0,     0,     0,   532,
     533,     0,     0,   191,     0,     0,   194,   534,   535,   536,
     537,   538,     0,   539,   195,   196,   540,   541,   542,     0,
     543,   544,   545,   546,   547,   548,   198,   549,   550,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562,     0,   563,   564,   206,   565,   566,   929,
     568,   569,   570,   571,     0,     0,   572,   573,   574,     0,
     575,   210,   576,   577,     0,   578,   213,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   215,   589,
       0,   590,   591,     0,   592,   593,   594,   595,   596,     0,
     216,   217,     0,     0,   598,   218,   599,   219,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,   613,   227,   614,     0,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,   229,   230,   231,   232,   233,   234,   235,   236,   624,
     625,   626,     0,     0,     0,     0,     0,   237,     0,     0,
     238,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   388,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,   931,   406,   407,   408,
       0,     0,     0,     0,     0,     0,     0,   409,   410,     0,
     411,     0,   412,   413,   414,     0,   133,     0,   135,     0,
       0,   415,   416,     0,   417,   418,     0,     0,   419,   932,
     136,   421,     0,   422,   423,   424,   425,   140,     0,     0,
     426,   427,   428,   429,   430,     0,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,     0,   440,     0,     0,
       0,     0,     0,     0,   441,   442,   443,   444,   445,   148,
     149,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,   457,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,   157,   467,   468,   159,     0,   469,   470,   471,
     161,     0,   472,     0,   473,     0,     0,     0,   474,     0,
     475,     0,   476,   166,     0,   477,     0,   478,   479,   480,
     481,     0,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,     0,   169,     0,   491,   492,   493,     0,
     171,     0,   172,     0,     0,     0,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   176,     0,   500,     0,     0,
     501,   502,   503,     0,     0,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   183,     0,
     185,     0,   517,   518,   519,   520,   521,   522,   523,   186,
     524,     0,   525,   526,     0,   527,     0,   189,   528,   190,
     529,   530,     0,     0,   531,     0,     0,     0,   532,   533,
       0,     0,   191,     0,     0,   194,   534,   535,   536,   537,
     538,     0,   539,   195,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,   198,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,     0,   563,   564,   206,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   933,     0,   575,
     210,   576,   577,     0,   578,   213,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   215,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,   934,
     217,     0,     0,   935,   218,   599,   219,     0,   600,   601,
     602,   603,   604,     0,     0,   605,   606,   607,   608,     0,
       0,   609,   610,   611,   612,   936,   227,   614,     0,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,   230,   231,   232,   233,   234,   235,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,     0,     0,   238,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   388,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,   967,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
       0,   412,   413,   414,     0,   133,     0,   135,     0,     0,
     415,   416,     0,   417,   418,     0,     0,   419,   932,   136,
     421,     0,   422,   423,   424,   425,   140,     0,     0,   426,
     427,   428,   429,   430,     0,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,     0,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,   148,   149,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,   457,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,   157,   467,   468,   159,     0,   469,   470,   471,   161,
       0,   472,     0,   473,     0,     0,     0,   474,     0,   475,
       0,   476,   166,     0,   477,     0,   478,   479,   480,   481,
       0,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,     0,   169,     0,   491,   492,   493,     0,   171,
       0,   172,     0,     0,     0,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   176,     0,   500,     0,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,     0,   185,
       0,   517,   518,   519,   520,   521,   522,   523,   186,   524,
       0,   525,   526,     0,   527,     0,   189,   528,   190,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,   191,     0,     0,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,   198,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,     0,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   968,     0,   575,   210,
     576,   577,     0,   578,   213,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,   969,   217,
       0,     0,   970,   218,   599,   219,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,   936,   227,   614,     0,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,  1189,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,  1193,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,     0,   238,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     388,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,     0,   412,   413,
     414,     0,   133,     0,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,     0,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,     0,     0,     0,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,  1201,     0,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,     0,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,     0,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   176,     0,   500,     0,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,     0,   185,     0,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
       0,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,   191,     0,
       0,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,     0,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,   210,   576,   577,     0,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,   613,   227,   614,     0,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,  1203,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,  1205,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   388,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   389,   390,     0,     0,     0,   391,
     392,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,     0,
     406,   407,   408,     0,     0,     0,     0,     0,     0,     0,
     409,   410,     0,   411,     0,   412,   413,   414,     0,   133,
       0,   135,     0,     0,   415,   416,     0,   417,   418,     0,
       0,   419,   420,   136,   421,     0,   422,   423,   424,   425,
     140,     0,     0,   426,   427,   428,   429,   430,   431,     0,
     432,   433,   434,   435,   436,     0,   437,   438,   439,     0,
     440,     0,     0,     0,     0,     0,     0,   441,   442,   443,
     444,   445,   148,   149,   446,     0,   447,     0,   448,     0,
     449,   450,   451,     0,   452,   453,   454,     0,     0,   455,
     456,   457,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,   464,   465,   466,   157,   467,   468,   159,     0,
     469,   470,   471,   161,     0,   472,     0,   473,     0,     0,
       0,   474,     0,   475,     0,   476,   166,     0,   477,     0,
     478,   479,   480,  1208,     0,   482,   483,   484,     0,   485,
     486,   487,   488,   489,   490,     0,     0,   169,     0,   491,
     492,   493,     0,   171,     0,   172,     0,     0,     0,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   176,     0,
     500,     0,     0,   501,   502,   503,     0,     0,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   183,     0,   185,     0,   517,   518,   519,   520,   521,
     522,   523,   186,   524,     0,   525,   526,     0,   527,     0,
     189,   528,   190,   529,   530,     0,     0,   531,     0,     0,
       0,   532,   533,     0,     0,   191,     0,     0,   194,   534,
     535,   536,   537,   538,     0,   539,   195,   196,   540,   541,
     542,     0,   543,   544,   545,   546,   547,   548,   198,   549,
     550,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,     0,   561,   562,     0,   563,   564,   206,   565,
     566,   567,   568,   569,   570,   571,     0,     0,   572,   573,
     574,     0,   575,   210,   576,   577,     0,   578,   213,     0,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     215,   589,     0,   590,   591,     0,   592,   593,   594,   595,
     596,     0,   216,   217,     0,     0,   598,   218,   599,   219,
       0,   600,   601,   602,   603,   604,     0,     0,   605,   606,
     607,   608,     0,     0,   609,   610,   611,   612,   613,   227,
     614,     0,   615,   616,   617,     0,     0,   618,   619,   620,
     621,   622,   623,   229,   230,   231,   232,   233,   234,   235,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
       0,     0,   238,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   388,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,     0,     0,     0,   409,
     410,     0,   411,     0,   412,   413,   414,     0,   133,     0,
     135,     0,     0,   415,   416,     0,   417,   418,     0,     0,
     419,   420,   136,   421,     0,   422,   423,   424,   425,   140,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,     0,   440,
       0,     0,     0,     0,     0,     0,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,   159,     0,   469,
     470,   471,   161,     0,   472,     0,   473,     0,     0,     0,
     474,     0,   475,     0,   476,   166,     0,   477,     0,   478,
     479,   480,  1210,     0,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,     0,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,     0,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   176,     0,   500,
       0,     0,   501,   502,   503,     0,     0,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,     0,   185,     0,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,     0,   527,     0,   189,
     528,   190,   529,   530,     0,     0,   531,     0,     0,     0,
     532,   533,     0,     0,   191,     0,     0,   194,   534,   535,
     536,   537,   538,     0,   539,   195,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,     0,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
       0,   575,   210,   576,   577,     0,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   215,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   216,   217,     0,     0,   598,   218,   599,   219,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,     0,     0,   609,   610,   611,   612,   613,   227,   614,
       0,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,   230,   231,   232,   233,   234,   235,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,    83,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   388,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
     408,     0,     0,     0,     0,     0,     0,     0,   409,   410,
       0,   411,     0,   412,   413,   414,     0,   133,     0,   135,
       0,     0,   415,   416,     0,   417,   418,     0,     0,   419,
     420,   136,   421,     0,   422,   423,   424,   425,   140,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439,     0,   440,     0,
       0,     0,     0,     0,     0,   441,   442,   443,   444,   445,
     148,   149,   446,     0,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,   457,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,   157,   467,   468,   159,     0,   469,   470,
     471,   161,     0,   472,     0,   473,     0,     0,     0,   474,
       0,   475,     0,   476,   166,     0,   477,     0,   478,   479,
     480,  1213,     0,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0,     0,   169,     0,   491,   492,   493,
       0,   171,     0,   172,     0,     0,     0,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   176,     0,   500,     0,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   183,
       0,   185,     0,   517,   518,   519,   520,   521,   522,   523,
     186,   524,     0,   525,   526,     0,   527,     0,   189,   528,
     190,   529,   530,     0,     0,   531,     0,     0,     0,   532,
     533,     0,     0,   191,     0,     0,   194,   534,   535,   536,
     537,   538,     0,   539,   195,   196,   540,   541,   542,     0,
     543,   544,   545,   546,   547,   548,   198,   549,   550,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562,     0,   563,   564,   206,   565,   566,   567,
     568,   569,   570,   571,     0,     0,   572,   573,   574,     0,
     575,   210,   576,   577,     0,   578,   213,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   215,   589,
       0,   590,   591,     0,   592,   593,   594,   595,   596,     0,
     216,   217,     0,     0,   598,   218,   599,   219,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,   613,   227,   614,     0,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,   229,   230,   231,   232,   233,   234,   235,   236,   624,
     625,   626,     0,     0,     0,     0,     0,   237,     0,     0,
     238,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   388,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,     0,     0,     0,   409,   410,     0,
     411,  1385,   412,   413,   414,     0,   133,     0,   135,     0,
       0,   415,   416,     0,   417,   418,     0,     0,   419,   932,
     136,  1386,     0,   422,   423,   424,   425,   140,     0,     0,
     426,   427,   428,   429,   430,     0,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,     0,   440,     0,     0,
       0,     0,     0,     0,   441,   442,   443,   444,   445,   148,
     149,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,   457,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,   157,   467,   468,   159,     0,   469,   470,   471,
     161,     0,   472,     0,   473,     0,     0,     0,   474,     0,
     475,     0,   476,   166,     0,   477,     0,   478,   479,   480,
     481,     0,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,     0,   169,     0,   491,   492,   493,     0,
     171,     0,   172,     0,     0,     0,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   176,     0,   500,     0,     0,
     501,   502,   503,     0,     0,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   959,   183,     0,
     185,     0,   517,   518,   519,   520,   521,   522,   523,   186,
     524,     0,   525,   526,     0,   527,     0,   189,   528,   190,
     529,   530,     0,     0,   531,     0,     0,     0,   532,   533,
       0,     0,   191,     0,     0,   194,   534,   535,   536,   537,
     538,     0,   539,   195,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,   198,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,     0,   960,   564,   206,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,  1377,     0,   575,
     210,   576,   577,     0,   578,   213,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   215,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,   962,
     217,     0,     0,   963,   218,   599,   219,     0,   600,   601,
     602,   603,   604,     0,     0,   605,   606,   607,   608,     0,
       0,   609,   610,   611,   612,   936,   227,   614,     0,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   964,
     229,   230,   231,   232,   233,   234,   235,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,     0,     0,   238,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   388,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,  1403,     0,   409,   410,     0,   411,
       0,   412,   413,   414,     0,   133,     0,   135,     0,     0,
     415,   416,     0,   417,   418,     0,     0,   419,   420,   136,
     421,     0,   422,   423,   424,   425,   140,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,     0,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,   148,   149,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,   457,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,   157,   467,   468,   159,     0,   469,   470,   471,   161,
       0,   472,     0,   473,     0,     0,     0,   474,     0,   475,
       0,   476,   166,     0,   477,     0,   478,   479,   480,   481,
       0,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,     0,   169,     0,   491,   492,   493,     0,   171,
       0,   172,     0,     0,     0,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   176,     0,   500,     0,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,     0,   185,
       0,   517,   518,   519,   520,   521,   522,   523,   186,   524,
       0,   525,   526,     0,   527,     0,   189,   528,   190,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,   191,     0,     0,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,   198,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,     0,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,     0,   210,
     576,   577,     0,   578,   213,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,   216,   217,
       0,     0,   598,   218,   599,   219,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,   613,   227,   614,     0,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,  1475,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
    1666,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,     0,   238,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     388,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,     0,   412,   413,
     414,     0,   133,     0,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,     0,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,     0,     0,     0,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,  1692,     0,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,     0,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,     0,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   176,     0,   500,     0,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,     0,   185,     0,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
       0,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,   191,     0,
       0,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,     0,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,   210,   576,   577,     0,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,   613,   227,   614,     0,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,  1694,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,  1782,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   388,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   389,   390,     0,     0,     0,   391,
     392,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,     0,
     406,   407,   408,     0,     0,     0,     0,     0,     0,     0,
     409,   410,     0,   411,     0,   412,   413,   414,     0,   133,
       0,   135,     0,     0,   415,   416,     0,   417,   418,     0,
       0,   419,   932,   136,   421,     0,   422,   423,   424,   425,
     140,     0,     0,   426,   427,   428,   429,   430,     0,     0,
     432,   433,   434,   435,   436,     0,   437,   438,   439,     0,
     440,     0,     0,     0,     0,     0,     0,   441,   442,   443,
     444,   445,   148,   149,   446,     0,   447,     0,   448,     0,
     449,   450,   451,     0,   452,   453,   454,     0,     0,   455,
     456,   457,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,   464,   465,   466,   157,   467,   468,   159,     0,
     469,   470,   471,   161,     0,   472,     0,   473,     0,     0,
       0,   474,     0,   475,     0,   476,   166,     0,   477,     0,
     478,   479,   480,   481,     0,   482,   483,   484,     0,   485,
     486,   487,   488,   489,   490,     0,     0,   169,     0,   491,
     492,   493,     0,   171,     0,   172,     0,     0,     0,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   176,     0,
     500,     0,     0,   501,   502,   503,     0,     0,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     959,   183,     0,   185,     0,   517,   518,   519,   520,   521,
     522,   523,   186,   524,     0,   525,   526,     0,   527,     0,
     189,   528,   190,   529,   530,     0,     0,   531,     0,     0,
       0,   532,   533,     0,     0,   191,     0,     0,   194,   534,
     535,   536,   537,   538,     0,   539,   195,   196,   540,   541,
     542,     0,   543,   544,   545,   546,   547,   548,   198,   549,
     550,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,     0,   561,   562,     0,   960,   564,   206,   565,
     566,   567,   568,   569,   570,   571,     0,     0,   572,   573,
    1377,     0,   575,   210,   576,   577,     0,   578,   213,     0,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     215,   589,     0,   590,   591,     0,   592,   593,   594,   595,
     596,     0,   962,   217,     0,     0,   963,   218,   599,   219,
       0,   600,   601,   602,   603,   604,     0,     0,   605,   606,
     607,   608,     0,     0,   609,   610,   611,   612,   936,   227,
     614,     0,   615,   616,   617,     0,     0,   618,   619,   620,
     621,   622,   964,   229,   230,   231,   232,   233,   234,   235,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
       0,     0,   238,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   388,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,     0,     0,     0,   409,
     410,     0,   411,     0,   412,   413,   414,     0,   133,     0,
     135,     0,     0,   415,   416,     0,   417,   418,     0,     0,
     419,   932,   136,   421,     0,   422,   423,   424,   425,   140,
       0,     0,   426,   427,   428,   429,   430,     0,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,     0,   440,
       0,     0,     0,     0,     0,     0,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,   159,     0,   469,
     470,   471,   161,     0,   472,     0,   473,     0,     0,     0,
     474,     0,   475,     0,   476,   166,     0,   477,     0,   478,
     479,   480,   481,     0,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,     0,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,     0,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   176,     0,   500,
       0,     0,   501,   502,   503,     0,     0,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   959,
     183,     0,   185,     0,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,     0,   527,     0,   189,
     528,   190,   529,   530,     0,     0,   531,     0,     0,     0,
     532,   533,     0,     0,   191,     0,     0,   194,   534,   535,
     536,   537,   538,     0,   539,   195,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,     0,   960,   564,   206,   565,   566,
     567,  2042,   569,   570,   571,     0,     0,   572,   573,  1377,
       0,   575,   210,   576,   577,     0,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   215,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   962,   217,     0,     0,   963,   218,   599,   219,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,     0,     0,   609,   610,   611,   612,   936,   227,   614,
       0,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   964,   229,   230,   231,   232,   233,   234,   235,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,    83,    84,    85,     0,    87,    88,    89,    90,
      91,     0,     0,     0,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,     0,     0,     0,   105,   106,
     107,   108,     0,   109,     0,   110,   111,   112,     0,   113,
     114,   115,     0,     0,     0,     0,     0,   118,   119,     0,
       0,     0,     0,   120,     0,     0,     0,     0,     0,     0,
       0,     0,   121,     0,   122,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   130,     0,     0,     0,   132,   133,   134,   135,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   136,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     148,   149,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   155,     0,     0,
       0,     0,     0,   157,     0,     0,   159,     0,     0,     0,
       0,   161,     0,     0,     0,     0,   162,     0,   163,     0,
       0,     0,     0,     0,   166,     0,     0,     0,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   168,   169,     0,     0,     0,     0,
       0,   171,     0,   172,     0,     0,   173,   174,     0,   175,
       0,     0,     0,     0,     0,     0,   176,   177,     0,   178,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   183,
     184,   185,     0,     0,     0,     0,     0,     0,     0,     0,
     186,     0,     0,     0,     0,   188,     0,     0,   189,     0,
     190,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   191,   192,   193,   194,     0,     0,     0,
       0,     0,     0,     0,   195,   196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   198,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   204,     0,     0,   206,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   210,     0,     0,   212,     0,   213,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   215,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     216,   217,     0,     0,     0,   218,     0,   219,     0,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,     0,   228,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   229,   230,   231,   232,   233,   234,   235,   236,     0,
       0,     0,     0,     0,     0,     0,     0,   237,     0,     0,
     238,    83,    84,    85,     0,    87,    88,    89,    90,    91,
       0,     0,     0,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,     0,     0,     0,   105,   106,   107,
     108,     0,   109,     0,   110,   111,   112,     0,   113,   114,
     115,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   130,     0,     0,     0,   132,   133,   134,   135,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     136,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   148,
     149,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,     0,     0,     0,
       0,     0,   157,     0,     0,   159,     0,     0,     0,     0,
     161,     0,     0,     0,     0,   162,     0,   163,     0,     0,
       0,     0,     0,   166,     0,     0,     0,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   168,   169,     0,     0,     0,     0,     0,
     171,     0,   172,     0,     0,   173,   174,     0,   175,     0,
       0,     0,     0,     0,     0,   176,   177,     0,   178,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   183,   184,
     185,     0,     0,     0,     0,     0,     0,     0,     0,   186,
       0,     0,     0,     0,   188,     0,     0,   189,     0,   190,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   191,   192,   193,   194,     0,     0,     0,     0,
       0,     0,     0,   195,   196,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   198,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   204,     0,     0,   206,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     210,     0,     0,   212,     0,   213,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   216,
     217,     0,     0,     0,   218,     0,   219,     0,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,     0,   228,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     229,   230,   231,   232,   233,   234,   235,   236,     0,     0,
       0,     0,     0,     0,     0,     0,   237,     0,     0,   238,
      83,    84,    85,     0,    87,    88,    89,    90,    91,     0,
       0,     0,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,     0,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     130,     0,     0,     0,   132,   133,   134,   135,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   136,
       0,     0,     0,     0,     0,     0,   140,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   148,   149,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   157,     0,     0,   159,     0,     0,     0,     0,   161,
       0,     0,     0,     0,   162,     0,   163,     0,     0,     0,
       0,     0,   166,     0,     0,     0,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   168,   169,     0,     0,     0,     0,     0,   171,
       0,   172,     0,     0,   173,   174,     0,   175,     0,     0,
       0,     0,     0,     0,   176,   177,     0,   178,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   183,   184,   185,
       0,     0,     0,     0,     0,     0,     0,     0,   186,     0,
       0,     0,     0,   188,     0,     0,   189,     0,   190,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   191,   192,   193,   194,     0,     0,     0,     0,     0,
       0,     0,   195,   196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   198,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   204,     0,     0,   206,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   210,
       0,     0,   212,     0,   213,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   215,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   216,   217,
       0,     0,     0,   218,     0,   219,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,     0,   228,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   229,
     230,   231,   232,   233,   234,   235,   236,     0,     0,     0,
       0,     0,     0,     0,     0,   237,     0,     0,   238
};

static const short yycheck[] =
{
       2,   239,  1192,   917,   999,   147,    78,  1697,  1712,    78,
     114,   146,    78,  1629,   144,    81,    78,   114,  1529,    81,
    1750,  1108,   220,  1254,   203,  1266,    78,  1038,   766,  1113,
     773,  1722,   770,   758,    78,  1894,  1020,  1314,   346,   767,
     858,   769,   963,   957,   862,   346,  1631,  1385,  1057,  1142,
    1681,   155,  2339,   871,   782,   197,   224,    78,   155,   973,
    1974,  1285,  1286,  2248,   838,   803,  1092,   114,    86,    78,
     813,  1647,    81,  1227,  2542,  1101,  1785,  1647,   129,  2163,
    1304,   809,  2707,  2067,    86,  1647,  1936,  2001,  1155,  1038,
     202,  2005,  1185,  1647,  1647,   823,  1163,   209,  1647,   211,
    1075,   971,  2259,  2717,  2749,   114,  2253,  2254,   155,  2978,
     153,  1945,  1484,   851,   882,   209,  1228,   860,   222,   857,
    1219,  3131,   143,  1613,  1150,   222,  1170,  1942,  1072,   903,
      22,  1157,    23,    38,    11,    72,  2683,   146,  1164,  1038,
    1034,  1035,    90,    72,   146,    89,   155,  2878,    89,  2053,
    2054,  2189,  2190,  2191,  2192,   115,   876,    81,    95,   201,
       2,   157,   180,   109,   109,   115,  1277,  1278,   240,    75,
      81,   240,   162,   181,   109,   222,    94,   238,   180,    78,
    1334,   955,    81,   152,   114,  1696,   109,    94,   240,  1300,
     102,    78,   760,   202,    81,   176,   240,   156,    72,   162,
     209,    77,   211,   117,   278,   162,    30,   207,   109,   220,
     124,    72,   298,   222,  2198,   114,    81,   131,   239,   240,
     296,    95,   201,    88,   201,   155,   124,   114,    81,    93,
     157,   296,  1848,    84,   201,    88,    81,  3425,   127,   121,
     159,    82,   232,    88,    77,   214,    38,    81,   184,    78,
     184,   183,   238,   312,   299,  3723,   155,  3195,   162,  3197,
    2174,    81,  1399,   203,   196,   129,  3606,   155,   155,   232,
     174,   359,   202,   117,   117,   232,   238,   202,   184,   209,
     346,   211,   146,    72,   198,  2269,   396,  2271,   131,   254,
      72,   242,   222,   164,   162,  3721,  3722,   266,   174,   366,
     269,   337,  1389,   202,   236,  1816,    95,     0,   227,  1493,
     209,   100,   211,    95,   157,   381,   159,  3327,    89,   381,
     286,    16,   254,   222,   287,   288,  1664,   312,   364,   238,
    3798,   288,   420,   298,   222,   222,   238,   346,   238,  1616,
     162,   174,   238,    77,   201,    72,   413,  1356,  1076,  1077,
      16,  3819,   337,  1537,   198,    39,  3585,    41,  1228,   286,
    3700,   771,   328,   359,    72,   775,   298,   286,  1238,  1239,
     444,  3797,   381,   783,   306,    72,   486,  1388,   329,  1117,
    1604,  1605,  1200,  1126,   227,  1123,  1111,  1611,   357,   314,
    1580,   479,   233,   317,   174,  1479,   359,   343,   343,  3409,
     486,   811,   359,   479,   238,   815,   230,    72,   343,   323,
     232,   240,   352,  3601,   479,   825,   320,   299,   238,    72,
     343,   482,   481,   413,   420,  1153,  1154,   354,  1246,   396,
     366,   220,   366,  1171,   479,  3445,   472,   479,  1256,   398,
     174,  1169,   343,   286,   350,   301,   427,   346,   291,  1267,
     413,   240,   241,   415,   762,  1522,   413,   420,   240,   346,
     366,   762,   597,   420,  2154,   389,   384,   391,  1196,  1197,
     381,   479,  2057,   432,   443,   486,   408,   384,  1668,   323,
     323,  1568,   381,   479,  1354,  1578,   486,  1055,   364,   340,
     333,  1602,  1603,   220,   381,   409,   482,  1217,   396,  1610,
     289,   352,   452,  2318,   337,   455,   371,   486,  3239,   486,
     460,   461,   462,   240,   303,  1499,   479,   406,   371,   479,
     384,  1505,   479,   415,  1394,  1395,   371,  3465,  3538,   479,
    1597,   479,   240,   477,  3002,  3003,   477,   359,   475,   396,
     486,   486,   419,   240,   415,   413,   475,  1684,   480,   400,
     455,   486,  1689,  3100,  3101,  3102,  3103,  3104,  1457,  2049,
    1454,  1698,    78,   486,   455,   409,   409,   479,  1594,  1513,
    2654,  2485,  2656,  2657,  1711,   240,   303,   486,   312,  2764,
     482,   473,   482,  2768,   364,   481,  2670,   240,   597,    26,
      78,   413,   157,    81,  2409,   597,  3825,  1581,   472,   473,
     474,   475,   286,   337,   772,   100,   303,   242,   129,   777,
     778,   472,   473,   474,   475,  1727,   784,  2248,   201,  1718,
    2479,   455,  1666,   238,   481,   405,   114,   183,   485,   463,
    1784,  1785,   339,   768,   769,   455,   201,   471,   303,    26,
    1408,  1795,  2014,   463,  1798,   166,    72,   196,   482,    36,
     159,   471,  1806,  1807,   758,  2693,  2560,  2491,  2562,   238,
     452,   758,   482,   455,   453,  1819,  1820,   155,   460,   461,
     462,   463,   807,   465,  2658,  2659,  1830,   129,   846,   471,
     236,   470,   471,   472,   473,   474,   475,  3623,   470,   471,
     472,   473,   474,   475,   329,   430,   762,   301,   840,  1810,
    1811,   129,   209,   350,    26,   129,   477,  3717,   479,   480,
     481,   758,   203,   109,   166,   486,   169,   201,   171,   451,
     855,   216,   454,   430,   240,   220,   453,   114,    81,   480,
    1884,   152,   332,   597,   222,   486,   220,   214,   166,   466,
     467,   468,   166,   470,   471,   472,   473,   474,   475,   758,
     306,   486,  1836,   762,   797,  3765,   453,   766,   253,  1484,
     115,   770,   470,   471,   472,   473,   474,   475,  2682,   466,
     467,   468,  2676,   470,   471,   472,   473,   474,   475,   486,
     798,   157,   291,   480,   827,  3410,  1529,   157,   453,   266,
     339,   159,   313,   214,   803,    77,   798,   234,   157,  1883,
    3445,    83,  2706,  3417,   312,   470,   471,   472,   473,   474,
     475,   415,   303,   205,   240,  2972,   169,   470,   471,   472,
     473,   474,   475,   302,  1552,  1553,  1554,  1555,   758,   337,
    3766,   396,   479,   286,   151,   844,   415,  2468,   396,  1753,
    1754,   348,   851,   296,  2748,   266,   958,   234,   857,   961,
     131,   486,   408,   152,  1582,  1583,  1726,    72,   346,   758,
    1588,   313,   102,   762,   958,   257,  2482,   961,  1738,   390,
     157,   758,  1690,   368,   876,   762,   157,   303,   152,   479,
     357,  1699,   278,   322,   169,   313,   171,   452,   379,   313,
     455,  1709,   174,   381,   203,   460,   461,   462,  3539,    91,
     322,  3770,  3771,   921,   150,   956,   223,   137,   974,   149,
     286,  3379,   234,   430,   312,   214,   481,  1642,   286,   921,
     485,   291,  1650,  1651,  1652,  1653,   156,   286,   486,  2440,
     948,  1749,   162,  1751,  1752,   161,   357,  1755,   390,   337,
     214,   959,   960,  1681,   953,  1683,   948,   343,  3589,   958,
    1688,  3820,   961,  1696,   433,   215,   186,   959,   960,   398,
    2184,  2999,   390,   240,   196,   974,   390,   266,   364,   486,
     269,   479,  2557,   165,   838,   984,   398,   266,   387,  2564,
     269,  3065,  3066,  3067,  3068,  3069,  3070,  1715,   311,  2000,
     102,   231,   266,   432,   303,   269,   157,   389,   119,   391,
     376,  3186,   232,   379,   130,   286,  3191,  1111,  1992,  3194,
     432,   296,  1750,   239,  1111,   879,  1034,  1035,   266,   265,
      72,   267,   254,   398,   301,   240,  3667,   453,   958,   430,
     312,   961,  1034,  1035,   876,  3182,  1038,   149,   278,   903,
     466,   467,   468,    95,   470,   471,   472,   473,   474,   475,
     352,  2000,   178,   161,   480,   337,   132,  1560,   357,   958,
     205,  1931,   961,  2130,  1111,    72,   298,   422,   357,   386,
     387,   192,   117,  1816,  2264,   974,   337,  2807,  2104,  2105,
      87,   388,   158,   357,   354,   486,   131,   974,   303,   133,
    2065,   955,   956,    72,   215,   137,  1334,   452,   400,  2789,
     455,  1110,  1111,   364,  3572,   460,   461,   462,  1117,   357,
    3735,   202,   257,  2097,  1123,   355,  2100,  2101,   388,   231,
    2970,   196,   479,  1141,   479,  2834,  1851,   171,  1946,   359,
      72,   239,  2708,  2764,   260,  1144,  1639,  2768,  2708,  1141,
    2277,   162,  1645,  2280,   443,    87,  2708,  2284,   224,  2216,
    2217,  2218,  2219,   198,  2708,  2708,  1659,  1229,   396,  2708,
    1229,   431,  1171,  1471,   206,   452,   278,  2260,   455,   443,
    1471,   350,   479,   460,   461,   462,  1248,  1229,  1020,   254,
     479,  1111,   352,   413,  3168,  1229,   312,   352,   240,   241,
     420,  3105,   452,  2347,  1212,   455,  1038,  3484,   398,   388,
     460,   461,   462,   132,  2341,   479,   312,   482,  1229,   479,
    1212,   232,  1111,   312,  1216,  1217,   341,  1219,  1227,  3203,
     389,  3205,   391,   298,  1111,  1999,   329,  1248,   466,   158,
     400,   337,   432,   240,   413,   400,  1646,   289,   453,   364,
    2394,  2059,   431,   355,   389,  1254,   391,  2256,   419,   479,
    1271,   466,   467,   468,  2072,   470,   471,   472,   473,   474,
     475,   240,   388,   366,   390,   364,  1275,  1288,  2086,  2423,
     758,   185,  2090,  2676,   762,   423,   202,  3462,   323,   291,
     425,  3365,  3366,  3367,   455,   211,   291,   119,   165,  2014,
     479,   452,  1301,    79,   455,   224,   303,  1318,   240,   460,
     461,   462,   463,  2706,  2458,   430,   360,   221,   430,   431,
     413,   312,    98,  1334,  3708,   160,  2470,  2471,  1336,  2855,
    1371,  1372,  1331,  1332,   303,  1334,   203,   160,  1346,   196,
    1434,   360,   453,   387,  1336,     5,   160,  1434,   359,  3794,
     341,  2565,  1351,  2879,  1346,   466,   467,   468,   215,   470,
     471,   472,   473,   474,   475,  1357,    26,   479,   387,   486,
     192,   303,   482,   364,   409,   125,    36,  1385,  3762,  1435,
    1436,   425,   217,  3767,  1216,  1217,  1488,  1219,  3833,  1388,
    1484,   483,   142,  1385,   217,   312,  1388,  1484,  1556,  1253,
    1392,  1393,   413,   217,   154,  1507,   425,  1418,  1419,   420,
    1421,  1452,  3796,   234,  3859,  1471,  2543,   329,  2492,  2747,
     337,  1420,  1478,   312,  1423,  1424,   338,   350,   470,   471,
     472,   473,   474,   475,    42,  1434,  1435,  1436,  2156,  2157,
    2158,  2159,  2160,  2161,   430,   431,  1454,  1484,   337,   361,
     452,   415,   375,   455,   114,   205,   453,   452,   460,   461,
     462,    18,  1454,  3312,  1068,   460,   461,   462,   479,   466,
     467,   468,  1471,   470,   471,   472,   473,   474,   475,  1478,
    2393,  1480,  2395,  2396,   453,  1484,  2613,  2614,  1092,  1488,
    3564,    96,   356,   479,    52,   246,   974,  1101,   467,   468,
    3106,   470,   471,   472,   473,   474,   475,    72,  1507,    35,
     337,   116,    70,   173,   341,  1514,   452,  1371,  1372,   455,
    2248,   453,   480,   478,   460,   461,   462,   396,   486,  1528,
      95,   486,  2296,  1761,   466,   467,   468,   364,   470,   471,
     472,   473,   474,   475,   895,  1434,  1435,  1436,  1642,   169,
    2268,   171,  2270,   479,   312,  1642,  1388,  1434,  1435,  1436,
    1392,  1393,  1687,   400,  1484,  3186,   480,   918,  1488,  2480,
    3191,   191,   486,  3194,   234,   312,   455,   455,   339,   337,
    1579,   124,  1471,   341,   463,   463,   465,  1507,   131,  1478,
    3165,   326,   471,   471,  1471,  1484,  2827,  1596,  1452,  1488,
     337,  1478,   356,   430,   455,  1642,   364,  1484,  1728,   134,
    1779,  2011,   463,  1445,  1613,  2015,  2883,  2884,  1507,  3593,
     478,   477,  2596,   479,   389,   481,   391,   364,   486,  2603,
    2604,   453,  2032,  1111,  2778,  1933,  2036,    85,    86,  1638,
    3321,   480,  1933,  1642,   466,   467,   468,   486,   470,   471,
     472,   473,   474,   475,   312,  2782,  1664,  2784,  2058,  2786,
    2060,  2788,  1538,  2790,   223,  1541,   108,  1499,  2795,  1545,
    1681,   291,  1664,  1505,  3280,  2676,   296,   477,  2735,   337,
     453,   481,  1681,   341,  1683,   487,  2401,  1686,   455,  1688,
     480,  2406,   202,  2093,   136,  2503,   486,  2918,  1697,   215,
     297,  2828,   480,  2777,   301,  2706,   364,  2440,   486,  1771,
     106,   452,  1771,   470,   471,   472,   473,   474,   228,   460,
     461,   462,  1642,   480,   356,     7,  1718,  2127,    10,  1771,
    1722,   117,   479,   243,  2134,   452,  2136,  1771,    20,    21,
    2468,   251,  2816,   460,   461,   462,  2890,   189,   480,  1581,
    1761,  1750,   482,  1642,   486,   482,   486,  1851,    40,   486,
    1771,    43,   479,   246,  1851,  1642,   238,  2500,  1144,   480,
     452,   157,   430,  2581,  2582,   486,   218,   480,   460,   461,
     462,   483,   402,   486,   474,  1784,  1785,   119,   477,   479,
     410,   481,   481,  1792,  3008,  1803,  1795,   479,   474,  1798,
     480,   454,   455,   479,  1803,   481,   486,  1806,  1807,   301,
     480,  1803,   114,   115,  1851,  1814,   486,  3318,  1817,  1818,
    1819,  1820,  3443,   448,   449,   450,  2900,   325,  1827,  1828,
     883,  1830,   885,  1832,   887,   106,  1835,   347,   452,   480,
     893,  3462,    96,   480,  1855,   486,   460,   461,   462,   486,
    1849,  1850,  1851,  1418,  1419,  1854,  1421,   377,   378,  1858,
     192,   445,  3582,  1862,   242,   479,  1865,  1866,  1867,  1868,
    1869,  1870,  1871,  1872,  1873,   481,  1875,  1933,  1254,   304,
     484,  1880,   486,    72,  2602,  1884,  1718,  2964,   170,   480,
    1722,  2016,   477,   141,   479,   486,   430,   431,    87,   341,
     286,   343,  1910,   345,   480,   291,   301,  3077,  3078,   351,
     486,  3081,  2312,  3083,   141,   463,   358,   465,  1910,  1975,
    2014,  1977,   364,  1975,   301,  1977,  3532,  2014,   430,   431,
     372,  1851,   452,   396,  1933,   455,   445,   323,   380,  2339,
     460,   461,   462,  2676,     8,   480,  1945,   333,    12,    13,
      14,   486,   304,    90,   202,    96,  1434,  1435,  1436,    23,
      24,    25,  1851,    27,    28,   484,   480,   486,    32,    33,
      34,   108,   486,  2706,  1851,   202,  1975,  2014,  1977,   445,
     228,   480,   242,  3677,   426,  3679,   472,   486,  1996,   169,
    2705,   171,   183,  1471,   364,   243,   480,  3618,   200,   136,
    1478,   228,   486,   251,  1996,   196,  1484,   480,  2000,   480,
    2002,   191,  2004,   486,   482,  2014,   243,   446,   447,   452,
    2248,   480,   455,   409,   251,   480,   274,   460,   461,   462,
    2029,   486,   422,   480,    81,   480,  2764,   430,   431,   486,
    2768,   486,   480,  3544,  1933,   236,   479,   274,   486,   106,
    2049,   240,   189,   301,  2053,  2054,  1933,  3073,   480,   479,
    3740,   481,   452,   254,   486,   455,   483,  3288,   108,   480,
     460,   461,   462,   472,   480,   486,   430,   431,   480,  2807,
     486,   218,  3209,  3210,   486,  2205,  1975,   234,  1977,   479,
    1258,  1259,   131,  2085,  2014,   480,   136,  3718,  1975,   347,
    1977,   486,    77,   479,  1480,   481,   286,   298,    83,   246,
     389,   291,   391,   480,   303,   306,   296,   483,  3175,   486,
     347,   453,   180,   452,  3268,  2014,   455,   389,  2528,   391,
     396,   460,   461,   462,   466,   467,   468,  2014,   470,   471,
     472,   473,   474,   475,   396,  1999,   121,   480,  2147,   189,
     479,   396,  1528,   486,    72,  2154,   480,  2504,  2505,  2167,
    1992,    90,   486,  2155,  1642,   396,   205,   415,  2000,    87,
    2002,  2163,  2004,   106,  2173,  2167,  2175,    95,   218,  2894,
     480,   480,   100,   480,   223,  2177,   486,   486,   452,   486,
     396,   455,   167,   415,   480,  2423,   460,   461,   462,   174,
     486,   234,   177,  1579,   341,   240,   480,   271,   345,   430,
     431,   152,   486,   396,   351,   479,   452,   408,   257,   455,
    1596,   358,   402,  2215,   460,   461,   462,   364,  2236,   479,
     410,   452,  2506,  2507,   455,   372,   480,  2248,   481,   460,
     461,   462,   486,   380,  2236,   480,   480,   480,  2648,  2248,
     225,   486,   486,   486,   480,   319,   312,   480,   479,  2258,
     486,   480,  1638,   486,   453,  2097,   305,   486,  2100,  2101,
    1036,  1037,   312,   214,  2282,  2463,  2464,   466,   467,   468,
     479,   470,   471,   472,   473,   474,   475,   481,   480,   426,
    2282,  2290,   479,   430,   486,   301,   337,   337,   216,   252,
     482,   341,   220,   278,   480,   345,   482,  2401,   295,   480,
    1686,   351,  2406,   479,  2401,   486,   430,   479,   358,  2406,
    2319,  1697,   240,   241,   364,   266,   356,   480,   269,   107,
    3315,  2330,   372,   486,   246,   253,   480,   312,   117,   430,
     380,   405,   486,    90,  3471,  3472,  3473,  3474,  2347,  2348,
     389,   480,   391,   482,   480,   470,   471,   472,   473,   474,
     486,   400,   337,   478,  2401,   994,   341,   996,   286,  2406,
     409,   289,   150,  1851,  2769,   480,  2771,   480,  2377,  3523,
     183,   486,  2381,   486,   430,   303,   426,   305,    96,   364,
     452,   479,    96,   196,  2393,  2394,  2395,  2396,   460,   461,
     462,   312,  2401,   480,   480,   246,  2405,  2406,  2808,   486,
     486,  2410,  2423,   487,   480,   477,   357,   479,   415,   481,
     486,  2420,  2421,   187,  2423,   187,  2437,   479,   187,  2829,
     187,  1418,  1419,   236,  1421,   187,   486,  2436,   187,  2438,
     301,   479,  2296,  2442,   222,  2456,   187,   187,  3669,   187,
     368,   254,  3673,  3674,   187,  1933,   301,  2468,  3186,  2458,
     472,   473,   474,  3191,   187,   187,  3194,   452,    90,  2468,
     455,  2470,  2471,  1849,   303,   460,   461,   462,   197,   252,
     196,  2401,   319,   479,   479,   479,  2406,   265,   479,   267,
    3670,  2483,  2491,   479,   479,   298,   479,  1975,  2497,  1977,
     278,   479,   443,   306,   309,   479,  3650,  2506,  2507,  2508,
     451,   452,  2401,   454,   455,   479,  3643,  2406,   479,   460,
     461,   462,   452,   479,  2401,   455,   486,   479,   479,  2406,
     460,   461,   462,   311,   479,   453,  2014,   479,    90,  2538,
     430,   431,   479,   479,  3352,  3353,   143,  3355,   466,   467,
     468,   479,   470,   471,   472,   473,   474,   475,   479,   479,
    2559,  2560,   452,  2562,   342,   455,   479,   252,   486,    77,
     460,   461,   462,   479,   452,    83,  2575,   455,  2577,   479,
     479,   479,   460,   461,   462,  3318,   240,   479,  2580,   479,
    2722,   196,   196,   472,   452,  2587,   374,  2589,   234,   357,
     269,   479,   460,   461,   462,   408,   452,  2606,   156,   486,
     414,  2705,    72,   121,   460,   461,   462,    38,  2705,    16,
     486,   479,   452,  3803,   453,  2757,   479,    87,   479,  2754,
     460,   461,   462,   479,   481,  1818,  3354,   466,   467,   468,
     479,   470,   471,   472,   473,   474,   475,  3455,  3048,   479,
    3050,  2483,   396,   396,   396,   301,  2655,  3465,   358,   167,
     396,  2723,  2654,   291,  2656,  2657,   174,   396,  2705,   177,
     396,   396,   396,   486,   354,   414,  2675,  2676,  2670,  2741,
     415,   396,   894,   396,  2676,   415,   396,   396,  2696,   452,
    3834,  2683,   455,   396,  1877,  2757,   124,   460,   461,   462,
    2928,  3605,    90,  2695,  2696,   301,  2705,  2706,   225,   486,
    2718,   354,  2723,   396,  2706,  3443,   301,   225,   396,   396,
     108,   396,  2721,   396,   479,   240,  2718,   299,   479,   422,
    2741,   479,    90,   479,  3462,  2734,    79,   157,  2746,  2747,
     260,   415,  2930,  2931,  2932,  2933,  2757,   479,   136,  2748,
      90,   102,  2814,  2764,  2746,  2747,   196,  2768,   452,   425,
     301,   455,    90,   481,  2596,  2764,   460,   461,   462,  2768,
     278,  2603,  2604,   355,   187,   428,   415,   187,  2154,  2778,
     240,   415,   187,    16,  2783,  2705,   396,   486,   486,   420,
    2789,   142,   290,   344,   466,   201,   394,   479,   427,  2175,
    2894,   189,   394,  2814,   312,   271,   271,  2894,  2807,    72,
     486,  3544,   163,   394,   364,  3543,  2705,   479,   479,   396,
    3220,   201,   486,  3631,   466,   398,   486,   236,  2705,   480,
     218,   182,   302,   341,   466,   296,  1818,   486,  2837,   254,
     477,  2840,   480,   303,  2676,   480,   197,  2846,    35,   396,
     396,   354,   130,  2852,  3582,  2854,   364,  2894,   246,  2858,
    2859,   212,   479,  2862,  2863,  2864,  2865,  2866,  2867,  2868,
    2869,  2870,  2871,  3681,  2706,   244,   244,  2876,  2877,   479,
     291,   307,   301,   291,   291,   486,  2885,   480,   254,   412,
    3618,  2890,   486,   315,   106,  2894,  2904,  2896,   315,  3617,
     106,   337,   337,   337,  3622,  3623,  2905,   396,   396,  2908,
     240,  2910,  2904,   329,    90,   240,   240,  2928,   415,  2918,
    2919,  2920,  2921,  2401,   452,   415,  2925,   455,  2406,  2928,
     240,  3331,   460,   461,   462,   463,   466,   465,   477,  2938,
     291,   396,  3342,   471,  3344,   396,   254,   466,   299,   196,
     466,  2943,   301,   341,  2330,   305,   186,   345,   479,    90,
    3678,   210,  3680,   351,   301,   213,   473,   157,   213,   196,
     358,    90,   486,   479,  2894,   479,   364,   328,   480,   301,
     301,    11,    78,   387,   372,  2377,   486,   207,   268,  2381,
    3718,   486,   380,   453,   301,   106,   480,   480,   480,   201,
     480,  3719,   480,   480,   480,  2894,   466,   467,   468,   480,
     470,   471,   472,   473,   474,   475,   480,  2894,   486,   201,
     445,   480,   445,   480,   480,   396,   480,    86,  2420,  2421,
     480,   480,   479,   445,    93,   479,    95,  3036,   426,   428,
     482,  3759,   480,    31,   487,   104,   254,   237,  3766,   452,
     480,  3779,   455,   486,   291,   482,   480,   460,   461,   462,
     463,   479,   465,   230,   396,  3783,  3794,   257,   471,   312,
     129,   263,    90,  3065,  3066,  3067,  3068,  3069,  3070,   138,
     479,   396,   263,   263,  3484,   480,   240,   146,   147,   240,
     108,   150,   396,   396,   396,   396,   396,   156,   396,   240,
     240,   160,   240,   240,   477,  3833,   165,   269,  3100,  3101,
    3102,  3103,  3104,   480,   405,   480,   301,   339,   136,  3847,
     179,   480,   479,   182,   486,  3124,   299,   301,   187,   396,
     415,  3859,   301,   480,   479,   243,  3135,   308,   197,   243,
     479,   296,   201,   137,   203,   415,   415,   466,   207,    72,
     486,   304,   486,   184,   477,   184,   180,   201,  3166,    72,
     196,   115,   480,   480,   223,   424,   480,   201,   480,   209,
     479,   189,    95,   486,  3166,  3186,   466,   100,   466,   463,
    3191,   480,   479,  3194,   466,   230,   405,  3186,   196,   183,
     240,   396,  3191,   396,  2377,  3194,   396,   396,  2381,  2575,
     218,  2577,   196,   396,   480,   240,   164,   201,   240,   430,
     478,   244,   206,   479,    90,   209,   196,   211,   305,   226,
     126,   418,   388,   479,   486,   453,   479,  2705,   246,   243,
    2606,    90,   206,  3232,   480,   479,   201,  2420,  2421,   480,
     479,   201,   236,   429,   480,   479,   429,   211,   480,   480,
     106,   486,   291,   405,   291,   415,  3088,   486,   187,   182,
     254,   451,   452,   486,   454,   455,   291,   240,   159,  3268,
     460,   461,   462,   463,   227,   465,  3275,  3276,   203,  2655,
     478,   471,   203,  3282,  3283,   201,   415,   415,  3287,  3288,
     175,   186,   480,   216,  3293,  3294,   117,   220,  3297,   117,
     479,   304,   245,   201,   298,  3313,   396,   479,   196,   139,
     419,   479,   306,   304,   201,   479,   479,   240,   241,   373,
    3312,  3313,   480,   341,   480,   384,   196,   345,   333,  3321,
     253,   479,   479,   351,    90,   430,  3335,   486,   264,   291,
     358,   223,   327,   304,    93,  2721,   364,   351,   304,   351,
     344,  3413,   196,   301,   372,   192,   419,   430,  2734,   486,
     388,   175,   380,   301,   301,    90,   289,  3375,  3376,   479,
     170,   350,  3380,  3365,  3366,  3367,   162,   480,   186,    76,
     303,   332,   327,  3375,  3376,  3377,   413,   479,  3380,  3381,
     240,  2204,  1393,   387,  2607,  2377,  2483,  2126,  2167,  2381,
    3374,  3150,  3413,  3402,  2109,  3153,  3033,  2783,   426,  3403,
    2539,  3419,  3162,  2789,   408,  3778,  2894,  3802,  3757,  3756,
    3786,  3155,  1660,  2798,  3437,  3859,  2186,  3419,  3833,  3387,
    2706,  2705,  3386,  2675,   428,  3793,  3444,  3546,  2420,  2421,
    1640,  3549,  3804,   182,  3443,   368,  1247,  3220,  2314,  3167,
    3618,  3462,  3444,  3718,   448,   449,   450,  2053,  2559,  3458,
    2054,  1673,  3173,  3462,  2840,  3684,  3858,  2859,  3467,  3824,
    2862,  2863,  2864,  2865,  2866,  2867,  2868,  2869,  2870,  2871,
    3312,   972,  2858,   477,  3594,  2193,   480,   481,   482,  3321,
    3489,  1943,   158,  2815,  3493,  1229,  3148,  2489,  1229,  2294,
    3214,  2497,  1426,  2508,  1427,  1958,  1425,  1937,  2468,  2885,
    2248,  2770,  3463,  3512,  3513,   846,  2490,  3516,  3146,  2903,
    3648,  1833,  2896,  2500,  3523,  3524,  2437,  2435,  2920,  2921,
     453,  2349,  2319,  1880,  2579,   597,  2754,  2241,   597,  1675,
    1996,  1436,  2918,  1176,  3543,   347,  1430,   470,   471,   472,
     473,   474,   475,  2302,  1973,  1056,  1253,  2000,  3557,  2303,
    2478,  3215,   878,  1037,  3311,  3216,  2968,  1369,   380,  1434,
    2004,  2297,  3564,     2,  1744,  1216,    -1,    -1,    -1,  3641,
      -1,    -1,    -1,  3582,  1796,  1797,    -1,    -1,   647,   648,
      -1,    -1,  1804,    -1,    -1,    -1,  1808,  1809,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3615,    -1,    -1,
    3838,  1823,    -1,  1825,    -1,    -1,    -1,    -1,    -1,  3618,
    3619,    -1,    -1,  3615,    -1,    -1,    -1,    -1,    -1,    -1,
    3641,    -1,    -1,  1845,    -1,  1847,    -1,    -1,    72,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3645,  3646,    -1,  3648,
      -1,  3650,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
    3036,    95,    -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,
    3669,    -1,    -1,    -1,  3673,  3674,  2859,    -1,    -1,  2862,
    2863,  2864,  2865,  2866,  2867,  2868,  2869,  2870,  2871,    -1,
      -1,    -1,    -1,    -1,    -1,  3527,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   767,   768,
     769,    -1,   771,    -1,   773,    -1,   775,   776,    -1,  3718,
     779,    -1,   781,   782,   783,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3124,    -1,    -1,    -1,    -1,  2920,  2921,    -1,
      -1,  3740,    -1,    -1,    -1,   804,    -1,    -1,   807,    -1,
     809,    -1,   811,    -1,    -1,    72,   815,   816,   817,  3135,
      -1,    -1,   821,    -1,   823,    -1,   825,    -1,    -1,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,   838,
    3779,   840,   216,   100,    -1,    -1,   220,    -1,    -1,    -1,
      -1,    -1,    -1,   852,    -1,  3794,   855,    -1,    -1,   858,
      -1,    -1,    -1,   862,   863,    -1,   240,   241,   867,    -1,
     869,    -1,   871,  3824,    -1,   874,    -1,    -1,    -1,   253,
      -1,    -1,    -1,    -1,  3816,    -1,    -1,  3838,    -1,    -1,
      72,    -1,    -1,  1144,  3833,  3834,   895,    -1,   897,    -1,
      -1,    -1,    -1,    -1,   903,    -1,    -1,  3858,  3847,    -1,
      -1,    -1,   286,    95,    -1,   289,    -1,    -1,   100,    -1,
    3859,    -1,    -1,    -1,  3856,   924,    -1,   926,    -1,   303,
     929,   305,    -1,    -1,    -1,    -1,  2088,  2859,    -1,    -1,
    2862,  2863,  2864,  2865,  2866,  2867,  2868,  2869,  2870,  2871,
    3282,  3283,    -1,    -1,    -1,    -1,   955,   956,    -1,   216,
      -1,   960,    -1,   220,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     979,    -1,    -1,   240,   241,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   368,    -1,   253,    -1,  2920,  2921,
     182,  3124,    -1,  1254,    -1,    -1,    -1,   777,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3335,
      -1,    -1,    -1,    -1,    -1,  2177,    -1,    -1,    -1,   286,
    2182,   801,   289,    -1,   216,  1034,  1035,    -1,   220,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   303,  1046,   305,    -1,
    1049,    -1,    -1,  1052,    -1,    -1,    -1,    -1,   240,   241,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   253,    -1,    -1,    -1,    -1,    -1,  1076,  1077,   453,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,   468,    -1,   470,   471,   472,   473,
     474,   475,    -1,    -1,  1103,    72,    -1,   289,    -1,    -1,
      -1,   368,   486,    -1,    -1,    -1,  1115,    -1,    -1,    -1,
      87,   303,    -1,    -1,    -1,    -1,    -1,    -1,    95,  1128,
      -1,    -1,    -1,   100,    -1,  1134,    -1,  1388,    -1,  1138,
      -1,    -1,   912,    -1,    -1,    -1,  1145,   917,    -1,    -1,
      -1,  3467,    -1,    -1,  1153,  1154,    -1,  3489,   928,  3282,
    3283,  3493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1169,  1170,    -1,  1172,  1173,    -1,    -1,    -1,    -1,    -1,
    3512,  3513,    -1,    -1,    -1,    -1,   368,   957,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   453,  1196,  1197,    -1,
      -1,  1200,  3124,   973,    -1,    -1,    -1,    -1,   978,   466,
     467,   468,    -1,   470,   471,   472,   473,   474,   475,    -1,
      -1,   478,   992,    -1,    -1,    -1,    -1,    -1,    -1,  1480,
     487,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1237,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1246,  1247,   216,
      -1,    -1,  1251,   220,    -1,    -1,    -1,  1256,    -1,    -1,
      -1,    -1,    -1,  1514,    -1,  1264,    -1,    -1,  1267,    -1,
    1269,   453,    -1,   240,   241,    -1,    -1,  1528,    -1,    -1,
      78,    72,    -1,    -1,    -1,    -1,   253,    -1,   470,   471,
     472,   473,   474,   475,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,   100,
      -1,    -1,    -1,  3645,  3646,    -1,    -1,    -1,    -1,   286,
      -1,    -1,   289,    -1,    -1,    -1,    -1,    -1,  1579,  2481,
      -1,    -1,   130,    -1,    -1,    -1,   303,    -1,   305,    -1,
     138,   139,    -1,    -1,  1114,  1596,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3669,    -1,    -1,    -1,  3673,  3674,    -1,
    3282,  3283,  1613,    -1,    -1,    -1,  3489,    -1,    -1,    -1,
    3493,    -1,  1371,  1372,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   179,    -1,    -1,    -1,    -1,  1385,  1638,    -1,  3512,
    3513,   182,    -1,  1392,  1393,  1165,  1166,  1167,    -1,    -1,
      -1,   368,    -1,    -1,  1403,    -1,  1405,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   220,    -1,  3740,   216,    -1,   225,    87,   220,
      -1,    -1,    -1,    -1,    -1,  1686,    95,    -1,    -1,    -1,
      -1,   100,    -1,    -1,    -1,    -1,  1697,    -1,    -1,   240,
     241,    -1,    -1,  1452,    -1,  1454,    -1,    -1,    -1,    -1,
      -1,    -1,   253,    -1,   262,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1473,  1245,    -1,    -1,    -1,    -1,
      -1,   279,   280,    -1,   282,   283,   453,   285,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1266,    -1,   289,   466,
     467,   468,    -1,   470,   471,   472,   473,   474,   475,    -1,
      -1,    -1,   303,   480,    -1,    -1,    -1,   315,    -1,    -1,
      -1,    -1,  3645,  3646,    -1,    -1,    -1,    -1,    -1,  2681,
    1529,  2683,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     348,    -1,    -1,  1552,  1553,  1554,  1555,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,    86,    -1,  3489,    -1,    -1,
      -1,  3493,    93,    72,    -1,    -1,    -1,   368,    -1,    -1,
      -1,   240,   241,  1582,  1583,   383,    -1,   385,    87,  1588,
    3512,  3513,    -1,    -1,   253,    -1,    95,    -1,  1849,    -1,
      -1,   100,    -1,    -1,    -1,    -1,    -1,    -1,   129,   407,
      -1,    -1,    -1,    -1,    -1,    -1,   414,    -1,    -1,   417,
      -1,    -1,    -1,    -1,    -1,   146,   147,   286,    -1,    -1,
     289,  1401,    -1,    -1,    -1,   156,    -1,    -1,    -1,   160,
      -1,    -1,    -1,    -1,   303,    -1,   305,  1646,    -1,  1648,
      -1,  1650,  1651,  1652,  1653,    -1,    -1,    -1,    -1,   180,
      -1,   182,   453,    -1,    -1,  1664,    -1,  1666,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   197,    -1,    -1,   470,
     471,   472,   473,   474,   475,    -1,    -1,    -1,  1687,    -1,
      -1,  1690,  1691,    -1,    -1,    -1,    -1,  1696,    -1,    -1,
    1699,  1700,    -1,  1702,    -1,    72,    -1,    -1,  1707,   368,
    1709,    -1,    -1,  1712,    -1,    -1,  1715,   216,    -1,    -1,
      87,   220,    -1,  3645,  3646,    -1,    -1,    -1,    95,    -1,
    1729,  1730,    -1,   100,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   240,   241,    -1,    -1,    -1,    72,    -1,    -1,    -1,
    1749,    -1,  1751,  1752,   253,    -1,  1755,    -1,    -1,    -1,
      -1,    87,  1761,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,    -1,    -1,  1543,   100,    -1,    -1,    -1,    -1,    -1,
    1779,    -1,    -1,  1782,    -1,    -1,    -1,   286,    -1,    -1,
     289,    -1,    -1,    -1,   453,    -1,    -1,    -1,  2049,    -1,
      -1,    -1,  2053,  2054,   303,    -1,   305,   466,   467,   468,
      -1,   470,   471,   472,   473,   474,   475,  1816,    -1,    -1,
      -1,   480,    72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,   216,
     100,    -1,    -1,   220,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   384,    -1,    -1,    -1,    -1,    -1,   368,
      -1,    -1,    -1,   240,   241,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   253,  1886,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2154,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   240,   241,    -1,    -1,    -1,   286,
      -1,    -1,   289,    -1,  2175,    -1,    -1,   253,    -1,    -1,
      -1,  1701,    -1,    -1,    -1,    -1,   303,  1936,  1708,    -1,
      -1,    -1,    -1,  3095,    -1,    -1,    -1,  1946,  3100,  3101,
    3102,  3103,  3104,    -1,   453,    -1,  3108,    -1,    -1,    -1,
     286,    -1,    -1,   289,    -1,    -1,   216,   466,   467,   468,
     220,   470,   471,   472,   473,   474,   475,   303,    -1,   305,
      -1,   480,    -1,  1753,  1754,    -1,    -1,    -1,    -1,    -1,
     240,   241,    -1,    -1,    -1,  1765,    -1,  1996,    -1,    -1,
    1999,   368,    -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2011,  2012,    -1,    -1,  2015,  2016,    -1,    -1,
      -1,  2020,    -1,    -1,    -1,    -1,    -1,  2026,    -1,    -1,
      -1,    -1,  2031,  2032,    -1,    -1,   286,  2036,  2037,   289,
      -1,    -1,   368,  2042,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   303,    -1,   305,    -1,    -1,    -1,  2058,
    2059,  2060,  2061,    -1,  2063,    -1,    -1,  2066,  2067,    -1,
      -1,    -1,    -1,  2072,    -1,    -1,   597,    -1,    -1,  2330,
      -1,    -1,    -1,    -1,    -1,    -1,   453,  2086,    -1,    -1,
      -1,  2090,    -1,    -1,  2093,  2094,  2095,  2096,    -1,   466,
     467,   468,    -1,   470,   471,   472,   473,   474,   475,  1879,
    2109,  2110,  2111,  2112,  2113,  2114,  2115,    -1,   368,  2118,
    2119,    -1,    -1,  2122,  2123,  2124,    -1,   453,  2127,  2128,
      -1,    -1,    -1,    -1,    -1,  2134,  2135,  2136,    -1,  2138,
     466,   467,   468,    -1,   470,   471,   472,   473,   474,   475,
      -1,    -1,    72,    -1,   480,    -1,    -1,  2156,  2157,  2158,
    2159,  2160,  2161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3323,    -1,  1943,    -1,    95,    -1,    -1,  2177,    -1,
     100,  3333,  3334,    -1,    -1,    -1,  3338,  3339,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3348,    -1,    -1,  2198,
      -1,    -1,    -1,   453,    -1,    -1,    -1,  2206,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,  2226,    -1,    -1,
     480,    -1,  2231,    -1,  2233,    -1,    -1,    -1,    -1,    -1,
      72,    -1,  2241,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2249,    -1,    -1,    -1,  2253,  2254,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,   100,  2268,
    2269,  2270,  2271,    -1,    -1,    72,    -1,   798,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,
      87,    -1,    -1,    -1,    -1,    -1,   216,  2296,    95,    -1,
     220,    -1,    -1,   100,    -1,    -1,    -1,    -1,  2559,  2560,
      -1,  2562,    -1,  2312,    -1,    -1,   837,   838,    -1,   840,
     240,   241,    -1,    -1,  2575,    -1,  2577,    -1,    -1,    -1,
      -1,    -1,    -1,   253,    -1,    -1,    -1,  2336,    -1,    -1,
    2339,    -1,   134,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2121,    -1,    -1,    -1,  2606,    -1,    -1,   879,   151,
      -1,    -1,   883,    -1,   885,    -1,   887,    -1,    -1,   289,
      -1,    -1,   893,   894,    -1,    -1,    -1,    -1,    -1,    -1,
     172,    -1,   903,   303,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     921,    -1,    -1,    -1,  2655,    -1,    -1,    -1,   240,   241,
      -1,   203,  2411,    -1,    -1,    -1,    -1,   209,    -1,   216,
      -1,   253,    -1,   220,    -1,  2676,    -1,   948,    -1,    -1,
      -1,   223,  2202,    -1,   955,   956,    -1,    -1,   959,   960,
      -1,  2440,    -1,   240,   241,    -1,    -1,    -1,   368,    -1,
      -1,    -1,    -1,    -1,    -1,  2706,   253,   289,    -1,    -1,
    2230,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2238,    -1,
    2721,   303,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2734,  2483,    -1,    -1,    -1,    -1,   286,
    2489,    -1,   289,    -1,    -1,    -1,    -1,  2748,    -1,  1020,
      -1,    -1,    -1,    -1,  2503,    -1,   303,    -1,   305,    -1,
      -1,   303,    -1,  1034,  1035,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2528,
    2529,  2530,  2783,   453,   326,    -1,   368,  1144,  2789,    -1,
      -1,    -1,    -1,  2542,    -1,    -1,   466,   467,   468,    72,
     470,   471,   472,   473,   474,   475,   348,    -1,    -1,    -1,
      -1,    -1,   354,    -1,    87,    -1,    -1,    -1,   360,    -1,
      -1,   368,    95,    -1,    -1,    -1,    -1,   100,    -1,    -1,
      -1,    -1,  2581,  2582,    -1,    -1,    -1,    -1,    -1,  2840,
      -1,    -1,    -1,    -1,    -1,   387,   388,    -1,    -1,    -1,
     392,    -1,    -1,  2602,    -1,    -1,    -1,  2858,   400,    -1,
      -1,    -1,    -1,   405,    -1,    -1,  2615,  2616,  2617,  2618,
    1141,   453,   414,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   425,  2885,   467,   468,    -1,   470,   471,
     472,   473,   474,   475,    -1,    -1,    -1,  1254,    -1,  2648,
    2649,    -1,    -1,    -1,    -1,    -1,   453,    -1,    -1,  2658,
    2659,    -1,    -1,    -1,    -1,    -1,    -1,  2918,    -1,   466,
     467,   468,    -1,   470,   471,   472,   473,   474,   475,    -1,
      -1,    -1,    -1,   480,  2683,    -1,    -1,    -1,    -1,    -1,
      -1,  1212,  2462,   216,    -1,    -1,   114,   220,  2697,  2698,
    2699,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,   241,  1240,
      -1,    -1,  1243,  2722,    -1,    -1,    -1,    -1,    -1,    -1,
     253,    -1,  1253,    -1,    -1,    -1,    -1,   155,    -1,    -1,
      -1,    -1,    -1,  2742,    -1,    -1,    -1,    -1,  2747,    -1,
      -1,    -1,    -1,    -1,    -1,  2754,    -1,    -1,  2757,  2758,
      -1,    -1,  2761,   286,    -1,    -1,   289,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2774,    -1,    -1,    -1,    -1,
     303,    -1,   305,    -1,   202,  3036,    -1,    -1,    -1,    -1,
      -1,   209,    -1,   211,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   222,    -1,    -1,    -1,    -1,  2808,
      -1,    -1,    72,    -1,    -1,  1336,  2815,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1346,    -1,    -1,    -1,    -1,
    2829,    -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   368,  1367,    -1,    -1,    -1,
    1371,  1372,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1385,    -1,    72,  1388,    -1,    -1,
      -1,  1392,  1393,  1480,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    87,    -1,    -1,  3135,    -1,    -1,    -1,    -1,    95,
      -1,    -1,    -1,    -1,   100,    -1,    72,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1514,    -1,    -1,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,  1528,   182,    -1,   100,    -1,    -1,    -1,    -1,    -1,
     453,  1452,    -1,  1454,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,   468,  2716,   470,   471,   472,
     473,   474,   475,    -1,    -1,  2725,   216,   480,    -1,    -1,
     220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2970,  1579,    -1,  2744,    -1,    -1,    -1,  1499,    -1,
     240,   241,    -1,    -1,  1505,    -1,    -1,    -1,    -1,  1596,
      -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3002,  3003,    -1,  1613,    -1,    -1,    -1,
     216,    -1,    -1,    72,   220,    -1,    -1,    -1,    -1,    -1,
     196,  2791,    -1,  2793,    -1,   201,    -1,    -1,  2798,   289,
      -1,  1638,    -1,    -1,   240,   241,    95,  3288,    -1,    -1,
     216,   100,    -1,   303,   220,  3044,    -1,   253,    -1,  3048,
    3049,  3050,  3051,  3052,  3053,  3054,    -1,  2827,    -1,    -1,
    1581,    -1,    -1,    -1,   240,   241,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   253,    -1,  1686,
     286,    -1,    -1,   289,  3335,    -1,    -1,    -1,    -1,    -1,
    1697,    -1,    -1,    -1,    -1,    -1,    -1,   303,    -1,   305,
      -1,  3100,  3101,  3102,  3103,  3104,    -1,    -1,   368,    -1,
     286,    -1,    -1,   289,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3123,    -1,    -1,   303,    -1,   305,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1664,    -1,    -1,    -1,  3146,    -1,    -1,
      -1,  3150,  1673,    -1,  3153,    -1,  3155,   216,    -1,    -1,
      -1,   220,   368,  3162,    -1,  2935,  2936,    -1,    -1,  3168,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   240,   241,  3182,    -1,  3184,    -1,    -1,    -1,    -1,
      -1,    -1,   368,   453,   253,    -1,  3195,    -1,  3197,    -1,
    3199,    -1,    -1,    72,  3203,    -1,  3205,    -1,    -1,  1730,
     470,   471,   472,   473,   474,   475,  3467,    -1,    87,    -1,
      -1,  3220,    -1,  1744,  1745,    -1,    95,   286,    -1,    -1,
     289,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1849,    -1,   303,    -1,    -1,   453,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,   468,    -1,   470,   471,   472,   473,   474,   475,
      -1,    -1,    -1,    -1,   480,  1796,  1797,   453,    -1,    -1,
      -1,    -1,  1803,  1804,    -1,    -1,    -1,  1808,  1809,    -1,
     466,   467,   468,    -1,   470,   471,   472,   473,   474,   475,
      -1,    -1,  1823,    -1,  1825,    -1,    -1,    -1,    -1,   368,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3318,
      -1,    -1,    -1,    -1,  1845,    -1,  1847,    -1,    -1,    -1,
      -1,    -1,  3331,  3332,    -1,    -1,    -1,  3107,    -1,    -1,
     758,    -1,    -1,  3342,  3343,  3344,    -1,   216,   766,    -1,
    3349,   220,   770,  3352,  3353,  3354,  3355,    -1,  1879,    -1,
    3130,    -1,    -1,    -1,    -1,  1886,    -1,    -1,    -1,    -1,
    3140,   240,   241,  1894,    -1,    -1,    -1,    -1,    -1,    -1,
    3379,    -1,    -1,    -1,   253,   803,    -1,    -1,    -1,  1910,
      -1,    -1,    -1,    -1,   453,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,   468,
      -1,   470,   471,   472,   473,   474,   475,   286,  3669,    -1,
     289,    -1,  3673,  3674,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3430,  1144,   851,   303,    -1,   305,    -1,  3437,   857,
      -1,    72,  2049,    -1,  3443,    -1,  2053,  2054,    -1,    -1,
      -1,    -1,    -1,  3452,    -1,    -1,  3455,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    -1,  3465,    -1,    -1,   100,
      -1,  1992,    -1,    -1,    -1,  1996,    -1,    -1,  1999,  3478,
      -1,    -1,    -1,    -1,    -1,  3484,   139,    -1,    -1,  3740,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3299,
    3300,  3301,  3302,    -1,    -1,   953,    -1,    -1,    -1,    -1,
     958,    72,  1254,   961,    -1,  3544,    -1,  2154,    -1,    -1,
      -1,   182,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    -1,   984,  2088,  2175,   100,
      -1,   224,    -1,  3572,    -1,    -1,  2097,    -1,    -1,  2100,
    2101,    -1,    -1,    -1,   453,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,    -1,  3593,    -1,  3595,   466,   467,   468,
      -1,   470,   471,   472,   473,   474,   475,    -1,    -1,   240,
     241,   480,    -1,    -1,    -1,    -1,    -1,    -1,  3617,  3618,
      -1,    -1,   253,  3622,  3623,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3631,    -1,  2155,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2163,    -1,    -1,    -1,  2167,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2177,    -1,   289,    -1,
      -1,  2182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   303,    -1,    -1,    -1,    -1,    -1,  3677,  3678,
    3679,  3680,  3681,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,  1110,  1111,    -1,    -1,    -1,    -1,    -1,  1117,
    3699,    -1,    -1,    -1,    -1,  1123,    -1,    -1,    -1,   240,
     241,    -1,    -1,    -1,    -1,  2236,    -1,    -1,    -1,  3718,
    3719,    -1,   253,  2330,    -1,    -1,  1144,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1171,    -1,   286,    -1,    -1,   289,  3758,
    3759,  2282,    -1,    -1,    -1,    -1,    -1,  3766,  1480,    -1,
      -1,    -1,   303,    -1,   305,  2296,  2297,    -1,    -1,  2300,
      -1,  2302,    -1,    -1,  3783,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3794,    -1,    -1,    -1,    -1,
      -1,    -1,  1514,    -1,    -1,    -1,    -1,    -1,    -1,  1227,
      -1,    -1,    -1,    -1,  3584,    -1,  1528,    -1,    -1,    -1,
      -1,    -1,   453,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3833,  3605,  1254,   368,    -1,   470,
     471,   472,   473,   474,   475,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3626,  1275,    -1,    -1,
    3859,    -1,    -1,    -1,    -1,    -1,    -1,  1579,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1301,  1596,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3666,    -1,    -1,    -1,
      -1,  1613,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1331,  1332,    -1,  1334,    -1,    -1,    -1,
      -1,    -1,   453,    -1,    -1,    -1,  1638,    -1,    -1,    -1,
      -1,    -1,    -1,  1351,    -1,   466,   467,   468,    -1,   470,
     471,   472,   473,   474,   475,    -1,    -1,   478,    -1,    -1,
      -1,    -1,  2559,  2560,    -1,  2562,    -1,    -1,  2479,    -1,
    2481,    -1,  2483,    -1,    -1,    -1,    -1,    -1,  2575,    -1,
    2577,    -1,    -1,    -1,  1686,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1697,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2606,
      -1,    -1,  1420,    -1,    -1,  1423,  1424,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2655,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2579,    -1,
      -1,    -1,  1480,    -1,    -1,    -1,  1484,    -1,    -1,  2676,
    1488,    -1,    -1,    -1,    -1,  2596,    -1,    -1,    -1,    72,
      -1,    -1,  2603,  2604,    -1,    -1,    -1,    -1,    -1,  1507,
      -1,    -1,    -1,    -1,    87,    -1,  1514,    -1,    91,  2706,
      -1,    -1,    95,    -1,    -1,    -1,    -1,   100,    -1,    -1,
    1528,    -1,    -1,   766,  2721,    -1,    -1,   770,    -1,   772,
      -1,    -1,    -1,    -1,   777,   778,    -1,  2734,    -1,    -1,
      -1,   784,    -1,  2654,    -1,  2656,  2657,  1849,    -1,    -1,
      -1,  2748,    -1,    -1,    -1,    -1,    -1,    -1,   801,  2670,
     803,    -1,    -1,    -1,    -1,  2676,    -1,    -1,    -1,    -1,
    2681,  1579,  2683,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   165,    -1,  2695,  2696,  2783,    -1,  1596,    -1,
      -1,    -1,  2789,    -1,    -1,  2706,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   846,    -1,  1613,    -1,  2718,   851,    -1,
      -1,  2722,    -1,    -1,   857,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1638,    -1,    -1,   216,  1642,  2746,  2747,   220,    -1,    -1,
      -1,    -1,    -1,  2840,    -1,    -1,  2757,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,   241,    -1,
      -1,  2858,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   912,
     253,    -1,    -1,  1681,   917,  1683,    -1,    -1,  1686,    -1,
    1688,    -1,    -1,    -1,    -1,   928,    -1,    72,  2885,  1697,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    87,   286,    -1,    -1,   289,    -1,    -1,    -1,
      95,    -1,    -1,    -1,   957,   100,    -1,    -1,    -1,    -1,
     303,  2918,   305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     973,    -1,    -1,    -1,    -1,   978,    -1,    -1,    -1,    -1,
      -1,    -1,  1750,    -1,    -1,    -1,    -1,  2049,    -1,   992,
      -1,  2053,  2054,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1784,  1785,    -1,    -1,
      -1,    -1,    -1,    -1,  1792,   368,    -1,  1795,    -1,    -1,
    1798,    -1,    -1,  2904,    -1,    -1,    -1,    -1,  1806,  1807,
      -1,    -1,    -1,    -1,    -1,    -1,  1814,    -1,    -1,  1817,
    1818,  1819,  1820,    -1,    -1,    -1,    -1,    72,    -1,  1827,
    1828,    -1,  1830,    -1,  1832,    -1,    -1,  1835,    -1,    -1,
      -1,   216,   415,    -1,    -1,   220,    -1,    -1,    -1,  3036,
      95,  1849,  1850,  1851,    -1,   100,  1854,    -1,    -1,    -1,
    1858,    -1,  2154,    -1,  1862,   240,   241,  1865,  1866,  1867,
    1868,  1869,  1870,  1871,  1872,  1873,    -1,  1875,   253,    -1,
     453,  1114,  1880,  2175,  1117,    -1,  1884,    -1,    -1,    -1,
    1123,    -1,    -1,   466,   467,   468,    -1,   470,   471,   472,
     473,   474,   475,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   286,    -1,    -1,   289,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   303,    -1,
     305,    -1,  1165,  1166,  1167,    -1,    -1,   182,  1171,    -1,
      -1,    -1,    -1,    -1,    -1,   320,    -1,  1945,  3135,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3065,  3066,  3067,  3068,  3069,  3070,
      -1,   216,    -1,    -1,    95,   220,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   368,  3095,   240,   241,    -1,    -1,  3100,
    3101,  3102,  3103,  3104,    -1,    -1,   381,  3108,   253,    -1,
      -1,    -1,  1245,    -1,    -1,    -1,  2014,   138,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   147,    -1,    -1,   150,
      -1,  2029,    -1,  1266,    -1,   156,    -1,    -1,  2330,   160,
      -1,    -1,    -1,    -1,   289,    -1,    -1,    -1,    -1,    -1,
      -1,  2049,    -1,    -1,    -1,  2053,  2054,    -1,   303,    -1,
      -1,   182,    -1,    -1,    -1,  3166,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   197,    -1,   453,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,   468,    -1,   470,   471,   472,   473,   474,
     475,  3288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3215,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,  3335,  2147,
      -1,    -1,    -1,    -1,    -1,    -1,  2154,    -1,    87,    -1,
      -1,    90,    -1,    -1,    -1,    -1,    95,    -1,  1401,    -1,
      -1,   100,    -1,    -1,    -1,  2173,    -1,  2175,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    87,    -1,    -1,    90,    -1,    -1,   453,    -1,
      95,  3312,  3313,    -1,    -1,   100,    -1,    -1,    -1,    -1,
      -1,    -1,  3323,    -1,    -1,   470,   471,   472,   473,   474,
     475,    -1,  3333,  3334,    -1,    -1,    -1,  3338,  3339,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3348,    -1,    -1,
    2248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2258,    -1,    -1,   384,  3365,  3366,  3367,  2559,  2560,    -1,
    2562,    -1,    -1,    -1,  3375,  3376,    -1,    -1,    -1,  3380,
    3467,    -1,    -1,  2575,    -1,  2577,    -1,   216,    -1,    -1,
      -1,   220,  2290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1543,   240,   241,    -1,  2606,    -1,    -1,    -1,  3419,    -1,
      -1,  2319,    -1,  1556,   253,    -1,    -1,    -1,    -1,    -1,
      -1,   216,  2330,    -1,    -1,   220,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3444,    -1,    -1,    -1,    -1,    -1,  2347,
    2348,    -1,    -1,    -1,    -1,   240,   241,   286,    -1,    -1,
     289,    -1,    -1,  2655,    -1,    -1,    -1,    -1,   253,    -1,
      -1,    -1,    -1,    -1,   303,    -1,   305,    -1,    -1,  2377,
      -1,    -1,    -1,  2381,  2676,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2393,  2394,  2395,  2396,    -1,
      -1,   286,    -1,  2401,   289,    -1,    -1,  2405,  2406,    -1,
      -1,    -1,  2410,    -1,  2706,    -1,    -1,    -1,   303,    -1,
     305,    -1,  2420,  2421,    -1,  2423,    -1,    -1,    -1,  2721,
      72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2436,   368,
    2438,    -1,  2734,    -1,  2442,    87,    -1,    -1,  1681,    -1,
    1683,    -1,    -1,    95,    -1,  1688,  2748,    -1,   100,    -1,
    2458,    -1,    -1,  3564,    -1,    -1,    -1,    -1,  1701,    -1,
    2468,    -1,  2470,  2471,    -1,  1708,    -1,    -1,    -1,    -1,
      -1,    -1,  3669,   368,    -1,    -1,  3673,  3674,    -1,    -1,
      -1,  2783,    -1,  2491,    -1,    -1,    -1,  2789,    -1,  2497,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2506,  2507,
    2508,    -1,    -1,    -1,  3615,    -1,    -1,  1750,    -1,    -1,
    1753,  1754,    -1,    -1,   453,    -1,   647,   648,    -1,    -1,
      -1,    -1,  1765,    -1,    -1,    -1,    -1,   466,   467,   468,
    2538,   470,   471,   472,   473,   474,   475,    -1,  2840,    -1,
      -1,    -1,    -1,  3740,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2559,  2560,    -1,  2562,    -1,  2858,    -1,   453,    -1,
      -1,    -1,    -1,    -1,   216,    -1,    -1,  2575,   220,  2577,
      -1,   466,   467,   468,    -1,   470,   471,   472,   473,   474,
     475,    -1,    -1,  2885,    -1,    -1,    -1,    -1,   240,   241,
      -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,  2606,    -1,
      -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2918,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1144,    -1,    -1,   286,    -1,  1879,   289,    -1,   183,
      -1,    -1,    -1,    -1,    -1,   776,    -1,  2655,   779,    -1,
     781,   303,   196,   305,    -1,    -1,    -1,   201,    -1,    -1,
      -1,    -1,   206,    -1,   316,   209,    -1,   211,  2676,    -1,
      -1,    -1,    -1,   804,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3794,    -1,    -1,   817,    -1,    -1,    -1,
     821,    -1,   236,    -1,    -1,    -1,    -1,  2705,  2706,    -1,
    1943,    -1,    -1,    -1,    -1,    -1,    -1,   838,    -1,   840,
     254,    -1,    -1,  2721,    -1,    -1,   368,    -1,    -1,    -1,
      -1,   852,  3833,    -1,    -1,    -1,  2734,    -1,    -1,    -1,
      -1,    -1,   863,    -1,  3036,    -1,   867,    -1,   869,    -1,
    2748,  1254,    -1,    -1,    -1,    -1,    -1,    -1,  3859,    -1,
      -1,    -1,    -1,    -1,   298,    -1,  2764,    -1,    -1,    -1,
    2768,    -1,   306,    -1,   895,    -1,   897,    -1,    -1,    -1,
    2778,    -1,   903,    -1,    -1,  2783,    -1,    -1,    -1,    -1,
      -1,  2789,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   924,    -1,   926,    -1,    -1,    -1,  2807,
     344,   453,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   466,   467,   468,    -1,   470,   471,
     472,   473,   474,   475,   955,    -1,    -1,    -1,    -1,  2837,
      -1,    -1,  2840,  3135,    -1,    -1,    -1,    -1,  2846,    -1,
      -1,    -1,    -1,   387,  2852,    -1,  2854,    -1,    -1,    -1,
    2858,  2859,    -1,    -1,  2862,  2863,  2864,  2865,  2866,  2867,
    2868,  2869,  2870,  2871,   408,    -1,    -1,    -1,  2876,  2877,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2885,  2121,    -1,
      -1,    -1,  2890,    -1,   428,    -1,  2894,    -1,  2896,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2905,    -1,    -1,
    2908,    -1,  2910,    -1,   448,   449,   450,    -1,    -1,    -1,
    2918,  2919,  2920,  2921,    -1,  1046,    -1,  2925,  1049,    -1,
    2928,  1052,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2938,    -1,    -1,   477,    -1,    -1,   480,   481,   482,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2202,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1480,    -1,    -1,
      -1,    -1,  1103,    -1,    -1,    -1,     3,    -1,    -1,    -1,
      -1,    -1,     9,    -1,    -1,    -1,  3288,  2230,    15,    -1,
      17,    -1,    19,    -1,    -1,  2238,    -1,  1128,    -1,    -1,
      -1,  1514,    29,  1134,    -1,  2248,    -1,  1138,    -1,    -1,
      -1,    -1,    -1,    -1,  1145,  1528,    -1,    -1,    -1,    46,
      47,    -1,    -1,    -1,    -1,   202,    -1,    -1,  3036,    -1,
      -1,    -1,   209,  3335,   211,    -1,    -1,    -1,    -1,    -1,
      -1,  1172,    -1,    -1,    -1,    -1,    73,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,  1579,    72,    -1,    -1,
      -1,    -1,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    87,  1596,    -1,    90,    -1,    -1,    -1,    -1,
      95,   118,    -1,   120,   121,   100,    -1,    -1,   125,   126,
    1613,    -1,    -1,    -1,    -1,    -1,  1237,    -1,   135,    -1,
     137,    -1,    -1,    -1,    -1,    -1,  3124,    -1,    -1,    -1,
    1251,    -1,    -1,    -1,   151,  1638,   153,  3135,    -1,   156,
      -1,    -1,    -1,    -1,    -1,   162,    -1,    -1,    -1,    -1,
      -1,   168,    -1,    -1,    -1,    -1,    -1,   174,    -1,    -1,
      -1,    -1,    -1,   180,    -1,    -1,    -1,    -1,    -1,   186,
      -1,   188,    -1,    -1,    -1,  3467,   193,    -1,    -1,    -1,
      -1,    -1,    -1,  1686,    -1,    -1,    -1,   204,  3186,   206,
      -1,    -1,    -1,  3191,  1697,    -1,  3194,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   232,    -1,    -1,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,  2462,
      -1,    -1,    72,    -1,  3232,  2468,    -1,    -1,   255,   256,
      -1,    -1,    -1,    -1,   261,   240,   241,    87,    -1,    -1,
      -1,    -1,    -1,   270,    -1,    95,    -1,    -1,   253,    -1,
     100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3268,   288,    -1,    -1,    -1,    -1,    -1,  3275,  3276,    -1,
      -1,    -1,    -1,    -1,  3282,  3283,    -1,    -1,    -1,  3287,
    3288,   286,    -1,    -1,   289,  3293,  3294,    -1,    -1,  3297,
      -1,    -1,    -1,    -1,   321,    -1,    -1,    -1,   303,    -1,
     305,    -1,    -1,    -1,   331,    -1,    -1,   334,    -1,   336,
      -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,   346,
      -1,    -1,   349,    -1,    -1,    -1,   353,  3335,    -1,    -1,
      -1,    -1,   359,    -1,    -1,    -1,  1849,   364,    -1,    -1,
     367,    -1,  1473,    -1,    -1,    -1,    -1,   374,    -1,    -1,
      -1,   201,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   368,    -1,    -1,   216,  3669,    -1,    -1,
     220,  3673,  3674,    -1,    -1,    -1,   403,    -1,   405,    -1,
      -1,    -1,    -1,    -1,   411,    -1,   413,    -1,    -1,   416,
     240,   241,    -1,   420,  3402,    -1,    -1,    -1,    72,    -1,
      -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    95,    -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3443,   286,    -1,  3740,   289,
      80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   453,    -1,
    3458,    -1,   479,   303,  3462,   305,    -1,    -1,    -1,  3467,
      -1,   466,   467,   468,    -1,   470,   471,   472,   473,   474,
     475,    -1,   112,  2716,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3489,  2725,    -1,   124,  3493,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,    -1,
      -1,  2744,    -1,    -1,  3512,  3513,    -1,    -1,  3516,    -1,
      -1,   151,    -1,    -1,    -1,  3523,  3524,  1648,   368,    -1,
      -1,  2764,    -1,    -1,    -1,  2768,    -1,    -1,    -1,    -1,
      -1,    -1,   172,    -1,    -1,  3543,  2049,    -1,    -1,    -1,
    2053,  2054,   216,    -1,    -1,    -1,   220,    -1,  2791,  3557,
    2793,    -1,    -1,    -1,    -1,  2798,    -1,    -1,    72,    -1,
    1691,    -1,    -1,   203,  2807,    -1,   240,   241,    -1,  1700,
      -1,  1702,    -1,    87,  3582,    -1,  1707,    -1,    -1,   253,
      -1,    95,    -1,   223,  2827,    -1,   100,    -1,    -1,   766,
      -1,    -1,    -1,   770,    -1,    -1,    -1,    -1,  1729,  1730,
      -1,    -1,    -1,   453,    -1,    -1,    -1,   247,    -1,    -1,
    3618,  3619,   286,    -1,    -1,   289,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,   803,    -1,    -1,   303,
      -1,   305,    -1,    -1,    -1,    -1,    -1,  3645,  3646,    -1,
    3648,  2154,  3650,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3669,  2175,   303,    -1,  3673,  3674,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   851,    -1,    -1,    -1,    -1,    -1,
     857,    -1,    -1,    -1,    -1,    -1,   326,    -1,    72,    -1,
      -1,    -1,  2935,  2936,   368,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   216,    87,    -1,    -1,   220,    -1,   348,    -1,
    3718,    95,   352,    -1,   354,    -1,   100,    -1,    -1,    -1,
     360,    -1,    -1,    -1,    -1,    -1,   240,   241,    -1,    -1,
      -1,    -1,  3740,    -1,    -1,    -1,    -1,    -1,    -1,   253,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   387,   388,    -1,
      -1,    -1,   392,    -1,    -1,  1886,    -1,    -1,    -1,    -1,
     400,    -1,    -1,    -1,    -1,   405,    -1,    -1,    -1,    -1,
      -1,  3779,   286,    -1,    -1,   289,   953,    -1,    -1,   453,
      -1,   958,    -1,    -1,   961,   425,  3794,    -1,    -1,   303,
      -1,   305,   466,   467,   468,    -1,   470,   471,   472,   473,
     474,   475,    -1,    -1,    -1,    -1,    -1,   984,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2330,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3833,  3834,    -1,    -1,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,  3847,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3859,    -1,    -1,   368,    -1,   240,   241,    -1,    -1,
      -1,    -1,    -1,    -1,  3107,    -1,    -1,    -1,  1999,   253,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,
      -1,  2012,    -1,    -1,    -1,    -1,    -1,  3130,    -1,  2020,
      -1,    -1,    -1,    -1,    -1,  2026,    -1,  3140,    -1,    -1,
    2031,    -1,   286,    -1,    -1,   289,  2037,    -1,    -1,    -1,
      -1,  2042,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   303,
      -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2061,    -1,  2063,  1110,    -1,    -1,    -1,    -1,    -1,   453,
    1117,    -1,    -1,  3186,    -1,    -1,  1123,    -1,  3191,    -1,
      -1,  3194,   466,   467,   468,    -1,   470,   471,   472,   473,
     474,   475,    -1,  2094,  2095,  2096,    -1,  1144,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2111,  2112,  2113,  2114,   368,    -1,    -1,  2118,  2119,    -1,
      -1,  2122,  2123,  2124,  1171,    -1,    -1,  2128,    -1,    -1,
      -1,    -1,    -1,    -1,  2135,    -1,    -1,  2138,    -1,    80,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,    -1,    -1,    -1,  2559,  2560,    -1,  2562,
    1227,    -1,    -1,    -1,    -1,    -1,  3299,  3300,  3301,  3302,
      -1,    -1,  2575,   134,  2577,    -1,    -1,    -1,    -1,   453,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1254,    -1,    -1,
     151,    -1,   466,   467,   468,    -1,   470,   471,   472,   473,
     474,   475,    -1,  2606,    -1,    -1,    -1,    -1,  1275,    -1,
      -1,   172,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,
      -1,    -1,    -1,    -1,  1301,    -1,    -1,    -1,    86,    -1,
      -1,    92,   203,    -1,    -1,    -1,    -1,    -1,   209,    -1,
      -1,    -1,  2655,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   112,   223,    -1,  1331,  1332,    -1,  1334,    -1,    -1,
      -1,    -1,    -1,  2676,    -1,  2296,    -1,    -1,    -1,    -1,
     131,    -1,    -1,   134,  1351,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,    -1,    -1,  2706,    -1,    -1,   157,    -1,    -1,    -1,
    3443,    -1,   160,    -1,    -1,  2336,    -1,    -1,  2721,    -1,
      -1,   172,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3462,
      -1,  2734,   180,    -1,   182,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   303,    -1,    -1,  2748,    -1,    -1,    -1,    -1,
     311,    -1,   203,  1420,   205,    -1,  1423,  1424,   209,    -1,
      -1,    -1,    -1,    -1,    -1,   326,    -1,    -1,    -1,    -1,
      -1,    -1,   223,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2783,    -1,    -1,    -1,    -1,    -1,  2789,   348,    -1,    -1,
      -1,   352,    -1,   354,    -1,   246,    -1,    -1,    -1,   360,
      -1,    -1,    -1,    -1,    -1,    -1,   257,    -1,    -1,    -1,
    3543,    -1,    -1,  1480,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1488,    -1,    -1,    -1,    -1,   387,   388,    -1,    -1,
      -1,   392,    -1,    -1,    -1,    -1,    -1,  2840,    -1,   400,
    1507,    -1,    -1,    -1,   405,    -1,    -1,  1514,    -1,  3582,
      -1,  3584,   303,   414,   305,  2858,    -1,    -1,    -1,    -1,
      -1,  1528,    -1,    -1,   425,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3605,    -1,    -1,   326,    -1,    -1,    -1,    -1,
      -1,    -1,  2885,    -1,    -1,  3618,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3626,    -1,    -1,    -1,   348,    -1,    -1,
      -1,   352,    -1,   354,    -1,    -1,    -1,    -1,  2529,  2530,
      -1,    -1,  1579,    -1,    -1,  2918,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1596,
      -1,    -1,    -1,  3666,    -1,    -1,    -1,   388,   389,    -1,
     391,   392,    -1,    -1,    -1,    -1,  1613,    -1,    -1,   400,
      -1,    -1,    -1,   404,   405,    -1,    -1,    -1,   409,    -1,
      -1,    -1,    -1,   414,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1638,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3718,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2615,  2616,  2617,  2618,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1681,    -1,  1683,    -1,    -1,  1686,
      -1,  1688,    -1,    -1,    -1,    -1,    -1,    -1,  2649,    -1,
    1697,    -1,    -1,  3036,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3779,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3794,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2697,  2698,  2699,    -1,
      -1,    -1,    -1,  1750,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     2,
    3833,  2722,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3847,    -1,    -1,  1784,  1785,    -1,
      -1,  2742,    -1,    -1,    -1,  1792,  3859,    -1,  1795,    -1,
      -1,  1798,  3135,    -1,    -1,    -1,  2757,    -1,    -1,  1806,
    1807,    -1,    -1,    -1,    -1,    -1,    -1,  1814,    -1,    -1,
    1817,  1818,  1819,  1820,    -1,    -1,    -1,    -1,    -1,    -1,
    1827,  1828,    -1,  1830,    -1,  1832,    -1,    -1,  1835,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1849,  1850,    -1,    -1,    -1,  1854,    -1,    -1,
      -1,  1858,    -1,    -1,    -1,  1862,    -1,    -1,  1865,  1866,
    1867,  1868,  1869,  1870,  1871,  1872,  1873,    -1,  1875,    -1,
      -1,    -1,    -1,  1880,    -1,    -1,    -1,  1884,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   160,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1945,   182,
      -1,    -1,    -1,    -1,    -1,  3288,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3335,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     798,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2029,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2049,    -1,    -1,    -1,  2053,  2054,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3044,    -1,    -1,    -1,    -1,  3049,    -1,
    3051,  3052,  3053,  3054,    -1,   883,    -1,   885,    -1,   887,
      -1,    -1,    -1,    -1,    -1,   893,   894,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3467,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   921,    -1,    -1,    -1,    -1,    -1,    -1,
    2147,    -1,    -1,    -1,    -1,    -1,    -1,  2154,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     948,    -1,  3123,    -1,    -1,    -1,  2173,    -1,  2175,    -1,
      -1,   959,   960,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1020,    -1,    -1,    -1,    -1,    -1,  3199,    -1,
      -1,  2248,    -1,    -1,    -1,    -1,  1034,  1035,    -1,    -1,
    1038,  2258,    -1,    -1,    -1,    -1,    -1,  1144,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2290,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2319,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2330,    -1,    -1,  3669,    -1,    -1,    -1,
    3673,  3674,    -1,    -1,    -1,    -1,    -1,    -1,  1144,    -1,
    2347,  2348,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1141,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1254,    -1,    -1,
    2377,  3332,    -1,    -1,  2381,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3343,    -1,    -1,    -1,  2393,  2394,  2395,  2396,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3740,  2405,    -1,
      -1,    -1,    -1,  2410,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2420,  2421,    -1,  2423,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1212,    -1,    -1,    -1,    -1,  2436,
      -1,  2438,    -1,    -1,    -1,  2442,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1254,    -1,
      -1,  2458,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2468,    -1,  2470,  2471,    -1,    -1,    -1,    -1,  3430,
      -1,    -1,    -1,    -1,    -1,    -1,  3437,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2491,    -1,    -1,    -1,    -1,    -1,
    2497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2506,
    2507,  2508,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1336,    -1,
      -1,    -1,  2559,  2560,    -1,  2562,    -1,    -1,  1346,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2575,    -1,
    2577,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1480,    -1,    -1,    -1,  1385,    -1,  2606,
    1388,    -1,    -1,    -1,  1392,  1393,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1514,    -1,    -1,
      -1,    -1,    -1,   876,    -1,    -1,    -1,    -1,    -1,    -1,
     883,  1528,   885,    -1,   887,    -1,    -1,    -1,  2655,    -1,
     893,   894,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1454,    -1,    -1,  2676,
      -1,    -1,    -1,    -1,  1480,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1579,    -1,    -1,    -1,    -1,    -1,    -1,  2706,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1514,  1596,
      -1,  1499,    -1,    -1,  2721,    -1,    -1,  1505,    -1,    -1,
      -1,    -1,  1528,    -1,    -1,    -1,  1613,  2734,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3699,    -1,
      -1,  2748,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1638,    -1,    -1,    -1,    -1,    -1,  2764,    -1,    -1,
      -1,  2768,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2778,    -1,  1579,    -1,    -1,  2783,  1020,    -1,    -1,
      -1,    -1,  2789,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1596,    -1,    -1,  1581,    -1,  1038,    -1,  3758,    -1,  1686,
    2807,    -1,    -1,    -1,    -1,    -1,    -1,  1613,    -1,    -1,
    1697,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2837,    -1,  1638,  2840,    -1,    -1,    -1,    -1,    -1,  2846,
      -1,    -1,    -1,    -1,    -1,  2852,    -1,  2854,    -1,    -1,
      -1,  2858,  2859,    -1,    -1,  2862,  2863,  2864,  2865,  2866,
    2867,  2868,  2869,  2870,  2871,    -1,    -1,    -1,    -1,  2876,
    2877,    -1,    -1,    -1,    -1,    -1,  1664,    -1,  2885,    -1,
    1686,    -1,    -1,  2890,    -1,  1673,    -1,    -1,    -1,  2896,
      -1,  1697,    -1,    -1,    -1,    -1,    -1,    -1,  2905,    -1,
      -1,  2908,    -1,  2910,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2918,  2919,  2920,  2921,    -1,    -1,    -1,  2925,    -1,
      -1,  2928,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2938,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1849,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1216,  1217,    -1,  1219,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1796,  1797,
      -1,    -1,    -1,    -1,    -1,  1803,  1804,    -1,    -1,    -1,
    1808,  1809,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3036,
      -1,    -1,    -1,    -1,    -1,  1823,    -1,  1825,    -1,    -1,
      -1,    -1,    -1,  1849,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1845,    -1,  1847,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3124,    -1,    -1,
      -1,    -1,  1910,    -1,    -1,    -1,    -1,    -1,  3135,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1388,    -1,    -1,    -1,  1392,
    1393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2049,    -1,    -1,    -1,  2053,  2054,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3186,
      -1,    -1,    -1,    -1,  3191,    -1,    -1,  3194,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1445,    -1,  1992,    -1,    -1,    -1,  1996,    -1,
      -1,    -1,  2000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3232,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2049,    -1,    -1,    -1,  2053,  2054,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1499,    -1,    -1,    -1,
      -1,  3268,  1505,    -1,    -1,    -1,    -1,  2154,  3275,  3276,
      -1,    -1,    -1,    -1,    -1,  3282,  3283,    -1,    -1,    -1,
    3287,  3288,    -1,    -1,    -1,    -1,  3293,  3294,  2175,    -1,
    3297,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2088,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2097,
      -1,    -1,  2100,  2101,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3335,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1581,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2154,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2155,    -1,  2175,
      -1,    -1,    -1,    -1,    -1,  2163,    -1,    -1,    -1,  2167,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2177,
      -1,    -1,    -1,    -1,  2182,  3402,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1673,    -1,    -1,    -1,    -1,    -1,  3443,    -1,    -1,    -1,
      -1,    -1,    -1,  2330,    -1,    -1,    -1,    -1,  2236,    -1,
      -1,  3458,    -1,    -1,    -1,  3462,    -1,    -1,    -1,    -1,
    3467,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1718,    -1,    -1,    -1,  1722,
      -1,    -1,  3489,    -1,    -1,    -1,  3493,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2282,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1745,    -1,    -1,  3512,  3513,    -1,    -1,  3516,
      -1,    -1,    -1,    -1,    -1,    -1,  3523,  3524,    -1,    -1,
      -1,    -1,    -1,    -1,  2330,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3543,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3557,    -1,    -1,  1796,  1797,    -1,    -1,    -1,    -1,    -1,
      -1,  1804,    -1,    -1,    -1,  1808,  1809,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3582,    -1,    -1,    -1,    -1,
    1823,    -1,  1825,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1845,    -1,  1847,    -1,    -1,    -1,    -1,    -1,
      -1,  3618,  3619,    -1,    -1,    -1,    -1,   766,    -1,    -1,
      -1,   770,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3645,  3646,
      -1,  3648,    -1,  3650,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1894,    -1,    -1,   803,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3669,    -1,    -1,    -1,  3673,  3674,    -1,    -1,
      -1,    -1,  2559,  2560,    -1,  2562,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2575,    -1,
    2577,    -1,    -1,  2481,    -1,  2483,    -1,    -1,    -1,    -1,
      -1,    -1,   851,    -1,    -1,    -1,    -1,    -1,   857,    -1,
      -1,  3718,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2606,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3740,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1992,
      -1,    -1,    -1,  2559,  2560,    -1,  2562,  2000,    -1,  2002,
      -1,  2004,    -1,    -1,    -1,    -1,    -1,    -1,  2655,  2575,
      -1,  2577,  3779,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3794,    -1,  2676,
      -1,  2579,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2606,    -1,    -1,    -1,   953,    -1,    -1,    -1,  2596,    -1,
      -1,    -1,    -1,    -1,    -1,  2603,  2604,    -1,    -1,  2706,
      -1,    -1,    -1,    -1,    -1,    -1,  3833,  3834,    -1,    -1,
      -1,    -1,    -1,    -1,  2721,   984,    -1,    -1,    -1,    -1,
    3847,    -1,    -1,    -1,    -1,  2088,    -1,  2734,    -1,  2655,
      -1,    -1,  3859,    -1,  2097,    -1,    -1,  2100,  2101,    -1,
      -1,  2748,    -1,    -1,    -1,    -1,  2654,    -1,  2656,  2657,
    2676,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2670,    -1,    -1,    -1,    -1,    -1,  2676,    -1,
      -1,    -1,    -1,  2681,    -1,  2683,  2783,    -1,    -1,    -1,
    2706,    -1,  2789,    -1,    -1,    -1,    -1,  2695,  2696,    -1,
      -1,    -1,    -1,    -1,    -1,  2721,    -1,    -1,  2706,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2734,    -1,
    2718,    -1,    -1,    -1,  2177,    -1,    -1,    -1,    -1,  2182,
      -1,    -1,  2748,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2840,    -1,    -1,    -1,    -1,  2746,  2747,
      -1,  1110,    -1,    -1,    -1,    -1,    -1,    -1,  1117,    -1,
      -1,  2858,    -1,    -1,  1123,    -1,    -1,  2783,    -1,    -1,
      -1,    -1,    -1,  2789,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1144,    -1,    -1,  2885,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1171,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2918,    -1,    -1,  2840,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2858,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1227,  2885,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1254,    -1,    -1,    -1,    -1,
      -1,    -1,  2918,    -1,    -1,    -1,  2904,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1275,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3036,
      -1,    -1,  1301,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1331,  1332,    -1,  1334,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3036,    -1,    -1,    -1,    -1,    -1,  2479,    -1,  2481,    -1,
    2483,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3135,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1420,    -1,    -1,  1423,  1424,    -1,  3065,  3066,  3067,
    3068,  3069,  3070,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3095,    -1,    -1,
      -1,    -1,  3100,  3101,  3102,  3103,  3104,    -1,    -1,    -1,
    3108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3135,
      -1,  1480,    -1,    -1,    -1,    -1,  2579,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2596,    -1,    -1,    -1,    -1,    -1,    -1,
    2603,  2604,    -1,    -1,    -1,  1514,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3166,  1528,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1579,    -1,    -1,  2676,    -1,    -1,    -1,    -1,  2681,    -1,
    2683,    -1,    -1,    -1,    -1,    -1,    -1,  1596,  3335,    -1,
      -1,    -1,  2695,    -1,    -1,    -1,    -1,    -1,  1144,    -1,
      -1,    -1,    -1,  2706,  1613,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3288,    -1,    -1,    -1,    -1,    -1,    -1,  1638,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1144,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3313,    -1,    -1,    -1,  3335,
      -1,    -1,  1681,    -1,  1683,  3323,    -1,  1686,    -1,  1688,
      -1,    -1,    -1,    -1,    -1,  3333,  3334,    -1,  1697,    -1,
    3338,  3339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3348,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1254,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3365,  3366,  3367,
    3467,    -1,    -1,    -1,    -1,    -1,    -1,  3375,  3376,    -1,
      -1,    -1,  3380,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1750,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1254,    -1,    -1,    -1,    -1,    -1,
      -1,  3419,    -1,    -1,    -1,  1784,  1785,    -1,    -1,    -1,
      -1,    -1,    -1,  1792,    -1,    -1,  1795,    -1,    -1,  1798,
      -1,    -1,    -1,    -1,    -1,    -1,  3444,  1806,  1807,    -1,
      -1,  3467,    -1,    -1,    -1,  1814,    -1,    -1,  1817,  1818,
    1819,  1820,    -1,    -1,    -1,    -1,    -1,    -1,  1827,  1828,
      -1,  1830,    -1,  1832,    -1,    -1,  1835,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1849,  1850,    -1,    -1,    -1,  1854,    -1,    -1,    -1,  1858,
      -1,    -1,    -1,  1862,    -1,    -1,  1865,  1866,  1867,  1868,
    1869,  1870,  1871,  1872,  1873,    -1,  1875,    -1,    -1,    -1,
      -1,  1880,    -1,    -1,    -1,  1884,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2988,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3564,    -1,    -1,    -1,
      -1,    -1,  3669,    -1,    -1,    -1,  3673,  3674,    -1,    -1,
      -1,    -1,    -1,    -1,  1480,    -1,  1945,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3615,  1514,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1528,    -1,    -1,  3088,    -1,    -1,    -1,    -1,
    1480,    -1,  3095,  3740,    -1,    -1,    -1,  3100,  3101,  3102,
    3103,  3104,    -1,  3669,    -1,  3108,    -1,  3673,  3674,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2029,    -1,    -1,    -1,  1514,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1579,    -1,    -1,    -1,    -1,  1528,    -1,
    2049,    -1,    -1,    -1,  2053,  2054,    -1,    -1,    -1,    -1,
    1596,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1613,    -1,   953,
      -1,    -1,    -1,    -1,  3740,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1579,
      -1,    -1,  1638,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     984,    -1,    -1,    -1,    -1,    -1,  1596,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1613,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2147,    -1,
    1686,    -1,    -1,    -1,    -1,  2154,    -1,    -1,  1638,    -1,
      -1,  1697,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2173,    -1,  2175,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1686,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1697,    -1,  3312,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3321,    -1,
    3323,    -1,    -1,    -1,    -1,    -1,  1110,    -1,    -1,    -1,
    3333,  3334,    -1,    -1,    -1,  3338,  3339,    -1,    -1,  2248,
      -1,    -1,    -1,    -1,    -1,  3348,    -1,    -1,    -1,  2258,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1849,    -1,    -1,    -1,    -1,    -1,    -1,
    2319,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2330,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2347,  2348,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1849,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2377,    -1,
      -1,    -1,  2381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2393,  2394,  2395,  2396,    -1,    -1,
      -1,  1275,    -1,    -1,    -1,    -1,  2405,    -1,    -1,    -1,
      -1,  2410,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2420,  2421,    -1,  2423,    -1,    -1,  1301,    -1,    -1,
      -1,    -1,    -1,    -1,  3527,    -1,    -1,  2436,    -1,  2438,
      -1,    -1,    -1,  2442,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1331,  1332,  2458,
    1334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2468,
      -1,  2470,  2471,    -1,    -1,    -1,    -1,  1351,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2491,    -1,    -1,    -1,    -1,    -1,  2497,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2506,  2507,  2508,
      -1,    -1,    -1,  2049,    -1,    -1,    -1,  2053,  2054,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2538,
      -1,    -1,    -1,    -1,    -1,    -1,  1420,    -1,    -1,  1423,
    1424,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2559,  2560,    -1,  2562,    -1,    -1,    -1,    -1,    -1,  2049,
      -1,    -1,    -1,  2053,  2054,    -1,  2575,    -1,  2577,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2606,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2154,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2175,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2655,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2154,    -1,    -1,  2676,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2175,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2706,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2721,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2734,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2748,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2764,    -1,    -1,    -1,  2768,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2778,
      -1,    -1,    -1,    -1,  2783,    -1,    -1,    -1,    -1,    -1,
    2789,    -1,    -1,    -1,  2330,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2807,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2837,    -1,
      -1,  2840,    -1,    -1,    -1,    -1,    -1,  2846,    -1,    -1,
    2330,    -1,    -1,  2852,    -1,  2854,    -1,    -1,    -1,  2858,
    2859,    -1,    -1,  2862,  2863,  2864,  2865,  2866,  2867,  2868,
    2869,  2870,  2871,    -1,    -1,    -1,    -1,  2876,  2877,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2885,    -1,    -1,    -1,
      -1,  2890,    -1,    -1,    -1,    -1,    -1,  2896,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2905,    -1,    -1,  2908,
      -1,  2910,    -1,    -1,    -1,    -1,    -1,    -1,  1792,  2918,
    2919,  2920,  2921,    -1,    -1,    -1,  2925,    -1,    -1,  2928,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2938,
    1814,    -1,    -1,  1817,    -1,    -1,  1820,    -1,    -1,    -1,
      -1,    -1,    -1,  1827,  1828,    -1,    -1,    -1,  1832,    -1,
      -1,  1835,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1850,    -1,    -1,    -1,
    1854,    -1,    -1,    -1,  1858,    -1,    -1,    -1,  1862,    -1,
      -1,  1865,  1866,  1867,  1868,  1869,  1870,  1871,  1872,  1873,
      -1,  1875,    -1,    -1,    -1,    -1,  1880,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2559,  2560,    -1,  2562,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3036,    -1,  2575,
      -1,  2577,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2606,  1945,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2559,
    2560,    -1,  2562,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2575,    -1,  2577,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1410,    -1,    -1,    -1,    -1,    -1,    -1,  2655,
      -1,    -1,    -1,    -1,    -1,  3124,  2606,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3135,    -1,    -1,    -1,
    2676,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2029,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2706,    -1,    -1,    -1,    -1,  2655,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2721,    -1,  3186,    -1,    -1,
      -1,    -1,  3191,    -1,    -1,  3194,  2676,    -1,  2734,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2748,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2706,    -1,    -1,    -1,
      -1,    -1,    -1,  3232,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2721,    -1,    -1,    -1,    -1,    -1,  2783,    -1,    -1,
      -1,    -1,    -1,  2789,  2734,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2748,  3268,
      -1,    -1,  1570,  2147,    -1,    -1,  3275,  3276,    -1,    -1,
      -1,    -1,    -1,  3282,  3283,    -1,    -1,    -1,  3287,  3288,
      -1,    -1,    -1,    -1,  3293,  3294,    -1,    -1,  3297,  2173,
      -1,    -1,    -1,  2783,  2840,    -1,    -1,    -1,    -1,  2789,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2858,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3335,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2885,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2840,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2858,    -1,
      -1,    -1,  2918,    -1,  2258,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3402,    -1,  2885,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2290,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1723,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2918,    -1,
      -1,    -1,    -1,    -1,  3443,  2319,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3458,
      -1,    -1,    -1,  3462,    -1,    -1,    -1,    -1,  3467,    -1,
      -1,    -1,    -1,    -1,  2348,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3489,    -1,  1790,    -1,  3493,    -1,    -1,    -1,    -1,    -1,
    3036,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3512,  3513,  1813,    -1,  3516,    -1,  2393,
    1818,  2395,  2396,    -1,  3523,  3524,    -1,    -1,    -1,    -1,
      -1,  2405,    -1,    -1,    -1,    -1,  2410,    -1,    -1,  1837,
    1838,    -1,    -1,  1841,  3543,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3036,    -1,  3557,    -1,
      -1,    -1,  2436,    -1,  2438,    -1,    -1,    -1,  2442,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1878,    -1,    -1,  3582,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3135,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2491,    -1,  3618,
    3619,    -1,    -1,  2497,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2506,  2507,  2508,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3645,  3646,    -1,  3648,
      -1,  3650,    -1,    -1,    -1,  3135,  1954,    -1,    -1,    -1,
      -1,    -1,    -1,  1961,  2538,  1963,    -1,    -1,    -1,    -1,
    3669,    -1,    -1,    -1,  3673,  3674,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3718,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3740,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3779,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3794,    -1,    -1,    -1,  3335,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3288,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3833,  3834,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3847,     5,
      -1,    -1,    -1,    -1,    -1,  3335,    -1,    -1,    -1,    -1,
    3859,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      26,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      36,    37,    -1,    -1,    -1,    -1,    42,    -1,    44,    45,
      -1,    -1,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3467,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   114,    -1,
      -1,    -1,    -1,  2837,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2846,    -1,    -1,    -1,    -1,    -1,  2852,    -1,
    2854,    -1,    -1,    -1,    -1,    -1,    -1,  3467,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2876,  2877,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2896,    -1,    -1,   181,    -1,    -1,    -1,    -1,
      -1,  2905,    -1,    -1,  2908,    -1,  2910,    -1,    -1,   195,
      -1,    -1,    -1,    -1,    -1,  2919,    -1,    -1,    -1,    -1,
      -1,  2925,    -1,  2351,  2928,    -1,    -1,    -1,   214,    -1,
      -1,    -1,    -1,    -1,  2938,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2373,    -1,  2375,   234,  2377,
    2378,    -1,    -1,  2381,    -1,    -1,    -1,  2385,    -1,    -1,
      -1,    -1,    -1,    -1,  2392,    -1,    -1,    -1,    -1,  2397,
      -1,    -1,    -1,    -1,  2402,    -1,    -1,    -1,    -1,  2407,
     266,    -1,    -1,   269,    -1,    -1,    -1,    -1,  2416,    -1,
      -1,    -1,  2420,  2421,  2422,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3669,    -1,   291,  2434,  3673,  3674,    -1,
      -1,    -1,    -1,  2441,    -1,  2443,  2444,  2445,  2446,  2447,
    2448,  2449,  2450,  2451,  2452,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3669,
      -1,    -1,    -1,  3673,  3674,    -1,    -1,    -1,    -1,    -1,
      -1,   357,    -1,    -1,  3740,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     396,    -1,    -1,    -1,    -1,    -1,    -1,  2545,    -1,    -1,
      -1,    -1,   408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3740,    -1,    -1,    -1,    -1,   421,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   443,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   451,   452,    -1,   454,    -1,
     456,    -1,    -1,    -1,   460,   461,   462,   463,    -1,   465,
     466,    -1,    -1,    -1,   470,   471,   472,   473,   474,    -1,
      -1,   477,   478,   479,   480,    -1,   482,   483,   484,    -1,
     486,   487,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2653,    -1,    -1,  3232,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2677,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3275,  3276,     5,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3287,    -1,    -1,    -1,    -1,    -1,  3293,
    3294,    -1,    -1,  3297,    26,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    36,    37,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    45,    -1,    -1,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2780,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2797,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3402,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2836,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2857,
      -1,  2859,    -1,    -1,  2862,  2863,  2864,  2865,  2866,  2867,
    2868,  2869,  2870,  2871,    -1,  2873,    -1,    -1,    -1,   181,
      -1,    -1,    -1,    -1,  3458,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   195,    -1,    -1,    -1,    -1,    -1,  2897,
      -1,    -1,    -1,  2901,    -1,    -1,    -1,    -1,  2906,  2907,
      -1,    -1,   214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2920,  2921,  2922,    -1,  2924,    -1,    -1,  2927,
      -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3516,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3524,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   266,    -1,    -1,   269,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3557,    -1,    -1,    -1,    -1,    -1,   291,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3619,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   357,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3648,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   396,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   408,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   421,
      -1,    -1,    -1,    -1,    -1,    -1,  3124,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   451,
     452,    -1,   454,    -1,    -1,    -1,    -1,    -1,   460,   461,
     462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,
     472,   473,   474,    -1,    -1,   477,   478,   479,    -1,    -1,
      -1,   483,    -1,    -1,    -1,   487,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3233,    -1,    -1,  3236,  3237,
    3238,    -1,    -1,  3241,    -1,    -1,    -1,    -1,  3246,  3247,
    3248,  3249,  3250,  3251,  3252,  3253,  3254,  3255,  3256,  3257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,    -1,
      -1,    -1,    -1,  3281,  3282,  3283,  3284,    -1,  3286,    -1,
      -1,    -1,  3290,  3291,  3292,    -1,    -1,  3295,    26,    -1,
    3298,    -1,    -1,    -1,    -1,    -1,    -1,  3305,    36,    37,
      -1,    -1,    -1,    -1,    -1,    -1,    44,    45,    -1,    -1,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    26,   114,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    36,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    44,    45,    -1,  3404,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   195,    -1,    -1,
      -1,    -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   214,  3485,    -1,    -1,
      -1,  3489,    -1,    -1,    -1,  3493,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3501,    -1,  3503,   234,    -1,    -1,  3507,
    3508,  3509,    -1,    -1,  3512,  3513,  3514,  3515,    -1,  3517,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   266,    -1,
     181,   269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   195,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   291,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   214,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3586,    -1,
      -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   266,    -1,    -1,   269,   357,
      -1,    -1,  3630,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3644,  3645,  3646,  3647,
     291,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3657,
    3658,  3659,    -1,  3661,    -1,    -1,    -1,    -1,   396,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3676,    -1,
     408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   421,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   443,   357,    -1,  3716,    -1,
      -1,    -1,    -1,   451,   452,    -1,   454,    -1,    -1,    -1,
    3728,  3729,   460,   461,   462,   463,    -1,   465,   466,    -1,
      -1,    -1,   470,   471,   472,   473,   474,    -1,    -1,   477,
     478,   479,   480,    -1,    -1,   396,    -1,    -1,    -1,   487,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   408,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     421,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     451,   452,    -1,   454,    -1,    -1,    -1,    -1,    -1,   460,
     461,   462,   463,     5,   465,   466,    -1,    -1,    -1,   470,
     471,   472,   473,   474,    -1,    -1,   477,   478,   479,   480,
      -1,    -1,    -1,    -1,    26,    -1,   487,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    36,    37,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    45,    -1,    -1,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   195,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   266,    -1,    -1,   269,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   291,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   357,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   396,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   408,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   421,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   451,
     452,    -1,   454,    -1,    -1,    -1,    -1,    -1,   460,   461,
     462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,
     472,   473,   474,    -1,    -1,   477,   478,   479,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   487,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    -1,    17,    18,
      -1,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    -1,
      39,    40,    41,    -1,    43,    44,    45,    46,    47,    -1,
      -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,
      -1,    70,    71,    -1,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,    -1,   105,   106,   107,    -1,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,    -1,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,    -1,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
      -1,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,    -1,
      -1,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,    -1,   317,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,   405,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,   417,   418,
     419,    -1,   421,   422,   423,   424,   425,   426,   427,   428,
     429,   430,   431,   432,   433,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,   444,   445,    -1,    -1,    -1,
      -1,    -1,   451,    -1,    -1,   454,    -1,    -1,    -1,     6,
       7,     8,    -1,    10,    11,    12,    13,    14,    -1,    -1,
      -1,    18,    -1,    20,    21,    22,    23,    24,    25,    -1,
      27,    28,    -1,    -1,   483,    32,    33,    34,    35,    -1,
      37,    -1,    39,    40,    41,    -1,    43,    44,    45,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,
      57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,
      -1,    68,    -1,    70,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      -1,    -1,    -1,   100,   101,   102,   103,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,
      -1,    -1,    -1,    -1,    -1,   122,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   154,   155,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,    -1,
     187,    -1,    -1,   190,    -1,    -1,    -1,    -1,   195,    -1,
      -1,    -1,    -1,   200,    -1,   202,    -1,    -1,    -1,    -1,
      -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   216,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   228,   229,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,   240,   241,    -1,   243,    -1,    -1,    -1,
      -1,    -1,    -1,   250,   251,    -1,   253,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   284,    -1,    -1,
      -1,    -1,   289,    -1,    -1,   292,    -1,   294,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     307,   308,   309,   310,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   318,   319,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   330,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     347,    -1,    -1,   350,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   365,    -1,
      -1,   368,    -1,   370,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   382,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   394,   395,    -1,
      -1,    -1,   399,    -1,   401,    -1,    -1,    -1,    -1,    -1,
      -1,   408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   421,    -1,   423,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   435,   436,
     437,   438,   439,   440,   441,   442,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   451,    -1,    -1,   454,    -1,    -1,
      -1,    -1,     6,     7,     8,    -1,    10,    11,    12,    13,
      14,    -1,    -1,    -1,    18,    -1,    20,    21,    22,    23,
      24,    25,    -1,    27,    28,    -1,    -1,   484,    32,    33,
      34,    35,    -1,    37,    -1,    39,    40,    41,    -1,    43,
      44,    45,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    -1,    68,    -1,    70,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    -1,    -1,    -1,   100,   101,   102,   103,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,   122,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   141,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     154,   155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,    -1,
      -1,    -1,    -1,   187,    -1,    -1,   190,    -1,    -1,    -1,
      -1,   195,    -1,    -1,    -1,    -1,   200,    -1,   202,    -1,
      -1,    -1,    -1,    -1,   208,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   228,   229,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,   240,   241,    -1,   243,
      -1,    -1,    -1,    -1,    -1,    -1,   250,   251,    -1,   253,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     284,    -1,    -1,    -1,    -1,   289,    -1,    -1,   292,    -1,
     294,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   307,   308,   309,   310,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   318,   319,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   330,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   347,    -1,    -1,   350,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   365,    -1,    -1,   368,    -1,   370,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   382,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     394,   395,    -1,    -1,    -1,   399,    -1,   401,    -1,    -1,
      -1,    -1,    -1,    -1,   408,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   421,    -1,   423,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   435,   436,   437,   438,   439,   440,   441,   442,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   451,    -1,    -1,
     454,    -1,     3,    -1,    -1,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    -1,    27,    28,    29,    -1,
     484,    32,    33,    34,    35,    -1,    37,    -1,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    -1,    99,   100,
     101,   102,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,   120,
     121,   122,    -1,    -1,   125,   126,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   135,    -1,   137,    -1,    -1,    -1,
     141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,    -1,   153,   154,   155,   156,    -1,    -1,    -1,    -1,
      -1,   162,    -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,
      -1,    -1,    -1,   174,    -1,    -1,    -1,    -1,    -1,   180,
     181,    -1,    -1,    -1,    -1,   186,   187,   188,    -1,   190,
      -1,    -1,   193,    -1,   195,    -1,    -1,    -1,    -1,   200,
      -1,   202,    -1,   204,    -1,   206,    -1,   208,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,    -1,   237,    -1,    -1,   240,
     241,    -1,   243,    -1,    -1,    -1,    -1,    -1,    -1,   250,
     251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,    -1,
     261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   270,
      -1,    -1,   273,   274,   275,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   284,    -1,    -1,    -1,   288,   289,    -1,
      -1,   292,    -1,   294,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   307,   308,   309,   310,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   318,   319,    -1,
     321,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   330,
     331,    -1,    -1,   334,    -1,   336,    -1,    -1,    -1,    -1,
     341,    -1,    -1,    -1,    -1,   346,   347,    -1,   349,   350,
      -1,    -1,   353,    -1,    -1,    -1,    -1,    -1,   359,    -1,
      -1,    -1,    -1,   364,   365,    -1,   367,   368,    -1,   370,
      -1,    -1,    -1,   374,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   394,   395,    -1,    -1,    -1,   399,    -1,
     401,    -1,   403,    -1,   405,    -1,    -1,   408,    -1,    -1,
     411,    -1,   413,    -1,    -1,   416,    -1,    -1,    -1,   420,
     421,    -1,   423,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   435,   436,   437,   438,   439,   440,
     441,   442,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     451,    -1,    -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,   479,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    -1,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,   409,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,
     471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    -1,    17,    18,    -1,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    -1,    39,    40,    41,    -1,    43,    44,
      45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
      -1,   106,   107,    -1,   109,   110,   111,   112,   113,   114,
     115,   116,    -1,   118,   119,   120,   121,   122,    -1,    -1,
     125,   126,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,   136,    -1,   138,   139,   140,   141,   142,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,   167,   168,    -1,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,    -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,    -1,   210,    -1,   212,   213,   214,
     215,   216,   217,   218,   219,    -1,   221,   222,   223,   224,
     225,   226,    -1,   228,   229,    -1,   231,   232,   233,   234,
     235,    -1,   237,    -1,    -1,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,
      -1,    -1,   307,   308,   309,   310,   311,   312,   313,   314,
     315,    -1,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,    -1,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,    -1,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,    -1,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,   394,
     395,    -1,    -1,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,    -1,   409,   410,   411,   412,   413,   414,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,    -1,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,    -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,
     455,    -1,    -1,   458,   459,   460,   461,   462,   463,   464,
     465,    -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   479,   480,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    -1,    17,    18,
      -1,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    -1,
      39,    40,    41,    -1,    43,    44,    45,    46,    47,    -1,
      -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,
      -1,    70,    71,    -1,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    92,    93,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,    -1,   106,   107,    -1,
     109,   110,    -1,    -1,   113,   114,   115,   116,    -1,   118,
     119,   120,   121,    -1,    -1,    -1,   125,   126,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,   136,    -1,   138,
     139,   140,   141,   142,    -1,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,   167,   168,
      -1,    -1,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,    -1,    -1,   182,    -1,   184,   185,   186,    -1,   188,
     189,    -1,    -1,   192,   193,   194,   195,    -1,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,   207,    -1,
      -1,   210,    -1,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,    -1,   228,
     229,    -1,   231,   232,   233,   234,   235,    -1,   237,    -1,
      -1,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,    -1,   251,   252,   253,    -1,   255,   256,   257,    -1,
      -1,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,    -1,   277,   278,
     279,   280,   281,   282,   283,    -1,   285,    -1,   287,   288,
     289,   290,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,    -1,    -1,    -1,   303,   304,    -1,    -1,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,    -1,   317,    -1,
      -1,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,    -1,   345,   346,   347,   348,
     349,    -1,   351,   352,   353,   354,   355,   356,   357,    -1,
      -1,   360,   361,   362,    -1,   364,   365,   366,   367,   368,
     369,   370,    -1,   372,   373,   374,   375,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,   394,   395,    -1,    -1,   398,
      -1,   400,    -1,    -1,   403,   404,   405,   406,   407,    -1,
      -1,   410,   411,   412,   413,    -1,    -1,   416,   417,   418,
     419,    -1,   421,   422,   423,   424,   425,   426,    -1,    -1,
     429,   430,   431,   432,   433,   434,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   443,   444,   445,    -1,    -1,    -1,
      -1,    -1,   451,    -1,    -1,   454,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,    -1,
      20,    21,    22,    23,    24,    25,    -1,    27,    28,    29,
      -1,   480,    32,    33,    34,    35,    -1,    -1,    -1,    39,
      40,    41,    -1,    43,    -1,    -1,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    92,    93,    -1,    95,    -1,    97,    98,    99,
      -1,   101,    -1,   103,    -1,    -1,   106,   107,    -1,   109,
     110,    -1,    -1,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,    -1,   138,   139,
     140,    -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,   167,   168,    -1,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
      -1,    -1,   182,    -1,   184,   185,   186,   187,   188,   189,
     190,    -1,   192,   193,   194,   195,    -1,   197,    -1,   199,
      -1,    -1,    -1,   203,    -1,   205,    -1,   207,   208,    -1,
     210,    -1,   212,   213,   214,   215,    -1,   217,   218,   219,
      -1,   221,   222,   223,   224,   225,   226,    -1,    -1,   229,
      -1,   231,   232,   233,    -1,   235,    -1,   237,    -1,    -1,
      -1,    -1,   242,    -1,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,    -1,    -1,   255,   256,   257,    -1,    -1,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,    -1,   275,    -1,   277,   278,   279,
     280,   281,   282,   283,   284,   285,    -1,   287,   288,    -1,
     290,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
      -1,    -1,    -1,   303,   304,    -1,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,    -1,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,    -1,   345,   346,    -1,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,    -1,    -1,
     360,   361,   362,    -1,   364,   365,   366,   367,    -1,   369,
     370,    -1,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,   394,   395,    -1,    -1,   398,   399,
     400,   401,    -1,   403,   404,   405,   406,   407,    -1,    -1,
     410,   411,   412,   413,    -1,   415,   416,   417,   418,   419,
     420,   421,   422,    -1,   424,   425,   426,    -1,    -1,   429,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,
      -1,   451,    -1,    -1,   454,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   477,    -1,    -1,
      -1,   481,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,    -1,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    -1,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    89,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,   111,   112,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,   182,
      -1,   184,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,    -1,   197,    -1,   199,   200,   201,   202,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,   216,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,   228,   229,    -1,   231,   232,
     233,   234,   235,    -1,   237,    -1,    -1,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,   304,    -1,    -1,   307,   308,   309,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,   397,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,    -1,   409,   410,   411,   412,
     413,   414,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,   452,
     453,   454,   455,    -1,    -1,   458,   459,   460,   461,   462,
     463,   464,   465,    -1,    -1,    -1,    -1,   470,   471,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   479,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      -1,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,    -1,   106,   107,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,    -1,
     138,   139,   140,   141,   142,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,   167,
     168,    -1,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,    -1,    -1,   182,    -1,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,    -1,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,    -1,   210,    -1,   212,   213,   214,   215,   216,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,    -1,
     228,   229,    -1,   231,   232,   233,   234,   235,    -1,   237,
      -1,    -1,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,   304,    -1,    -1,   307,
     308,   309,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,    -1,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
      -1,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,    -1,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,   394,   395,    -1,    -1,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
      -1,   409,   410,   411,   412,   413,   414,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
      -1,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,    -1,    -1,
      -1,    -1,    -1,   451,   452,   453,   454,   455,    -1,    -1,
     458,   459,   460,   461,   462,   463,   464,   465,    -1,    -1,
      -1,    -1,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,    -1,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    -1,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    89,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,    -1,   106,   107,    -1,   109,   110,   111,   112,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,   157,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,   182,
      -1,   184,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,    -1,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,   216,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,   228,   229,    -1,   231,   232,
     233,   234,   235,    -1,   237,    -1,    -1,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,   304,    -1,    -1,   307,   308,   309,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,    -1,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,    -1,   409,   410,   411,   412,
     413,   414,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,   452,
     453,   454,   455,    -1,    -1,   458,   459,   460,   461,   462,
     463,   464,   465,    -1,    -1,    -1,    -1,   470,   471,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   479,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      -1,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,    -1,   106,   107,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,    -1,
     138,   139,   140,   141,   142,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,   167,
     168,    -1,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,    -1,    -1,   182,    -1,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,    -1,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,    -1,   210,    -1,   212,   213,   214,   215,   216,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,    -1,
     228,   229,    -1,   231,   232,   233,   234,   235,    -1,   237,
      -1,    -1,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,   304,    -1,    -1,   307,
     308,   309,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,    -1,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,    -1,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,   394,   395,    -1,    -1,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
      -1,   409,   410,   411,   412,   413,   414,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
      -1,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,    -1,    -1,
      -1,    -1,    -1,   451,   452,   453,   454,   455,    -1,    -1,
     458,   459,   460,   461,   462,   463,   464,   465,    -1,    -1,
      -1,    -1,   470,   471,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   479,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,    -1,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    -1,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    -1,    -1,    -1,    89,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,    -1,   106,   107,    -1,   109,   110,   111,   112,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,   182,
      -1,   184,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,    -1,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,   216,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,   228,   229,    -1,   231,   232,
     233,   234,   235,    -1,   237,    -1,    -1,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,   304,    -1,    -1,   307,   308,   309,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,    -1,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,    -1,   409,   410,   411,   412,
     413,   414,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,   452,
     453,   454,   455,    -1,    -1,   458,   459,   460,   461,   462,
     463,   464,   465,    -1,    -1,    -1,    -1,   470,   471,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   479,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      -1,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,    -1,   106,   107,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,    -1,
     138,   139,   140,   141,   142,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,   167,
     168,    -1,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,    -1,    -1,   182,    -1,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,    -1,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,    -1,   210,    -1,   212,   213,   214,   215,   216,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,    -1,
     228,   229,    -1,   231,   232,   233,   234,   235,    -1,   237,
      -1,    -1,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,   304,    -1,    -1,   307,
     308,   309,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,    -1,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
      -1,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,    -1,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,   394,   395,    -1,    -1,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
      -1,   409,   410,   411,   412,   413,   414,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
      -1,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,    -1,    -1,
      -1,    -1,    -1,   451,   452,   453,   454,   455,    -1,    -1,
     458,   459,   460,   461,   462,   463,   464,   465,    -1,    -1,
      -1,    -1,   470,   471,    -1,    -1,    -1,    -1,    -1,   477,
      -1,   479,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,    -1,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    -1,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    89,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,    -1,   106,   107,    -1,   109,   110,   111,   112,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,   182,
      -1,   184,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,    -1,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,   216,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,   228,   229,    -1,   231,   232,
     233,   234,   235,    -1,   237,    -1,    -1,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,   304,    -1,    -1,   307,   308,   309,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,    -1,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,    -1,   409,   410,   411,   412,
     413,   414,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,   452,
     453,   454,   455,    -1,    -1,   458,   459,   460,   461,   462,
     463,   464,   465,    -1,    -1,    -1,    -1,   470,   471,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   479,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      -1,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,    -1,   106,   107,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,    -1,
     138,   139,   140,   141,   142,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,   167,
     168,    -1,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,    -1,    -1,   182,    -1,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,    -1,   197,
      -1,   199,   200,   201,   202,   203,    -1,   205,    -1,   207,
     208,    -1,   210,    -1,   212,   213,   214,   215,   216,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,    -1,
     228,   229,    -1,   231,   232,   233,   234,   235,    -1,   237,
      -1,    -1,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,   304,    -1,    -1,   307,
     308,   309,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,    -1,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
      -1,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,    -1,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,   394,   395,    -1,    -1,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
      -1,   409,   410,   411,   412,   413,   414,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
      -1,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,    -1,    -1,
      -1,    -1,    -1,   451,   452,   453,   454,   455,    -1,    -1,
     458,   459,   460,   461,   462,   463,   464,   465,    -1,    -1,
      -1,    -1,   470,   471,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   479,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,    -1,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    -1,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    89,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,    -1,   106,   107,    -1,   109,   110,   111,   112,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,   182,
      -1,   184,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,    -1,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,   216,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,   228,   229,    -1,   231,   232,
     233,   234,   235,    -1,   237,    -1,    -1,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,   304,    -1,    -1,   307,   308,   309,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,    -1,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,    -1,   409,   410,   411,   412,
     413,   414,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,   452,
     453,   454,   455,    -1,    -1,   458,   459,   460,   461,   462,
     463,   464,   465,    -1,    -1,    -1,    -1,   470,   471,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   479,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      -1,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,    -1,   106,   107,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,    -1,
     138,   139,   140,   141,   142,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,   167,
     168,    -1,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,    -1,    -1,   182,    -1,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,    -1,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,    -1,   210,    -1,   212,   213,   214,   215,   216,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,    -1,
     228,   229,    -1,   231,   232,   233,   234,   235,    -1,   237,
      -1,    -1,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,   304,    -1,    -1,   307,
     308,   309,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,    -1,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
      -1,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,    -1,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,   394,   395,    -1,    -1,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
      -1,   409,   410,   411,   412,   413,   414,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
      -1,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,    -1,    -1,
      -1,    -1,    -1,   451,   452,   453,   454,   455,    -1,    -1,
     458,   459,   460,   461,   462,   463,   464,   465,    -1,    -1,
      -1,    -1,   470,   471,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   479,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,    -1,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    -1,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    89,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,    -1,   106,   107,    -1,   109,   110,   111,   112,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,   182,
      -1,   184,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,    -1,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,   216,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,   228,   229,    -1,   231,   232,
     233,   234,   235,    -1,   237,    -1,    -1,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,   304,    -1,    -1,   307,   308,   309,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,    -1,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,    -1,   409,   410,   411,   412,
     413,   414,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,   452,
     453,   454,   455,    -1,    -1,   458,   459,   460,   461,   462,
     463,   464,   465,    -1,    -1,    -1,    -1,   470,   471,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   479,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      -1,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,    -1,   106,   107,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,    -1,
     138,   139,   140,   141,   142,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,   167,
     168,    -1,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,    -1,    -1,   182,    -1,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,    -1,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,    -1,   210,    -1,   212,   213,   214,   215,   216,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,    -1,
     228,   229,    -1,   231,   232,   233,   234,   235,    -1,   237,
      -1,    -1,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,    -1,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,   304,    -1,    -1,   307,
     308,   309,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,    -1,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
      -1,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,    -1,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,   394,   395,    -1,    -1,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
      -1,    -1,   410,   411,   412,   413,   414,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
      -1,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,    -1,    -1,
      -1,    -1,    -1,   451,   452,   453,   454,   455,    -1,    -1,
     458,   459,   460,   461,   462,   463,   464,   465,    -1,    -1,
      -1,    -1,    -1,   471,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   479,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,    -1,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    -1,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    89,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,    -1,   101,   102,
     103,   104,    -1,   106,   107,    -1,   109,   110,   111,   112,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,    -1,
      -1,   184,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,    -1,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,    -1,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,   228,   229,    -1,   231,   232,
     233,   234,   235,    -1,   237,    -1,    -1,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,   251,   252,
      -1,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,   304,    -1,    -1,   307,   308,   309,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,    -1,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,    -1,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,    -1,   409,   410,   411,   412,
     413,   414,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,   452,
     453,   454,   455,    -1,    -1,   458,   459,   460,   461,   462,
     463,   464,   465,    -1,    -1,    -1,    -1,   470,   471,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   479,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      -1,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    92,    93,    -1,    95,    96,    97,
      98,    99,    -1,   101,   102,   103,   104,    -1,   106,   107,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,    -1,
     138,   139,   140,   141,   142,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,   167,
     168,    -1,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,    -1,    -1,    -1,    -1,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,    -1,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,    -1,   210,    -1,   212,   213,   214,   215,    -1,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,    -1,
     228,   229,    -1,   231,   232,   233,   234,   235,    -1,   237,
      -1,    -1,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,    -1,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,    -1,   304,    -1,    -1,   307,
     308,   309,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,    -1,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
      -1,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,   369,   370,    -1,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,   394,   395,    -1,    -1,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
      -1,    -1,   410,   411,   412,   413,   414,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
      -1,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,    -1,    -1,
      -1,    -1,    -1,   451,   452,    -1,   454,   455,    -1,    -1,
     458,   459,   460,   461,   462,   463,   464,   465,    -1,    -1,
      -1,    -1,    -1,   471,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   479,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,    -1,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    -1,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,    -1,    -1,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,   182,
      -1,   184,   185,   186,   187,   188,   189,   190,    -1,   192,
     193,   194,   195,    -1,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,   216,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,   228,   229,    -1,   231,   232,
     233,    -1,   235,    -1,   237,    -1,    -1,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,    -1,   287,   288,   289,   290,    -1,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,   302,
     303,   304,    -1,    -1,   307,   308,   309,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,    -1,   398,   399,   400,   401,    -1,
     403,   404,   405,   406,   407,    -1,    -1,   410,   411,   412,
     413,   414,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,    -1,
      -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,   479,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    -1,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,    -1,    -1,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,   182,
      -1,   184,   185,   186,   187,   188,   189,   190,    -1,   192,
     193,   194,   195,    -1,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,   216,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,   228,   229,    -1,   231,   232,
     233,    -1,   235,    -1,   237,    -1,    -1,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,    -1,   287,   288,   289,   290,    -1,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,   302,
     303,   304,    -1,    -1,   307,   308,   309,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,    -1,   398,   399,   400,   401,    -1,
     403,   404,   405,   406,   407,    -1,    -1,   410,   411,   412,
     413,   414,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,    -1,
      -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,   479,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    -1,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,    -1,    -1,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,   182,
      -1,   184,   185,   186,   187,   188,   189,   190,    -1,   192,
     193,   194,   195,    -1,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,   216,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,   228,   229,    -1,   231,   232,
     233,    -1,   235,    -1,   237,    -1,    -1,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,    -1,   287,   288,   289,   290,    -1,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,   304,    -1,    -1,   307,   308,   309,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,    -1,   398,   399,   400,   401,    -1,
     403,   404,   405,   406,   407,    -1,    -1,   410,   411,   412,
     413,   414,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,    -1,
      -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,   479,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    -1,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,    -1,    -1,   106,   107,    -1,   109,   110,    -1,    -1,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
      -1,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,   182,
      -1,   184,   185,   186,   187,   188,   189,   190,    -1,   192,
     193,   194,   195,    -1,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,   216,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,   228,   229,    -1,   231,   232,
     233,    -1,   235,    -1,   237,    -1,    -1,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,    -1,   255,   256,   257,    -1,    -1,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,    -1,   287,   288,   289,   290,    -1,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,   304,    -1,    -1,   307,   308,   309,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,    -1,   360,   361,   362,
      -1,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,    -1,   398,   399,   400,   401,    -1,
     403,   404,   405,   406,   407,    -1,    -1,   410,   411,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,    -1,
      -1,   454,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    -1,    17,    18,    -1,    20,    21,    22,    23,
      24,    25,    -1,    27,    28,    29,   479,    -1,    32,    33,
      34,    35,    -1,    -1,    -1,    39,    40,    41,    -1,    43,
      -1,    -1,    46,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    -1,    -1,    -1,    -1,    -1,    90,    -1,    92,    93,
      -1,    95,    -1,    97,    98,    99,    -1,   101,    -1,   103,
      -1,    -1,   106,   107,    -1,   109,   110,    -1,    -1,   113,
     114,   115,   116,    -1,   118,   119,   120,   121,   122,    -1,
      -1,   125,   126,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,   136,    -1,   138,   139,   140,   141,   142,    -1,
      -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,
     154,   155,   156,    -1,   158,    -1,   160,    -1,   162,   163,
     164,    -1,   166,   167,   168,    -1,    -1,   171,   172,   173,
     174,   175,    -1,   177,   178,   179,    -1,    -1,   182,    -1,
     184,   185,   186,   187,   188,   189,   190,    -1,   192,   193,
     194,   195,    -1,   197,    -1,   199,    -1,    -1,   202,   203,
      -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,   213,
     214,   215,    -1,   217,   218,   219,    -1,   221,   222,   223,
     224,   225,   226,    -1,   228,   229,    -1,   231,   232,   233,
      -1,   235,    -1,   237,    -1,    -1,    -1,    -1,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,   251,   252,    -1,
      -1,   255,   256,   257,    -1,    -1,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,    -1,   277,   278,   279,   280,   281,   282,   283,
     284,   285,    -1,   287,   288,    -1,   290,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,    -1,    -1,    -1,   303,
     304,    -1,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,    -1,   317,   318,   319,   320,   321,   322,    -1,
     324,   325,   326,   327,   328,   329,   330,   331,   332,    -1,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
      -1,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,    -1,    -1,   360,   361,   362,    -1,
     364,   365,   366,   367,    -1,   369,   370,    -1,   372,   373,
     374,   375,   376,   377,   378,   379,   380,   381,   382,   383,
      -1,   385,   386,    -1,   388,   389,   390,   391,   392,    -1,
     394,   395,    -1,    -1,   398,   399,   400,   401,    -1,   403,
     404,   405,   406,   407,    -1,    -1,   410,   411,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,    -1,
     424,   425,   426,    -1,    -1,   429,   430,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
     444,   445,    -1,    -1,    -1,    -1,    -1,   451,    -1,    -1,
     454,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    -1,    17,    18,    -1,    20,    21,    22,    23,    24,
      25,    -1,    27,    28,    29,    -1,   480,    32,    33,    34,
      35,    -1,    -1,    -1,    39,    40,    41,    -1,    43,    -1,
      -1,    46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,    93,    -1,
      95,    -1,    97,    98,    99,    -1,   101,    -1,   103,    -1,
      -1,   106,   107,    -1,   109,   110,    -1,    -1,   113,   114,
     115,   116,    -1,   118,   119,   120,   121,   122,    -1,    -1,
     125,   126,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,   136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,   167,   168,    -1,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,
     185,   186,   187,   188,   189,   190,    -1,   192,   193,   194,
     195,    -1,   197,    -1,   199,    -1,    -1,    -1,   203,    -1,
     205,    -1,   207,   208,    -1,   210,    -1,   212,   213,   214,
     215,    -1,   217,   218,   219,    -1,   221,   222,   223,   224,
     225,   226,    -1,    -1,   229,    -1,   231,   232,   233,    -1,
     235,    -1,   237,    -1,    -1,    -1,    -1,   242,    -1,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,    -1,    -1,
     255,   256,   257,    -1,    -1,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,    -1,
     275,    -1,   277,   278,   279,   280,   281,   282,   283,   284,
     285,    -1,   287,   288,    -1,   290,    -1,   292,   293,   294,
     295,   296,    -1,    -1,   299,    -1,    -1,    -1,   303,   304,
      -1,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,    -1,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,    -1,
     345,   346,    -1,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,    -1,    -1,   360,   361,   362,    -1,   364,
     365,   366,   367,    -1,   369,   370,    -1,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,    -1,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,   394,
     395,    -1,    -1,   398,   399,   400,   401,    -1,   403,   404,
     405,   406,   407,    -1,    -1,   410,   411,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,    -1,   424,
     425,   426,    -1,    -1,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,    -1,    -1,    -1,    -1,    -1,   451,   452,    -1,   454,
     455,    -1,    -1,    -1,    -1,   460,   461,   462,   463,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   478,   479,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    -1,    27,    28,    29,    -1,
      -1,    32,    33,    34,    35,    -1,    -1,    -1,    39,    40,
      41,    -1,    43,    -1,    -1,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    92,    93,    -1,    95,    -1,    97,    98,    99,    -1,
     101,    -1,   103,    -1,    -1,   106,   107,    -1,   109,   110,
      -1,    -1,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
      -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
      -1,   192,   193,   194,   195,    -1,   197,    -1,   199,    -1,
      -1,    -1,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,    -1,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,    -1,   229,    -1,
     231,   232,   233,    -1,   235,    -1,   237,    -1,    -1,    -1,
      -1,   242,    -1,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,    -1,    -1,   255,   256,   257,    -1,    -1,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,    -1,   275,    -1,   277,   278,   279,   280,
     281,   282,   283,   284,   285,    -1,   287,   288,    -1,   290,
      -1,   292,   293,   294,   295,   296,    -1,    -1,   299,    -1,
      -1,    -1,   303,   304,    -1,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,    -1,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,    -1,   364,   365,   366,   367,    -1,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,    -1,   403,   404,   405,   406,   407,    -1,    -1,   410,
     411,   412,   413,    -1,    -1,   416,   417,   418,   