/*--------------------------------------------------------------------
 * FILE:
 *     probe_set_pglb_status.c
 *
 * NOTE:
 *     This file is composed of the probe process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/shm.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

int PGC_Set_Pglb_Status(Probe_Header * header, char * packet);
Pglb_Info * PGC_Get_PglbTbl_Rec(Pglb_Info * key);

int
PGC_Set_Pglb_Status(Probe_Header * header, char * packet)
{
	char * func = "PGC_Set_Pglb_Status()";
	Pglb_Info * pglb_key = NULL;
	Pglb_Info * pglb = NULL;

	if ((header == NULL ) || (packet == NULL) || (PglbTbl == NULL))
	{
		show_error("%s: table is not allocated",func);
		return STATUS_ERROR;
	}
	if (ntohl(header->body_length) < sizeof(Pglb_Info))
	{
		show_error("%s: there is no packet data ",func);
		return STATUS_ERROR;
	}
	pglb_key = (Pglb_Info *) packet;
	pglb = PGC_Get_PglbTbl_Rec(pglb_key);
	if (pglb == NULL)
	{
		show_error("%s: there is no such pglb in PglbTbl",func);
		return STATUS_ERROR;
	}
	show_debug("%s:pglb->status[%d] <- [%d]\n",func, pglb->status, ntohs(pglb_key->status));
	pglb->status = ntohs(pglb_key->status);

	return STATUS_OK;
}

Pglb_Info *
PGC_Get_PglbTbl_Rec(Pglb_Info * key)
{
	Pglb_Info * pglb = NULL;
	if (PglbTbl == NULL)
	{
		return NULL;
	}
	pglb = PglbTbl;
	while (pglb->receivePortNumber != 0)
	{
		if (pglb->serverNo == ntohs(key->serverNo))
		{
			return pglb;
		}
		pglb ++;
	}
	return NULL;
}
