/*--------------------------------------------------------------------
 * FILE:
 *     socket.c
 *
 * NOTE:
 *     This file is composed of the communication modules
 *
 * Portions Copyright (c) 2003-2008, Atsushi Mitani
 * Portions Copyright (c) 2003-2007	PgPool Global Development Group
 *--------------------------------------------------------------------
 * pglb is based on pgpool.
 * pgpool: a language independent connection pool server for PostgreSQL 
 * written by Tatsuo Ishii
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of the
 * author not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. The author makes no representations about the
 * suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
*/
#include "postgres.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/ipc.h>
#include <netdb.h>
#include <errno.h>
#include <fcntl.h>
#include <time.h>
#include <sys/param.h>
#include <sys/file.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#ifdef HAVE_NETINET_TCP_H
#include <netinet/tcp.h>
#endif

#include "replicate_com.h"
#include "pglb.h"


/*--------------------------------------
 * PROTOTYPE DECLARATION
 *--------------------------------------
 */
int PGRread_byte(int sock,char * buf,int len, int flag);
int PGRcreate_cluster_socket( int * sock, ClusterTbl * ptr );

int
PGRread_byte(int sock,char * buf,int len, int flag)
{
	char * func = "PGRread_byte()";
	int r;
	char * read_ptr;
	int read_size = 0;
	int max_buf_size ;
	int pid;

	pid = getpid();
	max_buf_size = len;
	read_ptr = (char*)buf;
	for (;;)
	{
		r = recv(sock,read_ptr + read_size ,max_buf_size - read_size, flag);
		if (r < 0)
		{
			if (errno == EINTR)
			{
				continue;
			}
#ifdef EAGAIN
			if (errno == EAGAIN)
			{
				return read_size;
			}
#endif
#if defined(EWOULDBLOCK) && (!defined(EAGAIN) || (EWOULDBLOCK != EAGAIN))
			if (errno == EWOULDBLOCK)
			{
				show_error("%s:no data (%s)",func,strerror(errno));
				return read_size;
			}
#endif
#ifdef ECONNRESET
			if (errno == ECONNRESET)
			{
				PGR_Close_Sock(&sock);
				show_error("%s:connection reset (%s)",func, strerror(errno));
				return -1;
			}
#endif
			show_error("%s:recv() failed. (%s)",func,strerror(errno));
			read_size = -1;
			break;
		}
		if (r > 0)
		{
			read_size += r;
			if (max_buf_size == read_size)
			{
				break;
			}
			break;
		}
		if (read_size)
		{
			return read_size;
		}
		else
		{
			return -1;
		}
	}

	return read_size;
}

int
PGRcreate_cluster_socket( int * sock, ClusterTbl * ptr )
{
	char * func = "PGRcreate_cluster_socket()";
	int status = STATUS_ERROR;

	/*
	if (PGRis_connection_full(ptr) == 1)
	{
		return STATUS_ERROR;
	}
	*/
	if (ptr != (ClusterTbl *) NULL)
	{
		status = PGR_Create_Send_Socket(sock, ptr->hostName, ptr->port)	;
	}
	else
	{
		show_error("%s:ClusterTbl is not initialize",func);
	}
	return status;
}
