/*--------------------------------------------------------------------
 * FILE:
 *     show.c
 *
 * NOTE:
 *     This file is composed of the probe process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <ctype.h>
#include <time.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <arpa/inet.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

void show_cluster_tbl(ClusterTbl * cluster);
void show_host_tbl(HostTbl * host);
void show_replicate_server_info(ReplicateServerInfo * rep);
void show_pglb_info(Pglb_Info * pglb);

void
show_cluster_tbl(ClusterTbl * cluster)
{
	char * func = "show_cluster_tbl()";
	if (cluster == NULL)
		return;
	fprintf(stderr,"%s:useFlag[%d]\n",func,cluster->useFlag);
	fprintf(stderr,"%s:port[%d]\n",func,cluster->port);
	fprintf(stderr,"%s:max_connect[%d]\n",func,cluster->max_connect);
	fprintf(stderr,"%s:use_num[%d]\n",func,cluster->use_num);
	fprintf(stderr,"%s:rate[%d]\n",func,cluster->rate);
	fprintf(stderr,"%s:rec_no[%d]\n",func,cluster->rec_no);
	fprintf(stderr,"%s:retry_count[%d]\n",func,cluster->retry_count);
	/*
	fprintf(stderr,"%s:hostName[%s]\n",func,cluster->hostName);
	*/
}

void
show_cluster_tbl_net(ClusterTbl * cluster)
{
	char * func = "show_cluster_tbl_net()";
	if (cluster == NULL)
		return;
	fprintf(stderr,"%s:useFlag[%d]\n",func,ntohs(cluster->useFlag));
	fprintf(stderr,"%s:port[%d]\n",func,ntohs(cluster->port));
	fprintf(stderr,"%s:max_connect[%d]\n",func,ntohs(cluster->max_connect));
	fprintf(stderr,"%s:use_num[%d]\n",func,ntohs(cluster->use_num));
	fprintf(stderr,"%s:rate[%d]\n",func,ntohs(cluster->rate));
	fprintf(stderr,"%s:rec_no[%d]\n",func,ntohs(cluster->rec_no));
	fprintf(stderr,"%s:retry_count[%d]\n",func,ntohs(cluster->retry_count));
	/*
	fprintf(stderr,"%s:hostName[%s]\n",func,cluster->hostName);
	*/
}
void
show_host_tbl(HostTbl * host)
{
	char * func ="show_host_tbl()";
	if (host == NULL)
		return;
	fprintf(stderr,"%s:useFlag[%d]\n",func,host->useFlag);
	fprintf(stderr,"%s:port[%d]\n",func,host->port);
	fprintf(stderr,"%s:recoveryPort[%d]\n",func,host->recoveryPort);
	fprintf(stderr,"%s:hostNum[%d]\n",func,host->hostNum);
	fprintf(stderr,"%s:retry_count[%d]\n",func,host->retry_count);
	fprintf(stderr,"%s:transaction_count[%d]\n",func,host->transaction_count);
	fprintf(stderr,"%s:hostName[%s]\n",func,host->hostName);
	fprintf(stderr,"%s:resolvedName[%s]\n",func,host->resolvedName);
}

void
show_replicate_server_info(ReplicateServerInfo * rep)
{
	char * func ="show_replicate_server_info()";
	if (rep == NULL)
		return;
	fprintf(stderr,"%s:useFlag[%d]\n",func,rep->useFlag);
	fprintf(stderr,"%s:portNumber[%d]\n",func,rep->portNumber);
	fprintf(stderr,"%s:recoveryPortNumber[%d]\n",func,rep->recoveryPortNumber);
	fprintf(stderr,"%s:lifecheckPortNumber[%d]\n",func,rep->lifecheckPortNumber);
	fprintf(stderr,"%s:RLogPortNumber[%d]\n",func,rep->RLogPortNumber);
	fprintf(stderr,"%s:retry_count[%d]\n",func,rep->retry_count);
	fprintf(stderr,"%s:response_mode[%d]\n",func,rep->response_mode);
	fprintf(stderr,"%s:sock[%d]\n",func,rep->sock);
	fprintf(stderr,"%s:replicate_id[%d]\n",func,rep->replicate_id);
	fprintf(stderr,"%s:hostName[%s]\n",func,rep->hostName);
}

void
show_pglb_info(Pglb_Info * pglb)
{
	char * func ="show_pglb_info()";
	fprintf(stderr,"%s:physicalServerId[%d]\n",func, pglb->physicalServerId);
	fprintf(stderr,"%s:status[%d]\n",func, pglb->status);
	fprintf(stderr,"%s:receiveStatus[%d]\n",func, pglb->receiveStatus);
	fprintf(stderr,"%s:serverNo[%d]\n",func, pglb->serverNo);
	fprintf(stderr,"%s:receivePortNumber[%d]\n",func, pglb->receivePortNumber);
	fprintf(stderr,"%s:recoveryPortNumber[%d]\n",func, pglb->recoveryPortNumber);
	fprintf(stderr,"%s:maxClusterNum[%d]\n",func, pglb->maxClusterNum);
	fprintf(stderr,"%s:logRotate[%d]\n",func, pglb->logRotate);
	fprintf(stderr,"%s:hostName[%s]\n",func, pglb->hostName);
	fprintf(stderr,"%s:backendSocketDir[%s]\n",func, pglb->backendSocketDir);
	fprintf(stderr,"%s:usePool[%s]\n",func, pglb->usePool);
	fprintf(stderr,"%s:lifecheckTimeout[%s]\n",func, pglb->lifecheckTimeout);
	fprintf(stderr,"%s:lifecheckInterval[%s]\n",func, pglb->lifecheckInterval);
	fprintf(stderr,"%s:connectionLifetime[%s]\n",func, pglb->connectionLifetime);
	fprintf(stderr,"%s:logFileName[%s]\n",func, pglb->logFileName);
	fprintf(stderr,"%s:logFileSize[%s]\n",func, pglb->logFileSize);
	fprintf(stderr,"%s:workPath[%s]\n",func, pglb->workPath);
	fprintf(stderr,"%s:binPath[%s]\n",func, pglb->binPath);
}
