#!/bin/sh

# Generates configure.in, Makefile.in and config.h.in from configure.ac.
# Makefile.am files and configure.ac must exist: they can be created with
# autofind.sh script.

################################
## Script options - Beginning ##
################################

# Additional directory to look for m4 files
ADDITIONAL_M4_DIR="./" # "/usr/local/share/aclocal"

# Directories to explore (depth = 1 & no '/' otherwise it will not work)
DIRECTORIES=( "." "lib" "src" "test" )

##########################
## Script options - End ##
##########################

echo "This script generates configure.in, Makefile.in and config.h.in."
echo "Usage: $0"

for dir in ${DIRECTORIES[@]}
do
	echo ""
	cd $dir
	echo "Entering $dir"

	if test -d "$ADDITIONAL_M4_DIR" # Test whether the optional m4 directory exists
	then
		echo -n "aclocal -I $ADDITIONAL_M4_DIR... "
		aclocal -I "$ADDITIONAL_M4_DIR"
	else
		echo -n "aclocal... "
		aclocal
	fi
	echo "done"
	
	echo -n "autoheader... "
	autoheader
	echo "done"
	
	echo -n "automake -a -c... "
	automake -a -c
	echo "done"
	
	echo -n "autoconf... "
	autoconf
	echo "done"
	
	if test "$dir" != "." -a "$dir" != "./"
	then
		cd ..
	fi
	
	echo "Leaving $dir"
	
done
