//////////////////////////////////////////////////////////////////////////
//
// pgScript - PostgreSQL Tools
// RCS-ID:      $Id: pgsGenReal.h,v 1.1 2008/06/27 18:19:17 pgunittest Exp $
// Copyright (C) 2008 The pgScript Development Team
// This software is released under the Artistic Licence
//
//////////////////////////////////////////////////////////////////////////


#ifndef PGSGENREAL_H_
#define PGSGENREAL_H_

#include "pgscript/pgScript.h"
#include "pgscript/expressions/pgsExpression.h"

class pgsGenReal : public pgsExpression
{

private:

	const pgsExpression * m_min;
	const pgsExpression * m_max;
	const pgsExpression * m_precision;
	const pgsExpression * m_sequence;
	const pgsExpression * m_seed;

public:

	pgsGenReal(const pgsExpression * min, const pgsExpression * max,
			const pgsExpression * precision,
			const pgsExpression * sequence, const pgsExpression * seed);

	virtual ~pgsGenReal();

	virtual pgsExpression * clone() const;

	pgsGenReal(const pgsGenReal & that);

	pgsGenReal & operator =(const pgsGenReal & that);

public:

	virtual wxString value() const;

	virtual pgsOperand eval(pgsVarMap & vars) const;

};

#endif /*PGSGENREAL_H_*/
