//////////////////////////////////////////////////////////////////////////
//
// pgScript - PostgreSQL Tools
// RCS-ID:      $Id: pgsLogStmt.cpp,v 1.1 2008/06/27 18:19:17 pgunittest Exp $
// Copyright (C) 2008 The pgScript Development Team
// This software is released under the Artistic Licence
//
//////////////////////////////////////////////////////////////////////////


#include "pgAdmin3.h"
#include "pgscript/statements/pgsLogStmt.h"

#include "pgscript/utilities/pgsUtilities.h"

pgsLogStmt::pgsLogStmt(const pgsExpression * var, pgsOutputStream & cout,
		pgsThread * app) :
	pgsStmt(app), m_var(var), m_cout(cout)
{

}

pgsLogStmt::~pgsLogStmt()
{
	pdelete(m_var);
}

void pgsLogStmt::eval(pgsVarMap & vars) const
{
	m_cout << wxT("[") << line() << wxT(".") << column() << wxT("] ") << wxT("log(")
			<< wx_static_cast(const wxString, m_var->value()) << wxT("): ");
	pgsOperand result = m_var->eval(vars);
	if (result->is_record())
	{
		m_cout << wxT("\n");
	}
	m_cout << wx_static_cast(const wxString, result->value()) << wxT("\n") << wxT("\n");
}
