/***************************************************************************
 *  Copyright (C) 2009 Nippon Telegraph and Telephone Corporation
 ***************************************************************************/
/**
 * @file    stats_info.h
 * @brief   definition about mainly stored-procedure for getting snapshot
 *
 */

#ifndef STATS_INFO_H
#define STATS_INFO_H

/**
 * @def     SP_NAME_GET_STATS
 * @brief   name of stored-procedure
 */
#define SP_NAME_GET_STATS  "get_stats"

/**
 * @def     DEFAULT_SNAPSHOT_LEVEL
 * @brief   default level of snapshot getting 
 *
 *   Now we use only 0.
 */
#define DEFAULT_SNAPSHOT_LEVEL 0

/**
 * @def     MAX_INT_STRING_LEN
 * @brief   string length of integer-max
 */
#define MAX_INT_STRING_LEN 16

/**
 * @def     DEC_KEY
 * @brief   key-string for password enc/dec
 */
#define DEC_KEY "kcapStatsgp"

/**
 * @def     EXPNDSZ
 * @brief   size unit of area extention
 */
#define EXPNDSZ 1

/**
 * @struct  DBConnInfo
 * @brief   connection information
 */
typedef struct dbConnInfo
{
    long  int db_id;
    char *dbname;      /* target db name */
    char *hostname;
    int   port;
    char *username;
    char *dec_pwd;     /* password（dec）*/
    char *enc_pwd;     /* password（enc）*/
} DBConnInfo;

/**
 * @struct  TargetHostInfo
 * @brief   target host information
 */
typedef struct targetHostInfo
{
    long int  host_id;
    int  db_num;          /* number of DBs in the host */
    DBConnInfo *db_list;  /* list of conn-info to DBs in the host */
} TargetHostInfo;

/**
 * @struct  TargetInfo
 * @brief   target whole info
 */
typedef struct targetInfo
{
    int  host_num;              /* number of hosts */
    TargetHostInfo *host_list;
} TargetInfo;

/**
 * @struct  SnapshotParameters
 * @brief   Parameters for snapshot
 */
typedef struct snapshotParameters
{
    char *description;
    short int  level;
} SnapshotParameters;

/*
 * External declarations
 */
extern Datum get_stats_no_args(PG_FUNCTION_ARGS);
extern Datum get_stats_by_dbid(PG_FUNCTION_ARGS);
extern Datum get_stats_with_description(PG_FUNCTION_ARGS);
extern Datum get_stats_by_dbid_with_description(PG_FUNCTION_ARGS);
extern Datum get_key(PG_FUNCTION_ARGS);


#endif   /* STATS_INFO_H */

