/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.postgresql.pljava.ObjectPool;
import org.postgresql.pljava.SavepointListener;
import org.postgresql.pljava.TransactionListener;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.ELogHandler;
import org.postgresql.pljava.internal.ObjectPoolImpl;
import org.postgresql.pljava.internal.SubXactListener;
import org.postgresql.pljava.internal.TransactionalMap;
import org.postgresql.pljava.internal.XactListener;
import org.postgresql.pljava.jdbc.SQLUtils;

public class Session
implements org.postgresql.pljava.Session {
    private final TransactionalMap m_attributes = new TransactionalMap((Map)new HashMap());

    @Override
    public void addTransactionListener(TransactionListener transactionListener) {
        XactListener.addListener(transactionListener);
    }

    @Override
    public void addSavepointListener(SavepointListener savepointListener) {
        SubXactListener.addListener(savepointListener);
    }

    @Override
    public Object getAttribute(String string) {
        return this.m_attributes.get(string);
    }

    @Override
    public ObjectPool getObjectPool(Class clazz) {
        return ObjectPoolImpl.getObjectPool(clazz);
    }

    @Override
    public String getUserName() {
        return AclId.getUser().getName();
    }

    @Override
    public String getSessionUserName() {
        return AclId.getSessionUser().getName();
    }

    @Override
    public void removeAttribute(String string) {
        this.m_attributes.remove(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.m_attributes.put(string, object);
    }

    @Override
    public void removeTransactionListener(TransactionListener transactionListener) {
        XactListener.removeListener(transactionListener);
    }

    @Override
    public void removeSavepointListener(SavepointListener savepointListener) {
        SubXactListener.removeListener(savepointListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAsSessionUser(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            ResultSet resultSet = null;
            AclId aclId = AclId.getSessionUser();
            AclId aclId2 = AclId.getUser();
            try {
                Session._setUser(aclId);
                if (statement.execute(string)) {
                    resultSet = statement.getResultSet();
                    resultSet.next();
                }
            }
            finally {
                SQLUtils.close(resultSet);
                SQLUtils.close(statement);
                Session._setUser(aclId2);
            }
        }
    }

    static long init() throws SQLException {
        ELogHandler.init();
        return System.identityHashCode(Thread.currentThread());
    }

    private static native void _setUser(AclId var0);
}

