/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.logging.Logger;

public class ComplexScalar
implements SQLData {
    private static Logger s_logger = Logger.getAnonymousLogger();
    private double m_x;
    private double m_y;
    private String m_typeName;

    public static ComplexScalar parse(String string, String string2) throws SQLException {
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            if (streamTokenizer.nextToken() == 40 && streamTokenizer.nextToken() == -2) {
                double d = streamTokenizer.nval;
                if (streamTokenizer.nextToken() == 44 && streamTokenizer.nextToken() == -2) {
                    double d2 = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() == 41) {
                        s_logger.info(string2 + " from string");
                        return new ComplexScalar(d, d2, string2);
                    }
                }
            }
            throw new SQLException("Unable to parse complex from string \"" + string + '\"');
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public ComplexScalar() {
    }

    public ComplexScalar(double d, double d2, String string) {
        this.m_x = d;
        this.m_y = d2;
        this.m_typeName = string;
    }

    @Override
    public String getSQLTypeName() {
        return this.m_typeName;
    }

    @Override
    public void readSQL(SQLInput sQLInput, String string) throws SQLException {
        s_logger.info(string + " from SQLInput");
        this.m_x = sQLInput.readDouble();
        this.m_y = sQLInput.readDouble();
        this.m_typeName = string;
    }

    @Override
    public void writeSQL(SQLOutput sQLOutput) throws SQLException {
        s_logger.info(this.m_typeName + " to SQLOutput");
        sQLOutput.writeDouble(this.m_x);
        sQLOutput.writeDouble(this.m_y);
    }

    public String toString() {
        s_logger.info(this.m_typeName + " toString");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.m_x);
        stringBuffer.append(',');
        stringBuffer.append(this.m_y);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static ComplexScalar logAndReturn(ComplexScalar complexScalar) {
        s_logger.info(complexScalar.getSQLTypeName() + complexScalar);
        return complexScalar;
    }
}

