/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.logging.Logger;

public class ComplexTuple
implements SQLData {
    private static Logger s_logger = Logger.getAnonymousLogger();
    private double m_x;
    private double m_y;
    private String m_typeName;

    @Override
    public String getSQLTypeName() {
        return this.m_typeName;
    }

    @Override
    public void readSQL(SQLInput sQLInput, String string) throws SQLException {
        this.m_typeName = string;
        this.m_x = sQLInput.readDouble();
        this.m_y = sQLInput.readDouble();
        s_logger.info(string + " from SQLInput");
    }

    @Override
    public void writeSQL(SQLOutput sQLOutput) throws SQLException {
        sQLOutput.writeDouble(this.m_x);
        sQLOutput.writeDouble(this.m_y);
        s_logger.info(this.m_typeName + " to SQLOutput");
    }

    public static ComplexTuple logAndReturn(ComplexTuple complexTuple) {
        s_logger.info(complexTuple.getSQLTypeName() + "(" + complexTuple.m_x + ", " + complexTuple.m_y + ")");
        return complexTuple;
    }
}

