/* $Id: query.h,v 1.9 2005/12/14 06:37:20 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/query.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/query.h,v 1.4 2004/10/17 07:18:02 flaw
 *//*
 * Postgres Query Interface
 */
#ifndef PyPg_query_H
#define PyPg_query_H 0
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPgQuery {
	PyObject_HEAD
	PyObj q_source;
	PyObj q_input;
	PyObj q_output;
	Node *q_rpt;

	MemoryContext q_context;      /* The permanent context */
	MemoryContext q_exec_context; /* The execution context */

	List *q_queryl;
	List *q_planl;

	Oid q_lastoid;
} * PyPgQuery;

extern PyTypeObject PyPgQuery_Type;
PyObj PyPgQuery_Initialize(PyObj, PyObj);

ParamListInfo ParamListInfo_FromTupleDescAndHeapTuple(TupleDesc, HeapTuple);
PyObj PyList_FromTupleDescAndTuplestore(TupleDesc, Tuplestorestate *);

#define PyPgQuery_NEW() ((PyObj) PyPgQuery_Type.tp_alloc(&PyPgQuery_Type, 0))
#define PyPgQuery_New(STR) PyPgQuery_Initialize(PyPgQuery_NEW(), STR)

#define PyPgQuery(SELF) ((PyPgQuery) SELF)

#define PyPgQuery_FetchString(SELF) (PyPgQuery(SELF)->q_source)
#define PyPgQuery_FetchSource(SELF) (PyPgQuery(SELF)->q_source)
#define PyPgQuery_FetchArgTypes(SELF) (PyPgQuery(SELF)->q_input)
#define PyPgQuery_FetchInput(SELF) (PyPgQuery(SELF)->q_input)
#define PyPgQuery_FetchOutput(SELF) (PyPgQuery(SELF)->q_output)
#define PyPgQuery_FetchRawParseTree(SELF) (PyPgQuery(SELF)->q_rpt)
#define PyPgQuery_FetchMemoryContext(SELF) (PyPgQuery(SELF)->q_context)
#define PyPgQuery_FetchExecutionMemoryContext(SELF) \
	(PyPgQuery(SELF)->q_exec_context)
#define PyPgQuery_FetchQueryList(SELF) (PyPgQuery(SELF)->q_queryl)
#define PyPgQuery_FetchPlanList(SELF) (PyPgQuery(SELF)->q_planl)
#define PyPgQuery_FetchLastOid(SELF) (PyPgQuery(SELF)->q_lastoid)

#define PyPgQuery_FixSource(SELF, STR) (PyPgQuery(SELF)->q_source = STR)
#define PyPgQuery_FixString(SELF, STR) (PyPgQuery(SELF)->q_source = STR)
#define PyPgQuery_FixArgTypes(SELF, ATS) (PyPgQuery(SELF)->q_input = ATS)
#define PyPgQuery_FixInput(SELF, TD) (PyPgQuery(SELF)->q_input = TD)
#define PyPgQuery_FixOutput(SELF, TD) (PyPgQuery(SELF)->q_output = TD)
#define PyPgQuery_FixRawParseTree(SELF, RPT) (PyPgQuery(SELF)->q_rpt = RPT)
#define PyPgQuery_FixMemoryContext(SELF, CX) (PyPgQuery(SELF)->q_context = CX)
#define PyPgQuery_FixExecutionMemoryContext(SELF, CX) \
	(PyPgQuery(SELF)->q_exec_context = CX)
#define PyPgQuery_FixQueryList(SELF, QL) (PyPgQuery(SELF)->q_queryl = QL)
#define PyPgQuery_FixPlanList(SELF, PL) (PyPgQuery(SELF)->q_planl = PL)
#define PyPgQuery_FixLastOid(SELF, LO) (PyPgQuery(SELF)->q_lastoid = LO)

#define PyPgQuery_FetchSTRING(SELF) \
	PyString_AS_STRING(PyPgQuery_FetchString(SELF))

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_query_H */
/*
 * vim: ts=3:sw=3:noet:
 */
