/* $Id: timewise.h,v 1.1 2005/10/21 21:54:55 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Interfaces to Postgres time types
 */
#ifndef PyPg_type_timewise_H
#define PyPg_type_timewise_H 0
#ifdef __cplusplus
extern "C" {
#endif

IF_PGTYPE_ABSTIME(extern PyPgTypeObject PyPg_abstime_Type;)
IF_PGTYPE_RELTIME(extern PyPgTypeObject PyPg_reltime_Type;)
IF_PGTYPE_TINTERVAL(extern PyPgTypeObject PyPg_tinterval_Type;)
IF_PGTYPE_DATE(extern PyPgTypeObject PyPg_date_Type;)
IF_PGTYPE_TIME(extern PyPgTypeObject PyPg_time_Type;)
IF_PGTYPE_TIMETZ(extern PyPgTypeObject PyPg_timetz_Type;)
IF_PGTYPE_TIMESTAMP(extern PyPgTypeObject PyPg_timestamp_Type;)
IF_PGTYPE_TIMESTAMPTZ(extern PyPgTypeObject PyPg_timestamptz_Type;)
IF_PGTYPE_INTERVAL(extern PyPgTypeObject PyPg_interval_Type;)

#define PyPg_abstime_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_abstime_Type))
#define PyPg_abstime_CheckExact(SELF) \
	((SELF)->ob_type == &PyPg_abstime_Type)

#define PyPg_reltime_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_reltime_Type))
#define PyPg_reltime_CheckExact(SELF) \
	((SELF)->ob_type == &PyPg_reltime_Type)

#define PyPg_tinterval_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_tinterval_Type))
#define PyPg_tinterval_CheckExact(SELF) \
	((SELF)->ob_type == &PyPg_tinterval_Type)

#define PyPg_date_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_date_Type))
#define PyPg_date_CheckExact(SELF) ((SELF)->ob_type == &PyPg_date_Type)

#define PyPg_time_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_time_Type))
#define PyPg_time_CheckExact(SELF) \
	((SELF)->ob_type == &PyPg_time_Type)

#define PyPg_timetz_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_timetz_Type))
#define PyPg_timetz_CheckExact(SELF) \
	((SELF)->ob_type == &PyPg_timetz_Type)

#define PyPg_timestamp_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_timestamp_Type))
#define PyPg_timestamp_CheckExact(SELF) \
	((SELF)->ob_type == &PyPg_timestamp_Type)

#define PyPg_timestamptz_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_timestamptz_Type))
#define PyPg_timestamptz_CheckExact(SELF) \
	((SELF)->ob_type == &PyPg_timestamptz_Type)

#define PyPg_interval_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_interval_Type))
#define PyPg_interval_CheckExact(SELF) \
	((SELF)->ob_type == &PyPg_interval_Type)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_type_timewise_H */
/*
 * vim: ts=3:sw=3:noet:
 */
