/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.codehaus.plexus.components.io.functions.PlexusIoResourceConsumer;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoArchivedResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.Stream;

public abstract class AbstractPlexusIoArchiveResourceCollection
extends AbstractPlexusIoResourceCollection
implements PlexusIoArchivedResourceCollection {
    private File file;

    protected AbstractPlexusIoArchiveResourceCollection() {
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    protected abstract Iterator<PlexusIoResource> getEntries() throws IOException;

    @Override
    public Iterator<PlexusIoResource> getResources() throws IOException {
        return new FilteringIterator();
    }

    @Override
    public Stream stream() {
        return new Stream(){

            @Override
            public void forEach(PlexusIoResourceConsumer resourceConsumer) throws IOException {
                Iterator<PlexusIoResource> it = AbstractPlexusIoArchiveResourceCollection.this.getEntries();
                while (it.hasNext()) {
                    PlexusIoResource res = it.next();
                    if (!AbstractPlexusIoArchiveResourceCollection.this.isSelected(res)) continue;
                    resourceConsumer.accept(res);
                }
                if (it instanceof Closeable) {
                    ((Closeable)((Object)it)).close();
                }
            }
        };
    }

    @Override
    public long getLastModified() throws IOException {
        File f = this.getFile();
        return f == null ? 0L : f.lastModified();
    }

    class FilteringIterator
    implements Iterator<PlexusIoResource>,
    Closeable {
        final Iterator<PlexusIoResource> it;
        PlexusIoResource next;

        public FilteringIterator() throws IOException {
            this.it = AbstractPlexusIoArchiveResourceCollection.this.getEntries();
        }

        boolean doNext() {
            while (this.it.hasNext()) {
                PlexusIoResource candidate = this.it.next();
                try {
                    if (!AbstractPlexusIoArchiveResourceCollection.this.isSelected(candidate)) continue;
                    this.next = candidate;
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.doNext();
        }

        @Override
        public PlexusIoResource next() {
            if (this.next == null) {
                this.doNext();
            }
            PlexusIoResource res = this.next;
            this.next = null;
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            if (this.it instanceof Closeable) {
                ((Closeable)((Object)this.it)).close();
            }
        }
    }
}

