/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.TVMCIAccessor;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;

public abstract class TVMCI {
    private static volatile Object fallbackEngineData;

    protected TVMCI() {
        assert (this.checkCaller());
    }

    private boolean checkCaller() {
        String packageName = this.getClass().getPackage().getName();
        assert (packageName.equals("org.graalvm.compiler.truffle.runtime") || packageName.equals("org.graalvm.graal.truffle") || packageName.equals("com.oracle.graal.truffle") || packageName.equals("com.oracle.truffle.api.impl")) : TVMCI.class.getName() + " subclass is not in trusted package: " + this.getClass().getName();
        return true;
    }

    protected abstract void onLoopCount(Node var1, int var2);

    protected void onLoad(RootNode rootNode) {
        Accessor.InstrumentSupport support = TVMCIAccessor.instrumentAccess();
        if (support != null) {
            support.onLoad(rootNode);
        }
    }

    protected void setCallTarget(RootNode root, RootCallTarget callTarget) {
        TVMCIAccessor.nodesAccess().setCallTarget(root, callTarget);
    }

    protected void onFirstExecution(RootNode rootNode) {
        Accessor.InstrumentSupport accessor = TVMCIAccessor.instrumentAccess();
        if (accessor != null) {
            accessor.onFirstExecution(rootNode);
        }
    }

    protected void markFrameMaterializeCalled(FrameDescriptor descriptor) {
        TVMCIAccessor.framesAccess().markMaterializeCalled(descriptor);
    }

    protected boolean getFrameMaterializeCalled(FrameDescriptor descriptor) {
        return TVMCIAccessor.framesAccess().getMaterializeCalled(descriptor);
    }

    protected boolean isCloneUninitializedSupported(RootNode root) {
        return TVMCIAccessor.nodesAccess().isCloneUninitializedSupported(root);
    }

    protected void onThrowable(Node callNode, RootCallTarget root, Throwable e, Frame frame) {
        Accessor.LanguageSupport language = TVMCIAccessor.languageAccess();
        if (language != null) {
            language.onThrowable(callNode, root, e, frame);
        }
    }

    protected RootNode cloneUninitialized(RootNode root) {
        return TVMCIAccessor.nodesAccess().cloneUninitialized(root);
    }

    protected int adoptChildrenAndCount(RootNode root) {
        return TVMCIAccessor.nodesAccess().adoptChildrenAndCount(root);
    }

    protected OptionDescriptors getCompilerOptionDescriptors() {
        return OptionDescriptors.EMPTY;
    }

    protected boolean isGuestCallStackFrame(StackTraceElement e) {
        return false;
    }

    protected void initializeProfile(CallTarget target, Class<?>[] argumentTypes) {
    }

    protected static <T> T getOrCreateRuntimeData(RootNode rootNode, BiFunction<OptionValues, Supplier<TruffleLogger>, T> constructor) {
        Objects.requireNonNull(constructor);
        Accessor.NodeSupport nodesAccess = TVMCIAccessor.nodesAccess();
        Accessor.EngineSupport engineAccess = TVMCIAccessor.engineAccess();
        Object polyglotEngine = rootNode == null ? engineAccess.getCurrentPolyglotEngine() : nodesAccess.getPolyglotEngine(rootNode);
        if (polyglotEngine != null) {
            return engineAccess.getOrCreateRuntimeData(polyglotEngine, constructor);
        }
        if (fallbackEngineData == null) {
            fallbackEngineData = engineAccess.getOrCreateRuntimeData(null, constructor);
        }
        return (T)fallbackEngineData;
    }

    protected static void resetFallbackEngineData() {
        fallbackEngineData = null;
    }

    protected void reportPolymorphicSpecialize(Node node) {
    }

    protected ThreadLocal<Object> createFastThreadLocal() {
        return new ThreadLocal<Object>();
    }

    protected IndirectCallNode createUncachedIndirectCall() {
        return null;
    }

    protected Accessor.CallInlined getCallInlined() {
        return null;
    }

    protected Accessor.CallProfiled getCallProfiled() {
        return null;
    }

    protected Accessor.CastUnsafe getCastUnsafe() {
        return null;
    }

    protected abstract <T extends Node> BlockNode<T> createBlockNode(T[] var1, BlockNode.ElementExecutor<T> var2);

    protected void reloadEngineOptions(Object runtimeData, OptionValues optionValues) {
    }

    protected void onEngineClosed(Object runtimeData) {
    }

    protected void applyPolyglotEngine(RootNode from, RootNode to) {
        TVMCIAccessor.nodesAccess().applyPolyglotEngine(from, to);
    }

    protected OutputStream getConfiguredLogStream() {
        return null;
    }

    public static class TestAccessor<C extends Closeable, T extends CallTarget> {
        private final Test<C, T> testTvmci;

        protected TestAccessor(Test<C, T> testTvmci) {
            if (!this.getClass().getPackage().getName().equals("com.oracle.truffle.tck")) {
                throw new IllegalStateException();
            }
            this.testTvmci = testTvmci;
        }

        protected final C createTestContext(String testName) {
            return this.testTvmci.createTestContext(testName);
        }

        protected final T createTestCallTarget(C testContext, RootNode testNode) {
            return this.testTvmci.createTestCallTarget(testContext, testNode);
        }

        protected final void finishWarmup(C testContext, T callTarget) {
            this.testTvmci.finishWarmup(testContext, callTarget);
        }
    }

    public static abstract class Test<C extends Closeable, T extends CallTarget> {
        protected abstract C createTestContext(String var1);

        protected abstract T createTestCallTarget(C var1, RootNode var2);

        protected abstract void finishWarmup(C var1, T var2);
    }
}

