/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.TargetMappingNode;
import com.oracle.truffle.polyglot.ToHostNode;
import java.lang.reflect.Type;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ToHostNode.class)
final class ToHostNodeGen
extends ToHostNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private Cached0Data cached0_cache;
    @Node.Child
    private Cached1Data cached1_cache;
    @Node.Child
    private TargetMappingNode generic_targetMapping_;
    @Node.Child
    private InteropLibrary generic_interop_;

    private ToHostNodeGen() {
    }

    @Override
    @ExplodeLoop
    public Object execute(Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                Cached0Data s1_ = this.cached0_cache;
                while (s1_ != null) {
                    if (s1_.interop_.accepts(arg0Value) && arg1Value == s1_.cachedTargetType_) {
                        return this.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.interop_, s1_.cachedTargetType_, s1_.primitiveTarget_, s1_.allowsImplementation_, s1_.targetMapping_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                Cached1Data s2_ = this.cached1_cache;
                while (s2_ != null) {
                    if (arg1Value == s2_.cachedTargetType_) {
                        return this.cached1Boundary(state, s2_, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0) {
                return ToHostNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.generic_targetMapping_, this.generic_interop_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object cached1Boundary(int state, Cached1Data s2_, Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
        try {
            Object object = this.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, INTEROP_LIBRARY_.getUncached(arg0Value), s2_.cachedTargetType_, s2_.primitiveTarget_, s2_.allowsImplementation_, s2_.targetMapping_);
            return object;
        }
        finally {
            NodeUtil.popEncapsulatingNode(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if ((exclude & 1) == 0) {
                int count1_ = 0;
                Cached0Data s1_ = this.cached0_cache;
                if ((state & 1) != 0) {
                    while (!(s1_ == null || s1_.interop_.accepts(arg0Value) && arg1Value == s1_.cachedTargetType_)) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < 5) {
                    s1_ = super.insert(new Cached0Data(this.cached0_cache));
                    s1_.interop_ = s1_.insertAccessor(INTEROP_LIBRARY_.create(arg0Value));
                    s1_.cachedTargetType_ = arg1Value;
                    s1_.primitiveTarget_ = ToHostNode.isPrimitiveTarget(s1_.cachedTargetType_);
                    s1_.allowsImplementation_ = ToHostNode.allowsImplementation(arg3Value, arg1Value);
                    s1_.targetMapping_ = s1_.insertAccessor(TargetMappingNode.create());
                    this.cached0_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.interop_, s1_.cachedTargetType_, s1_.primitiveTarget_, s1_.allowsImplementation_, s1_.targetMapping_);
                    return object;
                }
            }
            if ((exclude & 2) == 0) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    int count2_ = 0;
                    Cached1Data s2_ = this.cached1_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null && arg1Value != s2_.cachedTargetType_) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && count2_ < 5) {
                        s2_ = super.insert(new Cached1Data(this.cached1_cache));
                        s2_.cachedTargetType_ = arg1Value;
                        s2_.primitiveTarget_ = ToHostNode.isPrimitiveTarget(s2_.cachedTargetType_);
                        s2_.allowsImplementation_ = ToHostNode.allowsImplementation(arg3Value, arg1Value);
                        s2_.targetMapping_ = s2_.insertAccessor(TargetMappingNode.create());
                        this.cached1_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        this.cached0_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, INTEROP_LIBRARY_.getUncached(arg0Value), s2_.cachedTargetType_, s2_.primitiveTarget_, s2_.allowsImplementation_, s2_.targetMapping_);
                        return object;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }
            this.generic_targetMapping_ = super.insert(TargetMappingNode.getUncached());
            this.generic_interop_ = super.insert(INTEROP_LIBRARY_.createDispatched(0));
            this.exclude_ = exclude |= 3;
            this.cached0_cache = null;
            this.cached1_cache = null;
            state &= 0xFFFFFFFC;
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            Object object = ToHostNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.generic_targetMapping_, this.generic_interop_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            Cached0Data s1_ = this.cached0_cache;
            Cached1Data s2_ = this.cached1_cache;
            if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToHostNode create() {
        return new ToHostNodeGen();
    }

    public static ToHostNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=ToHostNode.class)
    private static final class Uncached
    extends ToHostNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
            return ToHostNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, TargetMappingNode.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=ToHostNode.class)
    private static final class Cached1Data
    extends Node {
        @Node.Child
        Cached1Data next_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedTargetType_;
        @CompilerDirectives.CompilationFinal
        boolean primitiveTarget_;
        @CompilerDirectives.CompilationFinal
        boolean allowsImplementation_;
        @Node.Child
        TargetMappingNode targetMapping_;

        Cached1Data(Cached1Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }

    @GeneratedBy(value=ToHostNode.class)
    private static final class Cached0Data
    extends Node {
        @Node.Child
        Cached0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedTargetType_;
        @CompilerDirectives.CompilationFinal
        boolean primitiveTarget_;
        @CompilerDirectives.CompilationFinal
        boolean allowsImplementation_;
        @Node.Child
        TargetMappingNode targetMapping_;

        Cached0Data(Cached0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

