/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.RemoteRepository;

public final class DefaultMirrorSelector
implements MirrorSelector {
    private static final String WILDCARD = "*";
    private static final String EXTERNAL_WILDCARD = "external:*";
    private final List<MirrorDef> mirrors = new ArrayList<MirrorDef>();

    public DefaultMirrorSelector add(String id, String url, String type, boolean repositoryManager, String mirrorOfIds, String mirrorOfTypes) {
        this.mirrors.add(new MirrorDef(id, url, type, repositoryManager, mirrorOfIds, mirrorOfTypes));
        return this;
    }

    public RemoteRepository getMirror(RemoteRepository repository) {
        MirrorDef mirror = this.findMirror(repository);
        if (mirror == null) {
            return null;
        }
        RemoteRepository.Builder builder = new RemoteRepository.Builder(mirror.id, repository.getContentType(), mirror.url);
        builder.setRepositoryManager(mirror.repositoryManager);
        if (mirror.type != null && mirror.type.length() > 0) {
            builder.setContentType(mirror.type);
        }
        builder.setSnapshotPolicy(repository.getPolicy(true));
        builder.setReleasePolicy(repository.getPolicy(false));
        builder.setMirroredRepositories(Collections.singletonList(repository));
        return builder.build();
    }

    private MirrorDef findMirror(RemoteRepository repository) {
        String repoId = repository.getId();
        if (repoId != null && !this.mirrors.isEmpty()) {
            MirrorDef mirror;
            int i;
            int n = this.mirrors.size();
            for (i = 0; i < n; ++i) {
                mirror = this.mirrors.get(i);
                if (!repoId.equals(mirror.mirrorOfIds) || !DefaultMirrorSelector.matchesType(repository.getContentType(), mirror.mirrorOfTypes)) continue;
                return mirror;
            }
            n = this.mirrors.size();
            for (i = 0; i < n; ++i) {
                mirror = this.mirrors.get(i);
                if (!DefaultMirrorSelector.matchPattern(repository, mirror.mirrorOfIds) || !DefaultMirrorSelector.matchesType(repository.getContentType(), mirror.mirrorOfTypes)) continue;
                return mirror;
            }
        }
        return null;
    }

    static boolean matchPattern(RemoteRepository repository, String pattern) {
        boolean result = false;
        String originalId = repository.getId();
        if (WILDCARD.equals(pattern) || pattern.equals(originalId)) {
            result = true;
        } else {
            String[] repos;
            for (String repo : repos = pattern.split(",")) {
                if (repo.length() > 1 && repo.startsWith("!")) {
                    if (!repo.substring(1).equals(originalId)) continue;
                    result = false;
                    break;
                }
                if (repo.equals(originalId)) {
                    result = true;
                    break;
                }
                if (EXTERNAL_WILDCARD.equals(repo) && DefaultMirrorSelector.isExternalRepo(repository)) {
                    result = true;
                    continue;
                }
                if (!WILDCARD.equals(repo)) continue;
                result = true;
            }
        }
        return result;
    }

    static boolean isExternalRepo(RemoteRepository repository) {
        boolean local = "localhost".equals(repository.getHost()) || "127.0.0.1".equals(repository.getHost()) || "file".equalsIgnoreCase(repository.getProtocol());
        return !local;
    }

    static boolean matchesType(String repoType, String mirrorType) {
        boolean result = false;
        if (mirrorType == null || mirrorType.length() <= 0 || WILDCARD.equals(mirrorType)) {
            result = true;
        } else if (mirrorType.equals(repoType)) {
            result = true;
        } else {
            String[] layouts;
            for (String layout : layouts = mirrorType.split(",")) {
                if (layout.length() > 1 && layout.startsWith("!")) {
                    if (!layout.substring(1).equals(repoType)) continue;
                    result = false;
                    break;
                }
                if (layout.equals(repoType)) {
                    result = true;
                    break;
                }
                if (!WILDCARD.equals(layout)) continue;
                result = true;
            }
        }
        return result;
    }

    static class MirrorDef {
        final String id;
        final String url;
        final String type;
        final boolean repositoryManager;
        final String mirrorOfIds;
        final String mirrorOfTypes;

        public MirrorDef(String id, String url, String type, boolean repositoryManager, String mirrorOfIds, String mirrorOfTypes) {
            this.id = id;
            this.url = url;
            this.type = type;
            this.repositoryManager = repositoryManager;
            this.mirrorOfIds = mirrorOfIds;
            this.mirrorOfTypes = mirrorOfTypes;
        }
    }
}

