/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testset;

import java.io.File;
import java.util.List;
import org.apache.maven.surefire.util.RunOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryScannerParameters {
    private final File testClassesDirectory;
    private final List<String> includes;
    private final List<String> excludes;
    private final List<String> specificTests;
    private final boolean failIfNoTests;
    private final RunOrder[] runOrder;

    private DirectoryScannerParameters(File testClassesDirectory, List<String> includes, List<String> excludes, List<String> specificTests, boolean failIfNoTests, RunOrder[] runOrder) {
        this.testClassesDirectory = testClassesDirectory;
        this.includes = includes;
        this.excludes = excludes;
        this.specificTests = specificTests;
        this.failIfNoTests = failIfNoTests;
        this.runOrder = runOrder;
    }

    public DirectoryScannerParameters(File testClassesDirectory, List<String> includes, List<String> excludes, List<String> specificTests, boolean failIfNoTests, String runOrder) {
        this(testClassesDirectory, includes, excludes, specificTests, failIfNoTests, runOrder == null ? RunOrder.DEFAULT : RunOrder.valueOfMulti(runOrder));
    }

    public List<String> getSpecificTests() {
        return this.specificTests;
    }

    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public boolean isFailIfNoTests() {
        return this.failIfNoTests;
    }

    public RunOrder[] getRunOrder() {
        return this.runOrder;
    }
}

